       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04872.                                         
       AUTHOR.        SS7F226.                                          
COB303 DATE-WRITTEN.  JULY 22, 2015.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS IS RETREIVE AND UPDATE PROCEDURE FOR ELIGIBILITY FLAG     *        
      * AND GUID.                                                      *        
      *                                                                *        
      * NOTE: ELIGIBILITY FLAG DESCRIBES AS BELOW,                     *        
      *                                                                *        
      * I = INELIGIBLE /NOT ELIGIBLE / NOT TARGETED FOR RETAIL BENEFIT *        
      * E = ELIGIBLE /READY FOR SIGNUP                                 *        
      * R = REGISTERED / ENROLLED                                      *        
      * N = NOT FOUND                                                  *        
      *                                                                *        
      * THIS PROCEDURE IS FOR SEB ONLY.                                *ING *   
      * I_PARM_TYPE CAN BE 'E' FOR RETREIVE AND 'U' FOR UPDATE.        *        
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           I_PARM_TYPE                CHAR(01)              --         
      *--           I_ACCOUNT_NO               CHAR(13)              --         
      *--           I_GUID                     CHAR(36)              --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--           RETURN_CODE                INTEGER               --         
      *--           ACCOUNT_NO                 CHAR(13)              --         
      *--           GUID                       CHAR(36)              --         
      *--           ELIGIBILITY_FLAG           CHAR(01)              --         
      *--                                                            --         
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *    ------    --------   -------------------------------------  *        
      *  07/22/2015  SS7F226    NEW PROGRAM                            *        
      *  11/10/2015  SM93554    ADDED ADDITIONAL ACCOUNTS              *        
      *  11/16/2015  SM93554    REMOVED ALL THE HARD CODED TEST ACCTS. *        
A05136*  11/30/2015  SM93554    COMMENTED OUT MINUS CURR DATE CHECK.   *        
      *              PRDFIX                                            *        
A05460*  05/12/2016  SM93554    RETURN ZERO WHEN RESI ACCT NOT FOUND   *        
      *              ACT161     INSTEAD OF RETURNING 100.              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04872'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04872 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        (AT)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY    (C8)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_DATA        (VO)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE (YP)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WS ABEND WORK AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  WS-MISC.                                                     
           05  WS-GTT-NAME             PIC X(19)  VALUE SPACES.         
           05  WS-SPACES               PIC X(01)  VALUE SPACES.         
           05  WS-ZERO                 PIC S9(9) COMP VALUE 0.          
           05  WS-SUB1                 PIC S9(4) COMP VALUE 0.          
           05  WS-INFINITE-TS          PIC X(26)                        
                                VALUE '2999-12-31-00.00.00.000000'.     
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
           05  WS-CURRENT-TIMESTAMP-1MIN PIC X(26)  VALUE SPACES.       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-ACCOUNT-NO-CHAR      PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM       REDEFINES WS-ACCOUNT-NO-CHAR     
                                       PIC 9(13).                       
           05  WS-GUID                 PIC X(36)  VALUE SPACES.         
           05  WS-PARM-TYPE            PIC X(01)  VALUE SPACES.         
           05  WS-ATTRIBUTE-DESC       PIC X(15)  VALUE                 
                                                  'SHOPPINGREWARDS'.    
           05  WS-ATTRIBUTE-VALUE-TX.                                   
              49 WS-ATTRIBUTE-VALUE-TX-LEN  PIC S9(4) USAGE COMP.       
              49 WS-ATTRIBUTE-VALUE-TX-TEXT PIC X(200).                 
                                                                        
       01  LITERALS.                                                    
           05  PROGRAM-NAME            PIC X(8)   VALUE 'CSR04872'.     
           05  WS-RESIDENTAIL          PIC X(01)  VALUE 'R'.            
           05  WS-10                   PIC X(03)  VALUE '010'.          
           05  WS-ONE                  PIC 9(02)  VALUE 01.             
           05  WS-I                    PIC X(01)  VALUE 'I'.            
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-ELIGIBLE             PIC X(01)  VALUE 'E'.            
           05  WS-INQUIRY              PIC X(01)  VALUE 'E'.            
           05  WS-INSERT               PIC X(01)  VALUE 'I'.            
           05  WS-UPDATE               PIC X(01)  VALUE 'U'.            
           05  WS-REGISTERED           PIC X(01)  VALUE 'R'.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS             PIC S9(9) COMP VALUE 0.          
                                                                        
      *01  WS-ACCOUNT-TBL.                                                      
      *    05 WS-ACCOUNT-NO-TBL        PIC 9(13) OCCURS 31 VALUE 0.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01)  VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW            PIC X(01)  VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-DATABASE             PIC 9(01)  VALUE ZERO.           
               88 CSR-DATABASE                    VALUE 1.              
               88 SEB-DATABASE                    VALUE 2.              
           05  WS-INPUT-ACCOUNT        PIC X(01)  VALUE 'N'.            
               88 INPUT-ACCOUNT-FOUND             VALUE 'Y'.            
               88 INPUT-ACCOUNT-NOT-FOUND         VALUE 'N'.            
           05  WS-RSDNTL-ACCT-FOUND    PIC X(01)  VALUE 'N'.            
               88 RSDNTL-ACCT-FOUND               VALUE 'Y'.            
               88 RSDNTL-ACCT-NOT-FOUND           VALUE 'N'.            
           05  WS-OFF01-FOUND          PIC X(01)  VALUE 'N'.            
               88 OFF01-FOUND                     VALUE 'Y'.            
               88 OFF01-FOUND-NOT-FOUND           VALUE 'N'.            
                                                                        
           05  WS-ACCT-ATTR-FOUND      PIC X(01)  VALUE 'N'.            
               88 ACCT-ATTR-FOUND                 VALUE 'Y'.            
               88 ACCT-ATTR-NOT-FOUND             VALUE 'N'.            
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) COMP VALUE 0.         
          05 S-ACCOUNT-NO              PIC X(13)  VALUE SPACES.         
          05 S-GUID                    PIC X(36)  VALUE SPACES.         
          05 S-ELIGIBILITY-FLAG        PIC X(01)  VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)  VALUE SPACES.         
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)   VALUE ' '.            
           10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05)  VALUE SPACES.         
                                                                        
      *                                                                         
       LINKAGE SECTION.                                                 
       01   LINK-PARM-TYPE             PIC X(01).                       
       01   LINK-ACCOUNT-NO            PIC X(13).                       
       01   LINK-GUID                  PIC X(36).                       
                                                                        
       PROCEDURE DIVISION USING LINK-PARM-TYPE                          
                                LINK-ACCOUNT-NO                         
                                LINK-GUID.                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'SESSION.CSR04872_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04872_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04872_R1
              (                                                    
                     RETURN_CODE              INT                   
                    ,ACCOUNT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,GUID CHAR(36)  COLLATE LATIN1_GENERAL_100_BIN2             
                    ,ELIGIBILITY_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                              THRU  9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
                     WITH ROWSET POSITIONING FOR                        
             SELECT  RETURN_CODE                                        
                    ,ACCOUNT_NO                                         
                    ,GUID                                               
                    ,ELIGIBILITY_FLAG                                   
               FROM #CSR04872_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01334001
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                              01340005
MFA-TR*              WITH ROWSET POSITIONING FOR                        01341003
MFA-TR*      SELECT  RETURN_CODE                                        01350003
MFA-TR*             ,ACCOUNT_NO                                         01361003
MFA-TR*             ,GUID                                               01362003
MFA-TR*             ,ELIGIBILITY_FLAG                                   01362003
MFA-TR*        FROM SESSION.CSR04872_R1                                 01366003
MFA-TR*    END-EXEC.                                                    01380001
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES                   TO LINK-ACCOUNT-NO         
           END-IF.                                                      
                                                                        
           MOVE LINK-ACCOUNT-NO              TO WS-ACCOUNT-NO-CHAR.     
           MOVE WS-ACCOUNT-NO-NUM            TO WS-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                YP-ACCOUNT-NO.          
           MOVE LINK-GUID                    TO WS-GUID.                
           MOVE LINK-PARM-TYPE               TO WS-PARM-TYPE.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      * SELECT THE DATABASE TO PROCESS OUTPUT DATA.                    *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7800-GET-CURRENT-VALUES THRU 7800-EXIT               
                                                                        
           EVALUATE WS-PARM-TYPE                                        
             WHEN WS-INQUIRY                                            
                  PERFORM 2100-INQUIRY-PROCESS THRU 2100-EXIT           
             WHEN WS-UPDATE                                             
                  PERFORM 2200-UPDATE-PROCESS  THRU 2200-EXIT           
             WHEN WS-INSERT                                             
                  PERFORM 2300-INSERT-PROCESS  THRU 2300-EXIT           
             WHEN OTHER                                                 
                  CONTINUE                                              
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2100-INQUIRY-PROCESS.                                         *         
      * PROCESS THE ACCTOUNT NO AND GUID AND GET ELIGIBLILITY DETAILS.*         
      *****************************************************************         
       2100-INQUIRY-PROCESS.                                            
      *                                                                         
           IF WS-ACCOUNT-NO GREATER THAN ZEROES                         
              PERFORM 7000-SELECT-ACCT-NO        THRU 7000-EXIT         
              IF RSDNTL-ACCT-FOUND                                      
                 PERFORM 7150-GET-OFF01-STATUS   THRU 7150-EXIT         
                 IF OFF01-FOUND                                         
                    MOVE ZEROES               TO S-RETURN-CODE          
                    MOVE WS-I                 TO S-ELIGIBILITY-FLAG     
                 ELSE                                                   
                    PERFORM 7100-ACCT-ATTR-STAT  THRU 7100-EXIT         
                    IF ACCT-ATTR-FOUND                                  
                       MOVE SPACES            TO WS-GUID                
                       MOVE YP-ATTRIBUTE-VALUE-TX-TEXT                  
                                              TO WS-GUID                
                       MOVE YP-STATUS-CD      TO S-ELIGIBILITY-FLAG     
                    ELSE                                                
                       MOVE ZEROES        TO S-RETURN-CODE              
                       MOVE WS-ELIGIBLE   TO S-ELIGIBILITY-FLAG         
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
ACT161           MOVE ZEROES                 TO S-RETURN-CODE           
                 MOVE WS-I                   TO S-ELIGIBILITY-FLAG      
              END-IF                                                    
           ELSE                                                         
              IF WS-GUID > SPACES                                       
                 MOVE LENGTH OF WS-GUID      TO                         
                                             WS-ATTRIBUTE-VALUE-TX-LEN  
                 MOVE WS-GUID                TO                         
                                             WS-ATTRIBUTE-VALUE-TX-TEXT 
                 PERFORM 7200-SELECT-ACCT-ATTR                          
                                              THRU 7200-EXIT            
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-ELIGIBLE         TO S-ELIGIBILITY-FLAG      
                 ELSE                                                   
                    MOVE 100                 TO S-RETURN-CODE           
                    MOVE WS-I                TO S-ELIGIBILITY-FLAG      
                 END-IF                                                 
              ELSE                                                      
                 MOVE 100                    TO S-RETURN-CODE           
                 MOVE WS-I                   TO S-ELIGIBILITY-FLAG      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-ACCOUNT-NO                TO S-ACCOUNT-NO.           
           MOVE WS-GUID                      TO S-GUID.                 
                                                                        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2200-UPDATE-PROCESS..                                         *         
      * UPDATE THE ACCT_ATTRIBUTE WITH INPUT TIMESTAMP AND SEND BACK. *         
      *****************************************************************         
       2200-UPDATE-PROCESS.                                             
      *                                                                         
           IF WS-GUID GREATER THAN SPACES OR                            
              WS-ACCOUNT-NO GREATER THAN ZEROES                         
                                                                        
              MOVE WS-INFINITE-TS            TO YP-CREATED-TS           
                                                                        
              IF WS-ACCOUNT-NO GREATER THAN ZEROES                      
                 PERFORM 8050-ACCT-LVL-UPT-ATTR  THRU 8050-EXIT         
              ELSE                                                      
                 MOVE WS-REGISTERED       TO YP-STATUS-CD               
                 PERFORM 8100-GUID-LVL-UPT-ATTR  THRU 8100-EXIT         
              END-IF                                                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-ELIGIBLE         TO S-ELIGIBILITY-FLAG         
              ELSE                                                      
                 MOVE WS-NO               TO S-ELIGIBILITY-FLAG         
              END-IF                                                    
              MOVE WS-ACCOUNT-NO          TO S-ACCOUNT-NO               
              MOVE WS-GUID                TO S-GUID                     
           ELSE                                                         
              MOVE 100                    TO S-RETURN-CODE              
              MOVE WS-ACCOUNT-NO          TO S-ACCOUNT-NO               
              MOVE WS-GUID                TO S-GUID                     
              MOVE WS-NO                  TO S-ELIGIBILITY-FLAG         
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *2300-INSERT-PROCESS.                                           *         
      *****************************************************************         
       2300-INSERT-PROCESS.                                             
                                                                        
           MOVE WS-ACCOUNT-NO              TO YP-ACCOUNT-NO             
           MOVE WS-ATTRIBUTE-DESC          TO YP-ATTRIBUTE-DESC         
           MOVE 'YES'                      TO YP-ATTRIBUTE-VALUE-CD     
                                                                        
           MOVE LENGTH OF WS-GUID          TO YP-ATTRIBUTE-VALUE-TX-LEN 
           MOVE WS-GUID                    TO YP-ATTRIBUTE-VALUE-TX-TEXT
           MOVE WS-ELIGIBLE                TO YP-STATUS-CD              
                                                                        
           PERFORM 8150-INSERT-ACCT-ATTR      THRU 8150-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE ZEROES                  TO S-RETURN-CODE             
              MOVE WS-ACCOUNT-NO           TO S-ACCOUNT-NO              
              MOVE WS-GUID                 TO S-GUID                    
              MOVE WS-ELIGIBLE             TO S-ELIGIBILITY-FLAG        
           END-IF.                                                      
                                                                        
PRDFIX     PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7000-SELECT-ACCT-NO.                                           *         
      *****************************************************************         
       7000-SELECT-ACCT-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-RSDNTL-ACCT-FOUND                             
                 FROM CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                    
                WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                  AND AT.ACCOUNT_TYPE_CODE = :WS-RESIDENTAIL            
                  AND AT.LOCAL_OFFICE      < :WS-10                     
                  AND AT.CODE_ACCT_STAT = 'A'                           
                  AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,29,1) = 
                                                             :WS-SPACES   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RSDNTL-ACCT-FOUND                                     
MFA-TR*          FROM CSS_ACCOUNT   AT                                          
MFA-TR*         WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           AND AT.ACCOUNT_TYPE_CODE = :WS-RESIDENTAIL                    
MFA-TR*           AND AT.LOCAL_OFFICE      < :WS-10                             
MFA-TR*           AND AT.CODE_ACCT_STAT = 'A'                                   
MFA-TR*           AND SUBSTR(AT.CODES_DATA_PRESENT,29,1) = :WS-SPACES           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7100-ACCT-ATTR-STAT.                                           *         
      *****************************************************************         
       7100-ACCT-ATTR-STAT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT YP.ATTRIBUTE_VALUE_TX                             
                     ,YP.STATUS_CD                                      
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), YP.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                 INTO :YP-ATTRIBUTE-VALUE-TX                            
                     ,:YP-STATUS-CD                                     
                     ,:YP-CREATED-TS                                    
                 FROM CSS_ACCT_ATTRIBUTE  YP WITH(READUNCOMMITTED)              
                WHERE YP.ACCOUNT_NO       = :AT-ACCOUNT-NO              
                  AND YP.ATTRIBUTE_DESC   = :WS-ATTRIBUTE-DESC          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT YP.ATTRIBUTE_VALUE_TX                                     
MFA-TR*              ,YP.STATUS_CD                                              
MFA-TR*              ,YP.CREATED_TS                                             
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-TX                                    
MFA-TR*              ,:YP-STATUS-CD                                             
MFA-TR*              ,:YP-CREATED-TS                                            
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE  YP                                    
MFA-TR*         WHERE YP.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*           AND YP.ATTRIBUTE_DESC   = :WS-ATTRIBUTE-DESC                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-YES                    TO WS-ACCT-ATTR-FOUND      
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7100'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_ACCT_ATTRIBUTE'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7150-GET-OFF01-STATUS.                                         *         
      *****************************************************************         
       7150-GET-OFF01-STATUS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-OFF01-FOUND                                   
                 FROM CSS_SO_DATA   VO WITH(READUNCOMMITTED)                    
                WHERE VO.ORDER_TYPE_CD    = 'OFF01'                     
                  AND VO.ORDER_STATE_CD NOT IN ('C','Z')                
                  AND VO.ACCOUNT_NO       = :AT-ACCOUNT-NO              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-OFF01-FOUND                                           
MFA-TR*          FROM CSS_SO_DATA   VO                                          
MFA-TR*         WHERE VO.ORDER_TYPE_CD    = 'OFF01'                             
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN ('C','Z')                        
MFA-TR*           AND VO.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7200-SELECT-ACCT-ATTR.                                         *         
      *****************************************************************         
       7200-SELECT-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) YP.STATUS_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), YP.CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS                                     
                 INTO :YP-STATUS-CD                                     
                     ,:YP-CREATED-TS                                    
                 FROM CSS_ACCT_ATTRIBUTE  YP WITH(READUNCOMMITTED)              
                WHERE YP.ATTRIBUTE_VALUE_TX                             
                                         = :WS-ATTRIBUTE-VALUE-TX       
                  AND YP.ATTRIBUTE_DESC  = :WS-ATTRIBUTE-DESC           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT YP.STATUS_CD                                              
MFA-TR*              ,YP.CREATED_TS                                             
MFA-TR*          INTO :YP-STATUS-CD                                             
MFA-TR*              ,:YP-CREATED-TS                                            
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE  YP                                    
MFA-TR*         WHERE YP.ATTRIBUTE_VALUE_TX                                     
MFA-TR*                                  = :WS-ATTRIBUTE-VALUE-TX               
MFA-TR*           AND YP.ATTRIBUTE_DESC  = :WS-ATTRIBUTE-DESC                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7800-GET-CURRENT-VALUES.                                      *         
      *****************************************************************         
       7800-GET-CURRENT-VALUES.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP =                                     
MFA-TR*                                  CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MINUTE, -1, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP-1MIN   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP-1MIN =                                
MFA-TR*                                  CURRENT TIMESTAMP - 1 MINUTE           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************01938703
      *  DELETE SESSION TABLE - INITIAL                                *01938803
      ******************************************************************01938903
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04872_R1                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    01939203
MFA-TR*         DELETE                                                  01939303
MFA-TR*           FROM SESSION.CSR04872_R1                              01939403
MFA-TR*     END-EXEC.                                                   01939503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE SQLCODE                  TO ABEND-SQLCODE           
               MOVE SQLSTATE                 TO ABEND-SQLSTATE          
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE 'CSR04872_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************01941703
      * 8010-INSERT-GTT-R1.  METER READ HISTORY DATA                   *01941803
      ******************************************************************01941903
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04872_R1                            
             (                                                          
              RETURN_CODE                                               
             ,ACCOUNT_NO                                                
             ,GUID                                                      
             ,ELIGIBILITY_FLAG                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-ACCOUNT-NO                                             
             ,:S-GUID                                                   
             ,:S-ELIGIBILITY-FLAG                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01942203
MFA-TR*      INSERT INTO SESSION.CSR04872_R1                            01942303
MFA-TR*      (                                                          01942403
MFA-TR*       RETURN_CODE                                               01942503
MFA-TR*      ,ACCOUNT_NO                                                01942603
MFA-TR*      ,GUID                                                      01942703
MFA-TR*      ,ELIGIBILITY_FLAG                                          01942703
MFA-TR*      )                                                          01943203
MFA-TR*      VALUES                                                     01943303
MFA-TR*      (                                                          01943403
MFA-TR*       :S-RETURN-CODE                                            01943503
MFA-TR*      ,:S-ACCOUNT-NO                                             01943603
MFA-TR*      ,:S-GUID                                                   01943703
MFA-TR*      ,:S-ELIGIBILITY-FLAG                                       01943703
MFA-TR*      )                                                          01944203
MFA-TR*    END-EXEC.                                                    01944303

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO CTR-ROWS-RS             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04872_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 01945903
       8010-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03060003
      ******************************************************************01938703
      *                                                                *01938803
      *  8050-ACCT-LVL-UPT-ATTR                                        *        
      ******************************************************************01938903
       8050-ACCT-LVL-UPT-ATTR.                                          
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_ACCT_ATTRIBUTE                                
                  SET CREATED_TS         = CIS.CHAR2TIMESTAMP(
                                                         :YP-CREATED-TS
              )               
                WHERE ATTRIBUTE_VALUE_TX = :WS-GUID                     
                  AND ATTRIBUTE_DESC     = 'SHOPPINGREWARDS'            
                  AND ACCOUNT_NO         = :YP-ACCOUNT-NO               
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    01939203
MFA-TR*        UPDATE CSS_ACCT_ATTRIBUTE                                        
MFA-TR*           SET CREATED_TS         = :YP-CREATED-TS                       
MFA-TR*         WHERE ATTRIBUTE_VALUE_TX = :WS-GUID                             
MFA-TR*           AND ATTRIBUTE_DESC     = 'SHOPPINGREWARDS'                    
MFA-TR*           AND ACCOUNT_NO         = :YP-ACCOUNT-NO                       
MFA-TR*        QUERYNO 8050                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************01938703
      *                                                                *01938803
      *  8100-GUID-LVL-UPT-ATTR.                                       *        
      ******************************************************************01938903
       8100-GUID-LVL-UPT-ATTR.                                          
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_ACCT_ATTRIBUTE                                
                  SET CREATED_TS         = CIS.CHAR2TIMESTAMP(
                                                         :YP-CREATED-TS
              )               
                     ,STATUS_CD          = :YP-STATUS-CD                
                WHERE ATTRIBUTE_VALUE_TX = :WS-GUID                     
                  AND ATTRIBUTE_DESC     = 'SHOPPINGREWARDS'            
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    01939203
MFA-TR*        UPDATE CSS_ACCT_ATTRIBUTE                                        
MFA-TR*           SET CREATED_TS         = :YP-CREATED-TS                       
MFA-TR*              ,STATUS_CD          = :YP-STATUS-CD                        
MFA-TR*         WHERE ATTRIBUTE_VALUE_TX = :WS-GUID                             
MFA-TR*           AND ATTRIBUTE_DESC     = 'SHOPPINGREWARDS'                    
MFA-TR*        QUERYNO 8100                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8150-INSERT-ACCT-ATTR.                                        *         
      *****************************************************************         
       8150-INSERT-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                        ( ACCOUNT_NO                                    
                         ,ATTRIBUTE_DESC                                
                         ,ATTRIBUTE_VALUE_CD                            
                         ,ATTRIBUTE_VALUE_DT                            
                         ,ATTRIBUTE_VALUE_TX                            
                         ,CREATED_TS                                    
                         ,STATUS_CD                                     
                        )                                               
              VALUES                                                    
                        ( :YP-ACCOUNT-NO                                
                         ,:YP-ATTRIBUTE-DESC                            
                         ,:YP-ATTRIBUTE-VALUE-CD                        
                         , CAST(SYSDATETIMEOFFSET() AS DATE)                    
                         ,:YP-ATTRIBUTE-VALUE-TX                        
                         , CIS.CURRENT$TIMESTAMP()                            
                         ,:YP-STATUS-CD                                 
                        )                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*                 ( ACCOUNT_NO                                            
MFA-TR*                  ,ATTRIBUTE_DESC                                        
MFA-TR*                  ,ATTRIBUTE_VALUE_CD                                    
MFA-TR*                  ,ATTRIBUTE_VALUE_DT                                    
MFA-TR*                  ,ATTRIBUTE_VALUE_TX                                    
MFA-TR*                  ,CREATED_TS                                            
MFA-TR*                  ,STATUS_CD                                             
MFA-TR*                 )                                                       
MFA-TR*       VALUES                                                            
MFA-TR*                 ( :YP-ACCOUNT-NO                                        
MFA-TR*                  ,:YP-ATTRIBUTE-DESC                                    
MFA-TR*                  ,:YP-ATTRIBUTE-VALUE-CD                                
MFA-TR*                  , CURRENT DATE                                         
MFA-TR*                  ,:YP-ATTRIBUTE-VALUE-TX                                
MFA-TR*                  , CURRENT TIMESTAMP                                    
MFA-TR*                  ,:YP-STATUS-CD                                         
MFA-TR*                 )                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO CTR-ROWS-RS             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8150'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO  TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
              MOVE YP-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ***************************************************************** 03070003
      * 8800-CHECK-RESULTS.                                           * 03080003
      ***************************************************************** 03090003
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS <= 0                                          
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                       TO S-RETURN-CODE           
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
           END-IF.                                                      
      *                                                                 03180003
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03210003
      ***************************************************************** 03220003
      * 8900-SEND-DONE.                                               * 03230003
      ***************************************************************** 03240003
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                 TO ABEND-PROGRAM           
           MOVE '8900'                       TO ACTIVE-PARAGRAPH        
           MOVE 'OPEN'                       TO ABEND-FUNCTION          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04872_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE.          
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03325003
      * 9999-END-PROGRAM.                                             * 03330003
      ***************************************************************** 03340003
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT.           
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT.           
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
