       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04871.                                      
       AUTHOR.           HA7A338.                                       
COB303 DATE-WRITTEN.     JUN 26,2015.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                    SOUTH CAROLINA ELECTRIC & GAS               *        
      ******************************************************************        
      *                     STORED PROCEDURE:  CSR04871                *        
      ******************************************************************        
      *                           S U M M A R Y                        *        
      *    CSR04871 :                                                  *        
      *                                                                *        
      *    # INSERT ENTRY IN CSS_OFF_CYCL_ACCT TABLE WHEN USER RELEASE *        
      *      UNBILLED ROW FROM BILL HISTORY SCREEN.                    *        
      ******************************************************************        
      *    PARAMETERS DETAIL                                           *        
      *                                                                *        
      *        INPUT                                                   *        
      *              I_ACCOUNT_NO          DECIMAL(13)                 *        
      *              I_BILL_NO             SMALLINT                    *        
      *              I_CODE_UTIL_TYPE      CHAR(01)                    *        
      *              I_IC_NO               SMALLINT                    *        
      *              I_BILL_ITEM_TIMESTAMP CHAR(26)                    *        
      *              I_LAST_UPDATE_TS      CHAR(26)                    *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *              RETURN_CODE           INTEGER                     *        
      *              BUS_RULE_ID           CHAR(10)                    *        
      *              BUS_RULE_RESULT_CD    CHAR(08)                    *        
      *              BUS_RULE_XREF_ID      CHAR(26)                    *        
      *                                                                *        
      ******************************************************************        
      *                    MODIFICATION LOG                            *        
      *                                                                *        
      *    DATE          INITIALS    COMMENTS                          *        
      *    -----------   --------    ----------------------------------*        
P00899*    06-26-2015    HA7A338     INITIAL VERSION                   *        
P00899*    09-22-2015    HA7A338     PROD FIX AR CNTL INSERT FAIL -180 *        
      *                                                                *        
      ******************************************************************        
      *               ---- BASIC SEQUENCE STRUCTURE ----               *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04871'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                      PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04871 STARTS HERE'.                  
                                                                        
       01 WS-WORKING-STORAGE.                                           
           05 WS-SQLSTATE                PIC X(05) VALUE SPACES.        
           05 WS-UTIL-TYPE               PIC X(01) VALUE SPACES.        
           05 WS-IC-NO                   PIC S9(4) VALUE 0 COMP.        
           05 WS-USER-ID                 PIC X(07) VALUE SPACES.        
           05 WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.        
           05 WS-CURRENT-DATE            PIC X(10) VALUE SPACES.        
           05 WS-CURRENT-TS              PIC X(26) VALUE SPACES.        
           05 WS-AT-LAST-UPDATE-TS       PIC X(26) VALUE SPACES.        
           05 WS-JULIAN-DATE             PIC S9(7) COMP-3 VALUE 0.      
           05 WS-CREDIT-LETTER-IND       PIC X(01) VALUE SPACES.        
                                                                        
       01 WS-FORMATTED-DATE-BREAKOUT.                                   
           10 WS-FORMAT-CC               PIC 9(02).                     
           10 WS-FORMAT-YY               PIC 9(02).                     
           10 FILLER                     PIC X(01) VALUE '-'.           
           10 WS-FORMAT-MM               PIC 9(02).                     
           10 FILLER                     PIC X(01) VALUE '-'.           
           10 WS-FORMAT-DD               PIC 9(02).                     
       01 WS-FORMATTED-DATE REDEFINES WS-FORMATTED-DATE-BREAKOUT        
                                         PIC X(10).                     
                                                                        
       01 WS-SWITCHES.                                                  
           05 ALL-DONE-SW                PIC X(01) VALUE 'N'.           
              88 NOT-ALL-DONE                VALUE 'N'.                 
              88 ALL-DONE                    VALUE 'Y'.                 
           05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR             VALUE 'N'.                 
              88 SEND-DONE-OK                VALUE 'Y'.                 
           05 WS-CNCL-REBIL-RLSD-IND     PIC X(01) VALUE 'N'.           
              88 CNCL-REBIL-RLSD             VALUE 'Y'.                 
           05 WS-OFF-CYCLE-ACCT-IND      PIC X(01) VALUE 'N'.           
              88 OFF-CYCLE-ACCT              VALUE 'Y'.                 
           05 WS-ACCT-HAS-AR-IND         PIC X(01) VALUE 'N'.           
              88 ACCT-HAS-AR                 VALUE 'Y'.                 
              88 ACCT-HAS-NO-AR              VALUE 'N'.                 
                                                                        
       01 COUNTER-FIELDS.                                               
           05 CTR-ROWS                   PIC S9(9) COMP VALUE 0.        
                                                                        
       01 WS-LITERALS.                                                  
           05 GTT-NAME                   PIC X(26) VALUE                
                                              'SESSION.CSR04871_R1'.    
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04871'.    
           05 MCSCA182                   PIC X(08) VALUE 'MCSCA182'.    
           05 WS-19                      PIC 9(02) VALUE 19.            
           05 WS-20                      PIC 9(02) VALUE 20.            
           05 WS-PASS                    PIC X(01) VALUE 'P'.           
           05 WS-FAIL                    PIC X(01) VALUE 'F'.           
           05 WS-HOLD                    PIC X(01) VALUE 'H'.           
           05 WS-YES                     PIC X(01) VALUE 'Y'.           
           05 WS-FINAL-BILL              PIC X(01) VALUE 'B'.           
           05 WS-REBILL-ASAP             PIC X(01) VALUE 'A'.           
           05 WS-NRML-BILL-RLSD          PIC X(01) VALUE ' '.           
           05 WS-CNCL-REBIL-RLSD         PIC X(01) VALUE 'O'.           
           05 WS-FINAL-BILL-RLSD         PIC X(01) VALUE 'B'.           
           05 WS-REBILL-HOOK             PIC X(01) VALUE 'C'.           
           05 WS-INSERTED                PIC X(10) VALUE '**INSERT**'.  
           05 WS-COMMENT                 PIC X(29) VALUE                
                                    'ACCOUNT RELEASED FOR BILLING.'.    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-BUS-RULE-ID             PIC X(10)  VALUE SPACE.        
           05  S-BUS-RULE-RESULT-CD      PIC X(08)  VALUE SPACE.        
           05  S-BUS-RULE-XREF-ID        PIC X(26)  VALUE SPACE.        
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO MCSCA182.                                     *        
      ******************************************************************        
           COPY CWS00182.                                                       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS TO JULIAN DATE CALCULATION                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00021                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_USER_PROFILE,PF                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01540000
      * CSS_ACCOUNT        AT                                         * 01550000
      ***************************************************************** 01560000
           EXEC SQL                                                     01570000
              INCLUDE TBACCT                                            01580000
           END-EXEC.                                                    01590000
                                                                        
      *****************************************************************         
      * CSS_AR_CNTL        AC                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_BILLING_HDR    BI                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_OFF_CYCL_ACCT  OC                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_BILL_WINDOW    BN                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_BUS_RULE_ACTN, 1S                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_BUS_RULE,      1R                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_SO_DATA,       VO                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_SO_FINAL_BILL, XD                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBSOFIN                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_CUST_PLAN,     CP                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01  PARM-BILL-NO                   PIC S9(4) COMP.               
       01  PARM-UTIL-TYPE                 PIC X(01).                    
       01  PARM-IC-NO                     PIC S9(4) COMP.               
       01  PARM-BILL-ITEM-TIMESTAMP       PIC X(26).                    
       01  PARM-LAST-UPDATE-TS            PIC X(26).                    
       01  PARM-USER-ID                   PIC X(07).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-BILL-NO                           
                                 PARM-UTIL-TYPE                         
                                 PARM-IC-NO                             
                                 PARM-BILL-ITEM-TIMESTAMP               
                                 PARM-LAST-UPDATE-TS                    
                                 PARM-USER-ID.                          
                                                                        
      *****************************************************************         
      * 0000-MAINLINE.                                                *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0100-INITIALIZE.                                              *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT.          
           PERFORM 7005-GET-EIB-DATE           THRU 7005-EXIT.          
           PERFORM 7010-GET-RESP-AREA-ID       THRU 7010-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0100A-DECLARE-GTT.                                            *         
      *****************************************************************         
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04871_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04871_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BUS_RULE_ID                                      
                      ,BUS_RULE_RESULT_CD                               
                      ,BUS_RULE_XREF_ID                                 
                  FROM #CSR04871_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BUS_RULE_ID                                              
MFA-TR*               ,BUS_RULE_RESULT_CD                                       
MFA-TR*               ,BUS_RULE_XREF_ID                                         
MFA-TR*           FROM SESSION.CSR04871_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                            *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE SCSCA182-LINK-RECORD.                             
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO            
                                               AC-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               BI-ACCOUNT-NO            
                                               OC-ACCOUNT-NO            
                                               VO-ACCOUNT-NO            
                                               MH-ACCOUNT-NO            
                                               SCSCA182-ACCOUNT-NO.     
           MOVE PARM-LAST-UPDATE-TS         TO WS-AT-LAST-UPDATE-TS.    
           MOVE PARM-UTIL-TYPE              TO CP-CODE-UTIL-TYPE        
                                               WS-UTIL-TYPE.            
           MOVE PARM-IC-NO                  TO CP-IC-NO                 
                                               WS-IC-NO.                
           MOVE PARM-USER-ID                TO WS-USER-ID.              
           MOVE WS-CURRENT-DATE             TO BN-DATE-EXTRACT          
                                               MH-DATE-TRANS.           
           MOVE WS-CURRENT-TS               TO AT-LAST-UPDATE-TS        
                                               MH-TRANS-HIST-SEQ-NO.    
           MOVE SPACES                      TO OC-CREDIT-LETTER-IND     
                                               XD-CREDIT-LETTER-IND.    
       1000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                          *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-RELEASE-FOR-BLNG       THRU 2100-EXIT.          
           PERFORM 2600-INSERT-TRANS-HIST      THRU 2600-EXIT.          
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
      *****************************************************************         
      * 2100-RELEASE-FOR-BLNG.                                        *         
      *****************************************************************         
       2100-RELEASE-FOR-BLNG.                                           
                                                                        
           PERFORM 2200-VLDT-LAST-UPDT-TS      THRU 2200-EXIT.          
           PERFORM 2300-PROCESS-ACCOUNT        THRU 2300-EXIT.          
           PERFORM 2400-UPDATE-ACCOUNT         THRU 2400-EXIT.          
           PERFORM 2500-PROCESS-AR-CNTL        THRU 2500-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2200-VLDT-LAST-UPDT-TS.                                       *         
      *****************************************************************         
       2200-VLDT-LAST-UPDT-TS.                                          
                                                                        
           PERFORM 6000-CALL-MCSCA182          THRU 6000-EXIT.          
           IF SCSCA182-LAST-UPDATE-TS = WS-AT-LAST-UPDATE-TS            
              CONTINUE                                                  
           ELSE                                                         
              MOVE  'BCNSMPT037'            TO S-BUS-RULE-ID            
              MOVE WS-PASS                  TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2300-PROCESS-ACCOUNT.                                         *         
      *****************************************************************         
       2300-PROCESS-ACCOUNT.                                            
                                                                        
           PERFORM 7030-GET-ACCOUNT-DTLS       THRU 7030-EXIT.          
           MOVE AT-CUSTOMER-NO              TO OC-CUSTOMER-NO.          
           MOVE AT-BILL-CYCLE               TO BN-BILL-CYCLE.           
           IF AT-CODE-ACCT-BILLED = WS-HOLD                             
              MOVE SPACES                   TO AT-CODE-ACCT-BILLED      
           END-IF.                                                      
                                                                        
           PERFORM 6620-JULIAN2DATE          THRU 6620-JULIAN2DATE-EXIT.
           MOVE WS-MONTH                    TO WS-FORMAT-MM.            
           MOVE WS-DATEHOLD-DAY             TO WS-FORMAT-DD.            
           MOVE WS-YEAR                     TO WS-FORMAT-YY.            
           IF WS-FORMAT-YY > 50                                         
               MOVE WS-19                   TO WS-FORMAT-CC             
             ELSE                                                       
               MOVE WS-20                   TO WS-FORMAT-CC             
           END-IF.                                                      
           MOVE WS-FORMATTED-DATE           TO AT-DATE-LAST-ACTION.     
                                                                        
           IF AT-CODE-ACCT-STAT = WS-FINAL-BILL                         
              PERFORM 7040-GET-CRED-LETTER-IND THRU 7040-EXIT           
              MOVE XD-CREDIT-LETTER-IND     TO OC-CREDIT-LETTER-IND     
           END-IF.                                                      
                                                                        
      *NEED TO CHECK WITH NC & REMOVE IF THIS IS NOT REQUIRED.          02911000
           PERFORM 7050-CHECK-OFF-CYCLE        THRU 7050-EXIT.          
           IF CNCL-REBIL-RLSD                                           
              MOVE WS-REBILL-ASAP           TO AT-CODE-BILL-PEND        
           ELSE                                                         
              MOVE SPACE                    TO AT-CODE-BILL-PEND        
           END-IF.                                                      
      ***********************************************************       02911000
                                                                        
           PERFORM 7060-SELECT-BILL-DATE       THRU 7060-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE  'BCNSMPT038'            TO S-BUS-RULE-ID            
              MOVE WS-PASS                  TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7070-CHECK-REBILL-HOOK      THRU 7070-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-REBILL-ASAP           TO AT-CODE-BILL-PEND        
              MOVE WS-CNCL-REBIL-RLSD       TO OC-CODE-BILL-OFF-CYCL    
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = WS-FINAL-BILL                      
                 MOVE WS-FINAL-BILL-RLSD    TO OC-CODE-BILL-OFF-CYCL    
              ELSE                                                      
                 MOVE WS-NRML-BILL-RLSD     TO OC-CODE-BILL-OFF-CYCL    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7080-GET-OFF-CYCLE-ACCT     THRU 7080-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2400-UPDATE-ACCOUNT.                                          *         
      *****************************************************************         
       2400-UPDATE-ACCOUNT.                                             
                                                                        
           PERFORM 8010-DLT-FORCE-ESTIMATE     THRU 8010-EXIT.          
                                                                        
           IF OFF-CYCLE-ACCT                                            
              PERFORM 8200-UPDT-OFF-CYCL-ACCT  THRU 8200-EXIT           
           ELSE                                                         
              PERFORM 8150-INSRT-OFF-CYCL-ACCT THRU 8150-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 8210-UPDT-ACCOUNT           THRU 8210-EXIT.          
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2500-PROCESS-AR-CNTL.                                         *         
      *****************************************************************         
       2500-PROCESS-AR-CNTL.                                            
                                                                        
           PERFORM 7090-CHECK-AR-CNTL          THRU 7090-EXIT.          
           IF ACCT-HAS-NO-AR                                            
              PERFORM 7100-SELECT-CUST-PLAN    THRU 7100-EXIT           
              INITIALIZE DCLCSS-AR-CNTL                                 
                                                                        
P00899        MOVE PARM-ACCOUNT-NO          TO AC-ACCOUNT-NO            
P00899        MOVE WS-CURRENT-TS            TO AC-LAST-UPDATE-TS        
              EVALUATE TRUE                                             
                 WHEN WS-UTIL-TYPE = 'E'                                
                    MOVE 40                 TO AC-PYMT-PRIORITY-LVL     
                 WHEN WS-UTIL-TYPE = 'G'                                
                    MOVE 45                 TO AC-PYMT-PRIORITY-LVL     
                 WHEN WS-UTIL-TYPE = 'U'                                
                    IF CP-CODE-SERVICE-TYPE = 'E'                       
                       MOVE 40              TO AC-PYMT-PRIORITY-LVL     
                    ELSE                                                
                       MOVE 45              TO AC-PYMT-PRIORITY-LVL     
                    END-IF                                              
              END-EVALUATE                                              
                                                                        
              PERFORM 8160-INSRT-AR-CNTL-ROW   THRU 8160-EXIT           
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2600-INSERT-TRANS-HIST.                                       *         
      *****************************************************************         
       2600-INSERT-TRANS-HIST.                                          
                                                                        
           PERFORM 5000-WRITE-TRNS-HIST        THRU 5000-EXIT.          
           PERFORM 5010-WRITE-TRNS-HIST-DTL    THRU 5010-EXIT.          
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 5000-WRITE-TRNS-HIST.                                         *         
      *****************************************************************         
       5000-WRITE-TRNS-HIST.                                            
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE 0                           TO MH-CUSTOMER-NO           
                                               MH-PREMISE-NO.           
           MOVE WS-USER-ID                  TO MH-USER-ID.              
           MOVE PROGRAM-NAME                TO MH-APPL-PROGRAM-ID.      
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT.    
           MOVE LENGTH OF WS-COMMENT        TO MH-TRAN-COMMENT-LEN.     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE 1                           TO MI-TRAN-APPL-NO.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 5010-WRITE-TRNS-HIST-DTL.                                     *         
      *****************************************************************         
       5010-WRITE-TRNS-HIST-DTL.                                        
                                                                        
      *    WRITE A TRANSACTION HISTORY DETAIL ROW                               
           IF OFF-CYCLE-ACCT                                            
              MOVE +01                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CREDIT-LETTER-IND     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE OC-CREDIT-LETTER-IND     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'CRDT LETTER IND'        TO MI-COLUMN-DESC           
           ELSE                                                         
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +01                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-INSERTED              TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE OC-CODE-BILL-OFF-CYCL    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'OFF CYCL CODE'          TO MI-COLUMN-DESC           
           END-IF.                                                      
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD +1                           TO MI-TRAN-APPL-NO.         
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 6000-CALL-MCSCA182.                                           *         
      *****************************************************************         
       6000-CALL-MCSCA182.                                              
                                                                        
           MOVE '6000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                                ,SCSCA182-RETURN-CODE                   
                                ,SCSCA182-LAST-UPDATE-TS                
                                ,ABEND-FILE.                            
                                                                        
           IF SCSCA182-RETURN-CODE = SUCCESSFUL-CALL                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SCSCA182-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * 6620-JULIAN2DATE.                                             *         
      *****************************************************************         
           COPY CPD00011.                                                       
      ****************************************************************          
      * 7000-GET-CURRENT-DATE.                                       *          
      ****************************************************************          
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TS,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS        = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-1          
              MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7005-GET-EIB-DATE.                                           *          
      * EIBDATE - CYYDDD (CENTURY-YEAR-NO OF DAYS TILL DATE)         *          
      ****************************************************************          
       7005-GET-EIB-DATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
               CIS.CHAR2DECIMAL('01' + LTRIM(RTRIM(CIS.SUBSTR2$(
           CIS.INT2CHAR(YEAR(CAST(SYSDATETIMEOFFSET() AS DATE))),3)
           )) + CASE WHEN                                               
                DATALENGTH(LTRIM(RTRIM(CIS.INT2CHAR(DATEPART(DAYOFYEAR, 
           CAST(SYSDATETIMEOFFSET() AS DATE))))))=1 THEN '00'
                     WHEN                                               
                DATALENGTH(LTRIM(RTRIM(CIS.INT2CHAR(DATEPART(DAYOFYEAR, 
           CAST(SYSDATETIMEOFFSET() AS DATE))))))=2 THEN '0' 
                     ELSE ''                                            
                END + LTRIM(RTRIM(CIS.INT2CHAR(DATEPART(DAYOFYEAR, 
           CAST(SYSDATETIMEOFFSET() AS DATE))))))                
                INTO :WS-JULIAN-DATE                                    
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*        DECIMAL('01'||STRIP(SUBSTR(CHAR(YEAR(CURRENT_DATE)),3))||        
MFA-TR*         CASE WHEN                                                       
MFA-TR*         LENGTH(STRIP(CHAR(DAYOFYEAR(CURRENT_DATE))))=1 THEN '00'        
MFA-TR*              WHEN                                                       
MFA-TR*         LENGTH(STRIP(CHAR(DAYOFYEAR(CURRENT_DATE))))=2 THEN '0'         
MFA-TR*              ELSE ''                                                    
MFA-TR*         END                                                             
MFA-TR*         || STRIP(CHAR(DAYOFYEAR(CURRENT_DATE))))                        
MFA-TR*         INTO :WS-JULIAN-DATE                                            
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-JULIAN-DATE           TO WS-COMP-JULEDATE         
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'EIB DATE'               TO TABLE-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7010-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7010-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE USER_ID = :PARM-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE USER_ID = :PARM-USER-ID                                   
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE WS-USER-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7020-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7020-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                  
                 INTO :S-BUS-RULE-XREF-ID                               
                 FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)              
                     ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)              
                WHERE [1R].BUS_RULE_ID    = :S-BUS-RULE-ID                
                  AND [1R].BUS_RULE_ID    = [1T].BUS_RULE_ID                
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BUS_RULE_XREF_ID                                          
MFA-TR*          INTO :S-BUS-RULE-XREF-ID                                       
MFA-TR*          FROM CSS_BUS_RULE      1R                                      
MFA-TR*              ,CSS_BUS_RULE_XREF 1T                                      
MFA-TR*         WHERE 1R.BUS_RULE_ID    = :S-BUS-RULE-ID                        
MFA-TR*           AND 1R.BUS_RULE_ID    = 1T.BUS_RULE_ID                        
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BUS_RULE'           TO TABLE-1                  
              MOVE 'BUS_RULE_ID'            TO TABLE-ELEMENT-1          
              MOVE S-BUS-RULE-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7030-GET-ACCOUNT-DTLS.                                       *          
      ****************************************************************          
       7030-GET-ACCOUNT-DTLS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AT.BILL_CYCLE                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CODE_BILL_PEND                                  
                    ,AT.CODE_ACCT_BILLED                                
                INTO :AT-BILL-CYCLE                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CODE-BILL-PEND                                 
                    ,:AT-CODE-ACCT-BILLED                               
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.BILL_CYCLE                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CODE_BILL_PEND                                          
MFA-TR*             ,AT.CODE_ACCT_BILLED                                        
MFA-TR*         INTO :AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CODE-BILL-PEND                                         
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*        WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7040-GET-CRED-LETTER-IND.                                    *          
      ****************************************************************          
       7040-GET-CRED-LETTER-IND.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XD.CREDIT_LETTER_IND                              
                INTO  :XD-CREDIT-LETTER-IND                             
                FROM  CSS_SO_FINAL_BILL XD WITH(READUNCOMMITTED)                
                     ,CSS_SO_DATA       VO WITH(READUNCOMMITTED)                
               WHERE  XD.SERV_ORDER_NO              = VO.SERV_ORDER_NO  
                 AND  (CIS.SUBSTR3(VO.ORDER_TYPE_CD,1,3) = 'OFF' OR          
                       CIS.SUBSTR3(VO.ORDER_TYPE_CD,1,2) = 'CC')             
                 AND  VO.ORDER_STATE_CD             = 'Z'               
                 AND  VO.ACCOUNT_NO_PRIOR           = :OC-ACCOUNT-NO    
               ORDER BY COMPLETED_DATETIME DESC                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  XD.CREDIT_LETTER_IND                                      
MFA-TR*         INTO  :XD-CREDIT-LETTER-IND                                     
MFA-TR*         FROM  CSS_SO_FINAL_BILL XD                                      
MFA-TR*              ,CSS_SO_DATA       VO                                      
MFA-TR*        WHERE  XD.SERV_ORDER_NO              = VO.SERV_ORDER_NO          
MFA-TR*          AND  (SUBSTR(VO.ORDER_TYPE_CD,1,3) = 'OFF' OR                  
MFA-TR*                SUBSTR(VO.ORDER_TYPE_CD,1,2) = 'CC')                     
MFA-TR*          AND  VO.ORDER_STATE_CD             = 'Z'                       
MFA-TR*          AND  VO.ACCOUNT_NO_PRIOR           = :OC-ACCOUNT-NO            
MFA-TR*        ORDER BY COMPLETED_DATETIME DESC                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DATA'            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO_PRIOR'       TO TABLE-ELEMENT-1          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7050-CHECK-OFF-CYCLE.                                        *          
      ****************************************************************          
       7050-CHECK-OFF-CYCLE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CNCL-REBIL-RLSD-IND                            
                FROM CSS_OFF_CYCL_ACCT OC WITH(READUNCOMMITTED)                 
               WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                
                 AND CODE_BILL_OFF_CYCL = :WS-CNCL-REBIL-RLSD           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CNCL-REBIL-RLSD-IND                                    
MFA-TR*         FROM CSS_OFF_CYCL_ACCT OC                                       
MFA-TR*        WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                        
MFA-TR*          AND CODE_BILL_OFF_CYCL = :WS-CNCL-REBIL-RLSD                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_OFF_CYCL_ACCT'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7060-SELECT-BILL-DATE.                                       *          
      ****************************************************************          
       7060-SELECT-BILL-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DATE_EXTRACT                                       
                INTO :BN-DATE-EXTRACT                                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE BILL_CYCLE   = :BN-BILL-CYCLE                      
                 AND DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_EXTRACT                                               
MFA-TR*         INTO :BN-DATE-EXTRACT                                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE   = :BN-BILL-CYCLE                              
MFA-TR*          AND DATE_EXTRACT = :BN-DATE-EXTRACT                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7070-CHECK-REBILL-HOOK.                                      *          
      ****************************************************************          
       7070-CHECK-REBILL-HOOK.                                          
                                                                        
           EXEC SQL                                                     
              SELECT CODE_BILL_STATUS                                   
                INTO :BI-CODE-BILL-STATUS                               
                FROM CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                  
                 AND CODE_BILL_STATUS = :WS-REBILL-HOOK                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_BILL_STATUS                                           
MFA-TR*         INTO :BI-CODE-BILL-STATUS                                       
MFA-TR*         FROM CSS_BILLING_HDR  BI                                        
MFA-TR*        WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                          
MFA-TR*          AND CODE_BILL_STATUS = :WS-REBILL-HOOK                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_HDR'        TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE BI-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7080-GET-OFF-CYCLE-ACCT.                                     *          
      ****************************************************************          
       7080-GET-OFF-CYCLE-ACCT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              OC.CREDIT_LETTER_IND                              
                INTO  :WS-OFF-CYCLE-ACCT-IND                            
                     ,:WS-CREDIT-LETTER-IND                             
                FROM  CSS_OFF_CYCL_ACCT     OC WITH(READUNCOMMITTED)            
               WHERE  OC.ACCOUNT_NO         =  :OC-ACCOUNT-NO           
                 AND  OC.CODE_BILL_OFF_CYCL =  :OC-CODE-BILL-OFF-CYCL   
                 AND  OC.CUSTOMER_NO        =  :OC-CUSTOMER-NO          
                 AND  OC.CREDIT_LETTER_IND  <> :WS-YES                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*              ,OC.CREDIT_LETTER_IND                                      
MFA-TR*         INTO  :WS-OFF-CYCLE-ACCT-IND                                    
MFA-TR*              ,:WS-CREDIT-LETTER-IND                                     
MFA-TR*         FROM  CSS_OFF_CYCL_ACCT     OC                                  
MFA-TR*        WHERE  OC.ACCOUNT_NO         =  :OC-ACCOUNT-NO                   
MFA-TR*          AND  OC.CODE_BILL_OFF_CYCL =  :OC-CODE-BILL-OFF-CYCL           
MFA-TR*          AND  OC.CUSTOMER_NO        =  :OC-CUSTOMER-NO                  
MFA-TR*          AND  OC.CREDIT_LETTER_IND  <> :WS-YES                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7080'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_OFF_CYCL_ACCT'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7090-CHECK-AR-CNTL.                                          *          
      ****************************************************************          
       7090-CHECK-AR-CNTL.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ACCT-HAS-AR-IND                                
                FROM CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO   = :AC-ACCOUNT-NO                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ACCT-HAS-AR-IND                                        
MFA-TR*         FROM CSS_AR_CNTL  AC                                            
MFA-TR*        WHERE ACCOUNT_NO   = :AC-ACCOUNT-NO                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7090'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_CNTL'            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7100-SELECT-CUST-PLAN.                                       *          
      ****************************************************************          
       7100-SELECT-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT CODE_SERVICE_TYPE                         
                INTO :CP-CODE-SERVICE-TYPE                              
                FROM CSS_CUST_PLAN     CP WITH(READUNCOMMITTED)                 
               WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                
                 AND IC_NO          = :CP-IC-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT CODE_SERVICE_TYPE                                 
MFA-TR*         INTO :CP-CODE-SERVICE-TYPE                                      
MFA-TR*         FROM CSS_CUST_PLAN     CP                                       
MFA-TR*        WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :CP-IC-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_PLAN'          TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 8000A-DEL-GTT-ROWS.                                          *          
      ****************************************************************          
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04871_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04871_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME                                   
                                            TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04871_R1'                                  
                                            TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
      ****************************************************************          
      * 8010-DLT-FORCE-ESTIMATE.                                     *          
      ****************************************************************          
       8010-DLT-FORCE-ESTIMATE.                                         
                                                                        
           EXEC SQL                                                     
             DELETE FROM OC                            
             FROM CSS_OFF_CYCL_ACCT OC
                   WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO            
                     AND CODE_BILL_OFF_CYCL = :WS-HOLD                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_OFF_CYCL_ACCT OC                                   
MFA-TR*            WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                    
MFA-TR*              AND CODE_BILL_OFF_CYCL = :WS-HOLD                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_OFF_CYCL_ACCT'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8100-SEND-RESULT.                                             *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04871_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04871_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04871_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 8150-INSRT-OFF-CYCL-ACCT.                                    *          
      ****************************************************************          
       8150-INSRT-OFF-CYCL-ACCT.                                        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_OFF_CYCL_ACCT                              
                        (ACCOUNT_NO                                     
                        ,CODE_BILL_OFF_CYCL                             
                        ,CUSTOMER_NO                                    
                        ,CREDIT_LETTER_IND)                             
                  VALUES                                                
                        (:OC-ACCOUNT-NO                                 
                        ,:OC-CODE-BILL-OFF-CYCL                         
                        ,:OC-CUSTOMER-NO                                
                        ,:OC-CREDIT-LETTER-IND)                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_OFF_CYCL_ACCT'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_BILL_OFF_CYCL'     TO TABLE-ELEMENT-2          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE OC-CODE-BILL-OFF-CYCL    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 8160-INSRT-AR-CNTL-ROW.                                      *          
      ****************************************************************          
       8160-INSRT-AR-CNTL-ROW.                                          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_AR_CNTL                                    
                        (ACCOUNT_NO                                     
                        ,PYMT_PRIORITY_LVL                              
                        ,ITEM_ID                                        
                        ,AMT_AR_DAY_00                                  
                        ,AMT_AR_DAY_30                                  
                        ,AMT_AR_DAY_60                                  
                        ,AMT_AR_DAY_90                                  
                        ,AMT_UNUSED_CR                                  
                        ,AMT_TRAN_BALANCE                               
                        ,TOT_SUMM_UNBILLED                              
                        ,LAST_UPDATE_TS)                                
                  VALUES                                                
                        (:AC-ACCOUNT-NO                                 
                        ,:AC-PYMT-PRIORITY-LVL                          
                        ,:AC-ITEM-ID                                    
                        ,:AC-AMT-AR-DAY-00                              
                        ,:AC-AMT-AR-DAY-30                              
                        ,:AC-AMT-AR-DAY-60                              
                        ,:AC-AMT-AR-DAY-90                              
                        ,:AC-AMT-UNUSED-CR                              
                        ,:AC-AMT-TRAN-BALANCE                           
                        ,:AC-TOT-SUMM-UNBILLED                          
                        ,CIS.CHAR2TIMESTAMP(:AC-LAST-UPDATE-TS))                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_AR_CNTL                                            
MFA-TR*                 (ACCOUNT_NO                                             
MFA-TR*                 ,PYMT_PRIORITY_LVL                                      
MFA-TR*                 ,ITEM_ID                                                
MFA-TR*                 ,AMT_AR_DAY_00                                          
MFA-TR*                 ,AMT_AR_DAY_30                                          
MFA-TR*                 ,AMT_AR_DAY_60                                          
MFA-TR*                 ,AMT_AR_DAY_90                                          
MFA-TR*                 ,AMT_UNUSED_CR                                          
MFA-TR*                 ,AMT_TRAN_BALANCE                                       
MFA-TR*                 ,TOT_SUMM_UNBILLED                                      
MFA-TR*                 ,LAST_UPDATE_TS)                                        
MFA-TR*           VALUES                                                        
MFA-TR*                 (:AC-ACCOUNT-NO                                         
MFA-TR*                 ,:AC-PYMT-PRIORITY-LVL                                  
MFA-TR*                 ,:AC-ITEM-ID                                            
MFA-TR*                 ,:AC-AMT-AR-DAY-00                                      
MFA-TR*                 ,:AC-AMT-AR-DAY-30                                      
MFA-TR*                 ,:AC-AMT-AR-DAY-60                                      
MFA-TR*                 ,:AC-AMT-AR-DAY-90                                      
MFA-TR*                 ,:AC-AMT-UNUSED-CR                                      
MFA-TR*                 ,:AC-AMT-TRAN-BALANCE                                   
MFA-TR*                 ,:AC-TOT-SUMM-UNBILLED                                  
MFA-TR*                 ,:AC-LAST-UPDATE-TS)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8160'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_CNTL'            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 8200-UPDT-OFF-CYCL-ACCT.                                     *          
      ****************************************************************          
       8200-UPDT-OFF-CYCL-ACCT.                                         
                                                                        
           EXEC SQL                                                     
             UPDATE OC                                 
                SET OC.CREDIT_LETTER_IND  = :OC-CREDIT-LETTER-IND       
             FROM CSS_OFF_CYCL_ACCT OC
              WHERE OC.ACCOUNT_NO         = :OC-ACCOUNT-NO              
                AND OC.CODE_BILL_OFF_CYCL = :OC-CODE-BILL-OFF-CYCL      
                AND OC.CUSTOMER_NO        = :OC-CUSTOMER-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_OFF_CYCL_ACCT     OC                                    
MFA-TR*         SET OC.CREDIT_LETTER_IND  = :OC-CREDIT-LETTER-IND               
MFA-TR*       WHERE OC.ACCOUNT_NO         = :OC-ACCOUNT-NO                      
MFA-TR*         AND OC.CODE_BILL_OFF_CYCL = :OC-CODE-BILL-OFF-CYCL              
MFA-TR*         AND OC.CUSTOMER_NO        = :OC-CUSTOMER-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_OFF_CYCL_ACCT'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_BILL_OFF_CYCL'     TO TABLE-ELEMENT-2          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE OC-CODE-BILL-OFF-CYCL    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 8210-UPDT-ACCOUNT.                                           *          
      ****************************************************************          
       8210-UPDT-ACCOUNT.                                               
                                                                        
           EXEC SQL                                                     
             UPDATE  AT                                      
                SET  CODE_ACCT_BILLED   = :AT-CODE-ACCT-BILLED          
                    ,DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) )          
                    ,CODE_BILL_PEND     = :AT-CODE-BILL-PEND            
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )            
             FROM CSS_ACCOUNT AT
              WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_ACCOUNT        AT                                      
MFA-TR*         SET  CODE_ACCT_BILLED   = :AT-CODE-ACCT-BILLED                  
MFA-TR*             ,DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION                  
MFA-TR*             ,CODE_BILL_PEND     = :AT-CODE-BILL-PEND                    
MFA-TR*             ,LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                    
MFA-TR*       WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                    *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * END PROGRAM COPYLIB                                           *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
