       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04870.                                      
       AUTHOR.           HA7A338.                                       
COB303 DATE-WRITTEN.     JUL 17, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                    SOUTH CAROLINA ELECTRIC & GAS               *        
      ******************************************************************        
      *                     STORED PROCEDURE:  CSR04870                *        
      ******************************************************************        
      *                           S U M M A R Y                        *        
      *    CSR04870 :                                                  *        
      *                                                                *        
      *       RETRIEVE BILLING INFO USED IN BILL CORRECTION SCREEN.    *        
      ******************************************************************        
      *    PARAMETERS DETAIL                                           *        
      *                                                                *        
      *        INPUT                                                   *        
      *              I_ACCOUNT_NO          DECIMAL(13)                 *        
      *              I_BILL_NO             SMALLINT                    *        
      *              I_CODE_UTIL_TYPE      CHAR(01)                    *        
      *              I_IC_NO               SMALLINT                    *        
      *              I_BILL_ITEM_TIMESTAMP CHAR(26)                    *        
      *              I_LAST_REVENUE_MONTH  CHAR(06)                    *        
      *              I_WQ_ITEM_ID          DECIMAL(10)                 *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *      1. CSR04870_R1 - BILLING DETAILS                          *        
      *      2. CSR04870_R2 - BILLING CONSUMPTION DETAILS-METERED      *        
      *      3. CSR04870_R3 - BILLING FACTOR DETAILS                   *        
      *      4. CSR04870_R4 - COMMON BUSINESS RULES                    *        
      *      5. CSR04870_R5 - ACCOUNT LEVEL DETAILS                    *        
      *      6. CSR04870_R6 - BILLING CONSUMPTION DETAILS-UNMETERED    *        
      *      7. CSR04870_R7 - ACCOUNT METER DETAILS                    *        
      *      8. CSR04870_R8 - ACCOUNT UNMETER DETAILS                  *        
      *      9. CSR04870_R9 - BILLING ADJUSTMENT DETAILS               *        
      *                                                                *        
      ******************************************************************        
      *                     MODIFICATION LOG                           *        
      *                                                                *        
      *    DATE          INITIALS    COMMENTS                          *        
      *    -----------   --------    ----------------------------------*        
P00899*    07/17/2015    HA7A338     INITIAL VERSION                   *        
      *    02/01/2016    HA7A338     MOVED BN REVENUE MONTH WHEN ACCOUNT        
      *                              IS NOT BILLED FOR FIRST TIME.     *        
      *    02/09/2016    HA7A338     FETCH CONSUMPTION DETAILS FROM WQ *        
      *                              TABLE ON TOP OF CX DETAILS WHEN   *        
      *                              WQ ITEM ID PASSED AS INPUT.       *        
P00899*    05/31/2016    NC94746     POPULATE CODE-ITEM-STATUS CORRECTLY        
      *                              FROM REGISTER STATUS.             *        
A05460*    06/30/2016    HA7A338     LOOK INTO ALL 14 REGISTERS FOR    *        
      *                              METER READING IN WQ FREEFORM      *        
A05460*    08/09/2016    HA7A338     ADDED FIX TO INITIALISE MAX/MIN   *        
      *                              VALUE WITH DEFAULT VALUES TO AVOID*        
      *                              S0C7 WHEN NO ROW FOUND IN MN TABLE*        
A05460*    08/17/2016    HA7A338     MOVE RATE PKG SEQ # FROM UT TABLE *        
      *                              WHEN IT IS 0 IN BG.               *        
A05460*    10/06/2016    HA7A338     FOR METER READ POST WQ, CALCULATE *        
      *                              THE CURRENT USAGE BY SUBTRACTING  *        
      *                              IT WITH PREVIOUS READING INDEX    *        
      *                              INSTEAD OF MN INDEX.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04870'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                          PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04870 STARTS HERE'.                 
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                   PIC X(08) VALUE 'CSR04870'. 
          05 MCSCB063                       PIC X(08) VALUE 'MCSCB063'. 
          05 WS-BI-REBILL                   PIC X(01) VALUE 'C'.        
          05 WS-CCF                         PIC X(01) VALUE 'C'.        
          05 WS-NO                          PIC X(01) VALUE 'N'.        
          05 WS-YES                         PIC X(01) VALUE 'Y'.        
          05 WS-TEST                        PIC X(01) VALUE 'T'.        
          05 WS-SUB-ACCT                    PIC X(01) VALUE 'S'.        
          05 WS-MST-ACCT                    PIC X(01) VALUE 'M'.        
          05 WS-ELEC-FCTR                   PIC X(01) VALUE 'B'.        
          05 WS-GAS-FCTR                    PIC X(01) VALUE 'B'.        
          05 WS-FAILED                      PIC X(01) VALUE 'F'.        
          05 WS-ACTIVE                      PIC X(01) VALUE 'A'.        
          05 WS-REMOVED                     PIC X(01) VALUE 'K'.        
          05 WS-BACKOUT                     PIC X(01) VALUE 'B'.        
          05 WS-CURRENT                     PIC X(01) VALUE 'C'.        
          05 WS-BG-REBILL                   PIC X(01) VALUE 'R'.        
          05 WS-BILLED                      PIC X(01) VALUE 'I'.        
          05 WS-FUTURE                      PIC X(01) VALUE 'A'.        
          05 WS-IMMEDIATE                   PIC X(01) VALUE 'C'.        
          05 WS-CREDIT                      PIC X(01) VALUE 'C'.        
          05 WS-DEBIT                       PIC X(01) VALUE 'D'.        
          05 WS-PENDING                     PIC X(01) VALUE 'P'.        
          05 WS-SMART-SCREEN                PIC X(01) VALUE 'S'.        
          05 WS-ACTIVE-NORMAL-BLNG          PIC X(01) VALUE 'A'.        
          05 WS-CSC-LIT-DESC                PIC X(04) VALUE ' CSC'.     
          05 WS-RTOV                        PIC X(04) VALUE 'RTOV'.     
          05 WS-AGLP                        PIC X(04) VALUE 'AGLP'.     
          05 WS-NAGL                        PIC X(04) VALUE 'NAGL'.     
          05 WS-BADJ                        PIC X(04) VALUE 'BADJ'.     
          05 WS-CMND-CODE                   PIC X(04) VALUE 'DATE'.     
          05 WS-PROGRAM-NAME                PIC X(06) VALUE 'COMMON'.   
          05 WS-SCEG                        PIC X(02) VALUE '01'.       
          05 WS-FREEFORM-RSN-CD             PIC X(04) VALUE '999 '.     
          05 WS-DEFAULT-MAX-UNITS           PIC 9(09) VALUE 999999999.  
          05 WS-DEFAULT-NO-DIALS            PIC 9(04) VALUE 5.          
          05 WS-DEFAULT-CONSTANT            PIC 9(04) VALUE 1.          
          05 WS-DEFAULT-PCOMP               PIC 9(02) VALUE 1.          
          05 WS-SEQ-NO                      PIC S9(4)V                  
                                                      VALUE 20 COMP-3.  
                                                                        
       01 SWITCHES.                                                     
          05 END-OF-BG-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-DETAIL-RECS                   VALUE 'Y'.        
          05 END-OF-CX-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-CNSMPTN-RECS                  VALUE 'Y'.        
          05 END-OF-UC-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-UC-CNSMPTN-REC                VALUE 'Y'.        
          05 END-OF-FH-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-FACTOR-RECS                   VALUE 'Y'.        
          05 END-OF-MT-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-METER-RECS                    VALUE 'Y'.        
          05 END-OF-UNMT-SW                 PIC X(01) VALUE 'N'.        
             88 NO-MORE-UNMTR-RECS                    VALUE 'Y'.        
          05 END-OF-BP-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-BIL-ADJST-RECS                VALUE 'Y'.        
          05 END-OF-RR-SW                   PIC X(01) VALUE 'N'.        
             88 NO-MORE-REG-RECS                      VALUE 'Y'.        
          05 END-OF-MTR-SW                  PIC X(01) VALUE 'N'.        
             88 NO-MORE-MTR-RECS                      VALUE 'Y'.        
          05 WS-DATABASE                    PIC 9(01) VALUE 0.          
             88 CSR-DATABASE                          VALUE 1.          
             88 SEB-DATABASE                          VALUE 2.          
          05 WS-BILL-WINDOW-IND             PIC X(01) VALUE 'Y'.        
             88 BILL-EXEMPT                           VALUE 'Y'.        
             88 BILL-NOT-EXEMPT                       VALUE 'N'.        
          05 WS-UNMTRD-ELEC-GAS             PIC X(01) VALUE 'N'.        
             88 UNMTRD-ELEC-GAS                       VALUE 'Y'.        
             88 MTRD-ELEC-GAS                         VALUE 'N'.        
          05 WS-HRLY-REGISTER               PIC X(01) VALUE 'N'.        
             88 HRLY-REGISTER                         VALUE 'Y'.        
             88 NOT-HRLY-REGISTER                     VALUE 'N'.        
          05 WS-CIG-CUSTOMER                PIC X(01) VALUE 'N'.        
             88 CIG-CUSTOMER                          VALUE 'Y'.        
             88 NOT-CIG-CUSTOMER                      VALUE 'N'.        
          05 WS-RTOV-IND                    PIC X(01) VALUE 'N'.        
             88 INSERT-RTOV                           VALUE 'Y'.        
             88 DO-NOT-INSERT-RTOV                    VALUE 'N'.        
          05 WS-DF-STATUS-CODE              PIC X(01) VALUE ' '.        
             88 ACTIVE                                VALUE 'A'.        
             88 OPEN-FOR-RENEWAL                      VALUE 'O'.        
             88 RENEWED                               VALUE 'R'.        
             88 DELETED                               VALUE 'D'.        
             88 PENDING                               VALUE 'P'.        
          05 WS-CX-LATEST-ROW               PIC X(01) VALUE 'N'.        
             88 CX-LATEST                             VALUE 'Y'.        
             88 CX-NOT-LATEST                         VALUE 'N'.        
                                                                        
       01 COUNTER-FIELDS.                                               
          05 CTR-ROWS-RS1                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS2                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS3                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS4                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS5                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS6                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS7                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS8                   PIC S9(9) VALUE 0 COMP.     
          05 CTR-ROWS-RS9                   PIC S9(9) VALUE 0 COMP.     
          05 WS-BILLING-KEY-NUM             PIC 9(02) VALUE 0.          
          05 WS-MN-REG-CNT                  PIC S9(4) VALUE 0 COMP.     
          05 WS-MTR-RGSTR-CNT               PIC S9(4) VALUE 0 COMP.     
                                                                        
       01 WS-DATE.                                                      
          05 WS-DATE-EXTRACT                PIC X(10) VALUE SPACES.     
          05 WS-CURRENT-DATE                PIC X(10) VALUE SPACES.     
          05 WS-CURR-DT-MINUS-4D            PIC X(10) VALUE SPACES.     
          05 WS-CURR-DT-PLUS-4D             PIC X(10) VALUE SPACES.     
          05 WS-LAST-REV-MTH-MINUS-12M      PIC X(10) VALUE             
                                                      '0001-01-01'.     
          05 WS-CURR-REV-MONTH              PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
          05 WS-REVENUE-MONTH               PIC 9(06) VALUE 0.          
          05 WS-START-REVENUE-MONTH         PIC S9(6) VALUE 0 COMP.     
          05 WS-END-REVENUE-MONTH           PIC S9(6) VALUE 0 COMP.     
          05 WS-REV-MTH-LST-NRML            PIC S9(6) VALUE 0 COMP.     
          05 WS-EFF-REV-MTH-TMP             PIC S9(6) VALUE 0 COMP.     
          05 WS-EFF-REV-MTH                 REDEFINES WS-EFF-REV-MTH-TMP
                                            PIC 9(06).                  
          05 WS-REVN-DT-MINUS-11M-INT       PIC S9(9) VALUE 0 COMP.     
          05 WS-REVN-DT-MINUS-11M           PIC 9(08) VALUE 0.          
          05 WS-LAST-REVN-DATE              PIC X(10) VALUE SPACES.     
          05 WS-START-REVN-DATE             PIC X(10) VALUE SPACES.     
          05 WS-STRT-REVN-DATE.                                         
             10 WS-START-REVENUE-YY         PIC X(04) VALUE SPACES.     
             10 WS-START-REVENUE-F1         PIC X(01) VALUE '-'.        
             10 WS-START-REVENUE-MT         PIC X(02) VALUE SPACES.     
             10 WS-START-REVENUE-F2         PIC X(01) VALUE '-'.        
             10 WS-START-REVENUE-DY         PIC X(02) VALUE '01'.       
          05 WS-LST-REVN-DATE.                                          
             10 WS-LAST-REVENUE-YY          PIC X(04) VALUE SPACES.     
             10 WS-LAST-REVENUE-F1          PIC X(01) VALUE '-'.        
             10 WS-LAST-REVENUE-MT          PIC X(02) VALUE SPACES.     
             10 WS-LAST-REVENUE-F2          PIC X(01) VALUE '-'.        
             10 WS-LAST-REVENUE-DY          PIC X(02) VALUE '01'.       
          05 WS-EFF-REV-MTH-DATE.                                       
             10 WS-EFF-REV-MTH-YR           PIC X(04) VALUE SPACES.     
             10 WS-EFF-REV-MTH-F1           PIC X(01) VALUE '-'.        
             10 WS-EFF-REV-MTH-MM           PIC X(02) VALUE SPACES.     
             10 WS-EFF-REV-MTH-F2           PIC X(01) VALUE '-'.        
             10 WS-EFF-REV-MTH-DD           PIC X(02) VALUE '05'.       
                                                                        
       01 WS-NULL-IND.                                                  
          05 WS-NULL-IND-1                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-2                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-3                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-4                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-5                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-6                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-7                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-8                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-9                  PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-10                 PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-11                 PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-12                 PIC S9(4) VALUE 0 COMP.     
          05 WS-NULL-IND-13                 PIC S9(4) VALUE 0 COMP.     
                                                                        
       01 WS-MISC.                                                      
          05 WS-GTT-NAME                    PIC X(26) VALUE SPACES.     
          05 WS-SQLSTATE                    PIC X(05) VALUE SPACES.     
          05 WS-MCSCB063-RET-CODE           PIC S9(4) VALUE 0 COMP.     
          05 WS-PREV-RATE-PLAN-NO           PIC X(03) VALUE SPACES.     
          05 WS-PREV-RT-PKG-SEQ-NO          PIC S9(4) VALUE 0 COMP.     
          05 WS-CSC-AMT-DESC                PIC $Z9.99.                 
          05 WS-DURATION-REMAIN-NO          PIC X(04) VALUE SPACES.     
          05 WS-CX-CODE-USAGE-VALUE         PIC X(04) VALUE SPACES.     
          05 WS-TEMP-USAGE                  PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
          05 WS-WQ-IDX                      PIC S9(4) VALUE 0 COMP.     
          05 WS-NO-DAYS                     PIC S9(4) VALUE 0 COMP.     
          05 WS-USAGE-ABSLT                 PIC 9(09)V9(3)              
                                                      VALUE 0 COMP-3.   
       01 WS-BILL-ADJ-DTLS.                                             
          05 WS-BP-ADJ-TYPE-CD              PIC x(04) VALUE SPACES.     
          05 WS-BP-REVENUE-MONTH            PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
          05 WS-BP-ADJ-REASON-DESC          PIC X(255) VALUE SPACES.    
          05 WS-BP-OVRRIDE-RT-REV-MTH       PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
          05 WS-BP-SPECIAL-PROCESS-CD       PIC X(02) VALUE SPACES.     
                                                                        
       01 WS-MTR-REG-DTLS.                                              
          05 WS-METER-NO                    PIC X(09) VALUE SPACES.     
          05 WS-MTR-REF-NO                  PIC S9(4) VALUE 0 COMP.     
          05 WS-REG-ID-NO                   PIC S9(4) VALUE 0 COMP.     
          05 WS-CODE-METER-STATUS           PIC X(01) VALUE SPACES.     
P00899    05 WS-CODE-REG-STATUS             PIC X(01) VALUE SPACES.     
          05 WS-LAST-REG-READ-DATE          PIC X(10) VALUE SPACES.     
          05 WS-LAST-READ-VALUE             PIC S9(12)V9(3)             
                                                      VALUE 0 COMP-3.   
          05 WS-CODE-USAGE-VALUE            PIC X(04) VALUE SPACES.     
          05 WS-PCOMP-FCT                   PIC S9(2)V9(5)              
                                                      VALUE 0 COMP-3.   
          05 WS-MIN-NO-UNITS                PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
          05 WS-MAX-NO-UNITS                PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
          05 WS-CONSTANT                    PIC S9(6)V9(5)              
                                                      VALUE 0 COMP-3.   
          05 WS-NO-READ-DIALS               PIC S9(4) VALUE 0 COMP.     
          05 WS-CODE-USAGE-SOURCE           PIC X(01) VALUE SPACES.     
          05 WS-CODE-USAGE-TYPE             PIC X(01) VALUE SPACES.     
          05 WS-CODE-TIME-PERIOD            PIC S9(4) VALUE 0 COMP.     
          05 WS-CODE-USAGE-ID               PIC X(01) VALUE SPACES.     
                                                                        
       01 WS-MTR-REG-DTLS-TBL.                                          
          05 WS-MTR-REG-DTL-DATA OCCURS 25 TIMES                        
                             INDEXED BY WS-MTR-REG-INDX.                
             10 WS-MR-METER-NO              PIC X(09) VALUE SPACES.     
             10 WS-MR-MTR-REF-NO            PIC S9(4) VALUE 0 COMP.     
             10 WS-MR-REG-ID-NO             PIC S9(4) VALUE 0 COMP.     
             10 WS-MR-CODE-METER-STATUS     PIC X(01) VALUE SPACES.     
P00899       10 WS-MR-CODE-REG-STATUS       PIC X(01) VALUE SPACES.     
             10 WS-MR-LAST-REG-READ-DATE    PIC X(10) VALUE SPACES.     
             10 WS-MR-LAST-READ-VALUE       PIC S9(12)V9(3)             
                                                      VALUE 0 COMP-3.   
             10 WS-MR-PCOMP-FCT             PIC S9(2)V9(5)              
                                                      VALUE 0 COMP-3.   
             10 WS-MR-MIN-NO-UNITS          PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 WS-MR-MAX-NO-UNITS          PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 WS-MR-CONSTANT              PIC S9(6)V9(5)              
                                                      VALUE 0 COMP-3.   
             10 WS-MR-NO-READ-DIALS         PIC S9(4) VALUE 0 COMP.     
             10 WS-MR-CODE-USAGE-SOURCE     PIC X(01) VALUE SPACES.     
             10 WS-MR-CODE-USAGE-TYPE       PIC X(01) VALUE SPACES.     
             10 WS-MR-CODE-TIME-PERIOD      PIC S9(4) VALUE 0 COMP.     
             10 WS-MR-CODE-USAGE-ID         PIC X(01) VALUE SPACES.     
             10 WS-MR-DIGTL-MTR-TYPE        PIC X(03) VALUE SPACES.     
             10 WS-MR-MTR-READ-SOURCE-CD    PIC X(01) VALUE SPACES.     
                                                                        
       01 WS-REG-DTLS-TBL.                                              
          05 WS-REG-DTL-DATA OCCURS 50 TIMES                            
                             INDEXED BY WS-REG-INDX.                    
             10 WS-MN-MIN-NO-UNITS          PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 WS-MN-MAX-NO-UNITS          PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 WS-MN-MTR-REF-NO            PIC S9(4) VALUE 0 COMP.     
                                                                        
       01 WS-WORK-QUEUE-DATA.                                           
          05 WS-WQ-FILLER                   PIC X(03).                  
          05 WS-WQ-METER-NO                 PIC X(09).                  
          05 WS-WQ-DATE-READ                PIC X(10).                  
          05 WS-WQ-UTIL-TYPE                PIC X(01).                  
          05 WS-WQ-TOU-FL                   PIC X(01).                  
          05 WS-WQ-READER-ID                PIC 9(05).                  
          05 WS-WQ-READINGS  OCCURS 14 TIMES                            
                             INDEXED BY WS-WQ-TEMP-INDX.                
             10 WS-WQ-READ                  PIC 9(09).                  
             10 WS-WQ-NO-READ-CD            PIC X(01).                  
             10 WS-WQ-USAGE-TYPE            PIC X(01).                  
             10 WS-WQ-USAGE-ID              PIC X(01).                  
             10 WS-WQ-USAGE-SOURCE          PIC X(01).                  
             10 WS-WQ-SESN-CD               PIC X(01).                  
             10 WS-WQ-TIME-PERIOD           PIC 9(01).                  
          05 WS-WQ-BTU-FACTOR               PIC 9(02)V9(5).             
          05 WS-WQ-CYCLE-IND                PIC X(01).                  
          05 WS-WQ-FF-FORMAT-CD             PIC X(01).                  
          05 WS-WQ-READ-CODE                PIC X(01).                  
          05 WS-WQ-READ-PROCESS-CD          PIC X(01).                  
          05 WS-WQ-READ-STATUS-CD           PIC X(01).                  
          05 WS-WQ-FILLER                   PIC X(04).                  
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING DETAILS                *                 
      *********************************************************                 
          05 RS-RETURN-CODE                 PIC S9(9) VALUE 0 COMP.     
          05 GTT-RETURN-FIELDS-1.                                       
             10 S1-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S1-ACCOUNT-NO               PIC S9(13)V                 
                                                      VALUE 0 COMP-3.   
             10 S1-CODE-UTIL-TYPE           PIC X(01) VALUE SPACES.     
             10 S1-IC-NO                    PIC S9(4) VALUE 0 COMP.     
             10 S1-BILL-NO                  PIC S9(9) VALUE 0 COMP.     
             10 S1-BILL-ITEM-TIMESTMP       PIC X(26) VALUE SPACES.     
             10 S1-BILLING-KEY-NUM          PIC S9(4) VALUE 0 COMP.     
             10 S1-DATE-ORIG-BILL           PIC X(10) VALUE SPACES.     
             10 S1-REVENUE-MONTH            PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
             10 S1-REV-MTH-ORIG-BILL        PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
             10 S1-REBILL-IND               PIC X(01) VALUE SPACES.     
             10 S1-RATE                     PIC X(03) VALUE SPACES.     
             10 S1-OPTION-CD                PIC X(12) VALUE SPACES.     
             10 S1-OPT-DESC-INT             PIC X(50) VALUE SPACES.     
             10 S1-TRANS-AMT                PIC S9(9)V9(2)              
                                                      VALUE 0 COMP-3.   
             10 S1-BILL-CALC-DESC           PIC X(01) VALUE SPACES.     
             10 S1-CODE-BILL-ITM-TYPE       PIC X(01) VALUE SPACES.     
             10 S1-TRANS-STATUS             PIC X(01) VALUE SPACES.     
             10 S1-DR-CR                    PIC X(01) VALUE SPACES.     
             10 S1-STATE-TAX                PIC S9(7)V99                
                                                      VALUE 0 COMP-3.   
             10 S1-CITY-TAX                 PIC S9(7)V99                
                                                      VALUE 0 COMP-3.   
             10 S1-OTHER-TAX                PIC S9(7)V99                
                                                      VALUE 0 COMP-3.   
             10 S1-CODE-REVENUE-CLASS       PIC X(03) VALUE SPACES.     
             10 S1-CODE-SIC-NO              PIC X(04) VALUE SPACES.     
             10 S1-CODE-CURTAIL-PRTY        PIC S99V9 VALUE 0 COMP-3.   
             10 S1-STATE-XMT                PIC X(01) VALUE SPACES.     
             10 S1-CITY-XMT                 PIC X(01) VALUE SPACES.     
             10 S1-OTHER-XMT                PIC X(01) VALUE SPACES.     
             10 S1-REV-RPT-CD               PIC X(01) VALUE SPACES.     
             10 S1-STANDBY-COMPLIED         PIC X(01) VALUE SPACES.     
             10 S1-PRORATE-CD               PIC X(01) VALUE SPACES.     
             10 S1-NEW-RATE-PCT             PIC SV9(4)                  
                                                      VALUE 0 COMP-3.   
             10 S1-TAX-REFUND-CD            PIC X(01) VALUE SPACES.     
             10 S1-DATE-LFTM-HI-DMD         PIC X(10) VALUE SPACES.     
             10 S1-LFTM-HI-PEAK-DMD         PIC S9(7)V                  
                                                      VALUE 0 COMP-3.   
             10 S1-ADJ-REASON               PIC X(04) VALUE SPACES.     
             10 S1-GAS-BASE-USE             PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S1-WNA-FACTOR               PIC S99V9(5)                
                                                      VALUE 0 COMP-3.   
             10 S1-BTU-FACTOR               PIC S99V9(5)                
                                                      VALUE 0 COMP-3.   
             10 S1-NO-OF-CONS-DAYS          PIC S9(4) VALUE 0 COMP.     
             10 S1-NO-CONSEC-ESTIMATE       PIC S9(4) VALUE 0 COMP.     
             10 S1-SHIPPER                  PIC X(01) VALUE SPACES.     
             10 S1-TRNSP-OVER-MDQ           PIC X(01) VALUE SPACES.     
             10 S1-BILL-CORRECTED-CD        PIC X(01) VALUE SPACES.     
             10 S1-RT-PKG-OPT-SEQ-NO        PIC S9(4) VALUE 0 COMP.     
             10 S1-HRLY-REGISTER            PIC X(01) VALUE SPACES.     
             10 S1-CIG-CUSTOMER             PIC X(01) VALUE SPACES.     
             10 S1-BILLED-DATE              PIC X(10) VALUE SPACES.     
             10 S1-CODE-BILL-STATUS         PIC X(01) VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING CONSUMPTION-METERED    *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S2-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S2-BILLING-KEY-NUM          PIC S9(4) VALUE 0 COMP.     
             10 S2-CODE-TIME-PERIOD         PIC S9(4) VALUE 0 COMP.     
             10 S2-MTR-REF-NO               PIC S9(4) VALUE 0 COMP.     
             10 S2-CODE-USAGE-TYPE          PIC X(01) VALUE SPACES.     
             10 S2-CODE-USAGE-ID            PIC X(01) VALUE SPACES.     
             10 S2-CODE-USAGE-SOURCE        PIC X(01) VALUE SPACES.     
             10 S2-ITEM-SEQ-NO              PIC S9(4) VALUE 0 COMP.     
             10 S2-METER-NO                 PIC X(09) VALUE SPACES.     
             10 S2-REG-ID-NO                PIC S9(4) VALUE 0 COMP.     
             10 S2-DATE-READ                PIC X(10) VALUE SPACES.     
             10 S2-CODE-METER-READ          PIC X(01) VALUE SPACES.     
             10 S2-CODE-METER-NO-READ       PIC X(01) VALUE SPACES.     
             10 S2-METER-READING            PIC S9(8)V9(3)              
                                                      VALUE 0 COMP-3.   
             10 S2-NO-UNITS                 PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S2-USAGE                    PIC S9(9)V9(3)              
                                                      VALUE 0 COMP-3.   
             10 S2-NO-DAYS                  PIC S9(4) VALUE 0 COMP.     
             10 S2-CODE-SOURCE-ID           PIC X(01) VALUE SPACES.     
             10 S2-CODE-DEBIT-CREDIT        PIC X(01) VALUE SPACES.     
             10 S2-CODE-ITEM-STATUS         PIC X(01) VALUE SPACES.     
             10 S2-CONSTANT                 PIC S9(6)V9(5)              
                                                      VALUE 0 COMP-3.   
             10 S2-NO-DIALS                 PIC S9(4) VALUE 0 COMP.     
             10 S2-EXCEPT-OVERRIDE-CD       PIC X(01) VALUE SPACES.     
             10 S2-REQUESTED-USAGE          PIC S9(9) VALUE 0 COMP.     
             10 S2-DIGTL-INTRL-MTR-NO       PIC X(18) VALUE SPACES.     
             10 S2-DIGTL-MTR-TYPE           PIC X(03) VALUE SPACES.     
             10 S2-CODE-TOU-SEASN           PIC X(01) VALUE SPACES.     
             10 S2-EXCL-DMD-RCHT-IND        PIC X(01) VALUE SPACES.     
             10 S2-MTR-READ-SOURCE-CD       PIC X(01) VALUE SPACES.     
             10 S2-PCOMP-FCT                PIC S9(2)V9(5)              
                                                      VALUE 0 COMP-3.   
             10 S2-CODE-USAGE-VALS          PIC X(04) VALUE SPACES.     
             10 S2-MIN-NO-UNITS             PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S2-MAX-NO-UNITS             PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S2-LATEST-ROW               PIC X(01) VALUE SPACES.     
             10 S2-WQ-CNSMPTN               PIC X(01) VALUE SPACES.     
             10 S2-WQ-NO-READ-CD            PIC X(01) VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING FACTOR DETAILS         *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S3-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S3-BILLING-KEY-NUM          PIC S9(4) VALUE 0 COMP.     
             10 S3-FACT-ID                  PIC X(09) VALUE SPACES.     
             10 S3-FACTOR                   PIC S9(9)V9(6)              
                                                      VALUE 0 COMP-3.   
             10 S3-EFF-DATE-FROM            PIC X(10) VALUE SPACES.     
             10 S3-EFF-DATE-TO              PIC X(10) VALUE SPACES.     
             10 S3-CODE-SEASON              PIC X(01) VALUE SPACES.     
             10 S3-INSTR-USE-TYPE-CD        PIC X(01) VALUE SPACES.     
             10 S3-CODE-TIME-PERIOD         PIC S9(4) VALUE 0 COMP.     
             10 S3-CMPNT-ID-CD              PIC X(02) VALUE SPACES.     
             10 S3-FIXED-FCTR-TYP-CD        PIC X(02) VALUE SPACES.     
             10 S3-FIXED-FCTR-SEQ-NO        PIC S9(4) VALUE 0 COMP.     
             10 S3-DURATION-REMAIN-NO       PIC X(04) VALUE SPACES.     
             10 S3-BLOCK-NO                 PIC S9(4) VALUE 0 COMP.     
             10 S3-ALLOWED-BLOCKS           PIC S9(4) VALUE 0 COMP.     
             10 S3-FCTR-POWER-10            PIC S9(4) VALUE 0 COMP.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR COMMON BUSINESS RULES          *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-4.                                       
             10 S4-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S4-RULE-ID                  PIC X(10) VALUE SPACES.     
             10 S4-RULE-RESULT-CD           PIC X(08) VALUE SPACES.     
             10 S4-BUS-RULE-XREF-ID         PIC X(26) VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR ACCOUNT LEVEL DETAILS          *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-5.                                       
             10 S5-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S5-ACCOUNT-NO               PIC S9(13)V                 
                                                      VALUE 0 COMP-3.   
             10 S5-CODE-UTIL-TYPE           PIC X(01) VALUE SPACES.     
             10 S5-IC-NO                    PIC S9(4) VALUE 0 COMP.     
             10 S5-COMPANY-NO               PIC X(02) VALUE SPACES.     
             10 S5-AT-LAST-UPDATE-TS        PIC X(26) VALUE SPACES.     
             10 S5-ACCT-FINALED-DT          PIC X(26) VALUE SPACES.     
             10 S5-MIN-PRORATION-DAYS       PIC S9(4) VALUE 0 COMP.     
             10 S5-MAX-PRORATION-DAYS       PIC S9(4) VALUE 0 COMP.     
             10 S5-BILL-WINDOW-IND          PIC X(01) VALUE SPACES.     
             10 S5-DATE-EXTRACT             PIC X(10) VALUE SPACES.     
             10 S5-MST-ACCT-BILLED          PIC X(01) VALUE 'N'.        
             10 S5-COMMON-REV-MONTH         PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
             10 S5-MV90-MTR-IND             PIC X(01) VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING CONSUMPTION-UNMETERED  *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-6.                                       
             10 S6-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S6-BILLING-KEY-NUM          PIC S9(4) VALUE 0 COMP.     
             10 S6-UM-DESCRIPTION           PIC X(17) VALUE SPACES.     
             10 S6-UM-RATE-ITEM-CODE        PIC S9(4) VALUE 0 COMP.     
             10 S6-UM-ITEM-SEQ-NO           PIC S9(4) VALUE 0 COMP.     
             10 S6-UM-NO-UNITS              PIC S9(9) VALUE 0 COMP.     
             10 S6-UM-NO-DAYS               PIC S9(4) VALUE 0 COMP.     
             10 S6-UM-CODE-DEBIT-CREDIT     PIC X(01) VALUE SPACES.     
             10 S6-UM-USAGE-FIXED           PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S6-UM-DATE-USAGE-ENDS       PIC X(10) VALUE SPACES.     
             10 S6-UM-CODE-SERVICE-TYPE     PIC X(01) VALUE SPACES.     
             10 S6-UM-CODE-ITEM-STATUS      PIC X(01) VALUE SPACES.     
             10 S6-UM-CODE-SOURCE-ID        PIC X(01) VALUE SPACES.     
             10 S6-UM-MTHLY-AMOUNT-FIXED    PIC S9(9)V9(2)              
                                                      VALUE 0 COMP-3.   
             10 S6-UM-DIST-NO               PIC X(03) VALUE SPACES.     
             10 S6-UM-LIGHT-NO              PIC S9(4) VALUE 0 COMP.     
             10 S6-UM-POLE-NO               PIC X(07) VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR ACCOUNT METER DETAILS          *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-7.                                       
             10 S7-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S7-METER-NO                 PIC X(09) VALUE SPACES.     
             10 S7-MTR-REF-NO               PIC S9(4) VALUE 0 COMP.     
             10 S7-REG-ID-NO                PIC S9(4) VALUE 0 COMP.     
             10 S7-CODE-METER-STATUS        PIC X(01) VALUE SPACES.     
             10 S7-CODE-USAGE-VALUE         PIC X(04) VALUE SPACES.     
             10 S7-MIN-NO-UNITS             PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S7-MAX-NO-UNITS             PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S7-CONSTANT                 PIC S9(6)V9(5)              
                                                      VALUE 0 COMP-3.   
             10 S7-NO-READ-DIALS            PIC S9(4) VALUE 0 COMP.     
             10 S7-PCOMP-FCT                PIC S9(2)V9(5)              
                                                      VALUE 0 COMP-3.   
             10 S7-LAST-READ-DATE           PIC X(10) VALUE SPACES.     
             10 S7-LAST-READ-VALUE          PIC S9(12)V9(3)             
                                                      VALUE 0 COMP-3.   
             10 S7-CODE-USAGE-SOURCE        PIC X(01) VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR ACCOUNT UNMETER DETAILS        *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-8.                                       
             10 S8-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S8-RATE-ITEM-DESC           PIC X(17) VALUE SPACES.     
             10 S8-NO-UNITS                 PIC S9(9) VALUE 0 COMP.     
             10 S8-USAGE-FIXED              PIC S9(9)V                  
                                                      VALUE 0 COMP-3.   
             10 S8-MTHLY-AMOUNT-FIXED       PIC S9(9)V9(2)              
                                                      VALUE 0 COMP-3.   
             10 S8-ITEM-SEQ-NO              PIC S9(4) VALUE 0 COMP.     
             10 S8-REMOVE-DATE              PIC X(10) VALUE SPACES.     
             10 S8-LAST-BILL-DATE           PIC X(10) VALUE SPACES.     
             10 S8-CODE-SERVICE-TYPE        PIC X(01) VALUE SPACES.     
             10 S8-CODE-PLAN-STATUS         PIC X(01) VALUE SPACES.     
             10 S8-CODE-STAT-REASON         PIC X(01) VALUE SPACES.     
             10 S8-RATE-ITEM-CODE           PIC S9(4) VALUE 0 COMP.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILL ADJUSTMENT DETAILS.       *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-9.                                       
             10 S9-RETURN-CODE              PIC S9(9) VALUE 0 COMP.     
             10 S9-BILLING-KEY-NUM          PIC S9(4) VALUE 0 COMP.     
             10 S9-ADJ-TYPE-CD              PIC X(08) VALUE SPACES.     
             10 S9-REVENUE-MONTH            PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
             10 S9-ADJ-REASON-DESC          PIC X(255) VALUE SPACES.    
             10 S9-OVRRIDE-RT-REV-MTH       PIC S9(6)V                  
                                                      VALUE 0 COMP-3.   
             10 S9-SPECIAL-PROCESS-CD       PIC X(02) VALUE SPACES.     
             10 S9-ADJ-REASON-CD            PIC X(04) VALUE SPACES.     
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCOUNT         AT                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR   DF                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BILLING_DET     BG                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BILLING_HDR     BI                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BILL_ADJUSTMNT  BP                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILADJ                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BILL_ADJ_REASN  K0                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLADRSN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BILL_WINDOW     BN                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BUS_RULE        1R                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_CNSMPTN_HIST    CX                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_COMPANY         C7                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_CUST_PLAN       CP                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_DELINQUENCY     C8                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_FIXED_FCTR      FF                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_FIXED_FCT_HIST  FH                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXHST                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_JOB_PARM        G6                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_MSTSUB_ACCT     MU                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT    MN                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_MTR_CAP         MC                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_PRICE_SCHED     PS                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_RATE_COMP_DEF   J1                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_RATE_CREATOR    RT                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC  RD                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CRM_RT_PKG_OPTION   FI                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BUS_RULE_XREF   1T                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BUS_RULE_ACTN   1S                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_BUS_RULE_MSG    1X                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULMSG                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_RULE_ACTN_LINK  2X                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULACN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_SPCL_FCTR       SF                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_UM_CNSMPT_HIST  UC                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMCNSM                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_UM_EQUIPMENT    L9                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_UNMTR_PLAN      UP                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT    UT                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_UI_RUL_ACTN_XR  1U                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUIRULX                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_WQ_ITEMS        WQ                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *  ERROR HANDLING                                                *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
      ******************************************************************        
      *    SUPPORTS MCSCB063 CALL                                      *        
      ******************************************************************        
           COPY CWS00063.                                                       
      ******************************************************************        
      **  RETRIEVE BILLING DETAILS FOR THE REVENUE MONTHS THAT FALLS  **        
      **  BETWEEN THE INPUT RANGE.                                    **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BG-CURSOR CURSOR FOR                              
                 SELECT BG.BILL_NO                                      
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                           
                       ,BG.DATE_ORIG_BILL                               
                       ,BG.AMT_BILL_ITEM                                
                       ,BG.CODE_BILL_CALC                               
                       ,BG.CODE_BILL_ITM_TYPE                           
                       ,BG.CODE_BILL_ITM_IND                            
                       ,BG.CODE_DR_CR_CNSMPTN                           
                       ,BG.AMT_STATE_TAX                                
                       ,BG.AMT_CITY_TAX                                 
                       ,BG.AMT_OTHER_TAX                                
                       ,BG.CODE_REVENUE_CLASS                           
                       ,BG.CODE_SIC_NO                                  
                       ,BG.RATE_PLAN_NO                                 
                       ,BG.CODE_CURTAIL_PRTY                            
                       ,BG.CODE_STAT_TAX_XMT                            
                       ,BG.CODE_CITY_TAX_XMT                            
                       ,BG.CODE_OTHR_TAX_XMT                            
                       ,BG.REV_RPT_CD                                   
                       ,BG.STANDBY_COMPLIED                             
                       ,BG.PRORATE_CD                                   
                       ,BG.NEW_RATE_PCT                                 
                       ,BG.TAX_REFUND_CD                                
                       ,BG.DATE_LFTM_HI_DMD                             
                       ,BG.LFTM_HI_PEAK_DMD                             
                       ,BG.REBILL_IND                                   
                       ,BG.ADJ_REASON_CD                                
                       ,BG.REVENUE_MONTH                                
                       ,BG.GAS_BASE_USE                                 
                       ,BG.WNA_FACTOR                                   
                       ,BG.BTU_FACTOR                                   
                       ,BG.NO_OF_CONS_DAYS                              
                       ,BG.REV_MTH_ORIG_BILL                            
                       ,BG.FUEL_SHIPPER_CD                              
                       ,BG.TRNSP_OVER_MDQ_FL                            
                       ,BG.RT_PKG_OPT_SEQ_NO                            
                       ,BI.BILL_CORRECTED_CD                            
                       ,BI.DATE_BILLED                                  
                       ,BI.CODE_BILL_STATUS                             
                 FROM   CSS_BILLING_DET   BG WITH(READUNCOMMITTED)              
                       ,CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)              
                 WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO          
                   AND  BG.IC_NO              = :BG-IC-NO               
                   AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE      
                   AND  ((BG.REVENUE_MONTH   <= :WS-START-REVENUE-MONTH 
                   AND  BG.REVENUE_MONTH     >= :WS-END-REVENUE-MONTH)  
                    OR  BG.REVENUE_MONTH      = 0)                      
                   AND  BG.CODE_BILL_ITM_TYPE = 'C'                     
                   AND  BG.CODE_BILL_ITM_IND <> 'K'                     
                   AND  BG.ACCOUNT_NO         = BI.ACCOUNT_NO           
                   AND  BG.BILL_NO            = BI.BILL_NO              
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BG-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT BG.BILL_NO                                              
MFA-TR*                ,BG.BILL_ITEM_TIMESTMP                                   
MFA-TR*                ,BG.DATE_ORIG_BILL                                       
MFA-TR*                ,BG.AMT_BILL_ITEM                                        
MFA-TR*                ,BG.CODE_BILL_CALC                                       
MFA-TR*                ,BG.CODE_BILL_ITM_TYPE                                   
MFA-TR*                ,BG.CODE_BILL_ITM_IND                                    
MFA-TR*                ,BG.CODE_DR_CR_CNSMPTN                                   
MFA-TR*                ,BG.AMT_STATE_TAX                                        
MFA-TR*                ,BG.AMT_CITY_TAX                                         
MFA-TR*                ,BG.AMT_OTHER_TAX                                        
MFA-TR*                ,BG.CODE_REVENUE_CLASS                                   
MFA-TR*                ,BG.CODE_SIC_NO                                          
MFA-TR*                ,BG.RATE_PLAN_NO                                         
MFA-TR*                ,BG.CODE_CURTAIL_PRTY                                    
MFA-TR*                ,BG.CODE_STAT_TAX_XMT                                    
MFA-TR*                ,BG.CODE_CITY_TAX_XMT                                    
MFA-TR*                ,BG.CODE_OTHR_TAX_XMT                                    
MFA-TR*                ,BG.REV_RPT_CD                                           
MFA-TR*                ,BG.STANDBY_COMPLIED                                     
MFA-TR*                ,BG.PRORATE_CD                                           
MFA-TR*                ,BG.NEW_RATE_PCT                                         
MFA-TR*                ,BG.TAX_REFUND_CD                                        
MFA-TR*                ,BG.DATE_LFTM_HI_DMD                                     
MFA-TR*                ,BG.LFTM_HI_PEAK_DMD                                     
MFA-TR*                ,BG.REBILL_IND                                           
MFA-TR*                ,BG.ADJ_REASON_CD                                        
MFA-TR*                ,BG.REVENUE_MONTH                                        
MFA-TR*                ,BG.GAS_BASE_USE                                         
MFA-TR*                ,BG.WNA_FACTOR                                           
MFA-TR*                ,BG.BTU_FACTOR                                           
MFA-TR*                ,BG.NO_OF_CONS_DAYS                                      
MFA-TR*                ,BG.REV_MTH_ORIG_BILL                                    
MFA-TR*                ,BG.FUEL_SHIPPER_CD                                      
MFA-TR*                ,BG.TRNSP_OVER_MDQ_FL                                    
MFA-TR*                ,BG.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,BI.BILL_CORRECTED_CD                                    
MFA-TR*                ,BI.DATE_BILLED                                          
MFA-TR*                ,BI.CODE_BILL_STATUS                                     
MFA-TR*          FROM   CSS_BILLING_DET   BG                                    
MFA-TR*                ,CSS_BILLING_HDR   BI                                    
MFA-TR*          WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                  
MFA-TR*            AND  BG.IC_NO              = :BG-IC-NO                       
MFA-TR*            AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE              
MFA-TR*            AND  ((BG.REVENUE_MONTH   <= :WS-START-REVENUE-MONTH         
MFA-TR*            AND  BG.REVENUE_MONTH     >= :WS-END-REVENUE-MONTH)          
MFA-TR*             OR  BG.REVENUE_MONTH      = 0)                              
MFA-TR*            AND  BG.CODE_BILL_ITM_TYPE = 'C'                             
MFA-TR*            AND  BG.CODE_BILL_ITM_IND <> 'K'                             
MFA-TR*            AND  BG.ACCOUNT_NO         = BI.ACCOUNT_NO                   
MFA-TR*            AND  BG.BILL_NO            = BI.BILL_NO                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  RETRIEVE METERED CONSUMPTION DETAILS FOR THE BILLING KEY    **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE CX-CURSOR CURSOR FOR                              
                 SELECT                                                 
                   CODE_UTIL_TYPE + CODE_USAGE_TYPE + CAST(
           CODE_TIME_PERIOD AS VARCHAR(MAX)) + CODE_USAGE_ID   AS 
           CODE_USAGE_VALUE            
                       ,CODE_TIME_PERIOD                                
                       ,MTR_REF_NO                                      
                       ,CODE_USAGE_TYPE                                 
                       ,CODE_USAGE_ID                                   
                       ,CODE_USAGE_SOURCE                               
                       ,ITEM_SEQ_NO                                     
                       ,METER_NO                                        
                       ,REG_ID_NO                                       
                       ,DATE_READ                                       
                       ,CODE_METER_READ                                 
                       ,CODE_METER_NO_READ                              
                       ,METER_READING                                   
                       ,DEMAND_READING                                  
                       ,EMPLOYEE_NO                                     
                       ,NO_UNITS                                        
                       ,NO_DEMAND_UNITS                                 
                       ,NO_DAYS                                         
                       ,CODE_SOURCE_ID                                  
                       ,CODE_DEBIT_CREDIT                               
                       ,CODE_ITEM_STATUS                                
                       ,CODE_DISCOUNT                                   
                       ,CONSTANT                                        
                       ,NO_DIALS                                        
                       ,EXCEPT_OVERRIDE_CD                              
                       ,REQUESTED_USAGE                                 
                       ,DIGTL_INTRL_MTR_NO                              
                       ,DIGTL_MTR_TYPE                                  
                       ,CODE_TOU_SEASN                                  
                       ,EXCL_DMD_RCHT_IND                               
                       ,MTR_READ_SOURCE_CD                              
                       ,PCOMP_FCT                                       
                   FROM CSS_CNSMPTN_HIST   CX WITH(READUNCOMMITTED)             
                  WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO          
                    AND CX.BILL_NO            = :CX-BILL-NO             
                    AND CX.IC_NO              = :CX-IC-NO               
                    AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE      
                    AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )  
                    AND CX.CODE_USAGE_ID NOT IN ('1','2','3','4','5',   
                                                     '6','7','8','9')   
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CX-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT                                                         
MFA-TR*            CHAR(CODE_UTIL_TYPE   CONCAT                                 
MFA-TR*                 CODE_USAGE_TYPE  CONCAT                                 
MFA-TR*                 CODE_TIME_PERIOD CONCAT                                 
MFA-TR*                 CODE_USAGE_ID)   AS CODE_USAGE_VALUE                    
MFA-TR*                ,CODE_TIME_PERIOD                                        
MFA-TR*                ,MTR_REF_NO                                              
MFA-TR*                ,CODE_USAGE_TYPE                                         
MFA-TR*                ,CODE_USAGE_ID                                           
MFA-TR*                ,CODE_USAGE_SOURCE                                       
MFA-TR*                ,ITEM_SEQ_NO                                             
MFA-TR*                ,METER_NO                                                
MFA-TR*                ,REG_ID_NO                                               
MFA-TR*                ,DATE_READ                                               
MFA-TR*                ,CODE_METER_READ                                         
MFA-TR*                ,CODE_METER_NO_READ                                      
MFA-TR*                ,METER_READING                                           
MFA-TR*                ,DEMAND_READING                                          
MFA-TR*                ,EMPLOYEE_NO                                             
MFA-TR*                ,NO_UNITS                                                
MFA-TR*                ,NO_DEMAND_UNITS                                         
MFA-TR*                ,NO_DAYS                                                 
MFA-TR*                ,CODE_SOURCE_ID                                          
MFA-TR*                ,CODE_DEBIT_CREDIT                                       
MFA-TR*                ,CODE_ITEM_STATUS                                        
MFA-TR*                ,CODE_DISCOUNT                                           
MFA-TR*                ,CONSTANT                                                
MFA-TR*                ,NO_DIALS                                                
MFA-TR*                ,EXCEPT_OVERRIDE_CD                                      
MFA-TR*                ,REQUESTED_USAGE                                         
MFA-TR*                ,DIGTL_INTRL_MTR_NO                                      
MFA-TR*                ,DIGTL_MTR_TYPE                                          
MFA-TR*                ,CODE_TOU_SEASN                                          
MFA-TR*                ,EXCL_DMD_RCHT_IND                                       
MFA-TR*                ,MTR_READ_SOURCE_CD                                      
MFA-TR*                ,PCOMP_FCT                                               
MFA-TR*            FROM CSS_CNSMPTN_HIST   CX                                   
MFA-TR*           WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                  
MFA-TR*             AND CX.BILL_NO            = :CX-BILL-NO                     
MFA-TR*             AND CX.IC_NO              = :CX-IC-NO                       
MFA-TR*             AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE              
MFA-TR*             AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP          
MFA-TR*             AND CX.CODE_USAGE_ID NOT IN ('1','2','3','4','5',           
MFA-TR*                                              '6','7','8','9')           
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  RETRIEVE UNMETERED CONSUMPTION DETAILS FOR THE BILLING KEY  **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE UC-CURSOR CURSOR FOR                              
                 SELECT RATE_ITEM_CODE                                  
                       ,ITEM_SEQ_NO                                     
                       ,NO_UNITS                                        
                       ,NO_DAYS                                         
                       ,CODE_DEBIT_CREDIT                               
                       ,USAGE_FIXED                                     
                       ,DATE_USAGE_ENDS                                 
                       ,CODE_SERVICE_TYPE                               
                       ,CODE_ITEM_STATUS                                
                       ,CODE_SOURCE_ID                                  
                       ,MTHLY_AMOUNT_FIXED                              
                       ,DIST_NO                                         
                       ,LIGHT_NO                                        
                       ,POLE_NO                                         
                  FROM  CSS_UM_CNSMPT_HIST UC WITH(READUNCOMMITTED)             
                 WHERE  ACCOUNT_NO         = :UC-ACCOUNT-NO             
                   AND  BILL_NO            = :UC-BILL-NO                
                   AND  CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE         
                   AND  IC_NO              = :UC-IC-NO                  
                   AND  BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UC-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT RATE_ITEM_CODE                                          
MFA-TR*                ,ITEM_SEQ_NO                                             
MFA-TR*                ,NO_UNITS                                                
MFA-TR*                ,NO_DAYS                                                 
MFA-TR*                ,CODE_DEBIT_CREDIT                                       
MFA-TR*                ,USAGE_FIXED                                             
MFA-TR*                ,DATE_USAGE_ENDS                                         
MFA-TR*                ,CODE_SERVICE_TYPE                                       
MFA-TR*                ,CODE_ITEM_STATUS                                        
MFA-TR*                ,CODE_SOURCE_ID                                          
MFA-TR*                ,MTHLY_AMOUNT_FIXED                                      
MFA-TR*                ,DIST_NO                                                 
MFA-TR*                ,LIGHT_NO                                                
MFA-TR*                ,POLE_NO                                                 
MFA-TR*           FROM  CSS_UM_CNSMPT_HIST UC                                   
MFA-TR*          WHERE  ACCOUNT_NO         = :UC-ACCOUNT-NO                     
MFA-TR*            AND  BILL_NO            = :UC-BILL-NO                        
MFA-TR*            AND  CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE                 
MFA-TR*            AND  IC_NO              = :UC-IC-NO                          
MFA-TR*            AND  BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  RETRIEVES FACTOR DETAILS FOR THE INPUT BILLING KEY FROM FCTR**        
      **  HIST TABLE.                                                 **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE FH-CURSOR CURSOR FOR                              
                 SELECT FH.EFF_DATE_FROM                                
                       ,FH.EFF_DATE_TO                                  
                       ,FH.FACTOR                                       
                       ,FH.CODE_SEASON                                  
                       ,FH.INSTR_USE_TYPE_CD                            
                       ,FH.CODE_TIME_PERIOD                             
                       ,FH.CMPNT_ID_CD                                  
                       ,FH.FIXED_FCTR_TYP_CD                            
                       ,FH.FIXED_FCTR_SEQ_NO                            
                       ,FH.DURATION_REMAIN_NO                           
                       ,FH.RT_PKG_OPT_SEQ_NO                            
                       ,FH.BLOCK_NO                                     
                       ,FH.FCTR_POWER_10                                
                       ,FH.CODE_DEBIT_CREDIT                            
                       ,FH.FACTOR_ID                                    
                   FROM CSS_FIXED_FCT_HIST  FH WITH(READUNCOMMITTED)            
                       ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)            
                  WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO          
                    AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE      
                    AND FH.IC_NO              = :FH-IC-NO               
                    AND FH.BILL_NO            = :FH-BILL-NO             
                    AND FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )  
                    AND FH.FACTOR_ID          = SF.FACTOR_ID            
                    AND SF.FACTOR_TYPE       <> :WS-ACTIVE              
                    AND SF.RATE_ELEC_FCTR    <> :WS-ELEC-FCTR           
                    AND SF.RATE_GAS_FCTR     <> :WS-GAS-FCTR            
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FH-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT FH.EFF_DATE_FROM                                        
MFA-TR*                ,FH.EFF_DATE_TO                                          
MFA-TR*                ,FH.FACTOR                                               
MFA-TR*                ,FH.CODE_SEASON                                          
MFA-TR*                ,FH.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,FH.CODE_TIME_PERIOD                                     
MFA-TR*                ,FH.CMPNT_ID_CD                                          
MFA-TR*                ,FH.FIXED_FCTR_TYP_CD                                    
MFA-TR*                ,FH.FIXED_FCTR_SEQ_NO                                    
MFA-TR*                ,FH.DURATION_REMAIN_NO                                   
MFA-TR*                ,FH.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,FH.BLOCK_NO                                             
MFA-TR*                ,FH.FCTR_POWER_10                                        
MFA-TR*                ,FH.CODE_DEBIT_CREDIT                                    
MFA-TR*                ,FH.FACTOR_ID                                            
MFA-TR*            FROM CSS_FIXED_FCT_HIST  FH                                  
MFA-TR*                ,CSS_SPCL_FCTR       SF                                  
MFA-TR*           WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                  
MFA-TR*             AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE              
MFA-TR*             AND FH.IC_NO              = :FH-IC-NO                       
MFA-TR*             AND FH.BILL_NO            = :FH-BILL-NO                     
MFA-TR*             AND FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP          
MFA-TR*             AND FH.FACTOR_ID          = SF.FACTOR_ID                    
MFA-TR*             AND SF.FACTOR_TYPE       = :WS-ACTIVE                      
MFA-TR*             AND SF.RATE_ELEC_FCTR    = :WS-ELEC-FCTR                   
MFA-TR*             AND SF.RATE_GAS_FCTR     = :WS-GAS-FCTR                    
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7190                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  RETRIEVES METER NUMBER DETAILS FROM METERD ENVRNMENT TABLE  **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE MT-CURSOR CURSOR FOR                              
                 SELECT                                                 
                   MN.CODE_UTIL_TYPE + MN.CODE_USAGE_TYPE + CAST(
           MN.CODE_TIME_PERIOD AS VARCHAR(MAX)) + 
           MN.CODE_USAGE_ID    AS CODE_USAGE_VAL          
                       ,MN.METER_NO                                     
                       ,MN.MTR_REF_NO                                   
                       ,MN.REG_ID_NO                                    
                       ,MN.CODE_METER_STATUS                            
                       ,MN.LAST_REG_READ_DATE                           
                       ,MN.LAST_READ_VALUE                              
                       ,MN.MIN_NO_UNITS                                 
                       ,MN.MAX_NO_UNITS                                 
                       ,MN.CODE_USAGE_TYPE                              
                       ,MN.METER_PRESSURE                               
                       ,MC.CONSTANT                                     
                       ,MC.NO_READ_DIALS                                
                       ,MN.CODE_USAGE_SOURCE                            
                       ,MN.CODE_USAGE_TYPE                              
                       ,MN.CODE_TIME_PERIOD                             
                       ,MN.CODE_USAGE_ID                                
                       ,MN.DIGTL_MTR_TYPE                               
                       ,MN.MTR_READ_SOURCE_CD                           
                   FROM CSS_MTRD_ENVRNMT      MN WITH(READUNCOMMITTED)          
                       ,CSS_MTR_CAP           MC WITH(READUNCOMMITTED)          
                  WHERE MN.ACCOUNT_NO          = :MN-ACCOUNT-NO         
                    AND MN.CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE     
                    AND MN.IC_NO               = :MN-IC-NO              
                    AND MN.CODE_METER_STATUS  <> :WS-REMOVED            
                    AND MC.COMPANY_NO          = :MC-COMPANY-NO         
                    AND MN.METER_NO            = MC.METER_NO            
                    AND MN.REG_ID_NO           = MC.REG_ID_NO           
                    AND MN.CODE_UTIL_TYPE      = MC.CODE_UTIL_TYPE      
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MT-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT                                                         
MFA-TR*            CHAR(MN.CODE_UTIL_TYPE    CONCAT                             
MFA-TR*                 MN.CODE_USAGE_TYPE   CONCAT                             
MFA-TR*                 MN.CODE_TIME_PERIOD  CONCAT                             
MFA-TR*                 MN.CODE_USAGE_ID)    AS CODE_USAGE_VAL                  
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.MTR_REF_NO                                           
MFA-TR*                ,MN.REG_ID_NO                                            
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*                ,MN.LAST_REG_READ_DATE                                   
MFA-TR*                ,MN.LAST_READ_VALUE                                      
MFA-TR*                ,MN.MIN_NO_UNITS                                         
MFA-TR*                ,MN.MAX_NO_UNITS                                         
MFA-TR*                ,MN.CODE_USAGE_TYPE                                      
MFA-TR*                ,MN.METER_PRESSURE                                       
MFA-TR*                ,MC.CONSTANT                                             
MFA-TR*                ,MC.NO_READ_DIALS                                        
MFA-TR*                ,MN.CODE_USAGE_SOURCE                                    
MFA-TR*                ,MN.CODE_USAGE_TYPE                                      
MFA-TR*                ,MN.CODE_TIME_PERIOD                                     
MFA-TR*                ,MN.CODE_USAGE_ID                                        
MFA-TR*                ,MN.DIGTL_MTR_TYPE                                       
MFA-TR*                ,MN.MTR_READ_SOURCE_CD                                   
MFA-TR*            FROM CSS_MTRD_ENVRNMT      MN                                
MFA-TR*                ,CSS_MTR_CAP           MC                                
MFA-TR*           WHERE MN.ACCOUNT_NO          = :MN-ACCOUNT-NO                 
MFA-TR*             AND MN.CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE             
MFA-TR*             AND MN.IC_NO               = :MN-IC-NO                      
MFA-TR*             AND MN.CODE_METER_STATUS  <> :WS-REMOVED                    
MFA-TR*             AND MC.COMPANY_NO          = :MC-COMPANY-NO                 
MFA-TR*             AND MN.METER_NO            = MC.METER_NO                    
MFA-TR*             AND MN.REG_ID_NO           = MC.REG_ID_NO                   
MFA-TR*             AND MN.CODE_UTIL_TYPE      = MC.CODE_UTIL_TYPE              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  RETRIEVES UNMETER DETAILS FROM CUST PLAN TABLE              **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE UNMT-CURSOR CURSOR FOR                            
                 SELECT SUM(CP.NO_UNITS)                                
                       ,MAX(CP.USAGE_FIXED)                             
                       ,MAX(CP.MTHLY_AMOUNT_FIXED)                      
                       ,MAX(CP.ITEM_SEQ_NO)                             
                       ,CP.REMOVE_DATE                                  
                       ,CP.LAST_BILL_DATE                               
                       ,CP.CODE_SERVICE_TYPE                            
                       ,CP.CODE_PLAN_STATUS                             
                       ,CP.CODE_STAT_REASON                             
                       ,CP.RATE_ITEM_CODE                               
                   FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                  
                  WHERE CP.ACCOUNT_NO       = :CP-ACCOUNT-NO            
                    AND CP.CODE_UTIL_TYPE   = :CP-CODE-UTIL-TYPE        
                    AND CP.IC_NO            = :CP-IC-NO                 
                    AND (CP.REMOVE_DATE    >= IIF(TRY_CONVERT(DATE, 
                                             :WS-LAST-REV-MTH-MINUS-12M
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REV-MTH-MINUS-12M
              ) <> 0) OR (LEN(:WS-LAST-REV-MTH-MINUS-12M
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REV-MTH-MINUS-12M
              ), CONVERT(DATE, :WS-LAST-REV-MTH-MINUS-12M) )
                     OR  CP.REMOVE_DATE    IS NULL)                     
                  GROUP BY                                              
                        CP.CODE_SERVICE_TYPE                            
                       ,CP.CODE_PLAN_STATUS                             
                       ,CP.CODE_STAT_REASON                             
                       ,CP.RATE_ITEM_CODE                               
                       ,CP.LAST_BILL_DATE                               
                       ,CP.REMOVE_DATE                                  
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UNMT-CURSOR CURSOR FOR                                    
MFA-TR*          SELECT SUM(CP.NO_UNITS)                                        
MFA-TR*                ,MAX(CP.USAGE_FIXED)                                     
MFA-TR*                ,MAX(CP.MTHLY_AMOUNT_FIXED)                              
MFA-TR*                ,MAX(CP.ITEM_SEQ_NO)                                     
MFA-TR*                ,CP.REMOVE_DATE                                          
MFA-TR*                ,CP.LAST_BILL_DATE                                       
MFA-TR*                ,CP.CODE_SERVICE_TYPE                                    
MFA-TR*                ,CP.CODE_PLAN_STATUS                                     
MFA-TR*                ,CP.CODE_STAT_REASON                                     
MFA-TR*                ,CP.RATE_ITEM_CODE                                       
MFA-TR*            FROM CSS_CUST_PLAN CP                                        
MFA-TR*           WHERE CP.ACCOUNT_NO       = :CP-ACCOUNT-NO                    
MFA-TR*             AND CP.CODE_UTIL_TYPE   = :CP-CODE-UTIL-TYPE                
MFA-TR*             AND CP.IC_NO            = :CP-IC-NO                         
MFA-TR*             AND (CP.REMOVE_DATE    >= :WS-LAST-REV-MTH-MINUS-12M        
MFA-TR*              OR  CP.REMOVE_DATE    IS NULL)                             
MFA-TR*           GROUP BY                                                      
MFA-TR*                 CP.CODE_SERVICE_TYPE                                    
MFA-TR*                ,CP.CODE_PLAN_STATUS                                     
MFA-TR*                ,CP.CODE_STAT_REASON                                     
MFA-TR*                ,CP.RATE_ITEM_CODE                                       
MFA-TR*                ,CP.LAST_BILL_DATE                                       
MFA-TR*                ,CP.REMOVE_DATE                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  RETRIEVES BILL ADJUSTMENT DETAILS FROM BIIL_ADJUSTMENT TABLE**        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BP-CURSOR CURSOR FOR                              
                 SELECT BP.REVENUE_MONTH                                
                       ,BP.ADJ_TYPE_CD                                  
                       ,BP.ADJ_REASON_DESC                              
                       ,BP.OVRRIDE_RT_REV_MTH                           
                       ,BP.OVRRIDE_RT_BILL_DT                           
                       ,BP.OVRRIDE_RT_BILL_CY                           
                       ,BP.SPECIAL_PROCESS_CD                           
                   FROM CSS_BILL_ADJUSTMNT  BP WITH(READUNCOMMITTED)            
                  WHERE BP.ACCOUNT_NO         = :BP-ACCOUNT-NO          
                    AND BP.CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE      
                    AND BP.IC_NO              = :BP-IC-NO               
                    AND BP.BILL_NO            = :BP-BILL-NO             
                    AND BP.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )  
              ORDER BY BP.ADJ_TYPE_CD DESC                              
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BP-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT BP.REVENUE_MONTH                                        
MFA-TR*                ,BP.ADJ_TYPE_CD                                          
MFA-TR*                ,BP.ADJ_REASON_DESC                                      
MFA-TR*                ,BP.OVRRIDE_RT_REV_MTH                                   
MFA-TR*                ,BP.OVRRIDE_RT_BILL_DT                                   
MFA-TR*                ,BP.OVRRIDE_RT_BILL_CY                                   
MFA-TR*                ,BP.SPECIAL_PROCESS_CD                                   
MFA-TR*            FROM CSS_BILL_ADJUSTMNT  BP                                  
MFA-TR*           WHERE BP.ACCOUNT_NO         = :BP-ACCOUNT-NO                  
MFA-TR*             AND BP.CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE              
MFA-TR*             AND BP.IC_NO              = :BP-IC-NO                       
MFA-TR*             AND BP.BILL_NO            = :BP-BILL-NO                     
MFA-TR*             AND BP.BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP          
MFA-TR*       ORDER BY BP.ADJ_TYPE_CD DESC                                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  RETRIEVES REGISTER DETAILS FOR METERS PRESENT IN MN TABLE   **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE RR-CURSOR CURSOR FOR                              
                 SELECT                                                 
                   RR.CODE_UTIL_TYPE + RR.CODE_USAGE_TYPE + CAST(
           RR.CODE_TIME_PERIOD AS VARCHAR(MAX)) + 
           RR.CODE_USAGE_ID   AS CODE_USAGE_VAL           
                       ,RR.REG_ID_NO                                    
                       ,RR.MIN_NO_UNITS                                 
                       ,RR.MAX_NO_UNITS                                 
                       ,RR.LAST_REG_READ_DT                             
                       ,RR.LAST_READ_VALUE                              
                       ,MC.CONSTANT                                     
                       ,MC.NO_READ_DIALS                                
                       ,RR.CODE_USAGE_SOURCE                            
                       ,RR.CODE_USAGE_TYPE                              
                       ,RR.CODE_TIME_PERIOD                             
                       ,RR.CODE_USAGE_ID                                
P00899                 ,RR.CODE_REG_STATUS                              
                   FROM CSS_REGISTER_READ  RR WITH(READUNCOMMITTED)             
                       ,CSS_MTR_CAP           MC WITH(READUNCOMMITTED)          
                  WHERE RR.ACCOUNT_NO      = :MN-ACCOUNT-NO             
                    AND RR.CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE         
                    AND RR.IC_NO           = :MN-IC-NO                  
                    AND RR.MTR_REF_NO      = :MN-MTR-REF-NO             
                    AND RR.METER_NO        = :MN-METER-NO               
                    AND MC.COMPANY_NO      = :MC-COMPANY-NO             
                    AND RR.METER_NO        = MC.METER_NO                
                    AND RR.REG_ID_NO       = MC.REG_ID_NO               
                    AND RR.CODE_UTIL_TYPE  = MC.CODE_UTIL_TYPE          
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RR-CURSOR CURSOR FOR                                      
MFA-TR*          SELECT                                                         
MFA-TR*            CHAR(RR.CODE_UTIL_TYPE   CONCAT                              
MFA-TR*                 RR.CODE_USAGE_TYPE  CONCAT                              
MFA-TR*                 RR.CODE_TIME_PERIOD CONCAT                              
MFA-TR*                 RR.CODE_USAGE_ID)   AS CODE_USAGE_VAL                   
MFA-TR*                ,RR.REG_ID_NO                                            
MFA-TR*                ,RR.MIN_NO_UNITS                                         
MFA-TR*                ,RR.MAX_NO_UNITS                                         
MFA-TR*                ,RR.LAST_REG_READ_DT                                     
MFA-TR*                ,RR.LAST_READ_VALUE                                      
MFA-TR*                ,MC.CONSTANT                                             
MFA-TR*                ,MC.NO_READ_DIALS                                        
MFA-TR*                ,RR.CODE_USAGE_SOURCE                                    
MFA-TR*                ,RR.CODE_USAGE_TYPE                                      
MFA-TR*                ,RR.CODE_TIME_PERIOD                                     
MFA-TR*                ,RR.CODE_USAGE_ID                                        
MFA-TR*                ,RR.CODE_REG_STATUS                                      
MFA-TR*            FROM CSS_REGISTER_READ  RR                                   
MFA-TR*                ,CSS_MTR_CAP           MC                                
MFA-TR*           WHERE RR.ACCOUNT_NO      = :MN-ACCOUNT-NO                     
MFA-TR*             AND RR.CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                 
MFA-TR*             AND RR.IC_NO           = :MN-IC-NO                          
MFA-TR*             AND RR.MTR_REF_NO      = :MN-MTR-REF-NO                     
MFA-TR*             AND RR.METER_NO        = :MN-METER-NO                       
MFA-TR*             AND MC.COMPANY_NO      = :MC-COMPANY-NO                     
MFA-TR*             AND RR.METER_NO        = MC.METER_NO                        
MFA-TR*             AND RR.REG_ID_NO       = MC.REG_ID_NO                       
MFA-TR*             AND RR.CODE_UTIL_TYPE  = MC.CODE_UTIL_TYPE                  
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  RETRIEVES METER NUMBER DETAILS FROM CONSUMPTION HIST TABLE  **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE MTR-CURSOR CURSOR FOR                             
                 SELECT                                                 
                   CX.CODE_UTIL_TYPE + CX.CODE_USAGE_TYPE + CAST(
           CX.CODE_TIME_PERIOD AS VARCHAR(MAX)) + 
           CX.CODE_USAGE_ID    AS CODE_USAGE_VAL          
                       ,MAX(CX.PCOMP_FCT)                               
                       ,MAX(CX.CONSTANT)                                
                       ,MAX(CX.NO_DIALS)                                
                       ,CX.METER_NO                                     
                       ,CX.MTR_REF_NO                                   
                       ,CX.REG_ID_NO                                    
                       ,CX.CODE_TIME_PERIOD                             
                       ,CX.CODE_USAGE_TYPE                              
                   FROM CSS_CNSMPTN_HIST    CX WITH(READUNCOMMITTED)            
                  WHERE CX.ACCOUNT_NO       = :MN-ACCOUNT-NO            
                    AND CX.CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE        
                    AND CX.IC_NO            = :MN-IC-NO                 
                    AND CX.MTR_REF_NO       = :MN-MTR-REF-NO            
                    AND CX.METER_NO        <> :MN-METER-NO              
                    AND (CX.DATE_READ      >= IIF(TRY_CONVERT(DATE, 
                                             :WS-LAST-REV-MTH-MINUS-12M
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REV-MTH-MINUS-12M
              ) <> 0) OR (LEN(:WS-LAST-REV-MTH-MINUS-12M
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REV-MTH-MINUS-12M
              ), CONVERT(DATE, :WS-LAST-REV-MTH-MINUS-12M) )
                     OR  CX.DATE_READ      IS NULL)                     
                  GROUP BY                                              
                        CX.CODE_UTIL_TYPE                               
                       ,CX.CODE_USAGE_TYPE                              
                       ,CX.CODE_TIME_PERIOD                             
                       ,CX.CODE_USAGE_ID                                
                       ,CX.METER_NO                                     
                       ,CX.MTR_REF_NO                                   
                       ,CX.REG_ID_NO                                    
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MTR-CURSOR CURSOR FOR                                     
MFA-TR*          SELECT                                                         
MFA-TR*            CHAR(CX.CODE_UTIL_TYPE    CONCAT                             
MFA-TR*                 CX.CODE_USAGE_TYPE   CONCAT                             
MFA-TR*                 CX.CODE_TIME_PERIOD  CONCAT                             
MFA-TR*                 CX.CODE_USAGE_ID)    AS CODE_USAGE_VAL                  
MFA-TR*                ,MAX(CX.PCOMP_FCT)                                       
MFA-TR*                ,MAX(CX.CONSTANT)                                        
MFA-TR*                ,MAX(CX.NO_DIALS)                                        
MFA-TR*                ,CX.METER_NO                                             
MFA-TR*                ,CX.MTR_REF_NO                                           
MFA-TR*                ,CX.REG_ID_NO                                            
MFA-TR*                ,CX.CODE_TIME_PERIOD                                     
MFA-TR*                ,CX.CODE_USAGE_TYPE                                      
MFA-TR*            FROM CSS_CNSMPTN_HIST    CX                                  
MFA-TR*           WHERE CX.ACCOUNT_NO       = :MN-ACCOUNT-NO                    
MFA-TR*             AND CX.CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE                
MFA-TR*             AND CX.IC_NO            = :MN-IC-NO                         
MFA-TR*             AND CX.MTR_REF_NO       = :MN-MTR-REF-NO                    
MFA-TR*             AND CX.METER_NO        <> :MN-METER-NO                      
MFA-TR*             AND (CX.DATE_READ      >= :WS-LAST-REV-MTH-MINUS-12M        
MFA-TR*              OR  CX.DATE_READ      IS NULL)                             
MFA-TR*           GROUP BY                                                      
MFA-TR*                 CX.CODE_UTIL_TYPE                                       
MFA-TR*                ,CX.CODE_USAGE_TYPE                                      
MFA-TR*                ,CX.CODE_TIME_PERIOD                                     
MFA-TR*                ,CX.CODE_USAGE_ID                                        
MFA-TR*                ,CX.METER_NO                                             
MFA-TR*                ,CX.MTR_REF_NO                                           
MFA-TR*                ,CX.REG_ID_NO                                            
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7340                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 PARM-APPL-CODE                    PIC X(01) VALUE SPACES.     
       01 PARM-ACCOUNT-NO                   PIC S9(13)V                 
                                                      VALUE 0 COMP-3.   
       01 PARM-UTIL-TYPE                    PIC X(01) VALUE SPACES.     
       01 PARM-IC-NO                        PIC S9(4) VALUE 0 COMP.     
       01 PARM-BILL-NO                      PIC S9(9) VALUE 0 COMP.     
       01 PARM-BILL-ITEM-TS                 PIC X(26) VALUE SPACES.     
       01 PARM-REVENUE-MONTH                PIC X(06) VALUE SPACES.     
       01 PARM-WQ-ITEM-ID                   PIC S9(10)V                 
                                                      VALUE 0 COMP-3.   
                                                                        
       PROCEDURE DIVISION USING PARM-APPL-CODE                          
                                PARM-ACCOUNT-NO                         
                                PARM-UTIL-TYPE                          
                                PARM-IC-NO                              
                                PARM-BILL-NO                            
                                PARM-BILL-ITEM-TS                       
                                PARM-REVENUE-MONTH                      
                                PARM-WQ-ITEM-ID.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1   -  BILLING DETAILS                               
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)               
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,BILL_NO                 INT                     
                   ,BILL_ITEM_TIMESTMP CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILLING_KEY             SMALLINT                    
                   ,DATE_ORIG_BILL CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REVENUE_MONTH           DECIMAL(06,0)               
                   ,REV_MTH_ORIG_BILL       DECIMAL(06,0)               
                   ,REBILL_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2              
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPT_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TRANS_AMT               DECIMAL(11,2)               
                   ,BILL_CALC_CODE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_BILL_ITM_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TRANS_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DR_CR CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
                   ,STATE_TAX               DECIMAL(09,2)               
                   ,CITY_TAX                DECIMAL(09,2)               
                   ,OTHER_TAX               DECIMAL(09,2)               
                   ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_SIC_NO CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_CURTAIL_PRTY       DECIMAL(03,1)               
                   ,STATE_XMT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CITY_XMT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OTHER_XMT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,REV_RPT_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,STANDBY_COMPLIED CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRORATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,NEW_RATE_PCT            DECIMAL(04,4)               
                   ,TAX_REFUND_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DATE_LFTM_HI_DMD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LFTM_HI_PEAK_DMD        DECIMAL(07,0)               
                   ,ADJ_REASON CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,GAS_BASE_USE            INT                     
                   ,WNA_FACTOR              DECIMAL(07,5)               
                   ,BTU_FACTOR              DECIMAL(07,5)               
                   ,NO_OF_CONS_DAYS         SMALLINT                    
                   ,NO_CONSEC_ESTIMATE      SMALLINT                    
                   ,SHIPPER CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,TRNSP_OVER_MDQ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILL_CORRECTED_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RT_PKG_OPT_SEQ_NO       SMALLINT                    
                   ,HRLY_REGISTER CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CIG_CUSTOMER CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILLED_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_BILL_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))     AS 
           CODE_UTIL_TYPE      
                      ,IC_NO                                            
                      ,BILL_NO                                          
                      ,LTRIM(RTRIM(BILL_ITEM_TIMESTMP)) AS 
           BILL_ITEM_TIMESTMP  
                      ,BILLING_KEY                                      
                      ,LTRIM(RTRIM(DATE_ORIG_BILL))     AS 
           DATE_ORIG_BILL      
                      ,REVENUE_MONTH                                    
                      ,REV_MTH_ORIG_BILL                                
                      ,LTRIM(RTRIM(REBILL_IND))         AS REBILL_IND          
                      ,LTRIM(RTRIM(RATE))               AS RATE                
                      ,LTRIM(RTRIM(OPTION_CD))          AS OPTION_CD           
                      ,LTRIM(RTRIM(OPT_DESC_INT))       AS OPT_DESC_INT        
                      ,TRANS_AMT                                        
                      ,LTRIM(RTRIM(BILL_CALC_CODE))     AS 
           BILL_CALC_CODE      
                      ,LTRIM(RTRIM(CODE_BILL_ITM_TYPE)) AS 
           CODE_BILL_ITM_TYPE  
                      ,LTRIM(RTRIM(TRANS_STATUS))       AS TRANS_STATUS        
                      ,LTRIM(RTRIM(DR_CR))              AS DR_CR               
                      ,STATE_TAX                                        
                      ,CITY_TAX                                         
                      ,OTHER_TAX                                        
                      ,LTRIM(RTRIM(CODE_REVENUE_CLASS)) AS 
           CODE_REVENUE_CLASS  
                      ,LTRIM(RTRIM(CODE_SIC_NO))        AS CODE_SIC_NO         
                      ,CODE_CURTAIL_PRTY                                
                      ,LTRIM(RTRIM(STATE_XMT))          AS STATE_XMT           
                      ,LTRIM(RTRIM(CITY_XMT))           AS CITY_XMT            
                      ,LTRIM(RTRIM(OTHER_XMT))          AS OTHER_XMT           
                      ,LTRIM(RTRIM(REV_RPT_CD))         AS REV_RPT_CD          
                      ,LTRIM(RTRIM(STANDBY_COMPLIED))   AS 
           STANDBY_COMPLIED    
                      ,LTRIM(RTRIM(PRORATE_CD))         AS PRORATE_CD          
                      ,NEW_RATE_PCT                                     
                      ,LTRIM(RTRIM(TAX_REFUND_CD))      AS TAX_REFUND_CD       
                      ,LTRIM(RTRIM(DATE_LFTM_HI_DMD))   AS 
           DATE_LFTM_HI_DMD    
                      ,LFTM_HI_PEAK_DMD                                 
                      ,LTRIM(RTRIM(ADJ_REASON))         AS ADJ_REASON          
                      ,GAS_BASE_USE                                     
                      ,WNA_FACTOR                                       
                      ,BTU_FACTOR                                       
                      ,NO_OF_CONS_DAYS                                  
                      ,NO_CONSEC_ESTIMATE                               
                      ,LTRIM(RTRIM(SHIPPER))            AS SHIPPER             
                      ,LTRIM(RTRIM(TRNSP_OVER_MDQ))     AS 
           TRNSP_OVER_MDQ      
                      ,LTRIM(RTRIM(BILL_CORRECTED_CD))  AS 
           BILL_CORRECTED_CD   
                      ,RT_PKG_OPT_SEQ_NO                                
                      ,LTRIM(RTRIM(HRLY_REGISTER))      AS HRLY_REGISTER       
                      ,LTRIM(RTRIM(CIG_CUSTOMER)) AS CIG_CUSTOMER        
                      ,LTRIM(RTRIM(BILLED_DATE)) AS BILLED_DATE         
                      ,LTRIM(RTRIM(CODE_BILL_STATUS)) AS 
           CODE_BILL_STATUS    
                  FROM #CSR04870_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)     AS CODE_UTIL_TYPE              
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,STRIP(BILL_ITEM_TIMESTMP) AS BILL_ITEM_TIMESTMP          
MFA-TR*               ,BILLING_KEY                                              
MFA-TR*               ,STRIP(DATE_ORIG_BILL)     AS DATE_ORIG_BILL              
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,REV_MTH_ORIG_BILL                                        
MFA-TR*               ,STRIP(REBILL_IND)         AS REBILL_IND                  
MFA-TR*               ,STRIP(RATE)               AS RATE                        
MFA-TR*               ,STRIP(OPTION_CD)          AS OPTION_CD                   
MFA-TR*               ,STRIP(OPT_DESC_INT)       AS OPT_DESC_INT                
MFA-TR*               ,TRANS_AMT                                                
MFA-TR*               ,STRIP(BILL_CALC_CODE)     AS BILL_CALC_CODE              
MFA-TR*               ,STRIP(CODE_BILL_ITM_TYPE) AS CODE_BILL_ITM_TYPE          
MFA-TR*               ,STRIP(TRANS_STATUS)       AS TRANS_STATUS                
MFA-TR*               ,STRIP(DR_CR)              AS DR_CR                       
MFA-TR*               ,STATE_TAX                                                
MFA-TR*               ,CITY_TAX                                                 
MFA-TR*               ,OTHER_TAX                                                
MFA-TR*               ,STRIP(CODE_REVENUE_CLASS) AS CODE_REVENUE_CLASS          
MFA-TR*               ,STRIP(CODE_SIC_NO)        AS CODE_SIC_NO                 
MFA-TR*               ,CODE_CURTAIL_PRTY                                        
MFA-TR*               ,STRIP(STATE_XMT)          AS STATE_XMT                   
MFA-TR*               ,STRIP(CITY_XMT)           AS CITY_XMT                    
MFA-TR*               ,STRIP(OTHER_XMT)          AS OTHER_XMT                   
MFA-TR*               ,STRIP(REV_RPT_CD)         AS REV_RPT_CD                  
MFA-TR*               ,STRIP(STANDBY_COMPLIED)   AS STANDBY_COMPLIED            
MFA-TR*               ,STRIP(PRORATE_CD)         AS PRORATE_CD                  
MFA-TR*               ,NEW_RATE_PCT                                             
MFA-TR*               ,STRIP(TAX_REFUND_CD)      AS TAX_REFUND_CD               
MFA-TR*               ,STRIP(DATE_LFTM_HI_DMD)   AS DATE_LFTM_HI_DMD            
MFA-TR*               ,LFTM_HI_PEAK_DMD                                         
MFA-TR*               ,STRIP(ADJ_REASON)         AS ADJ_REASON                  
MFA-TR*               ,GAS_BASE_USE                                             
MFA-TR*               ,WNA_FACTOR                                               
MFA-TR*               ,BTU_FACTOR                                               
MFA-TR*               ,NO_OF_CONS_DAYS                                          
MFA-TR*               ,NO_CONSEC_ESTIMATE                                       
MFA-TR*               ,STRIP(SHIPPER)            AS SHIPPER                     
MFA-TR*               ,STRIP(TRNSP_OVER_MDQ)     AS TRNSP_OVER_MDQ              
MFA-TR*               ,STRIP(BILL_CORRECTED_CD)  AS BILL_CORRECTED_CD           
MFA-TR*               ,RT_PKG_OPT_SEQ_NO                                        
MFA-TR*               ,STRIP(HRLY_REGISTER)      AS HRLY_REGISTER               
MFA-TR*               ,STRIP(CIG_CUSTOMER      ) AS CIG_CUSTOMER                
MFA-TR*               ,STRIP(BILLED_DATE       ) AS BILLED_DATE                 
MFA-TR*               ,STRIP(CODE_BILL_STATUS  ) AS CODE_BILL_STATUS            
MFA-TR*           FROM SESSION.CSR04870_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - BILLING CONSUMPTION DETAILS                      
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,BILLING_KEY             SMALLINT                    
                   ,CODE_TIME_PERIOD        SMALLINT                    
                   ,MTR_REF_NO              SMALLINT                    
                   ,CODE_USAGE_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_USAGE_ID CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,REG_ID_NO               SMALLINT                    
                   ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_METER_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_METER_NO_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_READING           DECIMAL(11,3)               
                   ,NO_UNITS                DECIMAL(09,0)               
                   ,USAGE                   DECIMAL(12,3)               
                   ,NO_DAYS                 SMALLINT                    
                   ,CODE_SOURCE_ID CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_DEBIT_CREDIT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_ITEM_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CONSTANT                DECIMAL(11,5)               
                   ,NO_DIALS                SMALLINT                    
                   ,EXCEPT_OVERRIDE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REQUESTED_USAGE         INT                     
                   ,DIGTL_INTRL_MTR_NO CHAR(18)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DIGTL_MTR_TYPE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_TOU_SEASN CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EXCL_DMD_RCHT_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MTR_READ_SOURCE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PCOMP_FCT               DECIMAL(07,5)               
                   ,CODE_USAGE_VALS CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MIN_NO_UNITS            DECIMAL(09,0)               
                   ,MAX_NO_UNITS            DECIMAL(09,0)               
                   ,LATEST_ROW CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,WQ_CNSMPTN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,WQ_NO_READ_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BILLING_KEY                                      
                      ,CODE_TIME_PERIOD                                 
                      ,MTR_REF_NO                                       
                      ,LTRIM(RTRIM(CODE_USAGE_TYPE))     AS 
           CODE_USAGE_TYPE    
                      ,LTRIM(RTRIM(CODE_USAGE_ID))       AS 
           CODE_USAGE_ID      
                      ,LTRIM(RTRIM(CODE_USAGE_SOURCE))   AS 
           CODE_USAGE_SOURCE  
                      ,ITEM_SEQ_NO                                      
                      ,LTRIM(RTRIM(METER_NO))            AS METER_NO           
                      ,REG_ID_NO                                        
                      ,LTRIM(RTRIM(DATE_READ))           AS DATE_READ          
                      ,LTRIM(RTRIM(CODE_METER_READ))     AS 
           CODE_METER_READ    
                      ,LTRIM(RTRIM(CODE_METER_NO_READ))  AS 
           CODE_METER_NO_READ 
                      ,METER_READING                                    
                      ,NO_UNITS                                         
                      ,USAGE                                            
                      ,NO_DAYS                                          
                      ,LTRIM(RTRIM(CODE_SOURCE_ID))      AS 
           CODE_SOURCE_ID     
                      ,LTRIM(RTRIM(CODE_DEBIT_CREDIT))   AS 
           CODE_DEBIT_CREDIT  
                      ,LTRIM(RTRIM(CODE_ITEM_STATUS))    AS 
           CODE_ITEM_STATUS   
                      ,CONSTANT                                         
                      ,NO_DIALS                                         
                      ,LTRIM(RTRIM(EXCEPT_OVERRIDE_CD))  AS 
           EXCEPT_OVERRIDE_CD 
                      ,REQUESTED_USAGE                                  
                      ,LTRIM(RTRIM(DIGTL_INTRL_MTR_NO))  AS 
           DIGTL_INTRL_MTR_NO 
                      ,LTRIM(RTRIM(DIGTL_MTR_TYPE))      AS 
           DIGTL_MTR_TYPE     
                      ,LTRIM(RTRIM(CODE_TOU_SEASN))      AS 
           CODE_TOU_SEASN     
                      ,LTRIM(RTRIM(EXCL_DMD_RCHT_IND))   AS 
           EXCL_DMD_RCHT_IND  
                      ,LTRIM(RTRIM(MTR_READ_SOURCE_CD))  AS 
           MTR_READ_SOURCE_CD 
                      ,PCOMP_FCT                                        
                      ,LTRIM(RTRIM(CODE_USAGE_VALS))     AS 
           CODE_USAGE_VALS    
                      ,MIN_NO_UNITS                                     
                      ,MAX_NO_UNITS                                     
                      ,LTRIM(RTRIM(LATEST_ROW))          AS LATEST_ROW         
                      ,LTRIM(RTRIM(WQ_CNSMPTN))          AS WQ_CNSMPTN         
                      ,LTRIM(RTRIM(WQ_NO_READ_CD))       AS 
           WQ_NO_READ_CD      
                  FROM #CSR04870_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BILLING_KEY                                              
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,MTR_REF_NO                                               
MFA-TR*               ,STRIP(CODE_USAGE_TYPE)     AS CODE_USAGE_TYPE            
MFA-TR*               ,STRIP(CODE_USAGE_ID)       AS CODE_USAGE_ID              
MFA-TR*               ,STRIP(CODE_USAGE_SOURCE)   AS CODE_USAGE_SOURCE          
MFA-TR*               ,ITEM_SEQ_NO                                              
MFA-TR*               ,STRIP(METER_NO)            AS METER_NO                   
MFA-TR*               ,REG_ID_NO                                                
MFA-TR*               ,STRIP(DATE_READ)           AS DATE_READ                  
MFA-TR*               ,STRIP(CODE_METER_READ)     AS CODE_METER_READ            
MFA-TR*               ,STRIP(CODE_METER_NO_READ)  AS CODE_METER_NO_READ         
MFA-TR*               ,METER_READING                                            
MFA-TR*               ,NO_UNITS                                                 
MFA-TR*               ,USAGE                                                    
MFA-TR*               ,NO_DAYS                                                  
MFA-TR*               ,STRIP(CODE_SOURCE_ID)      AS CODE_SOURCE_ID             
MFA-TR*               ,STRIP(CODE_DEBIT_CREDIT)   AS CODE_DEBIT_CREDIT          
MFA-TR*               ,STRIP(CODE_ITEM_STATUS)    AS CODE_ITEM_STATUS           
MFA-TR*               ,CONSTANT                                                 
MFA-TR*               ,NO_DIALS                                                 
MFA-TR*               ,STRIP(EXCEPT_OVERRIDE_CD)  AS EXCEPT_OVERRIDE_CD         
MFA-TR*               ,REQUESTED_USAGE                                          
MFA-TR*               ,STRIP(DIGTL_INTRL_MTR_NO)  AS DIGTL_INTRL_MTR_NO         
MFA-TR*               ,STRIP(DIGTL_MTR_TYPE)      AS DIGTL_MTR_TYPE             
MFA-TR*               ,STRIP(CODE_TOU_SEASN)      AS CODE_TOU_SEASN             
MFA-TR*               ,STRIP(EXCL_DMD_RCHT_IND)   AS EXCL_DMD_RCHT_IND          
MFA-TR*               ,STRIP(MTR_READ_SOURCE_CD)  AS MTR_READ_SOURCE_CD         
MFA-TR*               ,PCOMP_FCT                                                
MFA-TR*               ,STRIP(CODE_USAGE_VALS)     AS CODE_USAGE_VALS            
MFA-TR*               ,MIN_NO_UNITS                                             
MFA-TR*               ,MAX_NO_UNITS                                             
MFA-TR*               ,STRIP(LATEST_ROW)          AS LATEST_ROW                 
MFA-TR*               ,STRIP(WQ_CNSMPTN)          AS WQ_CNSMPTN                 
MFA-TR*               ,STRIP(WQ_NO_READ_CD)       AS WQ_NO_READ_CD              
MFA-TR*           FROM SESSION.CSR04870_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3  -  BILLING FACTOR DETAILS                         
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,BILLING_KEY             SMALLINT                    
                   ,FACT_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
A05460             ,FACTOR                  DECIMAL(15,6)               
                   ,EFF_DATE_FROM CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EFF_DATE_TO CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_SEASON CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INSTR_USE_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_TIME_PERIOD        SMALLINT                    
                   ,CMPNT_ID_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXED_FCTR_TYP_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXED_FCTR_SEQ_NO       SMALLINT                    
                   ,DURATION_REMAIN_NO CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BLOCK_NO                SMALLINT                    
                   ,ALLOWED_BLOCKS          SMALLINT                    
                   ,FACTOR_POWER            SMALLINT                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS       THRU 8000C-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BILLING_KEY                                      
                      ,LTRIM(RTRIM(FACT_ID))  AS FACT_ID            
                      ,FACTOR                                           
                      ,LTRIM(RTRIM(EFF_DATE_FROM))  AS EFF_DATE_FROM      
                      ,LTRIM(RTRIM(EFF_DATE_TO))  AS EFF_DATE_TO        
                      ,LTRIM(RTRIM(CODE_SEASON))  AS CODE_SEASON        
                      ,LTRIM(RTRIM(INSTR_USE_TYPE_CD))  AS 
           INSTR_USE_TYPE_CD  
                      ,CODE_TIME_PERIOD                                 
                      ,LTRIM(RTRIM(CMPNT_ID_CD))  AS CMPNT_ID_CD        
                      ,LTRIM(RTRIM(FIXED_FCTR_TYP_CD))  AS 
           FIXED_FCTR_TYP_CD  
                      ,FIXED_FCTR_SEQ_NO                                
                      ,LTRIM(RTRIM(DURATION_REMAIN_NO))  AS 
           DURATION_REMAIN_NO 
                      ,BLOCK_NO                                         
                      ,ALLOWED_BLOCKS                                   
                      ,FACTOR_POWER                                     
                 FROM #CSR04870_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BILLING_KEY                                              
MFA-TR*               ,STRIP(FACT_ID           )  AS FACT_ID                    
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,STRIP(EFF_DATE_FROM     )  AS EFF_DATE_FROM              
MFA-TR*               ,STRIP(EFF_DATE_TO       )  AS EFF_DATE_TO                
MFA-TR*               ,STRIP(CODE_SEASON       )  AS CODE_SEASON                
MFA-TR*               ,STRIP(INSTR_USE_TYPE_CD )  AS INSTR_USE_TYPE_CD          
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,STRIP(CMPNT_ID_CD       )  AS CMPNT_ID_CD                
MFA-TR*               ,STRIP(FIXED_FCTR_TYP_CD )  AS FIXED_FCTR_TYP_CD          
MFA-TR*               ,FIXED_FCTR_SEQ_NO                                        
MFA-TR*               ,STRIP(DURATION_REMAIN_NO)  AS DURATION_REMAIN_NO         
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*               ,ALLOWED_BLOCKS                                           
MFA-TR*               ,FACTOR_POWER                                             
MFA-TR*          FROM SESSION.CSR04870_R3                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100D-DECLARE-GTT-R4  -  COMMON BUSINESS RULE DETAILS                   
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS       THRU 8000D-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,LTRIM(RTRIM(BUS_RULE_ID))         AS BUS_RULE_ID        
                      ,LTRIM(RTRIM(BUS_RESULT_CD))       AS 
           BUS_RESULT_CD      
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))    AS 
           BUS_RULE_XREF_ID   
                 FROM #CSR04870_R4                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,STRIP(BUS_RULE_ID)         AS BUS_RULE_ID                
MFA-TR*               ,STRIP(BUS_RESULT_CD)       AS BUS_RESULT_CD              
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)    AS BUS_RULE_XREF_ID           
MFA-TR*          FROM SESSION.CSR04870_R4                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100E-DECLARE-GTT-R5  -  ACCOUNT LEVEL DETAILS                          
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R5'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R5
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)               
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCT_FINALED_DT CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MIN_PRORATION_DAYS      SMALLINT                    
                   ,MAX_PRORATION_DAYS      SMALLINT                    
                   ,EXEMPT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,DATE_EXTRACT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MST_ACCT_BILLED CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMMON_REVENUE_MONTH    DECIMAL(06,0)               
                   ,MV90_MTR_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS       THRU 8000E-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))      AS 
           CODE_UTIL_TYPE     
                      ,IC_NO                                            
                      ,LTRIM(RTRIM(COMPANY_NO))  AS COMPANY_NO         
                      ,LTRIM(RTRIM(AT_LAST_UPDATE_TS))  AS 
           AT_LAST_UPDATE_TS  
                      ,LTRIM(RTRIM(ACCT_FINALED_DT))  AS ACCT_FINALED_DT    
                      ,MIN_PRORATION_DAYS                               
                      ,MAX_PRORATION_DAYS                               
                      ,LTRIM(RTRIM(EXEMPT_FL))  AS EXEMPT_FL          
                      ,LTRIM(RTRIM(DATE_EXTRACT))  AS DATE_EXTRACT       
                      ,LTRIM(RTRIM(MST_ACCT_BILLED))  AS MST_ACCT_BILLED    
                      ,COMMON_REVENUE_MONTH                             
                      ,LTRIM(RTRIM(MV90_MTR_IND))  AS MV90_MTR_IND       
                 FROM #CSR04870_R5                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)      AS CODE_UTIL_TYPE             
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,STRIP(COMPANY_NO        )  AS COMPANY_NO                 
MFA-TR*               ,STRIP(AT_LAST_UPDATE_TS )  AS AT_LAST_UPDATE_TS          
MFA-TR*               ,STRIP(ACCT_FINALED_DT   )  AS ACCT_FINALED_DT            
MFA-TR*               ,MIN_PRORATION_DAYS                                       
MFA-TR*               ,MAX_PRORATION_DAYS                                       
MFA-TR*               ,STRIP(EXEMPT_FL         )  AS EXEMPT_FL                  
MFA-TR*               ,STRIP(DATE_EXTRACT      )  AS DATE_EXTRACT               
MFA-TR*               ,STRIP(MST_ACCT_BILLED   )  AS MST_ACCT_BILLED            
MFA-TR*               ,COMMON_REVENUE_MONTH                                     
MFA-TR*               ,STRIP(MV90_MTR_IND      )  AS MV90_MTR_IND               
MFA-TR*          FROM SESSION.CSR04870_R5                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100E-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100F-DECLARE-GTT-R6 - BILLING CONSUMPTION DETAILS-UNMETERED            
      ******************************************************************        
       0100F-DECLARE-GTT-R6.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R6'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R6
              (                                                       
                    RETURN_CODE             INT                     
                   ,BILLING_KEY             SMALLINT                    
                   ,UM_DESCRIPTION CHAR(17)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_RATE_ITEM_CODE       SMALLINT                    
                   ,UM_ITEM_SEQ_NO          SMALLINT                    
                   ,UM_NO_UNITS             INT                     
                   ,UM_NO_DAYS              SMALLINT                    
                   ,UM_CDE_DEBIT_CREDT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_USAGE_FIXED          DECIMAL(09,0)               
                   ,UM_DATE_USAGE_ENDS CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_CDE_ITEM_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_CODE_SOURCE_ID CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_MTHLY_AMOUNT_FIXED   DECIMAL(11,2)               
                   ,UM_DIST_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,UM_LIGHT_NO             SMALLINT                    
                   ,UM_POLE_NO CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000F-DEL-GTT-ROWS       THRU 8000F-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100F'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C6 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BILLING_KEY                                      
                      ,LTRIM(RTRIM(UM_DESCRIPTION))      AS 
           UM_DESCRIPTION     
                      ,UM_RATE_ITEM_CODE                                
                      ,UM_ITEM_SEQ_NO                                   
                      ,UM_NO_UNITS                                      
                      ,UM_NO_DAYS                                       
                      ,LTRIM(RTRIM(UM_CDE_DEBIT_CREDT))  AS 
           UM_CDE_DEBIT_CREDT 
                      ,UM_USAGE_FIXED                                   
                      ,LTRIM(RTRIM(UM_DATE_USAGE_ENDS))  AS 
           UM_DATE_USAGE_ENDS 
                      ,LTRIM(RTRIM(UM_CODE_SERVICE_TYPE))                      
                                                 AS UM_CODE_SERVICE_TYPE
                      ,LTRIM(RTRIM(UM_CDE_ITEM_STATUS))  AS 
           UM_CDE_ITEM_STATUS 
                      ,LTRIM(RTRIM(UM_CODE_SOURCE_ID))   AS 
           UM_CODE_SOURCE_ID  
                      ,UM_MTHLY_AMOUNT_FIXED                            
                      ,LTRIM(RTRIM(UM_DIST_NO))          AS UM_DIST_NO         
                      ,UM_LIGHT_NO                                      
                      ,LTRIM(RTRIM(UM_POLE_NO))          AS UM_POLE_NO         
                  FROM #CSR04870_R6                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BILLING_KEY                                              
MFA-TR*               ,STRIP(UM_DESCRIPTION)      AS UM_DESCRIPTION             
MFA-TR*               ,UM_RATE_ITEM_CODE                                        
MFA-TR*               ,UM_ITEM_SEQ_NO                                           
MFA-TR*               ,UM_NO_UNITS                                              
MFA-TR*               ,UM_NO_DAYS                                               
MFA-TR*               ,STRIP(UM_CDE_DEBIT_CREDT)  AS UM_CDE_DEBIT_CREDT         
MFA-TR*               ,UM_USAGE_FIXED                                           
MFA-TR*               ,STRIP(UM_DATE_USAGE_ENDS)  AS UM_DATE_USAGE_ENDS         
MFA-TR*               ,STRIP(UM_CODE_SERVICE_TYPE)                              
MFA-TR*                                          AS UM_CODE_SERVICE_TYPE        
MFA-TR*               ,STRIP(UM_CDE_ITEM_STATUS)  AS UM_CDE_ITEM_STATUS         
MFA-TR*               ,STRIP(UM_CODE_SOURCE_ID)   AS UM_CODE_SOURCE_ID          
MFA-TR*               ,UM_MTHLY_AMOUNT_FIXED                                    
MFA-TR*               ,STRIP(UM_DIST_NO)          AS UM_DIST_NO                 
MFA-TR*               ,UM_LIGHT_NO                                              
MFA-TR*               ,STRIP(UM_POLE_NO)          AS UM_POLE_NO                 
MFA-TR*           FROM SESSION.CSR04870_R6                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100F-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100G-DECLARE-GTT-R7 - ACCOUNT METER DETAILS                            
      ******************************************************************        
       0100G-DECLARE-GTT-R7.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R7'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R7
              (                                                       
                    RETURN_CODE             INT                     
                   ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MTR_REF_NO              SMALLINT                    
                   ,REG_ID_NO               SMALLINT                    
                   ,CODE_METER_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_USAGE_VALUE CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MIN_NO_UNITS            DECIMAL(09,0)               
                   ,MAX_NO_UNITS            DECIMAL(09,0)               
                   ,CONSTANT                DECIMAL(11,5)               
                   ,NO_DIALS                SMALLINT                    
                   ,PCOMP_FCT               DECIMAL(07,5)               
                   ,LAST_READ_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_READ_VALUE         DECIMAL(12,3)               
                   ,CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000G-DEL-GTT-ROWS       THRU 8000G-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100G'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C7 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,LTRIM(RTRIM(METER_NO))            AS METER_NO           
                      ,MTR_REF_NO                                       
                      ,REG_ID_NO                                        
                      ,LTRIM(RTRIM(CODE_METER_STATUS))   AS 
           CODE_METER_STATUS  
                      ,LTRIM(RTRIM(CODE_USAGE_VALUE))    AS 
           CODE_USAGE_VALUE   
                      ,MIN_NO_UNITS                                     
                      ,MAX_NO_UNITS                                     
                      ,CONSTANT                                         
                      ,NO_DIALS                                         
                      ,PCOMP_FCT                                        
                      ,LTRIM(RTRIM(LAST_READ_DATE))      AS 
           LAST_READ_DATE     
                      ,LAST_READ_VALUE                                  
                      ,LTRIM(RTRIM(CODE_USAGE_SOURCE))   AS 
           CODE_USAGE_SOURCE  
                  FROM #CSR04870_R7                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C7 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,STRIP(METER_NO)            AS METER_NO                   
MFA-TR*               ,MTR_REF_NO                                               
MFA-TR*               ,REG_ID_NO                                                
MFA-TR*               ,STRIP(CODE_METER_STATUS)   AS CODE_METER_STATUS          
MFA-TR*               ,STRIP(CODE_USAGE_VALUE)    AS CODE_USAGE_VALUE           
MFA-TR*               ,MIN_NO_UNITS                                             
MFA-TR*               ,MAX_NO_UNITS                                             
MFA-TR*               ,CONSTANT                                                 
MFA-TR*               ,NO_DIALS                                                 
MFA-TR*               ,PCOMP_FCT                                                
MFA-TR*               ,STRIP(LAST_READ_DATE)      AS LAST_READ_DATE             
MFA-TR*               ,LAST_READ_VALUE                                          
MFA-TR*               ,STRIP(CODE_USAGE_SOURCE)   AS CODE_USAGE_SOURCE          
MFA-TR*           FROM SESSION.CSR04870_R7                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100G-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100H-DECLARE-GTT-R8 - ACCOUNT METER DETAILS                            
      ******************************************************************        
       0100H-DECLARE-GTT-R8.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R8'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R8')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R8
              (                                                       
                    RETURN_CODE             INT                     
                   ,RATE_ITEM_DESC CHAR(17)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NO_UNITS                INT                     
                   ,USAGE_FIXED             DECIMAL(09,0)               
                   ,MTHLY_AMOUNT_FIXED      DECIMAL(11,2)               
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,REMOVE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_PLAN_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_STAT_REASON CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_ITEM_CODE          SMALLINT                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000H-DEL-GTT-ROWS       THRU 8000H-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100H'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C8 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,LTRIM(RTRIM(RATE_ITEM_DESC))      AS 
           RATE_ITEM_DESC     
                      ,NO_UNITS                                         
                      ,USAGE_FIXED                                      
                      ,MTHLY_AMOUNT_FIXED                               
                      ,ITEM_SEQ_NO                                      
                      ,LTRIM(RTRIM(REMOVE_DATE))         AS REMOVE_DATE        
                      ,LTRIM(RTRIM(LAST_BILL_DATE))      AS 
           LAST_BILL_DATE     
                      ,LTRIM(RTRIM(CODE_SERVICE_TYPE))   AS 
           CODE_SERVICE_TYPE  
                      ,LTRIM(RTRIM(CODE_PLAN_STATUS))    AS 
           CODE_PLAN_STATUS   
                      ,LTRIM(RTRIM(CODE_STAT_REASON))    AS 
           CODE_STAT_REASON   
                      ,RATE_ITEM_CODE                                   
                  FROM #CSR04870_R8                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C8 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,STRIP(RATE_ITEM_DESC)      AS RATE_ITEM_DESC             
MFA-TR*               ,NO_UNITS                                                 
MFA-TR*               ,USAGE_FIXED                                              
MFA-TR*               ,MTHLY_AMOUNT_FIXED                                       
MFA-TR*               ,ITEM_SEQ_NO                                              
MFA-TR*               ,STRIP(REMOVE_DATE)         AS REMOVE_DATE                
MFA-TR*               ,STRIP(LAST_BILL_DATE)      AS LAST_BILL_DATE             
MFA-TR*               ,STRIP(CODE_SERVICE_TYPE)   AS CODE_SERVICE_TYPE          
MFA-TR*               ,STRIP(CODE_PLAN_STATUS)    AS CODE_PLAN_STATUS           
MFA-TR*               ,STRIP(CODE_STAT_REASON)    AS CODE_STAT_REASON           
MFA-TR*               ,RATE_ITEM_CODE                                           
MFA-TR*           FROM SESSION.CSR04870_R8                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100H-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0100I-DECLARE-GTT-R9 - BILLING ADJUSTMENT DETAILS.                      
      ******************************************************************        
       0100I-DECLARE-GTT-R9.                                            
                                                                        
           MOVE 'SESSION.CSR04870_R9'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04870_R9')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04870_R9
              (                                                       
                    RETURN_CODE             INT                     
                   ,BILLING_KEY             SMALLINT                    
                   ,REVENUE_MONTH           DECIMAL(06,0)               
                   ,ADJ_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADJ_REASON_DESC CHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,OVRRIDE_RT_REV_MTH      DECIMAL(06,0)               
                   ,SPECIAL_PROCESS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADJ_REASON_CD CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000I-DEL-GTT-ROWS       THRU 8000I-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100I'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C9 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BILLING_KEY                                      
                      ,REVENUE_MONTH                                    
                      ,LTRIM(RTRIM(ADJ_TYPE_CD))         AS ADJ_TYPE_CD        
                      ,LTRIM(RTRIM(ADJ_REASON_DESC))     AS 
           ADJ_REASON_DESC    
                      ,OVRRIDE_RT_REV_MTH                               
                      ,LTRIM(RTRIM(SPECIAL_PROCESS_CD))  AS 
           SPECIAL_PROCESS_CD 
                      ,LTRIM(RTRIM(ADJ_REASON_CD))       AS 
           ADJ_REASON_CD      
                  FROM #CSR04870_R9                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C9 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BILLING_KEY                                              
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,STRIP(ADJ_TYPE_CD)         AS ADJ_TYPE_CD                
MFA-TR*               ,STRIP(ADJ_REASON_DESC)     AS ADJ_REASON_DESC            
MFA-TR*               ,OVRRIDE_RT_REV_MTH                                       
MFA-TR*               ,STRIP(SPECIAL_PROCESS_CD)  AS SPECIAL_PROCESS_CD         
MFA-TR*               ,STRIP(ADJ_REASON_CD)       AS ADJ_REASON_CD              
MFA-TR*           FROM SESSION.CSR04870_R9                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100I-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                                      
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
      *MOVE INPUT DATA.                                                         
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO            
                                               BI-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               CX-ACCOUNT-NO            
                                               UC-ACCOUNT-NO            
                                               FH-ACCOUNT-NO            
                                               MN-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               DF-ACCOUNT-NO            
                                               BP-ACCOUNT-NO            
                                               S1-ACCOUNT-NO            
                                               S5-ACCOUNT-NO            
                                               MU-SUB-ACCT-NO.          
           MOVE PARM-UTIL-TYPE              TO BG-CODE-UTIL-TYPE        
                                               CX-CODE-UTIL-TYPE        
                                               UC-CODE-UTIL-TYPE        
                                               MN-CODE-UTIL-TYPE        
                                               CP-CODE-UTIL-TYPE        
                                               UT-CODE-UTIL-TYPE        
                                               DF-CODE-UTIL-TYPE        
                                               RD-CODE-UTIL-TYPE        
                                               PS-CODE-UTIL-TYPE        
                                               J1-CODE-UTIL-TYPE        
                                               UP-CODE-UTIL-TYPE        
                                               FH-CODE-UTIL-TYPE        
                                               BP-CODE-UTIL-TYPE        
                                               S1-CODE-UTIL-TYPE        
                                               S5-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO BG-IC-NO                 
                                               CX-IC-NO                 
                                               UC-IC-NO                 
                                               MN-IC-NO                 
                                               CP-IC-NO                 
                                               UT-IC-NO                 
                                               DF-IC-NO                 
                                               FH-IC-NO                 
                                               BP-IC-NO                 
                                               S1-IC-NO                 
                                               S5-IC-NO.                
           IF PARM-REVENUE-MONTH > SPACES                               
              MOVE PARM-REVENUE-MONTH       TO WS-REVENUE-MONTH         
           ELSE                                                         
              MOVE ZERO                     TO WS-REVENUE-MONTH         
           END-IF.                                                      
                                                                        
           IF PARM-BILL-NO > 0                                          
              MOVE PARM-BILL-NO             TO BI-BILL-NO               
                                               BG-BILL-NO               
                                               CX-BILL-NO               
                                               UC-BILL-NO               
                                               S1-BILL-NO               
                                               FH-BILL-NO               
                                               BP-BILL-NO               
           END-IF.                                                      
                                                                        
           IF PARM-BILL-ITEM-TS  > SPACES                               
              MOVE PARM-BILL-ITEM-TS        TO BG-BILL-ITEM-TIMESTMP    
                                               CX-BILL-ITEM-TIMESTMP    
                                               UC-BILL-ITEM-TIMESTMP    
                                               S1-BILL-ITEM-TIMESTMP    
                                               FH-BILL-ITEM-TIMESTMP    
                                               BP-BILL-ITEM-TIMESTMP    
           END-IF.                                                      
                                                                        
           IF PARM-WQ-ITEM-ID    > ZERO                                 
              MOVE PARM-WQ-ITEM-ID          TO WQ-ITEM-ID               
           END-IF.                                                      
                                                                        
           IF PARM-UTIL-TYPE = 'E'                                      
              MOVE  WS-NO                   TO   WS-ELEC-FCTR           
           ELSE                                                         
              IF PARM-UTIL-TYPE = 'G'                                   
                 MOVE  WS-NO                TO  WS-GAS-FCTR             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
           PERFORM 0100E-DECLARE-GTT-R5        THRU 0100E-EXIT.         
           PERFORM 0100F-DECLARE-GTT-R6        THRU 0100F-EXIT.         
           PERFORM 0100G-DECLARE-GTT-R7        THRU 0100G-EXIT.         
           PERFORM 0100H-DECLARE-GTT-R8        THRU 0100H-EXIT.         
           PERFORM 0100I-DECLARE-GTT-R9        THRU 0100I-EXIT.         
                                                                        
      *GET ACCOUNT DETAILS.                                                     
           PERFORM 7000-GET-ACCT-DTLS          THRU 7000-EXIT.          
           MOVE AT-COMPANY-NO               TO C8-COMPANY-NO            
                                               C7-COMPANY-NO            
                                               G6-COMPANY-NO            
                                               MC-COMPANY-NO.           
                                                                        
      *GET CURRENT REVENUE MONTH.                                               
           PERFORM 7005-GET-CURR-REVMNTH       THRU 7005-EXIT.          
                                                                        
      *GET CURRENT DATE.                                                        
           PERFORM 7010-GET-CURRENT-DATE       THRU 7010-EXIT.          
                                                                        
      *GET DATABASE REGION                                                      
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           PERFORM 7020-GET-DATABSE            THRU 7020-EXIT.          
                                                                        
      *GET MAX/MIN PRORATE DAYS                                                 
           PERFORM 7030-SELECT-PRORATE-DAYS    THRU 7030-EXIT.          
                                                                        
      *GET BILL WINDOW DATE                                                     
           PERFORM 7040-GET-BIL-WINDOW-DT      THRU 7040-EXIT.          
                                                                        
      *GET BILL WINDOW INDICATOR                                                
           PERFORM 7050-SELECT-BILWIND-IND     THRU 7050-EXIT.          
                                                                        
      *GET REVENUE MONTH FOR MASTER ACCOUNT                                     
           IF AT-MST-SUB-ACCT-IND = WS-SUB-ACCT                         
              PERFORM 7060-GET-MST-LST-REVNMNT THRU 7060-EXIT           
           END-IF.                                                      
                                                                        
      *GET BILL # AND BILL ITEM TS WHEN WQ ITEM ID PASSED                       
           IF PARM-ACCOUNT-NO > ZERO AND PARM-UTIL-TYPE     > SPACES AND
              PARM-IC-NO      > ZERO AND PARM-BILL-ITEM-TS <= SPACES AND
              PARM-BILL-NO    = ZERO AND WS-REVENUE-MONTH   = ZERO   AND
              PARM-WQ-ITEM-ID > ZERO                                    
              PERFORM 1100-GET-BILLING-KEY     THRU 1100-EXIT           
           END-IF.                                                      
                                                                        
      *GET START REVENUE MONTH                                                  
           IF PARM-ACCOUNT-NO > ZERO AND PARM-UTIL-TYPE     > SPACES AND
              PARM-IC-NO      > ZERO AND PARM-BILL-ITEM-TS <= SPACES AND
              PARM-BILL-NO    = ZERO AND WS-REVENUE-MONTH   = ZERO   AND
              PARM-WQ-ITEM-ID = ZERO                                    
              IF AT-REV-MTH-LST-NRML   > ZERO                           
                 MOVE AT-REV-MTH-LST-NRML   TO WS-REVENUE-MONTH         
              ELSE                                                      
                 MOVE BN-REVENUE-MONTH      TO WS-REVENUE-MONTH         
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *GET END REVENUE MONTH AS START REVENUE MONTH - 12 MONTHS                 
           IF WS-REVENUE-MONTH > 0                                      
              MOVE WS-REVENUE-MONTH         TO WS-START-REVENUE-MONTH   
              MOVE WS-REVENUE-MONTH(1:4)    TO WS-START-REVENUE-YY      
              MOVE WS-REVENUE-MONTH(5:2)    TO WS-START-REVENUE-MT      
              MOVE WS-STRT-REVN-DATE        TO WS-START-REVN-DATE       
              PERFORM 7001-GET-END-REVN-DT     THRU 7001-EXIT           
              MOVE WS-REVN-DT-MINUS-11M(1:6)                            
                                            TO WS-END-REVENUE-MONTH     
           END-IF.                                                      
                                                                        
      *GET LAST REVENUE MONTH AS LATEST REVENUE MONTH - 12 MONTHS               
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML      TO WS-REVENUE-MONTH         
           ELSE                                                         
              MOVE BN-REVENUE-MONTH         TO WS-REVENUE-MONTH         
           END-IF.                                                      
                                                                        
           IF WS-REVENUE-MONTH > 0                                      
              MOVE WS-REVENUE-MONTH(1:4)    TO WS-LAST-REVENUE-YY       
              MOVE WS-REVENUE-MONTH(5:2)    TO WS-LAST-REVENUE-MT       
              MOVE WS-LST-REVN-DATE         TO WS-LAST-REVN-DATE        
              PERFORM 7002-GET-RVN-MNTH-MINUS-12M                       
                                               THRU 7002-EXIT           
           END-IF.                                                      
                                                                        
      *GET METER READ SOURCE CODE DETAILS                                       
           IF PARM-UTIL-TYPE = 'U'                                      
              MOVE 0                        TO MN-NO-CONSEC-ESTIMATE    
              MOVE SPACES                   TO MN-MTR-READ-SOURCE-CD    
           ELSE                                                         
              PERFORM 7400-GET-MTRD-DTLS       THRU 7400-EXIT           
           END-IF.                                                      
                                                                        
      *CHECK FOR UNMETERED UTIL TYPE.                                           
           PERFORM 7420-GET-CUST-PLAN-DTLS     THRU 7420-EXIT.          
                                                                        
      *VALIDATE INPUT DATA.                                                     
           IF PARM-ACCOUNT-NO > ZERO AND PARM-UTIL-TYPE > SPACES AND    
              PARM-IC-NO      > ZERO                                    
              IF WS-REVENUE-MONTH   = ZERO AND (PARM-BILL-NO = ZERO OR  
                 PARM-BILL-ITEM-TS <= SPACES)                           
                 MOVE 'CR00009999'          TO S4-RULE-ID               
                 MOVE WS-FAILED             TO S4-RULE-RESULT-CD        
                 IF S4-RULE-ID > SPACES                                 
                    PERFORM 7600-GET-RULE-XREF-ID                       
                                               THRU 7600-EXIT           
                 END-IF                                                 
                 PERFORM 8040-INSERT-GTT-R4    THRU 8040-EXIT           
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1100-GET-BILLING-KEY.                                                   
      ******************************************************************        
       1100-GET-BILLING-KEY.                                            
                                                                        
           PERFORM 7070-GET-BILLING-KEY        THRU 7070-EXIT           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'CR00009999'             TO S4-RULE-ID               
              MOVE WS-FAILED                TO S4-RULE-RESULT-CD        
              IF S4-RULE-ID > SPACES                                    
                 PERFORM 7600-GET-RULE-XREF-ID THRU 7600-EXIT           
              END-IF                                                    
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           ELSE                                                         
              MOVE BG-BILL-NO               TO BI-BILL-NO               
                                               CX-BILL-NO               
                                               UC-BILL-NO               
                                               S1-BILL-NO               
                                               FH-BILL-NO               
                                               BP-BILL-NO               
                                                                        
              MOVE BG-BILL-ITEM-TIMESTMP    TO CX-BILL-ITEM-TIMESTMP    
                                               UC-BILL-ITEM-TIMESTMP    
                                               S1-BILL-ITEM-TIMESTMP    
                                               FH-BILL-ITEM-TIMESTMP    
                                               BP-BILL-ITEM-TIMESTMP    
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                                    
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-START-REVENUE-MONTH > 0 AND                            
              WS-END-REVENUE-MONTH   > 0                                
              PERFORM 7100-OPEN-BG-CURSOR      THRU 7100-EXIT           
              PERFORM 7110-FETCH-BG-ROW        THRU 7110-EXIT           
           ELSE                                                         
              PERFORM 7450-GET-BILLING-DTLS    THRU 7450-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 2100-BUILD-RESULT-SETS      THRU 2100-EXIT           
                     UNTIL NO-MORE-DETAIL-RECS                          
                                                                        
           IF WS-START-REVENUE-MONTH > 0 AND                            
              WS-END-REVENUE-MONTH   > 0                                
              PERFORM 7120-CLOSE-BG-CURSOR     THRU 7120-EXIT           
           END-IF.                                                      
                                                                        
      *LOAD ACCOUNT LEVEL DETAILS.                                              
           PERFORM 2550-SETUP-RESULT-RS5       THRU 2550-EXIT.          
                                                                        
      *LOAD METER/UNMETER DETAILS.                                              
           IF MTRD-ELEC-GAS                                             
              PERFORM 2460-BUILD-RESULT-RS7    THRU 2460-EXIT           
           ELSE                                                         
              PERFORM 2470-BUILD-RESULT-RS8    THRU 2470-EXIT           
           END-IF.                                                      
                                                                        
      *LOAD WQ CONSUMPTION DETAILS.                                             
           IF PARM-WQ-ITEM-ID   > 0                                     
              PERFORM 2480-GET-WQ-CNSMPTN      THRU 2480-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * BUILD THE RESULT SET DESCRIBED ABOVE.                                   
      ******************************************************************        
       2100-BUILD-RESULT-SETS.                                          
      *                                                                         
           PERFORM 2150-MOVE-BG-DETAILS        THRU 2150-EXIT.          
           PERFORM 2200-GET-RATE-PLAN-DTLS     THRU 2200-EXIT.          
           PERFORM 2510-SETUP-RESULT-RS1       THRU 2510-EXIT.          
                                                                        
           IF MTRD-ELEC-GAS                                             
              PERFORM 2250-GET-MTRD-CNSMPTN    THRU 2250-EXIT           
           ELSE                                                         
              PERFORM 2300-GET-UNMTRD-CNSMPTN  THRU 2300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-APPL-CODE NOT = WS-SMART-SCREEN                      
              PERFORM 2400-GET-FCTR-HIST-DTLS  THRU 2400-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 2420-GET-BILL-ADJST-DTLS    THRU 2420-EXIT.          
                                                                        
           IF WS-START-REVENUE-MONTH > 0 AND                            
              WS-END-REVENUE-MONTH   > 0                                
              PERFORM 7110-FETCH-BG-ROW        THRU 7110-EXIT           
           ELSE                                                         
              SET NO-MORE-DETAIL-RECS       TO TRUE                     
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE BG DETAILS FOR FURTHER PROCESS                                     
      ******************************************************************        
       2150-MOVE-BG-DETAILS.                                            
      *                                                                         
           INITIALIZE  GTT-RETURN-FIELDS-2                              
                       GTT-RETURN-FIELDS-3                              
                       GTT-RETURN-FIELDS-6                              
                       GTT-RETURN-FIELDS-9.                             
                                                                        
           MOVE WS-BILLING-KEY-NUM          TO S1-BILLING-KEY-NUM       
                                               S2-BILLING-KEY-NUM       
                                               S3-BILLING-KEY-NUM       
                                               S6-BILLING-KEY-NUM       
                                               S9-BILLING-KEY-NUM.      
           MOVE BG-BILL-NO                  TO CX-BILL-NO               
                                               UC-BILL-NO               
                                               FH-BILL-NO               
                                               BP-BILL-NO               
                                               S1-BILL-NO.              
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP    
                                               UC-BILL-ITEM-TIMESTMP    
                                               FH-BILL-ITEM-TIMESTMP    
                                               BP-BILL-ITEM-TIMESTMP    
                                               S1-BILL-ITEM-TIMESTMP.   
           MOVE BG-RATE-PLAN-NO             TO J1-RATE-PLAN-NO          
                                               RD-RATE-PLAN-NO          
                                               UP-RATE-PLAN-NO          
                                               PS-RATE-PLAN-NO.         
           MOVE BG-RT-PKG-OPT-SEQ-NO        TO DF-RT-PKG-OPT-SEQ-NO.    
           MOVE WS-NO                       TO END-OF-CX-SW             
                                               END-OF-UC-SW             
                                               END-OF-FH-SW             
                                               END-OF-BP-SW             
                                               WS-RTOV-IND.             
       2150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET BLOCK DETAILS AND OPTION DETAILS AT RATE LEVEL.                     
      ******************************************************************        
       2200-GET-RATE-PLAN-DTLS.                                         
                                                                        
           IF BG-RATE-PLAN-NO NOT = WS-PREV-RATE-PLAN-NO                
              MOVE BG-RATE-PLAN-NO          TO WS-PREV-RATE-PLAN-NO     
              PERFORM 7460-GET-HOURLY-REG-TYPE THRU 7460-EXIT           
              PERFORM 7470-CHECK-CIG-CUSTOMER  THRU 7470-EXIT           
              PERFORM 7480-CHECK-SECUR-RATE    THRU 7480-EXIT           
              IF SEB-DATABASE OR RD-SECURED-RATE-FL= WS-NO              
                 PERFORM 7490-GET-ALLOWED-BLOCK-NO                      
                                               THRU 7490-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SEB-DATABASE AND DF-RT-PKG-OPT-SEQ-NO = 0                 
              PERFORM 7495-GET-UT-RTPKG-NUM    THRU 7495-EXIT           
              MOVE UT-RT-PKG-OPT-SEQ-NO     TO DF-RT-PKG-OPT-SEQ-NO     
A05460                                         BG-RT-PKG-OPT-SEQ-NO     
           END-IF.                                                      
                                                                        
           IF SEB-DATABASE AND DF-RT-PKG-OPT-SEQ-NO > 0                 
              IF DF-RT-PKG-OPT-SEQ-NO NOT = WS-PREV-RT-PKG-SEQ-NO       
                 PERFORM 7500-GET-OPTN-DTLS    THRU 7500-EXIT           
                 PERFORM 2450-GET-CUST-CHRG    THRU 2450-EXIT           
                 MOVE DF-RT-PKG-OPT-SEQ-NO  TO WS-PREV-RT-PKG-SEQ-NO    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET CONSUMPTION DETAILS FOR METERED IC.                                 
      ******************************************************************        
       2250-GET-MTRD-CNSMPTN.                                           
                                                                        
           IF CTR-ROWS-RS2 = 0                                          
              PERFORM 7560-GET-MN-LATEST       THRU 7560-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7130-OPEN-CX-CURSOR         THRU 7130-EXIT.          
           PERFORM 7140-FETCH-CX-ROW           THRU 7140-EXIT.          
                                                                        
           PERFORM 2520-SETUP-RESULT-CX-RS2    THRU 2520-CX-EXIT        
                     UNTIL NO-MORE-CNSMPTN-RECS.                        
                                                                        
           PERFORM 7150-CLOSE-CX-CURSOR        THRU 7150-EXIT.          
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * GET CONSUMPTION DETAILS FOR UNMETER IC.                                 
      ****************************************************************          
       2300-GET-UNMTRD-CNSMPTN.                                         
                                                                        
           PERFORM 7160-OPEN-UC-CURSOR         THRU 7160-EXIT.          
           PERFORM 7170-FETCH-UC-ROW           THRU 7170-EXIT.          
                                                                        
           PERFORM 2350-PROCESS-UNMTRD-CNSMPTN THRU 2350-EXIT           
                     UNTIL NO-MORE-UC-CNSMPTN-REC.                      
                                                                        
           PERFORM 7180-CLOSE-UC-CURSOR        THRU 7180-EXIT.          
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET CONSUMPTION DETAILS FOR UNMETER IC.                                 
      ******************************************************************        
       2350-PROCESS-UNMTRD-CNSMPTN.                                     
                                                                        
           MOVE UC-RATE-ITEM-CODE           TO UP-RATE-ITEM-CODE        
           PERFORM 7520-GET-UNMTRD-RT-DESC     THRU 7520-EXIT.          
           PERFORM 2520-SETUP-RESULT-UC-RS6    THRU 2520-UC-EXIT.       
           PERFORM 7170-FETCH-UC-ROW           THRU 7170-EXIT.          
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET FACTOR HISTORY DETAILS FOR THE BILLING KEY                          
      ******************************************************************        
       2400-GET-FCTR-HIST-DTLS.                                         
                                                                        
           PERFORM 7190-OPEN-FH-CURSOR         THRU 7190-EXIT.          
           PERFORM 7200-FETCH-FH-ROW           THRU 7200-EXIT.          
                                                                        
           PERFORM 2530-SETUP-RESULT-RS3       THRU 2530-EXIT           
                     UNTIL NO-MORE-FACTOR-RECS.                         
                                                                        
           PERFORM 7210-CLOSE-FH-CURSOR        THRU 7210-EXIT.          
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET BILL ADJUSTMENT DETAILS FOR THE BILLING KEY                         
      ******************************************************************        
       2420-GET-BILL-ADJST-DTLS.                                        
                                                                        
           PERFORM 7280-OPEN-BP-CURSOR         THRU 7280-EXIT.          
           PERFORM 7290-FETCH-BP-ROW           THRU 7290-EXIT.          
                                                                        
           PERFORM 2590-SETUP-RESULT-RS9       THRU 2590-EXIT           
                     UNTIL NO-MORE-BIL-ADJST-RECS.                      
                                                                        
           PERFORM 7300-CLOSE-BP-CURSOR        THRU 7300-EXIT.          
                                                                        
           IF INSERT-RTOV                                               
              PERFORM 2590A-SETUP-RESULT-RS9   THRU 2590A-EXIT          
           END-IF.                                                      
                                                                        
      *                                                                         
       2420-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET CUSTOMER CHARGE DETAILS                                             
      ******************************************************************        
       2450-GET-CUST-CHRG.                                              
                                                                        
           MOVE DF-STATUS-CD                TO WS-DF-STATUS-CODE.       
           MOVE DF-OPTION-CD                TO WS-OPTION-CD.            
           MOVE ZEROS                       TO WS-CSC-AMT.              
           MOVE SPACES                      TO WS-CSC-TIMELINE-FL-063   
                                               WS-DATE-FOR-CSC-TIMELINE.
           EVALUATE TRUE                                                
               WHEN OPEN-FOR-RENEWAL                                    
               WHEN ACTIVE                                              
                 MOVE WS-YES                TO WS-THERM-CSC-ACCT-FL     
               WHEN PENDING                                             
                 MOVE WS-YES                TO WS-THERM-CSC-ACCT-FL     
                                               WS-PENDING-OPTION-FL-063 
               WHEN OTHER                                               
                  IF RENEWED OR DELETED                                 
                     PERFORM 7510-GET-OLD-RVN-MNTH THRU 7510-EXIT       
                  ELSE                                                  
                     MOVE DF-STATUS-EFF-REV-MTH                         
                                            TO WS-EFF-REV-MTH-TMP       
                  END-IF                                                
                  IF WS-EFF-REV-MTH-TMP = 0                             
                     MOVE 190001            TO WS-EFF-REV-MTH-TMP       
                  END-IF                                                
                  MOVE WS-EFF-REV-MTH(1:4)  TO WS-EFF-REV-MTH-YR        
                  MOVE WS-EFF-REV-MTH(5:2)  TO WS-EFF-REV-MTH-MM        
                  MOVE WS-EFF-REV-MTH-DATE  TO WS-DATE-FOR-CSC-TIMELINE 
                  MOVE WS-YES               TO WS-CSC-TIMELINE-FL-063   
           END-EVALUATE.                                                
                                                                        
           PERFORM 6000-CALL-MCSCB063-PGM      THRU 6000-EXIT.          
                                                                        
           IF DF-STATUS-CD = WS-PENDING                                 
              MOVE WS-PEND063-CSC-AMT       TO WS-CSC-AMT-DESC          
           ELSE                                                         
              MOVE WS-CSC-AMT               TO WS-CSC-AMT-DESC          
           END-IF.                                                      
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET METER NUMBER DETAILS FROM CONSUMPTION HISTORY TABLE                 
      ******************************************************************        
       2460-BUILD-RESULT-RS7.                                           
                                                                        
           PERFORM 7220-OPEN-MT-CURSOR         THRU 7220-EXIT.          
           PERFORM 7230-FETCH-MT-ROW           THRU 7230-EXIT.          
                                                                        
           PERFORM 2462-GET-REGISTER-DETAILS   THRU  2462-EXIT          
             UNTIL NO-MORE-METER-RECS.                                  
                                                                        
           PERFORM 7240-CLOSE-MT-CURSOR        THRU 7240-EXIT.          
      *                                                                         
       2460-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET REGISTER DETAILS FOR THE ACTIVE METER REFERENCE NUMBER              
      ******************************************************************        
       2462-GET-REGISTER-DETAILS.                                       
                                                                        
           PERFORM 2463-GET-LATEST-MTR-DTLS    THRU 2463-EXIT.          
                                                                        
           MOVE WS-NO                       TO END-OF-RR-SW.            
           PERFORM 7310-OPEN-RR-CURSOR         THRU 7310-EXIT.          
           PERFORM 7320-FETCH-RR-ROW           THRU 7320-EXIT.          
           PERFORM 2464-GET-REG-DTLS           THRU 2464-EXIT           
             UNTIL NO-MORE-REG-RECS.                                    
           PERFORM 7330-CLOSE-RR-CURSOR        THRU 7330-EXIT.          
                                                                        
           MOVE WS-NO                       TO END-OF-MTR-SW.           
           PERFORM 7340-OPEN-MTR-CURSOR        THRU 7340-EXIT.          
           PERFORM 7350-FETCH-MTR-ROW          THRU 7350-EXIT.          
           PERFORM 2465-GET-MTR-DTLS           THRU 2465-EXIT           
             UNTIL NO-MORE-MTR-RECS.                                    
           PERFORM 7360-CLOSE-MTR-CURSOR       THRU 7360-EXIT.          
                                                                        
           PERFORM 7230-FETCH-MT-ROW           THRU 7230-EXIT.          
      *                                                                         
       2462-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET LATEST METER DETAILS FROM MTRD ENVRNMNT TABLE                       
      ******************************************************************        
       2463-GET-LATEST-MTR-DTLS.                                        
                                                                        
           MOVE MN-METER-NO                 TO WS-METER-NO.             
           MOVE MN-MTR-REF-NO               TO WS-MTR-REF-NO.           
           MOVE MN-CODE-METER-STATUS        TO WS-CODE-METER-STATUS     
P00899                                         WS-CODE-REG-STATUS.      
           MOVE MN-LAST-REG-READ-DATE       TO WS-LAST-REG-READ-DATE.   
           MOVE MN-LAST-READ-VALUE          TO WS-LAST-READ-VALUE.      
           IF MN-CODE-USAGE-TYPE = WS-CCF AND MN-METER-PRESSURE > 0     
              COMPUTE WS-PCOMP-FCT ROUNDED =                            
                                      (MN-METER-PRESSURE + 14.7) / 14.73
           ELSE                                                         
              MOVE 1.0                      TO WS-PCOMP-FCT             
           END-IF.                                                      
           PERFORM 2560-SETUP-MTR-REG-TBL      THRU 2560-EXIT.          
           PERFORM 2570-SETUP-RESULT-RS7       THRU 2570-EXIT.          
      *                                                                         
       2463-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET REGISTER DETAILS FROM MTRD ENVRNMT & REGISTER READ TABLES           
      ******************************************************************        
       2464-GET-REG-DTLS.                                               
                                                                        
           PERFORM 2560-SETUP-MTR-REG-TBL      THRU 2560-EXIT.          
           PERFORM 2570-SETUP-RESULT-RS7       THRU 2570-EXIT.          
           PERFORM 7320-FETCH-RR-ROW           THRU 7320-EXIT.          
      *                                                                         
       2464-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET REGISTER DETAILS FROM MTRD ENVRNMT & REGISTER READ TABLES           
      ******************************************************************        
       2465-GET-MTR-DTLS.                                               
                                                                        
           IF CX-CODE-TIME-PERIOD = 0 AND                               
              CX-CODE-USAGE-TYPE  = ('B' OR 'C')                        
              PERFORM 2520-GET-REG-DTLS        THRU 2520-RG-EXIT        
           ELSE                                                         
              MOVE 0                        TO WS-MIN-NO-UNITS          
                                               WS-MAX-NO-UNITS          
           END-IF.                                                      
           MOVE ZEROES                      TO WS-LAST-READ-VALUE.      
           MOVE SPACES                      TO WS-LAST-REG-READ-DATE.   
           MOVE WS-REMOVED                  TO WS-CODE-METER-STATUS.    
           MOVE CX-METER-NO                 TO WS-METER-NO.             
           MOVE CX-MTR-REF-NO               TO WS-MTR-REF-NO.           
           MOVE CX-REG-ID-NO                TO WS-REG-ID-NO.            
           MOVE CX-NO-DIALS                 TO WS-NO-READ-DIALS.        
           MOVE CX-CONSTANT                 TO WS-CONSTANT.             
                                                                        
           PERFORM 2570-SETUP-RESULT-RS7       THRU 2570-EXIT.          
           PERFORM 7350-FETCH-MTR-ROW          THRU 7350-EXIT.          
      *                                                                         
       2465-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET UNMETER DETAILS FROM CUST PLAN TABLE                                
      ******************************************************************        
       2470-BUILD-RESULT-RS8.                                           
                                                                        
           PERFORM 7250-OPEN-UNMT-CURSOR       THRU 7250-EXIT.          
           PERFORM 7260-FETCH-UNMT-ROW         THRU 7260-EXIT.          
                                                                        
           PERFORM 2580-SETUP-RESULT-RS8       THRU 2580-EXIT           
             UNTIL NO-MORE-UNMTR-RECS.                                  
                                                                        
           PERFORM 7270-CLOSE-UNMT-CURSOR      THRU 7270-EXIT.          
      *                                                                         
       2470-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET CONSUMPTION DETAILS FOR METERED IC FROM WQ TABLE.                   
      ******************************************************************        
       2480-GET-WQ-CNSMPTN.                                             
                                                                        
           PERFORM 7570-GET-WQ-CNSMPTN         THRU 7570-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'CR00009999'             TO S4-RULE-ID               
              MOVE WS-FAILED                TO S4-RULE-RESULT-CD        
              IF S4-RULE-ID > SPACES                                    
                 PERFORM 7600-GET-RULE-XREF-ID THRU 7600-EXIT           
              END-IF                                                    
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           ELSE                                                         
              MOVE WQ-FREE-FORM-AREA-TEXT   TO WS-WORK-QUEUE-DATA       
           END-IF.                                                      
                                                                        
           IF WS-WQ-METER-NO > SPACES                                   
              PERFORM 2520-SETUP-RESULT-WQ-RS2 THRU 2520-WQ-EXIT        
           END-IF.                                                      
                                                                        
      *                                                                         
       2480-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * LOOK FOR WQ METER - REGISTER DETAILS IN THE MN / RG TABLES              
      ******************************************************************        
       2490-GET-WQ-MTR-REG-DTLS.                                        
      *                                                                         
           SET WS-MTR-REG-INDX              TO 1                        
           SEARCH WS-MTR-REG-DTL-DATA                                   
              AT END                                                    
              MOVE 'CR00000085'             TO S4-RULE-ID               
              MOVE WS-FAILED                TO S4-RULE-RESULT-CD        
              IF S4-RULE-ID > SPACES                                    
                 PERFORM 7600-GET-RULE-XREF-ID THRU 7600-EXIT           
              END-IF                                                    
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           WHEN WS-MR-METER-NO(WS-MTR-REG-INDX)                         
                          = WS-WQ-METER-NO                              
            AND WS-MR-CODE-USAGE-TYPE(WS-MTR-REG-INDX)                  
                          = WS-WQ-USAGE-TYPE(WS-WQ-IDX)                 
            AND WS-MR-CODE-TIME-PERIOD(WS-MTR-REG-INDX)                 
                          = WS-WQ-TIME-PERIOD(WS-WQ-IDX)                
            AND WS-MR-CODE-USAGE-ID(WS-MTR-REG-INDX)                    
                          = WS-WQ-USAGE-ID(WS-WQ-IDX)                   
              MOVE WS-MR-MTR-REF-NO(WS-MTR-REG-INDX)                    
                                             TO S2-MTR-REF-NO           
              MOVE WS-MR-REG-ID-NO(WS-MTR-REG-INDX)                     
                                             TO S2-REG-ID-NO            
              MOVE WS-MR-CONSTANT(WS-MTR-REG-INDX)                      
                                             TO S2-CONSTANT             
              MOVE WS-MR-NO-READ-DIALS(WS-MTR-REG-INDX)                 
                                             TO S2-NO-DIALS             
              MOVE WS-MR-DIGTL-MTR-TYPE(WS-MTR-REG-INDX)                
                                             TO S2-DIGTL-MTR-TYPE       
              MOVE WS-MR-MTR-READ-SOURCE-CD(WS-MTR-REG-INDX)            
                                             TO S2-MTR-READ-SOURCE-CD   
              MOVE WS-MR-PCOMP-FCT(WS-MTR-REG-INDX)                     
                                             TO S2-PCOMP-FCT            
              MOVE WS-MR-MIN-NO-UNITS(WS-MTR-REG-INDX)                  
                                             TO S2-MIN-NO-UNITS         
              MOVE WS-MR-MAX-NO-UNITS(WS-MTR-REG-INDX)                  
                                             TO S2-MAX-NO-UNITS         
P00899        MOVE WS-MR-CODE-REG-STATUS(WS-MTR-REG-INDX)               
P00899                                       TO S2-CODE-ITEM-STATUS     
           END-SEARCH.                                                  
                                                                        
       2490-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE BG VALUES TO RESULT SET 1.                                         
      ******************************************************************        
       2510-SETUP-RESULT-RS1.                                           
      *                                                                         
           IF BG-DATE-ORIG-BILL < '1950-01-01'                          
              MOVE SPACES                   TO S1-DATE-ORIG-BILL        
           ELSE                                                         
              MOVE BG-DATE-ORIG-BILL        TO S1-DATE-ORIG-BILL        
           END-IF.                                                      
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              MOVE 'C'                      TO S1-DR-CR                 
           ELSE                                                         
              MOVE 'D'                      TO S1-DR-CR                 
           END-IF.                                                      
           IF BG-CODE-BILL-ITM-TYPE = WS-CURRENT AND                    
              BG-CODE-BILL-ITM-IND  = WS-ACTIVE  AND                    
              BG-DATE-ORIG-BILL     > SPACES                            
              MOVE WS-BG-REBILL             TO S1-TRANS-STATUS          
           ELSE                                                         
              IF BG-CODE-BILL-ITM-TYPE = WS-BACKOUT                     
                 MOVE WS-BACKOUT            TO S1-TRANS-STATUS          
              ELSE                                                      
                 MOVE BG-CODE-BILL-ITM-IND  TO S1-TRANS-STATUS          
              END-IF                                                    
           END-IF.                                                      
           IF BI-DATE-BILLED = SPACES                                   
              IF BI-CODE-BILL-STATUS = WS-BI-REBILL                     
                 MOVE WS-IMMEDIATE          TO S1-CODE-BILL-STATUS      
              ELSE                                                      
                 MOVE WS-FUTURE             TO S1-CODE-BILL-STATUS      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-BILLED                TO S1-CODE-BILL-STATUS      
           END-IF.                                                      
           MOVE BG-AMT-BILL-ITEM            TO S1-TRANS-AMT.            
           MOVE BG-CODE-BILL-CALC           TO S1-BILL-CALC-DESC.       
           MOVE BG-CODE-BILL-ITM-TYPE       TO S1-CODE-BILL-ITM-TYPE.   
           MOVE BG-AMT-STATE-TAX            TO S1-STATE-TAX.            
           MOVE BG-AMT-CITY-TAX             TO S1-CITY-TAX.             
           MOVE BG-AMT-OTHER-TAX            TO S1-OTHER-TAX.            
           MOVE BG-CODE-REVENUE-CLASS       TO S1-CODE-REVENUE-CLASS.   
           MOVE BG-CODE-SIC-NO              TO S1-CODE-SIC-NO.          
           MOVE BG-RATE-PLAN-NO             TO S1-RATE.                 
           MOVE BG-CODE-CURTAIL-PRTY        TO S1-CODE-CURTAIL-PRTY.    
           MOVE BG-CODE-STAT-TAX-XMT        TO S1-STATE-XMT.            
           MOVE BG-CODE-CITY-TAX-XMT        TO S1-CITY-XMT.             
           MOVE BG-CODE-OTHR-TAX-XMT        TO S1-OTHER-XMT.            
           MOVE BG-REV-RPT-CD               TO S1-REV-RPT-CD.           
           MOVE BG-STANDBY-COMPLIED         TO S1-STANDBY-COMPLIED.     
           MOVE BG-PRORATE-CD               TO S1-PRORATE-CD.           
           MOVE BG-NEW-RATE-PCT             TO S1-NEW-RATE-PCT.         
           MOVE BG-TAX-REFUND-CD            TO S1-TAX-REFUND-CD.        
           MOVE BG-DATE-LFTM-HI-DMD         TO S1-DATE-LFTM-HI-DMD.     
           MOVE BG-LFTM-HI-PEAK-DMD         TO S1-LFTM-HI-PEAK-DMD.     
           MOVE BG-ADJ-REASON-CD            TO S1-ADJ-REASON.           
           MOVE BG-REVENUE-MONTH            TO S1-REVENUE-MONTH.        
           MOVE BG-GAS-BASE-USE             TO S1-GAS-BASE-USE.         
           MOVE BG-WNA-FACTOR               TO S1-WNA-FACTOR.           
           MOVE BG-BTU-FACTOR               TO S1-BTU-FACTOR.           
           MOVE BG-NO-OF-CONS-DAYS          TO S1-NO-OF-CONS-DAYS.      
           MOVE BG-REV-MTH-ORIG-BILL        TO S1-REV-MTH-ORIG-BILL.    
           MOVE MN-NO-CONSEC-ESTIMATE       TO S1-NO-CONSEC-ESTIMATE.   
           MOVE MN-MTR-READ-SOURCE-CD       TO S1-REBILL-IND.           
           MOVE BG-FUEL-SHIPPER-CD          TO S1-SHIPPER.              
           MOVE BG-TRNSP-OVER-MDQ-FL        TO S1-TRNSP-OVER-MDQ.       
           MOVE BG-RT-PKG-OPT-SEQ-NO        TO S1-RT-PKG-OPT-SEQ-NO.    
           MOVE WS-CIG-CUSTOMER             TO S1-CIG-CUSTOMER.         
           MOVE WS-HRLY-REGISTER            TO S1-HRLY-REGISTER.        
           MOVE BI-BILL-CORRECTED-CD        TO S1-BILL-CORRECTED-CD.    
           MOVE BI-DATE-BILLED              TO S1-BILLED-DATE.          
           MOVE DF-OPTION-CD                TO S1-OPTION-CD.            
           MOVE FI-OPT-DESC-INT             TO S1-OPT-DESC-INT.         
           IF SEB-DATABASE                                              
              STRING FI-OPT-DESC-INT DELIMITED BY '   '                 
                     ' with '                                           
                     WS-CSC-AMT-DESC DELIMITED BY SIZE                  
                     WS-CSC-LIT-DESC DELIMITED BY SIZE                  
                INTO S1-OPT-DESC-INT                                    
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE METERED IC CONSUMPTION TO RS2.                                     
      ******************************************************************        
       2520-SETUP-RESULT-CX-RS2.                                        
      *                                                                         
           IF CX-CODE-USAGE-TYPE = ('E' OR 'J' OR 'K' OR 'Q' OR 'S')    
              MOVE CX-DEMAND-READING        TO S2-METER-READING         
                                               S2-USAGE                 
              MOVE CX-NO-DEMAND-UNITS       TO S2-NO-UNITS              
           ELSE                                                         
              MOVE CX-METER-READING         TO S2-METER-READING         
              MOVE CX-NO-UNITS              TO S2-NO-UNITS              
                                               S2-USAGE                 
           END-IF.                                                      
           IF MN-LAST-REG-READ-DATE = CX-DATE-READ                      
              SET CX-LATEST                 TO TRUE                     
           ELSE                                                         
              SET CX-NOT-LATEST             TO TRUE                     
           END-IF.                                                      
           MOVE WS-CX-LATEST-ROW            TO S2-LATEST-ROW.           
           MOVE CX-CODE-TIME-PERIOD         TO S2-CODE-TIME-PERIOD.     
           MOVE CX-MTR-REF-NO               TO S2-MTR-REF-NO.           
           MOVE CX-CODE-USAGE-TYPE          TO S2-CODE-USAGE-TYPE.      
           MOVE CX-CODE-USAGE-ID            TO S2-CODE-USAGE-ID.        
           MOVE CX-CODE-USAGE-SOURCE        TO S2-CODE-USAGE-SOURCE.    
           MOVE CX-ITEM-SEQ-NO              TO S2-ITEM-SEQ-NO.          
           MOVE CX-METER-NO                 TO S2-METER-NO.             
           MOVE CX-REG-ID-NO                TO S2-REG-ID-NO.            
           MOVE CX-DATE-READ                TO S2-DATE-READ.            
           MOVE CX-CODE-METER-READ          TO S2-CODE-METER-READ.      
           MOVE CX-CODE-METER-NO-READ       TO S2-CODE-METER-NO-READ.   
           MOVE CX-NO-DAYS                  TO S2-NO-DAYS.              
           MOVE CX-CODE-SOURCE-ID           TO S2-CODE-SOURCE-ID.       
           MOVE CX-CODE-DEBIT-CREDIT        TO S2-CODE-DEBIT-CREDIT.    
           MOVE CX-CODE-ITEM-STATUS         TO S2-CODE-ITEM-STATUS.     
           MOVE CX-CONSTANT                 TO S2-CONSTANT.             
           MOVE CX-NO-DIALS                 TO S2-NO-DIALS.             
           MOVE CX-EXCEPT-OVERRIDE-CD       TO S2-EXCEPT-OVERRIDE-CD.   
           MOVE CX-REQUESTED-USAGE          TO S2-REQUESTED-USAGE.      
           MOVE CX-DIGTL-INTRL-MTR-NO       TO S2-DIGTL-INTRL-MTR-NO.   
           MOVE CX-DIGTL-MTR-TYPE           TO S2-DIGTL-MTR-TYPE.       
           MOVE CX-CODE-TOU-SEASN           TO S2-CODE-TOU-SEASN.       
           MOVE CX-EXCL-DMD-RCHT-IND        TO S2-EXCL-DMD-RCHT-IND.    
           MOVE CX-MTR-READ-SOURCE-CD       TO S2-MTR-READ-SOURCE-CD.   
           MOVE CX-PCOMP-FCT                TO S2-PCOMP-FCT.            
           MOVE WS-CX-CODE-USAGE-VALUE      TO S2-CODE-USAGE-VALS.      
           MOVE SPACES                      TO S2-WQ-NO-READ-CD.        
           MOVE WS-NO                       TO S2-WQ-CNSMPTN.           
           IF S2-CODE-TOU-SEASN = SPACES                                
              MOVE WS-CURRENT               TO S2-CODE-TOU-SEASN        
           END-IF.                                                      
           IF CX-CONSTANT > 0                                           
              IF CX-CODE-USAGE-TYPE  = ('B' OR 'C')                     
                 COMPUTE WS-TEMP-USAGE ROUNDED = S2-USAGE / CX-CONSTANT 
                 MOVE WS-TEMP-USAGE         TO S2-USAGE                 
              ELSE                                                      
                 IF S2-USAGE = 0 AND S2-NO-UNITS > 0                    
                    COMPUTE S2-USAGE ROUNDED = S2-NO-UNITS / CX-CONSTANT
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-DEFAULT-CONSTANT      TO S2-CONSTANT              
           END-IF.                                                      
           IF CX-PCOMP-FCT > 0 AND CX-CODE-UTIL-TYPE = 'G'              
              COMPUTE WS-TEMP-USAGE ROUNDED = S2-USAGE / CX-PCOMP-FCT   
              MOVE WS-TEMP-USAGE            TO S2-USAGE                 
           END-IF.                                                      
           IF CX-CODE-TIME-PERIOD = 0 AND                               
              CX-CODE-USAGE-TYPE  = ('B' OR 'C')                        
              PERFORM 2520-GET-REG-DTLS        THRU 2520-RG-EXIT        
           ELSE                                                         
              MOVE 0                        TO S2-MIN-NO-UNITS          
                                               S2-MAX-NO-UNITS          
           END-IF.                                                      
           IF CX-NO-DIALS = 0                                           
              MOVE WS-DEFAULT-NO-DIALS      TO S2-NO-DIALS              
           END-IF.                                                      
           IF CX-PCOMP-FCT = 0                                          
              MOVE WS-DEFAULT-PCOMP         TO S2-PCOMP-FCT             
           END-IF.                                                      
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 7140-FETCH-CX-ROW           THRU 7140-EXIT.          
                                                                        
       2520-CX-EXIT.                                                    
           EXIT.                                                        
      ******************************************************************        
      * MOVE METERED IC CONSUMPTION FROM WQ TABLE TO RS2.                       
      ******************************************************************        
       2520-SETUP-RESULT-WQ-RS2.                                        
      *                                                                         
           MOVE ZERO                        TO S2-ITEM-SEQ-NO           
                                               S2-REQUESTED-USAGE.      
           MOVE SPACES                      TO S2-EXCEPT-OVERRIDE-CD    
                                               S2-DIGTL-INTRL-MTR-NO.   
           MOVE WS-NO                       TO S2-EXCL-DMD-RCHT-IND     
                                               S2-LATEST-ROW.           
           MOVE WS-YES                      TO S2-WQ-CNSMPTN.           
           MOVE WS-WQ-METER-NO              TO S2-METER-NO.             
           MOVE WS-WQ-DATE-READ             TO S2-DATE-READ.            
P00899***  MOVE WS-ACTIVE-NORMAL-BLNG       TO S2-CODE-SOURCE-ID                
P00899***                                      S2-CODE-ITEM-STATUS.             
P00899     MOVE 'C'                         TO S2-CODE-SOURCE-ID.       
                                                                        
           PERFORM VARYING WS-WQ-IDX FROM 1 BY 1                        
             UNTIL WS-WQ-IDX > 14                                       
A05460        IF WS-WQ-READ (WS-WQ-IDX) >= 0                            
                 PERFORM 2490-GET-WQ-MTR-REG-DTLS                       
                                               THRU 2490-EXIT           
                 IF WS-WQ-DATE-READ > WS-MR-LAST-REG-READ-DATE          
                                           (WS-MTR-REG-INDX)            
                    MOVE WS-MR-LAST-REG-READ-DATE(WS-MTR-REG-INDX)      
                                            TO WS-LAST-REG-READ-DATE    
                    PERFORM 7580-GET-DAY-DIFFERENCE                     
                                               THRU 7580-EXIT           
                    MOVE WS-NO-DAYS         TO S2-NO-DAYS               
                    MOVE WS-WQ-NO-READ-CD (WS-WQ-IDX)                   
                                            TO S2-CODE-METER-NO-READ    
                                                  S2-WQ-NO-READ-CD      
                    MOVE WS-WQ-SESN-CD (WS-WQ-IDX)                      
                                            TO S2-CODE-TOU-SEASN        
                    MOVE WS-WQ-READ-CODE    TO S2-CODE-METER-READ       
                    MOVE WS-WQ-TIME-PERIOD (WS-WQ-IDX)                  
                                            TO S2-CODE-TIME-PERIOD      
                    MOVE WS-WQ-USAGE-TYPE (WS-WQ-IDX)                   
                                            TO S2-CODE-USAGE-TYPE       
                    MOVE WS-WQ-USAGE-ID (WS-WQ-IDX)                     
                                            TO S2-CODE-USAGE-ID         
                    MOVE WS-WQ-USAGE-SOURCE (WS-WQ-IDX)                 
                                            TO S2-CODE-USAGE-SOURCE     
                    STRING WS-WQ-UTIL-TYPE                              
                           WS-WQ-USAGE-TYPE (WS-WQ-IDX)                 
                           WS-WQ-TIME-PERIOD (WS-WQ-IDX)                
                           WS-WQ-USAGE-ID (WS-WQ-IDX)                   
                           DELIMITED BY SIZE INTO S2-CODE-USAGE-VALS    
                    END-STRING                                          
                                                                        
                    IF S2-CODE-TOU-SEASN = SPACES                       
                       MOVE WS-CURRENT      TO S2-CODE-TOU-SEASN        
                    END-IF                                              
                    IF WS-WQ-USAGE-ID (WS-WQ-IDX) = 'F'                 
                       MOVE WS-CREDIT       TO S2-CODE-DEBIT-CREDIT     
                    ELSE                                                
                       MOVE WS-DEBIT        TO S2-CODE-DEBIT-CREDIT     
                    END-IF                                              
                                                                        
                    IF WS-WQ-USAGE-TYPE (WS-WQ-IDX)   =                 
                                    ('E' OR 'J' OR 'K' OR 'Q' OR 'S')   
                       COMPUTE S2-USAGE = WS-WQ-READ (WS-WQ-IDX) / 1000 
                       MOVE S2-USAGE        TO S2-METER-READING         
                    ELSE                                                
A05460                 IF WS-WQ-SESN-CD (WS-WQ-IDX)     = 'C'           
A05460                    PERFORM 2525-CALCULATE-CURRENT-RDNG           
A05460                                      THRU 2525-EXIT              
A05460                 ELSE                                             
                          COMPUTE S2-USAGE    = WS-WQ-READ (WS-WQ-IDX) -
                               WS-MR-LAST-READ-VALUE (WS-MTR-REG-INDX)  
A05460                 END-IF                                           
                       MOVE WS-WQ-READ (WS-WQ-IDX)                      
                                            TO S2-METER-READING         
                       IF S2-USAGE < 0                                  
                          MOVE S2-USAGE     TO WS-USAGE-ABSLT           
                          IF WS-USAGE-ABSLT > S2-METER-READING          
                             COMPUTE S2-USAGE = S2-USAGE + (10 **       
                                WS-MR-NO-READ-DIALS (WS-MTR-REG-INDX))  
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                    COMPUTE S2-NO-UNITS = S2-USAGE * S2-CONSTANT        
                                                                        
                    IF S2-PCOMP-FCT > 0 AND WS-WQ-UTIL-TYPE = 'G'       
                       COMPUTE WS-TEMP-USAGE ROUNDED =                  
                                             S2-USAGE / S2-PCOMP-FCT    
                       MOVE WS-TEMP-USAGE   TO S2-USAGE                 
                    END-IF                                              
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
                 END-IF                                                 
A05460        END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2520-WQ-EXIT.                                                    
           EXIT.                                                        
      ******************************************************************        
      * MOVE REGISTER LEVEL DETAILS TO RS2.                                     
      ******************************************************************        
       2520-GET-REG-DTLS.                                               
      *                                                                         
           SET WS-REG-INDX                   TO 1                       
           MOVE ZERO                         TO MN-MIN-NO-UNITS         
           MOVE WS-DEFAULT-MAX-UNITS         TO MN-MAX-NO-UNITS         
           SEARCH WS-REG-DTL-DATA                                       
              AT END                                                    
              PERFORM 7530-GET-MTRD-REG-DTLS   THRU 7530-EXIT           
              MOVE MN-MIN-NO-UNITS           TO S2-MIN-NO-UNITS         
              MOVE MN-MAX-NO-UNITS           TO S2-MAX-NO-UNITS         
           WHEN WS-MN-MTR-REF-NO(WS-REG-INDX)    = CX-MTR-REF-NO        
              MOVE WS-MN-MIN-NO-UNITS(WS-REG-INDX)                      
                                             TO S2-MIN-NO-UNITS         
              MOVE WS-MN-MAX-NO-UNITS(WS-REG-INDX)                      
                                             TO S2-MAX-NO-UNITS         
           END-SEARCH.                                                  
                                                                        
       2520-RG-EXIT.                                                    
           EXIT.                                                        
      ******************************************************************        
      * MOVE UNMETER CONSUMPTION DETAILS TO RS6.                                
      ******************************************************************        
       2520-SETUP-RESULT-UC-RS6.                                        
      *                                                                         
           MOVE L9-UM-EQUIP-SHRT-DESC       TO S6-UM-DESCRIPTION.       
           MOVE UC-RATE-ITEM-CODE           TO S6-UM-RATE-ITEM-CODE.    
           MOVE UC-ITEM-SEQ-NO              TO S6-UM-ITEM-SEQ-NO.       
           MOVE UC-NO-UNITS                 TO S6-UM-NO-UNITS.          
           MOVE UC-NO-DAYS                  TO S6-UM-NO-DAYS.           
           MOVE UC-CODE-DEBIT-CREDIT        TO S6-UM-CODE-DEBIT-CREDIT. 
           MOVE UC-USAGE-FIXED              TO S6-UM-USAGE-FIXED.       
           MOVE UC-DATE-USAGE-ENDS          TO S6-UM-DATE-USAGE-ENDS.   
           MOVE UC-CODE-SERVICE-TYPE        TO S6-UM-CODE-SERVICE-TYPE. 
           MOVE UC-CODE-ITEM-STATUS         TO S6-UM-CODE-ITEM-STATUS.  
           MOVE UC-CODE-SOURCE-ID           TO S6-UM-CODE-SOURCE-ID.    
           MOVE UC-MTHLY-AMOUNT-FIXED       TO S6-UM-MTHLY-AMOUNT-FIXED.
           MOVE UC-DIST-NO                  TO S6-UM-DIST-NO.           
           MOVE UC-LIGHT-NO                 TO S6-UM-LIGHT-NO.          
           MOVE UC-POLE-NO                  TO S6-UM-POLE-NO.           
                                                                        
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT.          
                                                                        
       2520-UC-EXIT.                                                    
           EXIT.                                                        
A05460******************************************************************        
A05460* LOOK FOR PREVIOUS READING IN WQ ARRAY READINGS                          
A05460******************************************************************        
A05460 2525-CALCULATE-CURRENT-RDNG.                                     
A05460*                                                                         
A05460     SET WS-WQ-TEMP-INDX              TO 1                        
A05460     SEARCH WS-WQ-READINGS                                        
A05460        AT END                                                    
A05460        COMPUTE S2-USAGE    = WS-WQ-READ (WS-WQ-IDX) -            
A05460                   WS-MR-LAST-READ-VALUE (WS-MTR-REG-INDX)        
A05460     WHEN WS-WQ-SESN-CD (WS-WQ-TEMP-INDX) = 'P'                   
A05460      AND WS-WQ-USAGE-TYPE  (WS-WQ-IDX)   =                       
A05460                  WS-WQ-USAGE-TYPE  (WS-WQ-TEMP-INDX)             
A05460      AND WS-WQ-TIME-PERIOD (WS-WQ-IDX)   =                       
A05460                  WS-WQ-TIME-PERIOD (WS-WQ-TEMP-INDX)             
A05460      AND WS-WQ-USAGE-ID    (WS-WQ-IDX)   =                       
A05460                  WS-WQ-USAGE-ID    (WS-WQ-TEMP-INDX)             
A05460        COMPUTE S2-USAGE    = WS-WQ-READ (WS-WQ-IDX) -            
A05460                         WS-WQ-READ (WS-WQ-TEMP-INDX)             
A05460     END-SEARCH.                                                  
A05460                                                                  
A05460 2525-EXIT.                                                       
A05460     EXIT.                                                        
      ******************************************************************        
      * MOVE FACTOR HISTORY DETAILS FOR THE BILLING KEY.                        
      ******************************************************************        
       2530-SETUP-RESULT-RS3.                                           
      *                                                                         
           MOVE FH-EFF-DATE-FROM            TO S3-EFF-DATE-FROM.        
           MOVE FH-EFF-DATE-TO              TO S3-EFF-DATE-TO.          
           MOVE FH-CODE-SEASON              TO S3-CODE-SEASON.          
           MOVE FH-INSTR-USE-TYPE-CD        TO S3-INSTR-USE-TYPE-CD.    
           MOVE FH-CODE-TIME-PERIOD         TO S3-CODE-TIME-PERIOD.     
           MOVE FH-CMPNT-ID-CD              TO S3-CMPNT-ID-CD.          
           MOVE FH-FIXED-FCTR-TYP-CD        TO S3-FIXED-FCTR-TYP-CD.    
           MOVE FH-FIXED-FCTR-SEQ-NO        TO S3-FIXED-FCTR-SEQ-NO.    
           MOVE WS-DURATION-REMAIN-NO       TO S3-DURATION-REMAIN-NO.   
           MOVE FH-BLOCK-NO                 TO S3-BLOCK-NO.             
           MOVE FH-FCTR-POWER-10            TO S3-FCTR-POWER-10.        
           MOVE FH-FACTOR-ID                TO S3-FACT-ID.              
           MOVE FH-FACTOR                   TO S3-FACTOR.               
           IF FH-FCTR-POWER-10  NOT = 0                                 
              COMPUTE S3-FACTOR     = FH-FACTOR * 10**FH-FCTR-POWER-10  
           END-IF.                                                      
           IF FH-CODE-DEBIT-CREDIT = WS-CREDIT AND S3-FACTOR > 0        
              COMPUTE S3-FACTOR  = S3-FACTOR * -1                       
           END-IF                                                       
           IF CSR-DATABASE AND RD-SECURED-RATE-FL= WS-YES               
              MOVE 9                        TO S3-ALLOWED-BLOCKS        
           ELSE                                                         
              MOVE PS-BLOCK-NO              TO S3-ALLOWED-BLOCKS        
           END-IF.                                                      
                                                                        
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 7200-FETCH-FH-ROW           THRU 7200-EXIT.          
      *                                                                         
       2530-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE ACCOUNT LEVEL DETAILS TO RS5.                                      
      ******************************************************************        
       2550-SETUP-RESULT-RS5.                                           
      *                                                                         
           IF WS-DATE-EXTRACT = WS-CURRENT-DATE                         
              SET BILL-NOT-EXEMPT           TO TRUE                     
           ELSE                                                         
              SET BILL-EXEMPT               TO TRUE                     
           END-IF.                                                      
           IF WS-REV-MTH-LST-NRML >  0 AND                              
              AT-REV-MTH-LST-NRML <= WS-REV-MTH-LST-NRML                
              MOVE WS-YES                   TO S5-MST-ACCT-BILLED       
           END-IF.                                                      
           IF BN-DATE-EXTRACT NOT = SPACES AND                          
              BN-DATE-EXTRACT    <= WS-CURR-DT-PLUS-4D                  
              MOVE BN-DATE-EXTRACT          TO S5-DATE-EXTRACT          
           ELSE                                                         
              MOVE SPACES                   TO S5-DATE-EXTRACT          
           END-IF.                                                      
           MOVE AT-COMPANY-NO               TO S5-COMPANY-NO.           
           MOVE AT-LAST-UPDATE-TS           TO S5-AT-LAST-UPDATE-TS.    
           MOVE AT-ACCT-FINALED-DT          TO S5-ACCT-FINALED-DT.      
           MOVE C7-MIN-PRORATION-DAYS       TO S5-MIN-PRORATION-DAYS.   
           MOVE C7-MAX-PRORATION-DAYS       TO S5-MAX-PRORATION-DAYS.   
           MOVE WS-BILL-WINDOW-IND          TO S5-BILL-WINDOW-IND.      
           MOVE WS-CURR-REV-MONTH           TO S5-COMMON-REV-MONTH.     
           MOVE MN-MTR-READ-SOURCE-CD       TO S5-MV90-MTR-IND.         
                                                                        
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT.          
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE ACCOUNT METER NUMBER DETAILS TO METER-REG ARRAY                    
      ******************************************************************        
       2560-SETUP-MTR-REG-TBL.                                          
      *                                                                         
           ADD +1                           TO WS-MTR-RGSTR-CNT         
           SET WS-MTR-REG-INDX              TO WS-MTR-RGSTR-CNT         
           MOVE WS-METER-NO                 TO WS-MR-METER-NO           
                                               (WS-MTR-REG-INDX)        
           MOVE WS-MTR-REF-NO               TO WS-MR-MTR-REF-NO         
                                               (WS-MTR-REG-INDX)        
           MOVE WS-REG-ID-NO                TO WS-MR-REG-ID-NO          
                                               (WS-MTR-REG-INDX)        
           MOVE WS-CODE-METER-STATUS        TO WS-MR-CODE-METER-STATUS  
                                               (WS-MTR-REG-INDX)        
P00899     MOVE WS-CODE-REG-STATUS          TO WS-MR-CODE-REG-STATUS    
P00899                                         (WS-MTR-REG-INDX)        
           MOVE WS-MAX-NO-UNITS             TO WS-MR-MAX-NO-UNITS       
                                               (WS-MTR-REG-INDX)        
           MOVE WS-MIN-NO-UNITS             TO WS-MR-MIN-NO-UNITS       
                                               (WS-MTR-REG-INDX)        
           MOVE WS-CONSTANT                 TO WS-MR-CONSTANT           
                                               (WS-MTR-REG-INDX)        
           MOVE WS-NO-READ-DIALS            TO WS-MR-NO-READ-DIALS      
                                               (WS-MTR-REG-INDX)        
           MOVE WS-PCOMP-FCT                TO WS-MR-PCOMP-FCT          
                                               (WS-MTR-REG-INDX)        
           MOVE WS-LAST-REG-READ-DATE       TO WS-MR-LAST-REG-READ-DATE 
                                               (WS-MTR-REG-INDX)        
           MOVE WS-LAST-READ-VALUE          TO WS-MR-LAST-READ-VALUE    
                                               (WS-MTR-REG-INDX)        
           MOVE WS-CODE-USAGE-SOURCE        TO WS-MR-CODE-USAGE-SOURCE  
                                               (WS-MTR-REG-INDX)        
           MOVE MN-DIGTL-MTR-TYPE           TO WS-MR-DIGTL-MTR-TYPE     
                                               (WS-MTR-REG-INDX)        
           MOVE MN-MTR-READ-SOURCE-CD       TO WS-MR-MTR-READ-SOURCE-CD 
                                               (WS-MTR-REG-INDX)        
           MOVE WS-CODE-USAGE-TYPE          TO WS-MR-CODE-USAGE-TYPE    
                                               (WS-MTR-REG-INDX)        
           MOVE WS-CODE-TIME-PERIOD         TO WS-MR-CODE-TIME-PERIOD   
                                               (WS-MTR-REG-INDX)        
           MOVE WS-CODE-USAGE-ID            TO WS-MR-CODE-USAGE-ID      
                                               (WS-MTR-REG-INDX)        
           IF WS-CONSTANT = 0                                           
              MOVE WS-DEFAULT-CONSTANT      TO WS-MR-CONSTANT           
                                               (WS-MTR-REG-INDX)        
           END-IF.                                                      
           IF WS-NO-READ-DIALS = 0                                      
              MOVE WS-DEFAULT-NO-DIALS      TO WS-MR-NO-READ-DIALS      
                                               (WS-MTR-REG-INDX)        
           END-IF.                                                      
           IF WS-MAX-NO-UNITS = 0                                       
              MOVE WS-DEFAULT-MAX-UNITS     TO WS-MR-MAX-NO-UNITS       
                                               (WS-MTR-REG-INDX)        
           END-IF.                                                      
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE ACCOUNT METER NUMBER DETAILS TO RS7                                
      ******************************************************************        
       2570-SETUP-RESULT-RS7.                                           
      *                                                                         
           MOVE WS-METER-NO                 TO S7-METER-NO.             
           MOVE WS-MTR-REF-NO               TO S7-MTR-REF-NO.           
           MOVE WS-REG-ID-NO                TO S7-REG-ID-NO.            
           MOVE WS-CODE-METER-STATUS        TO S7-CODE-METER-STATUS.    
           MOVE WS-CODE-USAGE-VALUE         TO S7-CODE-USAGE-VALUE.     
           MOVE WS-MAX-NO-UNITS             TO S7-MAX-NO-UNITS.         
           MOVE WS-MIN-NO-UNITS             TO S7-MIN-NO-UNITS.         
           MOVE WS-CONSTANT                 TO S7-CONSTANT.             
           MOVE WS-NO-READ-DIALS            TO S7-NO-READ-DIALS.        
           MOVE WS-PCOMP-FCT                TO S7-PCOMP-FCT.            
           MOVE WS-LAST-REG-READ-DATE       TO S7-LAST-READ-DATE.       
           MOVE WS-LAST-READ-VALUE          TO S7-LAST-READ-VALUE.      
           MOVE WS-CODE-USAGE-SOURCE        TO S7-CODE-USAGE-SOURCE.    
           IF WS-CONSTANT = 0                                           
              MOVE WS-DEFAULT-CONSTANT      TO S7-CONSTANT              
           END-IF.                                                      
           IF WS-NO-READ-DIALS = 0                                      
              MOVE WS-DEFAULT-NO-DIALS      TO S7-NO-READ-DIALS         
           END-IF.                                                      
           IF WS-MAX-NO-UNITS = 0                                       
              MOVE WS-DEFAULT-MAX-UNITS     TO S7-MAX-NO-UNITS          
           END-IF.                                                      
                                                                        
           PERFORM 8070-INSERT-GTT-R7          THRU 8070-EXIT.          
                                                                        
       2570-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE ACCOUNT UNMETER DETAILS TO RS8                                     
      ******************************************************************        
       2580-SETUP-RESULT-RS8.                                           
      *                                                                         
           PERFORM 7540-GET-UM-EQUIP-DESC      THRU 7540-EXIT.          
           MOVE L9-UM-EQUIP-SHRT-DESC       TO S8-RATE-ITEM-DESC.       
           MOVE CP-NO-UNITS                 TO S8-NO-UNITS.             
           MOVE CP-USAGE-FIXED              TO S8-USAGE-FIXED.          
           MOVE CP-MTHLY-AMOUNT-FIXED       TO S8-MTHLY-AMOUNT-FIXED.   
           MOVE CP-ITEM-SEQ-NO              TO S8-ITEM-SEQ-NO.          
           MOVE CP-REMOVE-DATE              TO S8-REMOVE-DATE.          
           MOVE CP-LAST-BILL-DATE           TO S8-LAST-BILL-DATE.       
           MOVE CP-CODE-SERVICE-TYPE        TO S8-CODE-SERVICE-TYPE.    
           MOVE CP-CODE-PLAN-STATUS         TO S8-CODE-PLAN-STATUS.     
           MOVE CP-CODE-STAT-REASON         TO S8-CODE-STAT-REASON.     
           MOVE CP-RATE-ITEM-CODE           TO S8-RATE-ITEM-CODE.       
                                                                        
           PERFORM 8080-INSERT-GTT-R8          THRU 8080-EXIT.          
           PERFORM 7260-FETCH-UNMT-ROW         THRU 7260-EXIT.          
                                                                        
       2580-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE BILL ADJUSTMENT DETAILS TO RS9                                     
      ******************************************************************        
       2590-SETUP-RESULT-RS9.                                           
      *                                                                         
           IF BP-ADJ-TYPE-CD NOT = WS-RTOV                              
              MOVE BP-ADJ-TYPE-CD           TO S9-ADJ-TYPE-CD           
              MOVE BP-REVENUE-MONTH         TO S9-REVENUE-MONTH         
              MOVE BP-ADJ-REASON-DESC-TEXT(1:BP-ADJ-REASON-DESC-LEN)    
                                            TO S9-ADJ-REASON-DESC       
              MOVE BP-OVRRIDE-RT-REV-MTH    TO S9-OVRRIDE-RT-REV-MTH    
              MOVE BP-SPECIAL-PROCESS-CD    TO S9-SPECIAL-PROCESS-CD    
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
              WHEN BP-ADJ-TYPE-CD = WS-AGLP                             
              WHEN BP-ADJ-TYPE-CD = WS-NAGL                             
                 IF INSERT-RTOV                                         
                    SET DO-NOT-INSERT-RTOV  TO TRUE                     
                    MOVE WS-BP-ADJ-TYPE-CD  TO S9-ADJ-TYPE-CD(5:4)      
                    MOVE WS-BP-OVRRIDE-RT-REV-MTH                       
                                            TO S9-OVRRIDE-RT-REV-MTH    
                 END-IF                                                 
                 PERFORM 8090-INSERT-GTT-R9    THRU 8090-EXIT           
              WHEN BP-ADJ-TYPE-CD = WS-RTOV                             
                 SET INSERT-RTOV            TO TRUE                     
                 MOVE BP-ADJ-TYPE-CD        TO WS-BP-ADJ-TYPE-CD        
                 MOVE BP-REVENUE-MONTH      TO WS-BP-REVENUE-MONTH      
                 MOVE BP-ADJ-REASON-DESC-TEXT(1:BP-ADJ-REASON-DESC-LEN) 
                                            TO WS-BP-ADJ-REASON-DESC    
                 MOVE BP-OVRRIDE-RT-REV-MTH TO WS-BP-OVRRIDE-RT-REV-MTH 
                 MOVE BP-SPECIAL-PROCESS-CD TO WS-BP-SPECIAL-PROCESS-CD 
              WHEN BP-ADJ-TYPE-CD = WS-BADJ                             
                 PERFORM 7550-GET-BADJ-ADJST-RSN-CD                     
                                               THRU 7550-EXIT           
                 PERFORM 8090-INSERT-GTT-R9    THRU 8090-EXIT           
              WHEN OTHER                                                
                 PERFORM 8090-INSERT-GTT-R9    THRU 8090-EXIT           
           END-EVALUATE.                                                
                                                                        
           PERFORM 7290-FETCH-BP-ROW           THRU 7290-EXIT.          
                                                                        
       2590-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MOVE BILL ADJUSTMENT DETAILS TO RS9                                     
      ******************************************************************        
       2590A-SETUP-RESULT-RS9.                                          
      *                                                                         
           MOVE WS-BP-ADJ-TYPE-CD           TO S9-ADJ-TYPE-CD.          
           MOVE WS-BP-REVENUE-MONTH         TO S9-REVENUE-MONTH.        
           MOVE WS-BP-ADJ-REASON-DESC       TO S9-ADJ-REASON-DESC.      
           MOVE WS-BP-OVRRIDE-RT-REV-MTH    TO S9-OVRRIDE-RT-REV-MTH.   
           MOVE WS-BP-SPECIAL-PROCESS-CD    TO S9-SPECIAL-PROCESS-CD.   
                                                                        
           PERFORM 8090-INSERT-GTT-R9          THRU 8090-EXIT.          
                                                                        
       2590A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * GET CUSTOMER SERVICE CHARGE                                             
      ******************************************************************        
       6000-CALL-MCSCB063-PGM.                                          
                                                                        
           CALL MCSCB063 USING CWS00063-FIELDS                          
                              ,ABEND-FILE                               
                              ,WS-MCSCB063-RET-CODE                     
                                                                        
           IF WS-MCSCB063-RET-CODE = 0                                  
              CONTINUE                                                  
           ELSE                                                         
             MOVE WS-MCSCB063-RET-CODE      TO WS-ACTIVE-RETURN-CODE    
             MOVE 'CALL'                    TO ABEND-FUNCTION           
             MOVE 'MCSCB063'                TO TABLE-1                  
             PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET ACCOUNT DETAILS                                                     
      ******************************************************************        
       7000-GET-ACCT-DTLS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                    ,AT.MST_SUB_ACCT_IND                                
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.COMPANY_NO                                      
                INTO :AT-LAST-UPDATE-TS                                 
                    ,:AT-ACCT-FINALED-DT :WS-NULL-IND-9                  
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.LAST_UPDATE_TS                                          
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*         INTO :AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-NULL-IND-9                          
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*        WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-9 < 0                                      
                 MOVE SPACES                TO AT-ACCT-FINALED-DT       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CALCULATE END REVENUE MONTH                                             
      ******************************************************************        
       7001-GET-END-REVN-DT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              (SELECT IIF(TRY_CAST(E AS INT) IS NULL, CIS.INTEGER$(E), 
              CAST(E AS INT)) FROM (SELECT REPLACE(CIS.CHAR2$DATE(        
                   DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, 
                                                    :WS-START-REVN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-REVN-DATE
              ) <> 0) OR (LEN(:WS-START-REVN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-START-REVN-DATE
              ), CONVERT(DATE, :WS-START-REVN-DATE) ) ), 'ISO'), '-', 
           '') E) T)
            INTO
              :WS-REVN-DT-MINUS-11M-INT  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-REVN-DT-MINUS-11M-INT  = INT(REPLACE(CHAR(                
MFA-TR*            DATE(:WS-START-REVN-DATE) - 11 MONTH, ISO),'-',''))          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-REVN-DT-MINUS-11M-INT TO WS-REVN-DT-MINUS-11M     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7001'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'START REVENUE MONTH'    TO TABLE-ELEMENT-1          
              MOVE WS-START-REVN-DATE       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CALCULATE LAST REVENUE MONTH - 13 MONTHS DATE TO GET MTR/UNMTR          
      * HISTORY FOR LATEST 13 MONTHS IRRESPECTIVE OF REVENUE MNTH PASSED        
      ******************************************************************        
       7002-GET-RVN-MNTH-MINUS-12M.                                     
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(DATEADD( MONTH, -12, IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-REVN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REVN-DATE
              ) <> 0) OR (LEN(:WS-LAST-REVN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REVN-DATE
              ), CONVERT(DATE, :WS-LAST-REVN-DATE) ) ) AS CHAR(10))
            INTO
              :WS-LAST-REV-MTH-MINUS-12M         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-LAST-REV-MTH-MINUS-12M =                                  
MFA-TR*               CHAR(DATE(:WS-LAST-REVN-DATE) - 12 MONTH)                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7002'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'AT REVENUE MONTH'       TO TABLE-ELEMENT-1          
              MOVE WS-LAST-REVN-DATE        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * GET CURRENT REVENUE MONTH.                                              
      *****************************************************************         
       7005-GET-CURR-REVMNTH.                                           
                                                                        
           EXEC SQL                                                     
               SELECT CIS.CHAR2DECIMAL(CIS.SUBSTR3(PARM_DATA,15,6))             
                 INTO :WS-CURR-REV-MONTH                                
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                   
                  AND COMPANY_NO   = :WS-SCEG                           
                  AND CMND_CODE    = :WS-CMND-CODE                      
                  AND SEQ_NO       = :WS-SEQ-NO                         
                  AND STATUS       = :WS-ACTIVE                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     26750000
MFA-TR*        SELECT DECIMAL(SUBSTR(PARM_DATA,15,6))                           
MFA-TR*          INTO :WS-CURR-REV-MONTH                                        
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                           
MFA-TR*           AND COMPANY_NO   = :WS-SCEG                                   
MFA-TR*           AND CMND_CODE    = :WS-CMND-CODE                              
MFA-TR*           AND SEQ_NO       = :WS-SEQ-NO                                 
MFA-TR*           AND STATUS       = :WS-ACTIVE                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    26820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET CURRENT DATE                                                        
      ******************************************************************        
       7010-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              DATEADD( DAY, -4, CAST(SYSDATETIMEOFFSET() AS DATE) ),
              DATEADD( DAY, 4, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURRENT-DATE,
              :WS-CURR-DT-MINUS-4D,
              :WS-CURR-DT-PLUS-4D          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE     = CURRENT DATE                           
MFA-TR*          ,:WS-CURR-DT-MINUS-4D = CURRENT DATE - 4 DAYS                  
MFA-TR*          ,:WS-CURR-DT-PLUS-4D  = CURRENT DATE + 4 DAYS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-1          
              MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CHECK THE DATABASE IS CSR OR SEB.                                       
      ******************************************************************        
       7020-GET-DATABSE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
               WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
                 AND  COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY C8                                        
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*          AND  COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE          TO WS-DATABASE              
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ_VALUE'           TO TABLE-ELEMENT-1          
              MOVE 'DATABASE'               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE MAX/MIN PRORATE DAYS FOR THE COMPANY                            
      ******************************************************************        
       7030-SELECT-PRORATE-DAYS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT  MIN_PRORATION_DAYS                                
                    , MAX_PRORATION_DAYS                                
                INTO :C7-MIN-PRORATION-DAYS                             
                    ,:C7-MAX-PRORATION-DAYS                             
                FROM  CSS_COMPANY  C7 WITH(READUNCOMMITTED)                     
               WHERE  COMPANY_NO    = :C7-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MIN_PRORATION_DAYS                                        
MFA-TR*             , MAX_PRORATION_DAYS                                        
MFA-TR*         INTO :C7-MIN-PRORATION-DAYS                                     
MFA-TR*             ,:C7-MAX-PRORATION-DAYS                                     
MFA-TR*         FROM  CSS_COMPANY  C7                                           
MFA-TR*        WHERE  COMPANY_NO    = :C7-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_COMPANY'            TO TABLE-1                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE C7-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE BILL WINDOW DATE                                                
      ******************************************************************        
       7040-GET-BIL-WINDOW-DT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DATE_EXTRACT                                      
                INTO  :BN-DATE-EXTRACT                                  
                FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                     ,CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
               WHERE  BN.BILL_CYCLE    = AT.BILL_CYCLE                  
                 AND  AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                 
                 AND  BN.DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-CURR-DT-MINUS-4D
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DT-MINUS-4D
              ) <> 0) OR (LEN(:WS-CURR-DT-MINUS-4D
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-DT-MINUS-4D
              ), CONVERT(DATE, :WS-CURR-DT-MINUS-4D) )           
               ORDER BY BN.DATE_EXTRACT                                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DATE_EXTRACT                                              
MFA-TR*         INTO  :BN-DATE-EXTRACT                                          
MFA-TR*         FROM  CSS_BILL_WINDOW BN                                        
MFA-TR*              ,CSS_ACCOUNT     AT                                        
MFA-TR*        WHERE  BN.BILL_CYCLE    = AT.BILL_CYCLE                          
MFA-TR*          AND  AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                         
MFA-TR*          AND  BN.DATE_EXTRACT >= :WS-CURR-DT-MINUS-4D                   
MFA-TR*        ORDER BY BN.DATE_EXTRACT                                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO BN-DATE-EXTRACT          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE BILL WINDOW INDICATOR                                           
      ******************************************************************        
       7050-SELECT-BILWIND-IND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BN.REVENUE_MONTH,
              BN.DATE_EXTRACT                                   
                INTO  :BN-REVENUE-MONTH                                 
                     ,:WS-DATE-EXTRACT                                  
                FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                     ,CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
               WHERE  BN.BILL_CYCLE     = AT.BILL_CYCLE                 
                 AND  AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                
                 AND  BN.DATE_EXTRACT  <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
               ORDER BY BN.REVENUE_MONTH DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BN.REVENUE_MONTH                                          
MFA-TR*              ,BN.DATE_EXTRACT                                           
MFA-TR*         INTO  :BN-REVENUE-MONTH                                         
MFA-TR*              ,:WS-DATE-EXTRACT                                          
MFA-TR*         FROM  CSS_BILL_WINDOW BN                                        
MFA-TR*              ,CSS_ACCOUNT     AT                                        
MFA-TR*        WHERE  BN.BILL_CYCLE     = AT.BILL_CYCLE                         
MFA-TR*          AND  AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                        
MFA-TR*          AND  BN.DATE_EXTRACT  <= :WS-CURRENT-DATE                      
MFA-TR*        ORDER BY BN.REVENUE_MONTH DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                     TO BN-REVENUE-MONTH         
                 MOVE SPACES                TO WS-DATE-EXTRACT          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE LAST BILLED REVENUE MONTH FOR THE MASTER ACCOUNT.               
      ******************************************************************        
       7060-GET-MST-LST-REVNMNT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) IIF(TRY_CAST(AT.REV_MTH_LST_NRML
               AS INT) IS NULL, CIS.INTEGER(AT.REV_MTH_LST_NRML), CAST(
           AT.REV_MTH_LST_NRML AS INT)) REV_MTH_LST_NRML                       
                INTO  :WS-REV-MTH-LST-NRML                              
                FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)              
                     ,CSS_MSTSUB_ACCT     MU WITH(READUNCOMMITTED)              
               WHERE  AT.ACCOUNT_NO       = MU.MST_ACCT_NO              
                 AND  AT.MST_SUB_ACCT_IND = :WS-MST-ACCT                
                 AND  MU.SUB_ACCT_NO      = :MU-SUB-ACCT-NO             
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.REV_MTH_LST_NRML                                       
MFA-TR*         INTO  :WS-REV-MTH-LST-NRML                                      
MFA-TR*         FROM  CSS_ACCOUNT         AT                                    
MFA-TR*              ,CSS_MSTSUB_ACCT     MU                                    
MFA-TR*        WHERE  AT.ACCOUNT_NO       = MU.MST_ACCT_NO                      
MFA-TR*          AND  AT.MST_SUB_ACCT_IND = :WS-MST-ACCT                        
MFA-TR*          AND  MU.SUB_ACCT_NO      = :MU-SUB-ACCT-NO                     
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MSTSUB_ACCT'        TO TABLE-1                  
              MOVE 'SUB_ACCT_NO'            TO TABLE-ELEMENT-1          
              MOVE MU-SUB-ACCT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET LATEST BG ROW BILLING KEY WHEN WQ ITEM ID PASSED                    
      ******************************************************************        
       7070-GET-BILLING-KEY.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) BG.BILL_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP                     
                INTO :BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
              FROM   CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                 
                    ,CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)                 
              WHERE  BG.ACCOUNT_NO          = :BG-ACCOUNT-NO            
                AND  BG.IC_NO               = :BG-IC-NO                 
                AND  BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE        
                AND  BG.ACCOUNT_NO          = BI.ACCOUNT_NO             
                AND  BG.BILL_NO             = BI.BILL_NO                
               ORDER BY BI.BILL_NO DESC                                 
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.BILL_NO                                                 
MFA-TR*             ,BG.BILL_ITEM_TIMESTMP                                      
MFA-TR*         INTO :BG-BILL-NO                                                
MFA-TR*             ,:BG-BILL-ITEM-TIMESTMP                                     
MFA-TR*       FROM   CSS_BILLING_DET   BG                                       
MFA-TR*             ,CSS_BILLING_HDR   BI                                       
MFA-TR*       WHERE  BG.ACCOUNT_NO          = :BG-ACCOUNT-NO                    
MFA-TR*         AND  BG.IC_NO               = :BG-IC-NO                         
MFA-TR*         AND  BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                
MFA-TR*         AND  BG.ACCOUNT_NO          = BI.ACCOUNT_NO                     
MFA-TR*         AND  BG.BILL_NO             = BI.BILL_NO                        
MFA-TR*        ORDER BY BI.BILL_NO DESC                                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN BG CURSOR TO FETCH BILLING DETAIL ROWS                             
      ******************************************************************        
       7100-OPEN-BG-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_DTL'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH BILLING DETAIL ROWS.                                              
      ******************************************************************        
       7110-FETCH-BG-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
                 INTO :BG-BILL-NO                                       
                     ,:BG-BILL-ITEM-TIMESTMP                            
                     ,:BG-DATE-ORIG-BILL :WS-NULL-IND-1                  
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-REV-RPT-CD                                    
                     ,:BG-STANDBY-COMPLIED                              
                     ,:BG-PRORATE-CD                                    
                     ,:BG-NEW-RATE-PCT                                  
                     ,:BG-TAX-REFUND-CD                                 
                     ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND-2                
                     ,:BG-LFTM-HI-PEAK-DMD                              
                     ,:BG-REBILL-IND                                    
                     ,:BG-ADJ-REASON-CD                                 
                     ,:BG-REVENUE-MONTH                                 
                     ,:BG-GAS-BASE-USE                                  
                     ,:BG-WNA-FACTOR                                    
                     ,:BG-BTU-FACTOR                                    
                     ,:BG-NO-OF-CONS-DAYS                               
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-FUEL-SHIPPER-CD                               
                     ,:BG-TRNSP-OVER-MDQ-FL                             
                     ,:BG-RT-PKG-OPT-SEQ-NO :WS-NULL-IND-3               
                     ,:BI-BILL-CORRECTED-CD                             
                     ,:BI-DATE-BILLED :WS-NULL-IND-10                    
                     ,:BI-CODE-BILL-STATUS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1  < 0                                     
                 MOVE SPACES                TO BG-DATE-ORIG-BILL        
              END-IF                                                    
              IF WS-NULL-IND-2  < 0                                     
                 MOVE SPACES                TO BG-DATE-LFTM-HI-DMD      
              END-IF                                                    
              IF WS-NULL-IND-3  < 0                                     
                 MOVE ZERO                  TO BG-RT-PKG-OPT-SEQ-NO     
              END-IF                                                    
              IF WS-NULL-IND-10 < 0                                     
                 MOVE SPACES                TO BI-DATE-BILLED           
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
                 ADD +1                     TO WS-BILLING-KEY-NUM       
              ELSE                                                      
                 SET NO-MORE-DETAIL-RECS    TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_DTL'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE BG CURSOR                                                         
      ******************************************************************        
       7120-CLOSE-BG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_DTL'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN CX CURSOR TO FETCH BILLING METER CONSUMPTION DETAILS               
      ******************************************************************        
       7130-OPEN-CX-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN CX-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CNSMPTN_HIST '      TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE CX-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CX-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CX-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE CX-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH BILLING METERED CONSUMPTION DETAILS.                              
      ******************************************************************        
       7140-FETCH-CX-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
              FETCH CX-CURSOR                                           
               INTO :WS-CX-CODE-USAGE-VALUE                             
                   ,:CX-CODE-TIME-PERIOD                                
                   ,:CX-MTR-REF-NO                                      
                   ,:CX-CODE-USAGE-TYPE                                 
                   ,:CX-CODE-USAGE-ID                                   
                   ,:CX-CODE-USAGE-SOURCE                               
                   ,:CX-ITEM-SEQ-NO                                     
                   ,:CX-METER-NO                                        
                   ,:CX-REG-ID-NO                                       
                   ,:CX-DATE-READ :WS-NULL-IND-4                         
                   ,:CX-CODE-METER-READ                                 
                   ,:CX-CODE-METER-NO-READ                              
                   ,:CX-METER-READING                                   
                   ,:CX-DEMAND-READING                                  
                   ,:CX-EMPLOYEE-NO                                     
                   ,:CX-NO-UNITS                                        
                   ,:CX-NO-DEMAND-UNITS                                 
                   ,:CX-NO-DAYS                                         
                   ,:CX-CODE-SOURCE-ID                                  
                   ,:CX-CODE-DEBIT-CREDIT                               
                   ,:CX-CODE-ITEM-STATUS                                
                   ,:CX-CODE-DISCOUNT                                   
                   ,:CX-CONSTANT                                        
                   ,:CX-NO-DIALS                                        
                   ,:CX-EXCEPT-OVERRIDE-CD                              
                   ,:CX-REQUESTED-USAGE                                 
                   ,:CX-DIGTL-INTRL-MTR-NO                              
                   ,:CX-DIGTL-MTR-TYPE                                  
                   ,:CX-CODE-TOU-SEASN                                  
                   ,:CX-EXCL-DMD-RCHT-IND                               
                   ,:CX-MTR-READ-SOURCE-CD                              
                   ,:CX-PCOMP-FCT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-4 < 0                                      
                 MOVE SPACES                TO CX-DATE-READ             
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-CNSMPTN-RECS   TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '      TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE CX-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CX-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CX-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE CX-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE METER CONSUMPTION CURSOR.                                         
      ******************************************************************        
       7150-CLOSE-CX-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE CX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '      TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE CX-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CX-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CX-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE CX-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN UC CURSOR TO FETCH BILLING UNMETER CONSUMPTION DTLS                
      ******************************************************************        
       7160-OPEN-UC-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN UC-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7160'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UM_CNSMPT_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE UC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UC-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UC-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE UC-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH BILLING UNMETER CONSUMPTION DETAILS.                              
      ******************************************************************        
       7170-FETCH-UC-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
              FETCH UC-CURSOR                                           
               INTO :UC-RATE-ITEM-CODE                                  
                   ,:UC-ITEM-SEQ-NO                                     
                   ,:UC-NO-UNITS                                        
                   ,:UC-NO-DAYS                                         
                   ,:UC-CODE-DEBIT-CREDIT                               
                   ,:UC-USAGE-FIXED                                     
                   ,:UC-DATE-USAGE-ENDS :WS-NULL-IND-5                   
                   ,:UC-CODE-SERVICE-TYPE                               
                   ,:UC-CODE-ITEM-STATUS                                
                   ,:UC-CODE-SOURCE-ID                                  
                   ,:UC-MTHLY-AMOUNT-FIXED                              
                   ,:UC-DIST-NO                                         
                   ,:UC-LIGHT-NO                                        
                   ,:UC-POLE-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-5 < 0                                      
                 MOVE SPACES                TO UC-DATE-USAGE-ENDS       
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-UC-CNSMPTN-REC TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7170'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UM_CNSMPT_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE UC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UC-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UC-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE UC-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE UNMETER CONSUMPTION CURSOR                                        
      ******************************************************************        
       7180-CLOSE-UC-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE UC-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7180'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UM_CNSMPT_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE UC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UC-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UC-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE UC-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN FH CURSOR TO FETCH BILLING FACTOR DETAILS                          
      ******************************************************************        
       7190-OPEN-FH-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN FH-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7190'                   TO ACTIVE-PARAGRAPH         
              MOVE '0PEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCT_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE FH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FH-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FH-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE FH-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7190-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH BILLING FACTOR DETAILS.                                           
      ******************************************************************        
       7200-FETCH-FH-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH FH-CURSOR                                          
                INTO :FH-EFF-DATE-FROM :WS-NULL-IND-6                    
                    ,:FH-EFF-DATE-TO :WS-NULL-IND-7                      
                    ,:FH-FACTOR                                         
                    ,:FH-CODE-SEASON                                    
                    ,:FH-INSTR-USE-TYPE-CD                              
                    ,:FH-CODE-TIME-PERIOD                               
                    ,:FH-CMPNT-ID-CD                                    
                    ,:FH-FIXED-FCTR-TYP-CD                              
                    ,:FH-FIXED-FCTR-SEQ-NO                              
                    ,:WS-DURATION-REMAIN-NO :WS-NULL-IND-8               
                    ,:FH-RT-PKG-OPT-SEQ-NO                              
                    ,:FH-BLOCK-NO                                       
                    ,:FH-FCTR-POWER-10                                  
                    ,:FH-CODE-DEBIT-CREDIT                              
                    ,:FH-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-6 < 0                                      
                 MOVE SPACES                TO FH-EFF-DATE-FROM         
              END-IF                                                    
              IF WS-NULL-IND-7 < 0                                      
                 MOVE SPACES                TO FH-EFF-DATE-TO           
              END-IF                                                    
              IF WS-NULL-IND-8 < 0                                      
                 MOVE SPACES                TO WS-DURATION-REMAIN-NO    
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-FACTOR-RECS    TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCT_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE FH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FH-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FH-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE FH-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE BILLING FACTOR CURSOR                                             
      ******************************************************************        
       7210-CLOSE-FH-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE FH-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCT_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE FH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FH-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FH-BILL-NO               TO HOSTVAR-ELEMENT-3        
              MOVE FH-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN MT CURSOR TO FETCH METER NUMBER DETAILS                            
      ******************************************************************        
       7220-OPEN-MT-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN MT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE '0PEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH METER NUMBER DETAILS.                                             
      ******************************************************************        
       7230-FETCH-MT-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH MT-CURSOR                                          
                INTO :WS-CODE-USAGE-VALUE                               
                    ,:MN-METER-NO                                       
                    ,:MN-MTR-REF-NO                                     
                    ,:WS-REG-ID-NO                                      
                    ,:MN-CODE-METER-STATUS                              
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:MN-LAST-READ-VALUE                                
                    ,:WS-MIN-NO-UNITS                                   
                    ,:WS-MAX-NO-UNITS                                   
                    ,:MN-CODE-USAGE-TYPE                                
                    ,:MN-METER-PRESSURE                                 
                    ,:WS-CONSTANT                                       
                    ,:WS-NO-READ-DIALS                                  
                    ,:WS-CODE-USAGE-SOURCE                              
                    ,:WS-CODE-USAGE-TYPE                                
                    ,:WS-CODE-TIME-PERIOD                               
                    ,:WS-CODE-USAGE-ID                                  
                    ,:MN-DIGTL-MTR-TYPE                                 
                    ,:MN-MTR-READ-SOURCE-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-METER-RECS     TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE METER NUMBER CURSOR                                               
      ******************************************************************        
       7240-CLOSE-MT-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE MT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7240'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN UNMT CURSOR TO FETCH UNMETER DETAILS.                              
      ******************************************************************        
       7250-OPEN-UNMT-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN UNMT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE '0PEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_PLAN'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH UNMETER DETAILS.                                                  
      ******************************************************************        
       7260-FETCH-UNMT-ROW.                                             
      *                                                                         
           EXEC SQL                                                     
               FETCH UNMT-CURSOR                                        
                INTO :CP-NO-UNITS                                       
                    ,:CP-USAGE-FIXED                                    
                    ,:CP-MTHLY-AMOUNT-FIXED                             
                    ,:CP-ITEM-SEQ-NO                                    
                    ,:CP-REMOVE-DATE :WS-NULL-IND-11                     
                    ,:CP-LAST-BILL-DATE :WS-NULL-IND-12                  
                    ,:CP-CODE-SERVICE-TYPE                              
                    ,:CP-CODE-PLAN-STATUS                               
                    ,:CP-CODE-STAT-REASON                               
                    ,:CP-RATE-ITEM-CODE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-11 < 0                                     
                 MOVE SPACES                TO CP-REMOVE-DATE           
              END-IF                                                    
              IF WS-NULL-IND-12 < 0                                     
                 MOVE SPACES                TO CP-LAST-BILL-DATE        
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-UNMTR-RECS     TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7260'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_PLAN'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE UNMETER DETAIL CURSOR                                             
      ******************************************************************        
       7270-CLOSE-UNMT-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE UNMT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7270'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_PLAN'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN BP CURSOR TO FETCH BILL ADJUSTMENT DETAILS.                        
      ******************************************************************        
       7280-OPEN-BP-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BP-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE '0PEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_ADJUSTMNT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH BILL ADJUSTMENT DETAILS.                                          
      ******************************************************************        
       7290-FETCH-BP-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BP-CURSOR                                          
                INTO :BP-REVENUE-MONTH                                  
                    ,:BP-ADJ-TYPE-CD                                    
                    ,:BP-ADJ-REASON-DESC                                
                    ,:BP-OVRRIDE-RT-REV-MTH                             
                    ,:BP-OVRRIDE-RT-BILL-DT :WS-NULL-IND-13              
                    ,:BP-OVRRIDE-RT-BILL-CY                             
                    ,:BP-SPECIAL-PROCESS-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-13 < 0                                     
                 MOVE SPACES                TO BP-OVRRIDE-RT-BILL-DT    
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-BIL-ADJST-RECS TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7290'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_ADJUSTMNT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE BILL ADJUSTMENT DETAILS                                           
      ******************************************************************        
       7300-CLOSE-BP-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_ADJUSTMNT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN REG CURSOR TO FETCH REGISTER DETAILS OF ACTIVE METER.              
      ******************************************************************        
       7310-OPEN-RR-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN RR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
              MOVE '0PEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REGISTER_READ'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH ACTIVE METER REGISTER DETAILS.                                    
      ******************************************************************        
       7320-FETCH-RR-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH RR-CURSOR                                          
                INTO :WS-CODE-USAGE-VALUE                               
                    ,:WS-REG-ID-NO                                      
                    ,:WS-MIN-NO-UNITS                                   
                    ,:WS-MAX-NO-UNITS                                   
                    ,:WS-LAST-REG-READ-DATE                             
                    ,:WS-LAST-READ-VALUE                                
                    ,:WS-CONSTANT                                       
                    ,:WS-NO-READ-DIALS                                  
                    ,:WS-CODE-USAGE-SOURCE                              
                    ,:WS-CODE-USAGE-TYPE                                
                    ,:WS-CODE-TIME-PERIOD                               
                    ,:WS-CODE-USAGE-ID                                  
P00899              ,:WS-CODE-REG-STATUS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-REG-RECS       TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REGISTER_READ'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE REGISTER DETAILS CURSOR                                           
      ******************************************************************        
       7330-CLOSE-RR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE RR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7330'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REGISTER_READ'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN MTR CURSOR TO FETCH METER DETAILS OF LATEST 13 MONTHS              
      ******************************************************************        
       7340-OPEN-MTR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN MTR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7340'                   TO ACTIVE-PARAGRAPH         
              MOVE '0PEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7340-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * FETCH ALL METER DETAILS                                                 
      ******************************************************************        
       7350-FETCH-MTR-ROW.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH MTR-CURSOR                                         
                INTO :WS-CODE-USAGE-VALUE                               
                    ,:CX-PCOMP-FCT                                      
                    ,:CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                    ,:CX-METER-NO                                       
                    ,:CX-MTR-REF-NO                                     
                    ,:CX-REG-ID-NO                                      
                    ,:CX-CODE-TIME-PERIOD                               
                    ,:CX-CODE-USAGE-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 SET NO-MORE-MTR-RECS       TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CLOSE METER DETAILS CURSOR                                              
      ******************************************************************        
       7360-CLOSE-MTR-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE MTR-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7360'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET METER DETAILS.                                                      
      ******************************************************************        
       7400-GET-MTRD-DTLS.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) NO_CONSEC_ESTIMATE,
              CODE_METER_STATUS,
              'M'                                                
                INTO :MN-NO-CONSEC-ESTIMATE                             
                    ,:MN-CODE-METER-STATUS                              
                    ,:MN-MTR-READ-SOURCE-CD                             
                FROM CSS_MTRD_ENVRNMT      MN WITH(READUNCOMMITTED)             
               WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE           
                 AND IC_NO               = :MN-IC-NO                    
                 AND (MTR_READ_SOURCE_CD = 'M'                          
                  OR CODE_USAGE_SOURCE   = 'S')                         
            ORDER BY CODE_METER_STATUS                                  
                    ,NO_CONSEC_ESTIMATE  DESC                           
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_CONSEC_ESTIMATE                                         
MFA-TR*             ,CODE_METER_STATUS                                          
MFA-TR*             ,'M'                                                        
MFA-TR*         INTO :MN-NO-CONSEC-ESTIMATE                                     
MFA-TR*             ,:MN-CODE-METER-STATUS                                      
MFA-TR*             ,:MN-MTR-READ-SOURCE-CD                                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT      MN                                   
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :MN-IC-NO                            
MFA-TR*          AND (MTR_READ_SOURCE_CD = 'M'                                  
MFA-TR*           OR CODE_USAGE_SOURCE   = 'S')                                 
MFA-TR*     ORDER BY CODE_METER_STATUS                                          
MFA-TR*             ,NO_CONSEC_ESTIMATE  DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO MN-MTR-READ-SOURCE-CD    
                 MOVE 0                     TO MN-NO-CONSEC-ESTIMATE    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CHECK IF IC IS UNMETERED                                                
      ******************************************************************        
       7420-GET-CUST-PLAN-DTLS.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO  :WS-UNMTRD-ELEC-GAS                              
                 FROM  CSS_CUST_PLAN WITH(READUNCOMMITTED)                      
                WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                  
                  AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE              
                  AND  IC_NO          = :CP-IC-NO                       
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :WS-UNMTRD-ELEC-GAS                                      
MFA-TR*          FROM  CSS_CUST_PLAN                                            
MFA-TR*         WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                      
MFA-TR*           AND  IC_NO          = :CP-IC-NO                               
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET MTRD-ELEC-GAS          TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7420'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_PLAN'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET REBILL DETAIL INFO FOR CANCELLED ROW (IF PRESENT)                   
      ******************************************************************        
       7450-GET-BILLING-DTLS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT BG.BILL_NO                                         
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                              
                    ,BG.DATE_ORIG_BILL                                  
                    ,BG.AMT_BILL_ITEM                                   
                    ,BG.CODE_BILL_CALC                                  
                    ,BG.CODE_BILL_ITM_TYPE                              
                    ,BG.CODE_BILL_ITM_IND                               
                    ,BG.CODE_DR_CR_CNSMPTN                              
                    ,BG.AMT_STATE_TAX                                   
                    ,BG.AMT_CITY_TAX                                    
                    ,BG.AMT_OTHER_TAX                                   
                    ,BG.CODE_REVENUE_CLASS                              
                    ,BG.CODE_SIC_NO                                     
                    ,BG.RATE_PLAN_NO                                    
                    ,BG.CODE_CURTAIL_PRTY                               
                    ,BG.CODE_STAT_TAX_XMT                               
                    ,BG.CODE_CITY_TAX_XMT                               
                    ,BG.CODE_OTHR_TAX_XMT                               
                    ,BG.REV_RPT_CD                                      
                    ,BG.STANDBY_COMPLIED                                
                    ,BG.PRORATE_CD                                      
                    ,BG.NEW_RATE_PCT                                    
                    ,BG.TAX_REFUND_CD                                   
                    ,BG.DATE_LFTM_HI_DMD                                
                    ,BG.LFTM_HI_PEAK_DMD                                
                    ,BG.REBILL_IND                                      
                    ,BG.ADJ_REASON_CD                                   
                    ,BG.REVENUE_MONTH                                   
                    ,BG.GAS_BASE_USE                                    
                    ,BG.WNA_FACTOR                                      
                    ,BG.BTU_FACTOR                                      
                    ,BG.NO_OF_CONS_DAYS                                 
                    ,BG.REV_MTH_ORIG_BILL                               
                    ,BG.FUEL_SHIPPER_CD                                 
                    ,BG.TRNSP_OVER_MDQ_FL                               
                    ,BG.RT_PKG_OPT_SEQ_NO                               
                    ,BI.BILL_CORRECTED_CD                               
                    ,BI.DATE_BILLED                                     
                    ,BI.CODE_BILL_STATUS                                
                INTO :BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-DATE-ORIG-BILL :WS-NULL-IND-1                   
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-RPT-CD                                     
                    ,:BG-STANDBY-COMPLIED                               
                    ,:BG-PRORATE-CD                                     
                    ,:BG-NEW-RATE-PCT                                   
                    ,:BG-TAX-REFUND-CD                                  
                    ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND-2                 
                    ,:BG-LFTM-HI-PEAK-DMD                               
                    ,:BG-REBILL-IND                                     
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-GAS-BASE-USE                                   
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-NO-OF-CONS-DAYS                                
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-FUEL-SHIPPER-CD                                
                    ,:BG-TRNSP-OVER-MDQ-FL                              
                    ,:BG-RT-PKG-OPT-SEQ-NO :WS-NULL-IND-3                
                    ,:BI-BILL-CORRECTED-CD                              
                    ,:BI-DATE-BILLED :WS-NULL-IND-10                     
                    ,:BI-CODE-BILL-STATUS                               
              FROM   CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                 
                    ,CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)                 
              WHERE  BG.ACCOUNT_NO          = :BG-ACCOUNT-NO            
                AND  BG.IC_NO               = :BG-IC-NO                 
                AND  BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE        
                AND  BG.BILL_NO             = :BG-BILL-NO               
                AND  BG.BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
                AND  BG.ACCOUNT_NO          = BI.ACCOUNT_NO             
                AND  BG.BILL_NO             = BI.BILL_NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.BILL_NO                                                 
MFA-TR*             ,BG.BILL_ITEM_TIMESTMP                                      
MFA-TR*             ,BG.DATE_ORIG_BILL                                          
MFA-TR*             ,BG.AMT_BILL_ITEM                                           
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*             ,BG.CODE_BILL_ITM_TYPE                                      
MFA-TR*             ,BG.CODE_BILL_ITM_IND                                       
MFA-TR*             ,BG.CODE_DR_CR_CNSMPTN                                      
MFA-TR*             ,BG.AMT_STATE_TAX                                           
MFA-TR*             ,BG.AMT_CITY_TAX                                            
MFA-TR*             ,BG.AMT_OTHER_TAX                                           
MFA-TR*             ,BG.CODE_REVENUE_CLASS                                      
MFA-TR*             ,BG.CODE_SIC_NO                                             
MFA-TR*             ,BG.RATE_PLAN_NO                                            
MFA-TR*             ,BG.CODE_CURTAIL_PRTY                                       
MFA-TR*             ,BG.CODE_STAT_TAX_XMT                                       
MFA-TR*             ,BG.CODE_CITY_TAX_XMT                                       
MFA-TR*             ,BG.CODE_OTHR_TAX_XMT                                       
MFA-TR*             ,BG.REV_RPT_CD                                              
MFA-TR*             ,BG.STANDBY_COMPLIED                                        
MFA-TR*             ,BG.PRORATE_CD                                              
MFA-TR*             ,BG.NEW_RATE_PCT                                            
MFA-TR*             ,BG.TAX_REFUND_CD                                           
MFA-TR*             ,BG.DATE_LFTM_HI_DMD                                        
MFA-TR*             ,BG.LFTM_HI_PEAK_DMD                                        
MFA-TR*             ,BG.REBILL_IND                                              
MFA-TR*             ,BG.ADJ_REASON_CD                                           
MFA-TR*             ,BG.REVENUE_MONTH                                           
MFA-TR*             ,BG.GAS_BASE_USE                                            
MFA-TR*             ,BG.WNA_FACTOR                                              
MFA-TR*             ,BG.BTU_FACTOR                                              
MFA-TR*             ,BG.NO_OF_CONS_DAYS                                         
MFA-TR*             ,BG.REV_MTH_ORIG_BILL                                       
MFA-TR*             ,BG.FUEL_SHIPPER_CD                                         
MFA-TR*             ,BG.TRNSP_OVER_MDQ_FL                                       
MFA-TR*             ,BG.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,BI.BILL_CORRECTED_CD                                       
MFA-TR*             ,BI.DATE_BILLED                                             
MFA-TR*             ,BI.CODE_BILL_STATUS                                        
MFA-TR*         INTO :BG-BILL-NO                                                
MFA-TR*             ,:BG-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:BG-DATE-ORIG-BILL:WS-NULL-IND-1                           
MFA-TR*             ,:BG-AMT-BILL-ITEM                                          
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*             ,:BG-CODE-BILL-ITM-TYPE                                     
MFA-TR*             ,:BG-CODE-BILL-ITM-IND                                      
MFA-TR*             ,:BG-CODE-DR-CR-CNSMPTN                                     
MFA-TR*             ,:BG-AMT-STATE-TAX                                          
MFA-TR*             ,:BG-AMT-CITY-TAX                                           
MFA-TR*             ,:BG-AMT-OTHER-TAX                                          
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:BG-CODE-SIC-NO                                            
MFA-TR*             ,:BG-RATE-PLAN-NO                                           
MFA-TR*             ,:BG-CODE-CURTAIL-PRTY                                      
MFA-TR*             ,:BG-CODE-STAT-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-CITY-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-OTHR-TAX-XMT                                      
MFA-TR*             ,:BG-REV-RPT-CD                                             
MFA-TR*             ,:BG-STANDBY-COMPLIED                                       
MFA-TR*             ,:BG-PRORATE-CD                                             
MFA-TR*             ,:BG-NEW-RATE-PCT                                           
MFA-TR*             ,:BG-TAX-REFUND-CD                                          
MFA-TR*             ,:BG-DATE-LFTM-HI-DMD:WS-NULL-IND-2                         
MFA-TR*             ,:BG-LFTM-HI-PEAK-DMD                                       
MFA-TR*             ,:BG-REBILL-IND                                             
MFA-TR*             ,:BG-ADJ-REASON-CD                                          
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-GAS-BASE-USE                                           
MFA-TR*             ,:BG-WNA-FACTOR                                             
MFA-TR*             ,:BG-BTU-FACTOR                                             
MFA-TR*             ,:BG-NO-OF-CONS-DAYS                                        
MFA-TR*             ,:BG-REV-MTH-ORIG-BILL                                      
MFA-TR*             ,:BG-FUEL-SHIPPER-CD                                        
MFA-TR*             ,:BG-TRNSP-OVER-MDQ-FL                                      
MFA-TR*             ,:BG-RT-PKG-OPT-SEQ-NO:WS-NULL-IND-3                        
MFA-TR*             ,:BI-BILL-CORRECTED-CD                                      
MFA-TR*             ,:BI-DATE-BILLED:WS-NULL-IND-10                             
MFA-TR*             ,:BI-CODE-BILL-STATUS                                       
MFA-TR*       FROM   CSS_BILLING_DET   BG                                       
MFA-TR*             ,CSS_BILLING_HDR   BI                                       
MFA-TR*       WHERE  BG.ACCOUNT_NO          = :BG-ACCOUNT-NO                    
MFA-TR*         AND  BG.IC_NO               = :BG-IC-NO                         
MFA-TR*         AND  BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                
MFA-TR*         AND  BG.BILL_NO             = :BG-BILL-NO                       
MFA-TR*         AND  BG.BILL_ITEM_TIMESTMP  = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*         AND  BG.ACCOUNT_NO          = BI.ACCOUNT_NO                     
MFA-TR*         AND  BG.BILL_NO             = BI.BILL_NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1  < 0                                     
                 MOVE SPACES                TO BG-DATE-ORIG-BILL        
              END-IF                                                    
              IF WS-NULL-IND-2  < 0                                     
                 MOVE SPACES                TO BG-DATE-LFTM-HI-DMD      
              END-IF                                                    
              IF WS-NULL-IND-3  < 0                                     
                 MOVE ZERO                  TO BG-RT-PKG-OPT-SEQ-NO     
              END-IF                                                    
              IF WS-NULL-IND-10 < 0                                     
                 MOVE SPACES                TO BI-DATE-BILLED           
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
                 ADD +1                     TO WS-BILLING-KEY-NUM       
              ELSE                                                      
                 SET NO-MORE-DETAIL-RECS    TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7450'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE HOURLY REGISTER TYPE                                            
      ******************************************************************        
       7460-GET-HOURLY-REG-TYPE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-HRLY-REGISTER                                  
                FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
                 AND REG_TYPE_CD      =  'H'                            
                 AND VERSION_NO_CNTRL = (                               
                        SELECT MAX(VERSION_NO_CNTRL)                    
                          FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)          
                         WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE     
                           AND RATE_PLAN_NO    = :J1-RATE-PLAN-NO)      
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-HRLY-REGISTER                                          
MFA-TR*         FROM CSS_RATE_COMP_DEF                                          
MFA-TR*        WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                      
MFA-TR*          AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                        
MFA-TR*          AND REG_TYPE_CD      =  'H'                                    
MFA-TR*          AND VERSION_NO_CNTRL = (                                       
MFA-TR*                 SELECT MAX(VERSION_NO_CNTRL)                            
MFA-TR*                   FROM CSS_RATE_COMP_DEF                                
MFA-TR*                  WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE             
MFA-TR*                    AND RATE_PLAN_NO    = :J1-RATE-PLAN-NO)              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET NOT-HRLY-REGISTER      TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7460'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE J1-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7460-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CHECK WHETHER THE ACCOUNT IS CIG CUSTOMER.                              
      ******************************************************************        
       7470-CHECK-CIG-CUSTOMER.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CIG-CUSTOMER                                   
                FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
                 AND REG_TYPE_CD      =  'D'                            
                 AND VERSION_NO_CNTRL = (                               
                        SELECT MAX(VERSION_NO_CNTRL)                    
                          FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)          
                         WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE     
                           AND RATE_PLAN_NO    = :J1-RATE-PLAN-NO)      
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CIG-CUSTOMER                                           
MFA-TR*         FROM CSS_RATE_COMP_DEF                                          
MFA-TR*        WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                      
MFA-TR*          AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                        
MFA-TR*          AND REG_TYPE_CD      =  'D'                                    
MFA-TR*          AND VERSION_NO_CNTRL = (                                       
MFA-TR*                 SELECT MAX(VERSION_NO_CNTRL)                            
MFA-TR*                   FROM CSS_RATE_COMP_DEF                                
MFA-TR*                  WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE             
MFA-TR*                    AND RATE_PLAN_NO    = :J1-RATE-PLAN-NO)              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET NOT-CIG-CUSTOMER       TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7470'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE J1-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7470-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CHECK WHETHER THE ACCOUNT IS SECURED RATE ACCOUNT.                      
      ******************************************************************        
       7480-CHECK-SECUR-RATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT SECURED_RATE_FL                                    
               INTO :RD-SECURED-RATE-FL                                 
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SECURED_RATE_FL                                            
MFA-TR*        INTO :RD-SECURED-RATE-FL                                         
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE                      
MFA-TR*          AND RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7480'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE RD-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7480-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET ALLOWED BLOCK DETAILS FOR NON SECURED RATE ACCOUNTS                 
      ******************************************************************        
       7490-GET-ALLOWED-BLOCK-NO.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) BLOCK_NO                                          
                 INTO :PS-BLOCK-NO                                      
                 FROM CSS_PRICE_SCHED       PS WITH(READUNCOMMITTED)            
                WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO          
                  AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE        
                  AND PS.VERSION_NO_CNTRL   = (                         
                      SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)             
                       WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE         
                         AND RATE_PLAN_NO   = PS.RATE_PLAN_NO           
                         AND CODE_STATUS    IN ('A','T') )              
                 ORDER BY BLOCK_NO DESC                                 
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BLOCK_NO                                                  
MFA-TR*          INTO :PS-BLOCK-NO                                              
MFA-TR*          FROM CSS_PRICE_SCHED       PS                                  
MFA-TR*         WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO                  
MFA-TR*           AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE                
MFA-TR*           AND PS.VERSION_NO_CNTRL   = (                                 
MFA-TR*               SELECT MAX(VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_RATE_CREATOR                                   
MFA-TR*                WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE                 
MFA-TR*                  AND RATE_PLAN_NO   = PS.RATE_PLAN_NO                   
MFA-TR*                  AND CODE_STATUS    IN ('A','T') )                      
MFA-TR*          ORDER BY BLOCK_NO DESC                                         
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                     TO PS-BLOCK-NO              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7490'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PRICE_SCHED'        TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE PS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PS-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7490-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET RT PKG SEQ # FROM UT TABLE FOR SEB ACCTS NOT BILLED ONCE            
      ******************************************************************        
       7495-GET-UT-RTPKG-NUM.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT UT.RT_PKG_OPT_SEQ_NO                               
               INTO :UT-RT-PKG-OPT-SEQ-NO                               
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO      =  :UT-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE              
                 AND IC_NO           =  :UT-IC-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*        INTO :UT-RT-PKG-OPT-SEQ-NO                                       
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*        WHERE ACCOUNT_NO      =  :UT-ACCOUNT-NO                          
MFA-TR*          AND CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE                      
MFA-TR*          AND IC_NO           =  :UT-IC-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7495'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7495-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET OPTION DETAILS FOR SCANA ENERGY ACCOUNTS                            
      ******************************************************************        
       7500-GET-OPTN-DTLS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT FI.OPT_DESC_INT                                    
                    ,FI.OPTION_CD                                       
                    ,FI.OPT_CALC_TYPE_CD                                
                    ,DF.STATUS_EFF_REV_MTH                              
                    ,DF.STATUS_CD                                       
                INTO :FI-OPT-DESC-INT                                   
                    ,:DF-OPTION-CD                                      
                    ,:FI-OPT-CALC-TYPE-CD                               
                    ,:DF-STATUS-EFF-REV-MTH                             
                    ,:DF-STATUS-CD                                      
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
                 AND DF.OPTION_CD          = FI.OPTION_CD               
      *          AND FI.OPTION_START_DT   <= CURRENT DATE                       
      *          AND FI.OPTION_END_DT     >= CURRENT DATE                       
                 AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
                 AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
                 AND FI.PROC_STATUS_CD     = 'AC'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*             ,FI.OPTION_CD                                               
MFA-TR*             ,FI.OPT_CALC_TYPE_CD                                        
MFA-TR*             ,DF.STATUS_EFF_REV_MTH                                      
MFA-TR*             ,DF.STATUS_CD                                               
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*             ,:DF-OPTION-CD                                              
MFA-TR*             ,:FI-OPT-CALC-TYPE-CD                                       
MFA-TR*             ,:DF-STATUS-EFF-REV-MTH                                     
MFA-TR*             ,:DF-STATUS-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPTION_START_DT   <= CURRENT DATE                       
MFA-TR*          AND FI.OPTION_END_DT     >= CURRENT DATE                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO FI-OPT-DESC-INT          
                 MOVE SPACES                TO DF-OPTION-CD             
              END-IF                                                    
           ELSE                                                         
             MOVE '7500'                    TO ACTIVE-PARAGRAPH         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1                  
             MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1          
             MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2          
             MOVE 'IC_NO'                   TO TABLE-ELEMENT-3          
             MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-4          
             MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
             MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2        
             MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3        
             MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4        
             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET OLDEST REVENUE MONTH FOR RENEWED OR DELETE ROWS                     
      ******************************************************************        
       7510-GET-OLD-RVN-MNTH.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) IIF(TRY_CAST(BG.REVENUE_MONTH
               AS INT) IS NULL, CIS.INTEGER(BG.REVENUE_MONTH), CAST(
           BG.REVENUE_MONTH AS INT)) REVENUE_MONTH                             
                INTO :WS-EFF-REV-MTH-TMP                                
                FROM CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                 
               WHERE BG.ACCOUNT_NO        = :DF-ACCOUNT-NO              
                 AND BG.IC_NO             = :DF-IC-NO                   
                 AND BG.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE          
                 AND BG.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO       
                 AND BG.CODE_BILL_CALC    =  'A'                        
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  = 'A'                        
                 AND BG.REVENUE_MONTH     > 0                           
               ORDER BY REVENUE_MONTH ASC                               
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.REVENUE_MONTH                                           
MFA-TR*         INTO :WS-EFF-REV-MTH-TMP                                        
MFA-TR*         FROM CSS_BILLING_DET   BG                                       
MFA-TR*        WHERE BG.ACCOUNT_NO        = :DF-ACCOUNT-NO                      
MFA-TR*          AND BG.IC_NO             = :DF-IC-NO                           
MFA-TR*          AND BG.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                  
MFA-TR*          AND BG.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO               
MFA-TR*          AND BG.CODE_BILL_CALC    =  'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*          AND BG.REVENUE_MONTH     > 0                                   
MFA-TR*        ORDER BY REVENUE_MONTH ASC                                       
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                     TO WS-EFF-REV-MTH-TMP       
              END-IF                                                    
           ELSE                                                         
             MOVE '7510'                    TO ACTIVE-PARAGRAPH         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1                  
             MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1          
             MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2          
             MOVE 'IC_NO'                   TO TABLE-ELEMENT-3          
             MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-4          
             MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
             MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2        
             MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3        
             MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4        
             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET RATE DESCRIPTION FOR UNMETER RATE PLAN #.                           
      ******************************************************************        
       7520-GET-UNMTRD-RT-DESC.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) L9.UM_EQUIP_SHRT_DESC                              
                INTO :L9-UM-EQUIP-SHRT-DESC                             
                FROM CSS_UNMTR_PLAN   UP WITH(READUNCOMMITTED)                  
                    ,CSS_UM_EQUIPMENT L9 WITH(READUNCOMMITTED)                  
               WHERE UP.UM_EQUIP_ID    =  L9.UM_EQUIP_ID                
                 AND UP.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE             
                 AND UP.RATE_PLAN_NO   = :UP-RATE-PLAN-NO               
                 AND UP.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE             
                 AND L9.STATUS_CD      = :WS-ACTIVE                     
                 AND UP.VERSION_NO_CNTRL =                              
                        (SELECT MAX(RT.VERSION_NO_CNTRL)                
                           FROM CSS_RATE_CREATOR  RT
                           WITH(READUNCOMMITTED)                    
                          WHERE RT.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE  
                            AND RT.RATE_PLAN_NO   = :UP-RATE-PLAN-NO    
                            AND RT.CODE_STATUS    = :WS-ACTIVE)         
              ORDER BY UP.RATE_ITEM_CODE                                
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT L9.UM_EQUIP_SHRT_DESC                                      
MFA-TR*         INTO :L9-UM-EQUIP-SHRT-DESC                                     
MFA-TR*         FROM CSS_UNMTR_PLAN   UP                                        
MFA-TR*             ,CSS_UM_EQUIPMENT L9                                        
MFA-TR*        WHERE UP.UM_EQUIP_ID    =  L9.UM_EQUIP_ID                        
MFA-TR*          AND UP.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE                     
MFA-TR*          AND UP.RATE_PLAN_NO   = :UP-RATE-PLAN-NO                       
MFA-TR*          AND UP.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE                     
MFA-TR*          AND L9.STATUS_CD      = :WS-ACTIVE                             
MFA-TR*          AND UP.VERSION_NO_CNTRL =                                      
MFA-TR*                 (SELECT MAX(RT.VERSION_NO_CNTRL)                        
MFA-TR*                    FROM CSS_RATE_CREATOR  RT                            
MFA-TR*                   WHERE RT.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE          
MFA-TR*                     AND RT.RATE_PLAN_NO   = :UP-RATE-PLAN-NO            
MFA-TR*                     AND RT.CODE_STATUS    = :WS-ACTIVE)                 
MFA-TR*       ORDER BY UP.RATE_ITEM_CODE                                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO L9-UM-EQUIP-SHRT-DESC    
              END-IF                                                    
           ELSE                                                         
             MOVE '7520'                    TO ACTIVE-PARAGRAPH         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                  
             MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1          
             MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2          
             MOVE 'RATE_ITEM_CODE'          TO TABLE-ELEMENT-3          
             MOVE UP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1        
             MOVE UP-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2        
             MOVE UP-RATE-ITEM-CODE         TO HOSTVAR-ELEMENT-3        
             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET METER REGISTER DETAILS.                                             
      ******************************************************************        
       7530-GET-MTRD-REG-DTLS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT MN.MTR_REF_NO                                      
                    ,MN.MIN_NO_UNITS                                    
                    ,MN.MAX_NO_UNITS                                    
                INTO :MN-MTR-REF-NO                                     
                    ,:MN-MIN-NO-UNITS                                   
                    ,:MN-MAX-NO-UNITS                                   
                FROM CSS_MTRD_ENVRNMT      MN WITH(READUNCOMMITTED)             
               WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE           
                 AND IC_NO               = :MN-IC-NO                    
                 AND MTR_REF_NO          = :CX-MTR-REF-NO               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.MTR_REF_NO                                              
MFA-TR*             ,MN.MIN_NO_UNITS                                            
MFA-TR*             ,MN.MAX_NO_UNITS                                            
MFA-TR*         INTO :MN-MTR-REF-NO                                             
MFA-TR*             ,:MN-MIN-NO-UNITS                                           
MFA-TR*             ,:MN-MAX-NO-UNITS                                           
MFA-TR*         FROM CSS_MTRD_ENVRNMT      MN                                   
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :MN-IC-NO                            
MFA-TR*          AND MTR_REF_NO          = :CX-MTR-REF-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD +1                     TO WS-MN-REG-CNT            
                 SET WS-REG-INDX            TO WS-MN-REG-CNT            
                 MOVE MN-MTR-REF-NO         TO                          
                                        WS-MN-MTR-REF-NO(WS-REG-INDX)   
                 MOVE MN-MIN-NO-UNITS       TO                          
                                        WS-MN-MIN-NO-UNITS(WS-REG-INDX) 
                 MOVE MN-MAX-NO-UNITS       TO                          
                                        WS-MN-MAX-NO-UNITS(WS-REG-INDX) 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7530'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7530-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET EQUIPMENT DESCRIPTION FOR UNMETER RATE ITEM CODE.                   
      ******************************************************************        
       7540-GET-UM-EQUIP-DESC.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) L9.UM_EQUIP_SHRT_DESC                              
                INTO :L9-UM-EQUIP-SHRT-DESC                             
                FROM                                                    
                     CSS_UM_EQUIPMENT     L9 WITH(READUNCOMMITTED)              
                    ,CSS_UNMTR_PLAN       UP WITH(READUNCOMMITTED)              
                    ,CSS_UTIL_ENVRNMT     UT WITH(READUNCOMMITTED)              
                    ,CSS_RATE_CREATOR     RT WITH(READUNCOMMITTED)              
               WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
                 AND UT.IC_NO             = :UT-IC-NO                   
                 AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
                 AND L9.UM_EQUIP_ID       = UP.UM_EQUIP_ID              
                 AND UT.CODE_UTIL_TYPE    = UP.CODE_UTIL_TYPE           
                 AND UT.RATE_PLAN_NO      = UP.RATE_PLAN_NO             
                 AND UP.RATE_ITEM_CODE    = :CP-RATE-ITEM-CODE          
                 AND RT.RATE_PLAN_NO      = UP.RATE_PLAN_NO             
                 AND RT.VERSION_NO_CNTRL  = UP.VERSION_NO_CNTRL         
                 AND RT.CODE_STATUS      <> :WS-TEST                    
                 AND RT.FROM_EFFECTIVE_DT =                             
                    (SELECT MAX(RC.FROM_EFFECTIVE_DT)                   
                       FROM CSS_RATE_CREATOR   RC WITH(READUNCOMMITTED)         
                      WHERE RC.RATE_PLAN_NO  = RT.RATE_PLAN_NO          
                        AND RC.CODE_STATUS  <> :WS-TEST                 
                    )                                                   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT L9.UM_EQUIP_SHRT_DESC                                      
MFA-TR*         INTO :L9-UM-EQUIP-SHRT-DESC                                     
MFA-TR*         FROM                                                            
MFA-TR*              CSS_UM_EQUIPMENT     L9                                    
MFA-TR*             ,CSS_UNMTR_PLAN       UP                                    
MFA-TR*             ,CSS_UTIL_ENVRNMT     UT                                    
MFA-TR*             ,CSS_RATE_CREATOR     RT                                    
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                      
MFA-TR*          AND UT.IC_NO             = :UT-IC-NO                           
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND L9.UM_EQUIP_ID       = UP.UM_EQUIP_ID                      
MFA-TR*          AND UT.CODE_UTIL_TYPE    = UP.CODE_UTIL_TYPE                   
MFA-TR*          AND UT.RATE_PLAN_NO      = UP.RATE_PLAN_NO                     
MFA-TR*          AND UP.RATE_ITEM_CODE    = :CP-RATE-ITEM-CODE                  
MFA-TR*          AND RT.RATE_PLAN_NO      = UP.RATE_PLAN_NO                     
MFA-TR*          AND RT.VERSION_NO_CNTRL  = UP.VERSION_NO_CNTRL                 
MFA-TR*          AND RT.CODE_STATUS      <> :WS-TEST                            
MFA-TR*          AND RT.FROM_EFFECTIVE_DT =                                     
MFA-TR*             (SELECT MAX(RC.FROM_EFFECTIVE_DT)                           
MFA-TR*                FROM CSS_RATE_CREATOR   RC                               
MFA-TR*               WHERE RC.RATE_PLAN_NO  = RT.RATE_PLAN_NO                  
MFA-TR*                 AND RC.CODE_STATUS  <> :WS-TEST                         
MFA-TR*             )                                                           
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO L9-UM-EQUIP-SHRT-DESC    
              END-IF                                                    
           ELSE                                                         
             MOVE '7540'                    TO ACTIVE-PARAGRAPH         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                  
             MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1          
             MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2          
             MOVE 'RATE_ITEM_CODE'          TO TABLE-ELEMENT-3          
             MOVE UP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1        
             MOVE UP-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2        
             MOVE UP-RATE-ITEM-CODE         TO HOSTVAR-ELEMENT-3        
             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7540-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET ADJUSTMENT REASON CODE.                                             
      ******************************************************************        
       7550-GET-BADJ-ADJST-RSN-CD.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) K0.ADJ_REASON_CD                                   
                INTO :K0-ADJ-REASON-CD                                  
                FROM CSS_BILL_ADJ_REASN    K0 WITH(READUNCOMMITTED)             
               WHERE ADJ_REASON_DESC     = :BP-ADJ-REASON-DESC          
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT K0.ADJ_REASON_CD                                           
MFA-TR*         INTO :K0-ADJ-REASON-CD                                          
MFA-TR*         FROM CSS_BILL_ADJ_REASN    K0                                   
MFA-TR*        WHERE ADJ_REASON_DESC     = :BP-ADJ-REASON-DESC                  
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE K0-ADJ-REASON-CD      TO S9-ADJ-REASON-CD         
              ELSE                                                      
                 MOVE WS-FREEFORM-RSN-CD    TO S9-ADJ-REASON-CD         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7550'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_ADJ_REASN'     TO TABLE-1                  
              MOVE 'ADJ_REASON_DESC'        TO TABLE-ELEMENT-1          
              MOVE BP-ADJ-REASON-DESC       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CHECK WHETHER CX TABLE HAS LATEST ROW FOR THE BILLING KEY               
      ******************************************************************        
       7560-GET-MN-LATEST.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) LAST_REG_READ_DATE                                 
                INTO :MN-LAST-REG-READ-DATE                             
                FROM CSS_MTRD_ENVRNMT      MN WITH(READUNCOMMITTED)             
               WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE           
                 AND IC_NO               = :MN-IC-NO                    
                ORDER BY LAST_REG_READ_DATE DESC                        
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_REG_READ_DATE                                         
MFA-TR*         INTO :MN-LAST-REG-READ-DATE                                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT      MN                                   
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :MN-IC-NO                            
MFA-TR*         ORDER BY LAST_REG_READ_DATE DESC                                
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
A05460     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO MN-LAST-REG-READ-DATE    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7560'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET CONSUMPTION DETAILS FROM WQ TABLE.                                  
      ******************************************************************        
       7570-GET-WQ-CNSMPTN.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT WQ.FREE_FORM_AREA                                  
                INTO :WQ-FREE-FORM-AREA                                 
                FROM CSS_WQ_ITEMS       WQ WITH(READUNCOMMITTED)                
               WHERE ITEM_ID          = :WQ-ITEM-ID                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WQ.FREE_FORM_AREA                                          
MFA-TR*         INTO :WQ-FREE-FORM-AREA                                         
MFA-TR*         FROM CSS_WQ_ITEMS       WQ                                      
MFA-TR*        WHERE ITEM_ID          = :WQ-ITEM-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7570'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ITEMS'           TO TABLE-1                  
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-1          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7570-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE DAY DIFFERENCE B/W MN READ DATE AND WQ READ DATE                
      ******************************************************************        
       7580-GET-DAY-DIFFERENCE.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-WQ-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-WQ-DATE-READ
              ) <> 0) OR (LEN(:WS-WQ-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                       :WS-WQ-DATE-READ
              ), CONVERT(DATE, :WS-WQ-DATE-READ) ))         
                                 - CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                 :WS-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-READ-DATE
              ), CONVERT(DATE, :WS-LAST-REG-READ-DATE) ))
            INTO
              :WS-NO-DAYS   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-NO-DAYS  = DAYS(DATE(:WS-WQ-DATE-READ))                 
MFA-TR*                          - DAYS(DATE(:WS-LAST-REG-READ-DATE))           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7580'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'WQ READ DT'             TO TABLE-ELEMENT-1          
              MOVE WS-WQ-DATE-READ          TO HOSTVAR-ELEMENT-1        
              MOVE 'MTR READ DT'            TO TABLE-ELEMENT-2          
              MOVE WS-LAST-REG-READ-DATE    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7580-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE BUSSINESS RULE DETAILS.                                *        
      ******************************************************************        
       7600-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S4-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)               
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S4-RULE-ID                       
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S4-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE      1R                                       
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S4-RULE-ID                               
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7600'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S4-RULE-ID              TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                                     
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000C-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S3-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S3-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000C'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R3'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000D-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S4-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S4-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000D'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R4'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000E-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000E-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S5-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S5-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000E'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R5'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000F-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000F-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S6-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S6-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000F'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R6'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000F-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000G-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000G-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R7                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R7                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S7-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S7-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000G'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R7'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000G-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000H-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000H-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R8                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R8                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S8-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S8-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000H'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R8'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000H-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000I-DEL-GTT-ROWS.                                                     
      ******************************************************************        
       8000I-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04870_R9                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04870_R9                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S9-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S9-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000I'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04870_R9'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000I-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.   CSS_BUS_RULE                                      
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,BILL_NO                                              
                  ,BILL_ITEM_TIMESTMP                                   
                  ,BILLING_KEY                                          
                  ,DATE_ORIG_BILL                                       
                  ,REVENUE_MONTH                                        
                  ,REV_MTH_ORIG_BILL                                    
                  ,REBILL_IND                                           
                  ,RATE                                                 
                  ,OPTION_CD                                            
                  ,OPT_DESC_INT                                         
                  ,TRANS_AMT                                            
                  ,BILL_CALC_CODE                                       
                  ,CODE_BILL_ITM_TYPE                                   
                  ,TRANS_STATUS                                         
                  ,DR_CR                                                
                  ,STATE_TAX                                            
                  ,CITY_TAX                                             
                  ,OTHER_TAX                                            
                  ,CODE_REVENUE_CLASS                                   
                  ,CODE_SIC_NO                                          
                  ,CODE_CURTAIL_PRTY                                    
                  ,STATE_XMT                                            
                  ,CITY_XMT                                             
                  ,OTHER_XMT                                            
                  ,REV_RPT_CD                                           
                  ,STANDBY_COMPLIED                                     
                  ,PRORATE_CD                                           
                  ,NEW_RATE_PCT                                         
                  ,TAX_REFUND_CD                                        
                  ,DATE_LFTM_HI_DMD                                     
                  ,LFTM_HI_PEAK_DMD                                     
                  ,ADJ_REASON                                           
                  ,GAS_BASE_USE                                         
                  ,WNA_FACTOR                                           
                  ,BTU_FACTOR                                           
                  ,NO_OF_CONS_DAYS                                      
                  ,NO_CONSEC_ESTIMATE                                   
                  ,SHIPPER                                              
                  ,TRNSP_OVER_MDQ                                       
                  ,BILL_CORRECTED_CD                                    
                  ,RT_PKG_OPT_SEQ_NO                                    
                  ,HRLY_REGISTER                                        
                  ,CIG_CUSTOMER                                         
                  ,BILLED_DATE                                          
                  ,CODE_BILL_STATUS                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S1-RETURN-CODE                                      
                  ,:S1-ACCOUNT-NO                                       
                  ,:S1-CODE-UTIL-TYPE                                   
                  ,:S1-IC-NO                                            
                  ,:S1-BILL-NO                                          
                  ,:S1-BILL-ITEM-TIMESTMP                               
                  ,:S1-BILLING-KEY-NUM                                  
                  ,:S1-DATE-ORIG-BILL                                   
                  ,:S1-REVENUE-MONTH                                    
                  ,:S1-REV-MTH-ORIG-BILL                                
                  ,:S1-REBILL-IND                                       
                  ,:S1-RATE                                             
                  ,:S1-OPTION-CD                                        
                  ,:S1-OPT-DESC-INT                                     
                  ,:S1-TRANS-AMT                                        
                  ,:S1-BILL-CALC-DESC                                   
                  ,:S1-CODE-BILL-ITM-TYPE                               
                  ,:S1-TRANS-STATUS                                     
                  ,:S1-DR-CR                                            
                  ,:S1-STATE-TAX                                        
                  ,:S1-CITY-TAX                                         
                  ,:S1-OTHER-TAX                                        
                  ,:S1-CODE-REVENUE-CLASS                               
                  ,:S1-CODE-SIC-NO                                      
                  ,:S1-CODE-CURTAIL-PRTY                                
                  ,:S1-STATE-XMT                                        
                  ,:S1-CITY-XMT                                         
                  ,:S1-OTHER-XMT                                        
                  ,:S1-REV-RPT-CD                                       
                  ,:S1-STANDBY-COMPLIED                                 
                  ,:S1-PRORATE-CD                                       
                  ,:S1-NEW-RATE-PCT                                     
                  ,:S1-TAX-REFUND-CD                                    
                  ,:S1-DATE-LFTM-HI-DMD                                 
                  ,:S1-LFTM-HI-PEAK-DMD                                 
                  ,:S1-ADJ-REASON                                       
                  ,:S1-GAS-BASE-USE                                     
                  ,:S1-WNA-FACTOR                                       
                  ,:S1-BTU-FACTOR                                       
                  ,:S1-NO-OF-CONS-DAYS                                  
                  ,:S1-NO-CONSEC-ESTIMATE                               
                  ,:S1-SHIPPER                                          
                  ,:S1-TRNSP-OVER-MDQ                                   
                  ,:S1-BILL-CORRECTED-CD                                
                  ,:S1-RT-PKG-OPT-SEQ-NO                                
                  ,:S1-HRLY-REGISTER                                    
                  ,:S1-CIG-CUSTOMER                                     
                  ,:S1-BILLED-DATE                                      
                  ,:S1-CODE-BILL-STATUS                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,BILL_ITEM_TIMESTMP                                           
MFA-TR*           ,BILLING_KEY                                                  
MFA-TR*           ,DATE_ORIG_BILL                                               
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           ,REV_MTH_ORIG_BILL                                            
MFA-TR*           ,REBILL_IND                                                   
MFA-TR*           ,RATE                                                         
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OPT_DESC_INT                                                 
MFA-TR*           ,TRANS_AMT                                                    
MFA-TR*           ,BILL_CALC_CODE                                               
MFA-TR*           ,CODE_BILL_ITM_TYPE                                           
MFA-TR*           ,TRANS_STATUS                                                 
MFA-TR*           ,DR_CR                                                        
MFA-TR*           ,STATE_TAX                                                    
MFA-TR*           ,CITY_TAX                                                     
MFA-TR*           ,OTHER_TAX                                                    
MFA-TR*           ,CODE_REVENUE_CLASS                                           
MFA-TR*           ,CODE_SIC_NO                                                  
MFA-TR*           ,CODE_CURTAIL_PRTY                                            
MFA-TR*           ,STATE_XMT                                                    
MFA-TR*           ,CITY_XMT                                                     
MFA-TR*           ,OTHER_XMT                                                    
MFA-TR*           ,REV_RPT_CD                                                   
MFA-TR*           ,STANDBY_COMPLIED                                             
MFA-TR*           ,PRORATE_CD                                                   
MFA-TR*           ,NEW_RATE_PCT                                                 
MFA-TR*           ,TAX_REFUND_CD                                                
MFA-TR*           ,DATE_LFTM_HI_DMD                                             
MFA-TR*           ,LFTM_HI_PEAK_DMD                                             
MFA-TR*           ,ADJ_REASON                                                   
MFA-TR*           ,GAS_BASE_USE                                                 
MFA-TR*           ,WNA_FACTOR                                                   
MFA-TR*           ,BTU_FACTOR                                                   
MFA-TR*           ,NO_OF_CONS_DAYS                                              
MFA-TR*           ,NO_CONSEC_ESTIMATE                                           
MFA-TR*           ,SHIPPER                                                      
MFA-TR*           ,TRNSP_OVER_MDQ                                               
MFA-TR*           ,BILL_CORRECTED_CD                                            
MFA-TR*           ,RT_PKG_OPT_SEQ_NO                                            
MFA-TR*           ,HRLY_REGISTER                                                
MFA-TR*           ,CIG_CUSTOMER                                                 
MFA-TR*           ,BILLED_DATE                                                  
MFA-TR*           ,CODE_BILL_STATUS                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S1-RETURN-CODE                                              
MFA-TR*           ,:S1-ACCOUNT-NO                                               
MFA-TR*           ,:S1-CODE-UTIL-TYPE                                           
MFA-TR*           ,:S1-IC-NO                                                    
MFA-TR*           ,:S1-BILL-NO                                                  
MFA-TR*           ,:S1-BILL-ITEM-TIMESTMP                                       
MFA-TR*           ,:S1-BILLING-KEY-NUM                                          
MFA-TR*           ,:S1-DATE-ORIG-BILL                                           
MFA-TR*           ,:S1-REVENUE-MONTH                                            
MFA-TR*           ,:S1-REV-MTH-ORIG-BILL                                        
MFA-TR*           ,:S1-REBILL-IND                                               
MFA-TR*           ,:S1-RATE                                                     
MFA-TR*           ,:S1-OPTION-CD                                                
MFA-TR*           ,:S1-OPT-DESC-INT                                             
MFA-TR*           ,:S1-TRANS-AMT                                                
MFA-TR*           ,:S1-BILL-CALC-DESC                                           
MFA-TR*           ,:S1-CODE-BILL-ITM-TYPE                                       
MFA-TR*           ,:S1-TRANS-STATUS                                             
MFA-TR*           ,:S1-DR-CR                                                    
MFA-TR*           ,:S1-STATE-TAX                                                
MFA-TR*           ,:S1-CITY-TAX                                                 
MFA-TR*           ,:S1-OTHER-TAX                                                
MFA-TR*           ,:S1-CODE-REVENUE-CLASS                                       
MFA-TR*           ,:S1-CODE-SIC-NO                                              
MFA-TR*           ,:S1-CODE-CURTAIL-PRTY                                        
MFA-TR*           ,:S1-STATE-XMT                                                
MFA-TR*           ,:S1-CITY-XMT                                                 
MFA-TR*           ,:S1-OTHER-XMT                                                
MFA-TR*           ,:S1-REV-RPT-CD                                               
MFA-TR*           ,:S1-STANDBY-COMPLIED                                         
MFA-TR*           ,:S1-PRORATE-CD                                               
MFA-TR*           ,:S1-NEW-RATE-PCT                                             
MFA-TR*           ,:S1-TAX-REFUND-CD                                            
MFA-TR*           ,:S1-DATE-LFTM-HI-DMD                                         
MFA-TR*           ,:S1-LFTM-HI-PEAK-DMD                                         
MFA-TR*           ,:S1-ADJ-REASON                                               
MFA-TR*           ,:S1-GAS-BASE-USE                                             
MFA-TR*           ,:S1-WNA-FACTOR                                               
MFA-TR*           ,:S1-BTU-FACTOR                                               
MFA-TR*           ,:S1-NO-OF-CONS-DAYS                                          
MFA-TR*           ,:S1-NO-CONSEC-ESTIMATE                                       
MFA-TR*           ,:S1-SHIPPER                                                  
MFA-TR*           ,:S1-TRNSP-OVER-MDQ                                           
MFA-TR*           ,:S1-BILL-CORRECTED-CD                                        
MFA-TR*           ,:S1-RT-PKG-OPT-SEQ-NO                                        
MFA-TR*           ,:S1-HRLY-REGISTER                                            
MFA-TR*           ,:S1-CIG-CUSTOMER                                             
MFA-TR*           ,:S1-BILLED-DATE                                              
MFA-TR*           ,:S1-CODE-BILL-STATUS                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BILLING CONSUMPTION DETAILS - METERED              
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,BILLING_KEY                                        
                    ,CODE_TIME_PERIOD                                   
                    ,MTR_REF_NO                                         
                    ,CODE_USAGE_TYPE                                    
                    ,CODE_USAGE_ID                                      
                    ,CODE_USAGE_SOURCE                                  
                    ,ITEM_SEQ_NO                                        
                    ,METER_NO                                           
                    ,REG_ID_NO                                          
                    ,DATE_READ                                          
                    ,CODE_METER_READ                                    
                    ,CODE_METER_NO_READ                                 
                    ,METER_READING                                      
                    ,NO_UNITS                                           
                    ,USAGE                                              
                    ,NO_DAYS                                            
                    ,CODE_SOURCE_ID                                     
                    ,CODE_DEBIT_CREDIT                                  
                    ,CODE_ITEM_STATUS                                   
                    ,CONSTANT                                           
                    ,NO_DIALS                                           
                    ,EXCEPT_OVERRIDE_CD                                 
                    ,REQUESTED_USAGE                                    
                    ,DIGTL_INTRL_MTR_NO                                 
                    ,DIGTL_MTR_TYPE                                     
                    ,CODE_TOU_SEASN                                     
                    ,EXCL_DMD_RCHT_IND                                  
                    ,MTR_READ_SOURCE_CD                                 
                    ,PCOMP_FCT                                          
                    ,CODE_USAGE_VALS                                    
                    ,MIN_NO_UNITS                                       
                    ,MAX_NO_UNITS                                       
                    ,LATEST_ROW                                         
                    ,WQ_CNSMPTN                                         
                    ,WQ_NO_READ_CD                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S2-RETURN-CODE                                      
                  ,:S2-BILLING-KEY-NUM                                  
                  ,:S2-CODE-TIME-PERIOD                                 
                  ,:S2-MTR-REF-NO                                       
                  ,:S2-CODE-USAGE-TYPE                                  
                  ,:S2-CODE-USAGE-ID                                    
                  ,:S2-CODE-USAGE-SOURCE                                
                  ,:S2-ITEM-SEQ-NO                                      
                  ,:S2-METER-NO                                         
                  ,:S2-REG-ID-NO                                        
                  ,:S2-DATE-READ                                        
                  ,:S2-CODE-METER-READ                                  
                  ,:S2-CODE-METER-NO-READ                               
                  ,:S2-METER-READING                                    
                  ,:S2-NO-UNITS                                         
                  ,:S2-USAGE                                            
                  ,:S2-NO-DAYS                                          
                  ,:S2-CODE-SOURCE-ID                                   
                  ,:S2-CODE-DEBIT-CREDIT                                
                  ,:S2-CODE-ITEM-STATUS                                 
                  ,:S2-CONSTANT                                         
                  ,:S2-NO-DIALS                                         
                  ,:S2-EXCEPT-OVERRIDE-CD                               
                  ,:S2-REQUESTED-USAGE                                  
                  ,:S2-DIGTL-INTRL-MTR-NO                               
                  ,:S2-DIGTL-MTR-TYPE                                   
                  ,:S2-CODE-TOU-SEASN                                   
                  ,:S2-EXCL-DMD-RCHT-IND                                
                  ,:S2-MTR-READ-SOURCE-CD                               
                  ,:S2-PCOMP-FCT                                        
                  ,:S2-CODE-USAGE-VALS                                  
                  ,:S2-MIN-NO-UNITS                                     
                  ,:S2-MAX-NO-UNITS                                     
                  ,:S2-LATEST-ROW                                       
                  ,:S2-WQ-CNSMPTN                                       
                  ,:S2-WQ-NO-READ-CD                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,BILLING_KEY                                                
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,CODE_USAGE_TYPE                                            
MFA-TR*             ,CODE_USAGE_ID                                              
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,CODE_METER_READ                                            
MFA-TR*             ,CODE_METER_NO_READ                                         
MFA-TR*             ,METER_READING                                              
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,USAGE                                                      
MFA-TR*             ,NO_DAYS                                                    
MFA-TR*             ,CODE_SOURCE_ID                                             
MFA-TR*             ,CODE_DEBIT_CREDIT                                          
MFA-TR*             ,CODE_ITEM_STATUS                                           
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*             ,EXCEPT_OVERRIDE_CD                                         
MFA-TR*             ,REQUESTED_USAGE                                            
MFA-TR*             ,DIGTL_INTRL_MTR_NO                                         
MFA-TR*             ,DIGTL_MTR_TYPE                                             
MFA-TR*             ,CODE_TOU_SEASN                                             
MFA-TR*             ,EXCL_DMD_RCHT_IND                                          
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*             ,PCOMP_FCT                                                  
MFA-TR*             ,CODE_USAGE_VALS                                            
MFA-TR*             ,MIN_NO_UNITS                                               
MFA-TR*             ,MAX_NO_UNITS                                               
MFA-TR*             ,LATEST_ROW                                                 
MFA-TR*             ,WQ_CNSMPTN                                                 
MFA-TR*             ,WQ_NO_READ_CD                                              
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S2-RETURN-CODE                                              
MFA-TR*           ,:S2-BILLING-KEY-NUM                                          
MFA-TR*           ,:S2-CODE-TIME-PERIOD                                         
MFA-TR*           ,:S2-MTR-REF-NO                                               
MFA-TR*           ,:S2-CODE-USAGE-TYPE                                          
MFA-TR*           ,:S2-CODE-USAGE-ID                                            
MFA-TR*           ,:S2-CODE-USAGE-SOURCE                                        
MFA-TR*           ,:S2-ITEM-SEQ-NO                                              
MFA-TR*           ,:S2-METER-NO                                                 
MFA-TR*           ,:S2-REG-ID-NO                                                
MFA-TR*           ,:S2-DATE-READ                                                
MFA-TR*           ,:S2-CODE-METER-READ                                          
MFA-TR*           ,:S2-CODE-METER-NO-READ                                       
MFA-TR*           ,:S2-METER-READING                                            
MFA-TR*           ,:S2-NO-UNITS                                                 
MFA-TR*           ,:S2-USAGE                                                    
MFA-TR*           ,:S2-NO-DAYS                                                  
MFA-TR*           ,:S2-CODE-SOURCE-ID                                           
MFA-TR*           ,:S2-CODE-DEBIT-CREDIT                                        
MFA-TR*           ,:S2-CODE-ITEM-STATUS                                         
MFA-TR*           ,:S2-CONSTANT                                                 
MFA-TR*           ,:S2-NO-DIALS                                                 
MFA-TR*           ,:S2-EXCEPT-OVERRIDE-CD                                       
MFA-TR*           ,:S2-REQUESTED-USAGE                                          
MFA-TR*           ,:S2-DIGTL-INTRL-MTR-NO                                       
MFA-TR*           ,:S2-DIGTL-MTR-TYPE                                           
MFA-TR*           ,:S2-CODE-TOU-SEASN                                           
MFA-TR*           ,:S2-EXCL-DMD-RCHT-IND                                        
MFA-TR*           ,:S2-MTR-READ-SOURCE-CD                                       
MFA-TR*           ,:S2-PCOMP-FCT                                                
MFA-TR*           ,:S2-CODE-USAGE-VALS                                          
MFA-TR*           ,:S2-MIN-NO-UNITS                                             
MFA-TR*           ,:S2-MAX-NO-UNITS                                             
MFA-TR*           ,:S2-LATEST-ROW                                               
MFA-TR*           ,:S2-WQ-CNSMPTN                                               
MFA-TR*           ,:S2-WQ-NO-READ-CD                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8020'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R2'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3.                                                     
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,BILLING_KEY                                          
                  ,FACT_ID                                              
                  ,FACTOR                                               
                  ,EFF_DATE_FROM                                        
                  ,EFF_DATE_TO                                          
                  ,CODE_SEASON                                          
                  ,INSTR_USE_TYPE_CD                                    
                  ,CODE_TIME_PERIOD                                     
                  ,CMPNT_ID_CD                                          
                  ,FIXED_FCTR_TYP_CD                                    
                  ,FIXED_FCTR_SEQ_NO                                    
                  ,DURATION_REMAIN_NO                                   
                  ,BLOCK_NO                                             
                  ,ALLOWED_BLOCKS                                       
                  ,FACTOR_POWER                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S3-RETURN-CODE                                      
                  ,:S3-BILLING-KEY-NUM                                  
                  ,:S3-FACT-ID                                          
                  ,:S3-FACTOR                                           
                  ,:S3-EFF-DATE-FROM                                    
                  ,:S3-EFF-DATE-TO                                      
                  ,:S3-CODE-SEASON                                      
                  ,:S3-INSTR-USE-TYPE-CD                                
                  ,:S3-CODE-TIME-PERIOD                                 
                  ,:S3-CMPNT-ID-CD                                      
                  ,:S3-FIXED-FCTR-TYP-CD                                
                  ,:S3-FIXED-FCTR-SEQ-NO                                
                  ,:S3-DURATION-REMAIN-NO                               
                  ,:S3-BLOCK-NO                                         
                  ,:S3-ALLOWED-BLOCKS                                   
                  ,:S3-FCTR-POWER-10                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BILLING_KEY                                                  
MFA-TR*           ,FACT_ID                                                      
MFA-TR*           ,FACTOR                                                       
MFA-TR*           ,EFF_DATE_FROM                                                
MFA-TR*           ,EFF_DATE_TO                                                  
MFA-TR*           ,CODE_SEASON                                                  
MFA-TR*           ,INSTR_USE_TYPE_CD                                            
MFA-TR*           ,CODE_TIME_PERIOD                                             
MFA-TR*           ,CMPNT_ID_CD                                                  
MFA-TR*           ,FIXED_FCTR_TYP_CD                                            
MFA-TR*           ,FIXED_FCTR_SEQ_NO                                            
MFA-TR*           ,DURATION_REMAIN_NO                                           
MFA-TR*           ,BLOCK_NO                                                     
MFA-TR*           ,ALLOWED_BLOCKS                                               
MFA-TR*           ,FACTOR_POWER                                                 
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S3-RETURN-CODE                                              
MFA-TR*           ,:S3-BILLING-KEY-NUM                                          
MFA-TR*           ,:S3-FACT-ID                                                  
MFA-TR*           ,:S3-FACTOR                                                   
MFA-TR*           ,:S3-EFF-DATE-FROM                                            
MFA-TR*           ,:S3-EFF-DATE-TO                                              
MFA-TR*           ,:S3-CODE-SEASON                                              
MFA-TR*           ,:S3-INSTR-USE-TYPE-CD                                        
MFA-TR*           ,:S3-CODE-TIME-PERIOD                                         
MFA-TR*           ,:S3-CMPNT-ID-CD                                              
MFA-TR*           ,:S3-FIXED-FCTR-TYP-CD                                        
MFA-TR*           ,:S3-FIXED-FCTR-SEQ-NO                                        
MFA-TR*           ,:S3-DURATION-REMAIN-NO                                       
MFA-TR*           ,:S3-BLOCK-NO                                                 
MFA-TR*           ,:S3-ALLOWED-BLOCKS                                           
MFA-TR*           ,:S3-FCTR-POWER-10                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S3-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS3            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8030'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R3'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8040-INSERT-GTT-R4.                                                     
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,BUS_RESULT_CD                                        
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S4-RETURN-CODE                                      
                  ,:S4-RULE-ID                                          
                  ,:S4-RULE-RESULT-CD                                   
                  ,:S4-BUS-RULE-XREF-ID                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RESULT_CD                                                
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S4-RETURN-CODE                                              
MFA-TR*           ,:S4-RULE-ID                                                  
MFA-TR*           ,:S4-RULE-RESULT-CD                                           
MFA-TR*           ,:S4-BUS-RULE-XREF-ID                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S4-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS4            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8040'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R4'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8050-INSERT-GTT-R5. INSERT ACCOUNT DETAILS                              
      ******************************************************************        
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R5                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,COMPANY_NO                                           
                  ,AT_LAST_UPDATE_TS                                    
                  ,ACCT_FINALED_DT                                      
                  ,MIN_PRORATION_DAYS                                   
                  ,MAX_PRORATION_DAYS                                   
                  ,EXEMPT_FL                                            
                  ,DATE_EXTRACT                                         
                  ,MST_ACCT_BILLED                                      
                  ,COMMON_REVENUE_MONTH                                 
                  ,MV90_MTR_IND                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S5-RETURN-CODE                                      
                  ,:S5-ACCOUNT-NO                                       
                  ,:S5-CODE-UTIL-TYPE                                   
                  ,:S5-IC-NO                                            
                  ,:S5-COMPANY-NO                                       
                  ,:S5-AT-LAST-UPDATE-TS                                
                  ,:S5-ACCT-FINALED-DT                                  
                  ,:S5-MIN-PRORATION-DAYS                               
                  ,:S5-MAX-PRORATION-DAYS                               
                  ,:S5-BILL-WINDOW-IND                                  
                  ,:S5-DATE-EXTRACT                                     
                  ,:S5-MST-ACCT-BILLED                                  
                  ,:S5-COMMON-REV-MONTH                                 
                  ,:S5-MV90-MTR-IND                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R5                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,AT_LAST_UPDATE_TS                                            
MFA-TR*           ,ACCT_FINALED_DT                                              
MFA-TR*           ,MIN_PRORATION_DAYS                                           
MFA-TR*           ,MAX_PRORATION_DAYS                                           
MFA-TR*           ,EXEMPT_FL                                                    
MFA-TR*           ,DATE_EXTRACT                                                 
MFA-TR*           ,MST_ACCT_BILLED                                              
MFA-TR*           ,COMMON_REVENUE_MONTH                                         
MFA-TR*           ,MV90_MTR_IND                                                 
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S5-RETURN-CODE                                              
MFA-TR*           ,:S5-ACCOUNT-NO                                               
MFA-TR*           ,:S5-CODE-UTIL-TYPE                                           
MFA-TR*           ,:S5-IC-NO                                                    
MFA-TR*           ,:S5-COMPANY-NO                                               
MFA-TR*           ,:S5-AT-LAST-UPDATE-TS                                        
MFA-TR*           ,:S5-ACCT-FINALED-DT                                          
MFA-TR*           ,:S5-MIN-PRORATION-DAYS                                       
MFA-TR*           ,:S5-MAX-PRORATION-DAYS                                       
MFA-TR*           ,:S5-BILL-WINDOW-IND                                          
MFA-TR*           ,:S5-DATE-EXTRACT                                             
MFA-TR*           ,:S5-MST-ACCT-BILLED                                          
MFA-TR*           ,:S5-COMMON-REV-MONTH                                         
MFA-TR*           ,:S5-MV90-MTR-IND                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S5-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS5            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8050'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R5'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8060-INSERT-GTT-R6.  BILLING CONSUMPTION DETAILS - UNMETERED            
      ******************************************************************        
       8060-INSERT-GTT-R6.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R6                           
                 (                                                      
                     RETURN_CODE                                        
                    ,BILLING_KEY                                        
                    ,UM_DESCRIPTION                                     
                    ,UM_RATE_ITEM_CODE                                  
                    ,UM_ITEM_SEQ_NO                                     
                    ,UM_NO_UNITS                                        
                    ,UM_NO_DAYS                                         
                    ,UM_CDE_DEBIT_CREDT                                 
                    ,UM_USAGE_FIXED                                     
                    ,UM_DATE_USAGE_ENDS                                 
                    ,UM_CODE_SERVICE_TYPE                               
                    ,UM_CDE_ITEM_STATUS                                 
                    ,UM_CODE_SOURCE_ID                                  
                    ,UM_MTHLY_AMOUNT_FIXED                              
                    ,UM_DIST_NO                                         
                    ,UM_LIGHT_NO                                        
                    ,UM_POLE_NO                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S6-RETURN-CODE                                      
                  ,:S6-BILLING-KEY-NUM                                  
                  ,:S6-UM-DESCRIPTION                                   
                  ,:S6-UM-RATE-ITEM-CODE                                
                  ,:S6-UM-ITEM-SEQ-NO                                   
                  ,:S6-UM-NO-UNITS                                      
                  ,:S6-UM-NO-DAYS                                       
                  ,:S6-UM-CODE-DEBIT-CREDIT                             
                  ,:S6-UM-USAGE-FIXED                                   
                  ,:S6-UM-DATE-USAGE-ENDS                               
                  ,:S6-UM-CODE-SERVICE-TYPE                             
                  ,:S6-UM-CODE-ITEM-STATUS                              
                  ,:S6-UM-CODE-SOURCE-ID                                
                  ,:S6-UM-MTHLY-AMOUNT-FIXED                            
                  ,:S6-UM-DIST-NO                                       
                  ,:S6-UM-LIGHT-NO                                      
                  ,:S6-UM-POLE-NO                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R6                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,BILLING_KEY                                                
MFA-TR*             ,UM_DESCRIPTION                                             
MFA-TR*             ,UM_RATE_ITEM_CODE                                          
MFA-TR*             ,UM_ITEM_SEQ_NO                                             
MFA-TR*             ,UM_NO_UNITS                                                
MFA-TR*             ,UM_NO_DAYS                                                 
MFA-TR*             ,UM_CDE_DEBIT_CREDT                                         
MFA-TR*             ,UM_USAGE_FIXED                                             
MFA-TR*             ,UM_DATE_USAGE_ENDS                                         
MFA-TR*             ,UM_CODE_SERVICE_TYPE                                       
MFA-TR*             ,UM_CDE_ITEM_STATUS                                         
MFA-TR*             ,UM_CODE_SOURCE_ID                                          
MFA-TR*             ,UM_MTHLY_AMOUNT_FIXED                                      
MFA-TR*             ,UM_DIST_NO                                                 
MFA-TR*             ,UM_LIGHT_NO                                                
MFA-TR*             ,UM_POLE_NO                                                 
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S6-RETURN-CODE                                              
MFA-TR*           ,:S6-BILLING-KEY-NUM                                          
MFA-TR*           ,:S6-UM-DESCRIPTION                                           
MFA-TR*           ,:S6-UM-RATE-ITEM-CODE                                        
MFA-TR*           ,:S6-UM-ITEM-SEQ-NO                                           
MFA-TR*           ,:S6-UM-NO-UNITS                                              
MFA-TR*           ,:S6-UM-NO-DAYS                                               
MFA-TR*           ,:S6-UM-CODE-DEBIT-CREDIT                                     
MFA-TR*           ,:S6-UM-USAGE-FIXED                                           
MFA-TR*           ,:S6-UM-DATE-USAGE-ENDS                                       
MFA-TR*           ,:S6-UM-CODE-SERVICE-TYPE                                     
MFA-TR*           ,:S6-UM-CODE-ITEM-STATUS                                      
MFA-TR*           ,:S6-UM-CODE-SOURCE-ID                                        
MFA-TR*           ,:S6-UM-MTHLY-AMOUNT-FIXED                                    
MFA-TR*           ,:S6-UM-DIST-NO                                               
MFA-TR*           ,:S6-UM-LIGHT-NO                                              
MFA-TR*           ,:S6-UM-POLE-NO                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S6-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS6            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8060'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R6'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8070-INSERT-GTT-R7.  ACCOUNT METER DETAILS                              
      ******************************************************************        
       8070-INSERT-GTT-R7.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R7                           
                 (                                                      
                     RETURN_CODE                                        
                    ,METER_NO                                           
                    ,MTR_REF_NO                                         
                    ,REG_ID_NO                                          
                    ,CODE_METER_STATUS                                  
                    ,CODE_USAGE_VALUE                                   
                    ,MIN_NO_UNITS                                       
                    ,MAX_NO_UNITS                                       
                    ,CONSTANT                                           
                    ,NO_DIALS                                           
                    ,PCOMP_FCT                                          
                    ,LAST_READ_DATE                                     
                    ,LAST_READ_VALUE                                    
                    ,CODE_USAGE_SOURCE                                  
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S7-RETURN-CODE                                      
                  ,:S7-METER-NO                                         
                  ,:S7-MTR-REF-NO                                       
                  ,:S7-REG-ID-NO                                        
                  ,:S7-CODE-METER-STATUS                                
                  ,:S7-CODE-USAGE-VALUE                                 
                  ,:S7-MIN-NO-UNITS                                     
                  ,:S7-MAX-NO-UNITS                                     
                  ,:S7-CONSTANT                                         
                  ,:S7-NO-READ-DIALS                                    
                  ,:S7-PCOMP-FCT                                        
                  ,:S7-LAST-READ-DATE                                   
                  ,:S7-LAST-READ-VALUE                                  
                  ,:S7-CODE-USAGE-SOURCE                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R7                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,CODE_METER_STATUS                                          
MFA-TR*             ,CODE_USAGE_VALUE                                           
MFA-TR*             ,MIN_NO_UNITS                                               
MFA-TR*             ,MAX_NO_UNITS                                               
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*             ,PCOMP_FCT                                                  
MFA-TR*             ,LAST_READ_DATE                                             
MFA-TR*             ,LAST_READ_VALUE                                            
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S7-RETURN-CODE                                              
MFA-TR*           ,:S7-METER-NO                                                 
MFA-TR*           ,:S7-MTR-REF-NO                                               
MFA-TR*           ,:S7-REG-ID-NO                                                
MFA-TR*           ,:S7-CODE-METER-STATUS                                        
MFA-TR*           ,:S7-CODE-USAGE-VALUE                                         
MFA-TR*           ,:S7-MIN-NO-UNITS                                             
MFA-TR*           ,:S7-MAX-NO-UNITS                                             
MFA-TR*           ,:S7-CONSTANT                                                 
MFA-TR*           ,:S7-NO-READ-DIALS                                            
MFA-TR*           ,:S7-PCOMP-FCT                                                
MFA-TR*           ,:S7-LAST-READ-DATE                                           
MFA-TR*           ,:S7-LAST-READ-VALUE                                          
MFA-TR*           ,:S7-CODE-USAGE-SOURCE                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S7-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS7            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8070'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R7'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8080-INSERT-GTT-R8.  ACCOUNT UNMETER DETAILS                            
      ******************************************************************        
       8080-INSERT-GTT-R8.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R8                           
                 (                                                      
                     RETURN_CODE                                        
                    ,RATE_ITEM_DESC                                     
                    ,NO_UNITS                                           
                    ,USAGE_FIXED                                        
                    ,MTHLY_AMOUNT_FIXED                                 
                    ,ITEM_SEQ_NO                                        
                    ,REMOVE_DATE                                        
                    ,LAST_BILL_DATE                                     
                    ,CODE_SERVICE_TYPE                                  
                    ,CODE_PLAN_STATUS                                   
                    ,CODE_STAT_REASON                                   
                    ,RATE_ITEM_CODE                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S8-RETURN-CODE                                      
                  ,:S8-RATE-ITEM-DESC                                   
                  ,:S8-NO-UNITS                                         
                  ,:S8-USAGE-FIXED                                      
                  ,:S8-MTHLY-AMOUNT-FIXED                               
                  ,:S8-ITEM-SEQ-NO                                      
                  ,:S8-REMOVE-DATE                                      
                  ,:S8-LAST-BILL-DATE                                   
                  ,:S8-CODE-SERVICE-TYPE                                
                  ,:S8-CODE-PLAN-STATUS                                 
                  ,:S8-CODE-STAT-REASON                                 
                  ,:S8-RATE-ITEM-CODE                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R8                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,RATE_ITEM_DESC                                             
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,USAGE_FIXED                                                
MFA-TR*             ,MTHLY_AMOUNT_FIXED                                         
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,REMOVE_DATE                                                
MFA-TR*             ,LAST_BILL_DATE                                             
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,CODE_PLAN_STATUS                                           
MFA-TR*             ,CODE_STAT_REASON                                           
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S8-RETURN-CODE                                              
MFA-TR*           ,:S8-RATE-ITEM-DESC                                           
MFA-TR*           ,:S8-NO-UNITS                                                 
MFA-TR*           ,:S8-USAGE-FIXED                                              
MFA-TR*           ,:S8-MTHLY-AMOUNT-FIXED                                       
MFA-TR*           ,:S8-ITEM-SEQ-NO                                              
MFA-TR*           ,:S8-REMOVE-DATE                                              
MFA-TR*           ,:S8-LAST-BILL-DATE                                           
MFA-TR*           ,:S8-CODE-SERVICE-TYPE                                        
MFA-TR*           ,:S8-CODE-PLAN-STATUS                                         
MFA-TR*           ,:S8-CODE-STAT-REASON                                         
MFA-TR*           ,:S8-RATE-ITEM-CODE                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S8-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS8            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8080'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R8'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8090-INSERT-GTT-R9.  BILL ADJUSTMENT DETAILS                            
      ******************************************************************        
       8090-INSERT-GTT-R9.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04870_R9                           
                 (                                                      
                     RETURN_CODE                                        
                    ,BILLING_KEY                                        
                    ,REVENUE_MONTH                                      
                    ,ADJ_TYPE_CD                                        
                    ,ADJ_REASON_DESC                                    
                    ,OVRRIDE_RT_REV_MTH                                 
                    ,SPECIAL_PROCESS_CD                                 
                    ,ADJ_REASON_CD                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S9-RETURN-CODE                                      
                  ,:S9-BILLING-KEY-NUM                                  
                  ,:S9-REVENUE-MONTH                                    
                  ,:S9-ADJ-TYPE-CD                                      
                  ,:S9-ADJ-REASON-DESC                                  
                  ,:S9-OVRRIDE-RT-REV-MTH                               
                  ,:S9-SPECIAL-PROCESS-CD                               
                  ,:S9-ADJ-REASON-CD                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04870_R9                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,BILLING_KEY                                                
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,ADJ_TYPE_CD                                                
MFA-TR*             ,ADJ_REASON_DESC                                            
MFA-TR*             ,OVRRIDE_RT_REV_MTH                                         
MFA-TR*             ,SPECIAL_PROCESS_CD                                         
MFA-TR*             ,ADJ_REASON_CD                                              
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S9-RETURN-CODE                                              
MFA-TR*           ,:S9-BILLING-KEY-NUM                                          
MFA-TR*           ,:S9-REVENUE-MONTH                                            
MFA-TR*           ,:S9-ADJ-TYPE-CD                                              
MFA-TR*           ,:S9-ADJ-REASON-DESC                                          
MFA-TR*           ,:S9-OVRRIDE-RT-REV-MTH                                       
MFA-TR*           ,:S9-SPECIAL-PROCESS-CD                                       
MFA-TR*           ,:S9-ADJ-REASON-CD                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S9-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS-RS9            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8090'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04870_R9'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                                     
      ******************************************************************        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S1-RETURN-CODE          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S2-RETURN-CODE          
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S3-RETURN-CODE          
              PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                       TO S4-RETURN-CODE          
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS5 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                       TO S5-RETURN-CODE          
              PERFORM 8050-INSERT-GTT-R5       THRU 8050-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS6 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-6                            
              MOVE 100                       TO S6-RETURN-CODE          
              PERFORM 8060-INSERT-GTT-R6       THRU 8060-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS7 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-7                            
              MOVE 100                       TO S7-RETURN-CODE          
              PERFORM 8070-INSERT-GTT-R7       THRU 8070-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS8 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-8                            
              MOVE 100                       TO S8-RETURN-CODE          
              PERFORM 8080-INSERT-GTT-R8       THRU 8080-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS9 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-9                            
              MOVE 100                       TO S9-RETURN-CODE          
              PERFORM 8090-INSERT-GTT-R9       THRU 8090-EXIT           
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                         
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S3-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S4-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R4'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S5-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R5'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S6-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R6'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C7                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S7-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R7'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C8                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S8-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R8'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C9                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C9 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S9-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04870_R9'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                                  
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S1-RETURN-CODE           
                                               S2-RETURN-CODE           
                                               S3-RETURN-CODE           
                                               S4-RETURN-CODE           
                                               S5-RETURN-CODE           
                                               S6-RETURN-CODE           
                                               S7-RETURN-CODE           
                                               S8-RETURN-CODE           
                                               S9-RETURN-CODE.          
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
           PERFORM 0100E-DECLARE-GTT-R5        THRU 0100E-EXIT.         
           PERFORM 0100F-DECLARE-GTT-R6        THRU 0100F-EXIT.         
           PERFORM 0100G-DECLARE-GTT-R7        THRU 0100G-EXIT.         
           PERFORM 0100H-DECLARE-GTT-R8        THRU 0100H-EXIT.         
           PERFORM 0100I-DECLARE-GTT-R9        THRU 0100I-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT.          
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT.          
           PERFORM 8070-INSERT-GTT-R7          THRU 8070-EXIT.          
           PERFORM 8080-INSERT-GTT-R8          THRU 8080-EXIT.          
           PERFORM 8090-INSERT-GTT-R9          THRU 8090-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                                  
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                                 
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * 9999-END-PROGRAM.                                                       
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT           
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
