       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04869.                                         
COB303 DATE-WRITTEN.  JUN 12, 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                        SCANA ENERGY                            *        
      *                                                                *        
      ******************************************************************        
      *                 P-R-O-G-R-A-M  S-U-M-M-A-R-Y                   *        
      *                                                                *        
      *  ROUTINE IS CALLED FROM PB TRANS-DRIVER WHEN PROCESSING TOFF   *        
      *  TRANSACTION TO ALLOW CHARGING OF AGL PASSTHROUGH CHARGES FOR  *        
      *  AN ADDITIONAL MONTH.                                          *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             ACCOUNT_NO                 CHAR(13)                *        
      *             REVENUE_MONTH              CHAR(06)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *                                                                *        
      *  APPL RETURN CODE                                              *        
      *  -----------------                                             *        
      *  1000 - INPUT VALUE/S INVALID.                                 *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *     DATE       INITIALS   COMMENTS                             *        
      *  -----------   --------   ------------------------------       *        
      *  12-JUN-2015   SS45239    INITIAL IMPLEMENTATION.              *        
      *                APP5290                                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999   MAIN CONTROL PATH AND INITIALIZATION            *        
      *  1000 - 1999   INPUT PROCESSING CONTROL PATH                   *        
      *  2000 - 2999   OUTPUT PROCESSING CONTROL PATH                  *        
      *  3000 - 4999   NOT USED                                        *        
      *  5000 - 5999   COMMON PROGRAM MODULES                          *        
      *  6000 - 6999   COMMON SYSTEM MODULES                           *        
      *  7000 - 7999   INPUT MODULES                                   *        
      *  8000 - 8999   OUTPUT MODULES                                  *        
      *  9000 - 9999   TERMINATION,ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04869'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
                 'WORKING STORAGE FOR CSR04869 STARTS HERE'.            
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES.                                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT   UT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILLING_DET    BG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CNSMPTN_HIST   CX                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_ADJUSTMNT BP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBILADJ                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST MH                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET MI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING.                        *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS.                                                 *        
      ******************************************************************        
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04869'. 
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
                                                                        
       01  SWITCHES.                                                    
           05  CSR04869-DONE-SW             PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
                                                                        
       01  NULL-INDICATORS.                                             
           05  NULL-DATE-READ               PIC S9(04) COMP.            
           05  NULL-PEAK-DEMAND-DT          PIC S9(04) COMP.            
           05  NULL-DATE-ORIG-BILL          PIC S9(04) COMP.            
           05  NULL-DATE-LFTM-HI-DMD        PIC S9(04) COMP.            
           05  NULL-OVRRIDE-RT-BILL-DT      PIC S9(04) COMP.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN               PIC S9(04) COMP.            
               49 GTT-ROW-CHAR              PIC X(1024).                
           05  GTT-SQLCODE                  PIC S9(09) COMP.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(09) COMP VALUE 1.    
           05  CTR-ROWS                     PIC S9(09) COMP VALUE 0.    
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(09) COMP.            
           05  WRKLEN1                      PIC S9(09) COMP.            
           05  WRKLEN2                      PIC S9(09) COMP.            
           05  WRK-DONE-STATUS              PIC S9(09) COMP.            
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
           05  GTT-NAME                     PIC X(26) VALUE             
                                                'SESSION.CSR04869_R1'.  
       01  WS-MISC.                                                     
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
           05  WS-ACCOUNT-NO                PIC X(13) VALUE SPACES.     
           05  WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                   
                                            PIC 9(13).                  
           05  WS-REVENUE-MONTH             PIC X(06) VALUE SPACES.     
           05  WS-REV-MTH-NUM REDEFINES WS-REVENUE-MONTH                
                                            PIC 9(6).                   
           05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
           05  WS-COMMON-RUN-DATE           PIC X(10) VALUE SPACES.     
           05  WS-COMMON-REV-MNTH           PIC 9(6)  VALUE ZEROS.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                   PIC X(18)  VALUE SPACES.    
            10  S-SQLCODE                   PIC S9(9)  COMP VALUE 0.    
            10  S-SQLSTATE                  PIC X(5)   VALUE ' '.       
            10  S-TABLE-NAME                PIC X(18)  VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L      PIC S9(4)  USAGE COMP.      
                49  S-HOST-VARIABLES-V      PIC X(255).                 
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L       PIC S9(4)  USAGE COMP.      
                49  S-SQL-STATEMENT-V       PIC X(255).                 
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L     PIC S9(4)  USAGE COMP.      
                49  S-SQL-DESCRIPTION-V     PIC X(255).                 
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC X(13).                  
       01  PARM-REVENUE-MONTH               PIC X(06).                  
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-REVENUE-MONTH.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *      CONTROLS THE MAIN PATH OF THE PROGRAM.                    *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE      THRU  0100-EXIT.                
           PERFORM 1000-PROCESS-INPUT   THRU  1000-EXIT.                
           PERFORM 2000-PROCESS-OUTPUT  THRU  2000-EXIT.                
           PERFORM 9999-END-PROGRAM     THRU  9999-EXIT.                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU  0100A-EXIT.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04869_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04869_R1
              (                                                      
                     RETURN_CODE   INT                              
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE AS RETURN_CODE                       
                  FROM #CSR04869_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE AS RETURN_CODE                               
MFA-TR*           FROM SESSION.CSR04869_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NUM              TO AT-ACCOUNT-NO.           
           MOVE PARM-REVENUE-MONTH          TO WS-REVENUE-MONTH.        
           PERFORM 1100-VALIDATE-INPUT         THRU  1100-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1100-VALIDATE-INPUT.                                          *         
      *      BASIC INPUT VALIDATION FOR ACCOUNT/REVENUE MONTH.        *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF WS-ACCOUNT-NUM > WS-ZERO AND WS-REV-MTH-NUM > WS-ZERO     
              CONTINUE                                                  
           ELSE                                                         
      *****INPUT VALUES ARE INVALID                                             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE INPUT'          TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              MOVE +1000                    TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT         THRU  8100-EXIT          
              PERFORM 9999-END-PROGRAM         THRU  9999-EXIT          
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-GET-BILLING-DET        THRU  7100-EXIT.         
           MOVE WS-ACCOUNT-NUM              TO CX-ACCOUNT-NO.           
           MOVE BG-BILL-NO                  TO CX-BILL-NO.              
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO CX-IC-NO.                
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP.   
                                                                        
           PERFORM 7150-GET-CNSMPTN-HIST       THRU  7150-EXIT.         
           PERFORM 2100-CREATE-BILLING-DETAIL  THRU  2100-EXIT.         
           PERFORM 2150-CREATE-DUMMY-CNSMPTN   THRU  2150-EXIT.         
           PERFORM 2175-CREATE-BILL-ADJTMNTS   THRU  2175-EXIT.         
                                                                        
           PERFORM 2200-WRITE-MNT-TRANS-HIST   THRU  2200-EXIT.         
           PERFORM 2300-BUILD-RESULT-SET       THRU  2300-EXIT.         
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                      TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT         THRU  8100-EXIT          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-CREATE-BILLING-DETAIL.                                    *        
      *      CREATE A NEW BILLING DETAIL ROW.                          *        
      ******************************************************************        
       2100-CREATE-BILLING-DETAIL.                                      
                                                                        
           PERFORM 7400-GET-CURRENT-TIMESTAMP  THRU  7400-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP        TO BG-BILL-ITEM-TIMESTMP.   
           MOVE 'P'                         TO BG-REV-RPT-CD.           
           PERFORM 8200-INSERT-BILLING-DET     THRU  8200-EXIT.         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-CREATE-DUMMY-CNSMPTN.                                              
      *      CREATE A DUMMY CONSUMPTION ROW FOR BEW BILLING DETAIL TO  *        
      *      AVOID ESTIMATION IN THE BILLING ROUTINES.                 *        
      ******************************************************************        
       2150-CREATE-DUMMY-CNSMPTN.                                       
                                                                        
           MOVE BG-ACCOUNT-NO               TO CX-ACCOUNT-NO            
           MOVE BG-BILL-NO                  TO CX-BILL-NO               
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE        
           MOVE BG-IC-NO                    TO CX-IC-NO                 
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP    
           MOVE 0                           TO CX-NO-UNITS              
                                               CX-NO-DEMAND-UNITS.      
           MOVE +1                          TO CX-ITEM-SEQ-NO.          
           PERFORM 8300-INSERT-CNSMPTN-HIST    THRU  8300-EXIT.         
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2175-CREATE-BILL-ADJTMNTS.                                     *        
      *      OVERRIDE BILLING PARAMETERS.                              *        
      *          A. REVENUE MONTH.                                     *        
      *          B. CHARGE AGL PASS-THROUGH.                           *        
      ******************************************************************        
       2175-CREATE-BILL-ADJTMNTS.                                       
                                                                        
           PERFORM 7300-GET-COMMON-REV-MTH     THRU  7300-EXIT.         
           MOVE G6-PARM-DATA(1:6)           TO WS-COMMON-REV-MNTH.      
           MOVE BG-ACCOUNT-NO               TO BP-ACCOUNT-NO.           
           MOVE BG-BILL-NO                  TO BP-BILL-NO.              
           MOVE BG-CODE-UTIL-TYPE           TO BP-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO BP-IC-NO.                
           MOVE BG-BILL-ITEM-TIMESTMP       TO BP-BILL-ITEM-TIMESTMP.   
           MOVE WS-COMMON-REV-MNTH          TO BP-REVENUE-MONTH.        
           MOVE SPACES                      TO BP-OVRRIDE-RT-BILL-CY    
                                               BP-SPECIAL-PROCESS-CD    
                                               BP-ADJ-REASON-DESC-TEXT. 
           MOVE LENGTH OF BP-ADJ-REASON-DESC-TEXT                       
                                            TO BP-ADJ-REASON-DESC-LEN.  
           MOVE WS-YES-NULL                 TO NULL-OVRRIDE-RT-BILL-DT. 
                                                                        
      *****OVERRIDE BILLING REVENUE MONTH FOR NEW BILLING DETAIL                
           MOVE 'RTOV'                      TO BP-ADJ-TYPE-CD.          
           MOVE WS-REV-MTH-NUM              TO BP-OVRRIDE-RT-REV-MTH.   
           PERFORM 8400-INSERT-BILL-ADJSTMNT   THRU  8400-EXIT.         
                                                                        
      *****CHARGE AGL PASS-THROUGH FOR NEW BILLING DETAIL                       
           MOVE 'AGLP'                      TO BP-ADJ-TYPE-CD.          
           MOVE 0                           TO BP-OVRRIDE-RT-REV-MTH.   
           PERFORM 8400-INSERT-BILL-ADJSTMNT   THRU  8400-EXIT.         
                                                                        
       2175-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-WRITE-MNT-TRANS-HIST.                                     *        
      *      LOG MAINTENANCE TRANSACTION HISTORY.                      *        
      ******************************************************************        
       2200-WRITE-MNT-TRANS-HIST.                                       
                                                                        
           PERFORM 7400-GET-CURRENT-TIMESTAMP  THRU  7400-EXIT.         
           PERFORM 7500-GET-CURRENT-DATE       THRU  7500-EXIT.         
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET.                            
           MOVE WS-CURRENT-TIMESTAMP       TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-CURRENT-DATE            TO MH-DATE-TRANS.            
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE SPACES                     TO MH-RESP-AREA-ID.          
           MOVE WS-ACCOUNT-NUM             TO MH-ACCOUNT-NO.            
           MOVE ZEROS                      TO MH-CUSTOMER-NO.           
           MOVE ZEROS                      TO MH-PREMISE-NO.            
           MOVE 'SYSTEM'                   TO MH-USER-ID.               
           MOVE PROGRAM-NAME               TO MH-APPL-PROGRAM-ID.       
           STRING 'ADDITIONAL AGL PASS-THROUGH CHARGE ON FINAL BILL.'   
                                              DELIMITED BY SIZE         
                                         INTO MH-TRAN-COMMENT-TEXT      
           MOVE +47                        TO MH-TRAN-COMMENT-LEN.      
           PERFORM 8500-INSERT-MNT-TRANS-HDR  THRU  8500-EXIT.          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           MOVE +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'OVRRIDE REV MTH'          TO MI-COLUMN-DESC.           
           MOVE '**NEW**'                  TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-REVENUE-MONTH           TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE SPACES                     TO MI-TABLE-ID.              
           PERFORM 8600-INSERT-MNT-TRANS-DET  THRU  8600-EXIT.          
                                                                        
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'CHARGE AGL P/T'           TO MI-COLUMN-DESC.           
           MOVE '**NEW**'                  TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE 'YES'                      TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE SPACES                     TO MI-TABLE-ID.              
           PERFORM 8600-INSERT-MNT-TRANS-DET  THRU  8600-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2300-BUILD-RESULT-SET.                                        *        
      ******************************************************************        
       2300-BUILD-RESULT-SET.                                           
                                                                        
           MOVE 0                          TO S-RETURN-CODE.            
           PERFORM 8100-SEND-RESULT           THRU  8100-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-BILLING-DET.                                          *        
      *      GET FUTURE BILL HOOK BILLING DETAILS.                     *        
      ******************************************************************        
       7100-GET-BILLING-DET.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) BG.PREMISE_NO,
              BG.BILL_NO,
              BG.CODE_UTIL_TYPE,
              BG.IC_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              BG.DATE_ORIG_BILL,
              BG.AMT_BILL_ITEM,
              BG.CODE_BILL_CALC,
              BG.CODE_BILL_ITM_TYPE,
              BG.CODE_BILL_ITM_IND,
              BG.CODE_DR_CR_CNSMPTN,
              BG.AMT_STATE_TAX,
              BG.AMT_CITY_TAX,
              BG.AMT_OTHER_TAX,
              BG.CODE_REVENUE_CLASS,
              BG.CODE_SIC_NO,
              BG.RATE_PLAN_NO,
              BG.CODE_CURTAIL_PRTY,
              BG.CODE_STAT_TAX_XMT,
              BG.CODE_CITY_TAX_XMT,
              BG.CODE_OTHR_TAX_XMT,
              BG.REV_RPT_CD,
              BG.STANDBY_COMPLIED,
              BG.PRORATE_CD,
              BG.NEW_RATE_PCT,
              BG.CODE_SUB_TOTAL,
              BG.TAX_REFUND_CD,
              BG.ACCOUNT_NO,
              BG.COMPANY_NO,
              BG.DATE_LFTM_HI_DMD,
              BG.LFTM_HI_PEAK_DMD,
              BG.REBILL_IND,
              BG.ADJ_REASON_CD,
              BG.REVENUE_MONTH,
              BG.GAS_BASE_USE,
              BG.WNA_FACTOR,
              BG.BTU_FACTOR,
              BG.NO_OF_CONS_DAYS,
              BG.REV_MTH_ORIG_BILL,
              BG.REV_DISTRICT_CD,
              BG.FUEL_SHIPPER_CD,
              BG.ALTERNATE_FUEL_CD,
              BG.TRNSP_OVER_MDQ_FL,
              BG.CITY_TAX_RATE,
              BG.OTHER_TAX_RATE,
              BG.STATE_TAX_RATE,
              BG.BILL_CALC_CYCLE,
              BG.NAICS_CD,
              BG.RT_PKG_OPT_SEQ_NO                             
                 INTO :BG-PREMISE-NO                                    
                     ,:BG-BILL-NO                                       
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
                     ,:BG-BILL-ITEM-TIMESTMP                            
                     ,:BG-DATE-ORIG-BILL :NULL-DATE-ORIG-BILL            
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-REV-RPT-CD                                    
                     ,:BG-STANDBY-COMPLIED                              
                     ,:BG-PRORATE-CD                                    
                     ,:BG-NEW-RATE-PCT                                  
                     ,:BG-CODE-SUB-TOTAL                                
                     ,:BG-TAX-REFUND-CD                                 
                     ,:BG-ACCOUNT-NO                                    
                     ,:BG-COMPANY-NO                                    
                     ,:BG-DATE-LFTM-HI-DMD :NULL-DATE-LFTM-HI-DMD        
                     ,:BG-LFTM-HI-PEAK-DMD                              
                     ,:BG-REBILL-IND                                    
                     ,:BG-ADJ-REASON-CD                                 
                     ,:BG-REVENUE-MONTH                                 
                     ,:BG-GAS-BASE-USE                                  
                     ,:BG-WNA-FACTOR                                    
                     ,:BG-BTU-FACTOR                                    
                     ,:BG-NO-OF-CONS-DAYS                               
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-REV-DISTRICT-CD                               
                     ,:BG-FUEL-SHIPPER-CD                               
                     ,:BG-ALTERNATE-FUEL-CD                             
                     ,:BG-TRNSP-OVER-MDQ-FL                             
                     ,:BG-CITY-TAX-RATE                                 
                     ,:BG-OTHER-TAX-RATE                                
                     ,:BG-STATE-TAX-RATE                                
                     ,:BG-BILL-CALC-CYCLE                               
                     ,:BG-NAICS-CD                                      
                     ,:BG-RT-PKG-OPT-SEQ-NO                             
                 FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)             
                 JOIN  CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)             
                   ON  UT.ACCOUNT_NO         =  AT.ACCOUNT_NO           
                 JOIN  CSS_BILLING_HDR     BI WITH(READUNCOMMITTED)             
                   ON  BI.ACCOUNT_NO         =  AT.ACCOUNT_NO           
                  AND  BI.DATE_BILLED        IS NULL                    
                 JOIN  CSS_BILLING_DET     BG WITH(READUNCOMMITTED)             
                   ON  BG.ACCOUNT_NO         =  UT.ACCOUNT_NO           
                  AND  BG.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE       
                  AND  BG.IC_NO              =  UT.IC_NO                
                WHERE  AT.ACCOUNT_NO         = :AT-ACCOUNT-NO           
                  AND  BI.BILL_NO            =                          
                                 (SELECT  MAX(BB.BILL_NO)               
                                    FROM  CSS_BILLING_HDR BB
                           WITH(READUNCOMMITTED)            
                                   WHERE  BB.ACCOUNT_NO  = BI.ACCOUNT_NO
                                     AND  BB.DATE_BILLED IS NULL)       
                  AND  BG.BILL_NO            = BI.BILL_NO               
                  AND  BG.CODE_BILL_CALC     = 'A'                      
                  AND  BG.CODE_BILL_ITM_TYPE = 'C'                      
                  AND  BG.CODE_BILL_ITM_IND  = 'A'                      
                  AND  BG.DATE_ORIG_BILL     IS NULL                    
                  AND  BG.REV_MTH_ORIG_BILL  = 0                        
                ORDER BY BILL_ITEM_TIMESTMP DESC                     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  BG.PREMISE_NO                                            
MFA-TR*              , BG.BILL_NO                                               
MFA-TR*              , BG.CODE_UTIL_TYPE                                        
MFA-TR*              , BG.IC_NO                                                 
MFA-TR*              , BG.BILL_ITEM_TIMESTMP                                    
MFA-TR*              , BG.DATE_ORIG_BILL                                        
MFA-TR*              , BG.AMT_BILL_ITEM                                         
MFA-TR*              , BG.CODE_BILL_CALC                                        
MFA-TR*              , BG.CODE_BILL_ITM_TYPE                                    
MFA-TR*              , BG.CODE_BILL_ITM_IND                                     
MFA-TR*              , BG.CODE_DR_CR_CNSMPTN                                    
MFA-TR*              , BG.AMT_STATE_TAX                                         
MFA-TR*              , BG.AMT_CITY_TAX                                          
MFA-TR*              , BG.AMT_OTHER_TAX                                         
MFA-TR*              , BG.CODE_REVENUE_CLASS                                    
MFA-TR*              , BG.CODE_SIC_NO                                           
MFA-TR*              , BG.RATE_PLAN_NO                                          
MFA-TR*              , BG.CODE_CURTAIL_PRTY                                     
MFA-TR*              , BG.CODE_STAT_TAX_XMT                                     
MFA-TR*              , BG.CODE_CITY_TAX_XMT                                     
MFA-TR*              , BG.CODE_OTHR_TAX_XMT                                     
MFA-TR*              , BG.REV_RPT_CD                                            
MFA-TR*              , BG.STANDBY_COMPLIED                                      
MFA-TR*              , BG.PRORATE_CD                                            
MFA-TR*              , BG.NEW_RATE_PCT                                          
MFA-TR*              , BG.CODE_SUB_TOTAL                                        
MFA-TR*              , BG.TAX_REFUND_CD                                         
MFA-TR*              , BG.ACCOUNT_NO                                            
MFA-TR*              , BG.COMPANY_NO                                            
MFA-TR*              , BG.DATE_LFTM_HI_DMD                                      
MFA-TR*              , BG.LFTM_HI_PEAK_DMD                                      
MFA-TR*              , BG.REBILL_IND                                            
MFA-TR*              , BG.ADJ_REASON_CD                                         
MFA-TR*              , BG.REVENUE_MONTH                                         
MFA-TR*              , BG.GAS_BASE_USE                                          
MFA-TR*              , BG.WNA_FACTOR                                            
MFA-TR*              , BG.BTU_FACTOR                                            
MFA-TR*              , BG.NO_OF_CONS_DAYS                                       
MFA-TR*              , BG.REV_MTH_ORIG_BILL                                     
MFA-TR*              , BG.REV_DISTRICT_CD                                       
MFA-TR*              , BG.FUEL_SHIPPER_CD                                       
MFA-TR*              , BG.ALTERNATE_FUEL_CD                                     
MFA-TR*              , BG.TRNSP_OVER_MDQ_FL                                     
MFA-TR*              , BG.CITY_TAX_RATE                                         
MFA-TR*              , BG.OTHER_TAX_RATE                                        
MFA-TR*              , BG.STATE_TAX_RATE                                        
MFA-TR*              , BG.BILL_CALC_CYCLE                                       
MFA-TR*              , BG.NAICS_CD                                              
MFA-TR*              , BG.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*          INTO :BG-PREMISE-NO                                            
MFA-TR*              ,:BG-BILL-NO                                               
MFA-TR*              ,:BG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:BG-IC-NO                                                 
MFA-TR*              ,:BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-DATE-ORIG-BILL:NULL-DATE-ORIG-BILL                    
MFA-TR*              ,:BG-AMT-BILL-ITEM                                         
MFA-TR*              ,:BG-CODE-BILL-CALC                                        
MFA-TR*              ,:BG-CODE-BILL-ITM-TYPE                                    
MFA-TR*              ,:BG-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:BG-CODE-DR-CR-CNSMPTN                                    
MFA-TR*              ,:BG-AMT-STATE-TAX                                         
MFA-TR*              ,:BG-AMT-CITY-TAX                                          
MFA-TR*              ,:BG-AMT-OTHER-TAX                                         
MFA-TR*              ,:BG-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:BG-CODE-SIC-NO                                           
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*              ,:BG-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:BG-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:BG-REV-RPT-CD                                            
MFA-TR*              ,:BG-STANDBY-COMPLIED                                      
MFA-TR*              ,:BG-PRORATE-CD                                            
MFA-TR*              ,:BG-NEW-RATE-PCT                                          
MFA-TR*              ,:BG-CODE-SUB-TOTAL                                        
MFA-TR*              ,:BG-TAX-REFUND-CD                                         
MFA-TR*              ,:BG-ACCOUNT-NO                                            
MFA-TR*              ,:BG-COMPANY-NO                                            
MFA-TR*              ,:BG-DATE-LFTM-HI-DMD:NULL-DATE-LFTM-HI-DMD                
MFA-TR*              ,:BG-LFTM-HI-PEAK-DMD                                      
MFA-TR*              ,:BG-REBILL-IND                                            
MFA-TR*              ,:BG-ADJ-REASON-CD                                         
MFA-TR*              ,:BG-REVENUE-MONTH                                         
MFA-TR*              ,:BG-GAS-BASE-USE                                          
MFA-TR*              ,:BG-WNA-FACTOR                                            
MFA-TR*              ,:BG-BTU-FACTOR                                            
MFA-TR*              ,:BG-NO-OF-CONS-DAYS                                       
MFA-TR*              ,:BG-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:BG-REV-DISTRICT-CD                                       
MFA-TR*              ,:BG-FUEL-SHIPPER-CD                                       
MFA-TR*              ,:BG-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:BG-TRNSP-OVER-MDQ-FL                                     
MFA-TR*              ,:BG-CITY-TAX-RATE                                         
MFA-TR*              ,:BG-OTHER-TAX-RATE                                        
MFA-TR*              ,:BG-STATE-TAX-RATE                                        
MFA-TR*              ,:BG-BILL-CALC-CYCLE                                       
MFA-TR*              ,:BG-NAICS-CD                                              
MFA-TR*              ,:BG-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*          FROM  CSS_ACCOUNT         AT                                   
MFA-TR*          JOIN  CSS_UTIL_ENVRNMT    UT                                   
MFA-TR*            ON  UT.ACCOUNT_NO         =  AT.ACCOUNT_NO                   
MFA-TR*          JOIN  CSS_BILLING_HDR     BI                                   
MFA-TR*            ON  BI.ACCOUNT_NO         =  AT.ACCOUNT_NO                   
MFA-TR*           AND  BI.DATE_BILLED        IS NULL                            
MFA-TR*          JOIN  CSS_BILLING_DET     BG                                   
MFA-TR*            ON  BG.ACCOUNT_NO         =  UT.ACCOUNT_NO                   
MFA-TR*           AND  BG.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE               
MFA-TR*           AND  BG.IC_NO              =  UT.IC_NO                        
MFA-TR*         WHERE  AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                   
MFA-TR*           AND  BI.BILL_NO            =                                  
MFA-TR*                          (SELECT  MAX(BB.BILL_NO)                       
MFA-TR*                             FROM  CSS_BILLING_HDR BB                    
MFA-TR*                            WHERE  BB.ACCOUNT_NO  = BI.ACCOUNT_NO        
MFA-TR*                              AND  BB.DATE_BILLED IS NULL)               
MFA-TR*           AND  BG.BILL_NO            = BI.BILL_NO                       
MFA-TR*           AND  BG.CODE_BILL_CALC     = 'A'                              
MFA-TR*           AND  BG.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*           AND  BG.CODE_BILL_ITM_IND  = 'A'                              
MFA-TR*           AND  BG.DATE_ORIG_BILL     IS NULL                            
MFA-TR*           AND  BG.REV_MTH_ORIG_BILL  = 0                                
MFA-TR*         ORDER BY BG.BILL_ITEM_TIMESTMP DESC                             
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-GET-CNSMPTN-HIST.                                         *        
      *      GET CONSUMPTION DETAILS FOR THE FUTURE BILL HOOK.         *        
      ******************************************************************        
       7150-GET-CNSMPTN-HIST.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CX.MTR_REF_NO,
              CX.REG_ID_NO,
              CX.CODE_TIME_PERIOD,
              CX.ITEM_SEQ_NO,
              CX.CODE_USAGE_TYPE,
              CX.CODE_USAGE_ID,
              CX.CODE_USAGE_SOURCE,
              CX.METER_NO,
              CX.DATE_READ,
              CX.CODE_METER_READ,
              CX.CODE_METER_NO_READ,
              CX.METER_READING,
              CX.DEMAND_READING,
              CX.EMPLOYEE_NO,
              CX.NO_UNITS,
              CX.NO_DEMAND_UNITS,
              CX.NO_DAYS,
              CX.CODE_SOURCE_ID,
              CX.CODE_DEBIT_CREDIT,
              CX.CODE_ITEM_STATUS,
              CX.CODE_DISCOUNT,
              CX.CONSTANT,
              CX.NO_DIALS,
              CX.COMPANY_NO,
              CX.EXCEPT_OVERRIDE_CD,
              CX.REQUESTED_USAGE,
              CX.DIGTL_INTRL_MTR_NO,
              CX.DIGTL_MTR_TYPE,
              CX.CODE_TOU_SEASN,
              CX.EXCL_DMD_RCHT_IND,
              CX.MTR_READ_SOURCE_CD,
              CX.BTU_FACTOR,
              CX.PCOMP_FCT,
              CX.PEAK_DEMAND_DT,
              CX.PRV_MTR_RD_COMB_FL                            
                 INTO :CX-MTR-REF-NO                                    
                     ,:CX-REG-ID-NO                                     
                     ,:CX-CODE-TIME-PERIOD                              
                     ,:CX-ITEM-SEQ-NO                                   
                     ,:CX-CODE-USAGE-TYPE                               
                     ,:CX-CODE-USAGE-ID                                 
                     ,:CX-CODE-USAGE-SOURCE                             
                     ,:CX-METER-NO                                      
                     ,:CX-DATE-READ :NULL-DATE-READ                      
                     ,:CX-CODE-METER-READ                               
                     ,:CX-CODE-METER-NO-READ                            
                     ,:CX-METER-READING                                 
                     ,:CX-DEMAND-READING                                
                     ,:CX-EMPLOYEE-NO                                   
                     ,:CX-NO-UNITS                                      
                     ,:CX-NO-DEMAND-UNITS                               
                     ,:CX-NO-DAYS                                       
                     ,:CX-CODE-SOURCE-ID                                
                     ,:CX-CODE-DEBIT-CREDIT                             
                     ,:CX-CODE-ITEM-STATUS                              
                     ,:CX-CODE-DISCOUNT                                 
                     ,:CX-CONSTANT                                      
                     ,:CX-NO-DIALS                                      
                     ,:CX-COMPANY-NO                                    
                     ,:CX-EXCEPT-OVERRIDE-CD                            
                     ,:CX-REQUESTED-USAGE                               
                     ,:CX-DIGTL-INTRL-MTR-NO                            
                     ,:CX-DIGTL-MTR-TYPE                                
                     ,:CX-CODE-TOU-SEASN                                
                     ,:CX-EXCL-DMD-RCHT-IND                             
                     ,:CX-MTR-READ-SOURCE-CD                            
                     ,:CX-BTU-FACTOR                                    
                     ,:CX-PCOMP-FCT                                     
                     ,:CX-PEAK-DEMAND-DT :NULL-PEAK-DEMAND-DT            
                     ,:CX-PRV-MTR-RD-COMB-FL                            
                 FROM  CSS_CNSMPTN_HIST    CX WITH(READUNCOMMITTED)             
                WHERE  CX.ACCOUNT_NO         = :CX-ACCOUNT-NO           
                  AND  CX.BILL_NO            = :CX-BILL-NO              
                  AND  CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE       
                  AND  CX.IC_NO              = :CX-IC-NO                
                  AND  CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )   
                ORDER  BY CX.ITEM_SEQ_NO DESC                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CX.MTR_REF_NO                                            
MFA-TR*              , CX.REG_ID_NO                                             
MFA-TR*              , CX.CODE_TIME_PERIOD                                      
MFA-TR*              , CX.ITEM_SEQ_NO                                           
MFA-TR*              , CX.CODE_USAGE_TYPE                                       
MFA-TR*              , CX.CODE_USAGE_ID                                         
MFA-TR*              , CX.CODE_USAGE_SOURCE                                     
MFA-TR*              , CX.METER_NO                                              
MFA-TR*              , CX.DATE_READ                                             
MFA-TR*              , CX.CODE_METER_READ                                       
MFA-TR*              , CX.CODE_METER_NO_READ                                    
MFA-TR*              , CX.METER_READING                                         
MFA-TR*              , CX.DEMAND_READING                                        
MFA-TR*              , CX.EMPLOYEE_NO                                           
MFA-TR*              , CX.NO_UNITS                                              
MFA-TR*              , CX.NO_DEMAND_UNITS                                       
MFA-TR*              , CX.NO_DAYS                                               
MFA-TR*              , CX.CODE_SOURCE_ID                                        
MFA-TR*              , CX.CODE_DEBIT_CREDIT                                     
MFA-TR*              , CX.CODE_ITEM_STATUS                                      
MFA-TR*              , CX.CODE_DISCOUNT                                         
MFA-TR*              , CX.CONSTANT                                              
MFA-TR*              , CX.NO_DIALS                                              
MFA-TR*              , CX.COMPANY_NO                                            
MFA-TR*              , CX.EXCEPT_OVERRIDE_CD                                    
MFA-TR*              , CX.REQUESTED_USAGE                                       
MFA-TR*              , CX.DIGTL_INTRL_MTR_NO                                    
MFA-TR*              , CX.DIGTL_MTR_TYPE                                        
MFA-TR*              , CX.CODE_TOU_SEASN                                        
MFA-TR*              , CX.EXCL_DMD_RCHT_IND                                     
MFA-TR*              , CX.MTR_READ_SOURCE_CD                                    
MFA-TR*              , CX.BTU_FACTOR                                            
MFA-TR*              , CX.PCOMP_FCT                                             
MFA-TR*              , CX.PEAK_DEMAND_DT                                        
MFA-TR*              , CX.PRV_MTR_RD_COMB_FL                                    
MFA-TR*          INTO :CX-MTR-REF-NO                                            
MFA-TR*              ,:CX-REG-ID-NO                                             
MFA-TR*              ,:CX-CODE-TIME-PERIOD                                      
MFA-TR*              ,:CX-ITEM-SEQ-NO                                           
MFA-TR*              ,:CX-CODE-USAGE-TYPE                                       
MFA-TR*              ,:CX-CODE-USAGE-ID                                         
MFA-TR*              ,:CX-CODE-USAGE-SOURCE                                     
MFA-TR*              ,:CX-METER-NO                                              
MFA-TR*              ,:CX-DATE-READ:NULL-DATE-READ                              
MFA-TR*              ,:CX-CODE-METER-READ                                       
MFA-TR*              ,:CX-CODE-METER-NO-READ                                    
MFA-TR*              ,:CX-METER-READING                                         
MFA-TR*              ,:CX-DEMAND-READING                                        
MFA-TR*              ,:CX-EMPLOYEE-NO                                           
MFA-TR*              ,:CX-NO-UNITS                                              
MFA-TR*              ,:CX-NO-DEMAND-UNITS                                       
MFA-TR*              ,:CX-NO-DAYS                                               
MFA-TR*              ,:CX-CODE-SOURCE-ID                                        
MFA-TR*              ,:CX-CODE-DEBIT-CREDIT                                     
MFA-TR*              ,:CX-CODE-ITEM-STATUS                                      
MFA-TR*              ,:CX-CODE-DISCOUNT                                         
MFA-TR*              ,:CX-CONSTANT                                              
MFA-TR*              ,:CX-NO-DIALS                                              
MFA-TR*              ,:CX-COMPANY-NO                                            
MFA-TR*              ,:CX-EXCEPT-OVERRIDE-CD                                    
MFA-TR*              ,:CX-REQUESTED-USAGE                                       
MFA-TR*              ,:CX-DIGTL-INTRL-MTR-NO                                    
MFA-TR*              ,:CX-DIGTL-MTR-TYPE                                        
MFA-TR*              ,:CX-CODE-TOU-SEASN                                        
MFA-TR*              ,:CX-EXCL-DMD-RCHT-IND                                     
MFA-TR*              ,:CX-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:CX-BTU-FACTOR                                            
MFA-TR*              ,:CX-PCOMP-FCT                                             
MFA-TR*              ,:CX-PEAK-DEMAND-DT:NULL-PEAK-DEMAND-DT                    
MFA-TR*              ,:CX-PRV-MTR-RD-COMB-FL                                    
MFA-TR*          FROM  CSS_CNSMPTN_HIST    CX                                   
MFA-TR*         WHERE  CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                   
MFA-TR*           AND  CX.BILL_NO            = :CX-BILL-NO                      
MFA-TR*           AND  CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE               
MFA-TR*           AND  CX.IC_NO              = :CX-IC-NO                        
MFA-TR*           AND  CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP           
MFA-TR*         ORDER  BY CX.ITEM_SEQ_NO DESC                                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE CX-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE CX-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CX-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'     TO TABLE-ELEMENT-4          
              MOVE CX-BILL-ITEM-TIMESTMP    TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-COMMON-DATE.                                          *        
      *      GET COMMON DATE FROM CSS_JOB_PARM.                        *        
      ******************************************************************        
       7200-GET-COMMON-DATE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT  CIS.SUBSTR3(G6.PARM_DATA,10,10)                       
                 INTO :WS-COMMON-RUN-DATE                               
                 FROM  CSS_JOB_PARM   G6 WITH(READUNCOMMITTED)                  
                WHERE  G6.PROGRAM_NAME  =  'COMMON'                     
                  AND  G6.COMPANY_NO    =  '01'                         
                  AND  G6.CMND_CODE     =  'DATE'                       
                  AND  G6.SEQ_NO        =  10                           
                  AND  G6.STATUS        =  'A'                          
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUBSTR(G6.PARM_DATA,10,10)                               
MFA-TR*          INTO :WS-COMMON-RUN-DATE                                       
MFA-TR*          FROM  CSS_JOB_PARM   G6                                        
MFA-TR*         WHERE  G6.PROGRAM_NAME  =  'COMMON'                             
MFA-TR*           AND  G6.COMPANY_NO    =  '01'                                 
MFA-TR*           AND  G6.CMND_CODE     =  'DATE'                               
MFA-TR*           AND  G6.SEQ_NO        =  10                                   
MFA-TR*           AND  G6.STATUS        =  'A'                                  
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-COMMON-REV-MTH.                                       *        
      *      GET COMMON REVENUE MONTH FROM CSS_JOB_PARM.               *        
      ******************************************************************        
       7300-GET-COMMON-REV-MTH.                                         
                                                                        
           EXEC SQL                                                     
               SELECT  CIS.SUBSTR3(G6.PARM_DATA,15,6)                        
                 INTO :G6-PARM-DATA                                     
                 FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                   
                WHERE  G6.PROGRAM_NAME  =  'COMMON'                     
                  AND  G6.CMND_CODE     =  'DATE'                       
                  AND  G6.SEQ_NO        =  20                           
                  AND  G6.STATUS        =  'A'                          
                  AND  G6.COMPANY_NO    =  '01'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUBSTR(G6.PARM_DATA,15,6)                                
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM  CSS_JOB_PARM  G6                                         
MFA-TR*         WHERE  G6.PROGRAM_NAME  =  'COMMON'                             
MFA-TR*           AND  G6.CMND_CODE     =  'DATE'                               
MFA-TR*           AND  G6.SEQ_NO        =  20                                   
MFA-TR*           AND  G6.STATUS        =  'A'                                  
MFA-TR*           AND  G6.COMPANY_NO    =  '01'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-CURRENT-TIMESTAMP.                                    *        
      *      GET THE CURRENT SYSTEM TIMESTAMP.                         *        
      ******************************************************************        
       7400-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              MOVE 'CURRENT_TIMESTAMP'      TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-CURRENT-DATE.                                         *        
      *      GET THE CURRENT SYSTEM DATE.                              *        
      ******************************************************************        
       7500-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              MOVE 'CURRENT_DATE'           TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04869_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04869_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '8000A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DELETE'             TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04869_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04869_R1                          
                  (                                                     
                    RETURN_CODE                                         
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04869_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04869_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-BILLING-DET.                                       *        
      ******************************************************************        
       8200-INSERT-BILLING-DET.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_DET                              
                    (                                                   
                       PREMISE_NO                                       
                      ,BILL_NO                                          
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,BILL_ITEM_TIMESTMP                               
                      ,DATE_ORIG_BILL                                   
                      ,AMT_BILL_ITEM                                    
                      ,CODE_BILL_CALC                                   
                      ,CODE_BILL_ITM_TYPE                               
                      ,CODE_BILL_ITM_IND                                
                      ,CODE_DR_CR_CNSMPTN                               
                      ,AMT_STATE_TAX                                    
                      ,AMT_CITY_TAX                                     
                      ,AMT_OTHER_TAX                                    
                      ,CODE_REVENUE_CLASS                               
                      ,CODE_SIC_NO                                      
                      ,RATE_PLAN_NO                                     
                      ,CODE_CURTAIL_PRTY                                
                      ,CODE_STAT_TAX_XMT                                
                      ,CODE_CITY_TAX_XMT                                
                      ,CODE_OTHR_TAX_XMT                                
                      ,REV_RPT_CD                                       
                      ,STANDBY_COMPLIED                                 
                      ,PRORATE_CD                                       
                      ,NEW_RATE_PCT                                     
                      ,CODE_SUB_TOTAL                                   
                      ,TAX_REFUND_CD                                    
                      ,ACCOUNT_NO                                       
                      ,COMPANY_NO                                       
                      ,DATE_LFTM_HI_DMD                                 
                      ,LFTM_HI_PEAK_DMD                                 
                      ,REBILL_IND                                       
                      ,ADJ_REASON_CD                                    
                      ,REVENUE_MONTH                                    
                      ,GAS_BASE_USE                                     
                      ,WNA_FACTOR                                       
                      ,BTU_FACTOR                                       
                      ,NO_OF_CONS_DAYS                                  
                      ,REV_MTH_ORIG_BILL                                
                      ,REV_DISTRICT_CD                                  
                      ,FUEL_SHIPPER_CD                                  
                      ,ALTERNATE_FUEL_CD                                
                      ,TRNSP_OVER_MDQ_FL                                
                      ,CITY_TAX_RATE                                    
                      ,OTHER_TAX_RATE                                   
                      ,STATE_TAX_RATE                                   
                      ,BILL_CALC_CYCLE                                  
                      ,NAICS_CD                                         
                      ,RT_PKG_OPT_SEQ_NO                                
                    )                                                   
               VALUES                                                   
                    (                                                   
                       :BG-PREMISE-NO                                   
                      ,:BG-BILL-NO                                      
                      ,:BG-CODE-UTIL-TYPE                               
                      ,:BG-IC-NO                                        
                      ,CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP)               
                      ,IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                             :NULL-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                   :NULL-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :NULL-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                   :NULL-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL :NULL-DATE-ORIG-BILL
              ) )           
                      ,:BG-AMT-BILL-ITEM                                
                      ,:BG-CODE-BILL-CALC                               
                      ,:BG-CODE-BILL-ITM-TYPE                           
                      ,:BG-CODE-BILL-ITM-IND                            
                      ,:BG-CODE-DR-CR-CNSMPTN                           
                      ,:BG-AMT-STATE-TAX                                
                      ,:BG-AMT-CITY-TAX                                 
                      ,:BG-AMT-OTHER-TAX                                
                      ,:BG-CODE-REVENUE-CLASS                           
                      ,:BG-CODE-SIC-NO                                  
                      ,:BG-RATE-PLAN-NO                                 
                      ,:BG-CODE-CURTAIL-PRTY                            
                      ,:BG-CODE-STAT-TAX-XMT                            
                      ,:BG-CODE-CITY-TAX-XMT                            
                      ,:BG-CODE-OTHR-TAX-XMT                            
                      ,:BG-REV-RPT-CD                                   
                      ,:BG-STANDBY-COMPLIED                             
                      ,:BG-PRORATE-CD                                   
                      ,:BG-NEW-RATE-PCT                                 
                      ,:BG-CODE-SUB-TOTAL                               
                      ,:BG-TAX-REFUND-CD                                
                      ,:BG-ACCOUNT-NO                                   
                      ,:BG-COMPANY-NO                                   
                      ,IIF(TRY_CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                             :NULL-DATE-LFTM-HI-DMD
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-LFTM-HI-DMD 
                                                 :NULL-DATE-LFTM-HI-DMD
              ) <> 0) OR (LEN(:BG-DATE-LFTM-HI-DMD 
                                                 :NULL-DATE-LFTM-HI-DMD
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-LFTM-HI-DMD 
                                                 :NULL-DATE-LFTM-HI-DMD
              ), CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                                 :NULL-DATE-LFTM-HI-DMD
              ) )       
                      ,:BG-LFTM-HI-PEAK-DMD                             
                      ,:BG-REBILL-IND                                   
                      ,:BG-ADJ-REASON-CD                                
                      ,:BG-REVENUE-MONTH                                
                      ,:BG-GAS-BASE-USE                                 
                      ,:BG-WNA-FACTOR                                   
                      ,:BG-BTU-FACTOR                                   
                      ,:BG-NO-OF-CONS-DAYS                              
                      ,:BG-REV-MTH-ORIG-BILL                            
                      ,:BG-REV-DISTRICT-CD                              
                      ,:BG-FUEL-SHIPPER-CD                              
                      ,:BG-ALTERNATE-FUEL-CD                            
                      ,:BG-TRNSP-OVER-MDQ-FL                            
                      ,:BG-CITY-TAX-RATE                                
                      ,:BG-OTHER-TAX-RATE                               
                      ,:BG-STATE-TAX-RATE                               
                      ,:BG-BILL-CALC-CYCLE                              
                      ,:BG-NAICS-CD                                     
                      ,:BG-RT-PKG-OPT-SEQ-NO                            
                    )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_DET                                      
MFA-TR*             (                                                           
MFA-TR*                PREMISE_NO                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,DATE_ORIG_BILL                                           
MFA-TR*               ,AMT_BILL_ITEM                                            
MFA-TR*               ,CODE_BILL_CALC                                           
MFA-TR*               ,CODE_BILL_ITM_TYPE                                       
MFA-TR*               ,CODE_BILL_ITM_IND                                        
MFA-TR*               ,CODE_DR_CR_CNSMPTN                                       
MFA-TR*               ,AMT_STATE_TAX                                            
MFA-TR*               ,AMT_CITY_TAX                                             
MFA-TR*               ,AMT_OTHER_TAX                                            
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,CODE_SIC_NO                                              
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,CODE_CURTAIL_PRTY                                        
MFA-TR*               ,CODE_STAT_TAX_XMT                                        
MFA-TR*               ,CODE_CITY_TAX_XMT                                        
MFA-TR*               ,CODE_OTHR_TAX_XMT                                        
MFA-TR*               ,REV_RPT_CD                                               
MFA-TR*               ,STANDBY_COMPLIED                                         
MFA-TR*               ,PRORATE_CD                                               
MFA-TR*               ,NEW_RATE_PCT                                             
MFA-TR*               ,CODE_SUB_TOTAL                                           
MFA-TR*               ,TAX_REFUND_CD                                            
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,DATE_LFTM_HI_DMD                                         
MFA-TR*               ,LFTM_HI_PEAK_DMD                                         
MFA-TR*               ,REBILL_IND                                               
MFA-TR*               ,ADJ_REASON_CD                                            
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,GAS_BASE_USE                                             
MFA-TR*               ,WNA_FACTOR                                               
MFA-TR*               ,BTU_FACTOR                                               
MFA-TR*               ,NO_OF_CONS_DAYS                                          
MFA-TR*               ,REV_MTH_ORIG_BILL                                        
MFA-TR*               ,REV_DISTRICT_CD                                          
MFA-TR*               ,FUEL_SHIPPER_CD                                          
MFA-TR*               ,ALTERNATE_FUEL_CD                                        
MFA-TR*               ,TRNSP_OVER_MDQ_FL                                        
MFA-TR*               ,CITY_TAX_RATE                                            
MFA-TR*               ,OTHER_TAX_RATE                                           
MFA-TR*               ,STATE_TAX_RATE                                           
MFA-TR*               ,BILL_CALC_CYCLE                                          
MFA-TR*               ,NAICS_CD                                                 
MFA-TR*               ,RT_PKG_OPT_SEQ_NO                                        
MFA-TR*             )                                                           
MFA-TR*        VALUES                                                           
MFA-TR*             (                                                           
MFA-TR*                :BG-PREMISE-NO                                           
MFA-TR*               ,:BG-BILL-NO                                              
MFA-TR*               ,:BG-CODE-UTIL-TYPE                                       
MFA-TR*               ,:BG-IC-NO                                                
MFA-TR*               ,:BG-BILL-ITEM-TIMESTMP                                   
MFA-TR*               ,:BG-DATE-ORIG-BILL:NULL-DATE-ORIG-BILL                   
MFA-TR*               ,:BG-AMT-BILL-ITEM                                        
MFA-TR*               ,:BG-CODE-BILL-CALC                                       
MFA-TR*               ,:BG-CODE-BILL-ITM-TYPE                                   
MFA-TR*               ,:BG-CODE-BILL-ITM-IND                                    
MFA-TR*               ,:BG-CODE-DR-CR-CNSMPTN                                   
MFA-TR*               ,:BG-AMT-STATE-TAX                                        
MFA-TR*               ,:BG-AMT-CITY-TAX                                         
MFA-TR*               ,:BG-AMT-OTHER-TAX                                        
MFA-TR*               ,:BG-CODE-REVENUE-CLASS                                   
MFA-TR*               ,:BG-CODE-SIC-NO                                          
MFA-TR*               ,:BG-RATE-PLAN-NO                                         
MFA-TR*               ,:BG-CODE-CURTAIL-PRTY                                    
MFA-TR*               ,:BG-CODE-STAT-TAX-XMT                                    
MFA-TR*               ,:BG-CODE-CITY-TAX-XMT                                    
MFA-TR*               ,:BG-CODE-OTHR-TAX-XMT                                    
MFA-TR*               ,:BG-REV-RPT-CD                                           
MFA-TR*               ,:BG-STANDBY-COMPLIED                                     
MFA-TR*               ,:BG-PRORATE-CD                                           
MFA-TR*               ,:BG-NEW-RATE-PCT                                         
MFA-TR*               ,:BG-CODE-SUB-TOTAL                                       
MFA-TR*               ,:BG-TAX-REFUND-CD                                        
MFA-TR*               ,:BG-ACCOUNT-NO                                           
MFA-TR*               ,:BG-COMPANY-NO                                           
MFA-TR*               ,:BG-DATE-LFTM-HI-DMD:NULL-DATE-LFTM-HI-DMD               
MFA-TR*               ,:BG-LFTM-HI-PEAK-DMD                                     
MFA-TR*               ,:BG-REBILL-IND                                           
MFA-TR*               ,:BG-ADJ-REASON-CD                                        
MFA-TR*               ,:BG-REVENUE-MONTH                                        
MFA-TR*               ,:BG-GAS-BASE-USE                                         
MFA-TR*               ,:BG-WNA-FACTOR                                           
MFA-TR*               ,:BG-BTU-FACTOR                                           
MFA-TR*               ,:BG-NO-OF-CONS-DAYS                                      
MFA-TR*               ,:BG-REV-MTH-ORIG-BILL                                    
MFA-TR*               ,:BG-REV-DISTRICT-CD                                      
MFA-TR*               ,:BG-FUEL-SHIPPER-CD                                      
MFA-TR*               ,:BG-ALTERNATE-FUEL-CD                                    
MFA-TR*               ,:BG-TRNSP-OVER-MDQ-FL                                    
MFA-TR*               ,:BG-CITY-TAX-RATE                                        
MFA-TR*               ,:BG-OTHER-TAX-RATE                                       
MFA-TR*               ,:BG-STATE-TAX-RATE                                       
MFA-TR*               ,:BG-BILL-CALC-CYCLE                                      
MFA-TR*               ,:BG-NAICS-CD                                             
MFA-TR*               ,:BG-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'     TO TABLE-ELEMENT-4          
              MOVE BG-BILL-ITEM-TIMESTMP    TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-INSERT-CNSMPTN-HIST.                                      *        
      ******************************************************************        
       8300-INSERT-CNSMPTN-HIST.                                        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CNSMPTN_HIST                             
                    (                                                   
                       ACCOUNT_NO                                       
                      ,BILL_NO                                          
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,BILL_ITEM_TIMESTMP                               
                      ,MTR_REF_NO                                       
                      ,REG_ID_NO                                        
                      ,CODE_TIME_PERIOD                                 
                      ,ITEM_SEQ_NO                                      
                      ,CODE_USAGE_TYPE                                  
                      ,CODE_USAGE_ID                                    
                      ,CODE_USAGE_SOURCE                                
                      ,METER_NO                                         
                      ,DATE_READ                                        
                      ,CODE_METER_READ                                  
                      ,CODE_METER_NO_READ                               
                      ,METER_READING                                    
                      ,DEMAND_READING                                   
                      ,EMPLOYEE_NO                                      
                      ,NO_UNITS                                         
                      ,NO_DEMAND_UNITS                                  
                      ,NO_DAYS                                          
                      ,CODE_SOURCE_ID                                   
                      ,CODE_DEBIT_CREDIT                                
                      ,CODE_ITEM_STATUS                                 
                      ,CODE_DISCOUNT                                    
                      ,CONSTANT                                         
                      ,NO_DIALS                                         
                      ,COMPANY_NO                                       
                      ,EXCEPT_OVERRIDE_CD                               
                      ,REQUESTED_USAGE                                  
                      ,DIGTL_INTRL_MTR_NO                               
                      ,DIGTL_MTR_TYPE                                   
                      ,CODE_TOU_SEASN                                   
                      ,EXCL_DMD_RCHT_IND                                
                      ,MTR_READ_SOURCE_CD                               
                      ,BTU_FACTOR                                       
                      ,PCOMP_FCT                                        
                      ,PEAK_DEMAND_DT                                   
                      ,PRV_MTR_RD_COMB_FL                               
                    )                                                   
               VALUES                                                   
                    (                                                   
                       :CX-ACCOUNT-NO                                   
                      ,:CX-BILL-NO                                      
                      ,:CX-CODE-UTIL-TYPE                               
                      ,:CX-IC-NO                                        
                      ,CIS.CHAR2TIMESTAMP(:CX-BILL-ITEM-TIMESTMP)               
                      ,:CX-MTR-REF-NO                                   
                      ,:CX-REG-ID-NO                                    
                      ,:CX-CODE-TIME-PERIOD                             
                      ,:CX-ITEM-SEQ-NO                                  
                      ,:CX-CODE-USAGE-TYPE                              
                      ,:CX-CODE-USAGE-ID                                
                      ,:CX-CODE-USAGE-SOURCE                            
                      ,:CX-METER-NO                                     
                      ,IIF(TRY_CONVERT(DATE, :CX-DATE-READ 
                                             :NULL-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ 
                                                        :NULL-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ :NULL-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:CX-DATE-READ :NULL-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ :NULL-DATE-READ) )                
                      ,:CX-CODE-METER-READ                              
                      ,:CX-CODE-METER-NO-READ                           
                      ,:CX-METER-READING                                
                      ,:CX-DEMAND-READING                               
                      ,:CX-EMPLOYEE-NO                                  
                      ,:CX-NO-UNITS                                     
                      ,:CX-NO-DEMAND-UNITS                              
                      ,:CX-NO-DAYS                                      
                      ,:CX-CODE-SOURCE-ID                               
                      ,:CX-CODE-DEBIT-CREDIT                            
                      ,:CX-CODE-ITEM-STATUS                             
                      ,:CX-CODE-DISCOUNT                                
                      ,:CX-CONSTANT                                     
                      ,:CX-NO-DIALS                                     
                      ,:CX-COMPANY-NO                                   
                      ,:CX-EXCEPT-OVERRIDE-CD                           
                      ,:CX-REQUESTED-USAGE                              
                      ,:CX-DIGTL-INTRL-MTR-NO                           
                      ,:CX-DIGTL-MTR-TYPE                               
                      ,:CX-CODE-TOU-SEASN                               
                      ,:CX-EXCL-DMD-RCHT-IND                            
                      ,:CX-MTR-READ-SOURCE-CD                           
                      ,:CX-BTU-FACTOR                                   
                      ,:CX-PCOMP-FCT                                    
                      ,IIF(TRY_CONVERT(DATE, :CX-PEAK-DEMAND-DT 
                                             :NULL-PEAK-DEMAND-DT
              ) IS NULL OR (PATINDEX('%.%', :CX-PEAK-DEMAND-DT 
                                                   :NULL-PEAK-DEMAND-DT
              ) <> 0) OR (LEN(:CX-PEAK-DEMAND-DT :NULL-PEAK-DEMAND-DT
              ) <> 10), CIS.CHAR2DATE(:CX-PEAK-DEMAND-DT 
                                                   :NULL-PEAK-DEMAND-DT
              ), CONVERT(DATE, :CX-PEAK-DEMAND-DT :NULL-PEAK-DEMAND-DT
              ) )           
                      ,:CX-PRV-MTR-RD-COMB-FL                           
                    )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CNSMPTN_HIST                                     
MFA-TR*             (                                                           
MFA-TR*                ACCOUNT_NO                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,MTR_REF_NO                                               
MFA-TR*               ,REG_ID_NO                                                
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,ITEM_SEQ_NO                                              
MFA-TR*               ,CODE_USAGE_TYPE                                          
MFA-TR*               ,CODE_USAGE_ID                                            
MFA-TR*               ,CODE_USAGE_SOURCE                                        
MFA-TR*               ,METER_NO                                                 
MFA-TR*               ,DATE_READ                                                
MFA-TR*               ,CODE_METER_READ                                          
MFA-TR*               ,CODE_METER_NO_READ                                       
MFA-TR*               ,METER_READING                                            
MFA-TR*               ,DEMAND_READING                                           
MFA-TR*               ,EMPLOYEE_NO                                              
MFA-TR*               ,NO_UNITS                                                 
MFA-TR*               ,NO_DEMAND_UNITS                                          
MFA-TR*               ,NO_DAYS                                                  
MFA-TR*               ,CODE_SOURCE_ID                                           
MFA-TR*               ,CODE_DEBIT_CREDIT                                        
MFA-TR*               ,CODE_ITEM_STATUS                                         
MFA-TR*               ,CODE_DISCOUNT                                            
MFA-TR*               ,CONSTANT                                                 
MFA-TR*               ,NO_DIALS                                                 
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,EXCEPT_OVERRIDE_CD                                       
MFA-TR*               ,REQUESTED_USAGE                                          
MFA-TR*               ,DIGTL_INTRL_MTR_NO                                       
MFA-TR*               ,DIGTL_MTR_TYPE                                           
MFA-TR*               ,CODE_TOU_SEASN                                           
MFA-TR*               ,EXCL_DMD_RCHT_IND                                        
MFA-TR*               ,MTR_READ_SOURCE_CD                                       
MFA-TR*               ,BTU_FACTOR                                               
MFA-TR*               ,PCOMP_FCT                                                
MFA-TR*               ,PEAK_DEMAND_DT                                           
MFA-TR*               ,PRV_MTR_RD_COMB_FL                                       
MFA-TR*             )                                                           
MFA-TR*        VALUES                                                           
MFA-TR*             (                                                           
MFA-TR*                :CX-ACCOUNT-NO                                           
MFA-TR*               ,:CX-BILL-NO                                              
MFA-TR*               ,:CX-CODE-UTIL-TYPE                                       
MFA-TR*               ,:CX-IC-NO                                                
MFA-TR*               ,:CX-BILL-ITEM-TIMESTMP                                   
MFA-TR*               ,:CX-MTR-REF-NO                                           
MFA-TR*               ,:CX-REG-ID-NO                                            
MFA-TR*               ,:CX-CODE-TIME-PERIOD                                     
MFA-TR*               ,:CX-ITEM-SEQ-NO                                          
MFA-TR*               ,:CX-CODE-USAGE-TYPE                                      
MFA-TR*               ,:CX-CODE-USAGE-ID                                        
MFA-TR*               ,:CX-CODE-USAGE-SOURCE                                    
MFA-TR*               ,:CX-METER-NO                                             
MFA-TR*               ,:CX-DATE-READ:NULL-DATE-READ                             
MFA-TR*               ,:CX-CODE-METER-READ                                      
MFA-TR*               ,:CX-CODE-METER-NO-READ                                   
MFA-TR*               ,:CX-METER-READING                                        
MFA-TR*               ,:CX-DEMAND-READING                                       
MFA-TR*               ,:CX-EMPLOYEE-NO                                          
MFA-TR*               ,:CX-NO-UNITS                                             
MFA-TR*               ,:CX-NO-DEMAND-UNITS                                      
MFA-TR*               ,:CX-NO-DAYS                                              
MFA-TR*               ,:CX-CODE-SOURCE-ID                                       
MFA-TR*               ,:CX-CODE-DEBIT-CREDIT                                    
MFA-TR*               ,:CX-CODE-ITEM-STATUS                                     
MFA-TR*               ,:CX-CODE-DISCOUNT                                        
MFA-TR*               ,:CX-CONSTANT                                             
MFA-TR*               ,:CX-NO-DIALS                                             
MFA-TR*               ,:CX-COMPANY-NO                                           
MFA-TR*               ,:CX-EXCEPT-OVERRIDE-CD                                   
MFA-TR*               ,:CX-REQUESTED-USAGE                                      
MFA-TR*               ,:CX-DIGTL-INTRL-MTR-NO                                   
MFA-TR*               ,:CX-DIGTL-MTR-TYPE                                       
MFA-TR*               ,:CX-CODE-TOU-SEASN                                       
MFA-TR*               ,:CX-EXCL-DMD-RCHT-IND                                    
MFA-TR*               ,:CX-MTR-READ-SOURCE-CD                                   
MFA-TR*               ,:CX-BTU-FACTOR                                           
MFA-TR*               ,:CX-PCOMP-FCT                                            
MFA-TR*               ,:CX-PEAK-DEMAND-DT:NULL-PEAK-DEMAND-DT                   
MFA-TR*               ,:CX-PRV-MTR-RD-COMB-FL                                   
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE CX-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE CX-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CX-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'     TO TABLE-ELEMENT-4          
              MOVE CX-BILL-ITEM-TIMESTMP    TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8400-INSERT-BILL-ADJSTMNT.                                     *        
      ******************************************************************        
       8400-INSERT-BILL-ADJSTMNT.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILL_ADJUSTMNT                           
                    (                                                   
                       ACCOUNT_NO                                       
                      ,BILL_NO                                          
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,BILL_ITEM_TIMESTMP                               
                      ,ADJ_TYPE_CD                                      
                      ,REVENUE_MONTH                                    
                      ,ADJ_REASON_DESC                                  
                      ,OVRRIDE_RT_REV_MTH                               
                      ,OVRRIDE_RT_BILL_DT                               
                      ,OVRRIDE_RT_BILL_CY                               
                      ,SPECIAL_PROCESS_CD                               
                    )                                                   
               VALUES                                                   
                    (                                                   
                       :BP-ACCOUNT-NO                                   
                      ,:BP-BILL-NO                                      
                      ,:BP-CODE-UTIL-TYPE                               
                      ,:BP-IC-NO                                        
                      ,CIS.CHAR2TIMESTAMP(:BP-BILL-ITEM-TIMESTMP)               
                      ,:BP-ADJ-TYPE-CD                                  
                      ,:BP-REVENUE-MONTH                                
                      ,:BP-ADJ-REASON-DESC                              
                      ,:BP-OVRRIDE-RT-REV-MTH                           
                      ,IIF(TRY_CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                             :NULL-OVRRIDE-RT-BILL-DT
              ) IS NULL OR (PATINDEX('%.%', :BP-OVRRIDE-RT-BILL-DT 
                                               :NULL-OVRRIDE-RT-BILL-DT
              ) <> 0) OR (LEN(:BP-OVRRIDE-RT-BILL-DT 
                                               :NULL-OVRRIDE-RT-BILL-DT
              ) <> 10), CIS.CHAR2DATE(:BP-OVRRIDE-RT-BILL-DT 
                                               :NULL-OVRRIDE-RT-BILL-DT
              ), CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                               :NULL-OVRRIDE-RT-BILL-DT
              ) )   
                      ,:BP-OVRRIDE-RT-BILL-CY                           
                      ,:BP-SPECIAL-PROCESS-CD                           
                    )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILL_ADJUSTMNT                                   
MFA-TR*             (                                                           
MFA-TR*                ACCOUNT_NO                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,ADJ_TYPE_CD                                              
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,ADJ_REASON_DESC                                          
MFA-TR*               ,OVRRIDE_RT_REV_MTH                                       
MFA-TR*               ,OVRRIDE_RT_BILL_DT                                       
MFA-TR*               ,OVRRIDE_RT_BILL_CY                                       
MFA-TR*               ,SPECIAL_PROCESS_CD                                       
MFA-TR*             )                                                           
MFA-TR*        VALUES                                                           
MFA-TR*             (                                                           
MFA-TR*                :BP-ACCOUNT-NO                                           
MFA-TR*               ,:BP-BILL-NO                                              
MFA-TR*               ,:BP-CODE-UTIL-TYPE                                       
MFA-TR*               ,:BP-IC-NO                                                
MFA-TR*               ,:BP-BILL-ITEM-TIMESTMP                                   
MFA-TR*               ,:BP-ADJ-TYPE-CD                                          
MFA-TR*               ,:BP-REVENUE-MONTH                                        
MFA-TR*               ,:BP-ADJ-REASON-DESC                                      
MFA-TR*               ,:BP-OVRRIDE-RT-REV-MTH                                   
MFA-TR*               ,:BP-OVRRIDE-RT-BILL-DT:NULL-OVRRIDE-RT-BILL-DT           
MFA-TR*               ,:BP-OVRRIDE-RT-BILL-CY                                   
MFA-TR*               ,:BP-SPECIAL-PROCESS-CD                                   
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_ADJUSTMNT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE BP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE BP-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'     TO TABLE-ELEMENT-4          
              MOVE BP-BILL-ITEM-TIMESTMP    TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8500-INSERT-MNT-TRANS-HDR.                                     *        
      ******************************************************************        
       8500-INSERT-MNT-TRANS-HDR.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 (                                                      
                   TRANS_HIST_SEQ_NO,      DATE_TRANS,                  
                   CODE_TRAN_TYPE,         RESP_AREA_ID,                
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,            PREMISE_NO,                  
                   USER_ID,                APPL_PROGRAM_ID,             
                   TRAN_COMMENT                                         
                 )                                                      
               VALUES                                                   
                 (                                                      
                   CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          (                                                              
MFA-TR*            TRANS_HIST_SEQ_NO,      DATE_TRANS,                          
MFA-TR*            CODE_TRAN_TYPE,         RESP_AREA_ID,                        
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,            PREMISE_NO,                          
MFA-TR*            USER_ID,                APPL_PROGRAM_ID,                     
MFA-TR*            TRAN_COMMENT                                                 
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,                       
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,                     
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,                       
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,                  
MFA-TR*            :MH-TRAN-COMMENT                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MNT_TRANS_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE MH-CUSTOMER-NO           TO HOSTVAR-ELEMENT-2        
              MOVE 'PREMISE-NO'             TO TABLE-ELEMENT-3          
              MOVE MH-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'DATE-TRANS'             TO TABLE-ELEMENT-4          
              MOVE MH-DATE-TRANS            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8600-INSERT-MNT-TRANS-DET.                                     *        
      ******************************************************************        
       8600-INSERT-MNT-TRANS-DET.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
                    (                                                   
                      TRANS_HIST_SEQ_NO,     TRAN_APPL_NO,              
                      COLUMN_DESC,           PRV_COLUMN_VALUE,          
                      CHG_COLUMN_VALUE,                                 
                      TABLE_ID                                          
                    )                                                   
               VALUES                                                   
                    (                                                   
                     CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                     :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,       
                     :MI-CHG-COLUMN-VALUE,                              
                     :MI-TABLE-ID                                       
                    )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*             (                                                           
MFA-TR*               TRANS_HIST_SEQ_NO,     TRAN_APPL_NO,                      
MFA-TR*               COLUMN_DESC,           PRV_COLUMN_VALUE,                  
MFA-TR*               CHG_COLUMN_VALUE,                                         
MFA-TR*               TABLE_ID                                                  
MFA-TR*             )                                                           
MFA-TR*        VALUES                                                           
MFA-TR*             (                                                           
MFA-TR*              :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,                   
MFA-TR*              :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,               
MFA-TR*              :MI-CHG-COLUMN-VALUE,                                      
MFA-TR*              :MI-TABLE-ID                                               
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MT_TRN_HST_DET'     TO TABLE-1                  
              MOVE 'TRANS-HIST-SEQ-NO'      TO TABLE-ELEMENT-1          
              MOVE MI-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-1        
              MOVE 'TRAN-APPL-NO'           TO TABLE-ELEMENT-2          
              MOVE MI-TRAN-APPL-NO          TO HOSTVAR-ELEMENT-2        
              MOVE 'COLUMN-DESC'            TO TABLE-ELEMENT-3          
              MOVE MI-COLUMN-DESC           TO HOSTVAR-ELEMENT-3        
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-4          
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
