       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04865.                                      
       AUTHOR.           HA7A338.                                       
COB303 DATE-WRITTEN.     MAY 28,2015.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                    SOUTH CAROLINA ELECTRIC & GAS               *        
      ******************************************************************        
      *                     STORED PROCEDURE:  CSR04865                *        
      ******************************************************************        
      *                           S U M M A R Y                        *        
      *    CSR04865 :                                                  *        
      *                                                                *        
      *    # UPDATE AUTO RENEWAL FLAG FOR SEB ACCOUNTS WHEN THEY OPT-IN*        
      *      OR OPT OUT OF AUTO RENEWAL OPTION.                        *        
      ******************************************************************        
      *                                                                *        
      *    PARAMETERS DETAIL                                           *        
      *                                                                *        
      *        INPUT                                                   *        
      *              I_ACCOUNT_NO        DECIMAL(13,0)                 *        
      *              I_AUTO_RNWL_FLG     CHAR(01)                      *        
      *              I_USER-ID           CHAR(07)                      *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *               RETURN_CODE          INTEGER                     *        
      *               BUS_RULE_ID          CHAR(10)                    *        
      *               BUS_RULE_RESULT_CD   CHAR(08)                    *        
      *               BUS_RULE_XREF_ID     CHAR(26)                    *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                          MODIFICATION LOG                      *        
      *                                                                *        
      *    DATE          INITIALS    COMMENTS                          *        
      *    -----------   --------    ----------------------------------*        
P00892*    05-28-2015    HA7A338     UPDATE AUTO RENEWAL FLAG FOR WEB  *        
      *                              ACCOUNTS                          *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04865'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR CSR04865 STARTS HERE'.                  
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                PIC X(05) VALUE SPACES.        
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05 WS-AUTO-RNWL-FLG           PIC X(01) VALUE SPACES.        
           05 WS-USER-ID                 PIC X(07) VALUE SPACES.        
           05 WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.        
                                                                        
       01 WS-SWITCHES.                                                  
           05 ALL-DONE-SW                PIC X(01) VALUE 'N'.           
              88 NOT-ALL-DONE                VALUE 'N'.                 
              88 ALL-DONE                    VALUE 'Y'.                 
           05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR             VALUE 'N'.                 
              88 SEND-DONE-OK                VALUE 'Y'.                 
           05 AUTO-RNWL-OPTN             PIC X(01) VALUE ' '.           
              88 OPT-IN                      VALUE 'I'.                 
              88 OPT-OUT                     VALUE 'O'.                 
                                                                        
       01 COUNTER-FIELDS.                                               
           05 CTR-ROWS                   PIC S9(9) COMP VALUE 0.        
                                                                        
       01 WS-LITERALS.                                                  
           05 GTT-NAME                   PIC X(26) VALUE                
                                              'SESSION.CSR04865_R1'.    
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04865'.    
           05 WS-ZERO                    PIC 9(01) VALUE 0.             
           05 WS-ONE                     PIC 9(01) VALUE 1.             
           05 WS-SPACE                   PIC X(01) VALUE ' '.           
           05 WS-ACTIVE                  PIC X(01) VALUE 'A'.           
           05 WS-OPTIN-ATTR-VAL-CD       PIC X(01) VALUE 'I'.           
           05 WS-OPTIN-ATTR-DESC         PIC X(08) VALUE 'OPTED IN'.    
           05 WS-OPTOUT-ATTR-VAL-CD      PIC X(05) VALUE 'RENJR'.       
           05 WS-OPTOUT-ATTR-DESC        PIC X(14) VALUE                
                                              'AUTORENEW_REJE'.         
           05 WS-OPTOUT-ATTR-VALUE-TX    PIC X(09) VALUE 'OPTED OUT'.   
           05 WS-COMMENT                 PIC X(31) VALUE                
                                  'UPDATE AUTO RENEWAL ENROLLMENT.'.    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-BUS-RULE-ID             PIC X(10)  VALUE SPACE.        
           05  S-BUS-RULE-RESULT-CD      PIC X(08)  VALUE SPACE.        
           05  S-BUS-RULE-XREF-ID        PIC X(26)  VALUE SPACE.        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_USER_PROFILE,PF                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01540000
      * CSS_ACCT_RTPK_AGR, DF                                         * 01550000
      ***************************************************************** 01560000
           EXEC SQL                                                     01570000
              INCLUDE TBACCTRG                                          01580000
           END-EXEC.                                                    01590000
                                                                        
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT   UT                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ACCT_ATTRIBUTE YP                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_BUS_RULE_XREF, 1T                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01610000
      * CSS_BUS_RULE_ACTN, 1S                                         * 01620000
      ***************************************************************** 01630000
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
       01  PARM-AUTO-RNWL-FLG            PIC X(01).                     
       01  PARM-USER-ID                  PIC X(07).                     
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-AUTO-RNWL-FLG                     
                                 PARM-USER-ID.                          
                                                                        
      *****************************************************************         
      * 0000-MAINLINE.                                                *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE.                                              *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT.          
           PERFORM 7010-GET-RESP-AREA-ID       THRU 7010-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100A-DECLARE-GTT.                                            *         
      *****************************************************************         
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04865_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04865_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BUS_RULE_ID                                      
                      ,BUS_RULE_RESULT_CD                               
                      ,BUS_RULE_XREF_ID                                 
                  FROM #CSR04865_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BUS_RULE_ID                                              
MFA-TR*               ,BUS_RULE_RESULT_CD                                       
MFA-TR*               ,BUS_RULE_XREF_ID                                         
MFA-TR*           FROM SESSION.CSR04865_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                            *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO            
                                               DF-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               YP-ACCOUNT-NO            
                                               MH-ACCOUNT-NO.           
           MOVE PARM-AUTO-RNWL-FLG          TO AUTO-RNWL-OPTN           
                                               WS-AUTO-RNWL-FLG.        
           MOVE PARM-USER-ID                TO WS-USER-ID               
                                               DF-LAST-UPDATE-USERID.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                          *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-UPDT-AUTO-RNWL-FLG     THRU 2100-EXIT.          
           PERFORM 2200-INSERT-TRANS-HIST      THRU 2200-EXIT.          
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100-UPDT-AUTO-RNWL-FLG.                                      *         
      *****************************************************************         
       2100-UPDT-AUTO-RNWL-FLG.                                         
                                                                        
           PERFORM 7020-GET-ACCT-OPT-SEQ       THRU 7020-EXIT.          
           PERFORM 8200-UPDATE-ACCT-RTPK-AGR   THRU 8200-EXIT.          
           PERFORM 2150-UPDATE-ACCT-ATTRIBUTE  THRU 2150-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-UPDATE-ACCT-ATTRIBUTE                                     *        
      ******************************************************************        
       2150-UPDATE-ACCT-ATTRIBUTE.                                      
                                                                        
           MOVE WS-SPACE                   TO YP-ATTRIBUTE-VALUE-TX-TEXT
           MOVE WS-ZERO                     TO YP-ATTRIBUTE-VALUE-TX-LEN
           MOVE WS-ACTIVE                   TO YP-STATUS-CD.            
                                                                        
           EVALUATE TRUE                                                
              WHEN OPT-IN                                               
                 MOVE WS-OPTOUT-ATTR-DESC   TO YP-ATTRIBUTE-DESC        
                 PERFORM 8050-DELETE-ACCT-ATTR THRU 8050-EXIT           
                 MOVE WS-OPTIN-ATTR-DESC    TO YP-ATTRIBUTE-DESC        
                 MOVE WS-OPTIN-ATTR-VAL-CD  TO YP-ATTRIBUTE-VALUE-CD    
                 PERFORM 8150-INSERT-ACCT-ATTR THRU 8150-EXIT           
              WHEN OPT-OUT                                              
                 MOVE WS-OPTIN-ATTR-DESC    TO YP-ATTRIBUTE-DESC        
                 PERFORM 8050-DELETE-ACCT-ATTR THRU 8050-EXIT           
                 MOVE WS-OPTOUT-ATTR-DESC   TO YP-ATTRIBUTE-DESC        
                 MOVE WS-OPTOUT-ATTR-VAL-CD TO YP-ATTRIBUTE-VALUE-CD    
                 MOVE 9                     TO YP-ATTRIBUTE-VALUE-TX-LEN
                 MOVE WS-OPTOUT-ATTR-VALUE-TX                           
                                           TO YP-ATTRIBUTE-VALUE-TX-TEXT
                 PERFORM 8150-INSERT-ACCT-ATTR THRU 8150-EXIT           
                 IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS              
                    PERFORM 8250-UPDATE-ACCT-ATTR                       
                                               THRU 8250-EXIT           
                 END-IF                                                 
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
       2150-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 2200-INSERT-TRANS-HIST.                                       *         
      *****************************************************************         
       2200-INSERT-TRANS-HIST.                                          
                                                                        
           PERFORM 5000-WRITE-TRNS-HIST        THRU 5000-EXIT.          
           PERFORM 5010-WRITE-TRNS-HIST-DTL    THRU 5010-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5000-WRITE-TRNS-HIST.                                         *         
      *****************************************************************         
       5000-WRITE-TRNS-HIST.                                            
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ZERO                     TO MH-CUSTOMER-NO           
                                               MH-PREMISE-NO.           
           MOVE WS-USER-ID                  TO MH-USER-ID.              
           MOVE PROGRAM-NAME                TO MH-APPL-PROGRAM-ID.      
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT.    
           MOVE LENGTH OF WS-COMMENT        TO MH-TRAN-COMMENT-LEN.     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-ONE                      TO MI-TRAN-APPL-NO.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5010-WRITE-TRNS-HIST-DTL.                                     *         
      *****************************************************************         
       5010-WRITE-TRNS-HIST-DTL.                                        
                                                                        
      *    WRITE A TRANSACTION HISTORY DETAIL ROW                               
           IF DF-AUTO-REN-OPT-IN-FL NOT EQUAL WS-AUTO-RNWL-FLG          
              MOVE +01                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE DF-AUTO-REN-OPT-IN-FL    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-AUTO-RNWL-FLG         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'DF'                     TO MI-TABLE-ID              
              MOVE 'AUTO_REN_OPT_IN_FL'     TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * 7000-GET-CURRENT-DATE.                                       *          
      ****************************************************************          
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-1          
              MOVE MH-DATE-TRANS            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7010-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE USER_ID = :PARM-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE USER_ID = :PARM-USER-ID                                   
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE PARM-USER-ID             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7020-GET-ACCT-OPT-SEQ.                                       *          
      ****************************************************************          
       7020-GET-ACCT-OPT-SEQ.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DF.CODE_UTIL_TYPE                                  
                    ,DF.IC_NO                                           
                    ,DF.RT_PKG_OPT_SEQ_NO                               
                    ,DF.AUTO_REN_OPT_IN_FL                              
                INTO :DF-CODE-UTIL-TYPE                                 
                    ,:DF-IC-NO                                          
                    ,:DF-RT-PKG-OPT-SEQ-NO                              
                    ,:DF-AUTO-REN-OPT-IN-FL                             
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
                    ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                
               WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO            
                 AND DF.ACCOUNT_NO          = UT.ACCOUNT_NO             
                 AND DF.CODE_UTIL_TYPE      = UT.CODE_UTIL_TYPE         
                 AND DF.IC_NO               = UT.IC_NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO   = UT.RT_PKG_OPT_SEQ_NO      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DF.CODE_UTIL_TYPE                                          
MFA-TR*             ,DF.IC_NO                                                   
MFA-TR*             ,DF.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,DF.AUTO_REN_OPT_IN_FL                                      
MFA-TR*         INTO :DF-CODE-UTIL-TYPE                                         
MFA-TR*             ,:DF-IC-NO                                                  
MFA-TR*             ,:DF-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:DF-AUTO-REN-OPT-IN-FL                                     
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*             ,CSS_ACCT_RTPK_AGR  DF                                      
MFA-TR*        WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                    
MFA-TR*          AND DF.ACCOUNT_NO          = UT.ACCOUNT_NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE      = UT.CODE_UTIL_TYPE                 
MFA-TR*          AND DF.IC_NO               = UT.IC_NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO   = UT.RT_PKG_OPT_SEQ_NO              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8000A-DEL-GTT-ROWS.                                          *          
      ****************************************************************          
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04865_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04865_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04865_R1'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8050-DELETE-ACCT-ATTR.                                        *         
      *****************************************************************         
       8050-DELETE-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_ATTRIBUTE                           
                WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-SEND-RESULT.                                             *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04865_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04865_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04865_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8150-INSERT-ACCT-ATTR.                                        *         
      *****************************************************************         
       8150-INSERT-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                        ( ACCOUNT_NO                                    
                         ,ATTRIBUTE_DESC                                
                         ,ATTRIBUTE_VALUE_CD                            
                         ,ATTRIBUTE_VALUE_DT                            
                         ,ATTRIBUTE_VALUE_TX                            
                         ,CREATED_TS                                    
                         ,STATUS_CD                                     
                        )                                               
              VALUES                                                    
                        ( :YP-ACCOUNT-NO                                
                         ,:YP-ATTRIBUTE-DESC                            
                         ,:YP-ATTRIBUTE-VALUE-CD                        
                         , CAST(SYSDATETIMEOFFSET() AS DATE)                    
                         ,:YP-ATTRIBUTE-VALUE-TX                        
                         , CIS.CURRENT$TIMESTAMP()                            
                         ,:YP-STATUS-CD                                 
                        )                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*                 ( ACCOUNT_NO                                            
MFA-TR*                  ,ATTRIBUTE_DESC                                        
MFA-TR*                  ,ATTRIBUTE_VALUE_CD                                    
MFA-TR*                  ,ATTRIBUTE_VALUE_DT                                    
MFA-TR*                  ,ATTRIBUTE_VALUE_TX                                    
MFA-TR*                  ,CREATED_TS                                            
MFA-TR*                  ,STATUS_CD                                             
MFA-TR*                 )                                                       
MFA-TR*       VALUES                                                            
MFA-TR*                 ( :YP-ACCOUNT-NO                                        
MFA-TR*                  ,:YP-ATTRIBUTE-DESC                                    
MFA-TR*                  ,:YP-ATTRIBUTE-VALUE-CD                                
MFA-TR*                  , CURRENT DATE                                         
MFA-TR*                  ,:YP-ATTRIBUTE-VALUE-TX                                
MFA-TR*                  , CURRENT TIMESTAMP                                    
MFA-TR*                  ,:YP-STATUS-CD                                         
MFA-TR*                 )                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8150'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO  TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
              MOVE YP-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8200-UPDATE-ACCT-RTPK-AGR.                                   *          
      ****************************************************************          
       8200-UPDATE-ACCT-RTPK-AGR.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE  DF                                
                SET  AUTO_REN_OPT_IN_FL = :WS-AUTO-RNWL-FLG             
                    ,LAST_UPDATE_USERID = :DF-LAST-UPDATE-USERID        
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
             FROM CSS_ACCT_RTPK_AGR DF
              WHERE ACCOUNT_NO          = :DF-ACCOUNT-NO                
                AND CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE            
                AND IC_NO               = :DF-IC-NO                     
                AND RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*         SET  AUTO_REN_OPT_IN_FL = :WS-AUTO-RNWL-FLG                     
MFA-TR*             ,LAST_UPDATE_USERID = :DF-LAST-UPDATE-USERID                
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*       WHERE ACCOUNT_NO          = :DF-ACCOUNT-NO                        
MFA-TR*         AND CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE                    
MFA-TR*         AND IC_NO               = :DF-IC-NO                             
MFA-TR*         AND RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8250-UPDATE-ACCT-ATTR.                                       *          
      ****************************************************************          
       8250-UPDATE-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
             UPDATE  CSS_ACCT_ATTRIBUTE                                 
                SET  ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX        
                    ,ATTRIBUTE_VALUE_DT = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
              WHERE ACCOUNT_NO          = :YP-ACCOUNT-NO                
                AND ATTRIBUTE_DESC      = :YP-ATTRIBUTE-DESC            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_ACCT_ATTRIBUTE                                         
MFA-TR*         SET  ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX                
MFA-TR*             ,ATTRIBUTE_VALUE_DT = CURRENT DATE                          
MFA-TR*       WHERE ACCOUNT_NO          = :YP-ACCOUNT-NO                        
MFA-TR*         AND ATTRIBUTE_DESC      = :YP-ATTRIBUTE-DESC                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'ATTRIBUTE_DESC'         TO TABLE-ELEMENT-2          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE YP-ATTRIBUTE-DESC        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                    *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * END PROGRAM COPYLIB                                           *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
