       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04864.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  APR 15, 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE WILL INSERT/UPDATE PHYSICIAN NAME AND ADDRESS  *        
      *  DETAILS INTO CSS_NAME/CSS/ADDR_FORMATTED/CSS_ADDR_FREEFORM    *        
      *  TABLES.                                                                
      *                                                                *        
      *  #  INVOKED FROM ADD PROVIDER SCREEN                           *        
      *                                                                *        
      *  #  BUSOP NAME: REQUUPDPHYSICIANDETAILSBUSINESSOP              *        
      *                                                                *        
      *  #  PARAMETERS                                                 *        
      *     IN                                                         *        
      *         UPDATE_FLAG              CHAR(01)                      *        
      *         PHYSICIAN_ID             INTEGER                       *        
      *         SEL_FORMAT_TYPE          CHAR(01)                      *        
      *         TITLE_PREFIX             CHAR(09)                      *        
      *         FIRST_NAME               CHAR(15)                      *        
      *         MIDDLE_NAME              CHAR(15)                      *        
      *         LAST_NAME                CHAR(40)                      *        
      *         TITLE_SUFFIX_1           CHAR(03)                      *        
      *         LICENSE_STATE            CHAR(02)                      *        
      *         LICENSE_NUMBER           CHAR(09)                      *        
      *         FMT_HOUSE_NO             CHAR(15)                      *        
      *         FMT_ADDR_PREFIX_1        CHAR(03)                      *        
      *         FMT_ADDR_PREFIX_2        CHAR(02)                      *        
      *         FMT_STREET_NAME          CHAR(30)                      *        
      *         FMT_STREET_SUFFIX        CHAR(04)                      *        
      *         FMT_ADDR_SUFFIX          CHAR(02)                      *        
      *         FMT_STREET_LOCATION_1    CHAR(04)                      *        
      *         FMT_STREET_LOCATION_2    CHAR(11)                      *        
      *         FF_ADDR_STREET           CHAR(55)                      *        
      *         FF_ADDRESS_OVERFLOW      CHAR(35)                      *        
      *         CITY                     CHAR(26)                      *        
      *         STATE                    CHAR(02)                      *        
      *         ZIP_CODE                 CHAR(05)                      *        
      *         ZIP_CODE_PLUS_FOUR       CHAR(04)                      *        
      *         FF_ADDRESS_CITY_STATE    CHAR(30)                      *        
      *     OUT                                                        *        
      *         RETURN_CODE              INTEGER                       *        
      *         APPL_RETURN_CODE         CHAR(10)                      *        
      *         PHYSICIAN_ID             INTEGER                       *        
      *         ADDRESS_ID               DECIMAL(13, 0)                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  06/09/15  AA97148    INITIAL IMPLEMENTATION.                  *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04864'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02261 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04864'.  
           05  WS-PGRMNAME                PIC X(08)  VALUE 'CSR04864'.  
           05  WS-PHY-TITLE-PREFIX        PIC X(09)  VALUE SPACES.      
           05  WS-PHY-FIRST-NAME          PIC X(15)  VALUE SPACES.      
           05  WS-PHY-MIDDLE-NAME         PIC X(15)  VALUE SPACES.      
           05  WS-PHY-LAST-NAME           PIC X(40)  VALUE SPACES.      
           05  WS-PHY-TITLE-SUFFIX-1      PIC X(03)  VALUE SPACES.      
           05  WS-LICENSE-STATE-CD        PIC X(02)  VALUE SPACES.      
           05  WS-LICENSE-NUMBER          PIC X(09)  VALUE SPACES.      
           05  WS-LICENSE-NO-EXISTS       PIC X(01)  VALUE SPACES.      
           05  SEND-DONE-SW               PIC X(01)  VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  RS-RETURN-CODE             PIC S9(9)  COMP VALUE 0.      
       01  WS-PHY-ADDRESS.                                              
           05  WS-FMT-HOUSE-NO            PIC X(15)  VALUE SPACES.      
           05  WS-FMT-ADDR-PREFIX-1       PIC X(03)  VALUE SPACES.      
           05  WS-FMT-ADDR-PREFIX-2       PIC X(02)  VALUE SPACES.      
           05  WS-FMT-STREET-NAME         PIC X(30)  VALUE SPACES.      
           05  WS-FMT-STREET-SUFFIX       PIC X(04)  VALUE SPACES.      
           05  WS-FMT-ADDR-SUFFIX         PIC X(02)  VALUE SPACES.      
           05  WS-FMT-STREET-LOCATION-1   PIC X(04)  VALUE SPACES.      
           05  WS-FMT-STREET-LOCATION-2   PIC X(11)  VALUE SPACES.      
           05  WS-FF-ADDR-STREET          PIC X(55)  VALUE SPACES.      
           05  WS-FF-ADDRESS-OVERFLOW     PIC X(35)  VALUE SPACES.      
           05  WS-FF-ADDRESS-CITY-STATE   PIC X(30)  VALUE SPACES.      
           05  WS-CITY                    PIC X(26)  VALUE SPACES.      
           05  WS-STATE                   PIC X(02)  VALUE SPACES.      
           05  WS-ZIP-CODE                PIC X(05)  VALUE SPACES.      
           05  WS-ZIP-CODE-PLUS-FOUR      PIC X(04)  VALUE SPACES.      
           05  WS-PHYSICIAN-ID            PIC S9(9)  USAGE COMP VALUE 0.
           05  WS-SEL-FORMAT-TYPE         PIC X(01)  VALUE SPACES.      
           05  WS-UPDATE-FLAG             PIC X(01)  VALUE SPACES.      
           05  WS-ADDR-ZIP-CODE           PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-TRAN-APPL-NO            PIC S9(04) COMP VALUE 0.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                   PIC S9(9)  COMP VALUE 0.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE           PIC S9(9)  COMP VALUE 0.      
               10 S-APPL-RETURN-CODE      PIC X(10)  VALUE SPACES.      
               10 S-PHYSICIAN-ID          PIC S9(9)  USAGE COMP VALUE 0.
               10 S-ADDRESS-ID            PIC S9(13)V USAGE COMP-3      
                                                     VALUE 0.           
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                  PIC X(18)  VALUE SPACES.      
           05  S-SQLCODE                  PIC S9(9)  COMP  VALUE 0.     
           05  S-SQLSTATE                 PIC X(5)   VALUE ' '.         
           05  S-TABLE-NAME               PIC X(18)  VALUE SPACES.      
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4)  USAGE COMP.        
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4)  USAGE COMP.        
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4)  USAGE COMP.        
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L    PIC S9(4)  USAGE COMP.        
               49  WS-ABEND-SQLERRMC-V    PIC X(255).                   
           05  WS-SQLSTATE                PIC X(05)  VALUE SPACES.      
           05  WS-GTT-NAME                PIC X(19)  VALUE SPACES.      
                                                                        
      ******************************************************************00880000
      *    DB2 INCLUDES                                                *00890000
      ******************************************************************00900000
                                                                        
           EXEC SQL                                                     00920000
              INCLUDE SQLCA                                             00930000
           END-EXEC.                                                    00940000
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM  - DZ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_NAME_ID_CNTL   - I7                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_ID_CNTL   - I8                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CUST_ALERT     - CA                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01230000
              INCLUDE TBCSTALT                                          01240000
           END-EXEC.                                                    01250000
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01290000
              INCLUDE TBACCT                                            01300000
           END-EXEC.                                                    01310000
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN      - PY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPHYSN                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN_ATTR - PA                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPHYADD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_NAME           - DQ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE       - A4                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00289904
      * ERROR HANDLING.                                               *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *01480000
      ******************************************************************        
                                                                        
           COPY CWS00303.                                               01490000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPDKR362                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWSKR362                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00071                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00091A                                        
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS0091A                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD0090A                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWS0090A                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00091                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00091                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00004                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00011                                                  
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-UPDATE-FLAG            PIC X(01) VALUE SPACES.          
       01  PARM-PHYSICIAN-ID           PIC S9(9) COMP VALUE 0.          
       01  PARM-SEL-FORMAT-TYPE        PIC X(01) VALUE SPACES.          
       01  PARM-PHY-TITLE-PREFIX       PIC X(09) VALUE SPACES.          
       01  PARM-PHY-FIRST-NAME         PIC X(15) VALUE SPACES.          
       01  PARM-PHY-MIDDLE-NAME        PIC X(15) VALUE SPACES.          
       01  PARM-PHY-LAST-NAME          PIC X(40) VALUE SPACES.          
       01  PARM-PHY-TITLE-SUFFIX-1     PIC X(03) VALUE SPACES.          
       01  PARM-LICENSE-STATE-CD       PIC X(02) VALUE SPACES.          
       01  PARM-LICENSE-NUMBER         PIC X(09) VALUE SPACES.          
       01  PARM-FMT-HOUSE-NO           PIC X(15) VALUE SPACES.          
       01  PARM-FMT-ADDR-PREFIX-1      PIC X(03) VALUE SPACES.          
       01  PARM-FMT-ADDR-PREFIX-2      PIC X(02) VALUE SPACES.          
       01  PARM-FMT-STREET-NAME        PIC X(30) VALUE SPACES.          
       01  PARM-FMT-STREET-SUFFIX      PIC X(04) VALUE SPACES.          
       01  PARM-FMT-ADDR-SUFFIX        PIC X(02) VALUE SPACES.          
       01  PARM-FMT-STREET-LOCATION-1  PIC X(04) VALUE SPACES.          
       01  PARM-FMT-STREET-LOCATION-2  PIC X(11) VALUE SPACES.          
       01  PARM-FF-ADDR-STREET         PIC X(55) VALUE SPACES.          
       01  PARM-FF-ADDRESS-OVERFLOW    PIC X(35) VALUE SPACES.          
       01  PARM-CITY                   PIC X(26) VALUE SPACES.          
       01  PARM-STATE                  PIC X(02) VALUE SPACES.          
       01  PARM-ZIP-CODE               PIC X(05) VALUE SPACES.          
       01  PARM-ZIP-CODE-PLUS-FOUR     PIC X(04) VALUE SPACES.          
       01  PARM-FF-ADDRESS-CITY-STATE  PIC X(30) VALUE SPACES.          
                                                                        
       PROCEDURE DIVISION USING        PARM-UPDATE-FLAG                 
                                       PARM-PHYSICIAN-ID                
                                       PARM-SEL-FORMAT-TYPE             
                                       PARM-PHY-TITLE-PREFIX            
                                       PARM-PHY-FIRST-NAME              
                                       PARM-PHY-MIDDLE-NAME             
                                       PARM-PHY-LAST-NAME               
                                       PARM-PHY-TITLE-SUFFIX-1          
                                       PARM-LICENSE-STATE-CD            
                                       PARM-LICENSE-NUMBER              
                                       PARM-FMT-HOUSE-NO                
                                       PARM-FMT-ADDR-PREFIX-1           
                                       PARM-FMT-ADDR-PREFIX-2           
                                       PARM-FMT-STREET-NAME             
                                       PARM-FMT-STREET-SUFFIX           
                                       PARM-FMT-ADDR-SUFFIX             
                                       PARM-FMT-STREET-LOCATION-1       
                                       PARM-FMT-STREET-LOCATION-2       
                                       PARM-FF-ADDR-STREET              
                                       PARM-FF-ADDRESS-OVERFLOW         
                                       PARM-CITY                        
                                       PARM-STATE                       
                                       PARM-ZIP-CODE                    
                                       PARM-ZIP-CODE-PLUS-FOUR          
                                       PARM-FF-ADDRESS-CITY-STATE.      
                                                                        
      ******************************************************************03050000
      * 0000-MAINLINE                                                  *03060000
      ******************************************************************03130000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03250000
      * 0100-INITIALIZE                                                *03260000
      ******************************************************************03370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           INITIALIZE WS-PHY-ADDRESS                                    
                      DCLCSS-ADDR-FORMATTED                             
                      DCLCSS-ADDR-FREEFORM                              
                      GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE      AS RETURN_CODE                   
                  ,:S-APPL-RETURN-CODE AS APPL_RETURN_CODE              
                  ,:S-PHYSICIAN-ID     AS PHYSICIAN_ID                  
                  ,:S-ADDRESS-ID       AS ADDRESS_ID                    
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE      AS RETURN_CODE                           
MFA-TR*           ,:S-APPL-RETURN-CODE AS APPL_RETURN_CODE                      
MFA-TR*           ,:S-PHYSICIAN-ID     AS PHYSICIAN_ID                          
MFA-TR*           ,:S-ADDRESS-ID       AS ADDRESS_ID                            
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03660000
      * 1000-PROCESS-INPUT                                             *03670000
      *                                                                *03690000
      *     CALLED FROM 0000-MAINLINE                                  *03700000
      *                                                                *03710000
      *     1. RECEIVE PARMS.                                          *03720000
      ******************************************************************03730000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-UPDATE-FLAG           TO WS-UPDATE-FLAG            
                                              WS-KR362-UPDATE-FLAG.     
           MOVE PARM-PHYSICIAN-ID          TO WS-PHYSICIAN-ID           
                                              WS-KR362-NAME-ID.         
           MOVE PARM-SEL-FORMAT-TYPE       TO WS-SEL-FORMAT-TYPE.       
           MOVE PARM-PHY-TITLE-PREFIX      TO WS-PHY-TITLE-PREFIX       
                                              WS-KR362-TITLE-PREFIX.    
           MOVE PARM-PHY-FIRST-NAME        TO WS-PHY-FIRST-NAME         
                                              WS-KR362-FIRST-NAME.      
           MOVE PARM-PHY-MIDDLE-NAME       TO WS-PHY-MIDDLE-NAME        
                                              WS-KR362-MIDDLE-NAME.     
           MOVE PARM-PHY-LAST-NAME         TO WS-PHY-LAST-NAME          
                                              WS-KR362-LAST-NAME.       
           MOVE PARM-PHY-TITLE-SUFFIX-1    TO WS-PHY-TITLE-SUFFIX-1     
                                              WS-KR362-TITLE-SUFFIX-1.  
           MOVE PARM-LICENSE-STATE-CD      TO WS-LICENSE-STATE-CD.      
           MOVE PARM-LICENSE-NUMBER        TO WS-LICENSE-NUMBER.        
           MOVE PARM-FMT-HOUSE-NO          TO WS-FMT-HOUSE-NO.          
           MOVE PARM-FMT-ADDR-PREFIX-1     TO WS-FMT-ADDR-PREFIX-1.     
           MOVE PARM-FMT-ADDR-PREFIX-2     TO WS-FMT-ADDR-PREFIX-2.     
           MOVE PARM-FMT-STREET-NAME       TO WS-FMT-STREET-NAME.       
           MOVE PARM-FMT-STREET-SUFFIX     TO WS-FMT-STREET-SUFFIX.     
           MOVE PARM-FMT-ADDR-SUFFIX       TO WS-FMT-ADDR-SUFFIX.       
           MOVE PARM-FMT-STREET-LOCATION-1 TO WS-FMT-STREET-LOCATION-1. 
           MOVE PARM-FMT-STREET-LOCATION-2 TO WS-FMT-STREET-LOCATION-2. 
           MOVE PARM-FF-ADDR-STREET        TO WS-FF-ADDR-STREET.        
           MOVE PARM-FF-ADDRESS-OVERFLOW   TO WS-FF-ADDRESS-OVERFLOW.   
           MOVE PARM-CITY                  TO WS-CITY.                  
           MOVE PARM-STATE                 TO WS-STATE.                 
           MOVE PARM-ZIP-CODE              TO WS-ZIP-CODE.              
           MOVE PARM-ZIP-CODE-PLUS-FOUR    TO WS-ZIP-CODE-PLUS-FOUR.    
           MOVE PARM-FF-ADDRESS-CITY-STATE To WS-FF-ADDRESS-CITY-STATE. 
           MOVE 'PY'                       TO WS-KR362-NAME-TYPE.       
           MOVE 'I'                        TO WS-KR362-NAME-FORMAT.     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08230000
      * 2000-PROCESS-OUTPUT.                                           *08240000
      ******************************************************************08340000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-UPDATE-FLAG = 'I'                                      
              MOVE 'N'                     TO WS-LICENSE-NO-EXISTS      
              PERFORM 7050-CHECK-LICENSE-NO-EXISTS THRU 7050-EXIT       
              IF WS-LICENSE-NO-EXISTS = 'Y'                             
                 MOVE 0                    TO S-RETURN-CODE             
                 MOVE 'MEDCERT027'         TO S-APPL-RETURN-CODE        
                 ADD 1                     TO CTR-ROWS                  
                 GO TO 2000-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-PHYSICIAN-ID         TO S-PHYSICIAN-ID            
                                              PY-PHYSICIAN-ID           
              PERFORM 7040-SEL-PHY-ATTR-DETAILS    THRU 7040-EXIT       
              MOVE PA-ADDRESS-ID           TO S-ADDRESS-ID              
              MOVE PY-NAME-ID              TO WS-KR362-NAME-ID          
      *       Move format type 'A' to legacy created Physicians                 
              IF PA-ADDRESS-FORMAT > SPACES                             
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'A'                  TO PA-ADDRESS-FORMAT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7020-GET-TIMESTAMP              THRU 7020-EXIT.      
           PERFORM 5100-NAME-PROCESS               THRU 5100-KR362-EXIT.
           PERFORM 2100-ADDRESS-PROCESS            THRU 2100-EXIT.      
                                                                        
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    5100-NAME-PROCESS                                                    
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CPDKR362                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************        
      * 2100-ADDRESS-PROCESS                                           *        
      ******************************************************************        
                                                                        
       2100-ADDRESS-PROCESS.                                            
                                                                        
           EVALUATE WS-UPDATE-FLAG                                      
            WHEN 'I'                                                    
      *          Add new Physician address to the table                         
                 PERFORM 6202-GET-NEW-ADDRESS-ID         THRU 6202-EXIT 
                 IF WS-SEL-FORMAT-TYPE = 'A'                            
                    PERFORM 2110-MOVE-FMT-ADDR-FLDS-NEW  THRU 2110-EXIT 
                    PERFORM 8030-INSERT-FMT-ADDRESS      THRU 8030-EXIT 
                 ELSE                                                   
                    PERFORM 2120-MOVE-FF-ADDR-FLDS-NEW   THRU 2120-EXIT 
                    PERFORM 8040-INSERT-FF-ADDRESS       THRU 8040-EXIT 
                 END-IF                                                 
                 PERFORM 2300-INSERT-PHY-ATTR-DTLS       THRU 2300-EXIT 
                 MOVE PA-ADDRESS-ID        TO S-ADDRESS-ID              
            WHEN 'U'                                                    
      *          Update existing Physician address to the table                 
                 IF PA-ADDRESS-FORMAT = 'A'                             
                    MOVE PA-ADDRESS-ID     TO DY-ADDRESS-ID             
                    PERFORM 2130-MOVE-FMT-ADDR-FLDS-OLD  THRU 2130-EXIT 
                    PERFORM 8510-UPDATE-FMT-ADDRESS      THRU 8510-EXIT 
                 ELSE                                                   
                    MOVE PA-ADDRESS-ID     TO DZ-ADDRESS-ID             
                    PERFORM 2140-MOVE-FF-ADDR-FLDS-OLD   THRU 2140-EXIT 
                    PERFORM 8520-UPDATE-FF-ADDRESS       THRU 8520-EXIT 
                 END-IF                                                 
                 MOVE WS-LICENSE-NUMBER    TO PY-MED-LICENSE-NO         
                 MOVE WS-LICENSE-STATE-CD  TO PY-MED-LIC-STATE-CD       
                 PERFORM 8530-UPDATE-PHY-DETAILS         THRU 8530-EXIT 
           END-EVALUATE.                                                
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-MOVE-FMT-ADDR-FLDS-NEW                                    *        
      ******************************************************************        
                                                                        
       2110-MOVE-FMT-ADDR-FLDS-NEW.                                     
                                                                        
           MOVE WS-CITY                      TO A4-TOWN.                
           MOVE WS-STATE                     TO A4-STATE.               
           MOVE WS-ZIP-CODE                  TO A4-ZIP-CODE.            
           PERFORM 7030-GET-TOKEN            THRU 7030-EXIT.            
                                                                        
           MOVE WS-90-NEW-ADDRESS-ID         TO DY-ADDRESS-ID           
                                                PA-ADDRESS-ID.          
           MOVE WS-FMT-HOUSE-NO              TO DY-HOUSE-NO.            
           MOVE WS-FMT-ADDR-PREFIX-1         TO DY-ADDR-PREFIX-1.       
           MOVE WS-FMT-ADDR-PREFIX-2         TO DY-ADDR-PREFIX-2.       
           MOVE WS-FMT-STREET-NAME           TO DY-STREET-NAME.         
           MOVE WS-FMT-STREET-LOCATION-1     TO DY-STREET-LOCATION-1.   
           MOVE WS-FMT-STREET-LOCATION-2     TO DY-STREET-LOCATION-2    
           MOVE WS-FMT-STREET-SUFFIX         TO DY-STREET-SUFFIX.       
           MOVE WS-FMT-ADDR-SUFFIX           TO DY-ADDR-SUFFIX.         
           MOVE WS-ZIP-CODE                  TO DY-ZIP-CODE.            
           MOVE WS-ZIP-CODE-PLUS-FOUR        TO DY-ZIP-CODE-PLUS-FOUR.  
           MOVE A4-ZIP-CODE-TOKEN            TO DY-ZIP-CODE-TOKEN.      
           MOVE SPACES                       TO DY-CARRIER-ROUTE        
                                                DY-ADDRESS-OVERFLOW     
                                                DY-USPS-DELIV-PT-CD.    
           MOVE 'F'                          TO DY-ADDR-USAGE-CD.       
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-MOVE-FF-ADDR-FLDS-NEW                                     *        
      ******************************************************************        
                                                                        
       2120-MOVE-FF-ADDR-FLDS-NEW.                                      
                                                                        
           IF WS-ZIP-CODE-PLUS-FOUR > SPACES                            
              STRING WS-ZIP-CODE           DELIMITED BY SPACES          
                     WS-ZIP-CODE-PLUS-FOUR DELIMITED BY SIZE            
                     INTO WS-ADDR-ZIP-CODE                              
           ELSE                                                         
              MOVE WS-ZIP-CODE               TO WS-ADDR-ZIP-CODE        
           END-IF.                                                      
                                                                        
           MOVE WS-90-NEW-ADDRESS-ID         TO DZ-ADDRESS-ID           
                                                PA-ADDRESS-ID.          
           MOVE WS-FF-ADDR-STREET            TO DZ-ADDR-STREET.         
           MOVE WS-FF-ADDRESS-OVERFLOW       TO DZ-ADDRESS-OVERFLOW.    
           MOVE WS-ADDR-ZIP-CODE             TO DZ-ADDR-ZIP-CODE.       
           MOVE WS-FF-ADDRESS-CITY-STATE     TO DZ-ADDR-CITY-STATE.     
                                                                        
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5230-MOVE-FMT-ADDR-FLDS-OLD                                    *        
      ******************************************************************        
                                                                        
       2130-MOVE-FMT-ADDR-FLDS-OLD.                                     
                                                                        
           MOVE WS-CITY                      TO A4-TOWN.                
           MOVE WS-STATE                     TO A4-STATE.               
           MOVE WS-ZIP-CODE                  TO A4-ZIP-CODE.            
           PERFORM 7030-GET-TOKEN            THRU 7030-EXIT.            
                                                                        
           MOVE WS-FMT-HOUSE-NO              TO DY-HOUSE-NO.            
           MOVE WS-FMT-ADDR-PREFIX-1         TO DY-ADDR-PREFIX-1.       
           MOVE WS-FMT-ADDR-PREFIX-2         TO DY-ADDR-PREFIX-2.       
           MOVE WS-FMT-STREET-NAME           TO DY-STREET-NAME.         
           MOVE WS-FMT-STREET-LOCATION-1     TO DY-STREET-LOCATION-1.   
           MOVE WS-FMT-STREET-LOCATION-2     TO DY-STREET-LOCATION-2    
           MOVE WS-FMT-STREET-SUFFIX         TO DY-STREET-SUFFIX.       
           MOVE WS-FMT-ADDR-SUFFIX           TO DY-ADDR-SUFFIX.         
           MOVE WS-ZIP-CODE                  TO DY-ZIP-CODE.            
           MOVE WS-ZIP-CODE-PLUS-FOUR        TO DY-ZIP-CODE-PLUS-FOUR.  
           MOVE A4-ZIP-CODE-TOKEN            TO DY-ZIP-CODE-TOKEN.      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2140-MOVE-FF-ADDR-FLDS-OLD                                     *        
      ******************************************************************        
                                                                        
       2140-MOVE-FF-ADDR-FLDS-OLD.                                      
                                                                        
           IF WS-ZIP-CODE-PLUS-FOUR > SPACES                            
              STRING WS-ZIP-CODE '-'                                    
                     WS-ZIP-CODE-PLUS-FOUR DELIMITED BY SIZE            
                     INTO WS-ADDR-ZIP-CODE                              
           ELSE                                                         
              MOVE WS-ZIP-CODE               TO WS-ADDR-ZIP-CODE        
           END-IF.                                                      
                                                                        
           MOVE WS-FF-ADDR-STREET            TO DZ-ADDR-STREET.         
           MOVE WS-FF-ADDRESS-OVERFLOW       TO DZ-ADDRESS-OVERFLOW.    
           MOVE WS-ADDR-ZIP-CODE             TO DZ-ADDR-ZIP-CODE.       
           MOVE WS-FF-ADDRESS-CITY-STATE     TO DZ-ADDR-CITY-STATE.     
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2300-INSERT-PHY-ATTR-DTLS                                     *         
      *****************************************************************         
                                                                        
       2300-INSERT-PHY-ATTR-DTLS.                                       
                                                                        
           PERFORM 7010-GET-NEXT-PHYSICIAN-ID         THRU 7010-EXIT.   
           MOVE WS-LICENSE-NUMBER           TO PY-MED-LICENSE-NO.       
           MOVE WS-LICENSE-STATE-CD         TO PY-MED-LIC-STATE-CD.     
           MOVE DQ-NAME-ID                  TO PY-NAME-ID.              
           MOVE 'MD'                        TO PY-LICENSE-TYPE-CD.      
           PERFORM 8010-INSERT-PHY-DETAIL             THRU 8010-EXIT.   
                                                                        
      * Populate physician attribute variables                                  
           MOVE PY-PHYSICIAN-ID             TO PA-PHYSICIAN-ID          
                                               S-PHYSICIAN-ID.          
           MOVE SPACES                      TO PA-EXTENSION-NO          
                                               PA-PHONE-NO.             
           MOVE WS-SEL-FORMAT-TYPE          TO PA-ADDRESS-FORMAT.       
           PERFORM 8020-INSERT-PHY-ATTR               THRU 8020-EXIT.   
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6010-REDUCE-EMBEDDED-SPACES                                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                         0000
              INCLUDE CPD00004                                              0000
           END-EXEC.                                                        0000
                                                                        
      *****************************************************************         
      * 6202-GET-NEW-ADDRESS-ID                                       *         
      * 6210-CALCULATE-CHECK-DIGIT                                    *         
      * 6204-LOCK-ADDR-ID-CNTRL                                       *         
      * 6206-SELECT-ADDR-ID-CNTL                                      *         
      * 6208-UPDATE-ADDR-ID-CNTL                                      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                         0000
              INCLUDE CPD00090                                              0000
           END-EXEC.                                                        0000
                                                                        
      *****************************************************************         
      * 6210-CALCULATE-CHECK-DIGIT                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                         0000
              INCLUDE CPD00071                                              0000
           END-EXEC.                                                        0000
                                                                        
      *****************************************************************         
      * 6302-GET-NEW-NAME-ID                                          *         
      * 6210-CALCULATE-CHECK-DIGIT                                    *         
      * 6304-LOCK-NAME-ID-CNTRL                                       *         
      * 6306-SELECT-NAME-ID-CNTL                                      *         
      * 6308-UPDATE-NAME-ID-CNTL                                      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7010-GET-NEXT-PHYSICIAN-ID                                     *        
      ******************************************************************        
                                                                        
       7010-GET-NEXT-PHYSICIAN-ID.                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              NEXT VALUE FOR SEQ_PY_PHYSICIAN_ID
            INTO
              :PY-PHYSICIAN-ID   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :PY-PHYSICIAN-ID = NEXTVAL FOR SEQ_PY_PHYSICIAN_ID           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'SET'                      TO TABLE-1                
              MOVE 'SEQ_PY_PHYSICIAN_ID'      TO TABLE-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-GET-TIMESTAMP.                                            *        
      ******************************************************************        
                                                                        
       7020-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE         
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7020'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SET'                 TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-GET-TOKEN                                                 *        
      ******************************************************************        
                                                                        
       7030-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN     = :A4-TOWN                               
                  AND STATE    = :A4-STATE                              
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN     = :A4-TOWN                                       
MFA-TR*           AND STATE    = :A4-STATE                                      
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE '1' TO A4-ZIP-CODE-TOKEN                       
               WHEN OTHER                                               
                    MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE        
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7030'                 TO ACTIVE-PARAGRAPH     
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE SQLCODE                TO ABEND-SQLCODE        
                                                   S-RETURN-CODE        
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE 'CSS_ZIP_CODE'         TO TABLE-1              
                    MOVE 'TOWN'                 TO TABLE-ELEMENT-1      
                    MOVE A4-TOWN                TO HOSTVAR-ELEMENT-1    
                    MOVE 'STATE'                TO TABLE-ELEMENT-2      
                    MOVE A4-STATE               TO HOSTVAR-ELEMENT-2    
                    MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-3      
                    MOVE A4-ZIP-CODE            TO HOSTVAR-ELEMENT-3    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-SEL-PHY-ATTR-DETAILS                                      *        
      ******************************************************************        
                                                                        
       7040-SEL-PHY-ATTR-DETAILS.                                       
                                                                        
           EXEC SQL                                                     
              SELECT PA.ADDRESS_ID                                      
                    ,PA.ADDRESS_FORMAT                                  
                    ,PY.MED_LIC_STATE_CD                                
                    ,PY.MED_LICENSE_NO                                  
                    ,PY.NAME_ID                                         
                INTO :PA-ADDRESS-ID                                     
                    ,:PA-ADDRESS-FORMAT                                 
                    ,:PY-MED-LIC-STATE-CD                               
                    ,:PY-MED-LICENSE-NO                                 
                    ,:PY-NAME-ID                                        
                FROM CSS_PHYSICIAN      PY                              
                    ,CSS_PHYSICIAN_ATTR PA                              
               WHERE PY.PHYSICIAN_ID = PA.PHYSICIAN_ID                  
                 AND PY.PHYSICIAN_ID = :PY-PHYSICIAN-ID                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PA.ADDRESS_ID                                              
MFA-TR*             ,PA.ADDRESS_FORMAT                                          
MFA-TR*             ,PY.MED_LIC_STATE_CD                                        
MFA-TR*             ,PY.MED_LICENSE_NO                                          
MFA-TR*             ,PY.NAME_ID                                                 
MFA-TR*         INTO :PA-ADDRESS-ID                                             
MFA-TR*             ,:PA-ADDRESS-FORMAT                                         
MFA-TR*             ,:PY-MED-LIC-STATE-CD                                       
MFA-TR*             ,:PY-MED-LICENSE-NO                                         
MFA-TR*             ,:PY-NAME-ID                                                
MFA-TR*         FROM CSS_PHYSICIAN      PY                                      
MFA-TR*             ,CSS_PHYSICIAN_ATTR PA                                      
MFA-TR*        WHERE PY.PHYSICIAN_ID = PA.PHYSICIAN_ID                          
MFA-TR*          AND PY.PHYSICIAN_ID = :PY-PHYSICIAN-ID                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7040'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
                                                 S-RETURN-CODE          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PHYSICIAN'            TO TABLE-1                
              MOVE 'CSS_PHYSICIAN_ATTR'       TO TABLE-2                
              MOVE 'PHYSICIAN_ID'             TO TABLE-ELEMENT-1        
              MOVE PY-PHYSICIAN-ID            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-CHECK-LICENSE-NO-EXISTS                                   *        
      ******************************************************************        
                                                                        
       7050-CHECK-LICENSE-NO-EXISTS.                                    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-LICENSE-NO-EXISTS                              
                FROM CSS_PHYSICIAN      PY                              
               WHERE PY.MED_LIC_STATE_CD = :WS-LICENSE-STATE-CD         
                 AND PY.MED_LICENSE_NO   = :WS-LICENSE-NUMBER           
                 AND PY.LICENSE_TYPE_CD  IN ('MD',' ')                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-LICENSE-NO-EXISTS                                      
MFA-TR*         FROM CSS_PHYSICIAN      PY                                      
MFA-TR*        WHERE PY.MED_LIC_STATE_CD = :WS-LICENSE-STATE-CD                 
MFA-TR*          AND PY.MED_LICENSE_NO   = :WS-LICENSE-NUMBER                   
MFA-TR*          AND PY.LICENSE_TYPE_CD  IN ('MD',' ')                          
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
                                                 S-RETURN-CODE          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PHYSICIAN'            TO TABLE-1                
              MOVE 'MED_LIC_STATE_CD'         TO TABLE-ELEMENT-1        
              MOVE WS-LICENSE-STATE-CD        TO HOSTVAR-ELEMENT-1      
              MOVE 'MED_LICENSE_NO'           TO TABLE-ELEMENT-2        
              MOVE WS-LICENSE-NUMBER          TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-INSERT-PHY-DETAIL                                         *        
      ******************************************************************        
                                                                        
       8010-INSERT-PHY-DETAIL.                                          
                                                                        
               EXEC SQL                                                 
                   INSERT INTO CSS_PHYSICIAN                            
                       (PHYSICIAN_ID                                    
                       ,MED_LIC_STATE_CD                                
                       ,MED_LICENSE_NO                                  
                       ,NAME_ID                                         
                       ,LICENSE_TYPE_CD)                                
                   VALUES                                               
                       (:PY-PHYSICIAN-ID                                
                       ,:PY-MED-LIC-STATE-CD                            
                       ,:PY-MED-LICENSE-NO                              
                       ,:PY-NAME-ID                                     
                       ,:PY-LICENSE-TYPE-CD)                            
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SQLCODE                   TO ABEND-SQLCODE           
                                                S-RETURN-CODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PHYSICIAN'           TO TABLE-1                 
              MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-1         
              MOVE 'MED_LIC_STATE_CD'        TO TABLE-ELEMENT-2         
              MOVE 'MED_LICENSE_NO'          TO TABLE-ELEMENT-3         
              MOVE PY-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-1       
              MOVE PY-MED-LIC-STATE-CD       TO HOSTVAR-ELEMENT-2       
              MOVE PY-MED-LICENSE-NO         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8020-INSERT-PHY-ATTR.                                                   
      *****************************************************************         
                                                                        
       8020-INSERT-PHY-ATTR.                                            
                                                                        
               EXEC SQL                                                 
                   INSERT INTO CSS_PHYSICIAN_ATTR                       
                       (PHYSICIAN_ID                                    
                       ,ADDRESS_ID                                      
                       ,EXTENSION_NO                                    
                       ,PHONE_NO                                        
                       ,ADDRESS_FORMAT)                                 
                   VALUES                                               
                       (:PA-PHYSICIAN-ID                                
                       ,:PA-ADDRESS-ID                                  
                       ,:PA-EXTENSION-NO                                
                       ,:PA-PHONE-NO                                    
                       ,:PA-ADDRESS-FORMAT)                             
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SQLCODE                   TO ABEND-SQLCODE           
                                                S-RETURN-CODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PHYSICIAN_ATTR'      TO TABLE-1                 
              MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-1         
              MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-2         
              MOVE 'PHONE_NO'                TO TABLE-ELEMENT-3         
              MOVE PA-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-1       
              MOVE PA-ADDRESS-ID             TO HOSTVAR-ELEMENT-2       
              MOVE PA-PHONE-NO               TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8030-INSERT-FMT-ADDRESS.                                                
      *****************************************************************         
       8030-INSERT-FMT-ADDRESS.                                         
      *                                                                         
               EXEC SQL                                                 
                   INSERT INTO CSS_ADDR_FORMATTED                       
                       (ADDRESS_ID                                      
                       ,HOUSE_NO                                        
                       ,ADDR_PREFIX_1                                   
                       ,ADDR_PREFIX_2                                   
                       ,STREET_NAME                                     
                       ,STREET_LOCATION_1                               
                       ,STREET_LOCATION_2                               
                       ,STREET_SUFFIX                                   
                       ,ADDR_SUFFIX                                     
                       ,ZIP_CODE                                        
                       ,ZIP_CODE_PLUS_FOUR                              
                       ,ZIP_CODE_TOKEN                                  
                       ,CARRIER_ROUTE                                   
                       ,ADDR_USAGE_CD                                   
                       ,USPS_DELIV_PT_CD)                               
                   VALUES                                               
                       (:DY-ADDRESS-ID                                  
                       ,:DY-HOUSE-NO                                    
                       ,:DY-ADDR-PREFIX-1                               
                       ,:DY-ADDR-PREFIX-2                               
                       ,:DY-STREET-NAME                                 
                       ,:DY-STREET-LOCATION-1                           
                       ,:DY-STREET-LOCATION-2                           
                       ,:DY-STREET-SUFFIX                               
                       ,:DY-ADDR-SUFFIX                                 
                       ,:DY-ZIP-CODE                                    
                       ,:DY-ZIP-CODE-PLUS-FOUR                          
                       ,:DY-ZIP-CODE-TOKEN                              
                       ,:DY-CARRIER-ROUTE                               
                       ,:DY-ADDR-USAGE-CD                               
                       ,:DY-USPS-DELIV-PT-CD)                           
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SQLCODE                   TO ABEND-SQLCODE           
                                                S-RETURN-CODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                 
              MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1         
              MOVE 'STREET_NAME'             TO TABLE-ELEMENT-2         
              MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-3         
              MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              MOVE DY-STREET-NAME            TO HOSTVAR-ELEMENT-2       
              MOVE DY-ZIP-CODE               TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22900100
      * 8040-INSERT-FF-ADDRESS                                         *22900100
      ******************************************************************22900100
                                                                        
       8040-INSERT-FF-ADDRESS.                                          
                                                                        
            EXEC SQL                                                    
               INSERT INTO CSS_ADDR_FREEFORM                            
                    (ADDRESS_ID                                         
                    ,ADDR_STREET                                        
                    ,ADDRESS_OVERFLOW                                   
                    ,ADDR_CITY_STATE                                    
                    ,ADDR_ZIP_CODE                                      
                    ,ADDR_COUNTRY)                                      
               VALUES                                                   
                    (:DZ-ADDRESS-ID                                     
                    ,:DZ-ADDR-STREET                                    
                    ,:DZ-ADDRESS-OVERFLOW                               
                    ,:DZ-ADDR-CITY-STATE                                
                    ,:DZ-ADDR-ZIP-CODE                                  
                    ,:DZ-ADDR-COUNTRY)                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8040'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           S-RETURN-CODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-STREET       TO HOSTVAR-ELEMENT-2            
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8510-UPDATE-FMT-ADDRESS.                                                
      *****************************************************************         
                                                                        
       8510-UPDATE-FMT-ADDRESS.                                         
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_ADDR_FORMATTED                                
                  SET HOUSE_NO           = :DY-HOUSE-NO                 
                     ,ADDR_PREFIX_1      = :DY-ADDR-PREFIX-1            
                     ,ADDR_PREFIX_2      = :DY-ADDR-PREFIX-2            
                     ,STREET_NAME        = :DY-STREET-NAME              
                     ,STREET_LOCATION_1  = :DY-STREET-LOCATION-1        
                     ,STREET_LOCATION_2  = :DY-STREET-LOCATION-2        
                     ,STREET_SUFFIX      = :DY-STREET-SUFFIX            
                     ,ADDR_SUFFIX        = :DY-ADDR-SUFFIX              
                     ,ZIP_CODE           = :DY-ZIP-CODE                 
                     ,ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR       
                     ,ZIP_CODE_TOKEN     = :DY-ZIP-CODE-TOKEN           
                WHERE ADDRESS_ID         = :DY-ADDRESS-ID               
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8510'                    TO ACTIVE-PARAGRAPH       
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE SQLCODE                   TO ABEND-SQLCODE          
                                                 S-RETURN-CODE          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1        
               MOVE 'STREET_NAME'             TO TABLE-ELEMENT-2        
               MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-3        
               MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1      
               MOVE DY-STREET-NAME            TO HOSTVAR-ELEMENT-2      
               MOVE DY-ZIP-CODE               TO HOSTVAR-ELEMENT-3      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8520-UPDATE-FF-ADDRESS.                                       *         
      *****************************************************************         
                                                                        
       8520-UPDATE-FF-ADDRESS.                                          
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_ADDR_FREEFORM                                 
                  SET ADDR_STREET       = :DZ-ADDR-STREET               
                     ,ADDRESS_OVERFLOW  = :DZ-ADDRESS-OVERFLOW          
                     ,ADDR_CITY_STATE   = :DZ-ADDR-CITY-STATE           
                     ,ADDR_ZIP_CODE     = :DZ-ADDR-ZIP-CODE             
                WHERE ADDRESS_ID        = :DZ-ADDRESS-ID                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8520'                    TO ACTIVE-PARAGRAPH       
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE SQLCODE                   TO ABEND-SQLCODE          
                                                 S-RETURN-CODE          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ADDR_FREEFORM'       TO TABLE-1                
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1        
               MOVE 'ADDR_STREET'             TO TABLE-ELEMENT-2        
               MOVE 'ADDR_ZIP_CODE'           TO TABLE-ELEMENT-3        
               MOVE DZ-ADDRESS-ID             TO HOSTVAR-ELEMENT-1      
               MOVE DZ-ADDR-CITY-STATE        TO HOSTVAR-ELEMENT-2      
               MOVE DZ-ADDR-ZIP-CODE          TO HOSTVAR-ELEMENT-3      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8530-UPDATE-PHY-DETAILS                                       *         
      *****************************************************************         
                                                                        
       8530-UPDATE-PHY-DETAILS.                                         
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_PHYSICIAN                                     
                  SET MED_LIC_STATE_CD  = :PY-MED-LIC-STATE-CD          
                     ,MED_LICENSE_NO    = :PY-MED-LICENSE-NO            
                WHERE PHYSICIAN_ID      = :PY-PHYSICIAN-ID              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8530'                    TO ACTIVE-PARAGRAPH       
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE SQLCODE                   TO ABEND-SQLCODE          
                                                 S-RETURN-CODE          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_PHYSICIAN'           TO TABLE-1                
               MOVE 'MED_LIC_STATE_CD'        TO TABLE-ELEMENT-1        
               MOVE 'MED_LICENSE_NO'          TO TABLE-ELEMENT-2        
               MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-3        
               MOVE PY-MED-LIC-STATE-CD       TO HOSTVAR-ELEMENT-1      
               MOVE PY-MED-LICENSE-NO         TO HOSTVAR-ELEMENT-2      
               MOVE PY-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-3      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00331                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
