       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04863.                                         
       AUTHOR.        VENKAT PONNEKANTI                                 
COB303 DATE-WRITTEN.  MAY 20, 2015.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      * RETRIEVES ELECTRONIC PAYMENT DETAILS                           *        
      *    - BANK                                                      *        
      *    - CREDIT CARD                                               *        
      *    - PARM-RETRIEVE-TYPE                                        *        
      *    - ' ' - ALL PAYMENTS       (RESULT SETS 1-5)                *        
      *    - 'A' - ALL PAYMENTS       (RESULT SETS 1-5)                *        
      *    - 'B' - BANK PAYMENTS ONLY (RESULT SETS 1,2,3&5)            *        
      *    - 'C' - CARD PAYMENTS ONLY (RESULT SETS 1,4&5)              *        
      *    - 'I' - INQUIRE ONLY       (RESULT SETS 5)                  *        
      *    - 'P' - SCHEDULED PAYMENTS (RESULT SETS 1&5)                *        
      *    - 'S' - SCHEDULED PAYMENTS (RESULT SETS 1,3&5)              *        
      *                                                                *        
      *    - PARM-APPL-NAME                                            *        
      *    - 'CIS' - CALL FROM CSR MOD                                 *        
      *    - 'WEB' - CALL FROM WEB MOD                                 *        
      *                                                                *        
      * BUSS-OP: GETACCTELECTRONICPAYMENTSDTLS (INTERFACE SOLUTION)    *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * -------- -------- -------------------------------------------- *        
      *   DATE   INITIALS COMMENTS                                     *        
      * -------- -------- -------------------------------------------- *        
P00732* 05/20/15 VP43661  INITIAL IMPLEMENTATION.                      *        
P00836* 01/27/16 VP43661 -EXNCLUDE APPLIED REAL-TIME PAYMENTS FOR WEB. *        
P00836*                  -ADD STATUS-CD TO PENDING CC PAYMENTS CURSOR. *        
      *                                                                *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      * 0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              *        
      * 1000 - 1999  INPUT PROCESSING CONTROL PATH                     *        
      * 2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    *        
      * 3000 - 4999  NOT USED                                          *        
      * 5000 - 5999  COMMON PROGRAM MODULES                            *        
      * 6000 - 6999  COMMON SYSTEM MODULES                             *        
      * 7000 - 7999  INPUT MODULES                                     *        
      * 8000 - 8999  OUTPUT MODULES                                    *        
      * 9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04863'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04863 STARTS HERE'.                  
      *                                                                         
       01 WS-MISC.                                                      
          05 PROGRAM-NAME              PIC X(08)   VALUE 'CSR04863'.    
          05 WS-PGRMNAME               PIC X(08)   VALUE 'CSR04863'.    
          05 CSR03423                  PIC X(08)   VALUE 'CSR03423'.    
          05 WS-AUTO-CARD-PAY          PIC X(13)   VALUE                
                                                    'AUTO_CARD_PAY'.    
          05 WS-ACCOUNT-X              PIC X(13)   VALUE SPACES.        
          05 WS-ACCOUNT-NO  REDEFINES WS-ACCOUNT-X                      
                                       PIC 9(13).                       
          05 WS-CUSTOMER-X             PIC X(10)   VALUE SPACES.        
          05 WS-CUSTOMER-NO REDEFINES WS-CUSTOMER-X                     
                                       PIC 9(10).                       
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-R1               PIC S9(9)   COMP     VALUE 0.    
          05 CTR-ROWS-R2               PIC S9(9)   COMP     VALUE 0.    
          05 CTR-ROWS-R3               PIC S9(9)   COMP     VALUE 0.    
          05 CTR-ROWS-R4               PIC S9(9)   COMP     VALUE 0.    
          05 CTR-ROWS-R5               PIC S9(9)   COMP     VALUE 0.    
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 ALL-DONE-SW               PIC X(01)   VALUE 'N'.           
             88 NOT-ALL-DONE                       VALUE 'N'.           
             88 ALL-DONE                           VALUE 'Y'.           
P00836    05 PMT-APPLIED-SW            PIC X(01)   VALUE 'N'.           
P00836       88 PMT-NOT-APPLIED                    VALUE 'N'.           
P00836       88 PMT-APPLIED                        VALUE 'Y'.           
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE          PIC S9(9)     COMP   VALUE 0.    
             10 S-SOURCE-ID            PIC X(01)   VALUE SPACES.        
             10 S-PYMNT-DATE           PIC X(10)   VALUE SPACES.        
             10 S-PYMNT-AMT            PIC S9(09)V99 COMP-3 VALUE 0.    
             10 S-PYMNT-CREATED-TS     PIC X(26)   VALUE SPACES.        
      *      DRAFT SPECIFIC                                                     
             10 S-PYMT-POSTED-FL       PIC X(01)   VALUE SPACES.        
             10 S-CUST-BANK-SEQ-NO     PIC S9(9)     COMP   VALUE 0.    
      *      CREDIT CARD SPECIFIC                                               
             10 S-STATUS-CODE          PIC X(01)   VALUE SPACES.        
             10 S-PMT-CANCEL-REAS-CD   PIC X(02)   VALUE SPACES.        
      *                                                                         
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9)     COMP   VALUE 0.    
             10 S-STATUS-CODE-2        PIC X(01)   VALUE SPACES.        
             10 S-DRAFT-CYCLE          PIC X(02)   VALUE SPACES.        
             10 S-REQSTED-DRAFT-DAY    PIC X(02)   VALUE SPACES.        
             10 S-LAST-DRAFT-DT        PIC X(10)   VALUE SPACES.        
             10 S-STATUS-CHG-DT        PIC X(10)   VALUE SPACES.        
             10 S-ESTABLISHED-DT       PIC X(10)   VALUE SPACES.        
             10 S-RESUME-DRAFT-DT      PIC X(10)   VALUE SPACES.        
             10 S-CUST-BANK-SEQ-NO-2   PIC S9(9)     COMP   VALUE 0.    
             10 S-INIT-TYPE-CD-2       PIC X(02)   VALUE SPACES.        
      *                                                                         
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9)     COMP   VALUE 0.    
             10 S-BANK-ACCOUNT-NAME-3  PIC X(50)   VALUE SPACES.        
             10 S-BANK-ACCT-NO-3       PIC X(19)   VALUE SPACES.        
             10 S-BANK-ACCT-STAT-CD-3  PIC X(01)   VALUE SPACES.        
             10 S-BANK-ACCT-TYPE-CD-3  PIC X(01)   VALUE SPACES.        
             10 S-BANK-ID-3            PIC X(06)   VALUE SPACES.        
             10 S-CUST-BANK-SEQ-NO-3   PIC X(50)   VALUE SPACES.        
             10 S-BANK-ACCT-NICKNAME-3 PIC X(50)   VALUE SPACES.        
             10 S-CUSTOMER-NO-3        PIC X(11)   VALUE SPACES.        
             10 S-PRIMARY-IND-3        PIC X(01)   VALUE SPACES.        
      *                                                                         
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4        PIC S9(9)     COMP   VALUE 0.    
             10 S-ENROLL-STATUS        PIC X(01)   VALUE SPACES.        
             10 S-ENROLL-DATE          PIC X(10)   VALUE SPACES.        
             10 S-CANCEL-DATE          PIC X(10)   VALUE SPACES.        
      *                                                                         
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5        PIC S9(9)     COMP   VALUE 0.    
             10 S-DRAFT-FLAG           PIC X(01)   VALUE SPACES.        
             10 S-EDRAFT-FLAG          PIC X(02)   VALUE SPACES.        
             10 S-EPAY-FLAG            PIC X(02)   VALUE SPACES.        
             10 S-AUTO-CARD-FLAG       PIC X(02)   VALUE SPACES.        
             10 S-DRAFT-CYCLE-5        PIC X(02)   VALUE SPACES.        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                               *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBACCT                                          00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_BANK_EFT - BE                                              *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBBNKEFT                                        00782200
           END-EXEC.                                                    00782300
      ******************************************************************        
      * CSS_PAYMENT_TRANS - JT                                         *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE  TBPMTRAN                                       00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      *                                                                 00782400
      ******************************************************************        
      * CSS_PNDNG_BNK_DRFT - PB                                        *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE  TBPDBKDF                                       00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_PNDNG_CARD_PMT - PC                                        *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE  TBPNDCRD                                       00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_ACCT_ATTRIBUTE - YP                                        *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBACTATT                                        00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      * RESULT SET LOCATOR                                                      
      ******************************************************************        
      *                                                                         
      *01 LOC1 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *                                                                         
      ******************************************************************        
      * SCHEDULED ELECTRONIC PAYMENTS CURSOR                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE SCHD_PYMTS_CUR CURSOR FOR                       
                 SELECT CIS.CHAR2$DATE(PB.DRAFT_DATE,'USA')                     
                       ,PB.CODE_SOURCE_ID                               
                       ,PB.DRAFT_AMT                                    
                       ,PB.CUST_BANK_SEQ_NO                             
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           PB.PYMT_TRANS_TS, 121), ' ', '-'), ':', '.') PYMT_TRANS_TS          
                       ,PB.PYMT_POSTED_FL                               
P00836                 ,''                                              
                   FROM CSS_PNDNG_BNK_DRFT PB WITH(READUNCOMMITTED)             
                  WHERE PB.ACCOUNT_NO        =  :PB-ACCOUNT-NO          
                UNION                                                   
                 SELECT CIS.CHAR2$DATE(PC.PAYMENT_DATE,'USA')                   
                       ,'C'                                             
                       ,PC.PAYMENT_AMT                                  
                       ,0                                               
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), PC.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,''                                              
P00836                 ,PC.STATUS_CODE                                  
                   FROM CSS_PNDNG_CARD_PMT PC WITH(READUNCOMMITTED)             
                  WHERE PC.ACCOUNT_NO        =  :PC-ACCOUNT-NO          
                    AND PC.STATUS_CODE       IN ('A','E')               
                  ORDER BY 1,3,4                                        
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE SCHD_PYMTS_CUR CURSOR FOR                               
MFA-TR*          SELECT CHAR(PB.DRAFT_DATE,USA)                                 
MFA-TR*                ,PB.CODE_SOURCE_ID                                       
MFA-TR*                ,PB.DRAFT_AMT                                            
MFA-TR*                ,PB.CUST_BANK_SEQ_NO                                     
MFA-TR*                ,PB.PYMT_TRANS_TS                                        
MFA-TR*                ,PB.PYMT_POSTED_FL                                       
MFA-TR*                ,''                                                      
MFA-TR*            FROM CSS_PNDNG_BNK_DRFT PB                                   
MFA-TR*           WHERE PB.ACCOUNT_NO        =  :PB-ACCOUNT-NO                  
MFA-TR*         UNION                                                           
MFA-TR*          SELECT CHAR(PC.PAYMENT_DATE,USA)                               
MFA-TR*                ,'C'                                                     
MFA-TR*                ,PC.PAYMENT_AMT                                          
MFA-TR*                ,0                                                       
MFA-TR*                ,PC.CREATED_TS                                           
MFA-TR*                ,''                                                      
MFA-TR*                ,PC.STATUS_CODE                                          
MFA-TR*            FROM CSS_PNDNG_CARD_PMT PC                                   
MFA-TR*           WHERE PC.ACCOUNT_NO        =  :PC-ACCOUNT-NO                  
MFA-TR*             AND PC.STATUS_CODE       IN ('A','E')                       
MFA-TR*           ORDER BY 1,3,4                                                
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CREDIT CARD PAYMENT HISTORY CURSOR                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE CARD_PYMT_HST_CUR CURSOR FOR                    
                 SELECT CIS.CHAR2$DATE(PC.PAYMENT_DATE,'USA')                   
                       ,PC.PAYMENT_AMT                                  
                       ,PC.STATUS_CODE                                  
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), PC.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,PC.PMT_CANCEL_REAS_CD                           
                   FROM CSS_PNDNG_CARD_PMT PC WITH(READUNCOMMITTED)             
                  WHERE PC.ACCOUNT_NO        = :PC-ACCOUNT-NO           
                    AND PC.PAYMENT_DATE      > DATEADD( YEAR, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )   
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CARD_PYMT_HST_CUR CURSOR FOR                            
MFA-TR*          SELECT CHAR(PC.PAYMENT_DATE,USA)                               
MFA-TR*                ,PC.PAYMENT_AMT                                          
MFA-TR*                ,PC.STATUS_CODE                                          
MFA-TR*                ,PC.CREATED_TS                                           
MFA-TR*                ,PC.PMT_CANCEL_REAS_CD                                   
MFA-TR*            FROM CSS_PNDNG_CARD_PMT PC                                   
MFA-TR*           WHERE PC.ACCOUNT_NO        = :PC-ACCOUNT-NO                   
MFA-TR*             AND PC.PAYMENT_DATE      > CURRENT DATE - 2 YEARS           
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * BANK EFT DETAILS TO THE CLIENT                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE C2 CURSOR  FOR                         
               SELECT  :S-RETURN-CODE-2      AS RETURN_CODE             
                      ,:S-STATUS-CODE-2      AS STATUS_CODE             
                      ,:S-DRAFT-CYCLE        AS DRAFT_CYCLE             
                      ,:S-REQSTED-DRAFT-DAY  AS REQSTED_DRAFT_DAY       
                      ,:S-LAST-DRAFT-DT      AS LAST_DRAFT_DATE         
                      ,:S-STATUS-CHG-DT      AS STATUS_CHANGE_DT        
                      ,:S-ESTABLISHED-DT     AS ESTABLISHED_DATE        
                      ,:S-RESUME-DRAFT-DT    AS RESUME_DRAFT_DT         
                      ,:S-CUST-BANK-SEQ-NO-2 AS CUST_BANK_SEQ_NO        
                      ,:S-INIT-TYPE-CD-2     AS INIT_TYPE_CD            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT  :S-RETURN-CODE-2      AS RETURN_CODE                     
MFA-TR*               ,:S-STATUS-CODE-2      AS STATUS_CODE                     
MFA-TR*               ,:S-DRAFT-CYCLE        AS DRAFT_CYCLE                     
MFA-TR*               ,:S-REQSTED-DRAFT-DAY  AS REQSTED_DRAFT_DAY               
MFA-TR*               ,:S-LAST-DRAFT-DT      AS LAST_DRAFT_DATE                 
MFA-TR*               ,:S-STATUS-CHG-DT      AS STATUS_CHANGE_DT                
MFA-TR*               ,:S-ESTABLISHED-DT     AS ESTABLISHED_DATE                
MFA-TR*               ,:S-RESUME-DRAFT-DT    AS RESUME_DRAFT_DT                 
MFA-TR*               ,:S-CUST-BANK-SEQ-NO-2 AS CUST_BANK_SEQ_NO                
MFA-TR*               ,:S-INIT-TYPE-CD-2     AS INIT_TYPE_CD                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * AUTO CARD ENROLLMENT DETAILS TO THE CLIENT                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE C4 CURSOR  FOR                         
               SELECT  :S-RETURN-CODE-4      AS RETURN_CODE             
                      ,:S-ENROLL-STATUS      AS ENROLL_STATUS           
                      ,:S-ENROLL-DATE        AS ENROLL_DATE             
                      ,:S-CANCEL-DATE        AS CANCEL_DATE             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT  :S-RETURN-CODE-4      AS RETURN_CODE                     
MFA-TR*               ,:S-ENROLL-STATUS      AS ENROLL_STATUS                   
MFA-TR*               ,:S-ENROLL-DATE        AS ENROLL_DATE                     
MFA-TR*               ,:S-CANCEL-DATE        AS CANCEL_DATE                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DRAFT/EDRAFT/EPAY INQUIRE                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE C5 CURSOR  FOR                         
               SELECT  :S-RETURN-CODE-5      AS RETURN_CODE             
                      ,:S-DRAFT-FLAG         AS DRAFT_FLAG              
                      ,:S-EDRAFT-FLAG        AS EDRAFT_FLAG             
                      ,:S-EPAY-FLAG          AS EPAY_FLAG               
                      ,:S-AUTO-CARD-FLAG     AS AUTO_CARD_FLAG          
                      ,:S-DRAFT-CYCLE-5      AS DRAFT_CYCLE             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT  :S-RETURN-CODE-5      AS RETURN_CODE                     
MFA-TR*               ,:S-DRAFT-FLAG         AS DRAFT_FLAG                      
MFA-TR*               ,:S-EDRAFT-FLAG        AS EDRAFT_FLAG                     
MFA-TR*               ,:S-EPAY-FLAG          AS EPAY_FLAG                       
MFA-TR*               ,:S-AUTO-CARD-FLAG     AS AUTO_CARD_FLAG                  
MFA-TR*               ,:S-DRAFT-CYCLE-5      AS DRAFT_CYCLE                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE CUST_BANKS_CUR CURSOR
MSQ001          FOR CALL CSR03423( :WS-ACCOUNT-X
                  , :WS-CUSTOMER-X
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-APPL-NAME              PIC X(08).                       
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
COB305 01 PARM-ACCOUNT-NO-TO        PIC S9(13)V COMP-3 VALUE 0.              
       01  PARM-RETRIEVE-TYPE          PIC X(02).                       
       01  PARM-REALTIME-PYMTS         PIC X(01).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPL-NAME                          
                                PARM-ACCOUNT-NO                         
                                PARM-ACCOUNT-NO-TO                      
                                PARM-RETRIEVE-TYPE                      
                                PARM-REALTIME-PYMTS.                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           PERFORM 0101-DECLARE-GTT-R1      THRU 0101-EXIT.             
           PERFORM 0103-DECLARE-GTT-R3      THRU 0103-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0101-DECLARE-GTT-R1                                            *        
      * CONTENTS WILL VARY BASED ON 'PARM-RETRIEVE-TYPE'               *        
      * ' ' - EPAY/DRAFT/CREDIT CARD PAYMENTS(INCLUDING HISTORY)       *        
      * 'A' - EPAY/DRAFT/CREDIT CARD PAYMENTS(INCLUDING HISTORY)       *        
      * 'B' - EPAY/DRAFT SCHEDULED PAYMENTS                            *        
      * 'C' - CREDIT CARD PAYMENT HISTORY                              *        
      ******************************************************************        
      *                                                                         
       0101-DECLARE-GTT-R1.                                             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04863_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04863_R1
              (                                                          
                  RETURN_CODE              INT                      
                 ,SOURCE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,PYMNT_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,PYMNT_AMT                DECIMAL(11,2)                
                 ,PYMNT_TRANS_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,PYMT_POSTED_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,CUST_BANK_SEQ_NO         INT                      
                 ,STATUS_CODE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,PMT_CANCEL_REAS_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8001A-DEL-GTT-R1      THRU 8001A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0101'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04863_R1'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04863_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04863_R1                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0103-DECLARE-GTT-R3                                            *        
      * LIST OF CUSTOMER BANKS                                         *        
      ******************************************************************        
      *                                                                         
       0103-DECLARE-GTT-R3.                                             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04863_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04863_R3
              (                                                          
                  RETURN_CODE              INT                      
                 ,BANK_ACCOUNT_NAME CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,BANK_ACCT_NO CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,BANK_ACCT_STAT_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,BANK_ACCT_TYPE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,BANK_ID CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2             
                 ,CUST_BANK_SEQ_NO CHAR(09)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,BANK_ACCT_NICKNAME CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,PRIMARY_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8003A-DEL-GTT-R3      THRU 8003A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0103'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04863_R3'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04863_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04863_R3                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0103-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO                 TO AT-ACCOUNT-NO        
                                                   BE-ACCOUNT-NO        
                                                   PB-ACCOUNT-NO        
                                                   PC-ACCOUNT-NO        
                                                   YP-ACCOUNT-NO        
P00836                                             JT-ACCOUNT-NO        
                                                   WS-ACCOUNT-NO.       
           IF PARM-ACCOUNT-NO-TO > 0                                    
              MOVE PARM-ACCOUNT-NO-TO           TO AT-ACCOUNT-NO        
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7000-SELECT-ACCOUNT          THRU 7000-EXIT.         
           MOVE AT-CUSTOMER-NO                  TO WS-CUSTOMER-NO.      
      *                                                                         
           EVALUATE PARM-RETRIEVE-TYPE                                  
            WHEN SPACES                                                 
            WHEN 'A'                                                    
                 PERFORM 2100-GET-SCHD-PYMNTS   THRU 2100-EXIT          
                 PERFORM 2200-GET-BANK-EFT-DTLS THRU 2200-EXIT          
                 PERFORM 2300-GET-CUST-BANKS    THRU 2300-EXIT          
                 PERFORM 2400-GET-CARD-PMT-DTLS THRU 2400-EXIT          
                 PERFORM 2500-GET-CARD-PMT-HIST THRU 2500-EXIT          
            WHEN 'B'                                                    
                 PERFORM 2100-GET-SCHD-PYMNTS   THRU 2100-EXIT          
                 PERFORM 2200-GET-BANK-EFT-DTLS THRU 2200-EXIT          
                 PERFORM 2300-GET-CUST-BANKS    THRU 2300-EXIT          
            WHEN 'C'                                                    
                 PERFORM 2400-GET-CARD-PMT-DTLS THRU 2400-EXIT          
                 PERFORM 2500-GET-CARD-PMT-HIST THRU 2500-EXIT          
            WHEN 'I'                                                    
                 CONTINUE                                               
      *          PERFORM 2600-GET-ACCT-PMT-FLGS THRU 2600-EXIT                  
            WHEN 'P'                                                    
                 PERFORM 2100-GET-SCHD-PYMNTS   THRU 2100-EXIT          
            WHEN 'S'                                                    
                 PERFORM 2100-GET-SCHD-PYMNTS   THRU 2100-EXIT          
                 PERFORM 2300-GET-CUST-BANKS    THRU 2300-EXIT          
           END-EVALUATE.                                                
           PERFORM 2600-GET-ACCT-PMT-FLGS       THRU 2600-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-GET-SCHD-PYMNTS.                                          *        
      ******************************************************************        
      *                                                                         
       2100-GET-SCHD-PYMNTS.                                            
      *                                                                         
           PERFORM 7100-OPEN-SCHD-PYMTS-CUR     THRU 7100-EXIT.         
           SET NOT-ALL-DONE                     TO TRUE.                
           PERFORM 7110-FETCH-SCHD-PYMTS-CUR    THRU 7110-EXIT.         
      *                                                                         
           PERFORM UNTIL ALL-DONE                                       
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE        
              MOVE PB-CODE-SOURCE-ID            TO S-SOURCE-ID          
              MOVE PB-DRAFT-DATE                TO S-PYMNT-DATE         
              MOVE PB-DRAFT-AMT                 TO S-PYMNT-AMT          
              MOVE PB-PYMT-TRANS-TS             TO S-PYMNT-CREATED-TS   
              MOVE PB-PYMT-POSTED-FL            TO S-PYMT-POSTED-FL     
              MOVE PB-CUST-BANK-SEQ-NO          TO S-CUST-BANK-SEQ-NO   
P00836        MOVE PC-STATUS-CODE               TO S-STATUS-CODE        
              MOVE SPACES                       TO S-PMT-CANCEL-REAS-CD 
      *       SKIP CC PAYMENTS WHILE PROCESSING BANK PAYMENTS                   
      *       SKIP REALTIME PAYMENTS WHEN FLAG IS 'N'                           
P00836*       EXCLUDE 'IN PROGRESS' CC PAYMENTS                                 
              IF (PARM-RETRIEVE-TYPE  = 'B' AND S-SOURCE-ID = 'C') OR   
P00836           (PARM-APPL-NAME = 'CIS'    AND S-STATUS-CODE = 'E') OR 
                 (PARM-REALTIME-PYMTS = 'N' AND S-PYMT-POSTED-FL = 'Y') 
                 CONTINUE                                               
              ELSE                                                      
P00836           MOVE 'Y'                       TO PMT-APPLIED-SW       
P00836           IF PARM-APPL-NAME = 'WEB' AND S-PYMT-POSTED-FL = 'Y'   
P00836              MOVE PB-PYMT-TRANS-TS       TO JT-PYMT-RCVD-TS      
P00836              PERFORM 7250-SEL-PYMT-TRANS THRU 7250-EXIT          
P00836              IF PMT-NOT-APPLIED                                  
P00836                 PERFORM 8001-INSERT-GTT-R1                       
P00836                                          THRU 8001-EXIT          
P00836              END-IF                                              
P00836           ELSE                                                   
P00836              PERFORM 8001-INSERT-GTT-R1  THRU 8001-EXIT          
P00836           END-IF                                                 
              END-IF                                                    
              PERFORM 7110-FETCH-SCHD-PYMTS-CUR THRU 7110-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7120-CLOSE-SCHD-PYMTS-CUR    THRU 7120-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-GET-BANK-EFT-DTLS.                                        *        
      ******************************************************************        
      *                                                                         
       2200-GET-BANK-EFT-DTLS.                                          
      *                                                                         
           PERFORM 7050-SEL-BANK-EFT            THRU 7050-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              ADD +1                            TO CTR-ROWS-R2          
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-2      
              MOVE BE-STATUS-CODE               TO S-STATUS-CODE-2      
              MOVE BE-DRAFT-CYCLE               TO S-DRAFT-CYCLE        
              MOVE BE-LAST-DRAFT-DATE           TO S-LAST-DRAFT-DT      
              MOVE BE-STATUS-CHANGE-DT          TO S-STATUS-CHG-DT      
              MOVE BE-ESTABLISHED-DATE          TO S-ESTABLISHED-DT     
              MOVE BE-RESUME-DRAFT-DT           TO S-RESUME-DRAFT-DT    
              MOVE BE-CUST-BANK-SEQ-NO          TO S-CUST-BANK-SEQ-NO-2 
              MOVE BE-INIT-TYPE-CD              TO S-INIT-TYPE-CD-2     
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-GET-CUST-BANKS.                                           *        
      ******************************************************************        
      *                                                                         
       2300-GET-CUST-BANKS.                                             
      *                                                                         
           PERFORM 7200-OPEN-CUST-BANKS         THRU 7200-EXIT.         
           SET NOT-ALL-DONE                     TO TRUE.                
           PERFORM 7210-FETCH-CUST-BANKS        THRU 7210-EXIT.         
      *                                                                         
           PERFORM UNTIL ALL-DONE                                       
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-3      
              PERFORM 8003-INSERT-GTT-R3        THRU 8003-EXIT          
              PERFORM 7210-FETCH-CUST-BANKS     THRU 7210-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7220-CLOSE-CUST-BANKS        THRU 7220-EXIT.         
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-GET-CARD-PMT-DTLS.                                        *        
      ******************************************************************        
      *                                                                         
       2400-GET-CARD-PMT-DTLS.                                          
      *                                                                         
           PERFORM 7150-SEL-AUTO-CARD-ATTR      THRU 7150-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              ADD +1                            TO CTR-ROWS-R4          
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-4      
              MOVE YP-STATUS-CD                 TO S-ENROLL-STATUS      
              MOVE YP-CREATED-TS(1:10)          TO S-ENROLL-DATE        
              IF YP-ATTRIBUTE-VALUE-TX(1:3) = 'CAN'                     
                 MOVE YP-ATTRIBUTE-VALUE-TX(11:10)                      
                                                TO S-CANCEL-DATE        
              ELSE                                                      
                 MOVE SPACES                    TO S-CANCEL-DATE        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-GET-CARD-PMT-HIST.                                        *        
      ******************************************************************        
      *                                                                         
       2500-GET-CARD-PMT-HIST.                                          
      *                                                                         
           PERFORM 7300-OPEN-CARD-PYMT-HST-CUR  THRU 7300-EXIT.         
           SET NOT-ALL-DONE                     TO TRUE.                
           PERFORM 7310-FETCH-CARD-PYMT-HST-CUR THRU 7310-EXIT.         
      *                                                                         
           PERFORM UNTIL ALL-DONE                                       
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE        
              MOVE 'C'                          TO S-SOURCE-ID          
              MOVE PC-PAYMENT-DATE              TO S-PYMNT-DATE         
              MOVE PC-PAYMENT-AMT               TO S-PYMNT-AMT          
              MOVE PC-CREATED-TS                TO S-PYMNT-CREATED-TS   
              MOVE SPACES                       TO S-PYMT-POSTED-FL     
              MOVE +0                           TO S-CUST-BANK-SEQ-NO   
              MOVE PC-STATUS-CODE               TO S-STATUS-CODE        
              MOVE PC-PMT-CANCEL-REAS-CD        TO S-PMT-CANCEL-REAS-CD 
              PERFORM 8001-INSERT-GTT-R1        THRU 8001-EXIT          
              PERFORM 7310-FETCH-CARD-PYMT-HST-CUR                      
                                                THRU 7310-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7320-CLOSE-CARD-PYMT-HST-CUR THRU 7320-EXIT.         
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2600-GET-ACCT-PMT-FLGS.                                       *        
      ******************************************************************        
      *                                                                         
       2600-GET-ACCT-PMT-FLGS.                                          
      *                                                                         
           MOVE SPACES                          TO S-DRAFT-FLAG         
                                                   S-EDRAFT-FLAG        
                                                   S-EPAY-FLAG          
                                                   S-AUTO-CARD-FLAG     
                                                   S-DRAFT-CYCLE-5.     
      *                                                                         
           PERFORM 7050-SEL-BANK-EFT            THRU 7050-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              MOVE +1                           TO CTR-ROWS-R5          
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-5      
              IF BE-INIT-TYPE-CD = '01'                                 
                 MOVE BE-STATUS-CODE            TO S-DRAFT-FLAG         
                 MOVE BE-DRAFT-CYCLE            TO S-DRAFT-CYCLE-5      
              ELSE                                                      
                 IF BE-STATUS-CODE = 'A' OR 'D' OR 'C'                  
                    MOVE BE-STATUS-CODE         TO S-EDRAFT-FLAG        
                    MOVE BE-DRAFT-CYCLE         TO S-DRAFT-CYCLE-5      
                 ELSE                                                   
                    IF BE-STATUS-CODE = 'M' OR 'O'                      
                       MOVE BE-STATUS-CODE      TO S-EPAY-FLAG          
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7150-SEL-AUTO-CARD-ATTR      THRU 7150-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              MOVE +1                           TO CTR-ROWS-R5          
              MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-5      
              MOVE YP-STATUS-CD                 TO S-AUTO-CARD-FLAG     
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
      *                                                                 12220000
       7000-SELECT-ACCOUNT.                                             
      *                                                                 10120000
           MOVE WS-AUTO-CARD-PAY                TO YP-ATTRIBUTE-DESC.   
      *                                                                 10120000
           EXEC SQL                                                     
              SELECT  BILL_CYCLE                                        
                     ,TOTAL_AR_BALANCE                                  
                     ,CUSTOMER_NO                                       
                INTO  :AT-BILL-CYCLE                                    
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-CUSTOMER-NO                                   
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10130000
MFA-TR*       SELECT  BILL_CYCLE                                        10150000
MFA-TR*              ,TOTAL_AR_BALANCE                                  11490000
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*         INTO  :AT-BILL-CYCLE                                    10170000
MFA-TR*              ,:AT-TOTAL-AR-BALANCE                              11520000
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*         FROM CSS_ACCOUNT                                        10180000
MFA-TR*        WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                      10190000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    10200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10210000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10230000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-SEL-BANK-EFT.                                             *        
      ******************************************************************        
      *                                                                 10430000
       7050-SEL-BANK-EFT.                                               
      *                                                                 10450000
           EXEC SQL                                                     
              SELECT  BE.STATUS_CODE                                    
                     ,BE.DRAFT_CYCLE                                    
                     ,BE.REQSTED_DRAFT_DAY                              
                     ,COALESCE(CIS.CHAR2$DATE(
           BE.LAST_DRAFT_DATE,'USA'), 'N/A')     
                     ,COALESCE(CIS.CHAR2$DATE(
           BE.STATUS_CHANGE_DT,'USA'), 'N/A')    
                     ,COALESCE(CIS.CHAR2$DATE(
           BE.ESTABLISHED_DATE,'USA'), 'N/A')    
                     ,COALESCE(CIS.CHAR2$DATE(
           BE.RESUME_DRAFT_DT,'USA'), 'N/A')     
                     ,BE.CUST_BANK_SEQ_NO                               
                     ,BE.INIT_TYPE_CD                                   
                INTO  :BE-STATUS-CODE                                   
                     ,:BE-DRAFT-CYCLE                                   
                     ,:BE-REQSTED-DRAFT-DAY                             
                     ,:BE-LAST-DRAFT-DATE                               
                     ,:BE-STATUS-CHANGE-DT                              
                     ,:BE-ESTABLISHED-DATE                              
                     ,:BE-RESUME-DRAFT-DT                               
                     ,:BE-CUST-BANK-SEQ-NO                              
                     ,:BE-INIT-TYPE-CD                                  
                FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO   = :BE-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     10460000
MFA-TR*       SELECT  BE.STATUS_CODE                                    10560000
MFA-TR*              ,BE.DRAFT_CYCLE                                    10560000
MFA-TR*              ,BE.REQSTED_DRAFT_DAY                              10550000
MFA-TR*              ,COALESCE(CHAR(BE.LAST_DRAFT_DATE,USA), 'N/A')             
MFA-TR*              ,COALESCE(CHAR(BE.STATUS_CHANGE_DT,USA), 'N/A')            
MFA-TR*              ,COALESCE(CHAR(BE.ESTABLISHED_DATE,USA), 'N/A')            
MFA-TR*              ,COALESCE(CHAR(BE.RESUME_DRAFT_DT,USA), 'N/A')             
MFA-TR*              ,BE.CUST_BANK_SEQ_NO                                       
MFA-TR*              ,BE.INIT_TYPE_CD                                           
MFA-TR*         INTO  :BE-STATUS-CODE                                   10620000
MFA-TR*              ,:BE-DRAFT-CYCLE                                   10620000
MFA-TR*              ,:BE-REQSTED-DRAFT-DAY                             10550000
MFA-TR*              ,:BE-LAST-DRAFT-DATE                               10701000
MFA-TR*              ,:BE-STATUS-CHANGE-DT                              10670000
MFA-TR*              ,:BE-ESTABLISHED-DATE                              10660000
MFA-TR*              ,:BE-RESUME-DRAFT-DT                               10660000
MFA-TR*              ,:BE-CUST-BANK-SEQ-NO                                      
MFA-TR*              ,:BE-INIT-TYPE-CD                                          
MFA-TR*         FROM CSS_BANK_EFT BE                                    10750000
MFA-TR*        WHERE ACCOUNT_NO   = :BE-ACCOUNT-NO                      10760000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                    10770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10780000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BANK_EFT'           TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE BE-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-SCHD-PYMTS-CUR                                       *        
      ******************************************************************        
      *                                                                 12220000
       7100-OPEN-SCHD-PYMTS-CUR.                                        
      *                                                                 12220000
           EXEC SQL                                                     
              OPEN SCHD_PYMTS_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_PNDNG_BNK_DRFT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PB-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7110-FETCH-SCHD-PYMTS-CUR                                      *        
      ******************************************************************        
      *                                                                 12220000
       7110-FETCH-SCHD-PYMTS-CUR.                                       
      *                                                                 12220000
           EXEC SQL                                                     
             FETCH SCHD_PYMTS_CUR                                       
              INTO :PB-DRAFT-DATE                                       
                  ,:PB-CODE-SOURCE-ID                                   
                  ,:PB-DRAFT-AMT                                        
                  ,:PB-CUST-BANK-SEQ-NO                                 
                  ,:PB-PYMT-TRANS-TS                                    
                  ,:PB-PYMT-POSTED-FL                                   
                  ,:PC-STATUS-CODE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET ALL-DONE               TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PNDNG_BNK_DRFT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PB-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33800000
      ******************************************************************33760000
      * 7120-CLOSE-SCHD-PYMTS-CUR                                      *33770000
      ******************************************************************33780000
      *                                                                 33800000
       7120-CLOSE-SCHD-PYMTS-CUR.                                       
      *                                                                 33800000
           EXEC SQL                                                     
              CLOSE SCHD_PYMTS_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33800000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 33800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PNDNG_BNK_DRFT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PB-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-SEL-AUTO-CARD-ATTR.                                       *        
      ******************************************************************        
      *                                                                 10430000
       7150-SEL-AUTO-CARD-ATTR.                                         
      *                                                                 10450000
           EXEC SQL                                                     
              SELECT  YP.STATUS_CD                                      
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), YP.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                     ,YP.ATTRIBUTE_VALUE_TX                             
                INTO  :YP-STATUS-CD                                     
                     ,:YP-CREATED-TS                                    
                     ,:YP-ATTRIBUTE-VALUE-TX                            
                FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
               WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                
                 AND YP.ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10460000
MFA-TR*       SELECT  YP.STATUS_CD                                      10560000
MFA-TR*              ,YP.CREATED_TS                                             
MFA-TR*              ,YP.ATTRIBUTE_VALUE_TX                             10560000
MFA-TR*         INTO  :YP-STATUS-CD                                     10620000
MFA-TR*              ,:YP-CREATED-TS                                    10620000
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                            10550000
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                              10750000
MFA-TR*        WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                10760000
MFA-TR*          AND YP.ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC            10760000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                    10770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10780000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'ATTRIBUTE_DESC'         TO TABLE-ELEMENT-2          
              MOVE YP-ATTRIBUTE-DESC        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-CUST-BANKS.                                          *        
      ******************************************************************        
      *                                                                 12220000
       7200-OPEN-CUST-BANKS.                                            
      *                                                                 12220000
      *    EXEC SQL                                                     
      *       CALL CSR03423(:WS-ACCOUNT-X                               
      *                    ,:WS-CUSTOMER-X)                             
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CUST_BANKS_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CUST_BANKS_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CUST_BANKS_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = +466                              
      *       EXEC SQL                                                  
      *           ASSOCIATE LOCATORS (:LOC1) WITH PROCEDURE CSR03423    
      *       END-EXEC                                                  
      *       EXEC SQL                                                  
      *           ALLOCATE CUST_BANKS_CUR CURSOR FOR RESULT SET :LOC1   
      *       END-EXEC                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CALL'                   TO ABEND-FUNCTION           
              MOVE 'CSR03423'               TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-X             TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE WS-CUSTOMER-X            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7210-FETCH-CUST-BANKS                                          *        
      ******************************************************************        
      *                                                                 12220000
       7210-FETCH-CUST-BANKS.                                           
      *                                                                 12220000
           EXEC SQL                                                     
             FETCH CUST_BANKS_CUR                                       
              INTO :S-RETURN-CODE-3                                     
                  ,:S-BANK-ACCOUNT-NAME-3                               
                  ,:S-BANK-ACCT-NO-3                                    
                  ,:S-BANK-ACCT-STAT-CD-3                               
                  ,:S-BANK-ACCT-TYPE-CD-3                               
                  ,:S-BANK-ID-3                                         
                  ,:S-CUST-BANK-SEQ-NO-3                                
                  ,:S-BANK-ACCT-NICKNAME-3                              
                  ,:S-CUSTOMER-NO-3                                     
                  ,:S-PRIMARY-IND-3                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET ALL-DONE               TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CUST_BANKS_CUR'         TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-X             TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE WS-CUSTOMER-X            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33800000
      ******************************************************************33760000
      * 7220-CLOSE-CUST-BANKS                                          *33770000
      ******************************************************************33780000
      *                                                                 33800000
       7220-CLOSE-CUST-BANKS.                                           
      *                                                                 33800000
           EXEC SQL                                                     
              CLOSE CUST_BANKS_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33800000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 33800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CUST_BANKS_CUR'         TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-X             TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE WS-CUSTOMER-X            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       7220-EXIT.                                                       
           EXIT.                                                        
P00836*                                                                 11630000
P00836******************************************************************        
P00836* 7250-SEL-PYMT-TRANS                                            *        
P00836******************************************************************        
P00836*                                                                 12220000
P00836 7250-SEL-PYMT-TRANS.                                             
P00836*                                                                 10120000
P00836     EXEC SQL                                                     
P00836        SELECT TOP(1) 'N'                                               
P00836          INTO  :PMT-APPLIED-SW                                   
P00836          FROM CSS_PAYMENT_TRANS JT WITH(READUNCOMMITTED)                 
P00836         WHERE JT.ACCOUNT_NO     = :JT-ACCOUNT-NO                 
P00836           AND JT.PYMT_RCVD_TS   = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
P00836           AND JT.APPLIED_FL     IN ( ' ','N')                    
P00836                                              
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10130000
MFA-TR*       SELECT  'N'                                               10150000
MFA-TR*         INTO  :PMT-APPLIED-SW                                   10170000
MFA-TR*         FROM CSS_PAYMENT_TRANS JT                                       
MFA-TR*        WHERE JT.ACCOUNT_NO     = :JT-ACCOUNT-NO                 10190000
MFA-TR*          AND JT.PYMT_RCVD_TS   = :JT-PYMT-RCVD-TS                       
MFA-TR*          AND JT.APPLIED_FL     IN ( ' ','N')                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                    10200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 10210000
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00836*                                                                 10230000
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00836        MOVE '7250'                   TO ACTIVE-PARAGRAPH         
P00836        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00836        MOVE 'CSS_PAYMENT_TRANS'      TO TABLE-1                  
P00836        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00836        MOVE JT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00836        MOVE 'PYMT_TRANS_TS'          TO TABLE-ELEMENT-2          
P00836        MOVE JT-PYMT-RCVD-TS          TO HOSTVAR-ELEMENT-2        
P00836        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7250-EXIT.                                                       
P00836     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-CARD-PYMT-HST-CUR.                                   *        
      ******************************************************************        
      *                                                                 12220000
       7300-OPEN-CARD-PYMT-HST-CUR.                                     
      *                                                                 12220000
           EXEC SQL                                                     
              OPEN CARD_PYMT_HST_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_PNDNG_CARD_PMT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7310-FETCH-CARD-PYMT-HST-CUR.                                  *        
      ******************************************************************        
      *                                                                 12220000
       7310-FETCH-CARD-PYMT-HST-CUR.                                    
      *                                                                 12220000
           EXEC SQL                                                     
             FETCH CARD_PYMT_HST_CUR                                    
              INTO :PC-PAYMENT-DATE                                     
                  ,:PC-PAYMENT-AMT                                      
                  ,:PC-STATUS-CODE                                      
                  ,:PC-CREATED-TS                                       
                  ,:PC-PMT-CANCEL-REAS-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET ALL-DONE               TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PNDNG_CARD_PMT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33800000
      ******************************************************************33760000
      * 7320-CLOSE-CARD-PYMT-HST-CUR.                                  *33770000
      ******************************************************************33780000
      *                                                                 33800000
       7320-CLOSE-CARD-PYMT-HST-CUR.                                    
      *                                                                 33800000
           EXEC SQL                                                     
              CLOSE CARD_PYMT_HST_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33800000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 33800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PNDNG_CARD_PMT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11630000
      ******************************************************************        
      * 8001A-DEL-GTT-R1.                                              *        
      ******************************************************************        
      *                                                                 11630000
       8001A-DEL-GTT-R1.                                                
      *                                                                 11630000
           EXEC SQL                                                     
               DELETE FROM #CSR04863_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04863_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11630000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11630000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8001A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04863_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       8001A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8001-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8001-INSERT-GTT-R1.                                              
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04863_R1                            
             (                                                          
              RETURN_CODE                                               
             ,SOURCE_ID                                                 
             ,PYMNT_DATE                                                
             ,PYMNT_AMT                                                 
             ,PYMNT_TRANS_TS                                            
             ,PYMT_POSTED_FL                                            
             ,CUST_BANK_SEQ_NO                                          
             ,STATUS_CODE                                               
             ,PMT_CANCEL_REAS_CD                                        
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-SOURCE-ID                                              
             ,:S-PYMNT-DATE                                             
             ,:S-PYMNT-AMT                                              
             ,:S-PYMNT-CREATED-TS                                       
             ,:S-PYMT-POSTED-FL                                         
             ,:S-CUST-BANK-SEQ-NO                                       
             ,:S-STATUS-CODE                                            
             ,:S-PMT-CANCEL-REAS-CD                                     
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04863_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,SOURCE_ID                                                         
MFA-TR*      ,PYMNT_DATE                                                        
MFA-TR*      ,PYMNT_AMT                                                         
MFA-TR*      ,PYMNT_TRANS_TS                                                    
MFA-TR*      ,PYMT_POSTED_FL                                                    
MFA-TR*      ,CUST_BANK_SEQ_NO                                                  
MFA-TR*      ,STATUS_CODE                                                       
MFA-TR*      ,PMT_CANCEL_REAS_CD                                                
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-SOURCE-ID                                                      
MFA-TR*      ,:S-PYMNT-DATE                                                     
MFA-TR*      ,:S-PYMNT-AMT                                                      
MFA-TR*      ,:S-PYMNT-CREATED-TS                                               
MFA-TR*      ,:S-PYMT-POSTED-FL                                                 
MFA-TR*      ,:S-CUST-BANK-SEQ-NO                                               
MFA-TR*      ,:S-STATUS-CODE                                                    
MFA-TR*      ,:S-PMT-CANCEL-REAS-CD                                             
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8001'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04863_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 34110000
       8001-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34110000
      ******************************************************************        
      * 8003A-DEL-GTT-R3.                                              *        
      ******************************************************************        
      *                                                                 11630000
       8003A-DEL-GTT-R3.                                                
      *                                                                 11630000
           EXEC SQL                                                     
               DELETE FROM #CSR04863_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04863_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11630000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11630000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8003A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04863_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       8003A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8003-INSERT-GTT-R3.                                            *        
      ******************************************************************        
      *                                                                         
       8003-INSERT-GTT-R3.                                              
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04863_R3                            
             (                                                          
               RETURN_CODE                                              
              ,BANK_ACCOUNT_NAME                                        
              ,BANK_ACCT_NO                                             
              ,BANK_ACCT_STAT_CD                                        
              ,BANK_ACCT_TYPE_CD                                        
              ,BANK_ID                                                  
              ,CUST_BANK_SEQ_NO                                         
              ,BANK_ACCT_NICKNAME                                       
              ,CUSTOMER_NO                                              
              ,PRIMARY_IND                                              
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-3                                          
             ,:S-BANK-ACCOUNT-NAME-3                                    
             ,:S-BANK-ACCT-NO-3                                         
             ,:S-BANK-ACCT-STAT-CD-3                                    
             ,:S-BANK-ACCT-TYPE-CD-3                                    
             ,:S-BANK-ID-3                                              
             ,:S-CUST-BANK-SEQ-NO-3                                     
             ,:S-BANK-ACCT-NICKNAME-3                                   
             ,:S-CUSTOMER-NO-3                                          
             ,:S-PRIMARY-IND-3                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04863_R3                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,BANK_ACCOUNT_NAME                                                
MFA-TR*       ,BANK_ACCT_NO                                                     
MFA-TR*       ,BANK_ACCT_STAT_CD                                                
MFA-TR*       ,BANK_ACCT_TYPE_CD                                                
MFA-TR*       ,BANK_ID                                                          
MFA-TR*       ,CUST_BANK_SEQ_NO                                                 
MFA-TR*       ,BANK_ACCT_NICKNAME                                               
MFA-TR*       ,CUSTOMER_NO                                                      
MFA-TR*       ,PRIMARY_IND                                                      
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-3                                                  
MFA-TR*      ,:S-BANK-ACCOUNT-NAME-3                                            
MFA-TR*      ,:S-BANK-ACCT-NO-3                                                 
MFA-TR*      ,:S-BANK-ACCT-STAT-CD-3                                            
MFA-TR*      ,:S-BANK-ACCT-TYPE-CD-3                                            
MFA-TR*      ,:S-BANK-ID-3                                                      
MFA-TR*      ,:S-CUST-BANK-SEQ-NO-3                                             
MFA-TR*      ,:S-BANK-ACCT-NICKNAME-3                                           
MFA-TR*      ,:S-CUSTOMER-NO-3                                                  
MFA-TR*      ,:S-PRIMARY-IND-3                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R3             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8003'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04863_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 34110000
       8003-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34110000
      ******************************************************************34120000
      * 8800-CHECK-RESULTS.                                            *34130000
      ******************************************************************34140000
      *                                                                 34150000
       8800-CHECK-RESULTS.                                              
      *                                                                 34170000
           IF CTR-ROWS-R1  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE           
              PERFORM 8001-INSERT-GTT-R1     THRU 8001-EXIT             
           END-IF.                                                      
      *                                                                 34230000
           IF CTR-ROWS-R2  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
           END-IF.                                                      
      *                                                                 36650000
           IF CTR-ROWS-R3  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S-RETURN-CODE-3         
              PERFORM 8003-INSERT-GTT-R3     THRU 8003-EXIT             
           END-IF.                                                      
      *                                                                 34230000
           IF CTR-ROWS-R4  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                       TO S-RETURN-CODE-4         
           END-IF.                                                      
      *                                                                 34230000
           IF CTR-ROWS-R5  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                       TO S-RETURN-CODE-5         
           END-IF.                                                      
      *                                                                 34230000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36680000
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                 36680000
       8900-SEND-DONE.                                                  
      *                                                                 36680000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 34660000
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                               S-RETURN-CODE-4          
                                               S-RETURN-CODE-5.         
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
      *                                                                         
           PERFORM 8001A-DEL-GTT-R1         THRU 8001A-EXIT             
           PERFORM 8001-INSERT-GTT-R1       THRU 8001-EXIT.             
      *                                                                         
           PERFORM 8003A-DEL-GTT-R3         THRU 8003A-EXIT             
           PERFORM 8003-INSERT-GTT-R3       THRU 8003-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT.                
      *                                                                         
           IF CTR-ROWS-R1 < 1 AND CTR-ROWS-R2 < 1 AND                   
              CTR-ROWS-R3 < 1 AND CTR-ROWS-R4 < 1 AND CTR-ROWS-R5 < 1   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           END-IF.                                                      
      *                                                                 36950000
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
