       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04861.                                         
COB303 DATE-WRITTEN.  APRIL 2015.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES CASH LOCAL OFFICE GL DETAILS.        *00190002
      *                                                                *00150000
      *  BUSOP NAME: GETCASHLOCALOFFGLDETAILS                          *        
      ******************************************************************00180000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  04/23/15  AP40911    THIS PROCEDURE WAS WRITTEN TO USE IN CIS *00270002
      *                       MODERNIZATION TO RETRIEVE CASH LOCAL     *        
      *                       OFFICE GL DETAILS.                       *00240000
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04861'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)        VALUE           
           'WORKING STORAGE FOR CSR04861 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
           COPY CWS00303.                                               01700000
           COPY CJF00101.                                               01700000
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26)                        
                                           VALUE 'SESSION.CSR04861_R1'. 
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11)        VALUE           
                                                        'PARM FIELDS'.  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)        COMP            
                                                        VALUE 1.        
           05  CTR-ROWS                PIC S9(9)        COMP            
                                                        VALUE 0.        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)         VALUE           
                                                        'CSR04861'.     
           05  WS-SQLSTATE             PIC X(05).                       
           05  ALL-DONE-SW             PIC X(1)         VALUE 'N'.      
               88 NOT-ALL-DONE                          VALUE 'N'.      
               88 ALL-DONE                              VALUE 'Y'.      
           05  SEND-DONE-SW            PIC X(1)         VALUE 'Y'.      
               88 SEND-DONE-ERROR                       VALUE 'N'.      
               88 SEND-DONE-OK                          VALUE 'Y'.      
                                                                        
                                                                        
       01  WS-GEN-LED-RETURN-DATA.                                      
           05 WS-GEN-LED-ACCT-DETAILS  OCCURS 41 TIMES                  
                                       INDEXED BY WS-GL-INDEX.          
COB305        10 WS-GEN-LED-ACCT-NO        PIC S9(3)V9(4) COMP-3 
COB305           VALUE 0.         
COB305        10 WS-AMOUNT-POSTED        PIC S9(9)V9(2) COMP-3 VALUE 0.         
                                                                        
       01  WS-WORK-FIELDS.                                              
COB305     05 WS-SUB        PIC S9(04) COMP-3 VALUE 0.         
           05 WS-TABLE-LENGTH          PIC S9(04)       COMP-3          
                                                        VALUE 0.        
           05 WS-DRWR-LOW              PIC S9(04)       COMP.           
           05 WS-DRWR-HIGH             PIC S9(04)       COMP.           
           05 WS-JRNL-RETURN-CODE      PIC S9(09)       COMP-4.         
           05 WS-CNTL-RETURN-CODE      PIC S9(09)       COMP-4.         
COB305     05 WS-TEMP-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.         
           05 WS-GL-ACCT-NO-ED         PIC 9(03).9(04).                 
           05 WS-CLEAR-CASH            PIC X(08)        VALUE           
                                                        'CLR-CASH'.     
COB305     05 WS-CLR-CASH-ACCT-NO        PIC S9(03)V9(04) COMP-3 
COB305       VALUE 0.         
           05 WS-PROCESS               PIC X(06).                       
              88 DRAWER-DETAILS                         VALUE 'DRAWER'. 
              88 OFFICE-DETAILS                         VALUE 'OFFICE'. 
           05 WS-CURRENCY-TYPE         PIC X(01).                       
              88 CASH                                   VALUE 'A'.      
              88 CHECK                                  VALUE 'C'.      
              88 MONEY-ORDER                            VALUE 'M'.      
              88 DRAFT                                  VALUE 'D'.      
       01  WS-FLAG-VALUES.                                              
           05 WS-YES                   PIC X(1)         VALUE 'Y'.      
           05 WS-NO                    PIC X(1)         VALUE 'N'.      
           05 WS-GL-ACCT-FLAG          PIC X(1)         VALUE 'N'.      
           05 WS-LIHEAP-PMT            PIC X(1)         VALUE 'N'.      
           05 WS-LIHEAP-RVSL           PIC X(1)         VALUE 'N'.      
           05 WS-FOUND                 PIC X(1)         VALUE 'N'.      
           05 WS-TABLE-LIMIT           PIC S9(2)        VALUE  40.      
                                                                        
       01  FILLER                      PIC X(32)        VALUE           
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(09)       COMP VALUE 0.    
COB305     05 S-GL-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.          
           05  S-GL-ACCT-NAME         PIC X(25).                        
COB305     05 S-TOTAL-GL-AMT        PIC S9(11)V9(02) COMP-3 VALUE 0.          
           05  S-CASH-DRAWER-ID       PIC S9(04)       COMP.            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
           EXEC SQL                                                             
                INCLUDE SQLCA                                           05750000
           END-EXEC.                                                    05760000
                                                                        
      ******************************************************************        
      *    CSS_CSH_DRWR_JRNL  CJ                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE TBCDJRNL                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL  CS                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************        
      *    CSS_LIEAP_AGENCY  I5                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBLIAGCY                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************        
      *    CSS_GL_ACCT_NO  GO                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE TBGLATNO                                        05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_CNTL                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  DRWR_CNTL_CURSOR CURSOR FOR                    
                 SELECT  CASH_DRAWER_ID                                 
                   FROM  CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                
                  WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO        
                    AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE      
                    AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                    AND  CASH_DRAWER_ID BETWEEN                         
                                        :WS-DRWR-LOW AND :WS-DRWR-HIGH  
               ORDER BY  CASH_DRAWER_ID DESC                            
                    FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE  DRWR_CNTL_CURSOR CURSOR FOR                            
MFA-TR*          SELECT  CASH_DRAWER_ID                                         
MFA-TR*            FROM  CSS_CSH_DRWR_CNTL                                      
MFA-TR*           WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                
MFA-TR*             AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE              
MFA-TR*             AND  DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT               
MFA-TR*             AND  CASH_DRAWER_ID BETWEEN                                 
MFA-TR*                                 :WS-DRWR-LOW AND :WS-DRWR-HIGH          
MFA-TR*        ORDER BY  CASH_DRAWER_ID DESC                                    
MFA-TR*             FOR  FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_JRNL                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  DRWR_TRANS_CURSOR CURSOR FOR                   
                 SELECT  CASH_LOCAL_OFFICE,                             
                         CASH_REPORT_NO,                                
                         DATE_CASH_REPORT,                              
                         CASH_DRAWER_ID,                                
                         DATE_TRAN,                                     
                         REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', 
           '.') TRAN_TIME,                                     
                         CURRENCY_TYPE,                                 
                         TRAN_DATA,                                     
                         ENTRY_NO,                                      
                         TRAN_APPL_NO                                   
                   FROM  CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                
                  WHERE  CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO     
                    AND  CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE   
                    AND  DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )    
                    AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID      
                    FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*         DECLARE  DRWR_TRANS_CURSOR CURSOR FOR                   06930000
MFA-TR*          SELECT  CASH_LOCAL_OFFICE,                             06940000
MFA-TR*                  CASH_REPORT_NO,                                        
MFA-TR*                  DATE_CASH_REPORT,                                      
MFA-TR*                  CASH_DRAWER_ID,                                        
MFA-TR*                  DATE_TRAN,                                             
MFA-TR*                  TRAN_TIME,                                             
MFA-TR*                  CURRENCY_TYPE,                                         
MFA-TR*                  TRAN_DATA,                                             
MFA-TR*                  ENTRY_NO,                                              
MFA-TR*                  TRAN_APPL_NO                                           
MFA-TR*            FROM  CSS_CSH_DRWR_JRNL                                      
MFA-TR*           WHERE  CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO             
MFA-TR*             AND  CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE           
MFA-TR*             AND  DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT            
MFA-TR*             AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID              
MFA-TR*             FOR  FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *        CURSOR FOR CSS_LIEAP_AGENCY                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  LIEAP_CURSOR CURSOR FOR                        
                 SELECT  :WS-YES                                        
                   FROM  CSS_LIEAP_AGENCY WITH(READUNCOMMITTED)                 
                  WHERE  GL_ACCT_NO  = :I5-GL-ACCT-NO
            OPTION(FAST 1)
            FOR READ ONLY
            
                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE  LIEAP_CURSOR CURSOR FOR                                
MFA-TR*          SELECT  :WS-YES                                                
MFA-TR*            FROM  CSS_LIEAP_AGENCY                                       
MFA-TR*           WHERE  GL_ACCT_NO  = :I5-GL-ACCT-NO                           
MFA-TR*        OPTIMIZE  FOR 1 ROW                                              
MFA-TR*             FOR  FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-COMPANY-NO         PIC X(02).                           
       01  PARM-CASH-LOCAL-OFFICE  PIC X(03).                           
       01  PARM-DATE-CASH-REPORT   PIC X(10).                           
       01  PARM-CASH-DRAWER-ID     PIC S9(04) COMP.                     
                                                                        
       PROCEDURE DIVISION USING PARM-COMPANY-NO                         
                                PARM-CASH-LOCAL-OFFICE                  
                                PARM-DATE-CASH-REPORT                   
                                PARM-CASH-DRAWER-ID.                    
                                                                        
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      *                                                                *07750000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07760000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07770000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07780000
      *                                                                *07790000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                         TO ACTIVE-PARAGRAPH.     
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE WS-GEN-LED-RETURN-DATA.                           
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT  RETURN_CODE                                      
                      ,GL_ACCT_NO                                       
                      ,LTRIM(RTRIM(GL_ACCT_NAME)) AS GL_ACCT_NAME              
                      ,TOTAL_GL_AMOUNT                                  
                      ,CASH_DRAWER_ID                                   
               FROM                                                     
                   #CSR04861_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,STRIP(GL_ACCT_NAME) AS GL_ACCT_NAME                      
MFA-TR*               ,TOTAL_GL_AMOUNT                                          
MFA-TR*               ,CASH_DRAWER_ID                                           
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04861_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04861_R1'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04861_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04861_R1
              (                                                       
                     RETURN_CODE            INT                     
                    ,GL_ACCT_NO             DECIMAL(7,4)                
                    ,GL_ACCT_NAME CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,TOTAL_GL_AMOUNT        DECIMAL(13,2)               
                    ,CASH_DRAWER_ID         SMALLINT                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS                             
                                              THRU 8000A-EXIT           
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE PROGRAM-NAME       TO ABEND-PROGRAM                
                MOVE SQLCODE            TO ABEND-SQLCODE                
                MOVE SQLSTATE           TO ABEND-SQLSTATE               
                MOVE '0100A'            TO ACTIVE-PARAGRAPH             
                MOVE 'DECLARE GTT'      TO ABEND-FUNCTION               
                MOVE SPACES             TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
                MOVE 'CSR04861_R1'      TO TABLE-1                      
                MOVE SPACES             TO TABLE-ELEMENT-1              
                MOVE SPACES             TO HOSTVAR-ELEMENT-1            
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                                        THRU  9900-EXIT                 
             END-IF                                                     
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************08040000
      * 1000-PROCESS-INPUT.                                            *08050000
      *                                                                *08060000
      *     1. RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
           MOVE PARM-COMPANY-NO                TO CS-CASH-COMPANY-NO,   
                                                  CJ-CASH-COMPANY-NO,   
                                                  GO-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE, 
                                                  CJ-CASH-LOCAL-OFFICE. 
           MOVE PARM-DATE-CASH-REPORT          TO CS-DATE-CASH-REPORT,  
                                                  CJ-DATE-CASH-REPORT.  
           IF  PARM-CASH-DRAWER-ID > 0                                  
               MOVE 'DRAWER'                   TO WS-PROCESS            
               MOVE PARM-CASH-DRAWER-ID        TO WS-DRWR-LOW           
                                                  WS-DRWR-HIGH          
           ELSE                                                         
               MOVE 'OFFICE'                   TO WS-PROCESS            
               MOVE ZERO                       TO WS-DRWR-LOW           
               MOVE 999999                     TO WS-DRWR-HIGH          
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. BUILD RESULT SET                                        *08520000
      *     3. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 2200-PROCESS-OUTPUT         THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2200-PROCESS-OUTPUT                                         *        
      *                                                                *        
      *    1. TO GET THE CLEAR CASH ACCOUNT NO.                        *        
      *    2. CHECK IF IT IS PROCESSING FOR DRAWER OR OFFICE           *        
      ******************************************************************        
       2200-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
           MOVE WS-CLEAR-CASH                  TO GO-GL-ACCT-NAME.      
           PERFORM 7100-GET-ACCT-NUMBER        THRU 7100-EXIT.          
           MOVE GO-GL-ACCT-NO                  TO WS-CLR-CASH-ACCT-NO.  
                                                                        
           IF  DRAWER-DETAILS                                           
               PERFORM 2300-PROCESS-DRAWER      THRU 2300-EXIT          
           ELSE                                                         
               PERFORM 2410-PROCESS-OFFICE-DET  THRU 2410-EXIT          
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2300-PROCESS-DRAWER                                         *        
      *                                                                *        
      *    THIS PARA IS FOR THE DRAWER DETAILS                         *        
      *                                                                *        
      ******************************************************************        
       2300-PROCESS-DRAWER.                                             
                                                                        
           MOVE '2300'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7400-OPEN-CNTL-CURSOR       THRU 7400-EXIT.          
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2310-GET-DRAWER-DETAILS                          
                                               THRU 2310-EXIT           
                       UNTIL WS-CNTL-RETURN-CODE = NOT-FOUND            
           ELSE                                                         
               MOVE 1000                       TO S-RETURN-CODE         
               PERFORM 8100-SEND-RESULT       THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-CNTL-CURSOR      THRU 7420-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2310-GET-DRAWER-DETAILS                                     *        
      *    1. TO GET THE TRANSACTIONS FOR THE BATCH                    *        
      *    2. TO INITIALIZE THE RESULT SET FIELDS AND                  *        
      *       THE GL_ACCT ARRAY.                                       *        
      ******************************************************************        
       2310-GET-DRAWER-DETAILS.                                         
                                                                        
           MOVE '2310'                         TO ACTIVE-PARAGRAPH.     
           MOVE CS-CASH-DRAWER-ID              TO S-CASH-DRAWER-ID.     
                                                                        
           PERFORM 7300-OPEN-JRNL-CURSOR       THRU 7300-EXIT.          
           PERFORM 7310-FETCH-JRNL-CURSOR      THRU 7310-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2500-PROCESS-JRNL       THRU 2500-EXIT           
                       UNTIL WS-JRNL-RETURN-CODE = NOT-FOUND            
               PERFORM 2800-SEND-ALL-GL-ACCTS  THRU 2800-EXIT           
               INITIALIZE WS-GEN-LED-RETURN-DATA                        
                          , WS-TABLE-LENGTH                             
           ELSE                                                         
               MOVE 2000                       TO S-RETURN-CODE         
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7320-CLOSE-JRNL-CURSOR      THRU 7320-EXIT.          
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT.          
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2410-PROCESS-OFFICE-DET                                     *        
      *                                                                *        
      *    TO GET THE BATCHES FOR THE DAY AND LOCAL OFFICE             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2410-PROCESS-OFFICE-DET.                                         
                                                                        
           MOVE '2410'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7400-OPEN-CNTL-CURSOR       THRU 7400-EXIT           
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT           
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2420-GET-TRANS-FOR-CLS-RPT                       
                                               THRU 2420-EXIT           
                           UNTIL WS-CNTL-RETURN-CODE = NOT-FOUND        
                                                                        
               PERFORM 2800-SEND-ALL-GL-ACCTS  THRU 2800-EXIT           
           ELSE                                                         
               MOVE 1000                       TO S-RETURN-CODE         
               PERFORM 8100-SEND-RESULT       THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-CNTL-CURSOR      THRU 7420-EXIT.          
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2420-GET-TRANS-FOR-CLS-RPT                                  *        
      *                                                                *        
      *    TO GET THE TRANSACTIONS FOR A BATCH                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2420-GET-TRANS-FOR-CLS-RPT.                                      
                                                                        
           MOVE '2420'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7300-OPEN-JRNL-CURSOR       THRU 7300-EXIT.          
           PERFORM 7310-FETCH-JRNL-CURSOR      THRU 7310-EXIT.          
           PERFORM 2500-PROCESS-JRNL           THRU 2500-EXIT           
                   UNTIL WS-JRNL-RETURN-CODE = NOT-FOUND                
           PERFORM 7320-CLOSE-JRNL-CURSOR      THRU 7320-EXIT.          
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT.          
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500-PROCESS-JRNL                                           *        
      *                                                                *        
      *    TO DETERMINE WHETHER THE GL_ACCT NO IS DEBIT OR CREDIT      *        
      *                                                                *        
      ******************************************************************        
       2500-PROCESS-JRNL.                                               
                                                                        
           MOVE '2500'                         TO ACTIVE-PARAGRAPH.     
           MOVE CJ-TRAN-DATA                   TO CJF00101.             
           MOVE WS-NO                          TO WS-LIHEAP-RVSL,       
                                                  WS-LIHEAP-PMT,        
                                                  WS-GL-ACCT-FLAG.      
           IF  WS-101-ACCT-GEN-LED-DR = WS-CLR-CASH-ACCT-NO OR          
               WS-101-ACCT-GEN-LED-CR = WS-CLR-CASH-ACCT-NO             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-101-ACCT-GEN-LED-DR     TO I5-GL-ACCT-NO         
               PERFORM 2550-CHECK-GL-NUM       THRU 2550-EXIT           
                                                                        
               IF  WS-GL-ACCT-FLAG = WS-YES                             
                   MOVE WS-YES                 TO WS-LIHEAP-PMT         
               ELSE                                                     
                   MOVE WS-101-ACCT-GEN-LED-CR TO I5-GL-ACCT-NO         
                   PERFORM 2550-CHECK-GL-NUM   THRU 2550-EXIT           
                                                                        
                   IF  WS-GL-ACCT-FLAG = WS-YES                         
                       MOVE WS-YES             TO WS-LIHEAP-RVSL        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 2600-ACCUMULATE-TOTAL-AMOUNT                         
                                               THRU 2600-EXIT.          
           PERFORM 7310-FETCH-JRNL-CURSOR      THRU 7310-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2550-CHECK-GL-NUM                                           *        
      *                                                                *        
      *    TO CHECK WHETHER GL_ACCT_NO IS IN THE CSS_LIEAP_AGENCY      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2550-CHECK-GL-NUM.                                               
                                                                        
           MOVE '2550'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7200-OPEN-LIEAP-CURSOR      THRU 7200-EXIT.          
           PERFORM 7210-FETCH-LIEAP-CURSOR     THRU 7210-EXIT.          
           PERFORM 7220-CLOSE-LIEAP-CURSOR     THRU 7220-EXIT.          
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2600-ACCUMULATE-TOTAL-AMOUNT                                *        
      *                                                                *        
      *    1. TO CHECK IF BOTH THE GL_ACCT_NO ARE SAME                 *        
      *    2. TO GET ALL THE GL_ACCT_NO'S AND THEIR TOTAL AMOUNT       *        
      *    3. TO CHECK FOR THE GL_ACCT ARRAY LIMIT                     *        
      *    4. TO ACCUMULATE THE CASH, CHECK, MONEY ORDER AMOUNT AS THE *        
      *       DEPOSITABLE AMOUNT                                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2600-ACCUMULATE-TOTAL-AMOUNT.                                    
                                                                        
           MOVE '2600'                         TO ACTIVE-PARAGRAPH.     
           IF  WS-101-ACCT-GEN-LED-DR = WS-101-ACCT-GEN-LED-CR          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-101-ACCT-GEN-LED-CR = WS-CLR-CASH-ACCT-NO  OR     
                   WS-LIHEAP-RVSL = WS-YES                              
                   MULTIPLY -1 BY WS-101-AMT-POSTED                     
               END-IF                                                   
                                                                        
               IF  WS-101-ACCT-GEN-LED-CR = WS-CLR-CASH-ACCT-NO         
                   MOVE WS-101-ACCT-GEN-LED-DR TO WS-TEMP-ACCT-NO       
               ELSE                                                     
                   IF  WS-101-ACCT-GEN-LED-DR = WS-CLR-CASH-ACCT-NO     
                       MOVE WS-101-ACCT-GEN-LED-CR                      
                                               TO WS-TEMP-ACCT-NO       
                   ELSE                                                 
                       IF  WS-LIHEAP-PMT EQUAL WS-YES                   
                           MOVE WS-101-ACCT-GEN-LED-CR                  
                                               TO WS-TEMP-ACCT-NO       
                       ELSE                                             
                           IF  WS-LIHEAP-RVSL  EQUAL WS-YES             
                               MOVE WS-101-ACCT-GEN-LED-DR              
                                               TO WS-TEMP-ACCT-NO       
                           ELSE                                         
                               NEXT SENTENCE                            
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
                                                                        
               MOVE WS-NO                      TO WS-FOUND              
               PERFORM VARYING WS-SUB  FROM 1 BY 1 UNTIL                
                               WS-FOUND = WS-YES                        
                                                                        
                   IF  WS-GEN-LED-ACCT-NO(WS-SUB) EQUAL ZEROES          
                       MOVE WS-YES             TO WS-FOUND              
                       MOVE WS-SUB             TO WS-TABLE-LENGTH       
                       MOVE WS-TEMP-ACCT-NO    TO                       
                                   WS-GEN-LED-ACCT-NO(WS-SUB)           
                       MOVE WS-101-AMT-POSTED  TO                       
                                   WS-AMOUNT-POSTED(WS-SUB)             
                   ELSE                                                 
                      IF  WS-GEN-LED-ACCT-NO(WS-SUB) = WS-TEMP-ACCT-NO  
                          MOVE WS-YES          TO WS-FOUND              
                          ADD WS-101-AMT-POSTED                         
                                               TO                       
                              WS-AMOUNT-POSTED(WS-SUB)                  
                      END-IF                                            
                   END-IF                                               
               END-PERFORM                                              
                                                                        
               IF  WS-TABLE-LENGTH     GREATER THAN WS-TABLE-LIMIT      
                   MOVE -1                     TO WS-ACTIVE-RETURN-CODE 
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '2600'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'GL-ACCT-NO ARRAY '    TO TABLE-1               
                   MOVE 'EXCEEDED LIMIT'       TO TABLE-2               
                   MOVE CS-CASH-COMPANY-NO     TO HOSTVAR-ELEMENT-1     
                   MOVE CS-CASH-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-2     
                   MOVE CS-USER-ID             TO HOSTVAR-ELEMENT-3     
                   MOVE CS-DATE-CASH-REPORT    TO HOSTVAR-ELEMENT-4     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
               END-IF                                                   
               MOVE CJ-CURRENCY-TYPE           TO WS-CURRENCY-TYPE      
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2800-SEND-ALL-GL-ACCTS                                      *        
      *                                                                *        
      *    TO SEND ALL THE GL_ACCT_NO 'S WITH ACCT_NAME AND AMOUNT     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2800-SEND-ALL-GL-ACCTS.                                          
                                                                        
           MOVE '2800'                         TO ACTIVE-PARAGRAPH.     
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                           UNTIL WS-SUB > WS-TABLE-LENGTH               
               MOVE WS-GEN-LED-ACCT-NO(WS-SUB) TO GO-GL-ACCT-NO         
               PERFORM 7600-GET-ACCT-NAME      THRU 7600-EXIT           
               MOVE WS-GEN-LED-ACCT-NO(WS-SUB) TO S-GL-ACCT-NO          
               MOVE GO-GL-ACCT-NAME-DESC       TO S-GL-ACCT-NAME        
               MOVE WS-AMOUNT-POSTED(WS-SUB)   TO S-TOTAL-GL-AMT        
               PERFORM 8100-SEND-RESULT       THRU 8100-EXIT            
           END-PERFORM.                                                 
                                                                        
           IF  WS-TABLE-LENGTH EQUAL ZERO                               
               MOVE 2000                       TO S-RETURN-CODE         
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7100-GET-ACCT-NUMBER                                        *        
      *                                                                *        
      *    GET THE CLEAR CASH ACCOUNT NUMBER                           *        
      *                                                                *        
      ******************************************************************        
       7100-GET-ACCT-NUMBER.                                            
                                                                        
           EXEC SQL                                                     
                SELECT  GL_ACCT_NO                                      
                  INTO  :GO-GL-ACCT-NO                                  
                  FROM  CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                    
                 WHERE  COMPANY_NO   = :GO-COMPANY-NO                   
                   AND  GL_ACCT_NAME = :GO-GL-ACCT-NAME                 
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  GL_ACCT_NO                                              
MFA-TR*           INTO  :GO-GL-ACCT-NO                                          
MFA-TR*           FROM  CSS_GL_ACCT_NO                                          
MFA-TR*          WHERE  COMPANY_NO   = :GO-COMPANY-NO                           
MFA-TR*            AND  GL_ACCT_NAME = :GO-GL-ACCT-NAME                         
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE 'GL_ACCT_NAME'             TO TABLE-ELEMENT-2       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE GO-GL-ACCT-NAME            TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7200-OPEN-LIEAP-CURSOR                                      *        
      *                                                                *        
      *    TO OPEN THE LIEAP_CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
       7200-OPEN-LIEAP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN  LIEAP_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7210-FETCH-LIEAP-CURSOR                                     *        
      *                                                                *        
      *    TO FETCH THE LIEAP_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7210-FETCH-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                FETCH  LIEAP_CURSOR                                     
                 INTO  :WS-GL-ACCT-FLAG                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7210'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7220-CLOSE-LIEAP-CURSOR                                     *        
      *                                                                *        
      *    TO CLOSE THE LIEAP_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7220-CLOSE-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE  LIEAP_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7220'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7300-OPEN-JRNL-CURSOR                                       *        
      *                                                                *        
      *    TO OPEN DRWR_TRANS_CURSOR CURSOR FOR CSS_CSH_DRWR_JRNL      *        
      *                                                                *        
      ******************************************************************        
       7300-OPEN-JRNL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_TRANS_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7310-FETCH-JRNL-CURSOR                                      *        
      *                                                                *        
      *    TO FETCH DRWR_TRANS_CURSOR                                  *        
      *                                                                *        
      ******************************************************************        
       7310-FETCH-JRNL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_TRANS_CURSOR                                
                 INTO  :CJ-CASH-LOCAL-OFFICE,                           
                       :CJ-CASH-REPORT-NO,                              
                       :CJ-DATE-CASH-REPORT,                            
                       :CJ-CASH-DRAWER-ID,                              
                       :CJ-DATE-TRAN,                                   
                       :CJ-TRAN-TIME,                                   
                       :CJ-CURRENCY-TYPE,                               
                       :CJ-TRAN-DATA,                                   
                       :CJ-ENTRY-NO,                                    
                       :CJ-TRAN-APPL-NO                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  WS-JRNL-RETURN-CODE,  
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7310'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7320-CLOSE-JRNL-CURSOR                                      *        
      *                                                                *        
      *    TO CLOSE THE DRWR_ALL-CURSOR                                *        
      *                                                                *        
      ******************************************************************        
       7320-CLOSE-JRNL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_TRANS_CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7320'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7400-OPEN-CNTL-CURSOR                                       *        
      *                                                                *        
      *    TO OPEN DRWR_CNTL_CURSOR CURSOR FOR CSS_CSH_DRWR_CNTL       *        
      *                                                                *        
      ******************************************************************        
       7400-OPEN-CNTL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_CNTL_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7410-FETCH-CNTL-CURSOR                                      *        
      *                                                                *        
      *    TO FETCH DRWR_CNTL_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7410-FETCH-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_CNTL_CURSOR                                 
                 INTO :CS-CASH-DRAWER-ID                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH  DRWR_CNTL_CURSOR                                         
MFA-TR*          INTO  :CS-CASH-DRAWER-ID,                                      
MFA-TR*                :CS-AMT-BASIC-WORK,                                      
MFA-TR*                :CS-CODE-CSH-DRWR-STAT                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  WS-CNTL-RETURN-CODE,  
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
               ELSE                                                     
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7410'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE SPACES                 TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                   MOVE 'CSS_CSH_DRWR_CNTL'    TO TABLE-1               
                   MOVE 'CASH_COMPANY_NO'      TO TABLE-ELEMENT-1       
                   MOVE 'CASH_LOCAL_OFFICE'    TO TABLE-ELEMENT-2       
                   MOVE 'USER_ID'              TO TABLE-ELEMENT-3       
                   MOVE 'DATE_CASH_REPORT'     TO TABLE-ELEMENT-4       
                   MOVE CS-CASH-COMPANY-NO     TO HOSTVAR-ELEMENT-1     
                   MOVE CS-CASH-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-2     
                   MOVE CS-USER-ID             TO HOSTVAR-ELEMENT-3     
                   MOVE CS-DATE-CASH-REPORT    TO HOSTVAR-ELEMENT-4     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7420-CLOSE-CNTL-CURSOR                                      *        
      *                                                                *        
      *    TO CLOSE DRWR_CNTL_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7420-CLOSE-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_CNTL_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                   S-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7420'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7600-GET-ACCT-NAME                                          *        
      *                                                                *        
      *    TO GET THE GL_ACCT_NAME FOR CORRESPONDING GL_ACCT_NO        *        
      *                                                                *        
      ******************************************************************        
       7600-GET-ACCT-NAME.                                              
                                                                        
           EXEC SQL                                                     
                SELECT  GL.GL_ACCT_NAME_DESC                            
                  INTO  :GO-GL-ACCT-NAME-DESC                           
                  FROM  CSS_GL_ACCT_NO   GL WITH(READUNCOMMITTED)               
                 WHERE  GL.COMPANY_NO    = :GO-COMPANY-NO               
                   AND  GL.GL_ACCT_NO    = :GO-GL-ACCT-NO               
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  GL.GL_ACCT_NAME_DESC                                    
MFA-TR*           INTO  :GO-GL-ACCT-NAME-DESC                                   
MFA-TR*           FROM  CSS_GL_ACCT_NO   GL                                     
MFA-TR*          WHERE  GL.COMPANY_NO    = :GO-COMPANY-NO                       
MFA-TR*            AND  GL.GL_ACCT_NO    = :GO-GL-ACCT-NO                       
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'CSS_GL_ACCT_NAME'         TO TABLE-2               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-2       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE GO-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS                                          *        
      ******************************************************************        
        8000A-DELETE-GTT-ROWS.                                          
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04861_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04861_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04861_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
        8000A-EXIT.                                                     
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                              *         
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04861_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,GL_ACCT_NO                                          
                   ,GL_ACCT_NAME                                        
                   ,TOTAL_GL_AMOUNT                                     
                   ,CASH_DRAWER_ID                                      
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE                                      
                   ,:S-GL-ACCT-NO                                       
                   ,:S-GL-ACCT-NAME                                     
                   ,:S-TOTAL-GL-AMT                                     
                   ,:S-CASH-DRAWER-ID                                   
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04861_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,GL_ACCT_NO                                                  
MFA-TR*            ,GL_ACCT_NAME                                                
MFA-TR*            ,TOTAL_GL_AMOUNT                                             
MFA-TR*            ,CASH_DRAWER_ID                                              
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-GL-ACCT-NO                                               
MFA-TR*            ,:S-GL-ACCT-NAME                                             
MFA-TR*            ,:S-TOTAL-GL-AMT                                             
MFA-TR*            ,:S-CASH-DRAWER-ID                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO CTR-ROWS                     
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04861_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CPD0023C                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
