       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04860.                                         
COB303 DATE-WRITTEN.  APRIL 06, 2015.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00110000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM UPDATES THE CASH REPORT HEADER TABLE FOR CLOSING *00210000
      *  THE OFFICE.                                                   *00220000
      *                                                                *        
      *  BUSOP NAME: UPDCLOSECASHLOCALOFFICEBUSINESSOP                 *        
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
PRJ586*  04/06/15  AP40911    THIS PROCEDURE WAS WRITTEN TO USE IN CIS *00270002
      *                       MODERNIZATION TO CLOSE CASH LOCAL OFFICE.*        
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04860'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)       VALUE            
           'WORKING STORAGE FOR CSR04860 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
           COPY CWS00303.                                               01700000
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
              END-EXEC.                                                         
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
       01  FILLER                      PIC X(11)        VALUE           
                                                        'PARM FIELDS'.  
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9)        COMP            
                                                        VALUE 0.        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)        VALUE           
                                                        'CSR04860'.     
           05  WS-SQLSTATE             PIC X(05)        VALUE SPACES.   
           05  SEND-DONE-SW            PIC X(01)        VALUE 'Y'.      
               88 SEND-DONE-ERROR                       VALUE 'N'.      
               88 SEND-DONE-OK                          VALUE 'Y'.      
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-BATCH-STATUS-FLAG     PIC X(1)         VALUE 'N'.      
           05 WS-REPORT-STATUS-FLAG    PIC X(1)         VALUE 'N'.      
           05 WS-YES                   PIC X(1)         VALUE 'Y'.      
           05 WS-ACTIVE                PIC X(1)         VALUE 'A'.      
           05 WS-CLOSED                PIC X(1)         VALUE 'C'.      
                                                                        
       01  FILLER                      PIC X(32)        VALUE           
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(009) COMP VALUE +0.       
                                                                        
       01 CSRERLOG-P.                                                   
            10 S-SP-NAME           PIC X(18) VALUE SPACES.              
            10 S-SQLCODE           PIC S9(9) COMP VALUE 0.              
            10 S-SQLSTATE          PIC X(5)  VALUE ' '.                 
            10 S-TABLE-NAME        PIC X(18) VALUE SPACES.              
            10 S-HOST-VAIABLES.                                         
               49 S-HOST-VARIABLES-L PIC S9(4) USAGE COMP.              
               49 S-HOST-VARIABLES-V PIC X(255).                        
            10 S-SQL-STATEMENT.                                         
               49 S-SQL-STATEMENT-L  PIC S9(4) USAGE COMP.              
               49 S-SQL-STATEMENT-V  PIC X(255).                        
            10 S-SQL-DESCRIPTION.                                       
               49 S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.             
               49 S-SQL-DESCRIPTION-V PIC X(255).                       
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
           EXEC SQL                                                             
                INCLUDE SQLCA                                           05750000
           END-EXEC.                                                    05760000
                                                                        
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL  CS                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************05890000
      *    CSS_CSH_REPORT_HDR  YR                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSRPHD                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************02430037
      *    CSS_AR_LOCKOUT     AL                                       *02440037
      ******************************************************************02450037
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************05890000
      *    CURSOR FOR CSS_CSH_DRWR_CNTL                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  DRWR_CNTL_CURSOR CURSOR FOR                    
                 SELECT  :WS-YES                                        
                   FROM  CSS_CSH_DRWR_CNTL                              
                  WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO      
                    AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE    
                    AND  DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )     
                    AND  CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT   
               OPTION(FAST 1)                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ021
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE  DRWR_CNTL_CURSOR CURSOR FOR                            
MFA-TR*          SELECT  :WS-YES                                                
MFA-TR*            FROM  CSS_CSH_DRWR_CNTL                                      
MFA-TR*           WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO              
MFA-TR*             AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE            
MFA-TR*             AND  DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT             
MFA-TR*             AND  CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT           
MFA-TR*        OPTIMIZE  FOR 1 ROW                                              
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
       LINKAGE SECTION.                                                 
       01 PARM-COMPANY-NO         PIC X(02).                            
       01 PARM-CASH-LOCAL-OFFICE  PIC X(03).                            
       01 PARM-DATE-CASH-REPORT   PIC X(10).                            
       01 PARM-USER-ID            PIC X(07).                            
       PROCEDURE DIVISION USING   PARM-COMPANY-NO                       
                                  PARM-CASH-LOCAL-OFFICE                
                                  PARM-DATE-CASH-REPORT                 
                                  PARM-USER-ID.                         
                                                                        
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      *                                                                *07750000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                         TO ACTIVE-PARAGRAPH.     
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                FROM                                                    
                    #CSR04860_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04860_R1                                         
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************2530000 
      *  0100A-DECLARE-GTT.                                            *02540000
      ******************************************************************2890000 
       0100A-DECLARE-GTT.                                               
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04860_R1'            
                                       TO S-SQL-STATEMENT-V.            
     *                                                                  
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04860_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04860_R1
              (                                                       
                   RETURN_CODE              INT                     
                  ,APPL_RETURN_CODE         INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-SQLSTATE = '42710'                                     
                  PERFORM 8000A-DELETE-GTT-ROWS                         
                                             THRU 8000A-EXIT            
           ELSE                                                         
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     NEXT SENTENCE                                      
                  ELSE                                                  
                     MOVE PROGRAM-NAME       TO ABEND-PROGRAM           
                     MOVE SQLCODE            TO ABEND-SQLCODE           
                     MOVE SQLSTATE           TO ABEND-SQLSTATE          
                     MOVE '0100A'            TO ACTIVE-PARAGRAPH        
                     MOVE 'DECLARE GTT'      TO ABEND-FUNCTION          
                     MOVE SPACES             TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                     MOVE 'CSR04860_R1'      TO TABLE-1                 
                     MOVE SPACES             TO TABLE-ELEMENT-1         
                     MOVE SPACES             TO HOSTVAR-ELEMENT-1       
                     PERFORM 9900-SQL-ERROR-ROUTINE                     
                                                    THRU  9900-EXIT     
                  END-IF                                                
           END-IF.                                                      
     *                                                                  
         0100A-EXIT.                                                    
              EXIT.                                                     
     *                                                                  
      ******************************************************************08040000
      * 1000-PROCESS-INPUT.                                            *08050000
      *                                                                *08060000
      *     1. RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
           MOVE PARM-COMPANY-NO                TO CS-CASH-COMPANY-NO,   
                                                  YR-CASH-COMPANY-NO.   
           MOVE PARM-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE, 
                                                  YR-CASH-LOCAL-OFFICE. 
           MOVE PARM-DATE-CASH-REPORT          TO CS-DATE-CASH-REPORT,  
                                                  YR-DATE-CASH-REPORT.  
           MOVE PARM-USER-ID                   TO CS-USER-ID,           
                                                  YR-USER-ID.           
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. UPDATE DB2 DATA                                         *08510000
      *     3. BUILD RESULT SET                                        *08520000
      *     4. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7999-SELECT-AL               THRU                    
                                                7999-SELECT-AL-EXIT.    
           IF  AL-AR-LOCKOUT-IND = WS-YES                               
               MOVE 5000                        TO S-APPL-RETURN-CODE   
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
           PERFORM 2200-PROCESS-DETAIL          THRU 2200-EXIT.         
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2200-PROCESS-DETAIL                                         *        
      *                                                                *        
      *    1. CHECK IF ANY OF BATCHES.                                 *        
      *    2. IF NO BATCH FOR THE DATE IS OPEN CLOSE THE REPROT        *        
      *       FOR THE DATE WITH THE CURRENT TIMESTAMP AND THE USER.    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-DETAIL.                                             
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
           MOVE WS-ACTIVE                      TO CS-CODE-CSH-DRWR-STAT,
                                                  YR-STATUS.            
           PERFORM 7000-OPEN-DRWR-CNTL-CURSOR  THRU 7000-EXIT.          
           PERFORM 7010-FETCH-DRWR-CNTL-CURSOR THRU 7010-EXIT.          
                                                                        
           IF  WS-BATCH-STATUS-FLAG EQUAL WS-YES                        
               MOVE 1000                       TO S-APPL-RETURN-CODE    
           ELSE                                                         
               PERFORM 7200-CK-REPORT-STATUS   THRU 7200-EXIT           
               IF  WS-REPORT-STATUS-FLAG EQUAL WS-YES                   
                   MOVE WS-CLOSED              TO YR-STATUS             
                   PERFORM 7300-CLOSE-REPORT   THRU 7300-EXIT           
               ELSE                                                     
                   MOVE 2000                   TO S-APPL-RETURN-CODE    
               END-IF                                                   
           END-IF.                                                      
                                                                        
           ADD +1                            TO CTR-ROWS.               
           PERFORM 7020-CLOSE-DRWR-CNTL-CURSOR THRU 7020-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7000-OPEN-DRWR-CNTL-CURSOR                                  *        
      *                                                                *        
      *    TO OPEN THE DRWR_CNTL_CURSOR                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-OPEN-DRWR-CNTL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_CNTL_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7010-FETCH-DRWR-CNTL-CURSOR                                 *        
      *                                                                *        
      *    TO FETCH THE DRWR_CNTL_CURSOR                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7010-FETCH-DRWR-CNTL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_CNTL_CURSOR                                 
                 INTO  :WS-BATCH-STATUS-FLAG                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7010'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7020-CLOSE-DRWR-CNTL-CURSOR                                 *        
      *                                                                *        
      *    TO CLOSE THE DRWR_CNTL_CURSOR                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7020-CLOSE-DRWR-CNTL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_CNTL_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7200-CK-REPORT-STATUS                                       *        
      *                                                                *        
      *    TO CHECK THE REPORT STATUS.                                 *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-CK-REPORT-STATUS.                                           
                                                                        
           EXEC SQL                                                     
                SELECT  :WS-YES                                         
                  INTO  :WS-REPORT-STATUS-FLAG                          
                  FROM  CSS_CSH_REPORT_HDR                              
                 WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )        
                   AND  STATUS            = :YR-STATUS                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  :WS-YES                                                 
MFA-TR*           INTO  :WS-REPORT-STATUS-FLAG                                  
MFA-TR*           FROM  CSS_CSH_REPORT_HDR                                      
MFA-TR*          WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :YR-DATE-CASH-REPORT                
MFA-TR*            AND  STATUS            = :YR-STATUS                          
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_REPORT_HDR'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'STATUS'                   TO TABLE-ELEMENT-4       
               MOVE YR-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YR-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YR-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YR-STATUS                  TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7300-CLOSE-REPORT                                           *        
      *                                                                *        
      *    TO CLOSE THE REPORT                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7300-CLOSE-REPORT.                                               
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_CSH_REPORT_HDR                              
                   SET  STATUS     = :YR-STATUS                         
                       ,CLOSED_TS  = CIS.CURRENT$TIMESTAMP()                  
                       ,USER_ID    = :YR-USER-ID                        
                 WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_CSH_REPORT_HDR                                      
MFA-TR*            SET  STATUS     = :YR-STATUS                                 
MFA-TR*                ,CLOSED_TS  = CURRENT TIMESTAMP                          
MFA-TR*                ,USER_ID    = :YR-USER-ID                                
MFA-TR*          WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :YR-DATE-CASH-REPORT                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  S-RETURN-CODE.        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'UPDATE'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_REPORT_HDR'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE YR-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YR-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YR-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7999-SELECT-AL                                                 *        
      ******************************************************************        
              EXEC SQL                                                          
                 INCLUDE CPD00075                                               
              END-EXEC.                                                         
                                                                        
      ******************************************************************12310000
      * 8000A-DELETE-GTT-ROWS.                                         *12320000
      ******************************************************************12330000
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                DELETE FROM #CSR04860_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04860_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE '8000A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                                ABEND-TABLES            
               MOVE 'CSR04860_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
     *                                                                  
      ******************************************************************12310000
      * 8100-SEND-RESULT.                                               12320000
      ******************************************************************12330000
       8100-SEND-RESULT.                                                
     *                                                                  
           EXEC SQL                                                     
                INSERT INTO #CSR04860_R1                         
                (                                                       
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                )                                                       
                VALUES                                                  
                (                                                       
                      :S-RETURN-CODE                                    
                     ,:S-APPL-RETURN-CODE                               
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04860_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-APPL-RETURN-CODE                                       
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04860_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************42800000
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                     01720000
                INCLUDE CPD0023C                                        01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
