       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04859.                                      
COB303 DATE-WRITTEN.     APR  10, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS NEW UPDATE IS TO USE IN CIS MOD WHITE CROSS PLUS UPDATE  *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PRJ793*  04/08/15  VK7L032    CLONE OF CSR03828                        *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04859'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04859 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WO - CSS_WH_CROSS_PLUS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWCPLUS                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WP - CSS_WH_CROSS_PATNT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWCPPAT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WJ - CSS_WH_CROSS_SSN                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWCPSSN                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DQ - CSS_NAME                                                  *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * MH - CSS_MNT_TRANS_HIST                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * MH - CSS_MT_TRN_HST_DET                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CL - CSS_CRED_COLL                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * C8 - CSS_DELINQUENCY                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * AT - CSS_ACCOUNT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * I8 - CSS_ADDR_ID_CNTL                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * I7 - CSS_NAME_ID_CNTL                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * I6 - CSS_CNTCT_ID_CNTL                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTCID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * PF - CSS_USER_PROFILE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * WH - CSS_ACCT_WHT_CROSS                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWCACCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ********* COMMON SYSTEM AREA *************************************        
           COPY CCA00001.                                                       
                                                                        
      ******* WS FOR 6010-REDUCE-EMBEDDED SPACES ***********************        
       COPY CWS00011.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0090A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0092A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0013A                                                  
           END-EXEC.                                                            
                                                                        
      ********** ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS ********        
           COPY CWS00027.                                                       
                                                                        
      ********** SUPPORTS DB2 AND SQL ERROR CHECKING *******************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05 WS-FAILED                PIC X(01)  VALUE 'F'.            
           05 WS-SSN                   PIC X(09)  VALUE SPACES.         
           05 WS-APPLICATION-ID        PIC Z(08)9 VALUE SPACES.         
           05 WS-ADDRESS-ID            PIC S9(13)V COMP-3 VALUE 0.      
           05 WS-NEW-CRIT-OUTAGE       PIC X(02)  VALUE SPACES.         
           05 WS-PATIENT-NAME-UPDT     PIC X(01)  VALUE 'N'.            
              88 PATIENT-NAME-UPDT                VALUE 'Y'.            
           05 WS-PTNT-UPDT             PIC X(01)  VALUE 'N'.            
              88 PTNT-UPDT                        VALUE 'Y'.            
           05 WS-WCP-UPDT              PIC X(01)  VALUE 'N'.            
              88 WH-CR-PL-UPDT                    VALUE 'Y'.            
           05 WS-PTNT-SSN-UPDT         PIC X(01)  VALUE 'N'.            
              88 PTNT-SSN-UPDT                    VALUE 'Y'.            
           05 WS-STATUS-UPDT           PIC X(01)  VALUE 'N'.            
              88 STATUS-UPDT                      VALUE 'Y'.            
           05 WS-WHITE-CROSS-FLAG      PIC X(01)  VALUE 'N'.            
              88 WS-WC-EXISTS                     VALUE 'Y'.            
           05 WS-WCP-FLAG              PIC X(01)  VALUE 'N'.            
              88 WS-WCP-EXISTS                    VALUE 'Y'.            
           05 WS-DELETE-DNP-FL         PIC X(01)  VALUE 'N'.            
           05 WS-END-OF-ROWS           PIC X(01)  VALUE 'N'.            
              88 END-OF-ROWS                      VALUE 'Y'.            
COB305     05 WS-NAME-ID        PIC S9(13)V COMP-3 VALUE 0.              
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
           05 WS-COMMENTS              PIC X(255).                      
           05 WS-SELECT-RETURN-CODE    PIC S9(9) COMP.                  
           05 WS-NULL-IND-EFF          PIC S9(4) COMP  VALUE 0.         
           05 WS-NULL-IND-EXP          PIC S9(4) COMP  VALUE 0.         
           05 WS-NULL-IND-DOB          PIC S9(4) COMP  VALUE 0.         
           05 PROGRAM-NAME             PIC X(08)       VALUE 'CSR04859'.
           05 WS-SQLSTATE              PIC X(5).                        
           05 WS-PTNT-SUFFIX           PIC X(03)  VALUE SPACES.         
           05 WS-PTNT-PREFIX           PIC X(09)  VALUE SPACES.         
           05 WS-PTNT-FIRST-NAME       PIC X(15)  VALUE SPACES.         
           05 WS-PTNT-MIDDLE-NAME      PIC X(15)  VALUE SPACES.         
           05 WS-PTNT-LAST-NAME        PIC X(40)  VALUE SPACES.         
           05 WS-NAME-TYPE             PIC X(02)  VALUE SPACES.         
           05 WS-FULL-NAME             PIC X(50)  VALUE SPACES.         
           05 WS-EXPIRATION-DT         PIC X(10)  VALUE SPACES.         
           05 WS-NO-OF-DAYS            PIC S9(4)  COMP VALUE ZEROS.     
           05 WS-STATUS-CD             PIC X(01)  VALUE SPACES.         
                                                                        
       01  WS-MNT-TRANS-HIST.                                           
           05 WS-USERID                PIC X(08)  VALUE SPACES.         
           05 WS-DELINQUENCY-DT        PIC X(10)  VALUE SPACES.         
           05 WS-CURRENT-DATE          PIC X(10)  VALUE SPACES.         
           05 WS-CURRENT-TIMESTAMP     PIC X(26)  VALUE SPACES.         
           05 WS-ACCOUNT-EXISTS        PIC X(01)  VALUE 'N'.            
           05 WS-TRANS-COMMENTS        PIC X(210) VALUE SPACES.         
           05 WS-TRANS-COMMENTS-LEN    PIC S9(4)  VALUE 0 COMP.         
           05 WS-RESP-AREA-ID          PIC X(03)  VALUE SPACES.         
COB305     05 WS-CUSTOMER-NO-COMP        PIC S9(10) COMP-3 VALUE 0.             
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10) COMP-3 VALUE 0.              
           05 WS-APPEND-COMMENT        PIC X(84)  VALUE SPACES.         
           05 WS-APPEND-COMMENT-LEN    PIC S9(4)  VALUE 0 COMP.         
           05 WS-INSERT-COMMENT        PIC X(24)  VALUE                 
              'WHITE CROSS PLUS ADDED.!'.                               
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05 WS-CODE-TRAN-TYPE        PIC X(01)  VALUE 'F'.            
           05 WS-TRAN-APPL-NO          PIC S9(02) VALUE 0.              
           05 WS-TABLE-ID              PIC X(02).                       
           05 WS-COLUMN-DESC           PIC X(15).                       
           05 WS-CHG-COLUMN-VALUE-TEXT PIC X(75).                       
           05 WS-CHG-COLUMN-VALUE-LEN  PIC S9(04) COMP VALUE 0.         
           05 WS-PRV-COLUMN-VALUE-TEXT PIC X(75).                       
           05 WS-PRV-COLUMN-VALUE-LEN  PIC S9(04) COMP VALUE 0.         
                                                                        
       01  WS-LITERALS.                                                 
           05 WS-I                     PIC X(01)  VALUE 'I'.            
           05 WS-A                     PIC X(01)  VALUE 'A'.            
           05 WS-U                     PIC X(01)  VALUE 'U'.            
           05 WS-D                     PIC X(01)  VALUE 'D'.            
           05 WS-YES                   PIC X(01)  VALUE 'Y'.            
           05 WS-NO                    PIC X(01)  VALUE 'N'.            
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW              PIC X(01)  VALUE 'N'.            
              88 NOT-ALL-DONE                     VALUE 'N'.            
              88 ALL-DONE                         VALUE 'Y'.            
           05 SEND-DONE-SW             PIC X(01)  VALUE 'Y'.            
              88 SEND-DONE-ERROR                  VALUE 'N'.            
              88 SEND-DONE-OK                     VALUE 'Y'.            
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9)  COMP VALUE 0.         
           05 S-BUS-RULE-ID            PIC X(10)  VALUE SPACES.         
           05 S-BUS-RULE-RESULT-CD     PIC X(08)  VALUE SPACES.         
           05 S-BUS-RULE-XREF-ID       PIC X(26)  VALUE SPACES.         
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05 GTT-NAME                PIC X(26)                        
                                       VALUE 'SESSION.CSR04859_R1'.     
            05 GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
            05 GTT-SQLCODE             PIC S9(9)  COMP.                 
       01  FILLER                      PIC X(11)  VALUE 'PARM FIELDS'.  
                                                                        
       01  SNA-FIELDS.                                                  
           05 SNA-SUBC                 PIC S9(9) COMP.                  
           05 SNA-CONNECTION-NAME      PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-COLUMN               PIC S9(9) COMP VALUE 1.          
           05 CTR-ROWS                 PIC S9(9) COMP VALUE 0.          
           05 WS-ROW-COUNT             PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05 MAX-LENGTH-PARM          PIC S9(9) COMP.                  
           05 WRKLEN1                  PIC S9(9) COMP.                  
           05 WRKLEN2                  PIC S9(9) COMP.                  
           05 WRK-DONE-STATUS          PIC S9(9) COMP.                  
                                                                        
       01  FILLER PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.       
                                                                        
       01  WS-HOLD-DATE.                                                
           05 WS-HOLD-DATE-YY          PIC X(04).                       
           05 FILLER                   PIC X(01).                       
           05 WS-HOLD-DATE-MM          PIC X(02).                       
           05 FILLER                   PIC X(01).                       
           05 WS-HOLD-DATE-DD          PIC X(02).                       
                                                                        
       01  WS-WORK-DATE.                                                
           05 WS-WORK-DATE-MM          PIC X(02).                       
           05 FILLER                   PIC X(01) VALUE '/'.             
           05 WS-WORK-DATE-DD          PIC X(02).                       
           05 FILLER                   PIC X(01) VALUE '/'.             
           05 WS-WORK-DATE-YY          PIC X(04).                       
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE           PIC S9(9) COMP VALUE +0.         
      *                                                                         
       01  CN-CONSTANTS.                                                
           05 CN-DELIMITER             PIC X      VALUE ';'.            
           05 CN-ASTERISK              PIC X      VALUE '*'.            
       01  CSRERLOG-P.                                                  
           10 S-SP-NAME                PIC X(18)  VALUE SPACES.         
           10 S-SQLCODE                PIC S9(9)  COMP VALUE 0.         
           10 S-SQLSTATE               PIC X(5)   VALUE ' '.            
           10 S-TABLE-NAME             PIC X(18)  VALUE SPACES.         
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L    PIC S9(4)  USAGE COMP.           
              49 S-HOST-VARIABLES-V    PIC X(255).                      
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L     PIC S9(4)  USAGE COMP.           
              49 S-SQL-STATEMENT-V     PIC X(255).                      
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L   PIC S9(4)  USAGE COMP.           
              49 S-SQL-DESCRIPTION-V   PIC X(255).                      
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *       CURSOR DECLARATION FOR CSS_CRED_COLL                     *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE DNP_CSR CURSOR FOR                                
               SELECT CODE_NOTICE_TYPE                                  
                     ,DATE_CREDIT_ACTION                                
                 FROM CSS_CRED_COLL                                     
                WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                       
                  AND CODE_NOTICE_TYPE IN ('D','G','H','I')             
                  AND (DATE_CREDIT_ACTION BETWEEN IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )      
                                              AND IIF(TRY_CONVERT(DATE, 
                                                     :WS-DELINQUENCY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-DELINQUENCY-DT
              ) <> 0) OR (LEN(:WS-DELINQUENCY-DT
              ) <> 10), CIS.CHAR2DATE(:WS-DELINQUENCY-DT
              ), CONVERT(DATE, :WS-DELINQUENCY-DT) ))   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DNP_CSR CURSOR FOR                                        
MFA-TR*        SELECT CODE_NOTICE_TYPE                                          
MFA-TR*              ,DATE_CREDIT_ACTION                                        
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                               
MFA-TR*           AND CODE_NOTICE_TYPE IN ('D','G','H','I')                     
MFA-TR*           AND (DATE_CREDIT_ACTION BETWEEN :WS-CURRENT-DATE              
MFA-TR*                                       AND :WS-DELINQUENCY-DT)           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
       01 I-UPDATE-FL                  PIC X(01).                       
       01 I-APPLICATION-ID             PIC S9(9) USAGE COMP.            
       01 I-STATUS-CD                  PIC X(01).                       
       01 I-PTNT-SSN                   PIC X(09).                       
       01 I-PTNT-DOB                   PIC X(10).                       
       01 I-PTNT-PHONE                 PIC X(10).                       
       01 I-RELATIONSHIP               PIC X(15).                       
COB305 01 I-PTNT-NAME-ID        PIC S9(13)V COMP-3 VALUE 0.              
       01 I-PTNT-PREFIX                PIC X(09).                       
       01 I-PTNT-FIRST-NAME            PIC X(15).                       
       01 I-PTNT-MIDDLE-NAME           PIC X(15).                       
       01 I-PTNT-LAST-NAME             PIC X(40).                       
       01 I-PTNT-SUFFIX                PIC X(03).                       
       01 I-MED-COND-DESC              PIC X(100).                      
       01 I-MED-COND-DESC-LEN          PIC S9(04) COMP.                 
       01 I-DURATION-MONTH             PIC S9(9) USAGE COMP.            
       01 I-MED-COND-CODE              PIC X(02).                       
       01 I-AMBULANCE-FL               PIC X(01).                       
       01 I-PTNT-ASSIST-FL             PIC X(01).                       
       01 I-EFFECTIVE-DT               PIC X(10).                       
       01 I-COMMENT                    PIC X(255).                      
       01 I-COMMENT-LEN                PIC S9(04) COMP.                 
       01 I-TRANS-COMMENTS             PIC X(210).                      
       01 I-TRANS-COMMENTS-LEN         PIC S9(04) COMP.                 
COB305 01 I-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
       01 I-PHYSICIAN-ID               PIC S9(9)   USAGE COMP.          
       01 I-USER-ID                    PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING                                         
                    I-ACCOUNT-NO                                        
                  , I-UPDATE-FL                                         
                  , I-APPLICATION-ID                                    
                  , I-STATUS-CD                                         
                  , I-PTNT-SSN                                          
                  , I-PTNT-DOB                                          
                  , I-PTNT-PHONE                                        
                  , I-RELATIONSHIP                                      
                  , I-PTNT-NAME-ID                                      
                  , I-PTNT-PREFIX                                       
                  , I-PTNT-FIRST-NAME                                   
                  , I-PTNT-MIDDLE-NAME                                  
                  , I-PTNT-LAST-NAME                                    
                  , I-PTNT-SUFFIX                                       
                  , I-MED-COND-DESC                                     
                  , I-MED-COND-DESC-LEN                                 
                  , I-DURATION-MONTH                                    
                  , I-MED-COND-CODE                                     
                  , I-AMBULANCE-FL                                      
                  , I-PTNT-ASSIST-FL                                    
                  , I-EFFECTIVE-DT                                      
                  , I-COMMENT                                           
                  , I-COMMENT-LEN                                       
                  , I-TRANS-COMMENTS                                    
                  , I-TRANS-COMMENTS-LEN                                
                  , I-ADDRESS-ID                                        
                  , I-PHYSICIAN-ID                                      
                  , I-USER-ID                                           
                  .                                                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
                                                                        
           IF  STATUS-UPDT                                              
           OR (I-STATUS-CD = WS-A AND I-UPDATE-FL = WS-I)               
              PERFORM 2300-MISCELLANEOUS-UPDATE                         
                                               THRU 2300-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   0100-ITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE     DCLCSS-WH-CROSS-PLUS                          
                          DCLCSS-WH-CROSS-PATNT                         
                          DCLCSS-WH-CROSS-SSN                           
                          DCLCSS-NAME.                                  
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  0100A-DECLARE-GTT                                             *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04859_R1'       TO GTT-NAME.                
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04859_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04859_R1
              (                                                       
                    RETURN_CODE        INT                          
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,BUS_RULE_RESULT_CD                               
                      ,BUS_RULE_ID                                      
                      ,BUS_RULE_XREF_ID                                 
                  FROM #CSR04859_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,BUS_RULE_RESULT_CD                                       
MFA-TR*               ,BUS_RULE_ID                                              
MFA-TR*               ,BUS_RULE_XREF_ID                                         
MFA-TR*           FROM SESSION.CSR04859_R1                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE  I-ACCOUNT-NO               TO WS-ACCOUNT-NO            
           MOVE  I-USER-ID                  TO WS-USERID                
                                                                        
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT           
                                                                        
           IF  I-EFFECTIVE-DT > SPACES                                  
           AND I-DURATION-MONTH > 0                                     
                                                                        
               PERFORM  7025-GET-EXPIRATION-DT THRU 7025-EXIT           
                                                                        
               IF I-STATUS-CD = WS-A                                    
                  IF WS-EXPIRATION-DT <= WS-CURRENT-DATE                
                     MOVE  'WCP0000002'     TO S-BUS-RULE-ID            
                     MOVE WS-FAILED         TO S-BUS-RULE-RESULT-CD     
                                                                        
                     IF S-BUS-RULE-ID > SPACES                          
                        PERFORM 7170-GET-RULE-XREF-ID                   
                                               THRU 7170-EXIT           
                     END-IF                                             
                                                                        
                     PERFORM 8100-SEND-RESULT                           
                                               THRU 8100-EXIT           
                     PERFORM 9999-END-PROGRAM  THRU 9999-EXIT           
                  END-IF                                                
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES                  TO WS-EXPIRATION-DT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE STOREDED, WRITES TO THE          *        
      *      TRANSACTION TABLE.                                        *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                      TO ACTIVE-PARAGRAPH         
      *                                                                         
           PERFORM 7010-GET-RESP-AREA-ID       THRU 7010-EXIT           
                                                                        
           IF I-UPDATE-FL = WS-I                                        
              MOVE WS-INSERT-COMMENT        TO WS-APPEND-COMMENT        
              MOVE +24                      TO WS-APPEND-COMMENT-LEN    
              PERFORM 2005-PROCESS-NEW-FORM    THRU 2005-EXIT           
           ELSE                                                         
              IF I-UPDATE-FL = WS-U                                     
                 MOVE I-APPLICATION-ID      TO WS-APPLICATION-ID        
                                                                        
                 STRING 'APPLICATION ID ' DELIMITED BY SIZE             
                         WS-APPLICATION-ID DELIMITED BY SIZE            
                         '-'              DELIMITED BY SIZE             
                         I-PTNT-LAST-NAME DELIMITED BY SIZE             
                            ','           DELIMITED BY SIZE             
                         ' '              DELIMITED BY SIZE             
                        I-PTNT-FIRST-NAME DELIMITED BY SIZE             
                        ';!'              DELIMITED BY SIZE             
                   INTO WS-APPEND-COMMENT                               
                                                                        
                 MOVE +84                   TO WS-APPEND-COMMENT-LEN    
                 MOVE SPACES                TO WS-EMB-INPUT,            
                                               WS-CMP-TABLE             
                 MOVE 84                    TO WS-EMB-LENG              
                 MOVE WS-APPEND-COMMENT     TO WS-EMB-INPUT             
                                                                        
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES                    
                                               THRU 6010-EXIT           
                 MOVE WS-CMP-TABLE          TO WS-APPEND-COMMENT        
                 PERFORM 2250-PROCESS-UPDATE   THRU 2250-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
            IF  WS-DELETE-DNP-FL = WS-YES                               
                MOVE 'WCP0000001'           TO S-BUS-RULE-ID            
                MOVE WS-FAILED              TO S-BUS-RULE-RESULT-CD     
                MOVE 0                      TO RS-RETURN-CODE           
            END-IF.                                                     
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
                                                                        
            IF S-BUS-RULE-ID > SPACES                                   
                 PERFORM 7170-GET-RULE-XREF-ID THRU 7170-EXIT           
            END-IF.                                                     
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2005-PROCESS-NEW-FORM.                                         *        
      *                                                                *        
      *      PROCESS THE NEW FORM AND  WRITES TO THE                   *        
      *      TRANSACTION TABLE.                                        *        
      ******************************************************************        
      *                                                                         
       2005-PROCESS-NEW-FORM.                                           
      *                                                                         
           MOVE '2005'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      * BELOW APPLIES TO ALL NEW APPLICATION FORM                               
           MOVE I-PTNT-SSN                  TO WJ-SSN                   
           IF  WJ-SSN = '999999999'                                     
               IF  I-PTNT-NAME-ID > 0                                   
                   MOVE I-PTNT-NAME-ID      TO WO-NAME-ID               
                   MOVE WJ-SSN              TO WS-SSN                   
                   MOVE SPACES              TO WJ-SSN                   
                   PERFORM 2547-JOURNAL-WCP-SSN                         
                                               THRU 2547-EXIT           
                   MOVE WS-SSN              TO WJ-SSN                   
               ELSE                                                     
                   PERFORM 2080-PROCESS-PTNT-NAME                       
                                               THRU 2080-EXIT           
               END-IF                                                   
           ELSE                                                         
              IF  I-PTNT-NAME-ID > 0                                    
                  MOVE I-PTNT-NAME-ID       TO WO-NAME-ID               
                                               DQ-NAME-ID               
                                               WP-NAME-ID               
                                               WJ-NAME-ID               
                                                                        
      **** THOUGH THE PATIENT EXISTS CHECK IF NAME HAS CHANGED                  
                  PERFORM 2570-JOURNAL-PTNT-NAME                        
                                               THRU 2570-EXIT           
                  MOVE WJ-SSN               TO WS-SSN                   
                  MOVE SPACES               TO WJ-SSN                   
                                                                        
                  PERFORM 2547-JOURNAL-WCP-SSN                          
                                               THRU 2547-EXIT           
                  MOVE WS-SSN               TO WJ-SSN                   
                                                                        
                  PERFORM 2540-JOURNAL-PTNT-CONTACT                     
                                               THRU 2540-EXIT           
                  PERFORM 7110-SELECT-PTNT-SSN THRU 7110-EXIT           
                                                                        
                  IF  WJ-SSN = I-PTNT-SSN                               
                      CONTINUE                                          
                  ELSE                                                  
                      PERFORM 2280-PTNT-SSN-UPDATE                      
                                               THRU 2280-EXIT           
                  END-IF                                                
                                                                        
                  PERFORM 7060-SELECT-NAME     THRU 7060-EXIT           
                  PERFORM 7089-SELECT-PTNT-CONTACT                      
                                               THRU 7089-EXIT           
                                                                        
                  MOVE WS-NO                TO WS-PATIENT-NAME-UPDT     
                                                                        
                  PERFORM 2070-COMPARE-PTNT-NAME-FIELDS                 
                                               THRU  2070-EXIT          
                  IF  PATIENT-NAME-UPDT                                 
                      PERFORM 2035-POPULATE-PTNT-FIELDS                 
                                               THRU 2035-EXIT           
                      PERFORM 8070-UPDATE-NAME THRU 8070-EXIT           
                      INITIALIZE DCLCSS-NAME                            
                  END-IF                                                
                                                                        
                  IF I-PTNT-DOB = WP-PATIENT-DOB                        
                     CONTINUE                                           
                  ELSE                                                  
                     MOVE I-PTNT-DOB        TO WP-PATIENT-DOB           
                     PERFORM 8055-UPDATE-WCP-PTNT                       
                                               THRU 8055-EXIT           
                  END-IF                                                
              ELSE                                                      
                  PERFORM 2080-PROCESS-PTNT-NAME                        
                                               THRU 2080-EXIT           
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7050-GET-NEXT-APPLICATION-ID THRU 7050-EXIT          
           PERFORM  2575-JOURNAL-WCP            THRU 2575-EXIT          
                                                                        
           MOVE I-PHYSICIAN-ID              TO WO-PHYSICIAN-ID          
           MOVE WS-NO                       TO WS-STATUS-UPDT           
                                                                        
           PERFORM 2100-PROCESS-WH-CROSS-PLUS  THRU  2100-EXIT          
           PERFORM 8040-INSERT-CROSS-PLUS      THRU  8040-EXIT.         
      *                                                                         
       2005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2010-PROCESS-NEW-NAME.                                      *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2010-PROCESS-NEW-NAME.                                           
      *                                                                         
           MOVE '2010'                      TO ACTIVE-PARAGRAPH.        
           MOVE   WS-91-NEW-NAME-ID         TO DQ-NAME-ID               
           MOVE   WS-NAME-TYPE              TO DQ-NAME-TYPE             
           MOVE   WS-I                      TO DQ-NAME-FORMAT           
           MOVE   SPACES                    TO DQ-NICKNAME              
           MOVE   SPACES                    TO DQ-TITLE-SUFFIX-2        
           PERFORM 8000-INSERT-NAME            THRU 8000-EXIT           
           INITIALIZE DCLCSS-NAME.                                      
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2035-POPULATE-PTNT-FIELDS.                                    *        
      ******************************************************************        
      *                                                                         
       2035-POPULATE-PTNT-FIELDS.                                       
      *                                                                         
           MOVE I-PTNT-FIRST-NAME           TO DQ-FIRST-NAME            
           MOVE I-PTNT-MIDDLE-NAME          TO DQ-MIDDLE-NAME           
           MOVE I-PTNT-LAST-NAME            TO DQ-LAST-NAME             
           MOVE I-PTNT-PREFIX               TO DQ-TITLE-PREFIX          
           MOVE I-PTNT-SUFFIX               TO DQ-TITLE-SUFFIX-1        
           STRING I-PTNT-FIRST-NAME,                                    
                  I-PTNT-MIDDLE-NAME,                                   
                  I-PTNT-LAST-NAME   DELIMITED BY SIZE                  
             INTO DQ-FULL-NAME.                                         
      *                                                                         
       2035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2070-COMPARE-PTNT-NAME-FIELDS.                                *        
      ******************************************************************        
      *                                                                         
       2070-COMPARE-PTNT-NAME-FIELDS.                                   
      *                                                                         
           IF  I-PTNT-FIRST-NAME    EQUAL DQ-FIRST-NAME                 
           AND I-PTNT-MIDDLE-NAME   EQUAL DQ-MIDDLE-NAME                
           AND I-PTNT-LAST-NAME     EQUAL DQ-LAST-NAME                  
           AND I-PTNT-PREFIX        EQUAL DQ-TITLE-PREFIX               
           AND I-PTNT-SUFFIX        EQUAL DQ-TITLE-SUFFIX-1             
               CONTINUE                                                 
           ELSE                                                         
               SET PATIENT-NAME-UPDT        TO TRUE                     
           END-IF.                                                      
      *                                                                         
       2070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2080-PROCESS-PTNT-NAME.                                       *        
      ******************************************************************        
      *                                                                         
       2080-PROCESS-PTNT-NAME.                                          
      *                                                                         
           IF  I-PTNT-FIRST-NAME > SPACES                               
           OR  I-PTNT-LAST-NAME  > SPACES                               
           OR  I-PTNT-SSN        > SPACES                               
           OR  I-PTNT-DOB        > SPACES                               
               CONTINUE                                                 
           ELSE                                                         
               MOVE ZEROES                  TO WO-NAME-ID               
               GO TO 2080-EXIT                                          
           END-IF                                                       
      *                                                                         
           PERFORM 6302-GET-NEW-NAME-ID        THRU 6302-EXIT           
           IF  I-PTNT-FIRST-NAME   > SPACES                             
           OR  I-PTNT-LAST-NAME    > SPACES                             
               IF I-UPDATE-FL = WS-I                                    
                  PERFORM 2570-JOURNAL-PTNT-NAME                        
                                               THRU 2570-EXIT           
               END-IF                                                   
                                                                        
               MOVE      'PA'               TO WS-NAME-TYPE             
                                                                        
               PERFORM 2035-POPULATE-PTNT-FIELDS                        
                                               THRU 2035-EXIT           
               PERFORM 2010-PROCESS-NEW-NAME   THRU 2010-EXIT           
           END-IF                                                       
                                                                        
           IF  I-PTNT-DOB > SPACES                                      
               PERFORM 2540-JOURNAL-PTNT-CONTACT                        
                                               THRU 2540-EXIT           
           END-IF                                                       
                                                                        
           MOVE SPACES                      TO WJ-SSN                   
                                                                        
           IF  I-PTNT-SSN > SPACES                                      
           AND I-UPDATE-FL = WS-I                                       
               PERFORM 2547-JOURNAL-WCP-SSN    THRU 2547-EXIT           
           END-IF                                                       
                                                                        
           MOVE WS-91-NEW-NAME-ID           TO WP-NAME-ID               
                                               WO-NAME-ID               
                                               WJ-NAME-ID               
           MOVE I-PTNT-DOB                  TO WP-PATIENT-DOB           
                                                                        
           PERFORM 8050-INSERT-WCP-PTNT        THRU  8050-EXIT          
                                                                        
           IF  I-PTNT-SSN > SPACES                                      
               MOVE I-PTNT-SSN              TO WJ-SSN                   
               PERFORM 8060-INSERT-WCP-SSN     THRU  8060-EXIT          
           END-IF.                                                      
      *                                                                         
       2080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2100-PROCESS-WH-CROSS-PLUS.                                  *        
      *   CALLED FROM 2000-PROCESS-OUTPUT                              *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-WH-CROSS-PLUS.                                      
      *                                                                         
           MOVE I-ACCOUNT-NO                TO  WO-ACCOUNT-NO           
           MOVE I-STATUS-CD                 TO  WO-STATUS-CD            
           MOVE I-EFFECTIVE-DT              TO  WO-EFFECTIVE-DT         
           MOVE WS-EXPIRATION-DT            TO  WO-EXPIRATION-DT        
           MOVE I-COMMENT-LEN               TO  WO-COMMENT-LEN          
           MOVE I-COMMENT                   TO  WO-COMMENT-TEXT         
           MOVE I-MED-COND-CODE             TO  WO-MED-COND-CODE        
           MOVE I-MED-COND-DESC-LEN         TO  WO-MEDICAL-COND-DESC-LEN
           MOVE I-MED-COND-DESC            TO  WO-MEDICAL-COND-DESC-TEXT
           MOVE I-AMBULANCE-FL              TO  WO-AMBULANCE-FL         
           MOVE I-PTNT-ASSIST-FL            TO  WO-PATIENT-ASSIST-FL.   
           MOVE I-RELATIONSHIP              TO  WO-PATIENT-RELATION     
           MOVE I-PTNT-PHONE                TO  WO-PATIENT-PH-NO.       
           MOVE I-ADDRESS-ID                TO  WO-ADDRESS-ID.          
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2250-PROCESS-UPDATE.                                        *        
      *    PROCESS UPDATE AND WRITE INTO TRANSACTION TABLE.            *        
      ******************************************************************        
      *                                                                         
       2250-PROCESS-UPDATE.                                             
      *                                                                         
           MOVE '2250'                      TO ACTIVE-PARAGRAPH.        
           MOVE I-ACCOUNT-NO                TO WO-ACCOUNT-NO            
           MOVE I-APPLICATION-ID            TO WO-APPLICATION-ID        
           PERFORM 7065-SELECT-WCP             THRU 7065-EXIT           
           MOVE WO-STATUS-CD                TO WS-STATUS-CD             
           MOVE WO-NAME-ID                  TO DQ-NAME-ID               
                                               WP-NAME-ID               
                                               WJ-NAME-ID               
           PERFORM 7060-SELECT-NAME            THRU 7060-EXIT           
           PERFORM 7089-SELECT-PTNT-CONTACT    THRU 7089-EXIT           
           PERFORM 7110-SELECT-PTNT-SSN        THRU 7110-EXIT           
           PERFORM 2570-JOURNAL-PTNT-NAME      THRU 2570-EXIT           
           PERFORM 2540-JOURNAL-PTNT-CONTACT   THRU 2540-EXIT           
           PERFORM 2547-JOURNAL-WCP-SSN        THRU 2547-EXIT           
                                                                        
           IF  PTNT-SSN-UPDT                                            
               PERFORM 2280-PTNT-SSN-UPDATE    THRU 2280-EXIT           
           END-IF                                                       
                                                                        
           IF  PATIENT-NAME-UPDT                                        
               PERFORM 2035-POPULATE-PTNT-FIELDS THRU 2035-EXIT         
               PERFORM 8070-UPDATE-NAME        THRU 8070-EXIT           
                                                                        
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE 'PA'                TO  DQ-NAME-TYPE            
                   MOVE WS-I                TO  DQ-NAME-FORMAT          
                   MOVE SPACES              TO  DQ-NICKNAME             
                   MOVE SPACES              TO  DQ-TITLE-SUFFIX-2       
                   PERFORM 8000-INSERT-NAME     THRU 8000-EXIT          
               END-IF                                                   
                                                                        
               INITIALIZE DCLCSS-NAME                                   
           END-IF                                                       
                                                                        
           IF  PTNT-UPDT                                                
               IF  WO-NAME-ID = 0                                       
                   PERFORM 2260-ADD-NEW-NAME-ID                         
                                               THRU 2260-EXIT           
                        GO                  TO 2250-EXIT                
               ELSE                                                     
                   MOVE I-PTNT-DOB          TO WP-PATIENT-DOB           
                   PERFORM 8055-UPDATE-WCP-PTNT                         
                                               THRU 8055-EXIT           
               END-IF                                                   
           END-IF                                                       
                                                                        
           PERFORM 2575-JOURNAL-WCP            THRU 2575-EXIT           
                                                                        
           IF  WH-CR-PL-UPDT                                            
               MOVE I-PHYSICIAN-ID          TO WO-PHYSICIAN-ID          
               PERFORM 2100-PROCESS-WH-CROSS-PLUS                       
                                               THRU  2100-EXIT          
               PERFORM 8085-UPDATE-WCP         THRU 8085-EXIT           
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2260-ADD-NEW-NAME-ID.                                       *        
      ******************************************************************        
      *                                                                         
       2260-ADD-NEW-NAME-ID.                                            
      *                                                                         
           PERFORM 2080-PROCESS-PTNT-NAME      THRU 2080-EXIT           
           MOVE I-PHYSICIAN-ID              TO WO-PHYSICIAN-ID          
                                                                        
           PERFORM 2100-PROCESS-WH-CROSS-PLUS  THRU 2100-EXIT           
           PERFORM 8085-UPDATE-WCP             THRU 8085-EXIT.          
      *                                                                         
       2260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2280-PTNT-SSN-UPDATE.                                       *        
      ******************************************************************        
      *                                                                         
       2280-PTNT-SSN-UPDATE.                                            
      *                                                                         
           MOVE WJ-SSN                      TO WS-SSN                   
           MOVE WJ-NAME-ID                  TO WS-NAME-ID               
           MOVE I-PTNT-SSN                  TO WJ-SSN                   
                                                                        
           IF  I-PTNT-NAME-ID = WO-NAME-ID                              
           AND I-PTNT-NAME-ID > 0                                       
               MOVE WS-SSN                  TO WJ-SSN                   
               MOVE WS-NAME-ID              TO WJ-NAME-ID               
               IF  WJ-NAME-ID > 0                                       
                   PERFORM 8890-DELETE-WCP-SSN THRU 8890-EXIT           
               ELSE                                                     
                  IF  WJ-NAME-ID = 0                                    
                      PERFORM 2260-ADD-NEW-NAME-ID                      
                                               THRU 2260-EXIT           
                      GO                    TO 2250-EXIT                
                  END-IF                                                
               END-IF                                                   
                                                                        
               MOVE I-PTNT-SSN              TO WJ-SSN                   
               PERFORM 8060-INSERT-WCP-SSN     THRU  8060-EXIT          
           ELSE                                                         
               IF  I-PTNT-NAME-ID > 0                                   
                   SET WH-CR-PL-UPDT        TO TRUE                     
                   MOVE I-PTNT-NAME-ID      TO WO-NAME-ID               
                                               DQ-NAME-ID               
                                                                        
                   PERFORM 7060-SELECT-NAME    THRU 7060-EXIT           
                   PERFORM 2070-COMPARE-PTNT-NAME-FIELDS                
                                               THRU 2070-EXIT           
                   IF  PATIENT-NAME-UPDT                                
                       PERFORM 2035-POPULATE-PTNT-FIELDS                
                                               THRU 2035-EXIT           
                       PERFORM 8070-UPDATE-NAME                         
                                               THRU 8070-EXIT           
                       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                           MOVE 'PA'        TO  DQ-NAME-TYPE            
                           MOVE WS-I        TO  DQ-NAME-FORMAT          
                           MOVE SPACES      TO  DQ-NICKNAME             
                           MOVE SPACES      TO  DQ-TITLE-SUFFIX-2       
                           PERFORM 8000-INSERT-NAME THRU 8000-EXIT      
                       END-IF                                           
                                                                        
                       INITIALIZE DCLCSS-NAME                           
                       MOVE WS-NO           TO WS-PATIENT-NAME-UPDT     
                   END-IF                                               
                                                                        
                   MOVE I-PTNT-NAME-ID      TO WJ-NAME-ID               
                   PERFORM 7110-SELECT-PTNT-SSN                         
                                               THRU 7110-EXIT           
                   IF  WJ-SSN = I-PTNT-SSN                              
                       CONTINUE                                         
                   ELSE                                                 
                       PERFORM 8890-DELETE-WCP-SSN                      
                                               THRU 8890-EXIT           
                       MOVE I-PTNT-SSN      TO WJ-SSN                   
                       PERFORM 8060-INSERT-WCP-SSN                      
                                               THRU 8060-EXIT           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2080-PROCESS-PTNT-NAME                       
                                               THRU 2080-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-MISCELLANEOUS-UPDATE.                                     *        
      *   MISCELLANEOUS UPDATE                                         *        
      ******************************************************************        
      *                                                                         
       2300-MISCELLANEOUS-UPDATE.                                       
      *                                                                         
           MOVE '2200'                      TO ACTIVE-PARAGRAPH.        
           MOVE WO-ACCOUNT-NO               TO AT-ACCOUNT-NO            
           PERFORM 7085-SELECT-CRIT-OUTAGE     THRU 7085-EXIT           
           PERFORM 7120-SELECT-WHITE-CROSS-PLUS                         
                                               THRU 7120-EXIT           
           IF  WS-WCP-EXISTS                                            
               CONTINUE                                                 
           ELSE                                                         
               IF WO-STATUS-CD = WS-I                                   
                  MOVE 'DAYS-WCP-DNP-GRACE' TO C8-DELINQ-CD             
                  MOVE AT-COMPANY-NO        TO C8-COMPANY-NO            
                                                                        
                  PERFORM 7020-GET-DELINQUENCY-VAL                      
                                               THRU 7020-EXIT           
                  MOVE C8-DELINQ-VALUE      TO WS-NO-OF-DAYS            
                  PERFORM 7023-GET-DELINQUENCY-DT                       
                                               THRU 7023-EXIT           
                  MOVE WS-ACCOUNT-NO        TO CL-ACCOUNT-NO            
                                                                        
                  PERFORM 7130-OPEN-DNP-CURSOR THRU 7130-EXIT           
                  PERFORM 7140-FETCH-DNP-CURSOR THRU 7140-EXIT          
                  PERFORM 2310-PROCESS-DNP-DEL THRU 2310-EXIT           
                     UNTIL END-OF-ROWS                                  
                  PERFORM 7150-CLOSE-DNP-CURSOR THRU 7150-EXIT          
                  MOVE WS-NO                TO WS-END-OF-ROWS           
               END-IF                                                   
           END-IF                                                       
                                                                        
           PERFORM 2320-PROCESS-CRIT-UPDT      THRU 2320-EXIT.          
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2310-PROCESS-MISC-DEL.                                       *        
      *   DELETE FUTURE DNP FORECAST ROW                               *        
      ******************************************************************        
       2310-PROCESS-DNP-DEL.                                            
      *                                                                         
            PERFORM  2580-JOURNAL-DNP-DT       THRU 2580-EXIT           
            PERFORM  8087-DELETE-DNP-ROW       THRU 8087-EXIT           
            PERFORM  7140-FETCH-DNP-CURSOR     THRU 7140-EXIT.          
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2320-PROCESS-CRIT-UPDT.                                     *        
      *    PROCESS FOR THE MISCELLANEOUS UPDATE                        *        
      ******************************************************************        
      *                                                                         
       2320-PROCESS-CRIT-UPDT.                                          
      *                                                                         
           PERFORM 7160-SELECT-WHITE-CROSS     THRU 7160-EXIT           
           EVALUATE I-STATUS-CD                                         
               WHEN WS-A                                                
                  IF WS-WCP-EXISTS                                      
                  AND (AT-CODE-CRIT-OUTAGE = 'WP' OR 'WX')              
                     GO                     TO 2320-EXIT                
                  END-IF                                                
                                                                        
                  IF WS-WC-EXISTS                                       
                      MOVE 'WX'             TO WS-NEW-CRIT-OUTAGE       
                  ELSE                                                  
                      MOVE 'WP'             TO WS-NEW-CRIT-OUTAGE       
                  END-IF                                                
                                                                        
               WHEN WS-I                                                
               WHEN WS-D                                                
                  IF  WS-WCP-EXISTS                                     
                  OR  (WS-STATUS-CD = WS-I OR WS-D)                     
                      GO TO 2320-EXIT                                   
                  END-IF                                                
                                                                        
                  IF  WS-WC-EXISTS                                      
                      MOVE 'WC'    TO WS-NEW-CRIT-OUTAGE                
                  ELSE                                                  
                      MOVE SPACES  TO WS-NEW-CRIT-OUTAGE                
                  END-IF                                                
                                                                        
           END-EVALUATE.                                                
                                                                        
           PERFORM 2585-JOURNAL-CODE-CRIT      THRU 2585-EXIT           
           MOVE WS-NEW-CRIT-OUTAGE          TO AT-CODE-CRIT-OUTAGE      
           PERFORM 8090-UPDT-CODE-CRIT         THRU 8090-EXIT.          
      *                                                                         
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2540-JOURNAL-PTNT-CONTACT.                                  *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2540-JOURNAL-PTNT-CONTACT.                                       
      *                                                                         
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  WP-PATIENT-DOB = I-PTNT-DOB                              
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT DOB'           TO WS-COLUMN-DESC           
               IF  WP-PATIENT-DOB > SPACES                              
                   MOVE  WP-PATIENT-DOB     TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE  10                 TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE  '*NEW*'            TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-DOB = SPACES                                  
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-DOB          TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 10                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PTNT-UPDT                TO TRUE                     
           END-IF.                                                      
      *                                                                         
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2547-JOURNAL-WCP-SSN.                                       *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2547-JOURNAL-WCP-SSN.                                            
      *                                                                         
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  WJ-SSN = I-PTNT-SSN                                      
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'SSN'                   TO WS-COLUMN-DESC           
               IF  WJ-SSN  > ZEROES                                     
                   MOVE  WJ-SSN             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE  9                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE  '*NEW*'            TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               IF  I-PTNT-SSN = SPACES                                  
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-SSN          TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PTNT-SSN-UPDT            TO TRUE                     
           END-IF.                                                      
      *                                                                         
       2547-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2570-JOURNAL-PTNT-NAME.                                     *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2570-JOURNAL-PTNT-NAME.                                          
      *                                                                         
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  DQ-FIRST-NAME  = I-PTNT-FIRST-NAME                       
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT 1ST NM'        TO WS-COLUMN-DESC           
                                                                        
               IF  DQ-FIRST-NAME > SPACES                               
                   MOVE DQ-FIRST-NAME       TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               IF  I-PTNT-FIRST-NAME = SPACES                           
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-FIRST-NAME   TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PATIENT-NAME-UPDT        TO TRUE                     
           END-IF                                                       
                                                                        
           IF  DQ-MIDDLE-NAME = I-PTNT-MIDDLE-NAME                      
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-MIDDLE-NAME > SPACES                                
             OR  I-PTNT-MIDDLE-NAME > SPACES                            
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT MID NM'        TO WS-COLUMN-DESC           
                                                                        
               IF  DQ-MIDDLE-NAME > SPACES                              
                   MOVE DQ-MIDDLE-NAME      TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               IF  I-PTNT-MIDDLE-NAME = SPACES                          
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-MIDDLE-NAME  TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PATIENT-NAME-UPDT        TO TRUE                     
             END-IF                                                     
           END-IF                                                       
                                                                        
           IF  DQ-LAST-NAME   = I-PTNT-LAST-NAME                        
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT LAST NM'       TO WS-COLUMN-DESC           
                                                                        
               IF  DQ-LAST-NAME > SPACES                                
                   MOVE DQ-LAST-NAME        TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 40                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               IF  I-PTNT-LAST-NAME = SPACES                            
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-LAST-NAME    TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 40                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PATIENT-NAME-UPDT        TO TRUE                     
           END-IF                                                       
                                                                        
           IF  DQ-TITLE-PREFIX = I-PTNT-PREFIX                          
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-TITLE-PREFIX > SPACES                               
             OR  I-PTNT-PREFIX > SPACES                                 
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT  PREFIX'       TO WS-COLUMN-DESC           
                                                                        
               IF  DQ-TITLE-PREFIX > SPACES                             
                   MOVE DQ-TITLE-PREFIX     TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               IF  I-PTNT-PREFIX = SPACES                               
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-PREFIX       TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PATIENT-NAME-UPDT        TO TRUE                     
             END-IF                                                     
           END-IF                                                       
                                                                        
           IF  DQ-TITLE-SUFFIX-1 = I-PTNT-SUFFIX                        
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-TITLE-SUFFIX-1 > SPACES                             
             OR  I-PTNT-SUFFIX > SPACES                                 
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT SUFFIX'        TO WS-COLUMN-DESC           
                                                                        
               IF  DQ-TITLE-SUFFIX-1 > SPACES                           
                   MOVE DQ-TITLE-SUFFIX-1   TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               IF  I-PTNT-SUFFIX = SPACES                               
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-SUFFIX       TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PATIENT-NAME-UPDT        TO TRUE                     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2575-JOURNAL-WCP.                                           *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2575-JOURNAL-WCP.                                                
      *                                                                         
           MOVE SPACES                        TO WS-TABLE-ID            
           IF  WO-APPLICATION-ID   = I-APPLICATION-ID                   
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'APPLICATION ID'       TO WS-COLUMN-DESC          
             IF  I-APPLICATION-ID  > ZEROES                             
                 MOVE I-APPLICATION-ID       TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             MOVE WO-APPLICATION-ID          TO WS-CHG-COLUMN-VALUE-TEXT
             MOVE 9                          TO WS-CHG-COLUMN-VALUE-LEN 
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-PHYSICIAN-ID = I-PHYSICIAN-ID                         
               CONTINUE                                                 
           ELSE                                                         
                ADD +1                       TO WS-TRAN-APPL-NO         
                MOVE 'PHYSICIAN ID'          TO WS-COLUMN-DESC          
             IF  WO-PHYSICIAN-ID > ZEROES                               
                 MOVE WO-PHYSICIAN-ID        TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-PHYSICIAN-ID = ZEROES                                
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-PHYSICIAN-ID         TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-STATUS-CD  = I-STATUS-CD                              
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'STATUS'               TO WS-COLUMN-DESC          
                 MOVE '77'                   TO WS-TABLE-ID             
             IF  WO-STATUS-CD  > SPACES                                 
                 MOVE WO-STATUS-CD           TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-STATUS-CD = SPACES                                   
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-STATUS-CD            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
             SET STATUS-UPDT                 TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-EFFECTIVE-DT  = I-EFFECTIVE-DT                        
               CONTINUE                                                 
           ELSE                                                         
                ADD +1                       TO WS-TRAN-APPL-NO         
                MOVE 'SIGNED DT'             TO WS-COLUMN-DESC          
             IF WO-EFFECTIVE-DT > SPACES                                
                MOVE WO-EFFECTIVE-DT         TO WS-PRV-COLUMN-VALUE-TEXT
                MOVE 10                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                MOVE '*NEW*'                 TO WS-PRV-COLUMN-VALUE-TEXT
                MOVE 5                       TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-EFFECTIVE-DT = SPACES                                
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-EFFECTIVE-DT         TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 10                     TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-EXPIRATION-DT = WS-EXPIRATION-DT                      
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'EXPIRATION DT'        TO WS-COLUMN-DESC          
                                                                        
             IF  WO-EXPIRATION-DT > SPACES                              
                 MOVE WO-EXPIRATION-DT       TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 10                     TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  WS-EXPIRATION-DT = SPACES                              
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE WS-EXPIRATION-DT       TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 10                     TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-COMMENT-TEXT = I-COMMENT                              
               CONTINUE                                                 
           ELSE                                                         
             IF WO-COMMENT-TEXT > SPACES                                
             OR I-COMMENT  > SPACES                                     
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'COMMENT'                TO WS-COLUMN-DESC          
                                                                        
               IF  WO-COMMENT-TEXT > SPACES                             
                   MOVE WO-COMMENT-TEXT      TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE WO-COMMENT-LEN       TO WS-PRV-COLUMN-VALUE-LEN 
                   IF WO-COMMENT-LEN > 75                               
                      MOVE 75                TO WS-PRV-COLUMN-VALUE-LEN 
                   END-IF                                               
               ELSE                                                     
                   MOVE '*NEW*'              TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
                                                                        
               IF  I-COMMENT = SPACES                                   
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE I-COMMENT            TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE I-COMMENT-LEN        TO WS-CHG-COLUMN-VALUE-LEN 
                   IF I-COMMENT-LEN > 75                                
                      MOVE 75                TO WS-CHG-COLUMN-VALUE-LEN 
                   END-IF                                               
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET WH-CR-PL-UPDT             TO TRUE                    
             END-IF                                                     
           END-IF                                                       
                                                                        
           IF  WO-MED-COND-CODE = I-MED-COND-CODE                       
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'MED COND TYPE'        TO WS-COLUMN-DESC          
                 MOVE '76'                   TO WS-TABLE-ID             
             IF  WO-MED-COND-CODE > SPACES                              
                 MOVE WO-MED-COND-CODE       TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 2                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-MED-COND-CODE = SPACES                               
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-MED-COND-CODE        TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 2                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-MEDICAL-COND-DESC-TEXT  = I-MED-COND-DESC             
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'MED COND DESC'        TO WS-COLUMN-DESC          
             IF  WO-MEDICAL-COND-DESC-TEXT > SPACES                     
                 MOVE WO-MEDICAL-COND-DESC-TEXT                         
                                             TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE WO-MEDICAL-COND-DESC-LEN                          
                                             TO WS-PRV-COLUMN-VALUE-LEN 
                 IF  WS-PRV-COLUMN-VALUE-LEN > +75                      
                     MOVE +75                TO WS-PRV-COLUMN-VALUE-LEN 
                 END-IF                                                 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-MED-COND-DESC = SPACES                               
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-MED-COND-DESC        TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE I-MED-COND-DESC-LEN    TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  WS-CHG-COLUMN-VALUE-LEN > +75                          
                 MOVE +75                    TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-AMBULANCE-FL  = I-AMBULANCE-FL                        
               CONTINUE                                                 
           ELSE                                                         
                 MOVE '78'                   TO WS-TABLE-ID             
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'AMBULATORY'           TO WS-COLUMN-DESC          
             IF  WO-AMBULANCE-FL > SPACES                               
                 MOVE WO-AMBULANCE-FL        TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-AMBULANCE-FL = SPACES                                
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-AMBULANCE-FL         TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
                                                                        
           IF  WO-PATIENT-ASSIST-FL = I-PTNT-ASSIST-FL                  
               CONTINUE                                                 
           ELSE                                                         
                 MOVE '78'                   TO WS-TABLE-ID             
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'LEAVE UNASSIST'       TO WS-COLUMN-DESC          
             IF  WO-PATIENT-ASSIST-FL  > SPACES                         
                 MOVE WO-PATIENT-ASSIST-FL   TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             IF  I-PTNT-ASSIST-FL = SPACES                              
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-PTNT-ASSIST-FL       TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
                                                                        
             PERFORM 5950-SET-MNT-TRANS-VARS    THRU 5950-EXIT          
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF.                                                      
                                                                        
           IF  WO-PATIENT-PH-NO   = I-PTNT-PHONE                        
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'PATIENT PHONE'          TO WS-COLUMN-DESC          
               IF  WO-PATIENT-PH-NO  > SPACES                           
                   MOVE  WO-PATIENT-PH-NO    TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  10                  TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE  '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
                                                                        
               IF  I-PTNT-PHONE = SPACES                                
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 9                     TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                  MOVE I-PTNT-PHONE          TO WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 10                    TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET WH-CR-PL-UPDT               TO TRUE                  
           END-IF                                                       
                                                                        
           IF  WO-PATIENT-RELATION = I-RELATIONSHIP                     
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                         TO WS-TRAN-APPL-NO        
               MOVE 'RELATIONSHIP'            TO WS-COLUMN-DESC         
               IF  WO-PATIENT-RELATION   > SPACES                       
                   MOVE  WO-PATIENT-RELATION TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  15                  TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                  MOVE  '*NEW*'              TO WS-PRV-COLUMN-VALUE-TEXT
                  MOVE 5                     TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
                                                                        
               IF  I-RELATIONSHIP = SPACES                              
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                  MOVE I-RELATIONSHIP        TO WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 15                    TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
                                                                        
               PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET WH-CR-PL-UPDT             TO TRUE                    
           END-IF.                                                      
      *                                                                         
       2575-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2580-JOURNAL-ACCOUNT.                                       *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2580-JOURNAL-DNP-DT.                                             
      *                                                                         
           MOVE SPACES                       TO WS-TABLE-ID             
           ADD +1                            TO WS-TRAN-APPL-NO         
           EVALUATE CL-CODE-NOTICE-TYPE                                 
               WHEN 'D'                                                 
                  MOVE 'NORMAL DNP'          TO WS-COLUMN-DESC          
               WHEN 'G'                                                 
                  MOVE 'EXCEPTIONAL DNP'     TO WS-COLUMN-DESC          
               WHEN 'H'                                                 
                  MOVE 'RETURNED CK DNP'     TO WS-COLUMN-DESC          
               WHEN WS-I                                                
                  MOVE 'DEPOSIT DNP'         TO WS-COLUMN-DESC          
           END-EVALUATE                                                 
           MOVE CL-DATE-CREDIT-ACTION        TO WS-PRV-COLUMN-VALUE-TEXT
           MOVE 10                           TO WS-PRV-COLUMN-VALUE-LEN 
           MOVE '*DELETED*'                  TO WS-CHG-COLUMN-VALUE-TEXT
           MOVE 9                            TO WS-CHG-COLUMN-VALUE-LEN 
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
      *                                                                         
       2580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2585-JOURNAL-CODE-CRIT.                                     *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2585-JOURNAL-CODE-CRIT.                                          
      *                                                                         
           MOVE 'Q2'                         TO WS-TABLE-ID             
           ADD +1                            TO WS-TRAN-APPL-NO         
           MOVE 'CRITICAL ACCT'              TO WS-COLUMN-DESC          
           IF  AT-CODE-CRIT-OUTAGE > SPACES                             
               MOVE AT-CODE-CRIT-OUTAGE      TO WS-PRV-COLUMN-VALUE-TEXT
               MOVE 2                        TO WS-PRV-COLUMN-VALUE-LEN 
           ELSE                                                         
               MOVE '*NEW*'                  TO WS-PRV-COLUMN-VALUE-TEXT
               MOVE 2                        TO WS-PRV-COLUMN-VALUE-LEN 
           END-IF                                                       
           IF  WS-NEW-CRIT-OUTAGE > SPACES                              
               MOVE WS-NEW-CRIT-OUTAGE       TO WS-CHG-COLUMN-VALUE-TEXT
               MOVE 2                        TO WS-CHG-COLUMN-VALUE-LEN 
           ELSE                                                         
               MOVE '*DELETED*'              TO WS-CHG-COLUMN-VALUE-TEXT
               MOVE 9                        TO WS-CHG-COLUMN-VALUE-LEN 
           END-IF                                                       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
      *                                                                         
       2585-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5950-SET-MNT-TRANS-VARS                                        *        
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
      *                                                                         
       5950-SET-MNT-TRANS-VARS.                                         
      *                                                                         
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
           IF  WS-TRAN-APPL-NO = 1                                      
      *                                                                         
               MOVE 'CSR04859'              TO MH-APPL-PROGRAM-ID       
               MOVE WS-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO     
               MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS            
               MOVE WS-CODE-TRAN-TYPE       TO MH-CODE-TRAN-TYPE        
               MOVE PF-RESP-AREA-ID         TO MH-RESP-AREA-ID          
               MOVE WS-ACCOUNT-NO           TO MH-ACCOUNT-NO            
               MOVE 0                       TO MH-CUSTOMER-NO           
               MOVE 0                       TO MH-PREMISE-NO            
               MOVE WS-USERID               TO MH-USER-ID               
      *                                                                         
              IF I-TRANS-COMMENTS-LEN > ZEROES                          
                 IF  I-UPDATE-FL = WS-I                                 
                     IF  I-TRANS-COMMENTS-LEN > 186                     
                         MOVE 186           TO I-TRANS-COMMENTS-LEN     
                     END-IF                                             
                 ELSE                                                   
                     IF  I-TRANS-COMMENTS-LEN > 126                     
                         MOVE 126           TO I-TRANS-COMMENTS-LEN     
                     END-IF                                             
                 END-IF                                                 
                                                                        
                 MOVE I-TRANS-COMMENTS(1:I-TRANS-COMMENTS-LEN)          
                      TO I-TRANS-COMMENTS                               
                 STRING WS-APPEND-COMMENT DELIMITED BY '!'              
                        I-TRANS-COMMENTS DELIMITED BY SIZE              
                   INTO MH-TRAN-COMMENT-TEXT                            
                  MOVE I-TRANS-COMMENTS-LEN TO MH-TRAN-COMMENT-LEN      
                  ADD WS-APPEND-COMMENT-LEN TO MH-TRAN-COMMENT-LEN      
              ELSE                                                      
                 STRING WS-APPEND-COMMENT DELIMITED BY '!'              
                                          INTO MH-TRAN-COMMENT-TEXT     
                 MOVE WS-APPEND-COMMENT-LEN TO MH-TRAN-COMMENT-LEN      
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
      *                                                                         
       5950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ******************************************************************        
      *   6530-LOAD-MNT-TRANS-HIST.                                    *        
      ******************************************************************        
      *                                                                         
       6530-LOAD-MNT-TRANS-HIST.                                        
      *                                                                         
           MOVE '6530'                      TO ACTIVE-PARAGRAPH.        
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           END-IF.                                                      
      *                                                                         
       6530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6540-INSERT-MNT-TRANS-HIST.                                  *        
      ******************************************************************        
      *                                                                         
       6540-INSERT-MNT-TRANS-HIST.                                      
      *                                                                         
           MOVE '6540'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO,                                   
                   DATE_TRANS,                                          
                   CODE_TRAN_TYPE,                                      
                   RESP_AREA_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   PREMISE_NO,                                          
                   USER_ID,                                             
                   APPL_PROGRAM_ID,                                     
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                   
                   IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                   :MH-CODE-TRAN-TYPE,                                  
                   :MH-RESP-AREA-ID,                                    
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,                                     
                   :MH-PREMISE-NO,                                      
                   :MH-USER-ID,                                         
                   :MH-APPL-PROGRAM-ID,                                 
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE MH-APPL-PROGRAM-ID       TO ABEND-PROGRAM            
              MOVE '6540'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MNT_TRANS_HIST'     TO TABLE-1                  
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MH-CUSTOMER-NO           TO HOSTVAR-ELEMENT-2        
              MOVE MH-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE MH-DATE-TRANS            TO HOSTVAR-ELEMENT-4        
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE 'PREMISE-NO'             TO TABLE-ELEMENT-3          
              MOVE 'DATE-TRANS'             TO TABLE-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT
           END-IF.          
      *                                                                         
       6540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6550-INSERT-MT-TRN-HST-DET.                                  *        
      ******************************************************************        
      *                                                                         
       6550-INSERT-MT-TRN-HST-DET.                                      
      *                                                                         
           MOVE '6550'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO,                                     
                 TRAN_APPL_NO,                                          
                 COLUMN_DESC,                                           
                 PRV_COLUMN_VALUE,                                      
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                     
                 :MI-TRAN-APPL-NO,                                      
                 :MI-COLUMN-DESC,                                       
                 :MI-PRV-COLUMN-VALUE,                                  
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*          TRAN_APPL_NO,                                                  
MFA-TR*          COLUMN_DESC,                                                   
MFA-TR*          PRV_COLUMN_VALUE,                                              
MFA-TR*          CHG_COLUMN_VALUE,                                              
MFA-TR*          TABLE_ID)                                                      
MFA-TR*        VALUES                                                           
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :MI-TRAN-APPL-NO,                                              
MFA-TR*          :MI-COLUMN-DESC,                                               
MFA-TR*          :MI-PRV-COLUMN-VALUE,                                          
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                          
MFA-TR*          :MI-TABLE-ID)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE MH-APPL-PROGRAM-ID       TO ABEND-PROGRAM            
              MOVE '6550'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MT_TRN_HST_DET'     TO TABLE-1                  
              MOVE MI-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-1        
              MOVE MI-TRAN-APPL-NO          TO HOSTVAR-ELEMENT-2        
              MOVE MI-COLUMN-DESC           TO HOSTVAR-ELEMENT-3        
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4        
              MOVE 'TRANS-HIST-SEQ-NO'      TO TABLE-ELEMENT-1          
              MOVE 'TRAN-APPL-NO'           TO TABLE-ELEMENT-2          
              MOVE 'COLUMN-DESC'            TO TABLE-ELEMENT-3          
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT
           END-IF.          
      *                                                                         
       6550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *  CHECK DIGITS COPYBOOK.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00013                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00091                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00092                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      * 7000-GET-CURRENT-DATE                                          *        
      *      --THIS MODULE DETERMINES THE CURRENT DATE  FOR THE        *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*             ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE I-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT
           END-IF.          
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-GET-RESP-AREA-ID                                          *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
      *                                                                         
       7010-GET-RESP-AREA-ID.                                           
      *                                                                         
           MOVE WS-USERID                   TO PF-USER-ID               
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PF-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE PF-USER-ID               TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE I-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      7020-GET-DELINQUENCY-VAL                                  *        
      ******************************************************************        
      *                                                                         
       7020-GET-DELINQUENCY-VAL.                                        
      *                                                                         
           MOVE '7020'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-3          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7023-GET-DELINQUENCY-DT                                       *         
      *****************************************************************         
      *                                                                         
       7023-GET-DELINQUENCY-DT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, :WS-NO-OF-DAYS, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DELINQUENCY-DT          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DELINQUENCY-DT =                                          
MFA-TR*           DATE(:WS-CURRENT-DATE) + :WS-NO-OF-DAYS DAYS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7023'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-1          
              MOVE  WS-CURRENT-DATE         TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE  AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2        
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7023-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7025-GET-EXPIRATION-DT                                        *         
      *****************************************************************         
      *                                                                         
       7025-GET-EXPIRATION-DT.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, :I-DURATION-MONTH, IIF(TRY_CONVERT(DATE, 
                                                        :I-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :I-EFFECTIVE-DT
              ) <> 0) OR (LEN(:I-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                        :I-EFFECTIVE-DT
              ), CONVERT(DATE, :I-EFFECTIVE-DT) ) )
            INTO
              :WS-EXPIRATION-DT        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-EXPIRATION-DT =                                           
MFA-TR*         DATE(:I-EFFECTIVE-DT) + :I-DURATION-MONTH MONTHS                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'EFFECTIVE_DT'           TO TABLE-ELEMENT-1          
              MOVE  I-EFFECTIVE-DT          TO HOSTVAR-ELEMENT-1        
              MOVE 'DURATION '              TO TABLE-ELEMENT-2          
              MOVE  I-DURATION-MONTH        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO '            TO TABLE-ELEMENT-3          
              MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7040-SELECT-PTNT-NAME-ID.                                     *        
      ******************************************************************        
      *                                                                         
       7040-SELECT-PTNT-NAME-ID.                                        
      *                                                                         
           MOVE '7040'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT NAME_ID                                             
               INTO :WJ-NAME-ID                                         
               FROM CSS_WH_CROSS_SSN                                    
              WHERE SSN = :WJ-SSN                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_SSN'      TO TABLE-1                  
               MOVE 'SSN'                   TO TABLE-ELEMENT-1          
               MOVE WJ-SSN                  TO HOSTVAR-ELEMENT-1        
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-2          
               MOVE WJ-NAME-ID              TO HOSTVAR-ELEMENT-2        
               MOVE 'ACCOUNT_NO '           TO TABLE-ELEMENT-3          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
             END-IF.                                                    
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE NEW APPLICATION ID                                    *        
      ******************************************************************        
      *                                                                         
       7050-GET-NEXT-APPLICATION-ID.                                    
      *                                                                         
           MOVE '7050'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
                SELECT
              NEXT VALUE FOR SEQ_WO_APPLICATION_ID
            INTO
              :WO-APPLICATION-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WO-APPLICATION-ID                                          
MFA-TR*             = NEXTVAL FOR SEQ_WO_APPLICATION_ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE 'CSR04859'              TO ABEND-PROGRAM            
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'SEQ_PY_APPLICATION_ID' TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO '           TO TABLE-ELEMENT-2          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7060-SELECT-NAME.                                              *        
      *      -- THIS MODULE SELECTS NAME                               *        
      *         FROM CSS_NAME TABLE.                                   *        
      ******************************************************************        
      *                                                                         
       7060-SELECT-NAME.                                                
      *                                                                         
           MOVE '7060'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  FIRST_NAME                                       
                      ,MIDDLE_NAME                                      
                      ,LAST_NAME                                        
                      ,TITLE_PREFIX                                     
                      ,TITLE_SUFFIX_1                                   
                 INTO :DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-LAST-NAME                                     
                     ,:DQ-TITLE-PREFIX                                  
                     ,:DQ-TITLE-SUFFIX-1                                
                 FROM CSS_NAME                                          
                WHERE NAME_ID = :DQ-NAME-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES              TO  DQ-FIRST-NAME           
                                                DQ-MIDDLE-NAME          
                                                DQ-LAST-NAME            
                                                DQ-TITLE-PREFIX         
                                                DQ-TITLE-SUFFIX-1       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7060'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_NAME'          TO TABLE-1                  
                   MOVE 'ACCOUNT_NO '       TO TABLE-ELEMENT-1          
                   MOVE WS-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'NAME_ID'           TO TABLE-ELEMENT-2          
                   MOVE DQ-NAME-ID          TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7065-SELECT-WCP.                                               *        
      *      -- THIS MODULE SELECTS                                    *        
      *         FROM CSS_WH_CROSS_PLUS  TABLE                          *        
      ******************************************************************        
      *                                                                         
       7065-SELECT-WCP.                                                 
      *                                                                         
           MOVE '7065'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  APPLICATION_ID                                   
                      ,ACCOUNT_NO                                       
                      ,NAME_ID                                          
                      ,PHYSICIAN_ID                                     
                      ,STATUS_CD                                        
                      ,DATE_TRANS                                       
                      ,COALESCE(CAST(EFFECTIVE_DT AS CHAR(10)),' ')             
                      ,COALESCE(CAST(EXPIRATION_DT AS CHAR(10)),' ')            
                      ,COMMENT                                          
                      ,ADDRESS_ID                                       
                      ,MED_COND_CODE                                    
                      ,MEDICAL_COND_DESC                                
                      ,AMBULANCE_FL                                     
                      ,PATIENT_ASSIST_FL                                
                      ,PATIENT_RELATION                                 
                      ,PATIENT_PH_NO                                    
                 INTO :WO-APPLICATION-ID                                
                     ,:WO-ACCOUNT-NO                                    
                     ,:WO-NAME-ID                                       
                     ,:WO-PHYSICIAN-ID                                  
                     ,:WO-STATUS-CD                                     
                     ,:WO-DATE-TRANS                                    
                     ,:WO-EFFECTIVE-DT                                  
                     ,:WO-EXPIRATION-DT                                 
                     ,:WO-COMMENT                                       
                     ,:WO-ADDRESS-ID                                    
                     ,:WO-MED-COND-CODE                                 
                     ,:WO-MEDICAL-COND-DESC                             
                     ,:WO-AMBULANCE-FL                                  
                     ,:WO-PATIENT-ASSIST-FL                             
                     ,:WO-PATIENT-RELATION                              
                     ,:WO-PATIENT-PH-NO                                 
                 FROM CSS_WH_CROSS_PLUS                                 
                WHERE ACCOUNT_NO     = :WO-ACCOUNT-NO                   
                  AND APPLICATION_ID = :WO-APPLICATION-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  APPLICATION_ID                                           
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,NAME_ID                                                  
MFA-TR*               ,PHYSICIAN_ID                                             
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,DATE_TRANS                                               
MFA-TR*               ,COALESCE(CHAR(EFFECTIVE_DT),' ')                         
MFA-TR*               ,COALESCE(CHAR(EXPIRATION_DT),' ')                        
MFA-TR*               ,COMMENT                                                  
MFA-TR*               ,ADDRESS_ID                                               
MFA-TR*               ,MED_COND_CODE                                            
MFA-TR*               ,MEDICAL_COND_DESC                                        
MFA-TR*               ,AMBULANCE_FL                                             
MFA-TR*               ,PATIENT_ASSIST_FL                                        
MFA-TR*               ,PATIENT_RELATION                                         
MFA-TR*               ,PATIENT_PH_NO                                            
MFA-TR*          INTO :WO-APPLICATION-ID                                        
MFA-TR*              ,:WO-ACCOUNT-NO                                            
MFA-TR*              ,:WO-NAME-ID                                               
MFA-TR*              ,:WO-PHYSICIAN-ID                                          
MFA-TR*              ,:WO-STATUS-CD                                             
MFA-TR*              ,:WO-DATE-TRANS                                            
MFA-TR*              ,:WO-EFFECTIVE-DT                                          
MFA-TR*              ,:WO-EXPIRATION-DT                                         
MFA-TR*              ,:WO-COMMENT                                               
MFA-TR*              ,:WO-ADDRESS-ID                                            
MFA-TR*              ,:WO-MED-COND-CODE                                         
MFA-TR*              ,:WO-MEDICAL-COND-DESC                                     
MFA-TR*              ,:WO-AMBULANCE-FL                                          
MFA-TR*              ,:WO-PATIENT-ASSIST-FL                                     
MFA-TR*              ,:WO-PATIENT-RELATION                                      
MFA-TR*              ,:WO-PATIENT-PH-NO                                         
MFA-TR*          FROM CSS_WH_CROSS_PLUS                                         
MFA-TR*         WHERE ACCOUNT_NO     = :WO-ACCOUNT-NO                           
MFA-TR*           AND APPLICATION_ID = :WO-APPLICATION-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7065'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_WH_CROSS_PLUS'      TO TABLE-1                  
              MOVE 'APPLICATION_ID'         TO TABLE-ELEMENT-1          
              MOVE WO-APPLICATION-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7065-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7085-SELECT-CRIT-OUTAGE                                        *        
      *      -- THIS MODULE SELECTS CODE_CRIT_OUTAGE                   *        
      *         FROM CSS_ACCOUNT TABLE.                                *        
      ******************************************************************        
      *                                                                         
       7085-SELECT-CRIT-OUTAGE.                                         
      *                                                                         
           MOVE '7085'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT  CODE_CRIT_OUTAGE                                 
                       ,COMPANY_NO                                      
                 INTO :AT-CODE-CRIT-OUTAGE                              
                     ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7085'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7089-SELECT-PTNT-CONTACT.                                     *         
      *    SELECT FROM WH_CROSS_PATNT                                 *         
      *****************************************************************         
      *                                                                         
       7089-SELECT-PTNT-CONTACT.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(CAST(PATIENT_DOB AS CHAR(10)),' ')                
                INTO :WP-PATIENT-DOB                                    
                FROM CSS_WH_CROSS_PATNT                                 
               WHERE NAME_ID = :WP-NAME-ID                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COALESCE(CHAR(PATIENT_DOB),' ')                            
MFA-TR*         INTO :WP-PATIENT-DOB                                            
MFA-TR*         FROM CSS_WH_CROSS_PATNT                                         
MFA-TR*        WHERE NAME_ID = :WP-NAME-ID                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 CONTINUE                                               
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7089'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PATNT'    TO TABLE-1                  
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-1          
               MOVE WP-NAME-ID              TO HOSTVAR-ELEMENT-1        
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7089-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7110-SELECT-PTNT-SSN.                                         *         
      *****************************************************************         
      *                                                                         
       7110-SELECT-PTNT-SSN.                                            
      *                                                                         
           MOVE '7110'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT SSN                                                 
               INTO :WJ-SSN                                             
               FROM CSS_WH_CROSS_SSN                                    
              WHERE NAME_ID = :WJ-NAME-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_SSN'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-2          
               MOVE WJ-NAME-ID              TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7120-SELECT-WHITE-CROSS-PLUS.                                 *         
      *****************************************************************         
      *                                                                         
       7120-SELECT-WHITE-CROSS-PLUS.                                    
      *                                                                         
           MOVE '7120'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-WCP-FLAG                                        
               FROM CSS_WH_CROSS_PLUS                                   
              WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                         
                AND STATUS_CD  = 'A'                                    
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-WCP-FLAG                                                
MFA-TR*        FROM CSS_WH_CROSS_PLUS                                           
MFA-TR*       WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                                 
MFA-TR*         AND STATUS_CD  = 'A'                                            
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PLUS'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
             END-IF.                                                    
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-OPEN-DNP-CURSOR.                                          *        
      *  OPENS THE CURSOR FOR PROCESSING                               *        
      ******************************************************************        
      *                                                                         
       7130-OPEN-DNP-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN DNP_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7130'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE 'CSS_CRED_COLL'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7140-FETCH-DNP-CURSOR.                                       *        
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *        
      ******************************************************************        
      *                                                                         
       7140-FETCH-DNP-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH DNP_CSR                                            
                INTO :CL-CODE-NOTICE-TYPE                               
                    ,:CL-DATE-CREDIT-ACTION                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE WS-YES               TO WS-END-OF-ROWS           
              END-IF                                                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7140'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_CRED_COLL'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7150-CLOSE-DNP-CURSOR.                                     **         
      **  THIS PARAGRAPH CLOSES THE MAIN PROCESSING CURSOR.          **         
      *****************************************************************         
      *                                                                         
       7150-CLOSE-DNP-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE DNP_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7150'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_CRED_COLL'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7160-SELECT-WHITE-CROSS.                                       *        
      *      -- THIS MODULE CHECKS IF WHITE CROSS EXISTS ON THIS ACCT  *        
      ******************************************************************        
      *                                                                         
       7160-SELECT-WHITE-CROSS.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-WHITE-CROSS-FLAG                               
                FROM CSS_ACCT_WHT_CROSS                                 
               WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                        
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-WHITE-CROSS-FLAG                                       
MFA-TR*         FROM CSS_ACCT_WHT_CROSS                                         
MFA-TR*        WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7160'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_WHT_CROSS'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
      *                                                                         
       7170-GET-RULE-XREF-ID.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7170                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7170'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-BUS-RULE-ID           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000-INSERT-NAME.                                             *         
      *    INSERTS A ROW INTO TABLE CSS_NAME.                         *         
      *****************************************************************         
      *                                                                         
       8000-INSERT-NAME.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                       (NAME_ID                                         
                       ,NAME_TYPE                                       
                       ,NAME_FORMAT                                     
                       ,CREATED_DATE                                    
                       ,TITLE_PREFIX                                    
                       ,FIRST_NAME                                      
                       ,MIDDLE_NAME                                     
                       ,LAST_NAME                                       
                       ,NICKNAME                                        
                       ,TITLE_SUFFIX_1                                  
                       ,TITLE_SUFFIX_2                                  
                       ,FULL_NAME)                                      
              VALUES                                                    
                        (:DQ-NAME-ID                                    
                        ,:DQ-NAME-TYPE                                  
                        ,:DQ-NAME-FORMAT                                
                        ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)              
                        ,:DQ-TITLE-PREFIX                               
                        ,:DQ-FIRST-NAME                                 
                        ,:DQ-MIDDLE-NAME                                
                        ,:DQ-LAST-NAME                                  
                        ,:DQ-NICKNAME                                   
                        ,:DQ-TITLE-SUFFIX-1                             
                        ,:DQ-TITLE-SUFFIX-2                             
                        ,:DQ-FULL-NAME)                                 
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*                (NAME_ID                                                 
MFA-TR*                ,NAME_TYPE                                               
MFA-TR*                ,NAME_FORMAT                                             
MFA-TR*                ,CREATED_DATE                                            
MFA-TR*                ,TITLE_PREFIX                                            
MFA-TR*                ,FIRST_NAME                                              
MFA-TR*                ,MIDDLE_NAME                                             
MFA-TR*                ,LAST_NAME                                               
MFA-TR*                ,NICKNAME                                                
MFA-TR*                ,TITLE_SUFFIX_1                                          
MFA-TR*                ,TITLE_SUFFIX_2                                          
MFA-TR*                ,FULL_NAME)                                              
MFA-TR*       VALUES                                                            
MFA-TR*                 (:DQ-NAME-ID                                            
MFA-TR*                 ,:DQ-NAME-TYPE                                          
MFA-TR*                 ,:DQ-NAME-FORMAT                                        
MFA-TR*                 ,:WS-CURRENT-TIMESTAMP                                  
MFA-TR*                 ,:DQ-TITLE-PREFIX                                       
MFA-TR*                 ,:DQ-FIRST-NAME                                         
MFA-TR*                 ,:DQ-MIDDLE-NAME                                        
MFA-TR*                 ,:DQ-LAST-NAME                                          
MFA-TR*                 ,:DQ-NICKNAME                                           
MFA-TR*                 ,:DQ-TITLE-SUFFIX-1                                     
MFA-TR*                 ,:DQ-TITLE-SUFFIX-2                                     
MFA-TR*                 ,:DQ-FULL-NAME)                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_NAME'              TO TABLE-1                  
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-1          
               MOVE 'NAME_TYPE'             TO TABLE-ELEMENT-2          
               MOVE 'FIRST_NAME'            TO TABLE-ELEMENT-4          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3        
               MOVE DQ-NAME-ID              TO HOSTVAR-ELEMENT-1        
               MOVE DQ-NAME-TYPE            TO HOSTVAR-ELEMENT-2        
               MOVE DQ-FIRST-NAME           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04859_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04859_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04859_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04859_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04859_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8100 '                  TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04859_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8040-INSERT-CROSS-PLUS                                        *         
      *    INSERT INTO WH_CROSS_PLUS                                  *         
      *****************************************************************         
      *                                                                         
       8040-INSERT-CROSS-PLUS.                                          
      *                                                                         
           IF  WO-EFFECTIVE-DT = SPACES OR LOW-VALUES                   
               MOVE -1         TO WS-NULL-IND-EFF                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-EFF                       
           END-IF                                                       
      *                                                                         
           IF  WO-EXPIRATION-DT = SPACES OR LOW-VALUES                  
               MOVE -1         TO WS-NULL-IND-EXP                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-EXP                       
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_WH_CROSS_PLUS                            
                   (APPLICATION_ID                                      
                   ,ACCOUNT_NO                                          
                   ,NAME_ID                                             
                   ,PHYSICIAN_ID                                        
                   ,STATUS_CD                                           
                   ,DATE_TRANS                                          
                   ,EFFECTIVE_DT                                        
                   ,EXPIRATION_DT                                       
                   ,COMMENT                                             
                   ,ADDRESS_ID                                          
                   ,MED_COND_CODE                                       
                   ,MEDICAL_COND_DESC                                   
                   ,AMBULANCE_FL                                        
                   ,PATIENT_ASSIST_FL                                   
                   ,PATIENT_RELATION                                    
                   ,PATIENT_PH_NO)                                      
               VALUES                                                   
                    (:WO-APPLICATION-ID                                 
                    ,:WO-ACCOUNT-NO                                     
                    ,:WO-NAME-ID                                        
                    ,:WO-PHYSICIAN-ID                                   
                    ,:WO-STATUS-CD                                      
                    ,IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
                    ,IIF(TRY_CONVERT(DATE, :WO-EFFECTIVE-DT 
                                           :WS-NULL-IND-EFF
              ) IS NULL OR (PATINDEX('%.%', :WO-EFFECTIVE-DT 
                                                       :WS-NULL-IND-EFF
              ) <> 0) OR (LEN(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) <> 10), CIS.CHAR2DATE(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ), CONVERT(DATE, :WO-EFFECTIVE-DT :WS-NULL-IND-EFF) )            
                    ,IIF(TRY_CONVERT(DATE, :WO-EXPIRATION-DT 
                                           :WS-NULL-IND-EXP
              ) IS NULL OR (PATINDEX('%.%', :WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ) <> 0) OR (LEN(:WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) <> 10), CIS.CHAR2DATE(:WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ), CONVERT(DATE, :WO-EXPIRATION-DT :WS-NULL-IND-EXP) )           
                    ,:WO-COMMENT                                        
                    ,:WO-ADDRESS-ID                                     
                    ,:WO-MED-COND-CODE                                  
                    ,:WO-MEDICAL-COND-DESC                              
                    ,:WO-AMBULANCE-FL                                   
                    ,:WO-PATIENT-ASSIST-FL                              
                    ,:WO-PATIENT-RELATION                               
                    ,:WO-PATIENT-PH-NO)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_WH_CROSS_PLUS                                    
MFA-TR*            (APPLICATION_ID                                              
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,NAME_ID                                                     
MFA-TR*            ,PHYSICIAN_ID                                                
MFA-TR*            ,STATUS_CD                                                   
MFA-TR*            ,DATE_TRANS                                                  
MFA-TR*            ,EFFECTIVE_DT                                                
MFA-TR*            ,EXPIRATION_DT                                               
MFA-TR*            ,COMMENT                                                     
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*            ,MED_COND_CODE                                               
MFA-TR*            ,MEDICAL_COND_DESC                                           
MFA-TR*            ,AMBULANCE_FL                                                
MFA-TR*            ,PATIENT_ASSIST_FL                                           
MFA-TR*            ,PATIENT_RELATION                                            
MFA-TR*            ,PATIENT_PH_NO)                                              
MFA-TR*        VALUES                                                           
MFA-TR*             (:WO-APPLICATION-ID                                         
MFA-TR*             ,:WO-ACCOUNT-NO                                             
MFA-TR*             ,:WO-NAME-ID                                                
MFA-TR*             ,:WO-PHYSICIAN-ID                                           
MFA-TR*             ,:WO-STATUS-CD                                              
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*             ,:WO-EFFECTIVE-DT:WS-NULL-IND-EFF                           
MFA-TR*             ,:WO-EXPIRATION-DT:WS-NULL-IND-EXP                          
MFA-TR*             ,:WO-COMMENT                                                
MFA-TR*             ,:WO-ADDRESS-ID                                             
MFA-TR*             ,:WO-MED-COND-CODE                                          
MFA-TR*             ,:WO-MEDICAL-COND-DESC                                      
MFA-TR*             ,:WO-AMBULANCE-FL                                           
MFA-TR*             ,:WO-PATIENT-ASSIST-FL                                      
MFA-TR*             ,:WO-PATIENT-RELATION                                       
MFA-TR*             ,:WO-PATIENT-PH-NO)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                 CONTINUE                                               
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8040'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PLUS'     TO TABLE-1                  
               MOVE 'APPLICATION_ID'        TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-3          
               MOVE 'PHYSICIAN_ID'          TO TABLE-ELEMENT-4          
               MOVE WO-APPLICATION-ID       TO HOSTVAR-ELEMENT-1        
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2        
               MOVE WO-NAME-ID              TO HOSTVAR-ELEMENT-3        
               MOVE WO-PHYSICIAN-ID         TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8050-INSERT-WCP-PTNT                                          *         
      *    INSERT INTO WH_CROSS_PATNT                                 *         
      *****************************************************************         
      *                                                                         
       8050-INSERT-WCP-PTNT.                                            
      *                                                                         
           IF  WP-PATIENT-DOB = SPACES OR LOW-VALUES                    
               MOVE -1          TO WS-NULL-IND-DOB                      
           ELSE                                                         
               MOVE 0           TO WS-NULL-IND-DOB                      
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_WH_CROSS_PATNT                           
                   (NAME_ID                                             
                   ,PATIENT_DOB)                                        
               VALUES                                                   
                    (:WP-NAME-ID                                        
                    ,IIF(TRY_CONVERT(DATE, :WP-PATIENT-DOB 
                                           :WS-NULL-IND-DOB
              ) IS NULL OR (PATINDEX('%.%', :WP-PATIENT-DOB 
                                                       :WS-NULL-IND-DOB
              ) <> 0) OR (LEN(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) <> 10), CIS.CHAR2DATE(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ), CONVERT(DATE, :WP-PATIENT-DOB :WS-NULL-IND-DOB) ))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_WH_CROSS_PATNT                                   
MFA-TR*            (NAME_ID                                                     
MFA-TR*            ,PATIENT_DOB)                                                
MFA-TR*        VALUES                                                           
MFA-TR*             (:WP-NAME-ID                                                
MFA-TR*             ,:WP-PATIENT-DOB:WS-NULL-IND-DOB)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 CONTINUE                                               
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PATNT'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-4        
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-1          
               MOVE 'PATIENT_DOB'           TO TABLE-ELEMENT-2          
               MOVE WP-NAME-ID              TO HOSTVAR-ELEMENT-1        
               MOVE WP-PATIENT-DOB          TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8055-UPDATE-WCP-PTNT                                           *        
      *    UPDATE WH_CROSS_PATNT                                       *        
      ******************************************************************        
      *                                                                         
       8055-UPDATE-WCP-PTNT.                                            
      *                                                                         
           IF  WP-PATIENT-DOB = SPACES OR LOW-VALUES                    
               MOVE -1          TO WS-NULL-IND-DOB                      
           ELSE                                                         
               MOVE 0           TO WS-NULL-IND-DOB                      
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_WH_CROSS_PATNT                                
                  SET PATIENT_DOB = IIF(TRY_CONVERT(DATE, 
                                                       :WP-PATIENT-DOB 
                                                       :WS-NULL-IND-DOB
              ) IS NULL OR (PATINDEX('%.%', :WP-PATIENT-DOB 
                                                       :WS-NULL-IND-DOB
              ) <> 0) OR (LEN(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) <> 10), CIS.CHAR2DATE(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ), CONVERT(DATE, :WP-PATIENT-DOB :WS-NULL-IND-DOB) )     
                WHERE NAME_ID = :WP-NAME-ID                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_WH_CROSS_PATNT                                        
MFA-TR*           SET PATIENT_DOB = :WP-PATIENT-DOB:WS-NULL-IND-DOB             
MFA-TR*         WHERE NAME_ID = :WP-NAME-ID                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 CONTINUE                                               
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8055'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PATNT'    TO TABLE-1                  
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-1          
               MOVE 'PATIENT_DOB'           TO TABLE-ELEMENT-2          
               MOVE WP-NAME-ID              TO HOSTVAR-ELEMENT-1        
               MOVE WP-PATIENT-DOB          TO HOSTVAR-ELEMENT-2        
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8055-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8060-INSERT-WCP-SSN                                           *         
      *    INSERT INTO WH_CROSS_SSN *                                           
      *****************************************************************         
      *                                                                         
       8060-INSERT-WCP-SSN.                                             
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_WH_CROSS_SSN                              
                     (SSN                                               
                     ,NAME_ID)                                          
              VALUES                                                    
                     (:WJ-SSN                                           
                     ,:WJ-NAME-ID)                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                 CONTINUE                                               
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8060'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_SSN '     TO TABLE-1                  
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-1          
               MOVE 'SSN'                   TO TABLE-ELEMENT-2          
               MOVE WJ-NAME-ID              TO HOSTVAR-ELEMENT-1        
               MOVE WJ-SSN                  TO HOSTVAR-ELEMENT-2        
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8070-UPDATE-NAME.                                             *         
      *    UPDATE CSS_NAME                                            *         
      *****************************************************************         
      *                                                                         
       8070-UPDATE-NAME.                                                
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_NAME                                          
                  SET FIRST_NAME     = :DQ-FIRST-NAME                   
                     ,MIDDLE_NAME    = :DQ-MIDDLE-NAME                  
                     ,LAST_NAME      = :DQ-LAST-NAME                    
                     ,TITLE_PREFIX   = :DQ-TITLE-PREFIX                 
                     ,TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1               
                     ,FULL_NAME      = :DQ-FULL-NAME                    
                WHERE NAME_ID        = :DQ-NAME-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'FIRST_NAME'             TO TABLE-ELEMENT-1          
              MOVE 'MIDDLE_NAME'            TO TABLE-ELEMENT-2          
              MOVE 'LAST_NAME'              TO TABLE-ELEMENT-3          
              MOVE DQ-FIRST-NAME            TO HOSTVAR-ELEMENT-1        
              MOVE DQ-MIDDLE-NAME           TO HOSTVAR-ELEMENT-2        
              MOVE DQ-LAST-NAME             TO HOSTVAR-ELEMENT-3        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-4          
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8085-UPDATE-WCP.                                              *         
      *    UPDATE CSS_WH_CROSS_PLUS                                   *         
      *****************************************************************         
      *                                                                         
       8085-UPDATE-WCP.                                                 
      *                                                                         
           IF  WO-EFFECTIVE-DT = SPACES OR LOW-VALUES                   
               MOVE -1                      TO WS-NULL-IND-EFF          
           ELSE                                                         
               MOVE 0                       TO WS-NULL-IND-EFF          
           END-IF                                                       
      *                                                                         
           IF  WO-EXPIRATION-DT = SPACES OR LOW-VALUES                  
               MOVE -1                      TO WS-NULL-IND-EXP          
           ELSE                                                         
               MOVE 0                       TO WS-NULL-IND-EXP          
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_WH_CROSS_PLUS                                  
                 SET NAME_ID           = :WO-NAME-ID                    
                    ,PHYSICIAN_ID      = :WO-PHYSICIAN-ID               
                    ,STATUS_CD         = :WO-STATUS-CD                  
                    ,DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                         :WO-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WO-DATE-TRANS
              ) <> 0) OR (LEN(:WO-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :WO-DATE-TRANS
              ), CONVERT(DATE, :WO-DATE-TRANS) )                 
                    ,EFFECTIVE_DT      = IIF(TRY_CONVERT(DATE, 
                                                      :WO-EFFECTIVE-DT 
                                                       :WS-NULL-IND-EFF
              ) IS NULL OR (PATINDEX('%.%', :WO-EFFECTIVE-DT 
                                                       :WS-NULL-IND-EFF
              ) <> 0) OR (LEN(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) <> 10), CIS.CHAR2DATE(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ), CONVERT(DATE, :WO-EFFECTIVE-DT :WS-NULL-IND-EFF) )            
                    ,EXPIRATION_DT    =  IIF(TRY_CONVERT(DATE, 
                                                     :WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ) IS NULL OR (PATINDEX('%.%', :WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ) <> 0) OR (LEN(:WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) <> 10), CIS.CHAR2DATE(:WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ), CONVERT(DATE, :WO-EXPIRATION-DT :WS-NULL-IND-EXP) )           
                    ,COMMENT           = :WO-COMMENT                    
                    ,ADDRESS_ID        = :WO-ADDRESS-ID                 
                    ,MED_COND_CODE     = :WO-MED-COND-CODE              
                    ,MEDICAL_COND_DESC = :WO-MEDICAL-COND-DESC          
                    ,AMBULANCE_FL      = :WO-AMBULANCE-FL               
                    ,PATIENT_ASSIST_FL = :WO-PATIENT-ASSIST-FL          
                    ,PATIENT_RELATION  = :WO-PATIENT-RELATION           
                    ,PATIENT_PH_NO     = :WO-PATIENT-PH-NO              
                  WHERE APPLICATION_ID = :WO-APPLICATION-ID             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_WH_CROSS_PLUS                                          
MFA-TR*          SET NAME_ID           = :WO-NAME-ID                            
MFA-TR*             ,PHYSICIAN_ID      = :WO-PHYSICIAN-ID                       
MFA-TR*             ,STATUS_CD         = :WO-STATUS-CD                          
MFA-TR*             ,DATE_TRANS        = :WO-DATE-TRANS                         
MFA-TR*             ,EFFECTIVE_DT      = :WO-EFFECTIVE-DT                       
MFA-TR*                                  :WS-NULL-IND-EFF                       
MFA-TR*             ,EXPIRATION_DT    =  :WO-EXPIRATION-DT                      
MFA-TR*                                  :WS-NULL-IND-EXP                       
MFA-TR*             ,COMMENT           = :WO-COMMENT                            
MFA-TR*             ,ADDRESS_ID        = :WO-ADDRESS-ID                         
MFA-TR*             ,MED_COND_CODE     = :WO-MED-COND-CODE                      
MFA-TR*             ,MEDICAL_COND_DESC = :WO-MEDICAL-COND-DESC                  
MFA-TR*             ,AMBULANCE_FL      = :WO-AMBULANCE-FL                       
MFA-TR*             ,PATIENT_ASSIST_FL = :WO-PATIENT-ASSIST-FL                  
MFA-TR*             ,PATIENT_RELATION  = :WO-PATIENT-RELATION                   
MFA-TR*             ,PATIENT_PH_NO     = :WO-PATIENT-PH-NO                      
MFA-TR*           WHERE APPLICATION_ID = :WO-APPLICATION-ID                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8085'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_WH_CROSS_PLUS'      TO TABLE-1                  
              MOVE 'APPLICATION_ID'         TO TABLE-ELEMENT-1          
              MOVE WO-APPLICATION-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'NAME_ID'                TO TABLE-ELEMENT-3          
              MOVE WO-NAME-ID               TO HOSTVAR-ELEMENT-3        
              MOVE 'PHYSICIAN_ID'           TO TABLE-ELEMENT-4          
              MOVE WO-PHYSICIAN-ID          TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8087-DELETE-DNP-ROW.                                         *        
      *        DELETES THE RECORD FROM THE  CURSOR                     *        
      ******************************************************************        
      *                                                                         
       8087-DELETE-DNP-ROW.                                             
      *                                                                         
           MOVE '8087'                      TO WS-ACTIVE-PARAGRAPH      
                                                                        
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_CRED_COLL                                     
                WHERE CURRENT OF DNP_CSR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-YES                   TO WS-DELETE-DNP-FL         
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8087'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_CRED_COLL'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8087-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8090-UPDT-CODE-CRIT.                                          *         
      *    UPDATE CSS_ACCOUNT                                         *         
      *****************************************************************         
      *                                                                         
       8090-UPDT-CODE-CRIT.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE           
                     ,LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE                   
MFA-TR*              ,LAST_UPDATE_TS   = :WS-CURRENT-TIMESTAMP                  
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8090'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CODE_CRIT_OUTAGE'       TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CODE-CRIT-OUTAGE      TO HOSTVAR-ELEMENT-1        
              MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 8890-DELETE-WCP-SSN.                                          *         
      *****************************************************************         
      *                                                                         
       8890-DELETE-WCP-SSN.                                             
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_WH_CROSS_SSN                                  
                WHERE SSN     = :WJ-SSN                                 
                  AND NAME_ID = :WJ-NAME-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8890'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_SSN'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'NAME_ID'               TO TABLE-ELEMENT-2          
               MOVE WJ-NAME-ID              TO HOSTVAR-ELEMENT-2        
               MOVE 'SSN '                  TO TABLE-ELEMENT-3          
               MOVE WJ-SSN                  TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
