      ******************************************************************        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04857.                                     
COB303 DATE-WRITTEN.      APRIL 9, 2015.                                
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04857              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04857 :                                                --         
      *--                                                            --         
      *--    #  UPDATES SERVICE REQUEST ORDER STATE AND/OR ORDER TYPE--         
      *--    #  FOR AOO MAINTENANCE DIALOGS                          --         
      *--    #  BUS OP - UPDSOMAINTENANCEDETAILS                     --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--      IN                                                    --         
      *--                                                                       
      *--            SERV_ORDER_NO                                              
      *--            ORDER_TYPE_CD                                              
      *--            ORDER_STATE_CD                                             
      *--            USER_ID                                                    
      *--            COMMENTS                                                   
      *--            DNP_CANCEL_REASON                                          
      *--                                                                       
      *--      OUT                                                   --         
      *--                                                            --         
      *--            RETURN_CODE                                     --         
      *--*           DO_NOT_CANCEL_RSN                               --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  2015-04-09    DB18339     NEW CODE                        --         
D10154*--  2016-02-10    PK44514     SEND CANCEL TO CLICK FOR HOLD   --         
      *--                            TURNED DOWN COMPANY, TURNED DOWN--         
      *--                            CUSTOMER AND PAYMENT REQUIRED   --         
      *--  2015-11-24    DB18339     DEFECT 9512 - ADDED PROCESS FOR --         
      *--                            DNP/DNPFB CANCELS.              --         
      *--                            PK44514-REMOVE DNP_CANCEL INPUT --         
      *--                            PARM FOR 7.0                    --         
      *--  2015-12-18    DB18339     DEFECT 9862 - CHECKING AR BAL   --         
      *--                            BEFORE PREVENTING CANCEL.       --         
D11384*--  2016-06-02    PK44514     UPDATE PREMISE TABLE DETAILS    --         
      *--                            WHEN CANCELLING AN ORDER        --         
D11899*--  2016-07-14    PK44514     CHANGING ORDER TYPE ON FRO ORDER--         
      *--                            SHOULD NOT GO TO CLICK          --         
D12146*--  2016-08-30    PK44514     CHECK ONLY FOR PENDING DEPOSIT  --         
      *--                            WHEN CANCELLING ORDER           --         
P0795O*--  2016-08-30    PK44514     REPLACE CSR00028 WITH CSR04675  --         
      *--                PK44514     FOR WQS                         --         
      *--  2016-09-21    MF18988     ADD SERV-ORDER-NO AND           --         
      *--                            REQUIREMENT-CD = '2' TO         --         
      *--                            7200-CHECK-PRINT-REQ.           --         
      *--                            DEFECT# 9265                    --         
P01176*--  2016-11-07    PK44514     GAS SAMPLING CHANGES-UPDATE GAS --         
      *--                            SAMP FL TO N WHEN ORDER CANCELLED-         
D26047*--  2017-01-12    PK44514     FIXING QUERY 7000. REMOVING JOIN--         
      *--                            TO CSS_ACCOUNT AS IT WAS FAILING--         
      *--                            FOR PREMISE ONLY.               --         
D26207*--  2017-02-06    PK44514     ADDED CODE FOR SEB TO DELETE    --         
      *--                            RECONN AGRMNT AND SEND PAID TRAN--         
      *--                            WHEN RECONN ORDER IS CANCELLED. --         
D26401*--  2017-02-15    PK44514     DO NOT SEND CANCEL IN BATCH FOR --         
      *--                            PR ORDERS. IT IS DONE ONLINE    --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ002  01 MFA-CSR00064.
MSQ002    05 ARG-3 PIC X(26).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04857'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT - AT                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_SO_DATA - VO                                                        
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_ORDER_INST - VI                                                  
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_APPLIANCE - VQ                                                   
           EXEC SQL                                                             
               INCLUDE TBSOEQP                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_MTRD_ENVRNMT - MN                                                   
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_ROUTE_REPORT - PW                                                   
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_WORK_AREA - I2                                                      
           EXEC SQL                                                             
               INCLUDE TBWKAR                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_SO_CAD_QUEUE   (PREFIX = QP)                                        
           EXEC SQL                                                             
               INCLUDE TBCADPQU                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_SO_TASK_QUEUE (PREFIX = TQ)                                         
           EXEC SQL                                                             
               INCLUDE TBTSKQUE                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_SO_PRINT_LOC (PREFIX = C4)                                          
           EXEC SQL                                                             
               INCLUDE TBSOLOC                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_REQUIREMENT (PREFIX = EG)                                        
           EXEC SQL                                                             
               INCLUDE TBSOREQ                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_GASLINE_SO_XRF (PREFIX = XX)                                        
           EXEC SQL                                                             
               INCLUDE TBGASSO                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_GAS_SERV_LINE  (PREFIX = XO)                                        
           EXEC SQL                                                             
               INCLUDE TBGASSRV                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_PREM_GAS_LINE  (PREFIX = Y0)                                        
           EXEC SQL                                                             
               INCLUDE TBPREMLN                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_AR_CNTL (PREFIX = AC)                                               
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_DEP_ON_HAND (PREFIX = DO)                                           
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
                                                                        
DT9512     EXEC SQL                                                             
DT9512        INCLUDE TBDELQ                                                    
DT9512     END-EXEC.                                                            
                                                                        
      * CSS_SO_CREW     (PREFIX = TE)                                           
           EXEC SQL                                                     01050000
              INCLUDE TBSOCREW                                          01060000
           END-EXEC.                                                    01070000
                                                                        
      * CSS_SO_DNP      (PREFIX = AI)                                           
           EXEC SQL                                                     01050000
              INCLUDE TBSODNP                                           01060000
           END-EXEC.                                                    01070000
                                                                        
      * CSS_CRED_COLL   (PREFIX = CL)                                           
           EXEC SQL                                                     01050000
              INCLUDE TBCRCOLL                                          01060000
           END-EXEC.                                                    01070000
                                                                        
      *****************************************************************         
      * CURSOR DECLARATIONS                                           *         
      *****************************************************************         
           EXEC SQL                                                     
            DECLARE MM_CURSOR CURSOR FOR                                
             SELECT Y0.PREMISE_NO                                       
               FROM CSS_PREM_GAS_LINE Y0                                
             WHERE Y0.SERVICE_NO = :XX-SERVICE-NO                       
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-SERV-ORDER-NO      PIC X(13).                       
           05  PARM-SERV-ORDER-NO-NUM REDEFINES PARM-SERV-ORDER-NO      
                                       PIC 9(13).                       
           05  PARM-ORDER-TYPE-CD      PIC X(05).                       
           05  PARM-ORDER-STATE-CD     PIC X(01).                       
           05  PARM-USER-ID            PIC X(07).                       
           05  PARM-COMMENTS           PIC X(210).                      
           05  PARM-DNP-CANCEL-RSN     PIC X(01).                       
                                                                        
       01  MISC-FIELDS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04857'.      
           05  WS-SQLSTATE             PIC X(05) VALUE  SPACES.         
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
                                                                        
       01 WS-MISC.                                                      
          05 WS-RETURN-CODE-4747        PIC S9(09) COMP VALUE +0.       
          05 WS-WORK-DISTRICT-4747      PIC X(40).                      
          05 WS-RETURN-CODE-0200        PIC S9(09) COMP VALUE +0.       
          05 WS-HOLD-ORDERS-0200        PIC X(01).                      
          05 WS-RETURN-CODE-1287        PIC S9(09) COMP VALUE +0.       
D12146*   05 WS-RETURN-CODE-2159        PIC S9(09) COMP VALUE +0.               
          05 WS-AR-CNTL-EXISTS          PIC X(01) VALUE 'N'.            
          05 WS-AMT-DNP-ACCOUNT         PIC 9(3).9(2).                  
          05 WS-RESP-AREA-ID            PIC X(03).                      
          05 WS-USER-ID                 PIC X(07).                      
          05 WS-ORDER-STATE-DESC        PIC X(20) VALUE 'ACTIVE'.       
          05 WS-REMARK-TYPE             PIC X(01).                      
          05 WS-PRINT-WA                PIC X(01) VALUE 'N'.            
          05 WS-PRINT-REQ               PIC X(01) VALUE 'N'.            
          05 WS-NULL-1                  PIC S9(04) COMP VALUE +0.       
          05 WS-NULL-2                  PIC S9(04) COMP VALUE +0.       
          05 WS-WORK-AREA-ID            PIC X(08).                      
          05 WS-NEW-ORDER-TYPE-CD       PIC X(05).                      
          05 WS-NEW-ORDER-STATE-CD      PIC X(01) VALUE SPACES.         
          05 WS-PAYMENT-FL              PIC X(01) VALUE SPACES.         
          05 WS-WORK-DISTRICT           PIC X(40) VALUE ' '.            
          05 WS-TIME                    PIC X(26).                      
D12146    05 WS-PENDING-DEPOSIT-EXIST   PIC X(01) VALUE 'N'.            
D26070    05 WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.        
          05 WS-COMMENTS                PIC X(210) VALUE ' '.           
          05 WS-LOG-COMMENTS            PIC X(210) VALUE ' '.           
          05 WS-PARM-COMMENTS           PIC X(210) VALUE ' '.           
          05 WS-WA-COMMENTS             PIC X(20) VALUE ' '.            
          05 WS-WQ-COMMENTS.                                            
             10 WS-WQ-PREFIX            PIC X(06) VALUE 'ORDER '.       
             10 WS-SERV-ORDER-NO        PIC X(13) VALUE ' '.            
             10 WS-WQ-SUFFIX            PIC X(45) VALUE ' '.            
          05 WS-WQ-COMMENTS-1.                                          
             10  F                    PIC X(40) VALUE                   
             'PAYMENT RECEIVED,DNP STATE IS COMPLETE,'.                 
             10  F                    PIC X(47) VALUE                   
             'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT.'.           
          05 WS-WQ-COMMENTS-2.                                          
             10  F                    PIC X(37) VALUE                   
             'CONTACT IST CSR APPLICATION SUPPORT. '.                   
             10  F                    PIC X(56) VALUE                   
             'RESCHEDULED DNP PROCESS FAILED (CSR02122) DUE TO ERROR. '.
             10  F                    PIC X(35) VALUE                   
             'SEE CSS_ERROR_LOG FOR MORE DETAILS.'.                     
          05 WS-APPL-PGM-ID             PIC X(04) VALUE ' '.            
          05 WS-SERV-LINE-EXISTS        PIC X(01) VALUE ' '.            
COB305    05 WS-GAS-SVC-PREM-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
          05  WS-PREMISE-NO-NUM         PIC 9(10).                      
          05  WS-PREMISE-NO-CHAR        REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
D11384    05 WS-NULL-IND                PIC S9(4)   COMP.               
D11384    05 WS-SERV-ORDER-PEND         PIC X(01).                      
D11384    05 WS-SO-OFF-DATE             PIC X(10).                      
D11384    05 WS-ASSIGNED-DATE           PIC X(10).                      
DT9512    05  WS-DATABASE              PIC 9(01) VALUE ZERO.            
DT9512        88  CSR-DATABASE                   VALUE 1.               
DT9512        88  SEB-DATABASE                   VALUE 2.               
                                                                        
      *01 LOC04747 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
D10154*01 LOC04747C USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.       
      *01 LOC00200 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC01287 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC04251 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC02159 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC0125 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2122 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
D26207*01 LOC4759 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
D26207*01 LOC1334 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  ABEND-CODES.                                                 
           05  DATE-ERROR              PIC S9(9) VALUE -180 COMP.       
                                                                        
       01  WS-DATE-FIELDS.                                              
           05  WS-ASSIGNED-DT          PIC X(10).                       
           05  WS-CURRENT-DT           PIC X(10).                       
           05  WS-LAST-DT              PIC X(10).                       
           05  WS-LAST-TS              PIC X(26).                       
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE         PIC S9(9) VALUE 0 COMP.            
           05 RS-NO-CANCEL-RSN       PIC X(05) VALUE SPACES.            
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           05 S-NO-CANCEL-RSN        PIC X(05) VALUE SPACES.            
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
                                                                        
P0795O******************************************************************        
P0795O* CSR04675 - WRITE A WQ                                          *        
P0795O******************************************************************        
P0795O                                                                  
P0795O 01  CSR04675-CALL-DATA.                                          
P0795O     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
P0795O     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
P0795O     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
P0795O     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
P0795O     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
P0795O     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
P0795O     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
P0795O     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
P0795O     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
P0795O     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
P0795O     05  COMMENTS-4675.                                           
P0795O        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
P0795O        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
P0795O     05  FREE-FORM-DATA-4675.                                     
P0795O        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
P0795O        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
P0795O     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
P0795O*                                                                         
P0795O 01  CSR04675-RETURN-DATA.                                        
P0795O     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
P0795O     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
P0795O*                                                                         
                                                                        
       01  CSR04251-RETURN-DATA.                                        
           03  RETURN-CODE-4251         PIC S9(9) COMP VALUE 0.         
           03  OLD-WORK-AREA-4251       PIC X(12) VALUE SPACES.         
           03  OLD-WORK-AREA-TX-4251    PIC X(40) VALUE SPACES.         
           03  NEW-WORK-AREA-4251       PIC X(12) VALUE SPACES.         
           03  LOCAL-OFFICE-4251        PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-4251      PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-4251        PIC X(03) VALUE SPACES.         
           03  CRAWL-IND-4251           PIC X(01) VALUE SPACES.         
           03  METER-IND-4251           PIC X(01) VALUE SPACES.         
           03  ZIP-CODE-4251            PIC X(05) VALUE SPACES.         
           03  READ-ROUTE-4251          PIC X(04) VALUE SPACES.         
           03  POINT-ID-4251            PIC X(10) VALUE SPACES.         
           03  BUSINESS-UNIT-4251       PIC X(03) VALUE SPACES.         
                                                                        
       01  CSR00125-CALL-DATA.                                          
           05  ACCOUNT-NO-0125           PIC X(13) VALUE SPACES.        
           05  PREMISE-NO-0125           PIC X(10) VALUE SPACES.        
           05  USER-ID-0125              PIC X(07) VALUE SPACES.        
           05  REMARKS-0125.                                            
               49 REMARKS-0125-LEN       PIC S9(4) USAGE COMP VALUE 0.  
               49 REMARKS-0125-TEXT      PIC X(45) VALUE SPACES.        
           05  UPDATE-REMARKS-0125       PIC X(01) VALUE SPACES.        
           05  SELECT-UPDATE-FL-0125     PIC X(01) VALUE SPACES.        
           05  PANEL-NO-0125             PIC X(04) VALUE SPACES.        
           05  ORDER-TYPE-FL-0125        PIC X(01) VALUE SPACES.        
           05  CANCEL-REASON-0125        PIC X(01) VALUE SPACES.        
                                                                        
       01  CSR00125-RETURN-DATA.                                        
           05  RETURN-CODE-0125          PIC S9(9) COMP VALUE 0.        
           05  SERV-ORDER-NO-0125        PIC X(13) VALUE SPACES.        
           05  ORDER-REASON-0125         PIC X(01) VALUE SPACES.        
           05  RESP-AREA-0125            PIC X(03) VALUE SPACES.        
           05  PENDING-SO-FL-0125        PIC X(01) VALUE SPACES.        
           05  INSERT-WQ-FL-0125         PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-0125      PIC X(11) VALUE SPACES.        
           05  ORDER-TYPE-CD-0125        PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
       01  CSR02122-CALL-DATA.                                          
           05  ACCOUNT-NO-2122           PIC X(13) VALUE SPACES.        
           05  PREMISE-NO-2122           PIC X(10) VALUE SPACES.        
           05  ORDER-REASON-2122         PIC X(02) VALUE SPACES.        
           05  CANCEL-REASON-2122        PIC X(01) VALUE SPACES.        
           05  PENDING-SO-FLAG-2122      PIC X(01) VALUE SPACES.        
           05  UPDATE-PROFILE-2122       PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-2122      PIC X(11) VALUE SPACES.        
           05  PANEL-NO-2122             PIC X(04) VALUE SPACES.        
           05  ORDER-TYPE-2122           PIC X(05) VALUE SPACES.        
           05  REMARK-TX-2122.                                          
              49 COMMENTS-2122-LEN       PIC S9(4) USAGE COMP VALUE 0.  
              49 COMMENTS-2122-TEXT      PIC X(210) VALUE SPACES.       
       01  CSR02122-RETURN-DATA.                                        
           05  RETURN-CODE-2122          PIC S9(9) COMP VALUE 0.        
                                                                        
                                                                        
D12146 01  CSR02159-CALL-DATA.                                          
           05  ACCOUNT-NO-2159           PIC X(13) VALUE SPACES.        
D12146 01  CSR02159-RETURN-DATA.                                        
           05 RETURN-CODE-2159           PIC S9(9) COMP VALUE 0.        
           05 DEPOSIT-CERT-NO-2159       PIC S9(9) COMP VALUE 0.        
           05 ORIG-DEP-AMT-2159          PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 AMT-REFUNDED-2159          PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 TRANSFER-AMT-2159          PIC S9(7)V9(2)  COMP-3 VALUE 0.
           05 AMT-DEPOSIT-2159           PIC S9(7)V9(2)  COMP-3 VALUE 0.
           05 TRANSFERRED-TO-2159        PIC X(13).                     
           05 DEP-CERT-NO-TO-2159        PIC X(09).                     
           05 TRANSFERRED-FROM-2159      PIC X(13).                     
           05 DEP-CERT-NO-FROM-2159      PIC X(09).                     
           05 SERVICE-TYPE-CD-2159       PIC X(1)  VALUE SPACES.        
           05 REPEAT-COUNT-2159          PIC S9(4) COMP VALUE 1.        
           05 DATE-TRANS-2159            PIC X(10) VALUE SPACES.        
           05 AMT-POSTED-2159            PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 DEP-PAY-DT-2159            PIC X(10) VALUE SPACES.        
           05 DEP-PAY-AMT-2159           PIC S9(7)V9(2)  COMP-3 VALUE 0.
           05 INT-CREDIT-DT-2159         PIC X(10) VALUE SPACES.        
           05 INTEREST-AMT-2159          PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 INTEREST-RT-2159           PIC S9(3)V9(4)  COMP-3 VALUE 0.
           05 EFFECTIVE-DT-2159          PIC X(10) VALUE SPACES.        
           05 REV-DISTRICT-DESC-2159     PIC X(35) VALUE SPACES.        
           05 DATE-REFUND-2159           PIC X(10) VALUE SPACES.        
           05 MANUAL-INDICATOR-2159      PIC X(01) VALUE SPACES.        
           05 DEP-AMT-REFUNDED-2159      PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 INT-AMT-REFUNDED-2159      PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 TOT-AMT-REFUNDED-2159      PIC S9(9)V9(2)  COMP-3 VALUE 0.
           05 CHECK-ISS-REAS-CD-2159     PIC X(02) VALUE SPACES.        
           05 CHECK-STATUS-CD-2159       PIC X(01) VALUE SPACES.        
           05 USER-NAME-RQSTED-BY-2159   PIC X(29) VALUE SPACES.        
           05 USER-NAME-APPRVD-BY-2159   PIC X(29) VALUE SPACES.        
           05 ACCT-NO-CREDITED-2159      PIC X(13) VALUE SPACES.        
           05 COMMENTS-2159              PIC X(72) VALUE SPACES.        
           05 DEPOSIT-STATUS-CD-2159     PIC X(01) VALUE SPACES.        
           05 DATE-TRAN-2159             PIC X(10) VALUE SPACES.        
                                                                        
                                                                        
D26207 01  CSR04759-CALL-DATA.                                          
           05 ACCOUNT-NO-4759                PIC X(13).                 
           05 ACTION-CODE-4759               PIC X(01).                 
           05 AGREEMENT-COMMENTS-4759        PIC X(26).                 
COB305     05 AMT-TOT-RECONNECT-4759        PIC S9(11)V9(2) COMP-3 
COB305       VALUE 0.    
COB305     05 RECNCT-COLLECT-AMT-4759        PIC S9(07)V9(2) COMP-3 
COB305       VALUE 0.    
           05 RECNCT-TYPE-CD-4759            PIC X(03).                 
           05 USER-ID-4759                   PIC X(07).                 
           05 TRANS-CMT-4759                 PIC X(210).                
           05 TRANS-CMT-LEN-4759             PIC X(4).                  
           05 AUTO-DEP-ID-4759               PIC S9(09) COMP.           
           05 AUTO-DEP-LTR-IND-4759          PIC X(01).                 
COB305     05 AUTO-DEP-AMT-4759        PIC S9(09)V99 COMP-3 VALUE 0.      
COB305     05 RECALC-AUTO-DEP-AMT-4759        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.      
COB305     05 NOTC-AUTO-DEP-AMT-4759        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.      
COB305     05 DEP-COLLECT-AMT-4759        PIC S9(09)V99 COMP-3 VALUE 0.      
           05 DEP-BILL-OPT-CD-4759           PIC X(01).                 
           05 NO-SCHED-PYMTS-4759            PIC S9(09) COMP.           
           05 START-DATE-4759                PIC X(10).                 
COB305     05 MTHLY-INSTALL-AMT-4759        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.      
           05 RECALC-UPDT-4759               PIC X(01).                 
           05 RCNCT-TERM-ID-4759             PIC S9(04) COMP.           
           05 LAST-UPDATE-USERID-4759        PIC X(07).                 
           05 RCC-BILL-OPTION-CD-4759        PIC X(01).                 
           05 LAST-UPDATE-TS-4759            PIC X(26).                 
                                                                        
D26207 01  CSR04759-RETURN-DATA.                                        
           05 S-RETURN-CODE-4759            PIC S9(09) COMP VALUE 0.    
           05 S-RETURN-MESSAGE-4759         PIC X(50) VALUE SPACES.     
           05 S-APPL-RETURN-CODE-4759       PIC X(10)  VALUE SPACES.    
           05 S-AUTO-DEP-AMT-4759           PIC S9(09)V99 COMP-3        
                                                VALUE 0.                
           05 S-DEP-SUCCESS-4759            PIC X(01)  VALUE SPACES.    
           05 S-DEP-CERT-NO-4759            PIC S9(9)  COMP VALUE 0.    
           05 S-ABEND-PROGRAM-4759          PIC X(08)  VALUE SPACES.    
           05 S-ACTIVE-PARAGRAPH-4759       PIC X(04)  VALUE SPACES.    
           05 S-ABEND-FUNCTION-4759         PIC X(08)  VALUE SPACES.    
           05 S-TABLE-1-4759                PIC X(20)  VALUE SPACES.    
           05 S-TABLE-ELEMENT-1-4759        PIC X(20)  VALUE SPACES.    
           05 S-HOSTVAR-ELEMENT-1-4759      PIC X(20)  VALUE SPACES.    
           05 S-TABLE-ELEMENT-2-4759        PIC X(20)  VALUE SPACES.    
           05 S-HOSTVAR-ELEMENT-2-4759      PIC X(20)  VALUE SPACES.    
           05 S-TABLE-ELEMENT-3-4759        PIC X(20)  VALUE SPACES.    
           05 S-HOSTVAR-ELEMENT-3-4759      PIC X(20)  VALUE SPACES.    
           05 S-TABLE-ELEMENT-4-4759        PIC X(20)  VALUE SPACES.    
           05 S-HOSTVAR-ELEMENT-4-4759      PIC X(20)  VALUE SPACES.    
                                                                        
      *                                                                         
D26070 01  CSR01334-CALL-DATA.                                          
           03  SERV-ORDER-NO-1334       PIC X(13) VALUE SPACES.         
           03  PRINT-DEST-1334          PIC X(15) VALUE SPACES.         
           03  PRINT-DEST-IND-1334      PIC X(01) VALUE SPACES.         
           03  USER-ID-1334             PIC X(07) VALUE SPACES.         
           03  CAD-TRANS-TYPE-1334      PIC X(01) VALUE SPACES.         
                                                                        
D26070 01  CSR01334-RETURN-DATA.                                        
           05  RETURN-CODE-1334      PIC S9(9)     COMP VALUE 0.        
           05  ITEM-ID-1334          PIC S9(10)V   COMP-3 VALUE 0.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0125 CURSOR
MSQ001          FOR CALL CSR00125                                             
                  ( :ACCOUNT-NO-0125
                  , :PREMISE-NO-0125
                  , :USER-ID-0125
                  , :REMARKS-0125
                  , :UPDATE-REMARKS-0125
                  , :SELECT-UPDATE-FL-0125
                  , :PANEL-NO-0125
                  , :ORDER-TYPE-FL-0125
                  , :CANCEL-REASON-0125
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2122 CURSOR
MSQ001          FOR CALL CSR02122                                             
                  ( :ACCOUNT-NO-2122
                  , :PREMISE-NO-2122
                  , :ORDER-REASON-2122
                  , :CANCEL-REASON-2122
                  , :PENDING-SO-FLAG-2122
                  , :UPDATE-PROFILE-2122
                  , :AMOUNT-DISC-BAL-2122
                  , :PANEL-NO-2122
                  , :ORDER-TYPE-2122
                  , :REMARK-TX-2122
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
P0795O            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_1287 CURSOR
MSQ001          FOR CALL CSR01287 ( :VO-WORK-AREA-ID
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_2159 CURSOR
MSQ001          FOR CALL CSR02159( :ACCOUNT-NO-2159
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747 ( :VO-SERV-ORDER-NO
                  , '1'
                  , 'S'
                  , ' '
                  , :WS-WORK-DISTRICT OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747C CURSOR
MSQ001          FOR CALL CSR04747 ( :VO-SERV-ORDER-NO
                  , '1'
                  , 'M'
                  , :WS-USER-ID
                  , :WS-WORK-DISTRICT OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_0200 CURSOR
MSQ001          FOR CALL CSR00200 ( :VO-SERV-ORDER-NO
                  , :VO-ORDER-TYPE-CD
                  , :WS-USER-ID
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_DUMMY_CSR04078_1 CURSOR
MSQ001          FOR CALL CSR04078 ( 'D'
                  , :WS-GAS-SVC-PREM-NO
                  , :XX-SERVICE-NO
                  , ''
                  , ''
                  , ''
                  , 0
                  , 0
                  , 0
                  , 0.0
                  , ''
                  , ''
                  , ''
                  , ''
                  , ''
                  , :WS-USER-ID
                  , 'MODM'
                  , ''
                  , ''
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4251 CURSOR
MSQ001          FOR CALL CSR04251                                             
                   ( :VO-SERV-ORDER-NO
                  , 'N'
                  , :WS-USER-ID
                  , 'AROP'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4759 CURSOR
MSQ001          FOR CALL CSR04759                                             
                   ( :ACCOUNT-NO-4759
                  , :ACTION-CODE-4759
                  , :AGREEMENT-COMMENTS-4759
                  , :AMT-TOT-RECONNECT-4759
                  , :RECNCT-COLLECT-AMT-4759
                  , :RECNCT-TYPE-CD-4759
                  , :USER-ID-4759
                  , :TRANS-CMT-4759
                  , :TRANS-CMT-LEN-4759
                  , :AUTO-DEP-ID-4759
                  , :AUTO-DEP-LTR-IND-4759
                  , :AUTO-DEP-AMT-4759
                  , :RECALC-AUTO-DEP-AMT-4759
                  , :NOTC-AUTO-DEP-AMT-4759
                  , :DEP-COLLECT-AMT-4759
                  , :DEP-BILL-OPT-CD-4759
                  , :NO-SCHED-PYMTS-4759
                  , :START-DATE-4759
                  , :MTHLY-INSTALL-AMT-4759
                  , :RECALC-UPDT-4759
                  , :RCNCT-TERM-ID-4759
                  , :LAST-UPDATE-USERID-4759
                  , :RCC-BILL-OPTION-CD-4759
                  , :LAST-UPDATE-TS-4759
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1334 CURSOR
MSQ001          FOR CALL CSR01334                                             
                  ( :SERV-ORDER-NO-1334
                  , :PRINT-DEST-1334
                  , :PRINT-DEST-IND-1334
                  , :USER-ID-1334
                  , :CAD-TRANS-TYPE-1334
                  )
MSQ001        END-EXEC.
      
                                                                        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01    LINK-SERV-ORDER-NO        PIC X(13).                       
       01    LINK-ORDER-TYPE-CD        PIC X(05).                       
       01    LINK-ORDER-STATE-CD       PIC X(01).                       
       01    LINK-USER-ID              PIC X(07).                       
       01    LINK-COMMENTS             PIC X(210).                      
       01    LINK-DNP-CANCEL-RSN       PIC X(01).                       
                                                                        
       PROCEDURE DIVISION USING LINK-SERV-ORDER-NO                      
                                LINK-ORDER-TYPE-CD                      
                                LINK-ORDER-STATE-CD                     
                                LINK-USER-ID                            
                                LINK-COMMENTS                           
                                LINK-DNP-CANCEL-RSN.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-INPUT   THRU 1000-EXIT.                 
           PERFORM 2000-PROCESS-OUTPUT  THRU 2000-EXIT.                 
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS                                 
                      GTT-RETURN-FIELDS                                 
                      WS-MISC.                                          
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE AS RETURN_CODE,                    
                      :S-NO-CANCEL-RSN AS DO_NOT_CANCEL_RSN             
               FROM                                                     
               CIS.SYSDUMMY1                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE AS RETURN_CODE,                            
MFA-TR*               :S-NO-CANCEL-RSN AS DO_NOT_CANCEL_RSN                     
MFA-TR*        FROM                                                             
MFA-TR*        SYSIBM.SYSDUMMY1                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *0100A-DECLARE-GTT                                              *         
      *****************************************************************         
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04857_R1'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04857_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04857_R1
              (                                                       
                      RETURN_CODE           INT,                    
                      DO_NOT_CANCEL_RSN CHAR(05)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS                             
                                         THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04857_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
              PERFORM 8250-SEND-NULL-CODE THRU 8250-EXIT
           END-IF.               
                                                                        
           MOVE LINK-SERV-ORDER-NO  TO PARM-SERV-ORDER-NO.              
           MOVE LINK-ORDER-TYPE-CD  TO PARM-ORDER-TYPE-CD.              
           MOVE LINK-ORDER-STATE-CD TO PARM-ORDER-STATE-CD.             
           MOVE LINK-USER-ID        TO PARM-USER-ID.                    
           MOVE LINK-COMMENTS       TO PARM-COMMENTS.                   
           MOVE LINK-DNP-CANCEL-RSN TO PARM-DNP-CANCEL-RSN.             
                                                                        
           MOVE PARM-SERV-ORDER-NO TO VO-SERV-ORDER-NO                  
                                      VI-SERV-ORDER-NO.                 
           MOVE PARM-ORDER-TYPE-CD TO WS-NEW-ORDER-TYPE-CD.             
           MOVE PARM-ORDER-STATE-CD TO WS-NEW-ORDER-STATE-CD.           
           MOVE PARM-USER-ID        TO WS-USER-ID.                      
           MOVE PARM-COMMENTS       TO WS-PARM-COMMENTS.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *   1.  DESCRIBE RESULT SET                                      *        
      *   2.  BUILD RESULT SET                                         *        
      *   3.  SEND RESULT SET                                          *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-NEW-ORDER-STATE-CD = 'A'                               
              PERFORM 8200-RETURN-ZERO THRU 8200-EXIT                   
           END-IF.                                                      
                                                                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           IF CTR-ROWS = 0                                              
              INITIALIZE                 TDS-RETURN-FIELDS              
              MOVE 100                   TO RS-RETURN-CODE              
              PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT                 
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-MOVE-RESULT.                                              *        
      ******************************************************************        
       2100-MOVE-RESULT.                                                
                                                                        
           MOVE '2100'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-NO-CANCEL-RSN       TO S-NO-CANCEL-RSN.              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT.                                             *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
                                                                        
           PERFORM 7000-CURRENT-ORDER-INFO THRU 7000-EXIT.              
D26047     IF VO-ACCOUNT-NO > 0                                         
              MOVE VO-ACCOUNT-NO TO AT-ACCOUNT-NO                       
              PERFORM 7010-GET-ACCOUNT-INFO THRU 7010-EXIT              
D26047     END-IF.                                                      
           MOVE VO-PREMISE-NO TO WS-PREMISE-NO-NUM.                     
DT9512     PERFORM 7650-GET-DATABASE  THRU 7650-EXIT.                   
                                                                        
           IF WS-NEW-ORDER-STATE-CD = VO-ORDER-STATE-CD                 
              PERFORM 8200-RETURN-ZERO THRU 8200-EXIT                   
           END-IF.                                                      
                                                                        
      * IF ORDER STATE IS BLANK, WE ARE UPDATING ORDER TYPE INSTEAD.            
           IF WS-NEW-ORDER-STATE-CD <= SPACES                           
              PERFORM 2250-PROCESS-ORDER-TYPE THRU 2250-EXIT            
           END-IF.                                                      
                                                                        
           EVALUATE WS-NEW-ORDER-STATE-CD                               
                                                                        
              WHEN 'B'                                                  
                 MOVE 'H'                TO WS-REMARK-TYPE              
                 IF VO-BACK-DATED-IND = 'N'                             
D10154             PERFORM 7700-CHECK-CLICK THRU 7700-EXIT              
D10154             IF WS-WORK-DISTRICT-4747 > SPACES                    
D10154                PERFORM 7750-CANCEL-CLICK THRU 7750-EXIT          
D10154*               PERFORM 8800-CLICK-CANCEL THRU 8800-EXIT                  
D10154*               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
D10154*                  PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
D10154*               END-IF                                                    
D10154             ELSE                                                 
D10154                PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT     
D10154             END-IF                                               
                   MOVE 'N'              TO WQ-PRIORITY-4675            
                   MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO          
                   MOVE 'ORDER '         TO WS-WQ-PREFIX                
                   MOVE ' HAS BEEN TURNED DOWN BY COMPANY.'             
                                         TO WS-WQ-SUFFIX                
                   MOVE WS-WQ-COMMENTS   TO COMMENTS-4675-TEXT          
                   MOVE 54               TO COMMENTS-4675-LEN           
                   PERFORM 2400-SEND-WQ THRU 2400-EXIT                  
                   PERFORM 2500-AROP-RECALC THRU 2500-EXIT              
                 END-IF                                                 
                                                                        
              WHEN 'C'                                                  
                 MOVE 'C'                TO WS-REMARK-TYPE              
                 IF VO-BACK-DATED-IND = 'N'                             
                   PERFORM 2600-CHECK-CANCELS THRU 2600-EXIT            
                   IF PARM-ORDER-TYPE-CD = 'DNP01' OR                   
                      PARM-ORDER-TYPE-CD = 'DNPFB'                      
                     IF SEB-DATABASE AND                                
                        PARM-ORDER-TYPE-CD = 'DNP01' AND                
                        VO-ORDER-REASON (2:1) NOT= 'P'                  
                       PERFORM 2820-PENDING-CANCEL-DNP01 THRU 2820-EXIT 
                       MOVE 'D5283'           TO RS-NO-CANCEL-RSN       
                     ELSE                                               
DT9512                 PERFORM 2800-CANCEL-DNP THRU 2800-EXIT           
                     END-IF                                             
                   END-IF                                               
                   IF PARM-ORDER-TYPE-CD = 'FM006'                      
                      PERFORM 8860-CANCEL-RECON-AGRMNT THRU 8860-EXIT   
                      IF SEB-DATABASE                                   
                         PERFORM 8865-SEND-PAID-TRAN THRU 8865-EXIT     
                      END-IF                                            
                   END-IF                                               
                   PERFORM 8600-HOLD-ORDERS THRU 8600-EXIT              
                   IF WS-HOLD-ORDERS-0200 = 'Y'                         
                      MOVE 'H'           TO RS-NO-CANCEL-RSN            
                   END-IF                                               
D11384*            IF WS-NEW-ORDER-TYPE-CD(1:3) NOT = 'DNP'                     
D11384             PERFORM 2900-UPDATE-PREMISE-DTLS THRU 2900-EXIT      
D11384*            END-IF                                                       
                   PERFORM 7700-CHECK-CLICK THRU 7700-EXIT              
                   IF WS-WORK-DISTRICT-4747 > SPACES                    
D10154                PERFORM 7750-CANCEL-CLICK THRU 7750-EXIT          
D10154*               PERFORM 8800-CLICK-CANCEL THRU 8800-EXIT                  
D10154*               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
D10154*                  PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
D10154*               END-IF                                                    
                   ELSE                                                 
                      PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT     
                   END-IF                                               
                   MOVE 'N'              TO WQ-PRIORITY-4675            
                   MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO          
                   MOVE 'ORDER '         TO WS-WQ-PREFIX                
                   MOVE ' HAS BEEN CANCELED.'                           
                                         TO WS-WQ-SUFFIX                
                   MOVE WS-WQ-COMMENTS   TO COMMENTS-4675-TEXT          
                   MOVE 40               TO COMMENTS-4675-LEN           
                   PERFORM 2400-SEND-WQ THRU 2400-EXIT                  
                   PERFORM 8380-UPD-GAS-SAMPLE-FL THRU 8380-EXIT        
                 END-IF                                                 
                 PERFORM 2700-CHECK-GAS-LINES THRU 2700-EXIT            
                                                                        
              WHEN 'D'                                                  
                 MOVE 'H'                TO WS-REMARK-TYPE              
                 IF VO-BACK-DATED-IND = 'N'                             
D10154             PERFORM 7700-CHECK-CLICK THRU 7700-EXIT              
D10154             IF WS-WORK-DISTRICT-4747 > SPACES                    
D10154                PERFORM 7750-CANCEL-CLICK THRU 7750-EXIT          
D10154*               PERFORM 8800-CLICK-CANCEL THRU 8800-EXIT                  
D10154*               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
D10154*                  PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
D10154*               END-IF                                                    
D10154             ELSE                                                 
D10154                PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT     
D10154             END-IF                                               
                   MOVE 'N'              TO WQ-PRIORITY-4675            
                   MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO          
                   MOVE 'ORDER '         TO WS-WQ-PREFIX                
                   MOVE ' HAS BEEN TURNED DOWN BY CUSTOMER.'            
                                         TO WS-WQ-SUFFIX                
                   MOVE WS-WQ-COMMENTS   TO COMMENTS-4675-TEXT          
                   MOVE 55               TO COMMENTS-4675-LEN           
                   PERFORM 2400-SEND-WQ THRU 2400-EXIT                  
                   PERFORM 2500-AROP-RECALC THRU 2500-EXIT              
                 END-IF                                                 
                                                                        
              WHEN 'H'                                                  
                 MOVE 'H'                TO WS-REMARK-TYPE              
                 IF VO-BACK-DATED-IND = 'N'                             
D10154             PERFORM 7700-CHECK-CLICK THRU 7700-EXIT              
D10154             IF WS-WORK-DISTRICT-4747 > SPACES                    
D10154                PERFORM 7750-CANCEL-CLICK THRU 7750-EXIT          
D10154*               PERFORM 8800-CLICK-CANCEL THRU 8800-EXIT                  
D10154*               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
D10154*                  PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
D10154*               END-IF                                                    
D10154             ELSE                                                 
D10154                PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT     
D10154             END-IF                                               
                   MOVE 'H'              TO WQ-PRIORITY-4675            
                   MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO          
                   MOVE 'ORDER '         TO WS-WQ-PREFIX                
                   MOVE ' HAS BEEN PUT ON HOLD.'                        
                                         TO WS-WQ-SUFFIX                
                   MOVE WS-WQ-COMMENTS   TO COMMENTS-4675-TEXT          
                   MOVE 43               TO COMMENTS-4675-LEN           
                   PERFORM 2400-SEND-WQ THRU 2400-EXIT                  
                 END-IF                                                 
                                                                        
              WHEN 'R'                                                  
                 MOVE 'H'                TO WS-REMARK-TYPE              
                 IF VO-BACK-DATED-IND = 'N'                             
D10154*            PERFORM 7700-CHECK-CLICK THRU 7700-EXIT                      
D10154*            IF WS-WORK-DISTRICT-4747 > SPACES                            
D10154*               PERFORM 7750-CANCEL-CLICK THRU 7750-EXIT                  
D10154*               PERFORM 8800-CLICK-CANCEL THRU 8800-EXIT                  
D10154*               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
D10154*                  PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
D10154*               END-IF                                                    
D10154*            ELSE                                                         
D10154*               PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT             
D10154*            END-IF                                                       
                   MOVE 'H'              TO WQ-PRIORITY-4675            
                   MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO          
                   MOVE 'ORDER '         TO WS-WQ-PREFIX                
                   MOVE ' HAS BEEN PUT IN PAYMENT REQUIRED STATE.'      
                                         TO WS-WQ-SUFFIX                
                   MOVE WS-WQ-COMMENTS   TO COMMENTS-4675-TEXT          
                   MOVE 61               TO COMMENTS-4675-LEN           
                   PERFORM 2400-SEND-WQ THRU 2400-EXIT                  
                 END-IF                                                 
                                                                        
           END-EVALUATE.                                                
           IF SEB-DATABASE AND RS-NO-CANCEL-RSN = 'D5283'               
              CONTINUE                                                  
           ELSE                                                         
             PERFORM 8300-UPDATE-ORDER-STATE THRU 8300-EXIT             
             PERFORM 8400-INSERT-AUDIT       THRU 8400-EXIT             
             PERFORM 2300-PROCESS-REMARKS    THRU 2300-EXIT             
           END-IF.                                                      
           PERFORM 8200-RETURN-ZERO        THRU 8200-EXIT.              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-PROCESS-ORDER-TYPE.                                       *        
      ******************************************************************        
       2250-PROCESS-ORDER-TYPE.                                         
                                                                        
           MOVE '2250'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE 'G'                      TO WS-REMARK-TYPE.             
           PERFORM 8375-UPDATE-ORDER-TYPE THRU 8375-EXIT.               
           PERFORM 8400-INSERT-AUDIT THRU 8400-EXIT.                    
           PERFORM 2350-PROCESS-REMARKS-2 THRU 2350-EXIT.               
D11899     IF VO-BACK-DATED-IND NOT = 'Y' AND                           
D11899        VO-ORDER-STATE-CD = 'A'                                   
              PERFORM 7700-CHECK-CLICK THRU 7700-EXIT                   
              IF WS-WORK-DISTRICT-4747 > SPACES                         
                 PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
              END-IF                                                    
D11899     END-IF.                                                      
           PERFORM 8200-RETURN-ZERO THRU 8200-EXIT.                     
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  2300-PROCESS-REMARKS.                                                  
      *       UPDATING ORDER STATE GENERATES MULTIPLE SO REMARKS.               
      **************************************************************            
       2300-PROCESS-REMARKS.                                            
                                                                        
      * INSERTS ORDER STATE REMARK WITH COMMENTS FROM INPUT PARAMETER.          
                                                                        
           MOVE WS-PARM-COMMENTS         TO WS-COMMENTS.                
           PERFORM 8500-INSERT-REMARKS   THRU 8500-EXIT.                
                                                                        
      * INSERTS CHANGE LOG REMARKS WITH ORIGINAL ORDER STATE.                   
                                                                        
           EVALUATE VO-ORDER-STATE-CD                                   
              WHEN 'A'                                                  
                 MOVE 'ACTIVE'           TO WS-ORDER-STATE-DESC         
              WHEN 'B'                                                  
                 MOVE 'TURNED DOWN COMPANY'                             
                                         TO WS-ORDER-STATE-DESC         
              WHEN 'D'                                                  
                 MOVE 'TURNED DOWN CUSTOMER'                            
                                         TO WS-ORDER-STATE-DESC         
              WHEN 'H'                                                  
                 MOVE 'HOLD'             TO WS-ORDER-STATE-DESC         
              WHEN 'R'                                                  
                 MOVE 'PAYMENT REQUIRED' TO WS-ORDER-STATE-DESC         
              WHEN OTHER                                                
                MOVE SPACES              TO WS-ORDER-STATE-DESC         
           END-EVALUATE.                                                
                                                                        
           MOVE 'ORIG REQ STATE CD - '     TO WS-WA-COMMENTS.           
                                                                        
           STRING WS-WA-COMMENTS                                        
              DELIMITED BY SIZE                                         
              WS-ORDER-STATE-DESC                                       
              DELIMITED BY SIZE                                         
              INTO WS-LOG-COMMENTS                                      
           END-STRING.                                                  
                                                                        
           MOVE 'E'                        TO WS-REMARK-TYPE.           
           MOVE WS-LOG-COMMENTS            TO WS-COMMENTS.              
                                                                        
           PERFORM 8500-INSERT-REMARKS THRU 8500-EXIT.                  
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  2350-PROCESS-REMARKS-2                                                 
      *       UPDATING ORDER TYPE GENERATES MULTIPLE SO REMARKS.                
      **************************************************************            
       2350-PROCESS-REMARKS-2.                                          
                                                                        
      * INSERTS ORDER TYPE REMARK WITH COMMENTS FROM INPUT PARAMETER.           
                                                                        
           MOVE WS-PARM-COMMENTS         TO WS-COMMENTS.                
           PERFORM 8500-INSERT-REMARKS   THRU 8500-EXIT.                
                                                                        
      * INSERTS CHANGE LOG REMARKS WITH ORIGINAL ORDER TYPE.                    
                                                                        
           IF VO-ORDER-TYPE-CD(1:2) = 'CC' OR VO-ORDER-TYPE-CD = 'UMRCC'
                 MOVE 'CUSTOMER CHANGE'  TO WS-ORDER-STATE-DESC         
           ELSE                                                         
                 MOVE 'OCCUPANT CHANGE'  TO WS-ORDER-STATE-DESC         
           END-IF.                                                      
                                                                        
           MOVE 'ORIG REQ TYPE CD - '     TO WS-WA-COMMENTS.            
                                                                        
           STRING WS-WA-COMMENTS                                        
              DELIMITED BY SIZE                                         
              WS-ORDER-STATE-DESC                                       
              DELIMITED BY SIZE                                         
              INTO WS-LOG-COMMENTS                                      
           END-STRING.                                                  
                                                                        
           MOVE 'E'                        TO WS-REMARK-TYPE.           
           MOVE WS-LOG-COMMENTS            TO WS-COMMENTS.              
                                                                        
           PERFORM 8500-INSERT-REMARKS THRU 8500-EXIT.                  
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  2400-SEND-WQ.                                                          
      *       SENDS WQ IF ORDER IS PRINTED AND IN NON-CLICK, NON-CAD            
      *       WORK AREA. RIGHT NOW THIS IS FOR ORDER TYPE FW003 ONLY.           
      *       FW003 = LIGHT MNT-ELEC.                                           
      **************************************************************            
       2400-SEND-WQ.                                                    
                                                                        
           IF PARM-ORDER-TYPE-CD = 'FW003'                              
             PERFORM 7100-CHECK-WORK-AREA THRU 7100-EXIT                
             IF WS-PRINT-WA = 'Y'                                       
                PERFORM 7200-CHECK-PRINT-REQ THRU 7200-EXIT             
                IF WS-PRINT-REQ = 'Y'                                   
                   PERFORM 7300-GET-RESP-AREA THRU 7300-EXIT            
                   MOVE WS-USER-ID TO USER-ID-ORIG-4675                 
                   MOVE WS-RESP-AREA-ID TO RESP-AREA-ID-4675            
                   MOVE SPACES TO USER-ID-ASGN-4675                     
                   MOVE VO-LOCAL-OFFICE TO LOCAL-OFFICE-4675            
                   MOVE '2' TO ROUTING-CATEGORY-4675                    
                   MOVE 52 TO CATEGORY-ID-4675                          
                   PERFORM 5800-CALL-CSR04675 THRU 5800-EXIT            
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      *  2500-AROP-RECALC.                                                      
      *       RECALCULATES WORK AREA IF ORDER IS IN AROP WORK AREA              
      *       AND SET TO TURNED DOWN (BY CUSTOMER OR COMPANY).                  
      **************************************************************            
       2500-AROP-RECALC.                                                
                                                                        
           IF VO-WORK-AREA-ID(1:3) = 'ARO' OR                           
              VO-WORK-AREA-ID(1:4) = 'OORR'                             
                                                                        
              PERFORM 8850-RECALC-WORK-AREA   THRU 8850-EXIT            
              MOVE NEW-WORK-AREA-4251         TO VO-WORK-AREA-ID        
              MOVE BUSINESS-UNIT-4251         TO VO-SO-BUSINESS-UNIT    
              PERFORM 8350-UPDATE-WORK-AREA   THRU 8350-EXIT            
                                                                        
              MOVE 'H'                        TO WS-REMARK-TYPE         
              MOVE 'TURNED DOWN - WORK AREA RECALCULATED'               
                                              TO WS-COMMENTS            
              PERFORM 8500-INSERT-REMARKS     THRU 8500-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      *  2600-CHECK-CANCELS.                                                    
      *       CHECKS IF CANCELED ORDER IS CC, OC OR SET ORDER. IF SO,           
      *       WE CHECK FOR RECEIVABLES AND DEPOSITS. CANNOT CANCEL              
      *       THOSE ORDER TYPES IF RECVLS OR DEPS EXIST.                        
      **************************************************************            
       2600-CHECK-CANCELS.                                              
                                                                        
           IF PARM-ORDER-TYPE-CD(1:2) = 'CC' OR                         
              PARM-ORDER-TYPE-CD(1:2) = 'NC' OR                         
             (PARM-ORDER-TYPE-CD = 'FM002' AND AT-CODE-ACCT-STAT = 'P') 
              PERFORM 7400-CHECK-RECVLS     THRU 7400-EXIT              
              PERFORM 7500-CHECK-DEPOSITS   THRU 7500-EXIT              
              IF WS-AR-CNTL-EXISTS = 'Y'                                
                 MOVE 'R'                         TO RS-NO-CANCEL-RSN   
                 PERFORM 8250-SEND-NULL-CODE      THRU 8250-EXIT        
              END-IF                                                    
D12146*       IF WS-RETURN-CODE-2159 = 0                                        
D12146        IF WS-PENDING-DEPOSIT-EXIST = 'Y'                         
                 MOVE 'D'                         TO RS-NO-CANCEL-RSN   
                 PERFORM 8250-SEND-NULL-CODE      THRU 8250-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      *  2700-CHECK-GAS-LINES.                                                  
      *       IF ORDER CANCELED HAS GAS LINES, WE HAVE TO BACK OUT THE          
      *       GAS LINE TABLES AS WELL.                                          
      **************************************************************            
       2700-CHECK-GAS-LINES.                                            
                                                                        
           IF PARM-ORDER-TYPE-CD = 'FW024' AND PARM-ORDER-STATE-CD = 'C'
              PERFORM 7600-GAS-LINE-ORDERS THRU 7600-EXIT               
              IF WS-SERV-LINE-EXISTS = 'Y'                              
                 PERFORM 8610-DELETE-GASLINE-XRF THRU 8610-EXIT         
                 IF XO-SERV-LINE-STAT-FL = 'P'                          
                    PERFORM 7610-OPEN-MM-CURSOR       THRU 7610-EXIT    
                    PERFORM 7620-FETCH-MM-CURSOR      THRU 7620-EXIT    
                    PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND 
                      PERFORM 7620-FETCH-MM-CURSOR    THRU 7620-EXIT    
                    END-PERFORM                                         
                    PERFORM 7630-CLOSE-MM-CURSOR      THRU 7630-EXIT    
                 END-IF                                                 
                 IF XO-SERV-LINE-STAT-FL = 'T'                          
                    PERFORM 8630-UPDATE-GAS-SERV-LINE THRU 8630-EXIT    
                    PERFORM 8640-UPDATE-PREM-GAS-LINE THRU 8640-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      *  2800-CANCEL-DNP.                                                       
      *       IF ORDER CANCELED IS DNP/DNPFB, WE HAVE TO RUN CSR02122.          
      **************************************************************            
       2800-CANCEL-DNP.                                                 
                                                                        
                                                                        
           MOVE 'S'  TO SELECT-UPDATE-FL-0125.                          
           PERFORM 4100-CALL-CSR00125 THRU 4100-EXIT.                   
           PERFORM 7120-GET-ORDER-DATA THRU 7120-EXIT.                  
           IF INSERT-WQ-FL-0125 = 'Y'                                   
               PERFORM 7140-GET-CREW THRU 7140-EXIT                     
               IF TE-CREW-ID <= SPACES                                  
                   STRING 'DNP ORDER CANCELLED, '                       
                          'DNP WORK AREA WAS '                          
                          I2-WORK-AREA-TX                               
                          DELIMITED BY SIZE                             
                          INTO COMMENTS-4675-TEXT                       
                   END-STRING                                           
                   MOVE 80 TO COMMENTS-4675-LEN                         
               ELSE                                                     
                   STRING 'DNP ORDER CANCELLED, '                       
                          'DNP CREW ID WAS '                            
                          TE-CREW-ID                                    
                          DELIMITED BY SIZE                             
                          INTO COMMENTS-4675-TEXT                       
                   END-STRING                                           
                   MOVE 50 TO COMMENTS-4675-LEN                         
               END-IF                                                   
               MOVE VO-LOCAL-OFFICE TO LOCAL-OFFICE-4675                
               MOVE WS-USER-ID TO USER-ID-ORIG-4675                     
               MOVE WS-RESP-AREA-ID TO RESP-AREA-ID-4675                
               MOVE SPACES TO USER-ID-ASGN-4675                         
               MOVE '1' TO ROUTING-CATEGORY-4675                        
               MOVE 31 TO CATEGORY-ID-4675                              
               MOVE 'H' TO WQ-PRIORITY-4675                             
               IF WS-PAYMENT-FL = 'Y'                                   
                   MOVE 160 TO CATEGORY-ID-4675                         
                   MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
                   MOVE 90 TO COMMENTS-4675-LEN                         
               END-IF                                                   
               PERFORM 5800-CALL-CSR04675 THRU 5800-EXIT                
           END-IF.                                                      
                                                                        
           MOVE 'N'                TO PENDING-SO-FLAG-2122              
           MOVE VO-ORDER-REASON    TO ORDER-REASON-2122                 
           IF PARM-ORDER-TYPE-CD = 'DNP01' AND CSR-DATABASE             
              MOVE PARM-DNP-CANCEL-RSN TO CANCEL-REASON-2122            
           ELSE                                                         
              MOVE 'I'             TO CANCEL-REASON-2122                
           END-IF                                                       
           PERFORM  4200-CALL-CSR02122  THRU 4200-EXIT.                 
           PERFORM  7760-UPDATE-SO-DNP  THRU 7760-EXIT.                 
                                                                        
       2800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      *  2820-PENDING-CANCEL-DNP01.*                                            
      *    FOR SEB DNP01 ORDERS,SET IT TO PENDING CANCEL AND SEND A*            
      *    PAID TRANSACTION TO SEB.THE ORDER WILL STILL BE ACTIVE. *            
      **************************************************************            
       2820-PENDING-CANCEL-DNP01.                                       
                                                                        
                                                                        
           MOVE 'MANUAL DNP CANCEL' TO REMARKS-0125-TEXT                
           MOVE 17 TO REMARKS-0125-LEN.                                 
           MOVE 'Y' TO UPDATE-REMARKS-0125.                             
           MOVE 'S'  TO SELECT-UPDATE-FL-0125.                          
           MOVE 'A' TO ORDER-TYPE-FL-0125,                              
           MOVE 'R' TO CANCEL-REASON-0125                               
           PERFORM 4100-CALL-CSR00125 THRU 4100-EXIT.                   
           PERFORM 7120-GET-ORDER-DATA THRU 7120-EXIT.                  
           IF INSERT-WQ-FL-0125 = 'Y'                                   
               PERFORM 7140-GET-CREW THRU 7140-EXIT                     
               IF TE-CREW-ID <= SPACES                                  
                   STRING 'DNP ORDER CANCELLED, '                       
                          'DNP WORK AREA WAS '                          
                          I2-WORK-AREA-TX                               
                          DELIMITED BY SIZE                             
                          INTO COMMENTS-4675-TEXT                       
                   END-STRING                                           
                   MOVE 80 TO COMMENTS-4675-LEN                         
               ELSE                                                     
                   STRING 'DNP ORDER CANCELLED, '                       
                          'DNP CREW ID WAS '                            
                          TE-CREW-ID                                    
                          DELIMITED BY SIZE                             
                          INTO COMMENTS-4675-TEXT                       
                   END-STRING                                           
                   MOVE 50 TO COMMENTS-4675-LEN                         
               END-IF                                                   
               MOVE VO-LOCAL-OFFICE TO LOCAL-OFFICE-4675                
               MOVE WS-USER-ID TO USER-ID-ORIG-4675                     
               MOVE WS-RESP-AREA-ID TO RESP-AREA-ID-4675                
               MOVE SPACES TO USER-ID-ASGN-4675                         
               MOVE '1' TO ROUTING-CATEGORY-4675                        
               MOVE 31 TO CATEGORY-ID-4675                              
               MOVE 'H' TO WQ-PRIORITY-4675                             
               IF WS-PAYMENT-FL = 'Y'                                   
                   MOVE 160 TO CATEGORY-ID-4675                         
                   MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
                   MOVE 90 TO COMMENTS-4675-LEN                         
               END-IF                                                   
               PERFORM 5800-CALL-CSR04675 THRU 5800-EXIT                
           END-IF.                                                      
           IF WS-PAYMENT-FL = 'Y'                                       
               GO TO 2820-EXIT
           END-IF.                                         
                                                                        
           MOVE 'U' TO SELECT-UPDATE-FL-0125.                           
           PERFORM 4100-CALL-CSR00125 THRU 4100-EXIT.                   
                                                                        
           MOVE PENDING-SO-FL-0125 TO PENDING-SO-FLAG-2122              
           MOVE ORDER-REASON-0125    TO ORDER-REASON-2122               
           MOVE CANCEL-REASON-0125 TO CANCEL-REASON-2122                
           PERFORM  4200-CALL-CSR02122  THRU 4200-EXIT.                 
                                                                        
       2820-EXIT.                                                       
            EXIT.                                                       
                                                                        
D11384**************************************************************            
D11384*  2900-UPDATE-PREMISE-DTLS.                                 *            
D11384*     WHEN ORDER IS CANCELLED UPDATE THE PENDING ORDER FLAG  *            
D11384*       AND PENDING OFF DATE IN THE CSS_PREMISE TABLE        *            
      **************************************************************            
       2900-UPDATE-PREMISE-DTLS.                                        
                                                                        
           PERFORM 8670-SELECT-SODATA  THRU 8670-EXIT.                  
           PERFORM 8675-SELECT-ASSGNDT THRU 8675-EXIT.                  
           IF WS-SERV-ORDER-PEND NOT = SPACES OR                        
              WS-SO-OFF-DATE     NOT = SPACES                           
              PERFORM 8680-UPDATE-PREMISE  THRU 8680-EXIT               
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-CALL-CSR00125.                                              
                                                                        
           MOVE VO-ACCOUNT-NO  TO ACCOUNT-NO-0125.                      
           MOVE WS-PREMISE-NO-CHAR TO PREMISE-NO-0125.                  
           MOVE WS-USER-ID TO USER-ID-0125.                             
           MOVE 'MODM'     TO PANEL-NO-0125.                            
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00125                                             
      *           (:ACCOUNT-NO-0125,                                    
      *            :PREMISE-NO-0125,                                    
      *            :USER-ID-0125,                                       
      *            :REMARKS-0125,                                       
      *            :UPDATE-REMARKS-0125,                                
      *            :SELECT-UPDATE-FL-0125,                              
      *            :PANEL-NO-0125,                                      
      *            :ORDER-TYPE-FL-0125,                                 
      *            :CANCEL-REASON-0125)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0125
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0125
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0125 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00125'            TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-0125       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0125)                                                
      *       WITH PROCEDURE CSR00125                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0125 CURSOR FOR RESULT SET        
      *       :LOC0125                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0125 INTO                            
                 :RETURN-CODE-0125,                                     
                 :SERV-ORDER-NO-0125,                                   
                 :ORDER-REASON-0125,                                    
                 :RESP-AREA-0125,                                       
                 :PENDING-SO-FL-0125,                                   
                 :INSERT-WQ-FL-0125,                                    
                 :AMOUNT-DISC-BAL-0125,                                 
                 :ORDER-TYPE-CD-0125                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0125 NOT = 0 AND                      
                      RETURN-CODE-0125 NOT = 100 AND                    
                      RETURN-CODE-0125 NOT = 5000                       
                         MOVE RETURN-CODE-0125  TO WS-ACTIVE-RETURN-CODE
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '4100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR00125'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-0125   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                   END-IF                                               
                   IF RETURN-CODE-0125 = 5000                           
                      MOVE 'Y' TO WS-PAYMENT-FL                         
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00125'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-0125       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4200-CALL-CSR02122.                                              
                                                                        
           MOVE VO-ACCOUNT-NO        TO ACCOUNT-NO-2122                 
           MOVE WS-PREMISE-NO-CHAR   TO PREMISE-NO-2122                 
           IF PARM-ORDER-TYPE-CD = 'DNP01'                              
              MOVE 'Y'               TO UPDATE-PROFILE-2122             
           ELSE                                                         
              MOVE 'N'               TO UPDATE-PROFILE-2122             
           END-IF                                                       
           MOVE VO-AMT-DNP-AT-BILLING TO WS-AMT-DNP-ACCOUNT             
           MOVE WS-AMT-DNP-ACCOUNT   TO AMOUNT-DISC-BAL-2122            
           MOVE '016'               TO PANEL-NO-2122                    
           MOVE PARM-ORDER-TYPE-CD   TO ORDER-TYPE-2122                 
           MOVE 210                  TO COMMENTS-2122-LEN               
           MOVE PARM-COMMENTS        TO COMMENTS-2122-TEXT              
                                                                        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02122                                             
      *           (:ACCOUNT-NO-2122,                                    
      *            :PREMISE-NO-2122,                                    
      *            :ORDER-REASON-2122,                                  
      *            :CANCEL-REASON-2122,                                 
      *            :PENDING-SO-FLAG-2122,                               
      *            :UPDATE-PROFILE-2122,                                
      *            :AMOUNT-DISC-BAL-2122,                               
      *            :PANEL-NO-2122,                                      
      *            :ORDER-TYPE-2122,                                    
      *            :REMARK-TX-2122)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2122
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2122
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2122 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02122'            TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2122       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2122)                                                
      *       WITH PROCEDURE CSR02122                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2122 CURSOR FOR RESULT SET        
      *       :LOC2122                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2122 INTO                            
                 :RETURN-CODE-2122                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2122 NOT = 0 AND                      
                      RETURN-CODE-2122 NOT = 4000 AND                   
                      RETURN-CODE-2122 NOT = 4300 AND                   
                      RETURN-CODE-2122 NOT = 4400 AND                   
                      RETURN-CODE-2122 NOT = 4500 AND                   
                      RETURN-CODE-2122 NOT = 4600                       
                       MOVE RETURN-CODE-2122  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4200'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02122'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2122   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   IF RETURN-CODE-2122 = 4000                           
                      MOVE SPACES TO LOCAL-OFFICE-4675                  
                      MOVE 'SYSTEM' TO USER-ID-ORIG-4675                
                      MOVE 'WQ1' TO RESP-AREA-ID-4675                   
                      MOVE 'WQ09999' TO USER-ID-ASGN-4675               
                      MOVE '3' TO ROUTING-CATEGORY-4675                 
                      MOVE 530 TO CATEGORY-ID-4675                      
                      MOVE 'N' TO WQ-PRIORITY-4675                      
                      MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT       
                      MOVE 128 TO COMMENTS-4675-LEN                     
                      PERFORM 5800-CALL-CSR04675 THRU 5800-EXIT         
                   END-IF                                               
                   IF RETURN-CODE-2122 = 4300                           
                      MOVE 'D5942'        TO RS-NO-CANCEL-RSN           
                   END-IF                                               
                   IF RETURN-CODE-2122 = 4400                           
                      MOVE 'D5943'        TO RS-NO-CANCEL-RSN           
                   END-IF                                               
                   IF RETURN-CODE-2122 = 4500                           
                      MOVE 'D5944'        TO RS-NO-CANCEL-RSN           
                   END-IF                                               
                   IF RETURN-CODE-2122 = 4600                           
                      PERFORM 7770-GET-RESCH-DNP-INFO THRU 7770-EXIT    
                      MOVE 'D5945'        TO RS-NO-CANCEL-RSN           
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02122'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2122       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
P0795O******************************************************************        
P0795O* 5800-CALL-CSR04675.                                            *        
P0795O******************************************************************        
P0795O 5800-CALL-CSR04675.                                              
P0795O                                                                  
P0795O     MOVE 0 TO IN-ITEM-ID-4675.                                   
P0795O     MOVE SPACES TO DATE-REQUIRED-4675                            
P0795O                    DATE-CREATED-4675                             
P0795O                    FREE-FORM-DATA-4675-TEXT.                     
P0795O     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
P0795O     MOVE VO-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
P0795O     MOVE VO-PREMISE-NO TO PREMISE-NO-4675.                       
P0795O     MOVE 0             TO CUSTOMER-NO-4675.                      
P0795O     MOVE VO-SERV-ORDER-NO TO SERV-ORDER-NO-4675.                 
P0795O     MOVE PROGRAM-NAME     TO CREATED-BY-4675.                    
P0795O                                                                  
P0795O*    EXEC SQL                                                     
P0795O*       CALL CSR04675                                             
P0795O*           (:IN-ITEM-ID-4675,                                    
P0795O*            :ROUTING-CATEGORY-4675,                              
P0795O*            :LOCAL-OFFICE-4675,                                  
P0795O*            :USER-ID-ORIG-4675,                                  
P0795O*            :USER-ID-ASGN-4675,                                  
P0795O*            :RESP-AREA-ID-4675,                                  
P0795O*            :CATEGORY-ID-4675,                                   
P0795O*            :ACCOUNT-NO-4675,                                    
P0795O*            :PREMISE-NO-4675,                                    
P0795O*            :CUSTOMER-NO-4675,                                   
P0795O*            :SERV-ORDER-NO-4675,                                 
P0795O*            :COMMENTS-4675,                                      
P0795O*            :DATE-REQUIRED-4675,                                 
P0795O*            :DATE-CREATED-4675,                                  
P0795O*            :WQ-PRIORITY-4675,                                   
P0795O*            :FREE-FORM-DATA-4675,                                
P0795O*            :CREATED-BY-4675)                                    
P0795O*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P0795O                                                                  
P0795O     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0795O                                                                  
P0795O     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
P0795O        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0795O        MOVE '5800'                TO ACTIVE-PARAGRAPH            
P0795O        MOVE 'CALL'                TO ABEND-FUNCTION              
P0795O        MOVE 'CSR04675'            TO TABLE-1                     
P0795O        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
P0795O        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
P0795O        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
P0795O        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
P0795O        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P0795O        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P0795O     END-IF.                                                      
P0795O                                                                  
P0795O*    EXEC SQL                                                     
P0795O*       ASSOCIATE LOCATORS                                        
P0795O*       (:LOC4675)                                                
P0795O*       WITH PROCEDURE CSR04675                                   
P0795O*    END-EXEC.                                                    
P0795O                                                                  
P0795O*    EXEC SQL                                                     
P0795O*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
P0795O*       :LOC4675                                                  
P0795O*    END-EXEC.                                                    
P0795O                                                                  
P0795O     EXEC SQL                                                     
P0795O        FETCH RESULT_SET_CSR_4675 INTO                            
P0795O           :RETURN-CODE-4675,                                     
P0795O           :OUT-ITEM-ID-4675                                      
P0795O     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795O                                                                  
P0795O     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0795O     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795O         WHEN SUCCESSFUL-CALL                                     
P0795O             IF RETURN-CODE-4675 NOT = 0                          
P0795O                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
P0795O                 MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
P0795O                 MOVE '5800'            TO ACTIVE-PARAGRAPH       
P0795O                 MOVE 'FETCH'           TO ABEND-FUNCTION         
P0795O                 MOVE 'CSR04675'        TO TABLE-1                
P0795O                 MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
P0795O                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
P0795O                 MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
P0795O                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
P0795O                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
P0795O                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
P0795O             END-IF                                               
P0795O         WHEN OTHER                                               
P0795O             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
P0795O             MOVE '5800'                TO ACTIVE-PARAGRAPH       
P0795O             MOVE 'FETCH'               TO ABEND-FUNCTION         
P0795O             MOVE 'CSR04675'            TO TABLE-1                
P0795O             MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
P0795O             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
P0795O             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
P0795O             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
P0795O             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P0795O             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P0795O     END-EVALUATE.                                                
P0795O*                                                                         
P0795O 5800-EXIT.                                                       
P0795O      EXIT.                                                       
P0795O*                                                                         
      **************************************************************            
      *  7000-CURRENT-ORDER-INFO.                                               
      **************************************************************            
       7000-CURRENT-ORDER-INFO.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) VO.WORK_AREA_ID,
              VO.ORDER_STATE_CD,
              VO.ORDER_TYPE_CD,
              VO.COMPANY_NO,
              VO.SO_BUSINESS_UNIT,
              VO.BACK_DATED_IND,
              VO.ACCOUNT_NO,
              VO.PREMISE_NO,
              VO.LOCAL_OFFICE,
              VO.ORDER_REASON,
              VO.AMT_DNP_AT_BILLING                             
                 INTO :VO-WORK-AREA-ID,                                 
                      :VO-ORDER-STATE-CD,                               
                      :VO-ORDER-TYPE-CD,                                
                      :VO-COMPANY-NO,                                   
                      :VO-SO-BUSINESS-UNIT,                             
                      :VO-BACK-DATED-IND,                               
                      :VO-ACCOUNT-NO,                                   
                      :VO-PREMISE-NO,                                   
                      :VO-LOCAL-OFFICE,                                 
                      :VO-ORDER-REASON,                                 
                      :VO-AMT-DNP-AT-BILLING                            
               FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                        
               WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.WORK_AREA_ID,                                          
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.ORDER_TYPE_CD,                                         
MFA-TR*               VO.COMPANY_NO,                                            
MFA-TR*               VO.SO_BUSINESS_UNIT,                                      
MFA-TR*               VO.BACK_DATED_IND,                                        
MFA-TR*               VO.ACCOUNT_NO,                                            
MFA-TR*               VO.PREMISE_NO,                                            
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               VO.ORDER_REASON,                                          
MFA-TR*               VO.AMT_DNP_AT_BILLING                                     
MFA-TR*          INTO :VO-WORK-AREA-ID,                                         
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-ORDER-TYPE-CD,                                        
MFA-TR*               :VO-COMPANY-NO,                                           
MFA-TR*               :VO-SO-BUSINESS-UNIT,                                     
MFA-TR*               :VO-BACK-DATED-IND,                                       
MFA-TR*               :VO-ACCOUNT-NO,                                           
MFA-TR*               :VO-PREMISE-NO,                                           
MFA-TR*               :VO-LOCAL-OFFICE,                                         
MFA-TR*               :VO-ORDER-REASON,                                         
MFA-TR*               :VO-AMT-DNP-AT-BILLING                                    
MFA-TR*        FROM CSS_SO_DATA VO                                              
MFA-TR*        WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CURRENT ORDER INFO'  TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7010-GET-ACCOUNT-INFO.                                                 
      **************************************************************            
D26047 7010-GET-ACCOUNT-INFO.                                           
                                                                        
           MOVE SPACES TO AT-CODE-ACCT-STAT.                            
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_STAT                                 
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                 INTO :AT-CODE-ACCT-STAT                                
                     ,:AT-LAST-UPDATE-TS                                
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.LAST_UPDATE_TS                                         
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-LAST-UPDATE-TS                                        
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'ACCOUNT INFO'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7100-CHECK-WORK-AREA                                                   
      **************************************************************            
       7100-CHECK-WORK-AREA.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                INTO :WS-PRINT-WA                                       
               FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                      
               WHERE WORK_AREA_ID = :VO-WORK-AREA-ID                    
                 AND CAD_WORKAREA_FL = 'N'                              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO :WS-PRINT-WA                                               
MFA-TR*        FROM CSS_SO_PRINT_LOC                                            
MFA-TR*        WHERE WORK_AREA_ID = :VO-WORK-AREA-ID                            
MFA-TR*          AND CAD_WORKAREA_FL = 'N'                                      
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK WORK AREA'     TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_PRINT_LOC'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-GET-ORDER-DATA.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) VO.LOCAL_OFFICE,
              WORK_AREA_TX,
              PRINTED_IND                                        
                INTO :VO-LOCAL-OFFICE,                                  
                     :I2-WORK-AREA-TX,                                  
                     :VO-PRINTED-IND                                    
              FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                        
                   CSS_WORK_AREA I2 WITH(READUNCOMMITTED)                       
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
                AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VO.LOCAL_OFFICE,                                           
MFA-TR*              WORK_AREA_TX,                                              
MFA-TR*              PRINTED_IND                                                
MFA-TR*         INTO :VO-LOCAL-OFFICE,                                          
MFA-TR*              :I2-WORK-AREA-TX,                                          
MFA-TR*              :VO-PRINTED-IND                                            
MFA-TR*       FROM CSS_SO_DATA VO,                                              
MFA-TR*            CSS_WORK_AREA I2                                             
MFA-TR*       WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                           
MFA-TR*         AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO VO-LOCAL-OFFICE                       
                                  I2-WORK-AREA-TX                       
                                  VO-PRINTED-IND                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7120'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_DATA'     TO TABLE-1                    
                   MOVE 'CSS_WORK_AREA'   TO TABLE-2                    
                   MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1            
                   MOVE VO-SERV-ORDER-NO  TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-GET-CREW.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CREW_ID                                            
                INTO :TE-CREW-ID                                        
              FROM CSS_SO_CREW WITH(READUNCOMMITTED)                            
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CREW_ID                                                    
MFA-TR*         INTO :TE-CREW-ID                                                
MFA-TR*       FROM CSS_SO_CREW                                                  
MFA-TR*       WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO TE-CREW-ID                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7140'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_CREW'     TO TABLE-1                    
                   MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1            
                   MOVE VO-SERV-ORDER-NO  TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7200-CHECK-PRINT-REQ                                                   
      **************************************************************            
       7200-CHECK-PRINT-REQ.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                INTO :WS-PRINT-REQ                                      
               FROM CSS_SO_REQUIREMENT WITH(READUNCOMMITTED)                    
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                 AND REQUIREMENT_CD = '2'                               
                 AND SERV_ORDER_STATUS = '10'                           
                 AND REQMNT_STAGE_CD = 'C'                              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO :WS-PRINT-REQ                                              
MFA-TR*        FROM CSS_SO_REQUIREMENT                                          
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*          AND REQUIREMENT_CD = '2'                                       
MFA-TR*          AND SERV_ORDER_STATUS = '10'                                   
MFA-TR*          AND REQMNT_STAGE_CD = 'C'                                      
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK PRINT REQ'     TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_REQUIREMENT'  TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7300-GET-RESP-AREA                                           *        
      *        GETS RESPONSIBLE AREA FOR WORK QUEUE.                   *        
      ******************************************************************        
                                                                        
       7300-GET-RESP-AREA.                                              
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR01287 (                                             
      *                 :VO-WORK-AREA-ID )                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_1287
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_1287
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_1287 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'GET-RESP-AREA'       TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR01287'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC01287)                                               
      *       WITH PROCEDURE CSR01287                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_1287 CURSOR FOR RESULT SET            
      *       :LOC01287                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_1287 INTO                                
                 :WS-RETURN-CODE-1287,                                  
                 :WS-RESP-AREA-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01287'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7400-CHECK-RECVLS.                                           *        
      *        GETS ACCOUNTS RECEIVABLES FOR CANCELING ORDERS.         *        
      ******************************************************************        
                                                                        
       7400-CHECK-RECVLS.                                               
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-AR-CNTL-EXISTS                                 
              FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                            
                WHERE ACCOUNT_NO         = :VO-ACCOUNT-NO               
                  AND (AMT_AR_DAY_00 > 0 OR AMT_AR_DAY_30 > 0 OR        
                       AMT_AR_DAY_60 > 0 OR AMT_AR_DAY_90 > 0 OR        
                       AMT_TRAN_BALANCE > 0 OR TOT_SUMM_UNBILLED > 0)   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-AR-CNTL-EXISTS                                         
MFA-TR*       FROM CSS_AR_CNTL                                                  
MFA-TR*         WHERE ACCOUNT_NO         = :VO-ACCOUNT-NO                       
MFA-TR*           AND (AMT_AR_DAY_00 > 0 OR AMT_AR_DAY_30 > 0 OR                
MFA-TR*                AMT_AR_DAY_60 > 0 OR AMT_AR_DAY_90 > 0 OR                
MFA-TR*                AMT_TRAN_BALANCE > 0 OR TOT_SUMM_UNBILLED > 0)           
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK-RECVLS'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7500-CHECK-DEPOSITS.                                         *        
      *        GETS DEPOSITS BEFORE CANCELING ORDERS.                  *        
      ******************************************************************        
                                                                        
       7500-CHECK-DEPOSITS.                                             
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE VO-ACCOUNT-NO TO ACCOUNT-NO-2159.                       
      *    EXEC SQL                                                     
      *       CALL CSR02159(:ACCOUNT-NO-2159)                           
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_2159
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_2159
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_2159 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK-DEPOSITS'      TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR02159'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC02159)                                               
      *       WITH PROCEDURE CSR02159                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_2159 CURSOR FOR RESULT SET            
      *       :LOC02159                                                 
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
           EXEC SQL                                                     
              FETCH RESULT_CSR_2159 INTO                                
                 :RETURN-CODE-2159                                      
                ,:DEPOSIT-CERT-NO-2159                                  
                ,:ORIG-DEP-AMT-2159                                     
                ,:AMT-REFUNDED-2159                                     
                ,:TRANSFER-AMT-2159                                     
                ,:AMT-DEPOSIT-2159                                      
                ,:TRANSFERRED-TO-2159                                   
                ,:DEP-CERT-NO-TO-2159                                   
                ,:TRANSFERRED-FROM-2159                                 
                ,:DEP-CERT-NO-FROM-2159                                 
                ,:SERVICE-TYPE-CD-2159                                  
                ,:REPEAT-COUNT-2159                                     
                ,:DATE-TRANS-2159                                       
                ,:AMT-POSTED-2159                                       
                ,:DEP-PAY-DT-2159                                       
                ,:DEP-PAY-AMT-2159                                      
                ,:INT-CREDIT-DT-2159                                    
                ,:INTEREST-AMT-2159                                     
                ,:INTEREST-RT-2159                                      
                ,:EFFECTIVE-DT-2159                                     
                ,:REV-DISTRICT-DESC-2159                                
                ,:DATE-REFUND-2159                                      
                ,:MANUAL-INDICATOR-2159                                 
                ,:DEP-AMT-REFUNDED-2159                                 
                ,:INT-AMT-REFUNDED-2159                                 
                ,:TOT-AMT-REFUNDED-2159                                 
                ,:CHECK-ISS-REAS-CD-2159                                
                ,:CHECK-STATUS-CD-2159                                  
                ,:USER-NAME-RQSTED-BY-2159                              
                ,:USER-NAME-APPRVD-BY-2159                              
                ,:ACCT-NO-CREDITED-2159                                 
                ,:COMMENTS-2159                                         
                ,:DEPOSIT-STATUS-CD-2159                                
                ,:DATE-TRAN-2159                                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE RETURN-CODE-2159 TO WS-ACTIVE-RETURN-CODE       
                   IF RETURN-CODE-2159 = 100                            
                     SET NO-MORE-ROWS TO TRUE                           
                   ELSE                                                 
                      IF DEPOSIT-STATUS-CD-2159 = 'P'                   
                         MOVE 'Y' TO WS-PENDING-DEPOSIT-EXIST           
                      END-IF                                            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   SET NO-MORE-ROWS TO TRUE                             
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7500'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02159'            TO TABLE-1                
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE                                                 
           END-PERFORM.                                                 
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7600-GAS-LINE-ORDERS.                                        *        
      *        CHECKS FOR GASLINE INFO ON CURRENT ORDER.               *        
      ******************************************************************        
                                                                        
       7600-GAS-LINE-ORDERS.                                            
                                                                        
           MOVE '7600'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XX.SERVICE_NO,
              XO.SERV_LINE_STAT_FL,
              'Y'                                                
                INTO :XX-SERVICE-NO                                     
                    ,:XO-SERV-LINE-STAT-FL                              
                    ,:WS-SERV-LINE-EXISTS                               
              FROM CSS_SO_DATA SO WITH(READUNCOMMITTED)                         
                  ,CSS_GASLINE_SO_XRF XX WITH(READUNCOMMITTED)                  
                  ,CSS_GAS_SERV_LINE  XO WITH(READUNCOMMITTED)                  
              WHERE SO.SERV_ORDER_NO  = :VO-SERV-ORDER-NO               
                AND SO.SERV_ORDER_NO  = XX.SERV_ORDER_NO                
                AND XX.SERVICE_NO     = XO.SERVICE_NO                   
                AND (XO.SERV_LINE_STAT_FL = 'P' OR                      
                     XO.SERV_LINE_STAT_FL = 'T')                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XX.SERVICE_NO                                              
MFA-TR*             ,XO.SERV_LINE_STAT_FL                                       
MFA-TR*             ,'Y'                                                        
MFA-TR*         INTO :XX-SERVICE-NO                                             
MFA-TR*             ,:XO-SERV-LINE-STAT-FL                                      
MFA-TR*             ,:WS-SERV-LINE-EXISTS                                       
MFA-TR*       FROM CSS_SO_DATA SO                                               
MFA-TR*           ,CSS_GASLINE_SO_XRF XX                                        
MFA-TR*           ,CSS_GAS_SERV_LINE  XO                                        
MFA-TR*       WHERE SO.SERV_ORDER_NO  = :VO-SERV-ORDER-NO                       
MFA-TR*         AND SO.SERV_ORDER_NO  = XX.SERV_ORDER_NO                        
MFA-TR*         AND XX.SERVICE_NO     = XO.SERVICE_NO                           
MFA-TR*         AND (XO.SERV_LINE_STAT_FL = 'P' OR                              
MFA-TR*              XO.SERV_LINE_STAT_FL = 'T')                                
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'GAS-LINE-ORDERS'     TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GASLINE_SO_XRF'  TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7610-OPEN-MM-CURSOR.                                         *        
      *        CHECKS FOR MULTIPLE SERVICES AT MULTIPLE PREMISES.      *        
      ******************************************************************        
       7610-OPEN-MM-CURSOR.                                             
                                                                        
           MOVE '7610'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN MM_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN-MM-CURSOR'      TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'MM-CURSOR'           TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7620-FETCH-MM-CURSOR.                                        *        
      ******************************************************************        
                                                                        
       7620-FETCH-MM-CURSOR.                                            
                                                                        
           MOVE '7620'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH MM_CURSOR                                           
               INTO :WS-GAS-SVC-PREM-NO                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  PERFORM 8650-RUN-CSR04078  THRU 8650-EXIT             
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                  MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '7620'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH-MM-CURSOR'     TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'MM-CURSOR'           TO TABLE-1                 
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7630-CLOSE-MM-CURSOR.                                        *        
      ******************************************************************        
                                                                        
       7630-CLOSE-MM-CURSOR.                                            
                                                                        
           MOVE '7630'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE MM_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7630'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE-MM-CURSOR'     TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'MM-CURSOR'           TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
DT9512*****************************************************************         
DT9512* 7650-GET-DATABASE.                                            *         
DT9512*     SELECTS   DATABASE     (SEB OR CSR) FROM CSS_DELINQUENCY *          
DT9512*****************************************************************         
DT9512 7650-GET-DATABASE.                                               
DT9512                                                                  
DT9512     MOVE 'DATABASE'                       TO   C8-DELINQ-CD.     
DT9512     MOVE VO-COMPANY-NO                    TO   C8-COMPANY-NO.    
DT9512     EXEC SQL                                                     
DT9512        SELECT DELINQ_VALUE                                       
DT9512          INTO :C8-DELINQ-VALUE                                   
DT9512          FROM CSS_DELINQUENCY                                    
DT9512         WHERE DELINQ_CD = :C8-DELINQ-CD                          
DT9512           AND COMPANY_NO = :C8-COMPANY-NO                        
DT9512     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT9512                                                                  
DT9512     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
DT9512                                                                  
DT9512     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
DT9512        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
DT9512     ELSE                                                         
DT9512        MOVE '7650'                     TO ACTIVE-PARAGRAPH       
DT9512        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
DT9512        MOVE 'SELECT'                   TO ABEND-FUNCTION         
DT9512        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
DT9512        MOVE 'DELINQ CODE'              TO TABLE-ELEMENT-1        
DT9512        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
DT9512        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
DT9512        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
DT9512     END-IF.                                                      
DT9512                                                                  
DT9512 7650-EXIT.                                                       
DT9512     EXIT.                                                        
DT9512*                                                                         
      *                                                                         
D26070 7660-ACCEPT-TIMESTAMP.                                           
                                                                        
           MOVE '7660'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE WS-CURRENT-TIMESTAMP     TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7700-CHECK-CLICK.                                            *        
      *        CHECKS IF ORDER IS CLICK.                               *        
      ******************************************************************        
                                                                        
       7700-CHECK-CLICK.                                                
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :VO-SERV-ORDER-NO,                              
      *                 '1',                                            
      *                 'S',                                            
      *                 ' ',                                            
      *                 :WS-WORK-DISTRICT)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC04747)                                               
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747 CURSOR FOR RESULT SET            
      *       :LOC04747                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747 INTO                                
                 :WS-RETURN-CODE-4747,                                  
                 :WS-WORK-DISTRICT-4747                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7700'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
D10154*   7750-CANCEL-CLICK                                            *        
      *        CANCELS ORDER FROM CLICK.                               *        
      ******************************************************************        
                                                                        
D10154 7750-CANCEL-CLICK.                                               
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :VO-SERV-ORDER-NO,                              
      *                 '1',                                            
      *                 'M',                                            
      *                 :WS-USER-ID,                                    
      *                 :WS-WORK-DISTRICT)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747C
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747C
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747C INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7750'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC04747C)                                              
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747C CURSOR FOR RESULT SET           
      *       :LOC04747C                                                
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747C INTO                               
                 :WS-RETURN-CODE-4747,                                  
                 :WS-WORK-DISTRICT-4747                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7750'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7760-UPDATE-SO-DNP                                           *        
      *    UPDATES CSS_SO_DNP WITH CANCEL REASON WHEN DNP IS CANCELLED *        
      ******************************************************************        
                                                                        
       7760-UPDATE-SO-DNP.                                              
                                                                        
           MOVE '7760'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE CANCEL-REASON-2122      TO AI-DNP-CNCL-REASON-CD        
           MOVE PARM-SERV-ORDER-NO-NUM  TO AI-SERV-ORDER-NO             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DNP                                         
                 SET DNP_CNCL_REASON_CD = :AI-DNP-CNCL-REASON-CD        
               WHERE SERV_ORDER_NO = :AI-SERV-ORDER-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7760'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DNP'               TO TABLE-1                
              MOVE 'SERVICE ORDER'            TO TABLE-ELEMENT-1        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7770-GET-RESCH-DNP-INFO.                                         
                                                                        
           MOVE ACCOUNT-NO-2122 TO CL-ACCOUNT-NO.                       
           EXEC SQL                                                     
                 SELECT TOP(1) CODE_SPECIAL_TYPE,
              DATE_CREDIT_ACTION,
              AMT_NOTICE                                     
                   INTO  :CL-CODE-SPECIAL-TYPE                          
                        ,:CL-DATE-CREDIT-ACTION                         
                        ,:CL-AMT-NOTICE                                 
                   FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                  
                  WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                     
                    AND CODE_SPECIAL_TYPE IN ('W', 'T')                 
                    AND CODE_NOTICE_TYPE = 'G'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT CODE_SPECIAL_TYPE                                       
MFA-TR*                 ,DATE_CREDIT_ACTION                                     
MFA-TR*                 ,AMT_NOTICE                                             
MFA-TR*            INTO  :CL-CODE-SPECIAL-TYPE                                  
MFA-TR*                 ,:CL-DATE-CREDIT-ACTION                                 
MFA-TR*                 ,:CL-AMT-NOTICE                                         
MFA-TR*            FROM CSS_CRED_COLL CL                                        
MFA-TR*           WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                             
MFA-TR*             AND CODE_SPECIAL_TYPE IN ('W', 'T')                         
MFA-TR*             AND CODE_NOTICE_TYPE = 'G'                                  
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7770                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO CL-CODE-SPECIAL-TYPE                  
                                  CL-DATE-CREDIT-ACTION                 
                   MOVE 0.0    TO CL-AMT-NOTICE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7770'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_CRED_COLL'   TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE CL-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7770-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                          *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04857_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04857_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04857_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT.                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04857_R1                         
                (                                                       
                     RETURN_CODE,                                       
                     DO_NOT_CANCEL_RSN                                  
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE,                                    
                     :S-NO-CANCEL-RSN                                   
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04857_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE,                                               
MFA-TR*              DO_NOT_CANCEL_RSN                                          
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE,                                            
MFA-TR*              :S-NO-CANCEL-RSN                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD +1                    TO CTR-ROWS                    
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
               MOVE 'CSR04857_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-RETURN-ZERO.                                              *        
      *      RETURN ZERO IF SP WAS SUCCESSFUL. WE ALSO SEND BACK       *        
      *      RETURN ZERO AND DO NOTHING IF NEW ORDER STATE IS ACTIVE   *        
      *      OR IF NEW AND OLD ORDER STATE ARE THE SAME. ACTIVE STATE  *        
      *      UPDATES WILL BE HANDLED IN THE MAINTENANCE WIZARD.        *        
      ******************************************************************        
       8200-RETURN-ZERO.                                                
                                                                        
           MOVE ZERO                  TO RS-RETURN-CODE.                
           PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT.                   
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8250-SEND-NULL-CODE.                                           *        
      ******************************************************************        
       8250-SEND-NULL-CODE.                                             
                                                                        
           MOVE 100                   TO RS-RETURN-CODE.                
           PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT.                   
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8300-UPDATE-ORDER-STATE.                                     *        
      *        CHANGES ORDER STATE AND POSSIBLY COMPLETED DATETIME.    *        
      ******************************************************************        
                                                                        
       8300-UPDATE-ORDER-STATE.                                         
                                                                        
           MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-NEW-ORDER-STATE-CD = 'C'                               
                                                                        
             EXEC SQL                                                   
                 UPDATE CSS_SO_DATA                                     
                   SET ORDER_STATE_CD = :WS-NEW-ORDER-STATE-CD,         
                       COMPLETED_DATETIME = CIS.CURRENT$TIMESTAMP()           
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                                                            
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*      EXEC SQL                                                           
MFA-TR*          UPDATE CSS_SO_DATA                                             
MFA-TR*            SET ORDER_STATE_CD = :WS-NEW-ORDER-STATE-CD,                 
MFA-TR*                COMPLETED_DATETIME = CURRENT TIMESTAMP                   
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                        
MFA-TR*          QUERYNO 8300                                                   
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
                                                                        
           ELSE                                                         
                                                                        
             EXEC SQL                                                   
                 UPDATE CSS_SO_DATA                                     
                   SET ORDER_STATE_CD = :WS-NEW-ORDER-STATE-CD          
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                                                            
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*      EXEC SQL                                                           
MFA-TR*          UPDATE CSS_SO_DATA                                             
MFA-TR*            SET ORDER_STATE_CD = :WS-NEW-ORDER-STATE-CD                  
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                        
MFA-TR*          QUERYNO 8300                                                   
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
                                                                        
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE ORDER'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8350-UPDATE-WORK-AREA.                                       *        
      *        CHANGES WORK AREA AND BUSINESS UNIT.                    *        
      ******************************************************************        
                                                                        
       8350-UPDATE-WORK-AREA.                                           
                                                                        
           MOVE '8350'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                 SET WORK_AREA_ID = :VO-WORK-AREA-ID,                   
                     SO_BUSINESS_UNIT = :VO-SO-BUSINESS-UNIT            
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*          SET WORK_AREA_ID = :VO-WORK-AREA-ID,                           
MFA-TR*              SO_BUSINESS_UNIT = :VO-SO-BUSINESS-UNIT                    
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*        QUERYNO 8350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8350'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE WORK AREA'    TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8375-UPDATE-ORDER-TYPE.                                      *        
      *        CHANGES ORDER TYPE CODE.                                *        
      ******************************************************************        
                                                                        
       8375-UPDATE-ORDER-TYPE.                                          
                                                                        
           MOVE '8375'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                 SET ORDER_TYPE_CD = :WS-NEW-ORDER-TYPE-CD              
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*          SET ORDER_TYPE_CD = :WS-NEW-ORDER-TYPE-CD                      
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*        QUERYNO 8375                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8375'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE ORDER TYPE'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8375-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8380-UPD-GAS-SAMPLE-FL.                                     *         
      *        UPDATE THE GAS SAMPLE FL TO N WHEN ORDER IS CANCELLED   *        
      ******************************************************************        
                                                                        
       8380-UPD-GAS-SAMPLE-FL.                                          
                                                                        
           MOVE '8380'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
                 UPDATE CSS_SO_ORDER_INST                               
                   SET SAMPLE_TEST_FL= 'N'                              
                 WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                
                                                            
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*      EXEC SQL                                                           
MFA-TR*          UPDATE CSS_SO_ORDER_INST                                       
MFA-TR*            SET SAMPLE_TEST_FL= 'N'                                      
MFA-TR*          WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                        
MFA-TR*          QUERYNO 8380                                                   
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8380'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPD GAS SAMPLE FL'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8400-INSERT-AUDIT.                                           *        
      *        PUTS RECORDS IN SO_UPDATE (USED IN AUDIT DISPLAY PANEL) *        
      ******************************************************************        
                                                                        
       8400-INSERT-AUDIT.                                               
                                                                        
           MOVE '8400'                     TO WS-ACTIVE-PARAGRAPH.      

MSQ002     EXEC SQL
MSQ002         SELECT CIS.CURRENT$TIMESTAMP()
MSQ002           INTO :MFA-CSR00064.ARG-3
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
            CALL CSR00064 ( :VO-SERV-ORDER-NO
                  , :WS-USER-ID
                  , :MFA-CSR00064.ARG-3
                  , 'MODM'
                  , 'Y'
                  )                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*     CALL CSR00064 (                                                     
MFA-TR*                 :VO-SERV-ORDER-NO,                                      
MFA-TR*                 :WS-USER-ID,                                            
MFA-TR*                 CURRENT TIMESTAMP,                                      
MFA-TR*                 'MODM',                                                 
MFA-TR*                 'Y')                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8400'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT AUDIT'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_UPDATE'       TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8500-INSERT-REMARKS                                          *        
      *        PUTS RECORDS IN SO_REMARKS WITH CHANGE LOG REMARK TYPE. *        
      ******************************************************************        
                                                                        
       8500-INSERT-REMARKS.                                             
                                                                        
           MOVE '8500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            CALL CSR00068 (                                             
                        :VO-SERV-ORDER-NO,                              
                        :WS-REMARK-TYPE,                                
                        :WS-COMMENTS,                                   
                        :WS-USER-ID)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8500'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT REMARKS'      TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_REMARKS'      TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8600-HOLD-ORDERS                                             *        
      *        PUTS OTHER ORDERS ON HOLD IF CANCELED CC OR OFF ORDER;  *        
      *        ALSO REORDERS (CC002 BECOMES CC001, ETC).               *        
      ******************************************************************        
                                                                        
       8600-HOLD-ORDERS.                                                
                                                                        
           MOVE '8600'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR00200 (                                             
      *                 :VO-SERV-ORDER-NO,                              
      *                 :VO-ORDER-TYPE-CD,                              
      *                 :WS-USER-ID)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_0200
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_0200
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_0200 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8600'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR00200'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC00200)                                               
      *       WITH PROCEDURE CSR00200                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_0200 CURSOR FOR RESULT SET            
      *       :LOC00200                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_0200 INTO                                
                 :WS-RETURN-CODE-0200,                                  
                 :WS-HOLD-ORDERS-0200                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '8600'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00200'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8610-DELETE-GASLINE-XRF.                                     *          
      ****************************************************************          
                                                                        
       8610-DELETE-GASLINE-XRF.                                         
                                                                        
           MOVE '8610'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               DELETE CSS_GASLINE_SO_XRF                                
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8610'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE-GASLINE-XRF'  TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GASLINE_SO_XRF'  TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8630-UPDATE-GAS-SERV-LINE.                                   *          
      ****************************************************************          
                                                                        
       8630-UPDATE-GAS-SERV-LINE.                                       
                                                                        
           MOVE '8630'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_GAS_SERV_LINE                                
                  SET SERV_LINE_STAT_FL = 'A',                          
                  INSTALL_TYPE_CD = INSTALL_TYPE_ORIG                   
                 WHERE SERVICE_NO = :XX-SERVICE-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8630'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE-GAS-SERV-LINE' TO ABEND-FUNCTION             
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GAS_SERV_LINE'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8640-UPDATE-PREM-GAS-LINE.                                   *          
      ****************************************************************          
                                                                        
       8640-UPDATE-PREM-GAS-LINE.                                       
                                                                        
           MOVE '8640'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_PREM_GAS_LINE                                
                  SET INSTALL_PREM_FL = 'Y'                             
                WHERE PREMISE_NO = :VO-PREMISE-NO                       
                  AND SERVICE_NO = :XX-SERVICE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8640'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE-PREM-GAS-LINE' TO ABEND-FUNCTION             
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREM_GAS_LINE'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8650-RUN-CSR04078.                                           *        
      *        UPDATES GAS SERVICES WHEN GAS MAINT ORDER CANCELED.     *        
      ******************************************************************        
                                                                        
       8650-RUN-CSR04078.                                               
                                                                        
           MOVE '8650'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *         CALL CSR04078 (                                         
      *                 'D',                                            
      *                 :WS-GAS-SVC-PREM-NO,                            
      *                 :XX-SERVICE-NO, '', '', '', 0, 0, 0,            
      *                 0.0, '', '', '', '', '',                        
      *                 :WS-USER-ID,                                    
      *                 'MODM', '', '')                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_DUMMY_CSR04078_1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_DUMMY_CSR04078_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_DUMMY_CSR04078_1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8650'                TO ACTIVE-PARAGRAPH            
              MOVE 'RUN-CSR04078'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04078'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8670-SELECT-SODATA.                                           *         
      *     SELECTS IF ORDER EXISTS FOR ORDER STATE CD Z OR C         *         
      *****************************************************************         
       8670-SELECT-SODATA.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-SERV-ORDER-PEND                                
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO =  :VO-PREMISE-NO                       
                 AND ORDER_STATE_CD NOT IN ('Z','C')                    
                 AND SERV_ORDER_NO <> :VO-SERV-ORDER-NO                 
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SERV-ORDER-PEND                                        
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO =  :VO-PREMISE-NO                               
MFA-TR*          AND ORDER_STATE_CD NOT IN ('Z','C')                            
MFA-TR*          AND SERV_ORDER_NO <> :VO-SERV-ORDER-NO                         
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  MOVE 'Y'      TO            WS-SERV-ORDER-PEND        
               WHEN NOT-FOUND                                           
                  MOVE 'N'      TO            WS-SERV-ORDER-PEND        
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME               TO ABEND-PROGRAM      
                  MOVE 'SELECT'                   TO ABEND-FUNCTION     
                  MOVE SPACES                  TO ABEND-SQL-PREDICATES  
                                                     ABEND-TABLES       
                  MOVE 'CSS_SO_DATA'              TO TABLE-1            
                  MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1    
                  MOVE VO-PREMISE-NO              TO HOSTVAR-ELEMENT-1  
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8670-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8675-SELECT-ASSGNDT.                                          *         
      *     SELECTS CSS_SO_DATA TO FIND OUT MIN ASSIGNDATE FOR A PREMISE        
      *****************************************************************         
       8675-SELECT-ASSGNDT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) COALESCE(CAST ( CIS.CHAR2$DATE(CAST(MIN(
           ASSIGNED_DATETIME) AS DATE),'USA') AS CHAR(10)), ' ' )            
               INTO :WS-ASSIGNED-DATE                                   
               FROM CSS_SO_DATA WITH(READUNCOMMITTED)                           
              WHERE PREMISE_NO = :VO-PREMISE-NO                         
                AND ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03','CC001'   
                                      ,'CC002','CC003','NC001','DNPFB') 
                AND ORDER_STATE_CD NOT IN ('Z','C')                     
                AND SERV_ORDER_NO <> :VO-SERV-ORDER-NO                  
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COALESCE(CAST ( CHAR(DATE(MIN(ASSIGNED_DATETIME)            
MFA-TR*                           ),USA) AS CHAR(10)), ' ' )                    
MFA-TR*        INTO :WS-ASSIGNED-DATE                                           
MFA-TR*        FROM CSS_SO_DATA                                                 
MFA-TR*       WHERE PREMISE_NO = :VO-PREMISE-NO                                 
MFA-TR*         AND ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03','CC001'           
MFA-TR*                               ,'CC002','CC003','NC001','DNPFB')         
MFA-TR*         AND ORDER_STATE_CD NOT IN ('Z','C')                             
MFA-TR*         AND SERV_ORDER_NO <> :VO-SERV-ORDER-NO                          
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  MOVE WS-ASSIGNED-DATE       TO WS-SO-OFF-DATE         
                  IF WS-SO-OFF-DATE = SPACES                            
                     MOVE -1                        TO WS-NULL-IND      
                  END-IF                                                
               WHEN NOT-FOUND                                           
                  MOVE SPACES                 TO WS-SO-OFF-DATE         
                  MOVE -1                        TO WS-NULL-IND         
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE 'SELECT'                   TO ABEND-FUNCTION      
                 MOVE SPACES                     TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                 MOVE 'CSS_SO_DATA'              TO TABLE-1             
                 MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1     
                 MOVE VO-PREMISE-NO              TO HOSTVAR-ELEMENT-1   
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       8675-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8680-UPDATE-PREMISE                                           *         
      *     UPDATES CSS_PREMISE.                                      *         
      *****************************************************************         
       8680-UPDATE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET SERV_ORDER_PEND = :WS-SERV-ORDER-PEND,             
                     PEND_OFF_ORD_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-SO-OFF-DATE 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-SO-OFF-DATE 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:WS-SO-OFF-DATE :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-SO-OFF-DATE :WS-NULL-IND
              ), CONVERT(DATE, :WS-SO-OFF-DATE :WS-NULL-IND) )      
               WHERE PREMISE_NO = :VO-PREMISE-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*          SET SERV_ORDER_PEND = :WS-SERV-ORDER-PEND,                     
MFA-TR*              PEND_OFF_ORD_DT = :WS-SO-OFF-DATE:WS-NULL-IND              
MFA-TR*        WHERE PREMISE_NO = :VO-PREMISE-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8680'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE_PREMISE'      TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8680-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   8700-INSERT-CAD-CANCEL.                                      *        
      *        SENDS CANCEL ROW TO CSS_SO_CAD_QUEUE                    *        
      ******************************************************************        
                                                                        
       8700-INSERT-CAD-CANCEL.                                          
                                                                        
           MOVE '8700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CAD_QUEUE                             
                (SERV_ORDER_NO,                                         
                 COMPANY_NO,                                            
                 LOCAL_OFFICE,                                          
                 WORK_GROUP_ID,                                         
                 WORK_AREA_ID,                                          
                 CREATED_TS,                                            
                 CAD_TS,                                                
                 CAD_PRIORITY,                                          
                 CREATED_BY_USER_ID,                                    
                 CAD_TRANS_TY_ACTN)                                     
               VALUES                                                   
                (:VO-SERV-ORDER-NO,                                     
                 :VO-COMPANY-NO,                                        
                 :VO-LOCAL-OFFICE,                                      
                 ' ',                                                   
                 ' ',                                                   
                 CIS.CURRENT$TIMESTAMP(),                                     
                 NULL,                                                  
                 '1',                                                   
                 :WS-USER-ID,                                           
                 'C')                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_CAD_QUEUE                                     
MFA-TR*         (SERV_ORDER_NO,                                                 
MFA-TR*          COMPANY_NO,                                                    
MFA-TR*          LOCAL_OFFICE,                                                  
MFA-TR*          WORK_GROUP_ID,                                                 
MFA-TR*          WORK_AREA_ID,                                                  
MFA-TR*          CREATED_TS,                                                    
MFA-TR*          CAD_TS,                                                        
MFA-TR*          CAD_PRIORITY,                                                  
MFA-TR*          CREATED_BY_USER_ID,                                            
MFA-TR*          CAD_TRANS_TY_ACTN)                                             
MFA-TR*        VALUES                                                           
MFA-TR*         (:VO-SERV-ORDER-NO,                                             
MFA-TR*          :VO-COMPANY-NO,                                                
MFA-TR*          :VO-LOCAL-OFFICE,                                              
MFA-TR*          ' ',                                                           
MFA-TR*          ' ',                                                           
MFA-TR*          CURRENT TIMESTAMP,                                             
MFA-TR*          NULL,                                                          
MFA-TR*          '1',                                                           
MFA-TR*          :WS-USER-ID,                                                   
MFA-TR*          'C')                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8700'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT CAD CANCEL'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_CAD_QUEUE'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 8800-CLICK-CANCEL.                                           *          
      *      SENDS CANCEL ROW TO CSS_SO_TASK_QUEUE                   *          
      ****************************************************************          
                                                                        
       8800-CLICK-CANCEL.                                               
                                                                        
           MOVE '8800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_ORDER_INST                                 
                  SET TASK_STATUS_CD = 'C'                              
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND TASK_STATUS_CD IN ('S','R')                       
                  AND WORK_TYPE_CD   > ' '                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8800'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLICK CANCEL'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  8810-CLICK-TASK.                                             *         
      *       SENDS CANCEL/UPDATE ROW TO CSS_SO_TASK_QUEUE            *         
      *****************************************************************         
                                                                        
       8810-CLICK-TASK.                                                 
                                                                        
           MOVE '8810'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_TASK_QUEUE                            
                 (SERV_ORDER_NO,                                        
                  CREATED_TS,                                           
                  COMPANY_NO,                                           
                  TASK_PRIORITY,                                        
                  CREATED_BY_USER_ID,                                   
                  SO_BUSINESS_UNIT,                                     
                  CALL_ID,                                              
                  CALL_NUMBER)                                          
               VALUES                                                   
                  (:VO-SERV-ORDER-NO,                                   
                   CIS.CURRENT$TIMESTAMP(),                                   
                   :VO-COMPANY-NO,                                      
                   '1',                                                 
                   :WS-USER-ID,                                         
                   :VO-SO-BUSINESS-UNIT,                                
                   1,                                                   
                   1)                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_TASK_QUEUE                                    
MFA-TR*          (SERV_ORDER_NO,                                                
MFA-TR*           CREATED_TS,                                                   
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           TASK_PRIORITY,                                                
MFA-TR*           CREATED_BY_USER_ID,                                           
MFA-TR*           SO_BUSINESS_UNIT,                                             
MFA-TR*           CALL_ID,                                                      
MFA-TR*           CALL_NUMBER)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*           (:VO-SERV-ORDER-NO,                                           
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            :VO-COMPANY-NO,                                              
MFA-TR*            '1',                                                         
MFA-TR*            :WS-USER-ID,                                                 
MFA-TR*            :VO-SO-BUSINESS-UNIT,                                        
MFA-TR*            1,                                                           
MFA-TR*            1)                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8810'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLICK TASK INSERT'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_TASK_QUEUE'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8850-RECALC-WORK-AREA.                                       *        
      *        RECALCULATES WORK AREA FOR ORDER USING CSR04251.        *        
      ******************************************************************        
                                                                        
       8850-RECALC-WORK-AREA.                                           
                                                                        
           MOVE '8850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04251                                             
      *            (:VO-SERV-ORDER-NO,                                  
      *             'N',                                                
      *             :WS-USER-ID,                                        
      *             'AROP')                                             
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4251
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4251
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4251 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8850'                TO ACTIVE-PARAGRAPH            
              MOVE 'RECALC-WORK-AREA'    TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04251'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC04251)                                               
      *       WITH PROCEDURE CSR04251                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4251 CURSOR FOR RESULT SET        
      *       :LOC04251                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4251 INTO                            
                   :RETURN-CODE-4251,                                   
                   :OLD-WORK-AREA-4251,                                 
                   :OLD-WORK-AREA-TX-4251,                              
                   :NEW-WORK-AREA-4251,                                 
                   :LOCAL-OFFICE-4251,                                  
                   :CODE-UTIL-TYPE-4251,                                
                   :WORK-TYPE-CD-4251,                                  
                   :CRAWL-IND-4251,                                     
                   :METER-IND-4251,                                     
                   :ZIP-CODE-4251,                                      
                   :READ-ROUTE-4251,                                    
                   :POINT-ID-4251,                                      
                   :BUSINESS-UNIT-4251                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8850'                TO ACTIVE-PARAGRAPH            
              MOVE 'RECALC-WORK-AREA'    TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04251'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8860-CANCEL-RECON-AGRMNT                                     *        
      *        RECALCULATES WORK AREA FOR ORDER USING CSR04759.        *        
      ******************************************************************        
                                                                        
       8860-CANCEL-RECON-AGRMNT.                                        
                                                                        
           MOVE '8860'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE VO-ACCOUNT-NO  TO ACCOUNT-NO-4759                       
           MOVE 'D'            TO ACTION-CODE-4759                      
           MOVE SPACES         TO AGREEMENT-COMMENTS-4759               
           MOVE '0000000000000'   TO AMT-TOT-RECONNECT-4759             
           MOVE '000000000'    TO RECNCT-COLLECT-AMT-4759               
           MOVE SPACES         TO RECNCT-TYPE-CD-4759                   
           MOVE WS-USER-ID     TO USER-ID-4759                          
           MOVE 'RECONNECT ORDER CANCELED'    TO TRANS-CMT-4759         
           MOVE '0024'         TO TRANS-CMT-LEN-4759                    
           MOVE 0              TO AUTO-DEP-ID-4759                      
           MOVE SPACES         TO AUTO-DEP-LTR-IND-4759                 
           MOVE 0.00           TO AUTO-DEP-AMT-4759                     
           MOVE 0.00           TO RECALC-AUTO-DEP-AMT-4759              
           MOVE 0.00           TO NOTC-AUTO-DEP-AMT-4759                
           MOVE 0.00           TO DEP-COLLECT-AMT-4759                  
           MOVE SPACES         TO DEP-BILL-OPT-CD-4759                  
           MOVE 0              TO NO-SCHED-PYMTS-4759                   
           MOVE SPACES         TO START-DATE-4759                       
           MOVE 0.00           TO MTHLY-INSTALL-AMT-4759                
           MOVE SPACES         TO RECALC-UPDT-4759                      
           MOVE 0              TO RCNCT-TERM-ID-4759                    
           MOVE WS-USER-ID     TO LAST-UPDATE-USERID-4759               
           MOVE SPACES         TO RCC-BILL-OPTION-CD-4759               
           MOVE AT-LAST-UPDATE-TS TO LAST-UPDATE-TS-4759                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04759                                             
      *            (:ACCOUNT-NO-4759                                    
      *            ,:ACTION-CODE-4759                                   
      *            ,:AGREEMENT-COMMENTS-4759                            
      *            ,:AMT-TOT-RECONNECT-4759                             
      *            ,:RECNCT-COLLECT-AMT-4759                            
      *            ,:RECNCT-TYPE-CD-4759                                
      *            ,:USER-ID-4759                                       
      *            ,:TRANS-CMT-4759                                     
      *            ,:TRANS-CMT-LEN-4759                                 
      *            ,:AUTO-DEP-ID-4759                                   
      *            ,:AUTO-DEP-LTR-IND-4759                              
      *            ,:AUTO-DEP-AMT-4759                                  
      *            ,:RECALC-AUTO-DEP-AMT-4759                           
      *            ,:NOTC-AUTO-DEP-AMT-4759                             
      *            ,:DEP-COLLECT-AMT-4759                               
      *            ,:DEP-BILL-OPT-CD-4759                               
      *            ,:NO-SCHED-PYMTS-4759                                
      *            ,:START-DATE-4759                                    
      *            ,:MTHLY-INSTALL-AMT-4759                             
      *            ,:RECALC-UPDT-4759                                   
      *            ,:RCNCT-TERM-ID-4759                                 
      *            ,:LAST-UPDATE-USERID-4759                            
      *            ,:RCC-BILL-OPTION-CD-4759                            
      *            ,:LAST-UPDATE-TS-4759)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4759
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4759
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4759 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8860'                TO ACTIVE-PARAGRAPH            
              MOVE 'CANCEL-RECON-AGRMNT' TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04759'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4759)                                                
      *       WITH PROCEDURE CSR04759                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4759 CURSOR FOR RESULT SET        
      *       :LOC4759                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4759 INTO                            
                   :S-RETURN-CODE-4759                                  
                  ,:S-RETURN-MESSAGE-4759                               
                  ,:S-APPL-RETURN-CODE-4759                             
                  ,:S-AUTO-DEP-AMT-4759                                 
                  ,:S-DEP-SUCCESS-4759                                  
                  ,:S-DEP-CERT-NO-4759                                  
                  ,:S-ABEND-PROGRAM-4759                                
                  ,:S-ACTIVE-PARAGRAPH-4759                             
                  ,:S-ABEND-FUNCTION-4759                               
                  ,:S-TABLE-1-4759                                      
                  ,:S-TABLE-ELEMENT-1-4759                              
                  ,:S-HOSTVAR-ELEMENT-1-4759                            
                  ,:S-TABLE-ELEMENT-2-4759                              
                  ,:S-HOSTVAR-ELEMENT-2-4759                            
                  ,:S-TABLE-ELEMENT-3-4759                              
                  ,:S-HOSTVAR-ELEMENT-3-4759                            
                  ,:S-TABLE-ELEMENT-4-4759                              
                  ,:S-HOSTVAR-ELEMENT-4-4759                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8860'                TO ACTIVE-PARAGRAPH            
              MOVE 'CANCEL-RECON-AGRMNT' TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04759'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8865-SEND-PAID-TRAN.                                             
                                                                        
           MOVE VO-SERV-ORDER-NO TO SERV-ORDER-NO-1334.                 
           MOVE SPACES TO PRINT-DEST-1334                               
                          PRINT-DEST-IND-1334.                          
           MOVE WS-USER-ID TO USER-ID-1334.                             
           MOVE 'C' TO CAD-TRANS-TYPE-1334.                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01334                                             
      *           (:SERV-ORDER-NO-1334,                                 
      *            :PRINT-DEST-1334,                                    
      *            :PRINT-DEST-IND-1334,                                
      *            :USER-ID-1334,                                       
      *            :CAD-TRANS-TYPE-1334)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1334
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1334
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1334 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              ELSE                                                      
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '8865'                TO ACTIVE-PARAGRAPH          
                MOVE 'CALL'                TO ABEND-FUNCTION            
                MOVE 'CSR01334'            TO TABLE-1                   
                MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1           
                MOVE SERV-ORDER-NO-1334    TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1334)                                                
      *       WITH PROCEDURE CSR01334                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1334 CURSOR FOR RESULT SET        
      *       :LOC1334                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1334 INTO                            
                 :RETURN-CODE-1334,                                     
                 :ITEM-ID-1334                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1334 NOT = 0                          
                       MOVE RETURN-CODE-1334  TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '8865'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01334'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-1334 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '8865'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01334'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-1334     TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8865-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
