       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04853.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  APR 15, 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  RETRIEVES PHYSICIAN NAME, ADDRESS AND LICENSE DETAILS BASED ON*        
      *  NAME.                                                         *        
      *                                                                *        
      *  #  INVOKED FROM PHYSICIAN SEARCH SCREEN                       *        
      *                                                                *        
      *  #  BUSOP NAME: REQUGETPHYSICIANLASTNAMESEARCHBUSINESSOP       *        
      *                                                                *        
      *  #  PARAMETERS                                                 *        
      *     IN                                                         *        
      *         PHYSICIAN_FIRST_NAME     CHAR(15)                      *        
      *         PHYSICIAN_MIDDLE_NAME    CHAR(15)                      *        
      *         PHYSICIAN_LAST_NAME      CHAR(40)                      *        
      *         NAME_TYPE                CHAR(02)                      *        
      *     OUT                                                        *        
      *         RETURN_CODE              INTEGER                       *        
      *         FIRST_NAME               CHAR(15)                      *        
      *         MIDDLE_NAME              CHAR(15)                      *        
      *         LAST_NAME                CHAR(40)                      *        
      *         TITLE_PREFIX             CHAR(09)                      *        
      *         TITLE_SUFFIX_1           CHAR(03)                      *        
      *         FMT_HOUSE_NO             CHAR(15)                      *        
      *         FMT_ADDR_PREFIX_1        CHAR(03)                      *        
      *         FMT_ADDR_PREFIX_2        CHAR(02)                      *        
      *         FMT_STREET_NAME          CHAR(30)                      *        
      *         FMT_STREET_LOCATION_1    CHAR(04)                      *        
      *         FMT_STREET_LOCATION_2    CHAR(11)                      *        
      *         FMT_STREET_SUFFIX        CHAR(04)                      *        
      *         FMT_ADDR_SUFFIX          CHAR(02)                      *        
      *         FMT_ADDRESS_OVERFLOW     CHAR(35)                      *        
      *         FMT_ZIP_CODE             CHAR(05)                      *        
      *         FMT_ZIP_CODE_PLUS_FOUR   CHAR(04)                      *        
      *         FMT_ZIP_CODE_TOKEN       CHAR(01)                      *        
      *         FMT_ADDR_USAGE_CD        CHAR(01)                      *        
      *         FMT_TOWN                 CHAR(26)                      *        
      *         FMT_STATE                CHAR(02)                      *        
      *         FF_ADDR_STREET           CHAR(55)                      *        
      *         FF_ADDRESS_OVERFLOW      CHAR(35)                      *        
      *         FF_CITY_STATE            CHAR(30)                      *        
      *         FF_ZIP_CODE              CHAR(09)                      *        
      *         FF_COUNTRY               CHAR(35)                      *        
      *         PHONE_NO                 CHAR(10)                      *        
      *         EXTENSION                CHAR(06)                      *        
      *         PHYSICIAN_ID             INTEGER                       *        
      *         NAME_ID                  DECIMAL(13,0)                 *        
      *         ADDRESS_ID               DECIMAL(13,0)                 *        
      *         MED_LIC_STATE_CD         CHAR(02)                      *        
      *         MED_LICENSE_NO           CHAR(09)                      *        
      *         PHYSICIAN_NAME           CHAR(82)                      *        
      *         FULL_ADDRESS             CHAR(104)                     *        
      *         MEDCERT_LICENSE          CHAR(12)                      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  04/15/15  AA97148    INITIAL IMPLEMENTATION.                  *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04853'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                       PIC X(40) VALUE               
           'WORKING STORAGE FOR CSR04853 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04853'.  
           05  WS-PGRMNAME                PIC X(08)  VALUE 'CSR04853'.  
           05  WS-ADDRESS-LINE            PIC X(104) VALUE SPACES.      
           05  WS-PHYSICIAN-NAME          PIC X(82)  VALUE SPACES.      
           05  WS-PHYSICIAN-FIRST-NAME    PIC X(15)  VALUE SPACES.      
           05  WS-PHYSICIAN-MIDDLE-NAME   PIC X(15)  VALUE SPACES.      
           05  WS-PHYSICIAN-LAST-NAME     PIC X(40)  VALUE SPACES.      
           05  WS-MEDCERT-LICENSE         PIC X(12)  VALUE SPACES.      
           05  WS-NAME-TYPE               PIC X(02)  VALUE SPACES.      
           05  WS-PHYSICIAN-FOUND         PIC X(01)  VALUE SPACES.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                   PIC S9(9)  COMP VALUE 0.      
           05  WS-TBL-COUNT               PIC S9(9)  COMP VALUE 0.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE           PIC S9(9)  COMP VALUE 0.      
               10 S-FIRST-NAME            PIC X(15)  VALUE SPACES.      
               10 S-MIDDLE-NAME           PIC X(15)  VALUE SPACES.      
               10 S-LAST-NAME             PIC X(40)  VALUE SPACES.      
               10 S-TITLE-PREFIX          PIC X(09)  VALUE SPACES.      
               10 S-TITLE-SUFFIX-1        PIC X(03)  VALUE SPACES.      
               10 S-FMT-HOUSE-NO          PIC X(15)  VALUE SPACES.      
               10 S-FMT-ADDR-PREFIX-1     PIC X(03)  VALUE SPACES.      
               10 S-FMT-ADDR-PREFIX-2     PIC X(02)  VALUE SPACES.      
               10 S-FMT-STREET-NAME       PIC X(30)  VALUE SPACES.      
               10 S-FMT-STREET-LOCATION-1 PIC X(04)  VALUE SPACES.      
               10 S-FMT-STREET-LOCATION-2 PIC X(11)  VALUE SPACES.      
               10 S-FMT-STREET-SUFFIX     PIC X(04)  VALUE SPACES.      
               10 S-FMT-ADDR-SUFFIX       PIC X(02)  VALUE SPACES.      
               10 S-FMT-ADDRESS-OVERFLOW  PIC X(35)  VALUE SPACES.      
               10 S-FMT-ZIP-CODE          PIC X(05)  VALUE SPACES.      
               10 S-FMT-ZIP-CODE-PLUS-FOUR                              
                                          PIC X(04)  VALUE SPACES.      
               10 S-FMT-ZIP-CODE-TOKEN    PIC X(01)  VALUE SPACES.      
               10 S-FMT-ADDR-USAGE-CD     PIC X(01)  VALUE SPACES.      
               10 S-FMT-TOWN              PIC X(26)  VALUE SPACES.      
               10 S-FMT-STATE             PIC X(02)  VALUE SPACES.      
               10 S-FF-ADDR-STREET        PIC X(55)  VALUE SPACES.      
               10 S-FF-ADDRESS-OVERFLOW   PIC X(35)  VALUE SPACES.      
               10 S-FF-CITY-STATE         PIC X(30)  VALUE SPACES.      
               10 S-FF-ZIP-CODE           PIC X(09)  VALUE SPACES.      
               10 S-FF-COUNTRY            PIC X(35)  VALUE SPACES.      
               10 S-PHONE-NO              PIC X(10)  VALUE SPACES.      
               10 S-EXTENSION             PIC X(06)  VALUE SPACES.      
               10 S-PHYSICIAN-ID          PIC S9(9)  USAGE COMP VALUE 0.
               10 S-NAME-ID               PIC S9(13)V USAGE COMP-3      
                                                           VALUE 0.     
               10 S-ADDRESS-ID            PIC S9(13)V USAGE COMP-3      
                                                           VALUE 0.     
               10 S-MED-LIC-STATE-CD      PIC X(02)  VALUE SPACES.      
               10 S-MED-LICENSE-NO        PIC X(09)  VALUE SPACES.      
               10 S-PHYSICIAN-NAME        PIC X(82)  VALUE SPACES.      
               10 S-FULL-ADDRESS          PIC X(104) VALUE SPACES.      
               10 S-MEDCERT-LICENSE       PIC X(12)  VALUE SPACES.      
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                  PIC X(18)  VALUE SPACES.      
           05  S-SQLCODE                  PIC S9(9)  COMP  VALUE 0.     
           05  S-SQLSTATE                 PIC X(5)   VALUE ' '.         
           05  S-TABLE-NAME               PIC X(18)  VALUE SPACES.      
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4)  USAGE COMP.        
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4)  USAGE COMP.        
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4)  USAGE COMP.        
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L    PIC S9(4)  USAGE COMP.        
               49  WS-ABEND-SQLERRMC-V    PIC X(255).                   
           05  WS-SQLSTATE                PIC X(05)  VALUE SPACES.      
           05  WS-GTT-NAME                PIC X(19)  VALUE SPACES.      
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFMT                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM  - DZ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFRE                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN      - PY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBPHYSN                                           00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN_ATTR - PA                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBPHYADD                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_NAME           - DQ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBNAME                                            00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE       - A4                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01120000
              INCLUDE TBZIPCD                                           01130000
           END-EXEC.                                                    01140000
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET PHYSICIAN DETAILS                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE PHYSICIAN-NAME  CURSOR FOR                        
              SELECT DQ.NAME_ID                                         
                    ,DQ.FIRST_NAME                                      
                    ,DQ.MIDDLE_NAME                                     
                    ,DQ.LAST_NAME                                       
                    ,DQ.TITLE_PREFIX                                    
                    ,DQ.TITLE_SUFFIX_1                                  
                    ,RTRIM(LTRIM(RTRIM(DQ.TITLE_PREFIX) + ' ' + LTRIM(
           RTRIM(DQ.LAST_NAME) + ',' + ' ' + LTRIM(RTRIM(DQ.FIRST_NAME)
           )))) AS PHYSICIAN_NAME   
                FROM CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE DQ.FIRST_NAME  LIKE :WS-PHYSICIAN-FIRST-NAME       
                 AND DQ.MIDDLE_NAME LIKE :WS-PHYSICIAN-MIDDLE-NAME      
                 AND DQ.LAST_NAME   LIKE :WS-PHYSICIAN-LAST-NAME        
                 AND DQ.NAME_TYPE      = :WS-NAME-TYPE                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PHYSICIAN-NAME  CURSOR FOR                                
MFA-TR*       SELECT DQ.NAME_ID                                                 
MFA-TR*             ,DQ.FIRST_NAME                                              
MFA-TR*             ,DQ.MIDDLE_NAME                                             
MFA-TR*             ,DQ.LAST_NAME                                               
MFA-TR*             ,DQ.TITLE_PREFIX                                            
MFA-TR*             ,DQ.TITLE_SUFFIX_1                                          
MFA-TR*             ,RTRIM(LTRIM(RTRIM(DQ.TITLE_PREFIX) || ' ' ||               
MFA-TR*              LTRIM(RTRIM(DQ.LAST_NAME) || ',' || ' ' ||                 
MFA-TR*              LTRIM(RTRIM(DQ.FIRST_NAME))))) AS PHYSICIAN_NAME           
MFA-TR*         FROM CSS_NAME DQ                                                
MFA-TR*        WHERE DQ.FIRST_NAME  LIKE :WS-PHYSICIAN-FIRST-NAME               
MFA-TR*          AND DQ.MIDDLE_NAME LIKE :WS-PHYSICIAN-MIDDLE-NAME              
MFA-TR*          AND DQ.LAST_NAME   LIKE :WS-PHYSICIAN-LAST-NAME                
MFA-TR*          AND DQ.NAME_TYPE      = :WS-NAME-TYPE                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-PHYSICIAN-FIRST-NAME   PIC X(15).                       
       01  PARM-PHYSICIAN-MIDDLE-NAME  PIC X(15).                       
       01  PARM-PHYSICIAN-LAST-NAME    PIC X(40).                       
       01  PARM-NAME-TYPE              PIC X(02).                       
                                                                        
       PROCEDURE DIVISION USING PARM-PHYSICIAN-FIRST-NAME               
                                PARM-PHYSICIAN-MIDDLE-NAME              
                                PARM-PHYSICIAN-LAST-NAME                
                                PARM-NAME-TYPE.                         
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                    THRU 0100-EXIT.   
           PERFORM 1000-PROCESS-INPUT                 THRU 1000-EXIT.   
           PERFORM 2000-PROCESS-OUTPUT                THRU 2000-EXIT.   
           PERFORM 9999-END-PROGRAM                   THRU 9999-EXIT.   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT                  THRU 0100A-EXIT.  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04853'         TO WS-GTT-NAME.              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04853')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04853
              (                                                          
                  RETURN_CODE              INT                      
                 ,FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,TITLE_PREFIX CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,TITLE_SUFFIX_1 CHAR(03)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,FMT_ADDR_PREFIX_1 CHAR(03)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_ADDR_PREFIX_2 CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_STREET_NAME CHAR(30)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_STREET_LOCATION_1 CHAR(04)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_STREET_LOCATION_2 CHAR(11)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_STREET_SUFFIX CHAR(04)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_ADDR_SUFFIX CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,FMT_ZIP_CODE_PLUS_FOUR CHAR(04)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_ZIP_CODE_TOKEN CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_ADDR_USAGE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FMT_TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,FMT_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,FF_ADDR_STREET CHAR(55)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FF_ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FF_CITY_STATE CHAR(30)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FF_ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,FF_COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,EXTENSION CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,PHYSICIAN_ID             INT                      
                 ,NAME_ID                  DECIMAL(13,0)                
                 ,ADDRESS_ID               DECIMAL(13,0)                
                 ,MED_LIC_STATE_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,MED_LICENSE_NO CHAR(09)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,PHYSICIAN_NAME CHAR(82)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,FULL_ADDRESS CHAR(104)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,MEDCERT_LICENSE CHAR(12)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                   TO WS-SQLSTATE.              
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS           THRU 8000A-EXIT   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '0100A'              TO ACTIVE-PARAGRAPH          
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE WS-GTT-NAME          TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT *                                                 
               FROM #CSR04853                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR04853                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF PARM-PHYSICIAN-FIRST-NAME > SPACES                        
              MOVE PARM-PHYSICIAN-FIRST-NAME                            
                                           TO WS-PHYSICIAN-FIRST-NAME   
           ELSE                                                         
              MOVE SPACES                  TO WS-PHYSICIAN-FIRST-NAME   
           END-IF.                                                      
                                                                        
           IF PARM-PHYSICIAN-MIDDLE-NAME > SPACES                       
              MOVE PARM-PHYSICIAN-MIDDLE-NAME                           
                                           TO WS-PHYSICIAN-MIDDLE-NAME  
           ELSE                                                         
              MOVE SPACES                  TO WS-PHYSICIAN-MIDDLE-NAME  
           END-IF.                                                      
                                                                        
           MOVE PARM-PHYSICIAN-LAST-NAME   TO WS-PHYSICIAN-LAST-NAME.   
           INSPECT WS-PHYSICIAN-FIRST-NAME    REPLACING ALL ' ' BY '%'. 
           INSPECT WS-PHYSICIAN-MIDDLE-NAME   REPLACING ALL ' ' BY '%'. 
           INSPECT WS-PHYSICIAN-LAST-NAME     REPLACING ALL ' ' BY '%'. 
                                                                        
           MOVE PARM-NAME-TYPE             TO WS-NAME-TYPE.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      * INITIALIZE                                                              
           MOVE 0                          TO S-RETURN-CODE.            
                                                                        
           PERFORM 7500-OPEN-PHY-NAME-CURSOR          THRU 7500-EXIT.   
           PERFORM 7510-FETCH-PHY-NAME-CURSOR         THRU 7510-EXIT.   
           PERFORM 2100-PHYSICIAN-PROCESS             THRU 2100-EXIT    
                UNTIL SQLCODE = NOT-FOUND.                              
           PERFORM 7520-CLOSE-PHY-NAME-CURSOR         THRU 7520-EXIT.   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PHYSICIAN-PROCESS.                                        *        
      ******************************************************************        
                                                                        
       2100-PHYSICIAN-PROCESS.                                          
                                                                        
           MOVE 'N'                        TO WS-PHYSICIAN-FOUND.       
           PERFORM 7010-GET-PHYSICIAN-DETAILS         THRU 7010-EXIT.   
                                                                        
           IF WS-PHYSICIAN-FOUND = 'Y'                                  
              MOVE PA-ADDRESS-ID           TO DY-ADDRESS-ID             
                                              DZ-ADDRESS-ID             
                                                                        
              IF PA-ADDRESS-FORMAT = 'B'                                
                 PERFORM 7030-SELECT-PHY-ADDR-FF      THRU 7030-EXIT    
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2020-MOVE-FREEFORM-OUTPUT-VAR               
                                                      THRU 2020-EXIT    
                 ELSE                                                   
                    PERFORM 2040-INIT-FMT-FREE-RET-VAR                  
                                                      THRU 2040-EXIT    
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 7020-SELECT-PHY-ADDR-FMT     THRU 7020-EXIT    
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2010-MOVE-FORMATTED-OUTPUT-VAR              
                                                      THRU 2010-EXIT    
                 ELSE                                                   
                    PERFORM 2040-INIT-FMT-FREE-RET-VAR                  
                                                      THRU 2040-EXIT    
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 2030-MOVE-COMMON-OUTPUT-VAR     THRU 2030-EXIT    
              ADD +1                       TO WS-TBL-COUNT              
              PERFORM 8010-INSERT-GTT                 THRU 8010-EXIT    
           END-IF.                                                      
                                                                        
           PERFORM 7510-FETCH-PHY-NAME-CURSOR         THRU 7510-EXIT.   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-MOVE-FORMATTED-OUTPUT-VAR                                 *        
      ******************************************************************        
                                                                        
       2010-MOVE-FORMATTED-OUTPUT-VAR.                                  
                                                                        
           MOVE DY-ADDR-PREFIX-1           TO S-FMT-ADDR-PREFIX-1.      
           MOVE DY-ADDR-PREFIX-2           TO S-FMT-ADDR-PREFIX-2.      
           MOVE DY-ADDR-SUFFIX             TO S-FMT-ADDR-SUFFIX.        
           MOVE DY-ADDR-USAGE-CD           TO S-FMT-ADDR-USAGE-CD.      
           MOVE DY-ADDRESS-OVERFLOW        TO S-FMT-ADDRESS-OVERFLOW.   
           MOVE DY-HOUSE-NO                TO S-FMT-HOUSE-NO.           
           MOVE DY-STREET-LOCATION-1       TO S-FMT-STREET-LOCATION-2.  
           MOVE DY-STREET-LOCATION-2       TO S-FMT-STREET-LOCATION-2.  
           MOVE DY-STREET-NAME             TO S-FMT-STREET-NAME.        
           MOVE DY-STREET-SUFFIX           TO S-FMT-STREET-SUFFIX.      
           MOVE DY-ZIP-CODE                TO S-FMT-ZIP-CODE.           
           MOVE DY-ZIP-CODE-PLUS-FOUR      TO S-FMT-ZIP-CODE-PLUS-FOUR. 
           MOVE DY-ZIP-CODE-TOKEN          TO S-FMT-ZIP-CODE-TOKEN.     
           MOVE A4-TOWN                    TO S-FMT-TOWN.               
           MOVE A4-STATE                   TO S-FMT-STATE.              
           MOVE SPACES                     TO S-FF-ADDR-STREET          
                                              S-FF-ADDRESS-OVERFLOW     
                                              S-FF-CITY-STATE           
                                              S-FF-ZIP-CODE             
                                              S-FF-COUNTRY.             
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2020-MOVE-FREEFORM-OUTPUT-VAR                                  *        
      ******************************************************************        
                                                                        
       2020-MOVE-FREEFORM-OUTPUT-VAR.                                   
                                                                        
           MOVE SPACES                     TO S-FMT-ADDR-PREFIX-1       
                                              S-FMT-ADDR-PREFIX-2       
                                              S-FMT-ADDR-SUFFIX         
                                              S-FMT-ADDR-USAGE-CD       
                                              S-FMT-ADDRESS-OVERFLOW    
                                              S-FMT-HOUSE-NO            
                                              S-FMT-STREET-LOCATION-2   
                                              S-FMT-STREET-LOCATION-2   
                                              S-FMT-STREET-NAME         
                                              S-FMT-STREET-SUFFIX       
                                              S-FMT-ZIP-CODE            
                                              S-FMT-ZIP-CODE-PLUS-FOUR  
                                              S-FMT-ZIP-CODE-TOKEN      
                                              S-FMT-TOWN                
                                              S-FMT-STATE.              
           MOVE DZ-ADDR-STREET             TO S-FF-ADDR-STREET.         
           MOVE DZ-ADDRESS-OVERFLOW        TO S-FF-ADDRESS-OVERFLOW.    
           MOVE DZ-ADDR-CITY-STATE         TO S-FF-CITY-STATE.          
           MOVE DZ-ADDR-ZIP-CODE           TO S-FF-ZIP-CODE.            
           MOVE DZ-ADDR-COUNTRY            TO S-FF-COUNTRY.             
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2030-MOVE-COMMON-OUTPUT-VAR                                    *        
      ******************************************************************        
                                                                        
       2030-MOVE-COMMON-OUTPUT-VAR.                                     
                                                                        
           IF DQ-FIRST-NAME = SPACES                                    
             INSPECT WS-PHYSICIAN-NAME REPLACING ALL ',' BY SPACES      
           END-IF.                                                      
                                                                        
           MOVE PY-PHYSICIAN-ID            TO S-PHYSICIAN-ID.           
           MOVE PY-NAME-ID                 TO S-NAME-ID.                
           MOVE PY-MED-LIC-STATE-CD        TO S-MED-LIC-STATE-CD.       
           MOVE PY-MED-LICENSE-NO          TO S-MED-LICENSE-NO.         
           MOVE PA-ADDRESS-ID              TO S-ADDRESS-ID.             
           MOVE PA-PHONE-NO                TO S-PHONE-NO.               
           MOVE PA-EXTENSION-NO            TO S-EXTENSION.              
           MOVE DQ-FIRST-NAME              TO S-FIRST-NAME.             
           MOVE DQ-MIDDLE-NAME             TO S-MIDDLE-NAME.            
           MOVE DQ-LAST-NAME               TO S-LAST-NAME.              
           MOVE DQ-TITLE-PREFIX            TO S-TITLE-PREFIX.           
           MOVE DQ-TITLE-SUFFIX-1          TO S-TITLE-SUFFIX-1.         
           MOVE WS-PHYSICIAN-NAME          TO S-PHYSICIAN-NAME.         
           MOVE WS-ADDRESS-LINE            TO S-FULL-ADDRESS.           
           MOVE WS-MEDCERT-LICENSE         TO S-MEDCERT-LICENSE.        
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2040-INIT-FMT-FREE-RET-VAR                                     *        
      ******************************************************************        
                                                                        
       2040-INIT-FMT-FREE-RET-VAR.                                      
                                                                        
           MOVE SPACES                     TO S-FMT-ADDR-PREFIX-1       
                                              S-FMT-ADDR-PREFIX-2       
                                              S-FMT-ADDR-SUFFIX         
                                              S-FMT-ADDR-USAGE-CD       
                                              S-FMT-ADDRESS-OVERFLOW    
                                              S-FMT-HOUSE-NO            
                                              S-FMT-STREET-LOCATION-2   
                                              S-FMT-STREET-LOCATION-2   
                                              S-FMT-STREET-NAME         
                                              S-FMT-STREET-SUFFIX       
                                              S-FMT-ZIP-CODE            
                                              S-FMT-ZIP-CODE-PLUS-FOUR  
                                              S-FMT-ZIP-CODE-TOKEN      
                                              S-FMT-TOWN                
                                              S-FMT-STATE               
                                              S-FF-ADDR-STREET          
                                              S-FF-ADDRESS-OVERFLOW     
                                              S-FF-CITY-STATE           
                                              S-FF-ZIP-CODE             
                                              S-FF-COUNTRY.             
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7010-GET-PHYSICIAN-DETAILS                                      11850000
      ******************************************************************11920000
                                                                        
       7010-GET-PHYSICIAN-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT PA.ADDRESS_ID                                      
                    ,PA.PHONE_NO                                        
                    ,PA.EXTENSION_NO                                    
                    ,PA.ADDRESS_FORMAT                                  
                    ,PY.PHYSICIAN_ID                                    
                    ,PY.NAME_ID                                         
                    ,PY.MED_LIC_STATE_CD                                
                    ,PY.MED_LICENSE_NO                                  
                    ,RTRIM(LTRIM(RTRIM(PY.MED_LIC_STATE_CD) + ' ' + 
           LTRIM(RTRIM(PY.MED_LICENSE_NO))))                  
                INTO :PA-ADDRESS-ID                                     
                    ,:PA-PHONE-NO                                       
                    ,:PA-EXTENSION-NO                                   
                    ,:PA-ADDRESS-FORMAT                                 
                    ,:PY-PHYSICIAN-ID                                   
                    ,:PY-NAME-ID                                        
                    ,:PY-MED-LIC-STATE-CD                               
                    ,:PY-MED-LICENSE-NO                                 
                    ,:WS-MEDCERT-LICENSE                                
                FROM CSS_PHYSICIAN      PY WITH(READUNCOMMITTED)                
                    ,CSS_PHYSICIAN_ATTR PA WITH(READUNCOMMITTED)                
               WHERE PY.NAME_ID      = :DQ-NAME-ID                      
                 AND PA.PHYSICIAN_ID = PY.PHYSICIAN_ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT PA.ADDRESS_ID                                      11990000
MFA-TR*             ,PA.PHONE_NO                                                
MFA-TR*             ,PA.EXTENSION_NO                                            
MFA-TR*             ,PA.ADDRESS_FORMAT                                          
MFA-TR*             ,PY.PHYSICIAN_ID                                            
MFA-TR*             ,PY.NAME_ID                                                 
MFA-TR*             ,PY.MED_LIC_STATE_CD                                        
MFA-TR*             ,PY.MED_LICENSE_NO                                          
MFA-TR*             ,RTRIM(LTRIM(RTRIM(PY.MED_LIC_STATE_CD) || ' ' ||           
MFA-TR*              LTRIM(RTRIM(PY.MED_LICENSE_NO))))                          
MFA-TR*         INTO :PA-ADDRESS-ID                                     12000000
MFA-TR*             ,:PA-PHONE-NO                                               
MFA-TR*             ,:PA-EXTENSION-NO                                           
MFA-TR*             ,:PA-ADDRESS-FORMAT                                         
MFA-TR*             ,:PY-PHYSICIAN-ID                                           
MFA-TR*             ,:PY-NAME-ID                                                
MFA-TR*             ,:PY-MED-LIC-STATE-CD                               12000000
MFA-TR*             ,:PY-MED-LICENSE-NO                                 12000000
MFA-TR*             ,:WS-MEDCERT-LICENSE                                        
MFA-TR*         FROM CSS_PHYSICIAN      PY                              12010000
MFA-TR*             ,CSS_PHYSICIAN_ATTR PA                              12010000
MFA-TR*        WHERE PY.NAME_ID      = :DQ-NAME-ID                              
MFA-TR*          AND PA.PHYSICIAN_ID = PY.PHYSICIAN_ID                  12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 MOVE 'Y'                  TO WS-PHYSICIAN-FOUND        
            WHEN NOT-FOUND                                              
                 MOVE 'N'                  TO WS-PHYSICIAN-FOUND        
            WHEN OTHER                                                  
                 MOVE '7010'               TO ACTIVE-PARAGRAPH          
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSS_PHYSICIAN'      TO TABLE-1                   
                 MOVE 'CSS_PHYSICIAN_ATTR' TO TABLE-2                   
                 MOVE 'NAME_ID'            TO TABLE-ELEMENT-1           
                 MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT    
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7020-SELECT-PHY-ADDR-FMT                                        11850000
      ******************************************************************11920000
                                                                        
       7020-SELECT-PHY-ADDR-FMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT DY.ADDR_PREFIX_1                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.ADDR_USAGE_CD                                   
                    ,DY.ADDRESS_ID                                      
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.HOUSE_NO                                        
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.STREET_NAME                                     
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDR_SUFFIX                                     
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,DY.ZIP_CODE_TOKEN                                  
                    ,A4.TOWN                                            
                    ,A4.STATE                                           
                    ,RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) + ' ' + LTRIM(RTRIM(
           DY.ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(DY.ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(DY.STREET_NAME) + ' ' + LTRIM(RTRIM(
           DY.STREET_SUFFIX) + ' ' + LTRIM(RTRIM(DY.ADDR_SUFFIX) + 
           ' ' + LTRIM(RTRIM(DY.STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           DY.STREET_LOCATION_2) + ' ' + LTRIM(RTRIM(A4.TOWN) + ', ' + 
           LTRIM(RTRIM(A4.STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))))))
           ))))))               
                INTO :DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-ADDR-USAGE-CD                                  
                    ,:DY-ADDRESS-ID                                     
                    ,:DY-ADDRESS-OVERFLOW                               
                    ,:DY-HOUSE-NO                                       
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ADDR-SUFFIX                                    
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:DY-ZIP-CODE-TOKEN                                 
                    ,:A4-TOWN                                           
                    ,:A4-STATE                                          
                    ,:WS-ADDRESS-LINE                                   
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
                    ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
               WHERE ADDRESS_ID        = :DY-ADDRESS-ID                 
                 AND DY.ZIP_CODE       = A4.ZIP_CODE                    
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     15780000
MFA-TR*       SELECT DY.ADDR_PREFIX_1                                   15790000
MFA-TR*             ,DY.ADDR_PREFIX_2                                   15800000
MFA-TR*             ,DY.ADDR_USAGE_CD                                   15820000
MFA-TR*             ,DY.ADDRESS_ID                                              
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.HOUSE_NO                                                
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,DY.ZIP_CODE_TOKEN                                          
MFA-TR*             ,A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*             ,RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(DY.ADDR_PREFIX_1) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DY.ADDR_PREFIX_2) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DY.STREET_NAME) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(DY.STREET_SUFFIX) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DY.ADDR_SUFFIX) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(DY.STREET_LOCATION_1) || ' ' ||                
MFA-TR*              LTRIM(RTRIM(DY.STREET_LOCATION_2)|| ' ' ||                 
MFA-TR*              LTRIM(RTRIM(A4.TOWN) || ', ' ||                            
MFA-TR*              LTRIM(RTRIM(A4.STATE) || ' ' ||                            
MFA-TR*              LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))                       
MFA-TR*         INTO :DY-ADDR-PREFIX-1                                  15830000
MFA-TR*             ,:DY-ADDR-PREFIX-2                                  15800000
MFA-TR*             ,:DY-ADDR-USAGE-CD                                  15820000
MFA-TR*             ,:DY-ADDRESS-ID                                             
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                                       
MFA-TR*             ,:DY-HOUSE-NO                                               
MFA-TR*             ,:DY-STREET-LOCATION-1                                      
MFA-TR*             ,:DY-STREET-LOCATION-2                                      
MFA-TR*             ,:DY-STREET-NAME                                            
MFA-TR*             ,:DY-STREET-SUFFIX                                          
MFA-TR*             ,:DY-ADDR-SUFFIX                                            
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:DY-ZIP-CODE-TOKEN                                         
MFA-TR*             ,:A4-TOWN                                           14200000
MFA-TR*             ,:A4-STATE                                          14200000
MFA-TR*             ,:WS-ADDRESS-LINE                                           
MFA-TR*         FROM CSS_ADDR_FORMATTED DY                              15870000
MFA-TR*             ,CSS_ZIP_CODE       A4                              15870000
MFA-TR*        WHERE ADDRESS_ID        = :DY-ADDRESS-ID                 15130000
MFA-TR*          AND DY.ZIP_CODE       = A4.ZIP_CODE                            
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO  7020                                                      
MFA-TR*    END-EXEC.                                                    15890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7020'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_ADDR_FORMATTED'    TO TABLE-1                   
              MOVE 'CSS_ZIP_CODE'          TO TABLE-2                   
              MOVE 'ADDRESS-ID'            TO TABLE-ELEMENT-1           
              MOVE DY-ADDRESS-ID           TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7030-SELECT-PHY-ADDR-FF                                         11850000
      ******************************************************************11920000
                                                                        
       7030-SELECT-PHY-ADDR-FF.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DZ.ADDR_STREET                                     
                    ,DZ.ADDRESS_OVERFLOW                                
                    ,DZ.ADDR_CITY_STATE                                 
                    ,DZ.ADDR_ZIP_CODE                                   
                    ,DZ.ADDR_COUNTRY                                    
                    ,RTRIM(LTRIM(RTRIM(DZ.ADDR_STREET) + ' ' + LTRIM(
           RTRIM(DZ.ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(
           DZ.ADDR_CITY_STATE) + ' ' + LTRIM(RTRIM(DZ.ADDR_ZIP_CODE) + 
           ' ' + LTRIM(RTRIM(DZ.ADDR_COUNTRY)))))))                 
                INTO :DZ-ADDR-STREET                                    
                    ,:DZ-ADDRESS-OVERFLOW                               
                    ,:DZ-ADDR-CITY-STATE                                
                    ,:DZ-ADDR-ZIP-CODE                                  
                    ,:DZ-ADDR-COUNTRY                                   
                    ,:WS-ADDRESS-LINE                                   
                FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED)                 
               WHERE ADDRESS_ID             = :DZ-ADDRESS-ID            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     15010000
MFA-TR*       SELECT DZ.ADDR_STREET                                     15020000
MFA-TR*             ,DZ.ADDRESS_OVERFLOW                                15030000
MFA-TR*             ,DZ.ADDR_CITY_STATE                                 15040000
MFA-TR*             ,DZ.ADDR_ZIP_CODE                                   15050000
MFA-TR*             ,DZ.ADDR_COUNTRY                                    15060000
MFA-TR*             ,RTRIM(LTRIM(RTRIM(DZ.ADDR_STREET) || ' ' ||                
MFA-TR*              LTRIM(RTRIM(DZ.ADDRESS_OVERFLOW) || ' ' ||                 
MFA-TR*              LTRIM(RTRIM(DZ.ADDR_CITY_STATE) || ' ' ||                  
MFA-TR*              LTRIM(RTRIM(DZ.ADDR_ZIP_CODE) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DZ.ADDR_COUNTRY)))))))                         
MFA-TR*         INTO :DZ-ADDR-STREET                                    15070000
MFA-TR*             ,:DZ-ADDRESS-OVERFLOW                               15080000
MFA-TR*             ,:DZ-ADDR-CITY-STATE                                15090000
MFA-TR*             ,:DZ-ADDR-ZIP-CODE                                  15100000
MFA-TR*             ,:DZ-ADDR-COUNTRY                                   15110000
MFA-TR*             ,:WS-ADDRESS-LINE                                   15110000
MFA-TR*         FROM CSS_ADDR_FREEFORM DZ                               15120000
MFA-TR*        WHERE ADDRESS_ID             = :DZ-ADDRESS-ID            15130000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                    15140000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7030'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_ADDR_FREEFORM'     TO TABLE-1                   
              MOVE 'ADDRESS_ID'            TO TABLE-ELEMENT-1           
              MOVE DZ-ADDRESS-ID           TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-PHY-NAME-CURSOR                                               
      ******************************************************************        
                                                                        
       7500-OPEN-PHY-NAME-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN PHYSICIAN-NAME                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
                  MOVE '7500'              TO ACTIVE-PARAGRAPH          
                  MOVE 'OPEN'              TO ABEND-FUNCTION            
                  MOVE SPACES              TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                  PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT    
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-PHY-NAME-CURSOR                                              
      ******************************************************************        
                                                                        
       7510-FETCH-PHY-NAME-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH PHYSICIAN-NAME                                     
                INTO :DQ-NAME-ID                                        
                    ,:DQ-FIRST-NAME                                     
                    ,:DQ-MIDDLE-NAME                                    
                    ,:DQ-LAST-NAME                                      
                    ,:DQ-TITLE-PREFIX                                   
                    ,:DQ-TITLE-SUFFIX-1                                 
                    ,:WS-PHYSICIAN-NAME                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN NOT-FOUND                                             
                  MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE     
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
                  MOVE '7510'              TO ACTIVE-PARAGRAPH          
                  MOVE 'FETCH'             TO ABEND-FUNCTION            
                  MOVE SPACES              TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                  MOVE 'CSS_NAME'          TO TABLE-1                   
                  MOVE 'FIRST NAME'        TO TABLE-ELEMENT-1           
                  MOVE 'MIDDLE NAME'       TO TABLE-ELEMENT-2           
                  MOVE 'LAST NAME'         TO TABLE-ELEMENT-3           
                  MOVE WS-PHYSICIAN-FIRST-NAME  TO HOSTVAR-ELEMENT-1    
                  MOVE WS-PHYSICIAN-MIDDLE-NAME TO HOSTVAR-ELEMENT-2    
                  MOVE WS-PHYSICIAN-LAST-NAME   TO HOSTVAR-ELEMENT-3    
                  PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT    
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-PHY-NAME-CURSOR                                              
      ******************************************************************        
                                                                        
       7520-CLOSE-PHY-NAME-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE PHYSICIAN-NAME                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
                  MOVE '7520'              TO ACTIVE-PARAGRAPH          
                  MOVE 'CLOSE'             TO ABEND-FUNCTION            
                  MOVE SPACES              TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                  PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT    
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04853                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04853                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE     
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE SQLCODE            TO ABEND-SQLCODE             
                   MOVE SQLSTATE           TO ABEND-SQLSTATE            
                   MOVE '8000A'            TO ACTIVE-PARAGRAPH          
                   MOVE 'DELETE'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSR04853'         TO TABLE-1                   
                   MOVE SPACES             TO TABLE-ELEMENT-1           
                   MOVE SPACES             TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT    
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT                                                *        
      ******************************************************************        
                                                                        
       8010-INSERT-GTT.                                                 
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04853                               
             (                                                          
              RETURN_CODE                                               
             ,FIRST_NAME                                                
             ,MIDDLE_NAME                                               
             ,LAST_NAME                                                 
             ,TITLE_PREFIX                                              
             ,TITLE_SUFFIX_1                                            
             ,FMT_HOUSE_NO                                              
             ,FMT_ADDR_PREFIX_1                                         
             ,FMT_ADDR_PREFIX_2                                         
             ,FMT_STREET_NAME                                           
             ,FMT_STREET_LOCATION_1                                     
             ,FMT_STREET_LOCATION_2                                     
             ,FMT_STREET_SUFFIX                                         
             ,FMT_ADDR_SUFFIX                                           
             ,FMT_ADDRESS_OVERFLOW                                      
             ,FMT_ZIP_CODE                                              
             ,FMT_ZIP_CODE_PLUS_FOUR                                    
             ,FMT_ZIP_CODE_TOKEN                                        
             ,FMT_ADDR_USAGE_CD                                         
             ,FMT_TOWN                                                  
             ,FMT_STATE                                                 
             ,FF_ADDR_STREET                                            
             ,FF_ADDRESS_OVERFLOW                                       
             ,FF_CITY_STATE                                             
             ,FF_ZIP_CODE                                               
             ,FF_COUNTRY                                                
             ,PHONE_NO                                                  
             ,EXTENSION                                                 
             ,PHYSICIAN_ID                                              
             ,NAME_ID                                                   
             ,ADDRESS_ID                                                
             ,MED_LIC_STATE_CD                                          
             ,MED_LICENSE_NO                                            
             ,PHYSICIAN_NAME                                            
             ,FULL_ADDRESS                                              
             ,MEDCERT_LICENSE                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-FIRST-NAME                                             
             ,:S-MIDDLE-NAME                                            
             ,:S-LAST-NAME                                              
             ,:S-TITLE-PREFIX                                           
             ,:S-TITLE-SUFFIX-1                                         
             ,:S-FMT-HOUSE-NO                                           
             ,:S-FMT-ADDR-PREFIX-1                                      
             ,:S-FMT-ADDR-PREFIX-2                                      
             ,:S-FMT-STREET-NAME                                        
             ,:S-FMT-STREET-LOCATION-1                                  
             ,:S-FMT-STREET-LOCATION-2                                  
             ,:S-FMT-STREET-SUFFIX                                      
             ,:S-FMT-ADDR-SUFFIX                                        
             ,:S-FMT-ADDRESS-OVERFLOW                                   
             ,:S-FMT-ZIP-CODE                                           
             ,:S-FMT-ZIP-CODE-PLUS-FOUR                                 
             ,:S-FMT-ZIP-CODE-TOKEN                                     
             ,:S-FMT-ADDR-USAGE-CD                                      
             ,:S-FMT-TOWN                                               
             ,:S-FMT-STATE                                              
             ,:S-FF-ADDR-STREET                                         
             ,:S-FF-ADDRESS-OVERFLOW                                    
             ,:S-FF-CITY-STATE                                          
             ,:S-FF-ZIP-CODE                                            
             ,:S-FF-COUNTRY                                             
             ,:S-PHONE-NO                                               
             ,:S-EXTENSION                                              
             ,:S-PHYSICIAN-ID                                           
             ,:S-NAME-ID                                                
             ,:S-ADDRESS-ID                                             
             ,:S-MED-LIC-STATE-CD                                       
             ,:S-MED-LICENSE-NO                                         
             ,:S-PHYSICIAN-NAME                                         
             ,:S-FULL-ADDRESS                                           
             ,:S-MEDCERT-LICENSE                                        
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04853                                       
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,FIRST_NAME                                                        
MFA-TR*      ,MIDDLE_NAME                                                       
MFA-TR*      ,LAST_NAME                                                         
MFA-TR*      ,TITLE_PREFIX                                                      
MFA-TR*      ,TITLE_SUFFIX_1                                                    
MFA-TR*      ,FMT_HOUSE_NO                                                      
MFA-TR*      ,FMT_ADDR_PREFIX_1                                                 
MFA-TR*      ,FMT_ADDR_PREFIX_2                                                 
MFA-TR*      ,FMT_STREET_NAME                                                   
MFA-TR*      ,FMT_STREET_LOCATION_1                                             
MFA-TR*      ,FMT_STREET_LOCATION_2                                             
MFA-TR*      ,FMT_STREET_SUFFIX                                                 
MFA-TR*      ,FMT_ADDR_SUFFIX                                                   
MFA-TR*      ,FMT_ADDRESS_OVERFLOW                                              
MFA-TR*      ,FMT_ZIP_CODE                                                      
MFA-TR*      ,FMT_ZIP_CODE_PLUS_FOUR                                            
MFA-TR*      ,FMT_ZIP_CODE_TOKEN                                                
MFA-TR*      ,FMT_ADDR_USAGE_CD                                                 
MFA-TR*      ,FMT_TOWN                                                          
MFA-TR*      ,FMT_STATE                                                         
MFA-TR*      ,FF_ADDR_STREET                                                    
MFA-TR*      ,FF_ADDRESS_OVERFLOW                                               
MFA-TR*      ,FF_CITY_STATE                                                     
MFA-TR*      ,FF_ZIP_CODE                                                       
MFA-TR*      ,FF_COUNTRY                                                        
MFA-TR*      ,PHONE_NO                                                          
MFA-TR*      ,EXTENSION                                                         
MFA-TR*      ,PHYSICIAN_ID                                                      
MFA-TR*      ,NAME_ID                                                           
MFA-TR*      ,ADDRESS_ID                                                        
MFA-TR*      ,MED_LIC_STATE_CD                                                  
MFA-TR*      ,MED_LICENSE_NO                                                    
MFA-TR*      ,PHYSICIAN_NAME                                                    
MFA-TR*      ,FULL_ADDRESS                                                      
MFA-TR*      ,MEDCERT_LICENSE                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-FIRST-NAME                                                     
MFA-TR*      ,:S-MIDDLE-NAME                                                    
MFA-TR*      ,:S-LAST-NAME                                                      
MFA-TR*      ,:S-TITLE-PREFIX                                                   
MFA-TR*      ,:S-TITLE-SUFFIX-1                                                 
MFA-TR*      ,:S-FMT-HOUSE-NO                                                   
MFA-TR*      ,:S-FMT-ADDR-PREFIX-1                                              
MFA-TR*      ,:S-FMT-ADDR-PREFIX-2                                              
MFA-TR*      ,:S-FMT-STREET-NAME                                                
MFA-TR*      ,:S-FMT-STREET-LOCATION-1                                          
MFA-TR*      ,:S-FMT-STREET-LOCATION-2                                          
MFA-TR*      ,:S-FMT-STREET-SUFFIX                                              
MFA-TR*      ,:S-FMT-ADDR-SUFFIX                                                
MFA-TR*      ,:S-FMT-ADDRESS-OVERFLOW                                           
MFA-TR*      ,:S-FMT-ZIP-CODE                                                   
MFA-TR*      ,:S-FMT-ZIP-CODE-PLUS-FOUR                                         
MFA-TR*      ,:S-FMT-ZIP-CODE-TOKEN                                             
MFA-TR*      ,:S-FMT-ADDR-USAGE-CD                                              
MFA-TR*      ,:S-FMT-TOWN                                                       
MFA-TR*      ,:S-FMT-STATE                                                      
MFA-TR*      ,:S-FF-ADDR-STREET                                                 
MFA-TR*      ,:S-FF-ADDRESS-OVERFLOW                                            
MFA-TR*      ,:S-FF-CITY-STATE                                                  
MFA-TR*      ,:S-FF-ZIP-CODE                                                    
MFA-TR*      ,:S-FF-COUNTRY                                                     
MFA-TR*      ,:S-PHONE-NO                                                       
MFA-TR*      ,:S-EXTENSION                                                      
MFA-TR*      ,:S-PHYSICIAN-ID                                                   
MFA-TR*      ,:S-NAME-ID                                                        
MFA-TR*      ,:S-ADDRESS-ID                                                     
MFA-TR*      ,:S-MED-LIC-STATE-CD                                               
MFA-TR*      ,:S-MED-LICENSE-NO                                                 
MFA-TR*      ,:S-PHYSICIAN-NAME                                                 
MFA-TR*      ,:S-FULL-ADDRESS                                                   
MFA-TR*      ,:S-MEDCERT-LICENSE                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                       TO  CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE '8010'                  TO ACTIVE-PARAGRAPH          
              MOVE 'INSERT'                TO ABEND-FUNCTION            
              MOVE 'CSR04853'              TO TABLE-1                   
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM             
           MOVE '8900'                     TO ACTIVE-PARAGRAPH          
           MOVE 'OPEN'                     TO ABEND-FUNCTION            
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE      TO ABEND-SQLCODE             
                                              S-RETURN-CODE.            
                                                                        
           MOVE SQLERRMC                   TO ABEND-SQLERRMC.           
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'              TO ABEND-FUNCTION            
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT                  THRU 0100A-EXIT.  
                                                                        
           PERFORM 8010-INSERT-GTT                    THRU 8010-EXIT.   
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT             THRU 9000-EXIT.   
           PERFORM 9900-SQL-ERROR-ROUTINE             THRU 9900-EXIT.   
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF WS-TBL-COUNT = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                     TO S-RETURN-CODE             
              PERFORM 8010-INSERT-GTT                 THRU 8010-EXIT    
           END-IF.                                                      
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '9999-END-PROGRAM'      TO ABEND-FUNCTION            
              MOVE 'PROGRAMMER LOGIC'      TO TABLE-1                   
              MOVE 'FAILED TO SEND'        TO TABLE-ELEMENT-1           
              MOVE 'RESULT SET'            TO HOSTVAR-ELEMENT-1         
              MOVE -1                      TO WS-ACTIVE-RETURN-CODE     
                                                                        
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           ELSE                                                         
              PERFORM 8900-SEND-DONE                  THRU 8900-EXIT    
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
