       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04852.                                         
       AUTHOR.        VENKAT PONNEKANTI                                 
COB303 DATE-WRITTEN.  FEB 26, 2016.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      * RETRIEVES OVERAGE/SHORTAGE DETAILS FOR GIVEN CRITERIA          *        
      *                                                                *        
      * BUSS-OP: GETOVERAGESHORTAGEHISTORY                             *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * -------- -------- -------------------------------------------- *        
      *   DATE   INITIALS COMMENTS                                     *        
      * -------- -------- -------------------------------------------- *        
P00586* 02/26/16 VP43661  INITIAL IMPLEMENTATION.                      *        
P0586A* 10/20/16 VP43661  OFFSET REVERSAL CHANGES                      *        
      *                                                                *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      * 0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              *        
      * 1000 - 1999  INPUT PROCESSING CONTROL PATH                     *        
      * 2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    *        
      * 3000 - 4999  NOT USED                                          *        
      * 5000 - 5999  COMMON PROGRAM MODULES                            *        
      * 6000 - 6999  COMMON SYSTEM MODULES                             *        
      * 7000 - 7999  INPUT MODULES                                     *        
      * 8000 - 8999  OUTPUT MODULES                                    *        
      * 9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04852'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40)       VALUE       
                       'WORKING STORAGE FOR CSR04852 STARTS HERE'.      
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-CASH-OFFICES.                                           
             49 FILLER                      PIC S9(4)  COMP  VALUE 0.   
             49 WS-CASH-OFFICES-TXT         PIC X(300) VALUE SPACES.    
          05 WS-CASH-OFFICES-TXT1           PIC X(300) VALUE SPACES.    
          05 WS-CASH-OFF REDEFINES WS-CASH-OFFICES-TXT1                 
                         OCCURS 100 TIMES.                              
             10 WS-CASH-LOC-OFF             PIC X(03) .                 
          05 WS-CASH-LO-NO                  PIC X(03) .                 
          05 WS-SQLSTATE                    PIC X(5)  VALUE SPACES.     
          05 WS-EXISTS-FL                   PIC X(1)  VALUE SPACES.     
          05 WS-END-OF-LO-FL                PIC X(1)  VALUE SPACES.     
          05 WS-START-DT                    PIC X(10) VALUE SPACES.     
          05 WS-END-DT                      PIC X(10) VALUE SPACES.     
          05 WS-GL-ACCT-NO-SRCH             PIC X(8)  VALUE '%%%.%%%%'. 
          05 WS-DRAWER-ID-SRCH              PIC X(5)  VALUE '%%%%%'.    
          05 WS-OVRSHRT-ID-SRCH             PIC X(5)  VALUE '%%%%%'.    
      *                                                                         
       01 WS-COUNTER.                                                   
          05 CTR-ROWS                       PIC S9(9) COMP  VALUE 1.    
          05 SUB                            PIC S9(4) COMP  VALUE 1.    
                                                                        
       01 WS-CONSTANTS.                                                 
          05 PROGRAM-NAME                   PIC X(8)  VALUE 'CSR04852'. 
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                   PIC X(01) VALUE 'Y'.        
             88 SEND-DONE-ERROR                       VALUE 'N'.        
             88 SEND-DONE-OK                          VALUE 'Y'.        
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                  PIC S9(9) COMP  VALUE 0.    
      *                                                                         
      ******************************************************************00560000
      * DB2 INCLUDES                                                   *00570000
      ******************************************************************00580000
      *                                                                         
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
      *                                                                         
      ******************************************************************00560000
      * CSS_CSH_DRWR_CNTL - CS                                         *        
      ******************************************************************00560000
      *                                                                         
           EXEC SQL                                                     00840000
              INCLUDE TBCDCNTL                                          00850000
           END-EXEC.                                                    00860000
      *                                                                         
      ******************************************************************00560000
      * CSS_OVERSHORT_HDR - OH                                         *        
      ******************************************************************00560000
      *                                                                         
           EXEC SQL                                                     00840000
              INCLUDE TBOVSHHD                                          00850000
           END-EXEC.                                                    00860000
      *                                                                         
      ******************************************************************00560000
      * CSS_OVERSHORT_DET - OD                                         *        
      ******************************************************************00560000
      *                                                                         
           EXEC SQL                                                     00840000
              INCLUDE TBOVSHDT                                          00850000
           END-EXEC.                                                    00860000
      *                                                                         
      ******************************************************************00560000
      * CSS_USER_PROFILE - PF                                         *         
      ******************************************************************00560000
      *                                                                         
           EXEC SQL                                                     00840000
              INCLUDE TBUSRPRF                                          00850000
           END-EXEC.                                                    00860000
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************06900000
      * CURSOR FOR OVERAGE/SHORTAGE COUNT                              *06910000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE AS RETURN_CODE                    
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        06930000
MFA-TR*         SELECT :S-RETURN-CODE AS RETURN_CODE                            
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************06900000
      * CURSOR FOR OVERAGE/SHORTAGE HISTORY                            *06910000
      * CALLING PROCESS SHOULD EXPECT C2 ONLY WHEN C1 HAS 0 RETURN CODE*34660000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
            DECLARE C2 CURSOR  FOR                           
             SELECT OH.CASH_COMPANY_NO                                  
               ,OH.DATE_CASH_REPORT                                     
               ,OH.USER_ID                                              
               ,LTRIM(RTRIM(PF.LAST_NAME)) + ', ' + LTRIM(RTRIM(
           PF.FIRST_NAME)) + ' ' + CIS.SUBSTR2(
           PF.MIDDLE_NAME,1)     AS FULL_NAME        
               ,OH.CASH_LOCAL_OFFICE                                    
               ,OH.CASH_DRAWER_ID                                       
               ,COALESCE(CS.AMT_CASH_DEBIT, 0.00)     AS AMT_CASH_DEBIT   
               ,COALESCE(CS.AMT_CASH_CREDIT, 0.00)    AS AMT_CASH_CREDIT  
               ,COALESCE(CS.CODE_CSH_DRWR_STAT, ' ')  AS CODE_DRWR_STAT   
               ,COALESCE(REPLACE(REPLACE(CONVERT(CHAR(26), CS.CREATED_TS
           , 121), ' ', '-'), ':', '.'),' ')     AS CREATED_TS       
               ,COALESCE(REPLACE(REPLACE(CONVERT(CHAR(26), 
           CS.BALANCED_TS, 121), ' ', '-'), ':', '.'),' ')    AS 
           BALANCED_TS      
               ,OH.GL_ACCT_NO                                           
               ,OH.OVERSHORT_ID                                         
               ,OH.OVERSHORT_DR_CR                                      
               ,OH.OVERSHORT_AMT                                        
               ,OH.OFST_DR_CR                                           
               ,OH.OFST_OVERSHORT_AMT                                   
               ,OH.OVERSHORT_SOLTN_FL                                   
               ,OH.OVERSHORT_TYPE_CD                                    
               ,OH.ACCOUNT_NO                                           
               ,COALESCE(OD.OVERSHORT_SEQ_NO, 0)      AS 
           OVERSHORT_SEQ_NO 
               ,COALESCE(OD.OFST_DR_CR,' ')           AS OFST_DR_CR       
               ,COALESCE(OD.OFST_OVERSHORT_AMT, 0.00) AS 
           OFST_OVRSHRT_AMT 
               ,COALESCE(OD.OFST_COMPANY_NO,' ')      AS OFST_COMPANY_NO  
               ,COALESCE(OD.OFST_LOC_OFCE,' ')        AS OFST_LOC_OFCE    
               ,COALESCE(CAST(OFST_CASH_REPT_DT AS CHAR(10)),' ') AS 
           OFST_CASH_REPT_DT
               ,COALESCE(OD.OFST_CASH_DRWR_ID, 0)     AS 
           OFST_CASH_DRWR_ID
               ,COALESCE(OD.OFST_OVERSHORT_ID,0)      AS 
           OFST_OVERSHORT_ID
               ,OH.TRAN_COMMENT                     AS COMMENTS         
               ,CIS.CHAR2$DATE(CAST(OH.TRAN_TS AS DATE),'USA') + ' ' + 
           CIS.CHAR2$TIME(DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(OH.TRAN_TS AS TIME)), CAST(
           OH.TRAN_TS AS TIME)),'USA')         AS TRAN_TS          
               ,CIS.CHAR2$DATE(CAST(OH.LAST_UPDATE_TS AS DATE),'USA') + 
           ' ' + CIS.CHAR2$TIME(DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(OH.LAST_UPDATE_TS AS TIME)), 
           CAST(OH.LAST_UPDATE_TS AS TIME)),'USA')  AS LAST_UPDATE_TS   
             FROM  CSS_USER_PROFILE      PF                             
                  ,CSS_OVERSHORT_HDR     OH                             
             LEFT JOIN CSS_CSH_DRWR_CNTL CS                             
                    ON CS.CASH_COMPANY_NO   = OH.CASH_COMPANY_NO        
                   AND CS.CASH_LOCAL_OFFICE = OH.CASH_LOCAL_OFFICE      
                   AND CS.DATE_CASH_REPORT  = OH.DATE_CASH_REPORT       
                   AND CS.CASH_DRAWER_ID    = OH.CASH_DRAWER_ID         
             LEFT JOIN CSS_OVERSHORT_DET OD                             
                    ON OH.CASH_COMPANY_NO   = OD.CASH_COMPANY_NO        
                   AND OH.CASH_LOCAL_OFFICE = OD.CASH_LOCAL_OFFICE      
                   AND OH.DATE_CASH_REPORT  = OD.DATE_CASH_REPORT       
                   AND OH.CASH_DRAWER_ID    = OD.CASH_DRAWER_ID         
                   AND OH.OVERSHORT_ID      = OD.OVERSHORT_ID           
            WHERE OH.CASH_DRAWER_ID         >  0                        
              AND OH.USER_ID                = PF.USER_ID                
              AND OH.CASH_COMPANY_NO        = :OH-CASH-COMPANY-NO       
              AND LTRIM(RTRIM(CIS.DECIMAL2CHAR(OH.GL_ACCT_NO)))                 
                                         LIKE :WS-GL-ACCT-NO-SRCH       
              AND CIS.DIGITS(OH.CASH_DRAWER_ID)                       
                                         LIKE :WS-DRAWER-ID-SRCH        
              AND CIS.DIGITS(OH.OVERSHORT_ID)                         
                                         LIKE :WS-OVRSHRT-ID-SRCH       
              AND OH.CASH_LOCAL_OFFICE     IN (SELECT CASH_LO_NO FROM   
                                               #CSR04852_R1)     
P0586A        AND OH.OVERSHORT_SOLTN_FL    IN ('S','P')                 
              AND OH.DATE_CASH_REPORT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                           :WS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DT
              ) <> 0) OR (LEN(:WS-START-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-START-DT
              ), CONVERT(DATE, :WS-START-DT) )              
                                          AND IIF(TRY_CONVERT(DATE, 
                                                             :WS-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DT) <> 0) OR (LEN(
                                                             :WS-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-END-DT), CONVERT(DATE, 
                                                             :WS-END-DT
              ) )                
            ORDER BY OH.CASH_COMPANY_NO                                 
                    ,OH.DATE_CASH_REPORT                                
                    ,OH.USER_ID                                         
                    ,OH.CASH_LOCAL_OFFICE                               
                    ,OH.CASH_DRAWER_ID                                  
                    ,OH.OVERSHORT_ID                                    
                    ,OD.OVERSHORT_SEQ_NO                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*     DECLARE C2 CURSOR WITH RETURN FOR                           06930000
MFA-TR*      SELECT OH.CASH_COMPANY_NO                                          
MFA-TR*        ,OH.DATE_CASH_REPORT                                             
MFA-TR*        ,OH.USER_ID                                                      
MFA-TR*        ,TRIM(PF.LAST_NAME)||', '||TRIM(PF.FIRST_NAME)                   
MFA-TR*         ||' '||SUBSTR(PF.MIDDLE_NAME,1)     AS FULL_NAME                
MFA-TR*        ,OH.CASH_LOCAL_OFFICE                                            
MFA-TR*        ,OH.CASH_DRAWER_ID                                               
MFA-TR*        ,IFNULL(CS.AMT_CASH_DEBIT, 0.00)     AS AMT_CASH_DEBIT           
MFA-TR*        ,IFNULL(CS.AMT_CASH_CREDIT, 0.00)    AS AMT_CASH_CREDIT          
MFA-TR*        ,IFNULL(CS.CODE_CSH_DRWR_STAT, ' ')  AS CODE_DRWR_STAT           
MFA-TR*        ,IFNULL(CHAR(CS.CREATED_TS),' ')     AS CREATED_TS               
MFA-TR*        ,IFNULL(CHAR(CS.BALANCED_TS),' ')    AS BALANCED_TS              
MFA-TR*        ,OH.GL_ACCT_NO                                                   
MFA-TR*        ,OH.OVERSHORT_ID                                                 
MFA-TR*        ,OH.OVERSHORT_DR_CR                                              
MFA-TR*        ,OH.OVERSHORT_AMT                                                
MFA-TR*        ,OH.OFST_DR_CR                                                   
MFA-TR*        ,OH.OFST_OVERSHORT_AMT                                           
MFA-TR*        ,OH.OVERSHORT_SOLTN_FL                                           
MFA-TR*        ,OH.OVERSHORT_TYPE_CD                                            
MFA-TR*        ,OH.ACCOUNT_NO                                                   
MFA-TR*        ,IFNULL(OD.OVERSHORT_SEQ_NO, 0)      AS OVERSHORT_SEQ_NO         
MFA-TR*        ,IFNULL(OD.OFST_DR_CR,' ')           AS OFST_DR_CR               
MFA-TR*        ,IFNULL(OD.OFST_OVERSHORT_AMT, 0.00) AS OFST_OVRSHRT_AMT         
MFA-TR*        ,IFNULL(OD.OFST_COMPANY_NO,' ')      AS OFST_COMPANY_NO          
MFA-TR*        ,IFNULL(OD.OFST_LOC_OFCE,' ')        AS OFST_LOC_OFCE            
MFA-TR*        ,IFNULL(CHAR(OFST_CASH_REPT_DT),' ') AS OFST_CASH_REPT_DT        
MFA-TR*        ,IFNULL(OD.OFST_CASH_DRWR_ID, 0)     AS OFST_CASH_DRWR_ID        
MFA-TR*        ,IFNULL(OD.OFST_OVERSHORT_ID,0)      AS OFST_OVERSHORT_ID        
MFA-TR*        ,OH.TRAN_COMMENT                     AS COMMENTS                 
MFA-TR*        ,CHAR(DATE(OH.TRAN_TS ),USA) || ' ' ||                           
MFA-TR*         CHAR(TIME(OH.TRAN_TS ),USA)         AS TRAN_TS                  
MFA-TR*        ,CHAR(DATE(OH.LAST_UPDATE_TS ),USA) || ' ' ||                    
MFA-TR*         CHAR(TIME(OH.LAST_UPDATE_TS ),USA)  AS LAST_UPDATE_TS           
MFA-TR*      FROM  CSS_USER_PROFILE      PF                                     
MFA-TR*           ,CSS_OVERSHORT_HDR     OH                                     
MFA-TR*      LEFT JOIN CSS_CSH_DRWR_CNTL CS                                     
MFA-TR*             ON CS.CASH_COMPANY_NO   = OH.CASH_COMPANY_NO                
MFA-TR*            AND CS.CASH_LOCAL_OFFICE = OH.CASH_LOCAL_OFFICE              
MFA-TR*            AND CS.DATE_CASH_REPORT  = OH.DATE_CASH_REPORT               
MFA-TR*            AND CS.CASH_DRAWER_ID    = OH.CASH_DRAWER_ID                 
MFA-TR*      LEFT JOIN CSS_OVERSHORT_DET OD                                     
MFA-TR*             ON OH.CASH_COMPANY_NO   = OD.CASH_COMPANY_NO                
MFA-TR*            AND OH.CASH_LOCAL_OFFICE = OD.CASH_LOCAL_OFFICE              
MFA-TR*            AND OH.DATE_CASH_REPORT  = OD.DATE_CASH_REPORT               
MFA-TR*            AND OH.CASH_DRAWER_ID    = OD.CASH_DRAWER_ID                 
MFA-TR*            AND OH.OVERSHORT_ID      = OD.OVERSHORT_ID                   
MFA-TR*     WHERE OH.CASH_DRAWER_ID         >  0                        10190000
MFA-TR*       AND OH.USER_ID                = PF.USER_ID                10190000
MFA-TR*       AND OH.CASH_COMPANY_NO        = :OH-CASH-COMPANY-NO       10190000
MFA-TR*       AND TRIM(CHAR(OH.GL_ACCT_NO))                             10190000
MFA-TR*                                  LIKE :WS-GL-ACCT-NO-SRCH       10190000
MFA-TR*       AND CHAR(DIGITS(OH.CASH_DRAWER_ID))                               
MFA-TR*                                  LIKE :WS-DRAWER-ID-SRCH                
MFA-TR*       AND CHAR(DIGITS(OH.OVERSHORT_ID))                                 
MFA-TR*                                  LIKE :WS-OVRSHRT-ID-SRCH               
MFA-TR*       AND OH.CASH_LOCAL_OFFICE     IN (SELECT CASH_LO_NO FROM   10190000
MFA-TR*                                        SESSION.CSR04852_R1)             
MFA-TR*       AND OH.OVERSHORT_SOLTN_FL    IN ('S','P')                         
MFA-TR*       AND OH.DATE_CASH_REPORT BETWEEN :WS-START-DT              10190000
MFA-TR*                                   AND :WS-END-DT                10190000
MFA-TR*     ORDER BY OH.CASH_COMPANY_NO                                         
MFA-TR*             ,OH.DATE_CASH_REPORT                                        
MFA-TR*             ,OH.USER_ID                                                 
MFA-TR*             ,OH.CASH_LOCAL_OFFICE                                       
MFA-TR*             ,OH.CASH_DRAWER_ID                                          
MFA-TR*             ,OH.OVERSHORT_ID                                            
MFA-TR*             ,OD.OVERSHORT_SEQ_NO                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 PARM-APPL-NAME                    PIC X(08).                  
       01 PARM-COMPANY-NO                   PIC X(02).                  
       01 PARM-GL-ACCT-NO                   PIC X(08).                  
       01 PARM-START-DT                     PIC X(10).                  
       01 PARM-END-DT                       PIC X(10).                  
       01 PARM-DRAWER-ID                    PIC X(05).                  
       01 PARM-OVRSHRT-ID                   PIC X(05).                  
       01 PARM-CASH-LO-NOS                  PIC X(300).                 
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPL-NAME                          
                                PARM-COMPANY-NO                         
                                PARM-GL-ACCT-NO                         
                                PARM-START-DT                           
                                PARM-END-DT                             
                                PARM-DRAWER-ID                          
                                PARM-OVRSHRT-ID                         
                                PARM-CASH-LO-NOS.                       
      *                                                                         
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      ******************************************************************02170000
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      ******************************************************************02370000
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0101-DECLARE-GTT-R1      THRU 0101-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0101-DECLARE-GTT-R1.                                         *          
      ******************************************************************02290000
      *                                                                         
       0101-DECLARE-GTT-R1.                                             
      *                                                                         
           MOVE '0101'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04852_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04852_R1
              (                                                          
                 CASH_LO_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF SQLSTATE = '42710'                                        
              EXEC SQL                                                  
                  DELETE FROM #CSR04852_R1                       
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                          
MFA-TR*           DELETE FROM SESSION.CSR04852_R1                               
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0101'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04852_R1'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02370000
      * 1000-PROCESS-INPUT                                             *02300000
      ******************************************************************02370000
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE PARM-COMPANY-NO             TO OH-CASH-COMPANY-NO.      
           IF PARM-GL-ACCT-NO > SPACES                                  
              MOVE PARM-GL-ACCT-NO          TO WS-GL-ACCT-NO-SRCH
           END-IF.      
           IF PARM-DRAWER-ID > SPACES                                   
              MOVE PARM-DRAWER-ID           TO WS-DRAWER-ID-SRCH
           END-IF.       
           IF PARM-OVRSHRT-ID > SPACES                                  
              MOVE PARM-OVRSHRT-ID          TO WS-OVRSHRT-ID-SRCH
           END-IF.      
           MOVE PARM-START-DT               TO WS-START-DT.             
           MOVE PARM-END-DT                 TO WS-END-DT.               
           MOVE PARM-CASH-LO-NOS            TO WS-CASH-OFFICES.         
           MOVE WS-CASH-OFFICES-TXT         TO WS-CASH-OFFICES-TXT1.    
           INSPECT  WS-CASH-OFFICES-TXT1 REPLACING ALL LOW-VALUES BY    
                                                       SPACES.          
      *                                                                 34110000
           MOVE 'N'                         TO WS-END-OF-LO-FL.         
           PERFORM UNTIL SUB > 100 OR WS-END-OF-LO-FL = 'Y'             
              IF WS-CASH-LOC-OFF(SUB) = '$$$'                           
                 MOVE 'Y'                   TO WS-END-OF-LO-FL          
              ELSE                                                      
                 MOVE WS-CASH-LOC-OFF(SUB)  TO WS-CASH-LO-NO            
                 PERFORM 8000-INSERT-GTT-R1 THRU 8000-EXIT              
              END-IF                                                    
              ADD 1                         TO SUB                      
           END-PERFORM.                                                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02640000
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      ******************************************************************05190000
      *                                                                 05200000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 05200000
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 7000-SEL-CHECK-ROWS      THRU 7000-EXIT.             
      *                                                                 05200000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05200000
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
      *                                                                 12220000
       7000-SEL-CHECK-ROWS.                                             
      *                                                                 10120000
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 10120000
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO  :WS-EXISTS-FL                                     
                FROM  CSS_USER_PROFILE      PF WITH(READUNCOMMITTED)            
                     ,CSS_OVERSHORT_HDR     OH WITH(READUNCOMMITTED)            
                LEFT JOIN CSS_CSH_DRWR_CNTL CS WITH(READUNCOMMITTED)            
                       ON CS.CASH_COMPANY_NO   = OH.CASH_COMPANY_NO     
                      AND CS.CASH_LOCAL_OFFICE = OH.CASH_LOCAL_OFFICE   
                      AND CS.DATE_CASH_REPORT  = OH.DATE_CASH_REPORT    
                      AND CS.CASH_DRAWER_ID    = OH.CASH_DRAWER_ID      
                LEFT JOIN CSS_OVERSHORT_DET OD WITH(READUNCOMMITTED)            
                       ON OH.CASH_COMPANY_NO   = OD.CASH_COMPANY_NO     
                      AND OH.CASH_LOCAL_OFFICE = OD.CASH_LOCAL_OFFICE   
                      AND OH.DATE_CASH_REPORT  = OD.DATE_CASH_REPORT    
                      AND OH.CASH_DRAWER_ID    = OD.CASH_DRAWER_ID      
                      AND OH.OVERSHORT_ID      = OD.OVERSHORT_ID        
               WHERE OH.CASH_DRAWER_ID         >  0                     
                 AND OH.USER_ID                = PF.USER_ID             
                 AND OH.CASH_COMPANY_NO        = :OH-CASH-COMPANY-NO    
                 AND LTRIM(RTRIM(CIS.DECIMAL2CHAR(OH.GL_ACCT_NO)))              
                                            LIKE :WS-GL-ACCT-NO-SRCH    
                 AND OH.CASH_LOCAL_OFFICE     IN (SELECT CASH_LO_NO FROM
                                                  #CSR04852_R1
                           WITH(READUNCOMMITTED))  
P0586A           AND OH.OVERSHORT_SOLTN_FL    IN ('S','P')              
                 AND OH.DATE_CASH_REPORT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                           :WS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DT
              ) <> 0) OR (LEN(:WS-START-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-START-DT
              ), CONVERT(DATE, :WS-START-DT) )           
                                             AND IIF(TRY_CONVERT(DATE, 
                                                             :WS-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DT) <> 0) OR (LEN(
                                                             :WS-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-END-DT), CONVERT(DATE, 
                                                             :WS-END-DT
              ) )             
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10130000
MFA-TR*       SELECT  'Y'                                               10150000
MFA-TR*         INTO  :WS-EXISTS-FL                                     10170000
MFA-TR*         FROM  CSS_USER_PROFILE      PF                                  
MFA-TR*              ,CSS_OVERSHORT_HDR     OH                                  
MFA-TR*         LEFT JOIN CSS_CSH_DRWR_CNTL CS                                  
MFA-TR*                ON CS.CASH_COMPANY_NO   = OH.CASH_COMPANY_NO             
MFA-TR*               AND CS.CASH_LOCAL_OFFICE = OH.CASH_LOCAL_OFFICE           
MFA-TR*               AND CS.DATE_CASH_REPORT  = OH.DATE_CASH_REPORT            
MFA-TR*               AND CS.CASH_DRAWER_ID    = OH.CASH_DRAWER_ID              
MFA-TR*         LEFT JOIN CSS_OVERSHORT_DET OD                                  
MFA-TR*                ON OH.CASH_COMPANY_NO   = OD.CASH_COMPANY_NO             
MFA-TR*               AND OH.CASH_LOCAL_OFFICE = OD.CASH_LOCAL_OFFICE           
MFA-TR*               AND OH.DATE_CASH_REPORT  = OD.DATE_CASH_REPORT            
MFA-TR*               AND OH.CASH_DRAWER_ID    = OD.CASH_DRAWER_ID              
MFA-TR*               AND OH.OVERSHORT_ID      = OD.OVERSHORT_ID                
MFA-TR*        WHERE OH.CASH_DRAWER_ID         >  0                     10190000
MFA-TR*          AND OH.USER_ID                = PF.USER_ID             10190000
MFA-TR*          AND OH.CASH_COMPANY_NO        = :OH-CASH-COMPANY-NO    10190000
MFA-TR*          AND TRIM(CHAR(OH.GL_ACCT_NO))                          10190000
MFA-TR*                                     LIKE :WS-GL-ACCT-NO-SRCH    10190000
MFA-TR*          AND OH.CASH_LOCAL_OFFICE     IN (SELECT CASH_LO_NO FROM10190000
MFA-TR*                                           SESSION.CSR04852_R1)          
MFA-TR*          AND OH.OVERSHORT_SOLTN_FL    IN ('S','P')                      
MFA-TR*          AND OH.DATE_CASH_REPORT BETWEEN :WS-START-DT           10190000
MFA-TR*                                      AND :WS-END-DT             10190000
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    10200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10210000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                 10230000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_OVERSHORT_HDR'      TO TABLE-1                  
              MOVE 'CASH_LOCAL_OFFICE'      TO TABLE-ELEMENT-1          
              MOVE WS-CASH-OFFICES-TXT1     TO HOSTVAR-ELEMENT-1        
              MOVE 'GL_ACCT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-GL-ACCT-NO-SRCH       TO HOSTVAR-ELEMENT-2        
              MOVE 'DATE_CASH_REPORT_START' TO TABLE-ELEMENT-3          
              MOVE WS-START-DT              TO HOSTVAR-ELEMENT-3        
              MOVE 'DATE_CASH_REPORT_END'   TO TABLE-ELEMENT-4          
              MOVE WS-END-DT                TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 10120000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-GTT-R1.                                              
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04852_R1                            
             (                                                          
              CASH_LO_NO                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :WS-CASH-LO-NO                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04852_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       CASH_LO_NO                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :WS-CASH-LO-NO                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8001'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04852_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 34110000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34110000
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                 36680000
       8900-SEND-DONE.                                                  
      *                                                                 36680000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
              EXEC SQL                                                  
                  OPEN C2                                               
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                 
      *                                                                 34660000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE.           
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           END-IF.                                                      
      *                                                                 36950000
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
