       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04851.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  MAY 12, 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE UPDATES/INSERTS/DELETES ROWS FOR MEDICAL       *00190000
      *  CERTIFICATE INFORMATIONS.                                     *00200000
      *                                                                *00210000
      *  CREDIT ARRANGEMENTS RELEASE 6.0 CHANGES.                      *00210000
      *     1. CLONED OLD SPCB CSR02261                                *00210000
      *     2. STOP CAPTURING PHYSICIAN NAME AND ADDRESS DETAILS ON    *        
      *        CSS_CUST_ALERT TABLE.                                   *        
      *     3. PHYSICIAN NAME & ADDRESS WILL BE INSERTED INTO CSS_NAME/*        
      *        CSS_ADDR_FORMATTED/CSS_ADDR_FREEFORM BY CSR04864.       *        
      *     4. POPULATE NEWLY ADDED PHYSICIAN & PATIENT NAME ID IN     *00210000
      *        CSS_CUST_ALERT TABLE.                                   *        
      *     5. WRITE TRANSACTION HISTORY FOR PHYSICIAN, PATIENT NAME   *00210000
      *        AND ADDRESS DETAILS.                                    *        
      *                                                                *00210000
      *  CSR00125 - THIS PROCEDURE CANCELS ALL PENDING DNP ORDERS.     *        
      *  CSR02122 - THIS PROCEDURE UPDATES VALUES IN CSS_ACCOUNT AND   *        
      *             CSS_CREDIT PROFILE TABLE.                          *        
      *  CSR00423 - THIS PROCEDURE RETRIEVES WORK AREA AND CREW ID.    *        
ACT233*  CSR04675 - THIS PROCEDURE INSERT WQ DETAILS.                  *        
      *  CSR01556 - THIS PROCEDURE CANCELS ALL PENDING DNP NOTICES.    *        
      *                                                                *00210000
      *  #  INVOKED FROM MEDICAL CERTIFICATE SCREEN                    *        
      *                                                                *        
      *  #  BUSOP NAME: REQUUPDACCTMEDCERTDETAILSBUSINESSOP            *        
      *                                                                *        
      *  #  PARAMETERS                                                 *        
      *     IN                                                         *        
      *         DELETE-FLAG            X(01)                           *00240000
      *         ACCOUNT-NO             X(13)                           *00250000
      *         DATE-ALERT             X(10)                           *00260000
      *         DATE-EXPIRE            X(10)                           *00270000
      *         PATIENT-TITLE-PREFIX   X(09).                          *        
      *         PATIENT-FIRST-NAME     X(15).                          *        
      *         PATIENT-MIDDLE-NAME    X(15).                          *        
      *         PATIENT-LAST-NAME      X(40).                          *        
      *         PATIENT-TITLE-SUFFIX-1 X(03).                          *        
      *         PHYSICIAN-ID           S9(9) USAGE COMP.               *        
      *         USER-ID                X(07)                           *00400000
      *         FIRST-NOTICE-DATE      X(10)                           *00350000
      *         SECOND-NOTICE-DATE     X(10)                           *00360000
      *         DNP-DATE               X(10)                           *00370000
      *         TRANS-CMNT-TEXT        X(210).                         *        
      *         TRANS-CMNT-LEN         S9(04) COMP.                    *        
      *         IVR-DATE               X(10)                           *00370000
      *     OUT                                                        *        
      *         RETURN-CODE            S9(9)                           *00410000
      *                                                                *00410000
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  06/09/15  AA97148    INITIAL IMPLEMENTATION.                  *        
P0726A*  08/14/15  AA97148    Credit Arrangements release 6.1 changes- *        
P0726A*                       Allow sce&g and psnc companies to set up *        
P0726A*                       Medical Certificate on $0.00 balance.    *        
P0726B*  10/29/15  AA97148    DCR# 2838 - CHANGE PATIENT_NAME_ID AND   *        
P0726B*                       PHYSICIAN_ID TO HOLD NULL VALUES.        *        
A04860*  06/30/16  MR7E794    REMOVE THE 'DELETE FUNCTION FOR WQ       *        
A04860*            ACT119     CATEGORY 352 IN CSS_WQ_ITEMS_MF PARA 5350*        
ACT233*  07/26/16  TP7R341    REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
      *                                                                *        
      ******************************************************************00640000
      ******************************************************************00650000
      *                                                                *00660000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00670000
      *                                                                *00680000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00690000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00700000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00710000
      *  3000 - 4999  NOT USED                                         *00720000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00730000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00740000
      *  7000 - 7999  INPUT MODULES                                    *00750000
      *  8000 - 8999  OUTPUT MODULES                                   *00760000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00770000
      *                                                                *00780000
      ******************************************************************00790000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04851'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04851 STARTS HERE'.                  
                                                                        
      ******************************************************************00880000
      *    DB2 INCLUDES                                                *00890000
      ******************************************************************00900000
                                                                        
           EXEC SQL                                                     00920000
              INCLUDE SQLCA                                             00930000
           END-EXEC.                                                    00940000
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT          - AT                                      *        
      ******************************************************************        
           EXEC SQL                                                     01290000
              INCLUDE TBACCT                                            01300000
           END-EXEC.                                                    01310000
                                                                        
      ******************************************************************        
      * CSS_MNT_TRANS_HIST   - MH                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00990000
              INCLUDE TBMNHIST                                          01000000
           END-EXEC.                                                    01010000
                                                                        
      ******************************************************************        
      * CSS_MT_TRN_HST_DET   - MI                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01030000
              INCLUDE TBMNHDT                                           01040000
           END-EXEC.                                                    01050000
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE     - PF                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01070000
              INCLUDE TBUSRPRF                                          01080000
           END-EXEC.                                                    01090000
                                                                        
      ******************************************************************        
      * CSS_HOLIDAY          - J8                                      *        
      ******************************************************************        
           EXEC SQL                                                     01110000
              INCLUDE TBHLDAY                                           01120000
           END-EXEC.                                                    01130000
                                                                        
      ******************************************************************        
      * CSS_CRED_COLL        - CL                                      *        
      ******************************************************************        
           EXEC SQL                                                     01170000
              INCLUDE TBCRCOLL                                          01180000
           END-EXEC.                                                    01190000
                                                                        
      ******************************************************************        
      * CSS_CUST_ALERT       - CA                                      *        
      ******************************************************************        
           EXEC SQL                                                     01230000
              INCLUDE TBCSTALT                                          01240000
           END-EXEC.                                                    01250000
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY      - C8                                      *        
      ******************************************************************        
           EXEC SQL                                                     01290000
              INCLUDE TBDELQ                                            01300000
           END-EXEC.                                                    01310000
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT     - UT                                      *        
      ******************************************************************        
           EXEC SQL                                                     01290000
              INCLUDE TBUTLENV                                          01300000
           END-EXEC.                                                    01310000
                                                                        
      ******************************************************************        
      * CSS_READ_WINDOW      - RW                                      *        
      ******************************************************************        
           EXEC SQL                                                     01290000
              INCLUDE TBRDWNDW                                          01300000
           END-EXEC.                                                    01310000
      ******************************************************************        
      * CSS_ADDR_FORMATTED   - DY                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFMT                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM    - DZ                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFRE                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_NAME             - DQ                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBNAME                                            00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN        - PY                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBPHYSN                                           00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN_ATTR   - PA                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPHYADD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_NAME_ID_CNTL     - I7                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************01320000
      * WORKING STORAGE FOR CPD00309                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILL_WINDOW      - BN                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_REG_PROFILE      - LR                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_FORECAST    - CM                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRFCST                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************01330000
      * COBOL WORKING STORAGE COPY BOOKS                               *01340000
      ******************************************************************01350000
                                                                        
      ******************************************************************00289904
      * COPYBOOK ADDED FOR ERROR HANDLING.                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                 *01460000
      ******************************************************************        
                                                                        
           COPY CWS00027.                                               01470000
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *01480000
      ******************************************************************        
                                                                        
           COPY CWS00303.                                               01490000
                                                                        
      ******************************************************************        
      * TO BREAK UP CODES_DATA_PRESENT                                 *01500000
      ******************************************************************        
                                                                        
           COPY CWS00056.                                               01510000
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CPD00068                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CPDKR362                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWSKR362                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CPD00091                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CPD00071                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00004                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00011                                                  
           END-EXEC.                                                            
                                                                        
      *01 LOC1 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC2 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC3 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC4 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC5 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      ******************************************************************01530000
      *    WORK AREAS                                                  *01540000
      ******************************************************************01550000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR04851'.  
           05  MCSCB068                  PIC X(8)    VALUE 'MCSCB068'.  
           05  ALL-DONE-SW               PIC X(01)   VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  WS-SEB-REG-FLAG           PIC X(01)   VALUE 'N'.         
               88  WS-SEB-REGULATED                  VALUE 'Y'.         
               88  WS-SEB-DEREGULATED                VALUE 'N'.         
           05  SEND-DONE-SW              PIC X(01)   VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  WS-BAD-WORKING-DAY        PIC X(01).                     
               88 BAD-WORKING-DAY                    VALUE 'N'.         
               88 GOOD-WORKING-DAY                   VALUE 'Y'.         
           05  WS-A                      PIC X(02)   VALUE 'A '.        
           05  WS-B                      PIC X(02)   VALUE 'B '.        
           05  WS-DATABASE               PIC 9(01)   VALUE 0.           
               88 CSR-DATABASE                       VALUE 1.           
               88 SEB-DATABASE                       VALUE 2.           
           05  WS-COMPANY-NO             PIC X(02)   VALUE SPACES.      
               88 SCEG                               VALUE '01'.        
               88 PSNC                               VALUE '26'.        
           05  WS-DAY                    PIC S9(04)  COMP VALUE 0.      
           05  WS-DIFFERENCE             PIC S9(08)  COMP VALUE 0.      
           05  WS-SCND-NOTICE-DIFF       PIC S9(04)  COMP VALUE 0.      
           05  WS-FRST-NOTICE-DIFF       PIC S9(04)  COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(09)  COMP VALUE 0.      
           05  WS-WORK-DATE              PIC X(10)   VALUE SPACES.      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05  WS-ACCOUNT-NUM            PIC X(13).                     
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NUM                  
                                         PIC 9(13).                     
           05  WS-DATE-ALERT             PIC X(10)   VALUE SPACES.      
           05  WS-DATE-EXPIRE            PIC X(10)   VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP      PIC X(26)   VALUE SPACES.      
           05  WS-PHYSICIAN-ID           PIC S9(9)   USAGE COMP VALUE 0.
           05  WS-LAST-UPDATE-USERID     PIC X(07)   VALUE SPACES.      
           05  WS-FIRST-NOTICE-DATE      PIC X(10)   VALUE SPACES.      
           05  WS-SECOND-NOTICE-DATE     PIC X(10)   VALUE SPACES.      
           05  WS-IVR-DATE               PIC X(10)   VALUE SPACES.      
           05  WS-DNP-DATE               PIC X(10)   VALUE SPACES.      
           05  WS-USER-ID                PIC X(07)   VALUE SPACES.      
           05  WS-MED-INFO-EXISTS        PIC X(01)   VALUE SPACES.      
           05  WS-ACCOUNT-TABLE-SET      PIC X(01)   VALUE SPACES.      
           05  WS-ACCOUNT-NO-EXISTS      PIC X(01)   VALUE SPACES.      
           05  WS-SELECT-MED-INFO        PIC X(01)   VALUE SPACES.      
           05  WS-SELECT-CRED-COLL       PIC X(01)   VALUE SPACES.      
           05  WS-DNP-SCHEDULED          PIC X(01)   VALUE 'N'.         
           05  WS-DATE-ALERT-OLD         PIC X(10)   VALUE SPACES.      
           05  WS-DATE-EXPIRE-OLD        PIC X(10)   VALUE SPACES.      
           05  WS-PATIENT-NAME-ID-OLD    PIC S9(13)V USAGE COMP-3       
                                                     VALUE 0.           
           05  WS-PHYSICIAN-ID-OLD       PIC S9(9)   USAGE COMP VALUE 0.
           05  WS-PATIENT-FIRST-NAME     PIC X(15)   VALUE SPACES.      
           05  WS-PATIENT-MIDDLE-NAME    PIC X(15)   VALUE SPACES.      
           05  WS-PATIENT-LAST-NAME      PIC X(40)   VALUE SPACES.      
           05  WS-PATIENT-TITLE-PREFIX   PIC X(09)   VALUE SPACES.      
           05  WS-PATIENT-TITLE-SUFFIX-1 PIC X(03)   VALUE SPACES.      
           05  WS-FIRST-NAME-OLD         PIC X(15)   VALUE SPACES.      
           05  WS-MIDDLE-NAME-OLD        PIC X(15)   VALUE SPACES.      
           05  WS-LAST-NAME-OLD          PIC X(40)   VALUE SPACES.      
           05  WS-TITLE-PREFIX-OLD       PIC X(09)   VALUE SPACES.      
           05  WS-TITLE-SUFFIX-1-OLD     PIC X(03)   VALUE SPACES.      
           05  WS-CUST-ALERT-SEQ-OLD     PIC X(26)   VALUE SPACES.      
           05  WS-UPDATE-PROFILE         PIC X(01)   VALUE SPACES.      
           05  WS-SO-SELECT-UPDATE       PIC X(01)   VALUE SPACES.      
           05  WS-RETURN-FLAG            PIC X(01)   VALUE SPACES.      
           05  WS-COMMENTS               PIC X(250)  VALUE SPACES.      
           05  WS-PREMISE-NO-C           PIC X(10).                     
           05  WS-PREMISE-NO-I REDEFINES WS-PREMISE-NO-C                
                                         PIC 9(10).                     
COB305     05 WS-PREMISE-NO-D        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05  WS-SERV-ORDER-NO-C        PIC X(13).                     
           05  WS-SERV-ORDER-NO-I REDEFINES WS-SERV-ORDER-NO-C          
                                         PIC 9(13).                     
COB305     05 WS-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-WQ-PRIORITY            PIC X(01)   VALUE SPACES.      
           05  WS-WQ-ITEM-ID             PIC S9(10)V COMP-3 VALUE +0.   
           05  WS-WQ-ROUTING-CATGRY      PIC X(01)   VALUE SPACES.      
           05  WS-WQ-LOCAL-OFFICE        PIC X(03)   VALUE SPACES.      
           05  WS-WQ-USER-ID-ORIG        PIC X(07)   VALUE SPACES.      
           05  WS-WQ-USER-ID-ASGN        PIC X(07)   VALUE SPACES.      
           05  WS-WQ-RESP-AREA-ID        PIC X(03)   VALUE SPACES.      
           05  WS-WQ-CATEGORY-ID         PIC S9(4)  USAGE COMP VALUE +0.
           05  WS-WQ-ACCOUNT-NO          PIC S9(13)V USAGE COMP-3       
                                                     VALUE +0.          
           05  WS-WQ-PREMISE-NO          PIC S9(10)V USAGE COMP-3       
                                                     VALUE +0.          
           05  WS-WQ-CUSTOMER-NO         PIC S9(10)V USAGE COMP-3       
                                                     VALUE +0.          
           05  WS-WQ-SERV-ORDER-NO       PIC S9(13)V USAGE COMP-3       
                                                     VALUE +0.          
           05  WS-WQ-FREE-FORM-AREA.                                    
               49 WS-WQ-FREE-FORM-LEN    PIC S9(4)   COMP SYNC VALUE +0.
               49 WS-WQ-FREE-FORM-TEXT   PIC X(255)   VALUE SPACES.     
           05  WS-WQ-COMMENT.                                           
               49 WS-WQ-COMMENTS-LEN     PIC S9(4)   COMP SYNC VALUE +0.
               49 WS-WQ-COMMENTS-TEXT    PIC X(250)   VALUE SPACES.     
           05  WS-REMARKS-TX.                                           
               49 WS-REMARKS-TX-LEN      PIC S9(4)  USAGE COMP VALUE +0.
               49 WS-REMARKS-TX-TEXT     PIC X(210)  VALUE SPACES.      
           05  WS-CURR-TIMESTAMP         PIC X(26)   VALUE SPACES.      
           05  WS-WQ-DATE-REQUIRED       PIC X(26)   VALUE SPACES.      
           05  WS-WQ-DATE-CREATED        PIC X(26)   VALUE SPACES.      
ACT233     05  WS-WQ-CREATED-BY          PIC X(16)   VALUE SPACES.      
           05  RS-RETURN-CODE            PIC S9(9)   COMP VALUE 0.      
           05  WS-TRAN-APPL-NO           PIC S9(04)  COMP VALUE ZERO.   
           05  WS-DATE-BILL-00-NULL      PIC S9(04)  COMP VALUE +0.     
           05  WS-DATE-BILL-30-NULL      PIC S9(04)  COMP VALUE +0.     
           05  WS-DATE-BILL-60-NULL      PIC S9(04)  COMP VALUE +0.     
           05  WS-DATE-BILL-90-NULL      PIC S9(04)  COMP VALUE +0.     
           05  WS-LOCAL-OFFICE-NULL      PIC S9(04)  COMP VALUE +0.     
           05  WS-WORK-AREA-NULL         PIC S9(04)  COMP VALUE +0.     
           05  WS-CREW-ID-NULL           PIC S9(04)  COMP VALUE +0.     
P0726B     05  WS-PTNT-NAME-ID-NULL      PIC S9(04)  COMP VALUE +0.     
P0726B     05  WS-PHYSICIAN-ID-NULL      PIC S9(04)  COMP VALUE +0.     
           05  WS-NULL-IND1              PIC S9(04)  COMP.              
           05  WS-NULL-IND2              PIC S9(04)  COMP.              
           05  WS-NULL-IND3              PIC S9(04)  COMP.              
           05  WS-NULL-IND4              PIC S9(04)  COMP.              
           05  WS-NULL-IND5              PIC S9(04)  COMP.              
           05  WS-NULL-IND6              PIC S9(04)  COMP.              
           05  WS-NULL-IND7              PIC S9(04)  COMP.              
           05  WS-NULL-IND8              PIC S9(04)  COMP.              
           05  WS-NULL-IND9              PIC S9(04)  COMP.              
           05  WS-NULL-IND10             PIC S9(04)  COMP.              
           05  WS-NULL-IND11             PIC S9(04)  COMP.              
           05  WS-NULL-IND12             PIC S9(04)  COMP.              
           05  WS-NULL-IND13             PIC S9(04)  COMP.              
           05  WS-NEW-EXPIRED-CERT-MSG.                                 
               10 WS-MSG-SECTION-1       PIC X(46)   VALUE              
                   'NEW MEDICAL CERTIFICATE ENTERED - OLD MEDICAL '.    
               10 WS-MSG-SECTION-2       PIC X(23)   VALUE              
                   'CERTIFICATE WAS EXPIRED'.                           
           05  WS-NEW-CERT-MSG           PIC X(31)   VALUE              
               'NEW MEDICAL CERTIFICATE ENTERED'.                       
           05  WS-EXPIRE-CERT-MSG        PIC X(32)   VALUE              
               'EXPIRING OLD MEDICAL CERTIFICATE'.                      
           05  WS-UPDATE-CERT-MSG        PIC X(36)   VALUE              
               'UPDATING CURRENT MEDICAL CERTIFICATE'.                  
           05  WS-EXPIRED-CERT-MSG-PSNC.                                
               10 WS-MSG-SECTION-3       PIC X(29)   VALUE              
                   'NEW MORATORIUM ENTERED - OLD '.                     
               10 WS-MSG-SECTION-4       PIC X(22)   VALUE              
                   'MORATORIUM WAS EXPIRED'.                            
           05  WS-CERT-MSG-PSNC      PIC X(22)   VALUE                  
               'NEW MORATORIUM ENTERED'.                                
           05  WS-UPDATE-CERT-MSG-PSNC   PIC X(27)   VALUE              
               'UPDATING CURRENT MORATORIUM'.                           
           05  WS-CUST-ALERT-SEQ-NO      PIC X(26).                     
           05  WS-BUSINESS-DAY-SW        PIC X(01)   VALUE 'N'.         
               88  PREV-BUSINESS-DAY-NOT-FOUND       VALUE 'N'.         
               88  PREV-BUSINESS-DAY-FOUND           VALUE 'Y'.         
           05  WS-ROW-EXISTS             PIC X(01)   VALUE 'N'.         
               88  ROW-DOES-NOT-EXIST                VALUE 'N'.         
               88  ROW-EXISTS                        VALUE 'Y'.         
      *    CSR02122 RETURN AREA                                                 
           05  WS-CSR02122-RET-AREA.                                    
               10  WS-2122-RETURN-CODE   PIC S9(04)  COMP VALUE 0.      
      *    CSR00423 RETURN AREA                                                 
           05  WS-CSR00423-RET-AREA.                                    
               10 WS-CSR00423-RETURN-CD  PIC S9(04)  COMP VALUE 0.      
               10 WS-LOCAL-OFFICE        PIC X(03)   VALUE SPACES.      
               10 WS-WORK-AREA           PIC X(40)   VALUE SPACES.      
               10 WS-CREW-ID             PIC X(06)   VALUE SPACES.      
ACT233*    CSR04675 RETURN AREA                                                 
ACT233     05  WS-CSR04675-RET-AREA.                                    
ACT233         10  WS-CSR04675-RETURN-CD PIC S9(04)  COMP VALUE 0.      
      *    CSR00125 RETURN AREA                                                 
           05  WS-CSR00125-RET-AREA.                                    
               10 WS-SO-RETURN-CD-BD     PIC S9(04)  COMP VALUE 0.      
               10 WS-SERV-ORDER-CHAR-BD  PIC X(13)   VALUE SPACES.      
               10 WS-ORDER-REASON-BD     PIC X(01)   VALUE SPACES.      
               10 WS-RESP-AREA-ID-BD     PIC X(03)   VALUE SPACES.      
               10 WS-PENDING-DNP-FLAG-BD PIC X(01)   VALUE SPACES.      
               10 WS-INSERT-WORK-QUEUE-BD    PIC X(01) VALUE SPACES.    
               10 WS-AMOUNT-DISC-BAL     PIC X(12)   VALUE SPACES.      
               10 WS-ORDER-TYPE-CD-BD    PIC X(05)   VALUE SPACES.      
      *    CSR01556 RETURN AREA                                                 
           05  WS-CSR01556-RET-AREA.                                    
               10 WS-CSR01556-RETURN-CD  PIC S9(04)  COMP VALUE 0.      
               10 WS-SERV-ORDER-CHAR-PD  PIC X(13)   VALUE SPACES.      
               10 WS-ORDER-REASON-PD     PIC X(01)   VALUE SPACES.      
               10 WS-RESP-AREA-ID-PD     PIC X(03)   VALUE SPACES.      
               10 WS-PENDING-DNP-FLAG-PD PIC X(01)   VALUE SPACES.      
               10 WS-INSERT-WORK-QUEUE-PD    PIC X(01) VALUE SPACES.    
               10 WS-AMOUNT-DISC-BAL-PD  PIC X(12)   VALUE SPACES.      
               10 WS-ORDER-TYPE-CD-PD    PIC X(05)   VALUE SPACES.      
           05  WS-HOLD-EXP-DATE          PIC X(10)   VALUE SPACES.      
           05  WS-DATE-CALC              PIC X(10).                     
           05  WS-HOLD-DAY-NO            PIC S9(04)  COMP VALUE +0.     
           05  WS-DATE-CTR               PIC S9(04)  COMP VALUE +1.     
           05  WS-CTR-DAY-NO             PIC S9(04)  COMP VALUE +0.     
           05  WS-CURRENT-DATE           PIC X(10)   VALUE SPACES.      
           05  WS-CURRENT-DATE-MINUS-12MOS PIC X(10) VALUE SPACES.      
           05  WS-DATE-NOTICE-DUE        PIC X(10)   VALUE SPACES.      
           05  WS-REV-MTH-LST-NRML       PIC 9(06).                     
           05  FILLER REDEFINES WS-REV-MTH-LST-NRML.                    
               10 WS-REV-YR              PIC 9(04).                     
               10 WS-REV-MTH             PIC 9(02).                     
           05  WS-NULL-IND-CPD           PIC S9(04)  COMP.              
COB305     05 WS-DAY-AGL-DNP        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.   
COB305     05 WS-DAY-SECOND-MAIL        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-AMT-NONUTIL-WQ-MIN     PIC S9(5)V99.                  
           05  WS-READ-DATE              PIC X(10)   VALUE SPACES.      
           05  WS-HOLD-DATE-2            PIC X(10)   VALUE SPACES.      
           05  WS-HOLD-NEXT-BILL-DATE    PIC X(10)   VALUE SPACES.      
           05  WS-ADJ-DAY                PIC S9(9)   COMP.              
           05  WS-NUMBER-OF-DAYS         PIC S9(9)   COMP.              
           05  WS-NUMBER-OF-DAYS-LIM     PIC S9(9)   COMP.              
           05  WS-EIBRESP                PIC S9(8)                      
                                         COMP SYNC VALUE ZERO.          
           05  MULTIPLE-ROWS             PIC S9(9)   VALUE -811 COMP.   
           05  WS-WQ-CREATE-DATE         PIC X(10)   VALUE SPACES.      
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                 PIC X(26)                      
                                         VALUE 'SESSION.CSR04851_R1'.   
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN           PIC S9(04)  COMP.              
                49 GTT-ROW-CHAR          PIC X(1024).                   
            05  GTT-SQLCODE              PIC S9(9)   COMP.              
       01  FILLER                        PIC X(11)                      
                                         VALUE 'PARM FIELDS'.           
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
           05  SNA-CONNECTION-NAME       PIC X(8)    VALUE SPACES.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.      
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9)   COMP.              
           05  WRKLEN1                   PIC S9(9)   COMP.              
           05  WRKLEN2                   PIC S9(9)   COMP.              
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                PIC X(18)   VALUE SPACES.      
            10  S-SQLCODE                PIC S9(9)   COMP VALUE 0.      
            10  S-SQLSTATE               PIC X(5)    VALUE ' '.         
            10  S-TABLE-NAME             PIC X(18)   VALUE SPACES.      
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L   PIC S9(4)   USAGE COMP.        
                49  S-HOST-VARIABLES-V   PIC X(255).                    
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L    PIC S9(4)   USAGE COMP.        
                49  S-SQL-STATEMENT-V    PIC X(255).                    
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L  PIC S9(4)   USAGE COMP.        
                49  S-SQL-DESCRIPTION-V  PIC X(255).
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_DNP CURSOR
MSQ001          FOR CALL CSR00125                                       
                       ( :PARM-ACCOUNT-NO
                  , :WS-PREMISE-NO-C
                  , :WS-USER-ID
                  , :WS-REMARKS-TX
                  , 'Y'
                  , :WS-SO-SELECT-UPDATE
                  , '269'
                  , 'A'
                  , 'R'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR00423                                            
                    ( :WS-SERV-ORDER-NO-D
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR04675                                            
                    ( :WS-WQ-ITEM-ID
                  , :WS-WQ-ROUTING-CATGRY
                  , :WS-WQ-LOCAL-OFFICE
                  , :WS-WQ-USER-ID-ORIG
                  , :WS-WQ-USER-ID-ASGN
                  , :WS-WQ-RESP-AREA-ID
                  , :WS-WQ-CATEGORY-ID
                  , :WS-WQ-ACCOUNT-NO
                  , :WS-WQ-PREMISE-NO
                  , :WS-WQ-CUSTOMER-NO
                  , :WS-WQ-SERV-ORDER-NO
                  , :WS-WQ-COMMENT
                  , :WS-WQ-DATE-REQUIRED
                  , :WS-WQ-DATE-CREATED
                  , :WS-WQ-PRIORITY
                  , :WS-WQ-FREE-FORM-AREA
                  , :WS-WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR02122                                       
                        ( :PARM-ACCOUNT-NO
                  , :WS-PREMISE-NO-C
                  , :WS-ORDER-REASON-BD
                  , 'R'
                  , :WS-PENDING-DNP-FLAG-BD
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BAL
                  , '269'
                  , :WS-ORDER-TYPE-CD-BD
                  , :WS-REMARKS-TX
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE PENDING_NOTICE CURSOR
MSQ001          FOR CALL CSR01556                                       
                       ( :PARM-ACCOUNT-NO
                  , :WS-PREMISE-NO-C
                  , :WS-USER-ID
                  , :WS-REMARKS-TX
                  , 'Y'
                  , :WS-SO-SELECT-UPDATE
                  , '269'
                  , 'A'
                  , ' '
                  )
MSQ001        END-EXEC.
                    
                                                                        
HPCCDM*EJECT                                                            03020000
       LINKAGE SECTION.                                                 
       01  PARM-FILE-DELETE-FLAG       PIC X(01).                       
       01  PARM-ACCOUNT-NO             PIC X(13).                       
       01  PARM-DATE-ALERT             PIC X(10).                       
       01  PARM-DATE-EXPIRE            PIC X(10).                       
       01  PARM-PATIENT-TITLE-PREFIX   PIC X(09).                       
       01  PARM-PATIENT-FIRST-NAME     PIC X(15).                       
       01  PARM-PATIENT-MIDDLE-NAME    PIC X(15).                       
       01  PARM-PATIENT-LAST-NAME      PIC X(40).                       
       01  PARM-PATIENT-TITLE-SUFFIX-1 PIC X(03).                       
       01  PARM-PHYSICIAN-ID           PIC S9(9) USAGE COMP.            
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-FIRST-NOTICE-DATE      PIC X(10).                       
       01  PARM-SECOND-NOTICE-DATE     PIC X(10).                       
       01  PARM-DNP-DATE               PIC X(10).                       
       01  PARM-TRANS-CMNT-TEXT        PIC X(210).                      
       01  PARM-TRANS-CMNT-LEN         PIC S9(04) COMP.                 
       01  PARM-IVR-DATE               PIC X(10).                       
       PROCEDURE DIVISION USING PARM-FILE-DELETE-FLAG                   
                                PARM-ACCOUNT-NO                         
                                PARM-DATE-ALERT                         
                                PARM-DATE-EXPIRE                        
                                PARM-PATIENT-TITLE-PREFIX               
                                PARM-PATIENT-FIRST-NAME                 
                                PARM-PATIENT-MIDDLE-NAME                
                                PARM-PATIENT-LAST-NAME                  
                                PARM-PATIENT-TITLE-SUFFIX-1             
                                PARM-PHYSICIAN-ID                       
                                PARM-USER-ID                            
                                PARM-FIRST-NOTICE-DATE                  
                                PARM-SECOND-NOTICE-DATE                 
                                PARM-DNP-DATE                           
                                PARM-TRANS-CMNT-TEXT                    
                                PARM-TRANS-CMNT-LEN                     
                                PARM-IVR-DATE.                          
                                                                        
      ******************************************************************03050000
      * 0000-MAINLINE                                                  *03060000
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *03120000
      ******************************************************************03130000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03250000
      * 0100-INITIALIZE                                                *03260000
      ******************************************************************03370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE      AS  RETURN_CODE                  
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE      AS  RETURN_CODE                          
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03250000
      * 0400-GET-CURRENT-DT                                            *03260000
      ******************************************************************03370000
                                                                        
       0400-GET-CURRENT-DT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURR-TIMESTAMP               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*           ,:WS-CURR-TIMESTAMP = CURRENT TIMESTAMP                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '**    INSERT ERROR IN 4000-WRITE-WQ    **'       
              DISPLAY '**    PARAGRAPH 0400 ABENDED           **'       
              DISPLAY '**     ACCOUNT NO = ' AT-ACCOUNT-NO              
              DISPLAY '**       RETURN CODE = ' SQLCODE                 
              DISPLAY '**       PROCESSING TERMINATED         **'       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03660000
      * 1000-PROCESS-INPUT                                             *03670000
      ******************************************************************03730000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE  PARM-ACCOUNT-NO          TO  WS-ACCOUNT-NUM.           
           MOVE  WS-ACCOUNT-DEC           TO  WS-ACCOUNT-NO.            
           MOVE  WS-ACCOUNT-NO            TO  CA-ACCOUNT-NO             
                                              CL-ACCOUNT-NO             
                                              AT-ACCOUNT-NO.            
           MOVE  PARM-DATE-ALERT          TO  WS-DATE-ALERT.            
           MOVE  PARM-DATE-EXPIRE         TO  WS-DATE-EXPIRE.           
           MOVE  PARM-FIRST-NOTICE-DATE   TO  WS-FIRST-NOTICE-DATE.     
           MOVE  PARM-SECOND-NOTICE-DATE  TO  WS-SECOND-NOTICE-DATE.    
           MOVE  PARM-IVR-DATE            TO  WS-IVR-DATE.              
           MOVE  PARM-DNP-DATE            TO  WS-DNP-DATE.              
           MOVE  PARM-USER-ID             TO  WS-USER-ID                
                                              PF-USER-ID.               
           MOVE  PARM-PATIENT-FIRST-NAME  TO  WS-PATIENT-FIRST-NAME     
                                              WS-KR362-FIRST-NAME.      
           MOVE  PARM-PATIENT-MIDDLE-NAME TO  WS-PATIENT-MIDDLE-NAME    
                                              WS-KR362-MIDDLE-NAME.     
           MOVE  PARM-PATIENT-LAST-NAME   TO  WS-PATIENT-LAST-NAME      
                                              WS-KR362-LAST-NAME.       
           MOVE  PARM-PATIENT-TITLE-PREFIX                              
                                          TO  WS-PATIENT-TITLE-PREFIX   
                                              WS-KR362-TITLE-PREFIX.    
           MOVE  PARM-PATIENT-TITLE-SUFFIX-1                            
                                          TO  WS-PATIENT-TITLE-SUFFIX-1 
                                              WS-KR362-TITLE-SUFFIX-1.  
           MOVE  PARM-PHYSICIAN-ID        TO  WS-PHYSICIAN-ID           
                                              PY-PHYSICIAN-ID.          
           MOVE  'CN'                     TO  WS-KR362-NAME-TYPE.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08230000
      * 2000-PROCESS-OUTPUT.                                           *08240000
      ******************************************************************08340000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
           ADD +1                       TO   CTR-ROWS.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08830000
      * 5000-UPDATE                                                    *08840000
      * READS THE FLAG SENT FROM THE CLIENT AND DETERMINES WHETHER TO  *08900000
      * UPDATE/INSERT OR TO DELETE THE MEDICAL INFO.                   *08910000
      ******************************************************************08920000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           PERFORM 0400-GET-CURRENT-DT          THRU 0400-EXIT.         
           PERFORM 7010-SELECT-FROM-ACCOUNT     THRU 7010-EXIT.         
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
           MOVE AT-COMPANY-NO                TO WS-COMPANY-NO.          
                                                                        
           MOVE 'DATABASE'                   TO C8-DELINQ-CD            
           PERFORM 7350-GET-DEL-VALUES          THRU 7350-EXIT          
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE             
                                                                        
           PERFORM 5400-JRNL-TRAN-HEAD          THRU 5400-EXIT.         
           PERFORM 7100-MED-INFO-EXISTS         THRU 7100-EXIT          
           PERFORM 5050-GET-UTIL-NONUTIL-BAL    THRU 5050-EXIT.         
                                                                        
           IF PARM-FILE-DELETE-FLAG = 'D'                               
                IF SEB-DATABASE                                         
                   PERFORM 7960-SEL-CUST-ALERT-SEQ-NO THRU 7960-EXIT    
                END-IF                                                  
                PERFORM 5010-DELETE-MED-INFO THRU 5010-EXIT             
                MOVE PARM-TRANS-CMNT-LEN     TO MH-TRAN-COMMENT-LEN     
                MOVE PARM-TRANS-CMNT-TEXT    TO MH-TRAN-COMMENT-TEXT    
                PERFORM 5505-JRNL-DATE-ALERT    THRU 5505-EXIT          
                PERFORM 5510-JRNL-DATE-EXPIRE   THRU 5510-EXIT          
           ELSE                                                         
                IF (CSR-DATABASE AND PSNC)                              
                   MOVE 22 TO MH-TRAN-COMMENT-LEN                       
                   MOVE WS-CERT-MSG-PSNC         TO MH-TRAN-COMMENT-TEXT
                ELSE                                                    
                   MOVE 31 TO MH-TRAN-COMMENT-LEN                       
                   MOVE WS-NEW-CERT-MSG          TO MH-TRAN-COMMENT-TEXT
                END-IF                                                  
                PERFORM 5200-INSERT-UPDATE-MED-INFO THRU 5200-EXIT      
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09140000
      * 5010-DELETE-MED-INFO.                                          *09150000
      * DELETES MEDICAL INFORMATION                                    *09250000
      ******************************************************************09260000
                                                                        
       5010-DELETE-MED-INFO.                                            
                                                                        
            PERFORM 8410-DELETE-CUST-ALERT       THRU 8410-EXIT.        
            PERFORM 8420-DELETE-EXCPTN-CRED-COLL THRU 8420-EXIT.        
                                                                        
            MOVE SPACES TO WS-CODE-MEDICAL.                             
                                                                        
            MOVE WS-CODES-DATA-PRESENT        TO AT-CODES-DATA-PRESENT. 
            MOVE SPACES                       TO AT-CODE-TEMP-BILL.     
            PERFORM 8300-UPDATE-ACCOUNT       THRU 8300-EXIT.           
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5050-GET-UTIL-NONUTIL-BAL                                      *        
      ******************************************************************        
                                                                        
       5050-GET-UTIL-NONUTIL-BAL.                                       
                                                                        
      ******************************************************************16630000
      * CALLING CPD00068 TO GET WS-TOTAL-BALANCE-UTL                   *16640000
      *                         WS-TOTAL-BALANCE-NONUTIL               *        
      *                         WS-AMT-ARREARS-NONUTL                  *        
      ******************************************************************16650000
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
           MOVE WS-CURRENT-DATE         TO WS-HOLD-DATE-2.              
           MOVE 'Y'                     TO CALC-ARREARS-SW              
                                           CALC-BALANCE-SW              
                                           CALC-BAL-ONLY-SW.            
           MOVE SPACES                     TO ABEND-FUNCTION .          
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
           PERFORM 6000-CALL-CPD00068      THRU 6000-EXIT.              
           MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE,    
                                              SQLCODE.                  
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5100-NAME-PROCESS                                                       
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CPDKR362                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************09390000
      * 5200-INSERT-UPDATE-MED-INFO.                                   *09400000
      * INSERT/UPDATE MEDICAL INFORMATION                              *09640000
      ******************************************************************09650000
                                                                        
       5200-INSERT-UPDATE-MED-INFO.                                     
                                                                        
            PERFORM 5310-MOVE-TO-CUST-ALERT-VARS THRU 5310-EXIT.        
            PERFORM 7300-GET-DEL-VALUES          THRU 7300-EXIT.        
            MOVE MH-TRANS-HIST-SEQ-NO TO CA-CUST-ALERT-SEQ-NO           
                                                                        
      * NEW PATIENT NAME DETAILS HAS BEEN CREATED                               
            INITIALIZE DCLCSS-NAME.                                     
            MOVE 'I'                  TO WS-KR362-UPDATE-FLAG           
                                         WS-KR362-NAME-FORMAT.          
            IF WS-PATIENT-NAME-ID-OLD > 0                               
               MOVE WS-PATIENT-NAME-ID-OLD       TO DQ-NAME-ID          
               PERFORM 7140-GET-PHY-PTNT-NAME    THRU 7140-EXIT         
               IF DQ-LAST-NAME  = PARM-PATIENT-LAST-NAME AND            
                  DQ-FIRST-NAME = PARM-PATIENT-FIRST-NAME               
                  MOVE DQ-FIRST-NAME             TO WS-FIRST-NAME-OLD   
                  MOVE DQ-MIDDLE-NAME            TO WS-MIDDLE-NAME-OLD  
                  MOVE DQ-LAST-NAME              TO WS-LAST-NAME-OLD    
                  MOVE DQ-TITLE-PREFIX           TO WS-TITLE-PREFIX-OLD 
                  MOVE DQ-TITLE-SUFFIX-1 TO WS-TITLE-SUFFIX-1-OLD       
                  MOVE 'U'                       TO WS-KR362-UPDATE-FLAG
                  MOVE WS-PATIENT-NAME-ID-OLD    TO WS-KR362-NAME-ID    
                                                                        
               END-IF                                                   
            END-IF.                                                     
                                                                        
            PERFORM 5100-NAME-PROCESS           THRU 5100-KR362-EXIT.   
                                                                        
            IF WS-KR362-UPDATE-FLAG = 'I'                               
               MOVE WS-91-NEW-NAME-ID            TO CA-PATIENT-NAME-ID  
            ELSE                                                        
               MOVE WS-PATIENT-NAME-ID-OLD       TO CA-PATIENT-NAME-ID  
            END-IF.                                                     
                                                                        
      * UPDATE EXISTING MEDICAL CERTIFICATE                             09750000
            IF WS-MED-INFO-EXISTS = 'Y'                                 
               IF (CSR-DATABASE AND PSNC)                               
                  MOVE 27 TO MH-TRAN-COMMENT-LEN                        
                  MOVE WS-UPDATE-CERT-MSG-PSNC   TO MH-TRAN-COMMENT-TEXT
               ELSE                                                     
                  MOVE 36 TO MH-TRAN-COMMENT-LEN                        
                  MOVE WS-UPDATE-CERT-MSG        TO MH-TRAN-COMMENT-TEXT
               END-IF                                                   
               PERFORM 8101-UPDATE-CUST-ALERT    THRU 8101-EXIT         
               PERFORM 5500-JRNL-UPDATE          THRU 5500-EXIT         
            ELSE                                                        
      * EXPIRE THE OLD MEDICAL CERTIFICATE                              09810000
      *        ********************************************************         
      *        * DETERMINE IF ACCOUNT IS SCEG OR SEB.  IF ACCOUNT IS            
      *        * SEB THEN CHECK IF ACCOUNT HAS 2 MED CERTS.                     
      *        ********************************************************         
               MOVE 'DATABASE' TO C8-DELINQ-CD                          
               PERFORM 7350-GET-DEL-VALUES THRU 7350-EXIT               
               MOVE C8-DELINQ-VALUE TO WS-DATABASE                      
               IF SEB-DATABASE                                          
                  PERFORM 7200-LIMIT-2-MED-CERTS THRU 7200-EXIT         
               END-IF                                                   
      *        ********************************************************         
      *        * IF 2 MED CERTS ALREADY EXIST FOR SEB IN LAST 12 MONTHS         
      *        * THEN CONTINUE AND DO NOT EXPIRE ACTIVE MED CERT.               
      *        ********************************************************         
               IF S-RETURN-CODE NOT = 500                               
                  IF WS-CODE-MEDICAL = 'A'                              
                     IF (CSR-DATABASE AND PSNC)                         
                        MOVE 51 TO MH-TRAN-COMMENT-LEN                  
                        MOVE WS-EXPIRED-CERT-MSG-PSNC                   
                                                 TO MH-TRAN-COMMENT-TEXT
                     ELSE                                               
                        MOVE 69 TO MH-TRAN-COMMENT-LEN                  
                        MOVE WS-NEW-EXPIRED-CERT-MSG                    
                                                 TO MH-TRAN-COMMENT-TEXT
                     END-IF                                             
                     PERFORM 7500-GET-OLD-MED-CERT  THRU 7500-EXIT      
                     MOVE WS-DATE-ALERT TO WS-DATE-CALC                 
                     MOVE SPACES TO WS-HOLD-EXP-DATE                    
                     SET PREV-BUSINESS-DAY-NOT-FOUND TO TRUE            
                     MOVE +1 TO WS-HOLD-DAY-NO                          
                     PERFORM 7510-GET-1DAY-PRIOR-DATE                   
                          UNTIL PREV-BUSINESS-DAY-FOUND                 
                     PERFORM 8102-EXPIRE-CUST-ALERT THRU 8102-EXIT      
                  END-IF                                                
               END-IF                                                   
                                                                        
      * SET-UP A NEW CERTIFICATE                                        09870000
      *        *********************************************************        
      *        * IF UTILITY BALANCE IS NOT GREATER THAN 0 MOVE 600 TO  *        
P0726A*        * S-RETURN-CODE. FOR CSR, ALLOW MEDECAL CERTIFICATE     *        
P0726A*        * TO BE ENTERED ON $0.00 BALANCE.                       *        
      *        *********************************************************        
P0726A         IF SEB-DATABASE                                          
                  IF WS-TOTAL-BALANCE-UTL      > 0                      
                     CONTINUE                                           
                  ELSE                                                  
                     MOVE 600 TO S-RETURN-CODE                          
                     GO TO 5200-EXIT                                    
                  END-IF                                                
P0726A         END-IF                                                   
      *        ********************************************************         
      *        * IF 2 MED CERTS ALREADY EXIST FOR SEB IN LAST 12 MONTHS         
      *        * THEN CONTINUE AND DO NOT ALLOW NEW MED CERT TO BE              
      *        * ENTERED.                                                       
      *        ********************************************************         
               IF S-RETURN-CODE NOT = 500                               
                  PERFORM 8420-DELETE-EXCPTN-CRED-COLL  THRU 8420-EXIT  
                  PERFORM 8430-DELETE-NORM-CRED-ACTION  THRU 8430-EXIT  
                  PERFORM 8440-DELETE-RETURN-CK-DEPOSIT THRU 8440-EXIT  
                  PERFORM 8500-INSERT-CUST-ALERT        THRU 8500-EXIT  
                  PERFORM 5500-JRNL-UPDATE              THRU 5500-EXIT  
                                                                        
      *           ******************************************************        
      *           * MED CERT WILL FORECAST EXCEPTIONAL CREDIT ROWS WITH         
      *           * DATES BASED OFF THE OPTIMUM READ DATE (NORMAL DATES)        
      *           * FOR SEB. LOGIC TO RETRIEVE THE NEXT READ DATE WAS           
      *           * COPIED FROM CPD00310 AND LOGIC TO RETRIEVE THE NEXT         
      *           * BILL DATE WAS COPIED FROM CPD00309.  (SCEG WILL             
      *           * FORECAST EXCEPTIONAL ROWS BASED ON THE MED CERT             
      *           * EXPIRE DATE).                                               
      *           * SEB REGULATED, BALANCE CUSTOMERS, WILL USE DATES ON         
      *           * NEW TABLE CSS_CRED_FORECAST TO FORECAST DATES.              
      *           ******************************************************        
                  IF PSNC                                               
      *              * RETRIEVE VALUES FROM DELINQUENCY TABLE                   
                     MOVE MH-DATE-TRANS TO WS-READ-DATE                 
      *              * CALCULATE NEXT BILL DATE                                 
                     PERFORM 5900-NEXT-BILL-DATE                        
                        THRU 5900-NEXT-BILL-DATE-EXIT                   
                     MOVE BN-DATE-EXTRACT TO WS-HOLD-NEXT-BILL-DATE     
                                                                        
      *              * CALCULATE NEXT READ DATE                                 
                     PERFORM 5901-NEXT-READ-DATE                        
                        THRU 5901-NEXT-READ-DATE-EXIT                   
                                                                        
      *              * CALCULATE FIRST NOTICE MAIL DATE (BILL DATE + 1)         
                     IF BN-DATE-EXTRACT > SPACES                        
                        MOVE BN-DATE-EXTRACT TO WS-HOLD-DATE-2          
                        MOVE 0 TO WS-ADJ-DAY                            
                        MOVE +100 TO WS-ACTIVE-RETURN-CODE              
                        PERFORM 7030-GET-NEXT-WORK-DAY THRU 7030-EXIT   
                           UNTIL WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL
                        MOVE WS-WORK-DATE TO WS-FIRST-NOTICE-DATE       
                     ELSE                                               
                        MOVE SPACES TO WS-FIRST-NOTICE-DATE             
                     END-IF                                             
                  END-IF                                                
                                                                        
                  IF SEB-DATABASE                                       
                     MOVE AT-ACCOUNT-NO             TO LR-ACCOUNT-NO    
                     MOVE 'N'                       TO WS-SEB-REG-FLAG  
                     PERFORM 7160-CHECK-REGULATED THRU 7160-EXIT        
                     MOVE MH-DATE-TRANS TO WS-READ-DATE                 
                     MOVE SPACES TO WS-DNP-DATE                         
      *              * CALCULATE NEXT BILL DATE                                 
                     PERFORM 5900-NEXT-BILL-DATE                        
                        THRU 5900-NEXT-BILL-DATE-EXIT                   
                     MOVE BN-DATE-EXTRACT TO WS-HOLD-NEXT-BILL-DATE     
      *              * CALCULATE NEXT READ DATE                                 
                     PERFORM 5901-NEXT-READ-DATE                        
                        THRU 5901-NEXT-READ-DATE-EXIT                   
      *              * CALC FIRST NOTICE MAIL DATE (BILL DATE + 1)              
                     IF BN-DATE-EXTRACT > SPACES                        
                        MOVE BN-DATE-EXTRACT TO WS-HOLD-DATE-2          
                        MOVE 0 TO WS-ADJ-DAY                            
                        MOVE +100 TO WS-ACTIVE-RETURN-CODE              
                        PERFORM 7030-GET-NEXT-WORK-DAY THRU 7030-EXIT   
                           UNTIL WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL
                           MOVE WS-WORK-DATE TO WS-FIRST-NOTICE-DATE    
                     ELSE                                               
                        MOVE SPACES TO WS-FIRST-NOTICE-DATE             
                     END-IF                                             
      *              * CALCULATE DNP DATE AND 2ND NOTICE DATES                  
                     IF (WS-SEB-REGULATED OR WS-SEB-DEREGULATED)        
                                         AND AT-CREDIT-GROUP = 'B'      
                        PERFORM 5210-SEB-BALANCE THRU 5210-EXIT         
                     ELSE                                               
                        PERFORM 7253-CALCULATE-DATES THRU 7253-EXIT     
                        PERFORM UNTIL WS-DNP-DATE >= BN-DATE-EXTRACT    
                                AND   WS-DNP-DATE >  WS-DATE-EXPIRE     
                           PERFORM 5900-NEXT-BILL-DATE                  
                              THRU 5900-NEXT-BILL-DATE-EXIT             
                           PERFORM 7930-GET-NXT-RD-DT THRU 7930-EXIT    
                           PERFORM 7253-CALCULATE-DATES THRU 7253-EXIT  
                        END-PERFORM                                     
                     END-IF                                             
                  ELSE                                                  
      *              * CALCULATE NEXT BILL DATE FOR SCEG                        
                     MOVE MH-DATE-TRANS TO WS-READ-DATE                 
                     PERFORM 5900-NEXT-BILL-DATE                        
                        THRU 5900-NEXT-BILL-DATE-EXIT                   
                     MOVE BN-DATE-EXTRACT TO WS-HOLD-NEXT-BILL-DATE     
                     MOVE WS-DATE-EXPIRE  TO WS-DATE-NOTICE-DUE         
                  END-IF                                                
                                                                        
                  IF WS-FIRST-NOTICE-DATE > MH-DATE-TRANS               
                     IF SEB-DATABASE                                    
                        IF WS-DATE-EXPIRE >= WS-HOLD-NEXT-BILL-DATE     
                           PERFORM 5300-INSERT-FIRST-NOTICE             
                              THRU 5300-EXIT                            
                           IF WS-TOTAL-BALANCE-NONUTL > 0               
                              PERFORM 5320-INSERT-FIRST-NU-NOTICE       
                                 THRU 5320-EXIT                         
                           END-IF                                       
                        END-IF                                          
                     ELSE                                               
                        PERFORM 5300-INSERT-FIRST-NOTICE THRU 5300-EXIT 
                        IF WS-TOTAL-BALANCE-NONUTL > 0                  
                           PERFORM 5320-INSERT-FIRST-NU-NOTICE          
                              THRU 5320-EXIT                            
                        END-IF                                          
                     END-IF                                             
                     PERFORM 5302-INSERT-SECOND-NOTICE THRU 5302-EXIT   
                     IF WS-TOTAL-BALANCE-NONUTL > 0                     
                        PERFORM 5322-INSERT-SECOND-NU-NOTICE THRU       
                                5322-EXIT                               
                     END-IF                                             
                  ELSE                                                  
                     IF WS-SECOND-NOTICE-DATE > MH-DATE-TRANS           
                      PERFORM 5302-INSERT-SECOND-NOTICE THRU 5302-EXIT  
                      IF WS-TOTAL-BALANCE-NONUTL > 0                    
                         PERFORM 5322-INSERT-SECOND-NU-NOTICE THRU      
                                 5322-EXIT                              
                      END-IF                                            
                        MOVE 400                       TO S-RETURN-CODE 
                     ELSE                                               
                        MOVE 300                       TO S-RETURN-CODE 
                     END-IF                                             
                  END-IF                                                
                                                                        
                  PERFORM 5304-INSERT-DNP              THRU 5304-EXIT   
                  IF WS-TOTAL-BALANCE-NONUTL  > 0                       
                     PERFORM 5324-INSERT-EXCEPT-NU-WQ  THRU 5324-EXIT   
                  END-IF                                                
                                                                        
                  IF WS-AMT-ARREARS-NONUTL  >  WS-AMT-NONUTIL-WQ-MIN    
                     PERFORM 5326-INSERT-NU-WQ         THRU 5326-EXIT   
                  END-IF                                                
                                                                        
                  MOVE 'A'                      TO WS-CODE-MEDICAL      
                  MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT
                  MOVE SPACES                   TO AT-CODE-TEMP-BILL    
                  PERFORM 8300-UPDATE-ACCOUNT     THRU 8300-EXIT        
               END-IF                                                   
                                                                        
               IF S-RETURN-CODE = 0 OR 300 OR 400                       
                  MOVE AT-PREMISE-NO            TO WS-PREMISE-NO-D      
                  MOVE WS-PREMISE-NO-D          TO WS-PREMISE-NO-I      
                  MOVE 'MEDICAL CERTIFICATE'    TO WS-REMARKS-TX-TEXT   
                  MOVE +19                      TO WS-REMARKS-TX-LEN    
                                                                        
                  PERFORM 5600-CANCEL-DNP                THRU 5600-EXIT 
                  IF (CSR-DATABASE AND PSNC)                            
                     PERFORM 5700-CANCEL-NOTICES         THRU 5700-EXIT 
                  END-IF                                                
               END-IF                                                   
                                                                        
            END-IF.                                                     
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-SEB-BALANCE                                               *        
      ******************************************************************        
                                                                        
       5210-SEB-BALANCE.                                                
           MOVE AT-COMPANY-NO          TO CM-COMPANY-NO.                
           MOVE AT-BILL-CYCLE          TO CM-BILL-CYCLE.                
           IF WS-SEB-REGULATED                                          
               MOVE WS-A               TO CM-CRED-FORECAST-CD           
           ELSE                                                         
               MOVE WS-B               TO CM-CRED-FORECAST-CD           
           END-IF.                                                      
           PERFORM 7210-SEL-FORECAST   THRU 7210-EXIT.                  
           MOVE CM-DNP-NOTICE-MAIL-DT  TO WS-SECOND-NOTICE-DATE.        
           MOVE CM-DNP-NOTICE-DUE-DT   TO WS-DATE-NOTICE-DUE.           
           MOVE LOW-VALUES             TO WS-IVR-DATE.                  
           MOVE CM-DNP-DT              TO WS-DNP-DATE.                  
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10170000
      * 5300-INSERT-FIRST-NOTICE.                                      *10180000
      * UPDATE THE FIRST SPECIAL NOTICE ROW (E) FOR CSS_CRED_COLL      *10240000
      ******************************************************************10260000
                                                                        
       5300-INSERT-FIRST-NOTICE.                                        
                                                                        
               MOVE 'E'                   TO CL-CODE-NOTICE-TYPE        
               MOVE WS-FIRST-NOTICE-DATE  TO CL-DATE-NOTICE-MAIL        
               MOVE WS-DATE-EXPIRE        TO CL-DATE-NOTICE-DUE         
               MOVE LOW-VALUES            TO CL-DATE-CREDIT-ACTION      
               IF (CSR-DATABASE AND SCEG)                               
                  IF WS-HOLD-NEXT-BILL-DATE  >= WS-DNP-DATE             
                     MOVE WS-AMT-ARREARS-UTL    TO CL-AMT-NOTICE        
                  ELSE                                                  
                     MOVE WS-TOTAL-BALANCE-UTL  TO CL-AMT-NOTICE        
                  END-IF                                                
               ELSE                                                     
                  MOVE WS-TOTAL-BALANCE-UTL     TO CL-AMT-NOTICE        
               END-IF.                                                  
               PERFORM 5306-MOVE-PARA     THRU 5306-EXIT.               
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10390000
      * 5302-INSERT-SECOND-NOTICE.                                     *10400000
      * UPDATE THE FIRST SPECIAL NOTICE ROW (F) FOR CSS_CRED_COLL      *10460000
      ******************************************************************10480000
                                                                        
       5302-INSERT-SECOND-NOTICE.                                       
                                                                        
           IF NOT PSNC                                                  
             MOVE 'F'                   TO CL-CODE-NOTICE-TYPE          
             MOVE WS-SECOND-NOTICE-DATE TO CL-DATE-NOTICE-MAIL          
             MOVE WS-DATE-NOTICE-DUE    TO CL-DATE-NOTICE-DUE           
             MOVE WS-IVR-DATE           TO CL-DATE-CREDIT-ACTION        
             IF (CSR-DATABASE AND SCEG)                                 
                IF WS-HOLD-NEXT-BILL-DATE  >= WS-DNP-DATE               
                   MOVE WS-AMT-ARREARS-UTL   TO CL-AMT-NOTICE           
                ELSE                                                    
                   MOVE WS-TOTAL-BALANCE-UTL TO CL-AMT-NOTICE           
                END-IF                                                  
             ELSE                                                       
                MOVE WS-TOTAL-BALANCE-UTL    TO CL-AMT-NOTICE           
             END-IF                                                     
             PERFORM 5306-MOVE-PARA     THRU 5306-EXIT                  
           END-IF.                                                      
                                                                        
       5302-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10610000
      * 5304-INSERT-DNP.                                               *10620000
      * UPDATE THE DNP SPECIAL ROW(G) FOR CSS_CRED_COLL                *10680000
      *                                                                *10690000
      ******************************************************************10700000
                                                                        
       5304-INSERT-DNP.                                                 
                                                                        
           IF NOT PSNC                                                  
             MOVE 'G'                   TO CL-CODE-NOTICE-TYPE          
             MOVE LOW-VALUES            TO CL-DATE-NOTICE-MAIL          
             MOVE LOW-VALUES            TO CL-DATE-NOTICE-DUE           
             MOVE WS-DNP-DATE           TO CL-DATE-CREDIT-ACTION        
             IF (CSR-DATABASE AND SCEG)                                 
                IF WS-HOLD-NEXT-BILL-DATE  >= WS-DNP-DATE               
                   MOVE WS-AMT-ARREARS-UTL   TO CL-AMT-NOTICE           
                ELSE                                                    
                   MOVE WS-TOTAL-BALANCE-UTL TO CL-AMT-NOTICE           
                END-IF                                                  
             ELSE                                                       
                MOVE WS-TOTAL-BALANCE-UTL    TO CL-AMT-NOTICE           
             END-IF                                                     
             PERFORM 5306-MOVE-PARA     THRU 5306-EXIT                  
           END-IF.                                                      
                                                                        
       5304-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10830000
      * 5306-MOVE PARA.                                                *10840000
      ******************************************************************10940000
                                                                        
       5306-MOVE-PARA.                                                  
                                                                        
           MOVE SPACES                   TO CL-CODE-FRCST-CR-GRP        
           MOVE 0                        TO CL-ITEM-ID                  
           MOVE 0                        TO CL-CODE-MESSAGE-TYPE        
           MOVE AT-DATE-BILL-DAY-00      TO CL-DATE-BILL                
           MOVE 'M'                      TO CL-CODE-SPECIAL-TYPE        
                                                                        
           PERFORM 8600-INSERT-CRED-COLL THRU 8600-EXIT.                
                                                                        
       5306-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11090000
      * 5310-MOVE-TO-CUST-ALERT-VARS.                                  *11100000
      * MOVES ALL POSSIBLE WORKING STORAGE OF CUST_ALERT TO HOST       *11160000
      * VARIABLES.                                                     *11170000
      ******************************************************************11180000
                                                                        
       5310-MOVE-TO-CUST-ALERT-VARS.                                    
                                                                        
           MOVE 'M'                     TO CA-CODE-ALERT-TYPE.          
           MOVE WS-DATE-ALERT           TO CA-DATE-ALERT.               
           MOVE WS-DATE-EXPIRE          TO CA-DATE-EXPIRE.              
           MOVE WS-PHYSICIAN-ID         TO CA-PHYSICIAN-ID.             
           MOVE WS-USER-ID              TO CA-LAST-UPDATE-USERID.       
           MOVE MH-TRANS-HIST-SEQ-NO    TO WS-CURRENT-TIMESTAMP.        
           MOVE SPACES                  TO CA-CUST-ALERT-SEQ-NO         
                                           CA-PHONE-NO-EXT              
                                           CA-PHONE-NO.                 
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10170000
      * 5320-INSERT-FIRST-NU-NOTICE.                                   *10180000
      * UPDATE THE FIRST SPECIAL NOTICE NON UTIL ROW (T)               *10240000
      ******************************************************************10260000
       5320-INSERT-FIRST-NU-NOTICE.                                     
                                                                        
               MOVE 'T'                      TO CL-CODE-NOTICE-TYPE     
               MOVE WS-FIRST-NOTICE-DATE     TO CL-DATE-NOTICE-MAIL     
               MOVE WS-DATE-EXPIRE           TO CL-DATE-NOTICE-DUE      
               MOVE LOW-VALUES               TO CL-DATE-CREDIT-ACTION   
               IF (CSR-DATABASE AND SCEG)                               
                  IF WS-HOLD-NEXT-BILL-DATE  >= WS-DNP-DATE             
                     MOVE WS-AMT-ARREARS-NONUTL   TO CL-AMT-NOTICE      
                  ELSE                                                  
                     MOVE WS-TOTAL-BALANCE-NONUTL TO CL-AMT-NOTICE      
                  END-IF                                                
               ELSE                                                     
                  MOVE WS-TOTAL-BALANCE-NONUTL    TO CL-AMT-NOTICE      
               END-IF.                                                  
               PERFORM 5306-MOVE-PARA        THRU 5306-EXIT.            
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10390000
      * 5322-INSERT-SECOND-NU-NOTICE.                                  *10400000
      * UPDATE THE 2ND SPEC NONUTIL NOTICE  (U) FOR CSS_CRED_COLL      *10460000
      *                                                                *10470000
      ******************************************************************10480000
                                                                        
       5322-INSERT-SECOND-NU-NOTICE.                                    
                                                                        
           IF NOT PSNC                                                  
              MOVE 'U'                     TO CL-CODE-NOTICE-TYPE       
              MOVE WS-SECOND-NOTICE-DATE   TO CL-DATE-NOTICE-MAIL       
              MOVE WS-DATE-NOTICE-DUE      TO CL-DATE-NOTICE-DUE        
              MOVE LOW-VALUES              TO CL-DATE-CREDIT-ACTION     
              IF (CSR-DATABASE AND SCEG)                                
                 IF WS-HOLD-NEXT-BILL-DATE  >= WS-DNP-DATE              
                    MOVE WS-AMT-ARREARS-NONUTL   TO CL-AMT-NOTICE       
                 ELSE                                                   
                    MOVE WS-TOTAL-BALANCE-NONUTL TO CL-AMT-NOTICE       
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-TOTAL-BALANCE-NONUTL    TO CL-AMT-NOTICE       
              END-IF                                                    
              PERFORM 5306-MOVE-PARA       THRU 5306-EXIT               
           END-IF.                                                      
                                                                        
       5322-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10610000
      * 5324-INSERT-EXCEPT-NU-WQ                                       *10620000
      * UPDATE THE DNP SPECIAL ROW(G) FOR CSS_CRED_COLL                *10680000
      *                                                                *10690000
      ******************************************************************10700000
                                                                        
       5324-INSERT-EXCEPT-NU-WQ.                                        
                                                                        
           IF NOT PSNC                                                  
              MOVE 'X'                   TO CL-CODE-NOTICE-TYPE         
              MOVE LOW-VALUES            TO CL-DATE-NOTICE-MAIL         
              MOVE LOW-VALUES            TO CL-DATE-NOTICE-DUE          
              MOVE WS-TOTAL-BALANCE-NONUTL  TO CL-AMT-NOTICE            
              IF (CSR-DATABASE AND SCEG)                                
                 IF WS-HOLD-NEXT-BILL-DATE  >= WS-DNP-DATE              
                    MOVE WS-AMT-ARREARS-NONUTL     TO CL-AMT-NOTICE     
                 ELSE                                                   
                    MOVE WS-TOTAL-BALANCE-NONUTL   TO CL-AMT-NOTICE     
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-TOTAL-BALANCE-NONUTL      TO CL-AMT-NOTICE     
              END-IF                                                    
              PERFORM 5325-NEXT-BILL-DATE-AFTER-EXP   THRU 5325-EXIT    
              IF BN-DATE-EXTRACT > SPACES                               
                 MOVE BN-DATE-EXTRACT TO WS-DATE-CALC                   
                 MOVE SPACES TO WS-HOLD-EXP-DATE                        
                 SET PREV-BUSINESS-DAY-NOT-FOUND TO TRUE                
                 MOVE +1 TO WS-HOLD-DAY-NO                              
                 PERFORM 7510-GET-1DAY-PRIOR-DATE                       
                    UNTIL PREV-BUSINESS-DAY-FOUND                       
                 MOVE WS-HOLD-EXP-DATE TO CL-DATE-CREDIT-ACTION         
              ELSE                                                      
                 MOVE SPACES TO CL-DATE-CREDIT-ACTION                   
              END-IF                                                    
              PERFORM 5306-MOVE-PARA        THRU 5306-EXIT              
           END-IF.                                                      
                                                                        
       5324-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5325-NEXT-BILL-DATE-AFTER-EXP                                  *        
      ******************************************************************        
                                                                        
       5325-NEXT-BILL-DATE-AFTER-EXP.                                   
                                                                        
           MOVE '5325' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF AT-CODE-BILL-FREQ <= SPACES                               
              MOVE 'M01'   TO   WS-CODE-BILL-FREQ                       
           ELSE                                                         
              MOVE AT-CODE-BILL-FREQ   TO WS-CODE-BILL-FREQ             
           END-IF.                                                      
                                                                        
           MOVE AT-REV-MTH-LST-NRML TO WS-LST-REV-MTH-NRML.             
           MOVE AT-BILL-CYCLE       TO BN-BILL-CYCLE.                   
                                                                        
           IF WS-CURRENT-DATE = SPACES                                  
               MOVE -1 TO WS-CURRENT-DATE-NI                            
           ELSE                                                         
               MOVE 0 TO WS-CURRENT-DATE-NI                             
           END-IF                                                       
                                                                        
           IF WS-FREQ-CODE-LIT EQUAL 'M' THEN                           
              PERFORM 7940-OPEN-BILL-DATE-EXP-CSR                       
                 THRU 7940-EXIT                                         
              PERFORM 7945-FETCH-BILL-DATE-EXP-CSR                      
                 THRU 7945-EXIT                                         
              PERFORM 7950-CLOSE-BILL-DATE-EXP-CSR                      
                 THRU 7950-EXIT                                         
           ELSE                                                         
              MOVE SPACES TO BN-DATE-EXTRACT                            
              MOVE ZEROES TO BN-REVENUE-MONTH                           
           END-IF.                                                      
                                                                        
       5325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10610000
      * 5326-INSERT-NU-WQ                                              *10620000
      * INSERT THE NORMAL WQ  ROW(M) FOR CSS_CRED_COLL                 *10680000
      ******************************************************************10700000
                                                                        
      ******************************************************************        
      * 5326-INSERT-NU-WQ                                              *        
      ******************************************************************        
                                                                        
       5326-INSERT-NU-WQ.                                               
                                                                        
           MOVE 'M'                      TO CL-CODE-NOTICE-TYPE.        
           MOVE LOW-VALUES               TO CL-DATE-NOTICE-MAIL.        
           MOVE LOW-VALUES               TO CL-DATE-NOTICE-DUE.         
           MOVE WS-AMT-ARREARS-NONUTL    TO CL-AMT-NOTICE.              
           MOVE MH-DATE-TRANS            TO WS-HOLD-DATE-2.             
           MOVE 0 TO WS-ADJ-DAY.                                        
           MOVE +100 TO WS-ACTIVE-RETURN-CODE.                          
           PERFORM 7030-GET-NEXT-WORK-DAY THRU 7030-EXIT                
              UNTIL WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL.            
           MOVE WS-WORK-DATE             TO CL-DATE-CREDIT-ACTION.      
           PERFORM 5306-MOVE-PARA        THRU 5306-EXIT.                
                                                                        
       5326-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11380000
      * 5400-JRNL-TRAN-HEAD.                                           *11390000
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.             *11450000
      * THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,         *11460000
      * THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).                  *11470000
      ******************************************************************11480000
                                                                        
       5400-JRNL-TRAN-HEAD.                                             
                                                                        
           PERFORM 7800-SELECT-TIMESTAMP-DATE     THRU 7800-EXIT.       
           PERFORM 7802-SELECT-RESP-AREA          THRU 7802-EXIT.       
                                                                        
           MOVE 1                        TO MI-TRAN-APPL-NO.            
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE WS-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 0                        TO MH-CUSTOMER-NO.             
           MOVE 0                        TO MH-PREMISE-NO.              
           MOVE WS-USER-ID               TO MH-USER-ID.                 
           IF (CSR-DATABASE AND PSNC)                                   
              MOVE 'PANEL269A'           TO MH-APPL-PROGRAM-ID          
           ELSE                                                         
              MOVE 'PANEL269'            TO MH-APPL-PROGRAM-ID          
           END-IF.                                                      
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE SPACES                   TO MI-TABLE-ID.                
                                                                        
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11700000
      * 5500-JRNL-UPDATE.                                              *11710000
      * UPDATES THE JOURNAL                                            *11830000
      * REMOVED THE RECORDING OF THE START DATE AND THE EXPIRATION DATE*11831000
      * IN TRANSACTION HISTORY PER TPR12875. ADDED BACK IN THE         *11832000
      * TRANSACTION HISTORY FOR START DATE AND END DATE.               *11833000
      ******************************************************************11840000
                                                                        
       5500-JRNL-UPDATE.                                                
                                                                        
           MOVE '5500'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           PERFORM 5505-JRNL-DATE-ALERT          THRU 5505-EXIT.        
           PERFORM 5510-JRNL-DATE-EXPIRE         THRU 5510-EXIT.        
      *                                                                 11891000
           IF WS-KR362-UPDATE-FLAG = 'I'                                
              PERFORM 5515-JRNL-PATIENT-NAME     THRU 5515-EXIT         
           ELSE                                                         
              PERFORM 5540-JRNL-PATIENT-NAME-UPD THRU 5540-EXIT         
           END-IF.                                                      
      *                                                                 11891000
           IF WS-PHYSICIAN-ID > 0 AND                                   
              WS-PHYSICIAN-ID NOT = WS-PHYSICIAN-ID-OLD                 
              PERFORM 7130-GET-PHYSICIAN-DETAILS THRU 7130-EXIT         
              MOVE PY-NAME-ID        TO DQ-NAME-ID                      
              PERFORM 7140-GET-PHY-PTNT-NAME     THRU 7140-EXIT         
              PERFORM 5520-JRNL-PHYSICIAN-NAME   THRU 5520-EXIT         
                                                                        
              IF PA-ADDRESS-FORMAT = 'B'                                
                 MOVE PA-ADDRESS-ID     TO DZ-ADDRESS-ID                
                 PERFORM 7120-SEL-PHY-FF-ADDR    THRU 7120-EXIT         
                 PERFORM 5530-JRNL-PHY-FF-ADDR   THRU 5530-EXIT         
              ELSE                                                      
                 MOVE PA-ADDRESS-ID     TO DY-ADDRESS-ID                
                 PERFORM 7110-SEL-PHY-FMT-ADDR   THRU 7110-EXIT         
                 PERFORM 5525-JRNL-PHY-FMT-ADDR  THRU 5525-EXIT         
              END-IF                                                    
                                                                        
              PERFORM 5535-JRNL-LICENSE-NUMBER   THRU 5535-EXIT         
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12020000
      * 5505-JRNL-DATE-ALERT.                                          *12030000
      ******************************************************************12100000
                                                                        
       5505-JRNL-DATE-ALERT.                                            
                                                                        
           IF PARM-FILE-DELETE-FLAG = 'D'                               
              MOVE SPACES                TO PARM-DATE-ALERT             
           END-IF.                                                      
                                                                        
           IF WS-DATE-ALERT-OLD NOT = PARM-DATE-ALERT                   
                                                                        
              IF PARM-DATE-ALERT > SPACES                               
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE PARM-DATE-ALERT    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF WS-DATE-ALERT-OLD > SPACES                             
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-DATE-ALERT-OLD  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'ALERT DATE     '     TO MI-COLUMN-DESC              
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
                                                                        
              ADD +1                     TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
       5505-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12510000
      * 5510-JRNL-DATE-EXPIRE                                          *12520000
      ******************************************************************12590000
                                                                        
           IF PARM-FILE-DELETE-FLAG = 'D'                               
              MOVE SPACES                TO PARM-DATE-EXPIRE            
           END-IF.                                                      
                                                                        
       5510-JRNL-DATE-EXPIRE.                                           
                                                                        
           IF WS-DATE-EXPIRE-OLD NOT = PARM-DATE-EXPIRE                 
                                                                        
              IF PARM-DATE-EXPIRE > SPACES                              
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE PARM-DATE-EXPIRE   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF WS-DATE-ALERT-OLD > SPACES                             
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-DATE-EXPIRE-OLD TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'EXPIRE DATE    '     TO MI-COLUMN-DESC              
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
                                                                        
              ADD +1                     TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
       5510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12510000
      * 5515-JRNL-PATIENT-NAME                                         *12520000
      ******************************************************************12590000
                                                                        
       5515-JRNL-PATIENT-NAME.                                          
                                                                        
           IF WS-PATIENT-FIRST-NAME > SPACES                            
      *       First Name Validation                                             
              MOVE 'PTNT FIRST NAME'        TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-PATIENT-FIRST-NAME    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF WS-PATIENT-MIDDLE-NAME > SPACES                           
      *       Middle Name Validation                                            
              MOVE 'PTNT MIDDLE NAME'       TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-PATIENT-MIDDLE-NAME   TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF WS-PATIENT-LAST-NAME > SPACES                             
      *       Last Name Validation                                              
              MOVE 'PTNT LAST NAME'         TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-PATIENT-LAST-NAME     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 40                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF WS-PATIENT-TITLE-PREFIX > SPACES                          
      *       Title Prefix Validation                                           
              MOVE 'PTNT TITLE PREFIX'      TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-PATIENT-TITLE-PREFIX  TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF WS-PATIENT-TITLE-SUFFIX-1 > SPACES                        
      *       Title Suffix Validation                                           
              MOVE 'PTNT TITLE SUFFIX'      TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-PATIENT-TITLE-SUFFIX-1                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5515-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12960000
      * 5520-JRNL-PHYSICIAN-NAME                                       *12970000
      ******************************************************************13040000
                                                                        
       5520-JRNL-PHYSICIAN-NAME.                                        
                                                                        
           IF DQ-FIRST-NAME > SPACES                                    
      *       FIRST NAME VALIDATION                                             
              MOVE 'PHY FIRST NAME'         TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DQ-FIRST-NAME            TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME > SPACES                                   
      *       MIDDLE NAME VALIDATION                                            
              MOVE 'PHY MIDDLE NAME'           TO MI-COLUMN-DESC        
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DQ-MIDDLE-NAME           TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME > SPACES                                     
      *       LAST NAME VALIDATION                                              
              MOVE 'PHY LAST NAME'          TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DQ-LAST-NAME             TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 40                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-PREFIX > SPACES                                  
      *       TITLE PREFIX VALIDATION                                           
              MOVE 'PHY TITLE PREFIX'       TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DQ-TITLE-PREFIX          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-SUFFIX-1 > SPACES                                
      *       TITLE SUFFIX VALIDATION                                           
              MOVE 'PHY TITLE SUFFIX'       TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DQ-TITLE-SUFFIX-1        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13410000
      * 5525-JRNL-FMT-ADDR                                             *13420000
      ******************************************************************13490000
                                                                        
       5525-JRNL-PHY-FMT-ADDR.                                          
                                                                        
                                                                        
           IF DY-HOUSE-NO > SPACES                                      
      *       HOUSE                                                             
              MOVE 'HOUSE NO'               TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-HOUSE-NO              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-1 > SPACES                                 
      *       ADDRESS PREFIX 1                                                  
              MOVE 'ADDRESS PREFIX 1'       TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-ADDR-PREFIX-1         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-2 > SPACES                                 
      *       ADDRESS PREFIX 2                                                  
              MOVE 'ADDRESS PREFIX 2'          TO MI-COLUMN-DESC        
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-ADDR-PREFIX-2         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 2                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-STREET-NAME > SPACES                                   
      *       STREET NAME                                                       
              MOVE 'STREET NAME'               TO MI-COLUMN-DESC        
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-STREET-NAME           TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 30                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-STREET-SUFFIX > SPACES                                 
      *       STREET SUFFIX                                                     
              MOVE 'STREET SUFFIX'          TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-STREET-SUFFIX         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 4                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-ADDRESS-OVERFLOW > SPACES                              
      *       ADDRESS OVERFLOW                                                  
              MOVE 'ADDRESS OVERFLOW'          TO MI-COLUMN-DESC        
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-ADDRESS-OVERFLOW      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 35                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-1 > SPACES                             
      *       STREET LOCATION-1                                                 
              MOVE 'STREET LOCATION 1'      TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-STREET-LOCATION-1     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 35                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-2 > SPACES                             
      *       STREET LOCATION-2                                                 
              MOVE 'STREET LOCATION 2'      TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-STREET-LOCATION-2     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 35                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE > SPACES                                      
      *       ZIP CODE                                                          
              MOVE 'ZIP CODE'               TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-ZIP-CODE              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
      *       ZIP CODE PLUS FOUR                                                
              MOVE 'ZIP CODE PLUS FOUR'     TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DY-ZIP-CODE-PLUS-FOUR    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 4                        TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13860000
      * 5530-JRNL-PHY-FF-ADDR                                          *13870000
      ******************************************************************13940000
                                                                        
       5530-JRNL-PHY-FF-ADDR.                                           
                                                                        
           IF DZ-ADDR-STREET > SPACES                                   
      *       FIRST NAME VALIDATION                                             
              MOVE 'ADDRESS STREET'         TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DZ-ADDR-STREET           TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW > SPACES                              
      *       MIDDLE NAME VALIDATION                                            
              MOVE 'ADDRESS OVERFLOW'       TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DZ-ADDRESS-OVERFLOW      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13860000
      * 5535-JRNL-LICENSE-NUMBER                                       *13870000
      ******************************************************************13940000
                                                                        
       5535-JRNL-LICENSE-NUMBER.                                        
                                                                        
           IF PY-MED-LICENSE-NO > SPACES                                
      *       FIRST NAME VALIDATION                                             
              MOVE 'LICENSE NUMBER'         TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE PY-MED-LICENSE-NO        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF PY-MED-LIC-STATE-CD > SPACES                              
      *       MIDDLE NAME VALIDATION                                            
              MOVE 'LICENSE STAT CD'        TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE PY-MED-LIC-STATE-CD      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 15                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5535-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12960000
      * 5540-JRNL-PATIENT-NAME-UPD                                     *12970000
      ******************************************************************13040000
                                                                        
       5540-JRNL-PATIENT-NAME-UPD.                                      
                                                                        
      * First name validation                                                   
           MOVE SPACES                      TO MI-TABLE-ID              
           IF WS-FIRST-NAME-OLD = WS-PATIENT-FIRST-NAME                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'PTNT FIRST NAME'        TO MI-COLUMN-DESC           
              IF WS-FIRST-NAME-OLD > SPACES                             
                 MOVE WS-FIRST-NAME-OLD     TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 15                    TO MI-PRV-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN  
              END-IF                                                    
              IF WS-PATIENT-FIRST-NAME > SPACES                         
                 MOVE WS-PATIENT-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 15                    TO MI-CHG-COLUMN-VALUE-LEN  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
      * Middle name validation                                                  
           IF WS-MIDDLE-NAME-OLD = WS-PATIENT-MIDDLE-NAME               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'PTNT MIDDLE NAME'       TO MI-COLUMN-DESC           
              IF WS-MIDDLE-NAME-OLD > SPACES                            
                 MOVE WS-MIDDLE-NAME-OLD    TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 15                    TO MI-PRV-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN  
              END-IF                                                    
              IF WS-PATIENT-MIDDLE-NAME > SPACES                        
                 MOVE WS-PATIENT-MIDDLE-NAME                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 15                    TO MI-CHG-COLUMN-VALUE-LEN  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
      * Last name validation                                                    
           IF WS-LAST-NAME-OLD = WS-PATIENT-LAST-NAME                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'PTNT LAST NAME'         TO MI-COLUMN-DESC           
              IF WS-LAST-NAME-OLD > SPACES                              
                 MOVE WS-LAST-NAME-OLD      TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 40                    TO MI-PRV-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN  
              END-IF                                                    
              IF WS-PATIENT-LAST-NAME > SPACES                          
                 MOVE WS-PATIENT-LAST-NAME  TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 40                    TO MI-CHG-COLUMN-VALUE-LEN  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
      * Title prefix validation                                                 
           IF WS-TITLE-PREFIX-OLD = WS-PATIENT-TITLE-PREFIX             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'PTNT TITLE PREFIX'      TO MI-COLUMN-DESC           
              IF WS-TITLE-PREFIX-OLD > SPACES                           
                 MOVE WS-TITLE-PREFIX-OLD   TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 9                     TO MI-PRV-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN  
              END-IF                                                    
              IF  WS-PATIENT-TITLE-PREFIX > SPACES                      
                 MOVE  WS-PATIENT-TITLE-PREFIX                          
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
      * Title suffix validation                                                 
           IF WS-TITLE-SUFFIX-1-OLD = WS-PATIENT-TITLE-SUFFIX-1         
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'PTNT TITLE SUFFIX'      TO MI-COLUMN-DESC           
              IF WS-TITLE-SUFFIX-1-OLD > SPACES                         
                 MOVE WS-TITLE-SUFFIX-1-OLD TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 3                     TO MI-PRV-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN  
              END-IF                                                    
              IF WS-PATIENT-TITLE-SUFFIX-1 > SPACES                     
                 MOVE WS-PATIENT-TITLE-SUFFIX-1                         
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 3                     TO MI-CHG-COLUMN-VALUE-LEN  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5600-CANCEL-DNP                                                *        
      ******************************************************************        
                                                                        
       5600-CANCEL-DNP.                                                 
                                                                        
      *Flag set to 'S' which will select the order no, order reason and         
      *work area so that these can be passed to the work queue insert           
      *routine.                                                                 
           MOVE 'S'                             TO WS-SO-SELECT-UPDATE. 
                                                                        
           PERFORM 5610-OPEN-CSR00125           THRU 5610-EXIT.         
           PERFORM 5615-ASSOCIATE-LOCATORS      THRU 5615-EXIT.         
           PERFORM 5620-FETCH-CSR00125          THRU 5620-EXIT.         
           EVALUATE WS-SO-RETURN-CD-BD                                  
               WHEN 0                                                   
                    CONTINUE                                            
               WHEN 100                                                 
                    GO TO 5600-EXIT                                     
               WHEN 5000                                                
                    MOVE 'Y'                    TO WS-RETURN-FLAG       
               WHEN OTHER                                               
                    MOVE -1                     TO S-RETURN-CODE        
                    MOVE '5600'                 TO ACTIVE-PARAGRAPH     
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE 'DB2SP CALL'           TO ABEND-FUNCTION       
                    MOVE SQLCODE                TO ABEND-SQLCODE        
                    MOVE 'CSR00125'             TO TABLE-1              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1    
                    MOVE 'SQLCODE'              TO TABLE-ELEMENT-2      
                    MOVE SQLCODE                TO HOSTVAR-ELEMENT-2    
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
           PERFORM 5630-CLOSE-CSR00125           THRU 5630-EXIT.        
                                                                        
           MOVE WS-SERV-ORDER-CHAR-BD      TO WS-SERV-ORDER-NO-C.       
           MOVE WS-SERV-ORDER-NO-I         TO WS-SERV-ORDER-NO-D.       
                                                                        
           IF WS-ORDER-TYPE-CD-BD = 'DNPFB'                             
              MOVE 'N'                     TO WS-UPDATE-PROFILE         
           ELSE                                                         
              MOVE 'Y'                     TO WS-UPDATE-PROFILE         
           END-IF.                                                      
                                                                        
           IF WS-INSERT-WORK-QUEUE-BD = 'Y'                             
              PERFORM 5640-CALL-CSR00423          THRU 5640-EXIT        
              EVALUATE WS-CSR00423-RETURN-CD                            
                WHEN 0                                                  
                     CONTINUE                                           
                WHEN 100                                                
                     GO TO 5600-EXIT                                    
                WHEN OTHER                                              
                     MOVE WS-CSR00423-RETURN-CD   TO S-RETURN-CODE      
                                                     ABEND-SQLCODE      
                     MOVE PROGRAM-NAME            TO ABEND-PROGRAM      
                     MOVE '5200'                  TO ACTIVE-PARAGRAPH   
                     MOVE 'DB2 SP CALL'           TO ABEND-FUNCTION     
                     MOVE 'CSR00423'              TO TABLE-1            
                     MOVE 'WS-CSR00423-RETURN-CD' TO TABLE-ELEMENT-1    
                     MOVE WS-CSR00423-RETURN-CD   TO HOSTVAR-ELEMENT-1  
                     MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2    
                     MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2  
                     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT     
                     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT     
              END-EVALUATE                                              
                                                                        
              PERFORM 5650-PROCESS-WORK-QUEUE      THRU 5650-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-RETURN-FLAG = 'Y'                                      
              GO TO 5600-EXIT                                           
           END-IF                                                       
                                                                        
      *    Flag set to 'U' which will insert rows in css_so_remarks             
      *    and css_so_update, if required and update the state_cd               
      *    field on css_so_data with Cancelled.                                 
           MOVE 'U'                      TO WS-SO-SELECT-UPDATE.        
                                                                        
           PERFORM 5610-OPEN-CSR00125           THRU 5610-EXIT.         
           PERFORM 5615-ASSOCIATE-LOCATORS      THRU 5615-EXIT.         
           PERFORM 5620-FETCH-CSR00125          THRU 5620-EXIT.         
           EVALUATE WS-SO-RETURN-CD-BD                                  
              WHEN 0                                                    
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE -1                     TO S-RETURN-CODE         
                   MOVE '5600'                 TO ACTIVE-PARAGRAPH      
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE 'DB2SP CALL'           TO ABEND-FUNCTION        
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE 'CSR00125'             TO TABLE-1               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1     
                   MOVE 'SQLCODE'              TO TABLE-ELEMENT-2       
                   MOVE SQLCODE                TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
           PERFORM 5630-CLOSE-CSR00125            THRU 5630-EXIT.       
                                                                        
           PERFORM 5670-CALL-CSR02122             THRU 5670-EXIT.       
           IF WS-2122-RETURN-CODE = 0                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-2122-RETURN-CODE     TO S-RETURN-CODE             
                                              ABEND-SQLCODE             
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5600'                  TO ACTIVE-PARAGRAPH          
              MOVE 'DB2 SP CALL'           TO ABEND-FUNCTION            
              MOVE 'CSR02122'              TO TABLE-1                   
              MOVE 'WS-2122-RETURN-CODE'   TO TABLE-ELEMENT-1           
              MOVE WS-2122-RETURN-CODE     TO HOSTVAR-ELEMENT-1         
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5610-OPEN-CSR00125.                                            *        
      ******************************************************************        
                                                                        
       5610-OPEN-CSR00125.                                              
                                                                        
           INITIALIZE WS-CSR00125-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR00125                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:WS-PREMISE-NO-C                               
      *                 ,:WS-USER-ID                                    
      *                 ,:WS-REMARKS-TX                                 
      *                 ,'Y'                                            
      *                 ,:WS-SO-SELECT-UPDATE                           
      *                 ,'269'                                          
      *                 ,'A'                                            
      *                 ,'R'                                            
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_DNP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_DNP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_DNP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE '5610'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DB2SP CALL'               TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5615-ASSOCIATE-LOCATORS                                        *        
      ******************************************************************        
                                                                        
       5615-ASSOCIATE-LOCATORS.                                         
                                                                        
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC1)                                                  
      *        WITH PROCEDURE CSR00125                                  
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *        ALLOCATE CANCEL_DNP CURSOR FOR RESULT SET                
      *        :LOC1                                                    
      *    END-EXEC.                                                    
                                                                        
       5615-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5620-FETCH-CSR00125.                                           *        
      ******************************************************************        
                                                                        
       5620-FETCH-CSR00125.                                             
                                                                        
           EXEC SQL                                                     
           FETCH CANCEL_DNP INTO                                        
                    :WS-SO-RETURN-CD-BD                                 
                   ,:WS-SERV-ORDER-CHAR-BD                              
                   ,:WS-ORDER-REASON-BD                                 
                   ,:WS-RESP-AREA-ID-BD                                 
                   ,:WS-PENDING-DNP-FLAG-BD                             
                   ,:WS-INSERT-WORK-QUEUE-BD                            
                   ,:WS-AMOUNT-DISC-BAL                                 
                   ,:WS-ORDER-TYPE-CD-BD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE '5620'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5630-CLOSE-CSR00125.                                           *        
      ******************************************************************        
                                                                        
       5630-CLOSE-CSR00125.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE CANCEL_DNP                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                        TO S-RETURN-CODE           
              MOVE '5630'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'CSR00125'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'SQLCODE '                TO TABLE-ELEMENT-2         
              MOVE SQLCODE                   TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       5630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5640-CALL-CSR00423                                             *        
      ******************************************************************        
                                                                        
       5640-CALL-CSR00423.                                              
                                                                        
                                                                        
      *    EXEC SQL                                                     
      *        CALL CSR00423                                            
      *             (:WS-SERV-ORDER-NO-D                                
      *             )                                                   
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C4
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C4
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C4 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5640'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR00423'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC4)                                         
      *            WITH PROCEDURE CSR00423                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C4 CURSOR FOR RESULT SET                         
      *       :LOC4                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C4 INTO                                             
                    :WS-CSR00423-RETURN-CD                              
                   ,:WS-LOCAL-OFFICE :WS-LOCAL-OFFICE-NULL              
                   ,:WS-WORK-AREA :WS-WORK-AREA-NULL                 
                   ,:WS-CREW-ID :WS-CREW-ID-NULL                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-LOCAL-OFFICE-NULL =  -1                             
                 MOVE SPACES TO WS-LOCAL-OFFICE                         
              END-IF                                                    
              IF WS-WORK-AREA-NULL = -1                                 
                 MOVE SPACES TO WS-WORK-AREA                            
              END-IF                                                    
              IF WS-CREW-ID-NULL = -1                                   
                 MOVE SPACES TO WS-CREW-ID                              
              END-IF                                                    
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5640'                     TO ACTIVE-PARAGRAPH       
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15200000
      * 5650-PROCESS-WORK-QUEUE                                        *15210000
      ******************************************************************15280000
                                                                        
       5650-PROCESS-WORK-QUEUE.                                         
                                                                        
           MOVE '1'                    TO WS-WQ-ROUTING-CATGRY.         
           MOVE AT-LOCAL-OFFICE        TO WS-WQ-LOCAL-OFFICE.           
           MOVE WS-USER-ID             TO WS-WQ-USER-ID-ORIG.           
           MOVE SPACES                 TO WS-WQ-USER-ID-ASGN.           
           MOVE WS-RESP-AREA-ID-BD     TO WS-WQ-RESP-AREA-ID.           
           MOVE 31                     TO WS-WQ-CATEGORY-ID.            
           MOVE AT-ACCOUNT-NO          TO WS-WQ-ACCOUNT-NO.             
           MOVE AT-PREMISE-NO          TO WS-WQ-PREMISE-NO.             
           MOVE AT-CUSTOMER-NO         TO WS-WQ-CUSTOMER-NO.            
           MOVE WS-SERV-ORDER-CHAR-BD  TO WS-WQ-SERV-ORDER-NO.          
           MOVE WS-COMMENTS            TO WS-WQ-COMMENTS-TEXT.          
           MOVE LENGTH OF WS-COMMENTS  TO WS-WQ-COMMENTS-LEN.           
           MOVE WS-CURR-TIMESTAMP      TO WS-WQ-DATE-REQUIRED           
                                          WS-WQ-DATE-CREATED.           
           MOVE 'H'                    TO WS-WQ-PRIORITY.               
           MOVE ZEROES                 TO WS-WQ-FREE-FORM-LEN           
                                          WS-WQ-ITEM-ID.                
           MOVE SPACES                 TO WS-WQ-FREE-FORM-TEXT.         
ACT233     MOVE 'CSR04851'             TO WS-WQ-CREATED-BY.             
                                                                        
           IF WS-ORDER-TYPE-CD-BD = 'DNPFB'                             
              MOVE 'DNP ORDER FOR DNPFB' TO WS-COMMENTS                 
           ELSE                                                         
              IF WS-WORK-AREA = SPACES AND WS-CREW-ID = SPACES          
                 MOVE 'DNP ORDER CANCELLED' TO WS-COMMENTS              
              ELSE                                                      
                 IF WS-CREW-ID = SPACES                                 
                    STRING 'DNP ORDER CANCELLED,DNP WORK AREA WAS '     
                            DELIMITED BY SIZE WS-WORK-AREA              
                            DELIMITED BY SIZE                           
                      INTO WS-COMMENTS                                  
                 ELSE                                                   
                    STRING 'DNP ORDER CANCELLED,DNP CREW ID WAS '       
                            DELIMITED BY SIZE WS-CREW-ID                
                            DELIMITED BY SIZE                           
                      INTO WS-COMMENTS                                  
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-RETURN-FLAG = 'Y'                                      
              STRING 'PAYMENT RECEIVED,DNP STATE IS COMPLETE, '         
                      DELIMITED BY SIZE                                 
                     'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT'     
                      DELIMITED BY SIZE                                 
                INTO WS-COMMENTS                                        
              MOVE 160                 TO WS-WQ-CATEGORY-ID             
           END-IF.                                                      
                                                                        
                                                                        
ACT233     PERFORM 5660-CALL-CSR04675          THRU 5660-EXIT.          
                                                                        
       5650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
ACT233* 5660-CALL-CSR04675                                             *        
      ******************************************************************        
                                                                        
ACT233 5660-CALL-CSR04675.                                              
                                                                        
ACT233     INITIALIZE WS-CSR04675-RET-AREA.                             
                                                                        
      *    EXEC SQL                                                     
ACT233*        CALL CSR04675                                            
      *             (:WS-WQ-ITEM-ID                                     
      *            ,:WS-WQ-ROUTING-CATGRY                               
      *            ,:WS-WQ-LOCAL-OFFICE                                 
      *            ,:WS-WQ-USER-ID-ORIG                                 
      *            ,:WS-WQ-USER-ID-ASGN                                 
      *            ,:WS-WQ-RESP-AREA-ID                                 
      *            ,:WS-WQ-CATEGORY-ID                                  
      *            ,:WS-WQ-ACCOUNT-NO                                   
      *            ,:WS-WQ-PREMISE-NO                                   
      *            ,:WS-WQ-CUSTOMER-NO                                  
      *            ,:WS-WQ-SERV-ORDER-NO                                
      *            ,:WS-WQ-COMMENT                                      
      *            ,:WS-WQ-DATE-REQUIRED                                
      *            ,:WS-WQ-DATE-CREATED                                 
      *            ,:WS-WQ-PRIORITY                                     
      *            ,:WS-WQ-FREE-FORM-AREA                               
ACT233*            ,:WS-WQ-CREATED-BY                                   
      *            )                                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5660'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
ACT233        MOVE 'CSR04675'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC3)                                         
ACT233*            WITH PROCEDURE CSR04675                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C3 CURSOR FOR RESULT SET                         
      *       :LOC3                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C3 INTO                                             
ACT233              :WS-CSR04675-RETURN-CD                              
                   ,:WS-WQ-ITEM-ID                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF WS-CSR04675-RETURN-CD NOT = 0                     
ACT233                MOVE WS-CSR04675-RETURN-CD TO ABEND-SQLCODE       
                                                    S-RETURN-CODE       
                      MOVE PROGRAM-NAME      TO ABEND-PROGRAM           
                      MOVE '5660'            TO ACTIVE-PARAGRAPH        
                      MOVE 'FETCH'           TO ABEND-FUNCTION          
ACT233                MOVE 'CSR04675'        TO TABLE-1                 
                      MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2         
                      MOVE PARM-ACCOUNT-NO   TO HOSTVAR-ELEMENT-2       
                      PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT    
                      PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
ACT233                MOVE WS-CSR04675-RETURN-CD TO ABEND-SQLCODE       
                                                    S-RETURN-CODE       
                      MOVE PROGRAM-NAME      TO ABEND-PROGRAM           
                      MOVE '5660'            TO ACTIVE-PARAGRAPH        
                      MOVE 'FETCH'           TO ABEND-FUNCTION          
ACT233                MOVE 'CSR04675'        TO TABLE-1                 
                      MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2         
                      MOVE PARM-ACCOUNT-NO   TO HOSTVAR-ELEMENT-2       
                      PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT    
                      PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT    
           END-EVALUATE.                                                
                                                                        
       5660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5670-CALL-CSR02122                                             *        
      ******************************************************************        
                                                                        
       5670-CALL-CSR02122.                                              
                                                                        
           INITIALIZE WS-CSR02122-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR02122                                       
      *                 (:PARM-ACCOUNT-NO                               
      *                 ,:WS-PREMISE-NO-C                               
      *                 ,:WS-ORDER-REASON-BD                            
      *                 ,'R'                                            
      *                 ,:WS-PENDING-DNP-FLAG-BD                        
      *                 ,:WS-UPDATE-PROFILE                             
      *                 ,:WS-AMOUNT-DISC-BAL                            
      *                 ,'269'                                          
      *                 ,:WS-ORDER-TYPE-CD-BD                           
      *                 ,:WS-REMARKS-TX                                 
      *                 )                                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5670'                     TO ACTIVE-PARAGRAPH       
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC2)                                         
      *            WITH PROCEDURE CSR02122                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C2  CURSOR FOR RESULT SET                        
      *       :LOC2                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C2  INTO                                            
                    :WS-2122-RETURN-CODE                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5670'                     TO ACTIVE-PARAGRAPH       
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5670-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5700-CANCEL-NOTICES                                            *        
      ******************************************************************        
                                                                        
       5700-CANCEL-NOTICES.                                             
                                                                        
           MOVE SPACES                           TO WS-SO-SELECT-UPDATE.
                                                                        
           PERFORM 5710-OPEN-CSR01556               THRU 5710-EXIT.     
      *    EXEC SQL                                                     
      *         ASSOCIATE LOCATORS                                      
      *         (:LOC5)                                                 
      *         WITH PROCEDURE CSR01556                                 
      *    END-EXEC                                                     
      *    EXEC SQL                                                     
      *         ALLOCATE PENDING_NOTICE CURSOR FOR RESULT SET           
      *         :LOC5                                                   
      *    END-EXEC                                                     
           PERFORM 5720-FETCH-CSR01556              THRU 5720-EXIT.     
           EVALUATE WS-CSR01556-RETURN-CD                               
               WHEN 0                                                   
                    CONTINUE                                            
               WHEN 100                                                 
                    GO TO 5700-EXIT                                     
               WHEN OTHER                                               
                    MOVE WS-CSR01556-RETURN-CD   TO S-RETURN-CODE       
                                                    ABEND-SQLCODE       
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '5700'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DB2 SP CALL'           TO ABEND-FUNCTION      
                    MOVE 'CSR01556'              TO TABLE-1             
                    MOVE 'WS-CSR01556-RETURN-CD' TO TABLE-ELEMENT-1     
                    MOVE WS-CSR01556-RETURN-CD   TO HOSTVAR-ELEMENT-1   
                    MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2     
                    MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
           PERFORM 5730-CLOSE-CSR01556              THRU 5730-EXIT.     
                                                                        
           IF WS-INSERT-WORK-QUEUE-PD = 'Y'                             
              MOVE WS-SERV-ORDER-CHAR-PD         TO WS-SERV-ORDER-NO-C  
              MOVE WS-SERV-ORDER-NO-I            TO WS-SERV-ORDER-NO-D  
                                                                        
              PERFORM 5640-CALL-CSR00423            THRU 5640-EXIT      
              EVALUATE WS-CSR00423-RETURN-CD                            
                WHEN 0                                                  
                     CONTINUE                                           
                WHEN 100                                                
                     GO TO 5700-EXIT                                    
                WHEN OTHER                                              
                     MOVE WS-CSR00423-RETURN-CD   TO S-RETURN-CODE      
                                                     ABEND-SQLCODE      
                     MOVE PROGRAM-NAME            TO ABEND-PROGRAM      
                     MOVE '5700'                  TO ACTIVE-PARAGRAPH   
                     MOVE 'DB2 SP CALL'           TO ABEND-FUNCTION     
                     MOVE 'CSR00423'              TO TABLE-1            
                     MOVE 'WS-CSR00423-RETURN-CD' TO TABLE-ELEMENT-1    
                     MOVE WS-CSR00423-RETURN-CD   TO HOSTVAR-ELEMENT-1  
                     MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2    
                     MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2  
                     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT     
                     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT     
              END-EVALUATE                                              
                                                                        
              PERFORM 5740-PROCESS-WORK-QUEUE-PSNC   THRU 5740-EXIT     
                                                                        
              MOVE 'N'                        TO WS-UPDATE-PROFILE      
              MOVE 'NOT01'                    TO WS-ORDER-TYPE-CD-BD    
              MOVE WS-ORDER-REASON-PD         TO WS-ORDER-REASON-BD     
              MOVE WS-PENDING-DNP-FLAG-PD     TO WS-PENDING-DNP-FLAG-BD 
              MOVE WS-AMOUNT-DISC-BAL-PD      TO WS-AMOUNT-DISC-BAL     
              PERFORM 5670-CALL-CSR02122             THRU 5670-EXIT     
              IF WS-2122-RETURN-CODE = 0                                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-2122-RETURN-CODE     TO S-RETURN-CODE          
                                                 ABEND-SQLCODE          
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '5700'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'DB2 SP CALL'           TO ABEND-FUNCTION         
                 MOVE 'CSR02122'              TO TABLE-1                
                 MOVE 'WS-2122-RETURN-CODE'   TO TABLE-ELEMENT-1        
                 MOVE WS-2122-RETURN-CODE     TO HOSTVAR-ELEMENT-1      
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2        
                 MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5710-OPEN-CSR01556.                                            *        
      ******************************************************************        
                                                                        
       5710-OPEN-CSR01556.                                              
                                                                        
           INITIALIZE WS-CSR01556-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR01556                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:WS-PREMISE-NO-C                               
      *                 ,:WS-USER-ID                                    
      *                 ,:WS-REMARKS-TX                                 
      *                 ,'Y'                                            
      *                 ,:WS-SO-SELECT-UPDATE                           
      *                 ,'269'                                          
      *                 ,'A'                                            
      *                 ,' '                                            
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE PENDING_NOTICE
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN PENDING_NOTICE
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR PENDING_NOTICE INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE '5710'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DB2SP CALL'               TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR01556'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5720-FETCH-CSR01556.                                           *        
      ******************************************************************        
                                                                        
       5720-FETCH-CSR01556.                                             
                                                                        
           EXEC SQL                                                     
           FETCH PENDING_NOTICE INTO                                    
                    :WS-CSR01556-RETURN-CD                              
                   ,:WS-SERV-ORDER-CHAR-PD                              
                   ,:WS-ORDER-REASON-PD                                 
                   ,:WS-RESP-AREA-ID-PD                                 
                   ,:WS-PENDING-DNP-FLAG-PD                             
                   ,:WS-INSERT-WORK-QUEUE-PD                            
                   ,:WS-AMOUNT-DISC-BAL-PD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE '5720'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR01556'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5730-CLOSE-CSR01556                                            *        
      ******************************************************************        
                                                                        
       5730-CLOSE-CSR01556.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE PENDING_NOTICE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                      TO S-RETURN-CODE             
              MOVE '5730'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE 'CSR01556'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-2           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15200000
      * 5740-PROCESS-WORK-QUEUE-PSNC                                   *15210000
      ******************************************************************15280000
                                                                        
       5740-PROCESS-WORK-QUEUE-PSNC.                                    
                                                                        
           MOVE SPACES                 TO WS-COMMENTS.                  
           MOVE '1'                    TO WS-WQ-ROUTING-CATGRY.         
           MOVE AT-LOCAL-OFFICE        TO WS-WQ-LOCAL-OFFICE.           
           MOVE WS-USER-ID             TO WS-WQ-USER-ID-ORIG.           
           MOVE SPACES                 TO WS-WQ-USER-ID-ASGN.           
           MOVE WS-RESP-AREA-ID-PD     TO WS-WQ-RESP-AREA-ID.           
           MOVE 96                     TO WS-WQ-CATEGORY-ID.            
           MOVE AT-ACCOUNT-NO          TO WS-WQ-ACCOUNT-NO.             
           MOVE AT-PREMISE-NO          TO WS-WQ-PREMISE-NO.             
           MOVE AT-CUSTOMER-NO         TO WS-WQ-CUSTOMER-NO.            
           MOVE WS-SERV-ORDER-NO-D     TO WS-WQ-SERV-ORDER-NO.          
           MOVE WS-COMMENTS            TO WS-WQ-COMMENTS-TEXT.          
           MOVE LENGTH OF WS-COMMENTS  TO WS-WQ-COMMENTS-LEN.           
           MOVE WS-CURR-TIMESTAMP      TO WS-WQ-DATE-REQUIRED           
                                          WS-WQ-DATE-CREATED.           
           MOVE 'H'                    TO WS-WQ-PRIORITY.               
           MOVE ZEROES                 TO WS-WQ-FREE-FORM-LEN           
                                          WS-WQ-ITEM-ID.                
           MOVE SPACES                 TO WS-WQ-FREE-FORM-TEXT.         
                                                                        
           IF WS-WORK-AREA = SPACES AND WS-CREW-ID = SPACES             
              MOVE 'SECOND NOTICE ORDER CANCELLED' TO WS-COMMENTS       
           ELSE                                                         
              IF WS-CREW-ID = SPACES                                    
                 STRING 'SECOND NOTICE ORDER CANCELLED, SECOND NOTICE W         
      -                  'ORK AREA WAS'                                         
                            DELIMITED BY SIZE WS-WORK-AREA              
                            DELIMITED BY SIZE                           
                       INTO WS-COMMENTS                                 
              ELSE                                                      
                    STRING 'SECOND NOTICE ORDER CANCELLED, SECOND NOTIC         
      -                  'E CREW ID WAS'                                        
                            DELIMITED BY SIZE WS-CREW-ID                
                            DELIMITED BY SIZE                           
                      INTO WS-COMMENTS                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
ACT233     PERFORM 5660-CALL-CSR04675     THRU 5660-EXIT.               
                                                                        
       5740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15200000
      * 5900-NEXT-BILL-DATE.                                           *15210000
      ******************************************************************15280000
       5900-NEXT-BILL-DATE.                                             
                                                                        
           MOVE '5900' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF AT-CODE-BILL-FREQ <= SPACES                               
              MOVE 'M01'   TO   WS-CODE-BILL-FREQ                       
           ELSE                                                         
              MOVE AT-CODE-BILL-FREQ   TO WS-CODE-BILL-FREQ             
           END-IF.                                                      
           MOVE AT-REV-MTH-LST-NRML TO WS-LST-REV-MTH-NRML.             
           MOVE AT-BILL-CYCLE       TO BN-BILL-CYCLE.                   
                                                                        
           IF WS-CURRENT-DATE = SPACES                                  
               MOVE -1 TO WS-CURRENT-DATE-NI                            
           ELSE                                                         
               MOVE 0 TO WS-CURRENT-DATE-NI                             
           END-IF                                                       
                                                                        
           IF WS-FREQ-CODE-LIT EQUAL 'M' THEN                           
              PERFORM 7900-OPEN-BILL-DATE-CSR                           
                 THRU 7900-OPEN-BILL-DATE-CSR-EXIT                      
              PERFORM 7905-FETCH-BILL-DATE-CSR                          
                 THRU 7905-FETCH-BILL-DATE-CSR-EXIT                     
              PERFORM 7910-CLOSE-BILL-DATE-CSR                          
                 THRU 7910-CLOSE-BILL-DATE-CSR-EXIT                     
           ELSE                                                         
              MOVE SPACES TO BN-DATE-EXTRACT                            
              MOVE ZEROES TO BN-REVENUE-MONTH                           
           END-IF.                                                      
       5900-NEXT-BILL-DATE-EXIT.                                        
           EXIT.                                                        
                                                                        
      ******************************************************************15200000
      *   5901-NEXT-READ-DATE.                                         *15210000
      ******************************************************************15280000
                                                                        
       5901-NEXT-READ-DATE.                                             
                                                                        
           PERFORM 7905-SELECT-RD-CYC                                   
              THRU 7905-SELECT-RD-CYC-EXIT.                             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF AT-BILL-CYCLE < UT-READ-CYCLE                          
                 PERFORM 7920-GET-NXT-RD-DT-FIA                         
                    THRU 7920-GET-NXT-RD-DT-FIA-EXIT                    
              ELSE                                                      
                 PERFORM 7910-SELECT-NXT-RD-DT                          
                    THRU 7910-SELECT-NXT-RD-DT-EXIT                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5901-NEXT-READ-DATE-EXIT.                                        
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-CALL-CPD00068                                             *        
      ******************************************************************        
                                                                        
       6000-CALL-CPD00068.                                              
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
                                             S-RETURN-CODE.             
           IF ABEND-FUNCTION  > SPACES                                  
               IF ABEND-FUNCTION EQUAL 'BADDATA'                        
                  MOVE -1                  TO S-RETURN-CODE,            
                                              WS-ACTIVE-RETURN-CODE     
               END-IF                                                   
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6010-REDUCE-EMBEDDED-SPACES                                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                         0000
              INCLUDE CPD00004                                              0000
           END-EXEC.                                                        0000
                                                                        
      *****************************************************************         
      * 6210-CALCULATE-CHECK-DIGIT                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                         0000
              INCLUDE CPD00071                                              0000
           END-EXEC.                                                        0000
                                                                        
      *****************************************************************         
      * 6302-GET-NEW-NAME-ID                                          *         
      * 6210-CALCULATE-CHECK-DIGIT                                    *         
      * 6304-LOCK-NAME-ID-CNTRL                                       *         
      * 6306-SELECT-NAME-ID-CNTL                                      *         
      * 6308-UPDATE-NAME-ID-CNTL                                      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************15660000
      * 6530-LOAD-MNT-TRANS-HIST                                       *15670000
      * 6540-INSERT-MNT-TRANS-HIST                                     *        
      * 6550-INSERT-MT-TRN-HST-DET                                     *        
      ******************************************************************15680000
                                                                        
           EXEC SQL                                                     15700000
              INCLUDE CPD00067                                          15710000
           END-EXEC.                                                    15720000
                                                                        
      ******************************************************************15740000
      * 7000-GET-PREVIOUS-DAYS.                                        *15750000
      * CALCULATES DATES USING ONLY WORK DAYS.                         *15810000
      ******************************************************************15830000
                                                                        
       7000-GET-PREVIOUS-DAYS.                                          
                                                                        
           MOVE 1 TO WS-ADJ-DAY                                         
           MOVE 1 TO WS-NUMBER-OF-DAYS                                  
           PERFORM UNTIL WS-NUMBER-OF-DAYS > WS-NUMBER-OF-DAYS-LIM      
              PERFORM 7031-GET-PREV-WORK-DAY THRU 7031-EXIT             
              EVALUATE SQLCODE                                          
                 WHEN SUCCESSFUL-CALL                                   
                    ADD 1 TO WS-ADJ-DAY                                 
                    ADD 1 TO WS-NUMBER-OF-DAYS                          
                 WHEN NOT-FOUND                                         
                    ADD 1 TO WS-ADJ-DAY                                 
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 18190000
      * 7010-SELECT-FROM-ACCOUNT                                      * 18200000
      *     SELECT ACCOUNT_BALANCE AND DATE_BILL FROM CSS_ACCOUNT.    * 18270000
      *     THEY WILL BE USED TO POPULATE AMT_NOTICE AND DATE_BILL    * 18280000
      *     IN CSS_CRED_COLL.                                         * 18290000
      ***************************************************************** 18310000
                                                                        
       7010-SELECT-FROM-ACCOUNT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT,                                
                     PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
                     TOTAL_AR_BALANCE,                                  
                     CREDIT_GROUP,                                      
                     CODE_TEMP_BILL,                                    
                     REV_MTH_LST_NRML,                                  
                     CODE_BILL_FREQ,                                    
                     BILL_CYCLE,                                        
                     NOTICE_EXEMPT_CD,                                  
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     BANKRUPTCY_IND,                                    
                     CODE_ACCT_STAT,                                    
                     IVR_EXEMPT_CD,                                     
                     REV_MTH_LST_NRML                                   
                INTO :AT-CODES-DATA-PRESENT,                            
                     :AT-PREMISE-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-CREDIT-GROUP,                                  
                     :AT-CODE-TEMP-BILL,                                
                     :AT-REV-MTH-LST-NRML,                              
                     :AT-CODE-BILL-FREQ,                                
                     :AT-BILL-CYCLE,                                    
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-DATE-BILL-DAY-00,                              
                     :AT-DATE-BILL-DAY-30,                              
                     :AT-DATE-BILL-DAY-60,                              
                     :AT-DATE-BILL-DAY-90,                              
                     :AT-COMPANY-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-CODE-ACCT-STAT,                                
                     :AT-IVR-EXEMPT-CD,                                 
                     :AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     18360000
MFA-TR*       SELECT CODES_DATA_PRESENT,                                18370000
MFA-TR*              PREMISE_NO,                                        18380000
MFA-TR*              CUSTOMER_NO,                                       18380000
MFA-TR*              TOTAL_AR_BALANCE,                                  18380000
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              CODE_TEMP_BILL,                                            
MFA-TR*              REV_MTH_LST_NRML,                                          
MFA-TR*              CODE_BILL_FREQ,                                            
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              NOTICE_EXEMPT_CD,                                          
MFA-TR*              DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90,                                          
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              BANKRUPTCY_IND,                                            
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              IVR_EXEMPT_CD,                                             
MFA-TR*              REV_MTH_LST_NRML                                           
MFA-TR*         INTO :AT-CODES-DATA-PRESENT,                            18400000
MFA-TR*              :AT-PREMISE-NO,                                    18410000
MFA-TR*              :AT-CUSTOMER-NO,                                   18410000
MFA-TR*              :AT-TOTAL-AR-BALANCE,                              18410000
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-CODE-TEMP-BILL,                                        
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-DATE-BILL-DAY-00,                                      
MFA-TR*              :AT-DATE-BILL-DAY-30,                                      
MFA-TR*              :AT-DATE-BILL-DAY-60,                                      
MFA-TR*              :AT-DATE-BILL-DAY-90,                                      
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :AT-REV-MTH-LST-NRML                                       
MFA-TR*         FROM CSS_ACCOUNT                                        18430000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        18440000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                    18450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DATE-BILL-00-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-00                     
                 MOVE ZEROES TO WS-DATE-BILL-00-NULL                    
              END-IF                                                    
              IF WS-DATE-BILL-30-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-30                     
                 MOVE ZEROES TO WS-DATE-BILL-30-NULL                    
              END-IF                                                    
              IF WS-DATE-BILL-60-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-60                     
                 MOVE ZEROES TO WS-DATE-BILL-60-NULL                    
              END-IF                                                    
              IF WS-DATE-BILL-90-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-90                     
                 MOVE ZEROES TO WS-DATE-BILL-90-NULL                    
              END-IF                                                    
           ELSE                                                         
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************15660000
      * 7030-GET-NEXT-WORK-DAY                                         *15670000
      * CALCULATES NEXT WORK DAY.                                      *15670000
      ******************************************************************15680000
                                                                        
       7030-GET-NEXT-WORK-DAY.                                          
                                                                        
           ADD 1 TO WS-ADJ-DAY                                          
                                                                        
           EXEC SQL                                                     
              SELECT DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                        :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) ) )           
                INTO :WS-WORK-DATE                                      
                FROM CSS_MODEL_SQL                                      
                WHERE CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) ) )) -                
                        (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2
              ) ) )) / 7 * 7) BETWEEN 1 AND 5 
                  AND NOT EXISTS                                        
                       (SELECT HOLIDAY_DT                               
                          FROM CSS_HOLIDAY                              
                          WHERE COMPANY_NO = '01'                       
                            AND HOLIDAY_DT =                            
                                DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) ) ))                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-HOLD-DATE-2) + :WS-ADJ-DAY DAYS                   
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WHERE DAYS(DATE(:WS-HOLD-DATE-2)                                
MFA-TR*                            + :WS-ADJ-DAY DAYS) -                        
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-HOLD-DATE-2)                     
MFA-TR*                   + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                (SELECT HOLIDAY_DT                                       
MFA-TR*                   FROM CSS_HOLIDAY                                      
MFA-TR*                   WHERE COMPANY_NO = '01'                               
MFA-TR*                     AND HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-HOLD-DATE-2) +                         
MFA-TR*                                :WS-ADJ-DAY DAYS)                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7030'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'WS-HOLD-DATE-2'           TO TABLE-ELEMENT-1        
              MOVE WS-HOLD-DATE-2             TO HOSTVAR-ELEMENT-1      
              MOVE 'WS-ADJ-DAY'               TO TABLE-ELEMENT-1        
              MOVE WS-ADJ-DAY                 TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15660000
      * 7031-GET-PREV-WORK-DAY                                         *        
      * CALCULATES PREVIOUS WORK DAY.                                  *15670000
      ******************************************************************15680000
                                                                        
       7031-GET-PREV-WORK-DAY.                                          
           EXEC SQL                                                     
              SELECT DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                        :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) ) )           
                INTO :WS-WORK-DATE                                      
                FROM CSS_MODEL_SQL                                      
                WHERE CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) ) )) -                
                        (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) )
               )) / 7 * 7) BETWEEN 1 AND 5 
                  AND NOT EXISTS                                        
                       (SELECT HOLIDAY_DT                               
                          FROM CSS_HOLIDAY                              
                          WHERE COMPANY_NO = '01'                       
                            AND HOLIDAY_DT =                            
                                DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-2
              ) <> 0) OR (LEN(:WS-HOLD-DATE-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-HOLD-DATE-2
              ), CONVERT(DATE, :WS-HOLD-DATE-2) ) ))                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-HOLD-DATE-2) - :WS-ADJ-DAY DAYS                   
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WHERE DAYS(DATE(:WS-HOLD-DATE-2)                                
MFA-TR*                            - :WS-ADJ-DAY DAYS) -                        
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-HOLD-DATE-2)                     
MFA-TR*                   - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                (SELECT HOLIDAY_DT                                       
MFA-TR*                   FROM CSS_HOLIDAY                                      
MFA-TR*                   WHERE COMPANY_NO = '01'                               
MFA-TR*                     AND HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-HOLD-DATE-2) -                         
MFA-TR*                                :WS-ADJ-DAY DAYS)                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7031'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'WS-HOLD-DATE-2'           TO TABLE-ELEMENT-1        
              MOVE WS-HOLD-DATE-2             TO HOSTVAR-ELEMENT-1      
              MOVE 'WS-ADJ-DAY'               TO TABLE-ELEMENT-1        
              MOVE WS-ADJ-DAY                 TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7031-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7100-MED-INFO-EXISTS.                                          *15750000
      * SELECTS CSS_CUST_ALERT - CHECKS TO SEE IF THE MED INFO ALREADY *15810000
      * EXISTS.                                                        *15820000
      ******************************************************************15830000
                                                                        
       7100-MED-INFO-EXISTS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT DATE_ALERT                                         
                    ,DATE_EXPIRE                                        
                    ,PATIENT_NAME_ID                                    
                    ,PHYSICIAN_ID                                       
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), CUST_ALERT_SEQ_NO
           , 121), ' ', '-'), ':', '.') CUST_ALERT_SEQ_NO                      
                INTO :WS-DATE-ALERT-OLD :WS-NULL-IND1                   
                    ,:WS-DATE-EXPIRE-OLD :WS-NULL-IND2                   
P0726B              ,:WS-PATIENT-NAME-ID-OLD :WS-PTNT-NAME-ID-NULL      
P0726B              ,:WS-PHYSICIAN-ID-OLD :WS-PHYSICIAN-ID-NULL      
                    ,:WS-CUST-ALERT-SEQ-OLD                             
                FROM CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO  = :CA-ACCOUNT-NO                       
                 AND DATE_ALERT  = CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-ALERT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-ALERT
              ) <> 0) OR (LEN(:WS-DATE-ALERT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-ALERT
              ), CONVERT(DATE, :WS-DATE-ALERT) ),'ISO')       
                 AND DATE_EXPIRE >= CAST(SYSDATETIMEOFFSET() AS DATE)           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT DATE_ALERT                                         15920000
MFA-TR*             ,DATE_EXPIRE                                        15920000
MFA-TR*             ,PATIENT_NAME_ID                                            
MFA-TR*             ,PHYSICIAN_ID                                               
MFA-TR*             ,CUST_ALERT_SEQ_NO                                          
MFA-TR*         INTO :WS-DATE-ALERT-OLD :WS-NULL-IND1                   16390000
MFA-TR*             ,:WS-DATE-EXPIRE-OLD:WS-NULL-IND2                   16400000
MFA-TR*             ,:WS-PATIENT-NAME-ID-OLD :WS-PTNT-NAME-ID-NULL      16400000
MFA-TR*             ,:WS-PHYSICIAN-ID-OLD    :WS-PHYSICIAN-ID-NULL      16400000
MFA-TR*             ,:WS-CUST-ALERT-SEQ-OLD                             16400000
MFA-TR*         FROM CSS_CUST_ALERT                                     15940000
MFA-TR*        WHERE ACCOUNT_NO  = :CA-ACCOUNT-NO                       15950000
MFA-TR*          AND DATE_ALERT  = CHAR(DATE(:WS-DATE-ALERT),ISO)       15960000
MFA-TR*          AND DATE_EXPIRE >= CURRENT DATE                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 IF WS-NULL-IND1 < 0                                    
                    MOVE SPACES             TO WS-DATE-ALERT-OLD        
                    MOVE ZEROES             TO WS-NULL-IND1             
                 END-IF                                                 
                 IF WS-NULL-IND2 < 0                                    
                    MOVE SPACES             TO WS-DATE-EXPIRE-OLD       
                    MOVE ZEROES             TO WS-NULL-IND2             
                 END-IF                                                 
P0726B           IF WS-PTNT-NAME-ID-NULL < 0                            
P0726B              MOVE ZEROES             TO WS-PATIENT-NAME-ID-OLD   
P0726B                                         WS-PTNT-NAME-ID-NULL     
P0726B           END-IF                                                 
P0726B           IF WS-PHYSICIAN-ID-NULL < 0                            
P0726B              MOVE ZEROES             TO WS-PHYSICIAN-ID-OLD      
P0726B                                         WS-PHYSICIAN-ID-NULL     
P0726B           END-IF                                                 
                 MOVE WS-Y                  TO WS-MED-INFO-EXISTS       
            WHEN NOT-FOUND                                              
                 MOVE SPACES                TO WS-DATE-ALERT-OLD        
                                               WS-DATE-EXPIRE-OLD       
                 MOVE WS-N                  TO WS-MED-INFO-EXISTS       
                 MOVE ZEROES                TO WS-PATIENT-NAME-ID-OLD   
                                               WS-PHYSICIAN-ID-OLD      
            WHEN OTHER                                                  
                 MOVE '7100'                TO ACTIVE-PARAGRAPH         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_CUST_ALERT'      TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE 'DATE_ALERT'          TO TABLE-ELEMENT-2          
                 MOVE CA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
                 MOVE WS-DATE-ALERT         TO HOSTVAR-ELEMENT-2        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 15740000
      * 7110-SEL-PHY-FMT-ADDR.                                        * 15750000
      ***************************************************************** 15830000
                                                                        
       7110-SEL-PHY-FMT-ADDR.                                           
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     HOUSE_NO                                           
                    ,ADDR_PREFIX_1                                      
                    ,ADDR_PREFIX_2                                      
                    ,STREET_NAME                                        
                    ,STREET_LOCATION_1                                  
                    ,STREET_LOCATION_2                                  
                    ,STREET_SUFFIX                                      
                    ,ADDRESS_OVERFLOW                                   
                    ,ZIP_CODE                                           
                    ,ZIP_CODE_PLUS_FOUR                                 
                INTO :DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ADDRESS-OVERFLOW                               
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT                                                    15920000
MFA-TR*              HOUSE_NO                                                   
MFA-TR*             ,ADDR_PREFIX_1                                              
MFA-TR*             ,ADDR_PREFIX_2                                              
MFA-TR*             ,STREET_NAME                                                
MFA-TR*             ,STREET_LOCATION_1                                          
MFA-TR*             ,STREET_LOCATION_2                                          
MFA-TR*             ,STREET_SUFFIX                                              
MFA-TR*             ,ADDRESS_OVERFLOW                                           
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*             ,ZIP_CODE_PLUS_FOUR                                         
MFA-TR*         INTO :DY-HOUSE-NO                                       15930000
MFA-TR*             ,:DY-ADDR-PREFIX-1                                  15930000
MFA-TR*             ,:DY-ADDR-PREFIX-2                                  15930000
MFA-TR*             ,:DY-STREET-NAME                                    15930000
MFA-TR*             ,:DY-STREET-LOCATION-1                              15930000
MFA-TR*             ,:DY-STREET-LOCATION-2                              15930000
MFA-TR*             ,:DY-STREET-SUFFIX                                  15930000
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                               15930000
MFA-TR*             ,:DY-ZIP-CODE                                       15930000
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                             15930000
MFA-TR*         FROM CSS_ADDR_FORMATTED DY                              15940000
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                        15950000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
              MOVE DY-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15740000
      * 7120-SEL-PHY-FF-ADDR.                                         * 15750000
      ***************************************************************** 15830000
                                                                        
       7120-SEL-PHY-FF-ADDR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     ADDR_STREET                                        
                    ,ADDRESS_OVERFLOW                                   
                INTO :DZ-ADDR-STREET                                    
                    ,:DZ-ADDRESS-OVERFLOW                               
                FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED)                 
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT                                                    15920000
MFA-TR*              ADDR_STREET                                                
MFA-TR*             ,ADDRESS_OVERFLOW                                           
MFA-TR*         INTO :DZ-ADDR-STREET                                    15930000
MFA-TR*             ,:DZ-ADDRESS-OVERFLOW                               15930000
MFA-TR*         FROM CSS_ADDR_FREEFORM DZ                               15940000
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        15950000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ADDR_FREEFORM'        TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
              MOVE DZ-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7130-GET-PHYSICIAN-DETAILS                                      11850000
      ******************************************************************11920000
                                                                        
       7130-GET-PHYSICIAN-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT PY.MED_LIC_STATE_CD                                
                    ,PY.MED_LICENSE_NO                                  
                    ,PY.NAME_ID                                         
                    ,PA.ADDRESS_ID                                      
                    ,PA.ADDRESS_FORMAT                                  
                INTO :PY-MED-LIC-STATE-CD                               
                    ,:PY-MED-LICENSE-NO                                 
                    ,:PY-NAME-ID                                        
                    ,:PA-ADDRESS-ID                                     
                    ,:PA-ADDRESS-FORMAT                                 
                FROM CSS_PHYSICIAN      PY WITH(READUNCOMMITTED)                
                    ,CSS_PHYSICIAN_ATTR PA WITH(READUNCOMMITTED)                
               WHERE PY.PHYSICIAN_ID = PA.PHYSICIAN_ID                  
                 AND PY.PHYSICIAN_ID = :PY-PHYSICIAN-ID                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT PY.MED_LIC_STATE_CD                                        
MFA-TR*             ,PY.MED_LICENSE_NO                                          
MFA-TR*             ,PY.NAME_ID                                                 
MFA-TR*             ,PA.ADDRESS_ID                                              
MFA-TR*             ,PA.ADDRESS_FORMAT                                          
MFA-TR*         INTO :PY-MED-LIC-STATE-CD                               12000000
MFA-TR*             ,:PY-MED-LICENSE-NO                                 12000000
MFA-TR*             ,:PY-NAME-ID                                                
MFA-TR*             ,:PA-ADDRESS-ID                                             
MFA-TR*             ,:PA-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_PHYSICIAN      PY                              12010000
MFA-TR*             ,CSS_PHYSICIAN_ATTR PA                              12010000
MFA-TR*        WHERE PY.PHYSICIAN_ID = PA.PHYSICIAN_ID                  12020000
MFA-TR*          AND PY.PHYSICIAN_ID = :PY-PHYSICIAN-ID                 12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7130'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PHYSICIAN'            TO TABLE-1                
              MOVE 'PHYSICIAN_ID'             TO TABLE-ELEMENT-1        
              MOVE PY-PHYSICIAN-ID            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7140-GET-PHY-PTNT-NAME                                          11850000
      ******************************************************************11920000
                                                                        
       7140-GET-PHY-PTNT-NAME.                                          
                                                                        
           EXEC SQL                                                     
               SELECT DQ.FIRST_NAME                                     
                     ,DQ.MIDDLE_NAME                                    
                     ,DQ.LAST_NAME                                      
                     ,DQ.TITLE_PREFIX                                   
                     ,DQ.TITLE_SUFFIX_1                                 
                 INTO :DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-LAST-NAME                                     
                     ,:DQ-TITLE-PREFIX                                  
                     ,:DQ-TITLE-SUFFIX-1                                
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE DQ.NAME_ID = :DQ-NAME-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*        SELECT DQ.FIRST_NAME                                             
MFA-TR*              ,DQ.MIDDLE_NAME                                            
MFA-TR*              ,DQ.LAST_NAME                                              
MFA-TR*              ,DQ.TITLE_PREFIX                                           
MFA-TR*              ,DQ.TITLE_SUFFIX_1                                         
MFA-TR*          INTO :DQ-FIRST-NAME                                            
MFA-TR*              ,:DQ-MIDDLE-NAME                                           
MFA-TR*              ,:DQ-LAST-NAME                                             
MFA-TR*              ,:DQ-TITLE-PREFIX                                          
MFA-TR*              ,:DQ-TITLE-SUFFIX-1                                        
MFA-TR*          FROM CSS_NAME DQ                                               
MFA-TR*         WHERE DQ.NAME_ID = :DQ-NAME-ID                                  
MFA-TR*           WITH UR                                                       
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7140'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
              MOVE DQ-NAME-ID                 TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7160-CHECK-REGULATED.                                          *15750000
      * SELECTS CSS_REG_PROFILE TO SEE IF ACCOUNT IS A SEB REGUALTED   *15810000
      * ACCOUNT                                                        *15820000
      ******************************************************************15830000
                                                                        
       7160-CHECK-REGULATED.                                            
                                                                        
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7160                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE 'Y' TO WS-SEB-REG-FLAG                          
               END-IF                                                   
           ELSE                                                         
              MOVE '7160'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_REG_PROFILE'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE LR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7200-LIMIT-2-MED-CERTS.                                        *15750000
      * SELECTS CSS_CUST_ALERT - CHECKS TO SEE IF THERE ARE 2          *15810000
      * MED CERTS IN THE PAST 12 MONTHS.                               *15820000
      ******************************************************************15830000
                                                                        
       7200-LIMIT-2-MED-CERTS.                                          
                                                                        
           PERFORM 7205-GET-12-MONTHS-PAST THRU 7205-EXIT.              
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-NO                                     
                FROM CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                        
                 AND DATE_EXPIRE > IIF(TRY_CONVERT(DATE, 
                                           :WS-CURRENT-DATE-MINUS-12MOS
              ) IS NULL OR (PATINDEX('%.%', 
                                           :WS-CURRENT-DATE-MINUS-12MOS
              ) <> 0) OR (LEN(:WS-CURRENT-DATE-MINUS-12MOS
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE-MINUS-12MOS
              ), CONVERT(DATE, :WS-CURRENT-DATE-MINUS-12MOS) )         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT ACCOUNT_NO                                         15920000
MFA-TR*         INTO :WS-ACCOUNT-NO                                     15930000
MFA-TR*         FROM CSS_CUST_ALERT                                     15940000
MFA-TR*        WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                        15950000
MFA-TR*          AND DATE_EXPIRE > :WS-CURRENT-DATE-MINUS-12MOS         15960000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = -811                           
                 MOVE 500 TO S-RETURN-CODE                              
              ELSE                                                      
                 MOVE '7200'                        TO ACTIVE-PARAGRAPH 
                 MOVE PROGRAM-NAME                  TO ABEND-PROGRAM    
                 MOVE 'SELECT'                      TO ABEND-FUNCTION   
                 MOVE 'CSS_CUST_ALERT'              TO TABLE-1          
                 MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1  
                 MOVE 'WS-CURRENT-DATE-MINUS-12MOS' TO TABLE-ELEMENT-2  
                 MOVE CA-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1
                 MOVE WS-CURRENT-DATE-MINUS-12MOS   TO HOSTVAR-ELEMENT-2
                 PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT      
                 PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7205-GET-12-MONTHS-PAST.                                       *15750000
      * RETRIEVES CURRENT DATE MINUS 12 MONTHS.                        *15810000
      ******************************************************************15830000
                                                                        
       7205-GET-12-MONTHS-PAST.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              (DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) ))
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-DATE-MINUS-12MOS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE,                              
MFA-TR*           :WS-CURRENT-DATE-MINUS-12MOS =                                
MFA-TR*                       (CURRENT DATE - 12 MONTHS)                        
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7205'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7210-SEL-FORECAST.                                             *15750000
      * SELECTS DATES FROM CSS_CRED_FORECAST.                          *15780000
      *****************************************************************&15830000
                                                                        
       7210-SEL-FORECAST.                                               
                                                                        
           MOVE ZEROES                TO WS-NULL-IND5                   
                                         WS-NULL-IND6                   
                                         WS-NULL-IND7                   
                                         WS-NULL-IND8                   
                                         WS-NULL-IND9                   
                                         WS-NULL-IND10                  
                                         WS-NULL-IND11.                 
           EXEC SQL                                                     
              SELECT CM.DNP_DT,                                         
                     CM.ARREARS_DUE_DT,                                 
                     CM.DNP_NOTICE_MAIL_DT,                             
                     CM.DNP_NOTICE_DUE_DT,                              
                     CM.IVR_CALL_DT,                                    
                     CM.NONUTIL_WQ_DT,                                  
                     CM.DNP_REVIEW_DT                                   
                INTO :CM-DNP-DT :WS-NULL-IND11,                         
                     :CM-ARREARS-DUE-DT :WS-NULL-IND5,                  
                     :CM-DNP-NOTICE-MAIL-DT :WS-NULL-IND6,              
                     :CM-DNP-NOTICE-DUE-DT :WS-NULL-IND7,               
                     :CM-IVR-CALL-DT :WS-NULL-IND8,                     
                     :CM-NONUTIL-WQ-DT :WS-NULL-IND9,                   
                     :CM-DNP-REVIEW-DT :WS-NULL-IND10                   
                FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                 
               WHERE CM.COMPANY_NO         = :CM-COMPANY-NO             
                 AND CM.BILL_CYCLE         = :CM-BILL-CYCLE             
                 AND CM.CRED_FORECAST_CD   = :CM-CRED-FORECAST-CD       
                 AND CM.DNP_DT             > IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXPIRE
              ) <> 0) OR (LEN(:WS-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-EXPIRE
              ), CONVERT(DATE, :WS-DATE-EXPIRE) )            
                 AND CM.DNP_DT             > IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )           
                 AND CM.DNP_DT =                                        
                    (SELECT MIN (CM1.DNP_DT)                            
                       FROM CSS_CRED_FORECAST CM1 WITH(READUNCOMMITTED)         
                      WHERE CM1.COMPANY_NO        = :CM-COMPANY-NO      
                        AND CM1.BILL_CYCLE        = :CM-BILL-CYCLE      
                        AND CM1.CRED_FORECAST_CD  = :CM-CRED-FORECAST-CD
                        AND CM1.DNP_DT            > 
              IIF(TRY_CONVERT(DATE, :WS-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXPIRE
              ) <> 0) OR (LEN(:WS-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-EXPIRE
              ), CONVERT(DATE, :WS-DATE-EXPIRE) )     
                        AND CM1.DNP_DT            > 
              IIF(TRY_CONVERT(DATE, :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) ))   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CM.DNP_DT,                                                 
MFA-TR*              CM.ARREARS_DUE_DT,                                         
MFA-TR*              CM.DNP_NOTICE_MAIL_DT,                                     
MFA-TR*              CM.DNP_NOTICE_DUE_DT,                                      
MFA-TR*              CM.IVR_CALL_DT,                                            
MFA-TR*              CM.NONUTIL_WQ_DT,                                          
MFA-TR*              CM.DNP_REVIEW_DT                                           
MFA-TR*         INTO :CM-DNP-DT :WS-NULL-IND11,                                 
MFA-TR*              :CM-ARREARS-DUE-DT :WS-NULL-IND5,                          
MFA-TR*              :CM-DNP-NOTICE-MAIL-DT :WS-NULL-IND6,                      
MFA-TR*              :CM-DNP-NOTICE-DUE-DT :WS-NULL-IND7,                       
MFA-TR*              :CM-IVR-CALL-DT :WS-NULL-IND8,                             
MFA-TR*              :CM-NONUTIL-WQ-DT :WS-NULL-IND9,                           
MFA-TR*              :CM-DNP-REVIEW-DT :WS-NULL-IND10                           
MFA-TR*         FROM CSS_CRED_FORECAST CM                                       
MFA-TR*        WHERE CM.COMPANY_NO         = :CM-COMPANY-NO                     
MFA-TR*          AND CM.BILL_CYCLE         = :CM-BILL-CYCLE                     
MFA-TR*          AND CM.CRED_FORECAST_CD   = :CM-CRED-FORECAST-CD               
MFA-TR*          AND CM.DNP_DT             > :WS-DATE-EXPIRE                    
MFA-TR*          AND CM.DNP_DT             > :BN-DATE-EXTRACT                   
MFA-TR*          AND CM.DNP_DT =                                                
MFA-TR*             (SELECT MIN (CM1.DNP_DT)                                    
MFA-TR*                FROM CSS_CRED_FORECAST CM1                               
MFA-TR*               WHERE CM1.COMPANY_NO        = :CM-COMPANY-NO              
MFA-TR*                 AND CM1.BILL_CYCLE        = :CM-BILL-CYCLE              
MFA-TR*                 AND CM1.CRED_FORECAST_CD  = :CM-CRED-FORECAST-CD        
MFA-TR*                 AND CM1.DNP_DT            > :WS-DATE-EXPIRE             
MFA-TR*                 AND CM1.DNP_DT            > :BN-DATE-EXTRACT)           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS                  
                 MOVE ZEROES                    TO S-RETURN-CODE        
                                                   WS-ACTIVE-RETURN-CODE
              ELSE                                                      
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      MOVE 700                  TO S-RETURN-CODE        
                                                   WS-ACTIVE-RETURN-CODE
                   END-IF                                               
                   MOVE '7210'                     TO ACTIVE-PARAGRAPH  
                   MOVE PROGRAM-NAME               TO ABEND-PROGRAM     
                   MOVE 'SELECT'                   TO ABEND-FUNCTION    
                   MOVE 'CSS_CRED_FORECAST'        TO TABLE-1           
                   MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1   
                   MOVE CM-COMPANY-NO              TO HOSTVAR-ELEMENT-1 
                   MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-2   
                   MOVE CM-BILL-CYCLE              TO HOSTVAR-ELEMENT-2 
                   MOVE 'CRED_FORECAST_CD'         TO TABLE-ELEMENT-3   
                   MOVE CM-CRED-FORECAST-CD        TO HOSTVAR-ELEMENT-3 
                   MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4   
                   MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-4 
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND5 < 0                                          
              MOVE SPACES                   TO CM-ARREARS-DUE-DT        
           END-IF.                                                      
           IF WS-NULL-IND7 < 0                                          
              MOVE SPACES                   TO CM-DNP-NOTICE-DUE-DT     
           END-IF.                                                      
           IF WS-NULL-IND8 < 0                                          
              MOVE SPACES                   TO CM-IVR-CALL-DT           
           END-IF.                                                      
           IF WS-NULL-IND9 < 0                                          
              MOVE SPACES                   TO CM-NONUTIL-WQ-DT         
           END-IF.                                                      
           IF WS-NULL-IND10 < 0                                         
              MOVE SPACES                   TO CM-DNP-REVIEW-DT         
           END-IF.                                                      
           IF WS-NULL-IND11 < 0                                         
              MOVE SPACES                   TO CM-DNP-DT                
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7253-CALCULATE-DATES.                                          *15750000
      *     CALCULATES DATES BASED ON THE OPTIMUM READ DATE.           *15810000
      *     WS-SECOND-NOTICE-DATE AND WS-DNP-DATE WERE PASSED FROM     *15810000
      *     POWERBUILDER.  THESE DATES ARE RECALCULATED BELOW TO       *        
      *     CONTAIN THE CORRECT DATES FOR SEB ACCOUNTS.                *        
      *     CALCULATE DNP DATE FIRST.  THEN CALC 2ND NOTICE MAIL DATE  *        
      *     USING DAY-SEDOND-MAIL FROM CSS_DELINQUENCY.  THIS VALUE    *        
      *     WILL BE THE NUMBER OF DAYS PRIOR TO DNP DATE.              *        
      ******************************************************************15830000
       7253-CALCULATE-DATES.                                            
                                                                        
           MOVE RW-OPTIMUM-READ-DATE      TO WS-HOLD-DATE-2.            
           MOVE WS-DAY-AGL-DNP            TO WS-NUMBER-OF-DAYS-LIM.     
           PERFORM 7000-GET-PREVIOUS-DAYS THRU 7000-EXIT.               
           MOVE WS-WORK-DATE              TO WS-DNP-DATE.               
                                                                        
           MOVE WS-DNP-DATE               TO WS-HOLD-DATE-2.            
           MOVE 1                         TO WS-NUMBER-OF-DAYS-LIM.     
           PERFORM 7000-GET-PREVIOUS-DAYS THRU 7000-EXIT.               
           MOVE WS-WORK-DATE              TO WS-DATE-NOTICE-DUE.        
                                                                        
           MOVE WS-DNP-DATE               TO WS-HOLD-DATE-2.            
           MOVE WS-DAY-SECOND-MAIL        TO WS-NUMBER-OF-DAYS-LIM.     
           PERFORM 7000-GET-PREVIOUS-DAYS THRU 7000-EXIT.               
           MOVE WS-WORK-DATE              TO WS-SECOND-NOTICE-DATE.     
                                                                        
       7253-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7300-GET-DEL-VALUES.                                           *15750000
      * SELECTS VALUES FROM CSS_DELINQUENCY.                           *15810000
      ******************************************************************15830000
                                                                        
       7300-GET-DEL-VALUES.                                             
                                                                        
           MOVE 'DAY-AGL-DNP' TO C8-DELINQ-CD.                          
           PERFORM 7350-GET-DEL-VALUES THRU 7350-EXIT.                  
           MOVE C8-DELINQ-VALUE TO WS-DAY-AGL-DNP.                      
                                                                        
           MOVE 'DAY-SECOND-MAIL' TO C8-DELINQ-CD.                      
           PERFORM 7350-GET-DEL-VALUES THRU 7350-EXIT.                  
           MOVE C8-DELINQ-VALUE TO WS-DAY-SECOND-MAIL.                  
                                                                        
           MOVE 'AMT-NONUTIL-WQ-MIN' TO C8-DELINQ-CD.                   
           PERFORM 7350-GET-DEL-VALUES THRU 7350-EXIT.                  
           MOVE C8-DELINQ-VALUE TO WS-AMT-NONUTIL-WQ-MIN.               
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15740000
      * 7350-RETRIEVE-DEL.                                             *15750000
      * SELECTS VALUES FROM CSS_DELINQUENCY.                           *15810000
      ******************************************************************15830000
                                                                        
       7350-GET-DEL-VALUES.                                             
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT DELINQ_VALUE                                       15920000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15930000
MFA-TR*         FROM CSS_DELINQUENCY                                    15940000
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                          15950000
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'C8-DELINQ-CD'             TO TABLE-ELEMENT-1        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22900200
      * 7500-GET-OLD-MED-CERT.                                         *22900300
      * SELECTS THE CUST ALERT SEQ NO OF THE LATEST MEDICAL CERTIFICATE*22900900
      ******************************************************************22901100
                                                                        
       7500-GET-OLD-MED-CERT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           CUST_ALERT_SEQ_NO), 121), ' ', '-'), ':', '.')                      
                INTO :WS-CUST-ALERT-SEQ-NO                              
                FROM CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     22901600
MFA-TR*       SELECT MAX(CUST_ALERT_SEQ_NO)                             22901700
MFA-TR*         INTO :WS-CUST-ALERT-SEQ-NO                              22901800
MFA-TR*         FROM CSS_CUST_ALERT                                     22901900
MFA-TR*        WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                        22902000
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                    22902500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_ALERT'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *******************************************************************       
        7510-GET-1DAY-PRIOR-DATE.                                       
      *******************************************************************       
                                                                        
           PERFORM 7520-GET-PRIOR-DAY                                   
               VARYING WS-DATE-CTR FROM 1 BY 1                          
               UNTIL (WS-DAY NOT EQUAL ZEROES AND WS-DAY NOT EQUAL 6).  
                                                                        
           MOVE WS-HOLD-EXP-DATE TO WS-DATE-CALC.                       
           MOVE WS-HOLD-EXP-DATE TO J8-HOLIDAY-DT.                      
                                                                        
           PERFORM 7530-SELECT-HOLIDAY.                                 
                                                                        
           MOVE ZEROES TO WS-DAY.                                       
                                                                        
      *******************************************************************       
        7520-GET-PRIOR-DAY.                                             
      *******************************************************************       
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT(DATEADD( DAY, -:WS-DATE-CTR, 
              IIF(TRY_CONVERT(DATE, :WS-DATE-CALC
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC
              ) <> 0) OR (LEN(:WS-DATE-CALC) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-CALC
              ), CONVERT(DATE, :WS-DATE-CALC) ) )),                            
                   CIS.DAYS (DATEADD( DAY, -:WS-DATE-CTR, 
              IIF(TRY_CONVERT(DATE, :WS-DATE-CALC
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC
              ) <> 0) OR (LEN(:WS-DATE-CALC) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-CALC
              ), CONVERT(DATE, :WS-DATE-CALC) ) )) -                           
                   (CIS.DAYS(DATEADD( DAY, -:WS-DATE-CTR, 
              IIF(TRY_CONVERT(DATE, :WS-DATE-CALC
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC
              ) <> 0) OR (LEN(:WS-DATE-CALC) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-CALC
              ), CONVERT(DATE, :WS-DATE-CALC) ) ))/7 * 7)                      
               INTO :WS-HOLD-EXP-DATE,                                  
                   :WS-DAY                                              
               FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT(DATE(:WS-DATE-CALC) -                            
MFA-TR*            :WS-DATE-CTR DAYS),                                          
MFA-TR*            DAYS (DATE(:WS-DATE-CALC) -                                  
MFA-TR*            :WS-DATE-CTR DAYS) -                                         
MFA-TR*            (INTEGER(DAYS(DATE(:WS-DATE-CALC) -                          
MFA-TR*            :WS-DATE-CTR DAYS)/7) * 7)                                   
MFA-TR*        INTO :WS-HOLD-EXP-DATE,                                          
MFA-TR*            :WS-DAY                                                      
MFA-TR*        FROM CSS_HOLIDAY                                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               MOVE '7520' TO ACTIVE-PARAGRAPH                          
               MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
               MOVE 'SELECT' TO ABEND-FUNCTION                          
               MOVE 'CSS_HOLIDAY' TO TABLE-1                            
               MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                     
               MOVE 'CUST_ALERT_SEQ_NO' TO TABLE-ELEMENT-2              
               MOVE 'WS-DATE-CALC' TO TABLE-ELEMENT-3                   
               MOVE 'WS-HOLD-EXP-DATE' TO TABLE-ELEMENT-4               
               MOVE CA-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                  
               MOVE WS-CUST-ALERT-SEQ-NO TO HOSTVAR-ELEMENT-2           
               MOVE WS-DATE-CALC TO HOSTVAR-ELEMENT-3                   
               MOVE WS-HOLD-EXP-DATE TO HOSTVAR-ELEMENT-4               
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *******************************************************************       
        7530-SELECT-HOLIDAY.                                            
      *******************************************************************       
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT ('Y')                                    
                   INTO :WS-ROW-EXISTS                                  
                   FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                       
                   WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT ('Y')                                            
MFA-TR*            INTO :WS-ROW-EXISTS                                          
MFA-TR*            FROM CSS_HOLIDAY                                             
MFA-TR*            WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7530                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               SET PREV-BUSINESS-DAY-NOT-FOUND TO TRUE                  
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   ADD 1 TO WS-CTR-DAY-NO                               
                   IF WS-CTR-DAY-NO EQUAL WS-HOLD-DAY-NO                
                       SET PREV-BUSINESS-DAY-FOUND TO TRUE              
                       MOVE ZEROES TO WS-CTR-DAY-NO                     
                   ELSE                                                 
                       SET PREV-BUSINESS-DAY-NOT-FOUND TO TRUE          
                   END-IF                                               
               ELSE                                                     
                   MOVE '7530' TO ACTIVE-PARAGRAPH                      
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE 'SELECT' TO ABEND-FUNCTION                      
                   MOVE 'CSS_HOLIDAY' TO TABLE-1                        
                   MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                 
                   MOVE 'CUST_ALERT_SEQ_NO' TO TABLE-ELEMENT-2          
                   MOVE 'J8-HOLIDAY-DT' TO TABLE-ELEMENT-3              
                   MOVE 'WS-HOLD-EXP-DATE' TO TABLE-ELEMENT-4           
                   MOVE CA-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   MOVE WS-CUST-ALERT-SEQ-NO TO HOSTVAR-ELEMENT-2       
                   MOVE J8-HOLIDAY-DT TO HOSTVAR-ELEMENT-3              
                   MOVE WS-HOLD-EXP-DATE TO HOSTVAR-ELEMENT-4           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
      ******************************************************************17500000
      * 7800-SELECT-TIMESTAMP-DATE                                     *17520000
      ******************************************************************17570000
                                                                        
       7800-SELECT-TIMESTAMP-DATE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17610000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP,                    
MFA-TR*           :MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                    17670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17840000
      * 7802-SELECT-RESP-AREA                                          *17850000
      ******************************************************************17900000
                                                                        
       7802-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PF-USER-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17950000
MFA-TR*       SELECT RESP_AREA_ID                                       17960000
MFA-TR*         INTO :PF-RESP-AREA-ID                                   17970000
MFA-TR*         FROM CSS_USER_PROFILE                                   17980000
MFA-TR*        WHERE USER_ID = :PF-USER-ID                              17990000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7802                                                    
MFA-TR*    END-EXEC.                                                    18000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7802'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7802-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************18190000
      ** OPEN CURSOR TO CSS_BILL_WINDOW FOR MONTHLY BILLED ACCOUNTS    *        
      *****************************************************************         
                                                                        
       7900-OPEN-BILL-DATE-CSR.                                         
                                                                        
           MOVE '7900' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE MTH_BILL_DATE_CSR CURSOR FOR                      
               SELECT MIN (DATE_EXTRACT), REVENUE_MONTH                 
                 FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                WHERE BILL_CYCLE    = :BN-BILL-CYCLE                    
                AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) )                       
                AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                
                GROUP BY DATE_EXTRACT, REVENUE_MONTH                    
                ORDER BY REVENUE_MONTH ASC
            OPTION(FAST 1)
            FOR READ ONLY
                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MTH_BILL_DATE_CSR CURSOR FOR                              
MFA-TR*        SELECT MIN (DATE_EXTRACT), REVENUE_MONTH                         
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE BILL_CYCLE    = :BN-BILL-CYCLE                            
MFA-TR*         AND DATE_EXTRACT >= :WS-READ-DATE                               
MFA-TR*         AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                        
MFA-TR*         GROUP BY DATE_EXTRACT, REVENUE_MONTH                            
MFA-TR*         ORDER BY REVENUE_MONTH ASC                                      
MFA-TR*         OPTIMIZE FOR 1 ROW                                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              OPEN MTH_BILL_DATE_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE '7900' TO ACTIVE-PARAGRAPH                           
              MOVE 'OPEN CURSOR' TO ABEND-FUNCTION                      
              MOVE SPACES TO ABEND-SQL-PREDICATES                       
                                     ABEND-TABLES                       
              MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7900-OPEN-BILL-DATE-CSR-EXIT.                                    
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7905- FIND THE MINIMUM VALID READ CYCLE FOR A GIVEN ACCOUNT    *        
      ******************************************************************        
                                                                        
       7905-SELECT-RD-CYC.                                              
                                                                        
           MOVE '7905' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
               SELECT MIN(READ_CYCLE)                                   
                 INTO :UT-READ-CYCLE :WS-NULL-IND-CPD                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND READ_CYCLE IS NOT NULL                            
                  AND READ_CYCLE <> '  '                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN(READ_CYCLE)                                           
MFA-TR*          INTO :UT-READ-CYCLE:WS-NULL-IND-CPD                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND READ_CYCLE IS NOT NULL                                    
MFA-TR*           AND READ_CYCLE <> '  '                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7905                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-CPD < ZERO                                 
                 MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE                
                 MOVE 0         TO WS-NULL-IND-CPD                      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7905-SELECT-RD-CYC-EXIT.                                         
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  FETCH CURSOR TO CSS_BILL_WINDOW FOR MONTHLY BILLED ACCOUNTS   *        
      ******************************************************************        
                                                                        
       7905-FETCH-BILL-DATE-CSR.                                        
                                                                        
           MOVE '7905' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
              FETCH MTH_BILL_DATE_CSR                                   
               INTO :BN-DATE-EXTRACT :WS-NULL-DATE-EXTRACT,              
                    :BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-NULL-DATE-EXTRACT < ZERO                            
              OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO BN-DATE-EXTRACT                         
                 MOVE ZEROES TO BN-REVENUE-MONTH                        
              ELSE                                                      
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7905' TO ACTIVE-PARAGRAPH                        
                 MOVE 'FETCH CURSOR' TO ABEND-FUNCTION                  
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7905-FETCH-BILL-DATE-CSR-EXIT.                                   
           EXIT.                                                        
                                                                        
      ******************************************************************18651000
      * 7910-SELECT-NXT-RD-DT                                          *        
      * SELECT THE NEXT READ DATE BASED ON THE ACCOUNTS READ_CYCLE     *        
      * AND WHETHER IT HAS ALREADY BEEN READ THIS MONTH OR NOT.        *        
      * THIS IS DETERMINED BY LOOKING AT THE REV-MTH-LST-NRML FIELD    *        
      * ON THE ACCOUNT TABLE.                                          *        
      ******************************************************************        
                                                                        
       7910-SELECT-NXT-RD-DT.                                           
                                                                        
           MOVE '7910' TO  ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
               SELECT MIN (OPTIMUM_READ_DATE)                           
                 INTO :RW-OPTIMUM-READ-DATE :WS-NULL-IND-CPD             
                 FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                  
                WHERE RW.READ_CYCLE         = :UT-READ-CYCLE            
                  AND RW.OPTIMUM_READ_DATE >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) )             
                  AND RW.REVENUE_MONTH      > :AT-REV-MTH-LST-NRML      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN (OPTIMUM_READ_DATE)                                   
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE:WS-NULL-IND-CPD                     
MFA-TR*          FROM CSS_READ_WINDOW RW                                        
MFA-TR*         WHERE RW.READ_CYCLE         = :UT-READ-CYCLE                    
MFA-TR*           AND RW.OPTIMUM_READ_DATE >= :WS-READ-DATE                     
MFA-TR*           AND RW.REVENUE_MONTH      > :AT-REV-MTH-LST-NRML              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7910                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-CPD < ZERO                                 
                 MOVE SPACES                   TO RW-OPTIMUM-READ-DATE  
                 MOVE 0                        TO WS-NULL-IND-CPD       
              ELSE                                                      
                 MOVE RW-OPTIMUM-READ-DATE     TO WS-READ-DATE          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT NEXT RD DT'         TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_READ_WINDOW'           TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE 'WS-READ-DATE'              TO TABLE-ELEMENT-1       
              MOVE WS-READ-DATE                TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7910-SELECT-NXT-RD-DT-EXIT.                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      ** CLOSE CURSOR TO CSS_BILL_WINDOW FOR MONTHLY BILLED ACCOUNTS **         
      *****************************************************************         
                                                                        
       7910-CLOSE-BILL-DATE-CSR.                                        
                                                                        
           MOVE '7910' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE MTH_BILL_DATE_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE '7910' TO ACTIVE-PARAGRAPH                           
              MOVE 'CLOSE CURSOR' TO ABEND-FUNCTION                     
              MOVE SPACES TO ABEND-SQL-PREDICATES                       
                                     ABEND-TABLES                       
              MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7910-CLOSE-BILL-DATE-CSR-EXIT.                                   
           EXIT.                                                        
                                                                        
      ***************************************************************** 18651000
      * 7920-GET-NXT-RD-DT-FIA                                        *         
      * SELECT THE NEXT READ DATE BASED ON THE ACCOUNTS READ_CYCLE    *         
      * AND WHETHER IT HAS ALREADY BEEN READ THIS MONTH OR NOT.       *         
      * THIS IS DETERMINED BY LOOKING AT THE REV-MTH-LST-NRML FIELD   *         
      * ON THE ACCOUNT TABLE.                                         *         
      *****************************************************************         
                                                                        
       7920-GET-NXT-RD-DT-FIA.                                          
                                                                        
           MOVE '7920' TO  ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
               SELECT MIN (OPTIMUM_READ_DATE)                           
                 INTO :RW-OPTIMUM-READ-DATE :WS-NULL-IND-CPD             
                 FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                  
                WHERE RW.READ_CYCLE         = :UT-READ-CYCLE            
                  AND RW.OPTIMUM_READ_DATE >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) )             
                  AND RW.REVENUE_MONTH     >= :AT-REV-MTH-LST-NRML      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN (OPTIMUM_READ_DATE)                                   
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE:WS-NULL-IND-CPD                     
MFA-TR*          FROM CSS_READ_WINDOW RW                                        
MFA-TR*         WHERE RW.READ_CYCLE         = :UT-READ-CYCLE                    
MFA-TR*           AND RW.OPTIMUM_READ_DATE >= :WS-READ-DATE                     
MFA-TR*           AND RW.REVENUE_MONTH     >= :AT-REV-MTH-LST-NRML              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7920                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-CPD < ZERO                                 
                 MOVE SPACES                   TO RW-OPTIMUM-READ-DATE  
                 MOVE 0                        TO WS-NULL-IND-CPD       
              ELSE                                                      
                 MOVE RW-OPTIMUM-READ-DATE     TO WS-READ-DATE          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT NEXT RD DT FIA'     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_READ_WINDOW'           TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE 'WS-READ-DATE'              TO TABLE-ELEMENT-1       
              MOVE WS-READ-DATE                TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7920-GET-NXT-RD-DT-FIA-EXIT.                                     
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7930-GET-NXT-RD-DT                                             *        
      * SELECT THE NEXT READ DATE BASED ON THE PREVIOUS OPTIMUM        *        
      * READ DATE SELECTED IN PARA 7910- OR 7920- (WS-READ-DATE).      *        
      ******************************************************************        
                                                                        
       7930-GET-NXT-RD-DT.                                              
                                                                        
           MOVE '7930' TO  ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
               SELECT MIN (OPTIMUM_READ_DATE)                           
                 INTO :RW-OPTIMUM-READ-DATE :WS-NULL-IND-CPD             
                 FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED),                 
                      CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
                WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO            
                  AND RW.READ_CYCLE         = :UT-READ-CYCLE            
                  AND RW.OPTIMUM_READ_DATE  > IIF(TRY_CONVERT(DATE, 
                                                          :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) )             
                  AND RW.REVENUE_MONTH     >= AT.REV_MTH_LST_NRML       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN (OPTIMUM_READ_DATE)                                   
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE:WS-NULL-IND-CPD                     
MFA-TR*          FROM CSS_READ_WINDOW RW,                                       
MFA-TR*               CSS_ACCOUNT     AT                                        
MFA-TR*         WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                    
MFA-TR*           AND RW.READ_CYCLE         = :UT-READ-CYCLE                    
MFA-TR*           AND RW.OPTIMUM_READ_DATE  > :WS-READ-DATE                     
MFA-TR*           AND RW.REVENUE_MONTH     >= AT.REV_MTH_LST_NRML               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7930                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE RW-OPTIMUM-READ-DATE TO WS-READ-DATE.                   
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           AND WS-NULL-IND-CPD = 0                                      
              CONTINUE                                                  
           ELSE                                                         
              IF WS-NULL-IND-CPD NOT EQUAL 0                            
                 MOVE -1 TO WS-ACTIVE-RETURN-CODE                       
              END-IF                                                    
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT NEXT RD DT FIA'  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_READ_WINDOW'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'WS-READ-DATE'           TO TABLE-ELEMENT-1          
              MOVE WS-READ-DATE             TO HOSTVAR-ELEMENT-1        
              MOVE 'WS-NULL-IND-CPD'        TO TABLE-ELEMENT-1          
              MOVE WS-NULL-IND-CPD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************18660000
      * OPEN CURSOR TO CSS_BILL_WINDOW FOR MONTHLY BILLED ACCOUNTS     *        
      ******************************************************************        
                                                                        
       7940-OPEN-BILL-DATE-EXP-CSR.                                     
                                                                        
           MOVE '7940' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE BILL_DATE_EXP_CSR CURSOR FOR                      
               SELECT MIN (DATE_EXTRACT), REVENUE_MONTH                 
                 FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                WHERE BILL_CYCLE    = :BN-BILL-CYCLE                    
                AND DATE_EXTRACT  > IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXPIRE
              ) <> 0) OR (LEN(:WS-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-EXPIRE
              ), CONVERT(DATE, :WS-DATE-EXPIRE) )                     
                AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                
                GROUP BY DATE_EXTRACT, REVENUE_MONTH                    
                ORDER BY REVENUE_MONTH ASC
            OPTION(FAST 1)
            FOR READ ONLY
                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL_DATE_EXP_CSR CURSOR FOR                              
MFA-TR*        SELECT MIN (DATE_EXTRACT), REVENUE_MONTH                         
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE BILL_CYCLE    = :BN-BILL-CYCLE                            
MFA-TR*         AND DATE_EXTRACT  > :WS-DATE-EXPIRE                             
MFA-TR*         AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                        
MFA-TR*         GROUP BY DATE_EXTRACT, REVENUE_MONTH                            
MFA-TR*         ORDER BY REVENUE_MONTH ASC                                      
MFA-TR*         OPTIMIZE FOR 1 ROW                                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              OPEN BILL_DATE_EXP_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE '7940' TO ACTIVE-PARAGRAPH                           
              MOVE 'OPEN CURSOR' TO ABEND-FUNCTION                      
              MOVE SPACES TO ABEND-SQL-PREDICATES                       
                                     ABEND-TABLES                       
              MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * FETCH CURSOR TO CSS_BILL_WINDOW AFTER EXP DATE                 *        
      ******************************************************************        
                                                                        
       7945-FETCH-BILL-DATE-EXP-CSR.                                    
                                                                        
           MOVE '7945' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
              FETCH  BILL_DATE_EXP_CSR                                  
               INTO :BN-DATE-EXTRACT :WS-NULL-DATE-EXTRACT,              
                    :BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-NULL-DATE-EXTRACT < ZERO                            
              OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO BN-DATE-EXTRACT                         
                 MOVE ZEROES TO BN-REVENUE-MONTH                        
              ELSE                                                      
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7945' TO ACTIVE-PARAGRAPH                        
                 MOVE 'FETCH CURSOR' TO ABEND-FUNCTION                  
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7945-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CLOSE CURSOR TO CSS_BILL_WINDOW AFTER DATE EXPIRE              *        
      ******************************************************************        
                                                                        
       7950-CLOSE-BILL-DATE-EXP-CSR.                                    
                                                                        
           MOVE '7950' TO  ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL_DATE_EXP_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE '7950' TO ACTIVE-PARAGRAPH                           
              MOVE 'CLOSE CURSOR' TO ABEND-FUNCTION                     
              MOVE SPACES TO ABEND-SQL-PREDICATES                       
                                     ABEND-TABLES                       
              MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7960-SEL-CUST-ALERT-SEQ-NO                                     *        
      ******************************************************************        
                                                                        
       7960-SEL-CUST-ALERT-SEQ-NO.                                      
                                                                        
           EXEC SQL                                                     
              SELECT CAST(CUST_ALERT_SEQ_NO AS DATE)                            
              INTO   :WS-WQ-CREATE-DATE                                 
              FROM   CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                         
              AND   DATE_ALERT = CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-ALERT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-ALERT
              ) <> 0) OR (LEN(:WS-DATE-ALERT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-ALERT
              ), CONVERT(DATE, :WS-DATE-ALERT) ),'ISO')         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     39560000
MFA-TR*       SELECT DATE(CUST_ALERT_SEQ_NO)                            39570000
MFA-TR*       INTO   :WS-WQ-CREATE-DATE                                 39570000
MFA-TR*       FROM   CSS_CUST_ALERT                                     39570000
MFA-TR*       WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                         39570000
MFA-TR*       AND   DATE_ALERT = CHAR(DATE(:WS-DATE-ALERT),ISO)         39570000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7960                                                      
MFA-TR*    END-EXEC.                                                    39580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7960'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_ALERT'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
ACT119        MOVE CA-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************18660000
      * 8101-UPDATE-CUST-ALERT                                         *18670000
      ******************************************************************18740000
       8101-UPDATE-CUST-ALERT.                                          
                                                                        
P0726B     IF CA-PATIENT-NAME-ID = 0                                    
P0726B        MOVE -1                         TO WS-PTNT-NAME-ID-NULL   
P0726B     END-IF.                                                      
P0726B                                                                  
P0726B     IF CA-PHYSICIAN-ID    = 0                                    
P0726B        MOVE -1                         TO WS-PHYSICIAN-ID-NULL   
P0726B     END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_ALERT                                     
                 SET PATIENT_NAME_ID    = :CA-PATIENT-NAME-ID 
                                          :WS-PTNT-NAME-ID-NULL         
                    ,PHYSICIAN_ID       = :CA-PHYSICIAN-ID 
                                          :WS-PHYSICIAN-ID-NULL         
                    ,LAST_UPDATE_USERID = :CA-LAST-UPDATE-USERID        
               WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                        
                 AND DATE_ALERT = CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-ALERT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-ALERT
              ) <> 0) OR (LEN(:WS-DATE-ALERT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-ALERT
              ), CONVERT(DATE, :WS-DATE-ALERT) ),'ISO')        
                 AND CUST_ALERT_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                 :WS-CUST-ALERT-SEQ-OLD
              )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18800000
MFA-TR*       UPDATE CSS_CUST_ALERT                                     18810000
MFA-TR*          SET PATIENT_NAME_ID    = :CA-PATIENT-NAME-ID           18820000
MFA-TR*                                   :WS-PTNT-NAME-ID-NULL                 
MFA-TR*             ,PHYSICIAN_ID       = :CA-PHYSICIAN-ID                      
MFA-TR*                                   :WS-PHYSICIAN-ID-NULL                 
MFA-TR*             ,LAST_UPDATE_USERID = :CA-LAST-UPDATE-USERID                
MFA-TR*        WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                        18890000
MFA-TR*          AND DATE_ALERT = CHAR(DATE(:WS-DATE-ALERT),ISO)        18900000
MFA-TR*          AND CUST_ALERT_SEQ_NO  = :WS-CUST-ALERT-SEQ-OLD                
MFA-TR*    END-EXEC.                                                    18910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8101'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_ALERT'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_ALERT'               TO TABLE-ELEMENT-2        
              MOVE 'CUST_ALERT_SEQ_NO'        TO TABLE-ELEMENT-3        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-DATE-ALERT              TO HOSTVAR-ELEMENT-2      
              MOVE WS-CUST-ALERT-SEQ-OLD      TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************19132000
      * 8102-EXPIRE-CUST-ALERT                                         *19133000
      ******************************************************************19139100
                                                                        
       8102-EXPIRE-CUST-ALERT.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_ALERT                                     
                 SET DATE_EXPIRE = IIF(TRY_CONVERT(DATE, 
                                                      :WS-HOLD-EXP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-EXP-DATE
              ) <> 0) OR (LEN(:WS-HOLD-EXP-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-HOLD-EXP-DATE
              ), CONVERT(DATE, :WS-HOLD-EXP-DATE) )                    
               WHERE ACCOUNT_NO        = :CA-ACCOUNT-NO                 
                 AND CUST_ALERT_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :WS-CUST-ALERT-SEQ-NO
              )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19139400
MFA-TR*       UPDATE CSS_CUST_ALERT                                     19139500
MFA-TR*          SET DATE_EXPIRE = :WS-HOLD-EXP-DATE                            
MFA-TR*        WHERE ACCOUNT_NO        = :CA-ACCOUNT-NO                 19140300
MFA-TR*          AND CUST_ALERT_SEQ_NO = :WS-CUST-ALERT-SEQ-NO          19140400
MFA-TR*    END-EXEC.                                                    19140500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8102'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_ALERT'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CUST_ALERT_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CUST-ALERT-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************19143000
      * 8300-UPDATE-ACCOUNT                                            *19150000
      * UPDATES CSS_ACCOUNT TO SET/RESET MEDICAL CERTIFICATE INDICATOR.*19210000
      ******************************************************************19230000
                                                                        
       8300-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL            
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_TEMP_BILL'           TO TABLE-ELEMENT-3        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AT-CODE-TEMP-BILL          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************19540000
      * 8410-DELETE-CUST-ALERT                                         *19550000
      ******************************************************************19620000
                                                                        
       8410-DELETE-CUST-ALERT.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_ALERT                                
               WHERE ACCOUNT_NO  = :CA-ACCOUNT-NO                       
                 AND DATE_ALERT  = CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-ALERT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-ALERT
              ) <> 0) OR (LEN(:WS-DATE-ALERT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-ALERT
              ), CONVERT(DATE, :WS-DATE-ALERT) ),'ISO')       
                 AND DATE_EXPIRE = CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXPIRE
              ) <> 0) OR (LEN(:WS-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-EXPIRE
              ), CONVERT(DATE, :WS-DATE-EXPIRE) ),'ISO')      
                 AND CUST_ALERT_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                 :WS-CUST-ALERT-SEQ-OLD
              )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19680000
MFA-TR*       DELETE FROM CSS_CUST_ALERT                                19690000
MFA-TR*        WHERE ACCOUNT_NO  = :CA-ACCOUNT-NO                       19700000
MFA-TR*          AND DATE_ALERT  = CHAR(DATE(:WS-DATE-ALERT),ISO)       19710000
MFA-TR*          AND DATE_EXPIRE = CHAR(DATE(:WS-DATE-EXPIRE),ISO)              
MFA-TR*          AND CUST_ALERT_SEQ_NO  = :WS-CUST-ALERT-SEQ-OLD                
MFA-TR*    END-EXEC.                                                    19720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8410'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_ALERT'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_ALERT'               TO TABLE-ELEMENT-2        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-DATE-ALERT              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************19930000
      * 8420-DELETE-EXCPTN-CRED-COLL.                                  *19940000
      ******************************************************************20010000
                                                                        
       8420-DELETE-EXCPTN-CRED-COLL.                                    
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
               WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                 
                 AND (CODE_NOTICE_TYPE = 'E' OR                         
                      CODE_NOTICE_TYPE = 'F' OR                         
                      CODE_NOTICE_TYPE = 'G' OR                         
                      CODE_NOTICE_TYPE = 'T' OR                         
                      CODE_NOTICE_TYPE = 'U' OR                         
                      CODE_NOTICE_TYPE = 'X')                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8420'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20360000
      * 8430-DELETE-NORM-CRED-ACTION                                   *20370000
      ******************************************************************20460000
                                                                        
       8430-DELETE-NORM-CRED-ACTION.                                    
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
               WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
                 AND (((CODE_NOTICE_TYPE = 'C'                          
                 AND  DATE_NOTICE_MAIL   > CAST(SYSDATETIMEOFFSET() 
           AS DATE))                
                  OR  (CODE_NOTICE_TYPE = 'S'                           
                 AND  DATE_NOTICE_MAIL   > CAST(SYSDATETIMEOFFSET() 
           AS DATE))                
                  OR  (CODE_NOTICE_TYPE   = 'D'                         
                 AND  DATE_CREDIT_ACTION > CAST(SYSDATETIMEOFFSET() 
           AS DATE)))               
                  OR  (CODE_NOTICE_TYPE   = 'M'))                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     20520000
MFA-TR*       DELETE FROM CSS_CRED_COLL                                 20530000
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               20540000
MFA-TR*          AND (((CODE_NOTICE_TYPE = 'C'                                  
MFA-TR*          AND  DATE_NOTICE_MAIL   > CURRENT DATE)                20560000
MFA-TR*           OR  (CODE_NOTICE_TYPE = 'S'                                   
MFA-TR*          AND  DATE_NOTICE_MAIL   > CURRENT DATE)                20560000
MFA-TR*           OR  (CODE_NOTICE_TYPE   = 'D'                         20570000
MFA-TR*          AND  DATE_CREDIT_ACTION > CURRENT DATE))               20580000
MFA-TR*           OR  (CODE_NOTICE_TYPE   = 'M'))                               
MFA-TR*    END-EXEC.                                                    20590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8430'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
           IF CSR-DATABASE                                              
              EXEC SQL                                                  
                UPDATE CSS_CRED_COLL                                    
                SET DATE_CREDIT_ACTION = NULL                           
                WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                       
                AND CODE_NOTICE_TYPE = 'C'                              
      *  ADDED EQUAL SIGN TO FOLLOWING STATEMENT                                
                AND DATE_NOTICE_MAIL  <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                AND DATE_CREDIT_ACTION > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*         UPDATE CSS_CRED_COLL                                            
MFA-TR*         SET DATE_CREDIT_ACTION = NULL                                   
MFA-TR*         WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                               
MFA-TR*         AND CODE_NOTICE_TYPE = 'C'                                      
MFA-TR*  ADDED EQUAL SIGN TO FOLLOWING STATEMENT                                
MFA-TR*         AND DATE_NOTICE_MAIL  <= CURRENT DATE                           
MFA-TR*         AND DATE_CREDIT_ACTION > CURRENT DATE                           
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE '8430'                  TO ACTIVE-PARAGRAPH       
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'UPDATE'                TO ABEND-FUNCTION         
                 MOVE 'CSS_CRED_COLL'         TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE CL-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CSR-DATABASE                                              
              EXEC SQL                                                  
                UPDATE CSS_CRED_COLL                                    
                SET DATE_CREDIT_ACTION = NULL                           
                WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                       
                AND CODE_NOTICE_TYPE = 'S'                              
      *  ADDED EQUAL SIGN TO FOLLOWING STATEMENT                                
                AND DATE_NOTICE_MAIL  <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                AND DATE_CREDIT_ACTION > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*         UPDATE CSS_CRED_COLL                                            
MFA-TR*         SET DATE_CREDIT_ACTION = NULL                                   
MFA-TR*         WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                               
MFA-TR*         AND CODE_NOTICE_TYPE = 'S'                                      
MFA-TR*  ADDED EQUAL SIGN TO FOLLOWING STATEMENT                                
MFA-TR*         AND DATE_NOTICE_MAIL  <= CURRENT DATE                           
MFA-TR*         AND DATE_CREDIT_ACTION > CURRENT DATE                           
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE '8430'                  TO ACTIVE-PARAGRAPH       
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'UPDATE'                TO ABEND-FUNCTION         
                 MOVE 'CSS_CRED_COLL'         TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE CL-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************20830000
      * 8440-DELETE-RETURN-CK-DEPOSIT                                  *20840000
      * DELETE RETURNED CHECK AND DEPOSIT FORECAST CREDIT UNLESS       *20860000
      * FORECAST DNP DATE IS AFTER MEDICAL CERTIFICATE EXPIRATION DATE *20870000
      ******************************************************************20940000
                                                                        
       8440-DELETE-RETURN-CK-DEPOSIT.                                   
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
               WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
                 AND (CODE_NOTICE_TYPE   = 'H'                          
                  OR CODE_NOTICE_TYPE    = 'I')                         
                 AND DATE_CREDIT_ACTION <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXPIRE
              ) <> 0) OR (LEN(:WS-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-EXPIRE
              ), CONVERT(DATE, :WS-DATE-EXPIRE) )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21000000
MFA-TR*       DELETE FROM CSS_CRED_COLL                                 21010000
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               21020000
MFA-TR*          AND (CODE_NOTICE_TYPE   = 'H'                          21030000
MFA-TR*           OR CODE_NOTICE_TYPE    = 'I')                         21040000
MFA-TR*          AND DATE_CREDIT_ACTION <= :WS-DATE-EXPIRE              21050000
MFA-TR*    END-EXEC.                                                    21060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8440'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_CREDIT_ACTION'       TO TABLE-ELEMENT-2        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-DATE-EXPIRE             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
       8440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21300000
      * 8500-INSERT-CUST-ALERT                                         *21310000
      ******************************************************************21380000
                                                                        
       8500-INSERT-CUST-ALERT.                                          
                                                                        
P0726B     IF CA-PATIENT-NAME-ID = 0                                    
P0726B        MOVE -1                         TO WS-PTNT-NAME-ID-NULL   
P0726B     END-IF.                                                      
P0726B                                                                  
P0726B     IF CA-PHYSICIAN-ID    = 0                                    
P0726B        MOVE -1                         TO WS-PHYSICIAN-ID-NULL   
P0726B     END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_ALERT                                
                    (ACCOUNT_NO,                                        
                     CODE_ALERT_TYPE,                                   
                     DATE_ALERT,                                        
                     DATE_EXPIRE,                                       
                     CUST_ALERT_SEQ_NO,                                 
                     PATIENT_NAME_ID,                                   
                     PHYSICIAN_ID,                                      
                     LAST_UPDATE_USERID)                                
              VALUES                                                    
                  (:CA-ACCOUNT-NO,                                      
                   :CA-CODE-ALERT-TYPE,                                 
                   IIF(TRY_CONVERT(DATE, :CA-DATE-ALERT
              ) IS NULL OR (PATINDEX('%.%', :CA-DATE-ALERT
              ) <> 0) OR (LEN(:CA-DATE-ALERT) <> 10), CIS.CHAR2DATE(
                                                         :CA-DATE-ALERT
              ), CONVERT(DATE, :CA-DATE-ALERT) ),                              
                   IIF(TRY_CONVERT(DATE, :CA-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :CA-DATE-EXPIRE
              ) <> 0) OR (LEN(:CA-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :CA-DATE-EXPIRE
              ), CONVERT(DATE, :CA-DATE-EXPIRE) ),                             
                   CIS.CHAR2TIMESTAMP(:CA-CUST-ALERT-SEQ-NO),                   
P0726B             :CA-PATIENT-NAME-ID :WS-PTNT-NAME-ID-NULL,           
P0726B             :CA-PHYSICIAN-ID :WS-PHYSICIAN-ID-NULL,           
                   :CA-LAST-UPDATE-USERID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21440000
MFA-TR*       INSERT INTO CSS_CUST_ALERT                                21450000
MFA-TR*             (ACCOUNT_NO,                                        21460000
MFA-TR*              CODE_ALERT_TYPE,                                   21470000
MFA-TR*              DATE_ALERT,                                        21480000
MFA-TR*              DATE_EXPIRE,                                       21490000
MFA-TR*              CUST_ALERT_SEQ_NO,                                 21500000
MFA-TR*              PATIENT_NAME_ID,                                           
MFA-TR*              PHYSICIAN_ID,                                              
MFA-TR*              LAST_UPDATE_USERID)                                        
MFA-TR*       VALUES                                                    21600000
MFA-TR*           (:CA-ACCOUNT-NO,                                      21610000
MFA-TR*            :CA-CODE-ALERT-TYPE,                                 21620000
MFA-TR*            :CA-DATE-ALERT,                                      21630000
MFA-TR*            :CA-DATE-EXPIRE,                                     21640000
MFA-TR*            :CA-CUST-ALERT-SEQ-NO,                               21650000
MFA-TR*            :CA-PATIENT-NAME-ID :WS-PTNT-NAME-ID-NULL,                   
MFA-TR*            :CA-PHYSICIAN-ID    :WS-PHYSICIAN-ID-NULL,                   
MFA-TR*            :CA-LAST-UPDATE-USERID)                                      
MFA-TR*    END-EXEC.                                                    21750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_ALERT'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_ALERT'               TO TABLE-ELEMENT-2        
              MOVE 'DATE_EXPIRE'              TO TABLE-ELEMENT-3        
              MOVE 'CODE_ALERT_TYPE'          TO TABLE-ELEMENT-4        
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CA-DATE-ALERT              TO HOSTVAR-ELEMENT-2      
              MOVE CA-DATE-EXPIRE             TO HOSTVAR-ELEMENT-3      
              MOVE CA-CODE-ALERT-TYPE         TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22000000
      * 8600-INSERT-CRED-COLL                                          *22010000
      ******************************************************************22080000
       8600-INSERT-CRED-COLL.                                           
                                                                        
           IF CL-DATE-NOTICE-MAIL <= SPACES                             
              MOVE -1                       TO WS-NULL-IND1             
           ELSE                                                         
              MOVE 0                        TO WS-NULL-IND1             
           END-IF.                                                      
                                                                        
           IF CL-DATE-CREDIT-ACTION <= SPACES                           
              MOVE -1                       TO WS-NULL-IND2             
           ELSE                                                         
              MOVE 0                        TO WS-NULL-IND2             
           END-IF.                                                      
                                                                        
           IF CL-DATE-NOTICE-DUE <= SPACES                              
              MOVE -1                       TO WS-NULL-IND3             
           ELSE                                                         
              MOVE 0                        TO WS-NULL-IND3             
           END-IF.                                                      
                                                                        
           IF CL-DATE-BILL <= SPACES                                    
              MOVE -1                       TO WS-NULL-IND4             
           ELSE                                                         
              MOVE 0                        TO WS-NULL-IND4             
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_COLL                                 
                  (ACCOUNT_NO,                                          
                   CODE_SPECIAL_TYPE,                                   
                   DATE_NOTICE_MAIL,                                    
                   CODE_FRCST_CR_GRP,                                   
                   ITEM_ID,                                             
                   CODE_MESSAGE_TYPE,                                   
                   DATE_CREDIT_ACTION,                                  
                   DATE_NOTICE_DUE,                                     
                   AMT_NOTICE,                                          
                   CODE_NOTICE_TYPE,                                    
                   DATE_BILL,                                           
                   LAST_UPDATE_TS)                                      
              VALUES                                                    
                  (:CL-ACCOUNT-NO,                                      
                   :CL-CODE-SPECIAL-TYPE,                               
                   IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                         :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                                          :WS-NULL-IND1
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL :WS-NULL-IND1) ),          
                   :CL-CODE-FRCST-CR-GRP,                               
                   :CL-ITEM-ID,                                         
                   :CL-CODE-MESSAGE-TYPE,                               
                   IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                         :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                          :WS-NULL-IND2
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION :WS-NULL-IND2) ),        
                   IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                         :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE :WS-NULL-IND3
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-NULL-IND3) ),           
                   :CL-AMT-NOTICE,                                      
                   :CL-CODE-NOTICE-TYPE,                                
                   IIF(TRY_CONVERT(DATE, :CL-DATE-BILL :WS-NULL-IND4
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL :WS-NULL-IND4
              ) <> 0) OR (LEN(:CL-DATE-BILL :WS-NULL-IND4
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-BILL :WS-NULL-IND4
              ), CONVERT(DATE, :CL-DATE-BILL :WS-NULL-IND4) ),                 
                   CIS.CURRENT$TIMESTAMP())                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     22380000
MFA-TR*       INSERT INTO CSS_CRED_COLL                                 22390000
MFA-TR*           (ACCOUNT_NO,                                          22400000
MFA-TR*            CODE_SPECIAL_TYPE,                                   22410000
MFA-TR*            DATE_NOTICE_MAIL,                                    22420000
MFA-TR*            CODE_FRCST_CR_GRP,                                   22430000
MFA-TR*            ITEM_ID,                                             22440000
MFA-TR*            CODE_MESSAGE_TYPE,                                   22450000
MFA-TR*            DATE_CREDIT_ACTION,                                  22460000
MFA-TR*            DATE_NOTICE_DUE,                                     22470000
MFA-TR*            AMT_NOTICE,                                          22480000
MFA-TR*            CODE_NOTICE_TYPE,                                    22490000
MFA-TR*            DATE_BILL,                                           22500000
MFA-TR*            LAST_UPDATE_TS)                                      22510000
MFA-TR*       VALUES                                                    22530000
MFA-TR*           (:CL-ACCOUNT-NO,                                      22550000
MFA-TR*            :CL-CODE-SPECIAL-TYPE,                               22560000
MFA-TR*            :CL-DATE-NOTICE-MAIL:WS-NULL-IND1,                   22570000
MFA-TR*            :CL-CODE-FRCST-CR-GRP,                               22580000
MFA-TR*            :CL-ITEM-ID,                                         22590000
MFA-TR*            :CL-CODE-MESSAGE-TYPE,                               22600000
MFA-TR*            :CL-DATE-CREDIT-ACTION:WS-NULL-IND2,                 22610000
MFA-TR*            :CL-DATE-NOTICE-DUE:WS-NULL-IND3,                    22620000
MFA-TR*            :CL-AMT-NOTICE,                                      22630000
MFA-TR*            :CL-CODE-NOTICE-TYPE,                                22640000
MFA-TR*            :CL-DATE-BILL:WS-NULL-IND4,                          22650000
MFA-TR*            CURRENT TIMESTAMP)                                   22660000
MFA-TR*    END-EXEC.                                                    22680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8600'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-2        
              MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-3        
              MOVE 'DATE_NOTICE_MAIL'         TO TABLE-ELEMENT-4        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CL-CODE-NOTICE-TYPE        TO HOSTVAR-ELEMENT-2      
              MOVE CL-ITEM-ID                 TO HOSTVAR-ELEMENT-3      
              MOVE CL-DATE-NOTICE-MAIL        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * ABEND PROCESSING                                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     15700000
              INCLUDE CPD0023C                                          15710000
           END-EXEC.                                                    15720000
                                                                        
      ******************************************************************22910000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *22920000
      ******************************************************************22930000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************22980000
      * END PROGRAM COPYLIB                                            *22990000
      ******************************************************************23000000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
