       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04850.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  APR 29, 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * RETRIEVES PHYSICIAN/PATIENT INFORMATION FOR MEDICAL CERTIFICATE*        
      * HISTORY SCREEN.                                                *        
      *                                                                *        
      *  #  INVOKED FROM MEDICAL CERTIFICATE HISTORY PAGE              *        
      *                                                                *        
      *  #  BUSOP NAME: RequGetAcctMedCertHistoryBusinessOp            *        
      *                                                                *        
      *  #  PARAMETERS                                                 *        
      *     IN                                                         *        
      *         ACCOUNT_NO               CHAR(13)                      *        
      *     OUT                                                        *        
      *         RETURN_CODE              INTEGER                       *        
      *         CUST_ALERT_SEQ_NO        CHAR(26)                      *        
      *         DATE_ALERT               CHAR(10)                      *        
      *         DATE_EXPIRE              CHAR(10)                      *        
      *         CODE_DISC_OK             CHAR(01)                      *        
      *         ELEC_GAS                 CHAR(01)                      *        
      *         AMT_PAST_DUE             DECIMAL(11,2)                 *        
      *         BANKRUPTCY_IND           CHAR(01)                      *        
      *         TOT_BAL_UTL              DECIMAL(11,2)                 *        
      *         TOT_BAL_NONUTL           DECIMAL(11,2)                 *        
      *         CODE_CRIT_OUTAGE         CHAR(02)                      *        
      *         PATIENT_NAME             CHAR(82)                      *        
      *         PHYSICIAN_NAME           CHAR(82)                      *        
      *         PHYSICIAN_LICENSE        CHAR(11)                      *        
      *         ADDRESS_LINE1            CHAR(89)                      *        
      *         ADDRESS_LINE2            CHAR(12)                      *        
      *         ADDR_CITY_STATE          CHAR(30)                      *        
      *         ADDR_ZIP_CODE            CHAR(10)                      *        
      *         ESTABLISHED_BY           CHAR(07)                      *        
      *         ESTABLISHED_BY_NAME      CHAR(70)                      *        
      *         ARRANGEMENT_FLAG         CHAR(01)                      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  06/16/15  AA97148    INITIAL IMPLEMENTATION.                  *        
P0726A*  10/29/15  AA97148    DCR# 2838 - CHANGE PATIENT_NAME_ID AND   *        
P0726A*                       PHYSICIAN_ID TO HOLD NULL VALUE.         *        
A05460*  02/06/15  MS7M727    MOVE SPACES TO CODE_CRIT_OUTAGE WHEN     *        
A05460*            ACT036     CODE_CRIT_OUTAGE IS WX OR  WP.           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04850'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04850 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04850'.  
           05  WS-PGRMNAME                PIC X(08)  VALUE 'CSR04850'.  
           05  MCSCB068                   PIC X(08)  VALUE 'MCSCB068'.  
           05  WS-ELEC-GAS                PIC X(01)  VALUE 'N'.         
           05  WS-DATE-ALERT              PIC X(10)  VALUE SPACES.      
           05  WS-DATE-EXPIRE             PIC X(10)  VALUE SPACES.      
           05  WS-DATE-ALERT-USA          PIC X(10)  VALUE SPACES.      
           05  WS-DATE-EXPIRE-USA         PIC X(10)  VALUE SPACES.      
           05  WS-FULL-NAME               PIC X(82)  VALUE SPACES.      
           05  WS-PHYSICIAN-LICENSE       PIC X(11)  VALUE SPACES.      
           05  WS-DATE-BILL-00-NULL       PIC S9(04) COMP VALUE +0.     
           05  WS-DATE-BILL-30-NULL       PIC S9(04) COMP VALUE +0.     
           05  WS-DATE-BILL-60-NULL       PIC S9(04) COMP VALUE +0.     
           05  WS-DATE-BILL-90-NULL       PIC S9(04) COMP VALUE +0.     
           05  WS-DATE-ALERT-NULL         PIC S9(04) COMP VALUE +0.     
           05  WS-DATE-EXPIRE-NULL        PIC S9(04) COMP VALUE +0.     
P0726A     05  WS-PTNT-NAME-ID-NULL       PIC S9(04) COMP VALUE +0.     
P0726A     05  WS-PHYSICIAN-ID-NULL       PIC S9(04) COMP VALUE +0.     
           05  WS-INSERT-REC-COUNT        PIC S9(09) COMP VALUE +0.     
           05  WS-ADDRESS-LINE1           PIC X(56)  VALUE SPACES.      
           05  WS-ADDRESS-LINE2           PIC X(12)  VALUE SPACES.      
           05  WS-TOWN-STATE              PIC X(29)  VALUE SPACES.      
           05  RS-RETURN-CODE             PIC S9(09) COMP VALUE +0.     
           05  WS-ESTABLISHED-BY-NAME     PIC X(70)  VALUE SPACES.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                      PIC S9(9)  COMP VALUE 0.   
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE           PIC S9(9)  COMP VALUE 0.      
               10 S-CUST-ALERT-SEQ-NO     PIC X(26)  VALUE SPACES.      
               10 S-DATE-ALERT            PIC X(10)  VALUE SPACES.      
               10 S-DATE-EXPIRE           PIC X(10)  VALUE SPACES.      
               10 S-CODE-DISC-OK          PIC X(01)  VALUE SPACES.      
               10 S-ELEC-GAS              PIC X(01)  VALUE SPACES.      
               10 S-AMT-PAST-DUE          PIC S9(09)V99 COMP-3 VALUE +0.
               10 S-BANKRUPTCY-IND        PIC X(01)  VALUE SPACES.      
               10 S-TOT-BAL-UTL           PIC S9(09)V99 COMP-3 VALUE +0.
               10 S-TOT-BAL-NONUTL        PIC S9(09)V99 COMP-3 VALUE +0.
               10 S-CODE-CRIT-OUTAGE      PIC X(02)  VALUE SPACES.      
               10 S-PATIENT-NAME          PIC X(82)  VALUE SPACES.      
               10 S-PHYSICIAN-NAME        PIC X(82)  VALUE SPACES.      
               10 S-PHYSICIAN-LICENSE     PIC X(11)  VALUE SPACES.      
               10 S-ADDRESS-LINE1         PIC X(56)  VALUE SPACES.      
               10 S-ADDRESS-LINE2         PIC X(12)  VALUE SPACES.      
               10 S-ADDR-CITY-STATE       PIC X(30)  VALUE SPACES.      
               10 S-ADDR-ZIP-CODE         PIC X(10)  VALUE SPACES.      
               10 S-ESTABLISHED-BY        PIC X(07)  VALUE SPACES.      
               10 S-ESTABLISHED-BY-NAME   PIC X(70)  VALUE SPACES.      
               10 S-ARRANGEMENT-FLAG      PIC X(01)  VALUE SPACES.      
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                  PIC X(18)  VALUE SPACES.      
           05  S-SQLCODE                  PIC S9(9)  COMP  VALUE 0.     
           05  S-SQLSTATE                 PIC X(5)   VALUE ' '.         
           05  S-TABLE-NAME               PIC X(18)  VALUE SPACES.      
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4)  USAGE COMP.        
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4)  USAGE COMP.        
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4)  USAGE COMP.        
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L    PIC S9(4)  USAGE COMP.        
               49  WS-ABEND-SQLERRMC-V    PIC X(255).                   
           05  WS-SQLSTATE                PIC X(05)  VALUE SPACES.      
           05  WS-GTT-NAME                PIC X(19)  VALUE SPACES.      
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00720000
              INCLUDE TBACCT                                            00730000
           END-EXEC.                                                    00740000
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFMT                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM  - DZ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFRE                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_CUST_ALERT     - CA                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00640000
              INCLUDE TBCSTALT                                          00650000
           END-EXEC.                                                    00660000
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN      - PY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBPHYSN                                           00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_PHYSICIAN_ATTR - PA                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBPHYADD                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_NAME           - DQ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBNAME                                            00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT   - UT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBUTLENV                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE     - PF                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01070000
              INCLUDE TBUSRPRF                                          01080000
           END-EXEC.                                                    01090000
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT                  *        
      ******************************************************************        
                                                                        
           COPY CWS00056.                                               01680000
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET PHYSICIAN/PATIENT DETAILS             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CUST_ALERT CURSOR FOR                             
               SELECT ALERT_COMMENTS                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CUST_ALERT_SEQ_NO, 121), ' ', '-'), ':', '.') 
           CUST_ALERT_SEQ_NO                                 
                     ,DATE_ALERT                                        
                     ,DATE_EXPIRE                                       
                     ,ADDRESS_OVERFLOW                                  
                     ,ADDR_ZIP_CODE                                     
                     ,ADDR_STREET                                       
                     ,ADDR_COUNTRY                                      
                     ,ADDR_CITY_STATE                                   
                     ,ALERT_CONTACT_NAME                                
                     ,PATIENT_NAME_ID                                   
                     ,PHYSICIAN_ID                                      
                     ,LAST_UPDATE_USERID                                
                 FROM CSS_CUST_ALERT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                       
                ORDER BY DATE_ALERT DESC                                
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02090000
MFA-TR*       DECLARE CUST_ALERT CURSOR FOR                                     
MFA-TR*        SELECT ALERT_COMMENTS                                    02100000
MFA-TR*              ,CUST_ALERT_SEQ_NO                                 02110000
MFA-TR*              ,DATE_ALERT                                        02120000
MFA-TR*              ,DATE_EXPIRE                                       02130000
MFA-TR*              ,ADDRESS_OVERFLOW                                  02140000
MFA-TR*              ,ADDR_ZIP_CODE                                     02150000
MFA-TR*              ,ADDR_STREET                                       02160000
MFA-TR*              ,ADDR_COUNTRY                                      02170000
MFA-TR*              ,ADDR_CITY_STATE                                   02180000
MFA-TR*              ,ALERT_CONTACT_NAME                                02190000
MFA-TR*              ,PATIENT_NAME_ID                                           
MFA-TR*              ,PHYSICIAN_ID                                              
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*          FROM CSS_CUST_ALERT                                    02200000
MFA-TR*         WHERE ACCOUNT_NO = :CA-ACCOUNT-NO                       02210000
MFA-TR*         ORDER BY DATE_ALERT DESC                                02220000
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                    02230000
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO            PIC 9(13).                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************02300000
      * 0000-MAINLINE                                                  *02310000
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *02370000
      ******************************************************************02380000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                THRU 0100-EXIT.       
           PERFORM 1000-PROCESS-INPUT             THRU 1000-EXIT.       
           PERFORM 2000-PROCESS-OUTPUT            THRU 2000-EXIT.       
           PERFORM 9999-END-PROGRAM               THRU 9999-EXIT.       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02500000
      * 0100-INITIALIZE                                                *02510000
      ******************************************************************02620000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT              THRU 0100A-EXIT.      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04850'          TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04850')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04850
              (                                                          
                  RETURN_CODE              INT                      
                 ,CUST_ALERT_SEQ_NO CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,DATE_ALERT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,DATE_EXPIRE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,CODE_DISC_OK CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,ELEC_GAS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,AMT_PAST_DUE             DECIMAL(11,2)                
                 ,BANKRUPTCY_IND CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,TOT_BAL_UTL              DECIMAL(11,2)                
                 ,TOT_BAL_NONUTL           DECIMAL(11,2)                
                 ,CODE_CRIT_OUTAGE CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,PATIENT_NAME CHAR(82)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,PHYSICIAN_NAME CHAR(82)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,PHYSICIAN_LICENSE CHAR(11)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ADDRESS_LINE1 CHAR(89)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ADDRESS_LINE2 CHAR(12)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ADDR_CITY_STATE CHAR(30)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ADDR_ZIP_CODE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ESTABLISHED_BY CHAR(07)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ESTABLISHED_BY_NAME CHAR(70)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,ARRANGEMENT_FLAG CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT *                                                 
               FROM #CSR04850                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR04850                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************02910000
      * 1000-PROCESS-INPUT                                             *03000000
      ******************************************************************02980000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO            
                                               CA-ACCOUNT-NO            
                                               UT-ACCOUNT-NO.           
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03380000
      * 2000-PROCESS-OUTPUT.                                           *03390000
      ******************************************************************03470000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      * INITIALIZE                                                              
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           PERFORM 7010-SELECT-ACCOUNT            THRU 7010-EXIT.       
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
           MOVE 'N'                         TO S-ARRANGEMENT-FLAG       
           IF (AT-CODES-DATA-PRESENT(22:1) = 'A') OR                    
              (AT-CODES-DATA-PRESENT(32:1) = 'A')                       
              MOVE 'Y'                      TO S-ARRANGEMENT-FLAG       
           END-IF.                                                      
           MOVE AT-BANKRUPTCY-IND           TO S-BANKRUPTCY-IND         
ACT036     IF ((AT-CODE-CRIT-OUTAGE = 'WX') OR                          
ACT036         (AT-CODE-CRIT-OUTAGE = 'WP'))                            
ACT036        MOVE SPACES                   TO AT-CODE-CRIT-OUTAGE      
ACT036     END-IF.                                                      
           MOVE AT-CODE-CRIT-OUTAGE         TO S-CODE-CRIT-OUTAGE       
           MOVE AT-CODE-DISC-OK             TO S-CODE-DISC-OK.          
                                                                        
           PERFORM 6000-CALL-MCSCB068             THRU 6000-EXIT.       
           MOVE WS-TOTAL-BALANCE            TO S-AMT-PAST-DUE.          
           MOVE WS-TOTAL-BALANCE-UTL        TO S-TOT-BAL-UTL.           
           MOVE WS-TOTAL-BALANCE-NONUTL     TO S-TOT-BAL-NONUTL.        
                                                                        
      *    Populate Electric/Gas Indicator                                      
           MOVE 'N'                         TO WS-ELEC-GAS.             
           PERFORM 7020-SELECT-ELEC-GAS          THRU 7020-EXIT.        
           MOVE WS-ELEC-GAS                 TO S-ELEC-GAS.              
                                                                        
           PERFORM 7500-OPEN-CUST-ALERT-CURSOR    THRU 7500-EXIT.       
           PERFORM 7510-FETCH-CUST-ALERT-CURSOR   THRU 7510-EXIT.       
           PERFORM 2100-PROCESS-CUST-ALERT        THRU 2100-EXIT        
                UNTIL SQLCODE = NOT-FOUND.                              
           PERFORM 7520-CLOSE-CUST-ALERT-CURSOR   THRU 7520-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09180000
      * 2100-PROCESS-CUST-ALERT                                        *09190000
      ******************************************************************09270000
                                                                        
       2100-PROCESS-CUST-ALERT.                                         
                                                                        
           PERFORM 2120-MOVE-COMMON-OUTPUT-VAR      THRU 2120-EXIT.     
                                                                        
      *    Select Patient name from CSS_NAME table                              
           IF CA-PATIENT-NAME-ID > 0                                    
              MOVE CA-PATIENT-NAME-ID       TO DQ-NAME-ID               
              PERFORM 7040-SELECT-PATIENT-PHY-NAME  THRU 7040-EXIT      
              MOVE WS-FULL-NAME             TO S-PATIENT-NAME           
           ELSE                                                         
      *       For legacy patient name should be spaces                          
              MOVE SPACES                   TO S-PATIENT-NAME           
           END-IF.                                                      
                                                                        
      *    Select Physician related information                                 
           IF CA-PHYSICIAN-ID > 0                                       
              PERFORM 7050-SELECT-PHYSICIAN-DTLS    THRU 7050-EXIT      
              MOVE WS-PHYSICIAN-LICENSE     TO S-PHYSICIAN-LICENSE      
              MOVE PY-NAME-ID               TO DQ-NAME-ID               
              PERFORM 7040-SELECT-PATIENT-PHY-NAME  THRU 7040-EXIT      
              MOVE WS-FULL-NAME             TO S-PHYSICIAN-NAME         
              PERFORM 2150-GET-PHY-ADDRESS-MOD      THRU 2150-EXIT      
           ELSE                                                         
              MOVE SPACES                   TO S-PHYSICIAN-LICENSE      
              PERFORM 2160-GET-PHY-ADDRESS-LEGACY   THRU 2160-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT                  THRU 8010-EXIT.     
                                                                        
           PERFORM 7510-FETCH-CUST-ALERT-CURSOR     THRU 7510-EXIT.     
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-MOVE-COMMON-OUTPUT-VAR                                    *        
      ******************************************************************        
                                                                        
       2120-MOVE-COMMON-OUTPUT-VAR.                                     
                                                                        
           MOVE CA-CUST-ALERT-SEQ-NO        TO S-CUST-ALERT-SEQ-NO.     
           MOVE CA-DATE-ALERT               TO WS-DATE-ALERT.           
           MOVE CA-DATE-EXPIRE              TO WS-DATE-EXPIRE.          
           MOVE SPACES                      TO CA-ALERT-COMMENTS-TEXT.  
                                                                        
      *    Convert USA date format                                              
           PERFORM 7030-GET-USA-DATE             THRU 7030-EXIT.        
           MOVE WS-DATE-ALERT-USA           TO S-DATE-ALERT.            
           MOVE WS-DATE-EXPIRE-USA          TO S-DATE-EXPIRE.           
           MOVE CA-LAST-UPDATE-USERID       TO S-ESTABLISHED-BY.        
           PERFORM 7080-SEL-ESTABLISHED-NAME     THRU 7080-EXIT.        
           MOVE WS-ESTABLISHED-BY-NAME      TO S-ESTABLISHED-BY-NAME.   
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2130-MOVE-FORMATTED-OUTPUT-VAR                                 *        
      ******************************************************************        
                                                                        
       2130-MOVE-FORMATTED-OUTPUT-VAR.                                  
                                                                        
           MOVE WS-ADDRESS-LINE1            TO S-ADDRESS-LINE1.         
           MOVE WS-ADDRESS-LINE2            TO S-ADDRESS-LINE2.         
           MOVE WS-TOWN-STATE               TO S-ADDR-CITY-STATE.       
           IF DY-ZIP-CODE-PLUS-FOUR EQUAL SPACES                        
              MOVE DY-ZIP-CODE              TO S-ADDR-ZIP-CODE          
           ELSE                                                         
              STRING DY-ZIP-CODE(1:5) '-'                               
                     DY-ZIP-CODE-PLUS-FOUR DELIMITED BY SIZE            
                     INTO S-ADDR-ZIP-CODE                               
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2140-MOVE-FREEFORM-OUTPUT-VAR                                  *        
      ******************************************************************        
                                                                        
       2140-MOVE-FREEFORM-OUTPUT-VAR.                                   
                                                                        
           MOVE DZ-ADDR-STREET              TO S-ADDRESS-LINE1.         
           MOVE DZ-ADDRESS-OVERFLOW         TO S-ADDRESS-LINE2.         
           MOVE DZ-ADDR-CITY-STATE          TO S-ADDR-CITY-STATE.       
           IF DZ-ADDR-ZIP-CODE(6:4) EQUAL SPACES                        
              MOVE DZ-ADDR-ZIP-CODE         TO S-ADDR-ZIP-CODE          
           ELSE                                                         
              STRING DZ-ADDR-ZIP-CODE(1:5) '-'                          
                     DZ-ADDR-ZIP-CODE(6:4) DELIMITED BY SIZE            
                     INTO S-ADDR-ZIP-CODE                               
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-GET-PHY-ADDRESS-MOD                                       *        
      ******************************************************************        
                                                                        
       2150-GET-PHY-ADDRESS-MOD.                                        
                                                                        
           IF PA-ADDRESS-FORMAT = 'B'                                   
              PERFORM 7070-SELECT-PHY-ADDR-FF        THRU 7070-EXIT     
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2140-MOVE-FREEFORM-OUTPUT-VAR                  
                                                     THRU 2140-EXIT     
              ELSE                                                      
                 PERFORM 2170-INITIALIZE-ADDR-FIELDS THRU 2170-EXIT     
              END-IF                                                    
           ELSE                                                         
              PERFORM 7060-SELECT-PHY-ADDR-FMT       THRU 7060-EXIT     
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2130-MOVE-FORMATTED-OUTPUT-VAR                 
                                                     THRU 2130-EXIT     
              ELSE                                                      
                 PERFORM 2170-INITIALIZE-ADDR-FIELDS THRU 2170-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2160-GET-PHY-ADDRESS-LEGACY                                    *        
      ******************************************************************        
                                                                        
       2160-GET-PHY-ADDRESS-LEGACY.                                     
                                                                        
           IF CA-ADDR-ZIP-CODE(6:4) EQUAL SPACES                        
              MOVE CA-ADDR-ZIP-CODE         TO S-ADDR-ZIP-CODE          
           ELSE                                                         
              STRING CA-ADDR-ZIP-CODE(1:5) '-'                          
                     CA-ADDR-ZIP-CODE(6:4) DELIMITED BY SIZE            
                     INTO S-ADDR-ZIP-CODE                               
           END-IF.                                                      
           MOVE CA-ADDR-STREET              TO S-ADDRESS-LINE1.         
           MOVE CA-ADDRESS-OVERFLOW         TO S-ADDRESS-LINE2.         
           MOVE CA-ADDR-CITY-STATE          TO S-ADDR-CITY-STATE.       
           MOVE CA-ALERT-CONTACT-NAME       TO S-PHYSICIAN-NAME.        
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2170-INITIALIZE-ADDR-FIELDS                                    *        
      ******************************************************************        
                                                                        
       2170-INITIALIZE-ADDR-FIELDS.                                     
                                                                        
           MOVE SPACES                      TO S-ADDRESS-LINE1          
                                               S-ADDRESS-LINE2          
                                               S-ADDR-CITY-STATE        
                                               S-ADDR-ZIP-CODE.         
                                                                        
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-CALL-MCSCB068                                             *        
      ******************************************************************        
                                                                        
       6000-CALL-MCSCB068.                                              
                                                                        
      * Set CPD00068 Switches that are needed                                   
           MOVE'Y'                          TO CALC-BALANCE-SW          
                                               CALC-BAL-ONLY-SW.        
                                                                        
           MOVE PROGRAM-NAME                TO WS-CPD00068-CALLING-PGM. 
           MOVE SPACES                      TO ABEND-FUNCTION.          
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE,   
                                               S-RETURN-CODE.           
           IF ABEND-FUNCTION  > SPACES                                  
               IF ABEND-FUNCTION EQUAL 'BADDATA'                        
                  MOVE -1                   TO S-RETURN-CODE,           
                                               WS-ACTIVE-RETURN-CODE    
               END-IF                                                   
               ADD +1                       TO CTR-ROWS                 
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7010-SELECT-ACCOUNT                                            *11850000
      ******************************************************************11920000
                                                                        
       7010-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODE_DISC_OK                                       
                    ,CODE_ACCT_STAT                                     
                    ,NOTICE_EXEMPT_CD                                   
                    ,DATE_BILL_DAY_00                                   
                    ,DATE_BILL_DAY_30                                   
                    ,DATE_BILL_DAY_60                                   
                    ,DATE_BILL_DAY_90                                   
                    ,CREDIT_GROUP                                       
                    ,CODES_DATA_PRESENT                                 
                    ,BANKRUPTCY_IND                                     
                    ,COMPANY_NO                                         
                    ,LOCAL_OFFICE                                       
                    ,IVR_EXEMPT_CD                                      
                    ,CODE_CRIT_OUTAGE                                   
                    ,ADDRESS_FORMAT                                     
                INTO :AT-CODE-DISC-OK                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-NULL          
                    ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-NULL          
                    ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-NULL          
                    ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-NULL          
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-CODE-CRIT-OUTAGE                               
                    ,:AT-ADDRESS-FORMAT                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT CODE_DISC_OK                                       11990000
MFA-TR*             ,CODE_ACCT_STAT                                     11991000
MFA-TR*             ,NOTICE_EXEMPT_CD                                   11992000
MFA-TR*             ,DATE_BILL_DAY_00                                   11993000
MFA-TR*             ,DATE_BILL_DAY_30                                   11994000
MFA-TR*             ,DATE_BILL_DAY_60                                   11995000
MFA-TR*             ,DATE_BILL_DAY_90                                   11996000
MFA-TR*             ,CREDIT_GROUP                                       11997000
MFA-TR*             ,CODES_DATA_PRESENT                                 11998000
MFA-TR*             ,BANKRUPTCY_IND                                     11999000
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,IVR_EXEMPT_CD                                              
MFA-TR*             ,CODE_CRIT_OUTAGE                                           
MFA-TR*             ,ADDRESS_FORMAT                                             
MFA-TR*         INTO :AT-CODE-DISC-OK                                   12000000
MFA-TR*             ,:AT-CODE-ACCT-STAT                                 12001000
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                               12002000
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-DATE-BILL-00-NULL          12003000
MFA-TR*             ,:AT-DATE-BILL-DAY-30:WS-DATE-BILL-30-NULL          12004000
MFA-TR*             ,:AT-DATE-BILL-DAY-60:WS-DATE-BILL-60-NULL          12005000
MFA-TR*             ,:AT-DATE-BILL-DAY-90:WS-DATE-BILL-90-NULL          12006000
MFA-TR*             ,:AT-CREDIT-GROUP                                   12007000
MFA-TR*             ,:AT-CODES-DATA-PRESENT                             12008000
MFA-TR*             ,:AT-BANKRUPTCY-IND                                 12009000
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-CODE-CRIT-OUTAGE                                       
MFA-TR*             ,:AT-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_ACCOUNT                                        12010000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DATE-BILL-00-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-00                     
                 MOVE ZEROES TO WS-DATE-BILL-00-NULL                    
              END-IF                                                    
              IF WS-DATE-BILL-30-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-30                     
                 MOVE ZEROES TO WS-DATE-BILL-30-NULL                    
              END-IF                                                    
              IF WS-DATE-BILL-60-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-60                     
                 MOVE ZEROES TO WS-DATE-BILL-60-NULL                    
              END-IF                                                    
              IF WS-DATE-BILL-90-NULL < 0                               
                 MOVE SPACES TO AT-DATE-BILL-DAY-90                     
                 MOVE ZEROES TO WS-DATE-BILL-90-NULL                    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11430000
      * 7020-SELECT-ELEC-GAS.                                          *11440000
      ******************************************************************11510000
                                                                        
       7020-SELECT-ELEC-GAS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ELEC-GAS                                       
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                   
                 AND CODE_UTIL_TYPE IN ('E','G')                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11580000
MFA-TR*       SELECT 'Y'                                                11590000
MFA-TR*         INTO :WS-ELEC-GAS                                       11600000
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   11610000
MFA-TR*        WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                   11620000
MFA-TR*          AND CODE_UTIL_TYPE IN ('E','G')                        11630000
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                    11640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMNT'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12230000
      * 7030-GET-USA-DATE                                              *12240000
      ******************************************************************12310000
                                                                        
       7030-GET-USA-DATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-ALERT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-ALERT
              ) <> 0) OR (LEN(:WS-DATE-ALERT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-ALERT
              ), CONVERT(DATE, :WS-DATE-ALERT) ),'USA'),
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXPIRE
              ) <> 0) OR (LEN(:WS-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-EXPIRE
              ), CONVERT(DATE, :WS-DATE-EXPIRE) ),'USA')
            INTO
              :WS-DATE-ALERT-USA,
              :WS-DATE-EXPIRE-USA 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SET :WS-DATE-ALERT-USA  = CHAR(DATE(:WS-DATE-ALERT),USA)          
MFA-TR*          ,:WS-DATE-EXPIRE-USA = CHAR(DATE(:WS-DATE-EXPIRE),USA)         
MFA-TR*    END-EXEC.                                                    12430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'WS-DATE-ALERT'          TO TABLE-ELEMENT-1          
              MOVE 'WS-DATE-EXPIRE'         TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE WS-DATE-ALERT            TO HOSTVAR-ELEMENT-1        
              MOVE WS-DATE-EXPIRE           TO HOSTVAR-ELEMENT-2        
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************11840000
      * 7040-SELECT-PATIENT-PHY-NAME                                    11850000
      ******************************************************************11920000
                                                                        
       7040-SELECT-PATIENT-PHY-NAME.                                    
                                                                        
           EXEC SQL                                                     
              SELECT RTRIM(LTRIM(RTRIM(DQ.TITLE_PREFIX) + ' ' + LTRIM(
           RTRIM(DQ.FIRST_NAME) + ' ' + LTRIM(RTRIM(DQ.MIDDLE_NAME) + 
           ' ' + LTRIM(RTRIM(DQ.LAST_NAME) + ' ' + LTRIM(RTRIM(
           DQ.TITLE_SUFFIX_1)))))))               
                INTO :WS-FULL-NAME                                      
                FROM CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE DQ.NAME_ID = :DQ-NAME-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(DQ.TITLE_PREFIX) || ' ' ||               
MFA-TR*              LTRIM(RTRIM(DQ.FIRST_NAME) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(DQ.MIDDLE_NAME) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(DQ.LAST_NAME) || ' ' ||                        
MFA-TR*              LTRIM(RTRIM(DQ.TITLE_SUFFIX_1)))))))                       
MFA-TR*         INTO :WS-FULL-NAME                                      12000000
MFA-TR*         FROM CSS_NAME DQ                                        12010000
MFA-TR*        WHERE DQ.NAME_ID = :DQ-NAME-ID                           12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'NAME_ID'                TO TABLE-ELEMENT-1          
              MOVE DQ-NAME-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7050-SELECT-PHYSICIAN-DTLS                                      11850000
      ******************************************************************11920000
                                                                        
       7050-SELECT-PHYSICIAN-DTLS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT PY.NAME_ID                                         
                    ,RTRIM(LTRIM(RTRIM(PY.MED_LIC_STATE_CD) + ' ' + 
           LTRIM(RTRIM(PY.MED_LICENSE_NO))))                  
                    ,PA.ADDRESS_ID                                      
                    ,PA.ADDRESS_FORMAT                                  
                INTO :PY-NAME-ID                                        
                    ,:WS-PHYSICIAN-LICENSE                              
                    ,:PA-ADDRESS-ID                                     
                    ,:PA-ADDRESS-FORMAT                                 
                FROM CSS_PHYSICIAN      PY WITH(READUNCOMMITTED)                
                    ,CSS_PHYSICIAN_ATTR PA WITH(READUNCOMMITTED)                
               WHERE PY.PHYSICIAN_ID = :CA-PHYSICIAN-ID                 
                 AND PA.PHYSICIAN_ID = PY.PHYSICIAN_ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT PY.NAME_ID                                                 
MFA-TR*             ,RTRIM(LTRIM(RTRIM(PY.MED_LIC_STATE_CD) || ' ' ||           
MFA-TR*              LTRIM(RTRIM(PY.MED_LICENSE_NO))))                          
MFA-TR*             ,PA.ADDRESS_ID                                      11990000
MFA-TR*             ,PA.ADDRESS_FORMAT                                          
MFA-TR*         INTO :PY-NAME-ID                                        12000000
MFA-TR*             ,:WS-PHYSICIAN-LICENSE                                      
MFA-TR*             ,:PA-ADDRESS-ID                                     12000000
MFA-TR*             ,:PA-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_PHYSICIAN      PY                              12010000
MFA-TR*             ,CSS_PHYSICIAN_ATTR PA                              12010000
MFA-TR*        WHERE PY.PHYSICIAN_ID = :CA-PHYSICIAN-ID                         
MFA-TR*          AND PA.PHYSICIAN_ID = PY.PHYSICIAN_ID                  12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_PHYSICIAN_ATTR'     TO TABLE-1                  
              MOVE 'PHYSICIAN_ID'           TO TABLE-ELEMENT-1          
              MOVE CA-PHYSICIAN-ID          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7060-SELECT-PHY-ADDR-FMT                                       *11850000
      ******************************************************************11920000
                                                                        
       7060-SELECT-PHY-ADDR-FMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) + ' ' + LTRIM(RTRIM(
           DY.ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(DY.ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(DY.STREET_NAME) + ' ' + LTRIM(RTRIM(
           DY.STREET_SUFFIX) + ' ' + LTRIM(RTRIM(DY.ADDR_SUFFIX))))))))        
                    ,RTRIM(LTRIM(RTRIM(DY.STREET_LOCATION_1) + ' ' + 
           LTRIM(RTRIM(DY.STREET_LOCATION_2))))               
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,RTRIM(LTRIM(RTRIM(A4.TOWN) + ' ' + LTRIM(RTRIM(
           A4.STATE))))                           
                INTO :WS-ADDRESS-LINE1                                  
                    ,:WS-ADDRESS-LINE2                                  
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:WS-TOWN-STATE                                     
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
                    ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
               WHERE DY.ADDRESS_ID     = :PA-ADDRESS-ID                 
                 AND DY.ZIP_CODE       = A4.ZIP_CODE                    
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(DY.ADDR_PREFIX_1) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DY.ADDR_PREFIX_2) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DY.STREET_NAME) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(DY.STREET_SUFFIX) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(DY.ADDR_SUFFIX))))))))                         
MFA-TR*             ,RTRIM(LTRIM(RTRIM(DY.STREET_LOCATION_1) || ' ' ||          
MFA-TR*              LTRIM(RTRIM(DY.STREET_LOCATION_2))))                       
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,RTRIM(LTRIM(RTRIM(A4.TOWN) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(A4.STATE))))                                   
MFA-TR*         INTO :WS-ADDRESS-LINE1                                  12000000
MFA-TR*             ,:WS-ADDRESS-LINE2                                          
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:WS-TOWN-STATE                                     14200000
MFA-TR*         FROM CSS_ADDR_FORMATTED DY                              12010000
MFA-TR*             ,CSS_ZIP_CODE       A4                              15870000
MFA-TR*        WHERE DY.ADDRESS_ID     = :PA-ADDRESS-ID                 12020000
MFA-TR*          AND DY.ZIP_CODE       = A4.ZIP_CODE                            
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-1                  
              MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-1          
              MOVE PA-ADDRESS-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7070-SELECT-PHY-ADDR-FF                                        *11850000
      ******************************************************************11920000
                                                                        
       7070-SELECT-PHY-ADDR-FF.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DZ.ADDRESS_OVERFLOW                                
                    ,DZ.ADDR_STREET                                     
                    ,DZ.ADDR_COUNTRY                                    
                    ,DZ.ADDR_CITY_STATE                                 
                    ,DZ.ADDR_ZIP_CODE                                   
                INTO :DZ-ADDRESS-OVERFLOW                               
                    ,:DZ-ADDR-STREET                                    
                    ,:DZ-ADDR-COUNTRY                                   
                    ,:DZ-ADDR-CITY-STATE                                
                    ,:DZ-ADDR-ZIP-CODE                                  
                FROM CSS_ADDR_FREEFORM  DZ WITH(READUNCOMMITTED)                
               WHERE DZ.ADDRESS_ID   = :PA-ADDRESS-ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT DZ.ADDRESS_OVERFLOW                                11990000
MFA-TR*             ,DZ.ADDR_STREET                                             
MFA-TR*             ,DZ.ADDR_COUNTRY                                            
MFA-TR*             ,DZ.ADDR_CITY_STATE                                         
MFA-TR*             ,DZ.ADDR_ZIP_CODE                                           
MFA-TR*         INTO :DZ-ADDRESS-OVERFLOW                               12000000
MFA-TR*             ,:DZ-ADDR-STREET                                            
MFA-TR*             ,:DZ-ADDR-COUNTRY                                           
MFA-TR*             ,:DZ-ADDR-CITY-STATE                                        
MFA-TR*             ,:DZ-ADDR-ZIP-CODE                                          
MFA-TR*         FROM CSS_ADDR_FREEFORM  DZ                              12010000
MFA-TR*        WHERE DZ.ADDRESS_ID   = :PA-ADDRESS-ID                   12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ADDR_FREEFORM'      TO TABLE-1                  
              MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-1          
              MOVE PA-ADDRESS-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11840000
      * 7080-SEL-ESTABLISHED-NAME.                                     *11850000
      ******************************************************************11920000
                                                                        
       7080-SEL-ESTABLISHED-NAME.                                       
                                                                        
           EXEC SQL                                                     
              SELECT RTRIM(LTRIM(RTRIM(PF.LAST_NAME) + ',' + ' ' + 
           LTRIM(RTRIM(PF.FIRST_NAME))))                     
                INTO :WS-ESTABLISHED-BY-NAME                            
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :CA-LAST-UPDATE-USERID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11980000
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(PF.LAST_NAME) || ',' || ' ' ||           
MFA-TR*              LTRIM(RTRIM(PF.FIRST_NAME) )))                             
MFA-TR*         INTO :WS-ESTABLISHED-BY-NAME                            12000000
MFA-TR*         FROM CSS_USER_PROFILE PF                                12010000
MFA-TR*        WHERE PF.USER_ID = :CA-LAST-UPDATE-USERID                12020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                    12030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 CONTINUE                                               
            WHEN NOT-FOUND                                              
                 MOVE SPACES                TO WS-ESTABLISHED-BY-NAME   
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7080'                TO ACTIVE-PARAGRAPH         
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_USER_PROFILE'    TO TABLE-1                  
                 MOVE 'USER_ID'             TO TABLE-ELEMENT-1          
                 MOVE CA-LAST-UPDATE-USERID TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10320000
      * 7500-OPEN-CUST-ALERT-CURSOR                                    *10330000
      ******************************************************************10400000
                                                                        
       7500-OPEN-CUST-ALERT-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              OPEN CUST_ALERT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_ALERT'         TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09850000
      * 7510-FETCH-CUST-ALERT-CURSOR.                                  *09860000
      ******************************************************************09940000
                                                                        
       7510-FETCH-CUST-ALERT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              FETCH CUST_ALERT                                          
               INTO :CA-ALERT-COMMENTS                                  
                   ,:CA-CUST-ALERT-SEQ-NO                               
                   ,:CA-DATE-ALERT :WS-DATE-ALERT-NULL                 
                   ,:CA-DATE-EXPIRE :WS-DATE-EXPIRE-NULL                
                   ,:CA-ADDRESS-OVERFLOW                                
                   ,:CA-ADDR-ZIP-CODE                                   
                   ,:CA-ADDR-STREET                                     
                   ,:CA-ADDR-COUNTRY                                    
                   ,:CA-ADDR-CITY-STATE                                 
                   ,:CA-ALERT-CONTACT-NAME                              
P0726A             ,:CA-PATIENT-NAME-ID :WS-PTNT-NAME-ID-NULL           
P0726A             ,:CA-PHYSICIAN-ID :WS-PHYSICIAN-ID-NULL           
                   ,:CA-LAST-UPDATE-USERID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DATE-ALERT-NULL < 0                                 
                 MOVE SPACES             TO CA-DATE-ALERT               
                 MOVE ZEROES             TO WS-DATE-ALERT-NULL          
              END-IF                                                    
              IF WS-DATE-EXPIRE-NULL < 0                                
                 MOVE SPACES             TO CA-DATE-EXPIRE              
                 MOVE ZEROES             TO WS-DATE-EXPIRE-NULL         
              END-IF                                                    
P0726A        IF WS-PTNT-NAME-ID-NULL < 0                               
P0726A           MOVE ZEROES             TO CA-PATIENT-NAME-ID          
P0726A                                      WS-PTNT-NAME-ID-NULL        
P0726A        END-IF                                                    
P0726A        IF WS-PHYSICIAN-ID-NULL < 0                               
P0726A           MOVE ZEROES             TO CA-PHYSICIAN-ID             
P0726A                                      WS-PHYSICIAN-ID-NULL        
P0726A        END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7510'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_ALERT'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE CA-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10670000
      * 7520-CLOSE-CUST-ALERT-CURSOR                                   *10680000
      ******************************************************************10750000
                                                                        
       7520-CLOSE-CUST-ALERT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE CUST_ALERT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_ALERT'         TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04850                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04850                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '8000A'             TO ACTIVE-PARAGRAPH         
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE 'CSR04850'          TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT                                                *        
      ******************************************************************        
                                                                        
       8010-INSERT-GTT.                                                 
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04850                               
             (                                                          
              RETURN_CODE                                               
             ,CUST_ALERT_SEQ_NO                                         
             ,DATE_ALERT                                                
             ,DATE_EXPIRE                                               
             ,CODE_DISC_OK                                              
             ,ELEC_GAS                                                  
             ,AMT_PAST_DUE                                              
             ,BANKRUPTCY_IND                                            
             ,TOT_BAL_UTL                                               
             ,TOT_BAL_NONUTL                                            
             ,CODE_CRIT_OUTAGE                                          
             ,PATIENT_NAME                                              
             ,PHYSICIAN_NAME                                            
             ,PHYSICIAN_LICENSE                                         
             ,ADDRESS_LINE1                                             
             ,ADDRESS_LINE2                                             
             ,ADDR_CITY_STATE                                           
             ,ADDR_ZIP_CODE                                             
             ,ESTABLISHED_BY                                            
             ,ESTABLISHED_BY_NAME                                       
             ,ARRANGEMENT_FLAG                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-CUST-ALERT-SEQ-NO                                      
             ,:S-DATE-ALERT                                             
             ,:S-DATE-EXPIRE                                            
             ,:S-CODE-DISC-OK                                           
             ,:S-ELEC-GAS                                               
             ,:S-AMT-PAST-DUE                                           
             ,:S-BANKRUPTCY-IND                                         
             ,:S-TOT-BAL-UTL                                            
             ,:S-TOT-BAL-NONUTL                                         
             ,:S-CODE-CRIT-OUTAGE                                       
             ,:S-PATIENT-NAME                                           
             ,:S-PHYSICIAN-NAME                                         
             ,:S-PHYSICIAN-LICENSE                                      
             ,:S-ADDRESS-LINE1                                          
             ,:S-ADDRESS-LINE2                                          
             ,:S-ADDR-CITY-STATE                                        
             ,:S-ADDR-ZIP-CODE                                          
             ,:S-ESTABLISHED-BY                                         
             ,:S-ESTABLISHED-BY-NAME                                    
             ,:S-ARRANGEMENT-FLAG                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04850                                       
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CUST_ALERT_SEQ_NO                                                 
MFA-TR*      ,DATE_ALERT                                                        
MFA-TR*      ,DATE_EXPIRE                                                       
MFA-TR*      ,CODE_DISC_OK                                                      
MFA-TR*      ,ELEC_GAS                                                          
MFA-TR*      ,AMT_PAST_DUE                                                      
MFA-TR*      ,BANKRUPTCY_IND                                                    
MFA-TR*      ,TOT_BAL_UTL                                                       
MFA-TR*      ,TOT_BAL_NONUTL                                                    
MFA-TR*      ,CODE_CRIT_OUTAGE                                                  
MFA-TR*      ,PATIENT_NAME                                                      
MFA-TR*      ,PHYSICIAN_NAME                                                    
MFA-TR*      ,PHYSICIAN_LICENSE                                                 
MFA-TR*      ,ADDRESS_LINE1                                                     
MFA-TR*      ,ADDRESS_LINE2                                                     
MFA-TR*      ,ADDR_CITY_STATE                                                   
MFA-TR*      ,ADDR_ZIP_CODE                                                     
MFA-TR*      ,ESTABLISHED_BY                                                    
MFA-TR*      ,ESTABLISHED_BY_NAME                                               
MFA-TR*      ,ARRANGEMENT_FLAG                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-CUST-ALERT-SEQ-NO                                              
MFA-TR*      ,:S-DATE-ALERT                                                     
MFA-TR*      ,:S-DATE-EXPIRE                                                    
MFA-TR*      ,:S-CODE-DISC-OK                                                   
MFA-TR*      ,:S-ELEC-GAS                                                       
MFA-TR*      ,:S-AMT-PAST-DUE                                                   
MFA-TR*      ,:S-BANKRUPTCY-IND                                                 
MFA-TR*      ,:S-TOT-BAL-UTL                                                    
MFA-TR*      ,:S-TOT-BAL-NONUTL                                                 
MFA-TR*      ,:S-CODE-CRIT-OUTAGE                                               
MFA-TR*      ,:S-PATIENT-NAME                                                   
MFA-TR*      ,:S-PHYSICIAN-NAME                                                 
MFA-TR*      ,:S-PHYSICIAN-LICENSE                                              
MFA-TR*      ,:S-ADDRESS-LINE1                                                  
MFA-TR*      ,:S-ADDRESS-LINE2                                                  
MFA-TR*      ,:S-ADDR-CITY-STATE                                                
MFA-TR*      ,:S-ADDR-ZIP-CODE                                                  
MFA-TR*      ,:S-ESTABLISHED-BY                                                 
MFA-TR*      ,:S-ESTABLISHED-BY-NAME                                            
MFA-TR*      ,:S-ARRANGEMENT-FLAG                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS                
                                                WS-INSERT-REC-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04850'               TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
           PERFORM 8010-INSERT-GTT          THRU 8010-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF WS-INSERT-REC-COUNT = 0                                   
              MOVE 100                      TO S-RETURN-CODE            
              PERFORM 8010-INSERT-GTT       THRU 8010-EXIT              
           END-IF.                                                      
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
                                                                        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
