      ******************************************************************        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04849.                                     
COB303 DATE-WRITTEN.      FEB 12, 2015.                                 
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04849              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04849 :                                                --         
      *--                                                            --         
      *--    #  CHECKS ACCOUNT INFO TO SEE IF A SERVICE REQUEST      --         
      *--    #  IS ELIGIBLE FOR AUTOMATED READ-ONLY PROCESSING (AROP)--         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--      IN                                                    --         
      *--                                                                       
      *--            ACCOUNT_NO                                                 
      *--            PREMISE_NO                                                 
      *--            SERV_ORDER_NO                                              
      *--                                                                       
      *--      OUT                                                   --         
      *--                                                            --         
      *--            RETURN_CODE                                     --         
      *--            AROP_ELIGIBLE_FL                                --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  2015-02-12    DB18339     NEW CODE                        --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ002  01 MFA-CSR00064.
MSQ002    05 ARG-3 PIC X(26).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04849'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT - AT                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_SO_DATA - VO                                                        
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_ORDER_INST - VI                                                  
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_APPLIANCE - VQ                                                   
           EXEC SQL                                                             
               INCLUDE TBSOEQP                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_MTRD_ENVRNMT - MN                                                   
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_ROUTE_REPORT - PW                                                   
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_WORK_AREA - I2                                                      
           EXEC SQL                                                             
               INCLUDE TBWKAR                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_SO_CAD_QUEUE   (PREFIX = QP)                              *         
           EXEC SQL                                                             
               INCLUDE TBCADPQU                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_SO_TASK_QUEUE  (PREFIX = TQ)                              *         
           EXEC SQL                                                             
               INCLUDE TBTSKQUE                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC 9(13).                       
           05  PARM-ACCOUNT-NO-CHR REDEFINES PARM-ACCOUNT-NO            
                                       PIC X(13).                       
           05  PARM-PREMISE-NO         PIC 9(10).                       
           05  PARM-PREMISE-NO-CHR REDEFINES PARM-PREMISE-NO            
                                       PIC X(10).                       
           05  PARM-SERV-ORDER-NO      PIC 9(13).                       
           05  PARM-SERV-ORDER-NO-CHR REDEFINES PARM-SERV-ORDER-NO      
                                       PIC X(13).                       
       01  MISC-FIELDS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04849'.      
           05  WS-SQLSTATE             PIC X(05) VALUE  SPACES.         
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
                                                                        
       01 WS-MISC.                                                      
          05 WS-RETURN-CODE-4747        PIC S9(09) COMP VALUE +0.       
          05 WS-WORK-DISTRICT-4747      PIC X(40).                      
          05 WS-NULL-1                  PIC S9(04) COMP VALUE +0.       
          05 WS-NULL-2                  PIC S9(04) COMP VALUE +0.       
          05 WS-WORK-AREA-ID            PIC X(08).                      
          05 WS-WORK-DISTRICT           PIC X(40) VALUE ' '.            
          05 WS-TIME                    PIC X(26).                      
          05 WS-COMMENTS                PIC X(210) VALUE ' '.           
          05 WS-WA-COMMENTS             PIC X(32) VALUE ' '.            
          05 WS-APPL-PGM-ID             PIC X(04) VALUE ' '.            
                                                                        
      *01 LOC04747 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
                                                                        
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  ABEND-CODES.                                                 
           05  DATE-ERROR              PIC S9(9) VALUE -180 COMP.       
                                                                        
       01  WS-DATE-FIELDS.                                              
           05  WS-ASSIGNED-DT          PIC X(10).                       
           05  WS-CURRENT-DT           PIC X(10).                       
           05  WS-LAST-DT              PIC X(10).                       
           05  WS-LAST-TS              PIC X(26).                       
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE         PIC S9(9) VALUE 0 COMP.            
           05 RS-AROP-ELIGIBLE-FL    PIC X(1).                          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           05 S-AROP-ELIGIBLE-FL     PIC X(1).                          
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747 ( :VO-SERV-ORDER-NO
                  , '1'
                  , 'S'
                  , ' '
                  , :WS-WORK-DISTRICT OUTPUT
                  )
MSQ001        END-EXEC.
             
                                                                        
       LINKAGE SECTION.                                                 
       01    LINK-ACCOUNT-NO           PIC X(13).                       
       01    LINK-PREMISE-NO           PIC X(10).                       
       01    LINK-SERV-ORDER-NO        PIC X(13).                       
                                                                        
       PROCEDURE DIVISION USING LINK-ACCOUNT-NO                         
                                LINK-PREMISE-NO                         
                                LINK-SERV-ORDER-NO.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-INPUT   THRU 1000-EXIT.                 
           PERFORM 2000-PROCESS-OUTPUT  THRU 2000-EXIT.                 
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS                                 
                      GTT-RETURN-FIELDS                                 
                      WS-MISC.                                          
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE AS RETURN_CODE,                    
                      :S-AROP-ELIGIBLE-FL AS AROP_ELIGIBLE_FL           
               FROM                                                     
               CIS.SYSDUMMY1                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE AS RETURN_CODE,                            
MFA-TR*               :S-AROP-ELIGIBLE-FL AS AROP_ELIGIBLE_FL                   
MFA-TR*        FROM                                                             
MFA-TR*        SYSIBM.SYSDUMMY1                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *0100A-DECLARE-GTT                                              *         
      *****************************************************************         
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04849_R1'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04849_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04849_R1
              (                                                       
                      RETURN_CODE           INT                     
                     ,AROP_ELIGIBLE_FL CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS                             
                                         THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04849_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
              PERFORM 8250-SEND-NULL-CODE THRU 8250-EXIT
           END-IF.               
           IF LINK-PREMISE-NO NOT NUMERIC                               
              PERFORM 8250-SEND-NULL-CODE THRU 8250-EXIT
           END-IF.               
      *    IF LINK-SERV-ORDER-NO NOT NUMERIC                                    
      *       PERFORM 8250-SEND-NULL-CODE THRU 8250-EXIT.                       
                                                                        
           MOVE LINK-ACCOUNT-NO    TO PARM-ACCOUNT-NO-CHR.              
           MOVE LINK-PREMISE-NO    TO PARM-PREMISE-NO-CHR.              
           MOVE LINK-SERV-ORDER-NO TO PARM-SERV-ORDER-NO-CHR.           
                                                                        
           MOVE PARM-ACCOUNT-NO    TO VO-ACCOUNT-NO-PRIOR               
                                      AT-ACCOUNT-NO.                    
           MOVE PARM-PREMISE-NO    TO VO-PREMISE-NO.                    
           MOVE PARM-SERV-ORDER-NO TO VO-SERV-ORDER-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *   1.  DESCRIBE RESULT SET                                      *        
      *   2.  BUILD RESULT SET                                         *        
      *   3.  SEND RESULT SET                                          *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           IF CTR-ROWS = 0                                              
              INITIALIZE                 TDS-RETURN-FIELDS              
              MOVE 100                   TO RS-RETURN-CODE              
              PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT                 
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-MOVE-RESULT.                                              *        
      ******************************************************************        
       2100-MOVE-RESULT.                                                
                                                                        
           MOVE '2100'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-AROP-ELIGIBLE-FL    TO S-AROP-ELIGIBLE-FL.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT.                                             *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                   TO ACTIVE-PARAGRAPH.           
           MOVE 'Y'                      TO RS-AROP-ELIGIBLE-FL.        
                                                                        
           PERFORM 7000-ACCT-INFO THRU 7000-EXIT.                       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 8250-SEND-NULL-CODE THRU 8250-EXIT
           END-IF.               
                                                                        
           PERFORM 7050-AMR-CHECK THRU 7050-EXIT.                       
           IF RS-AROP-ELIGIBLE-FL = 'N'                                 
              PERFORM 8200-SEND-NOT-ELIGIBLE-FLAG THRU 8200-EXIT
           END-IF.       
                                                                        
           PERFORM 7100-DNP-CHECK THRU 7100-EXIT.                       
           IF RS-AROP-ELIGIBLE-FL = 'N'                                 
              PERFORM 8200-SEND-NOT-ELIGIBLE-FLAG THRU 8200-EXIT
           END-IF.       
                                                                        
           IF VO-SERV-ORDER-NO > 0                                      
              PERFORM 7150-WORK-TYPE-CHECK THRU 7150-EXIT               
              IF RS-AROP-ELIGIBLE-FL = 'N'                              
                 PERFORM 8200-SEND-NOT-ELIGIBLE-FLAG THRU 8200-EXIT     
              END-IF                                                    
              PERFORM 7200-RELEASE-CHECK THRU 7200-EXIT                 
              IF RS-AROP-ELIGIBLE-FL = 'N'                              
                 PERFORM 8200-SEND-NOT-ELIGIBLE-FLAG THRU 8200-EXIT     
              END-IF                                                    
              PERFORM 7300-LIGHT-PILOT-CHECK THRU 7300-EXIT             
              IF RS-AROP-ELIGIBLE-FL = 'N'                              
                 PERFORM 8200-SEND-NOT-ELIGIBLE-FLAG THRU 8200-EXIT     
              END-IF                                                    
              PERFORM 2300-PROCESS-AROP-ORDER THRU 2300-EXIT            
              PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT                 
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           ELSE                                                         
              PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT                 
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-AROP-ORDER.                                       *        
      ******************************************************************        
       2300-PROCESS-AROP-ORDER.                                         
                                                                        
           MOVE '2300'                   TO ACTIVE-PARAGRAPH.           
           MOVE 'Y'                      TO RS-AROP-ELIGIBLE-FL.        
                                                                        
           PERFORM 7350-CURRENT-ORDER-INFO THRU 7350-EXIT.              
                                                                        
           PERFORM 7700-CHECK-CLICK THRU 7700-EXIT.                     
           IF WS-WORK-DISTRICT-4747 > SPACES                            
              PERFORM 8800-CLICK-CANCEL THRU 8800-EXIT                  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 8810-CLICK-TASK THRU 8810-EXIT                 
              END-IF                                                    
           ELSE                                                         
              PERFORM 8700-INSERT-CAD-CANCEL THRU 8700-EXIT             
           END-IF.                                                      
                                                                        
           MOVE VO-WORK-AREA-ID TO WS-WORK-AREA-ID.                     
                                                                        
           IF VO-ORDER-STATE-CD = 'H' AND VO-WORK-AREA-ID(1:3) = 'ARO'  
             NEXT SENTENCE                                              
           ELSE                                                         
             IF AT-COMPANY-NO = '01'                                    
                MOVE 'AROPSCEG' TO VO-WORK-AREA-ID                      
             ELSE                                                       
                MOVE 'AROPPSNC' TO VO-WORK-AREA-ID                      
             END-IF                                                     
             PERFORM 7400-UPDATE-ORDER THRU 7400-EXIT                   
             PERFORM 7500-INSERT-AUDIT THRU 7500-EXIT                   
             PERFORM 7600-INSERT-REMARKS THRU 7600-EXIT                 
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7000-ACCT-INFO.                                                        
      **************************************************************            
       7000-ACCT-INFO.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COMPANY_NO                                        
                INTO :AT-COMPANY-NO                                     
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'ACCT INFO'           TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7050-AMR-CHECK.                                                        
      **************************************************************            
       7050-AMR-CHECK.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                INTO :RS-AROP-ELIGIBLE-FL                               
               FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
               WHERE MN.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR               
                 AND MN.REMOTE_READ_IND <> 'A'                          
                 AND MN.CODE_METER_STATUS <> 'K'                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*         INTO :RS-AROP-ELIGIBLE-FL                                       
MFA-TR*        FROM CSS_MTRD_ENVRNMT MN                                         
MFA-TR*        WHERE MN.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR                       
MFA-TR*          AND MN.REMOTE_READ_IND <> 'A'                                  
MFA-TR*          AND MN.CODE_METER_STATUS <> 'K'                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'AMR CHECK'           TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7100-DNP-CHECK.                                                        
      **************************************************************            
       7100-DNP-CHECK.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                 INTO :RS-AROP-ELIGIBLE-FL                              
               FROM CSS_SO_DATA WITH(READUNCOMMITTED)                           
               WHERE PREMISE_NO = :VO-PREMISE-NO                        
               AND ORDER_TYPE_CD IN ('DNP01', 'FM006', 'DNPFB')         
               AND ORDER_STATE_CD IN ('A','B','D','H','R','Z')          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :RS-AROP-ELIGIBLE-FL                                      
MFA-TR*        FROM CSS_SO_DATA                                                 
MFA-TR*        WHERE PREMISE_NO = :VO-PREMISE-NO                                
MFA-TR*        AND ORDER_TYPE_CD IN ('DNP01', 'FM006', 'DNPFB')                 
MFA-TR*        AND ORDER_STATE_CD IN ('A','B','D','H','R','Z')                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'DNP CHECK'           TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7150-WORK-TYPE-CHECK.                                                  
      **************************************************************            
       7150-WORK-TYPE-CHECK.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                  INTO :RS-AROP-ELIGIBLE-FL                             
                FROM CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)                
                INNER JOIN CSS_SO_DATA VO WITH(READUNCOMMITTED)                 
                  ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                
                INNER JOIN CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)               
                  ON VO.COMPANY_NO = L4.COMPANY_NO                      
                  AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                 
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND L4.AROP_EXTRACT_IND = 'N'                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*           INTO :RS-AROP-ELIGIBLE-FL                                     
MFA-TR*         FROM CSS_SO_ORDER_INST  VI                                      
MFA-TR*         INNER JOIN CSS_SO_DATA VO                                       
MFA-TR*           ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                        
MFA-TR*         INNER JOIN CSS_WORK_TYPE L4                                     
MFA-TR*           ON VO.COMPANY_NO = L4.COMPANY_NO                              
MFA-TR*           AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                         
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*           AND L4.AROP_EXTRACT_IND = 'N'                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'WORK TYPE CHECK'     TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7200-RELEASE-CHECK.                                                    
      **************************************************************            
       7200-RELEASE-CHECK.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                 INTO :RS-AROP-ELIGIBLE-FL                              
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND WORK_TYPE_CD  > ' '                               
                  AND HOLD_RELEASE  = 'Y'                               
                  AND RLSE_NO       = ' '                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :RS-AROP-ELIGIBLE-FL                                      
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND WORK_TYPE_CD  > ' '                                       
MFA-TR*           AND HOLD_RELEASE  = 'Y'                                       
MFA-TR*           AND RLSE_NO       = ' '                                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'RELEASE CHECK'       TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7300-LIGHT-PILOT-CHECK.                                                
      **************************************************************            
       7300-LIGHT-PILOT-CHECK.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                 INTO :RS-AROP-ELIGIBLE-FL                              
               FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED)                   
               WHERE VQ.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
                 AND VQ.CODE_UTIL_TYPE = 'G'                            
                 AND VQ.LIGHT_IND = 'Y'                                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :RS-AROP-ELIGIBLE-FL                                      
MFA-TR*        FROM CSS_SO_APPLIANCE VQ                                         
MFA-TR*        WHERE VQ.SERV_ORDER_NO = :VO-SERV-ORDER-NO                       
MFA-TR*          AND VQ.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND VQ.LIGHT_IND = 'Y'                                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'LIGHT PILOT CHECK'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  7350-CURRENT-ORDER-INFO.                                               
      **************************************************************            
       7350-CURRENT-ORDER-INFO.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) VO.WORK_AREA_ID,
              I2.WORK_AREA_TX,
              VO.ORDER_STATE_CD,
              VO.COMPANY_NO,
              VO.SO_BUSINESS_UNIT                               
                 INTO :VO-WORK-AREA-ID,                                 
                      :I2-WORK-AREA-TX,                                 
                      :VO-ORDER-STATE-CD,                               
                      :VO-COMPANY-NO,                                   
                      :VO-SO-BUSINESS-UNIT                              
               FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                        
               INNER JOIN CSS_WORK_AREA I2 WITH(READUNCOMMITTED)                
                  ON VO.COMPANY_NO = I2.COMPANY_NO                      
                 AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                  
               WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.WORK_AREA_ID,                                          
MFA-TR*               I2.WORK_AREA_TX,                                          
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.COMPANY_NO,                                            
MFA-TR*               VO.SO_BUSINESS_UNIT                                       
MFA-TR*          INTO :VO-WORK-AREA-ID,                                         
MFA-TR*               :I2-WORK-AREA-TX,                                         
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-COMPANY-NO,                                           
MFA-TR*               :VO-SO-BUSINESS-UNIT                                      
MFA-TR*        FROM CSS_SO_DATA VO                                              
MFA-TR*        INNER JOIN CSS_WORK_AREA I2                                      
MFA-TR*           ON VO.COMPANY_NO = I2.COMPANY_NO                              
MFA-TR*          AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                          
MFA-TR*        WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'CURRENT ORDER INFO'  TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7400-UPDATE-ORDER.                                           *08063003
      *        PUTS SO ON HOLD AND CHANGES WORK AREA                   *08064003
      ******************************************************************08061003
                                                                        
       7400-UPDATE-ORDER.                                               
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                 SET ORDER_STATE_CD = 'H',                              
                     WORK_AREA_ID = :VO-WORK-AREA-ID                    
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                       080693
MFA-TR*        UPDATE CSS_SO_DATA                                         080694
MFA-TR*          SET ORDER_STATE_CD = 'H',                                080694
MFA-TR*              WORK_AREA_ID = :VO-WORK-AREA-ID                      080694
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                    080694
MFA-TR*        QUERYNO 7400                                               080694
MFA-TR*    END-EXEC.                                                      080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE ORDER'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7500-INSERT-AUDIT.                                           *08063003
      *        PUTS RECORDS IN SO_UPDATE (USED IN AUDIT DISPLAY PANEL) *08064003
      ******************************************************************08061003
                                                                        
       7500-INSERT-AUDIT.                                               
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      

MSQ002     EXEC SQL
MSQ002         SELECT CIS.CURRENT$TIMESTAMP()
MSQ002           INTO :MFA-CSR00064.ARG-3
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
            CALL CSR00064 ( :VO-SERV-ORDER-NO
                  , 'SYSTEM'
                  , :MFA-CSR00064.ARG-3
                  , 'AROP'
                  , 'Y'
                  )                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*     CALL CSR00064 (                                                     
MFA-TR*                 :VO-SERV-ORDER-NO,                                      
MFA-TR*                 'SYSTEM',                                               
MFA-TR*                 CURRENT TIMESTAMP,                                      
MFA-TR*                 'AROP',                                                 
MFA-TR*                 'Y')                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT AUDIT'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_UPDATE'       TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7600-INSERT-REMARKS.                                         *08063003
      *        PUTS RECORDS IN SO_REMARKS.                             *08064003
      ******************************************************************08061003
                                                                        
       7600-INSERT-REMARKS.                                             
                                                                        
           MOVE '7600'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE 'HOLD FOR AROP - ORIG WORK AREA: '                      
                                           TO WS-WA-COMMENTS.           
           STRING WS-WA-COMMENTS                                        
              DELIMITED BY SIZE                                         
              I2-WORK-AREA-TX                                           
              DELIMITED BY SIZE                                         
              INTO WS-COMMENTS                                          
           END-STRING.                                                  
                                                                        
           EXEC SQL                                                     
            CALL CSR00068 (                                             
                        :VO-SERV-ORDER-NO,                              
                        'H',                                            
                        :WS-COMMENTS,                                   
                        'SYSTEM')                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT REMARKS'      TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_REMARKS'      TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7700-CHECK-CLICK.                                            *08063003
      *        CHECKS IF ORDER IS CLICK.                               *08064003
      ******************************************************************08061003
                                                                        
       7700-CHECK-CLICK.                                                
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :VO-SERV-ORDER-NO,                              
      *                 '1',                                            
      *                 'S',                                            
      *                 ' ',                                            
      *                 :WS-WORK-DISTRICT)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC04747)                                               
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747 CURSOR FOR RESULT SET            
      *       :LOC04747                                                 
      *    END-EXEC.                                                    
                                                                        
      *    INITIALIZE WS-RETURN-CODE-4747                                       
      *              WS-WORK-DISTRICT.                                          
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747 INTO                                
                 :WS-RETURN-CODE-4747,                                  
                 :WS-WORK-DISTRICT-4747                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7700'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                          *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04849_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04849_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04849_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT.                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04849_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,AROP_ELIGIBLE_FL                                   
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-AROP-ELIGIBLE-FL                                
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04849_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,AROP_ELIGIBLE_FL                                           
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-AROP-ELIGIBLE-FL                                        
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD +1                    TO CTR-ROWS                    
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
               MOVE 'CSR04849_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-SEND-NOT-ELIGIBLE-FLAG.                                   *        
      ******************************************************************        
       8200-SEND-NOT-ELIGIBLE-FLAG.                                     
                                                                        
           MOVE ZERO                  TO RS-RETURN-CODE.                
           PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT.                   
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8250-SEND-NULL-CODE.                                           *        
      ******************************************************************        
       8250-SEND-NULL-CODE.                                             
                                                                        
           MOVE 100                   TO RS-RETURN-CODE.                
           MOVE 'N'                   TO RS-AROP-ELIGIBLE-FL.           
           PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT.                   
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************0000    
      *   8700-INSERT-CAD-CANCEL.                                      *08063003
      *        SENDS CANCEL ROW TO CSS_SO_CAD_QUEUE                    *08064003
      ******************************************************************8061003 
                                                                        
       8700-INSERT-CAD-CANCEL.                                          
                                                                        
           MOVE '8700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CAD_QUEUE                             
                (SERV_ORDER_NO,                                         
                 COMPANY_NO,                                            
                 LOCAL_OFFICE,                                          
                 WORK_GROUP_ID,                                         
                 WORK_AREA_ID,                                          
                 CREATED_TS,                                            
                 CAD_TS,                                                
                 CAD_PRIORITY,                                          
                 CREATED_BY_USER_ID,                                    
                 CAD_TRANS_TY_ACTN)                                     
               VALUES                                                   
                (:VO-SERV-ORDER-NO,                                     
                 :VO-COMPANY-NO,                                        
                 :VO-LOCAL-OFFICE,                                      
                 ' ',                                                   
                 ' ',                                                   
                 CIS.CURRENT$TIMESTAMP(),                                     
                 NULL,                                                  
                 '1',                                                   
                 'SYSTEM',                                              
                 'C')                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080693
MFA-TR*        INSERT INTO CSS_SO_CAD_QUEUE                             08080694
MFA-TR*         (SERV_ORDER_NO,                                         08080694
MFA-TR*          COMPANY_NO,                                            08080694
MFA-TR*          LOCAL_OFFICE,                                          08069203
MFA-TR*          WORK_GROUP_ID,                                         08069203
MFA-TR*          WORK_AREA_ID,                                          08069203
MFA-TR*          CREATED_TS,                                            08069203
MFA-TR*          CAD_TS,                                                08069203
MFA-TR*          CAD_PRIORITY,                                          08069203
MFA-TR*          CREATED_BY_USER_ID,                                    08069203
MFA-TR*          CAD_TRANS_TY_ACTN)                                     08069203
MFA-TR*        VALUES                                                   08080694
MFA-TR*         (:VO-SERV-ORDER-NO,                                     08080694
MFA-TR*          :VO-COMPANY-NO,                                        08080694
MFA-TR*          :VO-LOCAL-OFFICE,                                      08069203
MFA-TR*          ' ',                                                   08069203
MFA-TR*          ' ',                                                   08069203
MFA-TR*          CURRENT TIMESTAMP,                                     08069203
MFA-TR*          NULL,                                                  08069203
MFA-TR*          '1',                                                   08069203
MFA-TR*          'SYSTEM',                                              08069203
MFA-TR*          'C')                                                   08069203
MFA-TR*    END-EXEC.                                                    08080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8700'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT CAD CANCEL'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_CAD_QUEUE'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************  2630000 
      * 8800-CLICK-CANCEL.                                           *  08063003
      *      SENDS CANCEL ROW TO CSS_SO_TASK_QUEUE                   *  08064003
      ****************************************************************  8061003 
                                                                        
       8800-CLICK-CANCEL.                                               
                                                                        
           MOVE '8800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_ORDER_INST                                 
                  SET TASK_STATUS_CD = 'C'                              
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND TASK_STATUS_CD IN ('S','R')                       
                  AND WORK_TYPE_CD   > ' '                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8800'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLICK CANCEL'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 2630000 
      *  8810-CLICK-TASK.                                             * 08063003
      *       SENDS CANCEL ROW TO CSS_SO_TASK_QUEUE                   * 08064003
      ***************************************************************** 8061003 
                                                                        
       8810-CLICK-TASK.                                                 
                                                                        
           MOVE '8810'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_TASK_QUEUE                            
                 (SERV_ORDER_NO,                                        
                  CREATED_TS,                                           
                  COMPANY_NO,                                           
                  TASK_PRIORITY,                                        
                  CREATED_BY_USER_ID,                                   
                  SO_BUSINESS_UNIT,                                     
                  CALL_ID,                                              
                  CALL_NUMBER)                                          
               VALUES                                                   
                  (:VO-SERV-ORDER-NO,                                   
                   CIS.CURRENT$TIMESTAMP(),                                   
                   :VO-COMPANY-NO,                                      
                   '1',                                                 
                   'SYSTEM',                                            
                   :VO-SO-BUSINESS-UNIT,                                
                   1,                                                   
                   1)                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080693
MFA-TR*        INSERT INTO CSS_SO_TASK_QUEUE                            08080694
MFA-TR*          (SERV_ORDER_NO,                                        08080694
MFA-TR*           CREATED_TS,                                           08080694
MFA-TR*           COMPANY_NO,                                           08069203
MFA-TR*           TASK_PRIORITY,                                        08069203
MFA-TR*           CREATED_BY_USER_ID,                                   08069203
MFA-TR*           SO_BUSINESS_UNIT,                                     08069203
MFA-TR*           CALL_ID,                                              08069203
MFA-TR*           CALL_NUMBER)                                          08069203
MFA-TR*        VALUES                                                   08080694
MFA-TR*           (:VO-SERV-ORDER-NO,                                   08080694
MFA-TR*            CURRENT TIMESTAMP,                                   08080694
MFA-TR*            :VO-COMPANY-NO,                                      08080694
MFA-TR*            '1',                                                 08069203
MFA-TR*            'SYSTEM',                                            08069203
MFA-TR*            :VO-SO-BUSINESS-UNIT,                                08069203
MFA-TR*            1,                                                   08069203
MFA-TR*            1)                                                   08069203
MFA-TR*    END-EXEC.                                                    08080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8810'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLICK TASK CANCEL'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_TASK_QUEUE'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
