       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR04848.                                           
       DATE-WRITTEN. FEBRUARY 6, 2015                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *  USED IN CIS AND WEB.                                          *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM ADDS, UPDATES AND DELETES PENDING BANK PMT ROWS  *        
      *  IN CSS_PNDNG_BNK_DRFT TABLE FOR AN ACCOUNT.                   *        
      *                                                                *        
      *  BUSOP - UPDACCTEPAYDRAFTPENDINGPMTS                           *        
      *                                                                *        
      *  PARM-UPDATE-TYPE = 'A' - TO ADD A ROW                         *        
      *                     'U' - UPDATE EXISTING ROW                  *        
      *                     'D' - TO DELETE A PNDNG PMT                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
P00836*  02/06/15  LG41184    NEW PROGRAM.                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04848'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04848 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *** CSS_ACCOUNT         - AT                                              
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_PNDNG_BNK_DRFT  - PB                                              
           EXEC SQL                                                             
              INCLUDE TBPDBKDF                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MNT_TRANS_HIST - MH                                               
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MT_TRN_HST_DET - MI                                               
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_USER_PROFILE - PF                                                 
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_BANK_EFT  - BE                                                    
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_CUSTOMER_BANK - JF                                                
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_PAYMENT_TRANS - JT                                                
           EXEC SQL                                                             
              INCLUDE TBPMTRAN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      * DB2 SQL ERROR CHECKING                                                  
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  MISC-FIELDS.                                                 
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
           05  WS-DRAFT-DATE-OLD        PIC X(10).                      
           05  WS-DRAFT-AMT             PIC  X(11).                     
           05  WS-DRAFT-AMT-NUM REDEFINES WS-DRAFT-AMT                  
                                        PIC  9(09)V99.                  
           05  WS-DRAFT-AMT-COMP3       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-DRAFT-AMT-COMP3-OLD   PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-DRAFT-AMT-NEW         PIC $(08)9.99.                  
           05  WS-DRAFT-AMT-OLD         PIC $(08)9.99.                  
           05  WS-BANK-SEQ-NUM          PIC X(09).                      
           05  WS-BANK-SEQ-NO           REDEFINES WS-BANK-SEQ-NUM       
                                        PIC 9(09).                      
           05  WS-BANK-SEQ-NO-COMP      PIC S9(09) COMP.                
           05  WS-BANK-SEQ-NO-OLD       PIC S9(09) COMP.                
           05  WS-COMMENT-LEN           PIC X(04) VALUE SPACES.         
           05  WS-COMMENT-LEN-NUM       REDEFINES WS-COMMENT-LEN        
                                        PIC 9(04).                      
           05  WS-CURRENT-DATE          PIC X(10)  VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC X(26)  VALUE SPACES.        
           05  WS-CURR-TS               PIC X(26).                      
                                                                        
           05  WS-EPAY-USER             PIC X(07) VALUE 'WEBTRN1'.      
           05  WS-CODE-SOURCE           PIC X(01) VALUE SPACE.          
               88 EPAY-TRAN    VALUE 'E'.                               
               88 DRAFT-TRAN   VALUE 'S'.                               
               88 EPAY-NONWEB-TRAN VALUE 'U'.                           
               88 EDRAFT-TRAN  VALUE 'I'.                               
           05  WS-NEW-TXT              PIC X(5) VALUE '*NEW*'.          
           05  WS-DELETED-TXT          PIC X(9) VALUE '*DELETED*'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04848'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-PEND-EXISTS-FLAG     PIC X(01) VALUE 'N'.             
               88 WS-PEND-EXISTS                 VALUE 'Y'.             
               88 WS-PEND-NOT-EXISTS             VALUE 'N'.             
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.      
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-PYMT-TRANS-TS         PIC X(26).                       
           05  S-APPLIED-FL            PIC X(01) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-UPDATE-TYPE          PIC X(01).                         
       01  PARM-ACCOUNT-NO           PIC X(13).                         
       01  PARM-DRAFT-DATE           PIC X(10).                         
       01  PARM-DRAFT-AMT            PIC X(11).                         
       01  PARM-ACCT-TYPE-CD         PIC X(01).                         
       01  PARM-CODE-SOURCE          PIC X(01).                         
       01  PARM-BANK-SEQ-NO          PIC X(09).                         
       01  PARM-PYMT-TRANS-TS        PIC X(26).                         
       01  PARM-INIT-TYPE-CD         PIC X(02).                         
       01  PARM-LAST-UPDATE-USERID   PIC X(07).                         
       01  PARM-COMMENTS             PIC X(210).                        
       01  PARM-COMMENT-LEN          PIC X(04).                         
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                 02090000
       PROCEDURE DIVISION USING PARM-UPDATE-TYPE                        
                                PARM-ACCOUNT-NO                         
                                PARM-DRAFT-DATE                         
                                PARM-DRAFT-AMT                          
                                PARM-ACCT-TYPE-CD                       
                                PARM-CODE-SOURCE                        
                                PARM-BANK-SEQ-NO                        
                                PARM-PYMT-TRANS-TS                      
                                PARM-INIT-TYPE-CD                       
                                PARM-LAST-UPDATE-USERID                 
                                PARM-COMMENTS                           
                                PARM-COMMENT-LEN.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           ADD +1       TO CTR-ROWS.                                    
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT  :S-RETURN-CODE     AS RETURN_CODE,                 
                     :S-PYMT-TRANS-TS   AS PYMT_TRAN_TS,                
                     :S-APPLIED-FL      AS APPLIED_FL                   
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE,                         
MFA-TR*              :S-PYMT-TRANS-TS   AS PYMT_TRAN_TS,                        
MFA-TR*              :S-APPLIED-FL      AS APPLIED_FL                           
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
           MOVE WS-ACCOUNT-NO-COMP3 TO PB-ACCOUNT-NO,                   
                                       BE-ACCOUNT-NO, AT-ACCOUNT-NO.    
                                                                        
           MOVE PARM-DRAFT-DATE     TO PB-DRAFT-DATE.                   
           MOVE PARM-CODE-SOURCE TO WS-CODE-SOURCE.                     
           IF DRAFT-TRAN AND PARM-INIT-TYPE-CD = '02'                   
              MOVE 'I' TO WS-CODE-SOURCE
           END-IF.                               
           MOVE WS-CODE-SOURCE         TO PB-CODE-SOURCE-ID.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
           PERFORM 7050-VALIDATE-ACCOUNT         THRU 7050-EXIT.        
           PERFORM 7800-SET-CURRENT-DATE-TS      THRU 7800-EXIT.        
           MOVE WS-CURRENT-DATE               TO MH-DATE-TRANS.         
           MOVE WS-CURRENT-TIMESTAMP          TO MH-TRANS-HIST-SEQ-NO,  
                                                 MI-TRANS-HIST-SEQ-NO,  
                                                 WS-CURR-TS.            
                                                                        
           MOVE PARM-LAST-UPDATE-USERID    TO PF-USER-ID,               
                                              MH-USER-ID, PB-USER-ID.   
           PERFORM 7802-SELECT-RESP-AREA        THRU 7802-EXIT.         
           IF PARM-PYMT-TRANS-TS NOT EQUAL SPACES AND LOW-VALUES        
              MOVE PARM-PYMT-TRANS-TS      TO PB-PYMT-TRANS-TS,         
                                              S-PYMT-TRANS-TS           
              PERFORM 7200-GET-APPLIED-FL     THRU 7200-EXIT            
           ELSE                                                         
              MOVE WS-CURRENT-TIMESTAMP    TO PB-PYMT-TRANS-TS,         
                                              S-PYMT-TRANS-TS           
           END-IF.                                                      
                                                                        
           PERFORM 2500-PROCESS-DRAFT-EPAY      THRU 2500-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-DRAFT-EPAY                                        *        
      ******************************************************************        
                                                                        
       2500-PROCESS-DRAFT-EPAY.                                         
                                                                        
           MOVE '2500'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           INITIALIZE MI-TRAN-APPL-NO.                                  
           EVALUATE PARM-UPDATE-TYPE                                    
              WHEN 'A'                                                  
                 PERFORM 2550-FORMAT-PNDNG-DRFT  THRU 2550-EXIT         
                 PERFORM 7500-INSERT-PNDNG-DRFT  THRU 7500-EXIT         
                 PERFORM 2675-WRITE-TRANS-HIST   THRU 2675-EXIT         
              WHEN 'U'                                                  
              WHEN 'D'                                                  
                 PERFORM 7150-SELECT-PENDING-PMT THRU 7150-EXIT         
                 IF WS-PEND-EXISTS                                      
                    IF PARM-UPDATE-TYPE = 'U'                           
                       MOVE PB-DRAFT-DATE  TO WS-DRAFT-DATE-OLD         
                       MOVE PB-DRAFT-AMT   TO WS-DRAFT-AMT-COMP3-OLD    
                       MOVE PB-CUST-BANK-SEQ-NO TO WS-BANK-SEQ-NO-OLD   
                       PERFORM 2550-FORMAT-PNDNG-DRFT  THRU 2550-EXIT   
                       PERFORM 7520-UPDATE-PNDNG-DRFT  THRU 7520-EXIT   
                    ELSE                                                
                       PERFORM 7540-CANCEL-PNDNG-DRFT  THRU 7540-EXIT   
                    END-IF                                              
                    PERFORM 2675-WRITE-TRANS-HIST      THRU 2675-EXIT   
                 END-IF                                                 
           END-EVALUATE.                                                
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE.                
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2550-FORMAT-PNDNG-DRFT.                                       *         
      ****************************************************************          
       2550-FORMAT-PNDNG-DRFT.                                          
           IF PARM-UPDATE-TYPE = 'A' OR 'U'                             
              MOVE PARM-DRAFT-DATE            TO PB-DRAFT-DATE          
              MOVE PARM-DRAFT-AMT             TO WS-DRAFT-AMT           
              MOVE WS-DRAFT-AMT-NUM           TO WS-DRAFT-AMT-COMP3     
              MOVE WS-DRAFT-AMT-COMP3         TO PB-DRAFT-AMT           
              MOVE PARM-BANK-SEQ-NO           TO WS-BANK-SEQ-NUM        
              MOVE WS-BANK-SEQ-NO             TO WS-BANK-SEQ-NO-COMP    
              MOVE WS-BANK-SEQ-NO-COMP        TO PB-CUST-BANK-SEQ-NO,   
                                                 JF-CUST-BANK-SEQ-NO    
              PERFORM 7900-GET-BANK-NICKNAME  THRU 7900-EXIT            
           END-IF.                                                      
                                                                        
           EVALUATE PARM-ACCT-TYPE-CD                                   
              WHEN 'C'                                                  
                 MOVE  '27' TO PB-TRANSACTION-CD                        
              WHEN 'S'                                                  
                 MOVE  '37' TO PB-TRANSACTION-CD                        
           END-EVALUATE.                                                
                                                                        
           IF PARM-UPDATE-TYPE = 'A'                                    
              MOVE WS-NO                        TO PB-PYMT-POSTED-FL
           END-IF.   
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2675-WRITE-TRANS-HIST.                                           
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE PARM-COMMENTS              TO MH-TRAN-COMMENT-TEXT.     
           MOVE PARM-COMMENT-LEN           TO WS-COMMENT-LEN.           
           MOVE WS-COMMENT-LEN-NUM         TO MH-TRAN-COMMENT-LEN.      
           MOVE PF-RESP-AREA-ID            TO MH-RESP-AREA-ID           
                                                                        
           EVALUATE TRUE                                                
              WHEN EPAY-TRAN                                            
                 MOVE 'PANELWEBE'          TO MH-APPL-PROGRAM-ID        
              WHEN DRAFT-TRAN OR EPAY-NONWEB-TRAN                       
                 MOVE 'PANEL092'           TO MH-APPL-PROGRAM-ID        
              WHEN EDRAFT-TRAN                                          
                 MOVE 'PANEL092E'          TO MH-APPL-PROGRAM-ID        
           END-EVALUATE.                                                
           MOVE WS-ACCOUNT-NO-COMP3        TO MH-ACCOUNT-NO.            
           MOVE 0                          TO MH-CUSTOMER-NO.           
           MOVE 0                          TO MH-PREMISE-NO.            
                                                                        
           MOVE SPACES                     TO MI-TABLE-ID.              
      *    MOVE PB-ACCOUNT-NO              TO BE-ACCOUNT-NO                     
      *    MOVE PB-CUST-BANK-SEQ-NO        TO JF-CUST-BANK-SEQ-NO               
      *    PERFORM 7900-GET-BANK-NICKNAME  THRU 7900-EXIT.                      
           MOVE PARM-DRAFT-AMT             TO WS-DRAFT-AMT              
           MOVE WS-DRAFT-AMT-NUM           TO WS-DRAFT-AMT-COMP3        
           MOVE WS-DRAFT-AMT-COMP3         TO PB-DRAFT-AMT              
           MOVE WS-DRAFT-AMT-COMP3         TO WS-DRAFT-AMT-NEW.         
                                                                        
           IF MI-TRAN-APPL-NO = 0                                       
              MOVE 1 TO MI-TRAN-APPL-NO                                 
           ELSE                                                         
              ADD  1 TO MI-TRAN-APPL-NO                                 
           END-IF                                                       
                                                                        
           EVALUATE PARM-UPDATE-TYPE                                    
           WHEN 'A'                                                     
              MOVE 'BANK SEQ NO'        TO MI-COLUMN-DESC               
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-NEW-TXT           TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE PARM-BANK-SEQ-NO     TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO MI-TRAN-APPL-NO                                  
              MOVE 'BANK NICKNAME'      TO MI-COLUMN-DESC               
              MOVE +50                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE JF-BANK-ACCT-NICKNAME-TEXT                           
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO MI-TRAN-APPL-NO                                  
              MOVE 'DRAFT AMOUNT'       TO MI-COLUMN-DESC               
              MOVE +12                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-DRAFT-AMT-NEW     TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              MOVE 'DRAFT DATE'         TO MI-COLUMN-DESC               
              ADD 1 TO MI-TRAN-APPL-NO                                  
              MOVE PARM-DRAFT-DATE      TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN      
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           WHEN 'D'                                                     
              MOVE PB-CUST-BANK-SEQ-NO   TO JF-CUST-BANK-SEQ-NO         
              PERFORM 7900-GET-BANK-NICKNAME  THRU 7900-EXIT            
              MOVE WS-DELETED-TXT        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'BANK SEQ NO'         TO MI-COLUMN-DESC              
              MOVE PB-CUST-BANK-SEQ-NO   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +9                    TO MI-PRV-COLUMN-VALUE-LEN     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO MI-TRAN-APPL-NO                                  
              MOVE 'BANK NICKNAME'       TO MI-COLUMN-DESC              
              MOVE +50                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE JF-BANK-ACCT-NICKNAME-TEXT                           
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO MI-TRAN-APPL-NO                                  
              MOVE 'DRAFT AMOUNT'      TO MI-COLUMN-DESC                
              MOVE +12                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE WS-DRAFT-AMT-NEW       TO MI-PRV-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              MOVE 'DRAFT DATE'       TO MI-COLUMN-DESC                 
              ADD 1 TO MI-TRAN-APPL-NO                                  
              MOVE PARM-DRAFT-DATE       TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           WHEN 'U'                                                     
              IF PARM-DRAFT-DATE NOT EQUAL WS-DRAFT-DATE-OLD            
                 MOVE 'DRAFT DATE'       TO MI-COLUMN-DESC              
                 MOVE WS-DRAFT-DATE-OLD  TO MI-PRV-COLUMN-VALUE-TEXT    
                 MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE PARM-DRAFT-DATE   TO MI-CHG-COLUMN-VALUE-TEXT     
                 MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN      
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD  1 TO MI-TRAN-APPL-NO                              
              END-IF                                                    
              IF WS-DRAFT-AMT-COMP3-OLD NOT EQUAL PB-DRAFT-AMT          
                 MOVE 'DRAFT AMOUNT'    TO MI-COLUMN-DESC               
                 MOVE WS-DRAFT-AMT-COMP3-OLD TO WS-DRAFT-AMT-OLD        
                 MOVE WS-DRAFT-AMT-OLD TO MI-PRV-COLUMN-VALUE-TEXT      
                 MOVE PB-DRAFT-AMT     TO WS-DRAFT-AMT-NEW              
                 MOVE WS-DRAFT-AMT-NEW  TO MI-CHG-COLUMN-VALUE-TEXT     
                 MOVE +12               TO MI-PRV-COLUMN-VALUE-LEN,     
                                           MI-CHG-COLUMN-VALUE-LEN      
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD  1 TO MI-TRAN-APPL-NO                              
              END-IF                                                    
              IF WS-BANK-SEQ-NO-OLD NOT EQUAL PB-CUST-BANK-SEQ-NO       
                 MOVE 'BANK SEQ NO'        TO MI-COLUMN-DESC            
                 MOVE WS-BANK-SEQ-NO-OLD   TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE PB-CUST-BANK-SEQ-NO  TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +9                   TO MI-PRV-COLUMN-VALUE-LEN,  
                                              MI-CHG-COLUMN-VALUE-LEN   
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD  1 TO MI-TRAN-APPL-NO                              
              END-IF                                                    
           END-EVALUATE.                                                
       2675-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-VALIDATE-ACCOUNT.                                           
           EXEC SQL                                                     
               SELECT ACCOUNT_NO,                                       
                      CUSTOMER_NO                                       
               INTO   :AT-ACCOUNT-NO                                    
                     ,:AT-CUSTOMER-NO                                   
               FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*        INTO   :AT-ACCOUNT-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*        FROM   CSS_ACCOUNT                                               
MFA-TR*        WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7050'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-SELECT-PENDING-PMT.                                                
      ******************************************************************        
       7150-SELECT-PENDING-PMT.                                         
                                                                        
           MOVE '7150' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT  'Y',                                             
                       DRAFT_DATE,                                      
                       DRAFT_AMT,                                       
                       TRANSACTION_CD,                                  
                       CODE_SOURCE_ID,                                  
                       CUST_BANK_SEQ_NO                                 
                 INTO  :WS-PEND-EXISTS-FLAG,                            
                       :PB-DRAFT-DATE,                                  
                       :PB-DRAFT-AMT,                                   
                       :PB-TRANSACTION-CD,                              
                       :PB-CODE-SOURCE-ID,                              
                       :PB-CUST-BANK-SEQ-NO                             
                 FROM  CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                 
                WHERE  ACCOUNT_NO     = :PB-ACCOUNT-NO                  
                  AND  PYMT_TRANS_TS  = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )               
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y',                                                     
MFA-TR*                DRAFT_DATE,                                              
MFA-TR*                DRAFT_AMT,                                               
MFA-TR*                TRANSACTION_CD,                                          
MFA-TR*                CODE_SOURCE_ID,                                          
MFA-TR*                CUST_BANK_SEQ_NO                                         
MFA-TR*          INTO  :WS-PEND-EXISTS-FLAG,                                    
MFA-TR*                :PB-DRAFT-DATE,                                          
MFA-TR*                :PB-DRAFT-AMT,                                           
MFA-TR*                :PB-TRANSACTION-CD,                                      
MFA-TR*                :PB-CODE-SOURCE-ID,                                      
MFA-TR*                :PB-CUST-BANK-SEQ-NO                                     
MFA-TR*          FROM  CSS_PNDNG_BNK_DRFT                                       
MFA-TR*         WHERE  ACCOUNT_NO     = :PB-ACCOUNT-NO                          
MFA-TR*           AND  PYMT_TRANS_TS  = :PB-PYMT-TRANS-TS                       
MFA-TR*          WITH  UR                                                       
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO  WS-ACTIVE-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7150'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_TRANS_TS'      TO TABLE-ELEMENT-1              
              MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE PB-PYMT-TRANS-TS     TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7200-GET-APPLIED-FL.                                                     
      *****************************************************************         
       7200-GET-APPLIED-FL.                                             
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT  APPLIED_FL                                       
                 INTO  :JT-APPLIED-FL                                   
                 FROM  CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                  
                WHERE  ACCOUNT_NO     = :PB-ACCOUNT-NO                  
                  AND  PYMT_RCVD_TS   = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )               
                  AND  CASH_LOCAL_OFFICE IN ('025','022')               
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  APPLIED_FL                                               
MFA-TR*          INTO  :JT-APPLIED-FL                                           
MFA-TR*          FROM  CSS_PAYMENT_TRANS                                        
MFA-TR*         WHERE  ACCOUNT_NO     = :PB-ACCOUNT-NO                          
MFA-TR*           AND  PYMT_RCVD_TS   = :PB-PYMT-TRANS-TS                       
MFA-TR*           AND  CASH_LOCAL_OFFICE IN ('025','022')                       
MFA-TR*          WITH  UR                                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO  WS-ACTIVE-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE JT-APPLIED-FL   TO S-APPLIED-FL                   
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '7200'          TO ACTIVE-PARAGRAPH               
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_PAYMENT_TRANS'  TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE 'PYMT_RCVD_TS'       TO TABLE-ELEMENT-1           
                 MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE PB-PYMT-TRANS-TS     TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06680001
      * 7500-INSERT-PNDNG-DRFT                                         *06690001
      *     INSERTS A ROW IN CSS_PNDNG_BNK_DRFT                        *06760001
      ******************************************************************06770001
       7500-INSERT-PNDNG-DRFT.                                          
                                                                        
           MOVE '7500' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_PNDNG_BNK_DRFT                           
                      (ACCOUNT_NO,                                      
                       DRAFT_DATE,                                      
                       DRAFT_AMT,                                       
                       TRANSACTION_CD,                                  
                       CODE_SOURCE_ID,                                  
                       CUST_BANK_SEQ_NO,                                
                       PYMT_POSTED_FL,                                  
                       PYMT_TRANS_TS,                                   
                       USER_ID)                                         
               VALUES (:PB-ACCOUNT-NO,                                  
                       IIF(TRY_CONVERT(DATE, :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) ),                              
                       :PB-DRAFT-AMT,                                   
                       :PB-TRANSACTION-CD,                              
                       :PB-CODE-SOURCE-ID,                              
                       :PB-CUST-BANK-SEQ-NO,                            
                       :PB-PYMT-POSTED-FL,                              
                       CIS.CHAR2TIMESTAMP(:PB-PYMT-TRANS-TS),                   
                       :PB-USER-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06830001
MFA-TR*        INSERT INTO CSS_PNDNG_BNK_DRFT                           06840001
MFA-TR*               (ACCOUNT_NO,                                      06850001
MFA-TR*                DRAFT_DATE,                                      06860001
MFA-TR*                DRAFT_AMT,                                       06870001
MFA-TR*                TRANSACTION_CD,                                  06880002
MFA-TR*                CODE_SOURCE_ID,                                  06890001
MFA-TR*                CUST_BANK_SEQ_NO,                                        
MFA-TR*                PYMT_POSTED_FL,                                          
MFA-TR*                PYMT_TRANS_TS,                                           
MFA-TR*                USER_ID)                                                 
MFA-TR*        VALUES (:PB-ACCOUNT-NO,                                  06900001
MFA-TR*                :PB-DRAFT-DATE,                                  06910001
MFA-TR*                :PB-DRAFT-AMT,                                   06920001
MFA-TR*                :PB-TRANSACTION-CD,                              06930001
MFA-TR*                :PB-CODE-SOURCE-ID,                              06940001
MFA-TR*                :PB-CUST-BANK-SEQ-NO,                                    
MFA-TR*                :PB-PYMT-POSTED-FL,                                      
MFA-TR*                :PB-PYMT-TRANS-TS,                                       
MFA-TR*                :PB-USER-ID)                                             
MFA-TR*    END-EXEC.                                                    06950001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'INSERT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'DRAFT_DATE'                 TO TABLE-ELEMENT-2      
              MOVE 'DRAFT_AMT'                  TO TABLE-ELEMENT-3      
              MOVE 'TRANSACTION_CD'             TO TABLE-ELEMENT-4      
              MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE PB-DRAFT-DATE                TO HOSTVAR-ELEMENT-2    
              MOVE PARM-DRAFT-AMT               TO HOSTVAR-ELEMENT-3    
              MOVE PB-TRANSACTION-CD            TO HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7520-UPDATE-PNDNG-DRFT                                                  
      *     UPDATES CSS_PNDNG_BNK_DRFT.                                         
      *                                                                         
      *     EDRAFTS CAN HAVE ONE-TIME EPAYMENTS WITH CODE-SOURCE-ID 'E'         
      *     AS WELL AS DRAFT PAYMENTS WITH CODE-SOURCE-ID = 'S'                 
      *     AND SO THE CODE-SOURCE-ID CANNOT BE USED FOR UPDATE."               
      *                                                                         
      *****************************************************************         
       7520-UPDATE-PNDNG-DRFT.                                          
                                                                        
           MOVE '7520' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PNDNG_BNK_DRFT                                 
                 SET DRAFT_DATE         = IIF(TRY_CONVERT(DATE, 
                                                         :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) ),               
                     DRAFT_AMT          = :PB-DRAFT-AMT,                
                     CUST_BANK_SEQ_NO   = :PB-CUST-BANK-SEQ-NO          
              WHERE  ACCOUNT_NO    = :PB-ACCOUNT-NO                     
                AND  PYMT_TRANS_TS = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PNDNG_BNK_DRFT                                         
MFA-TR*          SET DRAFT_DATE         = :PB-DRAFT-DATE,                       
MFA-TR*              DRAFT_AMT          = :PB-DRAFT-AMT,                        
MFA-TR*              CUST_BANK_SEQ_NO   = :PB-CUST-BANK-SEQ-NO                  
MFA-TR*       WHERE  ACCOUNT_NO    = :PB-ACCOUNT-NO                             
MFA-TR*         AND  PYMT_TRANS_TS = :PB-PYMT-TRANS-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
              MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'PYMT_TRANS_TS'              TO TABLE-ELEMENT-2      
              MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE PB-PYMT-TRANS-TS             TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7540-CANCEL-PNDNG-DRFT.                                          
                                                                        
           MOVE '7540' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE CSS_PNDNG_BNK_DRFT                                 
              WHERE  ACCOUNT_NO    = :PB-ACCOUNT-NO                     
                AND  PYMT_TRANS_TS = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE CSS_PNDNG_BNK_DRFT                                         
MFA-TR*       WHERE  ACCOUNT_NO    = :PB-ACCOUNT-NO                             
MFA-TR*         AND  PYMT_TRANS_TS = :PB-PYMT-TRANS-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE.               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'DELETE'                     TO ABEND-FUNCTION       
              MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'PYMT_TRANS_TS'              TO TABLE-ELEMENT-2      
              MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE PB-PYMT-TRANS-TS             TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7800-SET-CURRENT-DATE-TS.                                     *         
      *****************************************************************         
       7800-SET-CURRENT-DATE-TS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE,                         
MFA-TR*           :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7802-SELECT-RESP-AREA                                         *         
      *     SELECTS RESP-AREA FROM USER-PROFILE                        *        
      *****************************************************************         
       7802-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PF-USER-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7802                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7802'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7802-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7900-GET-BANK-NICKNAME.                                       *         
      *  VALIDATE BANK ACCT                                           *         
      *  ALSO GET NICKNAME FROM CSS_CUSTOMER_BANK                     *         
      *****************************************************************         
       7900-GET-BANK-NICKNAME.                                          
                                                                        
           EXEC SQL                                                     
              SELECT JF.BANK_ACCT_NICKNAME                              
                INTO :JF-BANK-ACCT-NICKNAME                             
                FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED),                     
                     CSS_CUSTOMER_BANK JF WITH(READUNCOMMITTED)                 
               WHERE BE.ACCOUNT_NO        = :BE-ACCOUNT-NO              
                 AND BE.CUSTOMER_NO       = JF.CUSTOMER_NO              
                 AND JF.CUST_BANK_SEQ_NO  = :JF-CUST-BANK-SEQ-NO        
                 AND JF.BANK_ACCT_STAT_CD = 'A'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT JF.BANK_ACCT_NICKNAME                                      
MFA-TR*         INTO :JF-BANK-ACCT-NICKNAME                                     
MFA-TR*         FROM CSS_BANK_EFT BE,                                           
MFA-TR*              CSS_CUSTOMER_BANK JF                                       
MFA-TR*        WHERE BE.ACCOUNT_NO        = :BE-ACCOUNT-NO                      
MFA-TR*          AND BE.CUSTOMER_NO       = JF.CUSTOMER_NO                      
MFA-TR*          AND JF.CUST_BANK_SEQ_NO  = :JF-CUST-BANK-SEQ-NO                
MFA-TR*          AND JF.BANK_ACCT_STAT_CD = 'A'                                 
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7900                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BANK_EFT '            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BANK SEQ NO'              TO TABLE-ELEMENT-2        
              MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE JF-CUST-BANK-SEQ-NO        TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6530- WRITE MAINTENANCE TRANSACTION.                                    
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- ERROR HANDLING INCLUDE *                                          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
