       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR04847.                                           
COB303 DATE-WRITTEN. FEB 2015.                                           
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      **                   SOUTH CAROLINA ELECTRIC & GAS             **         
      *****************************************************************         
      **                          S U M M A R Y                      **         
      **                                                             **         
      **     ADD/DELETE/UPDATE CUSTOMER BANK ACCT INFO               **         
      **     USED BY CIS AND WEB MOD                                 **         
      **                                                             **         
      ** BUSOP - UPDCUSTBANKINFO                                     **         
      *****************************************************************         
      *                                                               *         
      *                     MODIFICATION LOG                          *         
      *                                                               *         
      *     DATE      INITIALS    COMMENTS                            *         
      *   ----------  --------    ------------------------------------*         
P00836*   02/04/2015  SRIKRISHNA  INITIAL VERSION - CLONE OF CSR03426 *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04847'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                *        
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_MNT_TRANS_HIST - MH                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_MT_TRN_HST_DET - MI                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_BANK_EFT - BE                                                       
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_CUST_BANK - JF                                                      
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_PNDNG_BNK_DRFT - PB                                                 
           EXEC SQL                                                             
             INCLUDE TBPDBKDF                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT -AT                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_USER_PROFILE                                                        
           EXEC SQL                                                             
             INCLUDE TBUSRPRF                                                   
           END-EXEC.                                                            
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00372                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                  *        
      *****************************************************************         
                                                                        
      *****************************************************************         
      *    ERROR PROCESSING VARIABLES                                 *         
      *****************************************************************         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)  VALUE SPACES.         
           10  S-SQLCODE               PIC S9(9)  VALUE 0 COMP.         
           10  S-SQLSTATE              PIC X(05)  VALUE SPACES.         
           10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4)  USAGE COMP.           
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4)  USAGE COMP.           
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4)  USAGE COMP.           
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4)  USAGE COMP.           
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9) VALUE 0 COMP.          
           10 S-APPL-RETURN-CODE       PIC X(10) VALUE SPACES.          
           10 S-CUST-BANK-SEQ-NO       PIC S9(9) COMP VALUE ZEROES.     
           10 S-ACCOUNT-NO             PIC X(13) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)  COMP VALUE 1.         
           05  CTR-ROWS                PIC S9(9)  COMP VALUE 0.         
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-SYSTEM               PIC X(07)  VALUE 'SYSTEM'.       
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04847'.     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC-ITEMS.                                               
           05  WS-CUSTOMER-NO          PIC X(10).                       
           05  WS-CUSTOMER-NO-NUM REDEFINES WS-CUSTOMER-NO              
                                       PIC 9(10).                       
COB305     05 WS-CUSTOMER-NO-COMP3        PIC S9(10) COMP-3 VALUE 0.            
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-ACCT-TRANSLATE       PIC 9(13).                       
           05  WS-ACCT-TRANSLATE-CH REDEFINES                           
                     WS-ACCT-TRANSLATE PIC X(13).                       
           05  WS-BANK-SEQ-NO          PIC X(09) JUSTIFIED RIGHT.       
           05  WS-BANK-SEQ-NO-NUM REDEFINES WS-BANK-SEQ-NO              
                                       PIC 9(09).                       
           05  WS-BANK-SEQ             PIC S9(09) COMP.                 
           05  WS-BANK-ID              PIC X(06) JUSTIFIED RIGHT.       
           05  WS-BANK-ID-NUM REDEFINES WS-BANK-ID                      
                                       PIC S9(06)V.                     
           05  WS-NICKNAME-LENGTH      PIC X(04) JUSTIFIED RIGHT.       
           05  WS-NICKNAME-LEN-NUM REDEFINES WS-NICKNAME-LENGTH         
                                       PIC 9(04).                       
           05  WS-NICKNAME-LEN         PIC S9(04) USAGE COMP.           
           05  WS-COMMENT-LEN          PIC X(04) JUSTIFIED RIGHT.       
           05  WS-COMMENT-LEN-NUM REDEFINES WS-COMMENT-LEN              
                                       PIC 9(04).                       
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE 0.         
           05  WS-PRIMARY-FLAG         PIC X(01) VALUE 'N'.             
               88  WS-PRIMARY          VALUE 'Y'.                       
           05  WS-NICKNAME-EXISTS-FLAG PIC X(01) VALUE 'N'.             
               88 WS-NICKNAME-EXISTS             VALUE 'Y'.             
               88 WS-NICKNAME-NOT-EXISTS         VALUE 'N'.             
           05  WS-OLD-NICKNAME.                                         
               10 WS-OLD-NICKNAME-LEN  PIC S9(04) USAGE COMP.           
               10 WS-OLD-NICKNAME-TEXT PIC X(50).                       
           05  WS-D                    PIC X(01) VALUE 'D'.             
      *    05  WS-TRAILING-SPACES      PIC 9(02) VALUE 0.                       
           05  WS-CTR                  PIC 9(02) VALUE 0.               
           05  WS-SEQ-COUNT            PIC 9(01) VALUE 9.               
           05  WS-SEQ-COUNT-4          PIC 9(01) VALUE 4.               
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTMP     PIC X(26) VALUE SPACES.          
           05  WS-RESP-AREA            PIC X(03) VALUE SPACES.          
           05  WS-NULL-IND             PIC S9(04) COMP VALUE +0.        
           05  WS-PYMT-PNDNG           PIC X(01) VALUE 'N'.             
           05  WS-PREV-BNK-NICKNAME    PIC X(50) VALUE SPACES.          
COB305     05 WS-FINALLED-ACCT-COMP3        PIC S9(13) COMP-3 VALUE 0.          
           05  WS-30-DAYS-AGO          PIC X(10) VALUE SPACES.          
           05  WS-APPL-RETURN-CODE     PIC X(10) VALUE SPACES.          
                                                                        
       LINKAGE SECTION.                                                 
       01  I-CUSTOMER-NO               PIC X(10).                       
       01  I-CUST-BANK-SEQ-NO          PIC X(09).                       
       01  I-UPDATE-TYPE               PIC X(01).                       
       01  I-BANK-ACCT-NAME            PIC X(50).                       
       01  I-BANK-ACCT-NO              PIC X(19).                       
       01  I-BANK-ACCT-TYPE            PIC X(01).                       
       01  I-BANK-ID                   PIC X(06).                       
       01  I-BANK-ACCT-NICKNAME        PIC X(50).                       
       01  I-BANK-ACCT-NICKNAME-LEN    PIC X(04).                       
       01  I-USER-ID                   PIC X(07).                       
       01  I-COMMENT-TEXT              PIC X(210).                      
       01  I-COMMENT-LEN-NUM           PIC X(04).                       
       01  I-ACCOUNT-NO                PIC X(13).                       
       01  I-CHANNEL-CD                PIC X(08).                       
                                                                        
       PROCEDURE DIVISION USING I-CUSTOMER-NO                           
                               , I-CUST-BANK-SEQ-NO                     
                               , I-UPDATE-TYPE                          
                               , I-BANK-ACCT-NAME                       
                               , I-BANK-ACCT-NO                         
                               , I-BANK-ACCT-TYPE                       
                               , I-BANK-ID                              
                               , I-BANK-ACCT-NICKNAME                   
                               , I-BANK-ACCT-NICKNAME-LEN               
                               , I-USER-ID                              
                               , I-COMMENT-TEXT                         
                               , I-COMMENT-LEN-NUM                      
                               , I-ACCOUNT-NO                           
                               , I-CHANNEL-CD.                          
                                                                        
      ****************************************************************          
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                    *          
      ****************************************************************          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *    SET UP SQL ERROR PROCESSING                               *          
      *    DECLARE ASSOCIATED CURSOR                                 *          
      ****************************************************************          
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT  :S-RETURN-CODE     AS RETURN_CODE,                 
                     :S-APPL-RETURN-CODE AS APPL_RETURN_CODE,           
                     :S-CUST-BANK-SEQ-NO AS CUST_BANK_SEQ_NO,           
                     :S-ACCOUNT-NO      AS ACCOUNT_NO                   
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE,                         
MFA-TR*              :S-APPL-RETURN-CODE AS APPL_RETURN_CODE,                   
MFA-TR*              :S-CUST-BANK-SEQ-NO AS CUST_BANK_SEQ_NO,                   
MFA-TR*              :S-ACCOUNT-NO      AS ACCOUNT_NO                           
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
           MOVE I-CUSTOMER-NO TO WS-CUSTOMER-NO.                        
           MOVE WS-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO-COMP3.             
           MOVE WS-CUSTOMER-NO-COMP3 TO JF-CUSTOMER-NO                  
                                        BE-CUSTOMER-NO, AT-CUSTOMER-NO. 
                                                                        
           MOVE I-ACCOUNT-NO TO WS-ACCOUNT-NO.                          
           MOVE WS-ACCOUNT-NO-NUM TO WS-ACCOUNT-NO-COMP3.               
           MOVE WS-ACCOUNT-NO-COMP3 TO BE-ACCOUNT-NO                    
                                       MH-ACCOUNT-NO, AT-ACCOUNT-NO.    
                                                                        
           MOVE I-BANK-ACCT-NICKNAME-LEN     TO WS-NICKNAME-LENGTH.     
           MOVE WS-NICKNAME-LEN-NUM          TO WS-NICKNAME-LEN.        
                                                                        
           IF I-BANK-ID > SPACES                                        
              MOVE I-BANK-ID TO WS-BANK-ID                              
           ELSE                                                         
              MOVE ZERO      TO WS-BANK-ID-NUM                          
           END-IF.                                                      
                                                                        
      *    INSPECT I-CUST-BANK-SEQ-NO                                           
      *            TALLYING WS-TRAILING-SPACES FOR ALL SPACES.                  
      *    COMPUTE WS-CTR = WS-SEQ-COUNT - WS-TRAILING-SPACES.                  
      *    MOVE I-CUST-BANK-SEQ-NO(1:WS-CTR) TO WS-BANK-SEQ-NO.                 
      *    INSPECT WS-BANK-SEQ-NO REPLACING LEADING SPACES BY ZEROS.            
                                                                        
           MOVE I-CUST-BANK-SEQ-NO       TO WS-BANK-SEQ-NO.             
           MOVE WS-BANK-SEQ-NO-NUM       TO JF-CUST-BANK-SEQ-NO.        
           IF WS-BANK-SEQ-NO-NUM > ZERO                                 
              MOVE WS-BANK-SEQ-NO-NUM    TO S-CUST-BANK-SEQ-NO
           END-IF.         
                                                                        
      *    MOVE ZEROS TO WS-TRAILING-SPACES                                     
      *    INSPECT I-COMMENT-LEN-NUM                                            
      *            TALLYING WS-TRAILING-SPACES FOR ALL SPACES.                  
      *    COMPUTE WS-CTR = WS-SEQ-COUNT-4 - WS-TRAILING-SPACES.                
      *    MOVE I-COMMENT-LEN-NUM(1:WS-CTR) TO WS-COMMENT-LEN                   
      *    INSPECT WS-COMMENT-LEN REPLACING LEADING SPACES BY ZEROS.            
                                                                        
           MOVE I-COMMENT-LEN-NUM            TO WS-COMMENT-LEN          
                                                                        
           PERFORM 7100-VALIDATE-ACCOUNT     THRU 7100-EXIT.            
           PERFORM 7120-GET-CURRENT-DATETIME THRU 7120-EXIT.            
           PERFORM 7150-GET-RESP-AREA        THRU 7150-EXIT.            
           MOVE WS-RESP-AREA TO MH-RESP-AREA-ID.                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *2000-PROCESS-OUTPUT.                                          *          
      * I-UPDATE-TYPE = 'I' - ADD BANK                               *          
      *                 'U' - UPDATE BANK                            *          
      *                 'D' - DELETE BANK                            *          
      ****************************************************************          
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE I-UPDATE-TYPE                                       
              WHEN 'I'                                                  
                 PERFORM 2100-PROCESS-ADD-BANK    THRU 2100-EXIT        
                                                                        
              WHEN 'U'                                                  
                 PERFORM 7200-SELECT-BANK-INFO    THRU 7200-EXIT        
                 PERFORM 2300-PROCESS-UPDATE-BANK THRU 2300-EXIT        
                                                                        
              WHEN 'D'                                                  
                 PERFORM 7200-SELECT-BANK-INFO    THRU 7200-EXIT        
                 PERFORM 2500-PROCESS-DELETE-BANK THRU 2500-EXIT        
           END-EVALUATE                                                 
                                                                        
           MOVE ZERO                TO S-RETURN-CODE.                   
           MOVE JF-CUST-BANK-SEQ-NO TO S-CUST-BANK-SEQ-NO.              
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-PROCESS-ADD-BANK.                                           
           MOVE I-USER-ID                 TO WS-372-USER-ID,            
                                             JF-LAST-UPDATE-USERID      
           MOVE WS-COMMENT-LEN-NUM        TO WS-372-COMMENT-LEN         
           MOVE I-COMMENT-TEXT            TO WS-372-COMMENT-TEXT        
           MOVE I-BANK-ACCT-TYPE          TO JF-BANK-ACCT-TYPE-CD       
           MOVE I-BANK-ACCT-NAME          TO JF-BANK-ACCOUNT-NAME       
           MOVE I-BANK-ACCT-NO            TO JF-BANK-ACCT-NO            
           MOVE I-BANK-ID                 TO JF-BANK-ID                 
           MOVE I-BANK-ACCT-NICKNAME      TO JF-BANK-ACCT-NICKNAME-TEXT 
           MOVE WS-NICKNAME-LEN           TO JF-BANK-ACCT-NICKNAME-LEN. 
                                                                        
           PERFORM 6000-ADD-BANK-INFO THRU 6000-ADD-BANK-INFO-EXIT.     
           MOVE ZERO                    TO S-RETURN-CODE.               
           MOVE JF-CUST-BANK-SEQ-NO     TO S-CUST-BANK-SEQ-NO.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-PROCESS-UPDATE-BANK.                                        
                                                                        
           IF I-BANK-ACCT-NICKNAME > SPACES AND                         
           I-BANK-ACCT-NICKNAME NOT = WS-OLD-NICKNAME-TEXT              
      *       MOVE I-BANK-ACCT-NICKNAME  TO JF-BANK-ACCT-NICKNAME-TEXT          
      *       MOVE WS-NICKNAME-LEN       TO JF-BANK-ACCT-NICKNAME-LEN           
              PERFORM 7800-CHK-FOR-UNIQUE-NM THRU 7800-EXIT             
              IF WS-NICKNAME-EXISTS                                     
                 MOVE 'EPYMT00011'         TO S-APPL-RETURN-CODE        
                 MOVE AT-ACCOUNT-NO        TO WS-ACCT-TRANSLATE         
                 MOVE WS-ACCT-TRANSLATE-CH TO S-ACCOUNT-NO              
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2800-UPD-MNT-TRANS-HIST THRU 2800-EXIT               
                                                                        
           IF I-BANK-ACCT-NAME > SPACES                                 
           AND I-BANK-ACCT-NAME   NOT = JF-BANK-ACCOUNT-NAME            
              MOVE I-BANK-ACCT-NAME    TO  JF-BANK-ACCOUNT-NAME
           END-IF.        
                                                                        
           IF I-BANK-ACCT-TYPE > SPACES                                 
           AND I-BANK-ACCT-TYPE   NOT = JF-BANK-ACCT-TYPE-CD            
              MOVE I-BANK-ACCT-TYPE    TO  JF-BANK-ACCT-TYPE-CD
           END-IF.        
                                                                        
           IF I-BANK-ACCT-NICKNAME > SPACES                             
           AND I-BANK-ACCT-NICKNAME NOT =                               
           JF-BANK-ACCT-NICKNAME-TEXT(1:JF-BANK-ACCT-NICKNAME-LEN)      
              MOVE I-BANK-ACCT-NICKNAME     TO                          
                                           JF-BANK-ACCT-NICKNAME-TEXT   
              MOVE I-BANK-ACCT-NICKNAME-LEN TO                          
                                           JF-BANK-ACCT-NICKNAME-LEN
           END-IF.   
                                                                        
           PERFORM 8000-CUST-BANK-UPD THRU 8000-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 8060-UPDATE-BANK-EFT THRU 8060-EXIT               
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-PROCESS-DELETE-BANK.                                        
      *                                                                         
           MOVE JF-CUSTOMER-NO          TO BE-CUSTOMER-NO.              
           MOVE JF-CUST-BANK-SEQ-NO     TO BE-CUST-BANK-SEQ-NO.         
           PERFORM 7400-CHK-BNKEFT-PRIMARY THRU 7400-EXIT.              
           IF WS-PRIMARY                                                
              MOVE 'EPYMT00016'         TO S-APPL-RETURN-CODE           
              MOVE ZERO                 TO S-ACCOUNT-NO                 
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 7450-CHK-PNDNG-BNK-DRFT  THRU 7450-EXIT.             
           IF WS-PYMT-PNDNG = 'Y'                                       
              MOVE 'EPYMT00012'         TO S-APPL-RETURN-CODE           
              MOVE ZERO                 TO S-ACCOUNT-NO                 
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE 'N'                    TO WS-PRIMARY-FLAG,              
                                          WS-PYMT-PNDNG.                
           MOVE WS-BANK-SEQ-NO-NUM     TO WS-BANK-SEQ.                  
           PERFORM 7300-CHECK-OTHER-BANK-EFT     THRU 7300-EXIT.        
           IF WS-PRIMARY-FLAG NOT = 'Y'                                 
              PERFORM 7700-CHK-OTHER-PNDNG-DRFT THRU 7700-EXIT          
           END-IF.                                                      
      *    PERFORM 2570-VERIFY-EFT-PENDING                                      
      *       THRU 2570-EXIT                                                    
           IF WS-PRIMARY OR WS-PYMT-PNDNG = 'Y'                         
              MOVE 'EPYMT00028'         TO S-APPL-RETURN-CODE           
              MOVE AT-ACCOUNT-NO        TO WS-ACCT-TRANSLATE            
              MOVE WS-ACCT-TRANSLATE-CH TO S-ACCOUNT-NO                 
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           ELSE                                                         
              PERFORM 2800-UPD-MNT-TRANS-HIST THRU 2800-EXIT            
              PERFORM 8050-CUST-BANK-DEL      THRU 8050-EXIT            
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2570-VERIFY-EFT-PENDING.                                         
                                                                        
           MOVE 'N'                    TO WS-PRIMARY-FLAG,              
                                          WS-PYMT-PNDNG.                
           MOVE WS-BANK-SEQ-NO-NUM     TO WS-BANK-SEQ.                  
           PERFORM 7300-CHECK-OTHER-BANK-EFT     THRU 7300-EXIT.        
           PERFORM 7700-CHK-OTHER-PNDNG-DRFT     THRU 7700-EXIT.        
                                                                        
       2570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * WRITE MNT TRANSACTION HISTORY ROWS FOR UPDATES TO CUSTOMER   *          
      * BANK INFORMATION                                             *          
      ****************************************************************          
                                                                        
       2800-UPD-MNT-TRANS-HIST.                                         
                                                                        
           MOVE WS-CURRENT-TIMESTMP TO MH-TRANS-HIST-SEQ-NO.            
           MOVE WS-CURRENT-DATE     TO MH-DATE-TRANS.                   
           MOVE 'F'                 TO MH-CODE-TRAN-TYPE.               
           MOVE WS-RESP-AREA        TO MH-RESP-AREA-ID.                 
           MOVE I-CUSTOMER-NO       TO MH-CUSTOMER-NO.                  
           MOVE ZEROS               TO MH-PREMISE-NO.                   
           MOVE I-USER-ID           TO MH-USER-ID.                      
                                                                        
           PERFORM 7250-RETRIEVE-INIT-TYPE-CD THRU 7250-EXIT.           
           IF BE-INIT-TYPE-CD = '02'                                    
              IF BE-STATUS-CODE = 'M'                                   
              OR BE-STATUS-CODE = 'O'                                   
                 MOVE 'PANELWEB ' TO MH-APPL-PROGRAM-ID                 
              ELSE                                                      
                 MOVE 'PANEL194E' TO MH-APPL-PROGRAM-ID                 
              END-IF                                                    
           ELSE                                                         
              MOVE 'PANEL194 '    TO MH-APPL-PROGRAM-ID                 
           END-IF.                                                      
                                                                        
           MOVE WS-COMMENT-LEN-NUM TO MH-TRAN-COMMENT-LEN.              
           MOVE I-COMMENT-TEXT     TO MH-TRAN-COMMENT-TEXT.             
                                                                        
           IF WS-TRAN-APPL-NO = 0                                       
              MOVE +1           TO WS-TRAN-APPL-NO                      
           ELSE                                                         
              ADD +1            TO WS-TRAN-APPL-NO                      
           END-IF.                                                      
           PERFORM 2850-LOAD-MNT-DTL-UPD THRU 2850-EXIT.                
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2850-LOAD-MNT-DTL-UPD.                                           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES                   TO MI-TABLE-ID                 
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
                                                                        
           IF I-UPDATE-TYPE = 'D'                                       
              IF I-CHANNEL-CD > SPACES AND I-CHANNEL-CD NOT = 'CIS'     
                 MOVE +24                   TO MH-TRAN-COMMENT-LEN      
                 MOVE 'BANK INFORMATION DELETED'                        
                                            TO MH-TRAN-COMMENT-TEXT     
              END-IF                                                    
              MOVE WS-OLD-NICKNAME-TEXT                                 
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-OLD-NICKNAME-LEN      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'BANK NICKNAME'          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
              MOVE JF-CUST-BANK-SEQ-NO      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'BANK SEQ NO'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           ELSE                                                         
              MOVE WS-ACCOUNT-NO-COMP3      TO MH-ACCOUNT-NO            
              MOVE ZEROES                   TO MH-CUSTOMER-NO           
                                                                        
              IF I-BANK-ACCT-NAME > SPACES AND                          
                 I-BANK-ACCT-NAME   NOT = JF-BANK-ACCOUNT-NAME          
                 MOVE JF-BANK-ACCOUNT-NAME  TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +50                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE I-BANK-ACCT-NAME      TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE +50                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE 'BANK ACCT NAME'      TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                      TO MI-TRAN-APPL-NO          
              END-IF                                                    
                                                                        
              IF I-BANK-ACCT-TYPE > SPACES AND                          
                    I-BANK-ACCT-TYPE   NOT = JF-BANK-ACCT-TYPE-CD       
                 MOVE JF-BANK-ACCT-TYPE-CD  TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +50                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE I-BANK-ACCT-TYPE      TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE +50                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE 'BANK ACCT TYPE'      TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                      TO MI-TRAN-APPL-NO          
              END-IF                                                    
                                                                        
              IF I-BANK-ACCT-NICKNAME > SPACES AND                      
                     I-BANK-ACCT-NICKNAME NOT =                         
                     WS-OLD-NICKNAME-TEXT(1:WS-OLD-NICKNAME-LEN)        
                 MOVE WS-OLD-NICKNAME-TEXT   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-OLD-NICKNAME-LEN    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE I-BANK-ACCT-NICKNAME   TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE I-BANK-ACCT-NICKNAME-LEN                          
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE 'BANK NICKNAME'        TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO MI-TRAN-APPL-NO         
              END-IF                                                    
                                                                        
              IF MI-TRAN-APPL-NO > 1                                    
                 MOVE JF-CUST-BANK-SEQ-NO  TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE +9                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE JF-CUST-BANK-SEQ-NO  TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE 'BANK SEQ NO'        TO MI-COLUMN-DESC            
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                     TO MI-TRAN-APPL-NO           
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2850-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *6000-ADD-BANK-INFO.                                                      
           EXEC SQL                                                             
              INCLUDE CPD00372                                                  
           END-EXEC.                                                            
                                                                        
      *6530-LOAD-MNT-TRANS-HIST.                                                
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
       7100-VALIDATE-ACCOUNT.                                           
           EXEC SQL                                                     
               SELECT ACCOUNT_NO,                                       
                      CUSTOMER_NO                                       
               INTO   :AT-ACCOUNT-NO                                    
                     ,:AT-CUSTOMER-NO                                   
               FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                 AND  CUSTOMER_NO = :AT-CUSTOMER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*        INTO   :AT-ACCOUNT-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*        FROM   CSS_ACCOUNT                                               
MFA-TR*        WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*          AND  CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE, S-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
              MOVE I-CUSTOMER-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-GET-CURRENT-DATETIME.                                       
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7120'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7120'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -30, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-30-DAYS-AGO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-30-DAYS-AGO = CURRENT DATE - 30 DAYS                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7120'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA                                      
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :I-USER-ID                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA                                              
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :I-USER-ID                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE I-USER-ID             TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-BANK-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT BANK_ACCOUNT_NAME                                  
                    ,BANK_ACCT_NO                                       
                    ,BANK_ACCT_STAT_CD                                  
                    ,BANK_ID                                            
                    ,BANK_ACCT_TYPE_CD                                  
                    ,BANK_ACCT_NICKNAME                                 
              INTO  :JF-BANK-ACCOUNT-NAME                               
                   ,:JF-BANK-ACCT-NO                                    
                   ,:JF-BANK-ACCT-STAT-CD                               
                   ,:JF-BANK-ID                                         
                   ,:JF-BANK-ACCT-TYPE-CD                               
                   ,:JF-BANK-ACCT-NICKNAME                              
              FROM  CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                     
              WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                
                AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO           
                AND BANK_ACCT_STAT_CD  = 'A'                            
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BANK_ACCOUNT_NAME                                          
MFA-TR*             ,BANK_ACCT_NO                                               
MFA-TR*             ,BANK_ACCT_STAT_CD                                          
MFA-TR*             ,BANK_ID                                                    
MFA-TR*             ,BANK_ACCT_TYPE_CD                                          
MFA-TR*             ,BANK_ACCT_NICKNAME                                         
MFA-TR*       INTO  :JF-BANK-ACCOUNT-NAME                                       
MFA-TR*            ,:JF-BANK-ACCT-NO                                            
MFA-TR*            ,:JF-BANK-ACCT-STAT-CD                                       
MFA-TR*            ,:JF-BANK-ID                                                 
MFA-TR*            ,:JF-BANK-ACCT-TYPE-CD                                       
MFA-TR*            ,:JF-BANK-ACCT-NICKNAME                                      
MFA-TR*       FROM  CSS_CUSTOMER_BANK                                           
MFA-TR*       WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                        
MFA-TR*         AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO                   
MFA-TR*         AND BANK_ACCT_STAT_CD  = 'A'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE JF-BANK-ACCT-NICKNAME     TO WS-OLD-NICKNAME         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'       TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE JF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CUST_BANK_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE JF-CUST-BANK-SEQ-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-RETRIEVE-INIT-TYPE-CD                                     *        
      ******************************************************************        
       7250-RETRIEVE-INIT-TYPE-CD.                                      
                                                                        
           EXEC SQL                                                     
              SELECT STATUS_CODE                                        
                    ,INIT_TYPE_CD                                       
              INTO  :BE-STATUS-CODE                                     
                   ,:BE-INIT-TYPE-CD                                    
              FROM  CSS_BANK_EFT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO  = :BE-ACCOUNT-NO                        
                AND CUSTOMER_NO = :BE-CUSTOMER-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STATUS_CODE                                                
MFA-TR*             ,INIT_TYPE_CD                                               
MFA-TR*       INTO  :BE-STATUS-CODE                                             
MFA-TR*            ,:BE-INIT-TYPE-CD                                            
MFA-TR*       FROM  CSS_BANK_EFT                                                
MFA-TR*       WHERE ACCOUNT_NO  = :BE-ACCOUNT-NO                                
MFA-TR*         AND CUSTOMER_NO = :BE-CUSTOMER-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES TO BE-INIT-TYPE-CD                         
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7250'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_BANK_EFT'        TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE BE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-CHECK-OTHER-BANK-EFT.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AT.ACCOUNT_NO                                      
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.CUSTOMER_NO  = :JF-CUSTOMER-NO                  
                 AND EXISTS(SELECT 1                                    
                              FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED)        
                             WHERE BE.ACCOUNT_NO  = AT.ACCOUNT_NO       
                               AND BE.STATUS_CODE = 'A'                 
                               AND BE.CUST_BANK_SEQ_NO =                
                                        :JF-CUST-BANK-SEQ-NO)           
                 AND AT.CODE_ACCT_STAT = 'A'                            
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.CUSTOMER_NO  = :JF-CUSTOMER-NO                          
MFA-TR*          AND EXISTS(SELECT 1                                            
MFA-TR*                       FROM CSS_BANK_EFT BE                              
MFA-TR*                      WHERE BE.ACCOUNT_NO  = AT.ACCOUNT_NO               
MFA-TR*                        AND BE.STATUS_CODE = 'A'                         
MFA-TR*                        AND BE.CUST_BANK_SEQ_NO =                        
MFA-TR*                                 :JF-CUST-BANK-SEQ-NO)                   
MFA-TR*          AND AT.CODE_ACCT_STAT = 'A'                                    
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE 'Y' TO WS-PRIMARY-FLAG                            
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-PRIMARY-FLAG                            
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE '7300'              TO ACTIVE-PARAGRAPH           
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'CSS_ACCOUNT'       TO TABLE-1                    
                 MOVE 'CSS_BANK_EFT'      TO TABLE-2                    
                 MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1            
                 MOVE 'CUST_BANK_SEQ_NO'  TO TABLE-ELEMENT-2            
                 MOVE JF-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1          
                 MOVE WS-BANK-SEQ         TO HOSTVAR-ELEMENT-2          
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CHK-BNKEFT-PRIMARY.                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-PRIMARY-FLAG                                   
                FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO       = :BE-ACCOUNT-NO                  
                 AND CUSTOMER_NO      = :BE-CUSTOMER-NO                 
                 AND CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO            
                 AND STATUS_CODE      = 'A'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PRIMARY-FLAG                                           
MFA-TR*         FROM CSS_BANK_EFT                                               
MFA-TR*        WHERE ACCOUNT_NO       = :BE-ACCOUNT-NO                          
MFA-TR*          AND CUSTOMER_NO      = :BE-CUSTOMER-NO                         
MFA-TR*          AND CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO                    
MFA-TR*          AND STATUS_CODE      = 'A'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-PRIMARY-FLAG                            
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE '7400'              TO ACTIVE-PARAGRAPH           
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'CSS_BANK_EFT'      TO TABLE-1                    
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-2            
                 MOVE 'CUST_BANK_SEQ_NO'  TO TABLE-ELEMENT-3            
                 MOVE BE-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 MOVE JF-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2          
                 MOVE JF-CUST-BANK-SEQ-NO TO HOSTVAR-ELEMENT-3          
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7450-CHK-PNDNG-BNK-DRFT.                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-PYMT-PNDNG                                     
                FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO       = :BE-ACCOUNT-NO                  
                 AND CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO            
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PYMT-PNDNG                                             
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                         
MFA-TR*        WHERE ACCOUNT_NO       = :BE-ACCOUNT-NO                          
MFA-TR*          AND CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO                    
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-PYMT-PNDNG                              
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE '7450'              TO ACTIVE-PARAGRAPH           
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'CSS_PNDNG_BNK_DRFT'TO TABLE-1                    
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE 'CUST_BANK_SEQ_NO'  TO TABLE-ELEMENT-2            
                 MOVE BE-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 MOVE JF-CUST-BANK-SEQ-NO TO HOSTVAR-ELEMENT-2          
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-CHK-OTHER-PNDNG-DRFT.                                       
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) PB.ACCOUNT_NO                                       
               INTO :AT-ACCOUNT-NO                                      
               FROM CSS_PNDNG_BNK_DRFT PB WITH(READUNCOMMITTED)                 
              WHERE PB.ACCOUNT_NO IN                                    
                          (SELECT AT.ACCOUNT_NO                         
                             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)          
                            WHERE AT.CUSTOMER_NO = :JF-CUSTOMER-NO)     
                AND PB.CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO          
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PB.ACCOUNT_NO                                               
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_PNDNG_BNK_DRFT PB                                       
MFA-TR*       WHERE PB.ACCOUNT_NO IN                                            
MFA-TR*                   (SELECT AT.ACCOUNT_NO                                 
MFA-TR*                      FROM CSS_ACCOUNT AT                                
MFA-TR*                     WHERE AT.CUSTOMER_NO = :JF-CUSTOMER-NO)             
MFA-TR*         AND PB.CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO                  
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE 'Y' TO WS-PYMT-PNDNG                              
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-PYMT-PNDNG                              
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7700'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_PNDNG_BANK_DRFT'   TO TABLE-1                
                 MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1        
                 MOVE 'CUST_BANK_SEQ_NO'      TO TABLE-ELEMENT-2        
                 MOVE JF-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1      
                 MOVE JF-CUST-BANK-SEQ-NO     TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-CHK-FOR-UNIQUE-NM                                         *        
      ******************************************************************        
                                                                        
       7800-CHK-FOR-UNIQUE-NM.                                          
                                                                        
           MOVE 'N'               TO WS-NICKNAME-EXISTS-FLAG            
           EXEC SQL                                                     
               SELECT CUST_BANK_SEQ_NO                                  
                     ,BANK_ACCOUNT_NAME                                 
                 INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-IND                  
                     ,:JF-BANK-ACCOUNT-NAME                             
                 FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
                WHERE CUSTOMER_NO         = :JF-CUSTOMER-NO             
                  AND BANK_ACCT_NICKNAME  = :I-BANK-ACCT-NICKNAME       
                  AND BANK_ACCT_NO       <> :JF-BANK-ACCT-NO            
                  AND BANK_ACCT_STAT_CD  <> 'D'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUST_BANK_SEQ_NO                                          
MFA-TR*              ,BANK_ACCOUNT_NAME                                         
MFA-TR*          INTO :JF-CUST-BANK-SEQ-NO:WS-NULL-IND                          
MFA-TR*              ,:JF-BANK-ACCOUNT-NAME                                     
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO         = :JF-CUSTOMER-NO                     
MFA-TR*           AND BANK_ACCT_NICKNAME  = :I-BANK-ACCT-NICKNAME               
MFA-TR*           AND BANK_ACCT_NO       <> :JF-BANK-ACCT-NO                    
MFA-TR*           AND BANK_ACCT_STAT_CD  <> 'D'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7800                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'               TO WS-NICKNAME-EXISTS-FLAG      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7800'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * UPDATES CUSTOMER BANK WITH NEW NICKNAME                       *         
      *****************************************************************         
                                                                        
       8000-CUST-BANK-UPD.                                              
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CUSTOMER_BANK                                   
              SET BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME           
                 ,BANK_ACCT_TYPE_CD  = :JF-BANK-ACCT-TYPE-CD            
                 ,BANK_ACCOUNT_NAME  = :JF-BANK-ACCOUNT-NAME            
                 ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )             
              WHERE CUSTOMER_NO      = :JF-CUSTOMER-NO                  
                AND CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CUSTOMER_BANK                                           
MFA-TR*       SET BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME                   
MFA-TR*          ,BANK_ACCT_TYPE_CD  = :JF-BANK-ACCT-TYPE-CD                    
MFA-TR*          ,BANK_ACCOUNT_NAME  = :JF-BANK-ACCOUNT-NAME                    
MFA-TR*          ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTMP                     
MFA-TR*       WHERE CUSTOMER_NO      = :JF-CUSTOMER-NO                          
MFA-TR*         AND CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'       TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE JF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CUST_BANK_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE JF-CUST-BANK-SEQ-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-CUST-BANK-DEL.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUSTOMER_BANK                                 
                  SET BANK_ACCT_STAT_CD = :WS-D,                        
                      LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )          
                WHERE CUSTOMER_NO       = :JF-CUSTOMER-NO               
                  AND CUST_BANK_SEQ_NO  = :JF-CUST-BANK-SEQ-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUSTOMER_BANK                                         
MFA-TR*           SET BANK_ACCT_STAT_CD = :WS-D,                                
MFA-TR*               LAST_UPDATE_TS    = :WS-CURRENT-TIMESTMP                  
MFA-TR*         WHERE CUSTOMER_NO       = :JF-CUSTOMER-NO                       
MFA-TR*           AND CUST_BANK_SEQ_NO  = :JF-CUST-BANK-SEQ-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'       TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE JF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CUST_BANK_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE JF-CUST-BANK-SEQ-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-UPDATE-BANK-EFT.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
                  SET BANK_ACCOUNT_NAME = :JF-BANK-ACCOUNT-NAME,        
                      ACCT_TYPE_CD      = :JF-BANK-ACCT-TYPE-CD         
                WHERE CUSTOMER_NO       = :JF-CUSTOMER-NO               
                  AND CUST_BANK_SEQ_NO  = :JF-CUST-BANK-SEQ-NO          
      ***      WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-COMP3                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE             
                                      S-RETURN-CODE                     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BANK_EFT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE I-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SENDS ERROR RESULT                                            *         
      *---------------------------------------------------------------*         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE                  
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      *9900-SQL-ERROR.                                                          
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * 9999-END-PROGRAM.                                                       
      *---------------------------------------------------------------*         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
