       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04846.                                         
COB303 DATE-WRITTEN.      FEBRUARY 18, 2015.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS SP UPDATES CSS_BANK_EFT, CSS_PNDNG_BNK_DRFT, AND         *00190000
      *  CSS_ACCOUNT TABLES WITH BANK DRAFT INFORMATION.               *00200000
      *  THIS IS A REWRITE OF CSR02249 AND CSR04389 AND WILL BE USED   *00200000
      *  BY CIS MOD AND WEB MOD.                                       *00200000
      *                                                                *00180000
      *  BUSOP - UPDACCTEPAYDRAFTMAINTENANCE                           *00180000
      *                                                                *00180000
      *  PARM-UPDATE-TYPE = 'S' - EPAY/DRAFT ENROLL                    *00180000
      *                   = 'U' - UPDATE BANK-EFT                      *        
      *                   = 'C' - CANCEL ENROLLMENT                    *        
      *                                                                *        
      *  PARM-APPLN-SOURCE = CIS OR WEB                                *        
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
P00836*  02/18/2015 LG41184   PROCEDURE ORIGINALLY WRITTEN.            *        
P00732*  02/10/2016 VP43661   REMOVE BANK STATUS WHEN LOOKING FOR      *        
P00732*                       PREVIOUS PRIMARY BANK.                   *        
      *                                                                *        
      ******************************************************************00620000
      ******************************************************************00630000
      *                                                                *00640000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00650000
      *                                                                *00660000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00670000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00680000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00690000
      *  3000 - 4999  NOT USED                                         *00700000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00710000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00720000
      *  7000 - 7999  INPUT MODULES                                    *00730000
      *  8000 - 8999  OUTPUT MODULES                                   *00740000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00750000
      *                                                                *00760000
      ******************************************************************00770000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04846'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                              PIC X(40) VALUE        
           'WORKING STORAGE FOR CSR04846 STARTS HERE'.                  
                                                                        
      ******************************************************************00860000
      *    DB2 INCLUDES                                                *00870000
      ******************************************************************00880000
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                     00900000
              INCLUDE SQLCA                                             00910000
           END-EXEC.                                                    00920000
                                                                        
      *****    CSS_BANK_EFT - BE   *****                                        
           EXEC SQL                                                     00940000
              INCLUDE TBBNKEFT                                          00950000
           END-EXEC.                                                    00960000
                                                                        
      *****    CSS_PNDNG_BNK_DRFT - PB   *****                                  
           EXEC SQL                                                     00980000
              INCLUDE TBPDBKDF                                          00990000
           END-EXEC.                                                    01000000
                                                                        
      *****    CSS_ACCOUNT - AT   *****                                         
           EXEC SQL                                                     01020000
              INCLUDE TBACCT                                            01030000
           END-EXEC.                                                    01040000
                                                                        
      *****    CSS_MNT_TRANS_HIST - MH   *****                                  
           EXEC SQL                                                     01070000
              INCLUDE TBMNHIST                                          01080000
           END-EXEC.                                                    01090000
                                                                        
      *****    CSS_MT_TRN_HST_DET - MI   *****                                  
           EXEC SQL                                                     01110000
              INCLUDE TBMNHDT                                           01120000
           END-EXEC.                                                    01130000
                                                                        
      *****    CSS_CUSTOMER_BANK - JF    *****                                  
           EXEC SQL                                                     01150000
              INCLUDE TBCSTBNK                                          01160000
           END-EXEC.                                                    01170000
                                                                        
      *****    CSS_DELINQUENCY - C8    *****                                    
           EXEC SQL                                                     01150000
              INCLUDE TBDELQ                                            01160000
           END-EXEC.                                                    01170000
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                            *01200000
      *****************************************************************         
                                                                        
      * DB2 SQL ERROR CHECKING                                                  
           COPY CWS00303.                                               01320000
                                                                        
      * CODES-DATA-PRESENT FROM CSS_ACCOUNT                                     
           COPY CWS00056.                                               01360000
                                                                        
      * WS COPYBOOK FOR CPD00372                                                
           EXEC SQL                                                             
              INCLUDE CWS00372                                                  
           END-EXEC.                                                            
                                                                        
      * COMMON JOURNAL AREA                                                     
      *    EXEC SQL                                                     01380000
      *       INCLUDE CWS00013                                          01390000
      *    END-EXEC.                                                    01400000
                                                                        
      * ABEND WORK AREA                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    WORK AREAS                                                  *01430000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-COMMENT-LEN-NUM     PIC S9(04) COMP VALUE 0.        
           05  PARM-NICKNAME-LEN-NUM    PIC S9(04) COMP VALUE 0.        
           05  PARM-ACCOUNT-NO-TEMP     PIC X(13).                      
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO-TEMP  
                                        PIC 9(13).                      
           05  PARM-COMMENT-LEN-TEMP    PIC X(04) VALUE SPACES.         
           05  PARM-COMMENT-LEN-RED     REDEFINES PARM-COMMENT-LEN-TEMP 
                                        PIC 9(04).                      
           05  PARM-NICKNAME-LEN-TEMP   PIC X(04) VALUE SPACES.         
           05  PARM-NICKNAME-LEN-RED    REDEFINES                       
                                  PARM-NICKNAME-LEN-TEMP PIC 9(04).     
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC X(10) VALUE SPACES.          
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-DATE          PIC X(10)  VALUE SPACES.        
           05  WS-CURRENT-TIMESTMP      PIC X(26)  VALUE SPACES.        
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04846'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-CUSTOMER-NO-NUMERIC  PIC 9(10) VALUE ZERO.            
           05  WS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
           05  WS-BANK-ID-NUM          PIC S9(06) COMP-3 VALUE ZERO.    
           05  WS-BANK-ID              PIC X(06).                       
           05  WS-BANK-ID-NUMERIC      REDEFINES WS-BANK-ID             
                                       PIC 9(06).                       
           05  WS-CUST-BANK-SEQ-NO     PIC X(09).                       
           05  WS-CUST-BANK-SEQ-NUM    REDEFINES WS-CUST-BANK-SEQ-NO    
                                       PIC 9(09).                       
           05  WS-NULL-STATUS-DATE     PIC S9(04) COMP.                 
           05  WS-NULL-ACTION-DATE     PIC S9(04) COMP.                 
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE 0.         
           05  WS-NICKNAME             PIC X(50).                       
           05  WS-NICKNAME-EXISTS-FLAG PIC X(01) VALUE 'N'.             
               88 WS-NICKNAME-EXISTS             VALUE 'Y'.             
               88 WS-NICKNAME-NOT-EXISTS         VALUE 'N'.             
           05  WS-BANK-EFT-EXISTS-FLAG PIC X(01) VALUE 'N'.             
               88 WS-BANK-EFT-EXISTS             VALUE 'Y'.             
           05  WS-PEND-EXISTS-FLAG     PIC X(01) VALUE 'N'.             
               88 WS-PEND-EXISTS                 VALUE 'Y'.             
           05  WS-OLD-STATUS-CODE      PIC X(01).                       
           05  WS-OLD-STATUS-CHANGE-DT PIC X(10).                       
           05  WS-OLD-INIT-TYP-CD      PIC X(02).                       
           05  WS-OLD-CUST-BANK-SEQ    PIC S9(9) USAGE COMP.            
           05  WS-OLD-DRAFT-DAY        PIC X(02).                       
           05  WS-HOLD-BANK-ACCT-NO    PIC X(19) VALUE SPACES.          
           05  WS-HOLD-BANK-SEQ-NO     PIC S9(9) USAGE COMP.            
           05  WS-HOLD-BANK-ID-NUM     PIC S9(06) COMP-3 VALUE ZERO.    
           05  WS-HOLD-BANK-ID         PIC X(06).                       
           05  WS-HOLD-BANK-ID-NUMERIC REDEFINES WS-HOLD-BANK-ID        
                                       PIC 9(06).                       
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-APPLN-SOURCE           PIC X(08).                       
       01  PARM-UPDATE-TYPE            PIC X(01).                       
       01  PARM-ACCOUNT-NO             PIC X(13).                       
       01  PARM-STATUS-CODE            PIC X(01).                       
       01  PARM-DRAFT-CYCLE            PIC X(02).                       
       01  PARM-REQSTED-DRAFT-DAY      PIC X(02).                       
       01  PARM-BANK-ACCOUNT-NAME      PIC X(50).                       
       01  PARM-BANK-ACCT-NO           PIC X(19).                       
       01  PARM-ACCT-TYPE-CD           PIC X(01).                       
       01  PARM-BANK-ID                PIC X(06).                       
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-RESP-AREA-ID           PIC X(03).                       
       01  PARM-COMMENT-TEXT           PIC X(210).                      
       01  PARM-COMMENT-LEN            PIC X(04).                       
       01  PARM-INIT-TYPE-CD           PIC X(02).                       
       01  PARM-NICKNAME-TEXT          PIC X(50).                       
       01  PARM-NICKNAME-LEN           PIC X(04).                       
       01  PARM-CUST-BANK-SEQ-NO       PIC X(09).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPLN-SOURCE                       
                                PARM-UPDATE-TYPE                        
                                PARM-ACCOUNT-NO                         
                                PARM-STATUS-CODE                        
                                PARM-DRAFT-CYCLE                        
                                PARM-REQSTED-DRAFT-DAY                  
                                PARM-BANK-ACCOUNT-NAME                  
                                PARM-BANK-ACCT-NO                       
                                PARM-ACCT-TYPE-CD                       
                                PARM-BANK-ID                            
                                PARM-USER-ID                            
                                PARM-RESP-AREA-ID                       
                                PARM-COMMENT-TEXT                       
                                PARM-COMMENT-LEN                        
                                PARM-INIT-TYPE-CD                       
                                PARM-NICKNAME-TEXT                      
                                PARM-NICKNAME-LEN                       
                                PARM-CUST-BANK-SEQ-NO.                  
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *                          M A I N L I N E                      *         
      *   0000-MAINLINE.                                              * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       0000-MAINLINE.                                                   
      *                                                                 02550000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02550000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   0100-INITIALIZE.                                            * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       0100-INITIALIZE.                                                 
      *                                                                 02550000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE AS RETURN_CODE                    
                      ,:S-APPL-RETURN-CODE AS APPL_RETURN_CODE          
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE AS RETURN_CODE                            
MFA-TR*               ,:S-APPL-RETURN-CODE AS APPL_RETURN_CODE                  
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                    02850000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   1000-PROCESS-INPUT.                                         * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       1000-PROCESS-INPUT.                                              
      *                                                                 03060000
           INITIALIZE GTT-RETURN-FIELDS.                                
           ADD +1 TO CTR-ROWS.                                          
           MOVE PARM-ACCOUNT-NO      TO WS-ACCOUNT-NO.                  
           MOVE WS-ACCOUNT-NO-NUM    TO WS-ACCOUNT-NO-COMP3.            
           MOVE WS-ACCOUNT-NO-COMP3  TO AT-ACCOUNT-NO                   
                                        BE-ACCOUNT-NO                   
                                        PB-ACCOUNT-NO.                  
           MOVE PARM-COMMENT-LEN     TO PARM-COMMENT-LEN-TEMP.          
           MOVE PARM-NICKNAME-LEN    TO PARM-NICKNAME-LEN-TEMP.         
           MOVE PARM-COMMENT-LEN-RED TO PARM-COMMENT-LEN-NUM.           
                                                                        
           MOVE PARM-USER-ID         TO JF-LAST-UPDATE-USERID.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03200000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   2000-PROCESS-OUTPUT.                                        * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7050-SET-CURRENT-DATE-TS      THRU 7050-EXIT.        
           PERFORM 2200-FIND-BANK-EFT THRU 2200-EXIT.                   
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05690000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   2200-FIND-BANK-EFT.                                         * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2200-FIND-BANK-EFT.                                              
      *                                                                 05690000
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-CUSTOMER-NO         TO JF-CUSTOMER-NO.               
           MOVE AT-CUSTOMER-NO         TO WS-CUSTOMER-NO-NUMERIC.       
           MOVE WS-CUSTOMER-NO-NUMERIC TO WS-CUSTOMER-NO.               
                                                                        
           EVALUATE PARM-UPDATE-TYPE                                    
              WHEN 'S'                                                  
              WHEN 'U'                                                  
                 PERFORM 2400-ENROLL-UPDATE-BNKEFT  THRU 2400-EXIT      
              WHEN 'C'                                                  
                 PERFORM 2600-CANCEL-BANK-EFT    THRU 2600-EXIT         
           END-EVALUATE.                                                
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 2900-ALTER-AT-CODES    THRU 2900-EXIT.               
           PERFORM 8130-UPDATE-ACCOUNT    THRU 8130-EXIT.               
           MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *2400-ENROLL-UPDATE-BNKEFT.                                               
      *ENROLL IN OR UPDATE BANK-EFT.                                            
      ****************************************************************          
       2400-ENROLL-UPDATE-BNKEFT.                                       
           PERFORM 7100-SELECT-BANK-EFT   THRU 7100-EXIT.               
           IF WS-BANK-EFT-EXISTS                                        
              MOVE BE-STATUS-CODE            TO WS-OLD-STATUS-CODE      
              MOVE BE-INIT-TYPE-CD           TO WS-OLD-INIT-TYP-CD      
              MOVE BE-CUST-BANK-SEQ-NO       TO WS-OLD-CUST-BANK-SEQ    
              MOVE BE-REQSTED-DRAFT-DAY      TO WS-OLD-DRAFT-DAY        
              MOVE BE-BANK-ID                TO WS-BANK-ID-NUMERIC      
              MOVE WS-BANK-ID-NUMERIC        TO WS-BANK-ID-NUM          
              MOVE WS-BANK-ID-NUM            TO WS-BANK-ID              
           END-IF.                                                      
                                                                        
           IF WS-BANK-ID-NUM EQUAL ZEROES                               
              MOVE 'N' TO WS-BANK-EFT-EXISTS-FLAG                       
           END-IF.                                                      
                                                                        
           PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT.                  
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE +1                   TO WS-TRAN-APPL-NO.                
           PERFORM 5300-MOVE-TRAN-DET THRU 5300-EXIT.                   
           MOVE AT-CUSTOMER-NO           TO BE-CUSTOMER-NO              
                                                                        
           MOVE PARM-DRAFT-CYCLE         TO BE-DRAFT-CYCLE.             
           MOVE PARM-REQSTED-DRAFT-DAY   TO BE-REQSTED-DRAFT-DAY        
           MOVE PARM-STATUS-CODE         TO BE-STATUS-CODE.             
           MOVE PARM-BANK-ID             TO BE-BANK-ID.                 
           MOVE PARM-ACCT-TYPE-CD        TO BE-ACCT-TYPE-CD.            
           MOVE SPACE                    TO BE-LAST-DRAFT-CYCLE.        
           IF PARM-INIT-TYPE-CD NOT = SPACE                             
              MOVE PARM-INIT-TYPE-CD TO BE-INIT-TYPE-CD                 
           END-IF.                                                      
                                                                        
           IF PARM-CUST-BANK-SEQ-NO EQUAL SPACES OR                     
                    PARM-CUST-BANK-SEQ-NO EQUAL ZEROES                  
              MOVE PARM-USER-ID           TO WS-372-USER-ID             
              MOVE PARM-COMMENT-LEN-NUM   TO WS-372-COMMENT-LEN         
              MOVE PARM-COMMENT-TEXT      TO WS-372-COMMENT-TEXT        
                                                                        
              MOVE PARM-ACCT-TYPE-CD      TO JF-BANK-ACCT-TYPE-CD,      
                                             BE-ACCT-TYPE-CD            
              MOVE PARM-BANK-ACCOUNT-NAME TO JF-BANK-ACCOUNT-NAME,      
                                             BE-BANK-ACCOUNT-NAME       
              MOVE PARM-BANK-ACCT-NO      TO JF-BANK-ACCT-NO,           
                                             BE-BANK-ACCT-NO            
              MOVE PARM-BANK-ID           TO WS-BANK-ID                 
              MOVE WS-BANK-ID-NUMERIC     TO WS-BANK-ID-NUM             
              MOVE WS-BANK-ID-NUM         TO BE-BANK-ID, JF-BANK-ID     
              MOVE PARM-NICKNAME-TEXT     TO JF-BANK-ACCT-NICKNAME-TEXT 
              MOVE PARM-NICKNAME-LEN-RED  TO PARM-NICKNAME-LEN-NUM      
              MOVE PARM-NICKNAME-LEN-NUM  TO JF-BANK-ACCT-NICKNAME-LEN  
                                                                        
              PERFORM 6000-ADD-BANK-INFO  THRU 6000-ADD-BANK-INFO-EXIT  
              IF S-APPL-RETURN-CODE > SPACES                            
                               OR S-RETURN-CODE NOT = ZERO              
                 GO TO 2400-EXIT                                        
              ELSE                                                      
                 MOVE JF-CUST-BANK-SEQ-NO  TO BE-CUST-BANK-SEQ-NO       
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-CUST-BANK-SEQ-NO   TO WS-CUST-BANK-SEQ-NO       
              MOVE WS-CUST-BANK-SEQ-NUM    TO JF-CUST-BANK-SEQ-NO       
              PERFORM 7600-GET-BANK-DETAILS THRU 7600-EXIT              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                              JF-BANK-ACCT-STAT-CD = 'A'                
                 MOVE JF-CUST-BANK-SEQ-NO  TO BE-CUST-BANK-SEQ-NO       
                 MOVE JF-BANK-ACCOUNT-NAME TO BE-BANK-ACCOUNT-NAME      
                 MOVE JF-BANK-ACCT-NO      TO BE-BANK-ACCT-NO           
                 MOVE JF-BANK-ACCT-TYPE-CD TO BE-ACCT-TYPE-CD           
                 MOVE JF-BANK-ID           TO BE-BANK-ID                
              ELSE                                                      
      ******            BANK NOT FOUND                                          
                 MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE            
                 MOVE 'EPYMT00008'          TO S-APPL-RETURN-CODE       
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF PARM-UPDATE-TYPE = 'U'                                    
              PERFORM 5750-MNT-CUST-BANK-SEQ  THRU 5750-EXIT            
           END-IF                                                       
                                                                        
           IF WS-BANK-EFT-EXISTS                                        
              PERFORM 8110-UPDATE-BANK-EFT THRU 8110-EXIT               
           ELSE                                                         
              PERFORM 8180-INSERT-BANK-EFT THRU 8180-EXIT               
           END-IF.                                                      
                                                                        
           IF PARM-UPDATE-TYPE = 'U' AND                                
                   BE-CUST-BANK-SEQ-NO NOT = WS-OLD-CUST-BANK-SEQ       
              PERFORM 7225-CHECK-PENDING-EXISTS   THRU 7225-EXIT        
              IF WS-PEND-EXISTS                                         
                 MOVE BE-CUST-BANK-SEQ-NO  TO PB-CUST-BANK-SEQ-NO       
                 PERFORM 8165-UPDATE-PENDING-PMTS THRU 8165-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *2600-CANCEL-BANK-EFT.                                          *         
      *****************************************************************         
       2600-CANCEL-BANK-EFT.                                            
           PERFORM 7100-SELECT-BANK-EFT   THRU 7100-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              GO TO 2600-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE BE-STATUS-CODE            TO WS-OLD-STATUS-CODE         
                                                                        
           IF PARM-STATUS-CODE NOT = WS-OLD-STATUS-CODE                 
                    AND PARM-STATUS-CODE NOT = SPACES                   
              MOVE PARM-STATUS-CODE   TO BE-STATUS-CODE                 
                                                                        
              IF WS-OLD-STATUS-CODE = 'A' AND PARM-STATUS-CODE = 'D'    
                 PERFORM 8220-CANCEL-PNDNG-DRFTS THRU 8220-EXIT         
              END-IF                                                    
                                                                        
              PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT                
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              IF WS-TRAN-APPL-NO = 0                                    
                 MOVE +1                   TO WS-TRAN-APPL-NO           
              ELSE                                                      
                 ADD +1                    TO WS-TRAN-APPL-NO           
              END-IF                                                    
              PERFORM 5307-STATUS-CODE-MNT-TRANS THRU 5307-EXIT         
              PERFORM 8150-UPDATE-BANKEFT-STATUS THRU 8150-EXIT         
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *   2900-ALTER-AT-CODES.                                        * 02740000
      *   WS-CODE-BANK-EFT = 'A' ONLY FOR EDRAFT/BANKDRAFT, AND       *         
      *   NOT EPAY.                                                   *         
      *****************************************************************         
       2900-ALTER-AT-CODES.                                             
      *                                                                 06500000
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           IF BE-STATUS-CODE = 'A'                                      
              MOVE 'A' TO WS-CODE-BANK-EFT                              
           ELSE                                                         
              MOVE SPACES TO WS-CODE-BANK-EFT                           
           END-IF.                                                      
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.         
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08590000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   5100-MOVE-TRAN-HEAD.                                        * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
            MOVE 'F'                  TO MH-CODE-TRAN-TYPE.             
            MOVE PARM-RESP-AREA-ID    TO MH-RESP-AREA-ID.               
            MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO.                 
            MOVE WS-CURRENT-DATE      TO MH-DATE-TRANS.                 
            MOVE WS-CURRENT-TIMESTMP  TO MH-TRANS-HIST-SEQ-NO.          
                                                                        
            EVALUATE PARM-UPDATE-TYPE                                   
                WHEN 'U'                                                
                WHEN 'S'                                                
                     IF NOT WS-BANK-EFT-EXISTS                          
                        MOVE AT-CUSTOMER-NO TO MH-CUSTOMER-NO           
                     ELSE                                               
                        MOVE ZEROES TO MH-CUSTOMER-NO                   
                     END-IF                                             
                WHEN OTHER                                              
                     MOVE ZEROES TO MH-CUSTOMER-NO                      
            END-EVALUATE.                                               
            MOVE ZEROES               TO MH-PREMISE-NO.                 
            MOVE PARM-USER-ID         TO MH-USER-ID.                    
                                                                        
            IF PARM-STATUS-CODE <= 'I'                                  
               IF PARM-INIT-TYPE-CD = '02'                              
                  MOVE 'PANEL194E'    TO MH-APPL-PROGRAM-ID             
               ELSE                                                     
                  MOVE 'PANEL194'     TO MH-APPL-PROGRAM-ID             
               END-IF                                                   
            ELSE                                                        
               IF PARM-STATUS-CODE >= 'M'                               
                  MOVE 'PANELWEB'     TO MH-APPL-PROGRAM-ID             
               END-IF                                                   
            END-IF                                                      
                                                                        
            MOVE PARM-COMMENT-LEN-NUM TO MH-TRAN-COMMENT-LEN.           
            MOVE PARM-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.          
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   5300-MOVE-TRAN-DET.                                         * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       5300-MOVE-TRAN-DET.                                              
      *                                                                 09530000
           IF WS-BANK-EFT-EXISTS-FLAG = 'N'                             
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT                  
              MOVE +5      TO MI-PRV-COLUMN-VALUE-LEN                   
              MOVE WS-CURRENT-DATE        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE 'ESTABLISHED DAT'      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF.                                                      
                                                                        
           IF PARM-REQSTED-DRAFT-DAY > SPACES AND                       
           PARM-REQSTED-DRAFT-DAY NOT = WS-OLD-DRAFT-DAY                
               PERFORM 5305-DRAFT-DAY-MNT-TRANS   THRU 5305-EXIT        
           END-IF.                                                      
                                                                        
           IF  PARM-DRAFT-CYCLE NOT = BE-DRAFT-CYCLE                    
           AND PARM-DRAFT-CYCLE NOT = SPACES                            
           AND BE-DRAFT-CYCLE NOT = SPACES                              
               PERFORM 5306-DRAFT-CYCLE-MNT-TRANS THRU 5306-EXIT        
           END-IF.                                                      
      *                                                                 11540000
           IF  PARM-STATUS-CODE NOT = WS-OLD-STATUS-CODE                
           AND PARM-STATUS-CODE NOT = SPACES                            
               PERFORM 5307-STATUS-CODE-MNT-TRANS THRU 5307-EXIT        
           END-IF.                                                      
                                                                        
           IF PARM-INIT-TYPE-CD NOT = WS-OLD-INIT-TYP-CD                
                          AND PARM-INIT-TYPE-CD NOT = SPACES            
               PERFORM 5308-INIT-TYPE-MNT-TRANS   THRU 5308-EXIT        
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12660000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   5305-DRAFT-DAY-MNT-TRANS.                                   * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       5305-DRAFT-DAY-MNT-TRANS.                                        
      *                                                                 12660000
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           IF WS-BANK-EFT-EXISTS                                        
              MOVE WS-OLD-DRAFT-DAY         TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +2                       TO MI-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
           END-IF.                                                      
      *                                                                         
           MOVE PARM-REQSTED-DRAFT-DAY      TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE +2                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'DRAFT DAY'                 TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
       5305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   5306-DRAFT-CYCLE-MNT-TRANS.                                 * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       5306-DRAFT-CYCLE-MNT-TRANS.                                      
      *                                                                 12660000
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           IF WS-BANK-EFT-EXISTS                                        
              MOVE BE-DRAFT-CYCLE           TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +2                       TO MI-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
           END-IF.                                                      
      *                                                                         
           MOVE PARM-DRAFT-CYCLE            TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE +2                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'DRAFT CYCLE'               TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
       5306-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12660000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   5307-STATUS-CODE-MNT-TRANS.                                 * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       5307-STATUS-CODE-MNT-TRANS.                                      
      *                                                                 12660000
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE '46'                        TO MI-TABLE-ID.             
           IF WS-BANK-EFT-EXISTS                                        
              IF (PARM-STATUS-CODE > SPACES AND PARM-STATUS-CODE        
                              NOT = WS-OLD-STATUS-CODE)                 
                 MOVE WS-OLD-STATUS-CODE TO MI-PRV-COLUMN-VALUE-TEXT    
                 MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-CURRENT-DATE    TO BE-STATUS-CHANGE-DT         
                 MOVE 0                  TO WS-NULL-STATUS-DATE         
              ELSE                                                      
                 MOVE -1                 TO WS-NULL-STATUS-DATE         
                 GO TO 5307-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE -1                    TO WS-NULL-STATUS-DATE         
           END-IF.                                                      
      *                                                                         
           MOVE PARM-STATUS-CODE            TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE +1                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'STATUS CODE'               TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
       5307-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12660000
       5308-INIT-TYPE-MNT-TRANS.                                        
           IF WS-BANK-EFT-EXISTS                                        
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE SPACES                  TO MI-TABLE-ID               
              MOVE WS-OLD-INIT-TYP-CD      TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +2                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE PARM-INIT-TYPE-CD       TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE 'INIT TYPE CD'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
       5308-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   5750-MNT-CUST-BANK-SEQ.                                     * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       5750-MNT-CUST-BANK-SEQ.                                          
           IF WS-OLD-CUST-BANK-SEQ NOT = BE-CUST-BANK-SEQ-NO            
              MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO       
              MOVE SPACES                      TO MI-TABLE-ID           
              IF WS-BANK-EFT-EXISTS                                     
                 MOVE WS-OLD-CUST-BANK-SEQ TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE +9                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE BE-CUST-BANK-SEQ-NO  TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE 'PRIMARY BANK'       TO MI-COLUMN-DESC            
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                     TO WS-TRAN-APPL-NO           
                 MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO           
                                                                        
                 MOVE WS-OLD-CUST-BANK-SEQ TO WS-HOLD-BANK-SEQ-NO       
                 PERFORM 7550-GET-NICKNAME THRU 7550-EXIT               
                 MOVE 'BANK NICKNAME'      TO MI-COLUMN-DESC            
                 MOVE 50                   TO MI-PRV-COLUMN-VALUE-LEN,  
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-NICKNAME          TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE BE-CUST-BANK-SEQ-NO  TO WS-HOLD-BANK-SEQ-NO       
                 PERFORM 7550-GET-NICKNAME THRU 7550-EXIT               
                 MOVE WS-NICKNAME          TO MI-CHG-COLUMN-VALUE-TEXT  
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                     TO WS-TRAN-APPL-NO           
              ELSE                                                      
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE BE-CUST-BANK-SEQ-NO  TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE 'PRIMARY BANK'       TO MI-COLUMN-DESC            
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                     TO WS-TRAN-APPL-NO           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15470000
      *****************************************************************         
      *6000-ADD-BANK-INFO.                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00372                                                  
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   JOURNALLING INCLUDE.                                        * 02740000
      *   6530-LOAD-MNT-TRANS-HIST                                    *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                     12700000
              INCLUDE CPD00067                                          12710000
           END-EXEC.                                                    12720000
      *                                                                 12730000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   7000-SELECT-ACCOUNT.                                        * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7000-SELECT-ACCOUNT.                                             
      *                                                                 12770000
           EXEC SQL                                                     
               SELECT CUSTOMER_NO                                       
                     ,PREMISE_NO                                        
                     ,DATE_LAST_ACTION                                  
                     ,CODES_DATA_PRESENT                                
               INTO   :AT-CUSTOMER-NO                                   
                     ,:AT-PREMISE-NO                                    
                     ,:AT-DATE-LAST-ACTION :WS-NULL-ACTION-DATE          
                     ,:AT-CODES-DATA-PRESENT                            
               FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12800000
MFA-TR*        SELECT CUSTOMER_NO                                       12830000
MFA-TR*              ,PREMISE_NO                                        12840000
MFA-TR*              ,DATE_LAST_ACTION                                  12850000
MFA-TR*              ,CODES_DATA_PRESENT                                        
MFA-TR*        INTO   :AT-CUSTOMER-NO                                   12880000
MFA-TR*              ,:AT-PREMISE-NO                                    12890000
MFA-TR*              ,:AT-DATE-LAST-ACTION:WS-NULL-ACTION-DATE          12900000
MFA-TR*              ,:AT-CODES-DATA-PRESENT                                    
MFA-TR*        FROM   CSS_ACCOUNT                                       12910000
MFA-TR*        WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      12920000
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                    12930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12940000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 12960000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7050-SET-CURRENT-DATE-TS. *                                              
      *****************************************************************         
       7050-SET-CURRENT-DATE-TS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE,                         
MFA-TR*           :WS-CURRENT-TIMESTMP  = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   7100-SELECT-BANK-EFT.                                       * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7100-SELECT-BANK-EFT.                                            
      *                                                                 13160000
           EXEC SQL                                                     
               SELECT 'Y'                                               
                     ,ACCOUNT_NO                                        
                     ,CUSTOMER_NO                                       
                     ,BANK_ACCT_NO                                      
                     ,BANK_ID                                           
                     ,BANK_ACCOUNT_NAME                                 
                     ,ACCT_TYPE_CD                                      
                     ,STATUS_CHANGE_DT                                  
                     ,DRAFT_CYCLE                                       
                     ,REQSTED_DRAFT_DAY                                 
                     ,STATUS_CODE                                       
                     ,INIT_TYPE_CD                                      
                     ,CUST_BANK_SEQ_NO                                  
               INTO   :WS-BANK-EFT-EXISTS-FLAG                          
                     ,:BE-ACCOUNT-NO                                    
                     ,:BE-CUSTOMER-NO                                   
                     ,:BE-BANK-ACCT-NO                                  
                     ,:BE-BANK-ID                                       
                     ,:BE-BANK-ACCOUNT-NAME                             
                     ,:BE-ACCT-TYPE-CD                                  
                     ,:BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE          
                     ,:BE-DRAFT-CYCLE                                   
                     ,:BE-REQSTED-DRAFT-DAY                             
                     ,:BE-STATUS-CODE                                   
                     ,:BE-INIT-TYPE-CD                                  
                     ,:BE-CUST-BANK-SEQ-NO                              
               FROM   CSS_BANK_EFT WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO   = :BE-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13190000
MFA-TR*        SELECT 'Y'                                               13200000
MFA-TR*              ,ACCOUNT_NO                                        13210000
MFA-TR*              ,CUSTOMER_NO                                       13220000
MFA-TR*              ,BANK_ACCT_NO                                      13230000
MFA-TR*              ,BANK_ID                                           13240000
MFA-TR*              ,BANK_ACCOUNT_NAME                                 13250000
MFA-TR*              ,ACCT_TYPE_CD                                      13260000
MFA-TR*              ,STATUS_CHANGE_DT                                  13280000
MFA-TR*              ,DRAFT_CYCLE                                       13310000
MFA-TR*              ,REQSTED_DRAFT_DAY                                 13320000
MFA-TR*              ,STATUS_CODE                                       13330000
MFA-TR*              ,INIT_TYPE_CD                                              
MFA-TR*              ,CUST_BANK_SEQ_NO                                          
MFA-TR*        INTO   :WS-BANK-EFT-EXISTS-FLAG                          13350000
MFA-TR*              ,:BE-ACCOUNT-NO                                    13360000
MFA-TR*              ,:BE-CUSTOMER-NO                                   13370000
MFA-TR*              ,:BE-BANK-ACCT-NO                                  13380000
MFA-TR*              ,:BE-BANK-ID                                       13390000
MFA-TR*              ,:BE-BANK-ACCOUNT-NAME                             13400000
MFA-TR*              ,:BE-ACCT-TYPE-CD                                  13410000
MFA-TR*              ,:BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE          13430000
MFA-TR*              ,:BE-DRAFT-CYCLE                                   13460000
MFA-TR*              ,:BE-REQSTED-DRAFT-DAY                             13460000
MFA-TR*              ,:BE-STATUS-CODE                                   13480000
MFA-TR*              ,:BE-INIT-TYPE-CD                                          
MFA-TR*              ,:BE-CUST-BANK-SEQ-NO                                      
MFA-TR*        FROM   CSS_BANK_EFT                                      13500000
MFA-TR*        WHERE  ACCOUNT_NO   = :BE-ACCOUNT-NO                     13510000
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    13520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BE-STATUS-CHANGE-DT  TO WS-OLD-STATUS-CHANGE-DT      
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-BANK-EFT-EXISTS-FLAG                    
                 MOVE 0      TO BE-BANK-ID                              
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7100'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_BANK_EFT'       TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   7225-CHECK-PENDING-EXISTS                                   * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7225-CHECK-PENDING-EXISTS.                                       
      *                                                                 13750000
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-PEND-EXISTS-FLAG                              
                 FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO      = :PB-ACCOUNT-NO                  
                  AND CODE_SOURCE_ID IN ('I','S')                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13780000
MFA-TR*        SELECT 'Y'                                               13790000
MFA-TR*          INTO :WS-PEND-EXISTS-FLAG                              13840000
MFA-TR*          FROM CSS_PNDNG_BNK_DRFT                                13890000
MFA-TR*         WHERE ACCOUNT_NO      = :PB-ACCOUNT-NO                  13900000
MFA-TR*           AND CODE_SOURCE_ID IN ('I','S')                               
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7225                                                    
MFA-TR*    END-EXEC.                                                    13910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13920000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7225'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   7550-GET-NICKNAME.                                          * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7550-GET-NICKNAME.                                               
      *                                                                 14950000
           EXEC SQL                                                     
               SELECT BANK_ACCT_NICKNAME                                
                 INTO :WS-NICKNAME                                      
                 FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
                WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO              
                  AND CUST_BANK_SEQ_NO   = :WS-HOLD-BANK-SEQ-NO         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        SELECT BANK_ACCT_NICKNAME                                        
MFA-TR*          INTO :WS-NICKNAME                                              
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                      
MFA-TR*           AND CUST_BANK_SEQ_NO   = :WS-HOLD-BANK-SEQ-NO                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 15340000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7550'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUST_BANK_SEQ_NO'   TO TABLE-ELEMENT-2              
              MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE WS-HOLD-BANK-SEQ-NO  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   7600-GET-BANK-DETAILS.                                      * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7600-GET-BANK-DETAILS.                                           
      *                                                                 14950000
           EXEC SQL                                                     
               SELECT BANK_ACCOUNT_NAME                                 
                     ,BANK_ACCT_NO                                      
                     ,BANK_ACCT_STAT_CD                                 
                     ,BANK_ACCT_TYPE_CD                                 
                     ,BANK_ID                                           
                     ,BANK_ACCT_NICKNAME                                
                 INTO :JF-BANK-ACCOUNT-NAME                             
                     ,:JF-BANK-ACCT-NO                                  
                     ,:JF-BANK-ACCT-STAT-CD                             
                     ,:JF-BANK-ACCT-TYPE-CD                             
                     ,:JF-BANK-ID                                       
                     ,:JF-BANK-ACCT-NICKNAME                            
                 FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
                WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO              
                  AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        SELECT BANK_ACCOUNT_NAME                                         
MFA-TR*              ,BANK_ACCT_NO                                              
MFA-TR*              ,BANK_ACCT_STAT_CD                                         
MFA-TR*              ,BANK_ACCT_TYPE_CD                                         
MFA-TR*              ,BANK_ID                                                   
MFA-TR*              ,BANK_ACCT_NICKNAME                                        
MFA-TR*          INTO :JF-BANK-ACCOUNT-NAME                                     
MFA-TR*              ,:JF-BANK-ACCT-NO                                          
MFA-TR*              ,:JF-BANK-ACCT-STAT-CD                                     
MFA-TR*              ,:JF-BANK-ACCT-TYPE-CD                                     
MFA-TR*              ,:JF-BANK-ID                                               
MFA-TR*              ,:JF-BANK-ACCT-NICKNAME                                    
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                      
MFA-TR*           AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 15340000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   8110-UPDATE-BANK-EFT.                                       * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8110-UPDATE-BANK-EFT.                                            
      *                                                                 14520000
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
               SET BANK_ACCT_NO       = :BE-BANK-ACCT-NO                
                  ,BANK_ID            = :BE-BANK-ID                     
                  ,BANK_ACCOUNT_NAME  = :BE-BANK-ACCOUNT-NAME           
                  ,ACCT_TYPE_CD       = :BE-ACCT-TYPE-CD                
                  ,STATUS_CHANGE_DT   =                                 
                      IIF(TRY_CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                            :WS-NULL-STATUS-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) )          
                  ,REQSTED_DRAFT_DAY  = :BE-REQSTED-DRAFT-DAY           
                  ,DRAFT_CYCLE        = :BE-DRAFT-CYCLE                 
                  ,STATUS_CODE        = :BE-STATUS-CODE                 
                  ,INIT_TYPE_CD       = :BE-INIT-TYPE-CD                
                  ,CUST_BANK_SEQ_NO   = :BE-CUST-BANK-SEQ-NO            
               WHERE  ACCOUNT_NO      = :BE-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14550000
MFA-TR*        UPDATE CSS_BANK_EFT                                      14560000
MFA-TR*        SET BANK_ACCT_NO       = :BE-BANK-ACCT-NO                14570000
MFA-TR*           ,BANK_ID            = :BE-BANK-ID                     14580000
MFA-TR*           ,BANK_ACCOUNT_NAME  = :BE-BANK-ACCOUNT-NAME           14590000
MFA-TR*           ,ACCT_TYPE_CD       = :BE-ACCT-TYPE-CD                14600000
MFA-TR*           ,STATUS_CHANGE_DT   =                                 14630000
MFA-TR*               :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE          14640000
MFA-TR*           ,REQSTED_DRAFT_DAY  = :BE-REQSTED-DRAFT-DAY                   
MFA-TR*           ,DRAFT_CYCLE        = :BE-DRAFT-CYCLE                 14680000
MFA-TR*           ,STATUS_CODE        = :BE-STATUS-CODE                 14690000
MFA-TR*           ,INIT_TYPE_CD       = :BE-INIT-TYPE-CD                        
MFA-TR*           ,CUST_BANK_SEQ_NO   = :BE-CUST-BANK-SEQ-NO                    
MFA-TR*        WHERE  ACCOUNT_NO      = :BE-ACCOUNT-NO                  14710000
MFA-TR*    END-EXEC.                                                    14720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 14750000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8110'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK_EFT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   8130-UPDATE-ACCOUNT.                                        * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8130-UPDATE-ACCOUNT.                                             
      *                                                                 07100000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                     ,DATE_LAST_ACTION   = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                     ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07110000
MFA-TR*        UPDATE CSS_ACCOUNT                                       07120000
MFA-TR*           SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       07130000
MFA-TR*              ,DATE_LAST_ACTION   = CURRENT DATE                 07130000
MFA-TR*              ,LAST_UPDATE_TS     = CURRENT TIMESTAMP            07130000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       07140000
MFA-TR*    END-EXEC.                                                    07150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
      *                                                                 07190000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8130'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODES_DATA_PRESENT'  TO TABLE-ELEMENT-2             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              MOVE AT-CODES-DATA-PRESENT TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   8150-UPDATE-BANKEFT-STATUS.                                 * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8150-UPDATE-BANKEFT-STATUS.                                      
      *                                                                 14520000
           EXEC SQL                                                     
              UPDATE CSS_BANK_EFT                                       
                 SET STATUS_CODE      = :BE-STATUS-CODE                 
                    ,STATUS_CHANGE_DT =                                 
                         IIF(TRY_CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                               :WS-NULL-STATUS-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) )       
               WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14550000
MFA-TR*       UPDATE CSS_BANK_EFT                                       14550000
MFA-TR*          SET STATUS_CODE      = :BE-STATUS-CODE                 14560000
MFA-TR*             ,STATUS_CHANGE_DT =                                 14580000
MFA-TR*                  :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE               
MFA-TR*        WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                        14590000
MFA-TR*    END-EXEC.                                                    14720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
      *                                                                 14750000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BANK_EFT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *   8165-UPDATE-PENDING-PMTS.                                   * 02740000
      *****************************************************************         
       8165-UPDATE-PENDING-PMTS.                                        
      *                                                                 15540000
           EXEC SQL                                                     
               UPDATE CSS_PNDNG_BNK_DRFT                                
                  SET CUST_BANK_SEQ_NO   = :PB-CUST-BANK-SEQ-NO         
                WHERE ACCOUNT_NO         = :PB-ACCOUNT-NO               
                  AND CODE_SOURCE_ID    IN ('I','S')                    
                  AND PYMT_POSTED_FL <> 'Y'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE '8165'            TO ACTIVE-PARAGRAPH                
              MOVE 'UPDATE'          TO ABEND-FUNCTION                  
              MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                 
              MOVE PB-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1               
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8165-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   8180-INSERT-BANK-EFT.                                       * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8180-INSERT-BANK-EFT.                                            
      *                                                                 14970000
           EXEC SQL                                                     
               INSERT INTO CSS_BANK_EFT                                 
                      ( ACCOUNT_NO,                                     
                        CUSTOMER_NO,                                    
                        BANK_ACCT_NO,                                   
                        BANK_ID,                                        
                        BANK_ACCOUNT_NAME,                              
                        ACCT_TYPE_CD,                                   
                        ESTABLISHED_DATE,                               
                        STATUS_CHANGE_DT,                               
                        RESUME_DRAFT_DT,                                
                        REQSTED_DRAFT_DAY,                              
                        DRAFT_CYCLE,                                    
                        LAST_DRAFT_CYCLE,                               
                        STATUS_CODE,                                    
                        REMARKS,                                        
                        INIT_TYPE_CD,                                   
                        CUST_BANK_SEQ_NO)                               
               VALUES                                                   
                      (:BE-ACCOUNT-NO,                                  
                       :BE-CUSTOMER-NO,                                 
                       :BE-BANK-ACCT-NO,                                
                       :BE-BANK-ID,                                     
                       :BE-BANK-ACCOUNT-NAME,                           
                       :BE-ACCT-TYPE-CD,                                
                       IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ),                            
                       IIF(TRY_CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                             :WS-NULL-STATUS-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) ),        
                        NULL,                                           
                       :BE-REQSTED-DRAFT-DAY,                           
                       :BE-DRAFT-CYCLE,                                 
                       :BE-LAST-DRAFT-CYCLE,                            
                       :BE-STATUS-CODE,                                 
                        '',                                             
                       :BE-INIT-TYPE-CD,                                
                       :BE-CUST-BANK-SEQ-NO)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        INSERT INTO CSS_BANK_EFT                                 14990000
MFA-TR*               ( ACCOUNT_NO,                                     15000000
MFA-TR*                 CUSTOMER_NO,                                    15010000
MFA-TR*                 BANK_ACCT_NO,                                   15020000
MFA-TR*                 BANK_ID,                                        15030000
MFA-TR*                 BANK_ACCOUNT_NAME,                              15040000
MFA-TR*                 ACCT_TYPE_CD,                                   15050000
MFA-TR*                 ESTABLISHED_DATE,                               15060000
MFA-TR*                 STATUS_CHANGE_DT,                               15070000
MFA-TR*                 RESUME_DRAFT_DT,                                15080000
MFA-TR*                 REQSTED_DRAFT_DAY,                              15090000
MFA-TR*                 DRAFT_CYCLE,                                    15100000
MFA-TR*                 LAST_DRAFT_CYCLE,                               15110000
MFA-TR*                 STATUS_CODE,                                    15120000
MFA-TR*                 REMARKS,                                        15140000
MFA-TR*                 INIT_TYPE_CD,                                           
MFA-TR*                 CUST_BANK_SEQ_NO)                                       
MFA-TR*        VALUES                                                   15150000
MFA-TR*               (:BE-ACCOUNT-NO,                                  15160000
MFA-TR*                :BE-CUSTOMER-NO,                                 15170000
MFA-TR*                :BE-BANK-ACCT-NO,                                15180000
MFA-TR*                :BE-BANK-ID,                                     15190000
MFA-TR*                :BE-BANK-ACCOUNT-NAME,                           15200000
MFA-TR*                :BE-ACCT-TYPE-CD,                                15210000
MFA-TR*                :WS-CURRENT-DATE,                                15220000
MFA-TR*                :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE,        15230000
MFA-TR*                 NULL,                                           15240000
MFA-TR*                :BE-REQSTED-DRAFT-DAY,                                   
MFA-TR*                :BE-DRAFT-CYCLE,                                 15260000
MFA-TR*                :BE-LAST-DRAFT-CYCLE,                            15270000
MFA-TR*                :BE-STATUS-CODE,                                 15280000
MFA-TR*                 '',                                             15300000
MFA-TR*                :BE-INIT-TYPE-CD,                                        
MFA-TR*                :BE-CUST-BANK-SEQ-NO)                                    
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 15320000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK_EFT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   8220-CANCEL-PNDNG-DRFTS                                     * 02740000
      *   CANCEL PENDING DRAFTS                                       * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8220-CANCEL-PNDNG-DRFTS.                                         
      *                                                                 23550000
           EXEC SQL                                                     
               DELETE CSS_PNDNG_BNK_DRFT                                
                WHERE ACCOUNT_NO      = :PB-ACCOUNT-NO                  
                  AND CODE_SOURCE_ID IN ('I','S')                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE        
              ELSE                                                      
                 MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
                 MOVE '8220'            TO ACTIVE-PARAGRAPH             
                 MOVE 'UPDATE'          TO ABEND-FUNCTION               
                 MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
                 MOVE PB-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   8900-SEND-DONE.                                             * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   9000-SEND-ERROR-RESULT.                                     * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   9900-SQL-ERROR-ROUTINE                                      * 02740000
      *   9975-ABEND-CONTROL-TRANSFER                                 * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   9999-END-PROGRAM.                                           * 02740000
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE THRU 8900-EXIT                     
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
