       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04845.                                      
COB303 DATE-WRITTEN.     FEB 10, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04845              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04845 :                                                --         
      *--                                                            --         
      *--  UPDATE SAMPLE BILLING ACCOUNT TO CSS_BILL_SAMPLE TABLE.   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *-- PARAMETERS                                                 --         
      *--                                                            --         
      *--  INPUT                                                     --         
      *--    ACTION_IND              CHAR(01)                        --         
      *--    ACCOUNT_NO              CHAR(13)                        --         
      *--    USER_CALC_AM            DECIMAL(11, 2)                  --         
      *--    I_ACCOUNT_TYPE_CODE     CHAR(01)                        --         
      *--                                                            --         
      *--  OUTPUT                                                    --         
      *--    RESULT SET                                              --         
      *--    RETURN_CODE             INTEGER                         --         
      *--    APPL_RETURN_CODE        INTEGER                         --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
A04748*--  02/10/2015    SV95326     INITIAL VERSION.                --         
A04748*--  01/05/2015    SV95326     REMOVE CURRENT DATE LOGIC FROM  --         
      *--                            8400-DELETE-BILL-SAMPLE.        --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04845'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_SAMPLE , 4R                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILSMP                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      **** CSS_BILLING_DET , BG                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04845'.    
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05 WS-ACCOUNT-NO              PIC X(13) VALUE SPACES.        
           05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                    
                                         PIC S9(13).                    
           05  WS-GTT-NAME               PIC X(30) VALUE SPACES.        
           05  WS-BILL-AMT-DIFF-MSG      PIC X(43) VALUE                
               'AMOUNT ENTERED DOES NOT MATCH AMOUNT BILLED'.           
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
           05 GTT-RETURN-FIELDS-SAMPLE.                                 
              10 S-RETURN-CODE         PIC S9(9) COMP VALUE 0.          
              10 S-APPL-RETURN-CODE    PIC S9(9) COMP VALUE 0.          
      *                                                                         
      ****************************************************************          
      **   ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** WOKING STORAGE FOR CPDCA099                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE  BG_DET    CURSOR FOR                            
                SELECT  BG.CODE_UTIL_TYPE                               
                       ,BG.AMT_BILL_ITEM                                
                       ,BG.RATE_PLAN_NO                                 
                  FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
                       ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                
                 WHERE  BG.ACCOUNT_NO     = :4R-ACCOUNT-NO              
                   AND  BI.ACCOUNT_NO     = BG.ACCOUNT_NO               
                   AND  BG.BILL_NO        = BI.BILL_NO                  
                   AND  BG.CODE_BILL_CALC = 'A'                         
                   AND  BI.DATE_BILLED    = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
              ORDER BY BG.CODE_UTIL_TYPE                                
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*        DECLARE  BG_DET    CURSOR FOR                                  04
MFA-TR*         SELECT  BG.CODE_UTIL_TYPE                                     04
MFA-TR*                ,BG.AMT_BILL_ITEM                                        
MFA-TR*                ,BG.RATE_PLAN_NO                                         
MFA-TR*           FROM  CSS_BILLING_DET BG                                      
MFA-TR*                ,CSS_BILLING_HDR BI                                      
MFA-TR*          WHERE  BG.ACCOUNT_NO     = :4R-ACCOUNT-NO                      
MFA-TR*            AND  BI.ACCOUNT_NO     = BG.ACCOUNT_NO                       
MFA-TR*            AND  BG.BILL_NO        = BI.BILL_NO                          
MFA-TR*            AND  BG.CODE_BILL_CALC = 'A'                                 
MFA-TR*            AND  BI.DATE_BILLED    = CURRENT DATE                        
MFA-TR*       ORDER BY BG.CODE_UTIL_TYPE                                      03
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 PARM-ACTION-IND           PIC X(01) VALUE SPACES.             
       01 PARM-ACCOUNT-NO           PIC X(13) VALUE SPACES.             
COB305 01 PARM-USER-CALC-AM        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.        
       01 PARM-ACCOUNT-TYPE-CODE    PIC X(01) VALUE SPACES.             
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACTION-IND                         
                               ,PARM-ACCOUNT-NO                         
                               ,PARM-USER-CALC-AM                       
                               ,PARM-ACCOUNT-TYPE-CODE.                 
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT     THRU  2000-EXIT.             
           PERFORM 9999-END-PROGRAM        THRU  9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1   THRU 0100A-EXIT.              
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04845_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04845_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04845_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                  FROM #CSR04845_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*           FROM SESSION.CSR04845_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NUM            TO 4R-ACCOUNT-NO              
                                             AT-ACCOUNT-NO              
                                             BG-ACCOUNT-NO.             
           MOVE PARM-USER-CALC-AM         TO 4R-USER-CALC-AM.           
           MOVE PARM-ACCOUNT-TYPE-CODE    TO 4R-ACCOUNT-TYPE-CODE.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT.                                         **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           IF PARM-ACTION-IND  = 'A'                                    
              MOVE '2000'                    TO ACTIVE-PARAGRAPH        
              PERFORM 7000-GET-COMPANY-NO    THRU 7000-EXIT             
              MOVE AT-COMPANY-NO             TO 4R-COMPANY-NO           
              MOVE 0.00                      TO 4R-BILLED-AM            
              MOVE SPACES                    TO 4R-COMMENTS-TEXT        
              PERFORM 8200-INSERT-BILL-SAMPLE    THRU 8200-EXIT         
              PERFORM 8100-INSERT-GTT-R1         THRU 8100-EXIT         
           ELSE                                                         
              IF PARM-ACTION-IND  = 'U'                                 
                 MOVE 0.00                      TO 4R-BILLED-AM         
                 MOVE SPACES                    TO 4R-COMMENTS-TEXT     
                 PERFORM 8300-UPDATE-BILL-SAMPLE    THRU 8300-EXIT      
                 PERFORM 8100-INSERT-GTT-R1         THRU 8100-EXIT      
              ELSE                                                      
                 IF PARM-ACTION-IND  = 'D'                              
                    PERFORM 8400-DELETE-BILL-SAMPLE    THRU 8400-EXIT   
                    PERFORM 8100-INSERT-GTT-R1         THRU 8100-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 06071500
      * 7000-GET-COMPANY-NO.                                          * 06071600
      ***************************************************************** 06071700
       7000-GET-COMPANY-NO.                                             
      *                                                                 06071900
            EXEC SQL                                                    
                SELECT  AT.COMPANY_NO                                   
                  INTO :AT-COMPANY-NO                                   
                  FROM  CSS_ACCOUNT AT                                  
                 WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                    06072000
MFA-TR*         SELECT  AT.COMPANY_NO                                   06072100
MFA-TR*           INTO :AT-COMPANY-NO                                           
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*          WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                 06072200
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*     END-EXEC.                                                   06072700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06072800
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-APPL-RETURN-CODE.      
      *                                                                 06073100
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
            END-IF.                                                     
      *                                                                 06075500
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06075800
      *****************************************************************         
      ** DELETE SESSION TABLE                                        **         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04845_R1'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04845_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04845_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04845_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8100-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04845_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04845_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE 100                      TO  S-RETURN-CODE           
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04845_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************05610000
      * 8200-INSERT-BILL-SAMPLE.                                       *05630000
      ******************************************************************05640000
       8200-INSERT-BILL-SAMPLE.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_SAMPLE                               
                  (ACCOUNT_NO                                           
                  ,BILLED_DT                                            
                  ,COMPANY_NO                                           
                  ,BILLED_AM                                            
                  ,USER_CALC_AM                                         
                  ,LAST_UPDATE_TS                                       
                  ,COMMENTS                                             
                  ,ACCOUNT_TYPE_CODE                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4R-ACCOUNT-NO                                       
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,:4R-COMPANY-NO                                       
                  ,:4R-BILLED-AM                                        
                  ,:4R-USER-CALC-AM                                     
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:4R-COMMENTS                                         
                  ,:4R-ACCOUNT-TYPE-CODE                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     05670000
MFA-TR*       INSERT INTO CSS_BILL_SAMPLE                               05680000
MFA-TR*           (ACCOUNT_NO                                           05690000
MFA-TR*           ,BILLED_DT                                            05700000
MFA-TR*           ,COMPANY_NO                                           05700000
MFA-TR*           ,BILLED_AM                                            05700000
MFA-TR*           ,USER_CALC_AM                                         05700000
MFA-TR*           ,LAST_UPDATE_TS                                       05700000
MFA-TR*           ,COMMENTS                                             05700000
MFA-TR*           ,ACCOUNT_TYPE_CODE                                    05700000
MFA-TR*          )                                                      05750000
MFA-TR*       VALUES                                                    05760000
MFA-TR*          (                                                      05770000
MFA-TR*            :4R-ACCOUNT-NO                                       05700000
MFA-TR*           ,CURRENT DATE                                         05700000
MFA-TR*           ,:4R-COMPANY-NO                                       05700000
MFA-TR*           ,:4R-BILLED-AM                                        05700000
MFA-TR*           ,:4R-USER-CALC-AM                                     05700000
MFA-TR*           ,CURRENT TIMESTAMP                                    05700000
MFA-TR*           ,:4R-COMMENTS                                         05710000
MFA-TR*           ,:4R-ACCOUNT-TYPE-CODE                                05710000
MFA-TR*          )                                                      05830000
MFA-TR*    END-EXEC.                                                    05840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-APPL-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR -803 OR -530  
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8200'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_SAMPLE'        TO  TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'             TO  TABLE-ELEMENT-2         
              MOVE 4R-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
              MOVE 4R-COMPANY-NO            TO  HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
        8200-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************05610000
      * 8300-UPDATE-BILL-SAMPLE.                                       *05630000
      ******************************************************************05640000
       8300-UPDATE-BILL-SAMPLE.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE [4R]                                  
                 SET [4R].BILLED_AM = :4R-BILLED-AM                       
                    ,[4R].COMMENTS  = :4R-COMMENTS                        
              FROM CSS_BILL_SAMPLE [4R]
               WHERE [4R].BILLED_DT = CAST(SYSDATETIMEOFFSET() AS DATE)         
                 AND [4R].ACCOUNT_TYPE_CODE = :4R-ACCOUNT-TYPE-CODE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     05670000
MFA-TR*       UPDATE CSS_BILL_SAMPLE 4R                                 05680000
MFA-TR*          SET 4R.BILLED_AM = :4R-BILLED-AM                               
MFA-TR*             ,4R.COMMENTS  = :4R-COMMENTS                                
MFA-TR*        WHERE 4R.BILLED_DT = CURRENT DATE                                
MFA-TR*          AND 4R.ACCOUNT_TYPE_CODE = :4R-ACCOUNT-TYPE-CODE               
MFA-TR*    END-EXEC.                                                    05840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-APPL-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8300'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'UPDATE'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_SAMPLE'        TO  TABLE-1                 
              MOVE 'BILLED_DT'              TO  TABLE-ELEMENT-1         
              MOVE 'CURRENT DATE'           TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
        8300-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************05610000
      * 8400-DELETE-BILL-SAMPLE.                                       *05630000
      ******************************************************************05640000
       8400-DELETE-BILL-SAMPLE.                                         
                                                                        
           EXEC SQL                                                     
              DELETE [4R]                                  
              FROM CSS_BILL_SAMPLE [4R]
               WHERE [4R].ACCOUNT_NO = :4R-ACCOUNT-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     05670000
MFA-TR*       DELETE CSS_BILL_SAMPLE 4R                                 05680000
MFA-TR*        WHERE 4R.ACCOUNT_NO = :4R-ACCOUNT-NO                             
MFA-TR*    END-EXEC.                                                    05840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-APPL-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8400'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'DELETE'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_SAMPLE'        TO  TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
              MOVE 'BILLED_DT'              TO  TABLE-ELEMENT-2         
              MOVE 4R-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
              MOVE 'CURRENT DATE'           TO  HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
        8400-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              MOVE   0                      TO S-RETURN-CODE            
              PERFORM 8100-INSERT-GTT-R1       THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04845_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
*******    INITIALIZE GTT-RETURN-FIELDS.                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
                                                                        
           PERFORM 8100-INSERT-GTT-R1             THRU 8100-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
            
MSQ016        GOBACK.                                                   
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
