       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04844.                                      
COB303 DATE-WRITTEN.     FEB 10, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04844              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04844 :                                                --         
      *--                                                            --         
      *--  GET SAMPLE BILLING DATA FROM CSS_BILL_SAMPLE TABLE.       --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *-- PARAMETERS                                                 --         
      *--                                                            --         
      *--  INPUT                                                     --         
      *--    I_ACCOUNT_TYPE_CODE     CHAR(01)                        --         
      *--  OUTPUT                                                    --         
      *--    RESULT SET                                              --         
      *--    RETURN_CODE             INTEGER                         --         
      *--    ACCOUNT_NO              DECIMAL(13,0)                   --         
      *--    BILLED_DT               DATE                            --         
      *--    COMPANY_NO              CHAR(2)                         --         
      *--    BILLED_AM               DECIMAL(11,2)                   --         
      *--    USER_CALC_AM            DECIMAL(11,2)                   --         
      *--    COMMENTS                CHAR(250)                       --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
A04748*--  02/10/2015    SV95326     INITIAL VERSION.                --         
A04748*--  11/23/2015    SV95326     REMOVE CURRENT DATE LOGIC FROM  --         
      *--                            CURSOR.                         --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04844'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_SAMPLE , 4R                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILSMP                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_DET , BG                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04844'. 
           05  WS-BILL-AMT-DIFF-MSG         PIC X(43) VALUE             
                   'AMOUNT ENTERED DOES NOT MATCH AMOUNT BILLED'.       
           05  WS-BG-ROW-CNT                PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-R1               PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-R2               PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
           05 GTT-RETURN-FIELDS-SAMPLE.                                 
              10 S-RETURN-CODE         PIC S9(9) COMP VALUE 0.          
COB305        10 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
              10 S-BILLED-DT           PIC X(10).                       
              10 S-COMPANY-NO          PIC X(2).                        
COB305        10 S-BILLED-AM        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.     
COB305        10 S-USER-CALC-AM        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.     
              10 S-COMMENTS-TEXT       PIC X(250).                      
      *                                                                         
           05 GTT-RETURN-FIELDS-SAMPLE-DET.                             
              10 S-RETURN-CODE-R2      PIC S9(9) COMP VALUE 0.          
COB305        10 S-ACCOUNT-NO-R2        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.        
              10 S-CODE-UTIL-TYPE      PIC X(01).                       
              10 S-RATE-PLAN-NO        PIC X(3).                        
COB305        10 S-BILLED-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.     
COB305        10 S-USER-CALC-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.     
              10 S-COMMENTS-TXT        PIC X(250).                      
      *                                                                         
      ****************************************************************          
      **   ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** WOKING STORAGE FOR CPDCA099                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** FIXTURE SPECIAL AGREEMENTS CURSOR                            **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE SAMPLE_ACCT_CUR CURSOR FOR                       
                SELECT  [4R].ACCOUNT_NO                                   
                       ,[4R].BILLED_DT                                    
                       ,[4R].COMPANY_NO                                   
                       ,[4R].BILLED_AM                                    
                       ,[4R].USER_CALC_AM                                 
                       ,[4R].COMMENTS                                     
                 FROM  CSS_BILL_SAMPLE  [4R] WITH(READUNCOMMITTED)              
                WHERE  [4R].COMPANY_NO    IN ('01','26')                  
                  AND  [4R].ACCOUNT_TYPE_CODE  = :4R-ACCOUNT-TYPE-CODE    
                ORDER BY [4R].COMPANY_NO                                  
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SAMPLE_ACCT_CUR CURSOR FOR                               
MFA-TR*         SELECT  4R.ACCOUNT_NO                                           
MFA-TR*                ,4R.BILLED_DT                                            
MFA-TR*                ,4R.COMPANY_NO                                           
MFA-TR*                ,4R.BILLED_AM                                            
MFA-TR*                ,4R.USER_CALC_AM                                         
MFA-TR*                ,4R.COMMENTS                                             
MFA-TR*          FROM  CSS_BILL_SAMPLE  4R                                      
MFA-TR*         WHERE  4R.COMPANY_NO    IN ('01','26')                          
MFA-TR*           AND  4R.ACCOUNT_TYPE_CODE  = :4R-ACCOUNT-TYPE-CODE            
MFA-TR*         ORDER BY 4R.COMPANY_NO                                          
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE  BG_DET    CURSOR FOR                            
                SELECT  BG.CODE_UTIL_TYPE                               
                       ,BG.AMT_BILL_ITEM                                
                       ,BG.RATE_PLAN_NO                                 
                  FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
                       ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                
                 WHERE  BG.ACCOUNT_NO     = :4R-ACCOUNT-NO              
                   AND  BI.ACCOUNT_NO     = BG.ACCOUNT_NO               
                   AND  BG.BILL_NO        = BI.BILL_NO                  
                   AND  BG.CODE_BILL_CALC = 'A'                         
                   AND  BI.DATE_BILLED    = IIF(TRY_CONVERT(DATE, 
                                                          :4R-BILLED-DT
              ) IS NULL OR (PATINDEX('%.%', :4R-BILLED-DT
              ) <> 0) OR (LEN(:4R-BILLED-DT) <> 10), CIS.CHAR2DATE(
                                                          :4R-BILLED-DT
              ), CONVERT(DATE, :4R-BILLED-DT) )               
              ORDER BY BG.CODE_UTIL_TYPE                                
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*        DECLARE  BG_DET    CURSOR FOR                                  04
MFA-TR*         SELECT  BG.CODE_UTIL_TYPE                                     04
MFA-TR*                ,BG.AMT_BILL_ITEM                                        
MFA-TR*                ,BG.RATE_PLAN_NO                                         
MFA-TR*           FROM  CSS_BILLING_DET BG                                      
MFA-TR*                ,CSS_BILLING_HDR BI                                      
MFA-TR*          WHERE  BG.ACCOUNT_NO     = :4R-ACCOUNT-NO                      
MFA-TR*            AND  BI.ACCOUNT_NO     = BG.ACCOUNT_NO                       
MFA-TR*            AND  BG.BILL_NO        = BI.BILL_NO                          
MFA-TR*            AND  BG.CODE_BILL_CALC = 'A'                                 
MFA-TR*            AND  BI.DATE_BILLED    = :4R-BILLED-DT                       
MFA-TR*       ORDER BY BG.CODE_UTIL_TYPE                                      03
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-TYPE-CODE    PIC X(01) VALUE SPACES.             
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-TYPE-CODE.                 
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT     THRU  2000-EXIT.             
           PERFORM 2900-VLDT-NOTFOUND-RES  THRU  2900-EXIT.             
           PERFORM 9999-END-PROGRAM        THRU  9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-SAMPLE-DET  THRU  0100A-EXIT.      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE                               **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-SAMPLE-DET.                                    
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04844_R1'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04844_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04844_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)              
                   ,BILLED_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,BILLED_AM               DECIMAL(11,2)              
                   ,USER_CALC_AM            DECIMAL(11,2)              
                   ,COMMENTS CHAR(250)  COLLATE LATIN1_GENERAL_100_BIN2         
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS     THRU  8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04844_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,BILLED_DT                                        
                      ,COMPANY_NO                                       
                      ,BILLED_AM                                        
                      ,USER_CALC_AM                                     
                      ,COMMENTS                                         
                  FROM #CSR04844_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,BILLED_DT                                                
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILLED_AM                                                
MFA-TR*               ,USER_CALC_AM                                             
MFA-TR*               ,COMMENTS                                                 
MFA-TR*           FROM SESSION.CSR04844_R1                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04844_R2'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04844_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04844_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)              
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILLED_AMT              DECIMAL(11,2)              
                   ,USER_CALC_AMT           DECIMAL(11,2)              
                   ,COMMENTS CHAR(250)  COLLATE LATIN1_GENERAL_100_BIN2         
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS     THRU  8000B-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04844_R2'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,BILLED_AMT                                       
                      ,USER_CALC_AMT                                    
                      ,COMMENTS                                         
                  FROM #CSR04844_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,BILLED_AMT                                               
MFA-TR*               ,USER_CALC_AMT                                            
MFA-TR*               ,COMMENTS                                                 
MFA-TR*           FROM SESSION.CSR04844_R2                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT.                                         **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-ACCOUNT-TYPE-CODE    TO 4R-ACCOUNT-TYPE-CODE.      
           PERFORM 7100-OPEN-SAMPLE-ACCT-CUR THRU 7100-EXIT.            
           PERFORM 2200-PROCESS-SAMPLE-ACCT-CUR THRU 2200-EXIT          
                        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.        
           PERFORM 7120-CLOSE-SAMPLE-ACCT-CUR THRU 7120-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND RESULT SET                                       **        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE '2000A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE 4R-ACCOUNT-NO             TO S-ACCOUNT-NO.              
           MOVE 4R-BILLED-DT              TO S-BILLED-DT.               
           MOVE 4R-COMPANY-NO             TO S-COMPANY-NO.              
           MOVE 4R-BILLED-AM              TO S-BILLED-AM.               
           MOVE 4R-USER-CALC-AM           TO S-USER-CALC-AM.            
           IF WS-BG-ROW-CNT = 0                                         
              MOVE 26                           TO 4R-COMMENTS-LEN      
              MOVE 'ACCOUNT IS NOT YET BILLED.' TO 4R-COMMENTS-TEXT     
           ELSE                                                         
              IF 4R-USER-CALC-AM NOT EQUAL 4R-BILLED-AM                 
                 MOVE 43                      TO 4R-COMMENTS-LEN        
                 MOVE WS-BILL-AMT-DIFF-MSG    TO 4R-COMMENTS-TEXT       
              ELSE                                                      
                 MOVE SPACES                  TO 4R-COMMENTS-TEXT       
              END-IF                                                    
           END-IF.                                                      
           MOVE 4R-COMMENTS-TEXT          TO S-COMMENTS-TEXT.           
      *                                                                         
           PERFORM 8100A-SEND-RESULT      THRU  8100A-EXIT.             
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
       2000B-MOVE-RESULT.                                               
      *                                                                         
           MOVE '2000A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE 4R-ACCOUNT-NO             TO S-ACCOUNT-NO-R2.           
           MOVE BG-CODE-UTIL-TYPE         TO S-CODE-UTIL-TYPE.          
           MOVE BG-RATE-PLAN-NO           TO S-RATE-PLAN-NO.            
           MOVE BG-AMT-BILL-ITEM          TO S-BILLED-AMT.              
           MOVE 4R-USER-CALC-AM           TO S-USER-CALC-AMT.           
           MOVE SPACES                    TO S-COMMENTS-TXT.            
      *                                                                         
           PERFORM 8200A-SEND-RESULT      THRU  8200A-EXIT.             
      *                                                                         
       2000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-SAMPLE-ACCT-CUR.                                  *        
      ******************************************************************        
                                                                        
       2200-PROCESS-SAMPLE-ACCT-CUR.                                    
                                                                        
           PERFORM 7110-FETCH-SAMPLE-ACCT-CUR THRU 7110-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 0      TO WS-BG-ROW-CNT                              
              MOVE 0.00   TO BG-AMT-BILL-ITEM                           
              PERFORM 7130-OPEN-BG-DET-CUR THRU 7130-EXIT               
              PERFORM 2300-PROCESS-BG-DET-CUR THRU 2300-EXIT            
                        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
              PERFORM 7150-CLOSE-BG-DET-CUR THRU 7150-EXIT              
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              INITIALIZE DCLCSS-BILL-SAMPLE                             
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-BG-DET-CUR.                                       *        
      ******************************************************************        
                                                                        
       2300-PROCESS-BG-DET-CUR.                                         
                                                                        
           PERFORM 7140-FETCH-BG-DET-CUR THRU 7140-EXIT.                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD BG-AMT-BILL-ITEM  TO 4R-BILLED-AM                     
              ADD 1                 TO WS-BG-ROW-CNT                    
              PERFORM 2000B-MOVE-RESULT THRU 2000B-EXIT                 
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-R1  = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-SAMPLE   
              MOVE 100                        TO S-RETURN-CODE          
              PERFORM 8100A-SEND-RESULT       THRU  8100A-EXIT          
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-R2  = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-SAMPLE   
              MOVE 100                        TO S-RETURN-CODE-R2       
              PERFORM 8200A-SEND-RESULT       THRU  8200A-EXIT          
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-SAMPLE-ACCT-CUR.                                     *        
      ******************************************************************        
                                                                        
       7100-OPEN-SAMPLE-ACCT-CUR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN SAMPLE_ACCT_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BILL_SAMPLE'      TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-SAMPLE-ACCT-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7110-FETCH-SAMPLE-ACCT-CUR.                                      
                                                                        
           EXEC SQL                                                     
                FETCH SAMPLE_ACCT_CUR                                   
                INTO :4R-ACCOUNT-NO                                     
                    ,:4R-BILLED-DT                                      
                    ,:4R-COMPANY-NO                                     
                    ,:4R-BILLED-AM                                      
                    ,:4R-USER-CALC-AM                                   
                    ,:4R-COMMENTS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7110'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BILL_SAMPLE'          TO TABLE-1               
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-SAMPLE-ACCT-CUR.                                    *        
      ******************************************************************        
                                                                        
       7120-CLOSE-SAMPLE-ACCT-CUR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE SAMPLE_ACCT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7120'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BILL_SAMPLE'      TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-OPEN-BG-DET-CUR.                                          *        
      ******************************************************************        
                                                                        
       7130-OPEN-BG-DET-CUR.                                            
                                                                        
           EXEC SQL                                                     
                OPEN BG_DET                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE-R2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7130'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BILLING_DET'      TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7140-FETCH-BG-DET-CUR.                                         *        
      ******************************************************************        
                                                                        
       7140-FETCH-BG-DET-CUR.                                           
                                                                        
           EXEC SQL                                                     
                FETCH BG_DET                                            
                INTO :BG-CODE-UTIL-TYPE                                 
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE-R2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7140'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BILLING_DET'          TO TABLE-1               
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-CLOSE-BG-DET-CUR.                                         *        
      ******************************************************************        
                                                                        
       7150-CLOSE-BG-DET-CUR.                                           
                                                                        
           EXEC SQL                                                     
                CLOSE BG_DET                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE-R2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7150'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BILLING_DET'      TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** DELETE SESSION TABLE                                        **         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04844_R1'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04844_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04844_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04844_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04844_R2'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04844_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04844_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04844_R2'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET                                            **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT.                                               
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04844_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,BILLED_DT                                            
                  ,COMPANY_NO                                           
                  ,BILLED_AM                                            
                  ,USER_CALC_AM                                         
                  ,COMMENTS                                             
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-ACCOUNT-NO                                        
                  ,:S-BILLED-DT                                         
                  ,:S-COMPANY-NO                                        
                  ,:S-BILLED-AM                                         
                  ,:S-USER-CALC-AM                                      
                  ,:S-COMMENTS-TEXT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04844_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,BILLED_DT                                                    
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,BILLED_AM                                                    
MFA-TR*           ,USER_CALC_AM                                                 
MFA-TR*           ,COMMENTS                                                     
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-ACCOUNT-NO                                                
MFA-TR*           ,:S-BILLED-DT                                                 
MFA-TR*           ,:S-COMPANY-NO                                                
MFA-TR*           ,:S-BILLED-AM                                                 
MFA-TR*           ,:S-USER-CALC-AM                                              
MFA-TR*           ,:S-COMMENTS-TEXT                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-R1             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04844_R1'             TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100A-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET                                            **        
      ******************************************************************        
      *                                                                         
       8200A-SEND-RESULT.                                               
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04844_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,RATE_PLAN_NO                                         
                  ,BILLED_AMT                                           
                  ,USER_CALC_AMT                                        
                  ,COMMENTS                                             
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-R2                                    
                  ,:S-ACCOUNT-NO-R2                                     
                  ,:S-CODE-UTIL-TYPE                                    
                  ,:S-RATE-PLAN-NO                                      
                  ,:S-BILLED-AMT                                        
                  ,:S-USER-CALC-AMT                                     
                  ,:S-COMMENTS-TXT                                      
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04844_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,BILLED_AMT                                                   
MFA-TR*           ,USER_CALC_AMT                                                
MFA-TR*           ,COMMENTS                                                     
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-R2                                            
MFA-TR*           ,:S-ACCOUNT-NO-R2                                             
MFA-TR*           ,:S-CODE-UTIL-TYPE                                            
MFA-TR*           ,:S-RATE-PLAN-NO                                              
MFA-TR*           ,:S-BILLED-AMT                                                
MFA-TR*           ,:S-USER-CALC-AMT                                             
MFA-TR*           ,:S-COMMENTS-TXT                                              
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-R2             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8200A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04844_R2'             TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8200A-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-SAMPLE-DET THRU  0100A-EXIT.       
      *                                                                         
           PERFORM 8100A-SEND-RESULT            THRU  8100A-EXIT.       
           PERFORM 8200A-SEND-RESULT            THRU  8200A-EXIT.       
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE       THRU  9900-EXIT.        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE  THRU  8900-EXIT.                     
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
