       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04842.                                        
       AUTHOR.         HA7A338.                                         
COB303 DATE-WRITTEN.   FEB 19, 2015.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000100
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000200
      ******************************************************************00000600
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  #  INVOKED FROM CIS MODERNIZATION CASH MANAGEMENT SCREEN.     *        
      *  #  BUSOP - REQUVALIDATERECEIPTNUMBER                          *        
      *  #  VALIDATE RECEIPY NUMBERS OF APS, BILLMATRIX AND E-PAY.     *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             I_RCPT_NO        CHAR(15)                          *        
      *             I_RCPT_TYPE      CHAR(1)                           *        
      *                                                                *        
      *             I_RCPT_TYPE = 'A' APS (CHECK FREE)                 *        
      *                           'B' BILL MATRIX                      *        
      *                           'P' EPAY                             *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  ------------------                                            *        
      *             RETURN_CODE                                        *        
      *             APPL_RETURN_CODE                                   *        
      *             VALIDATION_FLAG                                    *        
      *             PAYMENT_DATE                                       *        
      *             PAYMENT_TIME                                       *        
      *             PAYMENT_TYPE                                       *        
      *             PAYMENT_RANGE                                      *        
      *             LAST_DIGIT_ACCT_NO                                 *        
      *             TRANSACTION_CODE                                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS    COMMENTS                                *        
      *  --------  --------    ----------------------------            *        
P00586*  02/19/15   HA7A338    NEW PROGRAM                             *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04842'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04842 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    NO DB2 TABLES USED                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04842'.      
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  GTT-NAME                PIC X(26)                        
                                            VALUE 'SESSION.CSR04842_R1'.
       01  MISC-FIELD.                                                  
           05  RS-RETURN-CODE          PIC S9(9) VALUE 0 COMP.          
           05  S-RETURN-CODE           PIC S9(9) VALUE 0 COMP.          
           05  WS-RCPT-NO              PIC X(15) VALUE SPACES.          
           05  WS-RCPT-TYPE            PIC X(01) VALUE ' '.             
               88 CHECK-FREE                     VALUE 'A'.             
               88 BILL-MATRIX                    VALUE 'B'.             
               88 E-PAY                          VALUE 'P'.             
           05  WS-VALID-RECEIPT        PIC X(01) VALUE ' '.             
               88 VALID-RECEIPT                  VALUE 'Y'.             
               88 INVALID-RECEIPT                VALUE 'N'.             
           05  WS-VALIDATION-FLAG      PIC X(01) VALUE SPACES.          
           05  WS-PAYMENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-RCPT-DAY-OF-YEAR     PIC X(03) VALUE SPACES.          
           05  WS-RCPT-DAY-OF-YEAR-N   REDEFINES WS-RCPT-DAY-OF-YEAR    
                                       PIC 9(03).                       
           05  WS-DAY-OF-YEAR          PIC S9(4) COMP.                  
           05  WS-RCPT-PAYMT-RANGE     PIC X(01) VALUE SPACES.          
           05  WS-RCPT-PAYMT-RANGE-N   REDEFINES WS-RCPT-PAYMT-RANGE    
                                       PIC 9(01).                       
           05  WS-RCPT-PAYMT-TSTMP     PIC X(05) VALUE SPACES.          
           05  WS-RCPT-PAYMT-TSTMP-N   REDEFINES WS-RCPT-PAYMT-TSTMP    
                                       PIC 9(05).                       
           05  WS-PAYMNT-SECONDS       PIC S9(9) COMP.                  
           05  WS-PAYMNT-24HR          PIC X(02).                       
           05  WS-PAYMNT-HH            PIC X(02).                       
           05  WS-PAYMNT-MM            PIC X(02).                       
           05  WS-PAYMNT-SS            PIC X(02).                       
           05  WS-PAYMNT-AM-PM         PIC X(02).                       
           05  WS-RCPT-PAYMT-TYPE      PIC X(01) VALUE SPACES.          
           05  WS-RCPT-PAYMT-TYPE-N    REDEFINES WS-RCPT-PAYMT-TYPE     
                                       PIC 9(01).                       
           05  WS-RCPT-ACCT-NUMBER     PIC X(01) VALUE SPACES.          
           05  WS-RCPT-TRAN-NUMBER     PIC X(04) VALUE SPACES.          
           05  WS-RCPT-PAYMT-YY        PIC X(02) VALUE SPACES.          
           05  WS-PYMNT-DATE           PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-DATE.                                                 
               10 WS-DATE-CC           PIC X(02).                       
               10 WS-DATE-YY           PIC X(02).                       
               10 FILLER               PIC X(01).                       
               10 WS-DATE-MM           PIC X(02).                       
               10 FILLER               PIC X(01).                       
               10 WS-DATE-DD           PIC X(02).                       
           05  WS-PAYMENT-TIME.                                         
               10 WS-PAYMENT-HH        PIC X(02).                       
               10 FILLER               PIC X(01) VALUE ':'.             
               10 WS-PAYMENT-MM        PIC X(02).                       
               10 FILLER               PIC X(01) VALUE ':'.             
               10 WS-PAYMENT-SS        PIC X(02).                       
               10 FILLER               PIC X(01) VALUE ' '.             
               10 WS-PAYMENT-AM-PM     PIC X(02).                       
           05  WS-PAYMENT-TYPE         PIC X(25) VALUE SPACES.          
           05  WS-PAYMENT-RANGE        PIC X(18) VALUE SPACES.          
           05  WS-LAST-DIGIT-ACCT-NO   PIC X(01) VALUE SPACES.          
           05  WS-TRANSACTION-CODE     PIC X(04) VALUE SPACES.          
           05  WS-CONF-PYMT-TYPE       PIC X(01) VALUE SPACES.          
           05  WS-CONF-PYMT-RANGE      PIC X(01) VALUE SPACES.          
           05  WS-CONF-PYMT-DATE.                                       
               10 WS-CONF-PYMT-CC      PIC X(02).                       
               10 WS-CONF-PYMT-YY      PIC X(02).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-CONF-PYMT-MM      PIC X(02) VALUE '01'.            
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-CONF-PYMT-DD      PIC X(02) VALUE '01'.            
           05  WS-RECEIPT-NUMBER.                                       
               10 WS-CHECK-FREE-RCPT.                                   
                  15 WS-A-DAY-OF-YEAR  PIC X(03).                       
                  15 WS-A-PAYMT-RANGE  PIC X(01).                       
                  15 WS-A-ACCT-NUMBER  PIC X(01).                       
                  15 WS-A-TRAN-NUMBER  PIC X(04).                       
                  15 WS-A-PAYMT-TYPE   PIC X(01).                       
                  15 WS-A-PAYMT-YEAR   PIC X(02).                       
                  15 FILLER            PIC X(03).                       
               10 WS-BILL-MATRIX-RCPT  REDEFINES WS-CHECK-FREE-RCPT.    
                  15 WS-B-DAY-OF-YEAR  PIC X(03).                       
                  15 WS-B-PAYMT-RANGE  PIC X(01).                       
                  15 WS-B-ACCT-NUMBER  PIC X(01).                       
                  15 WS-B-PAYMT-TYPE   PIC X(01).                       
                  15 FILLER            PIC X(09).                       
               10 WS-E-PAY-RCPT        REDEFINES WS-CHECK-FREE-RCPT.    
                  15 WS-P-DAY-OF-YEAR  PIC X(03).                       
                  15 WS-P-PAYMT-RANGE  PIC X(01).                       
                  15 WS-P-PAYMT-TSTMP  PIC X(05).                       
                  15 WS-P-PAYMT-TYPE   PIC X(01).                       
                  15 WS-P-PAYMT-YEAR   PIC X(02).                       
                  15 FILLER            PIC X(03).                       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S1-RETURN-CODE          PIC S9(9) VALUE 0 COMP.          
           05  S1-APPL-RETURN-CODE     PIC S9(9) VALUE 0 COMP.          
           05  S1-VALIDATION-FLAG      PIC X(01) VALUE SPACES.          
           05  S1-PAYMENT-DATE         PIC X(10) VALUE SPACES.          
           05  S1-PAYMENT-TIME         PIC X(11) VALUE SPACES.          
           05  S1-PAYMENT-TYPE         PIC X(25) VALUE SPACES.          
           05  S1-PAYMENT-RANGE        PIC X(18) VALUE SPACES.          
           05  S1-LAST-DIGIT-ACCT-NO   PIC X(01) VALUE SPACES.          
           05  S1-TRANSACTION-CODE     PIC X(04) VALUE SPACES.          
                                                                        
      ******************************************************************        
      *    NO CURSORS USED                                             *        
      ******************************************************************        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                 00000010
       LINKAGE SECTION.                                                 
       01  PARM-RCPT-NO                PIC X(15).                       
       01  PARM-RCPT-TYPE              PIC X(01).                       
      *                                                                         
       PROCEDURE DIVISION  USING PARM-RCPT-NO                           
                                ,PARM-RCPT-TYPE.                        
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04842_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04842_R1
              (                                                        
                 RETURN_CODE                INT                     
                ,APPL_RETURN_CODE           INT                     
                ,VALIDATION_FLAG CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,PAYMENT_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,PAYMENT_TIME CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,PAYMENT_TYPE CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,PAYMENT_RANGE CHAR(18)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,LAST_DIGIT_ACCT_NO CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,TRANSACTION_CODE CHAR(04)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PRCS-ABEND       THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT RETURN_CODE               AS RETURN_CODE          
                     ,APPL_RETURN_CODE          AS APPL_RETURN_CODE     
                     ,LTRIM(RTRIM(VALIDATION_FLAG))    AS 
           VALIDATION_FLAG      
                     ,LTRIM(RTRIM(PAYMENT_DATE))       AS PAYMENT_DATE         
                     ,LTRIM(RTRIM(PAYMENT_TIME))       AS PAYMENT_TIME         
                     ,LTRIM(RTRIM(PAYMENT_TYPE))       AS PAYMENT_TYPE         
                     ,LTRIM(RTRIM(PAYMENT_RANGE))      AS PAYMENT_RANGE        
                     ,LTRIM(RTRIM(LAST_DIGIT_ACCT_NO)) AS 
           LAST_DIGIT_ACCT_NO   
                     ,LTRIM(RTRIM(TRANSACTION_CODE))   AS 
           TRANSACTION_CODE     
               FROM #CSR04842_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT RETURN_CODE               AS RETURN_CODE          00000400
MFA-TR*              ,APPL_RETURN_CODE          AS APPL_RETURN_CODE             
MFA-TR*              ,STRIP(VALIDATION_FLAG)    AS VALIDATION_FLAG              
MFA-TR*              ,STRIP(PAYMENT_DATE)       AS PAYMENT_DATE                 
MFA-TR*              ,STRIP(PAYMENT_TIME)       AS PAYMENT_TIME                 
MFA-TR*              ,STRIP(PAYMENT_TYPE)       AS PAYMENT_TYPE              000
MFA-TR*              ,STRIP(PAYMENT_RANGE)      AS PAYMENT_RANGE             000
MFA-TR*              ,STRIP(LAST_DIGIT_ACCT_NO) AS LAST_DIGIT_ACCT_NO        000
MFA-TR*              ,STRIP(TRANSACTION_CODE)   AS TRANSACTION_CODE          000
MFA-TR*        FROM SESSION.CSR04842_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-RCPT-NO                TO WS-RCPT-NO               
                                               WS-RECEIPT-NUMBER.       
           MOVE PARM-RCPT-TYPE              TO WS-RCPT-TYPE.            
                                                                        
           PERFORM 1100-RECEIPT-VALIDATION     THRU 1100-EXIT.          
                                                                        
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 1100-RECEIPT-VALIDATION                                        *        
      ******************************************************************        
       1100-RECEIPT-VALIDATION.                                         
                                                                        
           PERFORM 1110-VALIDATE-DAY-OF-YEAR   THRU 1110-EXIT.          
                                                                        
           IF VALID-RECEIPT THEN                                        
              PERFORM 1115-VALIDATE-PAYMT-RANGE THRU 1115-EXIT          
           END-IF.                                                      
                                                                        
           IF VALID-RECEIPT THEN                                        
              PERFORM 1120-VALIDATE-LSTDGT-ACCN THRU 1120-EXIT          
           END-IF.                                                      
                                                                        
           IF VALID-RECEIPT THEN                                        
              PERFORM 1125-VALIDATE-TRAN-TSTMP  THRU 1125-EXIT          
           END-IF.                                                      
                                                                        
           IF VALID-RECEIPT THEN                                        
              PERFORM 1130-VALIDATE-TRAN-CODE   THRU 1130-EXIT          
           END-IF.                                                      
                                                                        
           IF VALID-RECEIPT THEN                                        
              PERFORM 1135-VALIDATE-PAYMT-TYPE  THRU 1135-EXIT          
           END-IF.                                                      
                                                                        
           IF VALID-RECEIPT THEN                                        
              PERFORM 1140-VALIDATE-PAYMT-YEAR  THRU 1140-EXIT          
           END-IF.                                                      
                                                                        
           IF VALID-RECEIPT THEN                                        
              MOVE 'Y'                         TO WS-VALIDATION-FLAG    
           ELSE                                                         
              MOVE 'N'                         TO WS-VALIDATION-FLAG    
           END-IF.                                                      
                                                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1110-VALIDATE-DAY-OF-YEAR                                      *        
      ******************************************************************        
       1110-VALIDATE-DAY-OF-YEAR.                                       
                                                                        
           EVALUATE TRUE                                                
             WHEN CHECK-FREE                                            
               MOVE WS-A-DAY-OF-YEAR        TO WS-RCPT-DAY-OF-YEAR      
                                                                        
             WHEN BILL-MATRIX                                           
               MOVE WS-B-DAY-OF-YEAR        TO WS-RCPT-DAY-OF-YEAR      
                                                                        
             WHEN E-PAY                                                 
               MOVE WS-P-DAY-OF-YEAR        TO WS-RCPT-DAY-OF-YEAR      
                                                                        
           END-EVALUATE.                                                
                                                                        
           IF WS-RCPT-DAY-OF-YEAR IS NOT NUMERIC                        
              OR WS-RCPT-DAY-OF-YEAR-N > 366                            
              SET INVALID-RECEIPT           TO TRUE                     
           ELSE                                                         
              SET VALID-RECEIPT             TO TRUE                     
           END-IF.                                                      
      *                                                                         
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1115-VALIDATE-PAYMT-RANGE.                                     *        
      ******************************************************************        
       1115-VALIDATE-PAYMT-RANGE.                                       
                                                                        
           EVALUATE TRUE                                                
             WHEN CHECK-FREE                                            
               MOVE WS-A-PAYMT-RANGE        TO WS-RCPT-PAYMT-RANGE      
                                                                        
             WHEN BILL-MATRIX                                           
               MOVE WS-B-PAYMT-RANGE        TO WS-RCPT-PAYMT-RANGE      
                                                                        
             WHEN E-PAY                                                 
               MOVE WS-P-PAYMT-RANGE        TO WS-RCPT-PAYMT-RANGE      
                                                                        
           END-EVALUATE.                                                
                                                                        
           IF WS-RCPT-PAYMT-RANGE IS NOT NUMERIC OR                     
              WS-RCPT-PAYMT-RANGE-N < 0 OR                              
              WS-RCPT-PAYMT-RANGE-N > 9 THEN                            
              SET INVALID-RECEIPT           TO TRUE                     
           ELSE                                                         
              SET VALID-RECEIPT             TO TRUE                     
           END-IF.                                                      
      *                                                                         
       1115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 1120-VALIDATE-LSTDGT-ACCN.                                     *        
      ******************************************************************        
       1120-VALIDATE-LSTDGT-ACCN.                                       
                                                                        
           EVALUATE TRUE                                                
             WHEN CHECK-FREE                                            
               MOVE WS-A-ACCT-NUMBER        TO WS-RCPT-ACCT-NUMBER      
                                                                        
             WHEN BILL-MATRIX                                           
               MOVE WS-B-ACCT-NUMBER        TO WS-RCPT-ACCT-NUMBER      
                                                                        
           END-EVALUATE.                                                
                                                                        
           IF ( CHECK-FREE OR BILL-MATRIX )                             
              AND WS-RCPT-ACCT-NUMBER = ' '                             
              SET INVALID-RECEIPT           TO TRUE                     
           ELSE                                                         
              SET VALID-RECEIPT             TO TRUE                     
           END-IF.                                                      
      *                                                                         
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1125-VALIDATE-TRAN-TSTMP.                                      *        
      ******************************************************************        
       1125-VALIDATE-TRAN-TSTMP.                                        
                                                                        
           SET VALID-RECEIPT                TO TRUE.                    
                                                                        
           IF E-PAY                                                     
                                                                        
              MOVE WS-P-PAYMT-TSTMP         TO WS-RCPT-PAYMT-TSTMP      
                                                                        
              IF WS-RCPT-PAYMT-TSTMP = ' '                              
                 OR WS-RCPT-PAYMT-TSTMP IS NOT NUMERIC                  
                 OR WS-RCPT-PAYMT-TSTMP-N > 86400                       
                 SET INVALID-RECEIPT        TO TRUE                     
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       1125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 1130-VALIDATE-TRAN-CODE.                                       *        
      ******************************************************************        
       1130-VALIDATE-TRAN-CODE.                                         
                                                                        
           SET VALID-RECEIPT                TO TRUE.                    
                                                                        
           IF CHECK-FREE                                                
                                                                        
              MOVE WS-A-TRAN-NUMBER         TO WS-RCPT-TRAN-NUMBER      
                                                                        
              IF WS-RCPT-TRAN-NUMBER = ' '                              
                 SET INVALID-RECEIPT        TO TRUE                     
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       1130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1135-VALIDATE-PAYMT-TYPE                                       *        
      ******************************************************************        
       1135-VALIDATE-PAYMT-TYPE.                                        
                                                                        
           SET VALID-RECEIPT                TO TRUE.                    
                                                                        
           EVALUATE TRUE                                                
             WHEN CHECK-FREE                                            
               MOVE WS-A-PAYMT-TYPE         TO WS-RCPT-PAYMT-TYPE       
               IF WS-RCPT-PAYMT-TYPE = ' '                              
                  OR WS-RCPT-PAYMT-TYPE IS NOT NUMERIC                  
                  OR ( WS-RCPT-PAYMT-TYPE-N NOT = 1                     
                    AND WS-RCPT-PAYMT-TYPE-N NOT = 2                    
                    AND WS-RCPT-PAYMT-TYPE-N NOT = 3                    
                    AND WS-RCPT-PAYMT-TYPE-N NOT = 4                    
                    AND WS-RCPT-PAYMT-TYPE-N NOT = 7 )                  
                  SET INVALID-RECEIPT       TO TRUE                     
               END-IF                                                   
                                                                        
             WHEN BILL-MATRIX                                           
               MOVE WS-B-PAYMT-TYPE         TO WS-RCPT-PAYMT-TYPE       
               IF WS-RCPT-PAYMT-TYPE = ' '                              
                  OR WS-RCPT-PAYMT-TYPE IS NOT NUMERIC                  
                  OR WS-RCPT-PAYMT-TYPE-N > 8                           
                  OR ( WS-RCPT-PAYMT-TYPE-N > 0                         
                    AND WS-RCPT-PAYMT-TYPE-N < 3 )                      
                  SET INVALID-RECEIPT       TO TRUE                     
               END-IF                                                   
                                                                        
             WHEN E-PAY                                                 
               MOVE WS-P-PAYMT-TYPE         TO WS-RCPT-PAYMT-TYPE       
               IF WS-RCPT-PAYMT-TYPE = ' '                              
                  OR WS-RCPT-PAYMT-TYPE IS NOT NUMERIC                  
                  OR WS-RCPT-PAYMT-TYPE-N NOT = 5                       
                  SET INVALID-RECEIPT       TO TRUE                     
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       1135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1140-VALIDATE-PAYMT-YEAR                                       *        
      ******************************************************************        
       1140-VALIDATE-PAYMT-YEAR.                                        
                                                                        
           SET VALID-RECEIPT                TO TRUE.                    
                                                                        
           EVALUATE TRUE                                                
             WHEN CHECK-FREE                                            
               MOVE WS-A-PAYMT-YEAR         TO WS-RCPT-PAYMT-YY         
               IF WS-RCPT-PAYMT-YY   = ' '                              
                  OR WS-RCPT-PAYMT-YY IS NOT NUMERIC                    
                  SET INVALID-RECEIPT       TO TRUE                     
               END-IF                                                   
                                                                        
             WHEN E-PAY                                                 
               MOVE WS-P-PAYMT-YEAR         TO WS-RCPT-PAYMT-YY         
               IF WS-RCPT-PAYMT-YY   = ' '                              
                  OR WS-RCPT-PAYMT-YY IS NOT NUMERIC                    
                  SET INVALID-RECEIPT       TO TRUE                     
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       1140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-RCPT-ACCT-NUMBER         TO WS-LAST-DIGIT-ACCT-NO.   
           MOVE WS-RCPT-TRAN-NUMBER         TO WS-TRANSACTION-CODE.     
           MOVE WS-RCPT-DAY-OF-YEAR-N       TO WS-DAY-OF-YEAR.          
                                                                        
           PERFORM 2100-PRCS-PAYMT-RANGE       THRU 2100-EXIT.          
           PERFORM 2125-PRCS-PAYMT-TYPE        THRU 2125-EXIT.          
           PERFORM 2130-PRCS-PAYMT-DATE        THRU 2130-EXIT.          
           PERFORM 2135-PRCS-PAYMT-TIME        THRU 2135-EXIT.          
                                                                        
           PERFORM 2200-MOVE-RESULT            THRU 2200-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PRCS-PAYMT-RANGE                                          *        
      ******************************************************************        
       2100-PRCS-PAYMT-RANGE.                                           
                                                                        
           IF CHECK-FREE THEN                                           
                                                                        
              EVALUATE WS-RCPT-PAYMT-RANGE                              
                WHEN '0'                                                
                  MOVE '$0.00 to $24.99'      TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '1'                                                
                  MOVE '$25.00 to $49.99'     TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '2'                                                
                  MOVE '$50.00 to $99.99'     TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '3'                                                
                  MOVE '$100.00 to $199.99'   TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '4'                                                
                  MOVE '$200.00 to $299.99'   TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '5'                                                
                  MOVE '$300.00 to $399.99'   TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '6'                                                
                  MOVE '$400.00 to $499.99'   TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '7'                                                
                  MOVE '$500.00 to $599.99'   TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '8'                                                
                  MOVE '$600.00 to $699.99'   TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '9'                                                
                  MOVE '$700.00 and above'    TO WS-PAYMENT-RANGE       
                                                                        
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
                                                                        
           IF BILL-MATRIX THEN                                          
                                                                        
              EVALUATE WS-RCPT-PAYMT-RANGE                              
                WHEN '0'                                                
                   MOVE '$0.00 to $99.99'     TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '1'                                                
                   MOVE '$100.00 to $199.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '2'                                                
                   MOVE '$200.00 to $299.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '3'                                                
                   MOVE '$300.00 to $399.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '4'                                                
                   MOVE '$400.00 to $499.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '5'                                                
                   MOVE '$500.00 to $599.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '6'                                                
                   MOVE '$600.00 to $699.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '7'                                                
                   MOVE '$700.00 to $799.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '8'                                                
                   MOVE '$800.00 to $899.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '9'                                                
                   MOVE '$900.00 and above'   TO WS-PAYMENT-RANGE       
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
                                                                        
           IF E-PAY THEN                                                
                                                                        
              EVALUATE WS-RCPT-PAYMT-RANGE                              
                WHEN '0'                                                
                  MOVE '$0.00 to $24.99'      TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '1'                                                
                  MOVE '$25.00 to $49.99'     TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '2'                                                
                  MOVE '$50.00 to $99.99'     TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '3'                                                
                   MOVE '$100.00 to $199.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '4'                                                
                   MOVE '$200.00 to $299.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '5'                                                
                   MOVE '$300.00 to $399.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '6'                                                
                   MOVE '$400.00 to $499.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '7'                                                
                   MOVE '$500.00 to $599.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '8'                                                
                   MOVE '$600.00 to $699.99'  TO WS-PAYMENT-RANGE       
                                                                        
                WHEN '9'                                                
                   MOVE '$700.00 and above'   TO WS-PAYMENT-RANGE       
                                                                        
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2125-PRCS-PAYMT-TYPE                                           *        
      ******************************************************************        
       2125-PRCS-PAYMT-TYPE.                                            
                                                                        
           IF CHECK-FREE THEN                                           
                                                                        
              EVALUATE WS-RCPT-PAYMT-TYPE                               
                WHEN '1'                                                
                  MOVE 'Cash'              TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '2'                                                
                  MOVE 'Check'             TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '3'                                                
                  MOVE 'Multiple'          TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '4'                                                
                  MOVE 'Money Order'       TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '7'                                                
                  MOVE 'Check to Electronic Debit'                      
                                           TO WS-PAYMENT-TYPE           
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
           IF BILL-MATRIX THEN                                          
                                                                        
              EVALUATE WS-RCPT-PAYMT-TYPE                               
                WHEN '0'                                                
                   MOVE 'Debit/ATM'        TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '3'                                                
                   MOVE 'AMEX'             TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '4'                                                
                   MOVE 'Visa'             TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '5'                                                
                   MOVE 'MasterCard'       TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '6'                                                
                   MOVE 'Discover'         TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '7'                                                
                   MOVE 'Check'            TO WS-PAYMENT-TYPE           
                                                                        
                WHEN '8'                                                
                   MOVE 'Third Party'      TO WS-PAYMENT-TYPE           
                                                                        
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
                                                                        
           IF E-PAY THEN                                                
                                                                        
              EVALUATE WS-RCPT-PAYMT-TYPE                               
                WHEN '8'                                                
                   MOVE 'E Pay'            TO WS-PAYMENT-TYPE           
                                                                        
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
                                                                        
      *                                                                         
       2125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2130-PRCS-PAYMT-DATE                                           *        
      ******************************************************************        
       2130-PRCS-PAYMT-DATE.                                            
                                                                        
           MOVE WS-CURRENT-DATE            TO WS-DATE.                  
           MOVE '01'                       TO WS-DATE-MM                
                                              WS-DATE-DD.               
                                                                        
           IF CHECK-FREE                                                
              OR E-PAY   THEN                                           
                                                                        
              MOVE WS-DATE-CC              TO WS-CONF-PYMT-CC           
              MOVE WS-RCPT-PAYMT-YY        TO WS-CONF-PYMT-YY           
           END-IF.                                                      
                                                                        
           IF BILL-MATRIX THEN                                          
                                                                        
              MOVE WS-DATE-CC              TO WS-CONF-PYMT-CC           
              MOVE WS-DATE-YY              TO WS-CONF-PYMT-YY           
           END-IF.                                                      
                                                                        
           MOVE WS-CONF-PYMT-DATE          TO WS-PAYMENT-DATE.          
                                                                        
           PERFORM 7100-GET-PAYMENT-DATE      THRU 7100-EXIT.           
                                                                        
      *                                                                         
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2135-PRCS-PAYMT-TIME                                           *        
      ******************************************************************        
       2135-PRCS-PAYMT-TIME.                                            
                                                                        
                                                                        
           IF E-PAY THEN                                                
              MOVE WS-RCPT-PAYMT-TSTMP-N    TO WS-PAYMNT-SECONDS        
                                                                        
              PERFORM 7200-GET-PAYMENT-TIME    THRU 7200-EXIT           
                                                                        
              MOVE WS-PAYMNT-HH             TO WS-PAYMENT-HH            
              MOVE WS-PAYMNT-MM             TO WS-PAYMENT-MM            
              MOVE WS-PAYMNT-SS             TO WS-PAYMENT-SS            
                                                                        
              IF WS-PAYMNT-24HR > 11 THEN                               
                 MOVE 'PM'                  TO WS-PAYMENT-AM-PM         
              ELSE                                                      
                 MOVE 'AM'                  TO WS-PAYMENT-AM-PM         
              END-IF                                                    
           ELSE                                                         
                                                                        
              MOVE SPACES                   TO WS-PAYMENT-TIME          
           END-IF.                                                      
                                                                        
                                                                        
      *                                                                         
       2135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-MOVE-RESULT.                                        *              
      ******************************************************************        
       2200-MOVE-RESULT.                                                
                                                                        
           MOVE WS-VALIDATION-FLAG          TO S1-VALIDATION-FLAG.      
                                                                        
           IF INVALID-RECEIPT                                           
              MOVE SPACES                   TO S1-PAYMENT-DATE          
                                               S1-PAYMENT-TIME          
                                               S1-PAYMENT-TYPE          
                                               S1-PAYMENT-RANGE         
                                               S1-LAST-DIGIT-ACCT-NO    
                                               S1-TRANSACTION-CODE      
           ELSE                                                         
                                                                        
              MOVE WS-PAYMENT-DATE          TO S1-PAYMENT-DATE          
              MOVE WS-PAYMENT-TIME          TO S1-PAYMENT-TIME          
              MOVE WS-PAYMENT-TYPE          TO S1-PAYMENT-TYPE          
              MOVE WS-PAYMENT-RANGE         TO S1-PAYMENT-RANGE         
              MOVE WS-LAST-DIGIT-ACCT-NO    TO S1-LAST-DIGIT-ACCT-NO    
              MOVE WS-TRANSACTION-CODE      TO S1-TRANSACTION-CODE      
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PRCS-ABEND          THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-PAYMENT-DATE                                          *        
      ******************************************************************        
       7100-GET-PAYMENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, (:WS-DAY-OF-YEAR - 1 ), 
              IIF(TRY_CONVERT(DATE, :WS-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PAYMENT-DATE
              ) <> 0) OR (LEN(:WS-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PAYMENT-DATE
              ), CONVERT(DATE, :WS-PAYMENT-DATE) ) )
            INTO
              :WS-PAYMENT-DATE      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PAYMENT-DATE = DATE(:WS-PAYMENT-DATE)                     
MFA-TR*                              + (:WS-DAY-OF-YEAR - 1 ) DAYS              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PRCS-ABEND          THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-PAYMENT-TIME                                          *        
      ******************************************************************        
       7200-GET-PAYMENT-TIME.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              SUBSTRING(REPLACE(CONVERT(CHAR(8), DATEADD( SECOND, 
                                                   :WS-PAYMNT-SECONDS, 
           CIS.CHAR2TIME('00:00:00') ), 108), ':', '.'), 1, 2),
              SUBSTRING(CIS.CHAR2$TIME( DATEADD( SECOND, 
                                                   :WS-PAYMNT-SECONDS, 
           CIS.CHAR2TIME('00:00:00') ), 'USA' ), 1, 2),
              SUBSTRING(REPLACE(CONVERT(CHAR(8), DATEADD( SECOND, 
                                                   :WS-PAYMNT-SECONDS, 
           CIS.CHAR2TIME('00:00:00') ), 108), ':', '.'), 4, 2),
              SUBSTRING(REPLACE(CONVERT(CHAR(8), DATEADD( SECOND, 
                                                   :WS-PAYMNT-SECONDS, 
           CIS.CHAR2TIME('00:00:00') ), 108), ':', '.'), 7, 2)
            INTO
              :WS-PAYMNT-24HR,
              :WS-PAYMNT-HH,
              :WS-PAYMNT-MM,
              :WS-PAYMNT-SS        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PAYMNT-24HR = SUBSTR( CHAR( TIME('00:00:00')              
MFA-TR*                    + :WS-PAYMNT-SECONDS SECONDS ), 1, 2)                
MFA-TR*          ,:WS-PAYMNT-HH = SUBSTR( CHAR( TIME('00:00:00')                
MFA-TR*                 + :WS-PAYMNT-SECONDS SECONDS, USA ), 1, 2)              
MFA-TR*          ,:WS-PAYMNT-MM = SUBSTR( CHAR( TIME('00:00:00')                
MFA-TR*                    + :WS-PAYMNT-SECONDS SECONDS ), 4, 2)                
MFA-TR*          ,:WS-PAYMNT-SS = SUBSTR( CHAR( TIME('00:00:00')                
MFA-TR*                    + :WS-PAYMNT-SECONDS SECONDS ), 7, 2)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PRCS-ABEND          THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04842_R1                           
                (                                                       
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,VALIDATION_FLAG                                      
                  ,PAYMENT_DATE                                         
                  ,PAYMENT_TIME                                         
                  ,PAYMENT_TYPE                                         
                  ,PAYMENT_RANGE                                        
                  ,LAST_DIGIT_ACCT_NO                                   
                  ,TRANSACTION_CODE                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S1-RETURN-CODE                                      
                  ,:S1-APPL-RETURN-CODE                                 
                  ,:S1-VALIDATION-FLAG                                  
                  ,:S1-PAYMENT-DATE                                     
                  ,:S1-PAYMENT-TIME                                     
                  ,:S1-PAYMENT-TYPE                                     
                  ,:S1-PAYMENT-RANGE                                    
                  ,:S1-LAST-DIGIT-ACCT-NO                               
                  ,:S1-TRANSACTION-CODE                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04842_R1                                   
MFA-TR*         (                                                               
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,VALIDATION_FLAG                                              
MFA-TR*           ,PAYMENT_DATE                                                 
MFA-TR*           ,PAYMENT_TIME                                                 
MFA-TR*           ,PAYMENT_TYPE                                                 
MFA-TR*           ,PAYMENT_RANGE                                                
MFA-TR*           ,LAST_DIGIT_ACCT_NO                                           
MFA-TR*           ,TRANSACTION_CODE                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S1-RETURN-CODE                                              
MFA-TR*           ,:S1-APPL-RETURN-CODE                                         
MFA-TR*           ,:S1-VALIDATION-FLAG                                          
MFA-TR*           ,:S1-PAYMENT-DATE                                             
MFA-TR*           ,:S1-PAYMENT-TIME                                             
MFA-TR*           ,:S1-PAYMENT-TYPE                                             
MFA-TR*           ,:S1-PAYMENT-RANGE                                            
MFA-TR*           ,:S1-LAST-DIGIT-ACCT-NO                                       
MFA-TR*           ,:S1-TRANSACTION-CODE                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS                
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04842_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PRCS-ABEND          THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04842_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04842_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04842_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PRCS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9700-PRCS-ABEND.                                               *        
      ******************************************************************        
       9700-PRCS-ABEND.                                                 
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
                                                                        
