       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04841.                                         
COB303 DATE-WRITTEN.  JANUARY 22, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM MOVES DATA FROM THE CUSTOMER TO THE NEWLY        *00200000
      *  CREATED ACCOUNT. DATA MOVED INCLUDES ROOMMATE, COAPPLICANT,   *00200000
      *  DBA NAME, DBA TAX ID, WEBSITE ADDRESS, AND CONTACTS.          *00200000
      *  STATUS CODE VALUES:                                           *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/22/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04841'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00970000
              INCLUDE TBUSRPRF                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBCUST                                            00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBNAME                                            00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01170000
              INCLUDE TBNMACTX                                          01180000
           END-EXEC.                                                    01190000
           EXEC SQL                                                     01340000
              INCLUDE TBACCT                                            01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCUSXFR                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBROOMT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCOAPP                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBATMISC                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCSTMSC                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBATBLNM                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-NUM    
                                        PIC X(10).                      
           05  WS-NEW-NAME-ID           PIC 9(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04841'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-TA-EXISTS-FL          PIC X(01) VALUE SPACES.         
           05  WS-MISC-INFO-MOVE-FL     PIC X(01) VALUE SPACES.         
           05  WS-UPDATE-CT             PIC S9(04) COMP VALUE ZERO.     
           05  WS-COMMIT-CT             PIC S9(04) COMP VALUE ZERO.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
              DECLARE CUSTX-CURSOR CURSOR WITH HOLD FOR                 
               SELECT DISTINCT ACCOUNT_NO                               
                 FROM CSS_CUSTOMER_XFER EK WITH(READUNCOMMITTED),               
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE EK.ASSOC_CUSTOMER_NO = AT.CUSTOMER_NO             
                                                                 
               FOR READ ONLY                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUSTX-CURSOR CURSOR WITH HOLD FOR                         
MFA-TR*        SELECT DISTINCT ACCOUNT_NO                                       
MFA-TR*          FROM CSS_CUSTOMER_XFER EK,                                     
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE EK.ASSOC_CUSTOMER_NO = AT.CUSTOMER_NO                     
MFA-TR*        WITH UR                                                          
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE CONTX-CURSOR CURSOR WITH HOLD FOR                 
               SELECT DISTINCT ACCOUNT_NO                               
                 FROM CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE CONTACT_XFER_FL = 'Y'                             
                  AND CV.CONTACT_ID = DT.CONTACT_ID                     
                  AND DT.CUSTOMER_NO = AT.CUSTOMER_NO                   
                                                                 
               FOR READ ONLY                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTX-CURSOR CURSOR WITH HOLD FOR                         
MFA-TR*        SELECT DISTINCT ACCOUNT_NO                                       
MFA-TR*          FROM CSS_CONTACT CV,                                           
MFA-TR*               CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE CONTACT_XFER_FL = 'Y'                                     
MFA-TR*           AND CV.CONTACT_ID = DT.CONTACT_ID                             
MFA-TR*           AND DT.CUSTOMER_NO = AT.CUSTOMER_NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE MISCX-CURSOR CURSOR WITH HOLD FOR                 
               SELECT ACCOUNT_NO                                        
                 FROM CSS_CUST_MISC_INFO LQ WITH(READUNCOMMITTED),              
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE (DBA_NAME > ' '                                   
                   OR  DBA_TAX_ID > ' '                                 
                   OR  WEBSITE_ADDR > ' ')                              
                  AND LQ.CUSTOMER_NO = AT.CUSTOMER_NO                   
                                                                 
               FOR READ ONLY                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MISCX-CURSOR CURSOR WITH HOLD FOR                         
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          FROM CSS_CUST_MISC_INFO LQ,                                    
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE (DBA_NAME > ' '                                           
MFA-TR*            OR  DBA_TAX_ID > ' '                                         
MFA-TR*            OR  WEBSITE_ADDR > ' ')                                      
MFA-TR*           AND LQ.CUSTOMER_NO = AT.CUSTOMER_NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE XFER-CURSOR CURSOR FOR                            
               SELECT EK.CUSTOMER_NO,                                   
                      RELATION_TYPE_CD,                                 
                      ACCESS_LEVEL_CD,                                  
                      NAME_ID                                           
                 FROM CSS_CUSTOMER_XFER EK WITH(READUNCOMMITTED),               
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO         
                  AND EK.CUSTOMER_NO = CU.CUSTOMER_NO                   
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE XFER-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT EK.CUSTOMER_NO,                                           
MFA-TR*               RELATION_TYPE_CD,                                         
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               NAME_ID                                                   
MFA-TR*          FROM CSS_CUSTOMER_XFER EK,                                     
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO                 
MFA-TR*           AND EK.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE CONTACT-CURSOR CURSOR FOR                         
               SELECT DT.CONTACT_ID,                                    
                      CONTACT_TYPE                                      
                 FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
                      CSS_CONTACT CV WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                     
                  AND DT.CONTACT_ID = CV.CONTACT_ID                     
                  AND CONTACT_XFER_FL = 'Y'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT DT.CONTACT_ID,                                            
MFA-TR*               CONTACT_TYPE                                              
MFA-TR*          FROM CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_CONTACT CV                                            
MFA-TR*         WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                             
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CONTACT_XFER_FL = 'Y'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 0500-DRIVER-ROUTINE THRU 0500-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0500-DRIVER-ROUTINE.                                             
                                                                        
           PERFORM 7070-OPEN-CUSTX-CURSOR THRU 7070-EXIT.               
           PERFORM 0501-FETCH-ROWS THRU 0501-EXIT.                      
           PERFORM 7071-CLOSE-CUSTX-CURSOR THRU 7071-EXIT.              
                                                                        
           PERFORM 7080-OPEN-CONTX-CURSOR THRU 7080-EXIT.               
           PERFORM 0502-FETCH-ROWS THRU 0502-EXIT.                      
           PERFORM 7081-CLOSE-CONTX-CURSOR THRU 7081-EXIT.              
                                                                        
           PERFORM 7090-OPEN-MISCX-CURSOR THRU 7090-EXIT.               
           PERFORM 0503-FETCH-ROWS THRU 0503-EXIT.                      
           PERFORM 7091-CLOSE-MISCX-CURSOR THRU 7091-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0501-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CUSTX-CURSOR                                       
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 0501-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '0501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER_XFER' TO TABLE-1                  
                   MOVE 'CSS_ACCOUNT'    TO TABLE-2                     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           ADD +1 TO WS-UPDATE-CT                                       
                     WS-COMMIT-CT.                                      
           IF WS-COMMIT-CT > 250                                        
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-CT
           END-IF.                                  
                                                                        
           GO TO 0501-FETCH-ROWS.                                       
                                                                        
       0501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0502-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CONTX-CURSOR                                       
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 0502-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '0502'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT'    TO TABLE-1                     
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-2                   
                   MOVE 'CSS_ACCOUNT'    TO TABLE-3                     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           ADD +1 TO WS-UPDATE-CT                                       
                     WS-COMMIT-CT.                                      
           IF WS-COMMIT-CT > 250                                        
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-CT
           END-IF.                                  
                                                                        
           GO TO 0502-FETCH-ROWS.                                       
                                                                        
       0502-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0503-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MISCX-CURSOR                                       
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 0503-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '0503'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           ADD +1 TO WS-UPDATE-CT                                       
                     WS-COMMIT-CT.                                      
           IF WS-COMMIT-CT > 250                                        
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-CT
           END-IF.                                  
                                                                        
           GO TO 0503-FETCH-ROWS.                                       
                                                                        
       0503-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE '293'                    TO MH-RESP-AREA-ID.            
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE 'ZS15485'                TO MH-USER-ID.                 
           MOVE 'PCSSO061'               TO MH-APPL-PROGRAM-ID.         
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-CUSTOMER-NO TO EK-ASSOC-CUSTOMER-NO                  
                                  LQ-CUSTOMER-NO                        
                                  DT-CUSTOMER-NO.                       
           PERFORM 7010-OPEN-XFER-CURSOR THRU 7010-EXIT.                
           PERFORM 2010-FETCH-ROWS THRU 2010-EXIT.                      
           PERFORM 7020-CLOSE-XFER-CURSOR THRU 7020-EXIT.               
           PERFORM 8090-DELETE-CUST-XFER THRU 8090-EXIT.                
                                                                        
           PERFORM 7120-OPEN-CONTACT-CURSOR THRU 7120-EXIT.             
           PERFORM 2040-FETCH-ROWS THRU 2040-EXIT.                      
           PERFORM 7130-CLOSE-CONTACT-CURSOR THRU 7130-EXIT.            
                                                                        
           PERFORM 7100-SELECT-CUST-MISC THRU 7100-EXIT.                
           MOVE SPACES TO WS-MISC-INFO-MOVE-FL.                         
           IF LQ-DBA-NAME > SPACES                                      
               MOVE 'Y' TO WS-MISC-INFO-MOVE-FL                         
               PERFORM 2100-DBA-NAME THRU 2100-EXIT
           END-IF.                    
           IF LQ-DBA-TAX-ID > SPACES OR                                 
              LQ-WEBSITE-ADDR > SPACES                                  
                  MOVE 'Y' TO WS-MISC-INFO-MOVE-FL                      
                  PERFORM 2200-MISC-TRANS-HIST THRU 2200-EXIT           
                  PERFORM 7110-SELECT-ACCT-MISC THRU 7110-EXIT          
                  IF WS-TA-EXISTS-FL = 'Y'                              
                      PERFORM 8000-UPDATE-ACCT-MISC THRU 8000-EXIT      
                  ELSE                                                  
                      PERFORM 8010-INSERT-ACCT-MISC THRU 8010-EXIT
                  END-IF
           END-IF.     
                                                                        
           IF WS-MISC-INFO-MOVE-FL = 'Y'                                
               PERFORM 8040-UPDATE-CUST-MISC-INFO THRU 8040-EXIT        
               PERFORM 8050-DELETE-NULL-MISC THRU 8050-EXIT
           END-IF.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH XFER-CURSOR                                        
                INTO :EK-CUSTOMER-NO,                                   
                     :EK-RELATION-TYPE-CD,                              
                     :EK-ACCESS-LEVEL-CD,                               
                     :CU-NAME-ID                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER_XFER' TO TABLE-1                  
                   MOVE 'CSS_CUSTOMER'   TO TABLE-2                     
                   MOVE 'ASSOC_CUSTOMER_NO' TO TABLE-ELEMENT-1          
                   MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
           EVALUATE EK-RELATION-TYPE-CD                                 
               WHEN 'RO'                                                
                   INITIALIZE DCLCSS-ROOMMATE                           
                   MOVE AT-ACCOUNT-NO TO RO-ACCOUNT-NO                  
                   MOVE EK-CUSTOMER-NO TO RO-CUSTOMER-NO                
                   MOVE EK-ACCESS-LEVEL-CD TO RO-ACCESS-LEVEL-CD        
                   PERFORM 8200-INSERT-ROOMMATE THRU 8200-EXIT          
                   PERFORM 2020-XFER-TRANSHIST THRU 2020-EXIT           
                   PERFORM 2030-BUILD-HT THRU 2030-EXIT                 
               WHEN 'CO'                                                
                   INITIALIZE DCLCSS-COAPPLICANT                        
                   MOVE AT-ACCOUNT-NO TO IC-ACCOUNT-NO                  
                   MOVE EK-CUSTOMER-NO TO IC-CUSTOMER-NO                
                   MOVE EK-ACCESS-LEVEL-CD TO IC-ACCESS-LEVEL-CD        
                   MOVE WS-CURRENT-DATE TO IC-CREATED-DATE              
                   PERFORM 8210-INSERT-COAPP THRU 8210-EXIT             
                   PERFORM 2020-XFER-TRANSHIST THRU 2020-EXIT           
                   PERFORM 2030-BUILD-HT THRU 2030-EXIT                 
           END-EVALUATE.                                                
                                                                        
           GO TO 2010-FETCH-ROWS.                                       
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2020-XFER-TRANSHIST.                                             
                                                                        
           MOVE EK-ASSOC-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM.             
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           EVALUATE EK-RELATION-TYPE-CD                                 
               WHEN 'RO'                                                
                   MOVE 'ROOMMATE XFER' TO MI-COLUMN-DESC               
               WHEN 'CO'                                                
                   MOVE 'COAPP XFER' TO MI-COLUMN-DESC                  
           END-EVALUATE.                                                
           MOVE 10                 TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE WS-CUSTOMER-NO-NUM TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE 13                 TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE AT-ACCOUNT-NO      TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2030-BUILD-HT.                                                   
                                                                        
           INITIALIZE DCLCSS-NAME-ACCT-XREF.                            
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE AT-COMPANY-NO TO HT-COMPANY-NO.                         
           MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           MOVE AT-PREMISE-NO TO HT-PREMISE-NO.                         
           MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE.           
           MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT.                 
           MOVE CU-NAME-ID TO HT-NAME-ID.                               
           EVALUATE EK-RELATION-TYPE-CD                                 
               WHEN 'RO'                                                
                   MOVE 'A' TO HT-CUSTOMER-ROLE-CD                      
               WHEN 'CO'                                                
                   MOVE 'B' TO HT-CUSTOMER-ROLE-CD                      
           END-EVALUATE.                                                
           PERFORM 7030-SELECT-ADDRESS THRU 7030-EXIT.                  
           PERFORM 8220-INSERT-NAME-XREF THRU 8220-EXIT.                
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2040-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CONTACT-CURSOR                                     
                INTO :DT-CONTACT-ID,                                    
                     :CV-CONTACT-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2040-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'    TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE DT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
           PERFORM 8230-INSERT-CONTACT-ACCT THRU 8230-EXIT.             
           PERFORM 8240-DELETE-CONTACT-CUST THRU 8240-EXIT.             
           PERFORM 8250-UPDATE-CONTACT THRU 8250-EXIT.                  
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE DT-CUSTOMER-NO       TO WS-CUSTOMER-NO-NUM.             
           MOVE 'CONTACT XFER'       TO MI-COLUMN-DESC(1:12).           
           MOVE ' '                  TO MI-COLUMN-DESC(13:1).           
           MOVE CV-CONTACT-TYPE      TO MI-COLUMN-DESC(14:2).           
           MOVE 10                   TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE WS-CUSTOMER-NO-NUM   TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE 13                   TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE AT-ACCOUNT-NO        TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
           GO TO 2040-FETCH-ROWS.                                       
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-DBA-NAME.                                                   
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
           MOVE WS-91-NEW-NAME-ID TO WS-NEW-NAME-ID.                    
                                                                        
           INITIALIZE DCLCSS-NAME.                                      
           MOVE WS-NEW-NAME-ID           TO DQ-NAME-ID.                 
           MOVE 'DB'                     TO DQ-NAME-TYPE.               
           MOVE 'B'                      TO DQ-NAME-FORMAT.             
           MOVE LQ-DBA-NAME              TO DQ-FULL-NAME.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           PERFORM 8030-INSERT-NAME THRU 8030-EXIT.                     
                                                                        
           INITIALIZE DCLCSS-NAME-ACCT-XREF.                            
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE AT-COMPANY-NO TO HT-COMPANY-NO.                         
           MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           MOVE AT-PREMISE-NO TO HT-PREMISE-NO.                         
           MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE.           
           MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT.                 
           MOVE DQ-NAME-ID TO HT-NAME-ID.                               
           MOVE SPACES TO HT-CUSTOMER-ROLE-CD.                          
           PERFORM 7030-SELECT-ADDRESS THRU 7030-EXIT.                  
           PERFORM 8220-INSERT-NAME-XREF THRU 8220-EXIT.                
                                                                        
           MOVE WS-NEW-NAME-ID TO AB-NAME-ID.                           
           PERFORM 8020-INSERT-ACCT-NAME THRU 8020-EXIT.                
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE LQ-CUSTOMER-NO       TO WS-CUSTOMER-NO-NUM.             
           MOVE 'DBA XFER'           TO MI-COLUMN-DESC.                 
           MOVE 10                   TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE WS-CUSTOMER-NO-NUM   TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE 13                   TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE AT-ACCOUNT-NO        TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-MISC-TRANS-HIST.                                            
                                                                        
           IF LQ-DBA-TAX-ID > SPACES                                    
               MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO        
               MOVE LQ-CUSTOMER-NO   TO WS-CUSTOMER-NO-NUM              
               MOVE 'TAX ID XFER'    TO MI-COLUMN-DESC                  
               MOVE 10               TO MI-PRV-COLUMN-VALUE-LEN         
               MOVE WS-CUSTOMER-NO-NUM TO MI-PRV-COLUMN-VALUE-TEXT      
               MOVE 13               TO MI-CHG-COLUMN-VALUE-LEN         
               MOVE AT-ACCOUNT-NO    TO MI-CHG-COLUMN-VALUE-TEXT        
               MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD +1              TO WS-TRAN-APPL-NO
           END-IF.                  
           IF LQ-WEBSITE-ADDR > SPACES                                  
               MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO        
               MOVE LQ-CUSTOMER-NO   TO WS-CUSTOMER-NO-NUM              
               MOVE 'WEBSITE ADDR'   TO MI-COLUMN-DESC                  
               MOVE 10               TO MI-PRV-COLUMN-VALUE-LEN         
               MOVE WS-CUSTOMER-NO-NUM TO MI-PRV-COLUMN-VALUE-TEXT      
               MOVE 13               TO MI-CHG-COLUMN-VALUE-LEN         
               MOVE AT-ACCOUNT-NO    TO MI-CHG-COLUMN-VALUE-TEXT        
               MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD +1              TO WS-TRAN-APPL-NO
           END-IF.                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,                                      
                      COMPANY_NO,                                       
                      PREMISE_NO,                                       
                      ACCOUNT_TYPE_CODE,                                
                      CODE_ACCT_STAT                                    
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-COMPANY-NO,                                   
                      :AT-PREMISE-NO,                                   
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-CODE-ACCT-STAT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               CODE_ACCT_STAT                                            
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-XFER-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN XFER-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER_XFER' TO TABLE-1                  
                   MOVE 'CSS_CUSTOMER'   TO TABLE-2                     
                   MOVE 'ASSOC_CUSTOMER_NO' TO TABLE-ELEMENT-1          
                   MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-XFER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE XFER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER_XFER' TO TABLE-1                  
                   MOVE 'CSS_CUSTOMER'   TO TABLE-2                     
                   MOVE 'ASSOC_CUSTOMER_NO' TO TABLE-ELEMENT-1          
                   MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT ADDRESS_ID,                              
                      TOWN,                                             
                      STATE,                                            
                      LOCAL_OFFICE                                      
                 INTO :HT-ADDRESS-ID,                                   
                      :HT-TOWN,                                         
                      :HT-STATE,                                        
                      :HT-LOCAL-OFFICE                                  
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND HT.NAME_ID  = DQ.NAME_ID                          
                  AND DQ.NAME_TYPE = 'CN'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT ADDRESS_ID,                                      
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE,                                                    
MFA-TR*               LOCAL_OFFICE                                              
MFA-TR*          INTO :HT-ADDRESS-ID,                                           
MFA-TR*               :HT-TOWN,                                                 
MFA-TR*               :HT-STATE,                                                
MFA-TR*               :HT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND HT.NAME_ID  = DQ.NAME_ID                                  
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-OPEN-CUSTX-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN CUSTX-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER_XFER' TO TABLE-1                  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7071-CLOSE-CUSTX-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE CUSTX-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7071'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER_XFER' TO TABLE-1                  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7071-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-OPEN-CONTX-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN CONTX-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7080'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT'    TO TABLE-1                     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7081-CLOSE-CONTX-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE CONTX-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7081'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT'    TO TABLE-1                     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7081-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-OPEN-MISCX-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN MISCX-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7091-CLOSE-MISCX-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE MISCX-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7091'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7091-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-CUST-MISC.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DBA_NAME,
              DBA_TAX_ID,
              WEBSITE_ADDR                                      
                 INTO :LQ-DBA-NAME,                                     
                      :LQ-DBA-TAX-ID,                                   
                      :LQ-WEBSITE-ADDR                                  
                 FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DBA_NAME,                                                 
MFA-TR*               DBA_TAX_ID,                                               
MFA-TR*               WEBSITE_ADDR                                              
MFA-TR*          INTO :LQ-DBA-NAME,                                             
MFA-TR*               :LQ-DBA-TAX-ID,                                           
MFA-TR*               :LQ-WEBSITE-ADDR                                          
MFA-TR*          FROM CSS_CUST_MISC_INFO                                        
MFA-TR*         WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-CUST-MISC-INFO                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE LQ-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-ACCT-MISC.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :TA-ACCOUNT-NO                                    
                 FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :TA-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCT_MISC_INFO                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-TA-EXISTS-FL                          
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-TA-EXISTS-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-OPEN-CONTACT-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN CONTACT-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'    TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE DT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-CLOSE-CONTACT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE CONTACT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'    TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE DT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-UPDATE-ACCT-MISC.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_MISC_INFO                                 
                 SET DBA_TAX_ID = :LQ-DBA-TAX-ID,                       
                     WEBSITE_ADDR = :LQ-WEBSITE-ADDR                    
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_MISC_INFO                                         
MFA-TR*          SET DBA_TAX_ID = :LQ-DBA-TAX-ID,                               
MFA-TR*              WEBSITE_ADDR = :LQ-WEBSITE-ADDR                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-ACCT-MISC.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MISC_INFO                            
                      (ACCOUNT_NO,                                      
                       DBA_TAX_ID,                                      
                       WEBSITE_ADDR)                                    
              VALUES  (:AT-ACCOUNT-NO,                                  
                       :LQ-DBA-TAX-ID,                                  
                       :LQ-WEBSITE-ADDR)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-ACCT-NAME.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_BILL_NMES                            
                      (ACCOUNT_NO,                                      
                       NAME_TYPE,                                       
                       NAME_ID)                                         
              VALUES  (:AT-ACCOUNT-NO,                                  
                       'DB',                                            
                       :AB-NAME-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8040-UPDATE-CUST-MISC-INFO.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_MISC_INFO                                 
                 SET DBA_TAX_ID = ' ',                                  
                     WEBSITE_ADDR = ' ',                                
                     DBA_NAME = ' '                                     
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_MISC_INFO                                         
MFA-TR*          SET DBA_TAX_ID = ' ',                                          
MFA-TR*              WEBSITE_ADDR = ' ',                                        
MFA-TR*              DBA_NAME = ' '                                             
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8040'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-DELETE-NULL-MISC.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_MISC_INFO                            
               WHERE CUSTOMER_NO        =  :AT-CUSTOMER-NO              
                 AND INFLUENTIAL_CUST   =  ' '                          
                 AND KEY_CUSTOMER       =  ' '                          
                 AND SPECIAL_CUST       =  ' '                          
                 AND CONSULTING_PROJECT =  ' '                          
                 AND CONSLT_PRJ_END_DT  IS NULL                         
                 AND LOSS_RESERVE_CD    =  0                            
                 AND LOSS_RESRVE_EFF_DT IS NULL                         
                 AND IVR_NDO_EXEMPT     = 'N'                           
                 AND BUILDER_FL         = 'N'                           
                 AND REALTOR_FL         = 'N'                           
                 AND LANDLORD_FL        = 'N'                           
                 AND DBA_NAME           = ' '                           
                 AND DBA_TAX_ID         = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND INTR_CO_IND        = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_MISC_INFO                                    
MFA-TR*        WHERE CUSTOMER_NO        =  :AT-CUSTOMER-NO                      
MFA-TR*          AND INFLUENTIAL_CUST   =  ' '                                  
MFA-TR*          AND KEY_CUSTOMER       =  ' '                                  
MFA-TR*          AND SPECIAL_CUST       =  ' '                                  
MFA-TR*          AND CONSULTING_PROJECT =  ' '                                  
MFA-TR*          AND CONSLT_PRJ_END_DT  IS NULL                                 
MFA-TR*          AND LOSS_RESERVE_CD    =  0                                    
MFA-TR*          AND LOSS_RESRVE_EFF_DT IS NULL                                 
MFA-TR*          AND IVR_NDO_EXEMPT     = 'N'                                   
MFA-TR*          AND BUILDER_FL         = 'N'                                   
MFA-TR*          AND REALTOR_FL         = 'N'                                   
MFA-TR*          AND LANDLORD_FL        = 'N'                                   
MFA-TR*          AND DBA_NAME           = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND INTR_CO_IND        = ' '                                   
MFA-TR*       QUERYNO 8050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8090-DELETE-CUST-XFER.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUSTOMER_XFER                             
               WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUSTOMER_XFER                                     
MFA-TR*        WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO                  
MFA-TR*       QUERYNO 8090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8090'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER_XFER'  TO TABLE-1                      
              MOVE 'ASSOC_CUSTOMER_NO'  TO TABLE-ELEMENT-1              
              MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-1            
              MOVE 'ASSOC_CUSTOMER_NO'  TO TABLE-ELEMENT-2              
              MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
       8200-INSERT-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ROOMMATE                                  
                      (ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       ACCESS_LEVEL_CD)                                 
              VALUES  (:RO-ACCOUNT-NO,                                  
                       :RO-CUSTOMER-NO,                                 
                       :RO-ACCESS-LEVEL-CD)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ROOMMATE'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE RO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RO-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-INSERT-COAPP.                                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_COAPPLICANT                               
                      (ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       CREATED_DATE,                                    
                       ACCESS_LEVEL_CD)                                 
              VALUES  (:IC-ACCOUNT-NO,                                  
                       :IC-CUSTOMER-NO,                                 
                       IIF(TRY_CONVERT(DATE, :IC-CREATED-DATE
              ) IS NULL OR (PATINDEX('%.%', :IC-CREATED-DATE
              ) <> 0) OR (LEN(:IC-CREATED-DATE) <> 10), CIS.CHAR2DATE(
                                                       :IC-CREATED-DATE
              ), CONVERT(DATE, :IC-CREATED-DATE) ),                            
                       :IC-ACCESS-LEVEL-CD)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COAPPLICANT                                       
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                CREATED_DATE,                                            
MFA-TR*                ACCESS_LEVEL_CD)                                         
MFA-TR*       VALUES  (:IC-ACCOUNT-NO,                                          
MFA-TR*                :IC-CUSTOMER-NO,                                         
MFA-TR*                :IC-CREATED-DATE,                                        
MFA-TR*                :IC-ACCESS-LEVEL-CD)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_COAPPLICANT'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE IC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE IC-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8220-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CUSTOMER_ROLE_CD,                                  
                     TOWN,                                              
                     STATE,                                             
                     LOCAL_OFFICE,                                      
                     ACCOUNT_TYPE_CODE,                                 
                     CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CUSTOMER-ROLE-CD,                               
                    :HT-TOWN,                                           
                    :HT-STATE,                                          
                    :HT-LOCAL-OFFICE,                                   
                    :HT-ACCOUNT-TYPE-CODE,                              
                    :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8220'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8230-INSERT-CONTACT-ACCT.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_ACCT                              
                   ( ACCOUNT_NO,                                        
                     CONTACT_ID )                                       
              VALUES                                                    
                   (:AT-ACCOUNT-NO,                                     
                    :DT-CONTACT-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8230'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-2              
              MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8240-DELETE-CONTACT-CUST.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_CUST                              
               WHERE CONTACT_ID = :DT-CONTACT-ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8240'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8250-UPDATE-CONTACT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT                                        
                 SET CONTACT_XFER_FL = ' '                              
               WHERE CONTACT_ID = :DT-CONTACT-ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8250'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT'        TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
