       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04840.                                         
COB303 DATE-WRITTEN.  APRIL 25, 2015.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM CREATES A NON-UTILITY OR LIGHTING ACCOUNT.       *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  04/25/15   FMB       NEW PROGRAM.                             *00290000
A05317*  01/26/16   FMB       POPULATE TRANSACTION COMMENTS.           *00290000
D11732*  07/12/16   SC        DO NOT CREATE NON-MTRD ACCT ON FB ACCT   *00290000
      *                       OR A PENDING ACCT                        *        
A05317*  12/27/16   FMB       POPULATE HT FIELDS ON INSERT.            *00290000
A05317*  01/17/17   FMB       INSERT CREDIT PROFILE FOR LIGHTING.      *00290000
A05317*  02/13/17   FMB       DEFAULT LIGHTING BILL CYCLE TO 01.       *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04840'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00770000
              INCLUDE TBACCT                                            00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBCUST                                            00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBPREM                                            00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBCSTPRM                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBCSTSTS                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBPREMLN                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBNMACTX                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBADRFMT                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBZIPCD                                           00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     01170000
              INCLUDE TBMNHIST                                          01180000
           END-EXEC.                                                    01190000
           EXEC SQL                                                     01210000
              INCLUDE TBMNHDT                                           01220000
           END-EXEC.                                                    01230000
           EXEC SQL                                                     01210000
              INCLUDE TBUSRPRF                                          01220000
           END-EXEC.                                                    01230000
           EXEC SQL                                                     01210000
              INCLUDE TBATCNTL                                          01220000
           END-EXEC.                                                    01230000
           EXEC SQL                                                     01210000
              INCLUDE TBCRPROF                                          01220000
           END-EXEC.                                                    01230000
           EXEC SQL                                                     01210000
              INCLUDE TBDELQ                                            01220000
           END-EXEC.                                                    01230000
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWS0126A                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04840'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-6                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-7                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-HT-UPDATED-FL         PIC X(01) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) COMP.                
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) COMP.                
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) COMP.                
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) COMP.                
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-ACCOUNT-FL          PIC X(01).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO                              
                          LINK-PREMISE-NO                               
                          LINK-ACCOUNT-FL                               
                          LINK-USERID                                   
                          LINK-COMMENTS.                                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE,                  
                       :RS-ACCOUNT-NO AS ACCOUNT_NO                     
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE,                          
MFA-TR*                :RS-ACCOUNT-NO AS ACCOUNT_NO                             
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
                                                                        
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7100-DELINQUENCY THRU 7100-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE CU-CUSTOMER-NO           TO MH-CUSTOMER-NO.             
           MOVE PR-PREMISE-NO            TO MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL085'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7040-SELECT-PREMISE THRU 7040-EXIT.                  
           PERFORM 7050-SELECT-CUSTOMER THRU 7050-EXIT.                 
           PERFORM 7060-SELECT-SPOUSE THRU 7060-EXIT.                   
                                                                        
           EVALUATE LINK-ACCOUNT-FL                                     
               WHEN 'N'                                                 
                   PERFORM 2100-NON-UTILITY-CHECKS THRU 2100-EXIT       
               WHEN 'L'                                                 
                   PERFORM 2200-LIGHTING-CHECKS THRU 2200-EXIT          
           END-EVALUATE.                                                
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 3000-CREATE-ACCOUNT THRU 3000-EXIT
           END-IF.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-NON-UTILITY-CHECKS.                                         
                                                                        
           PERFORM 7000-NON-UTIL-CHECK THRU 7000-EXIT.                  
           IF AT-ACCOUNT-NO > 0                                         
               MOVE +1 TO RS-STATUS-CODE                                
           ELSE                                                         
               PERFORM 7010-UTILITY-CHECK THRU 7010-EXIT                
               IF AT-ACCOUNT-NO > 0                                     
                   MOVE +2 TO RS-STATUS-CODE                            
               ELSE                                                     
                   PERFORM 7020-GAS-LINE-CHECK THRU 7020-EXIT           
                   IF Y0-SERVICE-NO > 0                                 
                       MOVE +3 TO RS-STATUS-CODE
                   END-IF
               END-IF
           END-IF.                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-LIGHTING-CHECKS.                                            
                                                                        
           PERFORM 7030-ACCT-CHECK THRU 7030-EXIT.                      
           IF AT-ACCOUNT-NO > 0                                         
               MOVE +4 TO RS-STATUS-CODE
           END-IF.                               
           PERFORM 7035-ACTIVE-NONUTIL-CHECK  THRU 7035-EXIT.           
           IF AT-ACCOUNT-NO > 0                                         
               MOVE +5 TO RS-STATUS-CODE
           END-IF.                               
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-CREATE-ACCOUNT.                                             
                                                                        
           MOVE WS-CURRENT-DATE TO WS-126-CURRENT-DATE.                 
           MOVE WS-CURRENT-TIMESTAMP TO WS-126-CURRENT-TIMESTAMP.       
           MOVE 'PANEL085 ' TO WS-126-PANEL-NO.                         
           MOVE LINK-USERID TO WS-126-USERID.                           
A05317     MOVE WS-COMMENTS-LEN TO WS-126-TRANS-COMMENTS-LEN.           
A05317     MOVE WS-COMMENTS-TEXT TO WS-126-TRANS-COMMENTS.              
                                                                        
           PERFORM 6102-GET-NEW-ACCOUNT-NO THRU 6102-EXIT.              
           MOVE WS-126-NEW-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM.             
           MOVE WS-ACCOUNT-NO-CHAR TO RS-ACCOUNT-NO.                    
                                                                        
           INITIALIZE DCLCSS-ACCOUNT.                                   
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE CU-CUSTOMER-NO TO AT-CUSTOMER-NO.                       
           MOVE PR-PREMISE-NO TO AT-PREMISE-NO.                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :AT-DATE-BILL-DAY-00           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AT-DATE-BILL-DAY-00 = CURRENT DATE - 1 DAY                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ) )
            INTO
              :AT-DATE-BILL-DAY-30
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AT-DATE-BILL-DAY-30 = CURRENT DATE - 1 MONTHS - 1 DAY        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, DATEADD( MONTH, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ) )
            INTO
              :AT-DATE-BILL-DAY-60
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AT-DATE-BILL-DAY-60 = CURRENT DATE - 2 MONTHS - 1 DAY        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, DATEADD( MONTH, -3, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ) )
            INTO
              :AT-DATE-BILL-DAY-90
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AT-DATE-BILL-DAY-90 = CURRENT DATE - 3 MONTHS - 1 DAY        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 'A' TO AT-CODE-COMPANY-ACCT                             
                       AT-CODE-PERM-BILL                                
                       AT-CODE-TEMP-BILL.                               
           MOVE PR-LOCAL-OFFICE TO AT-LOCAL-OFFICE.                     
           MOVE WS-CURRENT-DATE TO AT-DATE-LAST-ACTION.                 
           MOVE PR-COMPANY-NO TO AT-COMPANY-NO.                         
           MOVE WS-CURRENT-TIMESTAMP TO AT-ACCT-CREATE-DT               
                                        AT-ACCOUNT-INIT-TS              
                                        AT-LAST-UPDATE-TS.              
           MOVE 'U' TO AT-CREDIT-STATUS-CODE.                           
           MOVE 'M01' TO AT-CODE-BILL-FREQ.                             
           MOVE +1 TO AT-NO-BILL-COPIES.                                
A05317     MOVE '01' TO AT-BILL-CYCLE.                                  
                                                                        
           EVALUATE LINK-ACCOUNT-FL                                     
               WHEN 'N'                                                 
                   MOVE 'D' TO AT-CREDIT-GROUP                          
                   MOVE 'C' TO AT-CODE-P-BILL-DEST                      
                   MOVE 'A' TO AT-CODE-STATUS-REASON                    
                               AT-CODE-ACCT-STAT                        
                   MOVE 'N' TO AT-ACCOUNT-TYPE-CODE                     
                               AT-CODE-REPRINT-BILL                     
                               AT-CODE-MAJOR-ACCT                       
                               AT-BILL-HIST-XFER-IND                    
                               AT-CT-METER-RATED-IND                    
                               AT-BHV-EXEMPT-CD                         
                   MOVE 25 TO AT-NO-MO-ONLINE-HIST                      
                              AT-NO-MO-BILL-HIST                        
                   MOVE '1' TO AT-PRINT-TYPE-CD                         
               WHEN 'L'                                                 
                   MOVE 'N' TO AT-CREDIT-GROUP                          
                   MOVE 'P' TO AT-CODE-ACCT-STAT                        
                   MOVE 'R' TO AT-ACCOUNT-TYPE-CODE                     
           END-EVALUATE.                                                
           PERFORM 8000-INSERT-ACCOUNT THRU 8000-EXIT.                  
                                                                        
           IF LINK-ACCOUNT-FL = 'N'                                     
               INITIALIZE DCLCSS-CUST-PREM-HIST                         
               MOVE AT-ACCOUNT-NO TO CH-ACCOUNT-NO                      
               MOVE AT-CUSTOMER-NO TO CH-CUSTOMER-NO                    
               MOVE AT-PREMISE-NO TO CH-PREMISE-NO                      
               MOVE WS-CURRENT-DATE TO CH-DATE-UTIL-SVC-STRT            
               PERFORM 8010-INSERT-CUST-PREM-HIST THRU 8010-EXIT
           END-IF.       
                                                                        
A05317     MOVE AT-ACCOUNT-NO TO CZ-ACCOUNT-NO                          
A05317     PERFORM 8050-INSERT-CREDIT-PROFILE THRU 8050-EXIT.           
                                                                        
           INITIALIZE DCLCSS-NAME-ACCT-XREF.                            
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE AT-PREMISE-NO TO HT-PREMISE-NO.                         
           MOVE PR-COMPANY-NO TO HT-COMPANY-NO.                         
           MOVE PR-ADDRESS-ID TO HT-ADDRESS-ID.                         
           MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           MOVE CU-NAME-ID TO HT-NAME-ID.                               
           MOVE A4-TOWN TO HT-TOWN.                                     
           MOVE A4-STATE TO HT-STATE.                                   
           MOVE PR-LOCAL-OFFICE TO HT-LOCAL-OFFICE.                     
           EVALUATE LINK-ACCOUNT-FL                                     
               WHEN 'N'                                                 
                   MOVE 'A' TO HT-CODE-ACCT-STAT                        
                   MOVE 'N' TO HT-ACCOUNT-TYPE-CODE                     
               WHEN 'L'                                                 
                   MOVE 'P' TO HT-CODE-ACCT-STAT                        
                   MOVE 'R' TO HT-ACCOUNT-TYPE-CODE                     
           END-EVALUATE.                                                
                                                                        
           PERFORM 8040-DELETE-NAME-ACCT-XREF THRU 8040-EXIT.           
                                                                        
           PERFORM 8030-UPDATE-NAME-ACCT-XREF THRU 8030-EXIT.           
           EVALUATE WS-HT-UPDATED-FL                                    
               WHEN 'Y'                                                 
                   IF CE-NAME-ID > ZEROES                               
                       MOVE CE-NAME-ID TO HT-NAME-ID                    
                       PERFORM 8030-UPDATE-NAME-ACCT-XREF THRU 8030-EXIT
                   END-IF                                               
               WHEN 'N'                                                 
                   PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT         
                   IF CE-NAME-ID > ZEROES                               
                       MOVE CE-NAME-ID TO HT-NAME-ID                    
                       PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT     
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-NON-UTIL-CHECK.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND CODE_ACCT_STAT = 'A'                               
                 AND ACCOUNT_TYPE_CODE = 'N'                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND CODE_ACCT_STAT = 'A'                                       
MFA-TR*          AND ACCOUNT_TYPE_CODE = 'N'                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  AT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CODE_ACCT_STAT' TO TABLE-ELEMENT-2             
                   MOVE 'A'              TO HOSTVAR-ELEMENT-2           
                   MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-3          
                   MOVE 'N'              TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-UTILITY-CHECK.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_NAME_ACCT_XREF WITH(READUNCOMMITTED)                   
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ACCOUNT_TYPE_CODE <> 'N'                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_NAME_ACCT_XREF                                         
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_TYPE_CODE ^= 'N'                                   
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  AT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-2          
                   MOVE '^N'             TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-GAS-LINE-CHECK.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SERVICE_NO                                         
                INTO :Y0-SERVICE-NO                                     
                FROM CSS_PREM_GAS_LINE WITH(READUNCOMMITTED)                    
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERVICE_NO                                                 
MFA-TR*         INTO :Y0-SERVICE-NO                                             
MFA-TR*         FROM CSS_PREM_GAS_LINE                                          
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  Y0-SERVICE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_PREM_GAS_LINE' TO TABLE-1                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-ACCT-CHECK.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ACCOUNT_TYPE_CODE <> 'N'                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_TYPE_CODE ^= 'N'                                   
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  AT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-2          
                   MOVE '^N'              TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7035-ACTIVE-NONUTIL-CHECK.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ACCOUNT_TYPE_CODE = 'N'                            
                 AND CODE_ACCT_STAT = 'A'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_TYPE_CODE = 'N'                                    
MFA-TR*          AND CODE_ACCT_STAT = 'A'                                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7035                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  AT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7035'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CODE_ACCT_STAT' TO TABLE-ELEMENT-2             
                   MOVE 'A'              TO HOSTVAR-ELEMENT-2           
                   MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-3          
                   MOVE 'N'              TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7040-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE,
              COMPANY_NO,
              PR.ADDRESS_ID,
              TOWN,
              STATE                                              
                INTO :PR-LOCAL-OFFICE,                                  
                     :PR-COMPANY-NO,                                    
                     :PR-ADDRESS-ID,                                    
                     :A4-TOWN,                                          
                     :A4-STATE                                          
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND PR.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              PR.ADDRESS_ID,                                             
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE                                                      
MFA-TR*         INTO :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-COMPANY-NO,                                            
MFA-TR*              :PR-ADDRESS-ID,                                            
MFA-TR*              :A4-TOWN,                                                  
MFA-TR*              :A4-STATE                                                  
MFA-TR*         FROM CSS_PREMISE PR,                                            
MFA-TR*              CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND PR.ADDRESS_ID = DY.ADDRESS_ID                              
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-SPOUSE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
                INTO :CE-NAME-ID                                        
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE = 'S'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CE-NAME-ID                                                
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO CE-NAME-ID                            
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID,
              LOCAL_OFFICE                                       
                INTO :PF-RESP-AREA-ID,                                  
                     :PF-LOCAL-OFFICE                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID,                                              
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :PF-RESP-AREA-ID,                                          
MFA-TR*              :PF-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7100'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-ACCOUNT.                                             
                                                                        
           MOVE -1 TO WS-NULL-1                                         
                      WS-NULL-2                                         
                      WS-NULL-3                                         
                      WS-NULL-4                                         
                      WS-NULL-5.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCOUNT                                   
                     (ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      BILL_CYCLE,                                       
                      CODE_ACCT_STAT,                                   
                      CODE_STATUS_REASON,                               
                      ACCOUNT_TYPE_CODE,                                
                      DATE_BILL_DAY_00,                                 
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      TOTAL_AR_BALANCE,                                 
                      CODE_CRIT_OUTAGE,                                 
                      CODE_MAJOR_ACCT,                                  
                      CODE_REPRINT_BILL,                                
                      CODE_COMPANY_ACCT,                                
                      CODE_LPC_XMT,                                     
                      CODE_BILL_FREQ,                                   
                      CODE_PERM_BILL,                                   
                      CODE_P_BILL_DEST,                                 
                      CODE_TEMP_BILL,                                   
                      NOTICE_EXEMPT_CD,                                 
                      NO_BILL_COPIES,                                   
                      CODE_GROUP_ACCT,                                  
                      NO_MO_ONLINE_HIST,                                
                      CODE_ACCT_BILLED,                                 
                      CODE_BILL_PEND,                                   
                      DATE_EARLY_PAY,                                   
                      LOCAL_OFFICE,                                     
                      PREMISE_NO,                                       
                      DATE_LAST_ACTION,                                 
                      CODE_DISC_OK,                                     
                      DATE_CRNT_BIL_DLNQ,                               
                      ACCT_XFER_TO,                                     
                      ACCT_XFER_FROM_LST,                               
                      BILL_HIST_XFER_IND,                               
                      AR_XFER_IND,                                      
                      CODES_DATA_PRESENT,                               
                      DATE_REV_CHG_AUTH,                                
                      WORK_Q_PEND,                                      
                      MARKETING_PEND,                                   
                      EARLY_PAY_REASON,                                 
                      COMPANY_NO,                                       
                      CREDIT_GROUP,                                     
                      BANKRUPTCY_IND,                                   
                      MST_SUB_ACCT_IND,                                 
                      PRINT_TYPE_CD,                                    
                      CUST_PREM_REL,                                    
                      ACCT_CREATE_DT,                                   
                      ACCT_FINALED_DT,                                  
                      DISCON_REASON_CD,                                 
                      BILL_CYCLE_CHG_CD,                                
                      MST_OVRRD_BLL_IND,                                
                      CODE_PRNT_BLL_MST,                                
                      NO_MO_BILL_HIST,                                  
                      NXT_BILL_NO,                                      
                      LAST_NRML_BILL_NO,                                
                      NXT_SMRY_BILL_NO,                                 
                      NXT_SMRY_REBILL_NO,                               
                      BNKRPT_CASE_NO,                                   
                      CODE_ACCT_USAGE,                                  
                      ADDRESS_ID,                                       
                      ADDRESS_FORMAT,                                   
                      REDUCTN_FXDFCT_IND,                               
                      CANREB_CODE_00_DAY,                               
                      CANREB_CODE_30_DAY,                               
                      CANREB_CODE_60_DAY,                               
                      CANREB_CODE_90_DAY,                               
                      CUST_RQST_RD_DT_CD,                               
                      LAST_UPDATE_TS,                                   
                      CREDIT_STATUS_CODE,                               
                      LAST_PYMT_DATE,                                   
                      LAST_PYMT_AMOUNT,                                 
                      CT_METER_RATED_IND,                               
                      IVR_EXEMPT_CD,                                    
                      BHV_EXEMPT_CD,                                    
                      ACCOUNT_INIT_TS)                                  
              VALUES                                                    
                     (:AT-ACCOUNT-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-BILL-CYCLE,                                   
                      :AT-CODE-ACCT-STAT,                               
                      :AT-CODE-STATUS-REASON,                           
                      :AT-ACCOUNT-TYPE-CODE,                            
                      IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) ),                        
                      IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-30
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30) ),                        
                      IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-60
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60) ),                        
                      IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-90
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90) ),                        
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-CODE-CRIT-OUTAGE,                             
                      :AT-CODE-MAJOR-ACCT,                              
                      :AT-CODE-REPRINT-BILL,                            
                      :AT-CODE-COMPANY-ACCT,                            
                      :AT-CODE-LPC-XMT,                                 
                      :AT-CODE-BILL-FREQ,                               
                      :AT-CODE-PERM-BILL,                               
                      :AT-CODE-P-BILL-DEST,                             
                      :AT-CODE-TEMP-BILL,                               
                      :AT-NOTICE-EXEMPT-CD,                             
                      :AT-NO-BILL-COPIES,                               
                      :AT-CODE-GROUP-ACCT,                              
                      :AT-NO-MO-ONLINE-HIST,                            
                      :AT-CODE-ACCT-BILLED,                             
                      :AT-CODE-BILL-PEND,                               
                      IIF(TRY_CONVERT(DATE, :AT-DATE-EARLY-PAY 
                                            :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-EARLY-PAY 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:AT-DATE-EARLY-PAY :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-EARLY-PAY :WS-NULL-1
              ), CONVERT(DATE, :AT-DATE-EARLY-PAY :WS-NULL-1) ),               
                      :AT-LOCAL-OFFICE,                                 
                      :AT-PREMISE-NO,                                   
                      IIF(TRY_CONVERT(DATE, :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),                        
                      :AT-CODE-DISC-OK,                                 
                      IIF(TRY_CONVERT(DATE, :AT-DATE-CRNT-BIL-DLNQ 
                                            :WS-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-CRNT-BIL-DLNQ 
                                                             :WS-NULL-2
              ) <> 0) OR (LEN(:AT-DATE-CRNT-BIL-DLNQ :WS-NULL-2
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-CRNT-BIL-DLNQ :WS-NULL-2
              ), CONVERT(DATE, :AT-DATE-CRNT-BIL-DLNQ :WS-NULL-2) ),           
                      :AT-ACCT-XFER-TO,                                 
                      :AT-ACCT-XFER-FROM-LST,                           
                      :AT-BILL-HIST-XFER-IND,                           
                      :AT-AR-XFER-IND,                                  
                      :AT-CODES-DATA-PRESENT,                           
                      IIF(TRY_CONVERT(DATE, :AT-DATE-REV-CHG-AUTH 
                                            :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-REV-CHG-AUTH 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:AT-DATE-REV-CHG-AUTH :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-REV-CHG-AUTH :WS-NULL-3
              ), CONVERT(DATE, :AT-DATE-REV-CHG-AUTH :WS-NULL-3) ),            
                      :AT-WORK-Q-PEND,                                  
                      :AT-MARKETING-PEND,                               
                      :AT-EARLY-PAY-REASON,                             
                      :AT-COMPANY-NO,                                   
                      :AT-CREDIT-GROUP,                                 
                      :AT-BANKRUPTCY-IND,                               
                      :AT-MST-SUB-ACCT-IND,                             
                      :AT-PRINT-TYPE-CD,                                
                      :AT-CUST-PREM-REL,                                
                      CIS.CHAR2TIMESTAMP(:AT-ACCT-CREATE-DT),                   
                      CIS.CHAR2TIMESTAMP(:AT-ACCT-FINALED-DT :WS-NULL-4
              ),                    
                      :AT-DISCON-REASON-CD,                             
                      :AT-BILL-CYCLE-CHG-CD,                            
                      :AT-MST-OVRRD-BLL-IND,                            
                      :AT-CODE-PRNT-BLL-MST,                            
                      :AT-NO-MO-BILL-HIST,                              
                      :AT-NXT-BILL-NO,                                  
                      :AT-LAST-NRML-BILL-NO,                            
                      :AT-NXT-SMRY-BILL-NO,                             
                      :AT-NXT-SMRY-REBILL-NO,                           
                      :AT-BNKRPT-CASE-NO,                               
                      :AT-CODE-ACCT-USAGE,                              
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
                      :AT-REDUCTN-FXDFCT-IND,                           
                      :AT-CANREB-CODE-00-DAY,                           
                      :AT-CANREB-CODE-30-DAY,                           
                      :AT-CANREB-CODE-60-DAY,                           
                      :AT-CANREB-CODE-90-DAY,                           
                      :AT-CUST-RQST-RD-DT-CD,                           
                      CIS.CHAR2TIMESTAMP(:AT-LAST-UPDATE-TS),                   
                      :AT-CREDIT-STATUS-CODE,                           
                      IIF(TRY_CONVERT(DATE, :AT-LAST-PYMT-DATE 
                                            :WS-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :AT-LAST-PYMT-DATE 
                                                             :WS-NULL-5
              ) <> 0) OR (LEN(:AT-LAST-PYMT-DATE :WS-NULL-5
              ) <> 10), CIS.CHAR2DATE(:AT-LAST-PYMT-DATE :WS-NULL-5
              ), CONVERT(DATE, :AT-LAST-PYMT-DATE :WS-NULL-5) ),               
                      :AT-LAST-PYMT-AMOUNT,                             
                      :AT-CT-METER-RATED-IND,                           
                      :AT-IVR-EXEMPT-CD,                                
                      :AT-BHV-EXEMPT-CD,                                
                      CIS.CHAR2TIMESTAMP(:AT-ACCOUNT-INIT-TS))                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     28220000
MFA-TR*       INSERT INTO CSS_ACCOUNT                                   28230000
MFA-TR*              (ACCOUNT_NO,                                       28240000
MFA-TR*               CUSTOMER_NO,                                      28250000
MFA-TR*               BILL_CYCLE,                                       28260000
MFA-TR*               CODE_ACCT_STAT,                                   28270000
MFA-TR*               CODE_STATUS_REASON,                               28280000
MFA-TR*               ACCOUNT_TYPE_CODE,                                28290000
MFA-TR*               DATE_BILL_DAY_00,                                 28300000
MFA-TR*               DATE_BILL_DAY_30,                                 28310000
MFA-TR*               DATE_BILL_DAY_60,                                 28320000
MFA-TR*               DATE_BILL_DAY_90,                                 28330000
MFA-TR*               TOTAL_AR_BALANCE,                                 28340000
MFA-TR*               CODE_CRIT_OUTAGE,                                 28350000
MFA-TR*               CODE_MAJOR_ACCT,                                  28360000
MFA-TR*               CODE_REPRINT_BILL,                                28370000
MFA-TR*               CODE_COMPANY_ACCT,                                28380000
MFA-TR*               CODE_LPC_XMT,                                     28390000
MFA-TR*               CODE_BILL_FREQ,                                   28400000
MFA-TR*               CODE_PERM_BILL,                                   28410000
MFA-TR*               CODE_P_BILL_DEST,                                 28420000
MFA-TR*               CODE_TEMP_BILL,                                   28430000
MFA-TR*               NOTICE_EXEMPT_CD,                                 28440000
MFA-TR*               NO_BILL_COPIES,                                   28450000
MFA-TR*               CODE_GROUP_ACCT,                                  28460000
MFA-TR*               NO_MO_ONLINE_HIST,                                28470000
MFA-TR*               CODE_ACCT_BILLED,                                 28480000
MFA-TR*               CODE_BILL_PEND,                                   28481000
MFA-TR*               DATE_EARLY_PAY,                                   28490000
MFA-TR*               LOCAL_OFFICE,                                     28500000
MFA-TR*               PREMISE_NO,                                       28510000
MFA-TR*               DATE_LAST_ACTION,                                 28520000
MFA-TR*               CODE_DISC_OK,                                     28530000
MFA-TR*               DATE_CRNT_BIL_DLNQ,                               28540000
MFA-TR*               ACCT_XFER_TO,                                     28550000
MFA-TR*               ACCT_XFER_FROM_LST,                               28560000
MFA-TR*               BILL_HIST_XFER_IND,                               28570000
MFA-TR*               AR_XFER_IND,                                      28580000
MFA-TR*               CODES_DATA_PRESENT,                               28590000
MFA-TR*               DATE_REV_CHG_AUTH,                                28600000
MFA-TR*               WORK_Q_PEND,                                      28610000
MFA-TR*               MARKETING_PEND,                                   28620000
MFA-TR*               EARLY_PAY_REASON,                                 28630000
MFA-TR*               COMPANY_NO,                                       28640000
MFA-TR*               CREDIT_GROUP,                                     28650000
MFA-TR*               BANKRUPTCY_IND,                                   28660000
MFA-TR*               MST_SUB_ACCT_IND,                                 28670000
MFA-TR*               PRINT_TYPE_CD,                                    28680000
MFA-TR*               CUST_PREM_REL,                                    28690000
MFA-TR*               ACCT_CREATE_DT,                                   28700000
MFA-TR*               ACCT_FINALED_DT,                                  28710000
MFA-TR*               DISCON_REASON_CD,                                 28720000
MFA-TR*               BILL_CYCLE_CHG_CD,                                28730000
MFA-TR*               MST_OVRRD_BLL_IND,                                28740000
MFA-TR*               CODE_PRNT_BLL_MST,                                28750000
MFA-TR*               NO_MO_BILL_HIST,                                  28760000
MFA-TR*               NXT_BILL_NO,                                      28770000
MFA-TR*               LAST_NRML_BILL_NO,                                28780000
MFA-TR*               NXT_SMRY_BILL_NO,                                 28790000
MFA-TR*               NXT_SMRY_REBILL_NO,                               28800000
MFA-TR*               BNKRPT_CASE_NO,                                   28810000
MFA-TR*               CODE_ACCT_USAGE,                                  28820000
MFA-TR*               ADDRESS_ID,                                       28830000
MFA-TR*               ADDRESS_FORMAT,                                   28840000
MFA-TR*               REDUCTN_FXDFCT_IND,                               28850000
MFA-TR*               CANREB_CODE_00_DAY,                               28860000
MFA-TR*               CANREB_CODE_30_DAY,                               28870000
MFA-TR*               CANREB_CODE_60_DAY,                               28880000
MFA-TR*               CANREB_CODE_90_DAY,                               28890000
MFA-TR*               CUST_RQST_RD_DT_CD,                               28910000
MFA-TR*               LAST_UPDATE_TS,                                   28920000
MFA-TR*               CREDIT_STATUS_CODE,                               28930000
MFA-TR*               LAST_PYMT_DATE,                                   28940000
MFA-TR*               LAST_PYMT_AMOUNT,                                 28950000
MFA-TR*               CT_METER_RATED_IND,                               28960000
MFA-TR*               IVR_EXEMPT_CD,                                            
MFA-TR*               BHV_EXEMPT_CD,                                            
MFA-TR*               ACCOUNT_INIT_TS)                                          
MFA-TR*       VALUES                                                    28970000
MFA-TR*              (:AT-ACCOUNT-NO,                                   28980000
MFA-TR*               :AT-CUSTOMER-NO,                                  28990000
MFA-TR*               :AT-BILL-CYCLE,                                   29000000
MFA-TR*               :AT-CODE-ACCT-STAT,                               29010000
MFA-TR*               :AT-CODE-STATUS-REASON,                           29020000
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                            29030000
MFA-TR*               :AT-DATE-BILL-DAY-00,                             29040000
MFA-TR*               :AT-DATE-BILL-DAY-30,                             29050000
MFA-TR*               :AT-DATE-BILL-DAY-60,                             29060000
MFA-TR*               :AT-DATE-BILL-DAY-90,                             29070000
MFA-TR*               :AT-TOTAL-AR-BALANCE,                             29080000
MFA-TR*               :AT-CODE-CRIT-OUTAGE,                             29090000
MFA-TR*               :AT-CODE-MAJOR-ACCT,                              29100000
MFA-TR*               :AT-CODE-REPRINT-BILL,                            29110000
MFA-TR*               :AT-CODE-COMPANY-ACCT,                            29120000
MFA-TR*               :AT-CODE-LPC-XMT,                                 29130000
MFA-TR*               :AT-CODE-BILL-FREQ,                               29140000
MFA-TR*               :AT-CODE-PERM-BILL,                               29150000
MFA-TR*               :AT-CODE-P-BILL-DEST,                             29160000
MFA-TR*               :AT-CODE-TEMP-BILL,                               29170000
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                             29180000
MFA-TR*               :AT-NO-BILL-COPIES,                               29190000
MFA-TR*               :AT-CODE-GROUP-ACCT,                              29200000
MFA-TR*               :AT-NO-MO-ONLINE-HIST,                            29210000
MFA-TR*               :AT-CODE-ACCT-BILLED,                             29220000
MFA-TR*               :AT-CODE-BILL-PEND,                               29221000
MFA-TR*               :AT-DATE-EARLY-PAY:WS-NULL-1,                     29230000
MFA-TR*               :AT-LOCAL-OFFICE,                                 29240000
MFA-TR*               :AT-PREMISE-NO,                                   29250000
MFA-TR*               :AT-DATE-LAST-ACTION,                             29260000
MFA-TR*               :AT-CODE-DISC-OK,                                 29270000
MFA-TR*               :AT-DATE-CRNT-BIL-DLNQ:WS-NULL-2,                 29280000
MFA-TR*               :AT-ACCT-XFER-TO,                                 29290000
MFA-TR*               :AT-ACCT-XFER-FROM-LST,                           29300000
MFA-TR*               :AT-BILL-HIST-XFER-IND,                           29310000
MFA-TR*               :AT-AR-XFER-IND,                                  29320000
MFA-TR*               :AT-CODES-DATA-PRESENT,                           29330000
MFA-TR*               :AT-DATE-REV-CHG-AUTH:WS-NULL-3,                  29340000
MFA-TR*               :AT-WORK-Q-PEND,                                  29350000
MFA-TR*               :AT-MARKETING-PEND,                               29360000
MFA-TR*               :AT-EARLY-PAY-REASON,                             29370000
MFA-TR*               :AT-COMPANY-NO,                                   29380000
MFA-TR*               :AT-CREDIT-GROUP,                                 29390000
MFA-TR*               :AT-BANKRUPTCY-IND,                               29400000
MFA-TR*               :AT-MST-SUB-ACCT-IND,                             29410000
MFA-TR*               :AT-PRINT-TYPE-CD,                                29420000
MFA-TR*               :AT-CUST-PREM-REL,                                29430000
MFA-TR*               :AT-ACCT-CREATE-DT,                               29440000
MFA-TR*               :AT-ACCT-FINALED-DT:WS-NULL-4,                    29450000
MFA-TR*               :AT-DISCON-REASON-CD,                             29460000
MFA-TR*               :AT-BILL-CYCLE-CHG-CD,                            29470000
MFA-TR*               :AT-MST-OVRRD-BLL-IND,                            29480000
MFA-TR*               :AT-CODE-PRNT-BLL-MST,                            29490000
MFA-TR*               :AT-NO-MO-BILL-HIST,                              29500000
MFA-TR*               :AT-NXT-BILL-NO,                                  29510000
MFA-TR*               :AT-LAST-NRML-BILL-NO,                            29520000
MFA-TR*               :AT-NXT-SMRY-BILL-NO,                             29530000
MFA-TR*               :AT-NXT-SMRY-REBILL-NO,                           29540000
MFA-TR*               :AT-BNKRPT-CASE-NO,                               29550000
MFA-TR*               :AT-CODE-ACCT-USAGE,                              29560000
MFA-TR*               :AT-ADDRESS-ID,                                   29570000
MFA-TR*               :AT-ADDRESS-FORMAT,                               29580000
MFA-TR*               :AT-REDUCTN-FXDFCT-IND,                           29590000
MFA-TR*               :AT-CANREB-CODE-00-DAY,                           29600000
MFA-TR*               :AT-CANREB-CODE-30-DAY,                           29610000
MFA-TR*               :AT-CANREB-CODE-60-DAY,                           29620000
MFA-TR*               :AT-CANREB-CODE-90-DAY,                           29630000
MFA-TR*               :AT-CUST-RQST-RD-DT-CD,                           29650000
MFA-TR*               :AT-LAST-UPDATE-TS,                               29660000
MFA-TR*               :AT-CREDIT-STATUS-CODE,                           29670000
MFA-TR*               :AT-LAST-PYMT-DATE:WS-NULL-5,                     29680000
MFA-TR*               :AT-LAST-PYMT-AMOUNT,                             29690000
MFA-TR*               :AT-CT-METER-RATED-IND,                           29700000
MFA-TR*               :AT-IVR-EXEMPT-CD,                                        
MFA-TR*               :AT-BHV-EXEMPT-CD,                                        
MFA-TR*               :AT-ACCOUNT-INIT-TS)                                      
MFA-TR*    END-EXEC.                                                    29710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AT-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
              MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-CUST-PREM-HIST.                                      
                                                                        
           MOVE -1 TO WS-NULL-6.                                        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_PREM_HIST                           
                      (PREMISE_NO,                                      
                       ACCOUNT_NO,                                      
                       DATE_UTIL_SVC_STRT,                              
                       DATE_UTIL_SVC_END,                               
                       CUSTOMER_NO)                                     
               VALUES                                                   
                      (:CH-PREMISE-NO,                                  
                       :CH-ACCOUNT-NO,                                  
                       IIF(TRY_CONVERT(DATE, :CH-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-STRT) ),                      
                       IIF(TRY_CONVERT(DATE, :CH-DATE-UTIL-SVC-END 
                                             :WS-NULL-6
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-END 
                                                             :WS-NULL-6
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-END :WS-NULL-6
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-END :WS-NULL-6
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-END :WS-NULL-6) ),            
                       :CH-CUSTOMER-NO )                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CUST_PREM_HIST                                   
MFA-TR*               (PREMISE_NO,                                              
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                DATE_UTIL_SVC_STRT,                                      
MFA-TR*                DATE_UTIL_SVC_END,                                       
MFA-TR*                CUSTOMER_NO)                                             
MFA-TR*        VALUES                                                           
MFA-TR*               (:CH-PREMISE-NO,                                          
MFA-TR*                :CH-ACCOUNT-NO,                                          
MFA-TR*                :CH-DATE-UTIL-SVC-STRT,                                  
MFA-TR*                :CH-DATE-UTIL-SVC-END:WS-NULL-6,                         
MFA-TR*                :CH-CUSTOMER-NO )                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE CH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-2              
              MOVE CH-PREMISE-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3              
              MOVE CH-CUSTOMER-NO       TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     PREMISE_NO,                                        
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     CUSTOMER_NO,                                       
                     CONTACT_ID,                                        
                     STATE,                                             
                     TOWN,                                              
                     LOCAL_OFFICE,                                      
A05317               ACCOUNT_TYPE_CODE,                                 
A05317               CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-CONTACT-ID,                                     
                    :HT-STATE,                                          
                    :HT-TOWN,                                           
                    :HT-LOCAL-OFFICE,                                   
A05317              :HT-ACCOUNT-TYPE-CODE,                              
A05317              :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE HT-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-UPDATE-NAME-ACCT-XREF.                                      
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_NAME_ACCT_XREF                                
                  SET  ACCOUNT_NO   = :HT-ACCOUNT-NO,                   
                       ADDRESS_ID   = :HT-ADDRESS-ID,                   
                       COMPANY_NO   = :HT-COMPANY-NO,                   
                       PREMISE_NO   = :HT-PREMISE-NO,                   
                       TOWN         = :HT-TOWN,                         
                       STATE        = :HT-STATE,                        
                       LOCAL_OFFICE = :HT-LOCAL-OFFICE,                 
                       ACCOUNT_TYPE_CODE = :HT-ACCOUNT-TYPE-CODE,       
                       CODE_ACCT_STAT = :HT-CODE-ACCT-STAT              
               WHERE   CUSTOMER_NO  = :HT-CUSTOMER-NO                   
                 AND   NAME_ID      = :HT-NAME-ID                       
                 AND   ACCOUNT_NO   = 0                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-HT-UPDATED-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-HT-UPDATED-FL                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8030'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE HT-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   MOVE 'NAME_ID'       TO TABLE-ELEMENT-2              
                   MOVE HT-NAME-ID      TO HOSTVAR-ELEMENT-2            
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-3              
                   MOVE ZEROES          TO HOSTVAR-ELEMENT-3            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8040-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
               WHERE  PREMISE_NO = :PR-PREMISE-NO                       
                 AND  ACCOUNT_NO  = 0                                   
                 AND  CUSTOMER_NO = 0                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*        WHERE  PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*          AND  ACCOUNT_NO  = 0                                           
MFA-TR*          AND  CUSTOMER_NO = 0                                           
MFA-TR*       QUERYNO 8040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '8040'            TO ACTIVE-PARAGRAPH            
                  MOVE 'DELETE'          TO ABEND-FUNCTION              
                  MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                  
                  MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1             
                  MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CREDIT-PROFILE.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CREDIT_PROFILE                            
                     (ACCOUNT_NO,                                       
                      LAST_UPDATE_TS)                                   
              VALUES                                                    
                     (:CZ-ACCOUNT-NO,                                   
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CREDIT_PROFILE                                    
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*       VALUES                                                            
MFA-TR*              (:CZ-ACCOUNT-NO,                                           
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE CZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29700000
              INCLUDE CPD00071                                          29710000
           END-EXEC.                                                    29720000
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     29920000
              INCLUDE CPD00126                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
