       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04839.                                          
COB303 DATE-WRITTEN. FEBRUARY 18, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES RELEASE INFORMATION                      *        
      *  STATUS CODE VALUES:                                           *        
      *      +1 = RELEASE MISMATCH                                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/18/15    FMB      PROCEDURE ORIGINALLY CODED.              *        
A04860*  07/21/16    MR7E794  REPLACED CALL CSR00028 BY CSR04675.      *        
A04860*              ACT122                                            *        
A05317*  11/01/16    FMB      BRIDGE ORDERS ON RELEASE UPDATE.         *        
A05317*  11/30/16    FMB      LIMIT ORDERS CURSOR BY UTILITY TYPE.     *        
A05317*  12/12/16    FMB      CHECK CAD FLAG BEFORE SENDING TO CLICK.  *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04839'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04839 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPRMRL                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
A05317     EXEC SQL                                                             
A05317        INCLUDE TBSOLOC                                                   
A05317     END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04839_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04839'.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  T1-PREMISE-LINE          PIC X(253).                     
           05  T1-PREMISE-TABLE REDEFINES T1-PREMISE-LINE.              
               10  T1-PREMISE           OCCURS 23                       
                                        INDEXED BY T1-INDEX.            
                   15 T1-PREMISE-FL     PIC X(01).                      
                   15 T1-PREMISE-NO     PIC X(10).                      
           05  WS-PREMISE-NO-NUM        PIC X(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-ORDER-NO-NUM          PIC 9(13).                      
           05  WS-ORDER-NO-CHAR         REDEFINES WS-ORDER-NO-NUM       
                                        PIC X(13).                      
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-STATUS-CODE            PIC S9(9) COMP VALUE 0.         
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-6                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-7                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-MATCH-FL              PIC X(01) VALUE SPACES.         
           05  WS-WKDIST-DESC           PIC X(40) VALUE SPACES.         
           05  WS-MISMATCH-COMMENTS     PIC X(62) VALUE SPACES.         
           05  WS-WQ-COMMENTS.                                          
               10  F                    PIC X(6) VALUE 'ORDER '.        
               10  WS-WQ-SERV-ORDER-NO  PIC 9(13).                      
               10  F                    PIC X(10) VALUE ', RELEASE '.   
               10  WS-WQ-RELEASE-NO     PIC X(10).                      
               10  F                    PIC X(33) VALUE                 
               ' EXISTS FOR THIS PREMISE, UNABLE '.                     
               10  F                    PIC X(48) VALUE                 
               'TO MATCH RELEASE WITH SERVICE ORDER CRITERIA. '.        
                                                                        
        01  WS-COMPRESSION-TABLES.                                      
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
                                                                        
      ******************************************************************        
ACT122* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT122 01  CSR04675-CALL-DATA.                                          
ACT122     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT122     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT122     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT122     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT122     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT122     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT122     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT122     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT122     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT122     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT122     05  COMMENTS-4675.                                           
ACT122        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT122        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT122     05  FREE-FORM-DATA-4675.                                     
ACT122        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT122        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT122     05  CREATED-BY-4675            PIC X(16) VALUE SPACES.       
                                                                        
ACT122 01  CSR04675-RETURN-DATA.                                        
ACT122     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT122     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
      ******************************************************************        
      * CSR04747 - INSERT INTO CLICK TASK QUEUE                        *        
      ******************************************************************        
                                                                        
       01  CSR04747-CALL-DATA.                                          
           05  SERV-ORDER-NO-4747        PIC X(13) VALUE SPACES.        
           05  PRIORITY-4747             PIC X(01) VALUE SPACES.        
           05  ACTION-CD-4747            PIC X(01) VALUE SPACES.        
           05  USER-ID-4747              PIC X(07) VALUE SPACES.        
           05  IN-WORK-DISTRICT-4747     PIC X(40) VALUE SPACES.        
                                                                        
       01  CSR04747-RETURN-DATA.                                        
           05  RETURN-CODE-4747          PIC S9(9) COMP VALUE 0.        
           05  OUT-WORK-DISTRICT-4747    PIC X(40) VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR00092 - UPDATE SO REQUIREMENT                               *        
      ******************************************************************        
                                                                        
       01  CSR00092-CALL-DATA.                                          
           05  SERV-ORDER-NO-0092        PIC X(13) VALUE SPACES.        
           05  STATUS-0092               PIC X(02) VALUE SPACES.        
           05  REQUIREMENT-CD-0092       PIC X(03) VALUE SPACES.        
           05  USER-ID-0092              PIC X(07) VALUE SPACES.        
           05  WANTED-BY-DATE-0092       PIC X(26) VALUE SPACES.        
           05  PANEL-0092                PIC X(04) VALUE SPACES.        
           05  UPDATE-STATUS-0092        PIC X(02) VALUE SPACES.        
                                                                        
       01  CSR00092-RETURN-DATA.                                        
           05  RETURN-CODE-0092          PIC S9(9) COMP VALUE 0.        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
ACT122*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4747 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0092 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE PREM-CURSOR CURSOR FOR                            
               SELECT PREMISE_NO                                        
                 FROM CSS_PREM_RLSE_DATA WITH(READUNCOMMITTED)                  
                WHERE RLSE_NO = :RE-RLSE-NO                             
                  AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD             
                                                                 
               FOR READ ONLY                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PREM-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          FROM CSS_PREM_RLSE_DATA                                        
MFA-TR*         WHERE RLSE_NO = :RE-RLSE-NO                                     
MFA-TR*           AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD                     
MFA-TR*        WITH UR                                                          
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ORDER-CURSOR CURSOR FOR                           
               SELECT VO.SERV_ORDER_NO,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                               
                      REV_DISTRICT_CD,                                  
                      ACCOUNT_NO,                                       
                      VO.LOCAL_OFFICE,                                  
                      SO_BUSINESS_UNIT,                                 
                      FM_ELEC_SVC_WKDIST,                               
                      FM_GAS_OPS_WKDIST,                                
                      FM_FLD_SVCS_WKDIST,                               
                      FM_REV_PRT_WKDIST,                                
                      FM_DSM_ESVC_WKDIST,                               
A05317                WORK_AREA_ID                                      
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.PREMISE_NO = PR.PREMISE_NO                     
                  AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',      
                                        'CC003','FM006','FM003',        
                                        'NC001','ON001')                
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND EXISTS (                                          
                        SELECT 1                                        
                          FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)          
                         WHERE SERV_ORDER_NO = VO.SERV_ORDER_NO         
A05317                     AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE      
                           AND HOLD_RELEASE = 'Y'                       
                           AND RLSE_NO = '          ')                  
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORDER-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               WANTED_BY_DATETIME,                                       
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               SO_BUSINESS_UNIT,                                         
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST,                                       
MFA-TR*               WORK_AREA_ID                                              
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',              
MFA-TR*                                 'CC003','FM006','FM003',                
MFA-TR*                                 'NC001','ON001')                        
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND EXISTS (                                                  
MFA-TR*                 SELECT 1                                                
MFA-TR*                   FROM CSS_SO_ORDER_INST                                
MFA-TR*                  WHERE SERV_ORDER_NO = VO.SERV_ORDER_NO                 
MFA-TR*                    AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE              
MFA-TR*                    AND HOLD_RELEASE = 'Y'                               
MFA-TR*                    AND RLSE_NO = '          ')                          
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE INST-CURSOR CURSOR FOR                            
               SELECT CODE_UTIL_TYPE,                                   
                      METER_SUPPLYING,                                  
                      PER_TEMP_IND                                      
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND HOLD_RELEASE = 'Y'                                
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INST-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT CODE_UTIL_TYPE,                                           
MFA-TR*               METER_SUPPLYING,                                          
MFA-TR*               PER_TEMP_IND                                              
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND HOLD_RELEASE = 'Y'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7040                                                    
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT122            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747                                             
                  ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :IN-WORK-DISTRICT-4747 OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0092 CURSOR
MSQ001          FOR CALL CSR00092                                             
                  ( :SERV-ORDER-NO-0092
                  , :STATUS-0092
                  , :REQUIREMENT-CD-0092
                  , :USER-ID-0092
                  , :WANTED-BY-DATE-0092
                  , :PANEL-0092
                  , :UPDATE-STATUS-0092
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE        PIC X(01).                           
       01  LINK-RELEASE-NO         PIC X(10).                           
       01  LINK-REV-DISTRICT-CD    PIC X(03).                           
       01  LINK-RLSE-DT            PIC X(10).                           
       01  LINK-RLSE-EXP-DT        PIC X(10).                           
       01  LINK-INSPECTOR-NAME     PIC X(30).                           
       01  LINK-REMARKS            PIC X(250).                          
       01  LINK-SUPPLIES           PIC X(15).                           
       01  LINK-RLSE-TYPE          PIC X(02).                           
       01  LINK-PREMISE-INFO       PIC X(253).                          
       01  LINK-USERID             PIC X(07).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-UPDATE-TYPE                              
                          LINK-RELEASE-NO                               
                          LINK-REV-DISTRICT-CD                          
                          LINK-RLSE-DT                                  
                          LINK-RLSE-EXP-DT                              
                          LINK-INSPECTOR-NAME                           
                          LINK-REMARKS                                  
                          LINK-SUPPLIES                                 
                          LINK-RLSE-TYPE                                
                          LINK-PREMISE-INFO                             
                          LINK-USERID.                                  
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE      AS RETURN_CODE,              
                       :S-STATUS-CODE      AS STATUS_CODE,              
                       :WS-MISMATCH-COMMENTS AS MISMATCH_COMMENTS       
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE      AS RETURN_CODE,                      
MFA-TR*                :S-STATUS-CODE      AS STATUS_CODE,                      
MFA-TR*                :WS-MISMATCH-COMMENTS AS MISMATCH_COMMENTS               
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-PREMISE-INFO TO T1-PREMISE-LINE.                   
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL299'               TO MH-APPL-PROGRAM-ID.         
           MOVE +210                     TO MH-TRAN-COMMENT-LEN.        
           MOVE LINK-REMARKS(1:210)      TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE LINK-RELEASE-NO TO RE-RLSE-NO.                          
           MOVE LINK-REV-DISTRICT-CD TO RE-REV-DISTRICT-CD.             
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-RELEASE THRU 3000-EXIT           
               WHEN 'U'                                                 
                   PERFORM 3100-UPDATE-RELEASE THRU 3100-EXIT           
               WHEN 'D'                                                 
                   PERFORM 3200-DELETE-RELEASE THRU 3200-EXIT           
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-RELEASE.                                             
                                                                        
           MOVE LINK-INSPECTOR-NAME TO RE-RLSE-INSPTOR-NAME.            
           MOVE LINK-REMARKS TO RE-RLSE-REMARKS.                        
           MOVE LINK-SUPPLIES TO RE-RLSE-SUPPLIES.                      
           MOVE LINK-RLSE-TYPE TO RE-RLSE-TYPE.                         
           MOVE LINK-RLSE-DT TO RE-RLSE-DATE(1:10).                     
           MOVE '-00.00.00.000000' TO RE-RLSE-DATE(11:16).              
           MOVE LINK-RLSE-EXP-DT TO RE-RLSE-EXP-DATE.                   
           MOVE '-00.00.00.000000' TO RE-RLSE-EXP-DATE(11:16).          
           MOVE LINK-USERID TO RE-CREATED-BY-USER-ID                    
                               RE-LAST-UPDATE-USERID.                   
           MOVE WS-CURRENT-TIMESTAMP TO RE-CREATED-TS                   
                                        RE-LAST-UPDATE-TS.              
           PERFORM 8125-INSERT-RELEASE THRU 8125-EXIT.                  
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T1-INDEX > 23 OR 
               T1-PREMISE-FL (T1-INDEX) <= SPACES                               
                   MOVE T1-PREMISE-NO (T1-INDEX) TO WS-PREMISE-NO-CHAR  
                   MOVE WS-PREMISE-NO-NUM TO RP-PREMISE-NO              
                                             MH-PREMISE-NO              
                                             VO-PREMISE-NO              
                   PERFORM 8000-INSERT-RLSE-DATA THRU 8000-EXIT         
                   PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT     
A05317             MOVE LINK-RLSE-TYPE(1:1) TO VI-CODE-UTIL-TYPE        
                   PERFORM 7030-OPEN-ORDER-CURSOR THRU 7030-EXIT        
                   PERFORM 3010-FETCH-ROWS THRU 3010-EXIT               
                   PERFORM 7031-CLOSE-ORDER-CURSOR THRU 7031-EXIT       
           END-PERFORM.                                                 
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ORDER-CURSOR                                       
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-WANTED-BY-DATETIME,                            
                     :PR-REV-DISTRICT-CD,                               
                     :VO-ACCOUNT-NO,                                    
                     :VO-LOCAL-OFFICE,                                  
                     :VO-SO-BUSINESS-UNIT,                              
                     :PR-FM-ELEC-SVC-WKDIST,                            
                     :PR-FM-GAS-OPS-WKDIST,                             
                     :PR-FM-FLD-SVCS-WKDIST,                            
                     :PR-FM-REV-PRT-WKDIST,                             
                     :PR-FM-DSM-ESVC-WKDIST,                            
A05317               :VO-WORK-AREA-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'CSS_PREMISE'    TO TABLE-3                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF VO-SO-BUSINESS-UNIT > SPACES                              
               EVALUATE VO-SO-BUSINESS-UNIT                             
                   WHEN 'EOP'                                           
                       MOVE PR-FM-ELEC-SVC-WKDIST-TEXT TO WS-WKDIST-DESC
                   WHEN 'GOP'                                           
                       MOVE PR-FM-GAS-OPS-WKDIST-TEXT TO WS-WKDIST-DESC 
                   WHEN 'FSV'                                           
                       MOVE PR-FM-FLD-SVCS-WKDIST-TEXT TO WS-WKDIST-DESC
                   WHEN 'RVP'                                           
                       MOVE PR-FM-REV-PRT-WKDIST-TEXT TO WS-WKDIST-DESC 
                   WHEN 'DSM'                                           
                       MOVE PR-FM-DSM-ESVC-WKDIST-TEXT TO WS-WKDIST-DESC
               END-EVALUATE
           END-IF.                                            
                                                                        
           MOVE 'N' TO WS-MATCH-FL.                                     
           MOVE LINK-RLSE-TYPE(2:1) TO VI-PER-TEMP-IND.                 
           MOVE LINK-RLSE-TYPE(1:1) TO VI-CODE-UTIL-TYPE.               
           PERFORM 8175-UPDATE-ORDER THRU 8175-EXIT.                    
                                                                        
           IF WS-MATCH-FL = 'Y'                                         
               MOVE VO-SERV-ORDER-NO TO WS-ORDER-NO-CHAR                
               MOVE WS-ORDER-NO-NUM TO SERV-ORDER-NO-4747               
A05317         PERFORM 7010-SO-PRINT-LOC THRU 7010-EXIT                 
               IF WS-WKDIST-DESC > SPACES AND                           
A05317            C4-CAD-WORKAREA-FL = 'Y'                              
                      MOVE '1' TO PRIORITY-4747                         
                      MOVE 'U' TO ACTION-CD-4747                        
                      MOVE 'SYSTEM' TO USER-ID-4747                     
                      PERFORM 4220-CALL-CSR04747 THRU 4220-EXIT         
               END-IF                                                   
               MOVE WS-ORDER-NO-NUM TO SERV-ORDER-NO-0092               
               MOVE '10' TO STATUS-0092                                 
               MOVE '1' TO REQUIREMENT-CD-0092                          
               MOVE LINK-USERID TO USER-ID-0092                         
               MOVE VO-WANTED-BY-DATETIME TO WANTED-BY-DATE-0092        
               MOVE '299' TO PANEL-0092                                 
               MOVE 'Y' TO UPDATE-STATUS-0092                           
               PERFORM 4230-CALL-CSR00092 THRU 4230-EXIT                
           ELSE                                                         
               PERFORM 7040-OPEN-INST-CURSOR THRU 7040-EXIT             
               PERFORM 3020-FETCH-ROWS THRU 3020-EXIT                   
               PERFORM 7041-CLOSE-INST-CURSOR THRU 7041-EXIT
           END-IF.           
                                                                        
           GO TO 3010-FETCH-ROWS.                                       
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3020-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH INST-CURSOR                                        
                INTO :VI-CODE-UTIL-TYPE,                                
                     :VI-METER-SUPPLYING,                               
                     :VI-PER-TEMP-IND                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3020-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE VO-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM.                     
ACT122     MOVE WS-ACCOUNT-NO-CHAR TO ACCOUNT-NO-4675.                  
           MOVE VO-PREMISE-NO TO WS-PREMISE-NO-NUM.                     
ACT122     MOVE WS-PREMISE-NO-CHAR TO PREMISE-NO-4675.                  
ACT122     MOVE ZEROES TO CUSTOMER-NO-4675.                             
ACT122     MOVE '1' TO ROUTING-CATEGORY-4675.                           
           IF VI-CODE-UTIL-TYPE = 'E'                                   
ACT122         MOVE 83 TO CATEGORY-ID-4675                              
           ELSE                                                         
ACT122         MOVE 325 TO CATEGORY-ID-4675
           END-IF.                            
                                                                        
           MOVE VO-SERV-ORDER-NO TO WS-WQ-SERV-ORDER-NO.                
           MOVE RE-RLSE-NO TO WS-WQ-RELEASE-NO.                         
           IF VI-PER-TEMP-IND NOT = LINK-RLSE-TYPE(2:1)                 
               MOVE 'RELEASE TYPE' TO WS-MISMATCH-COMMENTS(1:13)
           END-IF.       
           IF PR-REV-DISTRICT-CD NOT = LINK-REV-DISTRICT-CD             
               MOVE ' REVENUE DISTRICT' TO WS-MISMATCH-COMMENTS(14:17)
           END-IF. 
           IF VI-CODE-UTIL-TYPE NOT = LINK-RLSE-TYPE(1:1)               
               MOVE ' UTILITY TYPE' TO WS-MISMATCH-COMMENTS(31:14)
           END-IF.     
           IF VI-METER-SUPPLYING NOT = LINK-SUPPLIES                    
               MOVE ' METER SUPPLIES' TO WS-MISMATCH-COMMENTS(45:16)
           END-IF.   
                                                                        
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           STRING WS-WQ-COMMENTS                                        
                  WS-MISMATCH-COMMENTS                                  
                  ' DOES NOT MATCH.'                                    
                  DELIMITED BY SIZE INTO WS-EMB-INPUT.                  
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
ACT122     MOVE WS-CMP-TABLE TO COMMENTS-4675-TEXT.                     
ACT122     MOVE +200 TO COMMENTS-4675-LEN.                              
                                                                        
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           MOVE WS-MISMATCH-COMMENTS TO WS-EMB-INPUT.                   
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           MOVE WS-CMP-TABLE TO WS-MISMATCH-COMMENTS.                   
           MOVE +1 TO S-STATUS-CODE.                                    
                                                                        
ACT122     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT122     MOVE VO-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT122     MOVE LINK-USERID TO USER-ID-ORIG-4675.                       
ACT122     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT122                    RESP-AREA-ID-4675                             
ACT122                    DATE-REQUIRED-4675                            
ACT122                    DATE-CREATED-4675                             
ACT122                    FREE-FORM-DATA-4675-TEXT.                     
ACT122     MOVE 'N' TO WQ-PRIORITY-4675                                 
ACT122     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
           MOVE VO-SERV-ORDER-NO TO WS-ORDER-NO-CHAR.                   
ACT122     MOVE WS-ORDER-NO-NUM TO SERV-ORDER-NO-4675.                  
ACT122     MOVE PROGRAM-NAME    TO CREATED-BY-4675.                     
ACT122     PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT                    
                                                                        
           GO TO 3020-FETCH-ROWS.                                       
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-RELEASE.                                             
                                                                        
           PERFORM 7100-SELECT-RELEASE THRU 7100-EXIT.                  
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T1-INDEX > 23 OR 
               T1-PREMISE-FL (T1-INDEX) <= SPACES                               
                   MOVE T1-PREMISE-NO (T1-INDEX) TO WS-PREMISE-NO-CHAR  
                   MOVE WS-PREMISE-NO-NUM TO RP-PREMISE-NO              
                                             MH-PREMISE-NO              
                                             VO-PREMISE-NO              
                   EVALUATE T1-PREMISE-FL (T1-INDEX)                    
                       WHEN 'I'                                         
                           PERFORM 8000-INSERT-RLSE-DATA THRU 8000-EXIT 
                           PERFORM 5000-TRANSHIST-FOR-INSERT THRU       
                                   5000-EXIT                            
A05317                     MOVE LINK-RLSE-TYPE(1:1) TO VI-CODE-UTIL-TYPE
                           PERFORM 7030-OPEN-ORDER-CURSOR THRU 7030-EXIT
                           PERFORM 3010-FETCH-ROWS THRU 3010-EXIT       
                           PERFORM 7031-CLOSE-ORDER-CURSOR THRU         
                                   7031-EXIT                            
                       WHEN 'D'                                         
                           PERFORM 8250-DELETE-RLSE-DATA THRU 8250-EXIT 
                           PERFORM 5100-TRANSHIST-FOR-DELETE THRU       
                                   5100-EXIT                            
                       WHEN OTHER                                       
                           PERFORM 5200-TRANSHIST-FOR-UPDATE THRU       
                                   5200-EXIT                            
A05317                     MOVE LINK-RLSE-TYPE(1:1) TO VI-CODE-UTIL-TYPE
A05317                     PERFORM 7030-OPEN-ORDER-CURSOR THRU 7030-EXIT
A05317                     PERFORM 3010-FETCH-ROWS THRU 3010-EXIT       
A05317                     PERFORM 7031-CLOSE-ORDER-CURSOR THRU         
A05317                             7031-EXIT                            
                   END-EVALUATE                                         
           END-PERFORM.                                                 
                                                                        
           MOVE LINK-INSPECTOR-NAME TO RE-RLSE-INSPTOR-NAME.            
           MOVE LINK-REMARKS TO RE-RLSE-REMARKS.                        
           MOVE LINK-SUPPLIES TO RE-RLSE-SUPPLIES.                      
           MOVE LINK-RLSE-TYPE TO RE-RLSE-TYPE.                         
           MOVE LINK-RLSE-DT TO RE-RLSE-DATE(1:10).                     
           MOVE '-00.00.00.000000' TO RE-RLSE-DATE(11:16).              
           MOVE LINK-RLSE-EXP-DT TO RE-RLSE-EXP-DATE.                   
           MOVE '-00.00.00.000000' TO RE-RLSE-EXP-DATE(11:16).          
           MOVE LINK-USERID TO RE-LAST-UPDATE-USERID.                   
           MOVE WS-CURRENT-TIMESTAMP TO RE-LAST-UPDATE-TS.              
           PERFORM 8150-UPDATE-RELEASE THRU 8150-EXIT.                  
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-RELEASE.                                             
                                                                        
           PERFORM 7100-SELECT-RELEASE THRU 7100-EXIT.                  
                                                                        
           PERFORM 7070-OPEN-PREM-CURSOR THRU 7070-EXIT.                
           PERFORM 3210-FETCH-ROWS THRU 3210-EXIT.                      
           PERFORM 7071-CLOSE-PREM-CURSOR THRU 7071-EXIT.               
                                                                        
           PERFORM 8200-DELETE-RELEASE THRU 8200-EXIT.                  
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH PREM-CURSOR                                        
                INTO :RP-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3210-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'RLSE_NO'        TO TABLE-ELEMENT-1             
                   MOVE RE-RLSE-NO       TO HOSTVAR-ELEMENT-1           
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE RP-PREMISE-NO TO MH-PREMISE-NO.                         
           PERFORM 5100-TRANSHIST-FOR-DELETE THRU 5100-EXIT.            
                                                                        
           GO TO 3210-FETCH-ROWS.                                       
                                                                        
       3210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT122 4210-CALL-CSR04675.                                              
                                                                        
      *    EXEC SQL                                                     
ACT122*       CALL CSR04675                                             
ACT122*           (:IN-ITEM-ID-4675,                                    
ACT122*            :ROUTING-CATEGORY-4675,                              
ACT122*            :LOCAL-OFFICE-4675,                                  
ACT122*            :USER-ID-ORIG-4675,                                  
ACT122*            :USER-ID-ASGN-4675,                                  
ACT122*            :RESP-AREA-ID-4675,                                  
ACT122*            :CATEGORY-ID-4675,                                   
ACT122*            :ACCOUNT-NO-4675,                                    
ACT122*            :PREMISE-NO-4675,                                    
ACT122*            :CUSTOMER-NO-4675,                                   
ACT122*            :SERV-ORDER-NO-4675,                                 
ACT122*            :COMMENTS-4675,                                      
ACT122*            :DATE-REQUIRED-4675,                                 
ACT122*            :DATE-CREATED-4675,                                  
ACT122*            :WQ-PRIORITY-4675,                                   
ACT122*            :FREE-FORM-DATA-4675,                                
ACT122*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT122        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT122        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT122        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT122*       (:LOC4675)                                                
ACT122*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT122*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT122*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT122        FETCH RESULT_SET_CSR_4675 INTO                            
ACT122           :RETURN-CODE-4675,                                     
ACT122           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT122             IF RETURN-CODE-4675 NOT = 0                          
ACT122                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT122                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT122                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT122                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT122             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT122             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT122             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4220-CALL-CSR04747.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04747                                             
      *           (:SERV-ORDER-NO-4747,                                 
      *            :PRIORITY-4747,                                      
      *            :ACTION-CD-4747,                                     
      *            :USER-ID-4747,                                       
      *            :IN-WORK-DISTRICT-4747)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4220'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04747'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-4747    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747)                                                
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4747 CURSOR FOR RESULT SET        
      *       :LOC4747                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4747 INTO                            
                 :RETURN-CODE-4747,                                     
                 :OUT-WORK-DISTRICT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4747 NOT = 0                          
                       MOVE RETURN-CODE-4747  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4220'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04747'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-4747 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4220'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-4747    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4230-CALL-CSR00092.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00092                                             
      *           (:SERV-ORDER-NO-0092,                                 
      *            :STATUS-0092,                                        
      *            :REQUIREMENT-CD-0092,                                
      *            :USER-ID-0092,                                       
      *            :WANTED-BY-DATE-0092,                                
      *            :PANEL-0092,                                         
      *            :UPDATE-STATUS-0092)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0092
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0092
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0092 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4230'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00092'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0092    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0092)                                                
      *       WITH PROCEDURE CSR00092                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0092 CURSOR FOR RESULT SET        
      *       :LOC0092                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0092 INTO                            
                 :RETURN-CODE-0092                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0092 NOT = 0                          
                       MOVE RETURN-CODE-0092  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4230'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00092'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0092 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4230'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00092'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0092    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4230-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-RELEASE-NO       TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'RELEASE NO'          TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-REV-DISTRICT-CD  TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'REVENUE DIST CD'     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +25                   TO MI-CHG-COLUMN-VALUE-LEN.       
           EVALUATE RE-RLSE-TYPE                                        
               WHEN 'EP'                                                
                   MOVE 'PERMANENT - ELECTRIC' TO                       
                         MI-CHG-COLUMN-VALUE-TEXT                       
               WHEN 'ET'                                                
                   MOVE 'TEMPORARY - ELECTRIC' TO                       
                         MI-CHG-COLUMN-VALUE-TEXT                       
               WHEN 'GP'                                                
                   MOVE 'PERMANENT - GAS' TO                            
                         MI-CHG-COLUMN-VALUE-TEXT                       
               WHEN 'GT'                                                
                   MOVE 'TEMPORARY - GAS' TO                            
                         MI-CHG-COLUMN-VALUE-TEXT                       
           END-EVALUATE.                                                
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'RELEASE TYPE'        TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-SUPPLIES         TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'SUPPLIES'            TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-RLSE-DT          TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'RELEASE DATE'        TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-RLSE-EXP-DT      TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'EXPIRATION DATE'     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-INSPECTOR-NAME   TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'INSPECTOR NAME'      TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-DELETE.                                       
                                                                        
           MOVE '5100'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF RE-RLSE-NO > SPACES                                       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-NO             TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'RELEASE NO'           TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-REV-DISTRICT-CD > SPACES                               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-REV-DISTRICT-CD     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'REVENUE DIST CD'      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-TYPE > SPACES                                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +25                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              EVALUATE RE-RLSE-TYPE                                     
                  WHEN 'EP'                                             
                      MOVE 'PERMANENT - ELECTRIC' TO                    
                            MI-PRV-COLUMN-VALUE-TEXT                    
                  WHEN 'ET'                                             
                      MOVE 'TEMPORARY - ELECTRIC' TO                    
                            MI-PRV-COLUMN-VALUE-TEXT                    
                  WHEN 'GP'                                             
                      MOVE 'PERMANENT - GAS' TO                         
                            MI-PRV-COLUMN-VALUE-TEXT                    
                  WHEN 'GT'                                             
                      MOVE 'TEMPORARY - GAS' TO                         
                            MI-PRV-COLUMN-VALUE-TEXT                    
              END-EVALUATE                                              
              MOVE 'RELEASE TYPE'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-SUPPLIES > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-SUPPLIES       TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'SUPPLIES'             TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-DATE > SPACES                                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-DATE           TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'RELEASE DATE'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-EXP-DATE > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-EXP-DATE       TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'EXPIRATION DATE'      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-INSPTOR-NAME > SPACES                             
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +30                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-INSPTOR-NAME   TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'INSPECTOR NAME'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5200'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF RE-RLSE-TYPE NOT = LINK-RLSE-TYPE                         
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +25                    TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              EVALUATE RE-RLSE-TYPE                                     
                  WHEN 'EP'                                             
                      MOVE 'PERMANENT - ELECTRIC' TO                    
                            MI-PRV-COLUMN-VALUE-TEXT                    
                  WHEN 'ET'                                             
                      MOVE 'TEMPORARY - ELECTRIC' TO                    
                            MI-PRV-COLUMN-VALUE-TEXT                    
                  WHEN 'GP'                                             
                      MOVE 'PERMANENT - GAS' TO                         
                            MI-PRV-COLUMN-VALUE-TEXT                    
                  WHEN 'GT'                                             
                      MOVE 'TEMPORARY - GAS' TO                         
                            MI-PRV-COLUMN-VALUE-TEXT                    
              END-EVALUATE                                              
              EVALUATE LINK-RLSE-TYPE                                   
                  WHEN 'EP'                                             
                      MOVE 'PERMANENT - ELECTRIC' TO                    
                            MI-CHG-COLUMN-VALUE-TEXT                    
                  WHEN 'ET'                                             
                      MOVE 'TEMPORARY - ELECTRIC' TO                    
                            MI-CHG-COLUMN-VALUE-TEXT                    
                  WHEN 'GP'                                             
                      MOVE 'PERMANENT - GAS' TO                         
                            MI-CHG-COLUMN-VALUE-TEXT                    
                  WHEN 'GT'                                             
                      MOVE 'TEMPORARY - GAS' TO                         
                            MI-CHG-COLUMN-VALUE-TEXT                    
              END-EVALUATE                                              
              MOVE 'RELEASE TYPE'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-SUPPLIES NOT = LINK-SUPPLIES                      
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-SUPPLIES          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-SUPPLIES       TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'SUPPLIES'             TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-DATE(1:10) NOT = LINK-RLSE-DT                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-RLSE-DT           TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-DATE(1:10)     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'RELEASE DATE'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-EXP-DATE(1:10) NOT = LINK-RLSE-EXP-DT             
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-RLSE-EXP-DT       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-EXP-DATE(1:10) TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'EXPIRATION DATE'      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF RE-RLSE-INSPTOR-NAME NOT = LINK-INSPECTOR-NAME            
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +30                    TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-INSPECTOR-NAME    TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE RE-RLSE-INSPTOR-NAME   TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'INSPECTOR NAME'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6000-REDUCE-EMBEDDED-SPACES.                                     
                                                                        
           MOVE 255 TO WS-EMB-TBL-LENG.                                 
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
           MOVE SPACE TO WS-EMB-LAST-CHAR.                              
           IF WS-EMB-LENG NUMERIC AND                                   
              WS-EMB-LENG > ZERO AND                                    
              WS-EMB-LENG < WS-EMB-TBL-LENG                             
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG TO WS-EMB-LENG
           END-IF.                     
           PERFORM 6010-COMPRESSION-ROUTINE THRU 6010-EXIT              
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX > WS-EMB-LENG.                         
           MOVE ZERO TO WS-EMB-LENG.                                    
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6010-COMPRESSION-ROUTINE.                                        
                                                                        
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE AND                 
              WS-EMB-LAST-CHAR                                          
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                        
                    WS-CMP-CHAR (WS-CMP-INDX)                           
                    WS-EMB-LAST-CHAR                                    
                SET WS-CMP-INDX UP BY 1
           END-IF.                                
                                                                        
       6010-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7010-SO-PRINT-LOC.                                               
A05317                                                                  
A05317     EXEC SQL                                                     
A05317        SELECT TOP(1) CAD_WORKAREA_FL                                    
A05317          INTO :C4-CAD-WORKAREA-FL                                
A05317          FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                     
A05317         WHERE WORK_AREA_ID = :VO-WORK-AREA-ID                    
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CAD_WORKAREA_FL                                            
MFA-TR*         INTO :C4-CAD-WORKAREA-FL                                        
MFA-TR*         FROM CSS_SO_PRINT_LOC                                           
MFA-TR*        WHERE WORK_AREA_ID = :VO-WORK-AREA-ID                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN NOT-FOUND                                           
A05317             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05317             MOVE 'N' TO C4-CAD-WORKAREA-FL                       
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
A05317             MOVE '7010'            TO ACTIVE-PARAGRAPH           
A05317             MOVE 'SELECT'          TO ABEND-FUNCTION             
A05317             MOVE 'CSS_SO_PRINT_LOC' TO TABLE-1                   
A05317             MOVE 'WORK_AREA_ID'    TO TABLE-ELEMENT-1            
A05317             MOVE VO-WORK-AREA-ID   TO HOSTVAR-ELEMENT-1          
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7010-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       7030-OPEN-ORDER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ORDER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'CSS_PREMISE'    TO TABLE-3                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7031-CLOSE-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7031'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'CSS_PREMISE'    TO TABLE-3                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7031-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-OPEN-INST-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN INST-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7041-CLOSE-INST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE INST-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7041'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7041-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-OPEN-PREM-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN PREM-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'RLSE_NO'        TO TABLE-ELEMENT-1             
                   MOVE RE-RLSE-NO       TO HOSTVAR-ELEMENT-1           
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7071-CLOSE-PREM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE PREM-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7071'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'RLSE_NO'        TO TABLE-ELEMENT-1             
                   MOVE RE-RLSE-NO       TO HOSTVAR-ELEMENT-1           
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7071-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID,
              LOCAL_OFFICE                                       
                INTO :PF-RESP-AREA-ID,                                  
                     :PF-LOCAL-OFFICE                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID,                                              
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :PF-RESP-AREA-ID,                                          
MFA-TR*              :PF-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-RELEASE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE, 121), 
           ' ', '-'), ':', '.') RLSE_DATE,                                     
                     RLSE_TYPE,                                         
                     RLSE_SUPPLIES,                                     
                     REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_EXP_DATE
           , 121), ' ', '-'), ':', '.') RLSE_EXP_DATE,                         
                     RLSE_INSPTOR_NAME,                                 
                     RLSE_REMARKS,                                      
                     CREATED_BY_USER_ID,                                
                     REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS,                            
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     LAST_UPDATE_USERID                                 
                INTO :RE-RLSE-DATE,                                     
                     :RE-RLSE-TYPE,                                     
                     :RE-RLSE-SUPPLIES,                                 
                     :RE-RLSE-EXP-DATE,                                 
                     :RE-RLSE-INSPTOR-NAME,                             
                     :RE-RLSE-REMARKS,                                  
                     :RE-CREATED-BY-USER-ID,                            
                     :RE-CREATED-TS,                                    
                     :RE-LAST-UPDATE-TS,                                
                     :RE-LAST-UPDATE-USERID                             
                FROM CSS_PREM_RLSE WITH(READUNCOMMITTED)                        
               WHERE RLSE_NO = :RE-RLSE-NO                              
                 AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RLSE_DATE,                                                 
MFA-TR*              RLSE_TYPE,                                                 
MFA-TR*              RLSE_SUPPLIES,                                             
MFA-TR*              RLSE_EXP_DATE,                                             
MFA-TR*              RLSE_INSPTOR_NAME,                                         
MFA-TR*              RLSE_REMARKS,                                              
MFA-TR*              CREATED_BY_USER_ID,                                        
MFA-TR*              CREATED_TS,                                                
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              LAST_UPDATE_USERID                                         
MFA-TR*         INTO :RE-RLSE-DATE,                                             
MFA-TR*              :RE-RLSE-TYPE,                                             
MFA-TR*              :RE-RLSE-SUPPLIES,                                         
MFA-TR*              :RE-RLSE-EXP-DATE,                                         
MFA-TR*              :RE-RLSE-INSPTOR-NAME,                                     
MFA-TR*              :RE-RLSE-REMARKS,                                          
MFA-TR*              :RE-CREATED-BY-USER-ID,                                    
MFA-TR*              :RE-CREATED-TS,                                            
MFA-TR*              :RE-LAST-UPDATE-TS,                                        
MFA-TR*              :RE-LAST-UPDATE-USERID                                     
MFA-TR*         FROM CSS_PREM_RLSE                                              
MFA-TR*        WHERE RLSE_NO = :RE-RLSE-NO                                      
MFA-TR*          AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREM_RLSE'      TO TABLE-1                      
              MOVE 'RLSE_NO'            TO TABLE-ELEMENT-1              
              MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-1              
              MOVE RE-RLSE-NO           TO HOSTVAR-ELEMENT-2            
              MOVE RE-REV-DISTRICT-CD   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-RLSE-DATA.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_PREM_RLSE_DATA                            
                   (RLSE_NO,                                            
                    REV_DISTRICT_CD,                                    
                    PREMISE_NO)                                         
              VALUES                                                    
                   (:RE-RLSE-NO,                                        
                    :RE-REV-DISTRICT-CD,                                
                    :RP-PREMISE-NO)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                      
              MOVE 'RLSE_NO'            TO TABLE-ELEMENT-1              
              MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-2              
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE RE-RLSE-NO           TO HOSTVAR-ELEMENT-1            
              MOVE RE-REV-DISTRICT-CD   TO HOSTVAR-ELEMENT-2            
              MOVE RP-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8125-INSERT-RELEASE.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_PREM_RLSE                                 
                   (RLSE_NO,                                            
                    REV_DISTRICT_CD,                                    
                    RLSE_DATE,                                          
                    RLSE_TYPE,                                          
                    RLSE_SUPPLIES,                                      
                    RLSE_EXP_DATE,                                      
                    RLSE_INSPTOR_NAME,                                  
                    RLSE_REMARKS,                                       
                    CREATED_BY_USER_ID,                                 
                    CREATED_TS,                                         
                    LAST_UPDATE_TS,                                     
                    LAST_UPDATE_USERID)                                 
              VALUES                                                    
                   (:RE-RLSE-NO,                                        
                    :RE-REV-DISTRICT-CD,                                
                    CIS.CHAR2TIMESTAMP(:RE-RLSE-DATE),                          
                    :RE-RLSE-TYPE,                                      
                    :RE-RLSE-SUPPLIES,                                  
                    CIS.CHAR2TIMESTAMP(:RE-RLSE-EXP-DATE),                      
                    :RE-RLSE-INSPTOR-NAME,                              
                    :RE-RLSE-REMARKS,                                   
                    :RE-CREATED-BY-USER-ID,                             
                    CIS.CHAR2TIMESTAMP(:RE-CREATED-TS),                         
                    CIS.CHAR2TIMESTAMP(:RE-LAST-UPDATE-TS),                     
                    :RE-LAST-UPDATE-USERID)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_PREM_RLSE                                         
MFA-TR*            (RLSE_NO,                                                    
MFA-TR*             REV_DISTRICT_CD,                                            
MFA-TR*             RLSE_DATE,                                                  
MFA-TR*             RLSE_TYPE,                                                  
MFA-TR*             RLSE_SUPPLIES,                                              
MFA-TR*             RLSE_EXP_DATE,                                              
MFA-TR*             RLSE_INSPTOR_NAME,                                          
MFA-TR*             RLSE_REMARKS,                                               
MFA-TR*             CREATED_BY_USER_ID,                                         
MFA-TR*             CREATED_TS,                                                 
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             LAST_UPDATE_USERID)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:RE-RLSE-NO,                                                
MFA-TR*             :RE-REV-DISTRICT-CD,                                        
MFA-TR*             :RE-RLSE-DATE,                                              
MFA-TR*             :RE-RLSE-TYPE,                                              
MFA-TR*             :RE-RLSE-SUPPLIES,                                          
MFA-TR*             :RE-RLSE-EXP-DATE,                                          
MFA-TR*             :RE-RLSE-INSPTOR-NAME,                                      
MFA-TR*             :RE-RLSE-REMARKS,                                           
MFA-TR*             :RE-CREATED-BY-USER-ID,                                     
MFA-TR*             :RE-CREATED-TS,                                             
MFA-TR*             :RE-LAST-UPDATE-TS,                                         
MFA-TR*             :RE-LAST-UPDATE-USERID)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8125'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_PREM_RLSE'      TO TABLE-1                      
              MOVE 'RLSE_NO'            TO TABLE-ELEMENT-1              
              MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-2              
              MOVE RE-RLSE-NO           TO HOSTVAR-ELEMENT-1            
              MOVE RE-REV-DISTRICT-CD   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8125-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8150-UPDATE-RELEASE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREM_RLSE                                      
                 SET RLSE_DATE = CIS.CHAR2TIMESTAMP(:RE-RLSE-DATE),             
                     RLSE_TYPE = :RE-RLSE-TYPE,                         
                     RLSE_SUPPLIES = :RE-RLSE-SUPPLIES,                 
                     RLSE_EXP_DATE = CIS.CHAR2TIMESTAMP(
                                                      :RE-RLSE-EXP-DATE
              ),                 
                     RLSE_INSPTOR_NAME = :RE-RLSE-INSPTOR-NAME,         
                     RLSE_REMARKS = :RE-RLSE-REMARKS,                   
                     LAST_UPDATE_USERID = :RE-LAST-UPDATE-USERID,       
                     LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :RE-LAST-UPDATE-TS
              )                
               WHERE RLSE_NO = :RE-RLSE-NO                              
                 AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREM_RLSE                                              
MFA-TR*          SET RLSE_DATE = :RE-RLSE-DATE,                                 
MFA-TR*              RLSE_TYPE = :RE-RLSE-TYPE,                                 
MFA-TR*              RLSE_SUPPLIES = :RE-RLSE-SUPPLIES,                         
MFA-TR*              RLSE_EXP_DATE = :RE-RLSE-EXP-DATE,                         
MFA-TR*              RLSE_INSPTOR_NAME = :RE-RLSE-INSPTOR-NAME,                 
MFA-TR*              RLSE_REMARKS = :RE-RLSE-REMARKS,                           
MFA-TR*              LAST_UPDATE_USERID = :RE-LAST-UPDATE-USERID,               
MFA-TR*              LAST_UPDATE_TS = :RE-LAST-UPDATE-TS                        
MFA-TR*        WHERE RLSE_NO = :RE-RLSE-NO                                      
MFA-TR*          AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD                      
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8150'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_PREM_RLSE'      TO TABLE-1                      
              MOVE 'RLSE_NO'            TO TABLE-ELEMENT-1              
              MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-2              
              MOVE RE-RLSE-NO           TO HOSTVAR-ELEMENT-1            
              MOVE RE-REV-DISTRICT-CD   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8175-UPDATE-ORDER.                                               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_ORDER_INST                                  
                 SET RLSE_NO = :RE-RLSE-NO,                             
                     RLSE_DATE = CIS.CHAR2TIMESTAMP(:RE-RLSE-DATE)              
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                 AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                
                 AND METER_SUPPLYING = :LINK-SUPPLIES                   
                 AND PER_TEMP_IND = :VI-PER-TEMP-IND                    
                 AND HOLD_RELEASE = 'Y'                                 
                 AND EXISTS (                                           
                     SELECT 1                                           
                       FROM CSS_SO_DATA VO1,                            
                            CSS_PREMISE PR                              
                      WHERE VO1.SERV_ORDER_NO = :VO-SERV-ORDER-NO       
                        AND VO1.PREMISE_NO = PR.PREMISE_NO              
                        AND PR.REV_DISTRICT_CD = :LINK-REV-DISTRICT-CD) 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_ORDER_INST                                          
MFA-TR*          SET RLSE_NO = :RE-RLSE-NO,                                     
MFA-TR*              RLSE_DATE = :RE-RLSE-DATE                                  
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*          AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_SUPPLYING = :LINK-SUPPLIES                           
MFA-TR*          AND PER_TEMP_IND = :VI-PER-TEMP-IND                            
MFA-TR*          AND HOLD_RELEASE = 'Y'                                         
MFA-TR*          AND EXISTS (                                                   
MFA-TR*              SELECT 1                                                   
MFA-TR*                FROM CSS_SO_DATA VO1,                                    
MFA-TR*                     CSS_PREMISE PR                                      
MFA-TR*               WHERE VO1.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
MFA-TR*                 AND VO1.PREMISE_NO = PR.PREMISE_NO                      
MFA-TR*                 AND PR.REV_DISTRICT_CD = :LINK-REV-DISTRICT-CD)         
MFA-TR*       QUERYNO 8175                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MATCH-FL                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-MATCH-FL                              
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8175'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE 'RLSE_NO'        TO TABLE-ELEMENT-2             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   MOVE RE-RLSE-NO       TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8175-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-DELETE-RELEASE.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_PREM_RLSE                                 
               WHERE RLSE_NO = :RE-RLSE-NO                              
                 AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_PREM_RLSE                                         
MFA-TR*        WHERE RLSE_NO = :RE-RLSE-NO                                      
MFA-TR*          AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD                      
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREM_RLSE'       TO TABLE-1                     
              MOVE 'RLSE_NO'             TO TABLE-ELEMENT-1             
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-1             
              MOVE RE-RLSE-NO            TO HOSTVAR-ELEMENT-2           
              MOVE RE-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8250-DELETE-RLSE-DATA.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_PREM_RLSE_DATA                            
               WHERE RLSE_NO = :RE-RLSE-NO                              
                 AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD              
                 AND PREMISE_NO = :RP-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_PREM_RLSE_DATA                                    
MFA-TR*        WHERE RLSE_NO = :RE-RLSE-NO                                      
MFA-TR*          AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD                      
MFA-TR*          AND PREMISE_NO = :RP-PREMISE-NO                                
MFA-TR*       QUERYNO 8250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8250'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREM_RLSE_DATA'  TO TABLE-1                     
              MOVE 'RLSE_NO'             TO TABLE-ELEMENT-1             
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-1             
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-3             
              MOVE RE-RLSE-NO            TO HOSTVAR-ELEMENT-2           
              MOVE RE-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE RP-PREMISE-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
