       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04838.                                          
COB303 DATE-WRITTEN. FEBRUARY 3, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES LANDLORD INFORMATION FOR A PREMISE       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/03/15    FMB      PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04838'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04838 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLADRX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS0090A                                                  
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04838_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  S-ADDRESS-ID           PIC X(13) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ADDRESS-ID-CHAR       PIC X(13).                      
           05  WS-ADDRESS-ID-NUM        REDEFINES WS-ADDRESS-ID-CHAR    
                                        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-MASTER-ACCT-NO-CHAR   PIC X(13).                      
           05  WS-MASTER-ACCT-NO-NUM    REDEFINES WS-MASTER-ACCT-NO-CHAR
                                        PIC 9(13).                      
           05  WS-NEW-ADDR-ID-NUM       PIC 9(13).                      
           05  WS-NEW-ADDR-ID-CHAR      REDEFINES WS-NEW-ADDR-ID-NUM    
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04838'.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-MISC-INFO-FL          PIC X(01) VALUE SPACES.         
           05  WS-LANDLORD-FL           PIC X(01) VALUE SPACES.         
           05  WS-CUST-CHG-FL           PIC X(01) VALUE SPACES.         
           05  WS-LL-ON-OTHER-FL        PIC X(01) VALUE SPACES.         
           05  WS-NEW-ADDRESS-FL        PIC X(01) VALUE SPACES.         
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
           05  WS-ADDR-DEL-FLAG         PIC X(01) VALUE 'N'.            
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-6                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-7                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  SI-HOUSE-NO              PIC X(15) VALUE SPACES.         
           05  SI-ADDR-PREFIX-1         PIC X(03) VALUE SPACES.         
           05  SI-ADDR-PREFIX-2         PIC X(02) VALUE SPACES.         
           05  SI-STREET-NAME           PIC X(30) VALUE SPACES.         
           05  SI-STREET-LOCATION-1     PIC X(04) VALUE SPACES.         
           05  SI-STREET-LOCATION-2     PIC X(11) VALUE SPACES.         
           05  SI-STREET-SUFFIX         PIC X(04) VALUE SPACES.         
           05  SI-ADDRESS-OVERFLOW      PIC X(35) VALUE SPACES.         
           05  SI-ZIP-CODE              PIC X(05) VALUE SPACES.         
           05  SI-ZIP-CODE-PLUS-FOUR    PIC X(04) VALUE SPACES.         
           05  SI-ADDR-SUFFIX           PIC X(02) VALUE SPACES.         
           05  SI-USPS-DELIV-PT-CD      PIC X(02) VALUE SPACES.         
           05  SI-TOWN                  PIC X(26) VALUE SPACES.         
           05  SI-STATE                 PIC X(02) VALUE SPACES.         
           05  SI-ADDR-STREET           PIC X(55) VALUE SPACES.         
           05  SI-ADDR-CITY-STATE       PIC X(30) VALUE SPACES.         
           05  SI-ADDR-ZIP-CODE         PIC X(09) VALUE SPACES.         
           05  SI-ADDR-COUNTRY          PIC X(35) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE        PIC X(01).                           
       01  LINK-COMPANY-NO         PIC X(02).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-CODE-RENTAL-PROP   PIC X(01).                           
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-MASTER-ACCT-NO     PIC X(13).                           
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-ADDRESS-ID         PIC X(13).                           
       01  LINK-ADDRESS-FORMAT     PIC X(01).                           
       01  LINK-ADDR-STREET        PIC X(55).                           
       01  LINK-CITY-STATE         PIC X(30).                           
       01  LINK-FF-ZIP-CODE        PIC X(09).                           
       01  LINK-COUNTRY            PIC X(35).                           
       01  LINK-ADDRESS-OVERFLOW   PIC X(35).                           
       01  LINK-HOUSE-NO           PIC X(15).                           
       01  LINK-ADDR-PREFIX-1      PIC X(03).                           
       01  LINK-ADDR-PREFIX-2      PIC X(02).                           
       01  LINK-STREET-NAME        PIC X(30).                           
       01  LINK-STREET-LOCATION-1  PIC X(04).                           
       01  LINK-STREET-LOCATION-2  PIC X(11).                           
       01  LINK-STREET-SUFFIX      PIC X(04).                           
       01  LINK-ZIP-CODE           PIC X(05).                           
       01  LINK-ZIP-CODE-PLUS-FOUR PIC X(04).                           
       01  LINK-TOWN               PIC X(26).                           
       01  LINK-STATE              PIC X(02).                           
       01  LINK-ADDR-SUFFIX        PIC X(02).                           
       01  LINK-USPS-DELIV-PT-CD   PIC X(02).                           
       01  LINK-USERID             PIC X(07).                           
       01  LINK-COMMENTS           PIC X(210).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-UPDATE-TYPE                              
                          LINK-COMPANY-NO                               
                          LINK-PREMISE-NO                               
                          LINK-CODE-RENTAL-PROP                         
                          LINK-CUSTOMER-NO                              
                          LINK-MASTER-ACCT-NO                           
                          LINK-ACCOUNT-NO                               
                          LINK-ADDRESS-ID                               
                          LINK-ADDRESS-FORMAT                           
                          LINK-ADDR-STREET                              
                          LINK-CITY-STATE                               
                          LINK-FF-ZIP-CODE                              
                          LINK-COUNTRY                                  
                          LINK-ADDRESS-OVERFLOW                         
                          LINK-HOUSE-NO                                 
                          LINK-ADDR-PREFIX-1                            
                          LINK-ADDR-PREFIX-2                            
                          LINK-STREET-NAME                              
                          LINK-STREET-LOCATION-1                        
                          LINK-STREET-LOCATION-2                        
                          LINK-STREET-SUFFIX                            
                          LINK-ZIP-CODE                                 
                          LINK-ZIP-CODE-PLUS-FOUR                       
                          LINK-TOWN                                     
                          LINK-STATE                                    
                          LINK-ADDR-SUFFIX                              
                          LINK-USPS-DELIV-PT-CD                         
                          LINK-USERID                                   
                          LINK-COMMENTS.                                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE      AS RETURN_CODE,              
                       :S-ADDRESS-ID       AS ADDRESS_ID                
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE      AS RETURN_CODE,                      
MFA-TR*                :S-ADDRESS-ID       AS ADDRESS_ID                        
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-MASTER-ACCT-NO NOT NUMERIC                           
               MOVE ZEROES TO LINK-MASTER-ACCT-NO
           END-IF.                      
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-ADDRESS-ID NOT NUMERIC                               
               MOVE ZEROES TO LINK-ADDRESS-ID
           END-IF.                          
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE LINK-MASTER-ACCT-NO TO WS-MASTER-ACCT-NO-CHAR.          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-ADDRESS-ID TO WS-ADDRESS-ID-CHAR.                  
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           IF WS-ADDRESS-ID-NUM > ZEROES                                
               EVALUATE LINK-ADDRESS-FORMAT                             
                   WHEN 'A'                                             
                       MOVE WS-ADDRESS-ID-NUM TO DY-ADDRESS-ID          
                       PERFORM 7400-SELECT-FORMATTED THRU 7400-EXIT     
                       MOVE DY-HOUSE-NO TO LINK-HOUSE-NO                
                       MOVE DY-ADDR-PREFIX-1 TO LINK-ADDR-PREFIX-1      
                       MOVE DY-ADDR-PREFIX-2 TO LINK-ADDR-PREFIX-2      
                       MOVE DY-STREET-NAME TO LINK-STREET-NAME          
                       MOVE DY-STREET-SUFFIX TO LINK-STREET-SUFFIX      
                       MOVE DY-STREET-LOCATION-1 TO                     
                            LINK-STREET-LOCATION-1                      
                       MOVE DY-STREET-LOCATION-2 TO                     
                            LINK-STREET-LOCATION-2                      
                       MOVE DY-ZIP-CODE TO LINK-ZIP-CODE                
                       MOVE DY-ZIP-CODE-PLUS-FOUR TO                    
                            LINK-ZIP-CODE-PLUS-FOUR                     
                       MOVE DY-ADDR-SUFFIX TO LINK-ADDR-SUFFIX          
                       MOVE A4-TOWN TO LINK-TOWN                        
                       MOVE A4-STATE TO LINK-STATE                      
                       MOVE DY-USPS-DELIV-PT-CD TO LINK-USPS-DELIV-PT-CD
                       MOVE DY-ADDRESS-OVERFLOW TO LINK-ADDRESS-OVERFLOW
                   WHEN 'B'                                             
                       MOVE WS-ADDRESS-ID-NUM TO DZ-ADDRESS-ID          
                       PERFORM 7500-SELECT-FREEFORM THRU 7500-EXIT      
                       MOVE DZ-ADDR-STREET TO LINK-ADDR-STREET          
                       MOVE DZ-ADDR-CITY-STATE TO LINK-CITY-STATE       
                       MOVE DZ-ADDR-ZIP-CODE TO LINK-FF-ZIP-CODE        
                       MOVE DZ-ADDR-COUNTRY TO LINK-COUNTRY             
                       MOVE DZ-ADDRESS-OVERFLOW TO LINK-ADDRESS-OVERFLOW
               END-EVALUATE
           END-IF.                                            
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-CUSTOMER-NO.             
           MOVE PR-PREMISE-NO            TO MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL062'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-LANDLORD THRU 3000-EXIT          
               WHEN 'U'                                                 
                   PERFORM 3100-UPDATE-LANDLORD THRU 3100-EXIT          
               WHEN 'D'                                                 
                   PERFORM 3200-DELETE-LANDLORD THRU 3200-EXIT          
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-LANDLORD.                                            
                                                                        
           PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT.                  
           IF WS-ADDRESS-ID-NUM = ZEROES                                
               PERFORM 3010-CREATE-ADDRESS THRU 3010-EXIT               
               MOVE WS-NEW-ADDR-ID-NUM TO WS-ADDRESS-ID-NUM             
               MOVE WS-NEW-ADDR-ID-CHAR TO S-ADDRESS-ID
           END-IF.                
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           PERFORM 8300-UPDATE-PREMISE THRU 8300-EXIT.                  
           IF LINK-CODE-RENTAL-PROP = 'D' OR 'S'                        
              PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT               
              IF CU-LANDLORD-REVERT-FL = ' ' OR 'N'                     
                  PERFORM 5030-CUSTOMER-TRANSHIST THRU 5030-EXIT        
                  PERFORM 8400-UPDATE-CUSTOMER THRU 8400-EXIT
              END-IF
           END-IF.          
                                                                        
           MOVE PR-PREMISE-NO TO SI-PREMISE-NO.                         
           MOVE CU-CUSTOMER-NO TO SI-CUSTOMER-NO.                       
           MOVE LINK-ADDRESS-FORMAT TO SI-ADDRESS-FORMAT.               
           MOVE WS-ADDRESS-ID-NUM TO SI-ADDRESS-ID.                     
           MOVE WS-MASTER-ACCT-NO-NUM TO SI-LL-MASTER-ACCT-NO.          
           PERFORM 8125-INSERT-LANDLORD THRU 8125-EXIT.                 
                                                                        
           MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO.                       
           PERFORM 7300-SELECT-CUST-MISC THRU 7300-EXIT.                
           IF WS-MISC-INFO-FL = 'Y'                                     
               EVALUATE LQ-LANDLORD-FL                                  
                   WHEN 'Y'                                             
                       CONTINUE                                         
                   WHEN OTHER                                           
                       MOVE 'Y' TO WS-LANDLORD-FL                       
                       PERFORM 8810-UPDATE-CUST-MISC THRU 8810-EXIT     
               END-EVALUATE                                             
           ELSE                                                         
               PERFORM 8820-INSERT-CUST-MISC THRU 8820-EXIT
           END-IF.            
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-CREATE-ADDRESS.                                             
                                                                        
           MOVE 'Y' TO WS-NEW-ADDRESS-FL.                               
           PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT.              
           MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM.             
                                                                        
           EVALUATE LINK-ADDRESS-FORMAT                                 
               WHEN 'A'                                                 
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                   MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID             
                   MOVE LINK-TOWN TO A4-TOWN                            
                   MOVE LINK-STATE TO A4-STATE                          
                   MOVE LINK-ZIP-CODE TO A4-ZIP-CODE                    
                   PERFORM 7010-GET-TOKEN THRU 7010-EXIT                
                   MOVE LINK-HOUSE-NO TO DY-HOUSE-NO                    
                   MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1          
                   MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2          
                   MOVE LINK-STREET-NAME TO DY-STREET-NAME              
                   MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX          
                   MOVE LINK-STREET-LOCATION-1 TO DY-STREET-LOCATION-1  
                   MOVE LINK-STREET-LOCATION-2 TO DY-STREET-LOCATION-2  
                   MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX              
                   MOVE LINK-ZIP-CODE TO DY-ZIP-CODE                    
                   MOVE LINK-ZIP-CODE-PLUS-FOUR TO DY-ZIP-CODE-PLUS-FOUR
                   MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN          
                   MOVE 'F' TO DY-ADDR-USAGE-CD                         
                   MOVE LINK-ADDRESS-OVERFLOW TO DY-ADDRESS-OVERFLOW    
                   MOVE LINK-USPS-DELIV-PT-CD TO DY-USPS-DELIV-PT-CD    
                   PERFORM 8600-INSERT-FMT-ADDRESS THRU 8600-EXIT       
               WHEN 'B'                                                 
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
                   MOVE WS-NEW-ADDR-ID-NUM TO DZ-ADDRESS-ID             
                   MOVE LINK-ADDR-STREET TO DZ-ADDR-STREET              
                   MOVE LINK-CITY-STATE TO DZ-ADDR-CITY-STATE           
                   MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE            
                   MOVE LINK-COUNTRY TO DZ-ADDR-COUNTRY                 
                   MOVE LINK-ADDRESS-OVERFLOW TO DZ-ADDRESS-OVERFLOW    
                   PERFORM 8500-INSERT-FF-ADDRESS THRU 8500-EXIT        
           END-EVALUATE.                                                
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-LANDLORD.                                            
                                                                        
           PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT.                  
           PERFORM 7100-SELECT-LANDLORD THRU 7100-EXIT.                 
           IF SI-ADDRESS-ID > ZEROES                                    
               EVALUATE SI-ADDRESS-FORMAT                               
                   WHEN 'A'                                             
                       MOVE SI-ADDRESS-ID TO DY-ADDRESS-ID              
                       PERFORM 7400-SELECT-FORMATTED THRU 7400-EXIT     
                       MOVE DY-HOUSE-NO TO SI-HOUSE-NO                  
                       MOVE DY-ADDR-PREFIX-1 TO SI-ADDR-PREFIX-1        
                       MOVE DY-ADDR-PREFIX-2 TO SI-ADDR-PREFIX-2        
                       MOVE DY-STREET-NAME TO SI-STREET-NAME            
                       MOVE DY-STREET-SUFFIX TO SI-STREET-SUFFIX        
                       MOVE DY-STREET-LOCATION-1 TO SI-STREET-LOCATION-1
                       MOVE DY-STREET-LOCATION-2 TO SI-STREET-LOCATION-2
                       MOVE DY-ZIP-CODE TO SI-ZIP-CODE                  
                       MOVE DY-ZIP-CODE-PLUS-FOUR TO                    
                            SI-ZIP-CODE-PLUS-FOUR                       
                       MOVE DY-ADDR-SUFFIX TO SI-ADDR-SUFFIX            
                       MOVE A4-TOWN TO SI-TOWN                          
                       MOVE A4-STATE TO SI-STATE                        
                       MOVE DY-USPS-DELIV-PT-CD TO SI-USPS-DELIV-PT-CD  
                       MOVE DY-ADDRESS-OVERFLOW TO SI-ADDRESS-OVERFLOW  
                   WHEN 'B'                                             
                       MOVE SI-ADDRESS-ID TO DZ-ADDRESS-ID              
                       PERFORM 7500-SELECT-FREEFORM THRU 7500-EXIT      
                       MOVE DZ-ADDR-STREET TO SI-ADDR-STREET            
                       MOVE DZ-ADDR-CITY-STATE TO SI-ADDR-CITY-STATE    
                       MOVE DZ-ADDR-ZIP-CODE TO SI-ADDR-ZIP-CODE        
                       MOVE DZ-ADDR-COUNTRY TO SI-ADDR-COUNTRY          
                       MOVE DZ-ADDRESS-OVERFLOW TO SI-ADDRESS-OVERFLOW  
               END-EVALUATE
           END-IF.                                            
           INITIALIZE DCLCSS-ADDR-FORMATTED                             
                      DCLCSS-ADDR-FREEFORM.                             
           IF WS-ADDRESS-ID-NUM = ZEROES                                
               PERFORM 3010-CREATE-ADDRESS THRU 3010-EXIT               
               MOVE WS-NEW-ADDR-ID-NUM TO WS-ADDRESS-ID-NUM             
               MOVE WS-NEW-ADDR-ID-CHAR TO S-ADDRESS-ID
           END-IF.                
                                                                        
           PERFORM 5300-TRANSHIST-FOR-UPDATE THRU 5300-EXIT.            
                                                                        
           PERFORM 8300-UPDATE-PREMISE THRU 8300-EXIT.                  
           IF LINK-CODE-RENTAL-PROP = 'D' OR 'S'                        
               PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT              
               IF CU-LANDLORD-REVERT-FL = ' ' OR 'N'                    
                   PERFORM 5030-CUSTOMER-TRANSHIST THRU 5030-EXIT       
                   PERFORM 8400-UPDATE-CUSTOMER THRU 8400-EXIT
               END-IF
           END-IF.         
                                                                        
           IF WS-CUST-CHG-FL = 'Y'                                      
               MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO                    
               PERFORM 7300-SELECT-CUST-MISC THRU 7300-EXIT             
               IF WS-MISC-INFO-FL = 'Y'                                 
                   EVALUATE LQ-LANDLORD-FL                              
                       WHEN 'Y'                                         
                           CONTINUE                                     
                        WHEN OTHER                                      
                           MOVE 'Y' TO WS-LANDLORD-FL                   
                           PERFORM 8810-UPDATE-CUST-MISC THRU           
                                   8810-EXIT                            
                   END-EVALUATE                                         
               ELSE                                                     
                   PERFORM 8820-INSERT-CUST-MISC THRU 8820-EXIT         
               END-IF                                                   
               MOVE SI-CUSTOMER-NO TO LQ-CUSTOMER-NO                    
               PERFORM 7310-LL-ON-OTHER-PREMISE THRU 7310-EXIT          
               IF WS-LL-ON-OTHER-FL = 'N'                               
                   PERFORM 7300-SELECT-CUST-MISC   THRU 7300-EXIT       
                   IF WS-MISC-INFO-FL = 'Y'                             
                       MOVE 'N' TO WS-LANDLORD-FL                       
                       PERFORM 8810-UPDATE-CUST-MISC THRU 8810-EXIT     
                       PERFORM 8830-DELETE-NULL-MISC THRU 8830-EXIT
                   END-IF
               END-IF
           END-IF.    
                                                                        
           MOVE WS-ADDRESS-ID-NUM TO SI-ADDRESS-ID.                     
           MOVE LINK-ADDRESS-FORMAT TO SI-ADDRESS-FORMAT.               
           MOVE CU-CUSTOMER-NO TO SI-CUSTOMER-NO.                       
           MOVE WS-MASTER-ACCT-NO-NUM TO SI-LL-MASTER-ACCT-NO.          
           PERFORM 8150-UPDATE-LANDLORD THRU 8150-EXIT.                 
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-LANDLORD.                                            
                                                                        
           PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT.                  
           PERFORM 7100-SELECT-LANDLORD THRU 7100-EXIT.                 
           PERFORM 5100-TRANSHIST-FOR-DELETE THRU 5100-EXIT.            
                                                                        
           PERFORM 8300-UPDATE-PREMISE THRU 8300-EXIT.                  
           PERFORM 8200-DELETE-LANDLORD THRU 8200-EXIT.                 
           PERFORM 8700-UPDATE-ORDERS THRU 8700-EXIT.                   
           PERFORM 8800-UPDATE-ACCOUNT THRU 8800-EXIT.                  
                                                                        
           MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO.                       
           PERFORM 7310-LL-ON-OTHER-PREMISE THRU 7310-EXIT.             
           IF WS-LL-ON-OTHER-FL = 'N'                                   
               PERFORM 7300-SELECT-CUST-MISC THRU 7300-EXIT             
               IF WS-MISC-INFO-FL = 'Y'                                 
                   MOVE 'N' TO WS-LANDLORD-FL                           
                   PERFORM 8810-UPDATE-CUST-MISC THRU 8810-EXIT         
                   PERFORM 8830-DELETE-NULL-MISC THRU 8830-EXIT
               END-IF
           END-IF.        
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LINK-CUSTOMER-NO      TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'LL CUSTOMER NO '     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE LINK-CODE-RENTAL-PROP TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'REVERSION TYPE '     TO MI-COLUMN-DESC.                
           MOVE '59'                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           MOVE SPACES                TO MI-TABLE-ID.                   
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF WS-MASTER-ACCT-NO-NUM > ZEROES                            
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +13                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE WS-MASTER-ACCT-NO-CHAR TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'LL MASTER ACCT '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-NEW-ADDRESS-FL = 'Y'                                   
               EVALUATE LINK-ADDRESS-FORMAT                             
                   WHEN 'A'                                             
                       PERFORM 5010-FORMATTED-TRANSHIST THRU 5010-EXIT  
                   WHEN 'B'                                             
                       PERFORM 5020-FREEFORM-TRANSHIST THRU 5020-EXIT   
               END-EVALUATE                                             
           ELSE                                                         
               MOVE WS-TRAN-APPL-NO   TO MI-TRAN-APPL-NO                
               MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE '*NEW*'           TO MI-PRV-COLUMN-VALUE-TEXT       
               MOVE +75               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE WS-ADDRESS-LINE(1:75) TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE 'LL ADDRESS'      TO MI-COLUMN-DESC                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5010-FORMATTED-TRANSHIST.                                        
                                                                        
           IF LINK-HOUSE-NO > SPACES                                    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +15                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-HOUSE-NO          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'HOUSE NO'             TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-ADDR-PREFIX-1 > SPACES                               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +3                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ADDR-PREFIX-1     TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDR PREFIX 1'        TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-ADDR-PREFIX-2 > SPACES                               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +2                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ADDR-PREFIX-2     TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDR PREFIX 2'        TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-STREET-NAME > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +30                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-STREET-NAME       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'STREET NAME'          TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-STREET-LOCATION-1 > SPACES                           
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +4                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-STREET-LOCATION-1 TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'STREET LOC 1'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-STREET-LOCATION-2 > SPACES                           
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +11                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-STREET-LOCATION-2 TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'STREET LOC 2'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-STREET-SUFFIX > SPACES                               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +4                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-STREET-SUFFIX     TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'STREET SUFFIX'        TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-ADDR-SUFFIX > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +2                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ADDR-SUFFIX       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDRESS SUFFIX'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-ZIP-CODE > SPACES                                    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +5                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ZIP-CODE          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP CODE'             TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE A4-ZIP-CODE-TOKEN      TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP TOKEN'            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-ZIP-CODE-PLUS-FOUR > SPACES                          
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +4                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ZIP-CODE-PLUS-FOUR TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP CODE +4'          TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
           IF LINK-ADDRESS-OVERFLOW > SPACES                            
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +35                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ADDRESS-OVERFLOW  TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'OVERFLOW'             TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5020-FREEFORM-TRANSHIST.                                         
                                                                        
           IF LINK-ADDR-STREET > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +55                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ADDR-STREET       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDRESS STREET '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-CITY-STATE > SPACES                                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +30                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-CITY-STATE        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'CITY, STATE    '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-FF-ZIP-CODE > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-FF-ZIP-CODE       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP CODE '            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-COUNTRY > SPACES                                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +35                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-COUNTRY           TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'COUNTRY NAME   '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-ADDRESS-OVERFLOW > SPACES                            
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +35                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LINK-ADDRESS-OVERFLOW  TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDR OVERFLOW '       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5030-CUSTOMER-TRANSHIST.                                         
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-DATE-TRANS                                     
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO,                                     
MFA-TR*              :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE PF-RESP-AREA-ID           TO MH-RESP-AREA-ID.           
           MOVE ZEROES                    TO MH-ACCOUNT-NO.             
           MOVE CU-CUSTOMER-NO            TO MH-CUSTOMER-NO.            
           MOVE ZEROES                    TO MH-PREMISE-NO.             
           MOVE LINK-USERID               TO MH-USER-ID.                
           MOVE 'PANEL062'                TO MH-APPL-PROGRAM-ID.        
           MOVE WS-COMMENTS-LEN           TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-COMMENTS-TEXT          TO MH-TRAN-COMMENT-TEXT.      
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'Y'                       TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE CU-LANDLORD-REVERT-FL     TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'REVERT ELIGIBLE'         TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-DELETE.                                       
                                                                        
           MOVE '5100'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
           MOVE +9                         TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE +10                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE CU-CUSTOMER-NO             TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE '*DELETED*'                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE 'LL CUSTOMER    '          TO MI-COLUMN-DESC.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5300-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF SI-CUSTOMER-NO NOT = CU-CUSTOMER-NO                       
              MOVE 'Y'                 TO WS-CUST-CHG-FL                
              MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO               
              MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN       
                                          MI-PRV-COLUMN-VALUE-LEN       
              MOVE CU-CUSTOMER-NO      TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE SI-CUSTOMER-NO      TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE 'LL CUSTOMER NO'    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-CODE-RENTAL-PROP NOT = PR-CODE-RENTAL-PROP           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-CODE-RENTAL-PROP TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE PR-CODE-RENTAL-PROP   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REVERSION TYPE '     TO MI-COLUMN-DESC              
              MOVE '59'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              MOVE SPACES                TO MI-TABLE-ID                 
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-MASTER-ACCT-NO-NUM NOT = SI-LL-MASTER-ACCT-NO          
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +13                    TO MI-CHG-COLUMN-VALUE-LEN    
                                             MI-PRV-COLUMN-VALUE-LEN    
              MOVE WS-MASTER-ACCT-NO-CHAR TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE SI-LL-MASTER-ACCT-NO   TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'LL MASTER ACCT '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-ADDRESS-FORMAT NOT = SI-ADDRESS-FORMAT               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE LINK-ADDRESS-FORMAT   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SI-ADDRESS-FORMAT     TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LL ADDR FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ADDRESS-ID-NUM NOT = SI-ADDRESS-ID                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-ADDRESS-ID-CHAR    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SI-ADDRESS-ID         TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LL ADDRESS ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-HOUSE-NO NOT = LINK-HOUSE-NO                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-HOUSE-NO > SPACES                                 
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-HOUSE-NO      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-HOUSE-NO > SPACES                                   
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-HOUSE-NO        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-PREFIX-1 NOT = LINK-ADDR-PREFIX-1                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-1 > SPACES                            
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-1 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-PREFIX-1 > SPACES                              
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-PREFIX-1   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR PREFIX 1'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-PREFIX-2 NOT = LINK-ADDR-PREFIX-2                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-2 > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-2 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-PREFIX-2 > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-PREFIX-2   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR PREFIX 2'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-STREET-NAME NOT = LINK-STREET-NAME                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-NAME > SPACES                              
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-NAME   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-STREET-NAME > SPACES                                
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-STREET-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-STREET-SUFFIX NOT = LINK-STREET-SUFFIX                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-SUFFIX > SPACES                            
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-STREET-SUFFIX > SPACES                              
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-STREET-SUFFIX TO MI-PRV-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-SUFFIX NOT = LINK-ADDR-SUFFIX                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-SUFFIX > SPACES                              
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-SUFFIX   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-SUFFIX > SPACES                                
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-STREET-LOCATION-1 NOT = LINK-STREET-LOCATION-1         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOCATION-1 > SPACES                        
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOCATION-1 TO                         
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-STREET-LOCATION-1 > SPACES                          
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-STREET-LOCATION-1 TO                           
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 1'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-STREET-LOCATION-2 NOT = LINK-STREET-LOCATION-2         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOCATION-2 > SPACES                        
                 MOVE +11                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOCATION-2 TO                         
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-STREET-LOCATION-2 > SPACES                          
                 MOVE +11                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-STREET-LOCATION-2 TO                           
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 2'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-TOWN NOT = LINK-TOWN                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TOWN > SPACES                                     
                 MOVE +26                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TOWN          TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-TOWN > SPACES                                       
                 MOVE +26                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-TOWN            TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'TOWN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-STATE NOT = LINK-STATE                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STATE > SPACES                                    
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STATE         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-STATE > SPACES                                      
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-STATE           TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STATE'               TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ZIP-CODE NOT = LINK-ZIP-CODE                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE > SPACES                                 
                 MOVE +5                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ZIP-CODE > SPACES                                   
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ZIP-CODE        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ZIP-CODE-PLUS-FOUR NOT = LINK-ZIP-CODE-PLUS-FOUR       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE-PLUS-FOUR > SPACES                       
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE-PLUS-FOUR TO                        
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ZIP-CODE-PLUS-FOUR > SPACES                         
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ZIP-CODE-PLUS-FOUR TO                          
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP +4'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-USPS-DELIV-PT-CD NOT = LINK-USPS-DELIV-PT-CD           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-USPS-DELIV-PT-CD > SPACES                         
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-USPS-DELIV-PT-CD TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-USPS-DELIV-PT-CD > SPACES                           
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-USPS-DELIV-PT-CD TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-STREET NOT = LINK-ADDR-STREET                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-STREET > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-STREET   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-STREET > SPACES                                
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-STREET     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR STREET'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-CITY-STATE NOT = LINK-CITY-STATE                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-CITY-STATE > SPACES                               
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-CITY-STATE    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-CITY-STATE TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CITY STATE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-ZIP-CODE NOT = LINK-FF-ZIP-CODE                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-ZIP-CODE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDR-COUNTRY NOT = LINK-COUNTRY                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-COUNTRY > SPACES                                  
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-COUNTRY       TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDR-COUNTRY > SPACES                               
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDR-COUNTRY    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'COUNTRY'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF SI-ADDRESS-OVERFLOW NOT = LINK-ADDRESS-OVERFLOW           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDRESS-OVERFLOW > SPACES                         
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF SI-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE SI-ADDRESS-OVERFLOW TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OVERFLOW'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CODE_RENTAL_PROP                                  
                 INTO :PR-CODE-RENTAL-PROP                              
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_RENTAL_PROP                                          
MFA-TR*          INTO :PR-CODE-RENTAL-PROP                                      
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :LINK-COMPANY-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :LINK-COMPANY-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-3         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-3       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID,
              LOCAL_OFFICE                                       
                INTO :PF-RESP-AREA-ID,                                  
                     :PF-LOCAL-OFFICE                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID,                                              
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :PF-RESP-AREA-ID,                                          
MFA-TR*              :PF-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     LL_MASTER_ACCT_NO,                                 
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT                                     
                INTO :SI-CUSTOMER-NO,                                   
                     :SI-LL-MASTER-ACCT-NO,                             
                     :SI-ADDRESS-ID,                                    
                     :SI-ADDRESS-FORMAT                                 
                FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              LL_MASTER_ACCT_NO,                                         
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT                                             
MFA-TR*         INTO :SI-CUSTOMER-NO,                                           
MFA-TR*              :SI-LL-MASTER-ACCT-NO,                                     
MFA-TR*              :SI-ADDRESS-ID,                                            
MFA-TR*              :SI-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_LANDLORD                                               
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT LANDLORD_REVERT_FL                                 
                INTO :CU-LANDLORD-REVERT-FL                             
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LANDLORD_REVERT_FL                                         
MFA-TR*         INTO :CU-LANDLORD-REVERT-FL                                     
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7200'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_CUSTOMER'       TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-CUST-MISC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT LANDLORD_FL                                        
                INTO :LQ-LANDLORD-FL                                    
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LANDLORD_FL                                                
MFA-TR*         INTO :LQ-LANDLORD-FL                                            
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MISC-INFO-FL                          
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-MISC-INFO-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7300'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE LQ-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-LL-ON-OTHER-PREMISE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                         
                INTO :SI-PREMISE-NO                                     
                FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
             AND NOT PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*         INTO :SI-PREMISE-NO                                             
MFA-TR*         FROM CSS_LANDLORD                                               
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*      AND NOT PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-LL-ON-OTHER-FL                        
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-LL-ON-OTHER-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7310'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_LANDLORD'  TO TABLE-1                      
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE SI-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-FORMATTED.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              STREET_SUFFIX,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              ADDR_SUFFIX,
              USPS_DELIV_PT_CD,
              TOWN,
              STATE,
              ADDRESS_OVERFLOW,
              RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))               
                INTO :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-ADDR-SUFFIX,                                   
                     :DY-USPS-DELIV-PT-CD,                              
                     :A4-TOWN,                                          
                     :A4-STATE,                                         
                     :DY-ADDRESS-OVERFLOW,                              
                     :WS-ADDRESS-LINE                                   
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              USPS_DELIV_PT_CD,                                          
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE,                                                     
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                    
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                               
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                               
MFA-TR*              LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))                       
MFA-TR*         INTO :DY-HOUSE-NO,                                              
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-USPS-DELIV-PT-CD,                                      
MFA-TR*              :A4-TOWN,                                                  
MFA-TR*              :A4-STATE,                                                 
MFA-TR*              :DY-ADDRESS-OVERFLOW,                                      
MFA-TR*              :WS-ADDRESS-LINE                                           
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7400'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
                   MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                
                   MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-1              
                   MOVE DY-ADDRESS-ID   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-SELECT-FREEFORM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY,
              RTRIM(LTRIM(RTRIM(ADDR_STREET) + ' ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(ADDR_CITY_STATE) + 
           ' ' + LTRIM(RTRIM(ADDR_ZIP_CODE) + ' ' + LTRIM(RTRIM(
           ADDR_COUNTRY)))))))                    
                INTO :DZ-ADDR-STREET,                                   
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY,                                  
                     :WS-ADDRESS-LINE                                   
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY,                                              
MFA-TR*              RTRIM(LTRIM(RTRIM(ADDR_STREET) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(ADDR_CITY_STATE) || ' ' ||                     
MFA-TR*              LTRIM(RTRIM(ADDR_ZIP_CODE) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_COUNTRY)))))))                            
MFA-TR*         INTO :DZ-ADDR-STREET,                                           
MFA-TR*              :DZ-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DZ-ADDR-CITY-STATE,                                       
MFA-TR*              :DZ-ADDR-ZIP-CODE,                                         
MFA-TR*              :DZ-ADDR-COUNTRY,                                          
MFA-TR*              :WS-ADDRESS-LINE                                           
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7500'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-1              
                   MOVE DZ-ADDRESS-ID   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8125-INSERT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_LANDLORD                                  
                   ( PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
                     LL_MASTER_ACCT_NO,                                 
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT)                                    
              VALUES                                                    
                   (:SI-PREMISE-NO,                                     
                    :SI-CUSTOMER-NO,                                    
                    :SI-LL-MASTER-ACCT-NO,                              
                    :SI-ADDRESS-ID,                                     
                    :SI-ADDRESS-FORMAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8125'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE 'ADDRESS_FORMAT'     TO TABLE-ELEMENT-4              
              MOVE SI-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE SI-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              MOVE SI-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              MOVE SI-ADDRESS-FORMAT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8125-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8150-UPDATE-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_LANDLORD                                       
                 SET CUSTOMER_NO = :SI-CUSTOMER-NO,                     
                     LL_MASTER_ACCT_NO = :SI-LL-MASTER-ACCT-NO,         
                     ADDRESS_ID = :SI-ADDRESS-ID,                       
                     ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_LANDLORD                                               
MFA-TR*          SET CUSTOMER_NO = :SI-CUSTOMER-NO,                             
MFA-TR*              LL_MASTER_ACCT_NO = :SI-LL-MASTER-ACCT-NO,                 
MFA-TR*              ADDRESS_ID = :SI-ADDRESS-ID,                               
MFA-TR*              ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                        
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8150'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE 'ADDRESS_FORMAT'     TO TABLE-ELEMENT-4              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE SI-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              MOVE PR-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              MOVE PR-ADDRESS-FORMAT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-DELETE-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_LANDLORD                                  
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_LANDLORD                                          
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_LANDLORD'        TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-UPDATE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET CODE_RENTAL_PROP = :LINK-CODE-RENTAL-PROP          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*          SET CODE_RENTAL_PROP = :LINK-CODE-RENTAL-PROP                  
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 8300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_RENTAL_PROP'   TO TABLE-ELEMENT-2              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LINK-CODE-RENTAL-PROP TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-UPDATE-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUSTOMER                                       
                 SET LANDLORD_REVERT_FL = 'Y'                           
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER                                               
MFA-TR*          SET LANDLORD_REVERT_FL = 'Y'                                   
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8400'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_CUSTOMER'  TO TABLE-1                      
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE CU-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-INSERT-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
              VALUES                                                    
                   (:DZ-ADDRESS-ID,                                     
                    :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-ADDRESS-OVERFLOW)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
              MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
              MOVE 'ADDR_COUNTRY'       TO TABLE-ELEMENT-4              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-STREET       TO HOSTVAR-ELEMENT-2            
              MOVE DZ-ADDR-ZIP-CODE     TO HOSTVAR-ELEMENT-3            
              MOVE DZ-ADDR-COUNTRY      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-INSERT-FMT-ADDRESS.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                    (ADDRESS_ID,                                        
                     HOUSE_NO,                                          
                     ADDR_PREFIX_1,                                     
                     ADDR_PREFIX_2,                                     
                     STREET_NAME,                                       
                     STREET_LOCATION_1,                                 
                     STREET_LOCATION_2,                                 
                     STREET_SUFFIX,                                     
                     ZIP_CODE,                                          
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN,                                    
                     ADDR_SUFFIX,                                       
                     USPS_DELIV_PT_CD,                                  
                     ADDRESS_OVERFLOW,                                  
                     ADDR_USAGE_CD)                                     
              VALUES                                                    
                   (:DY-ADDRESS-ID,                                     
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-STREET-SUFFIX,                                  
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-ADDR-SUFFIX,                                    
                    :DY-USPS-DELIV-PT-CD,                               
                    :DY-ADDRESS-OVERFLOW,                               
                    :DY-ADDR-USAGE-CD)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8600'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'HOUSE_NO'           TO TABLE-ELEMENT-2              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-3              
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-4              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-HOUSE-NO          TO HOSTVAR-ELEMENT-2            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-3            
              MOVE DY-ZIP-CODE          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-UPDATE-ORDERS.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ORDER_REASON = 'F'                                
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND ORDER_REASON = 'R'                                
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET ORDER_REASON = 'F'                                        
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND ORDER_REASON = 'R'                                        
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*       QUERYNO 8700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8700'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'   TO TABLE-1                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID = 0,                                   
                      ADDRESS_FORMAT = ' '                              
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND ADDRESS_ID = :SI-ADDRESS-ID                       
                  AND ADDRESS_FORMAT = :SI-ADDRESS-FORMAT               
                  AND CODE_ACCT_STAT <> 'A'                             
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET ADDRESS_ID = 0,                                           
MFA-TR*               ADDRESS_FORMAT = ' '                                      
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND ADDRESS_ID = :SI-ADDRESS-ID                               
MFA-TR*           AND ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                       
MFA-TR*           AND CODE_ACCT_STAT ^= 'A'                                     
MFA-TR*       QUERYNO 88001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8800'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'   TO TABLE-1                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-2              
                   MOVE SI-ADDRESS-ID   TO HOSTVAR-ELEMENT-2            
                   MOVE 'ADDRESS_FMT'   TO TABLE-ELEMENT-3              
                   MOVE SI-ADDRESS-FORMAT TO HOSTVAR-ELEMENT-3          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ADDR_XREF                           
                WHERE ADDRESS_ID = :SI-ADDRESS-ID                       
                  AND ACCOUNT_NO IN                                     
                   (SELECT ACCOUNT_NO                                   
                      FROM CSS_ACCOUNT                                  
                    WHERE PREMISE_NO = :PR-PREMISE-NO                   
                      AND CODE_ACCT_STAT <> 'A')                        
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_BILL_ADDR_XREF                                   
MFA-TR*         WHERE ADDRESS_ID = :SI-ADDRESS-ID                               
MFA-TR*           AND ACCOUNT_NO IN                                             
MFA-TR*            (SELECT ACCOUNT_NO                                           
MFA-TR*               FROM CSS_ACCOUNT                                          
MFA-TR*             WHERE PREMISE_NO = :PR-PREMISE-NO                           
MFA-TR*               AND CODE_ACCT_STAT ^= 'A')                                
MFA-TR*       QUERYNO 88002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8800'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'   TO TABLE-1                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-2              
                   MOVE SI-ADDRESS-ID   TO HOSTVAR-ELEMENT-2            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8810-UPDATE-CUST-MISC.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_MISC_INFO                                
                  SET LANDLORD_FL = :WS-LANDLORD-FL                     
                WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_MISC_INFO                                        
MFA-TR*           SET LANDLORD_FL = :WS-LANDLORD-FL                             
MFA-TR*         WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                             
MFA-TR*       QUERYNO 8810                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8810'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                 ABEND-TABLES           
                   MOVE 'CSS_CUST_MISC_INFO'  TO TABLE-1                
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE CU-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8820-INSERT-CUST-MISC.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_MISC_INFO                            
                   ( CUSTOMER_NO,                                       
                     LANDLORD_FL)                                       
              VALUES                                                    
                   (:LQ-CUSTOMER-NO,                                    
                    'Y')                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8820'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8830-DELETE-NULL-MISC.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_MISC_INFO                            
               WHERE CUSTOMER_NO        =  :LQ-CUSTOMER-NO              
                 AND INFLUENTIAL_CUST   =  ' '                          
                 AND KEY_CUSTOMER       =  ' '                          
                 AND SPECIAL_CUST       =  ' '                          
                 AND CONSULTING_PROJECT =  ' '                          
                 AND CONSLT_PRJ_END_DT  IS NULL                         
                 AND LOSS_RESERVE_CD    =  0                            
                 AND LOSS_RESRVE_EFF_DT IS NULL                         
                 AND IVR_NDO_EXEMPT     = 'N'                           
                 AND BUILDER_FL         = 'N'                           
                 AND REALTOR_FL         = 'N'                           
                 AND LANDLORD_FL        = 'N'                           
                 AND DBA_NAME           = ' '                           
                 AND DBA_TAX_ID         = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND INTR_CO_IND        = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_MISC_INFO                                    
MFA-TR*        WHERE CUSTOMER_NO        =  :LQ-CUSTOMER-NO                      
MFA-TR*          AND INFLUENTIAL_CUST   =  ' '                                  
MFA-TR*          AND KEY_CUSTOMER       =  ' '                                  
MFA-TR*          AND SPECIAL_CUST       =  ' '                                  
MFA-TR*          AND CONSULTING_PROJECT =  ' '                                  
MFA-TR*          AND CONSLT_PRJ_END_DT  IS NULL                                 
MFA-TR*          AND LOSS_RESERVE_CD    =  0                                    
MFA-TR*          AND LOSS_RESRVE_EFF_DT IS NULL                                 
MFA-TR*          AND IVR_NDO_EXEMPT     = 'N'                                   
MFA-TR*          AND BUILDER_FL         = 'N'                                   
MFA-TR*          AND REALTOR_FL         = 'N'                                   
MFA-TR*          AND LANDLORD_FL        = 'N'                                   
MFA-TR*          AND DBA_NAME           = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND INTR_CO_IND        = ' '                                   
MFA-TR*       QUERYNO 8830                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8830'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE LQ-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8830-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00090                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
