       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04837.                                         
COB303 DATE-WRITTEN.  JANUARY 14, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES PREMISE INFORMATION.                     *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/14/15   FMB       NEW PROGRAM.                             *00290000
I01959*  11/11/15   FMB       DELETE CSS_PREM_DER_DET WHEN PREMISE IS  *00290000
I01959*                       DELETED.                                 *00290000
A05317*  02/18/16   FMB       INTERSECTIONS FROM MAP. DEFAULT WORK     *00290000
A05317*                       DISTRICTS ON A BAD GIS CALL.             *00290000
A05317*                       REMOVE CSS_SO_CODE_DESC CHECK FOR WORK   *00290000
A05317*                       DISTRICTS. WRITE TO CSS_SO_CLICK_PREM    *00290000
A05317*                       IF MISSING WORK DISTRICTS ONLY ON A GOOD *00290000
A05317*                       GIS CALL.                                *00290000
A05317*  3/7/2016   FMB       ZERO PREMISE NUMBER CHECK. FIX S0C7.     *        
A05317*  5/17/2016  FMB       COMMENT OUT WQ 359 LOGIC.                *        
A05317*  07/06/16   FMB       LEAK FREQUENCY EXCEPTIONS.               *        
A05317*  10/18/16   FMB       CATEGORY 601 (GIS DOWN) WQ IS HIGH.      *        
A05317*  12/05/16   FMB       DO NOT ALLOW UPDATE OF PSNC CITY GATE.   *        
A05317*                       DEFAULT COUNTY IF 000 RECEIVED FROM GIS. *        
A05317*  12/15/16   FMB       USE UT VALUE IF NO READ ROUTE ON PREMISE.*        
A05317*  01/05/17   FMB       NEAREST PREMISE FROM GIS IN INSERT       *        
A05317*                       TRANSHIST. USER TABLE UPDATE USER ID.    *        
A05317*  01/09/17   FMB       COMMENT OUT READ ROUTE UPDATE ROUTINE.   *        
A05317*  01/20/17   FMB       ADD FINAL LOCAL OFFICE DEFAULT.          *        
ACT006*  01/23/17   TP7R341   REPLACE CSS NAVIGATION.                  *        
ACT006*             A05744                                             *        
A05317*  02/22/17   FMB       HANDLE MULTIPLE SERVICE LINES ON A       *        
A05317*                       DELETE. FRANCHISE FEE MODS. ADD LOCATOR  *        
A05317*                       TO INSERT TRANSACTION HISTORY.           *        
A05317*  03/06/17   FMB       NEAREST PREMISE PROCESSING ONLY ON       *        
A05317*                       INSERT.                                  *        
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04837'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBCITGT                                           00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBZIPRTE                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBRVDST                                           00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBSTCNTY                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBSUBDVN                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBADRFMT                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00970000
              INCLUDE TBADDRID                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01010000
              INCLUDE TBZIPCD                                           01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01090000
              INCLUDE TBPRCNTL                                          01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01130000
              INCLUDE TBPREM                                            01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01170000
              INCLUDE TBMNHIST                                          01180000
           END-EXEC.                                                    01190000
           EXEC SQL                                                     01210000
              INCLUDE TBMNHDT                                           01220000
           END-EXEC.                                                    01230000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPSUB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNVGTN                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTXCNTL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTXRATE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTXUSE                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBFRNCRD                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSBLMSG                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLCOFRT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCLPREM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPRDERD                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
           COPY CWS00071.                                               01550000
           COPY CWS00019.                                               01550000
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWS0037F                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     01710000
              INCLUDE CWS0090A                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     01710000
              INCLUDE CWS00094                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     01750000
              INCLUDE CWS00099                                          01760000
           END-EXEC.                                                    01770000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                             
              INCLUDE CWS00077                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-NEAREST-PREM-NO-CHAR  PIC X(10).                      
           05  WS-NEAREST-PREM-NO-NUM                                   
               REDEFINES WS-NEAREST-PREM-NO-CHAR                        
                                        PIC 9(10).                      
           05  WS-NEW-PREMISE-NO-NUM    PIC 9(10).                      
           05  WS-NEW-PREMISE-NO-CHAR   REDEFINES WS-NEW-PREMISE-NO-NUM 
                                        PIC X(10).                      
           05  WS-NEW-ADDR-ID-NUM       PIC 9(13).                      
           05  WS-NEW-ADDR-ID-CHAR      REDEFINES WS-NEW-ADDR-ID-NUM    
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04837'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-COUNT                 PIC S9(04) COMP VALUE ZERO.     
           05  WS-SUBI                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUBO                  PIC S9(4) COMP VALUE 0.         
           05  WS-FO-STREET-LOCATION-2  PIC X(11) VALUE SPACES.         
           05  WS-PREMISE-NO            PIC S9(10) COMP-3 VALUE 0.      
           05  WS-DISPLAY-LAT-LONG      PIC +9(3).9(6).                 
           05  WS-DISPLAY-DDDC          PIC 9(9).9(4).                  
           05  WS-DISPLAY-READ-ROUTE    PIC 9(4).                       
           05  WS-DISPLAY-AGL-PREM-NO   PIC 9(9).                       
           05  WS-BOT-TEAM-MEMBER       PIC X(01) VALUE 'N'.            
           05  WS-NEW-SET-CONDITION     PIC X(01) VALUE 'N'.            
           05  WS-PENDING-ACCOUNT       PIC X(01) VALUE 'N'.            
           05  WS-ACTIVE-ACCOUNT        PIC X(01) VALUE 'N'.            
           05  WS-OTHER-ACCOUNT         PIC X(01) VALUE 'N'.            
COB305     05 WS-ACTIVE-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.             
COB305     05 WS-ACTIVE-CUST-NO        PIC S9(10)V COMP-3 VALUE 0.             
COB305     05 WS-PENDING-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.             
COB305     05 WS-PENDING-CUST-NO        PIC S9(10)V COMP-3 VALUE 0.             
           05  WS-PREM-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 PREM-CHANGED                    VALUE 'YES'.          
           05  WS-ADDR-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ADDR-CHANGED                    VALUE 'YES'.          
           05  WS-LOFC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 LOFC-CHANGED                    VALUE 'YES'.          
           05  WS-RDST-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 RDST-CHANGED                    VALUE 'YES'.          
           05  WS-SUBD-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 SUBD-CHANGED                    VALUE 'YES'.          
           05  WS-Q346-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 Q346-CHANGED                    VALUE 'YES'.          
           05  WS-ZIPC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ZIPC-CHANGED                    VALUE 'YES'.          
           05  WS-LALO-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 LALO-CHANGED                    VALUE 'YES'.          
           05  WS-DDDC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 DDDC-CHANGED                    VALUE 'YES'.          
           05  WS-RRTE-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 RRTE-CHANGED                    VALUE 'YES'.          
           05  WS-ZT-EXISTS-FLAG        PIC X(03) VALUE 'NO '.          
               88 ZT-EXISTS                       VALUE 'YES'.          
               88 ZT-NOT-EXIST                    VALUE 'NO '.          
           05  WS-ZS-EXISTS-FLAG        PIC X(03) VALUE 'NO '.          
               88 ZS-EXISTS                       VALUE 'YES'.          
               88 ZS-NOT-EXIST                    VALUE 'NO '.          
           05  WS-PO-BOX-FLAG           PIC X(03) VALUE 'NO '.          
               88 PO-BOX                          VALUE 'YES'.          
               88 NOT-PO-BOX                      VALUE 'NO '.          
           05  WS-GIS-STATUS            PIC X(01) VALUE ' '.            
               88 GIS-SUCCESS                     VALUE '0'.            
               88 GIS-NOT-FOUND                   VALUE '1'.            
               88 GIS-DOWN                        VALUE '2'.            
               88 GIS-NOT-CALLED                  VALUE '3'.            
           05  WS-SUBDIV-CODE-FROM      PIC X(03) VALUE SPACES.         
           05  WS-SUBDIV-CODE-TO        PIC X(03) VALUE SPACES.         
           05  WS-DIRECTIONS.                                           
               10 WS-DIRECTIONS-LEN     PIC S9(4) COMP.                 
               10 WS-DIRECTIONS-TEXT    PIC X(255).                     
           05  WS-SCRATCH-PAD.                                          
               10 WS-SCRATCH-PAD-LEN    PIC S9(4) COMP.                 
               10 WS-SCRATCH-PAD-TEXT   PIC X(255).                     
           05  WS-SPECIAL-INSTRUCTIONS.                                 
               10 WS-SPECIAL-LEN        PIC S9(4) COMP.                 
               10 WS-SPECIAL-TEXT       PIC X(255).                     
           05  WS-SPECIAL-READ-INSTRUCTIONS.                            
               10 WS-SPECIAL-READ-LEN   PIC S9(4) COMP.                 
               10 WS-SPECIAL-READ-TEXT  PIC X(114).                     
           05  WS-FM-ELEC-SVC-WKDIST.                                   
               10 WS-FM-ELEC-SVC-WKDIST-LEN  PIC S9(4) COMP.            
               10 WS-FM-ELEC-SVC-WKDIST-TEXT PIC X(40).                 
           05  WS-FM-GAS-OPS-WKDIST.                                    
               10 WS-FM-GAS-OPS-WKDIST-LEN   PIC S9(4) COMP.            
               10 WS-FM-GAS-OPS-WKDIST-TEXT  PIC X(40).                 
           05  WS-FM-FLD-SVCS-WKDIST.                                   
               10 WS-FM-FLD-SVCS-WKDIST-LEN  PIC S9(4) COMP.            
               10 WS-FM-FLD-SVCS-WKDIST-TEXT PIC X(40).                 
           05  WS-FM-REV-PRT-WKDIST.                                    
               10 WS-FM-REV-PRT-WKDIST-LEN   PIC S9(4) COMP.            
               10 WS-FM-REV-PRT-WKDIST-TEXT PIC X(40).                  
           05  WS-FM-DSM-ESVC-WKDIST.                                   
               10 WS-FM-DSM-ESVC-WKDIST-LEN  PIC S9(4) COMP.            
               10 WS-FM-DSM-ESVC-WKDIST-TEXT PIC X(40).                 
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
A05317     05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ZIPCODE-COUNT       PIC S9(4) COMP VALUE 0.           
           05  WS-CLICK-PREM-FL       PIC X(01) VALUE SPACES.           
A05317     05  WS-AMPERSAND-CT        PIC S9(02) COMP-3 VALUE 0.        
A05317     05  WS-AMPERSAND-FL        PIC X(01) VALUE SPACES.           
A05317     05  WS-STREET-NAME         PIC X(30) VALUE SPACES.           
A05317     05  WS-LEAK-EXCEP-FL       PIC X(01) VALUE SPACES.           
                                                                        
       01  WS-WQ-DATA.                                                  
           05  WS-WQ-COMMENTS-346       PIC X(250) VALUE                
               'ADDRESS CHANGES HAVE BEEN MADE FOR THIS PREMISE.VERIFY C        
      -        'HANGES ARE CORRECT AND UPDATE SERVICE CARD.'.                   
           05  WS-REVDIST-WQ-MSG-P      PIC X(250) VALUE                
               'REVENUE DISTRICT CHANGED ON PENDING ACCOUNT.  INVESTIGAT        
      -        'E AND CORRECT IF NEEDED.'.                                      
           05  WS-REVDIST-WQ-MSG-A      PIC X(250) VALUE                
               'REVENUE DISTRICT CHANGED ON ACTIVE  ACCOUNT.  INVESTIGAT        
      -        'E AND CORRECT IF NEEDED.'.                                      
           05  WS-REVDIST-WQ-MSG-B      PIC X(250) VALUE                
               'REVENUE DISTRICT CHANGED ON ACTIVE AND PENDING ACCOUNT.         
      -        'INVESTIGATE AND CORRECT IF NEEDED.'.                            
           05  WS-REVDIST-WQ-MSG-F      PIC X(250) VALUE                
               'REVENUE DISTRICT CHANGED ON FINALED ACCOUNT.  INVESTIGAT        
      -        'E AND CORRECT IF NEEDED.'.                                      
           05  WS-REVDIST-WQ-MSG-W      PIC X(250) VALUE                
               'REVENUE DISTRICT CHANGED ON WRITE OFF ACCOUNT.  INVESTIG        
      -        'ATE AND CORRECT IF NEEDED.'.                                    
           05  WS-REVDIST-WQ-MSG-I      PIC X(250) VALUE                
               'REVENUE DISTRICT CHANGED ON INACTIVE  ACCOUNT.  INVESTIG        
      -        'ATE AND CORRECT IF NEEDED.'.                                    
           05  WS-LOCOFF-WQ-MSG         PIC X(045) VALUE                
               'LOCAL OFFICE CHANGED.  VALIDATE SUBDIVISION.'.          
           05  WS-GIS-DOWN-WQ-MSG         PIC X(060) VALUE              
A05317         'GIS DOWN. DEFAULT DATA USED. PLEASE INVESTIGATE ASAP.'. 
           05  WS-SUBDIV-WQ-MSG.                                        
               10  F                    PIC X(30) VALUE                 
               'SUBDIVISION NAME CHANGED FROM '.                        
               10  WS-SUBDIV-WQ-FROM    PIC X(24).                      
               10  F                    PIC X(03) VALUE 'TO '.          
               10  WS-SUBDIV-WQ-TO      PIC X(24).                      
               10  F                    PIC X(02) VALUE '. '.           
               10  F                    PIC X(30) VALUE                 
               'LIGHTING CHARGE CHANGED FROM '.                         
               10 WS-SUBDIV-AMT-FROM   PIC Z9.99.                       
               10  F                    PIC X(04) VALUE ' TO '.         
               10 WS-SUBDIV-AMT-TO     PIC Z9.99.                       
               10  F                    PIC X(01) VALUE '.'.            
               10  WS-ACTIVE-MSG       PIC X(18).                       
               10 WS-DATE-ACTIVE.                                       
                  15 WS-CREATE-MM      PIC 9(02).                       
                  15 F                 PIC X(01) VALUE '/'.             
                  15 WS-CREATE-DD      PIC 9(02).                       
                  15 F                 PIC X(01) VALUE '/'.             
                  15 WS-CREATE-YR      PIC 9(04).                       
           05  WS-GIS-MISMATCH-WQ-MSG.                                  
               10 F                    PIC X(45) VALUE                  
                 'COMBO DATA FROM GIS NOT FOUND-ADD TO TABLES '.        
               10 F                    PIC X(04) VALUE 'ZIP '.          
               10 WS-WQ-ZIP            PIC X(05).                       
               10 F                    PIC X(04) VALUE ' LO '.          
               10 WS-WQ-LO             PIC X(03).                       
               10 F                    PIC X(07) VALUE ' ROUTE '.       
               10 WS-WQ-ROUTE          PIC 9(04).                       
               10 F                    PIC X(10) VALUE ' REV DIST '.    
               10 WS-WQ-REV-DIST       PIC X(03).                       
               10 F                    PIC X(06) VALUE ' SUBD '.        
               10 WS-WQ-SUBD           PIC X(03).                       
                                                                        
       01  WS-MCSCB077-OUTPUT.                                          
           05  WS-MCSCB077-RET-CODE        PIC S9(09) COMP VALUE 0.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-PREMISE-NO           PIC X(10) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSR00647-CALL-DATA.                                          
           05  ACCOUNT-NO-0647           PIC X(13) VALUE SPACES.        
           05  PREMISE-NO-0647           PIC X(10) VALUE SPACES.        
           05  REV-DISTRICT-0647         PIC X(03) VALUE SPACES.        
           05  USERID-0647               PIC X(07) VALUE SPACES.        
                                                                        
       01  CSR00647-RETURN-DATA.                                        
           05  RETURN-CODE-0647          PIC S9(9) COMP VALUE 0.        
                                                                        
      *01 LOC0647 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) COMP.                
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) COMP.                
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) COMP.                
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) COMP.                
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0647 CURSOR
MSQ001          FOR CALL CSR00647                                             
                  ( :ACCOUNT-NO-0647
                  , :PREMISE-NO-0647
                  , :REV-DISTRICT-0647
                  , :USERID-0647
                  )
MSQ001        END-EXEC.
        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-ADDR-USAGE-CD       PIC X(01).                          
       01  LINK-HOUSE-NO            PIC X(15).                          
       01  LINK-ADDR-PREFIX-1       PIC X(03).                          
       01  LINK-ADDR-PREFIX-2       PIC X(02).                          
       01  LINK-STREET-NAME         PIC X(30).                          
       01  LINK-STREET-SUFFIX       PIC X(04).                          
       01  LINK-ADDR-SUFFIX         PIC X(02).                          
       01  LINK-STREET-LOC-1        PIC X(04).                          
       01  LINK-STREET-LOC-2        PIC X(11).                          
       01  LINK-ZIP-CODE            PIC X(05).                          
       01  LINK-ZIP-CODE-PLUS-FOUR  PIC X(04).                          
       01  LINK-TOWN                PIC X(26).                          
       01  LINK-DELIVERY-POINT      PIC X(02).                          
       01  LINK-ADDRESS-OVERFLOW    PIC X(35).                          
       01  LINK-LOCAL-OFFICE        PIC X(03).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
       01  LINK-SUBDIVISION-ID      PIC X(03).                          
       01  LINK-LOT                 PIC X(05).                          
       01  LINK-BLOCK               PIC X(05).                          
       01  LINK-COUNTY              PIC X(03).                          
       01  LINK-LOCATOR-ID          PIC X(09).                          
       01  LINK-CITY-GATE-ID        PIC X(07).                          
       01  LINK-READ-ROUTE          PIC S9(4) COMP.                     
       01  LINK-LEAK-SURVEY-DT      PIC X(10).                          
       01  LINK-LEAK-SURVEY-FREQ    PIC X(02).                          
       01  LINK-REV-DISTRICT        PIC X(03).                          
       01  LINK-CROSS-STREET-1      PIC X(35).                          
       01  LINK-CROSS-STREET-2      PIC X(35).                          
COB305 01 LINK-LATITUDE        PIC S9(3)V9(6) COMP-3 VALUE 0.              
COB305 01 LINK-LONGITUDE        PIC S9(3)V9(6) COMP-3 VALUE 0.              
COB305 01 LINK-AGL-PREMISE-NO        PIC S9(9)V COMP-3 VALUE 0.                 
       01  LINK-DIRECTIONS          PIC X(255).                         
       01  LINK-SCRATCH-PAD         PIC X(255).                         
       01  LINK-SPECIAL-INST        PIC X(255).                         
       01  LINK-SPECIAL-READ-INST   PIC X(114).                         
       01  LINK-DATE-SPCL-MSG-ENDS  PIC X(10).                          
       01  LINK-FM-ELEC-SVC-WKDIST  PIC X(40).                          
       01  LINK-FM-GAS-OPS-WKDIST   PIC X(40).                          
       01  LINK-FM-FLD-SVCS-WKDIST  PIC X(40).                          
       01  LINK-FM-REV-PRT-WKDIST   PIC X(40).                          
       01  LINK-FM-DSM-ESVC-WKDIST  PIC X(40).                          
COB305 01 LINK-DDDC-FCTR        PIC S9(9)V9(4) COMP-3 VALUE 0.              
       01  LINK-SEB-ENVRNMT         PIC X(01).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
       01  LINK-STATE               PIC X(02).                          
       01  LINK-NEAREST-PREM-NO     PIC X(10).                          
       01  LINK-GIS-STATUS-CD       PIC S9(4) COMP.                     
       01  LINK-ADDRESS-SOURCE      PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-UPDATE-TYPE                              
                          LINK-PREMISE-NO                               
                          LINK-ADDR-USAGE-CD                            
                          LINK-HOUSE-NO                                 
                          LINK-ADDR-PREFIX-1                            
                          LINK-ADDR-PREFIX-2                            
                          LINK-STREET-NAME                              
                          LINK-STREET-SUFFIX                            
                          LINK-ADDR-SUFFIX                              
                          LINK-STREET-LOC-1                             
                          LINK-STREET-LOC-2                             
                          LINK-ZIP-CODE                                 
                          LINK-ZIP-CODE-PLUS-FOUR                       
                          LINK-TOWN                                     
                          LINK-DELIVERY-POINT                           
                          LINK-ADDRESS-OVERFLOW                         
                          LINK-LOCAL-OFFICE                             
                          LINK-COMPANY-NO                               
                          LINK-SUBDIVISION-ID                           
                          LINK-LOT                                      
                          LINK-BLOCK                                    
                          LINK-COUNTY                                   
                          LINK-LOCATOR-ID                               
                          LINK-CITY-GATE-ID                             
                          LINK-READ-ROUTE                               
                          LINK-LEAK-SURVEY-DT                           
                          LINK-LEAK-SURVEY-FREQ                         
                          LINK-REV-DISTRICT                             
                          LINK-CROSS-STREET-1                           
                          LINK-CROSS-STREET-2                           
                          LINK-LATITUDE                                 
                          LINK-LONGITUDE                                
                          LINK-AGL-PREMISE-NO                           
                          LINK-DIRECTIONS                               
                          LINK-SCRATCH-PAD                              
                          LINK-SPECIAL-INST                             
                          LINK-SPECIAL-READ-INST                        
                          LINK-DATE-SPCL-MSG-ENDS                       
                          LINK-FM-ELEC-SVC-WKDIST                       
                          LINK-FM-GAS-OPS-WKDIST                        
                          LINK-FM-FLD-SVCS-WKDIST                       
                          LINK-FM-REV-PRT-WKDIST                        
                          LINK-FM-DSM-ESVC-WKDIST                       
                          LINK-DDDC-FCTR                                
                          LINK-SEB-ENVRNMT                              
                          LINK-USERID                                   
                          LINK-COMMENTS                                 
                          LINK-STATE                                    
                          LINK-NEAREST-PREM-NO                          
                          LINK-GIS-STATUS-CD                            
                          LINK-ADDRESS-SOURCE.                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE,                  
                       :RS-PREMISE-NO AS PREMISE_NO                     
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE,                          
MFA-TR*                :RS-PREMISE-NO AS PREMISE_NO                             
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-NEAREST-PREM-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-NEAREST-PREM-NO
           END-IF.                     
                                                                        
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           MOVE LINK-DIRECTIONS TO WS-DIRECTIONS.                       
           MOVE LINK-SCRATCH-PAD TO WS-SCRATCH-PAD.                     
           MOVE LINK-SPECIAL-INST TO WS-SPECIAL-INSTRUCTIONS.           
           MOVE LINK-SPECIAL-READ-INST TO WS-SPECIAL-READ-INSTRUCTIONS. 
           IF WS-SPECIAL-READ-TEXT = SPACES                             
               MOVE SPACES TO LINK-DATE-SPCL-MSG-ENDS
           END-IF.                  
           MOVE LINK-FM-ELEC-SVC-WKDIST TO WS-FM-ELEC-SVC-WKDIST.       
           MOVE LINK-FM-GAS-OPS-WKDIST TO WS-FM-GAS-OPS-WKDIST.         
           MOVE LINK-FM-FLD-SVCS-WKDIST TO WS-FM-FLD-SVCS-WKDIST.       
           MOVE LINK-FM-REV-PRT-WKDIST TO WS-FM-REV-PRT-WKDIST.         
           MOVE LINK-FM-DSM-ESVC-WKDIST TO WS-FM-DSM-ESVC-WKDIST.       
           MOVE LINK-NEAREST-PREM-NO TO WS-NEAREST-PREM-NO-CHAR.        
                                                                        
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '!' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '@' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '#' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '$' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '%' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '^' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '[' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL ']' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '{' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '}' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '|' BY ' '.       
           INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL '`' BY ' '.       
                                                                        
      * OLD VALUE IS NEWLINE - HEX 0A                                           
BIN001*    INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL ' ' BY ' '.               
BIN001     INSPECT WS-SPECIAL-READ-TEXT REPLACING ALL X'0A' BY ' '.
BIN001*    INSPECT WS-SPECIAL-TEXT        REPLACING ALL ' ' BY ' '.             
BIN001     INSPECT WS-SPECIAL-TEXT        REPLACING ALL X'0A' BY ' '.
BIN001*    INSPECT WS-DIRECTIONS-TEXT     REPLACING ALL ' ' BY ' '.             
BIN001     INSPECT WS-DIRECTIONS-TEXT     REPLACING ALL X'0A' BY ' '.
BIN001*    INSPECT WS-SCRATCH-PAD-TEXT    REPLACING ALL ' ' BY ' '.             
BIN001     INSPECT WS-SCRATCH-PAD-TEXT    REPLACING ALL X'0A' BY ' '.
                                                                        
           INSPECT LINK-ADDRESS-OVERFLOW REPLACING ALL '~' BY '-'.      
           INSPECT LINK-HOUSE-NO REPLACING ALL '~' BY '-'.              
           INSPECT LINK-STREET-LOC-2 REPLACING ALL '~' BY '-'.          
           INSPECT LINK-STREET-NAME REPLACING ALL '~' BY '-'.           
           IF LINK-STREET-LOC-1 = '#'                                   
               MOVE 'APT' TO LINK-STREET-LOC-1
           END-IF.                         
           IF LINK-COMPANY-NO = '26' AND                                
              LINK-LOCATOR-ID <= SPACES                                 
                  MOVE 'PF0011111' TO LINK-LOCATOR-ID
           END-IF.                  
           IF LINK-SUBDIVISION-ID = '000'                               
               MOVE 'ZZY' TO LINK-SUBDIVISION-ID
           END-IF.                       
                                                                        
           IF WS-FM-ELEC-SVC-WKDIST-TEXT <= SPACES AND                  
              WS-FM-GAS-OPS-WKDIST-TEXT <= SPACES AND                   
              WS-FM-FLD-SVCS-WKDIST-TEXT <= SPACES AND                  
              WS-FM-REV-PRT-WKDIST-TEXT <= SPACES AND                   
              WS-FM-DSM-ESVC-WKDIST-TEXT <= SPACES AND                  
A05317        LINK-GIS-STATUS-CD = +1                                   
                 MOVE 'Y' TO WS-CLICK-PREM-FL
           END-IF.                          
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7100-DELINQUENCY THRU 7100-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 7090-CHECK-SECURITY THRU 7090-EXIT.                  
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
           IF LINK-UPDATE-TYPE NOT = 'D'                                
               MOVE LINK-TOWN TO A4-TOWN                                
               MOVE LINK-STATE TO A4-STATE                              
               MOVE LINK-ZIP-CODE TO A4-ZIP-CODE                        
               PERFORM 7060-GET-TOKEN THRU 7060-EXIT
           END-IF.                   
                                                                        
           IF WS-NEAREST-PREM-NO-NUM > ZEROES AND                       
A05317        LINK-UPDATE-TYPE = 'I'                                    
                  MOVE WS-NEAREST-PREM-NO-NUM TO UT-PREMISE-NO          
                  PERFORM 7310-PREM-READ-ROUTE THRU 7310-EXIT           
                  MOVE UT-READ-ROUTE TO LINK-READ-ROUTE                 
A05317            MOVE PR-CITY-GATE-ID TO LINK-CITY-GATE-ID
           END-IF.            
                                                                        
           IF LINK-UPDATE-TYPE = 'I' AND                                
              LINK-GIS-STATUS-CD = +1 AND                               
            ((LINK-LOCAL-OFFICE = '000' OR SPACES) OR                   
             (LINK-REV-DISTRICT = '000' OR SPACES))                     
                 MOVE 0 TO LINK-GIS-STATUS-CD
           END-IF.                          
                                                                        
      * +1 = SUCCESS                                                            
      *  0 = NOT FOUND                                                          
      * -1 = GIS DOWN                                                           
      * -2 = GIS NOT CALLED                                                     
                                                                        
           EVALUATE LINK-GIS-STATUS-CD                                  
              WHEN 1                                                    
                  MOVE '0' TO WS-GIS-STATUS                             
              WHEN 0                                                    
                  MOVE '1' TO WS-GIS-STATUS                             
              WHEN -1                                                   
                  MOVE '2' TO WS-GIS-STATUS                             
              WHEN -2                                                   
                  MOVE '3' TO WS-GIS-STATUS                             
           END-EVALUATE.                                                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL077'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-PREMISE THRU 3000-EXIT           
               WHEN 'U'                                                 
A05317             IF WS-PREMISE-NO-NUM > ZEROES                        
                       PERFORM 3100-UPDATE-PREMISE THRU 3100-EXIT       
A05317             END-IF                                               
               WHEN 'D'                                                 
A05317             IF WS-PREMISE-NO-NUM > ZEROES                        
                       PERFORM 3200-DELETE-PREMISE THRU 3200-EXIT       
A05317             END-IF                                               
               WHEN OTHER                                               
                   PERFORM 3300-INVALID-ACTION THRU 3300-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * GIS PROVIDES FIELDS FOR FORMATTED AND INTERSECTION.             09410000
      * IF GIS IS DOWN, DEFAULTS ARE USED.                              09410000
      * DEFAULTS ARE USED FOR PO BOX ADDRESSES.                         09410000
                                                                        
       3000-INSERT-PREMISE.                                             
                                                                        
A05317     IF LINK-ADDRESS-SOURCE = 'M'                                 
A05317         MOVE LINK-STREET-NAME TO WS-STREET-NAME                  
A05317         INSPECT WS-STREET-NAME TALLYING WS-AMPERSAND-CT          
A05317             FOR ALL '&'                                          
A05317         IF WS-AMPERSAND-CT > 0                                   
A05317             MOVE 'I' TO LINK-ADDR-USAGE-CD                       
A05317             PERFORM 3020-PARSE-INTERSECTION THRU 3020-EXIT
               END-IF
           END-IF.      
                                                                        
           EVALUATE LINK-ADDR-USAGE-CD                                  
               WHEN 'F'                                                 
               WHEN 'I'                                                 
                   CONTINUE                                             
               WHEN 'P'                                                 
                  MOVE 'YES' TO WS-PO-BOX-FLAG                          
                  MOVE 'F' TO LINK-ADDR-USAGE-CD                        
           END-EVALUATE.                                                
                                                                        
           IF PO-BOX                                                    
               MOVE 'ZZY' TO LINK-SUBDIVISION-ID
           END-IF.                       
                                                                        
           IF LINK-SUBDIVISION-ID <= SPACES AND                         
              CSR-DATABASE                                              
                  MOVE 'ZZY' TO LINK-SUBDIVISION-ID
           END-IF.                    
                                                                        
           IF CSR-DATABASE AND                                          
             (GIS-NOT-FOUND OR                                          
              GIS-DOWN OR                                               
              GIS-NOT-CALLED)                                           
                  MOVE LINK-ZIP-CODE TO ZT-ZIP-CODE                     
                  PERFORM 7000-GIS-DEFAULTS THRU 7000-EXIT              
                  MOVE ZT-LOCAL-OFFICE TO LINK-LOCAL-OFFICE             
                  MOVE ZT-REV-DISTRICT-CD TO LINK-REV-DISTRICT          
A05317            PERFORM 7320-DEFAULT-WORK-DISTRICTS THRU 7320-EXIT
           END-IF.   
                                                                        
           IF SEB-DATABASE                                              
               EVALUATE LINK-SEB-ENVRNMT                                
                   WHEN 'D'                                             
                       PERFORM 7075-SELECT-DEREG-LOCAL-OFFICE THRU      
                               7075-EXIT                                
                   WHEN 'R'                                             
                       PERFORM 7070-SELECT-REG-LOCAL-OFFICE THRU        
                               7070-EXIT                                
               END-EVALUATE                                             
               MOVE B1-LOCAL-OFFICE TO LINK-LOCAL-OFFICE                
                                       ZT-LOCAL-OFFICE                  
               MOVE LINK-ZIP-CODE TO ZT-ZIP-CODE                        
               PERFORM 7150-SEB-REV-DISTRICT THRU 7150-EXIT             
               MOVE ZT-REV-DISTRICT-CD TO LINK-REV-DISTRICT
           END-IF.            
                                                                        
      *    IF CSR-DATABASE AND                                                  
      *       LINK-READ-ROUTE = ZEROES                                          
      *           MOVE LINK-ZIP-CODE TO ZT-ZIP-CODE                             
      *           MOVE LINK-LOCAL-OFFICE TO ZT-LOCAL-OFFICE                     
      *           MOVE LINK-REV-DISTRICT TO ZT-REV-DISTRICT-CD                  
      *           PERFORM 7010-DEFAULT-READ-ROUTE THRU 7010-EXIT                
      *           MOVE ZT-READ-ROUTE TO LINK-READ-ROUTE.                        
                                                                        
           EVALUATE LINK-COMPANY-NO                                     
               WHEN '26'                                                
                   MOVE '2999999' TO LINK-CITY-GATE-ID                  
               WHEN OTHER                                               
                   IF SEB-DATABASE                                      
                       MOVE 'AGL' TO LINK-CITY-GATE-ID                  
                   ELSE                                                 
A05317                 IF LINK-CITY-GATE-ID <= SPACES                   
                           MOVE LINK-LOCAL-OFFICE TO C0-LOCAL-OFFICE    
                           PERFORM 7020-DEFAULT-CITY-GATE THRU 7020-EXIT
                           MOVE C0-CITY-GATE-ID TO LINK-CITY-GATE-ID    
A05317                 END-IF                                           
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           IF (LINK-COUNTY <= SPACES) OR                                
A05317        (LINK-COUNTY = '000')                                     
                  MOVE LINK-REV-DISTRICT TO A9-REV-DISTRICT-CD          
                  PERFORM 7030-SELECT-REVDIST THRU 7030-EXIT            
                  MOVE A9-COUNTY TO LINK-COUNTY
           END-IF.                        
                                                                        
           IF PO-BOX                                                    
               EVALUATE LINK-COMPANY-NO                                 
                   WHEN '01'                                            
                       IF CSR-DATABASE                                  
                           IF LINK-REV-DISTRICT <= SPACES               
                               MOVE '000' TO LINK-REV-DISTRICT          
                           END-IF                                       
                           IF LINK-LOCAL-OFFICE <= SPACES               
                               MOVE '001' TO LINK-LOCAL-OFFICE          
                           END-IF                                       
                       ELSE                                             
                           IF LINK-REV-DISTRICT <= SPACES               
                               MOVE '800' TO LINK-REV-DISTRICT          
                           END-IF                                       
                           IF LINK-LOCAL-OFFICE <= SPACES               
                               MOVE '800' TO LINK-LOCAL-OFFICE          
                           END-IF                                       
                       END-IF                                           
                   WHEN '26'                                            
                       IF LINK-REV-DISTRICT <= SPACES                   
                           MOVE '290' TO LINK-REV-DISTRICT              
                       END-IF                                           
                       IF LINK-LOCAL-OFFICE <= SPACES                   
                           MOVE '011' TO LINK-LOCAL-OFFICE              
                       END-IF                                           
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF SEB-DATABASE                                              
               PERFORM 3010-REMOVE-DASH-STAR THRU 3010-EXIT
           END-IF.            
                                                                        
           PERFORM 6702-GET-NEW-PREMISE-NO THRU 6702-EXIT.              
           MOVE WS-94-NEW-PREMISE-NO TO WS-NEW-PREMISE-NO-NUM.          
           MOVE WS-NEW-PREMISE-NO-CHAR TO RS-PREMISE-NO.                
           MOVE WS-NEW-PREMISE-NO-NUM TO MH-PREMISE-NO.                 
                                                                        
           PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT.              
           MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM.             
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           INITIALIZE DCLCSS-ADDR-FORMATTED.                            
           MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID.                    
           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO.                           
           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1.                 
           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2.                 
           MOVE LINK-STREET-NAME TO DY-STREET-NAME.                     
           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX.                 
           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX.                     
           MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1.              
           MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2.              
           MOVE LINK-ZIP-CODE TO DY-ZIP-CODE.                           
           MOVE LINK-ZIP-CODE-PLUS-FOUR TO DY-ZIP-CODE-PLUS-FOUR.       
           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN.                 
           MOVE LINK-DELIVERY-POINT TO DY-USPS-DELIV-PT-CD.             
           MOVE LINK-ADDRESS-OVERFLOW TO DY-ADDRESS-OVERFLOW.           
           MOVE LINK-ADDR-USAGE-CD TO DY-ADDR-USAGE-CD.                 
           MOVE WS-CURRENT-TIMESTAMP TO DY-VALIDATION-TS.               
           PERFORM 8010-INSERT-ADDRESS THRU 8010-EXIT.                  
                                                                        
           INITIALIZE DCLCSS-PREMISE.                                   
           MOVE WS-NEW-PREMISE-NO-NUM    TO PR-PREMISE-NO.              
           MOVE WS-NEW-ADDR-ID-NUM       TO PR-ADDRESS-ID.              
           MOVE 'A'                      TO PR-ADDRESS-FORMAT.          
           MOVE LINK-LOCAL-OFFICE        TO PR-LOCAL-OFFICE.            
           MOVE LINK-COMPANY-NO          TO PR-COMPANY-NO.              
           MOVE LINK-SUBDIVISION-ID      TO PR-SUBDIVISION-ID.          
           MOVE LINK-LOT                 TO PR-LOT.                     
           MOVE LINK-BLOCK               TO PR-BLOCK.                   
           MOVE LINK-COUNTY              TO PR-COUNTY.                  
           MOVE LINK-LOCATOR-ID          TO PR-LOCATOR-ID.              
           MOVE LINK-READ-ROUTE          TO PR-READ-ROUTE.              
           MOVE LINK-CITY-GATE-ID        TO PR-CITY-GATE-ID.            
           MOVE LINK-CROSS-STREET-1      TO PR-CROSS-STREET-1.          
           MOVE LINK-CROSS-STREET-2      TO PR-CROSS-STREET-2.          
           MOVE LINK-LEAK-SURVEY-DT      TO PR-GAS-LEAK-SURVEY-DT.      
           MOVE LINK-LEAK-SURVEY-FREQ    TO PR-GAS-LK-SURVEY-FREQ.      
           MOVE LINK-REV-DISTRICT        TO PR-REV-DISTRICT-CD.         
           MOVE LINK-LATITUDE            TO PR-PREM-REF-LATITUDE.       
           MOVE LINK-LONGITUDE           TO PR-PREM-REF-LONGITUDE.      
           IF LINK-LATITUDE NOT = 0 OR                                  
              LINK-LONGITUDE NOT = 0                                    
                  MOVE 'G' TO PR-LAT-LONG-SOURCE-CD                     
                  MOVE WS-CURRENT-DATE TO PR-LAT-LONG-DT
           END-IF.               
           MOVE LINK-AGL-PREMISE-NO      TO PR-AGL-PREM-NO.             
           MOVE LINK-FM-ELEC-SVC-WKDIST  TO PR-FM-ELEC-SVC-WKDIST.      
           MOVE LINK-FM-GAS-OPS-WKDIST   TO PR-FM-GAS-OPS-WKDIST.       
           MOVE LINK-FM-FLD-SVCS-WKDIST  TO PR-FM-FLD-SVCS-WKDIST.      
           MOVE LINK-FM-REV-PRT-WKDIST   TO PR-FM-REV-PRT-WKDIST.       
           MOVE LINK-FM-DSM-ESVC-WKDIST  TO PR-FM-DSM-ESVC-WKDIST.      
           MOVE LINK-DDDC-FCTR           TO PR-DDDC-FCTR.               
           IF LINK-DDDC-FCTR > 0                                        
               MOVE WS-CURRENT-DATE      TO PR-DDDC-FCTR-EFF-DT
           END-IF.        
           MOVE 'J'                      TO PR-CODE-PREMISE-STAT.       
           MOVE WS-CURRENT-DATE          TO PR-PREM-CREATE-DT.          
           PERFORM 8000-INSERT-PREMISE THRU 8000-EXIT.                  
                                                                        
           INITIALIZE DCLCSS-NAME-ACCT-XREF.                            
           MOVE WS-NEW-PREMISE-NO-NUM    TO HT-PREMISE-NO.              
           MOVE WS-NEW-ADDR-ID-NUM       TO HT-ADDRESS-ID.              
           MOVE LINK-COMPANY-NO          TO HT-COMPANY-NO.              
           MOVE LINK-TOWN                TO HT-TOWN.                    
           MOVE LINK-STATE               TO HT-STATE.                   
           MOVE LINK-LOCAL-OFFICE        TO HT-LOCAL-OFFICE.            
           PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT.                
                                                                        
      *    IF LINK-COMPANY-NO = '26' AND                                        
      *       LINK-SUBDIVISION-ID = 'ZZZ'                                       
      *           INITIALIZE CWS00077-FIELDS                                    
      *           IF WS-COMMENTS-TEXT <= SPACES                                 
      *               MOVE 'PSNC UNKNOWN SUBDIVISION' TO                        
      *                    WS-77-COMMENTS-TEXT                                  
      *               MOVE +25 TO WS-77-COMMENTS-LEN                            
      *           ELSE                                                          
      *               MOVE WS-COMMENTS-TEXT TO WS-77-COMMENTS-TEXT              
      *               MOVE WS-COMMENTS-LEN TO WS-77-COMMENTS-LEN                
      *           END-IF                                                        
      *           MOVE 1 TO WS-77-ROUTE-CATEGORY                                
      *           MOVE 405 TO WS-77-CATEGORY-ID                                 
      *           MOVE 'N' TO WS-77-PRIORITY                                    
      *           MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO                        
      *           PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT.                    
                                                                        
           IF GIS-SUCCESS                                               
               MOVE LINK-ZIP-CODE TO ZT-ZIP-CODE                        
                                     ZS-ZIP-CODE                        
               MOVE LINK-LOCAL-OFFICE TO ZT-LOCAL-OFFICE                
               MOVE LINK-REV-DISTRICT TO ZT-REV-DISTRICT-CD             
               MOVE LINK-READ-ROUTE TO ZT-READ-ROUTE                    
               MOVE LINK-SUBDIVISION-ID TO ZS-SUBDIVISION-ID            
               PERFORM 7110-SELECT-ZIPCODE-LO-RT THRU 7110-EXIT         
               IF LINK-SUBDIVISION-ID = 'ZZZ' OR 'ZZY'                  
                   MOVE 'YES' TO WS-ZS-EXISTS-FLAG                      
               ELSE                                                     
                   PERFORM 7120-SELECT-ZIPCODE-SUBDIV THRU 7120-EXIT    
               END-IF                                                   
               IF ZT-EXISTS AND ZS-EXISTS                               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF ZT-NOT-EXIST                                      
                       MOVE LINK-READ-ROUTE TO ZT-READ-ROUTE            
                       MOVE LINK-COMPANY-NO TO ZT-COMPANY-NO            
A05317                 MOVE 'SYSTEM' TO ZT-LAST-UPDATE-USERID           
                       PERFORM 8080-INSERT-ZT THRU 8080-EXIT            
                   END-IF                                               
                   IF ZS-NOT-EXIST                                      
                       MOVE ZEROES TO ZS-RATE-ITEM-CD                   
                       MOVE LINK-COMPANY-NO TO ZS-COMPANY-NO            
A05317                 MOVE 'SYSTEM' TO ZS-LAST-UPDATE-USERID           
                       PERFORM 8090-INSERT-ZS THRU 8090-EXIT            
                   END-IF                                               
                   INITIALIZE CWS00077-FIELDS                           
                   MOVE LINK-ZIP-CODE TO WS-WQ-ZIP                      
                   MOVE LINK-LOCAL-OFFICE TO WS-WQ-LO                   
                   MOVE LINK-READ-ROUTE TO WS-WQ-ROUTE                  
                   MOVE LINK-REV-DISTRICT TO WS-WQ-REV-DIST             
                   MOVE LINK-SUBDIVISION-ID TO WS-WQ-SUBD               
                   MOVE WS-GIS-MISMATCH-WQ-MSG TO WS-77-COMMENTS-TEXT   
                   MOVE +100 TO WS-77-COMMENTS-LEN                      
                   MOVE 4 TO WS-77-ROUTE-CATEGORY                       
                   MOVE 406 TO WS-77-CATEGORY-ID                        
                   MOVE 'N' TO WS-77-PRIORITY                           
                   MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO
               END-IF
           END-IF.              
      *            PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT.                   
                                                                        
           IF GIS-DOWN                                                  
               INITIALIZE CWS00077-FIELDS                               
               MOVE WS-GIS-DOWN-WQ-MSG TO WS-77-COMMENTS-TEXT           
A05317         MOVE +60  TO WS-77-COMMENTS-LEN                          
               MOVE 4 TO WS-77-ROUTE-CATEGORY                           
               MOVE 601 TO WS-77-CATEGORY-ID                            
A05317         MOVE 'H' TO WS-77-PRIORITY                               
               MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO                   
               PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT
           END-IF.               
                                                                        
           IF WS-CLICK-PREM-FL = 'Y' AND                                
              CSR-DATABASE                                              
                  MOVE WS-NEW-PREMISE-NO-NUM TO 3O-PREMISE-NO           
                  PERFORM 8030-INSERT-CLICK-PREM THRU 8030-EXIT
           END-IF.        
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-REMOVE-DASH-STAR.                                           
                                                                        
           INSPECT LINK-STREET-NAME     REPLACING ALL '-' BY ' '.       
           INSPECT LINK-STREET-NAME     REPLACING ALL '*' BY ' '.       
           INSPECT LINK-STREET-LOC-2 REPLACING ALL '*' BY ' '.          
           INSPECT LINK-STREET-LOC-2 REPLACING ALL '#' BY ' '.          
           INSPECT LINK-ADDRESS-OVERFLOW     REPLACING ALL '*' BY ' '.  
           IF LINK-STREET-LOC-2 > ' '                                   
               MOVE LINK-STREET-LOC-2 TO WS-FO-STREET-LOCATION-2        
               MOVE SPACES TO LINK-STREET-LOC-2                         
               MOVE 1 TO WS-SUBI WS-SUBO                                
               PERFORM UNTIL WS-SUBI > 11                               
                   IF WS-FO-STREET-LOCATION-2(WS-SUBI:1) > ' '          
                       MOVE WS-FO-STREET-LOCATION-2(WS-SUBI:1) TO       
                            LINK-STREET-LOC-2 (WS-SUBO:1)               
                       ADD 1 TO WS-SUBO                                 
                   END-IF                                               
                   ADD 1 TO WS-SUBI                                     
               END-PERFORM                                              
           END-IF.                                                      
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 3020-PARSE-INTERSECTION.                                         
A05317                                                                  
A05317     MOVE 'N' TO WS-AMPERSAND-FL.                                 
A05317     MOVE SPACES TO LINK-STREET-NAME                              
A05317                    LINK-ADDRESS-OVERFLOW.                        
A05317     PERFORM VARYING WS-SUBI FROM 1 BY 1 UNTIL WS-SUBI > 30 OR    
A05317                     WS-AMPERSAND-FL = 'Y'                        
A05317         IF WS-STREET-NAME(WS-SUBI:1) = '&'                       
A05317             MOVE 'Y' TO WS-AMPERSAND-FL                          
A05317         ELSE                                                     
A05317             MOVE WS-STREET-NAME(WS-SUBI:1) TO                    
A05317                  LINK-STREET-NAME(WS-SUBI:1)                     
A05317         END-IF                                                   
A05317     END-PERFORM.                                                 
A05317                                                                  
A05317     ADD +1 TO WS-SUBI.                                           
A05317     MOVE +1 TO WS-SUBO.                                          
A05317                                                                  
A05317     PERFORM UNTIL WS-SUBI > 30                                   
A05317         MOVE WS-STREET-NAME(WS-SUBI:1) TO                        
A05317              LINK-ADDRESS-OVERFLOW(WS-SUBO:1)                    
A05317         ADD +1 TO WS-SUBI                                        
A05317                   WS-SUBO                                        
A05317     END-PERFORM.                                                 
A05317                                                                  
A05317 3020-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       3100-UPDATE-PREMISE.                                             
                                                                        
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO                      
                                     MH-PREMISE-NO                      
                                     WS-PREMISE-NO                      
                                     WS-CPD99-PREMISE-NO.               
           MOVE LINK-PREMISE-NO TO RS-PREMISE-NO.                       
                                                                        
           IF SEB-DATABASE                                              
               PERFORM 3010-REMOVE-DASH-STAR THRU 3010-EXIT
           END-IF.            
                                                                        
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO.                   
           PERFORM 7230-SELECT-CURRENT-ACCOUNT THRU 7230-EXIT.          
                                                                        
           PERFORM 7300-SELECT-PREMISE THRU 7300-EXIT.                  
A05317     PERFORM 7305-SELECT-READ-ROUTE THRU 7305-EXIT.               
A05317     IF UT-READ-ROUTE > ZEROES                                    
A05317         MOVE UT-READ-ROUTE TO PR-READ-ROUTE
           END-IF.                     
                                                                        
A05317     IF WS-LEAK-EXCEP-FL = 'Y' AND                                
A05317        GIS-SUCCESS                                               
A05317            MOVE PR-GAS-LK-SURVEY-FREQ TO LINK-LEAK-SURVEY-FREQ
           END-IF.  
A05317     IF LINK-COMPANY-NO = '26'                                    
A05317         MOVE '2999999' TO LINK-CITY-GATE-ID
           END-IF.                     
                                                                        
           IF (LINK-COUNTY <= SPACES) OR                                
A05317        (LINK-COUNTY = '000')                                     
                  MOVE LINK-REV-DISTRICT TO A9-REV-DISTRICT-CD          
                  PERFORM 7030-SELECT-REVDIST THRU 7030-EXIT            
                  MOVE A9-COUNTY TO LINK-COUNTY
           END-IF.                        
                                                                        
           PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT.            
                                                                        
           IF PREM-CHANGED                                              
               MOVE LINK-LOCAL-OFFICE TO PR-LOCAL-OFFICE                
               MOVE LINK-SUBDIVISION-ID TO PR-SUBDIVISION-ID            
               MOVE LINK-LOT TO PR-LOT                                  
               MOVE LINK-BLOCK TO PR-BLOCK                              
               MOVE LINK-COUNTY TO PR-COUNTY                            
               MOVE LINK-LOCATOR-ID TO PR-LOCATOR-ID                    
               MOVE LINK-CITY-GATE-ID TO PR-CITY-GATE-ID                
               MOVE LINK-READ-ROUTE TO PR-READ-ROUTE                    
               MOVE LINK-LEAK-SURVEY-DT TO PR-GAS-LEAK-SURVEY-DT        
               MOVE LINK-LEAK-SURVEY-FREQ TO PR-GAS-LK-SURVEY-FREQ      
               MOVE LINK-REV-DISTRICT TO PR-REV-DISTRICT-CD             
               MOVE LINK-CROSS-STREET-1 TO PR-CROSS-STREET-1            
               MOVE LINK-CROSS-STREET-2 TO PR-CROSS-STREET-2            
               MOVE LINK-LATITUDE TO PR-PREM-REF-LATITUDE               
               MOVE LINK-LONGITUDE TO PR-PREM-REF-LONGITUDE             
               MOVE LINK-AGL-PREMISE-NO TO PR-AGL-PREM-NO               
               MOVE WS-DIRECTIONS-TEXT TO PR-PREMISE-DIRECTIONS-TEXT    
               MOVE WS-DIRECTIONS-LEN TO PR-PREMISE-DIRECTIONS-LEN      
               MOVE WS-SCRATCH-PAD-TEXT TO PR-SCRATCH-PAD-TEXT          
               MOVE WS-SCRATCH-PAD-LEN TO PR-SCRATCH-PAD-LEN            
               MOVE WS-SPECIAL-TEXT TO PR-SPCL-INSTRUCTIONS-TEXT        
               MOVE WS-SPECIAL-LEN TO PR-SPCL-INSTRUCTIONS-LEN          
               MOVE WS-SPECIAL-READ-TEXT TO PR-SPCL-READ-INSTR-TEXT     
               MOVE WS-SPECIAL-READ-LEN TO PR-SPCL-READ-INSTR-LEN       
               MOVE LINK-DATE-SPCL-MSG-ENDS TO PR-DATE-SPCL-MSG-ENDS    
                                                                        
               MOVE LINK-FM-ELEC-SVC-WKDIST  TO PR-FM-ELEC-SVC-WKDIST   
               MOVE LINK-FM-GAS-OPS-WKDIST   TO PR-FM-GAS-OPS-WKDIST    
               MOVE LINK-FM-FLD-SVCS-WKDIST  TO PR-FM-FLD-SVCS-WKDIST   
               MOVE LINK-FM-REV-PRT-WKDIST   TO PR-FM-REV-PRT-WKDIST    
               MOVE LINK-FM-DSM-ESVC-WKDIST  TO PR-FM-DSM-ESVC-WKDIST   
               MOVE LINK-DDDC-FCTR           TO PR-DDDC-FCTR            
               IF DDDC-CHANGED                                          
                   MOVE WS-CURRENT-DATE      TO PR-DDDC-FCTR-EFF-DT     
               END-IF                                                   
               PERFORM 8200-UPDATE-PREMISE THRU 8200-EXIT
           END-IF.              
                                                                        
           IF ADDR-CHANGED                                              
               MOVE LINK-HOUSE-NO TO DY-HOUSE-NO                        
               MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1              
               MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2              
               MOVE LINK-STREET-NAME TO DY-STREET-NAME                  
               MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX              
               MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX                  
               MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1           
               MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2           
               MOVE LINK-ZIP-CODE TO DY-ZIP-CODE                        
               MOVE LINK-ZIP-CODE-PLUS-FOUR TO DY-ZIP-CODE-PLUS-FOUR    
               MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN              
               MOVE LINK-DELIVERY-POINT TO DY-USPS-DELIV-PT-CD          
               MOVE LINK-ADDRESS-OVERFLOW TO DY-ADDRESS-OVERFLOW        
               PERFORM 8210-UPDATE-ADDRESS THRU 8210-EXIT
           END-IF.              
                                                                        
           PERFORM 8220-UPDATE-XREF THRU 8220-EXIT.                     
                                                                        
      *    IF RRTE-CHANGED AND                                                  
      *       LINK-READ-ROUTE > 0                                               
      *           PERFORM 3120-READ-ROUTE-PROCESSING THRU 3120-EXIT.            
                                                                        
           IF RDST-CHANGED AND                                          
              PR-REV-DISTRICT-CD > SPACES AND                           
              LINK-REV-DISTRICT > SPACES AND                            
              PR-COMPANY-NO = '01' AND                                  
              CSR-DATABASE                                              
                  PERFORM F1100-CHECK-FOR-ACCOUNTS THRU F1100-EXIT      
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                      PERFORM F1200-PROCESS-FRANCHISE-FEE THRU          
                              F1200-EXIT
                  END-IF
           END-IF.                               
                                                                        
           IF LOFC-CHANGED                                              
               PERFORM 8230-UPDATE-ORDERS THRU 8230-EXIT
           END-IF.               
                                                                        
           IF Q346-CHANGED AND                                          
              LINK-COMPANY-NO = '01' AND                                
              CSR-DATABASE AND                                          
              WS-CPD99-ACCOUNT-NO > 0                                   
                  MOVE WS-CPD99-ACCOUNT-NO TO UT-ACCOUNT-NO             
                  PERFORM 7220-GAS-UTILITY-EXISTS THRU 7220-EXIT        
                  IF UT-CODE-UTIL-TYPE = 'G'                            
                      INITIALIZE CWS00077-FIELDS                        
                      MOVE WS-WQ-COMMENTS-346 TO WS-77-COMMENTS-TEXT    
                      MOVE LENGTH OF WS-77-COMMENTS-TEXT TO             
                                     WS-77-COMMENTS-LEN                 
                      MOVE 1 TO WS-77-ROUTE-CATEGORY                    
                      MOVE 346 TO WS-77-CATEGORY-ID                     
                      MOVE 'N' TO WS-77-PRIORITY                        
                      MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO            
                      MOVE AT-ACCOUNT-NO TO WS-77-ACCOUNT-NO            
                      MOVE AT-CUSTOMER-NO TO WS-77-CUSTOMER-NO          
                      IF AT-ACCOUNT-TYPE-CODE = 'N' OR                  
                        (AT-CREDIT-GROUP = 'M' OR 'D')                  
                           NEXT SENTENCE                                
                      ELSE                                              
                          PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT
                      END-IF
                  END-IF
           END-IF.    
                                                                        
A05317*    IF RDST-CHANGED AND                                                  
A05317*       LINK-COMPANY-NO = '01' AND                                        
A05317*       WS-BOT-TEAM-MEMBER = 'N'                                          
A05317*           PERFORM 3110-REVDIST-WQ THRU 3110-EXIT.                       
                                                                        
           IF RDST-CHANGED AND                                          
              CSR-DATABASE                                              
                  PERFORM 4100-CALL-CSR00647 THRU 4100-EXIT
           END-IF.            
                                                                        
           IF SUBD-CHANGED AND                                          
              LINK-COMPANY-NO = '01' AND                                
              WS-BOT-TEAM-MEMBER = 'N' AND                              
              WS-CPD99-ACCOUNT-NO > 0                                   
                  INITIALIZE CWS00077-FIELDS                            
                  MOVE 4 TO WS-77-ROUTE-CATEGORY                        
                  MOVE 363 TO WS-77-CATEGORY-ID                         
                  MOVE 'N' TO WS-77-PRIORITY                            
                  MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO                
                  MOVE AT-ACCOUNT-NO TO WS-77-ACCOUNT-NO                
                  MOVE AT-CUSTOMER-NO TO WS-77-CUSTOMER-NO              
                  MOVE LINK-ZIP-CODE TO ZS-ZIP-CODE                     
                  MOVE WS-SUBDIV-CODE-FROM TO ZS-SUBDIVISION-ID         
A05317            MOVE 0.00 TO UP-PRICE-PER-SERV                        
                  PERFORM 7260-GET-AMOUNT THRU 7260-EXIT                
                  MOVE UP-PRICE-PER-SERV TO WS-SUBDIV-AMT-FROM          
                  MOVE 0.00 TO UP-PRICE-PER-SERV                        
                  IF AT-ACCOUNT-TYPE-CODE = 'R'                         
                      MOVE WS-SUBDIV-CODE-TO TO ZS-SUBDIVISION-ID       
                      PERFORM 7260-GET-AMOUNT THRU 7260-EXIT            
                      MOVE UP-PRICE-PER-SERV TO WS-SUBDIV-AMT-TO        
                  ELSE                                                  
                      MOVE 0.00 TO WS-SUBDIV-AMT-TO                     
                  END-IF                                                
                  EVALUATE AT-CODE-ACCT-STAT                            
                      WHEN 'A'                                          
                          MOVE AT-ACCT-CREATE-DT(1:4) TO WS-CREATE-YR   
                          MOVE AT-ACCT-CREATE-DT(6:2) TO WS-CREATE-MM   
                          MOVE AT-ACCT-CREATE-DT(9:2) TO WS-CREATE-DD   
                          MOVE 'ACCOUNT ACTIVE ON ' TO WS-ACTIVE-MSG    
                      WHEN 'P'                                          
                          MOVE SPACES TO WS-DATE-ACTIVE                 
                          MOVE 'PENDING ACCOUNT' TO WS-ACTIVE-MSG       
                      WHEN OTHER                                        
                          MOVE SPACES TO WS-DATE-ACTIVE                 
                                         WS-ACTIVE-MSG                  
                  END-EVALUATE                                          
                  MOVE WS-SUBDIV-WQ-MSG TO WS-77-COMMENTS-TEXT          
                  MOVE LENGTH OF WS-77-COMMENTS-TEXT TO                 
                                 WS-77-COMMENTS-LEN                     
                  PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT
           END-IF.            
                                                                        
      *    IF LINK-COMPANY-NO = '26' AND                                        
      *       SUBD-CHANGED AND                                                  
      *       LINK-SUBDIVISION-ID = 'ZZZ'                                       
      *           INITIALIZE CWS00077-FIELDS                                    
      *           MOVE WS-COMMENTS-TEXT TO WS-77-COMMENTS-TEXT                  
      *           MOVE WS-COMMENTS-LEN TO WS-77-COMMENTS-LEN                    
      *           MOVE 1 TO WS-77-ROUTE-CATEGORY                                
      *           MOVE 405 TO WS-77-CATEGORY-ID                                 
      *           MOVE 'N' TO WS-77-PRIORITY                                    
      *           MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO                        
      *           PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT.                    
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3110-REVDIST-WQ.                                                 
                                                                        
           PERFORM 7240-ACCOUNT-TYPES THRU 7240-EXIT.                   
           IF WS-PENDING-ACCOUNT = 'Y'                                  
               PERFORM 7250-NEW-SET-CHECK THRU 7250-EXIT
           END-IF.               
           IF WS-NEW-SET-CONDITION = 'Y' AND                            
              WS-PENDING-ACCOUNT = 'Y'                                  
                  NEXT SENTENCE                                         
           ELSE                                                         
               IF WS-ACTIVE-ACCOUNT = 'Y' OR                            
                  WS-PENDING-ACCOUNT = 'Y' OR                           
                  WS-OTHER-ACCOUNT = 'Y'                                
                      INITIALIZE CWS00077-FIELDS                        
                      MOVE 100 TO WS-77-COMMENTS-LEN                    
                      MOVE 4 TO WS-77-ROUTE-CATEGORY                    
                      MOVE 359 TO WS-77-CATEGORY-ID                     
                      MOVE 'N' TO WS-77-PRIORITY                        
                      MOVE PR-PREMISE-NO TO WS-77-PREMISE-NO            
                      PERFORM 3115-FORMAT-359-COMMENTS THRU 3115-EXIT   
                      PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT
               END-IF
           END-IF.        
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3115-FORMAT-359-COMMENTS.                                        
                                                                        
           IF WS-ACTIVE-ACCOUNT = 'Y' AND                               
              WS-PENDING-ACCOUNT = 'Y'                                  
                  MOVE WS-ACTIVE-ACCT-NO TO WS-77-ACCOUNT-NO            
                  MOVE WS-ACTIVE-CUST-NO TO WS-77-CUSTOMER-NO           
                  MOVE WS-REVDIST-WQ-MSG-B TO WS-77-COMMENTS-TEXT       
                  IF LOFC-CHANGED                                       
                      MOVE WS-LOCOFF-WQ-MSG TO                          
                           WS-77-COMMENTS-TEXT(93:45)                   
                  END-IF                                                
                  MOVE LENGTH OF WS-77-COMMENTS-TEXT TO                 
                                 WS-77-COMMENTS-LEN                     
           ELSE                                                         
               IF WS-PENDING-ACCOUNT = 'Y'                              
                   MOVE WS-PENDING-ACCT-NO TO WS-77-ACCOUNT-NO          
                   MOVE WS-PENDING-CUST-NO TO WS-77-CUSTOMER-NO         
                   MOVE WS-REVDIST-WQ-MSG-P TO WS-77-COMMENTS-TEXT      
                   IF LOFC-CHANGED                                      
                       MOVE WS-LOCOFF-WQ-MSG TO                         
                            WS-77-COMMENTS-TEXT(83:45)                  
                   END-IF                                               
                   MOVE LENGTH OF WS-77-COMMENTS-TEXT TO                
                                  WS-77-COMMENTS-LEN                    
               ELSE                                                     
                   IF WS-ACTIVE-ACCOUNT = 'Y'                           
                       MOVE WS-ACTIVE-ACCT-NO TO WS-77-ACCOUNT-NO       
                       MOVE WS-ACTIVE-CUST-NO TO WS-77-CUSTOMER-NO      
                       MOVE WS-REVDIST-WQ-MSG-A TO WS-77-COMMENTS-TEXT  
                       IF LOFC-CHANGED                                  
                           MOVE WS-LOCOFF-WQ-MSG TO                     
                                WS-77-COMMENTS-TEXT(83:45)              
                       END-IF                                           
                       MOVE LENGTH OF WS-77-COMMENTS-TEXT TO            
                                      WS-77-COMMENTS-LEN                
                   ELSE                                                 
                       MOVE WS-ACTIVE-ACCT-NO TO WS-77-ACCOUNT-NO       
                       MOVE WS-ACTIVE-CUST-NO TO WS-77-CUSTOMER-NO      
                       EVALUATE AT-CODE-ACCT-STAT                       
                           WHEN 'B'                                     
                               MOVE WS-REVDIST-WQ-MSG-F TO              
                                    WS-77-COMMENTS-TEXT                 
                           WHEN 'S'                                     
                               MOVE WS-REVDIST-WQ-MSG-W TO              
                                    WS-77-COMMENTS-TEXT                 
                           WHEN 'J'                                     
                               MOVE WS-REVDIST-WQ-MSG-I TO              
                                    WS-77-COMMENTS-TEXT                 
                       END-EVALUATE                                     
                       IF LOFC-CHANGED                                  
                           MOVE WS-LOCOFF-WQ-MSG TO                     
                                WS-77-COMMENTS-TEXT(83:45)              
                       END-IF                                           
                       MOVE LENGTH OF WS-77-COMMENTS-TEXT TO            
                                      WS-77-COMMENTS-LEN
                   END-IF
               END-IF
           END-IF.               
                                                                        
       3115-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3120-READ-ROUTE-PROCESSING.                                      
                                                                        
           PERFORM 7270-SELECT-READ-ROUTE THRU 7270-EXIT.               
                                                                        
           IF UT-READ-ROUTE NOT = LINK-READ-ROUTE                       
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-READ-ROUTE > ZEROES                               
                  MOVE +4                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-READ-ROUTE     TO WS-DISPLAY-READ-ROUTE     
                  MOVE WS-DISPLAY-READ-ROUTE TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF UT-READ-ROUTE > ZEROES                                 
                  MOVE +4                  TO WS-DISPLAY-READ-ROUTE     
                  MOVE UT-READ-ROUTE       TO MI-PRV-COLUMN-VALUE-TEXT  
                  MOVE WS-DISPLAY-READ-ROUTE TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'READ ROUTE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           PERFORM 7280-OLD-READ-CYCLE THRU 7280-EXIT.                  
           MOVE LINK-LOCAL-OFFICE TO O2-LOCAL-OFFICE.                   
           MOVE LINK-READ-ROUTE TO O2-READ-ROUTE.                       
           MOVE LINK-COMPANY-NO TO O2-COMPANY-NO.                       
           PERFORM 7290-NEW-READ-CYCLE THRU 7290-EXIT.                  
                                                                        
           IF UT-READ-CYCLE NOT = O2-READ-CYCLE                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF O2-READ-CYCLE > SPACES                                 
                  MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE O2-READ-CYCLE       TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF UT-READ-CYCLE > SPACES                                 
                  MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE UT-READ-CYCLE       TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'READ CYCLE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           PERFORM 8240-UPDATE-UTIL-ENVRNMT THRU 8240-EXIT.             
                                                                        
           IF AT-CODE-ACCT-STAT = 'A' AND                               
              AT-BILL-CYCLE-CHG-CD NOT = 'F'                            
                  PERFORM 8250-UPDATE-ACCOUNT THRU 8250-EXIT
           END-IF.           
                                                                        
       3120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3125-BILL-CYCLE-TRANSHIST.                                       
                                                                        
           IF AT-BILL-CYCLE NOT = O2-READ-CYCLE                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF O2-READ-CYCLE > SPACES                                 
                  MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE O2-READ-CYCLE       TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF AT-BILL-CYCLE > SPACES                                 
                  MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE AT-BILL-CYCLE       TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'BILL CYCLE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
       3125-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-PREMISE.                                             
                                                                        
           MOVE WS-PREMISE-NO-NUM TO  PR-PREMISE-NO                     
                                      MH-PREMISE-NO.                    
           MOVE LINK-PREMISE-NO    TO RS-PREMISE-NO.                    
                                                                        
           PERFORM 7200-ACCOUNTS-EXIST THRU 7200-EXIT.                  
           IF AT-ACCOUNT-NO > 0 OR                                      
              HA-ACCOUNT-NO > 0                                         
                  MOVE +1 TO RS-STATUS-CODE                             
           ELSE                                                         
               PERFORM 7130-SERVICE-ORDERS THRU 7130-EXIT               
               IF VO-SERV-ORDER-NO > 0                                  
                   MOVE +3 TO RS-STATUS-CODE                            
               ELSE                                                     
                   PERFORM 7210-SELECT-GAS-LINE THRU 7210-EXIT          
                   IF XO-SERVICE-NO > 0                                 
                       MOVE +2 TO RS-STATUS-CODE                        
                   ELSE                                                 
                       PERFORM 7140-PREM-RELEASE THRU 7140-EXIT         
                       IF RP-RLSE-NO > SPACES                           
                           MOVE +4 TO RS-STATUS-CODE                    
                       ELSE                                             
                           PERFORM 7160-LANDLORD THRU 7160-EXIT         
                           IF SI-CUSTOMER-NO > 0                        
                               MOVE +5 TO RS-STATUS-CODE
                           END-IF
                       END-IF
                   END-IF
               END-IF
           END-IF.               
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 3210-DELETE-PROCESSING THRU 3210-EXIT
           END-IF.           
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3210-DELETE-PROCESSING.                                          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE LINK-PREMISE-NO       TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'PREMISE'             TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           PERFORM 8040-DELETE-NAME-ACCT-XREF THRU 8040-EXIT.           
           PERFORM 8050-DELETE-PREM-GAS-LINE THRU 8050-EXIT.            
I01959     PERFORM 8260-DELETE-DER-DET THRU 8260-EXIT.                  
           PERFORM 8060-DELETE-PREMISE THRU 8060-EXIT.                  
           PERFORM 8070-DELETE-WQ THRU 8070-EXIT.                       
                                                                        
       3210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3300' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4000-CALL-MCSCB077.                                              
                                                                        
           MOVE LINK-USERID TO WS-77-USER-ID-ORIG.                      
           MOVE PROGRAM-NAME TO WS-77-CREATED-BY.                       
                                                                        
           CALL MCSCB077  USING   CWS00077-FIELDS,                      
                                  ABEND-FILE,                           
                                  WS-MCSCB077-RET-CODE.                 
                                                                        
           MOVE WS-MCSCB077-RET-CODE       TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'MCSCB077'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-77-PREMISE-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-CALL-CSR00647.                                              
                                                                        
           MOVE ZEROES TO ACCOUNT-NO-0647.                              
           MOVE LINK-PREMISE-NO TO PREMISE-NO-0647.                     
           MOVE LINK-REV-DISTRICT TO REV-DISTRICT-0647.                 
           MOVE LINK-USERID TO USERID-0647.                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00647                                             
      *           (:ACCOUNT-NO-0647,                                    
      *            :PREMISE-NO-0647,                                    
      *            :REV-DISTRICT-0647,                                  
      *            :USERID-0647)                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0647
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0647
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0647 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00647'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-0647       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0647)                                                
      *       WITH PROCEDURE CSR00647                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0647 CURSOR FOR RESULT SET        
      *       :LOC0647                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0647 INTO                            
                 :RETURN-CODE-0647                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0647 NOT = 0                          
                       MOVE RETURN-CODE-0647  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00647'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
                       MOVE PREMISE-NO-0647   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                    WHEN OTHER                                          
                        MOVE PROGRAM-NAME          TO ABEND-PROGRAM     
                        MOVE '4100'                TO ACTIVE-PARAGRAPH  
                        MOVE 'FETCH'               TO ABEND-FUNCTION    
                        MOVE 'CSR00647'            TO TABLE-1           
                        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1   
                        MOVE PREMISE-NO-0647       TO HOSTVAR-ELEMENT-1 
                        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT   
                        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT   
                END-EVALUATE.                                           
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE SPACES                TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'NEW PREMISE'         TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF LINK-COMPANY-NO > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-COMPANY-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'COMPANY NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-ADDR-USAGE-CD = 'F'                                  
               PERFORM 5010-FORMATTED-TRANSHIST THRU 5010-EXIT          
           ELSE                                                         
               PERFORM 5020-INTERSECTION-TRANSHIST THRU 5020-EXIT
           END-IF.      
                                                                        
           IF LINK-ZIP-CODE > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE       '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-ZIP-CODE-PLUS-FOUR > SPACES                          
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE-PLUS-FOUR TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE +4'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF A4-ZIP-CODE-TOKEN > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE A4-ZIP-CODE-TOKEN     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP TOKEN'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-TOWN > ' '                                           
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE +26                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE LINK-TOWN               TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE 'TOWN'                  TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO
           END-IF.          
                                                                        
           IF LINK-STATE > ' '                                          
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE LINK-STATE              TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE 'STATE'                 TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO
           END-IF.          
                                                                        
           IF LINK-DELIVERY-POINT > ' '                                 
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE LINK-DELIVERY-POINT     TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE 'DELIVERY POINT'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO
           END-IF.          
                                                                        
           IF LINK-LOCAL-OFFICE > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LOCAL-OFFICE     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LOCAL OFFICE'        TO MI-COLUMN-DESC              
              MOVE 'B1'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              MOVE SPACES                TO MI-TABLE-ID                 
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-REV-DISTRICT > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-REV-DISTRICT     TO A9-REV-DISTRICT-CD          
              PERFORM 7030-SELECT-REVDIST THRU 7030-EXIT                
              MOVE A9-REV-DISTRICT-DESC  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REV DISTRICT'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-COUNTY > SPACES                                      
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +22                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-COUNTY           TO SC-COUNTY                   
              MOVE A4-STATE              TO SC-STATE                    
              PERFORM 7040-COUNTY-DESC THRU 7040-EXIT                   
              MOVE SC-COUNTY-DESC        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'COUNTY'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-SUBDIVISION-ID > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +26                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SUBDIVISION-ID   TO B0-SUBDIVISION-ID           
              MOVE LINK-COMPANY-NO       TO B0-COMPANY-NO               
              PERFORM 7050-SUBDIVISION-DESC  THRU 7050-EXIT             
              MOVE B0-SUBDIVISION-DESC   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SUBDIVISION    '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-BLOCK > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-BLOCK            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BLOCK'               TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-LOT > SPACES                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LOT              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LOT'                 TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-CITY-GATE-ID > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +7                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-CITY-GATE-ID     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CITY GATE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-READ-ROUTE > ZEROES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-READ-ROUTE       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'READ ROUTE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-LEAK-SURVEY-FREQ > SPACES                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LEAK-SURVEY-FREQ TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LEAK SURVEY FQ'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-LATITUDE NOT = ZEROES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LATITUDE         TO WS-DISPLAY-LAT-LONG         
              MOVE WS-DISPLAY-LAT-LONG   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LATITUDE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-LONGITUDE NOT = ZEROES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LONGITUDE        TO WS-DISPLAY-LAT-LONG         
              MOVE WS-DISPLAY-LAT-LONG   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LONGITUDE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-AGL-PREMISE-NO > ZEROES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-AGL-PREMISE-NO   TO WS-DISPLAY-AGL-PREM-NO      
              MOVE WS-DISPLAY-AGL-PREM-NO TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'AGL PREM NO'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF WS-FM-ELEC-SVC-WKDIST-TEXT > SPACES                       
             MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO              
             MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN      
             MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN      
             MOVE WS-FM-ELEC-SVC-WKDIST-TEXT TO MI-CHG-COLUMN-VALUE-TEXT
             MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT     
             MOVE 'ELEC SVC WKD'        TO MI-COLUMN-DESC               
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT            
             ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.             
                                                                        
           IF WS-FM-GAS-OPS-WKDIST-TEXT > SPACES                        
             MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO              
             MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN      
             MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN      
             MOVE WS-FM-GAS-OPS-WKDIST-TEXT TO MI-CHG-COLUMN-VALUE-TEXT 
             MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT     
             MOVE 'GAS OPS WKD'         TO MI-COLUMN-DESC               
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT            
             ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.             
                                                                        
           IF WS-FM-FLD-SVCS-WKDIST-TEXT > SPACES                       
             MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO              
             MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN      
             MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN      
             MOVE WS-FM-FLD-SVCS-WKDIST-TEXT TO MI-CHG-COLUMN-VALUE-TEXT
             MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT     
             MOVE 'FLD SVC WKD'         TO MI-COLUMN-DESC               
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT            
             ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.             
                                                                        
           IF WS-FM-REV-PRT-WKDIST-TEXT > SPACES                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-FM-REV-PRT-WKDIST-TEXT TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REV PRT WKD'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF WS-FM-DSM-ESVC-WKDIST-TEXT > SPACES                       
             MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO              
             MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN      
             MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN      
             MOVE WS-FM-DSM-ESVC-WKDIST-TEXT TO MI-CHG-COLUMN-VALUE-TEXT
             MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT     
             MOVE 'DSM ESVC WKD'        TO MI-COLUMN-DESC               
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT            
             ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.             
                                                                        
           IF LINK-DDDC-FCTR > ZEROES                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +18                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LINK-DDDC-FCTR        TO WS-DISPLAY-DDDC             
              MOVE WS-DISPLAY-DDDC       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DDDC FACTOR'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DDDC EFF DT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-ADDRESS-SOURCE > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              EVALUATE LINK-ADDRESS-SOURCE                              
                  WHEN 'M'                                              
                      MOVE 'MAP'         TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'C'                                              
                      MOVE 'CIS'         TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDRESS SOURCE'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
A05317     IF LINK-NEAREST-PREM-NO > SPACES                             
A05317        MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
A05317        MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
A05317        MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
A05317        MOVE LINK-NEAREST-PREM-NO  TO MI-CHG-COLUMN-VALUE-TEXT    
A05317        MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
A05317        MOVE 'NEAREST PREMISE'     TO MI-COLUMN-DESC              
A05317        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
A05317        ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
A05317     IF LINK-LOCATOR-ID > SPACES                                  
A05317        MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
A05317        MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
A05317        MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
A05317        MOVE LINK-LOCATOR-ID       TO MI-CHG-COLUMN-VALUE-TEXT    
A05317        MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
A05317        MOVE 'PF NUMBER'           TO MI-COLUMN-DESC              
A05317        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
A05317        ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE +13                         TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-NEW-ADDR-ID-NUM          TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE 'ADDRESS ID'                TO MI-COLUMN-DESC.          
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-NEW-PREMISE-NO-CHAR  TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE 'PREMISE NO'            TO MI-COLUMN-DESC.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5010-FORMATTED-TRANSHIST.                                        
                                                                        
            IF LINK-HOUSE-NO > SPACES                                   
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-HOUSE-NO         TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'HOUSE NUMBER'        TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-ADDR-PREFIX-1 > SPACES                              
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-ADDR-PREFIX-1     TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'ADDRESS PREFX 1'     TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-ADDR-PREFIX-2     > SPACES                          
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-ADDR-PREFIX-2     TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'ADDRESS PREFX 2'     TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-STREET-NAME > SPACES                                
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-STREET-NAME      TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'STREET NAME'         TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-STREET-SUFFIX > SPACES                              
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-STREET-SUFFIX     TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-ADDR-SUFFIX > SPACES                                
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-ADDR-SUFFIX      TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-STREET-LOC-1  > SPACES                              
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-STREET-LOC-1     TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'STREET LOC 1'        TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-STREET-LOC-2 > SPACES                               
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-STREET-LOC-2     TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'STREET LOC 2'        TO MI-COLUMN-DESC             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
            IF LINK-ADDRESS-OVERFLOW > SPACES                           
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE LINK-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'ADDR OVERFLOW'      TO MI-COLUMN-DESC              
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                      TO WS-TRAN-APPL-NO
            END-IF.           
                                                                        
           IF LINK-CROSS-STREET-1 > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-CROSS-STREET-1   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CROSS STREET 1'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
           IF LINK-CROSS-STREET-2 > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-CROSS-STREET-2     TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CROSS STREET 2 '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO
           END-IF.            
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5020-INTERSECTION-TRANSHIST.                                     
                                                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.            
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.    
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN.    
              MOVE LINK-STREET-NAME      TO MI-CHG-COLUMN-VALUE-TEXT.   
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.   
              MOVE 'STREET 1 NAME'       TO MI-COLUMN-DESC.             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.          
              ADD 1                      TO WS-TRAN-APPL-NO.            
                                                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.            
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.    
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN.    
              MOVE LINK-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT.   
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.   
              MOVE 'STREET 2 NAME  '     TO MI-COLUMN-DESC.             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.          
              ADD 1                      TO WS-TRAN-APPL-NO.            
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF PR-LOCAL-OFFICE NOT = LINK-LOCAL-OFFICE                   
              MOVE 'YES'                   TO WS-LOFC-CHANGED-FLAG      
                                              WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LOCAL-OFFICE > SPACES                             
                  MOVE +3                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-LOCAL-OFFICE   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-LOCAL-OFFICE > SPACES                               
                  MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-LOCAL-OFFICE     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'LOCAL OFFICE'          TO MI-COLUMN-DESC            
              MOVE 'B1'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              MOVE SPACES                  TO MI-TABLE-ID               
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-COMPANY-NO NOT = LINK-COMPANY-NO                       
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                              MI-PRV-COLUMN-VALUE-LEN   
              IF LINK-COMPANY-NO > SPACES                               
                  MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-COMPANY-NO     TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-COMPANY-NO > SPACES                                 
                  MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-COMPANY-NO       TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'COMPANY NO'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-BLOCK NOT = LINK-BLOCK                                 
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-BLOCK > SPACES                                    
                  MOVE +5                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-BLOCK          TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-BLOCK > SPACES                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-BLOCK            TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'BLOCK'                 TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-LOT NOT = LINK-LOT                                     
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LOT > SPACES                                      
                  MOVE +5                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-LOT            TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-LOT > SPACES                                        
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-LOT              TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'LOT'                   TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-REV-DISTRICT-CD NOT = LINK-REV-DISTRICT                
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
                                              WS-RDST-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                              MI-PRV-COLUMN-VALUE-LEN   
              IF LINK-REV-DISTRICT > SPACES                             
                  MOVE +35                  TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE LINK-REV-DISTRICT    TO A9-REV-DISTRICT-CD       
                  PERFORM 7030-SELECT-REVDIST THRU 7030-EXIT            
                  MOVE A9-REV-DISTRICT-DESC TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-REV-DISTRICT-CD > SPACES                            
                  MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE PR-REV-DISTRICT-CD   TO A9-REV-DISTRICT-CD       
                  PERFORM 7030-SELECT-REVDIST THRU 7030-EXIT            
                  MOVE A9-REV-DISTRICT-DESC TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'REV DISTRICT'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-SUBDIVISION-ID NOT = LINK-SUBDIVISION-ID               
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
                                              WS-SUBD-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE LINK-SUBDIVISION-ID     TO WS-SUBDIV-CODE-TO         
              MOVE PR-SUBDIVISION-ID       TO WS-SUBDIV-CODE-FROM       
              IF LINK-SUBDIVISION-ID > SPACES                           
                  MOVE +26                 TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-SUBDIVISION-ID TO B0-SUBDIVISION-ID         
                  MOVE LINK-COMPANY-NO     TO B0-COMPANY-NO             
                  PERFORM 7050-SUBDIVISION-DESC THRU 7050-EXIT          
                  MOVE B0-SUBDIVISION-DESC TO MI-CHG-COLUMN-VALUE-TEXT  
                                              WS-SUBDIV-WQ-TO           
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-SUBDIVISION-ID > SPACES                             
                  MOVE +26                 TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-SUBDIVISION-ID   TO B0-SUBDIVISION-ID         
                  MOVE LINK-COMPANY-NO     TO B0-COMPANY-NO             
                  PERFORM 7050-SUBDIVISION-DESC THRU 7050-EXIT          
                  MOVE B0-SUBDIVISION-DESC TO MI-PRV-COLUMN-VALUE-TEXT  
                                              WS-SUBDIV-WQ-FROM         
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'SUBDIVISION'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-CROSS-STREET-1 NOT = LINK-CROSS-STREET-1               
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-CROSS-STREET-1 > SPACES                           
                  MOVE +35                 TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-CROSS-STREET-1 TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-CROSS-STREET-1 > SPACES                             
                  MOVE +35                 TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-CROSS-STREET-1   TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'CROSS STREET 1'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-CROSS-STREET-2 NOT = LINK-CROSS-STREET-2               
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-CROSS-STREET-2 > SPACES                           
                  MOVE +35                 TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-CROSS-STREET-2 TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-CROSS-STREET-2 > SPACES                             
                  MOVE +35                 TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-CROSS-STREET-2   TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'CROSS STREET 2'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-COUNTY NOT = LINK-COUNTY                               
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE A4-STATE                TO SC-STATE                  
              IF LINK-COUNTY > SPACES                                   
                  MOVE +22                 TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-COUNTY         TO SC-COUNTY                 
                  PERFORM 7040-COUNTY-DESC THRU 7040-EXIT               
                  MOVE SC-COUNTY-DESC      TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-COUNTY > SPACES                                     
                  MOVE +22                 TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-COUNTY           TO SC-COUNTY                 
                  PERFORM 7040-COUNTY-DESC THRU 7040-EXIT               
                  MOVE SC-COUNTY-DESC      TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'COUNTY'                TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-LOCATOR-ID NOT = LINK-LOCATOR-ID                       
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LOCATOR-ID > SPACES                               
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-LOCATOR-ID TO MI-CHG-COLUMN-VALUE-TEXT      
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-LOCATOR-ID > SPACES                                 
                  MOVE +9                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-LOCATOR-ID       TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'PF NUMBER'             TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-GAS-LEAK-SURVEY-DT NOT = LINK-LEAK-SURVEY-DT           
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LEAK-SURVEY-DT > SPACES                           
                  MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-LEAK-SURVEY-DT TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-GAS-LEAK-SURVEY-DT > SPACES                         
                  MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-GAS-LEAK-SURVEY-DT TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'LEAK SURVEY DT'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-GAS-LK-SURVEY-FREQ NOT = LINK-LEAK-SURVEY-FREQ         
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LEAK-SURVEY-FREQ > SPACES                         
                  MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE LINK-LEAK-SURVEY-FREQ TO                         
                       MI-CHG-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                  MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN   
                  MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-GAS-LK-SURVEY-FREQ > SPACES                         
                  MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE PR-GAS-LK-SURVEY-FREQ TO                         
                       MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                  MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN   
                  MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'SURVEY FREQ'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-CITY-GATE-ID NOT = LINK-CITY-GATE-ID                   
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-CITY-GATE-ID > SPACES                             
                 MOVE +7                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-CITY-GATE-ID    TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-CITY-GATE-ID > SPACES                               
                 MOVE +7                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE PR-CITY-GATE-ID      TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'CITY GATE ID'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-READ-ROUTE NOT = LINK-READ-ROUTE                       
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
                                              WS-RRTE-CHANGED-FLAG
           END-IF.     
                                                                        
           IF PR-PREM-REF-LATITUDE NOT = LINK-LATITUDE                  
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
                                              WS-LALO-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LATITUDE NOT = ZEROES                             
                 MOVE LINK-LATITUDE        TO WS-DISPLAY-LAT-LONG       
                 MOVE WS-DISPLAY-LAT-LONG  TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN   
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-PREM-REF-LATITUDE NOT = ZEROES                      
                 MOVE +11                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE PR-PREM-REF-LATITUDE TO WS-DISPLAY-LAT-LONG       
                 MOVE WS-DISPLAY-LAT-LONG  TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'LATITUDE'              TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-PREM-REF-LONGITUDE NOT = LINK-LONGITUDE                
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
                                              WS-LALO-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-LONGITUDE NOT = ZEROES                            
                 MOVE LINK-LONGITUDE       TO WS-DISPLAY-LAT-LONG       
                 MOVE WS-DISPLAY-LAT-LONG  TO MI-CHG-COLUMN-VALUE-TEXT  
                 MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN   
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-PREM-REF-LONGITUDE NOT = ZEROES                     
                 MOVE +11                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE PR-PREM-REF-LONGITUDE TO WS-DISPLAY-LAT-LONG      
                 MOVE WS-DISPLAY-LAT-LONG  TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'LONGITUDE'             TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-AGL-PREM-NO NOT = LINK-AGL-PREMISE-NO                  
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-AGL-PREMISE-NO > ZEROES                           
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-AGL-PREMISE-NO   TO WS-DISPLAY-AGL-PREM-NO   
                 MOVE WS-DISPLAY-AGL-PREM-NO TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-AGL-PREM-NO > ZEROES                                
                 MOVE +9                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-AGL-PREM-NO        TO WS-DISPLAY-AGL-PREM-NO   
                 MOVE WS-DISPLAY-AGL-PREM-NO TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'AGL PREM NO'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-PREMISE-DIRECTIONS-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-DIRECTIONS-TEXT REPLACING                         
               ALL LOW-VALUES BY ' '.                                   
           IF PR-PREMISE-DIRECTIONS-TEXT <= SPACES                      
               MOVE SPACES TO PR-PREMISE-DIRECTIONS-TEXT
           END-IF.               
           IF WS-DIRECTIONS-TEXT <= SPACES                              
               MOVE SPACES TO WS-DIRECTIONS-TEXT
           END-IF.                       
           IF PR-PREMISE-DIRECTIONS-TEXT NOT = WS-DIRECTIONS-TEXT       
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-DIRECTIONS-TEXT > SPACES                            
                 MOVE +75                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-DIRECTIONS-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-PREMISE-DIRECTIONS-TEXT > SPACES                    
                 MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-PREMISE-DIRECTIONS-TEXT TO                     
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'DIRECTIONS'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-SCRATCH-PAD-TEXT REPLACING                        
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-SCRATCH-PAD-TEXT REPLACING                        
               ALL LOW-VALUES BY ' '.                                   
           IF PR-SCRATCH-PAD-TEXT <= SPACES                             
               MOVE SPACES TO PR-SCRATCH-PAD-TEXT
           END-IF.                      
           IF WS-SCRATCH-PAD-TEXT <= SPACES                             
               MOVE SPACES TO WS-SCRATCH-PAD-TEXT
           END-IF.                      
           IF PR-SCRATCH-PAD-TEXT NOT = WS-SCRATCH-PAD-TEXT             
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-SCRATCH-PAD-TEXT > SPACES                           
                 MOVE +75                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-SCRATCH-PAD-TEXT  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-SCRATCH-PAD-TEXT > SPACES                           
                 MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-SCRATCH-PAD-TEXT TO                            
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'SCRATCH PAD'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-SPCL-INSTRUCTIONS-TEXT REPLACING                  
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-SPECIAL-TEXT REPLACING                            
               ALL LOW-VALUES BY ' '.                                   
           IF PR-SPCL-INSTRUCTIONS-TEXT <= SPACES                       
               MOVE SPACES TO PR-SPCL-INSTRUCTIONS-TEXT
           END-IF.                
           IF WS-SPECIAL-TEXT <= SPACES                                 
               MOVE SPACES TO WS-SPECIAL-TEXT
           END-IF.                          
           IF PR-SPCL-INSTRUCTIONS-TEXT NOT = WS-SPECIAL-TEXT           
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-SPECIAL-TEXT > SPACES                               
                 MOVE +75                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-SPECIAL-TEXT TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-SPCL-INSTRUCTIONS-TEXT > SPACES                     
                 MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-SPCL-INSTRUCTIONS-TEXT TO                      
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'SPECIAL INST'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-SPCL-READ-INSTR-TEXT REPLACING                    
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-SPECIAL-READ-TEXT REPLACING                       
               ALL LOW-VALUES BY ' '.                                   
           IF PR-SPCL-READ-INSTR-TEXT <= SPACES                         
               MOVE SPACES TO PR-SPCL-READ-INSTR-TEXT
           END-IF.                  
           IF WS-SPECIAL-READ-TEXT <= SPACES                            
               MOVE SPACES TO WS-SPECIAL-READ-TEXT
           END-IF.                     
           IF PR-SPCL-READ-INSTR-TEXT NOT = WS-SPECIAL-READ-TEXT        
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-SPECIAL-READ-TEXT > SPACES                          
                 MOVE +75                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-SPECIAL-READ-TEXT TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-SPCL-READ-INSTR-TEXT > SPACES                       
                 MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-SPCL-READ-INSTR-TEXT TO                        
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'SPECIAL INST'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-DATE-SPCL-MSG-ENDS NOT = LINK-DATE-SPCL-MSG-ENDS       
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-DATE-SPCL-MSG-ENDS > SPACES                       
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-DATE-SPCL-MSG-ENDS TO                        
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-DATE-SPCL-MSG-ENDS > SPACES                         
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-DATE-SPCL-MSG-ENDS TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'DATE MSG ENDS'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-FM-ELEC-SVC-WKDIST-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           IF PR-FM-ELEC-SVC-WKDIST-TEXT <= SPACES                      
               MOVE SPACES TO PR-FM-ELEC-SVC-WKDIST-TEXT
           END-IF.               
           IF WS-FM-ELEC-SVC-WKDIST-TEXT <= SPACES                      
               MOVE SPACES TO WS-FM-ELEC-SVC-WKDIST-TEXT
           END-IF.               
           IF PR-FM-ELEC-SVC-WKDIST-TEXT NOT =                          
              WS-FM-ELEC-SVC-WKDIST-TEXT                                
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-FM-ELEC-SVC-WKDIST-TEXT > SPACES                    
                 MOVE +40                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-FM-ELEC-SVC-WKDIST-TEXT TO                     
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-FM-ELEC-SVC-WKDIST-TEXT > SPACES                    
                 MOVE +40                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-FM-ELEC-SVC-WKDIST-TEXT TO                     
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ELEC SVC WKD'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-FM-GAS-OPS-WKDIST-TEXT REPLACING                  
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-FM-GAS-OPS-WKDIST-TEXT REPLACING                  
               ALL LOW-VALUES BY ' '.                                   
           IF PR-FM-GAS-OPS-WKDIST-TEXT <= SPACES                       
               MOVE SPACES TO PR-FM-GAS-OPS-WKDIST-TEXT
           END-IF.                
           IF WS-FM-GAS-OPS-WKDIST-TEXT <= SPACES                       
               MOVE SPACES TO WS-FM-GAS-OPS-WKDIST-TEXT
           END-IF.                
           IF PR-FM-GAS-OPS-WKDIST-TEXT NOT =                           
              WS-FM-GAS-OPS-WKDIST-TEXT                                 
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-FM-GAS-OPS-WKDIST-TEXT > SPACES                     
                 MOVE +40                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-FM-GAS-OPS-WKDIST-TEXT TO                      
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-FM-GAS-OPS-WKDIST-TEXT > SPACES                     
                 MOVE +40                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-FM-GAS-OPS-WKDIST-TEXT TO                      
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'GAS OPS WKD'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-FM-FLD-SVCS-WKDIST-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           IF PR-FM-FLD-SVCS-WKDIST-TEXT <= SPACES                      
               MOVE SPACES TO PR-FM-FLD-SVCS-WKDIST-TEXT
           END-IF.               
           IF WS-FM-FLD-SVCS-WKDIST-TEXT <= SPACES                      
               MOVE SPACES TO WS-FM-FLD-SVCS-WKDIST-TEXT
           END-IF.               
           IF PR-FM-FLD-SVCS-WKDIST-TEXT NOT =                          
              WS-FM-FLD-SVCS-WKDIST-TEXT                                
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-FM-FLD-SVCS-WKDIST-TEXT > SPACES                    
                 MOVE +40                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-FM-FLD-SVCS-WKDIST-TEXT TO                     
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-FM-FLD-SVCS-WKDIST-TEXT > SPACES                    
                 MOVE +40                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-FM-FLD-SVCS-WKDIST-TEXT TO                     
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'FLD SVC WKD'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-FM-REV-PRT-WKDIST-TEXT REPLACING                  
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-FM-REV-PRT-WKDIST-TEXT REPLACING                  
               ALL LOW-VALUES BY ' '.                                   
           IF PR-FM-REV-PRT-WKDIST-TEXT <= SPACES                       
               MOVE SPACES TO PR-FM-REV-PRT-WKDIST-TEXT
           END-IF.                
           IF WS-FM-REV-PRT-WKDIST-TEXT <= SPACES                       
               MOVE SPACES TO WS-FM-REV-PRT-WKDIST-TEXT
           END-IF.                
           IF PR-FM-REV-PRT-WKDIST-TEXT NOT =                           
              WS-FM-REV-PRT-WKDIST-TEXT                                 
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-FM-REV-PRT-WKDIST-TEXT > SPACES                     
                 MOVE +40                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-FM-REV-PRT-WKDIST-TEXT TO                      
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-FM-REV-PRT-WKDIST-TEXT > SPACES                     
                 MOVE +40                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-FM-REV-PRT-WKDIST-TEXT TO                      
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'REV PRT WKD'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-FM-DSM-ESVC-WKDIST-TEXT REPLACING                 
               ALL LOW-VALUES BY ' '.                                   
           IF PR-FM-DSM-ESVC-WKDIST-TEXT <= SPACES                      
               MOVE SPACES TO PR-FM-DSM-ESVC-WKDIST-TEXT
           END-IF.               
           IF WS-FM-DSM-ESVC-WKDIST-TEXT <= SPACES                      
               MOVE SPACES TO WS-FM-DSM-ESVC-WKDIST-TEXT
           END-IF.               
           IF PR-FM-DSM-ESVC-WKDIST-TEXT NOT =                          
              WS-FM-DSM-ESVC-WKDIST-TEXT                                
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF WS-FM-DSM-ESVC-WKDIST-TEXT > SPACES                    
                 MOVE +40                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-FM-DSM-ESVC-WKDIST-TEXT TO                     
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-FM-DSM-ESVC-WKDIST-TEXT > SPACES                    
                 MOVE +40                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PR-FM-DSM-ESVC-WKDIST-TEXT TO                     
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'DSM ESVC WKD'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PR-DDDC-FCTR NOT = LINK-DDDC-FCTR                         
              MOVE 'YES'                   TO WS-PREM-CHANGED-FLAG      
                                              WS-DDDC-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-DDDC-FCTR > ZEROES                                
                 MOVE +18                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-DDDC-FCTR       TO WS-DISPLAY-DDDC           
                 MOVE WS-DISPLAY-DDDC      TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF PR-DDDC-FCTR > ZEROES                                  
                 MOVE +18                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE PR-DDDC-FCTR         TO WS-DISPLAY-DDDC           
                 MOVE WS-DISPLAY-DDDC      TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'DDDC FACTOR'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DDDC-CHANGED AND                                          
              PR-DDDC-FCTR-EFF-DT NOT = WS-CURRENT-DATE                 
                  MOVE 'YES'               TO WS-PREM-CHANGED-FLAG      
                  MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO           
                  IF WS-CURRENT-DATE > SPACES                           
                     MOVE +10              TO MI-CHG-COLUMN-VALUE-LEN   
                     MOVE WS-CURRENT-DATE  TO MI-CHG-COLUMN-VALUE-TEXT  
                  ELSE                                                  
                     MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN   
                     MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT  
                  END-IF                                                
                  IF PR-DDDC-FCTR-EFF-DT > ZEROES                       
                     MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN   
                     MOVE PR-DDDC-FCTR-EFF-DT TO                        
                          MI-PRV-COLUMN-VALUE-TEXT                      
                  ELSE                                                  
                     MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN   
                     MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT  
                  END-IF                                                
                  MOVE 'DDDC EFF DT'       TO MI-COLUMN-DESC            
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1                    TO WS-TRAN-APPL-NO           
               END-IF.                                                  
                                                                        
           IF DY-HOUSE-NO NOT = LINK-HOUSE-NO                           
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
                                              WS-Q346-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-HOUSE-NO > SPACES                                 
                 MOVE +15                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-HOUSE-NO        TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-HOUSE-NO > SPACES                                   
                 MOVE +15                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-HOUSE-NO          TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'HOUSE NUMBER'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-1 NOT = LINK-ADDR-PREFIX-1                 
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-ADDR-PREFIX-1 > SPACES                            
                 MOVE +3                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-ADDR-PREFIX-1   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ADDR-PREFIX-1 > SPACES                              
                 MOVE +3                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ADDR-PREFIX-1     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ADDRESS PREFX 1'       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-2 NOT = LINK-ADDR-PREFIX-2                 
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-ADDR-PREFIX-2 > SPACES                            
                 MOVE +2                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-ADDR-PREFIX-2   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ADDR-PREFIX-2 > SPACES                              
                 MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ADDR-PREFIX-2     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ADDRESS PREFX 2'       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-STREET-NAME NOT = LINK-STREET-NAME                     
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
                                              WS-Q346-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-STREET-NAME > SPACES                              
                 MOVE +30                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-STREET-NAME     TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-STREET-NAME > SPACES                                
                 MOVE +30                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-STREET-NAME       TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'STREET NAME'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-STREET-SUFFIX NOT = LINK-STREET-SUFFIX                 
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-STREET-SUFFIX > SPACES                            
                 MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-STREET-SUFFIX   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-STREET-SUFFIX > SPACES                              
                 MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-STREET-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'STREET SUFFIX'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ADDR-SUFFIX NOT = LINK-ADDR-SUFFIX                     
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-ADDR-SUFFIX > SPACES                              
                 MOVE +2                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-ADDR-SUFFIX                                  
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ADDR-SUFFIX > SPACES                                
                 MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ADDR-SUFFIX TO MI-PRV-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ADDRESS SUFFIX'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-1 NOT = LINK-STREET-LOC-1              
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
                                              WS-Q346-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-STREET-LOC-1 > SPACES                             
                 MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-STREET-LOC-1 TO                              
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-STREET-LOCATION-1 > SPACES                          
                 MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-STREET-LOCATION-1 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'STREET LOC 1'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-2 NOT = LINK-STREET-LOC-2              
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-STREET-LOC-2 > SPACES                             
                 MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-STREET-LOC-2 TO                              
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-STREET-LOCATION-2 > SPACES                          
                 MOVE +11                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-STREET-LOCATION-2 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'STREET LOC 2'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE NOT = LINK-ZIP-CODE                           
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
                                              WS-ZIPC-CHANGED-FLAG      
                                              WS-Q346-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-ZIP-CODE > SPACES                                 
                 MOVE +5                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-ZIP-CODE        TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ZIP-CODE > SPACES                                   
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ZIP-CODE          TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ZIP CODE'              TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR NOT = LINK-ZIP-CODE-PLUS-FOUR       
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-ZIP-CODE-PLUS-FOUR > SPACES                       
                 MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-ZIP-CODE-PLUS-FOUR TO                        
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ZIP-CODE-PLUS-FOUR > SPACES                         
                 MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ZIP CODE +4'           TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-TOKEN NOT = A4-ZIP-CODE-TOKEN                 
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF A4-ZIP-CODE-TOKEN > SPACES                             
                 MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE A4-ZIP-CODE-TOKEN    TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ZIP-CODE-TOKEN > SPACES                             
                 MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ZIP-CODE-TOKEN    TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ZIP CODE TOKEN'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-USPS-DELIV-PT-CD NOT = LINK-DELIVERY-POINT             
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-DELIVERY-POINT > SPACES                           
                 MOVE +2                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-DELIVERY-POINT  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-USPS-DELIV-PT-CD > SPACES                           
                 MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-USPS-DELIV-PT-CD  TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'DELIVERY POINT '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF DY-ADDRESS-OVERFLOW NOT = LINK-ADDRESS-OVERFLOW           
              MOVE 'YES'                   TO WS-ADDR-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-ADDRESS-OVERFLOW > SPACES                         
                 MOVE +35                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-ADDRESS-OVERFLOW TO                          
                      MI-CHG-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF DY-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE DY-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'ADDR. OVERFLOW '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GIS-DEFAULTS.                                               
                                                                        
      *    EXEC SQL                                                             
      *       SELECT LOCAL_OFFICE,                                              
      *              REV_DISTRICT_CD,                                           
      *              COUNT(*)                                                   
      *         INTO :ZT-LOCAL-OFFICE,                                          
      *              :ZT-REV-DISTRICT-CD,                                       
      *              :WS-ZIPCODE-COUNT                                          
      *         FROM CSS_PREMISE PR,                                            
      *              CSS_ADDR_FORMATTED DY                                      
      *        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
      *          AND DY.ADDRESS_ID = PR.ADDRESS_ID                              
      *        GROUP BY LOCAL_OFFICE,                                           
      *                 REV_DISTRICT_CD                                         
      *        ORDER BY 3 DESC                                                  
      *        FETCH FIRST 1 ROWS ONLY                                          
      *        WITH UR                                                          
      *        QUERYNO 70001                                                    
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    EVALUATE WS-ACTIVE-RETURN-CODE                                       
      *        WHEN SUCCESSFUL-CALL                                             
      *            CONTINUE                                                     
      *        WHEN NOT-FOUND                                                   
      *            MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                         
      *            MOVE '%%%' TO ZT-REV-DISTRICT-CD                             
      *                          ZT-LOCAL-OFFICE                                
      *        WHEN OTHER                                                       
      *            MOVE PROGRAM-NAME      TO ABEND-PROGRAM                      
      *            MOVE '7000'            TO ACTIVE-PARAGRAPH                   
      *            MOVE 'SELECT'          TO ABEND-FUNCTION                     
      *            MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                         
      *            MOVE 'CSS_PREMISE'     TO TABLE-1                            
      *            MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1                    
      *            MOVE ZT-ZIP-CODE       TO HOSTVAR-ELEMENT-1                  
      *            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                
      *            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                
      *    END-EVALUATE.                                                        
                                                                        
      *    EXEC SQL                                                             
      *       SELECT LOCAL_OFFICE,                                              
      *              REV_DISTRICT_CD,                                           
      *              READ_ROUTE                                                 
      *         INTO :ZT-LOCAL-OFFICE,                                          
      *              :ZT-REV-DISTRICT-CD,                                       
      *              :ZT-READ-ROUTE                                             
      *         FROM CSS_ZIPCODE_LO_RT                                          
      *        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
      *          AND REV_DISTRICT_CD LIKE :ZT-REV-DISTRICT-CD                   
      *          AND LOCAL_OFFICE LIKE :ZT-LOCAL-OFFICE                         
      *        FETCH FIRST 1 ROWS ONLY                                          
      *        WITH UR                                                          
      *        QUERYNO 70002                                                    
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    EVALUATE WS-ACTIVE-RETURN-CODE                                       
      *        WHEN SUCCESSFUL-CALL                                             
      *            CONTINUE                                                     
      *        WHEN NOT-FOUND                                                   
      *            MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                         
      *            INITIALIZE DCLCSS-ZIPCODE-LO-RT                              
      *            IF CSR-DATABASE AND                                          
      *               NOT-PO-BOX                                                
      *                   EVALUATE LINK-COMPANY-NO                              
      *                       WHEN '01'                                         
      *                           MOVE '999' TO ZT-REV-DISTRICT-CD              
      *                       WHEN '26'                                         
      *                           MOVE '997' TO ZT-REV-DISTRICT-CD              
      *                   END-EVALUATE                                          
      *            END-IF                                                       
      *        WHEN OTHER                                                       
      *            MOVE PROGRAM-NAME      TO ABEND-PROGRAM                      
      *            MOVE '7000'            TO ACTIVE-PARAGRAPH                   
      *            MOVE 'SELECT'          TO ABEND-FUNCTION                     
      *            MOVE 'CSS_ZIPCODE_LO_RT' TO TABLE-1                          
      *            MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1                    
      *            MOVE ZT-ZIP-CODE       TO HOSTVAR-ELEMENT-1                  
      *            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                
      *            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                
      *    END-EVALUATE.                                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE,
              REV_DISTRICT_CD,
              COUNT(*)                                           
                INTO :ZT-LOCAL-OFFICE,                                  
                     :ZT-REV-DISTRICT-CD,                               
                     :WS-ZIPCODE-COUNT                                  
                FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                    
               WHERE ZIP_CODE = :ZT-ZIP-CODE                            
               GROUP BY LOCAL_OFFICE,                                   
                        REV_DISTRICT_CD                                 
               ORDER BY 3 DESC                                          
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              COUNT(*)                                                   
MFA-TR*         INTO :ZT-LOCAL-OFFICE,                                          
MFA-TR*              :ZT-REV-DISTRICT-CD,                                       
MFA-TR*              :WS-ZIPCODE-COUNT                                          
MFA-TR*         FROM CSS_ZIPCODE_LO_RT                                          
MFA-TR*        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
MFA-TR*        GROUP BY LOCAL_OFFICE,                                           
MFA-TR*                 REV_DISTRICT_CD                                         
MFA-TR*        ORDER BY 3 DESC                                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 70001                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE '%%%' TO ZT-REV-DISTRICT-CD                     
                                 ZT-LOCAL-OFFICE                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '70001'           TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIPCODE_LO_RT' TO TABLE-1                  
                   MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1            
                   MOVE ZT-ZIP-CODE       TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE,
              REV_DISTRICT_CD,
              READ_ROUTE                                         
                INTO :ZT-LOCAL-OFFICE,                                  
                     :ZT-REV-DISTRICT-CD,                               
                     :ZT-READ-ROUTE                                     
                FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                    
               WHERE ZIP_CODE = :ZT-ZIP-CODE                            
                 AND REV_DISTRICT_CD LIKE :ZT-REV-DISTRICT-CD           
                 AND LOCAL_OFFICE LIKE :ZT-LOCAL-OFFICE                 
               ORDER BY LAST_UPDATE_TS                                  
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              READ_ROUTE                                                 
MFA-TR*         INTO :ZT-LOCAL-OFFICE,                                          
MFA-TR*              :ZT-REV-DISTRICT-CD,                                       
MFA-TR*              :ZT-READ-ROUTE                                             
MFA-TR*         FROM CSS_ZIPCODE_LO_RT                                          
MFA-TR*        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
MFA-TR*          AND REV_DISTRICT_CD LIKE :ZT-REV-DISTRICT-CD                   
MFA-TR*          AND LOCAL_OFFICE LIKE :ZT-LOCAL-OFFICE                         
MFA-TR*        ORDER BY LAST_UPDATE_TS                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 70002                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ZIPCODE-LO-RT                      
                   IF CSR-DATABASE AND                                  
                      NOT-PO-BOX                                        
                          EVALUATE LINK-COMPANY-NO                      
                              WHEN '01'                                 
                                  MOVE '999' TO ZT-REV-DISTRICT-CD      
                                  MOVE '199' TO ZT-LOCAL-OFFICE         
                              WHEN '26'                                 
                                  MOVE '997' TO ZT-REV-DISTRICT-CD      
                                  MOVE '299' TO ZT-LOCAL-OFFICE         
                          END-EVALUATE                                  
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '70002'           TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIPCODE_LO_RT' TO TABLE-1                  
                   MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1            
                   MOVE ZT-ZIP-CODE       TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-DEFAULT-READ-ROUTE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) READ_ROUTE                                         
                INTO :ZT-READ-ROUTE                                     
                FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                    
               WHERE ZIP_CODE = :ZT-ZIP-CODE                            
                 AND LOCAL_OFFICE = :ZT-LOCAL-OFFICE                    
                 AND REV_DISTRICT_CD = :ZT-REV-DISTRICT-CD              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_ROUTE                                                 
MFA-TR*         INTO :ZT-READ-ROUTE                                             
MFA-TR*         FROM CSS_ZIPCODE_LO_RT                                          
MFA-TR*        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
MFA-TR*          AND LOCAL_OFFICE = :ZT-LOCAL-OFFICE                            
MFA-TR*          AND REV_DISTRICT_CD = :ZT-REV-DISTRICT-CD                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  ZT-READ-ROUTE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7010'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIPCODE_LO_RT' TO TABLE-1                  
                   MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1            
                   MOVE ZT-ZIP-CODE       TO HOSTVAR-ELEMENT-1          
                   MOVE 'LOCAL_OFFICE'    TO TABLE-ELEMENT-2            
                   MOVE ZT-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-2          
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-3            
                   MOVE ZT-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-3         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-DEFAULT-CITY-GATE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CITY_GATE_ID                                       
                INTO :C0-CITY-GATE-ID                                   
                FROM CSS_CITY_GATE WITH(READUNCOMMITTED)                        
               WHERE LOCAL_OFFICE = :C0-LOCAL-OFFICE                    
               ORDER BY CITY_GATE_ID                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CITY_GATE_ID                                               
MFA-TR*         INTO :C0-CITY-GATE-ID                                           
MFA-TR*         FROM CSS_CITY_GATE                                              
MFA-TR*        WHERE LOCAL_OFFICE = :C0-LOCAL-OFFICE                            
MFA-TR*        ORDER BY CITY_GATE_ID                                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-CITY-GATE                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7020'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_CITY_GATE'   TO TABLE-1                    
                   MOVE 'LOCAL_OFFICE'    TO TABLE-ELEMENT-1            
                   MOVE C0-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-REVDIST.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COUNTY,
              REV_DISTRICT_DESC                                  
                INTO :A9-COUNTY,                                        
                     :A9-REV-DISTRICT-DESC                              
                FROM CSS_REV_DISTRICT WITH(READUNCOMMITTED)                     
               WHERE REV_DISTRICT_CD = :A9-REV-DISTRICT-CD              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNTY,                                                    
MFA-TR*              REV_DISTRICT_DESC                                          
MFA-TR*         INTO :A9-COUNTY,                                                
MFA-TR*              :A9-REV-DISTRICT-DESC                                      
MFA-TR*         FROM CSS_REV_DISTRICT                                           
MFA-TR*        WHERE REV_DISTRICT_CD = :A9-REV-DISTRICT-CD                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-REV-DISTRICT                       
                   MOVE '000' TO A9-COUNTY                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7030'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_REV_DISTRICT' TO TABLE-1                   
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-1            
                   MOVE A9-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-COUNTY-DESC.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COUNTY_DESC                                        
                INTO :SC-COUNTY-DESC                                    
                FROM CSS_STATE_COUNTY WITH(READUNCOMMITTED)                     
               WHERE COUNTY = :SC-COUNTY                                
                 AND STATE  = :SC-STATE                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNTY_DESC                                                
MFA-TR*         INTO :SC-COUNTY-DESC                                            
MFA-TR*         FROM CSS_STATE_COUNTY                                           
MFA-TR*        WHERE COUNTY = :SC-COUNTY                                        
MFA-TR*          AND STATE  = :SC-STATE                                         
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'UNKNOWN' TO SC-COUNTY-DESC                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7040'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_STATE_COUNTY' TO TABLE-1                   
                   MOVE 'COUNTY'          TO TABLE-ELEMENT-1            
                   MOVE SC-COUNTY         TO HOSTVAR-ELEMENT-1          
                   MOVE 'STATE'           TO TABLE-ELEMENT-2            
                   MOVE SC-STATE          TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SUBDIVISION-DESC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SUBDIVISION_DESC                                   
                INTO :B0-SUBDIVISION-DESC                               
                FROM CSS_SUBDIVISION WITH(READUNCOMMITTED)                      
               WHERE SUBDIVISION_ID = :B0-SUBDIVISION-ID                
                 AND COMPANY_NO     = :B0-COMPANY-NO                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBDIVISION_DESC                                           
MFA-TR*         INTO :B0-SUBDIVISION-DESC                                       
MFA-TR*         FROM CSS_SUBDIVISION                                            
MFA-TR*        WHERE SUBDIVISION_ID = :B0-SUBDIVISION-ID                        
MFA-TR*          AND COMPANY_NO     = :B0-COMPANY-NO                            
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-SUBDIVISION                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7050'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SUBDIVISION' TO TABLE-1                    
                   MOVE 'SUBDIVISION_ID'  TO TABLE-ELEMENT-1            
                   MOVE B0-SUBDIVISION-ID TO HOSTVAR-ELEMENT-1          
                   MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-2            
                   MOVE B0-COMPANY-NO     TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                ORDER BY ZIP_CODE_TOKEN                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         ORDER BY ZIP_CODE_TOKEN                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7060'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIP_CODE'    TO TABLE-1                    
                   MOVE 'TOWN'            TO TABLE-ELEMENT-1            
                   MOVE A4-TOWN           TO HOSTVAR-ELEMENT-1          
                   MOVE 'STATE'           TO TABLE-ELEMENT-2            
                   MOVE A4-STATE          TO HOSTVAR-ELEMENT-2          
                   MOVE 'ZIP CODE'        TO TABLE-ELEMENT-3            
                   MOVE A4-ZIP-CODE       TO HOSTVAR-ELEMENT-3          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-REG-LOCAL-OFFICE.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE                                       
                INTO :B1-LOCAL-OFFICE                                   
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE NOT STATUS_CD = 'I'                                
                 AND NOT LOCAL_OFFICE = '000'                           
                 AND REGULATED_CD = '02'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*         INTO :B1-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE NOT STATUS_CD = 'I'                                        
MFA-TR*          AND NOT LOCAL_OFFICE = '000'                                   
MFA-TR*          AND REGULATED_CD = '02'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_LOCAL_OFFICE'    TO TABLE-1                     
              MOVE 'REGULATED'           TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7075-SELECT-DEREG-LOCAL-OFFICE.                                  
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE                                       
                INTO :B1-LOCAL-OFFICE                                   
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE NOT STATUS_CD = 'I'                                
                 AND NOT LOCAL_OFFICE = '000'                           
                 AND NOT REGULATED_CD = '02'                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*         INTO :B1-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE NOT STATUS_CD = 'I'                                        
MFA-TR*          AND NOT LOCAL_OFFICE = '000'                                   
MFA-TR*          AND NOT REGULATED_CD = '02'                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7075                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7075'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_LOCAL_OFFICE'    TO TABLE-1                     
              MOVE 'DEREGULATED'         TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID,
              LOCAL_OFFICE                                       
                INTO :PF-RESP-AREA-ID,                                  
                     :PF-LOCAL-OFFICE                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID,                                              
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :PF-RESP-AREA-ID,                                          
MFA-TR*              :PF-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-CHECK-SECURITY.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-BOT-TEAM-MEMBER                                
ACT006          FROM CSS_CATEGORY WITH(READUNCOMMITTED)                         
ACT006         WHERE CATEGORY_ID IN (310,9999)                          
ACT006           AND USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-BOT-TEAM-MEMBER                                        
MFA-TR*         FROM CSS_CATEGORY                                               
MFA-TR*        WHERE CATEGORY_ID IN (310,9999)                                  
MFA-TR*          AND USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-BOT-TEAM-MEMBER                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-BOT-TEAM-MEMBER                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
ACT006             MOVE 'CSS_CATEGORY'   TO TABLE-1                     
                   MOVE 'USER_ID'        TO TABLE-ELEMENT-1             
                   MOVE LINK-USERID      TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :LINK-COMPANY-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :LINK-COMPANY-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7100'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-ZIPCODE-LO-RT.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES'                                              
                INTO :WS-ZT-EXISTS-FLAG                                 
                FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                    
               WHERE ZIP_CODE = :ZT-ZIP-CODE                            
                 AND LOCAL_OFFICE = :ZT-LOCAL-OFFICE                    
                 AND REV_DISTRICT_CD = :ZT-REV-DISTRICT-CD              
                 AND READ_ROUTE = :ZT-READ-ROUTE                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES'                                                      
MFA-TR*         INTO :WS-ZT-EXISTS-FLAG                                         
MFA-TR*         FROM CSS_ZIPCODE_LO_RT                                          
MFA-TR*        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
MFA-TR*          AND LOCAL_OFFICE = :ZT-LOCAL-OFFICE                            
MFA-TR*          AND REV_DISTRICT_CD = :ZT-REV-DISTRICT-CD                      
MFA-TR*          AND READ_ROUTE = :ZT-READ-ROUTE                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'YES' TO WS-ZT-EXISTS-FLAG                      
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'NO' TO WS-ZT-EXISTS-FLAG                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7110'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIPCODE_LO_RT' TO TABLE-1                  
                   MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1            
                   MOVE ZT-ZIP-CODE       TO HOSTVAR-ELEMENT-1          
                   MOVE 'LOCAL_OFFICE'    TO TABLE-ELEMENT-2            
                   MOVE ZT-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-2          
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-3            
                   MOVE ZT-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-3         
                   MOVE 'READ_ROUTE'      TO TABLE-ELEMENT-4            
                   MOVE ZT-READ-ROUTE     TO HOSTVAR-ELEMENT-4          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-ZIPCODE-SUBDIV.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES'                                              
                INTO :WS-ZS-EXISTS-FLAG                                 
                FROM CSS_ZIPCODE_SUBDIV WITH(READUNCOMMITTED)                   
               WHERE ZIP_CODE = :ZS-ZIP-CODE                            
                 AND SUBDIVISION_ID = :ZS-SUBDIVISION-ID                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES'                                                      
MFA-TR*         INTO :WS-ZS-EXISTS-FLAG                                         
MFA-TR*         FROM CSS_ZIPCODE_SUBDIV                                         
MFA-TR*        WHERE ZIP_CODE = :ZS-ZIP-CODE                                    
MFA-TR*          AND SUBDIVISION_ID = :ZS-SUBDIVISION-ID                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'YES' TO WS-ZS-EXISTS-FLAG                      
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'NO' TO WS-ZS-EXISTS-FLAG                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7120'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIPCODE_SUBDIV]' TO TABLE-1                
                   MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-1            
                   MOVE ZS-ZIP-CODE       TO HOSTVAR-ELEMENT-1          
                   MOVE 'SUBDIVISION_ID'  TO TABLE-ELEMENT-2            
                   MOVE ZS-SUBDIVISION-ID TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SERVICE-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SERV_ORDER_NO                                      
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ORDER_STATE_CD <> 'C'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT SERV_ORDER_NO                                      14210000
MFA-TR*         INTO :VO-SERV-ORDER-NO                                  14380000
MFA-TR*         FROM CSS_SO_DATA                                        14550000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*          AND ORDER_STATE_CD ^= 'C'                                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-SO-DATA                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7130'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA' TO TABLE-1                        
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-PREM-RELEASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RLSE_NO                                            
                INTO :RP-RLSE-NO                                        
                FROM CSS_PREM_RLSE_DATA WITH(READUNCOMMITTED)                   
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT RLSE_NO                                            14210000
MFA-TR*         INTO :RP-RLSE-NO                                        14380000
MFA-TR*         FROM CSS_PREM_RLSE_DATA                                 14550000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-PREM-RLSE-DATA                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7140'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-SEB-REV-DISTRICT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REV_DISTRICT_CD                                    
                INTO :ZT-REV-DISTRICT-CD                                
                FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                    
               WHERE ZIP_CODE = :ZT-ZIP-CODE                            
                 AND LOCAL_OFFICE = :ZT-LOCAL-OFFICE                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REV_DISTRICT_CD                                            
MFA-TR*         INTO :ZT-REV-DISTRICT-CD                                        
MFA-TR*         FROM CSS_ZIPCODE_LO_RT                                          
MFA-TR*        WHERE ZIP_CODE = :ZT-ZIP-CODE                                    
MFA-TR*          AND LOCAL_OFFICE = :ZT-LOCAL-OFFICE                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ZIPCODE-LO-RT                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE '001' TO ZT-REV-DISTRICT-CD                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7150'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ZIPCODE_LO_RT' TO TABLE-1                  
                   MOVE 'ZIP_CODE' TO TABLE-ELEMENT-1                   
                   MOVE ZT-ZIP-CODE TO HOSTVAR-ELEMENT-1                
                   MOVE 'LOCAL_OFFICE' TO TABLE-ELEMENT-1               
                   MOVE ZT-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-LANDLORD.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
                INTO :SI-CUSTOMER-NO                                    
                FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT CUSTOMER_NO                                        14210000
MFA-TR*         INTO :SI-CUSTOMER-NO                                    14380000
MFA-TR*         FROM CSS_LANDLORD                                       14550000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-LANDLORD                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7160'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD' TO TABLE-1                       
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-ACCOUNTS-EXIST.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72001                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  AT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7200'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :HA-ACCOUNT-NO                                     
                FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :HA-ACCOUNT-NO                                             
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72002                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  HA-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7200'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'HST_ACCOUNT'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-GAS-LINE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XO.SERVICE_NO                                      
                INTO :XO-SERVICE-NO                                     
                FROM CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED),                
                     CSS_PREM_GAS_LINE Y0 WITH(READUNCOMMITTED)                 
               WHERE Y0.PREMISE_NO = :PR-PREMISE-NO                     
                 AND XO.SERVICE_NO = Y0.SERVICE_NO                      
                 AND XO.SERV_LINE_STAT_FL IN ('A', 'T', 'U')            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XO.SERVICE_NO                                              
MFA-TR*         INTO :XO-SERVICE-NO                                             
MFA-TR*         FROM CSS_GAS_SERV_LINE XO,                                      
MFA-TR*              CSS_PREM_GAS_LINE Y0                                       
MFA-TR*        WHERE Y0.PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*          AND XO.SERVICE_NO = Y0.SERVICE_NO                              
MFA-TR*          AND XO.SERV_LINE_STAT_FL IN ('A', 'T', 'U')                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  XO-SERVICE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7210'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_GAS_SERV_LINE' TO TABLE-1                  
                   MOVE 'CSS_PREM_GAS_LINE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-GAS-UTILITY-EXISTS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_UTIL_TYPE                                     
                INTO :UT-CODE-UTIL-TYPE                                 
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                        
                 AND CODE_UTIL_TYPE = 'G'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_UTIL_TYPE                                             
MFA-TR*         INTO :UT-CODE-UTIL-TYPE                                         
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                                
MFA-TR*          AND CODE_UTIL_TYPE = 'G'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO UT-CODE-UTIL-TYPE                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7220'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE UT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-SELECT-CURRENT-ACCOUNT.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              ACCOUNT_TYPE_CODE,
              CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT, 121), 
           ' ', '-'), ':', '.') ACCT_CREATE_DT,
              CODE_ACCT_STAT,
              BILL_CYCLE,
              BILL_CYCLE_CHG_CD                                  
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CREDIT-GROUP,                                  
                     :AT-ACCT-CREATE-DT,                                
                     :AT-CODE-ACCT-STAT,                                
                     :AT-BILL-CYCLE,                                    
                     :AT-BILL-CYCLE-CHG-CD                              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              BILL_CYCLE_CHG_CD                                          
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-ACCT-CREATE-DT,                                        
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-BILL-CYCLE-CHG-CD                                      
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7230                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCOUNT                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7230'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-ACCOUNT-TYPES.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO,
              CUSTOMER_NO                                        
                INTO :WS-PENDING-ACCT-NO,                               
                     :WS-PENDING-CUST-NO                                
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND CODE_ACCT_STAT = 'P'                               
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*         INTO :WS-PENDING-ACCT-NO,                                       
MFA-TR*              :WS-PENDING-CUST-NO                                        
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND CODE_ACCT_STAT = 'P'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72401                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-PENDING-ACCOUNT                       
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-PENDING-ACCOUNT                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7240'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT 1'        TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO,
              CUSTOMER_NO                                        
                INTO :WS-ACTIVE-ACCT-NO,                                
                     :WS-ACTIVE-CUST-NO                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND CODE_ACCT_STAT = 'A'                               
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*         INTO :WS-ACTIVE-ACCT-NO,                                        
MFA-TR*              :WS-ACTIVE-CUST-NO                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND CODE_ACCT_STAT = 'A'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72402                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ACTIVE-ACCOUNT                        
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-ACTIVE-ACCOUNT                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7240'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT 2'        TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF WS-ACTIVE-ACCOUNT = 'N' AND                               
              WS-PENDING-ACCOUNT = 'N'                                  
                   EXEC SQL                                             
                      SELECT TOP(1) ACCOUNT_NO,
              CUSTOMER_NO                                
                        INTO :WS-ACTIVE-ACCT-NO,                        
                             :WS-ACTIVE-CUST-NO                         
                        FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                  
                       WHERE PREMISE_NO = :PR-PREMISE-NO                
                         AND CODE_ACCT_STAT IN ('B', 'S', 'J')          
                                                 
                                                                 
                                                           
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*            EXEC SQL                                                     
MFA-TR*               SELECT ACCOUNT_NO,                                        
MFA-TR*                      CUSTOMER_NO                                        
MFA-TR*                 INTO :WS-ACTIVE-ACCT-NO,                                
MFA-TR*                      :WS-ACTIVE-CUST-NO                                 
MFA-TR*                 FROM CSS_ACCOUNT                                        
MFA-TR*                WHERE PREMISE_NO = :PR-PREMISE-NO                        
MFA-TR*                  AND CODE_ACCT_STAT IN ('B', 'S', 'J')                  
MFA-TR*                FETCH FIRST 1 ROWS ONLY                                  
MFA-TR*                WITH UR                                                  
MFA-TR*                QUERYNO 72403                                            
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                
                   EVALUATE WS-ACTIVE-RETURN-CODE                       
                       WHEN SUCCESSFUL-CALL                             
                           MOVE 'Y' TO WS-OTHER-ACCOUNT                 
                       WHEN NOT-FOUND                                   
                           MOVE ZEROES TO WS-ACTIVE-RETURN-CODE         
                           MOVE 'N' TO WS-OTHER-ACCOUNT                 
                       WHEN OTHER                                       
                           MOVE PROGRAM-NAME TO ABEND-PROGRAM           
                           MOVE '7240'    TO ACTIVE-PARAGRAPH           
                           MOVE 'SELECT 3' TO ABEND-FUNCTION            
                           MOVE 'CSS_ACCOUNT' TO TABLE-1                
                           MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1         
                           MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1      
                           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT
                           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
                   END-EVALUATE
           END-IF.                                        
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-NEW-SET-CHECK.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SERV_ORDER_NO                                      
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ORDER_TYPE_CD = 'FM002'                            
                 AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERV_ORDER_NO                                              
MFA-TR*         INTO :VO-SERV-ORDER-NO                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND ORDER_TYPE_CD = 'FM002'                                    
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-NEW-SET-CONDITION                     
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-NEW-SET-CONDITION                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7250'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_DATA'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-GET-AMOUNT.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RATE_ITEM_CD                                       
                INTO :ZS-RATE-ITEM-CD                                   
                FROM CSS_ZIPCODE_SUBDIV WITH(READUNCOMMITTED)                   
               WHERE SUBDIVISION_ID = :ZS-SUBDIVISION-ID                
                 AND ZIP_CODE = :ZS-ZIP-CODE                            
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_ITEM_CD                                               
MFA-TR*         INTO :ZS-RATE-ITEM-CD                                           
MFA-TR*         FROM CSS_ZIPCODE_SUBDIV                                         
MFA-TR*        WHERE SUBDIVISION_ID = :ZS-SUBDIVISION-ID                        
MFA-TR*          AND ZIP_CODE = :ZS-ZIP-CODE                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72601                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  ZS-RATE-ITEM-CD                       
A05317                            UP-PRICE-PER-SERV                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7260'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT 1'        TO ABEND-FUNCTION             
                   MOVE 'CSS_ZIPCODE_SUBDIV' TO TABLE-1                 
                   MOVE 'SUBDIVISION_ID'  TO TABLE-ELEMENT-1            
                   MOVE ZS-SUBDIVISION-ID TO HOSTVAR-ELEMENT-1          
                   MOVE 'ZIP_CODE'        TO TABLE-ELEMENT-2            
                   MOVE ZS-ZIP-CODE       TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF ZS-RATE-ITEM-CD > 0                                       
               EXEC SQL                                                 
                  SELECT TOP(1) PRICE_PER_SERV                                 
                    INTO :UP-PRICE-PER-SERV                             
                    FROM CSS_UNMTR_PLAN WITH(READUNCOMMITTED)                   
                   WHERE RATE_PLAN_NO = '064'                           
                     AND CODE_UTIL_TYPE = 'U'                           
                     AND RATE_ITEM_CODE = :ZS-RATE-ITEM-CD              
                     AND VERSION_NO_CNTRL =                             
                        (SELECT MAX(VERSION_NO_CNTRL)                   
                           FROM CSS_UNMTR_PLAN WITH(READUNCOMMITTED)            
                          WHERE RATE_PLAN_NO = '064'                    
                            AND CODE_UTIL_TYPE = 'U'                    
                            AND RATE_ITEM_CODE = :ZS-RATE-ITEM-CD)      
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT PRICE_PER_SERV                                         
MFA-TR*             INTO :UP-PRICE-PER-SERV                                     
MFA-TR*             FROM CSS_UNMTR_PLAN                                         
MFA-TR*            WHERE RATE_PLAN_NO = '064'                                   
MFA-TR*              AND CODE_UTIL_TYPE = 'U'                                   
MFA-TR*              AND RATE_ITEM_CODE = :ZS-RATE-ITEM-CD                      
MFA-TR*              AND VERSION_NO_CNTRL =                                     
MFA-TR*                 (SELECT MAX(VERSION_NO_CNTRL)                           
MFA-TR*                    FROM CSS_UNMTR_PLAN                                  
MFA-TR*                   WHERE RATE_PLAN_NO = '064'                            
MFA-TR*                     AND CODE_UTIL_TYPE = 'U'                            
MFA-TR*                     AND RATE_ITEM_CODE = :ZS-RATE-ITEM-CD)              
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 72602                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       CONTINUE                                         
                   WHEN NOT-FOUND                                       
                       MOVE ZEROES TO WS-ACTIVE-RETURN-CODE             
                                      UP-PRICE-PER-SERV                 
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME  TO ABEND-PROGRAM              
                       MOVE '7260'        TO ACTIVE-PARAGRAPH           
                       MOVE 'SELECT 2'    TO ABEND-FUNCTION             
                       MOVE 'CSS_UNMTR_PLAN' TO TABLE-1                 
                       MOVE 'RATE_ITEM_CD' TO TABLE-ELEMENT-1           
                       MOVE ZS-RATE-ITEM-CD TO HOSTVAR-ELEMENT-1        
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE
           END-IF.                                            
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7270-SELECT-READ-ROUTE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) READ_ROUTE                                         
                INTO :UT-READ-ROUTE                                     
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
               ORDER BY READ_ROUTE DESC                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_ROUTE                                                 
MFA-TR*         INTO :UT-READ-ROUTE                                             
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        ORDER BY READ_ROUTE DESC                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  UT-READ-ROUTE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7250'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-OLD-READ-CYCLE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) READ_CYCLE                                         
                INTO :UT-READ-CYCLE                                     
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND READ_ROUTE = :UT-READ-ROUTE                        
               ORDER BY READ_ROUTE DESC                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE                                                 
MFA-TR*         INTO :UT-READ-CYCLE                                             
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND READ_ROUTE = :UT-READ-ROUTE                                
MFA-TR*        ORDER BY READ_ROUTE DESC                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  UT-READ-CYCLE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7280'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   MOVE 'READ_ROUTE'      TO TABLE-ELEMENT-1            
                   MOVE UT-READ-ROUTE     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7290-NEW-READ-CYCLE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) READ_CYCLE                                         
                INTO :O2-READ-CYCLE                                     
                FROM CSS_LOC_OFF_CYC_RT WITH(READUNCOMMITTED)                   
               WHERE LOCAL_OFFICE = :O2-LOCAL-OFFICE                    
                 AND READ_ROUTE = :O2-READ-ROUTE                        
                 AND COMPANY_NO = :O2-COMPANY-NO                        
               ORDER BY READ_ROUTE DESC                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE                                                 
MFA-TR*         INTO :O2-READ-CYCLE                                             
MFA-TR*         FROM CSS_LOC_OFF_CYC_RT                                         
MFA-TR*        WHERE LOCAL_OFFICE = :O2-LOCAL-OFFICE                            
MFA-TR*          AND READ_ROUTE = :O2-READ-ROUTE                                
MFA-TR*          AND COMPANY_NO = :O2-COMPANY-NO                                
MFA-TR*        ORDER BY READ_ROUTE DESC                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE UT-READ-CYCLE TO O2-READ-CYCLE                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7290'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_LOC_OFF_CYC_RT' TO TABLE-1                 
                   MOVE 'LOCAL_OFFICE'    TO TABLE-ELEMENT-1            
                   MOVE O2-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-1          
                   MOVE 'READ_ROUTE'      TO TABLE-ELEMENT-2            
                   MOVE O2-READ-ROUTE     TO HOSTVAR-ELEMENT-2          
                   MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-3            
                   MOVE O2-COMPANY-NO     TO HOSTVAR-ELEMENT-3          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT DY.ADDRESS_ID,                                    
                      LOCAL_OFFICE,                                     
                      COMPANY_NO,                                       
                      BLOCK,                                            
                      LOT,                                              
                      SUBDIVISION_ID,                                   
                      COUNTY,                                           
                      LOCATOR_ID,                                       
                      CITY_GATE_ID,                                     
                      GAS_LEAK_SURVEY_DT,                               
                      GAS_LK_SURVEY_FREQ,                               
                      REV_DISTRICT_CD,                                  
                      CROSS_STREET_1,                                   
                      CROSS_STREET_2,                                   
                      DATE_SPCL_MSG_ENDS,                               
                      SPCL_READ_INSTR,                                  
                      SPCL_INSTRUCTIONS,                                
                      PREMISE_DIRECTIONS,                               
                      SCRATCH_PAD,                                      
                      PREM_REF_LATITUDE,                                
                      PREM_REF_LONGITUDE,                               
                      LAT_LONG_DT,                                      
                      AGL_PREM_NO,                                      
                      FM_ELEC_SVC_WKDIST,                               
                      FM_GAS_OPS_WKDIST,                                
                      FM_FLD_SVCS_WKDIST,                               
                      FM_REV_PRT_WKDIST,                                
                      FM_DSM_ESVC_WKDIST,                               
                      DDDC_FCTR,                                        
                      DDDC_FCTR_EFF_DT,                                 
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDR_SUFFIX,                                      
                      ADDRESS_OVERFLOW,                                 
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      ADDR_USAGE_CD,                                    
                      USPS_DELIV_PT_CD,                                 
                      READ_ROUTE                                        
               INTO  :DY-ADDRESS-ID,                                    
                     :PR-LOCAL-OFFICE,                                  
                     :PR-COMPANY-NO,                                    
                     :PR-BLOCK,                                         
                     :PR-LOT,                                           
                     :PR-SUBDIVISION-ID,                                
                     :PR-COUNTY,                                        
                     :PR-LOCATOR-ID,                                    
                     :PR-CITY-GATE-ID,                                  
                     :PR-GAS-LEAK-SURVEY-DT :WS-NULL-1,                  
                     :PR-GAS-LK-SURVEY-FREQ,                            
                     :PR-REV-DISTRICT-CD,                               
                     :PR-CROSS-STREET-1,                                
                     :PR-CROSS-STREET-2,                                
                     :PR-DATE-SPCL-MSG-ENDS :WS-NULL-2,                  
                     :PR-SPCL-READ-INSTR,                               
                     :PR-SPCL-INSTRUCTIONS,                             
                     :PR-PREMISE-DIRECTIONS,                            
                     :PR-SCRATCH-PAD,                                   
                     :PR-PREM-REF-LATITUDE,                             
                     :PR-PREM-REF-LONGITUDE,                            
                     :PR-LAT-LONG-DT :WS-NULL-3,                         
                     :PR-AGL-PREM-NO,                                   
                     :PR-FM-ELEC-SVC-WKDIST,                            
                     :PR-FM-GAS-OPS-WKDIST,                             
                     :PR-FM-FLD-SVCS-WKDIST,                            
                     :PR-FM-REV-PRT-WKDIST,                             
                     :PR-FM-DSM-ESVC-WKDIST,                            
                     :PR-DDDC-FCTR,                                     
                     :PR-DDDC-FCTR-EFF-DT :WS-NULL-4,                    
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :DY-ADDR-SUFFIX,                                   
                     :DY-ADDRESS-OVERFLOW,                              
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-ADDR-USAGE-CD,                                 
                     :DY-USPS-DELIV-PT-CD,                              
                     :PR-READ-ROUTE                                     
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DY.ADDRESS_ID,                                            
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               BLOCK,                                                    
MFA-TR*               LOT,                                                      
MFA-TR*               SUBDIVISION_ID,                                           
MFA-TR*               COUNTY,                                                   
MFA-TR*               LOCATOR_ID,                                               
MFA-TR*               CITY_GATE_ID,                                             
MFA-TR*               GAS_LEAK_SURVEY_DT,                                       
MFA-TR*               GAS_LK_SURVEY_FREQ,                                       
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               CROSS_STREET_1,                                           
MFA-TR*               CROSS_STREET_2,                                           
MFA-TR*               DATE_SPCL_MSG_ENDS,                                       
MFA-TR*               SPCL_READ_INSTR,                                          
MFA-TR*               SPCL_INSTRUCTIONS,                                        
MFA-TR*               PREMISE_DIRECTIONS,                                       
MFA-TR*               SCRATCH_PAD,                                              
MFA-TR*               PREM_REF_LATITUDE,                                        
MFA-TR*               PREM_REF_LONGITUDE,                                       
MFA-TR*               LAT_LONG_DT,                                              
MFA-TR*               AGL_PREM_NO,                                              
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST,                                       
MFA-TR*               DDDC_FCTR,                                                
MFA-TR*               DDDC_FCTR_EFF_DT,                                         
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               USPS_DELIV_PT_CD,                                         
MFA-TR*               READ_ROUTE                                                
MFA-TR*        INTO  :DY-ADDRESS-ID,                                            
MFA-TR*              :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-COMPANY-NO,                                            
MFA-TR*              :PR-BLOCK,                                                 
MFA-TR*              :PR-LOT,                                                   
MFA-TR*              :PR-SUBDIVISION-ID,                                        
MFA-TR*              :PR-COUNTY,                                                
MFA-TR*              :PR-LOCATOR-ID,                                            
MFA-TR*              :PR-CITY-GATE-ID,                                          
MFA-TR*              :PR-GAS-LEAK-SURVEY-DT:WS-NULL-1,                          
MFA-TR*              :PR-GAS-LK-SURVEY-FREQ,                                    
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :PR-CROSS-STREET-1,                                        
MFA-TR*              :PR-CROSS-STREET-2,                                        
MFA-TR*              :PR-DATE-SPCL-MSG-ENDS:WS-NULL-2,                          
MFA-TR*              :PR-SPCL-READ-INSTR,                                       
MFA-TR*              :PR-SPCL-INSTRUCTIONS,                                     
MFA-TR*              :PR-PREMISE-DIRECTIONS,                                    
MFA-TR*              :PR-SCRATCH-PAD,                                           
MFA-TR*              :PR-PREM-REF-LATITUDE,                                     
MFA-TR*              :PR-PREM-REF-LONGITUDE,                                    
MFA-TR*              :PR-LAT-LONG-DT:WS-NULL-3,                                 
MFA-TR*              :PR-AGL-PREM-NO,                                           
MFA-TR*              :PR-FM-ELEC-SVC-WKDIST,                                    
MFA-TR*              :PR-FM-GAS-OPS-WKDIST,                                     
MFA-TR*              :PR-FM-FLD-SVCS-WKDIST,                                    
MFA-TR*              :PR-FM-REV-PRT-WKDIST,                                     
MFA-TR*              :PR-FM-DSM-ESVC-WKDIST,                                    
MFA-TR*              :PR-DDDC-FCTR,                                             
MFA-TR*              :PR-DDDC-FCTR-EFF-DT:WS-NULL-4,                            
MFA-TR*              :DY-HOUSE-NO,                                              
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-ADDR-USAGE-CD,                                         
MFA-TR*              :DY-USPS-DELIV-PT-CD,                                      
MFA-TR*              :PR-READ-ROUTE                                             
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  IF WS-NULL-1 < 0                                      
                      MOVE SPACES TO PR-GAS-LEAK-SURVEY-DT              
                  END-IF                                                
                  IF WS-NULL-2 < 0                                      
                      MOVE SPACES TO PR-DATE-SPCL-MSG-ENDS              
                  END-IF                                                
                  IF WS-NULL-3 < 0                                      
                      MOVE SPACES TO PR-LAT-LONG-DT                     
                  END-IF                                                
                  IF WS-NULL-4 < 0                                      
                      MOVE SPACES TO PR-DDDC-FCTR-EFF-DT                
                  END-IF                                                
                  IF PR-PREMISE-DIRECTIONS-TEXT < SPACES                
                      MOVE SPACES TO PR-PREMISE-DIRECTIONS-TEXT         
                  END-IF                                                
                  IF PR-SPCL-READ-INSTR-TEXT < SPACES                   
                      MOVE SPACES TO PR-SPCL-READ-INSTR-TEXT            
                  END-IF                                                
                  IF PR-SPCL-INSTRUCTIONS-TEXT < SPACES                 
                      MOVE SPACES TO PR-SPCL-INSTRUCTIONS-TEXT          
                  END-IF                                                
                  IF PR-SCRATCH-PAD-TEXT < SPACES                       
                      MOVE SPACES TO PR-SCRATCH-PAD-TEXT                
                  END-IF                                                
                  IF PR-FM-ELEC-SVC-WKDIST-TEXT < SPACES                
                      MOVE SPACES TO PR-FM-ELEC-SVC-WKDIST-TEXT         
                  END-IF                                                
                  IF PR-FM-GAS-OPS-WKDIST-TEXT < SPACES                 
                      MOVE SPACES TO PR-FM-GAS-OPS-WKDIST-TEXT          
                  END-IF                                                
                  IF PR-FM-FLD-SVCS-WKDIST-TEXT < SPACES                
                      MOVE SPACES TO PR-FM-FLD-SVCS-WKDIST-TEXT         
                  END-IF                                                
                  IF PR-FM-REV-PRT-WKDIST-TEXT < SPACES                 
                      MOVE SPACES TO PR-FM-REV-PRT-WKDIST-TEXT          
                  END-IF                                                
                  IF PR-FM-DSM-ESVC-WKDIST-TEXT < SPACES                
                      MOVE SPACES TO PR-FM-DSM-ESVC-WKDIST-TEXT         
                  END-IF                                                
A05317            IF PR-GAS-LK-SURVEY-FREQ = '55' OR '66' OR            
A05317                                       '77' OR '88'               
A05317                MOVE 'Y' TO WS-LEAK-EXCEP-FL                      
A05317            END-IF                                                
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_PREMISE'         TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7305-SELECT-READ-ROUTE.                                          
A05317                                                                  
A05317     EXEC SQL                                                     
A05317        SELECT MAX(READ_ROUTE)                                    
A05317          INTO :UT-READ-ROUTE :WS-NULL-8                           
A05317          FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
A05317         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(READ_ROUTE)                                            
MFA-TR*         INTO :UT-READ-ROUTE:WS-NULL-8                                   
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7305                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             IF WS-NULL-8 < 0                                     
A05317                 MOVE ZEROES TO UT-READ-ROUTE                     
A05317             END-IF                                               
A05317         WHEN NOT-FOUND                                           
A05317             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05317                            UT-READ-ROUTE                         
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
A05317             MOVE '7305'            TO ACTIVE-PARAGRAPH           
A05317             MOVE 'SELECT'          TO ABEND-FUNCTION             
A05317             MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
A05317             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
A05317             MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7305-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       7310-PREM-READ-ROUTE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) UT.READ_ROUTE,
              CITY_GATE_ID                                       
                INTO :UT-READ-ROUTE,                                    
A05317               :PR-CITY-GATE-ID                                   
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                 
A05317               CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE UT.PREMISE_NO = :UT-PREMISE-NO                     
A05317           AND UT.PREMISE_NO = PR.PREMISE_NO                      
A05317         ORDER BY UT.LAST_UPDATE_TS DESC                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.READ_ROUTE,                                             
MFA-TR*              CITY_GATE_ID                                               
MFA-TR*         INTO :UT-READ-ROUTE,                                            
MFA-TR*              :PR-CITY-GATE-ID                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT,                                       
MFA-TR*              CSS_PREMISE PR                                             
MFA-TR*        WHERE UT.PREMISE_NO = :UT-PREMISE-NO                             
MFA-TR*          AND UT.PREMISE_NO = PR.PREMISE_NO                              
MFA-TR*        ORDER BY UT.LAST_UPDATE_TS DESC                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  UT-READ-ROUTE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7310'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE UT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7320-DEFAULT-WORK-DISTRICTS.                                     
A05317                                                                  
A05317     EXEC SQL                                                     
A05317        SELECT TOP(1) FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST                                
A05317         INTO  :PR-FM-ELEC-SVC-WKDIST,                            
A05317               :PR-FM-GAS-OPS-WKDIST,                             
A05317               :PR-FM-FLD-SVCS-WKDIST,                            
A05317               :PR-FM-REV-PRT-WKDIST,                             
A05317               :PR-FM-DSM-ESVC-WKDIST                             
A05317           FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
A05317                CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                 
A05317          WHERE PR.LOCAL_OFFICE = :ZT-LOCAL-OFFICE                
A05317            AND PR.LOCAL_OFFICE = B1.LOCAL_OFFICE                 
A05317            AND PR.COMPANY_NO = B1.COMPANY_NO                     
A05317            AND ((PR.COMPANY_NO = '26'                            
A05317            AND FM_GAS_OPS_WKDIST > ' ')                          
A05317             OR (PR.COMPANY_NO = '01'                             
A05317            AND  DISTRICT_NO = 'GAS'                              
A05317            AND  FM_GAS_OPS_WKDIST > ' ')                         
A05317             OR (PR.COMPANY_NO = '01'                             
A05317            AND  DISTRICT_NO <> 'GAS'                             
A05317            AND FM_ELEC_SVC_WKDIST > ' '))                        
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*        INTO  :PR-FM-ELEC-SVC-WKDIST,                                    
MFA-TR*              :PR-FM-GAS-OPS-WKDIST,                                     
MFA-TR*              :PR-FM-FLD-SVCS-WKDIST,                                    
MFA-TR*              :PR-FM-REV-PRT-WKDIST,                                     
MFA-TR*              :PR-FM-DSM-ESVC-WKDIST                                     
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_LOCAL_OFFICE B1                                       
MFA-TR*         WHERE PR.LOCAL_OFFICE = :ZT-LOCAL-OFFICE                        
MFA-TR*           AND PR.LOCAL_OFFICE = B1.LOCAL_OFFICE                         
MFA-TR*           AND PR.COMPANY_NO = B1.COMPANY_NO                             
MFA-TR*           AND ((PR.COMPANY_NO = '26'                                    
MFA-TR*           AND FM_GAS_OPS_WKDIST > ' ')                                  
MFA-TR*            OR (PR.COMPANY_NO = '01'                                     
MFA-TR*           AND  DISTRICT_NO = 'GAS'                                      
MFA-TR*           AND  FM_GAS_OPS_WKDIST > ' ')                                 
MFA-TR*            OR (PR.COMPANY_NO = '01'                                     
MFA-TR*           AND  DISTRICT_NO ^= 'GAS'                                     
MFA-TR*           AND FM_ELEC_SVC_WKDIST > ' '))                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             MOVE PR-FM-ELEC-SVC-WKDIST TO LINK-FM-ELEC-SVC-WKDIST
A05317             MOVE PR-FM-GAS-OPS-WKDIST TO LINK-FM-GAS-OPS-WKDIST  
A05317             MOVE PR-FM-FLD-SVCS-WKDIST TO LINK-FM-FLD-SVCS-WKDIST
A05317             MOVE PR-FM-REV-PRT-WKDIST TO LINK-FM-REV-PRT-WKDIST  
A05317             MOVE PR-FM-DSM-ESVC-WKDIST TO LINK-FM-DSM-ESVC-WKDIST
A05317             IF PR-FM-GAS-OPS-WKDIST-TEXT > SPACES AND            
A05317                PR-FM-FLD-SVCS-WKDIST-TEXT <= SPACES              
A05317                    MOVE PR-FM-GAS-OPS-WKDIST TO                  
A05317                         LINK-FM-FLD-SVCS-WKDIST                  
A05317             END-IF                                               
A05317         WHEN NOT-FOUND                                           
A05317             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
A05317             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
A05317             MOVE '7320'                TO ACTIVE-PARAGRAPH       
A05317             MOVE 'SELECT'              TO ABEND-FUNCTION         
A05317             MOVE 'CSS_PREMISE'         TO TABLE-1                
A05317             MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
A05317             MOVE ZT-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7320-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       8000-INSERT-PREMISE.                                             
                                                                        
           IF PR-LAT-LONG-DT <= SPACES                                  
               MOVE -1 TO WS-NULL-1                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-1
           END-IF.                                     
           IF PR-DDDC-FCTR-EFF-DT <= SPACES                             
               MOVE -1 TO WS-NULL-2                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-2
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_PREMISE                                   
                    (PREMISE_NO,                                        
                     LOCAL_OFFICE,                                      
                     COMPANY_NO,                                        
                     CODE_PREMISE_STAT,                                 
                     BLOCK,                                             
                     LOT,                                               
                     REV_DISTRICT_CD,                                   
                     CITY_GATE_ID,                                      
                     SUBDIVISION_ID,                                    
                     COUNTY,                                            
                     LOCATOR_ID,                                        
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT,                                    
                     GAS_LK_SURVEY_FREQ,                                
                     CROSS_STREET_1,                                    
                     CROSS_STREET_2,                                    
                     PREM_CREATE_DT,                                    
                     LAT_LONG_DT,                                       
                     LAT_LONG_SOURCE_CD,                                
                     PREM_REF_LATITUDE,                                 
                     PREM_REF_LONGITUDE,                                
                     AGL_PREM_NO,                                       
                     READ_ROUTE,                                        
                     FM_ELEC_SVC_WKDIST,                                
                     FM_GAS_OPS_WKDIST,                                 
                     FM_FLD_SVCS_WKDIST,                                
                     FM_REV_PRT_WKDIST,                                 
                     FM_DSM_ESVC_WKDIST,                                
                     DDDC_FCTR,                                         
                     DDDC_FCTR_EFF_DT)                                  
              VALUES                                                    
                   (:PR-PREMISE-NO        ,                             
                    :PR-LOCAL-OFFICE      ,                             
                    :PR-COMPANY-NO        ,                             
                    :PR-CODE-PREMISE-STAT ,                             
                    :PR-BLOCK             ,                             
                    :PR-LOT               ,                             
                    :PR-REV-DISTRICT-CD   ,                             
                    :PR-CITY-GATE-ID      ,                             
                    :PR-SUBDIVISION-ID    ,                             
                    :PR-COUNTY            ,                             
                    :PR-LOCATOR-ID        ,                             
                    :PR-ADDRESS-ID        ,                             
                    :PR-ADDRESS-FORMAT    ,                             
                    :PR-GAS-LK-SURVEY-FREQ,                             
                    :PR-CROSS-STREET-1,                                 
                    :PR-CROSS-STREET-2,                                 
                    IIF(TRY_CONVERT(DATE, :PR-PREM-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :PR-PREM-CREATE-DT
              ) <> 0) OR (LEN(:PR-PREM-CREATE-DT
              ) <> 10), CIS.CHAR2DATE(:PR-PREM-CREATE-DT
              ), CONVERT(DATE, :PR-PREM-CREATE-DT) ),                          
                    IIF(TRY_CONVERT(DATE, :PR-LAT-LONG-DT :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :PR-LAT-LONG-DT :WS-NULL-1
              ) <> 0) OR (LEN(:PR-LAT-LONG-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:PR-LAT-LONG-DT :WS-NULL-1
              ), CONVERT(DATE, :PR-LAT-LONG-DT :WS-NULL-1) ),                  
                    :PR-LAT-LONG-SOURCE-CD,                             
                    :PR-PREM-REF-LATITUDE,                              
                    :PR-PREM-REF-LONGITUDE,                             
                    :PR-AGL-PREM-NO,                                    
                    :PR-READ-ROUTE,                                     
                    :PR-FM-ELEC-SVC-WKDIST,                             
                    :PR-FM-GAS-OPS-WKDIST,                              
                    :PR-FM-FLD-SVCS-WKDIST,                             
                    :PR-FM-REV-PRT-WKDIST,                              
                    :PR-FM-DSM-ESVC-WKDIST,                             
                    :PR-DDDC-FCTR,                                      
                    IIF(TRY_CONVERT(DATE, :PR-DDDC-FCTR-EFF-DT 
                                          :WS-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :PR-DDDC-FCTR-EFF-DT 
                                                             :WS-NULL-2
              ) <> 0) OR (LEN(:PR-DDDC-FCTR-EFF-DT :WS-NULL-2
              ) <> 10), CIS.CHAR2DATE(:PR-DDDC-FCTR-EFF-DT :WS-NULL-2
              ), CONVERT(DATE, :PR-DDDC-FCTR-EFF-DT :WS-NULL-2) ))             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_PREMISE                                           
MFA-TR*             (PREMISE_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              CODE_PREMISE_STAT,                                         
MFA-TR*              BLOCK,                                                     
MFA-TR*              LOT,                                                       
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              CITY_GATE_ID,                                              
MFA-TR*              SUBDIVISION_ID,                                            
MFA-TR*              COUNTY,                                                    
MFA-TR*              LOCATOR_ID,                                                
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              GAS_LK_SURVEY_FREQ,                                        
MFA-TR*              CROSS_STREET_1,                                            
MFA-TR*              CROSS_STREET_2,                                            
MFA-TR*              PREM_CREATE_DT,                                            
MFA-TR*              LAT_LONG_DT,                                               
MFA-TR*              LAT_LONG_SOURCE_CD,                                        
MFA-TR*              PREM_REF_LATITUDE,                                         
MFA-TR*              PREM_REF_LONGITUDE,                                        
MFA-TR*              AGL_PREM_NO,                                               
MFA-TR*              READ_ROUTE,                                                
MFA-TR*              FM_ELEC_SVC_WKDIST,                                        
MFA-TR*              FM_GAS_OPS_WKDIST,                                         
MFA-TR*              FM_FLD_SVCS_WKDIST,                                        
MFA-TR*              FM_REV_PRT_WKDIST,                                         
MFA-TR*              FM_DSM_ESVC_WKDIST,                                        
MFA-TR*              DDDC_FCTR,                                                 
MFA-TR*              DDDC_FCTR_EFF_DT)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:PR-PREMISE-NO        ,                                     
MFA-TR*             :PR-LOCAL-OFFICE      ,                                     
MFA-TR*             :PR-COMPANY-NO        ,                                     
MFA-TR*             :PR-CODE-PREMISE-STAT ,                                     
MFA-TR*             :PR-BLOCK             ,                                     
MFA-TR*             :PR-LOT               ,                                     
MFA-TR*             :PR-REV-DISTRICT-CD   ,                                     
MFA-TR*             :PR-CITY-GATE-ID      ,                                     
MFA-TR*             :PR-SUBDIVISION-ID    ,                                     
MFA-TR*             :PR-COUNTY            ,                                     
MFA-TR*             :PR-LOCATOR-ID        ,                                     
MFA-TR*             :PR-ADDRESS-ID        ,                                     
MFA-TR*             :PR-ADDRESS-FORMAT    ,                                     
MFA-TR*             :PR-GAS-LK-SURVEY-FREQ,                                     
MFA-TR*             :PR-CROSS-STREET-1,                                         
MFA-TR*             :PR-CROSS-STREET-2,                                         
MFA-TR*             :PR-PREM-CREATE-DT,                                         
MFA-TR*             :PR-LAT-LONG-DT:WS-NULL-1,                                  
MFA-TR*             :PR-LAT-LONG-SOURCE-CD,                                     
MFA-TR*             :PR-PREM-REF-LATITUDE,                                      
MFA-TR*             :PR-PREM-REF-LONGITUDE,                                     
MFA-TR*             :PR-AGL-PREM-NO,                                            
MFA-TR*             :PR-READ-ROUTE,                                             
MFA-TR*             :PR-FM-ELEC-SVC-WKDIST,                                     
MFA-TR*             :PR-FM-GAS-OPS-WKDIST,                                      
MFA-TR*             :PR-FM-FLD-SVCS-WKDIST,                                     
MFA-TR*             :PR-FM-REV-PRT-WKDIST,                                      
MFA-TR*             :PR-FM-DSM-ESVC-WKDIST,                                     
MFA-TR*             :PR-DDDC-FCTR,                                              
MFA-TR*             :PR-DDDC-FCTR-EFF-DT:WS-NULL-2)                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-2             
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-3             
              MOVE 'SUBDIVISION_ID'      TO TABLE-ELEMENT-4             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PR-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2           
              MOVE PR-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-3           
              MOVE PR-SUBDIVISION-ID     TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                    (ADDRESS_ID        ,                                
                     HOUSE_NO          ,                                
                     ADDR_PREFIX_1     ,                                
                     ADDR_PREFIX_2     ,                                
                     STREET_NAME       ,                                
                     STREET_LOCATION_1 ,                                
                     STREET_LOCATION_2 ,                                
                     STREET_SUFFIX     ,                                
                     ADDR_SUFFIX       ,                                
                     ADDRESS_OVERFLOW  ,                                
                     ZIP_CODE          ,                                
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN    ,                                
                     USPS_DELIV_PT_CD  ,                                
                     ADDR_USAGE_CD,                                     
                     VALIDATION_TS)                                     
               VALUES                                                   
                   (:DY-ADDRESS-ID        ,                             
                    :DY-HOUSE-NO          ,                             
                    :DY-ADDR-PREFIX-1     ,                             
                    :DY-ADDR-PREFIX-2     ,                             
                    :DY-STREET-NAME       ,                             
                    :DY-STREET-LOCATION-1 ,                             
                    :DY-STREET-LOCATION-2 ,                             
                    :DY-STREET-SUFFIX     ,                             
                    :DY-ADDR-SUFFIX       ,                             
                    :DY-ADDRESS-OVERFLOW  ,                             
                    :DY-ZIP-CODE          ,                             
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN    ,                             
                    :DY-USPS-DELIV-PT-CD  ,                             
                    :DY-ADDR-USAGE-CD,                                  
                    CIS.CHAR2TIMESTAMP(:DY-VALIDATION-TS))                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ADDR_FORMATTED                                    
MFA-TR*             (ADDRESS_ID        ,                                        
MFA-TR*              HOUSE_NO          ,                                        
MFA-TR*              ADDR_PREFIX_1     ,                                        
MFA-TR*              ADDR_PREFIX_2     ,                                        
MFA-TR*              STREET_NAME       ,                                        
MFA-TR*              STREET_LOCATION_1 ,                                        
MFA-TR*              STREET_LOCATION_2 ,                                        
MFA-TR*              STREET_SUFFIX     ,                                        
MFA-TR*              ADDR_SUFFIX       ,                                        
MFA-TR*              ADDRESS_OVERFLOW  ,                                        
MFA-TR*              ZIP_CODE          ,                                        
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              ZIP_CODE_TOKEN    ,                                        
MFA-TR*              USPS_DELIV_PT_CD  ,                                        
MFA-TR*              ADDR_USAGE_CD,                                             
MFA-TR*              VALIDATION_TS)                                             
MFA-TR*        VALUES                                                           
MFA-TR*            (:DY-ADDRESS-ID        ,                                     
MFA-TR*             :DY-HOUSE-NO          ,                                     
MFA-TR*             :DY-ADDR-PREFIX-1     ,                                     
MFA-TR*             :DY-ADDR-PREFIX-2     ,                                     
MFA-TR*             :DY-STREET-NAME       ,                                     
MFA-TR*             :DY-STREET-LOCATION-1 ,                                     
MFA-TR*             :DY-STREET-LOCATION-2 ,                                     
MFA-TR*             :DY-STREET-SUFFIX     ,                                     
MFA-TR*             :DY-ADDR-SUFFIX       ,                                     
MFA-TR*             :DY-ADDRESS-OVERFLOW  ,                                     
MFA-TR*             :DY-ZIP-CODE          ,                                     
MFA-TR*             :DY-ZIP-CODE-PLUS-FOUR,                                     
MFA-TR*             :DY-ZIP-CODE-TOKEN    ,                                     
MFA-TR*             :DY-USPS-DELIV-PT-CD  ,                                     
MFA-TR*             :DY-ADDR-USAGE-CD,                                          
MFA-TR*             :DY-VALIDATION-TS)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'HOUSE_NO'           TO TABLE-ELEMENT-2              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-3              
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-4              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-HOUSE-NO          TO HOSTVAR-ELEMENT-2            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-3            
              MOVE DY-ZIP-CODE          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     PREMISE_NO,                                        
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     CUSTOMER_NO,                                       
                     CONTACT_ID,                                        
                     STATE,                                             
                     TOWN,                                              
                     LOCAL_OFFICE)                                      
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-CONTACT-ID,                                     
                    :HT-STATE,                                          
                    :HT-TOWN,                                           
                    :HT-LOCAL-OFFICE)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE HT-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-CLICK-PREM.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SO_CLICK_PREM                             
                   ( PREMISE_NO,                                        
                     CLICK_FIELD_SVC_FL,                                
                     CLICK_ELEC_OPS_FL,                                 
                     CLICK_GAS_OPS_FL,                                  
                     CLICK_REV_PROT_FL,                                 
                     CLICK_DMS_FL,                                      
                     CLICK_LIGHTING_FL )                                
              VALUES                                                    
                   (:3O-PREMISE-NO,                                     
                    'Y',                                                
                    'Y',                                                
                    'Y',                                                
                    'Y',                                                
                    'Y',                                                
                    'Y')                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SO_CLICK-PREM'  TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 3O-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8040-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
               WHERE  PREMISE_NO = :PR-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*        WHERE  PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*       QUERYNO 8040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8040'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-DELETE-PREM-GAS-LINE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(SERVICE_NO)                                  
                INTO :WS-COUNT                                          
                FROM CSS_PREM_GAS_LINE WITH(READUNCOMMITTED)                    
A05317         WHERE SERVICE_NO IN (                                    
                     SELECT SERVICE_NO                                  
                       FROM CSS_PREM_GAS_LINE WITH(READUNCOMMITTED)             
                      WHERE PREMISE_NO = :PR-PREMISE-NO)                
A05317                                                           
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(SERVICE_NO)                                          
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_PREM_GAS_LINE                                          
MFA-TR*        WHERE SERVICE_NO IN (                                            
MFA-TR*              SELECT SERVICE_NO                                          
MFA-TR*                FROM CSS_PREM_GAS_LINE                                   
MFA-TR*               WHERE PREMISE_NO = :PR-PREMISE-NO)                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 80501                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                     
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8050'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT 1'                TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_PREM_GAS_LINE'       TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SERVICE_NO                                         
                INTO  :XO-SERVICE-NO                                    
                FROM  CSS_PREM_GAS_LINE WITH(READUNCOMMITTED)                   
               WHERE  PREMISE_NO = :PR-PREMISE-NO                       
A05317                                           
A05317                                                           
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERVICE_NO                                                 
MFA-TR*         INTO  :XO-SERVICE-NO                                            
MFA-TR*         FROM  CSS_PREM_GAS_LINE                                         
MFA-TR*        WHERE  PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 80502                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                     
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8050'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT 2'                TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_PREM_GAS_LINE'       TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_PREM_GAS_LINE                             
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_PREM_GAS_LINE                                     
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 80503                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                     
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8050'                    TO ACTIVE-PARAGRAPH       
               MOVE 'DELETE 1'                TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_PREM_GAS_LINE'       TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           IF WS-COUNT = 1                                              
               EXEC SQL                                                 
                  DELETE FROM CSS_GAS_SERV_LINE                         
                   WHERE SERVICE_NO = :XO-SERVICE-NO                    
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*           DELETE FROM CSS_GAS_SERV_LINE                                 
MFA-TR*            WHERE SERVICE_NO = :XO-SERVICE-NO                            
MFA-TR*           QUERYNO 80504                                                 
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE
           END-IF.        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               ELSE                                                     
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '8050'                TO ACTIVE-PARAGRAPH       
                   MOVE 'DELETE 2'            TO ABEND-FUNCTION         
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                     ABEND-TABLES       
                   MOVE 'CSS_GAS_SERV_LINE'   TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF.       
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-DELETE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_PREMISE                                   
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_PREMISE                                           
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 8060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8060'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8070-DELETE-WQ.                                                  
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_WQ_ITEMS                                  
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_WQ_ITEMS                                          
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 8070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8070'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_WQ_ITEMS'        TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8080-INSERT-ZT.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ZIPCODE_LO_RT                             
                   ( ZIP_CODE,                                          
                     LOCAL_OFFICE,                                      
                     REV_DISTRICT_CD,                                   
                     READ_ROUTE,                                        
                     COMPANY_NO,                                        
                     LAST_UPDATE_USERID )                               
              VALUES                                                    
                   ( :ZT-ZIP-CODE,                                      
                     :ZT-LOCAL-OFFICE,                                  
                     :ZT-REV-DISTRICT-CD,                               
                     :ZT-READ-ROUTE,                                    
                     :ZT-COMPANY-NO,                                    
                     :ZT-LAST-UPDATE-USERID )                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8080'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ZIPCODE_LO_RT'  TO TABLE-1                      
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1              
              MOVE ZT-ZIP-CODE          TO HOSTVAR-ELEMENT-1            
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-2              
              MOVE ZT-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2            
              MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-3              
              MOVE ZT-REV-DISTRICT-CD   TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8090-INSERT-ZS.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ZIPCODE_SUBDIV                            
                   ( ZIP_CODE,                                          
                     SUBDIVISION_ID,                                    
                     COMPANY_NO,                                        
                     RATE_ITEM_CD,                                      
                     LAST_UPDATE_USERID,                                
                     REV_DISTRICT_CD,                                   
                     LOCAL_OFFICE )                                     
              VALUES                                                    
                   ( :ZS-ZIP-CODE,                                      
                     :ZS-SUBDIVISION-ID,                                
                     :ZS-COMPANY-NO,                                    
                     :ZS-RATE-ITEM-CD,                                  
                     :ZS-LAST-UPDATE-USERID,                            
                     :ZS-REV-DISTRICT-CD,                               
                     :ZS-LOCAL-OFFICE )                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8090'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ZIPCODE_SUBDIV' TO TABLE-1                      
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1              
              MOVE ZS-ZIP-CODE          TO HOSTVAR-ELEMENT-1            
              MOVE 'SUBDIVSION'         TO TABLE-ELEMENT-2              
              MOVE ZS-SUBDIVISION-ID    TO HOSTVAR-ELEMENT-2            
              MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-3              
              MOVE ZS-REV-DISTRICT-CD   TO HOSTVAR-ELEMENT-3            
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-3              
              MOVE ZS-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-UPDATE-PREMISE.                                             
                                                                        
           IF LINK-LEAK-SURVEY-DT <= SPACES                             
               MOVE -1 TO WS-NULL-1                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-1
           END-IF.                                     
           IF LINK-DATE-SPCL-MSG-ENDS <= SPACES                         
               MOVE -1 TO WS-NULL-2                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-2
           END-IF.                                     
           IF LALO-CHANGED                                              
               MOVE WS-CURRENT-DATE TO PR-LAT-LONG-DT
           END-IF.                  
           IF PR-LAT-LONG-DT <= SPACES                                  
               MOVE -1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-3
           END-IF.                                     
           IF PR-DDDC-FCTR-EFF-DT <= SPACES                             
               MOVE -1 TO WS-NULL-4                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-4
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET LOCAL_OFFICE       = :PR-LOCAL-OFFICE,             
                     COMPANY_NO         = :PR-COMPANY-NO,               
                     BLOCK              = :PR-BLOCK,                    
                     LOT                = :PR-LOT,                      
                     REV_DISTRICT_CD    = :PR-REV-DISTRICT-CD,          
                     CITY_GATE_ID       = :PR-CITY-GATE-ID,             
                     SUBDIVISION_ID     = :PR-SUBDIVISION-ID,           
                     COUNTY             = :PR-COUNTY,                   
                     LOCATOR_ID         = :PR-LOCATOR-ID,               
                     GAS_LK_SURVEY_FREQ = :PR-GAS-LK-SURVEY-FREQ,       
                     GAS_LEAK_SURVEY_DT = IIF(TRY_CONVERT(DATE, 
                                                :PR-GAS-LEAK-SURVEY-DT 
                                                             :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :PR-GAS-LEAK-SURVEY-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:PR-GAS-LEAK-SURVEY-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:PR-GAS-LEAK-SURVEY-DT :WS-NULL-1
              ), CONVERT(DATE, :PR-GAS-LEAK-SURVEY-DT :WS-NULL-1) ),           
                     CROSS_STREET_1     = :PR-CROSS-STREET-1,           
                     CROSS_STREET_2     = :PR-CROSS-STREET-2,           
                     READ_ROUTE         = :PR-READ-ROUTE,               
                     PREM_REF_LATITUDE  = :PR-PREM-REF-LATITUDE,        
                     PREM_REF_LONGITUDE = :PR-PREM-REF-LONGITUDE,       
                     LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                       :PR-LAT-LONG-DT 
                                                             :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :PR-LAT-LONG-DT :WS-NULL-3
              ) <> 0) OR (LEN(:PR-LAT-LONG-DT :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:PR-LAT-LONG-DT :WS-NULL-3
              ), CONVERT(DATE, :PR-LAT-LONG-DT :WS-NULL-3) ),    
                     AGL_PREM_NO        = :PR-AGL-PREM-NO,              
                     PREMISE_DIRECTIONS = :PR-PREMISE-DIRECTIONS,       
                     SCRATCH_PAD        = :PR-SCRATCH-PAD,              
                     SPCL_INSTRUCTIONS  = :PR-SPCL-INSTRUCTIONS,        
                     SPCL_READ_INSTR    = :PR-SPCL-READ-INSTR,          
                     DATE_SPCL_MSG_ENDS = IIF(TRY_CONVERT(DATE, 
                                                :PR-DATE-SPCL-MSG-ENDS 
                                                             :WS-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :PR-DATE-SPCL-MSG-ENDS 
                                                             :WS-NULL-2
              ) <> 0) OR (LEN(:PR-DATE-SPCL-MSG-ENDS :WS-NULL-2
              ) <> 10), CIS.CHAR2DATE(:PR-DATE-SPCL-MSG-ENDS :WS-NULL-2
              ), CONVERT(DATE, :PR-DATE-SPCL-MSG-ENDS :WS-NULL-2) ),           
                     FM_ELEC_SVC_WKDIST = :PR-FM-ELEC-SVC-WKDIST,       
                     FM_GAS_OPS_WKDIST  = :PR-FM-GAS-OPS-WKDIST,        
                     FM_FLD_SVCS_WKDIST = :PR-FM-FLD-SVCS-WKDIST,       
                     FM_REV_PRT_WKDIST  = :PR-FM-REV-PRT-WKDIST,        
                     FM_DSM_ESVC_WKDIST = :PR-FM-DSM-ESVC-WKDIST,       
                     DDDC_FCTR          = :PR-DDDC-FCTR,                
                     DDDC_FCTR_EFF_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :PR-DDDC-FCTR-EFF-DT 
                                                             :WS-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :PR-DDDC-FCTR-EFF-DT 
                                                             :WS-NULL-4
              ) <> 0) OR (LEN(:PR-DDDC-FCTR-EFF-DT :WS-NULL-4
              ) <> 10), CIS.CHAR2DATE(:PR-DDDC-FCTR-EFF-DT :WS-NULL-4
              ), CONVERT(DATE, :PR-DDDC-FCTR-EFF-DT :WS-NULL-4) )
               WHERE PREMISE_NO         = :PR-PREMISE-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*          SET LOCAL_OFFICE       = :PR-LOCAL-OFFICE,                     
MFA-TR*              COMPANY_NO         = :PR-COMPANY-NO,                       
MFA-TR*              BLOCK              = :PR-BLOCK,                            
MFA-TR*              LOT                = :PR-LOT,                              
MFA-TR*              REV_DISTRICT_CD    = :PR-REV-DISTRICT-CD,                  
MFA-TR*              CITY_GATE_ID       = :PR-CITY-GATE-ID,                     
MFA-TR*              SUBDIVISION_ID     = :PR-SUBDIVISION-ID,                   
MFA-TR*              COUNTY             = :PR-COUNTY,                           
MFA-TR*              LOCATOR_ID         = :PR-LOCATOR-ID,                       
MFA-TR*              GAS_LK_SURVEY_FREQ = :PR-GAS-LK-SURVEY-FREQ,               
MFA-TR*              GAS_LEAK_SURVEY_DT = :PR-GAS-LEAK-SURVEY-DT                
MFA-TR*                                   :WS-NULL-1,                           
MFA-TR*              CROSS_STREET_1     = :PR-CROSS-STREET-1,                   
MFA-TR*              CROSS_STREET_2     = :PR-CROSS-STREET-2,                   
MFA-TR*              READ_ROUTE         = :PR-READ-ROUTE,                       
MFA-TR*              PREM_REF_LATITUDE  = :PR-PREM-REF-LATITUDE,                
MFA-TR*              PREM_REF_LONGITUDE = :PR-PREM-REF-LONGITUDE,               
MFA-TR*              LAT_LONG_DT        = :PR-LAT-LONG-DT:WS-NULL-3,            
MFA-TR*              AGL_PREM_NO        = :PR-AGL-PREM-NO,                      
MFA-TR*              PREMISE_DIRECTIONS = :PR-PREMISE-DIRECTIONS,               
MFA-TR*              SCRATCH_PAD        = :PR-SCRATCH-PAD,                      
MFA-TR*              SPCL_INSTRUCTIONS  = :PR-SPCL-INSTRUCTIONS,                
MFA-TR*              SPCL_READ_INSTR    = :PR-SPCL-READ-INSTR,                  
MFA-TR*              DATE_SPCL_MSG_ENDS = :PR-DATE-SPCL-MSG-ENDS                
MFA-TR*                                   :WS-NULL-2,                           
MFA-TR*              FM_ELEC_SVC_WKDIST = :PR-FM-ELEC-SVC-WKDIST,               
MFA-TR*              FM_GAS_OPS_WKDIST  = :PR-FM-GAS-OPS-WKDIST,                
MFA-TR*              FM_FLD_SVCS_WKDIST = :PR-FM-FLD-SVCS-WKDIST,               
MFA-TR*              FM_REV_PRT_WKDIST  = :PR-FM-REV-PRT-WKDIST,                
MFA-TR*              FM_DSM_ESVC_WKDIST = :PR-FM-DSM-ESVC-WKDIST,               
MFA-TR*              DDDC_FCTR          = :PR-DDDC-FCTR,                        
MFA-TR*              DDDC_FCTR_EFF_DT   = :PR-DDDC-FCTR-EFF-DT:WS-NULL-4        
MFA-TR*        WHERE PREMISE_NO         = :PR-PREMISE-NO                        
MFA-TR*        QUERYNO 8200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-UPDATE-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FORMATTED                                 
                 SET HOUSE_NO           = :DY-HOUSE-NO,                 
                     ADDR_PREFIX_1      = :DY-ADDR-PREFIX-1,            
                     ADDR_PREFIX_2      = :DY-ADDR-PREFIX-2,            
                     STREET_NAME        = :DY-STREET-NAME,              
                     STREET_LOCATION_1  = :DY-STREET-LOCATION-1,        
                     STREET_LOCATION_2  = :DY-STREET-LOCATION-2,        
                     STREET_SUFFIX      = :DY-STREET-SUFFIX,            
                     ADDR_SUFFIX        = :DY-ADDR-SUFFIX,              
                     ADDRESS_OVERFLOW   = :DY-ADDRESS-OVERFLOW,         
                     ZIP_CODE           = :DY-ZIP-CODE,                 
                     ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,       
                     ZIP_CODE_TOKEN     = :A4-ZIP-CODE-TOKEN,           
                     USPS_DELIV_PT_CD   = :DY-USPS-DELIV-PT-CD          
               WHERE ADDRESS_ID         = :DY-ADDRESS-ID                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FORMATTED                                         
MFA-TR*          SET HOUSE_NO           = :DY-HOUSE-NO,                         
MFA-TR*              ADDR_PREFIX_1      = :DY-ADDR-PREFIX-1,                    
MFA-TR*              ADDR_PREFIX_2      = :DY-ADDR-PREFIX-2,                    
MFA-TR*              STREET_NAME        = :DY-STREET-NAME,                      
MFA-TR*              STREET_LOCATION_1  = :DY-STREET-LOCATION-1,                
MFA-TR*              STREET_LOCATION_2  = :DY-STREET-LOCATION-2,                
MFA-TR*              STREET_SUFFIX      = :DY-STREET-SUFFIX,                    
MFA-TR*              ADDR_SUFFIX        = :DY-ADDR-SUFFIX,                      
MFA-TR*              ADDRESS_OVERFLOW   = :DY-ADDRESS-OVERFLOW,                 
MFA-TR*              ZIP_CODE           = :DY-ZIP-CODE,                         
MFA-TR*              ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,               
MFA-TR*              ZIP_CODE_TOKEN     = :A4-ZIP-CODE-TOKEN,                   
MFA-TR*              USPS_DELIV_PT_CD   = :DY-USPS-DELIV-PT-CD                  
MFA-TR*        WHERE ADDRESS_ID         = :DY-ADDRESS-ID                        
MFA-TR*        QUERYNO 8210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8220-UPDATE-XREF.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME_ACCT_XREF                                 
                 SET STATE        = :LINK-STATE,                        
                     TOWN         = :LINK-TOWN,                         
                     LOCAL_OFFICE = :LINK-LOCAL-OFFICE                  
               WHERE PREMISE_NO   = :PR-PREMISE-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME_ACCT_XREF                                         
MFA-TR*          SET STATE        = :LINK-STATE,                                
MFA-TR*              TOWN         = :LINK-TOWN,                                 
MFA-TR*              LOCAL_OFFICE = :LINK-LOCAL-OFFICE                          
MFA-TR*        WHERE PREMISE_NO   = :PR-PREMISE-NO                              
MFA-TR*        QUERYNO 8220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8220'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8230-UPDATE-ORDERS.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET LOCAL_OFFICE = :LINK-LOCAL-OFFICE                  
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_DATA                                                
MFA-TR*          SET LOCAL_OFFICE = :LINK-LOCAL-OFFICE                          
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*        QUERYNO 8230                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8230'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_SO_DATA'   TO TABLE-1                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8240-UPDATE-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_UTIL_ENVRNMT                                   
                 SET READ_ROUTE = :LINK-READ-ROUTE,                     
                     READ_CYCLE = :O2-READ-CYCLE                        
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_UTIL_ENVRNMT                                           
MFA-TR*          SET READ_ROUTE = :LINK-READ-ROUTE,                             
MFA-TR*              READ_CYCLE = :O2-READ-CYCLE                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        QUERYNO 8240                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8240'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE 'READ_ROUTE'    TO TABLE-ELEMENT-2              
                   MOVE LINK-READ-ROUTE TO HOSTVAR-ELEMENT-2            
                   MOVE 'READ_CYCLE'    TO TABLE-ELEMENT-3              
                   MOVE O2-READ-CYCLE   TO HOSTVAR-ELEMENT-3            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8250-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET BILL_CYCLE = :O2-READ-CYCLE                        
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET BILL_CYCLE = :O2-READ-CYCLE                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        QUERYNO 8250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 3125-BILL-CYCLE-TRANSHIST THRU 3125-EXIT     
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8250'          TO ACTIVE-PARAGRAPH             
                   MOVE 'UPDATE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_ACCOUNT'   TO TABLE-1                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE 'READ_CYCLE'    TO TABLE-ELEMENT-2              
                   MOVE O2-READ-CYCLE   TO HOSTVAR-ELEMENT-2            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
I01959 8260-DELETE-DER-DET.                                             
I01959                                                                  
I01959     EXEC SQL                                                     
I01959        DELETE FROM CSS_PREM_DER_DET                              
I01959         WHERE PREMISE_NO = :PR-PREMISE-NO                        
I01959                                                      
I01959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_PREM_DER_DET                                      
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       QUERYNO 8260                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01959                                                                  
I01959     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
I01959                                                                  
I01959     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I01959        MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
I01959     ELSE                                                         
I01959        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
I01959        MOVE '8260'                TO ACTIVE-PARAGRAPH            
I01959        MOVE 'DELETE'              TO ABEND-FUNCTION              
I01959        MOVE 'CSS_PREM_DER_DET'    TO TABLE-1                     
I01959        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
I01959        MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
I01959        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
I01959        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
I01959     END-IF.                                                      
I01959                                                                  
I01959 8260-EXIT.                                                       
I01959     EXIT.                                                        
                                                                        
           EXEC SQL                                                     29700000
              INCLUDE CPD00071                                          29710000
           END-EXEC.                                                    29720000
           EXEC SQL                                                     29700000
              INCLUDE CPD00013                                          29710000
           END-EXEC.                                                    29720000
           EXEC SQL                                                     29780000
              INCLUDE CPD00090                                          29790000
           END-EXEC.                                                    29800000
           EXEC SQL                                                     29820000
              INCLUDE CPD00094                                          29830000
           END-EXEC.                                                    29840000
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     29920000
              INCLUDE CPD00099                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
       F1100-CHECK-FOR-ACCOUNTS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :AT-ACCOUNT-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :WS-PREMISE-NO                       
                  AND CODE_ACCT_STAT IN ('A', 'B', 'S')                 
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :AT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE PREMISE_NO = :WS-PREMISE-NO                               
MFA-TR*           AND CODE_ACCT_STAT IN ('A', 'B', 'S')                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1100'                    TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       F1100-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1200-PROCESS-FRANCHISE-FEE.                                     
                                                                        
           MOVE WS-PREMISE-NO             TO JQ-PREMISE-NO.             
           MOVE PR-REV-DISTRICT-CD        TO JQ-PREV-REV-DIST.          
           MOVE LINK-REV-DISTRICT         TO JQ-CURR-REV-DIST.          
           PERFORM F7000-GET-CURR-MONTH   THRU F7000-EXIT.              
                                                                        
           MOVE JQ-PREV-REV-DIST          TO TR-DETAIL-ID.              
           MOVE WS-CURRENT-DATE           TO TR-DATE-FROM               
                                             TR-DATE-TO.                
           MOVE 'B'                       TO TC-TAX-TYPE.               
           MOVE ZEROES                    TO TR-TAX-RATE.               
           PERFORM F7200-GET-TAX-RATE     THRU F7200-EXIT.              
           MOVE TR-TAX-RATE               TO WS-PREV-TAX-RATE.          
                                                                        
           MOVE JQ-CURR-REV-DIST          TO TR-DETAIL-ID.              
           MOVE WS-CURRENT-DATE           TO TR-DATE-FROM               
                                             TR-DATE-TO.                
           MOVE 'B'                       TO TC-TAX-TYPE.               
           MOVE ZEROES                    TO TR-TAX-RATE.               
           PERFORM F7200-GET-TAX-RATE     THRU F7200-EXIT.              
           MOVE TR-TAX-RATE               TO WS-CURR-TAX-RATE.          
                                                                        
      *  B = BILL MESSAGE ONLY AND I = INITIATE CREDIT PROCESS                  
                                                                        
           IF WS-CURR-TAX-RATE < WS-PREV-TAX-RATE                       
               MOVE 'I'                   TO JQ-PROCESS-CD              
           ELSE                                                         
               MOVE 'B'                   TO JQ-PROCESS-CD              
               MOVE WS-CURRENT-DATE       TO JQ-PROCESSED-DT
           END-IF.           
                                                                        
           MOVE WS-PREMISE-NO             TO JQ-PREMISE-NO.             
                                                                        
           PERFORM F1250-ACTIVE-ACCOUNT      THRU F1250-EXIT.           
           PERFORM F1300-INDIVIDUAL-ACCOUNTS THRU F1300-EXIT.           
                                                                        
       F1200-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1250-ACTIVE-ACCOUNT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REV_MTH_LST_NRML,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT, 121), 
           ' ', '-'), ':', '.') ACCT_CREATE_DT                                 
                 INTO :WS-REV-MTH-LST-NRML,                             
                      :AT-ACCT-CREATE-DT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :WS-PREMISE-NO                       
                  AND CODE_ACCT_STAT = 'A'                              
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REV_MTH_LST_NRML,                                         
MFA-TR*               ACCT_CREATE_DT                                            
MFA-TR*          INTO :WS-REV-MTH-LST-NRML,                                     
MFA-TR*               :AT-ACCT-CREATE-DT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE PREMISE_NO = :WS-PREMISE-NO                               
MFA-TR*           AND CODE_ACCT_STAT = 'A'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCT-CREATE-DT (1:10) TO WS-ACCT-CREATE-DT   
                   IF WS-REV-MTH-LST-NRML > 0                           
                       PERFORM F1900-ACTIVE-DATES THRU F1900-EXIT       
                       MOVE WS-ACTIVE-START-DT   TO JQ-REV-START-MONTH  
                       MOVE WS-ACTIVE-END-DT     TO JQ-REV-END-MONTH    
                   ELSE                                                 
                       PERFORM F1950-NO-ACTIVE-DATES THRU F1950-EXIT    
                       MOVE WS-NO-ACTIVE-START-DT TO JQ-REV-START-MONTH 
                       MOVE WS-NO-ACTIVE-END-DT TO JQ-REV-END-MONTH     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   PERFORM F1950-NO-ACTIVE-DATES THRU F1950-EXIT        
                   MOVE WS-NO-ACTIVE-START-DT TO JQ-REV-START-MONTH     
                   MOVE WS-NO-ACTIVE-END-DT   TO JQ-REV-END-MONTH       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'F1250'               TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F1250-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1300-INDIVIDUAL-ACCOUNTS.                                       
                                                                        
           EXEC SQL                                                     
              DECLARE ACCOUNTS CURSOR FOR                               
                  SELECT ACCOUNT_NO,                                    
                         CODE_ACCT_STAT,                                
                         REV_MTH_LST_NRML,                              
                         COMPANY_NO,                                    
                         CUSTOMER_NO,                                   
                         LOCAL_OFFICE                                   
                    FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                      
                   WHERE PREMISE_NO = :WS-PREMISE-NO                    
                     AND CODE_ACCT_STAT IN ('A', 'B', 'S')              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNTS CURSOR FOR                                       
MFA-TR*           SELECT ACCOUNT_NO,                                            
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  REV_MTH_LST_NRML,                                      
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  LOCAL_OFFICE                                           
MFA-TR*             FROM CSS_ACCOUNT                                            
MFA-TR*            WHERE PREMISE_NO = :WS-PREMISE-NO                            
MFA-TR*              AND CODE_ACCT_STAT IN ('A', 'B', 'S')                      
MFA-TR*              WITH UR                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               OPEN ACCOUNTS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1300'                    TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           PERFORM F1400-PROCESS-ACCOUNTS THRU F1400-EXIT.              
                                                                        
           EXEC SQL                                                     
               CLOSE ACCOUNTS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1300'                    TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       F1300-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1400-PROCESS-ACCOUNTS.                                          
                                                                        
           EXEC SQL                                                     
               FETCH ACCOUNTS                                           
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CODE-ACCT-STAT,                                
                     :AT-REV-MTH-LST-NRML,                              
                     :AT-COMPANY-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-LOCAL-OFFICE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO F1400-EXIT                                     
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F1300'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'CLOSE'                   TO ABEND-FUNCTION     
                   MOVE 'CSS_ACCOUNT'             TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE WS-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ACCOUNT-NO                  TO JQ-ACCOUNT-NO.        
           MOVE AT-CUSTOMER-NO                 TO JQ-CUSTOMER-NO.       
           IF JQ-PROCESS-CD = 'B'                                       
               IF AT-CODE-ACCT-STAT = 'A' AND                           
                  AT-REV-MTH-LST-NRML > 0                               
                      PERFORM F1800-CREDIT-ACTIVE     THRU F1800-EXIT   
               END-IF                                                   
           ELSE                                                         
               PERFORM F1600-CREDIT-PROCESS        THRU F1600-EXIT
           END-IF.     
                                                                        
           GO TO F1400-PROCESS-ACCOUNTS.                                
                                                                        
       F1400-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1600-CREDIT-PROCESS.                                            
                                                                        
           PERFORM F7300-CHECK-I-OR-P-ROW THRU F7300-EXIT.              
           IF WS-EXISTS-I-OR-P = 'Y'                                    
               MOVE 'M'                     TO JQ-PROCESS-CD            
               MOVE ZERO                    TO JQ-REV-END-MONTH         
               MOVE WS-CURRENT-DATE         TO JQ-PROCESSED-DT          
               PERFORM F8000-INSERT-CREDIT  THRU F8000-EXIT             
               IF WS-ACTIVE-RETURN-CODE = DUPLICATE-FOUND               
                   PERFORM F8100-UPDATE-CREDIT  THRU F8100-EXIT         
               END-IF                                                   
           ELSE                                                         
               PERFORM F7400-CHECK-B-ROW    THRU F7400-EXIT             
               IF WS-EXISTS-B = 'Y'                                     
                   MOVE 'M'                 TO JQ-PROCESS-CD            
                   MOVE ZERO                TO JQ-REV-END-MONTH         
                   MOVE WS-CURRENT-DATE     TO JQ-PROCESSED-DT          
                   PERFORM F8000-INSERT-CREDIT THRU F8000-EXIT          
                   IF WS-ACTIVE-RETURN-CODE = DUPLICATE-FOUND           
                       PERFORM F8100-UPDATE-CREDIT THRU F8100-EXIT      
                   END-IF                                               
                   PERFORM F8400-DELETE-BILL-MSG THRU F8400-EXIT        
               ELSE                                                     
                   PERFORM F8000-INSERT-CREDIT      THRU F8000-EXIT
               END-IF
           END-IF.    
                                                                        
       F1600-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1800-CREDIT-ACTIVE.                                             
                                                                        
           PERFORM F7400-CHECK-B-ROW         THRU F7400-EXIT.           
           PERFORM F7500-HAS-MESSAGE-PRINTED THRU F7500-EXIT.           
           IF WS-EXISTS-B = 'Y' AND WS-EXISTS-BILL-MSG = 'Y'            
               PERFORM F8500-UPDATE-CREDIT THRU F8500-EXIT              
               PERFORM F8300-DELETE-CREDIT           THRU F8300-EXIT    
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   PERFORM F8400-DELETE-BILL-MSG THRU F8400-EXIT        
               END-IF                                                   
           ELSE                                                         
               PERFORM F8200-INSERT-BILL-MSG    THRU F8200-EXIT         
               PERFORM F8000-INSERT-CREDIT      THRU F8000-EXIT
           END-IF.        
                                                                        
                                                                        
       F1800-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1900-ACTIVE-DATES.                                              
                                                                        
           MOVE WS-REV-MTH-LST-NRML TO WS-ACTIVE-END-DT.                
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                  
                 AND COMPANY_NO = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                          
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-SCEG-FRAN-MONTHS          
               WHEN NOT-FOUND                                           
A05317             MOVE 0               TO WS-SCEG-FRAN-MONTHS          
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
                   MOVE 'FRAN_CRDT_SC_NBR_MT'     TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF WS-ACCT-CREATE-DT > '2004-08-03'                          
A05317         MOVE 0 TO WS-SCEG-FRAN-MONTHS
           END-IF.                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                 
                 AND COMPANY_NO = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                         
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-MUN-FRAN-MONTHS           
               WHEN NOT-FOUND                                           
A05317             MOVE 6               TO WS-MUN-FRAN-MONTHS           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_MUN_NBR_MT'    TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A05317     COMPUTE WS-TOT-FRAN-MONTHS =                                 
A05317             WS-MUN-FRAN-MONTHS +                                 
A05317             WS-SCEG-FRAN-MONTHS.                                 
                                                                        
           MOVE WS-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML-X.    
           MOVE WS-REV-MTH-LST-NRML-X(1:4) TO WS-REVENUE-DATE(1:4).     
           MOVE WS-REV-MTH-LST-NRML-X(5:2) TO WS-REVENUE-DATE(6:2).     
           MOVE '01'                       TO WS-REVENUE-DATE(9:2).     
           MOVE '-'                        TO WS-REVENUE-DATE(5:1)      
                                              WS-REVENUE-DATE(8:1).     
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, (DATEADD( MONTH, -(:WS-TOT-FRAN-MONTHS)
              , IIF(TRY_CONVERT(DATE, :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) ) )) )
            INTO
              :WS-FRAN-START-DATE                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-FRAN-START-DATE = (DATE(:WS-REVENUE-DATE) -              
MFA-TR*                    (:WS-TOT-FRAN-MONTHS) MONTH) +                       
MFA-TR*                    1 MONTH                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-FRAN-START-DATE(1:4) TO WS-START-REV-MONTH(1:4).     
           MOVE WS-FRAN-START-DATE(6:2) TO WS-START-REV-MONTH(5:2).     
           MOVE WS-START-REV-MONTH-R    TO WS-ACTIVE-START-DT.          
                                                                        
       F1900-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1950-NO-ACTIVE-DATES.                                           
                                                                        
           MOVE WS-CURR-REV-MONTH-R TO WS-NO-ACTIVE-END-DT.             
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                  
                 AND COMPANY_NO = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                          
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-SCEG-FRAN-MONTHS          
               WHEN NOT-FOUND                                           
A05317             MOVE 0               TO WS-SCEG-FRAN-MONTHS          
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_SC_NBR_MT'     TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF WS-ACCT-CREATE-DT > '2004-08-03'                          
A05317         MOVE 0 TO WS-SCEG-FRAN-MONTHS
           END-IF.                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                 
                 AND COMPANY_NO = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                         
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-MUN-FRAN-MONTHS           
               WHEN NOT-FOUND                                           
A05317             MOVE 6               TO WS-MUN-FRAN-MONTHS           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_MUN_NBR_MT'    TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A05317     COMPUTE WS-TOT-FRAN-MONTHS =                                 
A05317             WS-MUN-FRAN-MONTHS +                                 
A05317             WS-SCEG-FRAN-MONTHS.                                 
                                                                        
           MOVE WS-CURR-REV-MONTH(1:4) TO WS-REVENUE-DATE(1:4).         
           MOVE WS-CURR-REV-MONTH(5:2) TO WS-REVENUE-DATE(6:2).         
           MOVE '01'                   TO WS-REVENUE-DATE(9:2).         
           MOVE '-'                    TO WS-REVENUE-DATE(5:1)          
                                          WS-REVENUE-DATE(8:1).         
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, (DATEADD( MONTH, -(:WS-TOT-FRAN-MONTHS)
              , IIF(TRY_CONVERT(DATE, :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) ) )) )
            INTO
              :WS-FRAN-START-DATE                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-FRAN-START-DATE = (DATE(:WS-REVENUE-DATE) -              
MFA-TR*                    (:WS-TOT-FRAN-MONTHS) MONTH) +                       
MFA-TR*                    1 MONTH                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-FRAN-START-DATE(1:4) TO WS-START-REV-MONTH(1:4).     
           MOVE WS-FRAN-START-DATE(6:2) TO WS-START-REV-MONTH(5:2).     
           MOVE WS-START-REV-MONTH-R    TO WS-NO-ACTIVE-START-DT.       
                                                                        
       F1950-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7000-GET-CURR-MONTH.                                            
                                                                        
           EXEC SQL                                                     
               SELECT CIS.SUBSTR3(PARM_DATA,15,6)                            
                 INTO :WS-CURR-REV-MONTH                                
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND CMND_CODE    = 'DATE'                             
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
                  AND COMPANY_NO   = '01'                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBSTR(PARM_DATA,15,6)                                    
MFA-TR*          INTO :WS-CURR-REV-MONTH                                        
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                                   
MFA-TR*           AND CMND_CODE    = 'DATE'                                     
MFA-TR*           AND SEQ_NO       = 20                                         
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-CURRENT-DATE(1:4) TO WS-CURR-REV-MONTH(1:4)  
                   MOVE WS-CURRENT-DATE(6:2) TO WS-CURR-REV-MONTH(5:2)  
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7000'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_JOB_PARM'            TO TABLE-1            
                   MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1    
                   MOVE 'COMMON'                  TO HOSTVAR-ELEMENT-1  
                   MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2    
                   MOVE 'DATE'                    TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7000-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7200-GET-TAX-RATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) TR.TAX_RATE                                        
                INTO :TR-TAX-RATE                                       
                FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED),                     
                     CSS_TAX_RATE TR WITH(READUNCOMMITTED),                     
                     CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)                  
               WHERE TC.OPER_MODE = 'A'                                 
                 AND TC.OPER_MODE = TR.OPER_MODE                        
                 AND TC.TAX_TYPE  = :TC-TAX-TYPE                        
                 AND TR.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                  
                 AND TR.DATE_FROM IS NOT NULL                           
                 AND TR.DATE_FROM <= IIF(TRY_CONVERT(DATE, :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )                      
                 AND TR.DATE_TO >= IIF(TRY_CONVERT(DATE, :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )                          
                 AND TU.OPER_MODE = TC.OPER_MODE                        
                 AND TU.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                  
                 AND TU.DETAIL_ID = TR.DETAIL_ID                        
                 AND TR.DETAIL_ID = :TR-DETAIL-ID                       
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TR.TAX_RATE                                                
MFA-TR*         INTO :TR-TAX-RATE                                               
MFA-TR*         FROM CSS_TAX_CNTL TC,                                           
MFA-TR*              CSS_TAX_RATE TR,                                           
MFA-TR*              CSS_TAX_USE_CNTL TU                                        
MFA-TR*        WHERE TC.OPER_MODE = 'A'                                         
MFA-TR*          AND TC.OPER_MODE = TR.OPER_MODE                                
MFA-TR*          AND TC.TAX_TYPE  = :TC-TAX-TYPE                                
MFA-TR*          AND TR.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                          
MFA-TR*          AND TR.DATE_FROM IS NOT NULL                                   
MFA-TR*          AND TR.DATE_FROM <= :TR-DATE-FROM                              
MFA-TR*          AND TR.DATE_TO >= :TR-DATE-TO                                  
MFA-TR*          AND TU.OPER_MODE = TC.OPER_MODE                                
MFA-TR*          AND TU.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                          
MFA-TR*          AND TU.DETAIL_ID = TR.DETAIL_ID                                
MFA-TR*          AND TR.DETAIL_ID = :TR-DETAIL-ID                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO TR-TAX-RATE                              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7200'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_TAX_CNTL'            TO TABLE-1            
                   MOVE 'CSS_TAX_RATE'            TO TABLE-2            
                   MOVE 'CSS_TAX_USE_CNTL'        TO TABLE-3            
                   MOVE 'DETAIL_ID'               TO TABLE-ELEMENT-1    
                   MOVE TR-DETAIL-ID              TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7200-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7300-CHECK-I-OR-P-ROW.                                          
                                                                        
           MOVE 'N' TO WS-EXISTS-I-OR-P.                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-NO-F                                   
                FROM CSS_FRNCHSE_CRDT WITH(READUNCOMMITTED)                     
               WHERE PREMISE_NO = :JQ-PREMISE-NO                        
                 AND ACCOUNT_NO = :JQ-ACCOUNT-NO                        
                 AND PROCESS_CD IN ('I', 'P')                           
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-NO-F                                           
MFA-TR*         FROM CSS_FRNCHSE_CRDT                                           
MFA-TR*        WHERE PREMISE_NO = :JQ-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_NO = :JQ-ACCOUNT-NO                                
MFA-TR*          AND PROCESS_CD IN ('I', 'P')                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXISTS-I-OR-P                         
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EXISTS-I-OR-P                         
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7300'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7300-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7400-CHECK-B-ROW.                                               
                                                                        
           MOVE 'N' TO WS-EXISTS-B.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-NO-F                                   
                FROM CSS_FRNCHSE_CRDT WITH(READUNCOMMITTED)                     
               WHERE PREMISE_NO = :JQ-PREMISE-NO                        
                 AND ACCOUNT_NO = :JQ-ACCOUNT-NO                        
                 AND PROCESS_CD = 'B'                                   
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-NO-F                                           
MFA-TR*         FROM CSS_FRNCHSE_CRDT                                           
MFA-TR*        WHERE PREMISE_NO = :JQ-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_NO = :JQ-ACCOUNT-NO                                
MFA-TR*          AND PROCESS_CD = 'B'                                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXISTS-B                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EXISTS-B                              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7400'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7400-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7500-HAS-MESSAGE-PRINTED.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :U1-ACCOUNT-NO                                    
                 FROM CSS_SPCL_BILL_MSG WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND REVENUE_MO_ST  > :AT-REV-MTH-LST-NRML             
                  AND BILL_MSG_ID    = '95048'                          
                  AND MSG_TYPE_CD    = 'M'                              
                  AND REVENUE_MO_END > :AT-REV-MTH-LST-NRML             
                  AND COMPANY_NO     = :AT-COMPANY-NO                   
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :U1-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_SPCL_BILL_MSG                                         
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*           AND REVENUE_MO_ST  > :AT-REV-MTH-LST-NRML                     
MFA-TR*           AND BILL_MSG_ID    = '95048'                                  
MFA-TR*           AND MSG_TYPE_CD    = 'M'                                      
MFA-TR*           AND REVENUE_MO_END > :AT-REV-MTH-LST-NRML                     
MFA-TR*           AND COMPANY_NO     = :AT-COMPANY-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN DUPLICATE-FOUND                                     
                   MOVE 'Y' TO WS-EXISTS-BILL-MSG                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EXISTS-BILL-MSG                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7500'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7500-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8000-INSERT-CREDIT.                                             
                                                                        
           IF JQ-PROCESSED-DT <= SPACES                                 
               MOVE -1 TO WS-NULL-IND-F
           END-IF.                                
           EXEC SQL                                                     
               INSERT INTO CSS_FRNCHSE_CRDT                             
                      (PREMISE_NO,                                      
                       ACCOUNT_NO,                                      
                       REV_END_MONTH,                                   
                       CUSTOMER_NO,                                     
                       CURR_REV_DIST,                                   
                       PREV_REV_DIST,                                   
                       PROCESS_CD,                                      
                       PROCESSED_DT,                                    
                       REV_START_MONTH)                                 
                  VALUES                                                
                      (:JQ-PREMISE-NO,                                  
                       :JQ-ACCOUNT-NO,                                  
                       :JQ-REV-END-MONTH,                               
                       :JQ-CUSTOMER-NO,                                 
                       :JQ-CURR-REV-DIST,                               
                       :JQ-PREV-REV-DIST,                               
                       :JQ-PROCESS-CD,                                  
                       IIF(TRY_CONVERT(DATE, :JQ-PROCESSED-DT 
                                             :WS-NULL-IND-F
              ) IS NULL OR (PATINDEX('%.%', :JQ-PROCESSED-DT 
                                                         :WS-NULL-IND-F
              ) <> 0) OR (LEN(:JQ-PROCESSED-DT :WS-NULL-IND-F
              ) <> 10), CIS.CHAR2DATE(:JQ-PROCESSED-DT :WS-NULL-IND-F
              ), CONVERT(DATE, :JQ-PROCESSED-DT :WS-NULL-IND-F) ),             
                       :JQ-REV-START-MONTH)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FRNCHSE_CRDT                                     
MFA-TR*               (PREMISE_NO,                                              
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                REV_END_MONTH,                                           
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                CURR_REV_DIST,                                           
MFA-TR*                PREV_REV_DIST,                                           
MFA-TR*                PROCESS_CD,                                              
MFA-TR*                PROCESSED_DT,                                            
MFA-TR*                REV_START_MONTH)                                         
MFA-TR*           VALUES                                                        
MFA-TR*               (:JQ-PREMISE-NO,                                          
MFA-TR*                :JQ-ACCOUNT-NO,                                          
MFA-TR*                :JQ-REV-END-MONTH,                                       
MFA-TR*                :JQ-CUSTOMER-NO,                                         
MFA-TR*                :JQ-CURR-REV-DIST,                                       
MFA-TR*                :JQ-PREV-REV-DIST,                                       
MFA-TR*                :JQ-PROCESS-CD,                                          
MFA-TR*                :JQ-PROCESSED-DT :WS-NULL-IND-F,                         
MFA-TR*                :JQ-REV-START-MONTH)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN DUPLICATE-FOUND                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8000'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'INSERT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F8000-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8100-UPDATE-CREDIT.                                             
                                                                        
           IF JQ-PROCESSED-DT <= SPACES                                 
               MOVE -1 TO WS-NULL-IND-F
           END-IF.                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FRNCHSE_CRDT                                  
                  SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                
                      PROCESS_CD    = :JQ-PROCESS-CD,                   
                      PROCESSED_DT  = IIF(TRY_CONVERT(DATE, 
                                                       :JQ-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :JQ-PROCESSED-DT
              ) <> 0) OR (LEN(:JQ-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :JQ-PROCESSED-DT
              ), CONVERT(DATE, :JQ-PROCESSED-DT) )                  
                WHERE PREMISE_NO    = :JQ-PREMISE-NO                    
                  AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                    
                  AND PROCESS_CD    = 'M'                               
                  AND REV_END_MONTH = 0                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FRNCHSE_CRDT                                          
MFA-TR*           SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                        
MFA-TR*               PROCESS_CD    = :JQ-PROCESS-CD,                           
MFA-TR*               PROCESSED_DT  = :JQ-PROCESSED-DT                          
MFA-TR*         WHERE PREMISE_NO    = :JQ-PREMISE-NO                            
MFA-TR*           AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                            
MFA-TR*           AND PROCESS_CD    = 'M'                                       
MFA-TR*           AND REV_END_MONTH = 0                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'UPDATE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8100-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8200-INSERT-BILL-MSG.                                           
                                                                        
           MOVE AT-REV-MTH-LST-NRML  TO WS-BILL-REV-MONTH.              
           MOVE WS-BILL-REV-MONTH(1:4) TO WS-BILL-REV-DATE(1:4).        
           MOVE WS-BILL-REV-MONTH(5:2) TO WS-BILL-REV-DATE(6:2).        
           MOVE '01'                   TO WS-BILL-REV-DATE(9:2).        
           MOVE '-'                    TO WS-BILL-REV-DATE(5:1)         
                                          WS-BILL-REV-DATE(8:1).        
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-BILL-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-REV-DATE
              ) <> 0) OR (LEN(:WS-BILL-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-BILL-REV-DATE
              ), CONVERT(DATE, :WS-BILL-REV-DATE) ) )
            INTO
              :WS-NEXT-BILL-REV-DATE               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-NEXT-BILL-REV-DATE =                                     
MFA-TR*               (DATE(:WS-BILL-REV-DATE) + 1 MONTH)                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-NEXT-BILL-REV-DATE(1:4) TO                           
                WS-NEXT-BILL-REV-MONTH(1:4).                            
           MOVE WS-NEXT-BILL-REV-DATE(6:2) TO                           
                WS-NEXT-BILL-REV-MONTH(5:2).                            
                                                                        
           MOVE WS-NEXT-BILL-REV-MONTH TO U1-REVENUE-MO-ST              
                                          U1-REVENUE-MO-END.            
           MOVE AT-ACCOUNT-NO          TO U1-ACCOUNT-NO.                
           MOVE '95048'                TO U1-BILL-MSG-ID.               
           MOVE 'M'                    TO U1-MSG-TYPE-CD.               
           MOVE AT-COMPANY-NO          TO U1-COMPANY-NO.                
           MOVE 01                     TO U1-BILL-CYCLE-ST.             
           MOVE 21                     TO U1-BILL-CYCLE-END.            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SPCL_BILL_MSG                            
                  (REVENUE_MO_ST,                                       
                   ACCOUNT_NO,                                          
                   BILL_MSG_ID,                                         
                   MSG_TYPE_CD,                                         
                   COMPANY_NO,                                          
                   BILL_CYCLE_ST,                                       
                   BILL_CYCLE_END,                                      
                   REVENUE_MO_END)                                      
                 VALUES                                                 
                  (:U1-REVENUE-MO-ST,                                   
                   :U1-ACCOUNT-NO,                                      
                   :U1-BILL-MSG-ID,                                     
                   :U1-MSG-TYPE-CD,                                     
                   :U1-COMPANY-NO,                                      
                   :U1-BILL-CYCLE-ST,                                   
                   :U1-BILL-CYCLE-END,                                  
                   :U1-REVENUE-MO-END)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN DUPLICATE-FOUND                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8200'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'INSERT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F8200-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8300-DELETE-CREDIT.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_FRNCHSE_CRDT                             
                WHERE PREMISE_NO    = :JQ-PREMISE-NO                    
                  AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                    
                  AND PROCESSED_DT  = (SELECT MAX(PROCESSED_DT)         
                                         FROM CSS_FRNCHSE_CRDT          
                                       WHERE PREMISE_NO = :JQ-PREMISE-NO
                                         AND ACCOUNT_NO = :JQ-ACCOUNT-NO
                                         AND PROCESS_CD = 'B')          
                  AND PROCESS_CD    = 'B'                               
                  AND CURR_REV_DIST = PREV_REV_DIST                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8300'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'DELETE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8300-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8400-DELETE-BILL-MSG.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_SPCL_BILL_MSG                            
                WHERE ACCOUNT_NO     = :JQ-ACCOUNT-NO                   
                  AND REVENUE_MO_ST  > :AT-REV-MTH-LST-NRML             
                  AND BILL_MSG_ID    = '95048'                          
                  AND MSG_TYPE_CD    = 'M'                              
                  AND REVENUE_MO_END > :AT-REV-MTH-LST-NRML             
                  AND COMPANY_NO     = :AT-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8400'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'DELETE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8400-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8500-UPDATE-CREDIT.                                             
                                                                        
           IF JQ-PROCESSED-DT <= SPACES                                 
               MOVE -1 TO WS-NULL-IND-F
           END-IF.                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FRNCHSE_CRDT                                  
                  SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                
                      PROCESS_CD    = :JQ-PROCESS-CD,                   
                      PROCESSED_DT  = IIF(TRY_CONVERT(DATE, 
                                                       :JQ-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :JQ-PROCESSED-DT
              ) <> 0) OR (LEN(:JQ-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :JQ-PROCESSED-DT
              ), CONVERT(DATE, :JQ-PROCESSED-DT) )                  
                WHERE PREMISE_NO    = :JQ-PREMISE-NO                    
                  AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                    
                  AND PROCESSED_DT  = (SELECT MAX(PROCESSED_DT)         
                                         FROM CSS_FRNCHSE_CRDT          
                                       WHERE PREMISE_NO = :JQ-PREMISE-NO
                                         AND ACCOUNT_NO = :JQ-ACCOUNT-NO
                                         AND PROCESS_CD = 'B')          
                  AND PROCESS_CD    = 'B'                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FRNCHSE_CRDT                                          
MFA-TR*           SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                        
MFA-TR*               PROCESS_CD    = :JQ-PROCESS-CD,                           
MFA-TR*               PROCESSED_DT  = :JQ-PROCESSED-DT                          
MFA-TR*         WHERE PREMISE_NO    = :JQ-PREMISE-NO                            
MFA-TR*           AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                            
MFA-TR*           AND PROCESSED_DT  = (SELECT MAX(PROCESSED_DT)                 
MFA-TR*                                  FROM CSS_FRNCHSE_CRDT                  
MFA-TR*                                WHERE PREMISE_NO = :JQ-PREMISE-NO        
MFA-TR*                                  AND ACCOUNT_NO = :JQ-ACCOUNT-NO        
MFA-TR*                                  AND PROCESS_CD = 'B')                  
MFA-TR*           AND PROCESS_CD    = 'B'                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE     
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8500'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'UPDATE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8500-EXIT.                                                      
           EXIT.                                                        
                                                                        
