       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04835.                                          
COB303 DATE-WRITTEN. JUNE 10, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS ACCOUNT/PREMISE DATA FOR WFM.            *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/10/16    FMB      NEW PROGRAM.                                      
      *  03/16/17  DB18339    ADDED CUSTOMER FULL NAME CHECK AND CHANGED        
      *                       METER TYPE TO USE METER SIZE DESC FOR GAS         
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04835'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04835 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPRMRL                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSTCNTY                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRITOG                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDGMTYP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBREVCLS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLCKTYP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBELCLSP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04835_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE 0.         
               10 S-STATUS-CODE         PIC S9(9) COMP VALUE 0.         
               10 S-COMPANY-NO          PIC X(02) VALUE SPACES.         
               10 S-CUST-NAME           PIC X(86) VALUE SPACES.         
               10 S-DBA-NAME            PIC X(70) VALUE SPACES.         
               10 S-SERV-ADDRESS        PIC X(80) VALUE SPACES.         
               10 S-TOWN                PIC X(26) VALUE SPACES.         
               10 S-STATE               PIC X(02) VALUE SPACES.         
               10 S-ZIPCODE             PIC X(05) VALUE SPACES.         
               10 S-ADDRESS-OVERFLOW    PIC X(35) VALUE SPACES.         
               10 S-COUNTY-DESC         PIC X(22) VALUE SPACES.         
               10 S-CROSS-STREET-1      PIC X(35) VALUE SPACES.         
               10 S-CROSS-STREET-2      PIC X(35) VALUE SPACES.         
               10 S-LOT                 PIC X(05) VALUE SPACES.         
               10 S-BLOCK               PIC X(05) VALUE SPACES.         
               10 S-SUBDIVISION-DESC    PIC X(26) VALUE SPACES.         
               10 S-CITY-GATE-ID        PIC X(07) VALUE SPACES.         
               10 S-LOCATOR-ID          PIC X(09) VALUE SPACES.         
               10 S-DIRECTIONS          PIC X(255) VALUE SPACES.        
               10 S-SPCL-READ-INSTR     PIC X(114) VALUE SPACES.        
               10 S-SPECIAL-INSTR       PIC X(255) VALUE SPACES.        
               10 S-SAFETY-FL           PIC X(01) VALUE SPACES.         
               10 S-MAINTENANCE-FL      PIC X(01) VALUE SPACES.         
               10 S-STORM-FL            PIC X(01) VALUE SPACES.         
               10 S-CRITICAL-OUTAGE     PIC X(30) VALUE SPACES.         
               10 S-LATITUDE            PIC S9(3)V9(6) COMP-3 VALUE 0.  
               10 S-LONGITUDE           PIC S9(3)V9(6) COMP-3 VALUE 0.  
               10 S-CODE-ACCT-STAT      PIC X(01) VALUE SPACES.         
               10 S-ACCOUNT-TYPE-CODE   PIC X(01) VALUE SPACES.         
               10 S-ELEC-RLSE-NO        PIC X(10) VALUE SPACES.         
               10 S-ELEC-RLSE-DT        PIC X(10) VALUE SPACES.         
               10 S-GAS-RLSE-NO         PIC X(10) VALUE SPACES.         
               10 S-GAS-RLSE-DT         PIC X(10) VALUE SPACES.         
               10 S-EST-BTU             PIC S9(9) COMP VALUE 0.         
               10 S-SPLIT-SERVICE-FL    PIC X(01) VALUE SPACES.         
               10 S-XCESS-FLOW-FL       PIC X(01) VALUE SPACES.         
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2       PIC S9(9) COMP VALUE 0.         
               10 S-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.         
               10 S-METER-NO            PIC X(09) VALUE SPACES.         
               10 S-METER-STATUS-DESC   PIC X(25) VALUE SPACES.         
               10 S-METER-TYPE-DESC     PIC X(30) VALUE SPACES.         
               10 S-READ-ROUTE          PIC S9(4) COMP VALUE 0.         
               10 S-READ-CYCLE          PIC X(02) VALUE SPACES.         
               10 S-READ-SEQUENCE       PIC S9(9) COMP VALUE 0.         
               10 S-RATE-PLAN-NO        PIC X(03) VALUE SPACES.         
               10 S-RATE-PLAN-DESC      PIC X(50) VALUE SPACES.         
               10 S-REV-CLASS           PIC X(03) VALUE SPACES.         
               10 S-REV-CLASS-DESC      PIC X(26) VALUE SPACES.         
               10 S-EQUIP-MAKE          PIC X(02) VALUE SPACES.         
               10 S-SERIAL-NO           PIC X(11) VALUE SPACES.         
               10 S-CO-SIZE             PIC S9(4) COMP VALUE 0.         
               10 S-AMPS                PIC S9(4) COMP VALUE 0.         
               10 S-WIRES               PIC X(01) VALUE SPACES.         
               10 S-PHASES              PIC X(01) VALUE SPACES.         
               10 S-VOLTAGE             PIC S9(4) COMP VALUE 0.         
               10 S-METER-LOC-DESC      PIC X(14) VALUE SPACES.         
               10 S-LOCK-TYPE           PIC X(09) VALUE SPACES.         
               10 S-METER-PRESSURE      PIC S9(9) COMP VALUE 0.         
               10 S-SUBSTATION          PIC X(05) VALUE SPACES.         
               10 S-CIRCUIT             PIC X(05) VALUE SPACES.         
               10 S-POINT-ID            PIC X(10) VALUE SPACES.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
DBCHG      05  WS-METER-TYPE            PIC X(30) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04835'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.         
           05  WS-CUST-NAME             PIC X(76) VALUE SPACES.         
           05  WS-SAFETY-FL             PIC X(01) VALUE 'N'.            
           05  WS-MAINTENANCE-FL        PIC X(01) VALUE 'N'.            
           05  WS-STORM-FL              PIC X(01) VALUE 'N'.            
           05  WS-ELEC-RLSE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ELEC-RLSE-DT          PIC X(10) VALUE SPACES.         
           05  WS-GAS-RLSE-NO           PIC X(10) VALUE SPACES.         
           05  WS-GAS-RLSE-DT           PIC X(10) VALUE SPACES.         
           05  WS-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
DBCHG      05  WS-EST-BTU               PIC S9(9) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
           EXEC SQL DECLARE COMM-CURSOR CURSOR FOR                      
               SELECT COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE                                 
                 FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND RED_FLAG_IND = 'Y'                                
                  AND (RED_FLAG_EXPIRE_DT > CIS.CHAR2TIMESTAMP(
                                                 :KO-RED-FLAG-EXPIRE-DT
              )      
                   OR  RED_FLAG_EXPIRE_DT IS NULL)                      
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE COMM-CURSOR CURSOR FOR                              
MFA-TR*        SELECT COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE                                         
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND RED_FLAG_IND = 'Y'                                        
MFA-TR*           AND (RED_FLAG_EXPIRE_DT > :KO-RED-FLAG-EXPIRE-DT              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                      
               SELECT UT.CODE_UTIL_TYPE,                                
                      UT.RATE_PLAN_NO,                                  
                      UT.CODE_REVENUE_CLASS,                            
                      IC_NO,                                            
                      READ_ROUTE,                                       
                      READ_CYCLE,                                       
                      RATE_DESC,                                        
                      REVENUE_CLS_DESC                                  
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED),              
                      CSS_REVENUE_CLASS F3 WITH(READUNCOMMITTED)                
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND UT.CODE_UTIL_TYPE IN ('E', 'G')                   
                  AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE             
                  AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                 
                  AND UT.COMPANY_NO = RD.COMPANY_NO                     
                  AND UT.CODE_REVENUE_CLASS = F3.CODE_REVENUE_CLASS     
                  AND UT.CODE_UTIL_TYPE = F3.CODE_UTIL_TYPE             
                  AND UT.COMPANY_NO = F3.COMPANY_NO                     
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                              
MFA-TR*        SELECT UT.CODE_UTIL_TYPE,                                        
MFA-TR*               UT.RATE_PLAN_NO,                                          
MFA-TR*               UT.CODE_REVENUE_CLASS,                                    
MFA-TR*               IC_NO,                                                    
MFA-TR*               READ_ROUTE,                                               
MFA-TR*               READ_CYCLE,                                               
MFA-TR*               RATE_DESC,                                                
MFA-TR*               REVENUE_CLS_DESC                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_RATE_PLAN_DESC RD,                                    
MFA-TR*               CSS_REVENUE_CLASS F3                                      
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E', 'G')                           
MFA-TR*           AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                     
MFA-TR*           AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                         
MFA-TR*           AND UT.COMPANY_NO = RD.COMPANY_NO                             
MFA-TR*           AND UT.CODE_REVENUE_CLASS = F3.CODE_REVENUE_CLASS             
MFA-TR*           AND UT.CODE_UTIL_TYPE = F3.CODE_UTIL_TYPE                     
MFA-TR*           AND UT.COMPANY_NO = F3.COMPANY_NO                             
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE MTR-CURSOR CURSOR FOR                       
               SELECT DIGTL_MTR_TYPE,                                   
                      MN.CODE_METER_LOC,                                
                      METER_PRESSURE,                                   
                      CODE_METER_STATUS,                                
                      LOCK_TYPE_ID,                                     
                      METER_NO,                                         
                      REGISTER_RD_SEQ,                                  
                      CODE_METER_STATUS,                                
                      METER_LOC_DESC,                                   
                      GIS_POINT_ID                                      
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_METER_LOC Q4 WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND IC_NO = :UT-IC-NO                                 
                  AND MN.CODE_METER_LOC = Q4.CODE_METER_LOC             
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE MTR-CURSOR CURSOR FOR                               
MFA-TR*        SELECT DIGTL_MTR_TYPE,                                           
MFA-TR*               MN.CODE_METER_LOC,                                        
MFA-TR*               METER_PRESSURE,                                           
MFA-TR*               CODE_METER_STATUS,                                        
MFA-TR*               LOCK_TYPE_ID,                                             
MFA-TR*               METER_NO,                                                 
MFA-TR*               REGISTER_RD_SEQ,                                          
MFA-TR*               CODE_METER_STATUS,                                        
MFA-TR*               METER_LOC_DESC,                                           
MFA-TR*               GIS_POINT_ID                                              
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_METER_LOC Q4                                          
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :UT-IC-NO                                         
MFA-TR*           AND MN.CODE_METER_LOC = Q4.CODE_METER_LOC                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1        AS RETURN_CODE,           
                      :S-STATUS-CODE          AS STATUS_CODE,           
                      :S-COMPANY-NO           AS COMPANY_NO,            
                      :S-CUST-NAME            AS CUST_NAME,             
                      :S-DBA-NAME             AS DBA_NAME,              
                      :S-SERV-ADDRESS         AS SERV_ADDRESS,          
                      :S-TOWN                 AS TOWN,                  
                      :S-STATE                AS STATE,                 
                      :S-ZIPCODE              AS ZIPCODE,               
                      :S-ADDRESS-OVERFLOW     AS ADDRESS_OVERFLOW,      
                      :S-COUNTY-DESC          AS COUNTY_DESC,           
                      :S-CROSS-STREET-1       AS CROSS_STREET_1,        
                      :S-CROSS-STREET-2       AS CROSS_STREET_2,        
                      :S-LOT                  AS LOT,                   
                      :S-BLOCK                AS BLOCK,                 
                      :S-SUBDIVISION-DESC     AS SUBDIVISION_DESC,      
                      :S-CITY-GATE-ID         AS CITY_GATE_ID,          
                      :S-LOCATOR-ID           AS LOCATOR_ID,            
                      :S-DIRECTIONS           AS DIRECTIONS,            
                      :S-SPCL-READ-INSTR      AS SPCL_READ_INSTR,       
                      :S-SPECIAL-INSTR        AS SPECIAL_INSTR,         
                      :S-SAFETY-FL            AS SAFETY_FL,             
                      :S-MAINTENANCE-FL       AS MAINTENANCE_FL,        
                      :S-STORM-FL             AS STORM_FL,              
                      :S-CRITICAL-OUTAGE      AS CRITICAL_OUTAGE,       
                      :S-LATITUDE             AS LATITUDE,              
                      :S-LONGITUDE            AS LONGITUDE,             
                      :S-CODE-ACCT-STAT       AS CODE_ACCT_STAT,        
                      :S-ACCOUNT-TYPE-CODE    AS ACCOUNT_TYPE_CODE,     
                      :S-ELEC-RLSE-NO         AS ELEC_RLSE_NO,          
                      :S-ELEC-RLSE-DT         AS ELEC_RLSE_DT,          
                      :S-GAS-RLSE-NO          AS GAS_RLSE_NO,           
                      :S-GAS-RLSE-DT          AS GAS_RLSE_DT,           
                      :S-EST-BTU              AS EST_BTU,               
                      :S-SPLIT-SERVICE-FL     AS SPLIT_SERVICE_FL,      
                      :S-XCESS-FLOW-FL        AS XCESS_FLOW_FL          
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1        AS RETURN_CODE,                   
MFA-TR*               :S-STATUS-CODE          AS STATUS_CODE,                   
MFA-TR*               :S-COMPANY-NO           AS COMPANY_NO,                    
MFA-TR*               :S-CUST-NAME            AS CUST_NAME,                     
MFA-TR*               :S-DBA-NAME             AS DBA_NAME,                      
MFA-TR*               :S-SERV-ADDRESS         AS SERV_ADDRESS,                  
MFA-TR*               :S-TOWN                 AS TOWN,                          
MFA-TR*               :S-STATE                AS STATE,                         
MFA-TR*               :S-ZIPCODE              AS ZIPCODE,                       
MFA-TR*               :S-ADDRESS-OVERFLOW     AS ADDRESS_OVERFLOW,              
MFA-TR*               :S-COUNTY-DESC          AS COUNTY_DESC,                   
MFA-TR*               :S-CROSS-STREET-1       AS CROSS_STREET_1,                
MFA-TR*               :S-CROSS-STREET-2       AS CROSS_STREET_2,                
MFA-TR*               :S-LOT                  AS LOT,                           
MFA-TR*               :S-BLOCK                AS BLOCK,                         
MFA-TR*               :S-SUBDIVISION-DESC     AS SUBDIVISION_DESC,              
MFA-TR*               :S-CITY-GATE-ID         AS CITY_GATE_ID,                  
MFA-TR*               :S-LOCATOR-ID           AS LOCATOR_ID,                    
MFA-TR*               :S-DIRECTIONS           AS DIRECTIONS,                    
MFA-TR*               :S-SPCL-READ-INSTR      AS SPCL_READ_INSTR,               
MFA-TR*               :S-SPECIAL-INSTR        AS SPECIAL_INSTR,                 
MFA-TR*               :S-SAFETY-FL            AS SAFETY_FL,                     
MFA-TR*               :S-MAINTENANCE-FL       AS MAINTENANCE_FL,                
MFA-TR*               :S-STORM-FL             AS STORM_FL,                      
MFA-TR*               :S-CRITICAL-OUTAGE      AS CRITICAL_OUTAGE,               
MFA-TR*               :S-LATITUDE             AS LATITUDE,                      
MFA-TR*               :S-LONGITUDE            AS LONGITUDE,                     
MFA-TR*               :S-CODE-ACCT-STAT       AS CODE_ACCT_STAT,                
MFA-TR*               :S-ACCOUNT-TYPE-CODE    AS ACCOUNT_TYPE_CODE,             
MFA-TR*               :S-ELEC-RLSE-NO         AS ELEC_RLSE_NO,                  
MFA-TR*               :S-ELEC-RLSE-DT         AS ELEC_RLSE_DT,                  
MFA-TR*               :S-GAS-RLSE-NO          AS GAS_RLSE_NO,                   
MFA-TR*               :S-GAS-RLSE-DT          AS GAS_RLSE_DT,                   
MFA-TR*               :S-EST-BTU              AS EST_BTU,                       
MFA-TR*               :S-SPLIT-SERVICE-FL     AS SPLIT_SERVICE_FL,              
MFA-TR*               :S-XCESS-FLOW-FL        AS XCESS_FLOW_FL                  
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      CODE_UTIL_TYPE    AS CODE_UTIL_TYPE,              
                      METER_NO          AS METER_NO,                    
                      METER_STATUS_DESC AS METER_STATUS_DESC,           
                      METER_TYPE_DESC   AS METER_TYPE_DESC,             
                      READ_ROUTE        AS READ_ROUTE,                  
                      READ_CYCLE        AS READ_CYCLE,                  
                      READ_SEQUENCE     AS READ_SEQUENCE,               
                      RATE_PLAN_NO      AS RATE_PLAN_NO,                
                      RATE_PLAN_DESC    AS RATE_PLAN_DESC,              
                      REV_CLASS         AS REV_CLASS,                   
                      REV_CLASS_DESC    AS REV_CLASS_DESC,              
                      EQUIP_MAKE        AS EQUIP_MAKE,                  
                      SERIAL_NO         AS SERIAL_NO,                   
                      CO_SIZE           AS CO_SIZE,                     
                      AMPS              AS AMPS,                        
                      WIRES             AS WIRES,                       
                      PHASES            AS PHASES,                      
                      VOLTAGE           AS VOLTAGE,                     
                      METER_LOC_DESC    AS METER_LOC_DESC,              
                      LOCK_TYPE         AS LOCK_TYPE,                   
                      METER_PRESSURE    AS METER_PRESSURE,              
                      SUBSTATION        AS SUBSTATION,                  
                      CIRCUIT           AS CIRCUIT,                     
                      POINT_ID          AS POINT_ID                     
                FROM #CSR04835_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               CODE_UTIL_TYPE    AS CODE_UTIL_TYPE,                      
MFA-TR*               METER_NO          AS METER_NO,                            
MFA-TR*               METER_STATUS_DESC AS METER_STATUS_DESC,                   
MFA-TR*               METER_TYPE_DESC   AS METER_TYPE_DESC,                     
MFA-TR*               READ_ROUTE        AS READ_ROUTE,                          
MFA-TR*               READ_CYCLE        AS READ_CYCLE,                          
MFA-TR*               READ_SEQUENCE     AS READ_SEQUENCE,                       
MFA-TR*               RATE_PLAN_NO      AS RATE_PLAN_NO,                        
MFA-TR*               RATE_PLAN_DESC    AS RATE_PLAN_DESC,                      
MFA-TR*               REV_CLASS         AS REV_CLASS,                           
MFA-TR*               REV_CLASS_DESC    AS REV_CLASS_DESC,                      
MFA-TR*               EQUIP_MAKE        AS EQUIP_MAKE,                          
MFA-TR*               SERIAL_NO         AS SERIAL_NO,                           
MFA-TR*               CO_SIZE           AS CO_SIZE,                             
MFA-TR*               AMPS              AS AMPS,                                
MFA-TR*               WIRES             AS WIRES,                               
MFA-TR*               PHASES            AS PHASES,                              
MFA-TR*               VOLTAGE           AS VOLTAGE,                             
MFA-TR*               METER_LOC_DESC    AS METER_LOC_DESC,                      
MFA-TR*               LOCK_TYPE         AS LOCK_TYPE,                           
MFA-TR*               METER_PRESSURE    AS METER_PRESSURE,                      
MFA-TR*               SUBSTATION        AS SUBSTATION,                          
MFA-TR*               CIRCUIT           AS CIRCUIT,                             
MFA-TR*               POINT_ID          AS POINT_ID                             
MFA-TR*         FROM SESSION.CSR04835_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE,           
                      :S-METER-NO          AS METER_NO,                 
                      :S-METER-STATUS-DESC AS METER_STATUS_DESC,        
                      :S-METER-TYPE-DESC   AS METER_TYPE_DESC,          
                      :S-READ-ROUTE        AS READ_ROUTE,               
                      :S-READ-CYCLE        AS READ_CYCLE,               
                      :S-READ-SEQUENCE     AS READ_SEQUENCE,            
                      :S-RATE-PLAN-NO      AS RATE_PLAN_NO,             
                      :S-RATE-PLAN-DESC    AS RATE_PLAN_DESC,           
                      :S-REV-CLASS         AS REV_CLASS,                
                      :S-REV-CLASS-DESC    AS REV_CLASS_DESC,           
                      :S-EQUIP-MAKE        AS EQUIP_MAKE,               
                      :S-SERIAL-NO         AS SERIAL_NO,                
                      :S-CO-SIZE           AS CO_SIZE,                  
                      :S-AMPS              AS AMPS,                     
                      :S-WIRES             AS WIRES,                    
                      :S-PHASES            AS PHASES,                   
                      :S-VOLTAGE           AS VOLTAGE,                  
                      :S-METER-LOC-DESC    AS METER_LOC_DESC,           
                      :S-LOCK-TYPE         AS LOCK_TYPE,                
                      :S-METER-PRESSURE    AS METER_PRESSURE,           
                      :S-SUBSTATION        AS SUBSTATION,               
                      :S-CIRCUIT           AS CIRCUIT,                  
                      :S-POINT-ID          AS POINT_ID                  
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-METER-NO          AS METER_NO,                         
MFA-TR*               :S-METER-STATUS-DESC AS METER_STATUS_DESC,                
MFA-TR*               :S-METER-TYPE-DESC   AS METER_TYPE_DESC,                  
MFA-TR*               :S-READ-ROUTE        AS READ_ROUTE,                       
MFA-TR*               :S-READ-CYCLE        AS READ_CYCLE,                       
MFA-TR*               :S-READ-SEQUENCE     AS READ_SEQUENCE,                    
MFA-TR*               :S-RATE-PLAN-NO      AS RATE_PLAN_NO,                     
MFA-TR*               :S-RATE-PLAN-DESC    AS RATE_PLAN_DESC,                   
MFA-TR*               :S-REV-CLASS         AS REV_CLASS,                        
MFA-TR*               :S-REV-CLASS-DESC    AS REV_CLASS_DESC,                   
MFA-TR*               :S-EQUIP-MAKE        AS EQUIP_MAKE,                       
MFA-TR*               :S-SERIAL-NO         AS SERIAL_NO,                        
MFA-TR*               :S-CO-SIZE           AS CO_SIZE,                          
MFA-TR*               :S-AMPS              AS AMPS,                             
MFA-TR*               :S-WIRES             AS WIRES,                            
MFA-TR*               :S-PHASES            AS PHASES,                           
MFA-TR*               :S-VOLTAGE           AS VOLTAGE,                          
MFA-TR*               :S-METER-LOC-DESC    AS METER_LOC_DESC,                   
MFA-TR*               :S-LOCK-TYPE         AS LOCK_TYPE,                        
MFA-TR*               :S-METER-PRESSURE    AS METER_PRESSURE,                   
MFA-TR*               :S-SUBSTATION        AS SUBSTATION,                       
MFA-TR*               :S-CIRCUIT           AS CIRCUIT,                          
MFA-TR*               :S-POINT-ID          AS POINT_ID                          
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO,                              
                          LINK-PREMISE-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04835_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04835_R2
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               METER_STATUS_DESC CHAR(25)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               METER_TYPE_DESC CHAR(30)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               READ_ROUTE           SMALLINT,                           
               READ_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               READ_SEQUENCE        INT,                            
               RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RATE_PLAN_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2,        
               REV_CLASS CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,             
               REV_CLASS_DESC CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,        
               EQUIP_MAKE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               SERIAL_NO CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2,             
               CO_SIZE              SMALLINT,                           
               AMPS                 SMALLINT,                           
               WIRES CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               PHASES CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                
               VOLTAGE              SMALLINT,                           
               METER_LOC_DESC CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2,        
               LOCK_TYPE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,             
               METER_PRESSURE       INT,                            
               SUBSTATION CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,            
               CIRCUIT CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,               
               POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04835_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE DCLCSS-PREMISE                                    
                      DCLCSS-ACCOUNT                                    
                      DCLCSS-CUSTOMER                                   
                      DCLCSS-NAME                                       
                      DCLCSS-LOCK-TYPE.                                 
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-PREMISE-NO = ZEROES AND                              
              LINK-ACCOUNT-NO = ZEROES                                  
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE 'ALL PARMS ZERO' TO S-CUST-NAME                  
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7020-SELECT-ACCOUNT THRU 7020-EXIT               
               PERFORM 7030-SELECT-DBA THRU 7030-EXIT                   
               IF AT-CODE-CRIT-OUTAGE > ' '                             
                   PERFORM 7060-SELECT-CRIT-OUTAGE THRU 7060-EXIT       
               END-IF                                                   
               PERFORM 7070-RED-FLAGS THRU 7070-EXIT
           END-IF.                   
                                                                        
           IF PR-PREMISE-NO > 0                                         
               PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT               
               MOVE 'E' TO WS-CODE-UTIL-TYPE                            
               PERFORM 7170-SELECT-RELEASE THRU 7170-EXIT               
               MOVE RP-RLSE-NO TO WS-ELEC-RLSE-NO                       
               MOVE RE-RLSE-DATE(1:10) TO WS-ELEC-RLSE-DT               
               MOVE 'G' TO WS-CODE-UTIL-TYPE                            
               PERFORM 7170-SELECT-RELEASE THRU 7170-EXIT               
               MOVE RP-RLSE-NO TO WS-GAS-RLSE-NO                        
               MOVE RE-RLSE-DATE(1:10) TO WS-GAS-RLSE-DT                
               IF PR-COUNTY > ' '                                       
                   PERFORM 7040-SELECT-COUNTY THRU 7040-EXIT            
               END-IF                                                   
               IF PR-SUBDIVISION-ID > ' '                               
                   PERFORM 7050-SELECT-SUBDIVISION THRU 7050-EXIT       
               END-IF                                                   
DBCHG *        PERFORM 7180-SELECT-GAS-LINE THRU 7180-EXIT.                     
DBCHG          PERFORM 7190-SELECT-ESTIMATED-BTU THRU 7190-EXIT
           END-IF.        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE AT-COMPANY-NO TO S-COMPANY-NO.                          
           MOVE WS-CUST-NAME TO S-CUST-NAME.                            
           MOVE DQ-FULL-NAME TO S-DBA-NAME.                             
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE WS-ADDRESS-LINE-I TO S-SERV-ADDRESS                 
           ELSE                                                         
               MOVE WS-ADDRESS-LINE TO S-SERV-ADDRESS
           END-IF.                  
           MOVE A4-TOWN TO S-TOWN.                                      
           MOVE A4-STATE TO S-STATE.                                    
           MOVE DY-ZIP-CODE TO S-ZIPCODE.                               
           MOVE DY-ADDRESS-OVERFLOW TO S-ADDRESS-OVERFLOW.              
           MOVE SC-COUNTY-DESC TO S-COUNTY-DESC.                        
           MOVE PR-CROSS-STREET-1 TO S-CROSS-STREET-1.                  
           MOVE PR-CROSS-STREET-2 TO S-CROSS-STREET-2.                  
           MOVE PR-LOT TO S-LOT.                                        
           MOVE PR-BLOCK TO S-BLOCK.                                    
           MOVE B0-SUBDIVISION-DESC TO S-SUBDIVISION-DESC.              
           MOVE PR-CITY-GATE-ID TO S-CITY-GATE-ID.                      
           MOVE PR-LOCATOR-ID TO S-LOCATOR-ID.                          
           MOVE PR-PREMISE-DIRECTIONS-TEXT TO S-DIRECTIONS.             
           MOVE PR-SPCL-READ-INSTR-TEXT TO S-SPCL-READ-INSTR.           
           MOVE PR-SPCL-INSTRUCTIONS-TEXT TO S-SPECIAL-INSTR.           
           MOVE WS-SAFETY-FL TO S-SAFETY-FL.                            
           MOVE WS-MAINTENANCE-FL TO S-MAINTENANCE-FL.                  
           MOVE WS-STORM-FL TO S-STORM-FL.                              
           MOVE Q2-CRIT-OUTAGE-DESC TO S-CRITICAL-OUTAGE.               
           MOVE PR-PREM-REF-LATITUDE TO S-LATITUDE.                     
           MOVE PR-PREM-REF-LONGITUDE TO S-LONGITUDE.                   
           MOVE AT-CODE-ACCT-STAT TO S-CODE-ACCT-STAT.                  
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE WS-ELEC-RLSE-NO TO S-ELEC-RLSE-NO.                      
           MOVE WS-ELEC-RLSE-DT TO S-ELEC-RLSE-DT.                      
           MOVE WS-GAS-RLSE-NO TO S-GAS-RLSE-NO.                        
           MOVE WS-GAS-RLSE-DT TO S-GAS-RLSE-DT.                        
           MOVE XO-SPLIT-SERV-FL TO S-SPLIT-SERVICE-FL.                 
           MOVE XO-XS-FLOW-VALVE-FL TO S-XCESS-FLOW-FL.                 
DBCHG *    MOVE Y0-TOTAL-BTU TO S-EST-BTU.                                      
DBCHG      MOVE WS-EST-BTU   TO S-EST-BTU.                              
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7080-OPEN-UTIL-CURSOR THRU 7080-EXIT             
               PERFORM 2100-FETCH-ROWS THRU 2100-EXIT                   
               PERFORM 7081-CLOSE-UTIL-CURSOR THRU 7081-EXIT
           END-IF.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH UTIL-CURSOR                                        
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-RATE-PLAN-NO,                                  
                     :UT-CODE-REVENUE-CLASS,                            
                     :UT-IC-NO,                                         
                     :UT-READ-ROUTE,                                    
                     :UT-READ-CYCLE,                                    
                     :RD-RATE-DESC,                                     
                     :F3-REVENUE-CLS-DESC                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           PERFORM 7090-OPEN-MTR-CURSOR THRU 7090-EXIT.                 
           PERFORM 2110-FETCH-ROWS THRU 2110-EXIT.                      
           PERFORM 7091-CLOSE-MTR-CURSOR THRU 7091-EXIT.                
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MTR-CURSOR                                         
                INTO :MN-DIGTL-MTR-TYPE,                                
                     :MN-CODE-METER-LOC,                                
                     :MN-METER-PRESSURE,                                
                     :MN-CODE-METER-STATUS,                             
                     :MN-LOCK-TYPE-ID,                                  
                     :MN-METER-NO,                                      
                     :MN-REGISTER-RD-SEQ,                               
                     :MN-CODE-METER-STATUS,                             
                     :Q4-METER-LOC-DESC,                                
                     :MN-GIS-POINT-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2110-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-2             
                   MOVE 'IC_NO'          TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE UT-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2          
                   MOVE UT-IC-NO          TO HOSTVAR-ELEMENT-3          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
DBCHG *    IF MN-DIGTL-MTR-TYPE > ' '                                           
DBCHG *        PERFORM 7100-SELECT-DIGITAL-MTR THRU 7100-EXIT.                  
                                                                        
DBCHG      PERFORM 7200-SELECT-METER-TYPE  THRU 7200-EXIT.              
                                                                        
           IF MN-LOCK-TYPE-ID > ' '                                     
               PERFORM 7110-SELECT-LOCK-TYPE THRU 7110-EXIT
           END-IF.            
           PERFORM 7120-SELECT-EQUIPMENT THRU 7120-EXIT.                
           EVALUATE UT-CODE-UTIL-TYPE                                   
               WHEN 'E'                                                 
                   PERFORM 7140-SELECT-ELEC-METER THRU 7140-EXIT        
                   PERFORM 7150-SELECT-AMPS THRU 7150-EXIT              
                   IF MN-GIS-POINT-ID > 0                               
                       PERFORM 7160-SELECT-POINT THRU 7160-EXIT         
                   END-IF                                               
                   INITIALIZE DCLCSS-GAS-METER                          
               WHEN 'G'                                                 
                   PERFORM 7130-SELECT-GAS-METER THRU 7130-EXIT         
                   INITIALIZE DCLCSS-ELEC-METER                         
                              DCLCSS-ELEC-CL-SPEC                       
                              DCLCSS-PIM-POINT                          
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE UT-CODE-UTIL-TYPE TO S-CODE-UTIL-TYPE.                  
           MOVE MN-METER-NO TO S-METER-NO.                              
           EVALUATE MN-CODE-METER-STATUS                                
               WHEN 'A'                                                 
                   MOVE 'ACTIVE - NORMAL BILLING' TO S-METER-STATUS-DESC
               WHEN 'B'                                                 
                   MOVE 'BACKUP METER' TO S-METER-STATUS-DESC           
               WHEN 'I'                                                 
                   MOVE 'MONITOR ONLY - ACTIVE' TO S-METER-STATUS-DESC  
               WHEN 'J'                                                 
                   MOVE 'TURNED OFF' TO S-METER-STATUS-DESC             
               WHEN 'K'                                                 
                   MOVE 'REMOVED' TO S-METER-STATUS-DESC                
               WHEN 'T'                                                 
                   MOVE 'METER SONP' TO S-METER-STATUS-DESC             
           END-EVALUATE.                                                
DBCHG      MOVE WS-METER-TYPE TO S-METER-TYPE-DESC.                     
           MOVE UT-READ-ROUTE TO S-READ-ROUTE.                          
           MOVE UT-READ-CYCLE TO S-READ-CYCLE.                          
           MOVE MN-REGISTER-RD-SEQ TO S-READ-SEQUENCE.                  
           MOVE UT-RATE-PLAN-NO TO S-RATE-PLAN-NO.                      
           MOVE RD-RATE-DESC TO S-RATE-PLAN-DESC.                       
           MOVE UT-CODE-REVENUE-CLASS TO S-REV-CLASS.                   
           MOVE F3-REVENUE-CLS-DESC TO S-REV-CLASS-DESC.                
           MOVE EQ-CODE-MAKE TO S-EQUIP-MAKE.                           
           MOVE EQ-SERIAL-NO TO S-SERIAL-NO.                            
           MOVE GM-CODE-CO-SIZE TO S-CO-SIZE.                           
           MOVE U0-CLASS-AMPS TO S-AMPS.                                
           MOVE EM-NO-WIRES TO S-WIRES.                                 
           MOVE EM-NO-PHASES TO S-PHASES.                               
           MOVE EM-VOLTAGE TO S-VOLTAGE.                                
           MOVE Q4-METER-LOC-DESC TO S-METER-LOC-DESC.                  
           MOVE B3-LOCK-TYPE-DESC TO S-LOCK-TYPE.                       
           MOVE MN-METER-PRESSURE TO S-METER-PRESSURE.                  
           MOVE PP-SUBSTATION-ID TO S-SUBSTATION.                       
           MOVE PP-CIRCUIT-ID TO S-CIRCUIT.                             
           MOVE PP-AREA-ID TO S-POINT-ID(1:3).                          
           MOVE PP-TAG-NM TO S-POINT-ID(4:7).                           
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2110-FETCH-ROWS.                                       
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           MOVE SPACES TO PR-SPCL-READ-INSTR                            
                          PR-SPCL-INSTRUCTIONS                          
                          PR-PREMISE-DIRECTIONS.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2)))))))))),
              RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW)))),
              ADDR_USAGE_CD,
              PR.ADDRESS_ID,
              DY.ADDRESS_OVERFLOW,
              TOWN,
              STATE,
              DY.ZIP_CODE,
              LOT,
              BLOCK,
              COUNTY,
              LOCATOR_ID,
              SUBDIVISION_ID,
              CITY_GATE_ID,
              CROSS_STREET_1,
              CROSS_STREET_2,
              PREM_REF_LATITUDE,
              PREM_REF_LONGITUDE,
              SPCL_READ_INSTR,
              SPCL_INSTRUCTIONS,
              PREMISE_DIRECTIONS,
              COMPANY_NO                                         
                INTO :WS-ADDRESS-LINE,                                  
                     :WS-ADDRESS-LINE-I,                                
                     :DY-ADDR-USAGE-CD,                                 
                     :PR-ADDRESS-ID,                                    
                     :DY-ADDRESS-OVERFLOW,                              
                     :A4-TOWN,                                          
                     :A4-STATE,                                         
                     :DY-ZIP-CODE,                                      
                     :PR-LOT,                                           
                     :PR-BLOCK,                                         
                     :PR-COUNTY,                                        
                     :PR-LOCATOR-ID,                                    
                     :PR-SUBDIVISION-ID,                                
                     :PR-CITY-GATE-ID,                                  
                     :PR-CROSS-STREET-1,                                
                     :PR-CROSS-STREET-2,                                
                     :PR-PREM-REF-LATITUDE,                             
                     :PR-PREM-REF-LONGITUDE,                            
                     :PR-SPCL-READ-INSTR,                               
                     :PR-SPCL-INSTRUCTIONS,                             
                     :PR-PREMISE-DIRECTIONS,                            
                     :PR-COMPANY-NO                                     
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND PR.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)))))))))),                   
MFA-TR*              RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||                
MFA-TR*              LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                          
MFA-TR*              ADDR_USAGE_CD,                                             
MFA-TR*              PR.ADDRESS_ID,                                     13330000
MFA-TR*              DY.ADDRESS_OVERFLOW,                               13390000
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE,                                                     
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              LOT,                                                       
MFA-TR*              BLOCK,                                                     
MFA-TR*              COUNTY,                                                    
MFA-TR*              LOCATOR_ID,                                                
MFA-TR*              SUBDIVISION_ID,                                            
MFA-TR*              CITY_GATE_ID,                                              
MFA-TR*              CROSS_STREET_1,                                            
MFA-TR*              CROSS_STREET_2,                                            
MFA-TR*              PREM_REF_LATITUDE,                                         
MFA-TR*              PREM_REF_LONGITUDE,                                        
MFA-TR*              SPCL_READ_INSTR,                                           
MFA-TR*              SPCL_INSTRUCTIONS,                                         
MFA-TR*              PREMISE_DIRECTIONS,                                        
MFA-TR*              COMPANY_NO                                                 
MFA-TR*         INTO :WS-ADDRESS-LINE,                                          
MFA-TR*              :WS-ADDRESS-LINE-I,                                        
MFA-TR*              :DY-ADDR-USAGE-CD,                                         
MFA-TR*              :PR-ADDRESS-ID,                                    13330000
MFA-TR*              :DY-ADDRESS-OVERFLOW,                              13390000
MFA-TR*              :A4-TOWN,                                                  
MFA-TR*              :A4-STATE,                                                 
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :PR-LOT,                                                   
MFA-TR*              :PR-BLOCK,                                                 
MFA-TR*              :PR-COUNTY,                                                
MFA-TR*              :PR-LOCATOR-ID,                                            
MFA-TR*              :PR-SUBDIVISION-ID,                                        
MFA-TR*              :PR-CITY-GATE-ID,                                          
MFA-TR*              :PR-CROSS-STREET-1,                                        
MFA-TR*              :PR-CROSS-STREET-2,                                        
MFA-TR*              :PR-PREM-REF-LATITUDE,                                     
MFA-TR*              :PR-PREM-REF-LONGITUDE,                                    
MFA-TR*              :PR-SPCL-READ-INSTR,                                       
MFA-TR*              :PR-SPCL-INSTRUCTIONS,                                     
MFA-TR*              :PR-PREMISE-DIRECTIONS,                                    
MFA-TR*              :PR-COMPANY-NO                                             
MFA-TR*         FROM CSS_PREMISE PR,                                    13550000
MFA-TR*              CSS_ADDR_FORMATTED DY,                             13551000
MFA-TR*              CSS_ZIP_CODE A4                                    13551000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        13560000
MFA-TR*          AND PR.ADDRESS_ID = DY.ADDRESS_ID                      13561000
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                          13562000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              13562000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE' TO TABLE-1                        
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COMPANY_NO,
              PREMISE_NO,
              ACCOUNT_TYPE_CODE,
              CODE_ACCT_STAT,
              CODE_CRIT_OUTAGE,
              CASE WHEN RTRIM(LAST_NAME) > ''                    
                     THEN                                               
                     RTRIM(RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME
           ) + ' ' + RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1)
           ) ELSE                        
                     RTRIM(FULL_NAME) END                               
                INTO :AT-COMPANY-NO,                                    
                     :AT-PREMISE-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :AT-CODE-CRIT-OUTAGE,                              
                     :WS-CUST-NAME                                      
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                    
                 AND CU.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT COMPANY_NO,                                        14210000
MFA-TR*              PREMISE_NO,                                        14210000
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CODE_CRIT_OUTAGE,                                          
MFA-TR*              CASE WHEN RTRIM(LAST_NAME) > ''                            
MFA-TR*              THEN                                                       
MFA-TR*              RTRIM(RTRIM(FIRST_NAME) ||                                 
MFA-TR*                     ' ' ||                                              
MFA-TR*              RTRIM(MIDDLE_NAME) ||                                      
MFA-TR*                    ' ' ||                                               
MFA-TR*              RTRIM(LAST_NAME) ||                                        
MFA-TR*                     ' ' ||                                              
MFA-TR*              RTRIM(TITLE_SUFFIX_1)) ELSE                                
MFA-TR*              RTRIM(FULL_NAME) END                                       
MFA-TR*         INTO :AT-COMPANY-NO,                                    14380000
MFA-TR*              :AT-PREMISE-NO,                                    14380000
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-CODE-CRIT-OUTAGE,                                      
MFA-TR*              :WS-CUST-NAME                                              
MFA-TR*         FROM CSS_ACCOUNT AT,                                    14550000
MFA-TR*              CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        14560000
MFA-TR*          AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                            
MFA-TR*          AND CU.NAME_ID = DQ.NAME_ID                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF PR-PREMISE-NO = 0                                 
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7020'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT' TO TABLE-1                        
                   MOVE 'CSS_CUSTOMER' TO TABLE-2                       
                   MOVE 'CSS_NAME' TO TABLE-3                           
                   MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                 
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-DBA.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FULL_NAME                                         
                 INTO :DQ-FULL-NAME                                     
                 FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND AB.NAME_TYPE = 'DB'                               
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FULL_NAME                                                 
MFA-TR*          INTO :DQ-FULL-NAME                                             
MFA-TR*          FROM CSS_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_TYPE = 'DB'                                       
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO DQ-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7030'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'CSS_NAME' TO TABLE-2                           
                   MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                 
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-COUNTY.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COUNTY_DESC                                       
                 INTO :SC-COUNTY-DESC                                   
                 FROM CSS_STATE_COUNTY WITH(READUNCOMMITTED)                    
                WHERE STATE = :A4-STATE                                 
                  AND COUNTY = :PR-COUNTY                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNTY_DESC                                               
MFA-TR*          INTO :SC-COUNTY-DESC                                           
MFA-TR*          FROM CSS_STATE_COUNTY                                          
MFA-TR*         WHERE STATE = :A4-STATE                                         
MFA-TR*           AND COUNTY = :PR-COUNTY                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO SC-COUNTY-DESC                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7040'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_STATE_COUNTY' TO TABLE-1                   
                   MOVE A4-STATE      TO HOSTVAR-ELEMENT-1              
                   MOVE PR-COUNTY     TO HOSTVAR-ELEMENT-2              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-SUBDIVISION.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SUBDIVISION_DESC                                  
                 INTO :B0-SUBDIVISION-DESC                              
                 FROM CSS_SUBDIVISION WITH(READUNCOMMITTED)                     
                WHERE COMPANY_NO = :PR-COMPANY-NO                       
                  AND SUBDIVISION_ID = :PR-SUBDIVISION-ID               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBDIVISION_DESC                                          
MFA-TR*          INTO :B0-SUBDIVISION-DESC                                      
MFA-TR*          FROM CSS_SUBDIVISION                                           
MFA-TR*         WHERE COMPANY_NO = :PR-COMPANY-NO                               
MFA-TR*           AND SUBDIVISION_ID = :PR-SUBDIVISION-ID                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO B0-SUBDIVISION-DESC                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7050'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_SUBDIVISION' TO TABLE-1                    
                   MOVE PR-COMPANY-NO TO HOSTVAR-ELEMENT-1              
                   MOVE PR-SUBDIVISION-ID TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-CRIT-OUTAGE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CRIT_OUTAGE_DESC                                  
                 INTO :Q2-CRIT-OUTAGE-DESC                              
                 FROM CSS_CRIT_OUTAGE WITH(READUNCOMMITTED)                     
                WHERE COMPANY_NO = :AT-COMPANY-NO                       
                  AND CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CRIT_OUTAGE_DESC                                          
MFA-TR*          INTO :Q2-CRIT-OUTAGE-DESC                                      
MFA-TR*          FROM CSS_CRIT_OUTAGE                                           
MFA-TR*         WHERE COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*           AND CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO Q2-CRIT-OUTAGE-DESC                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7060'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CRIT_OUTAGE' TO TABLE-1                    
                   MOVE AT-COMPANY-NO TO HOSTVAR-ELEMENT-1              
                   MOVE AT-CODE-CRIT-OUTAGE TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-RED-FLAGS.                                                  
                                                                        
           MOVE WS-CURRENT-TS TO KO-RED-FLAG-EXPIRE-DT.                 
                                                                        
           EXEC SQL                                                     
              OPEN COMM-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
           PERFORM 7071-FETCH-COMMUNICATIONS THRU 7071-EXIT.            
                                                                        
           EXEC SQL                                                     
              CLOSE COMM-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7071-FETCH-COMMUNICATIONS.                                       
                                                                        
           EXEC SQL                                                     
               FETCH COMM-CURSOR                                        
                INTO :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF (KO-COMM-TYPE-CD      = '31' AND                  
                       KO-COMM-SUBTYPE-CODE = '02') OR                  
                      (KO-COMM-TYPE-CD      = '48')                     
                          MOVE 'Y' TO WS-SAFETY-FL                      
                   END-IF                                               
                   IF (KO-COMM-TYPE-CD      = '04' AND                  
                       KO-COMM-SUBTYPE-CODE = '06') OR                  
                      (KO-COMM-TYPE-CD      = '41' AND                  
                       KO-COMM-SUBTYPE-CODE = '09')                     
                          MOVE 'Y' TO WS-MAINTENANCE-FL                 
                   END-IF                                               
                   IF (KO-COMM-TYPE-CD      = '04' AND                  
                       KO-COMM-SUBTYPE-CODE = '17') OR                  
                      (KO-COMM-TYPE-CD      = '41' AND                  
                       KO-COMM-SUBTYPE-CODE = '05')                     
                          MOVE 'Y' TO WS-STORM-FL                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 7071-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSS_COMM_DATA'       TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 7071-FETCH-COMMUNICATIONS.                             
                                                                        
       7071-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-OPEN-UTIL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN UTIL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7080'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7081-CLOSE-UTIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE UTIL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7081'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7081-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-OPEN-MTR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN MTR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-2             
                   MOVE 'IC_NO'          TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE UT-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2          
                   MOVE UT-IC-NO          TO HOSTVAR-ELEMENT-3          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7091-CLOSE-MTR-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE MTR-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7091'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7091-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-DIGITAL-MTR.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DIGTL_MTR_TYP_DESC                                
                 INTO :T1-DIGTL-MTR-TYP-DESC                            
                 FROM CSS_DIGTL_MTR_TYPE WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND DIGTL_MTR_TYPE = :MN-DIGTL-MTR-TYPE               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYP_DESC                                        
MFA-TR*          INTO :T1-DIGTL-MTR-TYP-DESC                                    
MFA-TR*          FROM CSS_DIGTL_MTR_TYPE                                        
MFA-TR*         WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND DIGTL_MTR_TYPE = :MN-DIGTL-MTR-TYPE                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO T1-DIGTL-MTR-TYP-DESC                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7100'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DIGTL_MTR_TYPE' TO TABLE-1                 
                   MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1         
                   MOVE 'DIGTL_MTR_TYPE'     TO TABLE-ELEMENT-2         
                   MOVE UT-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-1          
                   MOVE MN-DIGTL-MTR-TYPE TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-LOCK-TYPE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) LOCK_TYPE_DESC                                    
                 INTO :B3-LOCK-TYPE-DESC                                
                 FROM CSS_LOCK_TYPE WITH(READUNCOMMITTED)                       
                WHERE LOCK_TYPE_ID = :MN-LOCK-TYPE-ID                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCK_TYPE_DESC                                            
MFA-TR*          INTO :B3-LOCK-TYPE-DESC                                        
MFA-TR*          FROM CSS_LOCK_TYPE                                             
MFA-TR*         WHERE LOCK_TYPE_ID = :MN-LOCK-TYPE-ID                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO B3-LOCK-TYPE-DESC                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7110'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_LOCK_TYPE'   TO TABLE-1                    
                   MOVE 'LOCK_TYPE_ID'       TO TABLE-ELEMENT-1         
                   MOVE MN-LOCK-TYPE-ID   TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERIAL_NO,
              CODE_MAKE                                         
                 INTO :EQ-SERIAL-NO,                                    
                      :EQ-CODE-MAKE                                     
                 FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                       
                WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND DEVICE_NO = :MN-METER-NO                          
                  AND EQUIP_TYPE_CD = 'M'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERIAL_NO,                                                
MFA-TR*               CODE_MAKE                                                 
MFA-TR*          INTO :EQ-SERIAL-NO,                                            
MFA-TR*               :EQ-CODE-MAKE                                             
MFA-TR*          FROM CSS_EQUIPMENT                                             
MFA-TR*         WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND DEVICE_NO = :MN-METER-NO                                  
MFA-TR*           AND EQUIP_TYPE_CD = 'M'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-EQUIPMENT                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7120'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_EQUIPMENT'   TO TABLE-1                    
                   MOVE 'CODE_UTIL_TYPE'  TO TABLE-ELEMENT-1            
                   MOVE 'DEVICE_NO'       TO TABLE-ELEMENT-2            
                   MOVE 'EQUIP_TYPE_CD'   TO TABLE-ELEMENT-3            
                   MOVE UT-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-1          
                   MOVE MN-METER-NO       TO HOSTVAR-ELEMENT-2          
                   MOVE 'M'               TO HOSTVAR-ELEMENT-3          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SELECT-GAS-METER.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_CO_SIZE                                      
                 INTO :GM-CODE-CO-SIZE                                  
                 FROM CSS_GAS_METER WITH(READUNCOMMITTED)                       
                WHERE CODE_UTIL_TYPE = 'G'                              
                  AND METER_NO = :MN-METER-NO                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_CO_SIZE                                              
MFA-TR*          INTO :GM-CODE-CO-SIZE                                          
MFA-TR*          FROM CSS_GAS_METER                                             
MFA-TR*         WHERE CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND METER_NO = :MN-METER-NO                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  GM-CODE-CO-SIZE                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7130'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_GAS_METER'   TO TABLE-1                    
                   MOVE 'CODE_UTIL_TYPE'  TO TABLE-ELEMENT-1            
                   MOVE 'METER_NO'        TO TABLE-ELEMENT-2            
                   MOVE 'G'               TO HOSTVAR-ELEMENT-1          
                   MOVE MN-METER-NO       TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-SELECT-ELEC-METER.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) NO_WIRES,
              NO_PHASES,
              VOLTAGE,
              ELEC_MTR_CLASS_CD,
              ELEC_MTR_SPEC_CD                                  
                 INTO :EM-NO-WIRES,                                     
                      :EM-NO-PHASES,                                    
                      :EM-VOLTAGE,                                      
                      :EM-ELEC-MTR-CLASS-CD,                            
                      :EM-ELEC-MTR-SPEC-CD                              
                 FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                      
                WHERE CODE_UTIL_TYPE = 'E'                              
                  AND METER_NO = :MN-METER-NO                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NO_WIRES,                                                 
MFA-TR*               NO_PHASES,                                                
MFA-TR*               VOLTAGE,                                                  
MFA-TR*               ELEC_MTR_CLASS_CD,                                        
MFA-TR*               ELEC_MTR_SPEC_CD                                          
MFA-TR*          INTO :EM-NO-WIRES,                                             
MFA-TR*               :EM-NO-PHASES,                                            
MFA-TR*               :EM-VOLTAGE,                                              
MFA-TR*               :EM-ELEC-MTR-CLASS-CD,                                    
MFA-TR*               :EM-ELEC-MTR-SPEC-CD                                      
MFA-TR*          FROM CSS_ELEC_METER                                            
MFA-TR*         WHERE CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND METER_NO = :MN-METER-NO                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7140                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ELEC-METER                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7140'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ELEC_METER'  TO TABLE-1                    
                   MOVE 'CODE_UTIL_TYPE'  TO TABLE-ELEMENT-1            
                   MOVE 'METER_NO'        TO TABLE-ELEMENT-2            
                   MOVE 'E'               TO HOSTVAR-ELEMENT-1          
                   MOVE MN-METER-NO       TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-SELECT-AMPS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CLASS_AMPS                                        
                 INTO :U0-CLASS-AMPS                                    
                 FROM CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                    
                WHERE ELEC_MTR_CLASS_CD = :EM-ELEC-MTR-CLASS-CD         
                  AND ELEC_MTR_SPEC_CD = :EM-ELEC-MTR-SPEC-CD           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CLASS_AMPS                                                
MFA-TR*          INTO :U0-CLASS-AMPS                                            
MFA-TR*          FROM CSS_ELEC_CL_SPEC                                          
MFA-TR*         WHERE ELEC_MTR_CLASS_CD = :EM-ELEC-MTR-CLASS-CD                 
MFA-TR*           AND ELEC_MTR_SPEC_CD = :EM-ELEC-MTR-SPEC-CD                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  U0-CLASS-AMPS                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7150'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ELEC_CL_SPEC' TO TABLE-1                   
                   MOVE 'ELEC_MTR_CLASS_CD'  TO TABLE-ELEMENT-1         
                   MOVE 'ELEC_MTR_SPEC_CD' TO TABLE-ELEMENT-2           
                   MOVE EM-ELEC-MTR-CLASS-CD TO HOSTVAR-ELEMENT-1       
                   MOVE EM-ELEC-MTR-SPEC-CD TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-SELECT-POINT.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AREA_ID,
              TAG_NM,
              SUBSTATION_ID,
              CIRCUIT_ID                                        
                 INTO :PP-AREA-ID,                                      
                      :PP-TAG-NM,                                       
                      :PP-SUBSTATION-ID,                                
                      :PP-CIRCUIT-ID                                    
                 FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                       
                WHERE POINT_ID = :MN-GIS-POINT-ID                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AREA_ID,                                                  
MFA-TR*               TAG_NM,                                                   
MFA-TR*               SUBSTATION_ID,                                            
MFA-TR*               CIRCUIT_ID                                                
MFA-TR*          INTO :PP-AREA-ID,                                              
MFA-TR*               :PP-TAG-NM,                                               
MFA-TR*               :PP-SUBSTATION-ID,                                        
MFA-TR*               :PP-CIRCUIT-ID                                            
MFA-TR*          FROM CSS_PIM_POINT                                             
MFA-TR*         WHERE POINT_ID = :MN-GIS-POINT-ID                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-PIM-POINT                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7160'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PIM_POINT' TO TABLE-1                      
                   MOVE 'POINT_ID'      TO TABLE-ELEMENT-1              
                   MOVE MN-GIS-POINT-ID TO HOSTVAR-ELEMENT-1            
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-SELECT-RELEASE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RP.RLSE_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE, 121), ' ', 
           '-'), ':', '.') RLSE_DATE                                         
                 INTO :RP-RLSE-NO,                                      
                      :RE-RLSE-DATE                                     
                 FROM CSS_PREM_RLSE RE WITH(READUNCOMMITTED),                   
                      CSS_PREM_RLSE_DATA RP WITH(READUNCOMMITTED)               
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND RP.RLSE_NO = RE.RLSE_NO                           
                  AND RP.REV_DISTRICT_CD = RE.REV_DISTRICT_CD           
                  AND RP.RLSE_NO > ' '                                  
                  AND CIS.SUBSTR3(RLSE_TYPE,1,1) = :WS-CODE-UTIL-TYPE        
                  AND RLSE_EXP_DATE > CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS)        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RP.RLSE_NO,                                               
MFA-TR*               RLSE_DATE                                                 
MFA-TR*          INTO :RP-RLSE-NO,                                              
MFA-TR*               :RE-RLSE-DATE                                             
MFA-TR*          FROM CSS_PREM_RLSE RE,                                         
MFA-TR*               CSS_PREM_RLSE_DATA RP                                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND RP.RLSE_NO = RE.RLSE_NO                                   
MFA-TR*           AND RP.REV_DISTRICT_CD = RE.REV_DISTRICT_CD                   
MFA-TR*           AND RP.RLSE_NO > ' '                                          
MFA-TR*           AND SUBSTR(RLSE_TYPE,1,1) = :WS-CODE-UTIL-TYPE                
MFA-TR*           AND RLSE_EXP_DATE > :WS-CURRENT-TS                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7170                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO RP-RLSE-NO                            
                                  RE-RLSE-DATE                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7170'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE' TO TABLE-1                      
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-2                 
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-2             
                   MOVE PR-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE WS-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7180-SELECT-GAS-LINE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SPLIT_SERV_FL,
              XS_FLOW_VALVE_FL,
              Y0.TOTAL_BTU                                      
                 INTO :XO-SPLIT-SERV-FL,                                
                      :XO-XS-FLOW-VALVE-FL,                             
                      :Y0-TOTAL-BTU                                     
                 FROM CSS_PREM_GAS_LINE Y0 WITH(READUNCOMMITTED),               
                      CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND Y0.SERVICE_NO = XO.SERVICE_NO                     
                  AND SERV_LINE_STAT_FL IN ('A', 'P', 'T')              
               ORDER BY SERV_LINE_STAT_FL                               
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SPLIT_SERV_FL,                                            
MFA-TR*               XS_FLOW_VALVE_FL,                                         
MFA-TR*               Y0.TOTAL_BTU                                              
MFA-TR*          INTO :XO-SPLIT-SERV-FL,                                        
MFA-TR*               :XO-XS-FLOW-VALVE-FL,                                     
MFA-TR*               :Y0-TOTAL-BTU                                             
MFA-TR*          FROM CSS_PREM_GAS_LINE Y0,                                     
MFA-TR*               CSS_GAS_SERV_LINE XO                                      
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND Y0.SERVICE_NO = XO.SERVICE_NO                             
MFA-TR*           AND SERV_LINE_STAT_FL IN ('A', 'P', 'T')                      
MFA-TR*        ORDER BY SERV_LINE_STAT_FL                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*        QUERYNO 7180                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-GAS-SERV-LINE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_GAS_SERV_LINE'  TO TABLE-1                 
                   MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-2                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
DBCHG  7190-SELECT-ESTIMATED-BTU.                                       
                                                                        
           EXEC SQL                                                     
               SELECT CASE WHEN SUM(AVERAGE_BTU) IS NULL                
                           THEN 0 ELSE SUM(AVERAGE_BTU) END             
                 INTO :WS-EST-BTU                                       
               FROM CSS_APPLIANCE LA,                                   
                    CSS_MKT_APPLIANCE JA                                
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                  
                 AND LA.COMPANY_NO = JA.COMPANY_NO                      
                 AND CIS_DISPLAY_FL = 'Y'                               
                 AND PRIMARY_FUEL_CD = 'NA-GAS'                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CASE WHEN SUM(AVERAGE_BTU) IS NULL                        
MFA-TR*                    THEN 0 ELSE SUM(AVERAGE_BTU) END                     
MFA-TR*          INTO :WS-EST-BTU                                               
MFA-TR*        FROM CSS_APPLIANCE LA,                                           
MFA-TR*             CSS_MKT_APPLIANCE JA                                        
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                          
MFA-TR*          AND LA.COMPANY_NO = JA.COMPANY_NO                              
MFA-TR*          AND CIS_DISPLAY_FL = 'Y'                                       
MFA-TR*          AND PRIMARY_FUEL_CD = 'NA-GAS'                                 
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-GAS-SERV-LINE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7190'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
                   MOVE 'CSS_MKT_APPLIANCE'  TO TABLE-2                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
DBCHG  7190-EXIT.                                                       
DBCHG      EXIT.                                                        
                                                                        
DBCHG  7200-SELECT-METER-TYPE.                                          
                                                                        
           IF UT-CODE-UTIL-TYPE = 'G'                                   
                                                                        
              EXEC SQL                                                  
               SELECT TOP(1) S.METER_SIZE_DESC                                 
                 INTO :WS-METER-TYPE                                    
                FROM CSS_GAS_METER G WITH(READUNCOMMITTED)                      
                INNER JOIN CSS_GAS_METER_SIZE S WITH(READUNCOMMITTED)           
                 ON G.METER_SIZE_ID = S.METER_SIZE_ID                   
                 AND G.COMPANY_NO = S.COMPANY_NO                        
                WHERE G.METER_NO = :MN-METER-NO                         
                 AND G.COMPANY_NO = :AT-COMPANY-NO                      
                                                 
                                                                 
                                                            
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*        SELECT S.METER_SIZE_DESC                                         
MFA-TR*          INTO :WS-METER-TYPE                                            
MFA-TR*         FROM CSS_GAS_METER G                                            
MFA-TR*         INNER JOIN CSS_GAS_METER_SIZE S                                 
MFA-TR*          ON G.METER_SIZE_ID = S.METER_SIZE_ID                           
MFA-TR*          AND G.COMPANY_NO = S.COMPANY_NO                                
MFA-TR*         WHERE G.METER_NO = :MN-METER-NO                                 
MFA-TR*          AND G.COMPANY_NO = :AT-COMPANY-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
                                                                        
           ELSE                                                         
                                                                        
              EXEC SQL                                                  
               SELECT TOP(1) EM.METER_SIZE_ID                                  
                 INTO :WS-METER-TYPE                                    
                FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
                INNER JOIN CSS_ELEC_METER EM WITH(READUNCOMMITTED)              
                 ON EQ.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE               
                 AND EQ.COMPANY_NO = EM.COMPANY_NO                      
                 AND EQ.DEVICE_NO = EM.METER_NO                         
                WHERE EM.METER_NO = :MN-METER-NO                        
                 AND EQ.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                 AND EQ.COMPANY_NO = :AT-COMPANY-NO                     
                                                 
                                                                 
                                                            
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*        SELECT EM.METER_SIZE_ID                                          
MFA-TR*          INTO :WS-METER-TYPE                                            
MFA-TR*         FROM CSS_EQUIPMENT EQ                                           
MFA-TR*         INNER JOIN CSS_ELEC_METER EM                                    
MFA-TR*          ON EQ.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE                       
MFA-TR*          AND EQ.COMPANY_NO = EM.COMPANY_NO                              
MFA-TR*          AND EQ.DEVICE_NO = EM.METER_NO                                 
MFA-TR*         WHERE EM.METER_NO = :MN-METER-NO                                
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.COMPANY_NO = :AT-COMPANY-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
                                                                        
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-METER-TYPE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7200'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_EQUIPMENT'      TO TABLE-1                 
                   MOVE 'METER_NO'           TO TABLE-ELEMENT-1         
                   MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2         
                   MOVE MN-METER-NO       TO HOSTVAR-ELEMENT-1          
                   MOVE UT-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
DBCHG  7200-EXIT.                                                       
DBCHG      EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04835_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04835_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04835_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04835_R2                            
             (                                                          
               RETURN_CODE,                                             
               CODE_UTIL_TYPE,                                          
               METER_NO,                                                
               METER_STATUS_DESC,                                       
               METER_TYPE_DESC,                                         
               READ_ROUTE,                                              
               READ_CYCLE,                                              
               READ_SEQUENCE,                                           
               RATE_PLAN_NO,                                            
               RATE_PLAN_DESC,                                          
               REV_CLASS,                                               
               REV_CLASS_DESC,                                          
               EQUIP_MAKE,                                              
               SERIAL_NO,                                               
               CO_SIZE,                                                 
               AMPS,                                                    
               WIRES,                                                   
               PHASES,                                                  
               VOLTAGE,                                                 
               METER_LOC_DESC,                                          
               LOCK_TYPE,                                               
               METER_PRESSURE,                                          
               SUBSTATION,                                              
               CIRCUIT,                                                 
               POINT_ID                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-CODE-UTIL-TYPE,                                       
               :S-METER-NO,                                             
               :S-METER-STATUS-DESC,                                    
               :S-METER-TYPE-DESC,                                      
               :S-READ-ROUTE,                                           
               :S-READ-CYCLE,                                           
               :S-READ-SEQUENCE,                                        
               :S-RATE-PLAN-NO,                                         
               :S-RATE-PLAN-DESC,                                       
               :S-REV-CLASS,                                            
               :S-REV-CLASS-DESC,                                       
               :S-EQUIP-MAKE,                                           
               :S-SERIAL-NO,                                            
               :S-CO-SIZE,                                              
               :S-AMPS,                                                 
               :S-WIRES,                                                
               :S-PHASES,                                               
               :S-VOLTAGE,                                              
               :S-METER-LOC-DESC,                                       
               :S-LOCK-TYPE,                                            
               :S-METER-PRESSURE,                                       
               :S-SUBSTATION,                                           
               :S-CIRCUIT,                                              
               :S-POINT-ID                                              
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04835_R2                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        CODE_UTIL_TYPE,                                                  
MFA-TR*        METER_NO,                                                        
MFA-TR*        METER_STATUS_DESC,                                               
MFA-TR*        METER_TYPE_DESC,                                                 
MFA-TR*        READ_ROUTE,                                                      
MFA-TR*        READ_CYCLE,                                                      
MFA-TR*        READ_SEQUENCE,                                                   
MFA-TR*        RATE_PLAN_NO,                                                    
MFA-TR*        RATE_PLAN_DESC,                                                  
MFA-TR*        REV_CLASS,                                                       
MFA-TR*        REV_CLASS_DESC,                                                  
MFA-TR*        EQUIP_MAKE,                                                      
MFA-TR*        SERIAL_NO,                                                       
MFA-TR*        CO_SIZE,                                                         
MFA-TR*        AMPS,                                                            
MFA-TR*        WIRES,                                                           
MFA-TR*        PHASES,                                                          
MFA-TR*        VOLTAGE,                                                         
MFA-TR*        METER_LOC_DESC,                                                  
MFA-TR*        LOCK_TYPE,                                                       
MFA-TR*        METER_PRESSURE,                                                  
MFA-TR*        SUBSTATION,                                                      
MFA-TR*        CIRCUIT,                                                         
MFA-TR*        POINT_ID                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-CODE-UTIL-TYPE,                                               
MFA-TR*        :S-METER-NO,                                                     
MFA-TR*        :S-METER-STATUS-DESC,                                            
MFA-TR*        :S-METER-TYPE-DESC,                                              
MFA-TR*        :S-READ-ROUTE,                                                   
MFA-TR*        :S-READ-CYCLE,                                                   
MFA-TR*        :S-READ-SEQUENCE,                                                
MFA-TR*        :S-RATE-PLAN-NO,                                                 
MFA-TR*        :S-RATE-PLAN-DESC,                                               
MFA-TR*        :S-REV-CLASS,                                                    
MFA-TR*        :S-REV-CLASS-DESC,                                               
MFA-TR*        :S-EQUIP-MAKE,                                                   
MFA-TR*        :S-SERIAL-NO,                                                    
MFA-TR*        :S-CO-SIZE,                                                      
MFA-TR*        :S-AMPS,                                                         
MFA-TR*        :S-WIRES,                                                        
MFA-TR*        :S-PHASES,                                                       
MFA-TR*        :S-VOLTAGE,                                                      
MFA-TR*        :S-METER-LOC-DESC,                                               
MFA-TR*        :S-LOCK-TYPE,                                                    
MFA-TR*        :S-METER-PRESSURE,                                               
MFA-TR*        :S-SUBSTATION,                                                   
MFA-TR*        :S-CIRCUIT,                                                      
MFA-TR*        :S-POINT-ID                                                      
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04835_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
