       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04834.                                          
COB303 DATE-WRITTEN. FEBRUARY 17, 2016.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS ORDER DATA WITHIN A LAT/LONG RANGE.     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/17/16    FMB      NEW PROGRAM.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04834'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04834 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04834_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04834_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE 0.         
               10 S-STATUS-CODE         PIC S9(9) COMP VALUE 0.         
               10 S-PREMISE-NO-1        PIC S9(10)V COMP-3 VALUE 0.     
               10 S-LATITUDE            PIC S9(3)V9(6) COMP-3 VALUE 0.  
               10 S-LONGITUDE           PIC S9(3)V9(6) COMP-3 VALUE 0.  
               10 S-SERV-ADDRESS        PIC X(80) VALUE SPACES.         
               10 S-COMPANY-NO          PIC X(02) VALUE SPACES.         
                                                                        
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2       PIC S9(9) COMP VALUE 0.         
               10 S-PREMISE-NO-2        PIC S9(10)V COMP-3 VALUE 0.     
               10 S-SERV-ORDER-NO       PIC S9(13)V COMP-3 VALUE 0.     
               10 S-ORDER-TYPE-CD       PIC X(05) VALUE SPACES.         
               10 S-ORDER-TYPE-DESC     PIC X(15) VALUE SPACES.         
               10 S-ORDER-STATE-CD      PIC X(01) VALUE SPACES.         
               10 S-ASSIGNED-TS         PIC X(26) VALUE SPACES.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04834'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.         
           05  WS-PREM-REF-LATITUDE     PIC S9(3)V9(6) COMP-3 VALUE 0.  
           05  WS-PREM-REF-LONGITUDE    PIC S9(3)V9(6) COMP-3 VALUE 0.  
           05  WS-DISPLAY-LATITUDE      PIC -ZZZ.9(4).                  
           05  WS-DISPLAY-LONGITUDE     PIC -ZZZ.9(4).                  
           05  WS-PREMISE-NO            PIC S9(10)V COMP-3 VALUE 0.     
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
           EXEC SQL                                                     
              DECLARE MAIN-CURSOR CURSOR FOR                            
               SELECT PR.PREMISE_NO,                                    
                      SERV_ORDER_NO,                                    
                      VO.ORDER_TYPE_CD,                                 
                      ORDER_TYPE_DESC,                                  
                      ORDER_STATE_CD,                                   
                      PREM_REF_LATITUDE,                                
                      PREM_REF_LONGITUDE,                               
                      ADDR_USAGE_CD,                                    
                      PR.COMPANY_NO,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),             
                      RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + 
           LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))))))           
                 FROM CSS_PREMISE PR,                                   
                      CSS_SO_DATA VO,                                   
                      CSS_ADDR_FORMATTED DY,                            
                      CSS_ZIP_CODE A4,                                  
                      CSS_ORDER_TYPE C2                                 
                 WHERE (PREM_REF_LATITUDE >                             
                       :WS-PREM-REF-LATITUDE - .005                     
                   AND PREM_REF_LATITUDE <                              
                       :WS-PREM-REF-LATITUDE + .005)                    
                   AND (PREM_REF_LONGITUDE >                            
                       :WS-PREM-REF-LONGITUDE - .005                    
                   AND PREM_REF_LONGITUDE <                             
                       :WS-PREM-REF-LONGITUDE + .005)                   
                   AND PR.PREMISE_NO = VO.PREMISE_NO                    
                   AND PR.ADDRESS_ID = DY.ADDRESS_ID                    
                   AND DY.ZIP_CODE = A4.ZIP_CODE                        
                   AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN            
                   AND ORDER_STATE_CD NOT IN ('C', 'Z')                 
                   AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD              
                   AND VO.COMPANY_NO = C2.COMPANY_NO                    
                 ORDER BY 1                                             
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MAIN-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT PR.PREMISE_NO,                                            
MFA-TR*               SERV_ORDER_NO,                                            
MFA-TR*               VO.ORDER_TYPE_CD,                                         
MFA-TR*               ORDER_TYPE_DESC,                                          
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               PREM_REF_LATITUDE,                                        
MFA-TR*               PREM_REF_LONGITUDE,                                       
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               PR.COMPANY_NO,                                            
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                   
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                              
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                              
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),                     
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||               
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                              
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                              
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE)))))))                            
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4,                                          
MFA-TR*               CSS_ORDER_TYPE C2                                         
MFA-TR*          WHERE (PREM_REF_LATITUDE >                                     
MFA-TR*                :WS-PREM-REF-LATITUDE - .005                             
MFA-TR*            AND PREM_REF_LATITUDE <                                      
MFA-TR*                :WS-PREM-REF-LATITUDE + .005)                            
MFA-TR*            AND (PREM_REF_LONGITUDE >                                    
MFA-TR*                :WS-PREM-REF-LONGITUDE - .005                            
MFA-TR*            AND PREM_REF_LONGITUDE <                                     
MFA-TR*                :WS-PREM-REF-LONGITUDE + .005)                           
MFA-TR*            AND PR.PREMISE_NO = VO.PREMISE_NO                            
MFA-TR*            AND PR.ADDRESS_ID = DY.ADDRESS_ID                            
MFA-TR*            AND DY.ZIP_CODE = A4.ZIP_CODE                                
MFA-TR*            AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                    
MFA-TR*            AND ORDER_STATE_CD NOT IN ('C', 'Z')                         
MFA-TR*            AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                      
MFA-TR*            AND VO.COMPANY_NO = C2.COMPANY_NO                            
MFA-TR*          ORDER BY 1                                                     
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7070                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      STATUS_CODE     AS STATUS_CODE,                   
                      PREMISE_NO      AS PREMISE_NO,                    
                      LATITUDE        AS LATITUDE,                      
                      LONGITUDE       AS LONGITUDE,                     
                      SERV_ADDRESS    AS SERV_ADDRESS,                  
                      COMPANY_NO      AS COMPANY_NO                     
                FROM #CSR04834_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               STATUS_CODE     AS STATUS_CODE,                           
MFA-TR*               PREMISE_NO      AS PREMISE_NO,                            
MFA-TR*               LATITUDE        AS LATITUDE,                              
MFA-TR*               LONGITUDE       AS LONGITUDE,                             
MFA-TR*               SERV_ADDRESS    AS SERV_ADDRESS,                          
MFA-TR*               COMPANY_NO      AS COMPANY_NO                             
MFA-TR*         FROM SESSION.CSR04834_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1   AS RETURN_CODE,                
                      :S-STATUS-CODE     AS STATUS_CODE,                
                      :S-PREMISE-NO-1    AS PREMISE_NO,                 
                      :S-LATITUDE        AS LATITUDE,                   
                      :S-LONGITUDE       AS LONGITUDE,                  
                      :S-SERV-ADDRESS    AS SERV_ADDRESS,               
                      :S-COMPANY-NO      AS COMPANY_NO                  
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1   AS RETURN_CODE,                        
MFA-TR*               :S-STATUS-CODE     AS STATUS_CODE,                        
MFA-TR*               :S-PREMISE-NO-1    AS PREMISE_NO,                         
MFA-TR*               :S-LATITUDE        AS LATITUDE,                           
MFA-TR*               :S-LONGITUDE       AS LONGITUDE,                          
MFA-TR*               :S-SERV-ADDRESS    AS SERV_ADDRESS,                       
MFA-TR*               :S-COMPANY-NO      AS COMPANY_NO                          
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      PREMISE_NO      AS PREMISE_NO,                    
                      SERV_ORDER_NO   AS SERV_ORDER_NO,                 
                      ORDER_TYPE_CD   AS ORDER_TYPE_CD,                 
                      ORDER_TYPE_DESC AS ORDER_TYPE_DESC,               
                      ORDER_STATE_CD  AS ORDER_STATE_CD,                
                      ASSIGNED_TS     AS ASSIGNED_TS                    
                FROM #CSR04834_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               PREMISE_NO      AS PREMISE_NO,                            
MFA-TR*               SERV_ORDER_NO   AS SERV_ORDER_NO,                         
MFA-TR*               ORDER_TYPE_CD   AS ORDER_TYPE_CD,                         
MFA-TR*               ORDER_TYPE_DESC AS ORDER_TYPE_DESC,                       
MFA-TR*               ORDER_STATE_CD  AS ORDER_STATE_CD,                        
MFA-TR*               ASSIGNED_TS     AS ASSIGNED_TS                            
MFA-TR*         FROM SESSION.CSR04834_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2   AS RETURN_CODE,                
                      :S-PREMISE-NO-1    AS PREMISE_NO,                 
                      :S-SERV-ORDER-NO   AS SERV_ORDER_NO,              
                      :S-ORDER-TYPE-CD   AS ORDER_TYPE_CD,              
                      :S-ORDER-TYPE-DESC AS ORDER_TYPE_DESC,            
                      :S-ORDER-STATE-CD  AS ORDER_STATE_CD,             
                      :S-ASSIGNED-TS     AS ASSIGNED_TS                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2   AS RETURN_CODE,                        
MFA-TR*               :S-PREMISE-NO-1    AS PREMISE_NO,                         
MFA-TR*               :S-SERV-ORDER-NO   AS SERV_ORDER_NO,                      
MFA-TR*               :S-ORDER-TYPE-CD   AS ORDER_TYPE_CD,                      
MFA-TR*               :S-ORDER-TYPE-DESC AS ORDER_TYPE_DESC,                    
MFA-TR*               :S-ORDER-STATE-CD  AS ORDER_STATE_CD,                     
MFA-TR*               :S-ASSIGNED-TS     AS ASSIGNED_TS                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 LINK-LATITUDE        PIC S9(3)V9(6) COMP-3 VALUE 0.              
COB305 01 LINK-LONGITUDE        PIC S9(3)V9(6) COMP-3 VALUE 0.              
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-LATITUDE,                                
                          LINK-LONGITUDE.                               
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04834_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04834_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               PREMISE_NO           DECIMAL(10,0),                      
               LATITUDE             DECIMAL(9,6),                       
               LONGITUDE            DECIMAL(9,6),                       
               SERV_ADDRESS CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,          
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04834_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04834_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04834_R2
              (                                                          
               RETURN_CODE          INT,                            
               PREMISE_NO           DECIMAL(10,0),                      
               SERV_ORDER_NO        DECIMAL(13,0),                      
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ORDER_TYPE_DESC CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ORDER_STATE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ASSIGNED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04834_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-LATITUDE TO WS-PREM-REF-LATITUDE                   
                                 WS-DISPLAY-LATITUDE.                   
           MOVE LINK-LONGITUDE TO WS-PREM-REF-LONGITUDE                 
                                 WS-DISPLAY-LONGITUDE.                  
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-LATITUDE = ZEROES AND                                
              LINK-LONGITUDE = ZEROES                                   
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE 'ALL PARMS ZERO' TO S-SERV-ADDRESS               
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7070-OPEN-MAIN-CURSOR THRU 7070-EXIT.                
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7071-CLOSE-MAIN-CURSOR THRU 7071-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MAIN-CURSOR                                        
                INTO :PR-PREMISE-NO,                                    
                     :VO-SERV-ORDER-NO,                                 
                     :VO-ORDER-TYPE-CD,                                 
                     :C2-ORDER-TYPE-DESC,                               
                     :VO-ORDER-STATE-CD,                                
                     :PR-PREM-REF-LATITUDE,                             
                     :PR-PREM-REF-LONGITUDE,                            
                     :DY-ADDR-USAGE-CD,                                 
                     :PR-COMPANY-NO,                                    
                     :VO-ASSIGNED-DATETIME :WS-NULL-1,                   
                     :WS-ADDRESS-LINE,                                  
                     :WS-ADDRESS-LINE-I                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO VO-ASSIGNED-DATETIME              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-3                 
                   MOVE 'CSS_SO_DATA'        TO TABLE-4                 
                   MOVE 'LATITUDE'       TO TABLE-ELEMENT-1             
                   MOVE WS-DISPLAY-LATITUDE TO HOSTVAR-ELEMENT-1        
                   MOVE 'LONGITUDE'      TO TABLE-ELEMENT-2             
                   MOVE WS-DISPLAY-LONGITUDE TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF PR-PREMISE-NO NOT = WS-PREMISE-NO                         
               MOVE PR-PREMISE-NO TO WS-PREMISE-NO                      
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE PR-PREMISE-NO TO S-PREMISE-NO-1                     
               MOVE PR-PREM-REF-LATITUDE TO S-LATITUDE                  
               MOVE PR-PREM-REF-LONGITUDE TO S-LONGITUDE                
               IF DY-ADDR-USAGE-CD = 'I'                                
                   MOVE WS-ADDRESS-LINE-I TO S-SERV-ADDRESS             
               ELSE                                                     
                   MOVE WS-ADDRESS-LINE TO S-SERV-ADDRESS               
               END-IF                                                   
               MOVE PR-COMPANY-NO TO S-COMPANY-NO                       
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2                               
           MOVE PR-PREMISE-NO TO S-PREMISE-NO-2.                        
           MOVE VO-SERV-ORDER-NO TO S-SERV-ORDER-NO.                    
           MOVE VO-ORDER-TYPE-CD TO S-ORDER-TYPE-CD.                    
           MOVE C2-ORDER-TYPE-DESC TO S-ORDER-TYPE-DESC.                
           MOVE VO-ORDER-STATE-CD TO S-ORDER-STATE-CD.                  
           MOVE VO-ASSIGNED-DATETIME TO S-ASSIGNED-TS.                  
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
           END-IF                                                       
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-OPEN-MAIN-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN MAIN-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-3                 
                   MOVE 'CSS_SO_DATA'        TO TABLE-4                 
                   MOVE 'LATITUDE'       TO TABLE-ELEMENT-1             
                   MOVE WS-DISPLAY-LATITUDE TO HOSTVAR-ELEMENT-1        
                   MOVE 'LONGITUDE'      TO TABLE-ELEMENT-2             
                   MOVE WS-DISPLAY-LONGITUDE TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7071-CLOSE-MAIN-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE MAIN-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7071'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-3                 
                   MOVE 'CSS_SO_DATA'        TO TABLE-4                 
                   MOVE 'LATITUDE'       TO TABLE-ELEMENT-1             
                   MOVE WS-DISPLAY-LATITUDE TO HOSTVAR-ELEMENT-1        
                   MOVE 'LONGITUDE'      TO TABLE-ELEMENT-2             
                   MOVE WS-DISPLAY-LONGITUDE TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7071-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04834_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04834_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04834_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04834_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04834_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04834_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04834_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              PREMISE_NO,                                               
              LATITUDE,                                                 
              LONGITUDE,                                                
              SERV_ADDRESS,                                             
              COMPANY_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-PREMISE-NO-1,                                         
               :S-LATITUDE,                                             
               :S-LONGITUDE,                                            
               :S-SERV-ADDRESS,                                         
               :S-COMPANY-NO                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04834_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       PREMISE_NO,                                                       
MFA-TR*       LATITUDE,                                                         
MFA-TR*       LONGITUDE,                                                        
MFA-TR*       SERV_ADDRESS,                                                     
MFA-TR*       COMPANY_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-PREMISE-NO-1,                                                 
MFA-TR*        :S-LATITUDE,                                                     
MFA-TR*        :S-LONGITUDE,                                                    
MFA-TR*        :S-SERV-ADDRESS,                                                 
MFA-TR*        :S-COMPANY-NO                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04834_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04834_R2                            
             (                                                          
              RETURN_CODE,                                              
              PREMISE_NO,                                               
              SERV_ORDER_NO,                                            
              ORDER_TYPE_CD,                                            
              ORDER_TYPE_DESC,                                          
              ORDER_STATE_CD,                                           
              ASSIGNED_TS                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-PREMISE-NO-2,                                         
               :S-SERV-ORDER-NO,                                        
               :S-ORDER-TYPE-CD,                                        
               :S-ORDER-TYPE-DESC,                                      
               :S-ORDER-STATE-CD,                                       
               :S-ASSIGNED-TS                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04834_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PREMISE_NO,                                                       
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       ORDER_TYPE_DESC,                                                  
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       ASSIGNED_TS                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-PREMISE-NO-2,                                                 
MFA-TR*        :S-SERV-ORDER-NO,                                                
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ORDER-TYPE-DESC,                                              
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-ASSIGNED-TS                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04834_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
