       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04833.                                          
COB303 DATE-WRITTEN. FEBRUARY 10, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS RELEASE DATA.                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/17/15    FMB      NEW PROGRAM.                                      
A05317*  10/27/16    FMB      IF NO ORDERS ASSOCIATED WITH RELEASE, DO *        
A05317*                       NOT PASS A +100 ROW TO FIX UI ISSUE.     *        
A05317*  11/30/16    FMB      INCLUDE HST_SO_DATA.                     *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04833'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04833 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPRMRL                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
A05317     EXEC SQL                                                             
A07317        INCLUDE TBHSTDAT                                                  
A05317     END-EXEC.                                                            
A05317     EXEC SQL                                                             
A05317        INCLUDE TBHSTODR                                                  
A05317     END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04833_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04833_R3'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE 0.         
               10 S-STATUS-CODE         PIC S9(9) COMP VALUE 0.         
               10 S-RELEASE-DT          PIC X(10) VALUE SPACES.         
               10 S-RELEASE-EXP-DT      PIC X(10) VALUE SPACES.         
               10 S-INSPECTOR-NAME      PIC X(30) VALUE SPACES.         
               10 S-REMARKS             PIC X(250) VALUE SPACES.        
               10 S-SUPPLIES            PIC X(15) VALUE SPACES.         
               10 S-RELEASE-TYPE        PIC X(02) VALUE SPACES.         
               10 S-CREATED-BY-NAME     PIC X(76) VALUE SPACES.         
               10 S-CREATED-DT          PIC X(10) VALUE SPACES.         
               10 S-LAST-UPDATE-NAME    PIC X(76) VALUE SPACES.         
               10 S-LAST-UPDATE-DT      PIC X(10) VALUE SPACES.         
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2       PIC S9(9) COMP VALUE 0.         
               10 S-PREMISE-NO-2        PIC S9(10)V COMP-3 VALUE 0.     
               10 S-ADDRESS-LINE        PIC X(80) VALUE SPACES.         
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3       PIC S9(9) COMP VALUE 0.         
               10 S-PREMISE-NO-3        PIC S9(10)V COMP-3 VALUE 0.     
               10 S-SERV-ORDER-NO       PIC S9(13)V COMP-3 VALUE 0.     
               10 S-WANTED-BY-DT        PIC X(10) VALUE SPACES.         
               10 S-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.         
               10 S-METER-SUPPLYING     PIC X(15) VALUE SPACES.         
               10 S-PER-TEMP-IND        PIC X(01) VALUE SPACES.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04833'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-8                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-9                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-CREATED-BY-NAME       PIC X(76) VALUE SPACES.         
           05  WS-LAST-UPDATE-NAME      PIC X(76) VALUE SPACES.         
           05  WS-FULL-NAME             PIC X(76) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
           EXEC SQL                                                     
              DECLARE PREM-CURSOR CURSOR FOR                            
               SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),          
                      RP.PREMISE_NO                                     
                 FROM CSS_PREM_RLSE_DATA RP WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE RP.RLSE_NO = :RE-RLSE-NO                          
                  AND RP.REV_DISTRICT_CD = :RE-REV-DISTRICT-CD          
                  AND RP.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PREM-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)))))))))),                  
MFA-TR*               RP.PREMISE_NO                                             
MFA-TR*          FROM CSS_PREM_RLSE_DATA RP,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE RP.RLSE_NO = :RE-RLSE-NO                                  
MFA-TR*           AND RP.REV_DISTRICT_CD = :RE-REV-DISTRICT-CD                  
MFA-TR*           AND RP.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ORDER-CURSOR CURSOR FOR                           
               SELECT VO.SERV_ORDER_NO,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                               
                      CODE_UTIL_TYPE,                                   
                      METER_SUPPLYING,                                  
                      PER_TEMP_IND                                      
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :RP-PREMISE-NO                       
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',      
                                        'CC003','FM006','FM003',        
                                        'NC001','ON001')                
                  AND ORDER_STATE_CD <> 'C'                             
                  AND RLSE_NO = :RE-RLSE-NO                             
                  AND METER_SUPPLYING = :RE-RLSE-SUPPLIES               
                  AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               
                  AND PER_TEMP_IND = :VI-PER-TEMP-IND                   
                  AND HOLD_RELEASE = 'Y'                                
A05317         UNION                                                    
A05317         SELECT YV.SERV_ORDER_NO,                                 
A05317                REPLACE(REPLACE(CONVERT(CHAR(26), 
           WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                               
A05317                CODE_UTIL_TYPE,                                   
A05317                METER_SUPPLYING,                                  
A05317                PER_TEMP_IND                                      
A05317           FROM HST_SO_DATA YV WITH(READUNCOMMITTED),                     
A05317                HST_SO_ORDER_INST ZG WITH(READUNCOMMITTED)                
A05317          WHERE PREMISE_NO = :RP-PREMISE-NO                       
A05317            AND YV.SERV_ORDER_NO = ZG.SERV_ORDER_NO               
A05317            AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',      
A05317                                  'CC003','FM006','FM003',        
A05317                                  'NC001','ON001')                
A05317            AND ORDER_STATE_CD <> 'C'                             
A05317            AND RLSE_NO = :RE-RLSE-NO                             
A05317            AND METER_SUPPLYING = :RE-RLSE-SUPPLIES               
A05317            AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               
A05317            AND PER_TEMP_IND = :VI-PER-TEMP-IND                   
A05317            AND HOLD_RELEASE = 'Y'                                
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORDER-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               WANTED_BY_DATETIME,                                       
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               METER_SUPPLYING,                                          
MFA-TR*               PER_TEMP_IND                                              
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE PREMISE_NO = :RP-PREMISE-NO                               
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',              
MFA-TR*                                 'CC003','FM006','FM003',                
MFA-TR*                                 'NC001','ON001')                        
MFA-TR*           AND ORDER_STATE_CD ^= 'C'                                     
MFA-TR*           AND RLSE_NO = :RE-RLSE-NO                                     
MFA-TR*           AND METER_SUPPLYING = :RE-RLSE-SUPPLIES                       
MFA-TR*           AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                       
MFA-TR*           AND PER_TEMP_IND = :VI-PER-TEMP-IND                           
MFA-TR*           AND HOLD_RELEASE = 'Y'                                        
MFA-TR*        UNION                                                            
MFA-TR*        SELECT YV.SERV_ORDER_NO,                                         
MFA-TR*               WANTED_BY_DATETIME,                                       
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               METER_SUPPLYING,                                          
MFA-TR*               PER_TEMP_IND                                              
MFA-TR*          FROM HST_SO_DATA YV,                                           
MFA-TR*               HST_SO_ORDER_INST ZG                                      
MFA-TR*         WHERE PREMISE_NO = :RP-PREMISE-NO                               
MFA-TR*           AND YV.SERV_ORDER_NO = ZG.SERV_ORDER_NO                       
MFA-TR*           AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',              
MFA-TR*                                 'CC003','FM006','FM003',                
MFA-TR*                                 'NC001','ON001')                        
MFA-TR*           AND ORDER_STATE_CD ^= 'C'                                     
MFA-TR*           AND RLSE_NO = :RE-RLSE-NO                                     
MFA-TR*           AND METER_SUPPLYING = :RE-RLSE-SUPPLIES                       
MFA-TR*           AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                       
MFA-TR*           AND PER_TEMP_IND = :VI-PER-TEMP-IND                           
MFA-TR*           AND HOLD_RELEASE = 'Y'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1        AS RETURN_CODE,           
                      :S-STATUS-CODE          AS STATUS_CODE,           
                      :S-RELEASE-DT           AS RELEASE_DT,            
                      :S-RELEASE-EXP-DT       AS RELEASE_EXP_DT,        
                      :S-INSPECTOR-NAME       AS INSPECTOR_NAME,        
                      :S-REMARKS              AS REMARKS,               
                      :S-SUPPLIES             AS SUPPLIES,              
                      :S-RELEASE-TYPE         AS RELEASE_TYPE,          
                      :S-CREATED-BY-NAME      AS CREATED_BY_NAME,       
                      :S-CREATED-DT           AS CREATED_DT,            
                      :S-LAST-UPDATE-NAME     AS LAST_UPDATE_NAME,      
                      :S-LAST-UPDATE-DT       AS LAST_UPDATE_DT         
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1        AS RETURN_CODE,                   
MFA-TR*               :S-STATUS-CODE          AS STATUS_CODE,                   
MFA-TR*               :S-RELEASE-DT           AS RELEASE_DT,                    
MFA-TR*               :S-RELEASE-EXP-DT       AS RELEASE_EXP_DT,                
MFA-TR*               :S-INSPECTOR-NAME       AS INSPECTOR_NAME,                
MFA-TR*               :S-REMARKS              AS REMARKS,                       
MFA-TR*               :S-SUPPLIES             AS SUPPLIES,                      
MFA-TR*               :S-RELEASE-TYPE         AS RELEASE_TYPE,                  
MFA-TR*               :S-CREATED-BY-NAME      AS CREATED_BY_NAME,               
MFA-TR*               :S-CREATED-DT           AS CREATED_DT,                    
MFA-TR*               :S-LAST-UPDATE-NAME     AS LAST_UPDATE_NAME,              
MFA-TR*               :S-LAST-UPDATE-DT       AS LAST_UPDATE_DT                 
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      PREMISE_NO      AS PREMISE_NO,                    
                      ADDRESS_LINE    AS ADDRESS_LINE                   
                FROM #CSR04833_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               PREMISE_NO      AS PREMISE_NO,                            
MFA-TR*               ADDRESS_LINE    AS ADDRESS_LINE                           
MFA-TR*         FROM SESSION.CSR04833_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2   AS RETURN_CODE,                
                      :S-PREMISE-NO-2    AS PREMISE_NO,                 
                      :S-ADDRESS-LINE    AS ADDRESS_LINE                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2   AS RETURN_CODE,                        
MFA-TR*               :S-PREMISE-NO-2    AS PREMISE_NO,                         
MFA-TR*               :S-ADDRESS-LINE    AS ADDRESS_LINE                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      PREMISE_NO      AS PREMISE_NO,                    
                      SERV_ORDER_NO   AS SERV_ORDER_NO,                 
                      WANTED_BY_DT    AS WANTED_BY_DT,                  
                      CODE_UTIL_TYPE  AS CODE_UTIL_TYPE,                
                      METER_SUPPLYING AS METER_SUPPLYING,               
                      PER_TEMP_IND    AS PER_TEMP_IND                   
                FROM #CSR04833_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               PREMISE_NO      AS PREMISE_NO,                            
MFA-TR*               SERV_ORDER_NO   AS SERV_ORDER_NO,                         
MFA-TR*               WANTED_BY_DT    AS WANTED_BY_DT,                          
MFA-TR*               CODE_UTIL_TYPE  AS CODE_UTIL_TYPE,                        
MFA-TR*               METER_SUPPLYING AS METER_SUPPLYING,                       
MFA-TR*               PER_TEMP_IND    AS PER_TEMP_IND                           
MFA-TR*         FROM SESSION.CSR04833_R3                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3   AS RETURN_CODE,                
                      :S-PREMISE-NO-3    AS PREMISE_NO,                 
                      :S-SERV-ORDER-NO   AS SERV_ORDER_NO,              
                      :S-WANTED-BY-DT    AS WANTED_BY_DT,               
                      :S-CODE-UTIL-TYPE  AS CODE_UTIL_TYPE,             
                      :S-METER-SUPPLYING AS METER_SUPPLYING,            
                      :S-PER-TEMP-IND    AS PER_TEMP_IND                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3   AS RETURN_CODE,                        
MFA-TR*               :S-PREMISE-NO-3    AS PREMISE_NO,                         
MFA-TR*               :S-SERV-ORDER-NO   AS SERV_ORDER_NO,                      
MFA-TR*               :S-WANTED-BY-DT    AS WANTED_BY_DT,                       
MFA-TR*               :S-CODE-UTIL-TYPE  AS CODE_UTIL_TYPE,                     
MFA-TR*               :S-METER-SUPPLYING AS METER_SUPPLYING,                    
MFA-TR*               :S-PER-TEMP-IND    AS PER_TEMP_IND                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-RELEASE-NO         PIC X(10).                           
       01  LINK-REV-DISTRICT-CD    PIC X(03).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-RELEASE-NO                               
                          LINK-REV-DISTRICT-CD.                         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04833_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04833_R2
              (                                                          
               RETURN_CODE          INT,                            
               PREMISE_NO           DECIMAL(13,0),                      
               ADDRESS_LINE CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04833_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04833_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04833_R3
              (                                                          
               RETURN_CODE          INT,                            
               PREMISE_NO           DECIMAL(10,0),                      
               SERV_ORDER_NO        DECIMAL(13,0),                      
               WANTED_BY_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_SUPPLYING CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PER_TEMP_IND CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04833_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-RELEASE-NO TO RE-RLSE-NO.                          
           MOVE LINK-REV-DISTRICT-CD TO RE-REV-DISTRICT-CD.             
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-RELEASE-NO = SPACES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-INSPECTOR-NAME                
               ADD +1 TO CTR-ROWS                                       
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-RELEASE THRU 7000-EXIT.                  
           IF RE-CREATED-BY-USER-ID > SPACES                            
               MOVE RE-CREATED-BY-USER-ID TO PF-USER-ID                 
               PERFORM 7005-SELECT-USER-PROFILE                         
               MOVE WS-FULL-NAME TO WS-CREATED-BY-NAME
           END-IF.                 
           IF RE-LAST-UPDATE-USERID > SPACES                            
               MOVE RE-LAST-UPDATE-USERID TO PF-USER-ID                 
               PERFORM 7005-SELECT-USER-PROFILE                         
               MOVE WS-FULL-NAME TO WS-LAST-UPDATE-NAME
           END-IF.                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE RE-RLSE-DATE TO S-RELEASE-DT.                           
           MOVE RE-RLSE-EXP-DATE(1:10) TO S-RELEASE-EXP-DT.             
           MOVE RE-RLSE-INSPTOR-NAME TO S-INSPECTOR-NAME.               
           MOVE RE-RLSE-REMARKS TO S-REMARKS.                           
           MOVE RE-RLSE-SUPPLIES TO S-SUPPLIES.                         
           MOVE RE-RLSE-TYPE TO S-RELEASE-TYPE.                         
           MOVE WS-CREATED-BY-NAME TO S-CREATED-BY-NAME.                
           MOVE RE-CREATED-TS(1:10) TO S-CREATED-DT.                    
           MOVE RE-LAST-UPDATE-TS(1:10) TO S-LAST-UPDATE-DT.            
           MOVE WS-LAST-UPDATE-NAME TO S-LAST-UPDATE-NAME.              
           ADD +1 TO CTR-ROWS.                                          
                                                                        
           PERFORM 7020-OPEN-PREM-CURSOR THRU 7020-EXIT.                
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7021-CLOSE-PREM-CURSOR THRU 7021-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH PREM-CURSOR                                        
                INTO :WS-ADDRESS-LINE,                                  
                     :RP-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA'  TO TABLE-1                
                   MOVE 'CSS_PREMISE'        TO TABLE-2                 
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE RP-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE RP-PREMISE-NO TO S-PREMISE-NO-2.                        
           MOVE WS-ADDRESS-LINE TO S-ADDRESS-LINE.                      
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           MOVE RE-RLSE-TYPE(1:1) TO VI-CODE-UTIL-TYPE.                 
           MOVE RE-RLSE-TYPE(2:1) TO VI-PER-TEMP-IND.                   
           PERFORM 7030-OPEN-ORDER-CURSOR THRU 7030-EXIT.               
           PERFORM 2200-FETCH-ROWS THRU 2200-EXIT.                      
           PERFORM 7031-CLOSE-ORDER-CURSOR THRU 7031-EXIT.              
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ORDER-CURSOR                                       
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-WANTED-BY-DATETIME,                            
                     :VI-CODE-UTIL-TYPE,                                
                     :VI-METER-SUPPLYING,                               
                     :VI-PER-TEMP-IND                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2200-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE RP-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE RP-PREMISE-NO TO S-PREMISE-NO-3.                        
           MOVE VO-SERV-ORDER-NO TO S-SERV-ORDER-NO.                    
           MOVE VO-WANTED-BY-DATETIME(1:10) TO S-WANTED-BY-DT.          
           MOVE VI-CODE-UTIL-TYPE TO S-CODE-UTIL-TYPE.                  
           MOVE VI-METER-SUPPLYING TO S-METER-SUPPLYING.                
           MOVE VI-PER-TEMP-IND TO S-PER-TEMP-IND.                      
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           GO TO 2200-FETCH-ROWS.                                       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-RELEASE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE
           , 121), ' ', '-'), ':', '.') RLSE_DATE,
              RLSE_TYPE,
              RLSE_SUPPLIES,
              REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_EXP_DATE, 121), 
           ' ', '-'), ':', '.') RLSE_EXP_DATE,
              RLSE_INSPTOR_NAME,
              RLSE_REMARKS,
              CREATED_BY_USER_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS, 121), ' ', 
           '-'), ':', '.') CREATED_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), RE.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              RE.LAST_UPDATE_USERID                              
                INTO :RE-RLSE-DATE,                                     
                     :RE-RLSE-TYPE,                                     
                     :RE-RLSE-SUPPLIES,                                 
                     :RE-RLSE-EXP-DATE,                                 
                     :RE-RLSE-INSPTOR-NAME,                             
                     :RE-RLSE-REMARKS,                                  
                     :RE-CREATED-BY-USER-ID,                            
                     :RE-CREATED-TS,                                    
                     :RE-LAST-UPDATE-TS,                                
                     :RE-LAST-UPDATE-USERID                             
                FROM CSS_PREM_RLSE RE WITH(READUNCOMMITTED)                     
               WHERE RLSE_NO = :RE-RLSE-NO                              
                 AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT RLSE_DATE,                                                 
MFA-TR*              RLSE_TYPE,                                                 
MFA-TR*              RLSE_SUPPLIES,                                             
MFA-TR*              RLSE_EXP_DATE,                                             
MFA-TR*              RLSE_INSPTOR_NAME,                                         
MFA-TR*              RLSE_REMARKS,                                              
MFA-TR*              CREATED_BY_USER_ID,                                        
MFA-TR*              CREATED_TS,                                                
MFA-TR*              RE.LAST_UPDATE_TS,                                         
MFA-TR*              RE.LAST_UPDATE_USERID                                      
MFA-TR*         INTO :RE-RLSE-DATE,                                             
MFA-TR*              :RE-RLSE-TYPE,                                             
MFA-TR*              :RE-RLSE-SUPPLIES,                                         
MFA-TR*              :RE-RLSE-EXP-DATE,                                         
MFA-TR*              :RE-RLSE-INSPTOR-NAME,                                     
MFA-TR*              :RE-RLSE-REMARKS,                                          
MFA-TR*              :RE-CREATED-BY-USER-ID,                                    
MFA-TR*              :RE-CREATED-TS,                                            
MFA-TR*              :RE-LAST-UPDATE-TS,                                        
MFA-TR*              :RE-LAST-UPDATE-USERID                                     
MFA-TR*         FROM CSS_PREM_RLSE RE                                   13550000
MFA-TR*        WHERE RLSE_NO = :RE-RLSE-NO                              13560000
MFA-TR*          AND REV_DISTRICT_CD = :RE-REV-DISTRICT-CD              13561000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE' TO TABLE-1                      
                   MOVE 'CSS_USER_PROFILE' TO TABLE-2                   
                   MOVE 'RLSE_NO'     TO TABLE-ELEMENT-1                
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-RLSE-NO    TO HOSTVAR-ELEMENT-2              
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME
           ) + ' ' + RTRIM(LAST_NAME)                                   
                INTO :WS-FULL-NAME                                      
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PF-USER-ID                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(FIRST_NAME) ||                                       
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME) ||                                      
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(LAST_NAME)                                           
MFA-TR*         INTO :WS-FULL-NAME                                              
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7005                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_USER_PROFILE' TO TABLE-1                   
                   MOVE 'USER_ID'        TO TABLE-ELEMENT-1             
                   MOVE PF-USER-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-OPEN-PREM-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN PREM-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA'  TO TABLE-1                
                   MOVE 'CSS_PREMISE'        TO TABLE-2                 
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE RP-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7021-CLOSE-PREM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE PREM-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7021'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA'  TO TABLE-1                
                   MOVE 'CSS_PREMISE'        TO TABLE-2                 
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE RP-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2            
                   MOVE RE-REV-DISTRICT-CD TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7021-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-OPEN-ORDER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ORDER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE RP-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7031-CLOSE-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7031'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE RP-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7031-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04833_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04833_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04833_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04833_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04833_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8003'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04833_R3'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04833_R2                            
             (                                                          
              RETURN_CODE,                                              
              PREMISE_NO,                                               
              ADDRESS_LINE                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-PREMISE-NO-2,                                         
               :S-ADDRESS-LINE                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04833_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PREMISE_NO,                                                       
MFA-TR*       ADDRESS_LINE                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-PREMISE-NO-2,                                                 
MFA-TR*        :S-ADDRESS-LINE                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04833_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04833_R3                            
             (                                                          
              RETURN_CODE,                                              
              PREMISE_NO,                                               
              SERV_ORDER_NO,                                            
              WANTED_BY_DT,                                             
              CODE_UTIL_TYPE,                                           
              METER_SUPPLYING,                                          
              PER_TEMP_IND                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-PREMISE-NO-3,                                         
               :S-SERV-ORDER-NO,                                        
               :S-WANTED-BY-DT,                                         
               :S-CODE-UTIL-TYPE,                                       
               :S-METER-SUPPLYING,                                      
               :S-PER-TEMP-IND                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04833_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PREMISE_NO,                                                       
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       WANTED_BY_DT,                                                     
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       METER_SUPPLYING,                                                  
MFA-TR*       PER_TEMP_IND                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-PREMISE-NO-3,                                                 
MFA-TR*        :S-SERV-ORDER-NO,                                                
MFA-TR*        :S-WANTED-BY-DT,                                                 
MFA-TR*        :S-CODE-UTIL-TYPE,                                               
MFA-TR*        :S-METER-SUPPLYING,                                              
MFA-TR*        :S-PER-TEMP-IND                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04833_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
A05317*    IF WS-GTT03-DECLARED = 'Y'                                           
               EXEC SQL                                                 
                   OPEN C3                                              
A05317         END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                
A05317*    ELSE                                                                 
A05317*        MOVE +100 TO S-RETURN-CODE-3                                     
A05317*        EXEC SQL                                                         
A05317*            OPEN N3                                                      
A05317*        END-EXEC.                                                        
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
