       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04832.                                          
COB303 DATE-WRITTEN. FEBRUARY 10, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS PREMISE DATA.                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/10/15    FMB      NEW PROGRAM.                                      
A05317*  02/18/16    FMB      RETURN ONLY GAS APPLIANCES.                       
A05317*  12/06/16    FMB      SET GAS FLAG IF ACTIVE GAS SET EXISTS.            
P00893*  01/18/17    FMB      RETURN CURRENT ACCOUNT AT PREMISE.                
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04832'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04832 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOREQ                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04832_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04832_R3'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE 0.         
               10 S-STATUS-CODE         PIC S9(9) COMP VALUE 0.         
               10 S-PREMISE-NO          PIC S9(10)V COMP-3 VALUE 0.     
               10 S-ADDRESS-ID          PIC S9(13)V COMP-3 VALUE 0.     
               10 S-COMPANY-NO          PIC X(02) VALUE SPACES.         
               10 S-HOUSE-NO            PIC X(15) VALUE SPACES.         
               10 S-ADDR-PREFIX-1       PIC X(03) VALUE SPACES.         
               10 S-ADDR-PREFIX-2       PIC X(02) VALUE SPACES.         
               10 S-STREET-NAME         PIC X(30) VALUE SPACES.         
               10 S-STREET-SUFFIX       PIC X(04) VALUE SPACES.         
               10 S-ADDR-SUFFIX         PIC X(02) VALUE SPACES.         
               10 S-STREET-LOCATION-1   PIC X(04) VALUE SPACES.         
               10 S-STREET-LOCATION-2   PIC X(11) VALUE SPACES.         
               10 S-ADDRESS-OVERFLOW    PIC X(35) VALUE SPACES.         
               10 S-ZIPCODE             PIC X(05) VALUE SPACES.         
               10 S-ZIPCODE-PLUS-FOUR   PIC X(04) VALUE SPACES.         
               10 S-ZIPCODE-TOKEN       PIC X(01) VALUE SPACES.         
               10 S-USPS-DELIV-PT-CD    PIC X(02) VALUE SPACES.         
               10 S-PO-BOX-FL           PIC X(01) VALUE SPACES.         
               10 S-LOT                 PIC X(05) VALUE SPACES.         
               10 S-BLOCK               PIC X(05) VALUE SPACES.         
               10 S-LOCAL-OFFICE        PIC X(03) VALUE SPACES.         
               10 S-COUNTY              PIC X(03) VALUE SPACES.         
               10 S-LOCATOR-ID          PIC X(09) VALUE SPACES.         
               10 S-SUBDIVISION-ID      PIC X(03) VALUE SPACES.         
               10 S-CITY-GATE-ID        PIC X(07) VALUE SPACES.         
               10 S-LEAK-SURVEY-DT      PIC X(10) VALUE SPACES.         
               10 S-LEAK-SURVEY-FREQ    PIC X(02) VALUE SPACES.         
               10 S-ADDR-USAGE-CD       PIC X(01) VALUE SPACES.         
               10 S-CODE-RENTAL-PROP    PIC X(01) VALUE SPACES.         
               10 S-REV-DISTRICT-CD     PIC X(03) VALUE SPACES.         
               10 S-READ-ROUTE          PIC S9(4) COMP VALUE 0.         
               10 S-CROSS-STREET-1      PIC X(35) VALUE SPACES.         
               10 S-CROSS-STREET-2      PIC X(35) VALUE SPACES.         
               10 S-LAT-LONG-DT         PIC X(10) VALUE SPACES.         
               10 S-LAT-LONG-SOURCE     PIC X(01) VALUE SPACES.         
               10 S-LATITUDE            PIC S9(3)V9(6) COMP-3 VALUE 0.  
               10 S-LONGITUDE           PIC S9(3)V9(6) COMP-3 VALUE 0.  
               10 S-AGL-PREM-NO         PIC S9(9)V COMP-3 VALUE 0.      
               10 S-FM-ELEC-SVC-WKDIST  PIC X(40) VALUE SPACES.         
               10 S-FM-GAS-OPS-WKDIST   PIC X(40) VALUE SPACES.         
               10 S-FM-FLD-SVCS-WKDIST  PIC X(40) VALUE SPACES.         
               10 S-FM-REV-PRT-WKDIST   PIC X(40) VALUE SPACES.         
               10 S-FM-DSM-ESVC-WKDIST  PIC X(40) VALUE SPACES.         
               10 S-DDDC-FCTR           PIC S9(9)V9(4) COMP-3 VALUE 0.  
               10 S-DDDC-FCTR-EFF-DT    PIC X(10) VALUE SPACES.         
               10 S-AGL-SERVICE-CENTER  PIC X(25) VALUE SPACES.         
               10 S-SPCL-READ-INSTR     PIC X(114) VALUE SPACES.        
               10 S-DATE-SPCL-MSG-ENDS  PIC X(10) VALUE SPACES.         
               10 S-SPECIAL-INSTR       PIC X(255) VALUE SPACES.        
               10 S-DIRECTIONS          PIC X(255) VALUE SPACES.        
               10 S-SCRATCH-PAD         PIC X(255) VALUE SPACES.        
               10 S-GAS-DETAILS-FL      PIC X(01) VALUE SPACES.         
               10 S-RELEASE-EXISTS-FL   PIC X(01) VALUE SPACES.         
               10 S-ALLOW-DELETE-FL     PIC X(01) VALUE SPACES.         
               10 S-ALLOW-ENV-CHG-FL    PIC X(01) VALUE SPACES.         
               10 S-DIVISION-CD         PIC X(01) VALUE SPACES.         
               10 S-LIMIT-LENGTH-FL     PIC X(01) VALUE SPACES.         
               10 S-LL-CUSTOMER-NO      PIC S9(10)V COMP-3 VALUE 0.     
               10 S-LL-CUSTOMER-NAME    PIC X(80) VALUE SPACES.         
               10 S-LL-ADDRESS-ID       PIC S9(13)V COMP-3 VALUE 0.     
               10 S-LL-ADDRESS-FORMAT   PIC X(01) VALUE SPACES.         
               10 S-LL-MASTER-ACCT-NO   PIC S9(13)V COMP-3 VALUE 0.     
               10 S-TOWN                PIC X(26) VALUE SPACES.         
               10 S-STATE               PIC X(02) VALUE SPACES.         
               10 S-ACCOUNT-TYPE-CODE   PIC X(01) VALUE SPACES.         
               10 S-PEND-OFF-ORD-DT     PIC X(10) VALUE SPACES.         
P00893         10 S-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.     
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2       PIC S9(9) COMP VALUE 0.         
               10 S-EQUIPMENT-NO        PIC X(20) VALUE SPACES.         
               10 S-APPLIANCE-CD        PIC X(02) VALUE SPACES.         
               10 S-LOCATION-CD         PIC X(03) VALUE SPACES.         
               10 S-BTU                 PIC S9(9) COMP VALUE 0.         
               10 S-CAUTION-TAG-IND     PIC X(01) VALUE SPACES.         
               10 S-CUT-IND             PIC X(01) VALUE SPACES.         
               10 S-PRIMARY-FUEL-CD     PIC X(06) VALUE SPACES.         
               10 S-TAG-NO              PIC X(10) VALUE SPACES.         
               10 S-CONDITION-CD        PIC X(03) VALUE SPACES.         
               10 S-APPLIANCE-COMMENTS  PIC X(255) VALUE SPACES.        
               10 S-CAUTION-TAG-DT      PIC X(10) VALUE SPACES.         
               10 S-SOURCE-SYSTEM-CD    PIC X(03) VALUE SPACES.         
               10 S-INSTALL-DT          PIC X(10) VALUE SPACES.         
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3       PIC S9(9) COMP VALUE 0.         
               10 S-SERV-ORDER-NO       PIC S9(13)V COMP-3 VALUE 0.     
               10 S-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.         
               10 S-IC-NO               PIC S9(4) COMP VALUE 0.         
               10 S-PER-TEMP-IND        PIC X(01) VALUE SPACES.         
               10 S-METER-SUPPLYING     PIC X(15) VALUE SPACES.         
               10 S-RLSE-NO             PIC X(10) VALUE SPACES.         
               10 S-RLSE-DATE           PIC X(25) VALUE SPACES.         
               10 S-WORK-TYPE-CD        PIC X(03) VALUE SPACES.         
               10 S-RLSE-TYPE           PIC X(02) VALUE SPACES.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04832'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-8                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-9                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-LANDLORD-NAME         PIC X(76) VALUE SPACES.         
           05  WS-ACCOUNT-CT            PIC S9(4) COMP VALUE 0.         
           05  WS-PENDING-CT            PIC S9(4) COMP VALUE 0.         
A05317     05  WS-GAS-SET-FL            PIC X(01) VALUE 'N'.            
P00893     05  WS-ACCOUNT-NO            PIC S9(13)V COMP-3 VALUE 0.     
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
           EXEC SQL                                                     
              DECLARE APP-CURSOR CURSOR FOR                             
               SELECT EQUIPMENT_NO,                                     
                      LA.LOCATION_CD,                                   
                      LA.APPLIANCE_CD,                                  
                      AVERAGE_BTU,                                      
                      CAUTION_TAG_IND,                                  
                      CUT_IND,                                          
                      PRIMARY_FUEL_CD,                                  
                      TAG_NO,                                           
                      CONDITION_CD,                                     
                      APPLIANCE_COMMENTS,                               
                      CAUTION_TAG_DT,                                   
                      SOURCE_SYSTEM_CD,                                 
                      INSTALL_DT                                        
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                 
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND CIS_DISPLAY_FL = 'Y'                              
A05317            AND PRIMARY_FUEL_CD = 'NA-GAS'                        
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE APP-CURSOR CURSOR FOR                                     
MFA-TR*        SELECT EQUIPMENT_NO,                                             
MFA-TR*               LA.LOCATION_CD,                                           
MFA-TR*               LA.APPLIANCE_CD,                                          
MFA-TR*               AVERAGE_BTU,                                              
MFA-TR*               CAUTION_TAG_IND,                                          
MFA-TR*               CUT_IND,                                                  
MFA-TR*               PRIMARY_FUEL_CD,                                          
MFA-TR*               TAG_NO,                                                   
MFA-TR*               CONDITION_CD,                                             
MFA-TR*               APPLIANCE_COMMENTS,                                       
MFA-TR*               CAUTION_TAG_DT,                                           
MFA-TR*               SOURCE_SYSTEM_CD,                                         
MFA-TR*               INSTALL_DT                                                
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                         
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*           AND PRIMARY_FUEL_CD = 'NA-GAS'                                
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7070                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ORDER-CURSOR CURSOR FOR                           
               SELECT VI.SERV_ORDER_NO,                                 
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      PER_TEMP_IND,                                     
                      METER_SUPPLYING,                                  
                      RLSE_NO,                                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE
           , 121), ' ', '-'), ':', '.') RLSE_DATE,                             
                      WORK_TYPE_CD,                                     
A05317                ORDER_TYPE_CD                                     
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',      
                                        'CC003','FM006','FM003',        
                                        'NC001','ON001')                
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND WORK_TYPE_CD > ' '                                
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORDER-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT VI.SERV_ORDER_NO,                                         
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               PER_TEMP_IND,                                             
MFA-TR*               METER_SUPPLYING,                                          
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               WORK_TYPE_CD,                                             
MFA-TR*               ORDER_TYPE_CD                                             
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND ORDER_TYPE_CD IN ('FM002', 'CC001', 'CC002',              
MFA-TR*                                 'CC003','FM006','FM003',                
MFA-TR*                                 'NC001','ON001')                        
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND WORK_TYPE_CD > ' '                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7130                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1        AS RETURN_CODE,           
                      :S-STATUS-CODE          AS STATUS_CODE,           
                      :S-PREMISE-NO           AS PREMISE_NO,            
                      :S-ADDRESS-ID           AS ADDRESS_ID,            
                      :S-COMPANY-NO           AS COMPANY_NO,            
                      :S-HOUSE-NO             AS HOUSE_NO,              
                      :S-ADDR-PREFIX-1        AS ADDR_PREFIX_1,         
                      :S-ADDR-PREFIX-2        AS ADDR_PREFIX_2,         
                      :S-STREET-NAME          AS STREET_NAME,           
                      :S-STREET-SUFFIX        AS STREET_SUFFIX,         
                      :S-ADDR-SUFFIX          AS ADDR_SUFFIX,           
                      :S-STREET-LOCATION-1    AS STREET_LOCATION_1,     
                      :S-STREET-LOCATION-2    AS STREET_LOCATION_2,     
                      :S-ADDRESS-OVERFLOW     AS ADDRESS_OVERFLOW,      
                      :S-ZIPCODE              AS ZIPCODE,               
                      :S-ZIPCODE-PLUS-FOUR    AS ZIPCODE_PLUS_FOUR,     
                      :S-ZIPCODE-TOKEN        AS ZIPCODE_TOKEN,         
                      :S-USPS-DELIV-PT-CD     AS USPS_DELIV_PT_CD,      
                      :S-PO-BOX-FL            AS PS_BOX_FL,             
                      :S-LOT                  AS LOT,                   
                      :S-BLOCK                AS BLOCK,                 
                      :S-LOCAL-OFFICE         AS LOCAL_OFFICE,          
                      :S-COUNTY               AS COUNTY,                
                      :S-LOCATOR-ID           AS LOCATOR_ID,            
                      :S-SUBDIVISION-ID       AS SUBDIVISION_ID,        
                      :S-CITY-GATE-ID         AS CITY_GATE_ID,          
                      :S-LEAK-SURVEY-DT       AS LEAK_SURVEY_DT,        
                      :S-LEAK-SURVEY-FREQ     AS LEAK_SURVEY_FREQ,      
                      :S-ADDR-USAGE-CD        AS ADDR_USAGE_CD,         
                      :S-CODE-RENTAL-PROP     AS CODE_RENTAL_PROP,      
                      :S-REV-DISTRICT-CD      AS REV_DISTRICT_CD,       
                      :S-READ-ROUTE           AS READ_ROUTE,            
                      :S-CROSS-STREET-1       AS CROSS_STREET_1,        
                      :S-CROSS-STREET-2       AS CROSS_STREET_2,        
                      :S-LAT-LONG-DT          AS LAT_LONG_DT,           
                      :S-LAT-LONG-SOURCE      AS LAT_LONG_SOURCE,       
                      :S-LATITUDE             AS LATITUDE,              
                      :S-LONGITUDE            AS LONGITUDE,             
                      :S-AGL-PREM-NO          AS AGL_PREM_NO,           
                      :S-FM-ELEC-SVC-WKDIST   AS FM_ELEC_SVC_WKDIST,    
                      :S-FM-GAS-OPS-WKDIST    AS FM_GAS_OPS_WKDIST,     
                      :S-FM-FLD-SVCS-WKDIST   AS FM_FLD_SVCS_WKDIST,    
                      :S-FM-REV-PRT-WKDIST    AS FM_REV_PRT_WKDIST,     
                      :S-FM-DSM-ESVC-WKDIST   AS FM_DSM_ESVC_WKDIST,    
                      :S-DDDC-FCTR            AS DDDC_FCTR,             
                      :S-DDDC-FCTR-EFF-DT     AS DDDC_FCTR_EFF_DT,      
                      :S-AGL-SERVICE-CENTER   AS AGL_SERVICE_CENTER,    
                      :S-SPCL-READ-INSTR      AS SPCL_READ_INSTR,       
                      :S-DATE-SPCL-MSG-ENDS   AS DATE_SPCL_MSG_ENDS,    
                      :S-SPECIAL-INSTR        AS SPECIAL_INSTR,         
                      :S-DIRECTIONS           AS DIRECTIONS,            
                      :S-SCRATCH-PAD          AS SCRATCH_PAD,           
                      :S-GAS-DETAILS-FL       AS GAS_DETAILS_FL,        
                      :S-RELEASE-EXISTS-FL    AS RELEASE_EXISTS_FL,     
                      :S-ALLOW-DELETE-FL      AS ALLOW_DELETE_FL,       
                      :S-ALLOW-ENV-CHG-FL     AS ALLOW_ENV_CHG_FL,      
                      :S-DIVISION-CD          AS DIVISION,              
                      :S-LIMIT-LENGTH-FL      AS LIMIT_LENGTH_FL,       
                      :S-LL-CUSTOMER-NO       AS LL_CUSTOMER_NO,        
                      :S-LL-CUSTOMER-NAME     AS LL_CUSTOMER_NAME,      
                      :S-LL-ADDRESS-ID        AS LL_ADDRESS_ID,         
                      :S-LL-ADDRESS-FORMAT    AS LL_ADDRESS_FORMAT,     
                      :S-LL-MASTER-ACCT-NO    AS LL_MASTER_ACCT_NO,     
                      :S-TOWN                 AS TOWN,                  
                      :S-STATE                AS STATE,                 
                      :S-ACCOUNT-TYPE-CODE    AS ACCOUNT_TYPE_CODE,     
                      :S-PEND-OFF-ORD-DT      AS PEND_OFF_ORD_DT,       
P00893                :S-ACCOUNT-NO           AS ACCOUNT_NO             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1        AS RETURN_CODE,                   
MFA-TR*               :S-STATUS-CODE          AS STATUS_CODE,                   
MFA-TR*               :S-PREMISE-NO           AS PREMISE_NO,                    
MFA-TR*               :S-ADDRESS-ID           AS ADDRESS_ID,                    
MFA-TR*               :S-COMPANY-NO           AS COMPANY_NO,                    
MFA-TR*               :S-HOUSE-NO             AS HOUSE_NO,                      
MFA-TR*               :S-ADDR-PREFIX-1        AS ADDR_PREFIX_1,                 
MFA-TR*               :S-ADDR-PREFIX-2        AS ADDR_PREFIX_2,                 
MFA-TR*               :S-STREET-NAME          AS STREET_NAME,                   
MFA-TR*               :S-STREET-SUFFIX        AS STREET_SUFFIX,                 
MFA-TR*               :S-ADDR-SUFFIX          AS ADDR_SUFFIX,                   
MFA-TR*               :S-STREET-LOCATION-1    AS STREET_LOCATION_1,             
MFA-TR*               :S-STREET-LOCATION-2    AS STREET_LOCATION_2,             
MFA-TR*               :S-ADDRESS-OVERFLOW     AS ADDRESS_OVERFLOW,              
MFA-TR*               :S-ZIPCODE              AS ZIPCODE,                       
MFA-TR*               :S-ZIPCODE-PLUS-FOUR    AS ZIPCODE_PLUS_FOUR,             
MFA-TR*               :S-ZIPCODE-TOKEN        AS ZIPCODE_TOKEN,                 
MFA-TR*               :S-USPS-DELIV-PT-CD     AS USPS_DELIV_PT_CD,              
MFA-TR*               :S-PO-BOX-FL            AS PS_BOX_FL,                     
MFA-TR*               :S-LOT                  AS LOT,                           
MFA-TR*               :S-BLOCK                AS BLOCK,                         
MFA-TR*               :S-LOCAL-OFFICE         AS LOCAL_OFFICE,                  
MFA-TR*               :S-COUNTY               AS COUNTY,                        
MFA-TR*               :S-LOCATOR-ID           AS LOCATOR_ID,                    
MFA-TR*               :S-SUBDIVISION-ID       AS SUBDIVISION_ID,                
MFA-TR*               :S-CITY-GATE-ID         AS CITY_GATE_ID,                  
MFA-TR*               :S-LEAK-SURVEY-DT       AS LEAK_SURVEY_DT,                
MFA-TR*               :S-LEAK-SURVEY-FREQ     AS LEAK_SURVEY_FREQ,              
MFA-TR*               :S-ADDR-USAGE-CD        AS ADDR_USAGE_CD,                 
MFA-TR*               :S-CODE-RENTAL-PROP     AS CODE_RENTAL_PROP,              
MFA-TR*               :S-REV-DISTRICT-CD      AS REV_DISTRICT_CD,               
MFA-TR*               :S-READ-ROUTE           AS READ_ROUTE,                    
MFA-TR*               :S-CROSS-STREET-1       AS CROSS_STREET_1,                
MFA-TR*               :S-CROSS-STREET-2       AS CROSS_STREET_2,                
MFA-TR*               :S-LAT-LONG-DT          AS LAT_LONG_DT,                   
MFA-TR*               :S-LAT-LONG-SOURCE      AS LAT_LONG_SOURCE,               
MFA-TR*               :S-LATITUDE             AS LATITUDE,                      
MFA-TR*               :S-LONGITUDE            AS LONGITUDE,                     
MFA-TR*               :S-AGL-PREM-NO          AS AGL_PREM_NO,                   
MFA-TR*               :S-FM-ELEC-SVC-WKDIST   AS FM_ELEC_SVC_WKDIST,            
MFA-TR*               :S-FM-GAS-OPS-WKDIST    AS FM_GAS_OPS_WKDIST,             
MFA-TR*               :S-FM-FLD-SVCS-WKDIST   AS FM_FLD_SVCS_WKDIST,            
MFA-TR*               :S-FM-REV-PRT-WKDIST    AS FM_REV_PRT_WKDIST,             
MFA-TR*               :S-FM-DSM-ESVC-WKDIST   AS FM_DSM_ESVC_WKDIST,            
MFA-TR*               :S-DDDC-FCTR            AS DDDC_FCTR,                     
MFA-TR*               :S-DDDC-FCTR-EFF-DT     AS DDDC_FCTR_EFF_DT,              
MFA-TR*               :S-AGL-SERVICE-CENTER   AS AGL_SERVICE_CENTER,            
MFA-TR*               :S-SPCL-READ-INSTR      AS SPCL_READ_INSTR,               
MFA-TR*               :S-DATE-SPCL-MSG-ENDS   AS DATE_SPCL_MSG_ENDS,            
MFA-TR*               :S-SPECIAL-INSTR        AS SPECIAL_INSTR,                 
MFA-TR*               :S-DIRECTIONS           AS DIRECTIONS,                    
MFA-TR*               :S-SCRATCH-PAD          AS SCRATCH_PAD,                   
MFA-TR*               :S-GAS-DETAILS-FL       AS GAS_DETAILS_FL,                
MFA-TR*               :S-RELEASE-EXISTS-FL    AS RELEASE_EXISTS_FL,             
MFA-TR*               :S-ALLOW-DELETE-FL      AS ALLOW_DELETE_FL,               
MFA-TR*               :S-ALLOW-ENV-CHG-FL     AS ALLOW_ENV_CHG_FL,              
MFA-TR*               :S-DIVISION-CD          AS DIVISION,                      
MFA-TR*               :S-LIMIT-LENGTH-FL      AS LIMIT_LENGTH_FL,               
MFA-TR*               :S-LL-CUSTOMER-NO       AS LL_CUSTOMER_NO,                
MFA-TR*               :S-LL-CUSTOMER-NAME     AS LL_CUSTOMER_NAME,              
MFA-TR*               :S-LL-ADDRESS-ID        AS LL_ADDRESS_ID,                 
MFA-TR*               :S-LL-ADDRESS-FORMAT    AS LL_ADDRESS_FORMAT,             
MFA-TR*               :S-LL-MASTER-ACCT-NO    AS LL_MASTER_ACCT_NO,             
MFA-TR*               :S-TOWN                 AS TOWN,                          
MFA-TR*               :S-STATE                AS STATE,                         
MFA-TR*               :S-ACCOUNT-TYPE-CODE    AS ACCOUNT_TYPE_CODE,             
MFA-TR*               :S-PEND-OFF-ORD-DT      AS PEND_OFF_ORD_DT,               
MFA-TR*               :S-ACCOUNT-NO           AS ACCOUNT_NO                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      EQUIPMENT_NO    AS EQUIPMENT_NO,                  
                      APPLIANCE_CD    AS APPLIANCE_CD,                  
                      LOCATION_CD     AS LOCATION_CD,                   
                      BTU             AS BTU,                           
                      CAUTION_TAG_IND AS CAUTION_TAG_IND,               
                      CUT_IND         AS CUT_IND,                       
                      PRIMARY_FUEL_CD AS PRIMARY_FUEL_CD,               
                      TAG_NO          AS TAG_NO,                        
                      CONDITION_CD    AS CONDITION_CD,                  
                      APPLIANCE_COMMENTS AS APPLIANCE_COMMENTS,         
                      CAUTION_TAG_DT  AS CAUTION_TAG_DT,                
                      SOURCE_SYSTEM_CD AS SOURCE_SYSTEM_CD,             
                      INSTALL_DT       AS INSTALL_DT                    
                FROM #CSR04832_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               EQUIPMENT_NO    AS EQUIPMENT_NO,                          
MFA-TR*               APPLIANCE_CD    AS APPLIANCE_CD,                          
MFA-TR*               LOCATION_CD     AS LOCATION_CD,                           
MFA-TR*               BTU             AS BTU,                                   
MFA-TR*               CAUTION_TAG_IND AS CAUTION_TAG_IND,                       
MFA-TR*               CUT_IND         AS CUT_IND,                               
MFA-TR*               PRIMARY_FUEL_CD AS PRIMARY_FUEL_CD,                       
MFA-TR*               TAG_NO          AS TAG_NO,                                
MFA-TR*               CONDITION_CD    AS CONDITION_CD,                          
MFA-TR*               APPLIANCE_COMMENTS AS APPLIANCE_COMMENTS,                 
MFA-TR*               CAUTION_TAG_DT  AS CAUTION_TAG_DT,                        
MFA-TR*               SOURCE_SYSTEM_CD AS SOURCE_SYSTEM_CD,                     
MFA-TR*               INSTALL_DT       AS INSTALL_DT                            
MFA-TR*         FROM SESSION.CSR04832_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2   AS RETURN_CODE,                
                      :S-EQUIPMENT-NO    AS EQUIPMENT_NO,               
                      :S-APPLIANCE-CD    AS APPLIANCE_CD,               
                      :S-LOCATION-CD     AS LOCATION_CD,                
                      :S-BTU             AS BTU,                        
                      :S-CAUTION-TAG-IND AS CAUTION_TAG_IND,            
                      :S-CUT-IND         AS CUT_IND,                    
                      :S-PRIMARY-FUEL-CD AS PRIMARY_FUEL_CD,            
                      :S-TAG-NO          AS TAG_NO,                     
                      :S-CONDITION-CD    AS CONDITION_CD,               
                      :S-APPLIANCE-COMMENTS AS APPLIANCE_COMMENTS,      
                      :S-CAUTION-TAG-DT  AS CAUTION_TAG_DT,             
                      :S-SOURCE-SYSTEM-CD AS SOURCE_SYSTEM_CD,          
                      :S-INSTALL-DT       AS INSTALL_DT                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2   AS RETURN_CODE,                        
MFA-TR*               :S-EQUIPMENT-NO    AS EQUIPMENT_NO,                       
MFA-TR*               :S-APPLIANCE-CD    AS APPLIANCE_CD,                       
MFA-TR*               :S-LOCATION-CD     AS LOCATION_CD,                        
MFA-TR*               :S-BTU             AS BTU,                                
MFA-TR*               :S-CAUTION-TAG-IND AS CAUTION_TAG_IND,                    
MFA-TR*               :S-CUT-IND         AS CUT_IND,                            
MFA-TR*               :S-PRIMARY-FUEL-CD AS PRIMARY_FUEL_CD,                    
MFA-TR*               :S-TAG-NO          AS TAG_NO,                             
MFA-TR*               :S-CONDITION-CD    AS CONDITION_CD,                       
MFA-TR*               :S-APPLIANCE-COMMENTS AS APPLIANCE_COMMENTS,              
MFA-TR*               :S-CAUTION-TAG-DT  AS CAUTION_TAG_DT,                     
MFA-TR*               :S-SOURCE-SYSTEM-CD AS SOURCE_SYSTEM_CD,                  
MFA-TR*               :S-INSTALL-DT       AS INSTALL_DT                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      SERV_ORDER_NO   AS SERV_ORDER_NO,                 
                      CODE_UTIL_TYPE  AS CODE_UTIL_TYPE,                
                      IC_NO           AS IC_NO,                         
                      PER_TEMP_IND    AS PER_TEMP_IND,                  
                      METER_SUPPLYING AS METER_SUPPLYING,               
                      RLSE_NO         AS RLSE_NO,                       
                      RLSE_DATE       AS RLSE_DATE,                     
                      WORK_TYPE_CD    AS WORK_TYPE_CD,                  
                      RLSE_TYPE       AS RLSE_TYPE                      
                FROM #CSR04832_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               SERV_ORDER_NO   AS SERV_ORDER_NO,                         
MFA-TR*               CODE_UTIL_TYPE  AS CODE_UTIL_TYPE,                        
MFA-TR*               IC_NO           AS IC_NO,                                 
MFA-TR*               PER_TEMP_IND    AS PER_TEMP_IND,                          
MFA-TR*               METER_SUPPLYING AS METER_SUPPLYING,                       
MFA-TR*               RLSE_NO         AS RLSE_NO,                               
MFA-TR*               RLSE_DATE       AS RLSE_DATE,                             
MFA-TR*               WORK_TYPE_CD    AS WORK_TYPE_CD,                          
MFA-TR*               RLSE_TYPE       AS RLSE_TYPE                              
MFA-TR*         FROM SESSION.CSR04832_R3                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3   AS RETURN_CODE,                
                      :S-SERV-ORDER-NO   AS SERV_ORDER_NO,              
                      :S-CODE-UTIL-TYPE  AS CODE_UTIL_TYPE,             
                      :S-IC-NO           AS IC_NO,                      
                      :S-PER-TEMP-IND    AS PER_TEMP_IND,               
                      :S-METER-SUPPLYING AS METER_SUPPLYING,            
                      :S-RLSE-NO         AS RLSE_NO,                    
                      :S-RLSE-DATE       AS RLSE_DATE,                  
                      :S-WORK-TYPE-CD    AS WORK_TYPE_CD,               
                      :S-RLSE-TYPE       AS RLSE_TYPE                   
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3   AS RETURN_CODE,                        
MFA-TR*               :S-SERV-ORDER-NO   AS SERV_ORDER_NO,                      
MFA-TR*               :S-CODE-UTIL-TYPE  AS CODE_UTIL_TYPE,                     
MFA-TR*               :S-IC-NO           AS IC_NO,                              
MFA-TR*               :S-PER-TEMP-IND    AS PER_TEMP_IND,                       
MFA-TR*               :S-METER-SUPPLYING AS METER_SUPPLYING,                    
MFA-TR*               :S-RLSE-NO         AS RLSE_NO,                            
MFA-TR*               :S-RLSE-DATE       AS RLSE_DATE,                          
MFA-TR*               :S-WORK-TYPE-CD    AS WORK_TYPE_CD,                       
MFA-TR*               :S-RLSE-TYPE       AS RLSE_TYPE                           
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PREMISE-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04832_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04832_R2
              (                                                          
               RETURN_CODE          INT,                            
               EQUIPMENT_NO CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2,          
               APPLIANCE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,          
               LOCATION_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
               BTU                  INT,                            
               CAUTION_TAG_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CUT_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2,                
               PRIMARY_FUEL_CD CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2,        
               TAG_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                
               CONDITION_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2,           
               APPLIANCE_COMMENTS CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                          
               CAUTION_TAG_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SOURCE_SYSTEM_CD CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               INSTALL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04832_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04832_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04832_R3
              (                                                          
               RETURN_CODE          INT,                            
               SERV_ORDER_NO        DECIMAL(13,0),                      
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               IC_NO                SMALLINT,                           
               PER_TEMP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               METER_SUPPLYING CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               RLSE_DATE CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,             
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RLSE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2              
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04832_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-PREMISE-NO = ZEROES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-HOUSE-NO                      
               ADD +1 TO CTR-ROWS                                       
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE DCLCSS-MTRD-ENVRNMT                               
                      DCLCSS-UTIL-ENVRNMT                               
                      DCLCSS-ACCOUNT                                    
                      DCLCSS-SO-DATA                                    
                      DCLCSS-GAS-SERV-LINE                              
                      DCLCSS-SO-REQUIREMENT.                            
                                                                        
           PERFORM 7110-COUNT-ACCOUNTS THRU 7110-EXIT.                  
           PERFORM 7120-COUNT-PENDING THRU 7120-EXIT.                   
                                                                        
           MOVE PR-PREMISE-NO TO WS-CPD99-PREMISE-NO.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                    
P00893                                 WS-ACCOUNT-NO.                   
           IF AT-ACCOUNT-NO = ZEROES                                    
               PERFORM 7150-PENDING-ACCOUNT THRU 7150-EXIT
           END-IF.             
                                                                        
           PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT.                  
           PERFORM 7030-SELECT-LANDLORD THRU 7030-EXIT.                 
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7020-SELECT-ACCOUNT THRU 7020-EXIT               
               PERFORM 7040-GAS-DETAILS THRU 7040-EXIT                  
               PERFORM 7060-LIMIT-LENGTH THRU 7060-EXIT                 
               PERFORM 7140-SELECT-READ-ROUTE THRU 7140-EXIT
           END-IF.           
           PERFORM 7050-PREM-RELEASE THRU 7050-EXIT.                    
           IF WS-ACCOUNT-CT = 0                                         
               PERFORM 7080-SERVICE-ORDERS THRU 7080-EXIT               
               PERFORM 7100-SELECT-GAS-LINE THRU 7100-EXIT
           END-IF.             
           IF SEB-DATABASE                                              
               PERFORM 7090-REQUIREMENT THRU 7090-EXIT
           END-IF.                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE PR-PREMISE-NO TO S-PREMISE-NO.                          
           MOVE PR-ADDRESS-ID TO S-ADDRESS-ID.                          
           MOVE PR-COMPANY-NO TO S-COMPANY-NO.                          
           MOVE DY-HOUSE-NO TO S-HOUSE-NO.                              
           MOVE DY-ADDR-PREFIX-1 TO S-ADDR-PREFIX-1.                    
           MOVE DY-ADDR-PREFIX-2 TO S-ADDR-PREFIX-2.                    
           MOVE DY-STREET-NAME TO S-STREET-NAME.                        
           MOVE DY-STREET-SUFFIX TO S-STREET-SUFFIX.                    
           MOVE DY-ADDR-SUFFIX TO S-ADDR-SUFFIX.                        
           MOVE DY-STREET-LOCATION-1 TO S-STREET-LOCATION-1.            
           MOVE DY-STREET-LOCATION-2 TO S-STREET-LOCATION-2.            
           MOVE DY-ADDRESS-OVERFLOW TO S-ADDRESS-OVERFLOW.              
           MOVE DY-ZIP-CODE TO S-ZIPCODE.                               
           MOVE DY-ZIP-CODE-PLUS-FOUR TO S-ZIPCODE-PLUS-FOUR.           
           MOVE DY-ZIP-CODE-TOKEN TO S-ZIPCODE-TOKEN.                   
           MOVE DY-USPS-DELIV-PT-CD TO S-USPS-DELIV-PT-CD.              
           MOVE A4-TOWN TO S-TOWN.                                      
           MOVE A4-STATE TO S-STATE.                                    
           IF DY-STREET-NAME(1:7) = 'PO BOX '                           
               MOVE 'Y' TO S-PO-BOX-FL                                  
           ELSE                                                         
               MOVE 'N' TO S-PO-BOX-FL
           END-IF.                                 
           MOVE PR-LOT TO S-LOT.                                        
           MOVE PR-BLOCK TO S-BLOCK.                                    
           MOVE PR-LOCAL-OFFICE TO S-LOCAL-OFFICE.                      
           MOVE PR-COUNTY TO S-COUNTY.                                  
           MOVE PR-LOCATOR-ID TO S-LOCATOR-ID.                          
           MOVE PR-SUBDIVISION-ID TO S-SUBDIVISION-ID.                  
           MOVE PR-CITY-GATE-ID TO S-CITY-GATE-ID.                      
           MOVE PR-GAS-LEAK-SURVEY-DT TO S-LEAK-SURVEY-DT.              
           MOVE PR-GAS-LK-SURVEY-FREQ TO S-LEAK-SURVEY-FREQ.            
           MOVE DY-ADDR-USAGE-CD TO S-ADDR-USAGE-CD.                    
           MOVE PR-CODE-RENTAL-PROP TO S-CODE-RENTAL-PROP.              
           MOVE PR-REV-DISTRICT-CD TO S-REV-DISTRICT-CD.                
           IF UT-READ-ROUTE > ZEROES                                    
               MOVE UT-READ-ROUTE TO S-READ-ROUTE                       
           ELSE                                                         
               MOVE PR-READ-ROUTE TO S-READ-ROUTE
           END-IF.                      
           MOVE PR-CROSS-STREET-1 TO S-CROSS-STREET-1.                  
           MOVE PR-CROSS-STREET-2 TO S-CROSS-STREET-2.                  
           MOVE PR-LAT-LONG-DT TO S-LAT-LONG-DT.                        
           MOVE PR-LAT-LONG-SOURCE-CD TO S-LAT-LONG-SOURCE.             
           MOVE PR-PREM-REF-LATITUDE TO S-LATITUDE.                     
           MOVE PR-PREM-REF-LONGITUDE TO S-LONGITUDE.                   
           MOVE PR-AGL-PREM-NO TO S-AGL-PREM-NO.                        
           MOVE PR-FM-ELEC-SVC-WKDIST-TEXT TO S-FM-ELEC-SVC-WKDIST.     
           MOVE PR-FM-GAS-OPS-WKDIST-TEXT TO S-FM-GAS-OPS-WKDIST.       
           MOVE PR-FM-FLD-SVCS-WKDIST-TEXT TO S-FM-FLD-SVCS-WKDIST.     
           MOVE PR-FM-REV-PRT-WKDIST-TEXT TO S-FM-REV-PRT-WKDIST.       
           MOVE PR-FM-DSM-ESVC-WKDIST-TEXT TO S-FM-DSM-ESVC-WKDIST.     
           MOVE PR-DDDC-FCTR TO S-DDDC-FCTR.                            
           MOVE PR-DDDC-FCTR-EFF-DT TO S-DDDC-FCTR-EFF-DT.              
           MOVE PR-AGL-SERVICE-CENTER TO S-AGL-SERVICE-CENTER.          
           MOVE PR-SPCL-READ-INSTR-TEXT TO S-SPCL-READ-INSTR.           
           MOVE PR-DATE-SPCL-MSG-ENDS TO S-DATE-SPCL-MSG-ENDS.          
           MOVE PR-SPCL-INSTRUCTIONS-TEXT TO S-SPECIAL-INSTR.           
           MOVE PR-PREMISE-DIRECTIONS-TEXT TO S-DIRECTIONS.             
           MOVE PR-SCRATCH-PAD-TEXT TO S-SCRATCH-PAD.                   
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE PR-PEND-OFF-ORD-DT TO S-PEND-OFF-ORD-DT.                
           IF AT-ACCOUNT-NO = ZEROES OR                                 
              UT-RATE-PLAN-NO > SPACES OR                               
A05317        S-ADDR-USAGE-CD = 'I'                                     
                  MOVE 'Y' TO S-GAS-DETAILS-FL                          
           ELSE                                                         
               MOVE 'N' TO S-GAS-DETAILS-FL
           END-IF.                            
           IF RP-RLSE-NO > SPACES                                       
               MOVE 'Y' TO S-RELEASE-EXISTS-FL                          
           ELSE                                                         
               MOVE 'N' TO S-RELEASE-EXISTS-FL
           END-IF.                         
           IF SEB-DATABASE                                              
               EVALUATE B1-REGULATED-CD                                 
                   WHEN '02'                                            
                       MOVE 'R' TO S-DIVISION-CD                        
                   WHEN OTHER                                           
                       MOVE 'D' TO S-DIVISION-CD                        
               END-EVALUATE
           END-IF.                                            
           IF MN-ACCOUNT-NO > ZEROES                                    
               MOVE 'Y' TO S-LIMIT-LENGTH-FL                            
           ELSE                                                         
               MOVE 'N' TO S-LIMIT-LENGTH-FL
           END-IF.                           
           IF VO-SERV-ORDER-NO > ZEROES OR                              
              XO-SERVICE-NO > ZEROES OR                                 
              WS-ACCOUNT-CT > 0 OR                                      
              SI-CUSTOMER-NO > 0 OR                                     
              RP-RLSE-NO > SPACES                                       
                  MOVE 'N' TO S-ALLOW-DELETE-FL                         
           ELSE                                                         
               MOVE 'Y' TO S-ALLOW-DELETE-FL
           END-IF.                           
           IF SEB-DATABASE AND                                          
             ((WS-ACCOUNT-CT = 0) OR                                    
              (WS-ACCOUNT-CT = WS-PENDING-CT AND                        
               EG-SERV-ORDER-NO = ZEROES))                              
                   MOVE 'Y' TO S-ALLOW-ENV-CHG-FL                       
           ELSE                                                         
               MOVE 'N' TO S-ALLOW-ENV-CHG-FL
           END-IF.                          
                                                                        
           MOVE WS-LANDLORD-NAME TO S-LL-CUSTOMER-NAME.                 
           MOVE SI-CUSTOMER-NO TO S-LL-CUSTOMER-NO.                     
           MOVE SI-ADDRESS-ID TO S-LL-ADDRESS-ID.                       
           MOVE SI-ADDRESS-FORMAT TO S-LL-ADDRESS-FORMAT.               
           MOVE SI-LL-MASTER-ACCT-NO TO S-LL-MASTER-ACCT-NO.            
P00893     MOVE WS-ACCOUNT-NO TO S-ACCOUNT-NO.                          
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
           PERFORM 7070-OPEN-APP-CURSOR THRU 7070-EXIT.                 
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7071-CLOSE-APP-CURSOR THRU 7071-EXIT.                
                                                                        
           PERFORM 7130-OPEN-ORDER-CURSOR THRU 7130-EXIT.               
           PERFORM 2200-FETCH-ROWS THRU 2200-EXIT.                      
           PERFORM 7131-CLOSE-ORDER-CURSOR THRU 7131-EXIT.              
                                                                        
A05317     IF WS-GAS-SET-FL = 'Y'                                       
A05317         MOVE 'Y' TO S-GAS-DETAILS-FL
           END-IF.                            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO LA-APPLIANCE-COMMENTS.                        
                                                                        
           EXEC SQL                                                     
               FETCH APP-CURSOR                                         
                INTO :LA-EQUIPMENT-NO,                                  
                     :LA-LOCATION-CD,                                   
                     :LA-APPLIANCE-CD,                                  
                     :JA-AVERAGE-BTU,                                   
                     :LA-CAUTION-TAG-IND,                               
                     :LA-CUT-IND,                                       
                     :LA-PRIMARY-FUEL-CD,                               
                     :LA-TAG-NO,                                        
                     :LA-CONDITION-CD,                                  
                     :LA-APPLIANCE-COMMENTS,                            
                     :LA-CAUTION-TAG-DT :WS-NULL-6,                      
                     :LA-SOURCE-SYSTEM-CD,                              
                     :LA-INSTALL-DT :WS-NULL-7                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-6 < 0                                     
                       MOVE SPACES TO LA-CAUTION-TAG-DT                 
                   END-IF                                               
                   IF WS-NULL-7 < 0                                     
                       MOVE SPACES TO LA-INSTALL-DT                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_APPLIANCE'  TO TABLE-1                     
                   MOVE 'CSS_MKT_APPLIANCE'  TO TABLE-2                 
                   MOVE 'CSS_APPLIANCE_LOC'  TO TABLE-3                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE LA-EQUIPMENT-NO TO S-EQUIPMENT-NO.                      
           MOVE LA-LOCATION-CD TO S-LOCATION-CD.                        
           MOVE LA-APPLIANCE-CD TO S-APPLIANCE-CD.                      
           MOVE JA-AVERAGE-BTU TO S-BTU.                                
           MOVE LA-CAUTION-TAG-IND TO S-CAUTION-TAG-IND.                
           MOVE LA-CUT-IND TO S-CUT-IND.                                
           MOVE LA-PRIMARY-FUEL-CD TO S-PRIMARY-FUEL-CD.                
           MOVE LA-TAG-NO TO S-TAG-NO.                                  
           MOVE LA-CONDITION-CD TO S-CONDITION-CD.                      
           MOVE LA-APPLIANCE-COMMENTS-TEXT TO S-APPLIANCE-COMMENTS.     
           MOVE LA-CAUTION-TAG-DT TO S-CAUTION-TAG-DT.                  
           MOVE LA-SOURCE-SYSTEM-CD TO S-SOURCE-SYSTEM-CD.              
           MOVE LA-INSTALL-DT TO S-INSTALL-DT.                          
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ORDER-CURSOR                                       
                INTO :VI-SERV-ORDER-NO,                                 
                     :VI-CODE-UTIL-TYPE,                                
                     :VI-IC-NO,                                         
                     :VI-PER-TEMP-IND,                                  
                     :VI-METER-SUPPLYING,                               
                     :VI-RLSE-NO,                                       
                     :VI-RLSE-DATE :WS-NULL-5,                           
                     :VI-WORK-TYPE-CD,                                  
A05317               :VO-ORDER-TYPE-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO VI-RLSE-DATE                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2200-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-2                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE VI-SERV-ORDER-NO TO S-SERV-ORDER-NO.                    
           MOVE VI-CODE-UTIL-TYPE TO S-CODE-UTIL-TYPE                   
                                     S-RLSE-TYPE(1:1).                  
           MOVE VI-IC-NO TO S-IC-NO.                                    
           MOVE VI-PER-TEMP-IND TO S-PER-TEMP-IND                       
                                   S-RLSE-TYPE(2:1).                    
           MOVE VI-METER-SUPPLYING TO S-METER-SUPPLYING.                
           MOVE VI-RLSE-NO TO S-RLSE-NO.                                
           MOVE VI-RLSE-DATE TO S-RLSE-DATE.                            
           MOVE VI-WORK-TYPE-CD TO S-WORK-TYPE-CD.                      
A05317     IF VO-ORDER-TYPE-CD = 'FM002' AND                            
A05317        VI-CODE-UTIL-TYPE = 'G'                                   
A05317            MOVE 'Y' TO WS-GAS-SET-FL
           END-IF.                            
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           GO TO 2200-FETCH-ROWS.                                       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           MOVE SPACES TO PR-FM-ELEC-SVC-WKDIST                         
                          PR-FM-GAS-OPS-WKDIST                          
                          PR-FM-FLD-SVCS-WKDIST                         
                          PR-FM-REV-PRT-WKDIST                          
                          PR-FM-DSM-ESVC-WKDIST                         
                          PR-SPCL-READ-INSTR                            
                          PR-SPCL-INSTRUCTIONS                          
                          PR-PREMISE-DIRECTIONS                         
                          PR-SCRATCH-PAD.                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PR.ADDRESS_ID,
              PR.COMPANY_NO,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              DY.ADDRESS_OVERFLOW,
              TOWN,
              STATE,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              USPS_DELIV_PT_CD,
              LOT,
              BLOCK,
              PR.LOCAL_OFFICE,
              COUNTY,
              LOCATOR_ID,
              SUBDIVISION_ID,
              CITY_GATE_ID,
              GAS_LEAK_SURVEY_DT,
              GAS_LK_SURVEY_FREQ,
              ADDR_USAGE_CD,
              CODE_RENTAL_PROP,
              REV_DISTRICT_CD,
              READ_ROUTE,
              CROSS_STREET_1,
              CROSS_STREET_2,
              LAT_LONG_DT,
              LAT_LONG_SOURCE_CD,
              PREM_REF_LATITUDE,
              PREM_REF_LONGITUDE,
              AGL_PREM_NO,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST,
              DDDC_FCTR,
              DDDC_FCTR_EFF_DT,
              AGL_SERVICE_CENTER,
              SPCL_READ_INSTR,
              DATE_SPCL_MSG_ENDS,
              SPCL_INSTRUCTIONS,
              PREMISE_DIRECTIONS,
              SCRATCH_PAD,
              REGULATED_CD,
              PEND_OFF_ORD_DT                                    
                INTO :PR-ADDRESS-ID,                                    
                     :PR-COMPANY-NO,                                    
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-SUFFIX,                                 
                     :DY-ADDR-SUFFIX,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-ADDRESS-OVERFLOW,                              
                     :A4-TOWN,                                          
                     :A4-STATE,                                         
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-USPS-DELIV-PT-CD,                              
                     :PR-LOT,                                           
                     :PR-BLOCK,                                         
                     :PR-LOCAL-OFFICE,                                  
                     :PR-COUNTY,                                        
                     :PR-LOCATOR-ID,                                    
                     :PR-SUBDIVISION-ID,                                
                     :PR-CITY-GATE-ID,                                  
                     :PR-GAS-LEAK-SURVEY-DT :WS-NULL-1,                  
                     :PR-GAS-LK-SURVEY-FREQ,                            
                     :DY-ADDR-USAGE-CD,                                 
                     :PR-CODE-RENTAL-PROP,                              
                     :PR-REV-DISTRICT-CD,                               
                     :PR-READ-ROUTE,                                    
                     :PR-CROSS-STREET-1,                                
                     :PR-CROSS-STREET-2,                                
                     :PR-LAT-LONG-DT :WS-NULL-2,                         
                     :PR-LAT-LONG-SOURCE-CD,                            
                     :PR-PREM-REF-LATITUDE,                             
                     :PR-PREM-REF-LONGITUDE,                            
                     :PR-AGL-PREM-NO,                                   
                     :PR-FM-ELEC-SVC-WKDIST,                            
                     :PR-FM-GAS-OPS-WKDIST,                             
                     :PR-FM-FLD-SVCS-WKDIST,                            
                     :PR-FM-REV-PRT-WKDIST,                             
                     :PR-FM-DSM-ESVC-WKDIST,                            
                     :PR-DDDC-FCTR,                                     
                     :PR-DDDC-FCTR-EFF-DT :WS-NULL-3,                    
                     :PR-AGL-SERVICE-CENTER,                            
                     :PR-SPCL-READ-INSTR,                               
                     :PR-DATE-SPCL-MSG-ENDS :WS-NULL-4,                  
                     :PR-SPCL-INSTRUCTIONS,                             
                     :PR-PREMISE-DIRECTIONS,                            
                     :PR-SCRATCH-PAD,                                   
                     :B1-REGULATED-CD,                                  
                     :PR-PEND-OFF-ORD-DT :WS-NULL-5                      
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                     
                     CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND PR.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                 AND PR.LOCAL_OFFICE = B1.LOCAL_OFFICE                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT PR.ADDRESS_ID,                                     13330000
MFA-TR*              PR.COMPANY_NO,                                     13330200
MFA-TR*              HOUSE_NO,                                          13330500
MFA-TR*              ADDR_PREFIX_1,                                     13330700
MFA-TR*              ADDR_PREFIX_2,                                     13330700
MFA-TR*              STREET_NAME,                                       13330800
MFA-TR*              STREET_SUFFIX,                                     13330900
MFA-TR*              ADDR_SUFFIX,                                       13331000
MFA-TR*              STREET_LOCATION_1,                                 13332000
MFA-TR*              STREET_LOCATION_2,                                 13380000
MFA-TR*              DY.ADDRESS_OVERFLOW,                               13390000
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE,                                                     
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              USPS_DELIV_PT_CD,                                          
MFA-TR*              LOT,                                                       
MFA-TR*              BLOCK,                                                     
MFA-TR*              PR.LOCAL_OFFICE,                                           
MFA-TR*              COUNTY,                                                    
MFA-TR*              LOCATOR_ID,                                                
MFA-TR*              SUBDIVISION_ID,                                            
MFA-TR*              CITY_GATE_ID,                                              
MFA-TR*              GAS_LEAK_SURVEY_DT,                                        
MFA-TR*              GAS_LK_SURVEY_FREQ,                                        
MFA-TR*              ADDR_USAGE_CD,                                             
MFA-TR*              CODE_RENTAL_PROP,                                          
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              READ_ROUTE,                                                
MFA-TR*              CROSS_STREET_1,                                            
MFA-TR*              CROSS_STREET_2,                                            
MFA-TR*              LAT_LONG_DT,                                               
MFA-TR*              LAT_LONG_SOURCE_CD,                                        
MFA-TR*              PREM_REF_LATITUDE,                                         
MFA-TR*              PREM_REF_LONGITUDE,                                        
MFA-TR*              AGL_PREM_NO,                                               
MFA-TR*              FM_ELEC_SVC_WKDIST,                                        
MFA-TR*              FM_GAS_OPS_WKDIST,                                         
MFA-TR*              FM_FLD_SVCS_WKDIST,                                        
MFA-TR*              FM_REV_PRT_WKDIST,                                         
MFA-TR*              FM_DSM_ESVC_WKDIST,                                        
MFA-TR*              DDDC_FCTR,                                                 
MFA-TR*              DDDC_FCTR_EFF_DT,                                          
MFA-TR*              AGL_SERVICE_CENTER,                                        
MFA-TR*              SPCL_READ_INSTR,                                           
MFA-TR*              DATE_SPCL_MSG_ENDS,                                        
MFA-TR*              SPCL_INSTRUCTIONS,                                         
MFA-TR*              PREMISE_DIRECTIONS,                                        
MFA-TR*              SCRATCH_PAD,                                               
MFA-TR*              REGULATED_CD,                                              
MFA-TR*              PEND_OFF_ORD_DT                                            
MFA-TR*         INTO :PR-ADDRESS-ID,                                    13330000
MFA-TR*              :PR-COMPANY-NO,                                    13330200
MFA-TR*              :DY-HOUSE-NO,                                      13330500
MFA-TR*              :DY-ADDR-PREFIX-1,                                 13330700
MFA-TR*              :DY-ADDR-PREFIX-2,                                 13330700
MFA-TR*              :DY-STREET-NAME,                                   13330800
MFA-TR*              :DY-STREET-SUFFIX,                                 13330900
MFA-TR*              :DY-ADDR-SUFFIX,                                   13331000
MFA-TR*              :DY-STREET-LOCATION-1,                             13332000
MFA-TR*              :DY-STREET-LOCATION-2,                             13380000
MFA-TR*              :DY-ADDRESS-OVERFLOW,                              13390000
MFA-TR*              :A4-TOWN,                                                  
MFA-TR*              :A4-STATE,                                                 
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-USPS-DELIV-PT-CD,                                      
MFA-TR*              :PR-LOT,                                                   
MFA-TR*              :PR-BLOCK,                                                 
MFA-TR*              :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-COUNTY,                                                
MFA-TR*              :PR-LOCATOR-ID,                                            
MFA-TR*              :PR-SUBDIVISION-ID,                                        
MFA-TR*              :PR-CITY-GATE-ID,                                          
MFA-TR*              :PR-GAS-LEAK-SURVEY-DT:WS-NULL-1,                          
MFA-TR*              :PR-GAS-LK-SURVEY-FREQ,                                    
MFA-TR*              :DY-ADDR-USAGE-CD,                                         
MFA-TR*              :PR-CODE-RENTAL-PROP,                                      
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :PR-READ-ROUTE,                                            
MFA-TR*              :PR-CROSS-STREET-1,                                        
MFA-TR*              :PR-CROSS-STREET-2,                                        
MFA-TR*              :PR-LAT-LONG-DT:WS-NULL-2,                                 
MFA-TR*              :PR-LAT-LONG-SOURCE-CD,                                    
MFA-TR*              :PR-PREM-REF-LATITUDE,                                     
MFA-TR*              :PR-PREM-REF-LONGITUDE,                                    
MFA-TR*              :PR-AGL-PREM-NO,                                           
MFA-TR*              :PR-FM-ELEC-SVC-WKDIST,                                    
MFA-TR*              :PR-FM-GAS-OPS-WKDIST,                                     
MFA-TR*              :PR-FM-FLD-SVCS-WKDIST,                                    
MFA-TR*              :PR-FM-REV-PRT-WKDIST,                                     
MFA-TR*              :PR-FM-DSM-ESVC-WKDIST,                                    
MFA-TR*              :PR-DDDC-FCTR,                                             
MFA-TR*              :PR-DDDC-FCTR-EFF-DT:WS-NULL-3,                            
MFA-TR*              :PR-AGL-SERVICE-CENTER,                                    
MFA-TR*              :PR-SPCL-READ-INSTR,                                       
MFA-TR*              :PR-DATE-SPCL-MSG-ENDS:WS-NULL-4,                          
MFA-TR*              :PR-SPCL-INSTRUCTIONS,                                     
MFA-TR*              :PR-PREMISE-DIRECTIONS,                                    
MFA-TR*              :PR-SCRATCH-PAD,                                           
MFA-TR*              :B1-REGULATED-CD,                                          
MFA-TR*              :PR-PEND-OFF-ORD-DT:WS-NULL-5                              
MFA-TR*         FROM CSS_PREMISE PR,                                    13550000
MFA-TR*              CSS_ADDR_FORMATTED DY,                             13551000
MFA-TR*              CSS_ZIP_CODE A4,                                   13551000
MFA-TR*              CSS_LOCAL_OFFICE B1                                13551000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        13560000
MFA-TR*          AND PR.ADDRESS_ID = DY.ADDRESS_ID                      13561000
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                          13562000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              13562000
MFA-TR*          AND PR.LOCAL_OFFICE = B1.LOCAL_OFFICE                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO PR-GAS-LEAK-SURVEY-DT             
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO PR-LAT-LONG-DT                    
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO PR-DDDC-FCTR-EFF-DT               
                   END-IF                                               
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO PR-DATE-SPCL-MSG-ENDS             
                   END-IF                                               
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO PR-PEND-OFF-ORD-DT                
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE' TO TABLE-1                        
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COMPANY_NO,
              ACCOUNT_TYPE_CODE                                  
                INTO :AT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT COMPANY_NO,                                        14210000
MFA-TR*              ACCOUNT_TYPE_CODE                                          
MFA-TR*         INTO :AT-COMPANY-NO,                                    14380000
MFA-TR*              :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT                                        14550000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        14560000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ACCOUNT                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7020'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT' TO TABLE-1                        
                   MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                 
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LL_MASTER_ACCT_NO,
              SI.CUSTOMER_NO,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + LTRIM(RTRIM(
           MIDDLE_NAME) + ' ' + LTRIM(RTRIM(LAST_NAME))))),
              NAME_FORMAT,
              FULL_NAME                                          
                INTO :SI-LL-MASTER-ACCT-NO,                             
                     :SI-CUSTOMER-NO,                                   
                     :SI-ADDRESS-ID,                                    
                     :SI-ADDRESS-FORMAT,                                
                     :WS-LANDLORD-NAME,                                 
                     :DQ-NAME-FORMAT,                                   
                     :DQ-FULL-NAME                                      
                FROM CSS_LANDLORD SI WITH(READUNCOMMITTED),                     
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND SI.CUSTOMER_NO = CU.CUSTOMER_NO                    
                 AND CU.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT LL_MASTER_ACCT_NO,                                 14210000
MFA-TR*              SI.CUSTOMER_NO,                                    14240000
MFA-TR*              ADDRESS_ID,                                        14250000
MFA-TR*              ADDRESS_FORMAT,                                    14310000
MFA-TR*              RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(LAST_NAME))))),                                
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              FULL_NAME                                                  
MFA-TR*         INTO :SI-LL-MASTER-ACCT-NO,                             14380000
MFA-TR*              :SI-CUSTOMER-NO,                                   14410000
MFA-TR*              :SI-ADDRESS-ID,                                    14420000
MFA-TR*              :SI-ADDRESS-FORMAT,                                14480000
MFA-TR*              :WS-LANDLORD-NAME,                                 14480000
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*         FROM CSS_LANDLORD SI,                                   14550000
MFA-TR*              CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*          AND SI.CUSTOMER_NO = CU.CUSTOMER_NO                            
MFA-TR*          AND CU.NAME_ID = DQ.NAME_ID                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-LANDLORD-NAME            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-LANDLORD                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7030'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD' TO TABLE-1                       
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-GAS-DETAILS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RATE_PLAN_NO                                       
                INTO :UT-RATE-PLAN-NO                                   
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND CODE_UTIL_TYPE = 'G'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT RATE_PLAN_NO                                       14210000
MFA-TR*         INTO :UT-RATE-PLAN-NO                                   14380000
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   14550000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        14560000
MFA-TR*          AND CODE_UTIL_TYPE = 'G'                                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-UTIL-ENVRNMT                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7040'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                 
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-PREM-RELEASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RLSE_NO                                            
                INTO :RP-RLSE-NO                                        
                FROM CSS_PREM_RLSE_DATA WITH(READUNCOMMITTED)                   
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT RLSE_NO                                            14210000
MFA-TR*         INTO :RP-RLSE-NO                                        14380000
MFA-TR*         FROM CSS_PREM_RLSE_DATA                                 14550000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-PREM-RLSE-DATA                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7050'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-LIMIT-LENGTH.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :MN-ACCOUNT-NO                                     
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                 
                     CSS_MTR_CAP MC WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND MC.COMPANY_NO = :AT-COMPANY-NO                     
                 AND MN.CODE_UTIL_TYPE = 'E'                            
                 AND MC.CODE_UTIL_TYPE = 'E'                            
                 AND MN.METER_NO = MC.METER_NO                          
                 AND CONSTANT > 1                                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT ACCOUNT_NO                                         14210000
MFA-TR*         INTO :MN-ACCOUNT-NO                                     14380000
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN,                               14550000
MFA-TR*              CSS_MTR_CAP MC                                             
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        14560000
MFA-TR*          AND MC.COMPANY_NO = :AT-COMPANY-NO                             
MFA-TR*          AND MN.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND MC.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND MN.METER_NO = MC.METER_NO                                  
MFA-TR*          AND CONSTANT > 1                                               
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-MTRD-ENVRNMT                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7060'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'CSS_MTR_CAP' TO TABLE-2                        
                   MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1                 
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-OPEN-APP-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN APP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_APPLIANCE'  TO TABLE-1                     
                   MOVE 'CSS_MKT_APPLIANCE'  TO TABLE-2                 
                   MOVE 'CSS_APPLIANCE_LOC'  TO TABLE-3                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7071-CLOSE-APP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE APP-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7071'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_APPLIANCE'  TO TABLE-1                     
                   MOVE 'CSS_MKT_APPLIANCE'  TO TABLE-2                 
                   MOVE 'CSS_APPLIANCE_LOC'  TO TABLE-3                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7071-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SERVICE-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SERV_ORDER_NO                                      
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ORDER_STATE_CD <> 'C'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT SERV_ORDER_NO                                      14210000
MFA-TR*         INTO :VO-SERV-ORDER-NO                                  14380000
MFA-TR*         FROM CSS_SO_DATA                                        14550000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*          AND ORDER_STATE_CD ^= 'C'                                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-SO-DATA                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7080'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA' TO TABLE-1                        
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-REQUIREMENT.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) EG.SERV_ORDER_NO                                   
                INTO :EG-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA  VO WITH(READUNCOMMITTED),                     
                     CSS_SO_REQUIREMENT EG WITH(READUNCOMMITTED)                
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND VO.ORDER_TYPE_CD = 'FM002'                         
                 AND VO.ORDER_STATE_CD = 'A'                            
                 AND EG.SERV_ORDER_NO = VO.SERV_ORDER_NO                
                 AND EG.SERV_ORDER_STATUS = '20'                        
                 AND REQUIREMENT_CD = '2'                               
                 AND REQMNT_STAGE_CD = 'C'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT EG.SERV_ORDER_NO                                   14210000
MFA-TR*         INTO :EG-SERV-ORDER-NO                                  14380000
MFA-TR*         FROM CSS_SO_DATA  VO,                                           
MFA-TR*              CSS_SO_REQUIREMENT EG                                      
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND VO.ORDER_TYPE_CD = 'FM002'                                 
MFA-TR*          AND VO.ORDER_STATE_CD = 'A'                                    
MFA-TR*          AND EG.SERV_ORDER_NO = VO.SERV_ORDER_NO                        
MFA-TR*          AND EG.SERV_ORDER_STATUS = '20'                                
MFA-TR*          AND REQUIREMENT_CD = '2'                                       
MFA-TR*          AND REQMNT_STAGE_CD = 'C'                                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-SO-DATA                            
                              DCLCSS-SO-REQUIREMENT                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7090'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA' TO TABLE-1                        
                   MOVE 'CSS_SO_REQUIREMENT' TO TABLE-2                 
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-GAS-LINE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XO.SERVICE_NO                                      
                INTO :XO-SERVICE-NO                                     
                FROM CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED),                
                     CSS_PREM_GAS_LINE Y0 WITH(READUNCOMMITTED)                 
               WHERE Y0.PREMISE_NO = :PR-PREMISE-NO                     
                 AND XO.SERVICE_NO = Y0.SERVICE_NO                      
                 AND XO.SERV_LINE_STAT_FL IN ('A', 'T', 'U')            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XO.SERVICE_NO                                              
MFA-TR*         INTO :XO-SERVICE-NO                                             
MFA-TR*         FROM CSS_GAS_SERV_LINE XO,                                      
MFA-TR*              CSS_PREM_GAS_LINE Y0                                       
MFA-TR*        WHERE Y0.PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*          AND XO.SERVICE_NO = Y0.SERVICE_NO                              
MFA-TR*          AND XO.SERV_LINE_STAT_FL IN ('A', 'T', 'U')                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  XO-SERVICE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7100'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_GAS_SERV_LINE' TO TABLE-1                  
                   MOVE 'CSS_PREM_GAS_LINE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-COUNT-ACCOUNTS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-ACCOUNT-CT                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-ACCOUNT-CT                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 71101                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-ACCOUNT-CT                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7110'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-ACCOUNT-CT = 0                                         
               EXEC SQL                                                 
                  SELECT COUNT(*)                                       
                    INTO :WS-ACCOUNT-CT                                 
                    FROM HST_ACCOUNT WITH(READUNCOMMITTED)                      
                   WHERE PREMISE_NO = :PR-PREMISE-NO                    
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT COUNT(*)                                               
MFA-TR*             INTO :WS-ACCOUNT-CT                                         
MFA-TR*             FROM HST_ACCOUNT                                            
MFA-TR*            WHERE PREMISE_NO = :PR-PREMISE-NO                            
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 71102                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       CONTINUE                                         
                   WHEN NOT-FOUND                                       
                       MOVE ZEROES TO WS-ACTIVE-RETURN-CODE             
                                      WS-ACCOUNT-CT                     
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME  TO ABEND-PROGRAM              
                       MOVE '7110'        TO ACTIVE-PARAGRAPH           
                       MOVE 'SELECT'      TO ABEND-FUNCTION             
                       MOVE 'HST_ACCOUNT' TO TABLE-1                    
                       MOVE 'PREMISE_NO'  TO TABLE-ELEMENT-1            
                       MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1          
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
               END-EVALUATE
           END-IF.                                            
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-COUNT-PENDING.                                              
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-PENDING-CT                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND CODE_ACCT_STAT = 'P'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-PENDING-CT                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND CODE_ACCT_STAT = 'P'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-PENDING-CT                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7120'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-OPEN-ORDER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ORDER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-2                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7131-CLOSE-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7131'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-2                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7131-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-SELECT-READ-ROUTE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MAX(READ_ROUTE)                                    
                INTO :UT-READ-ROUTE :WS-NULL-8                           
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(READ_ROUTE)                                            
MFA-TR*         INTO :UT-READ-ROUTE:WS-NULL-8                                   
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-8 < 0                                     
                       MOVE ZEROES TO UT-READ-ROUTE                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7140'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-PENDING-ACCOUNT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND CODE_ACCT_STAT = 'P'                               
                 AND ACCT_CREATE_DT IS NOT NULL                         
              ORDER BY ACCT_CREATE_DT DESC                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT ACCOUNT_NO                                         14210000
MFA-TR*         INTO :AT-ACCOUNT-NO                                     14380000
MFA-TR*         FROM CSS_ACCOUNT                                        14550000
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        14560000
MFA-TR*          AND CODE_ACCT_STAT = 'P'                                       
MFA-TR*          AND ACCT_CREATE_DT IS NOT NULL                                 
MFA-TR*       ORDER BY ACCT_CREATE_DT DESC                                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ACCOUNT                            
                   MOVE ZEROES TO AT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7150'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT' TO TABLE-1                        
                   MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1                 
                   MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04832_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04832_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04832_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04832_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04832_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8003'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04832_R3'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04832_R2                            
             (                                                          
              RETURN_CODE,                                              
              EQUIPMENT_NO,                                             
              APPLIANCE_CD,                                             
              LOCATION_CD,                                              
              BTU,                                                      
              CAUTION_TAG_IND,                                          
              CUT_IND,                                                  
              PRIMARY_FUEL_CD,                                          
              TAG_NO,                                                   
              CONDITION_CD,                                             
              APPLIANCE_COMMENTS,                                       
              CAUTION_TAG_DT,                                           
              SOURCE_SYSTEM_CD,                                         
              INSTALL_DT                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-EQUIPMENT-NO,                                         
               :S-APPLIANCE-CD,                                         
               :S-LOCATION-CD,                                          
               :S-BTU,                                                  
               :S-CAUTION-TAG-IND,                                      
               :S-CUT-IND,                                              
               :S-PRIMARY-FUEL-CD,                                      
               :S-TAG-NO,                                               
               :S-CONDITION-CD,                                         
               :S-APPLIANCE-COMMENTS,                                   
               :S-CAUTION-TAG-DT,                                       
               :S-SOURCE-SYSTEM-CD,                                     
               :S-INSTALL-DT                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04832_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       EQUIPMENT_NO,                                                     
MFA-TR*       APPLIANCE_CD,                                                     
MFA-TR*       LOCATION_CD,                                                      
MFA-TR*       BTU,                                                              
MFA-TR*       CAUTION_TAG_IND,                                                  
MFA-TR*       CUT_IND,                                                          
MFA-TR*       PRIMARY_FUEL_CD,                                                  
MFA-TR*       TAG_NO,                                                           
MFA-TR*       CONDITION_CD,                                                     
MFA-TR*       APPLIANCE_COMMENTS,                                               
MFA-TR*       CAUTION_TAG_DT,                                                   
MFA-TR*       SOURCE_SYSTEM_CD,                                                 
MFA-TR*       INSTALL_DT                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-EQUIPMENT-NO,                                                 
MFA-TR*        :S-APPLIANCE-CD,                                                 
MFA-TR*        :S-LOCATION-CD,                                                  
MFA-TR*        :S-BTU,                                                          
MFA-TR*        :S-CAUTION-TAG-IND,                                              
MFA-TR*        :S-CUT-IND,                                                      
MFA-TR*        :S-PRIMARY-FUEL-CD,                                              
MFA-TR*        :S-TAG-NO,                                                       
MFA-TR*        :S-CONDITION-CD,                                                 
MFA-TR*        :S-APPLIANCE-COMMENTS,                                           
MFA-TR*        :S-CAUTION-TAG-DT,                                               
MFA-TR*        :S-SOURCE-SYSTEM-CD,                                             
MFA-TR*        :S-INSTALL-DT                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04832_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04832_R3                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              CODE_UTIL_TYPE,                                           
              IC_NO,                                                    
              PER_TEMP_IND,                                             
              METER_SUPPLYING,                                          
              RLSE_NO,                                                  
              RLSE_DATE,                                                
              WORK_TYPE_CD,                                             
              RLSE_TYPE                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-SERV-ORDER-NO,                                        
               :S-CODE-UTIL-TYPE,                                       
               :S-IC-NO,                                                
               :S-PER-TEMP-IND,                                         
               :S-METER-SUPPLYING,                                      
               :S-RLSE-NO,                                              
               :S-RLSE-DATE,                                            
               :S-WORK-TYPE-CD,                                         
               :S-RLSE-TYPE                                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04832_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       IC_NO,                                                            
MFA-TR*       PER_TEMP_IND,                                                     
MFA-TR*       METER_SUPPLYING,                                                  
MFA-TR*       RLSE_NO,                                                          
MFA-TR*       RLSE_DATE,                                                        
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       RLSE_TYPE                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-SERV-ORDER-NO,                                                
MFA-TR*        :S-CODE-UTIL-TYPE,                                               
MFA-TR*        :S-IC-NO,                                                        
MFA-TR*        :S-PER-TEMP-IND,                                                 
MFA-TR*        :S-METER-SUPPLYING,                                              
MFA-TR*        :S-RLSE-NO,                                                      
MFA-TR*        :S-RLSE-DATE,                                                    
MFA-TR*        :S-WORK-TYPE-CD,                                                 
MFA-TR*        :S-RLSE-TYPE                                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04832_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
