       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04831.                                         
       AUTHOR.        SHABNAM.                                          
COB303 DATE-WRITTEN.  JANUARY 21, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE UPDATES THE ROWS IN THE CSS_INTV_USE_CLASS     *        
      *  BASED ON INPUT UPDATE_DATA.                                   *        
      *                                                                *        
      *  NOTE : IN THE INPUT UPDATE_DATA CAN COME MAX 31 TIMES.        *        
      ******************************************************************        
      *                                                                *        
      *# BASED ON I_UPDATE_DATA SP WILL PERFORM INSERT OR DELETE       *ING *   
      *  ON CSS_INTV_USE_CLASS FOR THE I_REVENUE_MONTH.                *        
      *                                                                *        
      *# I_UPDATE_DATA IS SEPARATED BY 3 CHARACTERS.                   *        
      *  EXAMPLE: I_UPDATE_DATA = (I01D02).                            *        
      *  IN THIS EXAMPLE 01 NEEDS TO INSERT AND 02 NEEDS TO DELETE     *        
      *  FROM CSS_INTV_USE_CLASS.                                      *        
      *                                                                *        
      *# WRITE MNT TRAN HIST OF UPDATE AND INSERT FIELDS.              *        
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           I_ACCOUNT_NO               DECIMAL(13)           --         
      *--           I_CODE_UTIL_TYPE           CHAR(01)              --         
      *--           I_IC_NO                    SMALLINT              --         
      *--           I_REVENUE_MONTH            CHAR(06)              --         
      *--           I_UPDATE_DATA              CHAR(93)              --         
      *--           I_CODE_USAGE_CLASS         CHAR(01)              --         
ACT232*--           I_USER_ID                  CHAR(07)              --         
      *--                                                            --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *    ------    --------   -------------------------------------  *        
      *  01/20/2015  SS7F226    NEW PROGRAM                            *        
A05136*  11/14/2015  RS7M249  GET USERID FROM INPUT INSTEAD FROM CURRE *        
A05136*              ACT232   NT SQLID                                 *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04831'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04831 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_INTV_USE_CLAS  (IU)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINTUSE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST (MH)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET (MI)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WS ABEND WORK AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)   VALUE 'CSR04831'.     
ACT232     05  PARM-USER-ID            PIC X(07)  VALUE SPACES.         
           05  WS-MAX-ROW              PIC S9(04) VALUE 31.             
           05  WS-SPACES               PIC X(03)  VALUE SPACES.         
           05  WS-B                    PIC X(01)  VALUE 'B'.            
           05  WS-ZERO                 PIC S9(9) COMP VALUE 0.          
           05  WS-INPUT-DAYS           PIC X(03).                       
           05  WS-REV-MTH-HOLD         PIC 9(06).                       
           05  WS-REV-MTH-CHAR REDEFINES WS-REV-MTH-HOLD                
                                       PIC X(06).                       
           05  WS-REV-FMT-START-DT     PIC X(08).                       
           05  WS-TRANS-HIST-SEQ-NO    PIC X(26).                       
           05  WS-DATE-TRANS           PIC X(10).                       
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE +0.        
           05  WS-MNT-TRAN-COMMENT     PIC X(35) VALUE                  
                'MAINT INTERVAL USE CLASS - CSR04831'.                  
           05  WS-I                    PIC 9(2)   VALUE 1.              
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-CODE-UTIL-TYPE       PIC X(01).                       
           05  WS-IC-NO                PIC S9(4) USAGE COMP.            
           05  WS-CODE-USAGE-CLASS     PIC X(01).                       
           05  WS-TIME-USAGE-ENDS      PIC X(08)  VALUE '23.59.00'.     
           05  WS-ACTION-FLAG          PIC X(01).                       
               88 WS-INSERT                       VALUE 'I'.            
               88 WS-DELETE                       VALUE 'D'.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-REV-INPUT-DT.                                             
           05  WS-REV-INPUT-YEAR       PIC X(04)  VALUE SPACES.         
           05  WS-FILLER1              PIC X(1)   VALUE '-'.            
           05  WS-REV-INPUT-MTH        PIC X(02)  VALUE SPACES.         
           05  WS-FILLER2              PIC X(1)   VALUE '-'.            
                                                                        
       01  WS-USAGE-STRT-TMSTMP.                                        
           05  WS-USAGE-TMSTMP-08      PIC X(08)  VALUE SPACES.         
           05  WS-USAGE-TMSTMP-02      PIC X(02)  VALUE SPACES.         
           05  WS-USAGE-TMSTMP-16      PIC X(16)                        
                                       VALUE '-00.00.00.000000'.        
                                                                        
       01  WS-INTV-USE-CLASS-TB.                                        
           05 WS-UPDATE-DATA.                                           
              10 WS-USAGE-START-DATE   PIC X(03) OCCURS 31 TIMES        
                                       INDEXED BY WS-INPUT-INDX.        
       01  WS-UPDATE-PARMS.                                             
           05 WS-ACTION-CODE           PIC X(01).                       
           05 WS-INTV-USAGE-START-DATE PIC X(02).                       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01)  VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW            PIC X(01)  VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) COMP VALUE 0.         
          05 S-APPL-RETURN-CODE        PIC S9(09) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)  VALUE SPACES.         
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)   VALUE ' '.            
           10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05)  VALUE SPACES.         
                                                                        
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
       01   LINK-CODE-UTIL-TYPE        PIC X(01).                       
       01   LINK-IC-NO                 PIC S9(4)   USAGE COMP.          
       01   LINK-REVENUE-MONTH         PIC X(06).                       
       01   LINK-UPDATE-DATA           PIC X(93).                       
       01   LINK-CODE-USAGE-CLASS      PIC X(01).                       
ACT232 01   LINK-USER-ID               PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING LINK-ACCOUNT-NO                         
                                LINK-CODE-UTIL-TYPE                     
                                LINK-IC-NO                              
                                LINK-REVENUE-MONTH                      
                                LINK-UPDATE-DATA                        
ACT232                          LINK-CODE-USAGE-CLASS                   
ACT232                          LINK-USER-ID.                           
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-INPUT-DATE    THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE LINK-ACCOUNT-NO              TO WS-ACCOUNT-NO           
                                                IU-ACCOUNT-NO.          
           MOVE LINK-REVENUE-MONTH           TO WS-REV-MTH-HOLD.        
           MOVE LINK-CODE-UTIL-TYPE          TO WS-CODE-UTIL-TYPE       
                                                IU-CODE-UTIL-TYPE.      
           MOVE LINK-IC-NO                   TO WS-IC-NO                
                                                IU-IC-NO.               
           MOVE LINK-UPDATE-DATA             TO WS-UPDATE-DATA.         
                                                                        
           MOVE LINK-CODE-USAGE-CLASS        TO WS-CODE-USAGE-CLASS     
                                                IU-CODE-USAGE-CLASS.    
           MOVE WS-B                         TO IU-CODE-ENTRY-TYPE.     
           MOVE WS-TIME-USAGE-ENDS           TO IU-TIME-USAGE-ENDS.     
ACT232     MOVE LINK-USER-ID                 TO PARM-USER-ID.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-INPUT-DATE.                                       *        
      * MAIN PROCESS FOR UPDATE.                                       *        
      ******************************************************************        
       2000-PROCESS-INPUT-DATE.                                         
                                                                        
           MOVE WS-REV-MTH-CHAR(1:4)         TO WS-REV-INPUT-YEAR.      
           MOVE WS-REV-MTH-CHAR(5:2)         TO WS-REV-INPUT-MTH.       
           MOVE WS-REV-INPUT-DT              TO WS-REV-FMT-START-DT.    
                                                                        
           MOVE WS-REV-FMT-START-DT          TO WS-USAGE-TMSTMP-08.     
                                                                        
           PERFORM VARYING WS-INPUT-INDX FROM 1 BY 1                    
                           UNTIL WS-INPUT-INDX > WS-MAX-ROW             
            OR WS-USAGE-START-DATE(WS-INPUT-INDX) = WS-SPACES           
                                                                        
             MOVE WS-USAGE-START-DATE(WS-INPUT-INDX)                    
                                             TO WS-INPUT-DAYS           
                                                                        
             MOVE WS-INPUT-DAYS              TO WS-UPDATE-PARMS         
                                                                        
             MOVE WS-INTV-USAGE-START-DATE   TO WS-USAGE-TMSTMP-02      
             MOVE WS-USAGE-STRT-TMSTMP       TO IU-USAGE-STRT-TMSTMP    
                                                                        
             PERFORM 7000-GET-CURRENT-VALUES  THRU 7000-EXIT            
             MOVE WS-TRANS-HIST-SEQ-NO       TO MH-TRANS-HIST-SEQ-NO    
             MOVE WS-DATE-TRANS              TO MH-DATE-TRANS           
ACT232       MOVE PARM-USER-ID               TO MH-USER-ID              
                                                                        
             MOVE WS-ACTION-CODE             TO WS-ACTION-FLAG          
             PERFORM 2100-UPDATE-PROCESS      THRU 2100-EXIT            
                                                                        
             PERFORM 8100-SEND-RESULT         THRU 8100-EXIT            
                                                                        
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2100-UPDATE-PROCESS.                                          *         
      * INSERT OR DELETE THE CSS_INTV_USE_CLASS BASED ON I_INPUT_DATA.*         
      *****************************************************************         
       2100-UPDATE-PROCESS.                                             
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-INSERT                                            
                   PERFORM 8000-INSERT-INTV   THRU 8000-EXIT            
                   PERFORM 2400-SETUP-MNT-TRAN-HDR                      
                                              THRU 2400-EXIT            
                   PERFORM 2600-SETUP-MNT-TRAN-DET                      
                                              THRU 2600-EXIT            
              WHEN WS-DELETE                                            
                   PERFORM 8050-DELETE-INTV   THRU 8050-EXIT            
                   PERFORM 2400-SETUP-MNT-TRAN-HDR                      
                                              THRU 2400-EXIT            
                   PERFORM 2600-SETUP-MNT-TRAN-DET                      
                                              THRU 2600-EXIT            
              WHEN OTHER                                                
                   MOVE WS-ZERO              TO CTR-ROWS                
                   PERFORM 9999-END-PROGRAM   THRU 9999-EXIT            
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2400-SETUP-MNT-TRAN-HDR.                                      *         
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.            *         
      *****************************************************************         
       2400-SETUP-MNT-TRAN-HDR.                                         
      *                                                                         
           MOVE 'F'                          TO MH-CODE-TRAN-TYPE.      
           MOVE SPACES                       TO MH-RESP-AREA-ID.        
           MOVE WS-ACCOUNT-NO                TO MH-ACCOUNT-NO.          
           MOVE ZEROES                       TO MH-CUSTOMER-NO.         
           MOVE ZEROES                       TO MH-PREMISE-NO.          
           MOVE PROGRAM-NAME                 TO MH-APPL-PROGRAM-ID.     
           MOVE +35                          TO MH-TRAN-COMMENT-LEN.    
           MOVE WS-MNT-TRAN-COMMENT          TO MH-TRAN-COMMENT-TEXT.   
           MOVE +0                           TO MH-ENTITY-KEY-DESC-LEN. 
           MOVE SPACES                       TO MH-ENTITY-KEY-DESC-TEXT.
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2600-SETUP-MNT-TRAN-DET.                                      *         
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND CALL    *         
      * COMMON PARAGRAPH FOR WRITING ROW.(6530-LOAD-MNT*)             *         
      *****************************************************************         
       2600-SETUP-MNT-TRAN-DET.                                         
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE 1                            TO WS-TRAN-APPL-NO         
                                                MI-TRAN-APPL-NO.        
           EVALUATE TRUE                                                
              WHEN WS-INSERT                                            
                   MOVE SPACES               TO MI-TABLE-ID             
                   MOVE 7                    TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '**NEW**'            TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE 'CODE UTIL TYPE '    TO MI-COLUMN-DESC          
                   MOVE WS-CODE-UTIL-TYPE    TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'IC NO          '    TO MI-COLUMN-DESC          
                   MOVE WS-IC-NO             TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'CODE ENTRY TYPE'    TO MI-COLUMN-DESC          
                   MOVE WS-B                 TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'USAGE_STRT_TMST'    TO MI-COLUMN-DESC          
                   MOVE WS-USAGE-STRT-TMSTMP TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'CODE_USAGE_CLAS'    TO MI-COLUMN-DESC          
                   MOVE WS-CODE-USAGE-CLASS  TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'TIME_USAGE_ENDS'    TO MI-COLUMN-DESC          
                   MOVE WS-TIME-USAGE-ENDS   TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
              WHEN WS-DELETE                                            
                   MOVE SPACES               TO MI-TABLE-ID             
                   MOVE 11                   TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE 'CODE UTIL TYPE '    TO MI-COLUMN-DESC          
                   MOVE WS-CODE-UTIL-TYPE    TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'IC NO          '    TO MI-COLUMN-DESC          
                   MOVE WS-IC-NO             TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'CODE ENTRY TYPE'    TO MI-COLUMN-DESC          
                   MOVE WS-B                 TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'USAGE_STRT_TMST'    TO MI-COLUMN-DESC          
                   MOVE WS-USAGE-STRT-TMSTMP TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'CODE_USAGE_CLAS'    TO MI-COLUMN-DESC          
                   MOVE WS-CODE-USAGE-CLASS  TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE 'TIME_USAGE_ENDS'    TO MI-COLUMN-DESC          
                   MOVE WS-TIME-USAGE-ENDS   TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST                     
                                              THRU 6530-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *6530-LOAD-MNT-TRANS-HIST.                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *7000-GET-CURRENT-VALUES.                                       *         
      *****************************************************************         
       7000-GET-CURRENT-VALUES.                                         
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DATE-TRANS = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *8000-INSERT-INTV.                                              *         
      *****************************************************************         
       8000-INSERT-INTV.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_INTV_USE_CLASS                             
             (                                                          
              ACCOUNT_NO                                                
             ,CODE_UTIL_TYPE                                            
             ,IC_NO                                                     
             ,CODE_ENTRY_TYPE                                           
             ,USAGE_STRT_TMSTMP                                         
             ,CODE_USAGE_CLASS                                          
             ,TIME_USAGE_ENDS                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :IU-ACCOUNT-NO                                            
             ,:IU-CODE-UTIL-TYPE                                        
             ,:IU-IC-NO                                                 
             ,:IU-CODE-ENTRY-TYPE                                       
             ,CIS.CHAR2TIMESTAMP(:IU-USAGE-STRT-TMSTMP)                         
             ,:IU-CODE-USAGE-CLASS                                      
             ,CIS.CHAR2TIME(:IU-TIME-USAGE-ENDS)                                
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_INTV_USE_CLASS                                     
MFA-TR*      (                                                                  
MFA-TR*       ACCOUNT_NO                                                        
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,CODE_ENTRY_TYPE                                                   
MFA-TR*      ,USAGE_STRT_TMSTMP                                                 
MFA-TR*      ,CODE_USAGE_CLASS                                                  
MFA-TR*      ,TIME_USAGE_ENDS                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :IU-ACCOUNT-NO                                                    
MFA-TR*      ,:IU-CODE-UTIL-TYPE                                                
MFA-TR*      ,:IU-IC-NO                                                         
MFA-TR*      ,:IU-CODE-ENTRY-TYPE                                               
MFA-TR*      ,:IU-USAGE-STRT-TMSTMP                                             
MFA-TR*      ,:IU-CODE-USAGE-CLASS                                              
MFA-TR*      ,:IU-TIME-USAGE-ENDS                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTV_USE_CLASS'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *8050-DELETE-INTV.                                              *         
      *****************************************************************         
       8050-DELETE-INTV.                                                
                                                                        
           EXEC SQL                                                     
             DELETE IU                                
             FROM CSS_INTV_USE_CLASS IU
              WHERE IU.ACCOUNT_NO         = :IU-ACCOUNT-NO              
                AND IU.CODE_UTIL_TYPE     = :IU-CODE-UTIL-TYPE          
                AND IU.IC_NO              = :IU-IC-NO                   
                AND IU.USAGE_STRT_TMSTMP  = CIS.CHAR2TIMESTAMP(
                                                  :IU-USAGE-STRT-TMSTMP
              )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE CSS_INTV_USE_CLASS IU                                       
MFA-TR*       WHERE IU.ACCOUNT_NO         = :IU-ACCOUNT-NO                      
MFA-TR*         AND IU.CODE_UTIL_TYPE     = :IU-CODE-UTIL-TYPE                  
MFA-TR*         AND IU.IC_NO              = :IU-IC-NO                           
MFA-TR*         AND IU.USAGE_STRT_TMSTMP  = :IU-USAGE-STRT-TMSTMP               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTV_USE_CLASS'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *8100-SEND-RESULT.                                              *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
                                                                        
           ADD +1                           TO CTR-ROWS.                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * END PROGRAM COPYLIB.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
