       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04830.                                         
COB303 DATE-WRITTEN.  JANUARY 07, 2015                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00041001
      *                                                                *00042001
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00043001
      *                                                                *00044001
      ******************************************************************00049201
      *                 P R O G R A M  S U M M A R Y                   *00049301
      *                                                                *00049401
      *1.THIS PROCEDURE RETRIEVE THE ROWS IN THE                       *00049501
      *  CSS_INTV_USE_CLASS TABLE FOR A SPECIFIC CUSTOMER ON A SPECIFIC*00049601
      *  DATE.                                                         *00049701
      *                                                                *00049701
      *2.IF CANCEL REBILL FLAG IS YES, WE NEED TO ALLOW USER TO EDIT   *00049701
      *  PARTICULAR REVENUE MONTH ALONG WITH LATEST REV MONTH.         *00049701
      ******************************************************************00049801
      *    PARAMETERS                                                  *00049904
      *                                                                *00050004
      *        IN                                                      *00050104
      *              I_ACCOUNT_NO            DECIMAL(13,0)             *00050204
      *                                                                *00050401
      *        OUT                                                     *00050504
      *              NONE                                              *00050604
      *                                                                *00050704
      *        INOUT                                                   *00050804
      *              NONE                                              *00050904
      *                                                                *00051004
      *    RESULT SET                                                  *00051104
      *              RETURN_CODE             INTEGER                   *00051204
      *              CODE_UTIL_TYPE          CHAR(1)                   *00051404
      *              IC_NO                   SMALLINT                  *00051504
      *              CODE_USAGE_CLASS        CHAR(1)                   *00051704
      *              TIME_USAGE_ENDS         TIME                      *00051804
      *              REV_MNTH                CHAR(6)                   *00051904
      *              INTV_USE_DATE           CHAR(92)                  *00052004
      *              REBILL_ROW_FOUND        CHAR(01)                  *00052004
      *                                                                *00052104
      *----------------------------------------------------------------*00052804
      *                     PROGRAM MODIFICATION LOG                   *00052901
      *                                                                *00053001
      *    DATE    INITIALS   COMMENTS                                 *00053101
      *  --------  --------   ---------------------------------------  *00054001
      *                                                                *00060003
      *  01/07/15  MR7E794    INITIAL CODE.                            *00070003
      *                       PROJ801                                  *00071003
      ******************************************************************00080001
      ******************************************************************00090001
      *                                                                *00100001
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00110001
      *                                                                *00120001
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00130001
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00140001
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00150001
      *  3000 - 4999  NOT USED                                         *00160001
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00170001
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00180001
      *  7000 - 7999  INPUT MODULES                                    *00190001
      *  8000 - 8999  OUTPUT MODULES                                   *00200001
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00210001
      *                                                                *00220001
      ******************************************************************00230001
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-CANCEL-REBILL-CUR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04830'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02248 STARTS HERE'.                  
                                                                        
      ******************************************************************00320001
      *    DB2 INCLUDES                                                *00330001
      ******************************************************************00340001
                                                                        
           EXEC SQL                                                     00360001
              INCLUDE SQLCA                                             00370001
           END-EXEC.                                                    00380001
                                                                        
      ***  CSS_ACCOUNT. (AT)                                            00511003
           EXEC SQL                                                     00520001
              INCLUDE TBACCT                                            00530001
           END-EXEC.                                                    00540001
                                                                        
      ***  CSS_INTV_USE_CLASS. (IU)                                     00540203
           EXEC SQL                                                     00541002
              INCLUDE TBINTUSE                                          00542002
           END-EXEC.                                                    00543002
                                                                        
      ***  CSS_JOB_PARM. (G6)                                           00540203
           EXEC SQL                                                     00541002
              INCLUDE TBJBPARM                                          00542002
           END-EXEC.                                                    00543002
                                                                        
      ***  CSS_BILLING_DET. (BG)                                        00540203
           EXEC SQL                                                     00541002
              INCLUDE TBBLLDET                                          00542002
           END-EXEC.                                                    00543002
                                                                        
      **** ERROR HANDLING (ABEND VARIABLES)                             00544005
           EXEC SQL                                                     00545005
               INCLUDE CWSX0010                                         00546005
           END-EXEC.                                                    00547005
      *                                                                 00548005
      ******************************************************************00550001
      *    COBOL WORKING STORAGE COPY BOOKS                            *00560001
      ******************************************************************00570001
           COPY CWS00303.                                               00610001
                                                                        
      ******************************************************************00660001
      *    WORK AREAS                                                  *00670001
      ******************************************************************00680001
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(08) VALUE 'CSR04830'.   
           05  WS-PGRMNAME                PIC X(08) VALUE 'CSR04830'.   
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
           05  WS-REV-MTH-HOLD            PIC 9(06).                    
           05  WS-REV-MTH-CHAR REDEFINES WS-REV-MTH-HOLD                
                                          PIC X(06).                    
           05  WS-INTV-USE-DATE           PIC X(92) VALUE SPACES.       
           05  WS-I                       PIC 9(2)  VALUE 1.            
           05  WS-IC-NO                   PIC S9(4) USAGE COMP          
                                                    VALUE 001.          
           05  WS-CODE-UTIL-TYPE          PIC X(01) VALUE 'E'.          
           05  WS-CODE-USAGE-CLASS        PIC X(01) VALUE 'D'.          
           05  WS-TIME-USAGE-ENDS         PIC X(08) VALUE '23.59.00'.   
           05  WS-NO-ROWS                 PIC X(1)  VALUE 'N'.          
           05  WS-ACCOUNT-FOUND           PIC X(1)  VALUE SPACES.       
           05  WS-COMPANY-NO              PIC X(02) VALUE '01'.         
           05  WS-CMND-CODE               PIC X(04) VALUE 'PARM'.       
           05  WS-REV-FMT-START-DT        PIC X(07).                    
           05  WS-REV-FMT-END-DT          PIC X(07).                    
           05  WS-GTT-NAME                PIC X(19) VALUE SPACES.       
           05  WS-BACKOUT                 PIC X(01) VALUE 'B'.          
           05  WS-YES                     PIC X(01) VALUE 'Y'.          
           05  WS-NO                      PIC X(01) VALUE 'N'.          
           05  WS-REV-MTH-ROW-COUNT       PIC S9(4) USAGE COMP VALUE 0. 
           05  WS-ONE                     PIC 9(01) VALUE 1.            
                                                                        
       01  WS-REBILL-INFO.                                              
COB305     05 WS-REV-MTH-ORIG-BILL        PIC S9(6)V USAGE COMP-3 
COB305       OCCURS 50 TIMES INDEXED BY WS-REV-MTH-INDX VALUE 0.              
           05  WS-REV-MTH-ORIG-NUM        PIC S9(6) VALUE ZERO.         
                                                                        
       01  WS-REV-INPUT-DT.                                             
           05  WS-REV-INPUT-YEAR          PIC X(04) VALUE SPACES.       
           05  WS-FILLER1                 PIC X(1)  VALUE '-'.          
           05  WS-REV-INPUT-MTH           PIC X(02) VALUE SPACES.       
           05  WS-FILLER2                 PIC X(1)  VALUE '-'.          
           05  WS-REV-INPUT-DATE          PIC X(02) VALUE '01'.         
                                                                        
       01  WS-REV-DATE.                                                 
           05  WS-REV-START-DATE          PIC X(10).                    
           05  WS-REV-END-DATE            PIC X(10).                    
           05  WS-COMP-REV-START-MTH      PIC X(10).                    
           05  WS-CURRENT-DATE            PIC X(10).                    
           05  WS-REV-INPUT-SET-DT        PIC X(10).                    
                                                                        
       01  WS-REV-FMT-S-DT.                                             
           05  WS-REV-FMT-S-YEAR          PIC X(04) VALUE SPACES.       
           05  WS-FILLER1                 PIC X(1)  VALUE '-'.          
           05  WS-REV-FMT-S-MTH           PIC X(02) VALUE SPACES.       
                                                                        
       01  WS-REV-FMT-E-DT.                                             
           05  WS-REV-FMT-E-YEAR          PIC X(04) VALUE SPACES.       
           05  WS-FILLER1                 PIC X(1)  VALUE '-'.          
           05  WS-REV-FMT-E-MTH           PIC X(02) VALUE SPACES.       
                                                                        
                                                                        
       01  WS-CONV-USAGE-STRT-TMSTMP.                                   
           05  WS-CONV-YEAR               PIC X(04) VALUE SPACES.       
           05  WS-CONV-MNTH               PIC X(02) VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS                PIC S9(9) COMP VALUE 0.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(9) COMP VALUE 0.       
           05  S-CODE-UTIL-TYPE           PIC X(01) VALUE SPACES.       
           05  S-IC-NO                    PIC S9(4) USAGE COMP VALUE 0. 
           05  S-CODE-USAGE-CLASS         PIC X(01) VALUE SPACES.       
           05  S-TIME-USAGE-ENDS          PIC X(08) VALUE SPACES.       
           05  S-REV-MNTH                 PIC X(06) VALUE SPACES.       
           05  S-INTV-USE-DATE            PIC X(92) VALUE SPACES.       
           05  S-REBILL-ROW-FOUND         PIC X(01) VALUE 'N'.          
      *                                                                 00861002
      *** GET INTERVAL USAGE DETAILS.                                   00862002
      *                                                                 00863002
           EXEC SQL                                                     
              DECLARE INTVUSE_CRSR CURSOR FOR                           
              SELECT CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CAST(USAGE_STRT_TMSTMP AS DATE)                            
                    ,CODE_USAGE_CLASS                                   
                    ,REPLACE(CONVERT(CHAR(8), TIME_USAGE_ENDS, 108), 
           ':', '.') TIME_USAGE_ENDS                                    
              FROM CSS_INTV_USE_CLASS IU WITH(READUNCOMMITTED)                  
              WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                         
              AND SUBSTRING(REPLACE(REPLACE(CONVERT(CHAR(26), 
           IU.USAGE_STRT_TMSTMP, 121), ' ', '-'), ':', '.'), 1, 7)             
                  BETWEEN :WS-REV-FMT-START-DT                          
                      AND :WS-REV-FMT-END-DT                            
             ORDER BY CAST(IU.USAGE_STRT_TMSTMP AS DATE)                        
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00864002
MFA-TR*       DECLARE INTVUSE_CRSR CURSOR FOR                           00865005
MFA-TR*       SELECT CODE_UTIL_TYPE                                     00866005
MFA-TR*             ,IC_NO                                              00867005
MFA-TR*             ,DATE(USAGE_STRT_TMSTMP)                            00867105
MFA-TR*             ,CODE_USAGE_CLASS                                   00868005
MFA-TR*             ,TIME_USAGE_ENDS                                    00868105
MFA-TR*       FROM CSS_INTV_USE_CLASS IU                                00869011
MFA-TR*       WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                         00869105
MFA-TR*       AND SUBSTR(CHAR(IU.USAGE_STRT_TMSTMP),1,7)                00869207
MFA-TR*           BETWEEN :WS-REV-FMT-START-DT                          00869307
MFA-TR*               AND :WS-REV-FMT-END-DT                            00869407
MFA-TR*      ORDER BY DATE(IU.USAGE_STRT_TMSTMP)                                
MFA-TR*      FOR FETCH ONLY WITH UR                                     00869611
MFA-TR*      QUERYNO 7050                                               00869702
MFA-TR*    END-EXEC.                                                    00869802
      *                                                                 00869902
      *** GET REV MTH FOR REBILLED THE ACCOUNT.                         00862002
      *                                                                 00863002
           EXEC SQL                                                     
               DECLARE CANCEL_REBILL_CUR CURSOR                         
                                         WITH ROWSET POSITIONING FOR    
                SELECT TOP(50) BG.REV_MTH_ORIG_BILL                             
                  FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                 WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO           
                   AND BG.BILL_NO            > :BG-BILL-NO              
                   AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       
                   AND BG.IC_NO              = :BG-IC-NO                
                   AND BG.CODE_BILL_ITM_TYPE <> :WS-BACKOUT             
                   AND BG.DATE_ORIG_BILL     IS NOT NULL                
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00864002
MFA-TR*        DECLARE CANCEL_REBILL_CUR CURSOR                         00865005
MFA-TR*                                  WITH ROWSET POSITIONING FOR    00865005
MFA-TR*         SELECT BG.REV_MTH_ORIG_BILL                             00866005
MFA-TR*           FROM CSS_BILLING_DET BG                               00869011
MFA-TR*          WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO           00869105
MFA-TR*            AND BG.BILL_NO            > :BG-BILL-NO              00869207
MFA-TR*            AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       00869207
MFA-TR*            AND BG.IC_NO              = :BG-IC-NO                00869207
MFA-TR*            AND BG.CODE_BILL_ITM_TYPE <> :WS-BACKOUT             00869207
MFA-TR*            AND BG.DATE_ORIG_BILL     IS NOT NULL                00869207
MFA-TR*         FETCH FIRST 50 ROWS ONLY WITH UR                        00869611
MFA-TR*         QUERYNO 7100                                            00869702
MFA-TR*    END-EXEC.                                                    00869802
       LINKAGE SECTION.                                                 
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO.                       
                                                                        
      ******************************************************************01100001
      * 0000-MAINLINE                                                  *01110001
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01120001
      ******************************************************************01130001
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01250001
      * 0100-INITIALIZE                                                *01260001
      *                                                                *01270001
      ******************************************************************01280001
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
      *                                                                 01320103
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01320403
      ******************************************************************01321003
      *  DECLARE GLOBAL TEMPORARY TABLE  - INTERVAL USAGE DETAILS      *01322003
      ******************************************************************01323003
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04830_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04830_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04830_R1
              (                                                    
                     RETURN_CODE              INT                   
                    ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                    ,IC_NO                    SMALLINT                  
                    ,CODE_USAGE_CLASS CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                    ,TIME_USAGE_ENDS CHAR(8)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                    ,REV_MNTH CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2          
                    ,INTV_USE_DATE CHAR(92)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,REBILL_ROW_FOUND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                              THRU  9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
                     WITH ROWSET POSITIONING FOR                        
             SELECT  RETURN_CODE                                        
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CODE_USAGE_CLASS                                   
                    ,TIME_USAGE_ENDS                                    
                    ,REV_MNTH                                           
                    ,INTV_USE_DATE                                      
                    ,REBILL_ROW_FOUND                                   
               FROM #CSR04830_R1                                 
               ORDER BY REV_MNTH DESC                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01334001
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                              01340005
MFA-TR*              WITH ROWSET POSITIONING FOR                        01341003
MFA-TR*      SELECT  RETURN_CODE                                        01350003
MFA-TR*             ,CODE_UTIL_TYPE                                     01361003
MFA-TR*             ,IC_NO                                              01362003
MFA-TR*             ,CODE_USAGE_CLASS                                   01363003
MFA-TR*             ,TIME_USAGE_ENDS                                    01364003
MFA-TR*             ,REV_MNTH                                           01365016
MFA-TR*             ,INTV_USE_DATE                                      01365103
MFA-TR*             ,REBILL_ROW_FOUND                                   01365103
MFA-TR*        FROM SESSION.CSR04830_R1                                 01366003
MFA-TR*        ORDER BY REV_MNTH DESC                                           
MFA-TR*    END-EXEC.                                                    01380001
      *                                                                 01390003
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 01430003
      ******************************************************************01440001
      * 1000-PROCESS-INPUT                                             *01450001
      *                                                                *01460001
      *     1. RECEIVE PARMS.                                          *01470001
      *                                                                *01480001
      ******************************************************************01490001
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO           TO WS-ACCOUNT-NO              
                                             AT-ACCOUNT-NO              
                                             BG-ACCOUNT-NO.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01600001
      * 2000-PROCESS-OUTPUT.                                           *01610001
      *                                                                *01620001
      *     1. DESCRIBE RESULT SET                                     *01630001
      *     2. UPDATE DB2 DATA                                         *01640001
      *     3. BUILD RESULT SET                                        *01650001
      *     4. SEND RESULT SET                                         *01660001
      *                                                                *01670001
      ******************************************************************01680001
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-ACCOUNT-NO                TO G6-PARM-DATA.           
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
           MOVE WS-COMPANY-NO                TO G6-COMPANY-NO.          
           MOVE WS-CMND-CODE                 TO G6-CMND-CODE.           
           PERFORM 7000-FIND-ACCOUNT-JOB-PARM  THRU 7000-EXIT.          
      ****IF THE ACCOUNT_NO IS NOT FOUND IN JOB_PARM PROGRAM WILL END           
      ****WITH RETURN CODE 100 ELSE PROCESS THE ACCOUNT.                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-NO                     TO S-REBILL-ROW-FOUND      
              PERFORM 2100-GET-START-END-DATE  THRU 2100-EXIT           
              PERFORM 2200-GET-INTV-USE-DETAIL THRU 2200-EXIT           
           END-IF.                                                      
      *                                                                 01751001
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01754001
      ******************************************************************01760001
      * 2100-GET-START-END-DATE                                        *01770002
      *                                                                *01780001
      *  1. GET THE START DATE.                                        *01790001
      *  2. GET THE END DATE.                                          *01800001
      *                                                                *01811001
      ******************************************************************01820001
                                                                        
       2100-GET-START-END-DATE.                                         
                                                                        
           PERFORM 7020-GET-ACCOUNT-DET       THRU 7020-EXIT.           
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND              
               AT-REV-MTH-LST-NRML   > 0                                
               MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MTH-HOLD         
               MOVE WS-REV-MTH-CHAR(1:4)     TO WS-REV-INPUT-YEAR       
               MOVE WS-REV-MTH-CHAR(5:2)     TO WS-REV-INPUT-MTH        
               MOVE WS-REV-INPUT-DT          TO WS-REV-INPUT-SET-DT     
           ELSE                                                         
               PERFORM 7010-SELECT-CURRENT-MONTH-DATE                   
                                              THRU 7010-EXIT            
               MOVE WS-CURRENT-DATE(1:4)     TO WS-REV-INPUT-YEAR       
               MOVE WS-CURRENT-DATE(6:2)     TO WS-REV-INPUT-MTH        
               MOVE WS-REV-INPUT-DT          TO WS-REV-INPUT-SET-DT     
           END-IF.                                                      
                                                                        
           PERFORM 7030-CALC-REV-MONTH        THRU 7030-EXIT.           
      *                                                                 01870001
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01900001
      ******************************************************************01910002
      * 2200-GET-INTV-USE-DETAIL                                       *01911002
      *                                                                *01912002
      *  1. GET OPEN MAIN CURSOR.                                      *01913002
      *  2. GET FETCH MAIN CURSOR UNTIL NO MORE ROWS.                  *01914002
      *  3. GET CLOSE MAIN CURSOR.                                     *01915002
      *                                                                *01916002
      ******************************************************************01917002
                                                                        
       2200-GET-INTV-USE-DETAIL.                                        
                                                                        
           PERFORM 7050-OPEN-INTV-CURSOR   THRU 7050-EXIT.              
                                                                        
           PERFORM 7060-FETCH-INTV-CURSOR  THRU 7060-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE IU-CODE-UTIL-TYPE         TO BG-CODE-UTIL-TYPE       
              MOVE IU-IC-NO                  TO BG-IC-NO                
              MOVE AT-LAST-NRML-BILL-NO      TO BG-BILL-NO              
              PERFORM 2500-GET-REBILL-DATA                              
                                              THRU 2500-EXIT            
              PERFORM 2300-PROCESS-INTV-REC   THRU 2300-EXIT            
                                    UNTIL WS-NO-ROWS = 'Y'              
                 AND WS-COMP-REV-START-MTH(1:7) = WS-REV-FMT-END-DT(1:7)
              PERFORM 7070-CLOSE-INTV-CURSOR  THRU 7070-EXIT            
              PERFORM 2400-PROCESS-OUTPUT     THRU 2400-EXIT            
           ELSE                                                         
              PERFORM 2450-POPULATE-DEFAULT-OUTPUT                      
                                              THRU 2450-EXIT            
              PERFORM 7070-CLOSE-INTV-CURSOR                            
                                              THRU 7070-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                 01920202
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01920502
      ******************************************************************01920602
      *  PROCESS THE INTERVAL USAGE RECORDS.                           *01920703
      *  2300-PROCESS-INTV-REC.                                        *        
      ******************************************************************01920802
       2300-PROCESS-INTV-REC.                                           
                                                                        
           IF IU-USAGE-STRT-TMSTMP(1:7) = WS-COMP-REV-START-MTH(1:7)    
              PERFORM 2350-PROCESS-DATE       THRU 2350-EXIT            
              PERFORM 7060-FETCH-INTV-CURSOR  THRU 7060-EXIT            
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'                    TO WS-NO-ROWS              
                 MOVE SPACES                 TO IU-USAGE-STRT-TMSTMP    
              END-IF                                                    
           ELSE                                                         
              PERFORM 2400-PROCESS-OUTPUT  THRU 2400-EXIT               
              PERFORM 7040-SET-COMP-DATE   THRU 7040-EXIT               
           END-IF.                                                      
      *                                                                 01922303
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01922703
      ******************************************************************01922803
      *  2350-PROCESS-DATE                                             *01922903
      ******************************************************************01923003
       2350-PROCESS-DATE.                                               
                                                                        
           IF WS-I < 92                                                 
           MOVE IU-USAGE-STRT-TMSTMP(9:2) TO WS-INTV-USE-DATE(WS-I:2)   
           ADD 2                          TO WS-I                       
           END-IF.                                                      
                                                                        
           IF WS-I < 92                                                 
           MOVE ','                       TO WS-INTV-USE-DATE(WS-I:1)   
           ADD 1                          TO WS-I                       
           END-IF.                                                      
      *                                                                 01924303
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01924603
      ******************************************************************01924703
      *  2400-PROCESS-OUTPUT                                           *01924803
      ******************************************************************01924903
       2400-PROCESS-OUTPUT.                                             
                                                                        
           MOVE IU-CODE-UTIL-TYPE         TO S-CODE-UTIL-TYPE           
           MOVE IU-IC-NO                  TO S-IC-NO                    
           MOVE IU-CODE-USAGE-CLASS       TO S-CODE-USAGE-CLASS         
           MOVE IU-TIME-USAGE-ENDS        TO S-TIME-USAGE-ENDS          
           MOVE WS-COMP-REV-START-MTH(1:4)TO WS-CONV-YEAR               
           MOVE WS-COMP-REV-START-MTH(6:2)TO WS-CONV-MNTH               
           MOVE WS-CONV-USAGE-STRT-TMSTMP TO S-REV-MNTH                 
           INSPECT WS-INTV-USE-DATE REPLACING ALL ', ' BY '  '          
           MOVE WS-INTV-USE-DATE          TO S-INTV-USE-DATE            
                                                                        
           PERFORM 2550-MOVE-REBILL-DATA   THRU 2550-EXIT               
                                                                        
           PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT               
           INITIALIZE WS-INTV-USE-DATE.                                 
           MOVE 1                         TO WS-I.                      
           MOVE WS-NO                     TO S-REBILL-ROW-FOUND.        
      *                                                                 01926903
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01927203
      ******************************************************************01924703
      *  2450-POPULATE-DEFAULT-OUTPUT.                                 *01924803
      ******************************************************************01924903
       2450-POPULATE-DEFAULT-OUTPUT.                                    
                                                                        
           MOVE WS-IC-NO                     TO S-IC-NO.                
           MOVE WS-CODE-UTIL-TYPE            TO S-CODE-UTIL-TYPE.       
           MOVE WS-CODE-USAGE-CLASS          TO S-CODE-USAGE-CLASS.     
           MOVE WS-TIME-USAGE-ENDS           TO S-TIME-USAGE-ENDS.      
      **** POPULATE CURRENT DATE FOR NEW CUSTOMER                               
           IF AT-REV-MTH-LST-NRML <= 0                                  
              MOVE WS-CURRENT-DATE           TO WS-COMP-REV-START-MTH   
              MOVE WS-COMP-REV-START-MTH(1:4)                           
                                             TO WS-CONV-YEAR            
              MOVE WS-COMP-REV-START-MTH(6:2)                           
                                             TO WS-CONV-MNTH            
              MOVE WS-CONV-USAGE-STRT-TMSTMP TO S-REV-MNTH              
      **** IF ACCOUNT NOT FOUND IN INTV_USE_CLASS TABLE BUT FOUND IN            
      **** JOB_PARM THEN POPULATE LATEST REVENUE MONTH +1 IN THE OUTPUT         
           ELSE                                                         
              MOVE WS-REV-FMT-END-DT         TO WS-COMP-REV-START-MTH   
              MOVE WS-COMP-REV-START-MTH(1:4)                           
                                             TO WS-CONV-YEAR            
              MOVE WS-COMP-REV-START-MTH(6:2)                           
                                             TO WS-CONV-MNTH            
              MOVE WS-CONV-USAGE-STRT-TMSTMP TO S-REV-MNTH              
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
      *                                                                 01926903
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01927203
      ******************************************************************01924703
      *  2500-GET-REBILL-DATA.                                         *01924803
      ******************************************************************01924903
       2500-GET-REBILL-DATA.                                            
                                                                        
           PERFORM 7100-OPEN-CANCEL-REBILL-CUR                          
                                              THRU 7100-EXIT.           
                                                                        
           PERFORM 7200-FETCH-CANCEL-REBILL-CUR                         
                                              THRU 7200-EXIT.           
                                                                        
           PERFORM 7300-CLOSE-CANCEL-REBILL-CUR                         
                                              THRU 7300-EXIT.           
      *                                                                 01926903
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01927203
      ******************************************************************01924703
      *  2550-MOVE-REBILL-DATA.                                        *01924803
      ******************************************************************01924903
       2550-MOVE-REBILL-DATA.                                           
                                                                        
           SET WS-REV-MTH-INDX                TO WS-ONE.                
           PERFORM VARYING WS-REV-MTH-INDX FROM 1 BY 1                  
                   UNTIL WS-REV-MTH-INDX > WS-REV-MTH-ROW-COUNT         
                                                                        
              MOVE WS-REV-MTH-ORIG-BILL(WS-REV-MTH-INDX)                
                                             TO WS-REV-MTH-ORIG-NUM     
              IF WS-REV-MTH-ORIG-NUM  = S-REV-MNTH                      
                 MOVE WS-YES                 TO S-REBILL-ROW-FOUND      
              END-IF                                                    
                                                                        
           END-PERFORM.                                                 
      *                                                                 01926903
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01927203
      ******************************************************************        
      * 7000-FIND-ACCOUNT-JOB-PARM.                                    *        
      ******************************************************************        
       7000-FIND-ACCOUNT-JOB-PARM.                                      
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-ACCOUNT-FOUND                                
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PARM_DATA    = :G6-PARM-DATA                  
                   AND G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ACCOUNT-FOUND                                        
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PARM_DATA    = :G6-PARM-DATA                          
MFA-TR*            AND G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
              MOVE 'PARM_DATA'               TO TABLE-ELEMENT-1         
              MOVE G6-PARM-DATA              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-CURRENT-MONTH-DATE.                                *        
      ******************************************************************        
       7010-SELECT-CURRENT-MONTH-DATE.                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-GET-ACCOUNT-DET.                                          *        
      ******************************************************************        
       7020-GET-ACCOUNT-DET.                                            
                                                                        
           EXEC SQL                                                     
                SELECT AT.LAST_NRML_BILL_NO                             
                      ,AT.REV_MTH_LST_NRML                              
                  INTO :AT-LAST-NRML-BILL-NO                            
                      ,:AT-REV-MTH-LST-NRML                             
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AT.LAST_NRML_BILL_NO                                     
MFA-TR*               ,AT.REV_MTH_LST_NRML                                      
MFA-TR*           INTO :AT-LAST-NRML-BILL-NO                                    
MFA-TR*               ,:AT-REV-MTH-LST-NRML                                     
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 02340001
      * 7030-CALC-REV-MONTH                                             02350001
      ***************************************************************** 02360001
                                                                        
       7030-CALC-REV-MONTH.                                             
                                                                        
           EXEC SQL                                                     
              SELECT
              (DATEADD( MONTH, -5, (DATEADD( MONTH, 1, 
              IIF(TRY_CONVERT(DATE, :WS-REV-INPUT-SET-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-INPUT-SET-DT
              ) <> 0) OR (LEN(:WS-REV-INPUT-SET-DT
              ) <> 10), CIS.CHAR2DATE(:WS-REV-INPUT-SET-DT
              ), CONVERT(DATE, :WS-REV-INPUT-SET-DT) ) )) )),
              (DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-REV-INPUT-SET-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-INPUT-SET-DT
              ) <> 0) OR (LEN(:WS-REV-INPUT-SET-DT
              ) <> 10), CIS.CHAR2DATE(:WS-REV-INPUT-SET-DT
              ), CONVERT(DATE, :WS-REV-INPUT-SET-DT) ) ))
            INTO
              :WS-REV-START-DATE,
              :WS-REV-END-DATE               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     02400003
MFA-TR*       SET :WS-REV-START-DATE                                    02410003
MFA-TR*           =((DATE(:WS-REV-INPUT-SET-DT) + 1 MONTH) - 5 MONTH)   02420012
MFA-TR*          ,:WS-REV-END-DATE                                      02430003
MFA-TR*           =(DATE(:WS-REV-INPUT-SET-DT) + 1 MONTH)               02440012
MFA-TR*    END-EXEC.                                                    02460003

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF  WS-ACTIVE-RETURN-CODE        EQUAL SUCCESSFUL-CALL       
               MOVE WS-REV-START-DATE(1:4) TO WS-REV-FMT-S-YEAR         
               MOVE WS-REV-START-DATE(6:2) TO WS-REV-FMT-S-MTH          
               MOVE WS-REV-FMT-S-DT        TO WS-REV-FMT-START-DT       
               MOVE WS-REV-START-DATE      TO WS-COMP-REV-START-MTH     
               MOVE WS-REV-END-DATE(1:4)   TO WS-REV-FMT-E-YEAR         
               MOVE WS-REV-END-DATE(6:2)   TO WS-REV-FMT-E-MTH          
               MOVE WS-REV-FMT-E-DT        TO WS-REV-FMT-END-DT         
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7030'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SET'                  TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE SPACES                 TO TABLE-1                   
               MOVE 'WS-REV-INPUT-DT'      TO TABLE-ELEMENT-1           
               MOVE WS-REV-INPUT-DT        TO HOSTVAR-ELEMENT-1         
               MOVE 'WS-REV-START-DATE'    TO TABLE-ELEMENT-1           
               MOVE WS-REV-START-DATE      TO HOSTVAR-ELEMENT-1         
               MOVE 'WS-REV-END-DATE'      TO TABLE-ELEMENT-1           
               MOVE WS-REV-END-DATE        TO HOSTVAR-ELEMENT-1         
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 02641003
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02670003
      ***************************************************************** 02680003
      * 7040-SET-COMP-DATE                                              02690003
      ***************************************************************** 02700003
       7040-SET-COMP-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                 :WS-COMP-REV-START-MTH
              ) IS NULL OR (PATINDEX('%.%', :WS-COMP-REV-START-MTH
              ) <> 0) OR (LEN(:WS-COMP-REV-START-MTH
              ) <> 10), CIS.CHAR2DATE(:WS-COMP-REV-START-MTH
              ), CONVERT(DATE, :WS-COMP-REV-START-MTH) ) )
            INTO
              :WS-COMP-REV-START-MTH            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     02740003
MFA-TR*       SET :WS-COMP-REV-START-MTH                                02750016
MFA-TR*            =(DATE(:WS-COMP-REV-START-MTH) + 1 MONTH)            02760016
MFA-TR*    END-EXEC.                                                    02790003

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF  WS-ACTIVE-RETURN-CODE        EQUAL SUCCESSFUL-CALL       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7040'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE SPACES                  TO TABLE-1                  
               MOVE 'WS-COMP-REV-START-MTH' TO TABLE-ELEMENT-1          
               MOVE WS-COMP-REV-START-MTH   TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 03031003
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03031003
      ******************************************************************01927403
      *  OPENS THE CURSOR DECLARED FOR GETTING INTERVAL USAGE DETAILS  *01927503
      *  7050-OPEN-INTV-CURSOR.                                        *        
      ******************************************************************01927603
       7050-OPEN-INTV-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN INTVUSE_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE            
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_INTV_USE_CLASS'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 01929903
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                 01930203
      ******************************************************************01930303
      *  FETCHES THE CURSOR DECLARED FOR GETTING THE INTERVAL DETAILS  *01930403
      *  7060-FETCH-INTV-CURSOR.                                       *        
      ******************************************************************01930503
       7060-FETCH-INTV-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH INTVUSE_CRSR                                       
               INTO   :IU-CODE-UTIL-TYPE                                
                     ,:IU-IC-NO                                         
                     ,:IU-USAGE-STRT-TMSTMP                             
                     ,:IU-CODE-USAGE-CLASS                              
                     ,:IU-TIME-USAGE-ENDS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE            
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7060'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_INTV_USE_CLASS'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE IU-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE IU-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'USAGE_STRT_TMSTMP'     TO TABLE-ELEMENT-4          
               MOVE IU-USAGE-STRT-TMSTMP    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 01934303
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                 01934603
      ******************************************************************01934703
      *  CLOSES THE CURSOR DECLARED FOR GETTING THE METER READ DETAILS *01934803
      *  7070-CLOSE-INTV-CURSOR.                                       *        
      ******************************************************************01934903
       7070-CLOSE-INTV-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE INTVUSE_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE            
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7070'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_INTV_USE_CLASS'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE IU-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE IU-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'USAGE_STRT_TMSTMP'     TO TABLE-ELEMENT-4          
               MOVE IU-USAGE-STRT-TMSTMP    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 01938203
       7070-EXIT.                                                       
            EXIT.                                                       
      *                                                                 01938503
      ******************************************************************        
      * 7100-OPEN-CANCEL-REBILL-CUR.                                   *        
      ******************************************************************        
       7100-OPEN-CANCEL-REBILL-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
               OPEN CANCEL_REBILL_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-1       
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-CANCEL-REBILL-CUR.                                  *        
      ******************************************************************        
       7200-FETCH-CANCEL-REBILL-CUR.                                    

MSQ008     MOVE 50 TO MSQ008-CANCEL-REBILL-CUR
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-CANCEL-REBILL-CUR
              FETCH 
              FROM CANCEL_REBILL_CUR      
                   INTO :WS-REV-MTH-ORIG-BILL                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM CANCEL_REBILL_CUR FOR 50 ROWS             
MFA-TR*            INTO :WS-REV-MTH-ORIG-BILL                                   
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CANCEL-REBILL-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)                TO WS-REV-MTH-ROW-COUNT    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-1       
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-CANCEL-REBILL-CUR.                                  *        
      ******************************************************************        
       7300-CLOSE-CANCEL-REBILL-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
               CLOSE CANCEL_REBILL_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-1       
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************01938703
      *  DELETE SESSION TABLE - INITIAL                                *01938803
      ******************************************************************01938903
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04830_R1                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    01939203
MFA-TR*         DELETE                                                  01939303
MFA-TR*           FROM SESSION.CSR04830_R1                              01939403
MFA-TR*     END-EXEC.                                                   01939503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE 'CSR04830_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************01941703
      * 8010-INSERT-GTT-R1.  METER READ HISTORY DATA                   *01941803
      ******************************************************************01941903
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04830_R1                            
             (                                                          
              RETURN_CODE                                               
             ,CODE_UTIL_TYPE                                            
             ,IC_NO                                                     
             ,CODE_USAGE_CLASS                                          
             ,TIME_USAGE_ENDS                                           
             ,REV_MNTH                                                  
             ,INTV_USE_DATE                                             
             ,REBILL_ROW_FOUND                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-CODE-UTIL-TYPE                                         
             ,:S-IC-NO                                                  
             ,:S-CODE-USAGE-CLASS                                       
             ,:S-TIME-USAGE-ENDS                                        
             ,:S-REV-MNTH                                               
             ,:S-INTV-USE-DATE                                          
             ,:S-REBILL-ROW-FOUND                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01942203
MFA-TR*      INSERT INTO SESSION.CSR04830_R1                            01942303
MFA-TR*      (                                                          01942403
MFA-TR*       RETURN_CODE                                               01942503
MFA-TR*      ,CODE_UTIL_TYPE                                            01942603
MFA-TR*      ,IC_NO                                                     01942703
MFA-TR*      ,CODE_USAGE_CLASS                                          01942803
MFA-TR*      ,TIME_USAGE_ENDS                                           01942903
MFA-TR*      ,REV_MNTH                                                  01943003
MFA-TR*      ,INTV_USE_DATE                                             01943103
MFA-TR*      ,REBILL_ROW_FOUND                                          01943103
MFA-TR*      )                                                          01943203
MFA-TR*      VALUES                                                     01943303
MFA-TR*      (                                                          01943403
MFA-TR*       :S-RETURN-CODE                                            01943503
MFA-TR*      ,:S-CODE-UTIL-TYPE                                         01943603
MFA-TR*      ,:S-IC-NO                                                  01943703
MFA-TR*      ,:S-CODE-USAGE-CLASS                                       01943803
MFA-TR*      ,:S-TIME-USAGE-ENDS                                        01943903
MFA-TR*      ,:S-REV-MNTH                                               01944003
MFA-TR*      ,:S-INTV-USE-DATE                                          01944103
MFA-TR*      ,:S-REBILL-ROW-FOUND                                       01944103
MFA-TR*      )                                                          01944203
MFA-TR*    END-EXEC.                                                    01944303

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS              
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04830_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 01945903
       8010-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03060003
      ***************************************************************** 03070003
      * 8800-CHECK-RESULTS.                                           * 03080003
      ***************************************************************** 03090003
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS <= 0                                          
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                      TO S-RETURN-CODE            
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
      *                                                                 03180003
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03210003
      ***************************************************************** 03220003
      * 8900-SEND-DONE.                                               * 03230003
      ***************************************************************** 03240003
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04830_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE.          
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1       THRU 0100A-EXIT.          
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03325003
      * 9999-END-PROGRAM.                                             * 03330003
      ***************************************************************** 03340003
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
