       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04827.                                        
       AUTHOR.         HA7A338.                                         
COB303 DATE-WRITTEN.   JAN 23, 2015.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  #  INVOKED FROM CIS MODERNIZATION POWER PLANT ACCOUNTING.     *        
      *  #  BUSOP - GETLIGHTSERVICEORDERDTLS                           *        
      *  #  RETRIEVES LIGHT SERVICE ORDER DETAILS WITH WORK TYPE LLD.  *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             I_TIMESTAMP  CHAR(26)                              *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  ------------------                                            *        
      *             RETURN_CODE                                        *        
      *             SERV_ORDER_NO                                      *        
      *             ACCOUNT_NO                                         *        
      *             WORK_AREA_ID                                       *        
      *             TOWN                                               *        
      *             STATE                                              *        
      *             COUNTY                                             *        
      *             COUNTY_DESC                                        *        
      *             MATL_ITEM_CD                                       *        
      *             MATL_ITEM_QT                                       *        
      *             MATL_ITEM_TOT_AM                                   *        
      *             UOM_CD                                             *        
      *             MATL_USAGE_CD                                      *        
      *             DATE_RECVED                                        *        
      *             COMPLETED_DATETIME                                 *        
      *             SUBSTATION_ID                                      *        
      *             CIRCUIT_ID                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS    COMMENTS                                *        
      *  --------  --------    ----------------------------            *        
      *  01/23/15   HA7A338    NEW PROGRAM                             *        
      *                                                                *        
A#5371*  09/09/15   SS95855    USE NEW TABLE LMS_CU_CD_MAP INSTEAD OF  *        
      *                        JOB PARM.SEND THE SCRAPPED MATERIAL ITEM*        
      *                        ROW IN ADDTION TO INSTALLED ONE. CREATE *        
      *                        WQ IF NO MATCH FOUND.                   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04827'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04827 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_DATA        VO                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT   MN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PIM_POINT      PP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_ORDER_INST  VI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SOMATL_PROCESS TN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOPROC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PREMISE        PR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ADDR_FORMATTED DY                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ZIP_CODE       A4                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_STATE_COUNTY   SC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSTCNTY                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
A#5371*    LMS_CU_CD_MAP      4X                                       *        
      ******************************************************************        
           EXEC SQL                                                             
A#5371        INCLUDE TBLMSMAP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04827'.      
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-SCRAPPED             PIC X(01) VALUE 'S'.             
           05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
           05  WS-ONE                  PIC 9(01) VALUE 1.               
           05  GTT-NAME                PIC X(26)                        
                                            VALUE 'SESSION.CSR04827_R1'.
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  MISC-FIELD.                                                  
           05  RS-RETURN-CODE          PIC S9(9) VALUE 0 COMP.          
           05  WS-TIMESTAMP            PIC X(26) VALUE SPACES.          
A#5317     05  WS-MATL-CU-CD           PIC X(15) VALUE SPACES.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09)  VALUE 0 COMP.        
           05  S1-SERV-ORDER-NO        PIC S9(13)V VALUE 0 COMP-3.      
           05  S1-ACCOUNT-NO           PIC S9(13)V VALUE 0 COMP-3.      
           05  S1-WORK-AREA-ID         PIC X(12)   VALUE SPACES.        
           05  S1-TOWN                 PIC X(26)   VALUE SPACES.        
           05  S1-STATE                PIC X(02)   VALUE SPACES.        
           05  S1-COUNTY               PIC X(03)   VALUE SPACES.        
           05  S1-COUNTY-DESC          PIC X(22)   VALUE SPACES.        
           05  S1-MATL-ITEM-CD         PIC X(12)   VALUE SPACES.        
           05  S1-MATL-ITEM-QT         PIC S9(09)  VALUE 0 COMP.        
           05  S1-MATL-ITEM-TOT-AM     PIC S9(07)V9(2)                  
                                                   VALUE 0 COMP-3.      
           05  S1-UOM-CD               PIC X(03)   VALUE SPACES.        
           05  S1-MATL-USAGE-CD        PIC X(01)   VALUE SPACES.        
           05  S1-DATE-RECVED          PIC X(26)   VALUE SPACES.        
           05  S1-COMPLETED-DATETIME   PIC X(26)   VALUE SPACES.        
           05  S1-SUBSTATION-ID        PIC X(05)   VALUE SPACES.        
           05  S1-CIRCUIT-ID           PIC X(05)   VALUE SPACES.        
A#5371     05  S1-MATL-CU-CD           PIC X(15)   VALUE SPACES.        
A#5371     05  S1-USER-ID-CPTD-BY      PIC X(07)   VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
           05  WS-MATCH-FOUND          PIC X(01) VALUE 'N'.             
               88 NO-MATCH-FOUND                 VALUE 'N'.             
               88 MATCH-FOUND                    VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    CURSOR TO FETCH LIGHT MNT-ELEC SERVICE ORDER DETAILS WITH   *        
      *    WORK TYPE "REPLACEMENT LIGHT DIFFERENT" LLD                 *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE SO_LGHT_CUR CURSOR FOR                           
                SELECT  DISTINCT                                        
                        VO.SERV_ORDER_NO                                
                       ,VO.ACCOUNT_NO                                   
                       ,VO.WORK_AREA_ID                                 
                       ,A4.TOWN                                         
                       ,A4.STATE                                        
                       ,PR.COUNTY                                       
                       ,SC.COUNTY_DESC                                  
                       ,TN.MATL_ITEM_CD                                 
                       ,TN.MATL_ITEM_QT                                 
                       ,TN.MATL_ITEM_TOT_AM                             
                       ,TN.UOM_CD                                       
                       ,TN.MATL_USAGE_CD                                
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), VO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED                            
A#5371                 ,VO.USER_ID_CPTD_BY                              
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                           
                       ,COALESCE(PP.SUBSTATION_ID,' ')                  
                       ,COALESCE(PP.CIRCUIT_ID,   ' ')                  
                  FROM CSS_SO_DATA        VO WITH(READUNCOMMITTED)              
                  LEFT OUTER JOIN                                       
                       CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)              
                    ON MN.ACCOUNT_NO         = VO.ACCOUNT_NO            
                   AND MN.CODE_UTIL_TYPE     = 'E'                      
                   AND MN.CODE_METER_STATUS <> 'K'                      
                  LEFT OUTER JOIN                                       
                       CSS_PIM_POINT      PP WITH(READUNCOMMITTED)              
                    ON MN.GIS_POINT_ID       = PP.POINT_ID              
                      ,CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)              
                      ,CSS_SOMATL_PROCESS TN WITH(READUNCOMMITTED)              
                      ,CSS_PREMISE        PR WITH(READUNCOMMITTED)              
                      ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                      ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)              
                      ,CSS_STATE_COUNTY   SC WITH(READUNCOMMITTED)              
                  WHERE  VO.COMPLETED_DATETIME > CIS.CHAR2TIMESTAMP(
                                                 :VO-COMPLETED-DATETIME
              ) 
                    AND  VO.ORDER_TYPE_CD      = 'FW003'                
                    AND  VO.ORDER_STATE_CD     = 'Z'                    
                    AND  VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO       
                    AND  VI.WORK_TYPE_CD       = 'LLD'                  
                    AND  VO.SERV_ORDER_NO      = TN.SERV_ORDER_NO       
                    AND  VO.PREMISE_NO         = PR.PREMISE_NO          
                    AND  DY.ADDRESS_ID         = PR.ADDRESS_ID          
                    AND  DY.ZIP_CODE           = A4.ZIP_CODE            
                    AND  DY.ZIP_CODE_TOKEN     = A4.ZIP_CODE_TOKEN      
                    AND  SC.STATE              = A4.STATE               
                    AND  SC.COUNTY             = PR.COUNTY              
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_LGHT_CUR CURSOR FOR                                   
MFA-TR*         SELECT  DISTINCT                                                
MFA-TR*                 VO.SERV_ORDER_NO                                        
MFA-TR*                ,VO.ACCOUNT_NO                                           
MFA-TR*                ,VO.WORK_AREA_ID                                         
MFA-TR*                ,A4.TOWN                                                 
MFA-TR*                ,A4.STATE                                                
MFA-TR*                ,PR.COUNTY                                               
MFA-TR*                ,SC.COUNTY_DESC                                          
MFA-TR*                ,TN.MATL_ITEM_CD                                         
MFA-TR*                ,TN.MATL_ITEM_QT                                         
MFA-TR*                ,TN.MATL_ITEM_TOT_AM                                     
MFA-TR*                ,TN.UOM_CD                                               
MFA-TR*                ,TN.MATL_USAGE_CD                                        
MFA-TR*                ,VO.DATE_RECVED                                          
MFA-TR*                ,VO.USER_ID_CPTD_BY                                      
MFA-TR*                ,VO.COMPLETED_DATETIME                                   
MFA-TR*                ,COALESCE(PP.SUBSTATION_ID,' ')                          
MFA-TR*                ,COALESCE(PP.CIRCUIT_ID,   ' ')                          
MFA-TR*           FROM CSS_SO_DATA        VO                                    
MFA-TR*           LEFT OUTER JOIN                                               
MFA-TR*                CSS_MTRD_ENVRNMT   MN                                    
MFA-TR*             ON MN.ACCOUNT_NO         = VO.ACCOUNT_NO                    
MFA-TR*            AND MN.CODE_UTIL_TYPE     = 'E'                              
MFA-TR*            AND MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*           LEFT OUTER JOIN                                               
MFA-TR*                CSS_PIM_POINT      PP                                    
MFA-TR*             ON MN.GIS_POINT_ID       = PP.POINT_ID                      
MFA-TR*               ,CSS_SO_ORDER_INST  VI                                    
MFA-TR*               ,CSS_SOMATL_PROCESS TN                                    
MFA-TR*               ,CSS_PREMISE        PR                                    
MFA-TR*               ,CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_ZIP_CODE       A4                                    
MFA-TR*               ,CSS_STATE_COUNTY   SC                                    
MFA-TR*           WHERE  VO.COMPLETED_DATETIME > :VO-COMPLETED-DATETIME         
MFA-TR*             AND  VO.ORDER_TYPE_CD      = 'FW003'                        
MFA-TR*             AND  VO.ORDER_STATE_CD     = 'Z'                            
MFA-TR*             AND  VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO               
MFA-TR*             AND  VI.WORK_TYPE_CD       = 'LLD'                          
MFA-TR*             AND  VO.SERV_ORDER_NO      = TN.SERV_ORDER_NO               
MFA-TR*             AND  VO.PREMISE_NO         = PR.PREMISE_NO                  
MFA-TR*             AND  DY.ADDRESS_ID         = PR.ADDRESS_ID                  
MFA-TR*             AND  DY.ZIP_CODE           = A4.ZIP_CODE                    
MFA-TR*             AND  DY.ZIP_CODE_TOKEN     = A4.ZIP_CODE_TOKEN              
MFA-TR*             AND  SC.STATE              = A4.STATE                       
MFA-TR*             AND  SC.COUNTY             = PR.COUNTY                      
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-TIMESTAMP              PIC X(26).                       
                                                                        
       PROCEDURE DIVISION  USING PARM-TIMESTAMP.                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04827_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04827_R1
              (                                                        
                 RETURN_CODE                INT                     
                ,SERV_ORDER_NO              DECIMAL(13)                 
                ,ACCOUNT_NO                 DECIMAL(13)                 
                ,WORK_AREA_ID CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                 
                ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2                
                ,COUNTY CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2               
                ,COUNTY_DESC CHAR(22)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,MATL_ITEM_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,MATL_ITEM_QT               INT                     
                ,MATL_ITEM_TOT_AM           DECIMAL(7,2)                
                ,UOM_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2               
                ,MATL_USAGE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,DATE_RECVED CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,COMPLETED_DATETIME CHAR(26)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,SUBSTATION_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,CIRCUIT_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
A#5371          ,MATL_CU_CD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2           
A#5371          ,USER_ID_CPTD_BY CHAR(07)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT RETURN_CODE               AS RETURN_CODE          
                     ,SERV_ORDER_NO             AS SERV_ORDER_NO        
                     ,ACCOUNT_NO                AS ACCOUNT_NO           
                     ,LTRIM(RTRIM(WORK_AREA_ID))       AS WORK_AREA_ID         
                     ,LTRIM(RTRIM(TOWN))               AS TOWN                 
                     ,LTRIM(RTRIM(STATE))              AS STATE                
                     ,LTRIM(RTRIM(COUNTY))             AS COUNTY               
                     ,LTRIM(RTRIM(COUNTY_DESC))        AS COUNTY_DESC          
                     ,LTRIM(RTRIM(MATL_ITEM_CD))       AS MATL_ITEM_CD         
                     ,MATL_ITEM_QT              AS MATL_ITEM_QT         
                     ,MATL_ITEM_TOT_AM          AS MATL_ITEM_TOT_AM     
                     ,LTRIM(RTRIM(UOM_CD))             AS UOM_CD               
                     ,LTRIM(RTRIM(MATL_USAGE_CD))      AS MATL_USAGE_CD        
                     ,LTRIM(RTRIM(DATE_RECVED))        AS DATE_RECVED          
                     ,LTRIM(RTRIM(COMPLETED_DATETIME)) AS 
           COMPLETED_DATETIME   
                     ,LTRIM(RTRIM(SUBSTATION_ID))      AS SUBSTATION_ID        
                     ,LTRIM(RTRIM(CIRCUIT_ID))         AS CIRCUIT_ID           
A#5371               ,LTRIM(RTRIM(MATL_CU_CD))         AS MATL_CU_CD           
A#5371               ,USER_ID_CPTD_BY           AS USER_ID_CPTD_BY      
               FROM #CSR04827_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT RETURN_CODE               AS RETURN_CODE                  
MFA-TR*              ,SERV_ORDER_NO             AS SERV_ORDER_NO                
MFA-TR*              ,ACCOUNT_NO                AS ACCOUNT_NO                   
MFA-TR*              ,STRIP(WORK_AREA_ID)       AS WORK_AREA_ID                 
MFA-TR*              ,STRIP(TOWN)               AS TOWN                         
MFA-TR*              ,STRIP(STATE)              AS STATE                        
MFA-TR*              ,STRIP(COUNTY)             AS COUNTY                       
MFA-TR*              ,STRIP(COUNTY_DESC)        AS COUNTY_DESC                  
MFA-TR*              ,STRIP(MATL_ITEM_CD)       AS MATL_ITEM_CD                 
MFA-TR*              ,MATL_ITEM_QT              AS MATL_ITEM_QT                 
MFA-TR*              ,MATL_ITEM_TOT_AM          AS MATL_ITEM_TOT_AM             
MFA-TR*              ,STRIP(UOM_CD)             AS UOM_CD                       
MFA-TR*              ,STRIP(MATL_USAGE_CD)      AS MATL_USAGE_CD                
MFA-TR*              ,STRIP(DATE_RECVED)        AS DATE_RECVED                  
MFA-TR*              ,STRIP(COMPLETED_DATETIME) AS COMPLETED_DATETIME           
MFA-TR*              ,STRIP(SUBSTATION_ID)      AS SUBSTATION_ID                
MFA-TR*              ,STRIP(CIRCUIT_ID)         AS CIRCUIT_ID                   
MFA-TR*              ,STRIP(MATL_CU_CD)         AS MATL_CU_CD                   
MFA-TR*              ,USER_ID_CPTD_BY           AS USER_ID_CPTD_BY              
MFA-TR*        FROM SESSION.CSR04827_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-TIMESTAMP              TO WS-TIMESTAMP             
                                               VO-COMPLETED-DATETIME.   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-OPEN-SO-LIGHT-CUR      THRU 7100-EXIT           
           PERFORM 7200-FETCH-SO-LIGHT-CUR     THRU 7200-EXIT           
           PERFORM 2100-SO-LIGHT-PROCESS       THRU 2100-EXIT           
             UNTIL NO-MORE-ROWS                                         
           PERFORM 7300-CLOSE-SO-LIGHT-CUR     THRU 7300-EXIT           
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                      TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-SO-LIGHT-PROCESS.                                   *              
      ******************************************************************        
       2100-SO-LIGHT-PROCESS.                                           
                                                                        
A#5371     INITIALIZE DCLLMS-CU-CD-MAP                                  
A#5371                WS-MATL-CU-CD.                                    
A#5371                                                                  
A#5371     MOVE TN-MATL-ITEM-CD             TO 4X-INSTL-MATL-ITEM-CD.   
A#5371     PERFORM 7400-GET-CU-CD-MAPPING      THRU 7400-EXIT.          
A#5371                                                                  
A#5371     EVALUATE TRUE                                                
A#5371       WHEN (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND         
A#5371            (4X-INSTL-MATL-CU-CD = 'NOMAPPING' OR 'NO MAPPING')   
A#5371         CONTINUE                                                 
A#5371       WHEN  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
A#5371         MOVE 4X-INSTL-MATL-CU-CD     TO WS-MATL-CU-CD            
A#5371         PERFORM 2200-MOVE-RESULT        THRU 2200-EXIT           
A#5371         INITIALIZE TN-MATL-USAGE-CD                              
A#5371                    TN-MATL-ITEM-CD                               
A#5371                    WS-MATL-CU-CD                                 
A#5371         MOVE WS-SCRAPPED             TO TN-MATL-USAGE-CD         
A#5371         MOVE 4X-SCRAP-MATL-ITEM-CD   TO TN-MATL-ITEM-CD          
A#5371         MOVE 4X-SCRAP-MATL-CU-CD     TO WS-MATL-CU-CD            
A#5371         PERFORM 2200-MOVE-RESULT        THRU 2200-EXIT           
A#5371*** WQ IN CASE OF OTHER SCENARIO                                          
A#5371       WHEN OTHER                                                 
A#5371         CONTINUE                                                 
A#5371     END-EVALUATE.                                                
                                                                        
           PERFORM 7200-FETCH-SO-LIGHT-CUR     THRU 7200-EXIT.          
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-MOVE-RESULT.                                        *              
      ******************************************************************        
       2200-MOVE-RESULT.                                                
                                                                        
           MOVE VO-SERV-ORDER-NO            TO S1-SERV-ORDER-NO.        
           MOVE VO-ACCOUNT-NO               TO S1-ACCOUNT-NO.           
           MOVE VO-WORK-AREA-ID             TO S1-WORK-AREA-ID.         
           MOVE A4-TOWN                     TO S1-TOWN.                 
           MOVE A4-STATE                    TO S1-STATE.                
           MOVE PR-COUNTY                   TO S1-COUNTY.               
           MOVE SC-COUNTY-DESC              TO S1-COUNTY-DESC.          
           MOVE TN-MATL-ITEM-CD             TO S1-MATL-ITEM-CD.         
           MOVE TN-MATL-ITEM-QT             TO S1-MATL-ITEM-QT.         
           MOVE TN-MATL-ITEM-TOT-AM         TO S1-MATL-ITEM-TOT-AM.     
           MOVE TN-UOM-CD                   TO S1-UOM-CD.               
           MOVE TN-MATL-USAGE-CD            TO S1-MATL-USAGE-CD.        
           MOVE VO-DATE-RECVED              TO S1-DATE-RECVED.          
           MOVE VO-COMPLETED-DATETIME       TO S1-COMPLETED-DATETIME.   
           MOVE PP-SUBSTATION-ID            TO S1-SUBSTATION-ID.        
           MOVE PP-CIRCUIT-ID               TO S1-CIRCUIT-ID.           
A#5371     MOVE WS-MATL-CU-CD               TO S1-MATL-CU-CD.           
A#5371     MOVE VO-USER-ID-CPTD-BY          TO S1-USER-ID-CPTD-BY       
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SO-LIGHT-CUR.                                             *        
      ******************************************************************        
       7100-OPEN-SO-LIGHT-CUR.                                          
                                                                        
           EXEC SQL                                                     
              OPEN SO_LGHT_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DATA'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-FETCH-SO-LIGHT-CUR.                                       *        
      ******************************************************************        
       7200-FETCH-SO-LIGHT-CUR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH SO_LGHT_CUR                                         
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-WORK-AREA-ID                                    
                   ,:A4-TOWN                                            
                   ,:A4-STATE                                           
                   ,:PR-COUNTY                                          
                   ,:SC-COUNTY-DESC                                     
                   ,:TN-MATL-ITEM-CD                                    
                   ,:TN-MATL-ITEM-QT                                    
                   ,:TN-MATL-ITEM-TOT-AM                                
                   ,:TN-UOM-CD                                          
                   ,:TN-MATL-USAGE-CD                                   
                   ,:VO-DATE-RECVED                                     
A#5371             ,:VO-USER-ID-CPTD-BY                                 
                   ,:VO-COMPLETED-DATETIME                              
                   ,:PP-SUBSTATION-ID                                   
                   ,:PP-CIRCUIT-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7200'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE 'CSS_SO_DATA'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-CLOSE-SO-LIGHT-CUR.                                       *        
      ******************************************************************        
       7300-CLOSE-SO-LIGHT-CUR.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE SO_LGHT_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DATA'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A#5371******************************************************************        
A#5371* 7400-GET-CU-CD-MAPPING.                                        *        
A#5371******************************************************************        
A#5371 7400-GET-CU-CD-MAPPING.                                          
A#5371                                                                  
A#5371     EXEC SQL                                                     
A#5371        SELECT INSTL_MATL_CU_CD                                   
A#5371              ,SCRAP_MATL_ITEM_CD                                 
A#5371              ,SCRAP_MATL_CU_CD                                   
A#5371          INTO :4X-INSTL-MATL-CU-CD                               
A#5371              ,:4X-SCRAP-MATL-ITEM-CD                             
A#5371              ,:4X-SCRAP-MATL-CU-CD                               
A#5371          FROM LMS_CU_CD_MAP                                      
A#5371         WHERE INSTL_MATL_ITEM_CD = :4X-INSTL-MATL-ITEM-CD        
A#5371     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A#5371                                                                  
A#5371     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A#5371                                                                  
A#5371     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A#5371        CONTINUE                                                  
A#5371     ELSE                                                         
A#5371        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A#5371        MOVE '7400'                   TO ACTIVE-PARAGRAPH         
A#5371        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A#5371        MOVE 'LMS_CU_CD_MAP'          TO TABLE-1                  
A#5371        MOVE 'INSTL_MATL_ITEM_CD'     TO TABLE-ELEMENT-1          
A#5371        MOVE 4X-INSTL-MATL-ITEM-CD    TO HOSTVAR-ELEMENT-1        
A#5371        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A#5371     END-IF.                                                      
A#5371                                                                  
A#5371 7400-EXIT.                                                       
A#5371     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04827_R1                           
                (                                                       
                   RETURN_CODE                                          
                  ,SERV_ORDER_NO                                        
                  ,ACCOUNT_NO                                           
                  ,WORK_AREA_ID                                         
                  ,TOWN                                                 
                  ,STATE                                                
                  ,COUNTY                                               
                  ,COUNTY_DESC                                          
                  ,MATL_ITEM_CD                                         
                  ,MATL_ITEM_QT                                         
                  ,MATL_ITEM_TOT_AM                                     
                  ,UOM_CD                                               
                  ,MATL_USAGE_CD                                        
                  ,DATE_RECVED                                          
                  ,COMPLETED_DATETIME                                   
                  ,SUBSTATION_ID                                        
                  ,CIRCUIT_ID                                           
A#5371            ,MATL_CU_CD                                           
A#5371            ,USER_ID_CPTD_BY                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S1-SERV-ORDER-NO                                    
                  ,:S1-ACCOUNT-NO                                       
                  ,:S1-WORK-AREA-ID                                     
                  ,:S1-TOWN                                             
                  ,:S1-STATE                                            
                  ,:S1-COUNTY                                           
                  ,:S1-COUNTY-DESC                                      
                  ,:S1-MATL-ITEM-CD                                     
                  ,:S1-MATL-ITEM-QT                                     
                  ,:S1-MATL-ITEM-TOT-AM                                 
                  ,:S1-UOM-CD                                           
                  ,:S1-MATL-USAGE-CD                                    
                  ,:S1-DATE-RECVED                                      
                  ,:S1-COMPLETED-DATETIME                               
                  ,:S1-SUBSTATION-ID                                    
                  ,:S1-CIRCUIT-ID                                       
A#5371            ,:S1-MATL-CU-CD                                       
A#5371            ,:S1-USER-ID-CPTD-BY                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04827_R1                                   
MFA-TR*         (                                                               
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,SERV_ORDER_NO                                                
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,WORK_AREA_ID                                                 
MFA-TR*           ,TOWN                                                         
MFA-TR*           ,STATE                                                        
MFA-TR*           ,COUNTY                                                       
MFA-TR*           ,COUNTY_DESC                                                  
MFA-TR*           ,MATL_ITEM_CD                                                 
MFA-TR*           ,MATL_ITEM_QT                                                 
MFA-TR*           ,MATL_ITEM_TOT_AM                                             
MFA-TR*           ,UOM_CD                                                       
MFA-TR*           ,MATL_USAGE_CD                                                
MFA-TR*           ,DATE_RECVED                                                  
MFA-TR*           ,COMPLETED_DATETIME                                           
MFA-TR*           ,SUBSTATION_ID                                                
MFA-TR*           ,CIRCUIT_ID                                                   
MFA-TR*           ,MATL_CU_CD                                                   
MFA-TR*           ,USER_ID_CPTD_BY                                              
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S1-SERV-ORDER-NO                                            
MFA-TR*           ,:S1-ACCOUNT-NO                                               
MFA-TR*           ,:S1-WORK-AREA-ID                                             
MFA-TR*           ,:S1-TOWN                                                     
MFA-TR*           ,:S1-STATE                                                    
MFA-TR*           ,:S1-COUNTY                                                   
MFA-TR*           ,:S1-COUNTY-DESC                                              
MFA-TR*           ,:S1-MATL-ITEM-CD                                             
MFA-TR*           ,:S1-MATL-ITEM-QT                                             
MFA-TR*           ,:S1-MATL-ITEM-TOT-AM                                         
MFA-TR*           ,:S1-UOM-CD                                                   
MFA-TR*           ,:S1-MATL-USAGE-CD                                            
MFA-TR*           ,:S1-DATE-RECVED                                              
MFA-TR*           ,:S1-COMPLETED-DATETIME                                       
MFA-TR*           ,:S1-SUBSTATION-ID                                            
MFA-TR*           ,:S1-CIRCUIT-ID                                               
MFA-TR*           ,:S1-MATL-CU-CD                                               
MFA-TR*           ,:S1-USER-ID-CPTD-BY                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS                
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04827_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04827_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04827_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04827_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
