       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04824.                                      
COB303 DATE-WRITTEN.     MAY 18, 2014.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04824              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04824 :                                                --         
      *--                                                            --         
      *--  LIGHT DETAILS SCREEN: RETRIEVE FIXTURE DETAILS BY USING   --         
      *--  FIXTURE DATA AS INPUT                                     --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *-- PARAMETERS                                                 --         
      *--                                                            --         
      *--  INPUT                                                     --         
      *--    FIXTURE_TAG_NO      CHAR(12)                            --         
      *--                                                            --         
      *--  OUTPUT                                                    --         
      *--    RESULT SET - CSR04824_FXTR: Fixture Details             --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00817*--  10/15/2014    SV95326     RETRIEVE FIXTURE DETAILS.       --         
A05084*--  07/21/2015    SV95326     ACT059 - MOVE ZS-SUBDIVISION-ID --         
      *--                            TO PR-SUBDIVISION-ID.           --         
A05084*--  07/22/2015    SV95326     ADD NEW FIELDS TO CSR04824 TO   --         
      *--                ACT057      SYNC UP WITH GIS.               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04824'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_INVENTRY, 4D                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_ENVRNMT, 4F                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_FXTR_ATTACHMTS, 4H                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_CONTRACT, 4L                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_SPCL_AGREEMENT, 4Q                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAGR                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PREMISE, PR                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTRD_ENVRNMT, MN                                                 
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PIM_POINT, PP                                                    
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CUST_PREM_HIST, CH                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME_ACCT_XREF, HT                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ADDR_FORMATTED, DY                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIP_CODE, A4                                                     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIPCODE_SUBDIV, ZS                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPSUB                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_MSTR_STCK_INFO, 4A                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMSTINF                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_LOCAL_OFFICE, B1                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_SUBDIVISION, B0                                                  
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_REV_DISTRICT, A9                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04824'. 
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9) COMP.                
           05  PARM-FIXTURE-EQUIP-TAG-NO PIC X(12).                     
           05  PARM-FIXTURE-EQUIP-TAG-NUM  REDEFINES                    
               PARM-FIXTURE-EQUIP-TAG-NO  PIC 9(12).                    
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-FXTR             PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
      **** GTT TABLE LAYOUT FOR Fixture Details                                 
      *                                                                         
           05 GTT-RETURN-FIELDS-FXTR.                                   
              10 S-F-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
              10 S-F-FIXTURE-TAG-NO      PIC X(12) VALUE SPACES.        
              10 S-F-FIXTURE-DESC        PIC X(50) VALUE SPACES.        
              10 S-F-FIXTURE-INV-STATUS  PIC X(01) VALUE SPACES.        
              10 S-F-FIXTURE-RATE-PLAN-NO PIC X(03) VALUE SPACES.       
              10 S-F-POLE-NO             PIC X(12) VALUE SPACES.        
              10 S-F-POLE-DESC           PIC X(50) VALUE SPACES.        
              10 S-F-CUSTOMER-NO         PIC X(10) VALUE SPACES.        
              10 S-F-ACCOUNT-NO          PIC X(13) VALUE SPACES.        
              10 S-F-PREMISE-NO          PIC X(10) VALUE SPACES.        
              10 S-F-ACCOUNT-TYPE        PIC X(01) VALUE SPACES.        
              10 S-F-CUSTOMER-NAME       PIC X(70) VALUE SPACES.        
              10 S-F-LOCAL-OFFICE-NO     PIC X(03) VALUE SPACES.        
              10 S-F-LOCAL-OFFICE-DESC   PIC X(22) VALUE SPACES.        
              10 S-F-REVENUE-DISTRICT-ID PIC X(03) VALUE SPACES.        
              10 S-F-REVENUE-DISTRICT-DESC PIC X(35) VALUE SPACES.      
              10 S-F-SUBDIVISION-ID      PIC X(03) VALUE SPACES.        
              10 S-F-SUBDIVISION-NAME    PIC X(26) VALUE SPACES.        
              10 S-F-HOUSE-NO            PIC X(15) VALUE SPACES.        
              10 S-F-ADDR-PREFIX-1       PIC X(03) VALUE SPACES.        
              10 S-F-ADDR-PREFIX-2       PIC X(02) VALUE SPACES.        
              10 S-F-STREET-NAME         PIC X(30) VALUE SPACES.        
              10 S-F-STREET-LOCATION-1   PIC X(04) VALUE SPACES.        
              10 S-F-STREET-LOCATION-2   PIC X(11) VALUE SPACES.        
              10 S-F-STREET-SUFFIX       PIC X(04) VALUE SPACES.        
              10 S-F-ADDRESS-OVERFLOW    PIC X(35) VALUE SPACES.        
              10 S-F-ZIP-CODE            PIC X(05) VALUE SPACES.        
              10 S-F-ZIP-CODE-PLUS-FOUR  PIC X(04) VALUE SPACES.        
              10 S-F-ZIP-CODE-TOKEN      PIC X(01) VALUE SPACES.        
              10 S-F-ADDR-SUFFIX         PIC X(02) VALUE SPACES.        
              10 S-F-TOWN                PIC X(26) VALUE SPACES.        
              10 S-F-STATE               PIC X(02) VALUE SPACES.        
ACT057        10 S-FIXTURE-INSTALL-DATE  PIC X(10) VALUE SPACES.        
ACT057        10 S-FIXTURE-STOCK-CODE    PIC X(15) VALUE SPACES.        
ACT057        10 S-FIXTURE-RATE-ITEM-CD  PIC S9(4) COMP VALUE 0.        
ACT057        10 S-FXTR-RATE-ITEM-CD-DESC PIC X(60) VALUE SPACES.       
ACT057        10 S-POLE-STOCK-CODE       PIC X(15) VALUE SPACES.        
ACT057        10 S-POLE-RATE             PIC X(03) VALUE SPACES.        
ACT057        10 S-POLE-RATE-ITEM-CD     PIC S9(4) COMP VALUE 0.        
ACT057        10 S-POLE-RATE-ITEM-CODE-DESC PIC X(60) VALUE SPACES.     
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05 WS-POLE-DESC               PIC X(50) VALUE SPACES.        
           05 WS-POLE-NO                 PIC X(12) VALUE SPACES.        
ACT057     05 WS-POLE-STOCK-CODE         PIC X(15) VALUE SPACES.        
ACT057     05 WS-POLE-RATE               PIC X(03) VALUE SPACES.        
ACT057     05 WS-POLE-RATE-ITEM-CD       PIC S9(4) COMP VALUE 0.        
ACT057     05 WS-POLE-RATE-ITEM-CODE-DESC PIC X(60) VALUE SPACES.       
ACT057     05 WS-RATE-PLAN-NO            PIC X(03) VALUE SPACES.        
ACT057     05 WS-RATE-ITEM-CD            PIC S9(4) COMP VALUE 0.        
ACT057     05 WS-RATE-ITEM-CODE-DESC     PIC X(60) VALUE SPACES.        
ACT057     05 WS-FXTR-RATE-ITEM-CD-DESC  PIC X(60) VALUE SPACES.        
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  IND-INSTALL-DT            PIC S9(04) COMP.               
      *                                                                         
      ****************************************************************          
      **   ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** WOKING STORAGE FOR CPDCA099                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 LINK-FIXTURE-EQUIP-TAG-NO    PIC X(12).                       
      *                                                                         
       PROCEDURE DIVISION USING LINK-FIXTURE-EQUIP-TAG-NO.              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT      THRU  1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT     THRU  2000-EXIT.             
           PERFORM 2900-VLDT-NOTFOUND-RES  THRU  2900-EXIT.             
           PERFORM 9999-END-PROGRAM        THRU  9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-FXTR    THRU  0100A-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - FIXTURE DETAILS             **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-FXTR.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04824_FXTR'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04824_FXTR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04824_FXTR
              (                                                       
                    RETURN_CODE             INT                     
                   ,FIXTURE_TAG CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXTURE_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXTURE_INV_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXTURE_RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,POLE_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,POLE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CUSTOMER_NO CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,ACCOUNT_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CUSTOMER_NAME CHAR(70)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LOCAL_OFFICE_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LOCAL_OFFICE_DESC CHAR(22)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REVENUE_DISTRICT_ID CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,REVENUE_DISTRICT_DESC CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SUBDIVISION_ID CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SUBDIVISION_NAME CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,ADDR_PREFIX_1 CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADDR_PREFIX_2 CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STREET_NAME CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STREET_LOCATION_1 CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STREET_LOCATION_2 CHAR(11)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STREET_SUFFIX CHAR(14)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,ZIP_CODE_PLUS_FOUR CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ZIP_CODE_TOKEN CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADDR_SUFFIX CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2              
                   ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
ACT057             ,FIXTURE_INSTALL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
ACT057             ,FIXTURE_STOCK_CODE CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
ACT057             ,FIXTURE_RATE_ITEM_CD    SMALLINT                    
ACT057             ,FXTR_RATE_ITEM_CD_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
ACT057             ,POLE_STOCK_CODE CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
ACT057             ,POLE_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
ACT057             ,POLE_RATE_ITEM_CD       SMALLINT                    
ACT057             ,POLE_RATE_ITEM_CODE_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS-FXTR  THRU  8000A-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04824_FXTR'       TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,FIXTURE_TAG                                      
                      ,FIXTURE_DESC                                     
                      ,FIXTURE_INV_STATUS                               
                      ,FIXTURE_RATE_PLAN_NO                             
                      ,POLE_NO                                          
                      ,POLE_DESC                                        
                      ,CUSTOMER_NO                                      
                      ,ACCOUNT_NO                                       
                      ,PREMISE_NO                                       
                      ,ACCOUNT_TYPE                                     
                      ,CUSTOMER_NAME                                    
                      ,LOCAL_OFFICE_NO                                  
                      ,LOCAL_OFFICE_DESC                                
                      ,REVENUE_DISTRICT_ID                              
                      ,REVENUE_DISTRICT_DESC                            
                      ,SUBDIVISION_ID                                   
                      ,SUBDIVISION_NAME                                 
                      ,HOUSE_NO                                         
                      ,ADDR_PREFIX_1                                    
                      ,ADDR_PREFIX_2                                    
                      ,STREET_NAME                                      
                      ,STREET_LOCATION_1                                
                      ,STREET_LOCATION_2                                
                      ,STREET_SUFFIX                                    
                      ,ADDRESS_OVERFLOW                                 
                      ,ZIP_CODE                                         
                      ,ZIP_CODE_PLUS_FOUR                               
                      ,ZIP_CODE_TOKEN                                   
                      ,ADDR_SUFFIX                                      
                      ,TOWN                                             
                      ,STATE                                            
ACT057                ,FIXTURE_INSTALL_DATE                             
ACT057                ,FIXTURE_STOCK_CODE                               
ACT057                ,FIXTURE_RATE_ITEM_CD                             
ACT057                ,FXTR_RATE_ITEM_CD_DESC                           
ACT057                ,POLE_STOCK_CODE                                  
ACT057                ,POLE_RATE                                        
ACT057                ,POLE_RATE_ITEM_CD                                
ACT057                ,POLE_RATE_ITEM_CODE_DESC                         
                  FROM #CSR04824_FXTR                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,FIXTURE_TAG                                              
MFA-TR*               ,FIXTURE_DESC                                             
MFA-TR*               ,FIXTURE_INV_STATUS                                       
MFA-TR*               ,FIXTURE_RATE_PLAN_NO                                     
MFA-TR*               ,POLE_NO                                                  
MFA-TR*               ,POLE_DESC                                                
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,ACCOUNT_TYPE                                             
MFA-TR*               ,CUSTOMER_NAME                                            
MFA-TR*               ,LOCAL_OFFICE_NO                                          
MFA-TR*               ,LOCAL_OFFICE_DESC                                        
MFA-TR*               ,REVENUE_DISTRICT_ID                                      
MFA-TR*               ,REVENUE_DISTRICT_DESC                                    
MFA-TR*               ,SUBDIVISION_ID                                           
MFA-TR*               ,SUBDIVISION_NAME                                         
MFA-TR*               ,HOUSE_NO                                                 
MFA-TR*               ,ADDR_PREFIX_1                                            
MFA-TR*               ,ADDR_PREFIX_2                                            
MFA-TR*               ,STREET_NAME                                              
MFA-TR*               ,STREET_LOCATION_1                                        
MFA-TR*               ,STREET_LOCATION_2                                        
MFA-TR*               ,STREET_SUFFIX                                            
MFA-TR*               ,ADDRESS_OVERFLOW                                         
MFA-TR*               ,ZIP_CODE                                                 
MFA-TR*               ,ZIP_CODE_PLUS_FOUR                                       
MFA-TR*               ,ZIP_CODE_TOKEN                                           
MFA-TR*               ,ADDR_SUFFIX                                              
MFA-TR*               ,TOWN                                                     
MFA-TR*               ,STATE                                                    
MFA-TR*               ,FIXTURE_INSTALL_DATE                                     
MFA-TR*               ,FIXTURE_STOCK_CODE                                       
MFA-TR*               ,FIXTURE_RATE_ITEM_CD                                     
MFA-TR*               ,FXTR_RATE_ITEM_CD_DESC                                   
MFA-TR*               ,POLE_STOCK_CODE                                          
MFA-TR*               ,POLE_RATE                                                
MFA-TR*               ,POLE_RATE_ITEM_CD                                        
MFA-TR*               ,POLE_RATE_ITEM_CODE_DESC                                 
MFA-TR*           FROM SESSION.CSR04824_FXTR                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF LINK-FIXTURE-EQUIP-TAG-NO     GREATER THAN SPACES         
              MOVE LINK-FIXTURE-EQUIP-TAG-NO TO                         
                                     PARM-FIXTURE-EQUIP-TAG-NO          
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE INVENTORY INFO,CUSTOMER INFO,CONTRACT INFO,  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        DCLLMS-EQUIP-INVENTRY      
                                             DCLLMS-EQUIP-ENVRNMT.      
      *                                                                         
      **** FIXTURE INVENTORY DATA                                               
           MOVE PARM-FIXTURE-EQUIP-TAG-NO  TO 4D-EQUIP-TAG-NO.          
      *                                                                         
      **** FIXTURE INVENTORY/ ENVIRONMENT INFO                                  
           PERFORM 7000-GET-FXTR-INV-STOCK-INFO THRU 7000-EXIT.         
      *                                                                         
      **** FIXTURE INVENTORY STATUS = J -> INSTALLED                            
           IF 4D-INVENTRY-STATUS-CD = 'J'                               
              PERFORM 2100-PROCESS-FIXTURE-ATTR  THRU  2100-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-MOVE-RESULT-FXTR     THRU 2500-EXIT.            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE ATTRIBUTES: LOCATION INO, CONTRACT INFO AND  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-FIXTURE-ATTR.                                       
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
      **** GET FIXTURE ENVIRONMENT DATA                                         
           MOVE 4D-EQUIP-SEQ              TO 4F-EQUIP-SEQ.              
           PERFORM 7050-EQUIP-ENVRNMNT-DATA THRU 7050-EXIT.             
ACT057     MOVE 4F-RATE-PLAN-NO           TO WS-RATE-PLAN-NO.           
ACT057     MOVE 4F-RATE-ITEM-CODE         TO WS-RATE-ITEM-CD.           
ACT057     PERFORM 7600-GET-RATE-ITEM-CODE-DESC THRU 7600-EXIT.         
ACT057     MOVE WS-RATE-ITEM-CODE-DESC  TO WS-FXTR-RATE-ITEM-CD-DESC.   
      *                                                                         
           MOVE 4D-EQUIP-SEQ              TO 4H-FXTR-EQUIP-SEQ.         
           PERFORM 7100-GET-POLE-INV-STOCK-INFO THRU 7100-EXIT.         
ACT057     MOVE WS-POLE-RATE              TO WS-RATE-PLAN-NO.           
ACT057     MOVE WS-POLE-RATE-ITEM-CD      TO WS-RATE-ITEM-CD.           
ACT057     PERFORM 7600-GET-RATE-ITEM-CODE-DESC THRU 7600-EXIT.         
ACT057     MOVE WS-RATE-ITEM-CODE-DESC   TO WS-POLE-RATE-ITEM-CODE-DESC.
      *                                                                         
      **** GET FIXTURE LOCATION DETAILS                                         
           EVALUATE 4F-INSTALL-LOC-CD                                   
               WHEN 'P'                                                 
                  PERFORM 2200-PROCESS-LOCATION-PREMISE THRU 2200-EXIT  
               WHEN 'S'                                                 
                  PERFORM 2275-PROCESS-LOCATION-SUB-DIV THRU 2275-EXIT  
           END-EVALUATE.                                                
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE LOCATION INFO USING PREMISE NO               **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-LOCATION-PREMISE.                                   
      *                                                                         
           MOVE '2200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-CPD00099-WORK           
                                             PR-SUBDIVISION-ID          
                                             PR-ADDRESS-ID              
                                             PR-REV-DISTRICT-CD         
                                             UT-CODE-REVENUE-CLASS      
                                             PP-AREA-ID                 
                                             PP-TAG-NM                  
                                             DQ-FULL-NAME.              
      *                                                                         
           IF 4F-INSTALL-LOC-CD = 'P'                                   
              MOVE 4F-INSTALL-LOC-NO      TO WS-CPD99-PREMISE-NO        
           END-IF.                                                      
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT.             
      *                                                                         
           MOVE WS-CPD99-PREMISE-NO       TO PR-PREMISE-NO.             
           PERFORM 7300-GET-PREMISE-DET  THRU  7300-EXIT.               
           PERFORM 7250-GET-SUBDIV-DESC  THRU  7250-EXIT.               
           PERFORM 7350-GET-REVDIST-DESC  THRU  7350-EXIT.              
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO       TO HT-ACCOUNT-NO              
                                             AT-ACCOUNT-NO.             
           PERFORM 7150-GET-ACCOUNT-DETAILS  THRU 7150-EXIT.            
           PERFORM 7200-GET-LOCAL-OFFICE-DESC THRU 7200-EXIT.           
           PERFORM 7400-GET-CUSTOMER-NAME    THRU 7400-EXIT.            
      *                                                                         
           PERFORM 3000-GET-CUST-ADDRESS     THRU 3000-EXIT.            
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE LOCATION INFO USING SUB DIVISION             **        
      ******************************************************************        
      *                                                                         
       2275-PROCESS-LOCATION-SUB-DIV.                                   
      *                                                                         
           MOVE '2275'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        ZS-SUBDIVISION-ID          
                                             ZS-REV-DISTRICT-CD         
                                             ZS-ZIP-CODE.               
      *                                                                         
           MOVE 4F-INSTALL-LOC-NO(1:3)    TO ZS-SUBDIVISION-ID.         
           PERFORM 7500-GET-ZIPCODE-SUBDIV-DATA  THRU 7500-EXIT.        
ACT059     MOVE ZS-SUBDIVISION-ID         TO PR-SUBDIVISION-ID.         
           PERFORM 7250-GET-SUBDIV-DESC  THRU  7250-EXIT.               
      *                                                                         
       2275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND FIXTURE RESULT SET                               **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-FXTR.                                           
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4D-EQUIP-TAG-NO           TO S-F-FIXTURE-TAG-NO.        
ACT057     MOVE 4A-STOCK-CD               TO S-FIXTURE-STOCK-CODE.      
           MOVE 4A-STOCK-DESC             TO S-F-FIXTURE-DESC.          
           MOVE 4D-INVENTRY-STATUS-CD     TO S-F-FIXTURE-INV-STATUS.    
      *                                                                         
           IF 4D-INVENTRY-STATUS-CD = 'J'                               
              MOVE 4F-RATE-PLAN-NO          TO S-F-FIXTURE-RATE-PLAN-NO 
              MOVE WS-POLE-NO               TO S-F-POLE-NO              
              MOVE WS-POLE-DESC             TO S-F-POLE-DESC            
ACT057        MOVE 4F-RATE-ITEM-CODE        TO S-FIXTURE-RATE-ITEM-CD   
ACT057        MOVE 4F-EQUIP-INSTALL-DT      TO S-FIXTURE-INSTALL-DATE   
ACT057        MOVE WS-POLE-STOCK-CODE       TO S-POLE-STOCK-CODE        
ACT057        MOVE WS-POLE-RATE             TO S-POLE-RATE              
ACT057        MOVE WS-POLE-RATE-ITEM-CD     TO S-POLE-RATE-ITEM-CD      
ACT057        MOVE WS-FXTR-RATE-ITEM-CD-DESC TO S-FXTR-RATE-ITEM-CD-DESC
ACT057        MOVE WS-POLE-RATE-ITEM-CODE-DESC TO                       
ACT057                                      S-POLE-RATE-ITEM-CODE-DESC  
              IF 4F-INSTALL-LOC-CD = 'P'                                
                 MOVE AT-CUSTOMER-NO        TO S-F-CUSTOMER-NO          
                 MOVE WS-CPD99-ACCOUNT-NO   TO S-F-ACCOUNT-NO           
                 MOVE WS-CPD99-PREMISE-NO   TO S-F-PREMISE-NO           
                 MOVE AT-ACCOUNT-TYPE-CODE  TO S-F-ACCOUNT-TYPE         
                                                                        
                 MOVE DQ-FULL-NAME          TO S-F-CUSTOMER-NAME        
                 MOVE AT-LOCAL-OFFICE       TO S-F-LOCAL-OFFICE-NO      
                 MOVE B1-LOCAL-OFFICE-DESC  TO S-F-LOCAL-OFFICE-DESC    
                 MOVE PR-REV-DISTRICT-CD    TO S-F-REVENUE-DISTRICT-ID  
                 MOVE A9-REV-DISTRICT-DESC  TO S-F-REVENUE-DISTRICT-DESC
                 MOVE DY-HOUSE-NO           TO S-F-HOUSE-NO             
                 MOVE DY-ADDR-PREFIX-1      TO S-F-ADDR-PREFIX-1        
                 MOVE DY-ADDR-PREFIX-2      TO S-F-ADDR-PREFIX-2        
                 MOVE DY-STREET-NAME        TO S-F-STREET-NAME          
                 MOVE DY-STREET-LOCATION-1  TO S-F-STREET-LOCATION-1    
                 MOVE DY-STREET-LOCATION-2  TO S-F-STREET-LOCATION-2    
                 MOVE DY-STREET-SUFFIX      TO S-F-STREET-SUFFIX        
                 MOVE DY-ADDRESS-OVERFLOW   TO S-F-ADDRESS-OVERFLOW     
                 MOVE DY-ZIP-CODE           TO S-F-ZIP-CODE             
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO S-F-ZIP-CODE-PLUS-FOUR   
                 MOVE DY-ZIP-CODE-TOKEN     TO S-F-ZIP-CODE-TOKEN       
                 MOVE DY-ADDR-SUFFIX        TO S-F-ADDR-SUFFIX          
                 MOVE A4-TOWN               TO S-F-TOWN                 
                 MOVE A4-STATE              TO S-F-STATE                
              END-IF                                                    
              IF 4F-INSTALL-LOC-CD = 'P' OR 'S'                         
                 MOVE PR-SUBDIVISION-ID     TO S-F-SUBDIVISION-ID       
                 MOVE B0-SUBDIVISION-DESC   TO S-F-SUBDIVISION-NAME     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 8100A-SEND-RESULT-FXTR  THRU  8100A-EXIT.            
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-FXTR = 0                                         
              INITIALIZE                     GTT-RETURN-FIELDS-FXTR     
              MOVE 100                    TO S-F-RETURN-CODE            
              PERFORM 8100A-SEND-RESULT-FXTR  THRU  8100A-EXIT          
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET ADDRESS USING PREMISE ADDR ID                            **        
      ******************************************************************        
      *                                                                         
       3000-GET-CUST-ADDRESS.                                           
      *                                                                         
           MOVE '3000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        DCLCSS-ADDR-FORMATTED      
                                             A4-ZIP-CODE                
                                             A4-ZIP-CODE-TOKEN          
                                             A4-TOWN                    
                                             A4-STATE.                  
      *                                                                         
           MOVE PR-ADDRESS-ID             TO DY-ADDRESS-ID.             
      *                                                                         
           PERFORM 7450-GET-FORMATTED-ADDR  THRU  7450-EXIT.            
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6990-FETCH-CUR-ACCOUNT                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00099                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 6995-CPD99-ERROR-ROUTINE                                     **        
      ******************************************************************        
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           MOVE PROGRAM-NAME             TO ABEND-PROGRAM.              
           MOVE WS-CPD99-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE.      
           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT.             
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT INVENTORY DATA                                    **        
      ******************************************************************        
      *                                                                         
        7000-GET-FXTR-INV-STOCK-INFO.                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4D].EQUIP_SEQ                                      
                     ,[4D].INVENTRY_STATUS_CD                             
ACT057               ,[4A].STOCK_CD                                       
                     ,[4A].STOCK_DESC                                     
                INTO :4D-EQUIP-SEQ                                      
                    ,:4D-INVENTRY-STATUS-CD                             
ACT057              ,:4A-STOCK-CD                                       
                    ,:4A-STOCK-DESC                                     
               FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
                    ,LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)              
              WHERE  [4D].EQUIP_TAG_NO      =  :4D-EQUIP-TAG-NO           
                AND  [4A].COMPANY_NO        =  [4D].COMPANY_NO              
                AND  [4A].CODE_SERVICE_TYPE =  [4D].CODE_SERVICE_TYPE       
                AND  [4A].STOCK_CD          =  [4D].STOCK_CD                
                AND  [4A].EQUIP_TYPE_CD     =  [4D].EQUIP_TYPE_CD           
                AND  [4D].EQUIP_TYPE_CD     =  'F'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4D.EQUIP_SEQ                                              
MFA-TR*              ,4D.INVENTRY_STATUS_CD                                     
MFA-TR*              ,4A.STOCK_CD                                               
MFA-TR*              ,4A.STOCK_DESC                                             
MFA-TR*         INTO :4D-EQUIP-SEQ                                              
MFA-TR*             ,:4D-INVENTRY-STATUS-CD                                     
MFA-TR*             ,:4A-STOCK-CD                                               
MFA-TR*             ,:4A-STOCK-DESC                                             
MFA-TR*        FROM  LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*             ,LMS_MSTR_STCK_INFO 4A                                      
MFA-TR*       WHERE  4D.EQUIP_TAG_NO      =  :4D-EQUIP-TAG-NO                   
MFA-TR*         AND  4A.COMPANY_NO        =  4D.COMPANY_NO                      
MFA-TR*         AND  4A.CODE_SERVICE_TYPE =  4D.CODE_SERVICE_TYPE               
MFA-TR*         AND  4A.STOCK_CD          =  4D.STOCK_CD                        
MFA-TR*         AND  4A.EQUIP_TYPE_CD     =  4D.EQUIP_TYPE_CD                   
MFA-TR*         AND  4D.EQUIP_TYPE_CD     =  'F'                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1                
              MOVE 'EQUIP_TAG_NO'             TO TABLE-ELEMENT-1        
              MOVE 4D-EQUIP-TAG-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT ENVIRONMENT DATA                                  **        
      ******************************************************************        
      *                                                                         
       7050-EQUIP-ENVRNMNT-DATA.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4F].INSTALL_LOC_NO                                 
                     ,[4F].INSTALL_POINT_NO                               
                     ,[4F].INSTALL_LOC_CD                                 
                     ,[4F].CODE_UTIL_TYPE                                 
                     ,[4F].IC_NO                                          
                     ,[4F].RATE_PLAN_NO                                   
                     ,[4F].RATE_ITEM_CODE                                 
                     ,[4F].ITEM_SEQ_NO                                    
                     ,[4F].BILLING_FL                                     
                     ,[4F].NO_BILL_REASON_CD                              
                     ,[4F].EQUIP_CONTRACT_FL                              
                     ,[4F].NO_CONTRACT_RSN_CD                             
                     ,[4F].EQUIP_OWNER_CD                                 
                     ,[4F].EQUIP_DRAWING_ID                               
                     ,[4F].SOURCE_APPL_CD                                 
                     ,[4F].SOURCE_APPL_REQ_NO                             
                     ,[4F].WMS_POINT_NO                                   
                     ,[4F].EQUIP_INSTALL_DT                               
                     ,[4F].SPCL_AGR_COMMENTS                              
                     ,[4F].EQUIP_COMMENTS                                 
                INTO :4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-POINT-NO                               
                    ,:4F-INSTALL-LOC-CD                                 
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-IC-NO                                          
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-RATE-ITEM-CODE                                 
                    ,:4F-ITEM-SEQ-NO                                    
                    ,:4F-BILLING-FL                                     
                    ,:4F-NO-BILL-REASON-CD                              
                    ,:4F-EQUIP-CONTRACT-FL                              
                    ,:4F-NO-CONTRACT-RSN-CD                             
                    ,:4F-EQUIP-OWNER-CD                                 
                    ,:4F-EQUIP-DRAWING-ID                               
                    ,:4F-SOURCE-APPL-CD                                 
                    ,:4F-SOURCE-APPL-REQ-NO                             
                    ,:4F-WMS-POINT-NO                                   
                    ,:4F-EQUIP-INSTALL-DT :IND-INSTALL-DT                
                    ,:4F-SPCL-AGR-COMMENTS                              
                    ,:4F-EQUIP-COMMENTS                                 
               FROM  LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
              WHERE  [4F].EQUIP_SEQ  =  :4F-EQUIP-SEQ                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4F.INSTALL_LOC_NO                                         
MFA-TR*              ,4F.INSTALL_POINT_NO                                       
MFA-TR*              ,4F.INSTALL_LOC_CD                                         
MFA-TR*              ,4F.CODE_UTIL_TYPE                                         
MFA-TR*              ,4F.IC_NO                                                  
MFA-TR*              ,4F.RATE_PLAN_NO                                           
MFA-TR*              ,4F.RATE_ITEM_CODE                                         
MFA-TR*              ,4F.ITEM_SEQ_NO                                            
MFA-TR*              ,4F.BILLING_FL                                             
MFA-TR*              ,4F.NO_BILL_REASON_CD                                      
MFA-TR*              ,4F.EQUIP_CONTRACT_FL                                      
MFA-TR*              ,4F.NO_CONTRACT_RSN_CD                                     
MFA-TR*              ,4F.EQUIP_OWNER_CD                                         
MFA-TR*              ,4F.EQUIP_DRAWING_ID                                       
MFA-TR*              ,4F.SOURCE_APPL_CD                                         
MFA-TR*              ,4F.SOURCE_APPL_REQ_NO                                     
MFA-TR*              ,4F.WMS_POINT_NO                                           
MFA-TR*              ,4F.EQUIP_INSTALL_DT                                       
MFA-TR*              ,4F.SPCL_AGR_COMMENTS                                      
MFA-TR*              ,4F.EQUIP_COMMENTS                                         
MFA-TR*         INTO :4F-INSTALL-LOC-NO                                         
MFA-TR*             ,:4F-INSTALL-POINT-NO                                       
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-CODE-UTIL-TYPE                                         
MFA-TR*             ,:4F-IC-NO                                                  
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*             ,:4F-RATE-ITEM-CODE                                         
MFA-TR*             ,:4F-ITEM-SEQ-NO                                            
MFA-TR*             ,:4F-BILLING-FL                                             
MFA-TR*             ,:4F-NO-BILL-REASON-CD                                      
MFA-TR*             ,:4F-EQUIP-CONTRACT-FL                                      
MFA-TR*             ,:4F-NO-CONTRACT-RSN-CD                                     
MFA-TR*             ,:4F-EQUIP-OWNER-CD                                         
MFA-TR*             ,:4F-EQUIP-DRAWING-ID                                       
MFA-TR*             ,:4F-SOURCE-APPL-CD                                         
MFA-TR*             ,:4F-SOURCE-APPL-REQ-NO                                     
MFA-TR*             ,:4F-WMS-POINT-NO                                           
MFA-TR*             ,:4F-EQUIP-INSTALL-DT:IND-INSTALL-DT                        
MFA-TR*             ,:4F-SPCL-AGR-COMMENTS                                      
MFA-TR*             ,:4F-EQUIP-COMMENTS                                         
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*       WHERE  4F.EQUIP_SEQ  =  :4F-EQUIP-SEQ                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF IND-INSTALL-DT = WS-YES-NULL                           
                 MOVE SPACES                  TO 4F-EQUIP-INSTALL-DT    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_ENVRNMT'        TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 4F-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-POLE-INV-STOCK-INFO.                                *        
      ******************************************************************        
      *                                                                         
       7100-GET-POLE-INV-STOCK-INFO.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) [4D].EQUIP_TAG_NO,
              [4A].STOCK_CD,
              [4A].STOCK_DESC,
              [4F].RATE_PLAN_NO,
              [4F].RATE_ITEM_CODE                                 
                INTO :WS-POLE-NO                                        
ACT057              ,:WS-POLE-STOCK-CODE                                
                    ,:WS-POLE-DESC                                      
ACT057              ,:WS-POLE-RATE                                      
ACT057              ,:WS-POLE-RATE-ITEM-CD                              
                FROM LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
                    ,LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)              
ACT057              ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
                WHERE [4H].FXTR_EQUIP_SEQ      = :4H-FXTR-EQUIP-SEQ       
ACT057             AND [4F].INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO       
                   AND [4H].EQUIP_TYPE_CD      = 'P'                      
                   AND [4D].EQUIP_SEQ          =  [4H].ATTACH_EQUIP_SEQ     
ACT057             AND [4D].EQUIP_SEQ          =  [4F].EQUIP_SEQ            
                   AND [4D].EQUIP_TYPE_CD      =  [4H].EQUIP_TYPE_CD        
                   AND [4D].INVENTRY_STATUS_CD = 'J'                      
                   AND [4A].COMPANY_NO         =  [4D].COMPANY_NO           
                   AND [4A].CODE_SERVICE_TYPE  =  [4D].CODE_SERVICE_TYPE    
                   AND [4A].STOCK_CD           =  [4D].STOCK_CD             
                   AND [4A].EQUIP_TYPE_CD      =  [4D].EQUIP_TYPE_CD        
                ORDER BY [4H].ATTACH_SEQ_NO                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4D.EQUIP_TAG_NO                                           
MFA-TR*              ,4A.STOCK_CD                                               
MFA-TR*              ,4A.STOCK_DESC                                             
MFA-TR*              ,4F.RATE_PLAN_NO                                           
MFA-TR*              ,4F.RATE_ITEM_CODE                                         
MFA-TR*         INTO :WS-POLE-NO                                                
MFA-TR*             ,:WS-POLE-STOCK-CODE                                        
MFA-TR*             ,:WS-POLE-DESC                                              
MFA-TR*             ,:WS-POLE-RATE                                              
MFA-TR*             ,:WS-POLE-RATE-ITEM-CD                                      
MFA-TR*         FROM LMS_FXTR_ATTACHMTS 4H                                      
MFA-TR*             ,LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*             ,LMS_MSTR_STCK_INFO 4A                                      
MFA-TR*             ,LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*         WHERE 4H.FXTR_EQUIP_SEQ      = :4H-FXTR-EQUIP-SEQ               
MFA-TR*            AND 4F.INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO               
MFA-TR*            AND 4H.EQUIP_TYPE_CD      = 'P'                              
MFA-TR*            AND 4D.EQUIP_SEQ          =  4H.ATTACH_EQUIP_SEQ             
MFA-TR*            AND 4D.EQUIP_SEQ          =  4F.EQUIP_SEQ                    
MFA-TR*            AND 4D.EQUIP_TYPE_CD      =  4H.EQUIP_TYPE_CD                
MFA-TR*            AND 4D.INVENTRY_STATUS_CD = 'J'                              
MFA-TR*            AND 4A.COMPANY_NO         =  4D.COMPANY_NO                   
MFA-TR*            AND 4A.CODE_SERVICE_TYPE  =  4D.CODE_SERVICE_TYPE            
MFA-TR*            AND 4A.STOCK_CD           =  4D.STOCK_CD                     
MFA-TR*            AND 4A.EQUIP_TYPE_CD      =  4D.EQUIP_TYPE_CD                
MFA-TR*         ORDER BY 4H.ATTACH_SEQ_NO                                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1                
              MOVE '4D.EQUIP_SEQ'             TO TABLE-ELEMENT-1        
              MOVE 4D-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7150-GET-ACCOUNT-DETAILS.                                   **        
      ******************************************************************        
      *                                                                         
       7150-GET-ACCOUNT-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT  AT.CUSTOMER_NO                                    
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ACCOUNT_TYPE_CODE                              
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-ACCOUNT-TYPE-CODE                              
               FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
              WHERE  AT.ACCOUNT_NO     =  :AT-ACCOUNT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*        FROM  CSS_ACCOUNT AT                                             
MFA-TR*       WHERE  AT.ACCOUNT_NO     =  :AT-ACCOUNT-NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-GET-LOCAL-OFFICE-DESC.                                 **        
      ******************************************************************        
      *                                                                         
       7200-GET-LOCAL-OFFICE-DESC.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  B1.LOCAL_OFFICE_DESC                              
                INTO :B1-LOCAL-OFFICE-DESC                              
               FROM  CSS_LOCAL_OFFICE  B1 WITH(READUNCOMMITTED)                 
              WHERE  B1.LOCAL_OFFICE  =  :AT-LOCAL-OFFICE               
                AND  B1.COMPANY_NO    =  '01'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  B1.LOCAL_OFFICE_DESC                                      
MFA-TR*         INTO :B1-LOCAL-OFFICE-DESC                                      
MFA-TR*        FROM  CSS_LOCAL_OFFICE  B1                                       
MFA-TR*       WHERE  B1.LOCAL_OFFICE  =  :AT-LOCAL-OFFICE                       
MFA-TR*         AND  B1.COMPANY_NO    =  '01'                                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_LOCAL_OFFICE'         TO TABLE-1                
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-1        
              MOVE AT-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7250-GET-SUBDIV-DESC.                                       **        
      ******************************************************************        
      *                                                                         
       7250-GET-SUBDIV-DESC.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT  B0.SUBDIVISION_DESC                               
                INTO :B0-SUBDIVISION-DESC                               
               FROM  CSS_SUBDIVISION   B0 WITH(READUNCOMMITTED)                 
              WHERE  B0.SUBDIVISION_ID =  :PR-SUBDIVISION-ID            
                AND  B0.COMPANY_NO     =  '01'                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  B0.SUBDIVISION_DESC                                       
MFA-TR*         INTO :B0-SUBDIVISION-DESC                                       
MFA-TR*        FROM  CSS_SUBDIVISION   B0                                       
MFA-TR*       WHERE  B0.SUBDIVISION_ID =  :PR-SUBDIVISION-ID                    
MFA-TR*         AND  B0.COMPANY_NO     =  '01'                                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SUBDIVISION'          TO TABLE-1                
              MOVE 'SUBDIVISION_ID'           TO TABLE-ELEMENT-1        
              MOVE PR-SUBDIVISION-ID          TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PREMISE DATA                                                 **        
      ******************************************************************        
      *                                                                         
       7300-GET-PREMISE-DET.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT  PR.SUBDIVISION_ID                                  
                    ,PR.ADDRESS_ID                                      
                    ,PR.REV_DISTRICT_CD                                 
               INTO :PR-SUBDIVISION-ID                                  
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-REV-DISTRICT-CD                                 
               FROM  CSS_PREMISE  PR WITH(READUNCOMMITTED)                      
              WHERE PR.PREMISE_NO = :PR-PREMISE-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  PR.SUBDIVISION_ID                                          
MFA-TR*             ,PR.ADDRESS_ID                                              
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*        INTO :PR-SUBDIVISION-ID                                          
MFA-TR*            ,:PR-ADDRESS-ID                                              
MFA-TR*            ,:PR-REV-DISTRICT-CD                                         
MFA-TR*        FROM  CSS_PREMISE  PR                                            
MFA-TR*       WHERE PR.PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET REVENUE DISTRICE DESCRIPTION.                            **        
      ******************************************************************        
      *                                                                         
       7350-GET-REVDIST-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  A9.REV_DISTRICT_DESC                               
               INTO :A9-REV-DISTRICT-DESC                               
               FROM  CSS_REV_DISTRICT  A9 WITH(READUNCOMMITTED)                 
              WHERE A9.REV_DISTRICT_CD  =  :PR-REV-DISTRICT-CD          
                AND A9.COMPANY_NO       =  '01'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  A9.REV_DISTRICT_DESC                                       
MFA-TR*        INTO :A9-REV-DISTRICT-DESC                                       
MFA-TR*        FROM  CSS_REV_DISTRICT  A9                                       
MFA-TR*       WHERE A9.REV_DISTRICT_CD  =  :PR-REV-DISTRICT-CD                  
MFA-TR*         AND A9.COMPANY_NO       =  '01'                                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_REV_DISTRICT'         TO TABLE-1                
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-1        
              MOVE PR-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER NAME                                            **        
      ******************************************************************        
      *                                                                         
       7400-GET-CUSTOMER-NAME.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME        
                ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '         
                     THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '         
                          THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                 
                INTO  :DQ-FULL-NAME                                     
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
               WHERE  HT.ACCOUNT_NO        = :HT-ACCOUNT-NO             
                 AND  HT.NAME_ID           =  DQ.NAME_ID                
                 AND  DQ.NAME_TYPE         =  'CN'                      
                 AND  HT.CUSTOMER_ROLE_CD  =  ' '                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME                
MFA-TR*         ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                          
MFA-TR*              CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '                 
MFA-TR*              THEN '' ELSE ', '    END  ||                               
MFA-TR*                   STRIP(DQ.FIRST_NAME)           ||                     
MFA-TR*              CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '                 
MFA-TR*                   THEN '' ELSE ' '     END  ||                          
MFA-TR*                   STRIP(DQ.MIDDLE_NAME),70) END                         
MFA-TR*         INTO  :DQ-FULL-NAME                                             
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*        WHERE  HT.ACCOUNT_NO        = :HT-ACCOUNT-NO                     
MFA-TR*          AND  HT.NAME_ID           =  DQ.NAME_ID                        
MFA-TR*          AND  DQ.NAME_TYPE         =  'CN'                              
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD  =  ' '                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER ADDRESS                                         **        
      ******************************************************************        
      *                                                                         
       7450-GET-FORMATTED-ADDR.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT  DY.HOUSE_NO                                        
                    ,DY.ADDR_PREFIX_1                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.STREET_NAME                                     
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.CARRIER_ROUTE                                   
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,DY.ZIP_CODE_TOKEN                                  
                    ,DY.ADDR_SUFFIX                                     
                    ,A4.TOWN                                            
                    ,A4.STATE                                           
               INTO :DY-HOUSE-NO                                        
                   ,:DY-ADDR-PREFIX-1                                   
                   ,:DY-ADDR-PREFIX-2                                   
                   ,:DY-STREET-NAME                                     
                   ,:DY-STREET-LOCATION-1                               
                   ,:DY-STREET-LOCATION-2                               
                   ,:DY-STREET-SUFFIX                                   
                   ,:DY-ADDRESS-OVERFLOW                                
                   ,:DY-CARRIER-ROUTE                                   
                   ,:DY-ZIP-CODE                                        
                   ,:DY-ZIP-CODE-PLUS-FOUR                              
                   ,:DY-ZIP-CODE-TOKEN                                  
                   ,:DY-ADDR-SUFFIX                                     
                   ,:A4-TOWN                                            
                   ,:A4-STATE                                           
               FROM  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
                    ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
              WHERE  DY.ADDRESS_ID      =  :DY-ADDRESS-ID               
                AND  DY.ZIP_CODE        =   A4.ZIP_CODE                 
                AND  DY.ZIP_CODE_TOKEN  =   A4.ZIP_CODE_TOKEN           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DY.HOUSE_NO                                                
MFA-TR*             ,DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.CARRIER_ROUTE                                           
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,DY.ZIP_CODE_TOKEN                                          
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*             ,A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*        INTO :DY-HOUSE-NO                                                
MFA-TR*            ,:DY-ADDR-PREFIX-1                                           
MFA-TR*            ,:DY-ADDR-PREFIX-2                                           
MFA-TR*            ,:DY-STREET-NAME                                             
MFA-TR*            ,:DY-STREET-LOCATION-1                                       
MFA-TR*            ,:DY-STREET-LOCATION-2                                       
MFA-TR*            ,:DY-STREET-SUFFIX                                           
MFA-TR*            ,:DY-ADDRESS-OVERFLOW                                        
MFA-TR*            ,:DY-CARRIER-ROUTE                                           
MFA-TR*            ,:DY-ZIP-CODE                                                
MFA-TR*            ,:DY-ZIP-CODE-PLUS-FOUR                                      
MFA-TR*            ,:DY-ZIP-CODE-TOKEN                                          
MFA-TR*            ,:DY-ADDR-SUFFIX                                             
MFA-TR*            ,:A4-TOWN                                                    
MFA-TR*            ,:A4-STATE                                                   
MFA-TR*        FROM  CSS_ADDR_FORMATTED DY                                      
MFA-TR*             ,CSS_ZIP_CODE       A4                                      
MFA-TR*       WHERE  DY.ADDRESS_ID      =  :DY-ADDRESS-ID                       
MFA-TR*         AND  DY.ZIP_CODE        =   A4.ZIP_CODE                         
MFA-TR*         AND  DY.ZIP_CODE_TOKEN  =   A4.ZIP_CODE_TOKEN                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7450'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
              MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET SUB DIVISION ZIP CODE DATA                               **        
      ******************************************************************        
      *                                                                         
       7500-GET-ZIPCODE-SUBDIV-DATA.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) ZS.REV_DISTRICT_CD,
              ZS.ZIP_CODE                                        
               INTO :ZS-REV-DISTRICT-CD                                 
                   ,:ZS-ZIP-CODE                                        
               FROM  CSS_ZIPCODE_SUBDIV  ZS WITH(READUNCOMMITTED)               
              WHERE ZS.SUBDIVISION_ID = :ZS-SUBDIVISION-ID              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  ZS.REV_DISTRICT_CD                                         
MFA-TR*             ,ZS.ZIP_CODE                                                
MFA-TR*        INTO :ZS-REV-DISTRICT-CD                                         
MFA-TR*            ,:ZS-ZIP-CODE                                                
MFA-TR*        FROM  CSS_ZIPCODE_SUBDIV  ZS                                     
MFA-TR*       WHERE ZS.SUBDIVISION_ID = :ZS-SUBDIVISION-ID                      
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'SUBDIVISION_ID'           TO TABLE-ELEMENT-1        
              MOVE ZS-SUBDIVISION-ID          TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT057******************************************************************        
ACT057**  7600-GET-RATE-ITEM-CODE-DESC.                                *        
ACT057******************************************************************        
ACT057*                                                                         
ACT057 7600-GET-RATE-ITEM-CODE-DESC.                                    
ACT057*                                                                         
ACT057     EXEC SQL                                                     
ACT057        SELECT LTRIM(RTRIM(L9.UM_EQUIP_LONG_DESC))                        
ACT057          INTO :WS-RATE-ITEM-CODE-DESC                            
ACT057          FROM CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)               
ACT057              ,CSS_RATE_CREATOR    RT WITH(READUNCOMMITTED)               
ACT057              ,CSS_UNMTR_PLAN      UP WITH(READUNCOMMITTED)               
ACT057              ,CSS_UM_EQUIPMENT    L9 WITH(READUNCOMMITTED)               
ACT057         WHERE  RT.RATE_PLAN_NO     =   RD.RATE_PLAN_NO           
ACT057           AND  UP.RATE_PLAN_NO     =   RD.RATE_PLAN_NO           
ACT057           AND  RT.CODE_UTIL_TYPE   =   RD.CODE_UTIL_TYPE         
ACT057           AND  UP.CODE_UTIL_TYPE   =   RD.CODE_UTIL_TYPE         
ACT057           AND  L9.UM_EQUIP_ID      =   UP.UM_EQUIP_ID            
ACT057           AND  L9.STATUS_CD        =  'A'                        
ACT057           AND  RD.COMPANY_NO       =  '01'                       
ACT057           AND  UP.VERSION_NO_CNTRL =   RT.VERSION_NO_CNTRL       
ACT057           AND  RT.VERSION_NO_CNTRL =                             
ACT057                (SELECT MAX(RT1.VERSION_NO_CNTRL)                 
ACT057                   FROM CSS_RATE_CREATOR RT1 WITH(READUNCOMMITTED)        
ACT057                  WHERE RT1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE    
ACT057                    AND RT1.RATE_PLAN_NO   = RD.RATE_PLAN_NO      
ACT057                    AND RT1.CODE_STATUS    = 'A')                 
ACT057           AND  UP.CODE_UTIL_TYPE   =  :4F-CODE-UTIL-TYPE         
ACT057           AND  UP.RATE_PLAN_NO     =  :WS-RATE-PLAN-NO           
ACT057           AND  UP.RATE_ITEM_CODE   =  :WS-RATE-ITEM-CD           
ACT057                                                           
ACT057                                                      
ACT057     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TRIM(L9.UM_EQUIP_LONG_DESC)                                
MFA-TR*         INTO :WS-RATE-ITEM-CODE-DESC                                    
MFA-TR*         FROM CSS_RATE_PLAN_DESC  RD                                     
MFA-TR*             ,CSS_RATE_CREATOR    RT                                     
MFA-TR*             ,CSS_UNMTR_PLAN      UP                                     
MFA-TR*             ,CSS_UM_EQUIPMENT    L9                                     
MFA-TR*        WHERE  RT.RATE_PLAN_NO     =   RD.RATE_PLAN_NO                   
MFA-TR*          AND  UP.RATE_PLAN_NO     =   RD.RATE_PLAN_NO                   
MFA-TR*          AND  RT.CODE_UTIL_TYPE   =   RD.CODE_UTIL_TYPE                 
MFA-TR*          AND  UP.CODE_UTIL_TYPE   =   RD.CODE_UTIL_TYPE                 
MFA-TR*          AND  L9.UM_EQUIP_ID      =   UP.UM_EQUIP_ID                    
MFA-TR*          AND  L9.STATUS_CD        =  'A'                                
MFA-TR*          AND  RD.COMPANY_NO       =  '01'                               
MFA-TR*          AND  UP.VERSION_NO_CNTRL =   RT.VERSION_NO_CNTRL               
MFA-TR*          AND  RT.VERSION_NO_CNTRL =                                     
MFA-TR*               (SELECT MAX(RT1.VERSION_NO_CNTRL)                         
MFA-TR*                  FROM CSS_RATE_CREATOR RT1                              
MFA-TR*                 WHERE RT1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE            
MFA-TR*                   AND RT1.RATE_PLAN_NO   = RD.RATE_PLAN_NO              
MFA-TR*                   AND RT1.CODE_STATUS    = 'A')                         
MFA-TR*          AND  UP.CODE_UTIL_TYPE   =  :4F-CODE-UTIL-TYPE                 
MFA-TR*          AND  UP.RATE_PLAN_NO     =  :WS-RATE-PLAN-NO                   
MFA-TR*          AND  UP.RATE_ITEM_CODE   =  :WS-RATE-ITEM-CD                   
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT057*                                                                         
ACT057     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
ACT057*                                                                         
ACT057     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT057        NEXT SENTENCE                                             
ACT057     ELSE                                                         
ACT057        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
ACT057        MOVE '7600'                     TO ACTIVE-PARAGRAPH       
ACT057        MOVE 'SELECT'                   TO ABEND-FUNCTION         
ACT057        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
ACT057                                           ABEND-TABLES           
ACT057        MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
ACT057        MOVE 'CSS_RATE_CREATOR'         TO TABLE-2                
ACT057        MOVE 'CSS_UNMTR_PLAN'           TO TABLE-3                
ACT057        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
ACT057        MOVE 4F-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
ACT057        MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
ACT057        MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
ACT057        MOVE 'RATE_ITEM_CD'             TO TABLE-ELEMENT-3        
ACT057        MOVE WS-RATE-ITEM-CD            TO HOSTVAR-ELEMENT-3      
ACT057        PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
ACT057     END-IF.                                                      
ACT057*                                                                         
ACT057 7600-EXIT.                                                       
ACT057     EXIT.                                                        
ACT057*                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - FIXTURE DETAILS                      **         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS-FXTR.                                         
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04824_FXTR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04824_FXTR                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04824_FXTR                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04824_FXTR'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - FIXTURE DETAILS                          **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-FXTR.                                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04824_FXTR                         
                 (                                                      
                   RETURN_CODE                                          
                  ,FIXTURE_TAG                                          
                  ,FIXTURE_DESC                                         
                  ,FIXTURE_INV_STATUS                                   
                  ,FIXTURE_RATE_PLAN_NO                                 
                  ,POLE_NO                                              
                  ,POLE_DESC                                            
                  ,CUSTOMER_NO                                          
                  ,ACCOUNT_NO                                           
                  ,PREMISE_NO                                           
                  ,ACCOUNT_TYPE                                         
                  ,CUSTOMER_NAME                                        
                  ,LOCAL_OFFICE_NO                                      
                  ,LOCAL_OFFICE_DESC                                    
                  ,REVENUE_DISTRICT_ID                                  
                  ,REVENUE_DISTRICT_DESC                                
                  ,SUBDIVISION_ID                                       
                  ,SUBDIVISION_NAME                                     
                  ,HOUSE_NO                                             
                  ,ADDR_PREFIX_1                                        
                  ,ADDR_PREFIX_2                                        
                  ,STREET_NAME                                          
                  ,STREET_LOCATION_1                                    
                  ,STREET_LOCATION_2                                    
                  ,STREET_SUFFIX                                        
                  ,ADDRESS_OVERFLOW                                     
                  ,ZIP_CODE                                             
                  ,ZIP_CODE_PLUS_FOUR                                   
                  ,ZIP_CODE_TOKEN                                       
                  ,ADDR_SUFFIX                                          
                  ,TOWN                                                 
                  ,STATE                                                
ACT057            ,FIXTURE_INSTALL_DATE                                 
ACT057            ,FIXTURE_STOCK_CODE                                   
ACT057            ,FIXTURE_RATE_ITEM_CD                                 
ACT057            ,FXTR_RATE_ITEM_CD_DESC                               
ACT057            ,POLE_STOCK_CODE                                      
ACT057            ,POLE_RATE                                            
ACT057            ,POLE_RATE_ITEM_CD                                    
ACT057            ,POLE_RATE_ITEM_CODE_DESC                             
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-F-RETURN-CODE                                     
                  ,:S-F-FIXTURE-TAG-NO                                  
                  ,:S-F-FIXTURE-DESC                                    
                  ,:S-F-FIXTURE-INV-STATUS                              
                  ,:S-F-FIXTURE-RATE-PLAN-NO                            
                  ,:S-F-POLE-NO                                         
                  ,:S-F-POLE-DESC                                       
                  ,:S-F-CUSTOMER-NO                                     
                  ,:S-F-ACCOUNT-NO                                      
                  ,:S-F-PREMISE-NO                                      
                  ,:S-F-ACCOUNT-TYPE                                    
                  ,:S-F-CUSTOMER-NAME                                   
                  ,:S-F-LOCAL-OFFICE-NO                                 
                  ,:S-F-LOCAL-OFFICE-DESC                               
                  ,:S-F-REVENUE-DISTRICT-ID                             
                  ,:S-F-REVENUE-DISTRICT-DESC                           
                  ,:S-F-SUBDIVISION-ID                                  
                  ,:S-F-SUBDIVISION-NAME                                
                  ,:S-F-HOUSE-NO                                        
                  ,:S-F-ADDR-PREFIX-1                                   
                  ,:S-F-ADDR-PREFIX-2                                   
                  ,:S-F-STREET-NAME                                     
                  ,:S-F-STREET-LOCATION-1                               
                  ,:S-F-STREET-LOCATION-2                               
                  ,:S-F-STREET-SUFFIX                                   
                  ,:S-F-ADDRESS-OVERFLOW                                
                  ,:S-F-ZIP-CODE                                        
                  ,:S-F-ZIP-CODE-PLUS-FOUR                              
                  ,:S-F-ZIP-CODE-TOKEN                                  
                  ,:S-F-ADDR-SUFFIX                                     
                  ,:S-F-TOWN                                            
                  ,:S-F-STATE                                           
ACT057            ,:S-FIXTURE-INSTALL-DATE                              
ACT057            ,:S-FIXTURE-STOCK-CODE                                
ACT057            ,:S-FIXTURE-RATE-ITEM-CD                              
ACT057            ,:S-FXTR-RATE-ITEM-CD-DESC                            
ACT057            ,:S-POLE-STOCK-CODE                                   
ACT057            ,:S-POLE-RATE                                         
ACT057            ,:S-POLE-RATE-ITEM-CD                                 
ACT057            ,:S-POLE-RATE-ITEM-CODE-DESC                          
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04824_FXTR                                 
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,FIXTURE_TAG                                                  
MFA-TR*           ,FIXTURE_DESC                                                 
MFA-TR*           ,FIXTURE_INV_STATUS                                           
MFA-TR*           ,FIXTURE_RATE_PLAN_NO                                         
MFA-TR*           ,POLE_NO                                                      
MFA-TR*           ,POLE_DESC                                                    
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,PREMISE_NO                                                   
MFA-TR*           ,ACCOUNT_TYPE                                                 
MFA-TR*           ,CUSTOMER_NAME                                                
MFA-TR*           ,LOCAL_OFFICE_NO                                              
MFA-TR*           ,LOCAL_OFFICE_DESC                                            
MFA-TR*           ,REVENUE_DISTRICT_ID                                          
MFA-TR*           ,REVENUE_DISTRICT_DESC                                        
MFA-TR*           ,SUBDIVISION_ID                                               
MFA-TR*           ,SUBDIVISION_NAME                                             
MFA-TR*           ,HOUSE_NO                                                     
MFA-TR*           ,ADDR_PREFIX_1                                                
MFA-TR*           ,ADDR_PREFIX_2                                                
MFA-TR*           ,STREET_NAME                                                  
MFA-TR*           ,STREET_LOCATION_1                                            
MFA-TR*           ,STREET_LOCATION_2                                            
MFA-TR*           ,STREET_SUFFIX                                                
MFA-TR*           ,ADDRESS_OVERFLOW                                             
MFA-TR*           ,ZIP_CODE                                                     
MFA-TR*           ,ZIP_CODE_PLUS_FOUR                                           
MFA-TR*           ,ZIP_CODE_TOKEN                                               
MFA-TR*           ,ADDR_SUFFIX                                                  
MFA-TR*           ,TOWN                                                         
MFA-TR*           ,STATE                                                        
MFA-TR*           ,FIXTURE_INSTALL_DATE                                         
MFA-TR*           ,FIXTURE_STOCK_CODE                                           
MFA-TR*           ,FIXTURE_RATE_ITEM_CD                                         
MFA-TR*           ,FXTR_RATE_ITEM_CD_DESC                                       
MFA-TR*           ,POLE_STOCK_CODE                                              
MFA-TR*           ,POLE_RATE                                                    
MFA-TR*           ,POLE_RATE_ITEM_CD                                            
MFA-TR*           ,POLE_RATE_ITEM_CODE_DESC                                     
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-F-RETURN-CODE                                             
MFA-TR*           ,:S-F-FIXTURE-TAG-NO                                          
MFA-TR*           ,:S-F-FIXTURE-DESC                                            
MFA-TR*           ,:S-F-FIXTURE-INV-STATUS                                      
MFA-TR*           ,:S-F-FIXTURE-RATE-PLAN-NO                                    
MFA-TR*           ,:S-F-POLE-NO                                                 
MFA-TR*           ,:S-F-POLE-DESC                                               
MFA-TR*           ,:S-F-CUSTOMER-NO                                             
MFA-TR*           ,:S-F-ACCOUNT-NO                                              
MFA-TR*           ,:S-F-PREMISE-NO                                              
MFA-TR*           ,:S-F-ACCOUNT-TYPE                                            
MFA-TR*           ,:S-F-CUSTOMER-NAME                                           
MFA-TR*           ,:S-F-LOCAL-OFFICE-NO                                         
MFA-TR*           ,:S-F-LOCAL-OFFICE-DESC                                       
MFA-TR*           ,:S-F-REVENUE-DISTRICT-ID                                     
MFA-TR*           ,:S-F-REVENUE-DISTRICT-DESC                                   
MFA-TR*           ,:S-F-SUBDIVISION-ID                                          
MFA-TR*           ,:S-F-SUBDIVISION-NAME                                        
MFA-TR*           ,:S-F-HOUSE-NO                                                
MFA-TR*           ,:S-F-ADDR-PREFIX-1                                           
MFA-TR*           ,:S-F-ADDR-PREFIX-2                                           
MFA-TR*           ,:S-F-STREET-NAME                                             
MFA-TR*           ,:S-F-STREET-LOCATION-1                                       
MFA-TR*           ,:S-F-STREET-LOCATION-2                                       
MFA-TR*           ,:S-F-STREET-SUFFIX                                           
MFA-TR*           ,:S-F-ADDRESS-OVERFLOW                                        
MFA-TR*           ,:S-F-ZIP-CODE                                                
MFA-TR*           ,:S-F-ZIP-CODE-PLUS-FOUR                                      
MFA-TR*           ,:S-F-ZIP-CODE-TOKEN                                          
MFA-TR*           ,:S-F-ADDR-SUFFIX                                             
MFA-TR*           ,:S-F-TOWN                                                    
MFA-TR*           ,:S-F-STATE                                                   
MFA-TR*           ,:S-FIXTURE-INSTALL-DATE                                      
MFA-TR*           ,:S-FIXTURE-STOCK-CODE                                        
MFA-TR*           ,:S-FIXTURE-RATE-ITEM-CD                                      
MFA-TR*           ,:S-FXTR-RATE-ITEM-CD-DESC                                    
MFA-TR*           ,:S-POLE-STOCK-CODE                                           
MFA-TR*           ,:S-POLE-RATE                                                 
MFA-TR*           ,:S-POLE-RATE-ITEM-CD                                         
MFA-TR*           ,:S-POLE-RATE-ITEM-CODE-DESC                                  
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-FXTR           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04824_FXTR'           TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              MOVE LINK-FIXTURE-EQUIP-TAG-NO TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100A-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-F-RETURN-CODE               
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-FXTR    THRU  0100A-EXIT.          
      *                                                                         
           PERFORM 8100A-SEND-RESULT-FXTR    THRU  8100A-EXIT.          
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE    THRU  9900-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE  THRU  8900-EXIT.                     
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
