       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04822.                                      
       AUTHOR.        SAKTHIVEL MATHIYAZHAGAN.                          
COB303 DATE-WRITTEN.     OCTOBER 20,2014.                               
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04822              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--                                                            --         
      *--  # UPDATE UNREGULATED CONTRACT DEATILS AND RELATED         --         
      *--    JOURNAL PROCESS.                                        --         
      *--                                                            --         
      *--  # REFER CPD04822 COPYBOOK FOR MORE DETAIL ON PGM.         --         
      *--  # CLONED FROM CSR02043 & CPD00132.                        --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             I_APPL_CODE          CHAR(10)                  --         
      *--             I_APPL_PGM_ID        CHAR(08)                  --         
      *--             I_APPL_PGM_ID        CHAR(10)                  --         
      *--             I_UPDATE_TYPE        CHAR(01)                  --         
      *--             I_PGM_CALLED_FROM    CHAR(01)                  --         
      *--             I_ACCOUNT_NO         CHAR(13)                  --         
      *--             I_CODE_CONTRACT_TYPE CHAR(01)                  --         
      *--             I_CNT_STATUS_CODE    CHAR(01)                  --         
      *--             I_CNT_NAME_CD        SMALLINT                  --         
      *--             I_CNT_ITEM_ID        INTEGER                   --         
      *--             I_DATE_CONTRACT      CHAR(10)                  --         
      *--             I_AMT_MO_PYMT        DECIMAL(11,2)             --         
      *--             I_DATE_PYMT_START    CHAR(10)                  --         
      *--             I_CODE_INTRST_METH   CHAR(01)                  --         
      *--             I_INTRST_RATE        DECIMAL(7,4)              --         
      *--             I_ADD_ON_INTRST      DECIMAL(9,2)              --         
      *--             I_NO_SCHED_PYMTS     SMALLINT                  --         
      *--             I_AMT_ORIG_ENTERED   DECIMAL(11,2)             --         
      *--             I_AMT_DOWN_PYMT      DECIMAL(11,2)             --         
      *--             I_AMT_TAX_STATE      DECIMAL(09,2)             --         
      *--             I_AMT_TAX_OTHER      DECIMAL(09,2)             --         
      *--             I_USER_ID            CHAR(07)                  --         
      *--             I_LIEN_CD            CHAR(01)                  --         
      *--             I_REBATE_AMOUNT      DECIMAL(9,2)              --         
      *--             I_REBATE_CD          CHAR(01)                  --         
      *--             I_CODE_BILL_TYPE     CHAR(01)                  --         
      *--             I_CNT_COMMENTS_TXT   CHAR(50)                  --         
      *--             I_REV_DISTRICT_CD    CHAR(03)                  --         
      *--             I_GL_ACCT_NO_ERN_INT DECIMAL(7,4)              --         
      *--             I_GL_ACCT_NO_DEF_INT DECIMAL(7,4)              --         
      *--             I_ADV_COLL           CHAR(01)                  --         
      *--             I_CNT_ADDL_DESC_TEXT CHAR(255)                 --         
      *--             I_DTL_CHRG_TYPE      CHAR(01)                  --         
      *--             I_DTL_GL_NO          DECIMAL(7,4)              --         
      *--             I_DTL_CHRG_AMT       DECIMAL(11,2)             --         
      *--             I_DTL_WRT_OFF_GL_NO  DECIMAL(7,4)              --         
      *--             I_DTL_DISP_FEE       DECIMAL(9,2)              --         
      *--             I_DTL_DISP_FEE       DECIMAL(9,2)              --         
      *--             I_DTL_INSP_FEE       DECIMAL(9,2)              --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--             RETURN_CODE          INTEGER                   --         
      *--             NEW_ITEM_ID          INTEGER                   --         
      *--             ACCT_XFER_TO         INTEGER                   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00851*--  10-20-2014    MS93554     UPDATE CONTRACT DETAILS         --         
A05136*--  08-23-2015    SM93554     ADDED FILING FEE AMT TO UPDATE  --         
      *--                ACT-160     IN CONTRACT DETAIL TABLE.        -         
A05136*--  11-12-2015    SM93554     ADDED TRANS COMMENT TO UPDATE   --         
      *--                ACT-299     MNT TRANS HIST TABLE.            -         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04822'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR UPDATE                          *        
      ******************************************************************        
           COPY CWS04822.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04822'.       
           05 MCSCB822                PIC X(08) VALUE 'MCSCB822'.       
           05 WS-N                    PIC X(01) VALUE 'N'.              
           05 WS-RED-FLAG             PIC X(01) VALUE 'R'.              
           05 WS-YELLOW-FLAG          PIC X(01) VALUE 'Y'.              
           05 WS-GREEN-FLAG           PIC X(01) VALUE 'G'.              
           05 GTT-NAME                PIC X(26)                         
                                            VALUE 'SESSION.CSR04822_R1'.
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05 RS-ITEM-ID               PIC S9(09)    COMP VALUE +0.     
           05 RS-ACCT-XFER-TO          PIC X(13)     VALUE SPACE.       
           05 RS-AR-LOCKOUT-IND        PIC  X(01)    VALUE SPACE.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05  S-ITEM-ID               PIC S9(09)    COMP VALUE +0.     
           05  S-ACCT-XFER-TO          PIC X(13)     VALUE SPACE.       
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-CODE          PIC X(10).                           
       01  PARM-APPL-PGM-ID        PIC X(08).                           
       01  PARM-UPDATE-TYPE        PIC X(01).                           
       01  PARM-PGM-CALLED-FROM    PIC X(01).                           
       01  PARM-ACCOUNT-NO         PIC X(13).                           
       01  PARM-CODE-CONTRACT-TYPE PIC X(01).                           
       01  PARM-CNT-STATUS-CD      PIC X(01).                           
       01  PARM-CNT-NAME-CD        PIC S9(04) USAGE COMP.               
       01  PARM-CNT-ITEM-ID        PIC S9(09) USAGE COMP.               
       01  PARM-DATE-CONTRACT      PIC X(10).                           
COB305 01 PARM-AMT-MO-PYMT        PIC S9(09)V9(02) USAGE COMP-3 VALUE 0.       
       01  PARM-DATE-PYMT-START    PIC X(10).                           
       01  PARM-CODE-INTRST-METH   PIC X(01).                           
COB305 01 PARM-INTRST-RATE        PIC S9(03)V9(04) USAGE COMP-3 VALUE 0.       
COB305 01 PARM-ADD-ON-INTRST        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
       01  PARM-NO-SCHED-PYMTS     PIC S9(04) USAGE COMP.               
COB305 01 PARM-AMT-ORIG-ENTERED        PIC S9(09)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-AMT-DOWN-PYMT        PIC S9(09)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-AMT-TAX-STATE        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-AMT-TAX-CITY        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-AMT-TAX-OTHER        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-LIEN-CD            PIC X(01).                           
COB305 01 PARM-REBATE-AMOUNT        PIC S9(07)V99 USAGE COMP-3 VALUE 0.         
       01  PARM-REBATE-CD          PIC X(01).                           
       01  PARM-CODE-BILL-TYPE     PIC X(01).                           
       01  PARM-CNT-COMMENTS-TXT   PIC X(50).                           
       01  PARM-REV-DISTRICT-CD    PIC X(03).                           
COB305 01 PARM-GL-ACCT-NO-ERN-INT        PIC S9(3)V9(04) USAGE COMP-3 
COB305       VALUE 0.        
COB305 01 PARM-GL-ACCT-NO-DEF-INT        PIC S9(3)V9(04) USAGE COMP-3 
COB305       VALUE 0.        
       01  PARM-ADV-COLL           PIC X(01).                           
       01  PARM-CNT-ADDL-DESC-TEXT PIC X(255).                          
       01  PARM-DTL-CHRG-TYPE      PIC X(01).                           
COB305 01 PARM-DTL-GL-NO        PIC S9(03)V9(04) USAGE COMP-3 VALUE 0.       
COB305 01 PARM-DTL-CHRG-AMT        PIC S9(09)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-DTL-WRT-OFF-GL-NO        PIC S9(03)V9(04) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-DTL-DISP-FEE        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-DTL-INSP-FEE        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
COB305 01 PARM-DTL-FILING-FEE        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
       01  PARM-COST-CENTER        PIC X(03).                           
COB305 01 PARM-DEFERRED-INTEREST        PIC S9(07)V9(02) USAGE COMP-3 
COB305       VALUE 0.       
ACT299 01  PARM-CNT-TRAN-COMMENT   PIC X(210) VALUE SPACES.             
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-CODE                         
                                 PARM-APPL-PGM-ID                       
                                 PARM-UPDATE-TYPE                       
                                 PARM-PGM-CALLED-FROM                   
                                 PARM-ACCOUNT-NO                        
                                 PARM-CODE-CONTRACT-TYPE                
                                 PARM-CNT-STATUS-CD                     
                                 PARM-CNT-NAME-CD                       
                                 PARM-CNT-ITEM-ID                       
                                 PARM-DATE-CONTRACT                     
                                 PARM-AMT-MO-PYMT                       
                                 PARM-DATE-PYMT-START                   
                                 PARM-CODE-INTRST-METH                  
                                 PARM-INTRST-RATE                       
                                 PARM-ADD-ON-INTRST                     
                                 PARM-NO-SCHED-PYMTS                    
                                 PARM-AMT-ORIG-ENTERED                  
                                 PARM-AMT-DOWN-PYMT                     
                                 PARM-AMT-TAX-STATE                     
                                 PARM-AMT-TAX-CITY                      
                                 PARM-AMT-TAX-OTHER                     
                                 PARM-USER-ID                           
                                 PARM-LIEN-CD                           
                                 PARM-REBATE-AMOUNT                     
                                 PARM-REBATE-CD                         
                                 PARM-CODE-BILL-TYPE                    
                                 PARM-CNT-COMMENTS-TXT                  
                                 PARM-REV-DISTRICT-CD                   
                                 PARM-GL-ACCT-NO-ERN-INT                
                                 PARM-GL-ACCT-NO-DEF-INT                
                                 PARM-ADV-COLL                          
                                 PARM-CNT-ADDL-DESC-TEXT                
                                 PARM-DTL-CHRG-TYPE                     
                                 PARM-DTL-GL-NO                         
                                 PARM-DTL-CHRG-AMT                      
                                 PARM-DTL-WRT-OFF-GL-NO                 
                                 PARM-DTL-DISP-FEE                      
                                 PARM-DTL-INSP-FEE                      
ACT160                           PARM-DTL-FILING-FEE                    
                                 PARM-COST-CENTER                       
                                 PARM-DEFERRED-INTEREST                 
ACT299                           PARM-CNT-TRAN-COMMENT.                 
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE.                                               *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04822_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04822_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,NEW_ITEM_ID             INT                     
                   ,ACCT_XFER_TO CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,NEW_ITEM_ID                                      
                      ,ACCT_XFER_TO                                     
                  FROM #CSR04822_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,NEW_ITEM_ID                                              
MFA-TR*               ,ACCT_XFER_TO                                             
MFA-TR*           FROM SESSION.CSR04822_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
      *    CONTRACT HEADER INFORMATION.                                         
           MOVE PARM-APPL-CODE            TO WS-4822-CNT-APPL-CODE      
           MOVE PROGRAM-NAME              TO WS-4822-CNT-APPL-PGM-ID    
           MOVE PARM-UPDATE-TYPE          TO WS-4822-UPDATE-TYPE        
           MOVE PARM-APPL-PGM-ID          TO WS-4822-CNT-APPL-PGM-ID    
           MOVE PARM-PGM-CALLED-FROM      TO WS-4822-PGM-CALLED-FROM    
           MOVE PARM-ACCOUNT-NO           TO WS-4822-ACCOUNT-NO         
           MOVE PARM-CODE-CONTRACT-TYPE   TO WS-4822-CODE-CONTRACT-TYPE 
           MOVE PARM-CNT-STATUS-CD        TO WS-4822-CNT-STATUS-CD      
           MOVE PARM-CNT-NAME-CD          TO WS-4822-CNT-NAME-CD        
           MOVE PARM-CNT-ITEM-ID          TO WS-4822-CNT-ITEM-ID        
           MOVE PARM-DATE-CONTRACT        TO WS-4822-DATE-CONTRACT      
           MOVE PARM-AMT-MO-PYMT          TO WS-4822-AMT-MO-PYMT        
           MOVE PARM-DATE-PYMT-START      TO WS-4822-DATE-PYMT-START    
           MOVE PARM-CODE-INTRST-METH     TO WS-4822-CODE-INTRST-METH   
           MOVE PARM-INTRST-RATE          TO WS-4822-INTRST-RATE        
           MOVE PARM-ADD-ON-INTRST        TO WS-4822-ADD-ON-INTRST      
           MOVE PARM-NO-SCHED-PYMTS       TO WS-4822-NO-SCHED-PYMTS     
           MOVE PARM-AMT-ORIG-ENTERED     TO WS-4822-AMT-ORIG-ENTERED   
           MOVE PARM-AMT-DOWN-PYMT        TO WS-4822-AMT-DOWN-PYMT      
           MOVE PARM-AMT-TAX-STATE        TO WS-4822-AMT-TAX-STATE      
           MOVE PARM-AMT-TAX-CITY         TO WS-4822-AMT-TAX-CITY       
           MOVE PARM-AMT-TAX-OTHER        TO WS-4822-AMT-TAX-OTHER      
           MOVE PARM-USER-ID              TO WS-4822-USER-ID            
           MOVE PARM-LIEN-CD              TO WS-4822-LIEN-CD            
           MOVE PARM-REBATE-AMOUNT        TO WS-4822-REBATE-AMOUNT      
           MOVE PARM-REBATE-CD            TO WS-4822-REBATE-CD          
           MOVE PARM-CODE-BILL-TYPE       TO WS-4822-CODE-BILL-TYPE     
           MOVE PARM-CNT-COMMENTS-TXT     TO WS-4822-CNT-COMMENTS-TXT   
           MOVE PARM-REV-DISTRICT-CD      TO WS-4822-REV-DISTRICT-CD    
           MOVE PARM-GL-ACCT-NO-ERN-INT   TO WS-4822-GL-ACCT-NO-ERN-INT 
           MOVE PARM-GL-ACCT-NO-DEF-INT   TO WS-4822-GL-ACCT-NO-DEF-INT 
           MOVE PARM-ADV-COLL             TO WS-4822-ADV-COLL           
           MOVE PARM-CNT-ADDL-DESC-TEXT   TO WS-4822-CNT-ADDL-DESC-TEXT 
           MOVE PARM-DEFERRED-INTEREST    TO WS-4822-DEFERRED-INTEREST  
ACT299     MOVE PARM-CNT-TRAN-COMMENT     TO                            
ACT299                                    WS-4822-CNT-TRAN-COMMENT-TXT. 
                                                                        
      *    CONTRACT DETAILS INFORMATION.                                        
           MOVE PARM-DTL-CHRG-TYPE        TO WS-4822-DTL-CHRG-TYPE.     
           MOVE PARM-DTL-GL-NO            TO WS-4822-DTL-GL-NO.         
           MOVE PARM-DTL-CHRG-AMT         TO WS-4822-DTL-CHRG-AMT.      
           MOVE PARM-DTL-WRT-OFF-GL-NO    TO WS-4822-DTL-WRT-OFF-GL-NO. 
           MOVE PARM-DTL-DISP-FEE         TO WS-4822-DTL-DISP-FEE.      
           MOVE PARM-DTL-INSP-FEE         TO WS-4822-DTL-INSP-FEE.      
ACT160     MOVE PARM-DTL-FILING-FEE       TO WS-4822-DTL-FILING-FEE.    
           MOVE PARM-COST-CENTER          TO WS-4822-COST-CENTER.       
                                                                        
      *    WE ARE NOT SENDING THE STATUS CHANGE DATE FROM FRONT END.            
      *    IT HANDLED IN BACKEND ITSELF.                                        
           MOVE SPACES                    TO WS-4822-STATUS-CHANGE-DT.  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE  WS-4822-APPL-CNT-RETURN-CD.                      
           PERFORM 6000-UPDT-CONTRACT-ENTRIES THRU 6000-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-UPDT-CONTRACT-ENTRIES.                                  *          
      *****************************************************************         
       6000-UPDT-CONTRACT-ENTRIES.                                      
                                                                        
           CALL MCSCB822 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CONTRACT-HEADER-PARMS                 
                               WS-CONTRACT-DETAIL-PARMS                 
                               WS-CONTRACT-OPERATION-TYPE               
                               WS-CONTRACT-RETURN-INFO.                 
                                                                        
           IF CPD4822-DB2-ERR-FOUND AND                                 
              WS-4822-APPL-CNT-RETURN-CD EQUAL ZERO                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              MOVE WS-4822-APPL-CNT-RETURN-CD TO  S-RETURN-CODE         
              MOVE WS-4822-NEW-ITEM-ID        TO  S-ITEM-ID             
              MOVE WS-4822-ACCT-XFER-TO       TO  S-ACCT-XFER-TO        
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04822_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04822_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04822_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04822_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,NEW_ITEM_ID                                          
                  ,ACCT_XFER_TO                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-ITEM-ID                                           
                  ,:S-ACCT-XFER-TO                                      
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04822_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,NEW_ITEM_ID                                                  
MFA-TR*           ,ACCT_XFER_TO                                                 
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-ITEM-ID                                                   
MFA-TR*           ,:S-ACCT-XFER-TO                                              
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04822_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT.                                        *        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
