       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04821.                                         
       AUTHOR.        SHABNAM.                                          
COB303 DATE-WRITTEN.  OCTOBER 15, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES UNREGULATED CONTARCT HEADER AND DETAIL *        
      *  INFORMATION BASED ON THE CONTARCT NAME AND ITEM ID.           *        
      *                                                                *        
      *  CLONED FROM CSR02030.                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *# THIS SP WILL BE CALLED USING CIS MOD TO RETRIEVE THE EXISTING *        
      *  UNREGULATED CONTACT DETAILS AND TO SET-UP THE NEW CONTRACT.   *        
      *                                                                *        
      *# GET ALL EXISTING CONTRACT HEADER AND DETAIL ROWS WHEN CONTRACT*        
      *  ITEM ID PASSED GREATER THAN ZERO.                             *        
      *                                                                *        
      *# GET DEFAULT CONTRACT VALUES WHEN CONTRACT ITEM ID PASSED AS   *        
      *  ZERO.(ZERO WILL BE PASSED DURING NEW CONTRACT SET-UP)         *        
      *                                                                *        
      *# RETURN THE PAYMENT SCHEDULE RESULT SET WHEN THE BILLING OPTION*        
      *  IS INSTALLMENT AND INTEREST METHOD IS ADD-ON.                 *        
      *                                                                *        
      *# CONTRACT NAME CODE 1099,1199,305,101 AND 326 TREATED AS       *        
      *  ADVANCE COLLECTION CONTRACT AND THESE CONTRACT WILL NOT       *        
      *  BE HAVING ANY CONTRACT DETAIL ROWS IN CSS_CNT_DETAIL TABLE    *        
      *  INSTEAD NEED TO RETRIEVE ALL DEFAULT CONTRACT VALUES.         *        
      *                                                                *        
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           I_ACCOUNT_NO               DECIMAL(13)           --         
      *--           I_CNT_ITEM_ID              INTEGER               --         
      *--           I_CNT_NAME_CD              SMALLINT              --         
      *--                                                            --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--  CSR04821_R1 - CONTRACT DETAILS                            --         
      *--                                                            --         
      *--           RETURN_CODE              INTEGER                 --         
      *--          ,CNT_ITEM_ID              INTEGER                 --         
      *--          ,CODE_BILL_TYPE           CHAR(1)                 --         
      *--          ,COMPANY_NO               CHAR(2)                 --         
      *--          ,CODE_CONTRACT_TYPE       CHAR(1)                 --         
      *--          ,CNT_NAME_CD              SMALLINT                --         
      *--          ,CNT_STATUS_CD            CHAR(1)                 --         
      *--          ,DATE_CONTRACT            CHAR(10)                --         
      *--          ,STATUS_CHANGE_DT         CHAR(10)                --         
      *--          ,CHARGE_AMOUNT            DECIMAL(11,2)           --         
      *--          ,AMT_DOWN_PYMT            DECIMAL(11,2)           --         
      *--          ,AMT_ORIG_ENTERED         DECIMAL(11,2)           --         
      *--          ,NO_SCHED_PYMTS           SMALLINT                --         
      *--          ,AMT_MO_PYMT              DECIMAL(11,2)           --         
      *--          ,DATE_PYMT_START          CHAR(10)                --         
      *--          ,DATE_PYMT_END            CHAR(10)                --         
      *--          ,UNBILLED_AMT             DECIMAL(09,2)           --         
      *--          ,STATE_TAX                DECIMAL(09,2)           --         
      *--          ,CITY_TAX                 DECIMAL(09,2)           --         
      *--          ,OTHER_TAX                DECIMAL(09,2)           --         
      *--          ,CODE_INTRST_METH         CHAR(1)                 --         
      *--          ,INTRST_RATE              DECIMAL(07,4)           --         
      *--          ,SIMPLE_INT_FIN_CHG       DECIMAL(07,4)           --         
      *--          ,INTRST_YTD               DECIMAL(09,2)           --         
      *--          ,DISPOSAL_FEE_AM          DECIMAL(09,2)           --         
      *--          ,INSPECTION_FEE_AM        DECIMAL(09,2)           --         
      *--          ,FILING_FEE_AM            DECIMAL(09,2)           --         
      *--          ,CHARGE_TYPE_CD           CHAR(1)                 --         
      *--          ,GL_ACCT_NO               DECIMAL(07,4)           --         
      *--          ,USER_ID                  CHAR(40)                --         
      *--          ,LIEN_CD                  CHAR(1)                 --         
      *--          ,CONTRACT_COMMENTS        CHAR(50)                --         
      *--          ,REV_DISTRICT_CD          CHAR(3)                 --         
      *--          ,GL_ACCT_NO_ERN_INT       DECIMAL(07,4)           --         
      *--          ,GL_ACCT_NO_DEF_INT       DECIMAL(07,4)           --         
      *--          ,WRT_OFF_GL_ACCT_NO       DECIMAL(07,4)           --         
      *--          ,AMT_DEF_INTEREST         DECIMAL(09,2)           --         
      *--          ,CNT_XFER_ACCT_NO         DECIMAL(13,0)           --         
      *--          ,ADDL_DESC_IND            CHAR(01)                --         
      *--          ,ADVANCE_COLL_FLAG        CHAR(01)                --         
      *--          ,REV_MTH_LST_NRML         CHAR(10)                --         
      *--          ,CNT_ADDL_DESC            CHAR(25)                --         
      *--          ,TOT_AMT_TRANS_BAL        DECIMAL(11,2)           --         
      *--          ,CODE_BILL_FREQ           CHAR(03)                --         
      *--          ,TRAN_BALANCE             DECIMAL(11,2)           --         
      *--          ,TOTAL_CHARGE             DECIMAL(11,2)           --         
      *--          ,TOTAL_CONTRACT           DECIMAL(11,2)           --         
      *--          ,CURRENT_BALANCE          DECIMAL(11,2)           --         
      *--          ,SETUP_NAME               CHAR(40)                --         
      *--          ,COST_CENTER              CHAR(03)                --         
      *--          ,MIN_TERM_MO_NM           DEC(3,0)                --         
      *--          ,MAX_TERM_MO_NM           DEC(3,0)                --         
      *--          ,MIN_INTRST_RT            DEC(7,4)                --         
ACT181*--          ,CONTRACT_TAXABLE_FL      CHAR(1)                 --         
ACT181*--          ,TAX_RATE                 DEC(5,4)                --         
ACT181*--          ,INTRST_PRIOR_YR          DEC(9,2)                --         
      *--                                                            --         
      *--  CSR04821_R2 - PAYMENT SCHEDULE DETAILS                    --         
      *--                                                            --         
      *--           RETURN_CODE              INTEGER                 --         
      *--          ,CNT_ITEM_ID_2            INTEGER                 --         
      *--          ,MONTH                    SMALLINT                --         
      *--          ,OPENING_BALANCE          DECIMAL(11,2)           --         
      *--          ,INTEREST                 DECIMAL(11,2)           --         
      *--          ,PRINCIPAL                DECIMAL(11,2)           --         
      *--          ,CLOSING_BALANCE          DECIMAL(11,2)           --         
      *--          ,TOTAL_INTEREST           DECIMAL(11,2)           --         
      *--                                                            --         
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *    ------    --------   -------------------------------------  *        
      *  10/15/2014  SS7F226    NEW PROGRAM                            *        
A05136*  09/16/2015  SM93554    DETERMINE THE PAYMENT AMOUNT FOR       *        
A05136*              ACT177     CLOSED AND PAID CUSTOMER.              *        
A05136*  11/19/2015  SM93554    REMOVE THE JUNK VALUE FROM VARCHAR     *        
A05136*              ACT238     FIELDS.                                *        
A05460*  05/26/2016  MS7M727    TO ADD CONTRACT_TAXABLE_FL,TAX_RATE,   *        
A05460*              ACT181     INTRST_PRIOR_YR FIELD IN RESULT SET 1  *        
ACT278*  10/18/2016  TP7R341    REMOVE UNWANTED COLUMNS FROM CONTRACT  *        
ACT278*              ACT278     TABLE                                  *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04821'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04821 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CONTRACT       (CT)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CONTRACT_INFO  (K6)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTINF                                                  
           END-EXEC.                                                            
                                                                        
ACT181******************************************************************        
ACT181*    CSS_TAX_RATE       (TR)                                     *        
ACT181******************************************************************        
ACT181     EXEC SQL                                                             
ACT181        INCLUDE TBTXRATE                                                  
ACT181     END-EXEC.                                                            
ACT181                                                                  
      ******************************************************************        
      *    CSS_CNT_DETAIL     (EA)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_WINDOW    (BN)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        (AT)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_AR_CNTL        (AC)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_USER_PROFILE   (PF)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PREMISE        (PR)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MODEL_SQL      (MS)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY    (C8)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WS ABEND WORK AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
           COPY CWS00056.                                                       
                                                                        
      ******************************************************************        
      *    FOR NEXT BILLING DATE CALCULATION COPY BOOK                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS2            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)   VALUE 'CSR04821'.     
           05  WS-PYMT-PRIORITY-LVL    PIC S9(4)  COMP   VALUE 100.     
           05  WS-NEW-CNT-ITEM-ID      PIC S9(9)  COMP   VALUE 0.       
           05  WS-MIN-CIS-CNT-ID       PIC S9(9)  COMP   VALUE 5000000. 
           05  WS-MIN-BPI-CNT-ID       PIC S9(9)  COMP   VALUE 9000000. 
           05  WS-MIN-PACE-CNT-ID      PIC S9(9)  COMP   VALUE 9500000. 
           05  WS-MIN-CNT-ID           PIC S9(9)  COMP   VALUE 9500999. 
           05  WS-NULL-DATE-IND        PIC S9(4)  COMP.                 
           05  WS-NULL-DATE-IND-AT     PIC S9(4)  COMP.                 
           05  WS-NULL-BILL-FRQ-AT     PIC S9(4)  COMP.                 
           05  WS-NULL-AMT-IND-AC      PIC S9(4)  COMP.                 
           05  WS-ITEM-ID-NULL-IND     PIC S9(4)  COMP.                 
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  WS-LAST-BILL-DATE       PIC X(10).                       
           05  WS-MIN-DATE             PIC X(10).                       
           05  WS-NEXT1-BILL-DATE      PIC X(10).                       
           05  WS-NEXT2-BILL-DATE      PIC X(10).                       
           05  WS-HOLD-DATE.                                            
               10  WS-DATE-CCYY        PIC 9(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-DATE-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DATE-DD          PIC 9(02).                       
           05  WS-BILL-FREQ.                                            
               10  WS-FREQ-CODE        PIC X(01).                       
               10  WS-START-MONTH      PIC 9(02).                       
           05  WS-INTERVAL             PIC 9(02).                       
           05  WS-CNT-PRESENT          PIC X(01).                       
           05  WS-CONTRACT-STATUS      PIC X(01).                       
           05  ACTIVE-CONTRACT         PIC X(01) VALUE 'B'.             
           05  PENDING-CONTRACT        PIC X(01) VALUE 'A'.             
           05  PAID-CONTRACT           PIC X(01) VALUE 'C'.             
           05  CANCELLED-CONTRACT      PIC X(01) VALUE 'D'.             
           05  CLOSED-CONTRACT         PIC X(01) VALUE 'E'.             
           05  REPOD-CONTRACT          PIC X(01) VALUE 'P'.             
           05  TRANSFERED-CONTRACT     PIC X(01) VALUE 'R'.             
           05  REFINANCED-CONTRACT     PIC X(01) VALUE 'F'.             
           05  WS-INSTALLMENT          PIC X(01) VALUE 'C'.             
           05  WS-COMMA                PIC X(02) VALUE ', '.            
           05  WS-SPACE                PIC X(01) VALUE ' '.             
           05  WS-ADD-ON               PIC X(01) VALUE 'B'.             
           05  WS-ZERO                 PIC S9(4) COMP VALUE 0.          
           05  WS-PACE-CONTRBTN        PIC S9(4) COMP VALUE 918.        
           05  WS-BILL-INS1            PIC S9(4) COMP VALUE 526.        
           05  WS-BILL-INS2            PIC S9(4) COMP VALUE 527.        
           05  WS-BILL-INS-SEB         PIC S9(4) COMP VALUE 528.        
           05  WS-TOT-AMT-TRANS-BAL    PIC S999999999V99 USAGE COMP-3   
                                                        VALUE 0.        
           05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
           05  WS-CONTRACT-DTLS        PIC X(01).                       
               88  GET-EXISTING-CONTARCT-DTLS    VALUE 'Y'.             
               88  GET-DEFAULT-CONTARCT-DTLS     VALUE 'N'.             
           05  REFORMAT-DATE.                                           
               10  WS-FORMAT-YEAR      PIC X(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-MONTH     PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-DAY       PIC X(02).                       
           05  USA-DATE-FORMAT.                                         
               10  USA-MONTH           PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-DAY             PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-YEAR            PIC X(04).                       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING              PIC X(01) VALUE 'P'.             
ACT181     05  WS-NC-STATE-SALES-TAX   PIC S9(4) COMP VALUE 11.         
           05  WS-PAID                 PIC X(01) VALUE 'C'.             
           05  WS-CLOSED               PIC X(01) VALUE 'E'.             
           05  STOP-CONTRACT-FETCH     PIC X(01) VALUE 'N'.             
           05  WS-ADVANCE-COLL         PIC X(01) VALUE 'N'.             
           05  WS-FIRST-BALANCE        PIC X(01) VALUE 'N'.             
           05  WS-FIRST-INTRST         PIC X(01) VALUE 'N'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
                                                                        
       01  WS-RETURN-GRP2.                                              
           05  WS-MONTHLY-RATE         PIC                              
                                       S9(9)V99999999   COMP-3 VALUE 0. 
           05  WS-TOTAL-INTEREST       PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-INTRST-RATE          PIC S999V9999    COMP-3 VALUE 0. 
           05  WS-NO-SCHED-PYMTS       PIC S9(4)        COMP VALUE 0.   
           05  WS-MNTHLY-PYMNT-AMT     PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-OPENING-BALANCE      PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-SCHD-COUNT           PIC S9(4)        COMP VALUE 0.   
                                                                        
       01  WS-WORK-AREA-FIELDS.                                         
           05  WS-CHARGE-AMOUNT        PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-CODE-BILL-TYPE       PIC X(1)         VALUE SPACE.    
           05  WS-CD-INTRST-METH       PIC X(1)         VALUE SPACE.    
           05  WS-SIMPLE-INT-FIN-CHG   PIC S9999V9999   COMP-3 VALUE 0. 
           05  WS-TRAN-BALANCE         PIC S9(7)V99     COMP-3 VALUE 0. 
           05  WS-CNT-ITEM-ID          PIC S9(9)        COMP VALUE 0.   
           05  WS-AMT-ORIG-ENTERED     PIC S9(9)V99     COMP-3 VALUE 0. 
ACT181     05  WS-CNT-TAXABLE-FL       PIC X(01) VALUE 'N'.             
ACT181     05  WS-TAX-RATE             PIC S9(9)V9999   COMP-3 VALUE 0. 
ACT181     05  WS-CNT-NAME-CD          PIC S9(4)        USAGE COMP.     
ACT181     05  WS-REV-DISTRICT-CD      PIC X(3)         VALUE SPACE.    
           05  WS-INTEREST-MON-TEMP    PIC S9(9)V999    COMP-3 VALUE 0. 
           05  WS-INTEREST-MON         PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-PRINCIPAL            PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-CLOSING-BALANCE      PIC S9(9)V99     COMP-3 VALUE 0. 
           05  WS-IN-CNT-ITEM-ID       PIC S9(9)        USAGE COMP.     
           05  WS-IN-CNT-NAME-CD       PIC S9(4)        USAGE COMP.     
           05  WS-TOTAL-CHARGE         PIC S999999999V99 USAGE COMP-3   
                                                       VALUE 0.         
           05  WS-TOTAL-CONTRACT       PIC S999999999V99 USAGE COMP-3   
                                                       VALUE 0.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS-1.                                         
           05  S-RETURN-CODE-1        PIC S9(9)        COMP VALUE 0.    
           05  S-CNT-ITEM-ID          PIC S9(9)        COMP VALUE 0.    
           05  S-CODE-BILL-TYPE       PIC X(1)         VALUE SPACE.     
           05  S-COMPANY-NO           PIC X(2)         VALUE SPACE.     
           05  S-CODE-CONTRACT-TYPE   PIC X(1)         VALUE SPACE.     
           05  S-CNT-NAME-CD          PIC S9(4)        COMP VALUE 0.    
           05  S-CNT-STATUS-CD        PIC X(1)         VALUE SPACE.     
           05  S-DATE-CONTRACT        PIC X(10)        VALUE SPACE.     
           05  S-STATUS-CHANGE-DT     PIC X(10)        VALUE SPACE.     
           05  S-CHARGE-AMOUNT        PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-AMT-DOWN-PYMT        PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-AMT-ORIG-ENTERED     PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-NO-SCHED-PYMTS       PIC S9(4)        COMP VALUE 0.    
           05  S-AMT-MO-PYMT          PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-DATE-PYMT-START-1    PIC X(10)        VALUE SPACE.     
           05  S-DATE-PYMT-END        PIC X(10)        VALUE SPACE.     
           05  S-UNBILLED-AMT         PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-STATE-TAX            PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-CITY-TAX             PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-OTHER-TAX            PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-CD-INTRST-METH       PIC X(1)         VALUE SPACE.     
           05  S-INTRST-RATE          PIC S999V9999    COMP-3 VALUE 0.  
           05  S-SIMPLE-INT-FIN-CHG   PIC S9999V9999   COMP-3 VALUE 0.  
           05  S-INTRST-YTD           PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-WHT-GDS-DISP-FEE     PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-INSPECTION-FEE       PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-FILING-FEE-AM        PIC S9(7)V9(2)   USAGE COMP-3     
                                                       VALUE 0.         
           05  S-CHARGE-TYPE          PIC X(1)         VALUE SPACE.     
           05  S-GL-ACCT-NO           PIC S9(3)V9999   COMP-3 VALUE 0.  
           05  S-USER-ID              PIC X(08)        VALUE SPACE.     
           05  S-LIEN-CD              PIC X(1)         VALUE 'N'.       
           05  S-CONTRACT-COMMENTS    PIC X(50)        VALUE SPACE.     
           05  S-REV-DISTRICT-CD      PIC X(3)         VALUE SPACE.     
           05  S-GL-ACCT-NO-ERN-INT   PIC S9(3)V9999   COMP-3 VALUE 0.  
           05  S-GL-ACCT-NO-DEF-INT   PIC S9(3)V9999   COMP-3 VALUE 0.  
           05  S-WRT-OFF-GL-ACCT-NO   PIC S9(3)V9999   COMP-3 VALUE 0.  
           05  S-AMT-DEF-INT          PIC S9(7)V99     COMP-3 VALUE 0.  
           05  S-XFER-ACCT-NO         PIC S9(13)       COMP-3 VALUE 0.  
           05  S-ADDL-DESC-IND        PIC X(01)        VALUE SPACE.     
           05  S-ADVANCE-COLL         PIC X(01)        VALUE SPACE.     
           05  S-LAST-BILL-DATE       PIC X(10)        VALUE SPACE.     
           05  S-CNT-ADDL-DESC        PIC X(255)       VALUE SPACES.    
           05  S-TOT-AMT-TRANS-BAL    PIC S999999999V99 USAGE COMP-3    
                                                       VALUE 0.         
           05  S-CODE-BILL-FREQ       PIC X(3)         VALUE SPACES.    
           05  S-AMT-TRAN-BALANCE     PIC S999999999V99 USAGE COMP-3    
                                                       VALUE 0.         
           05  S-TOTAL-CHARGE         PIC S999999999V99 USAGE COMP-3    
                                                       VALUE 0.         
           05  S-TOTAL-CONTRACT       PIC S999999999V99 USAGE COMP-3    
                                                       VALUE 0.         
           05  S-CURRENT-BAL          PIC S999999999V99 USAGE COMP-3    
                                                       VALUE 0.         
           05  S-SETUP-NAME           PIC X(40)        VALUE SPACE.     
           05  S-COST-CENTER          PIC X(03)        VALUE SPACE.     
           05  S-MIN-TERM-MO-NM       PIC S9(3)  COMP-3 VALUE 0.        
           05  S-MAX-TERM-MO-NM       PIC S9(3)  COMP-3 VALUE 0.        
           05  S-MIN-INTRST-RT        PIC S9(3)V9999 COMP-3 VALUE 0.    
           05  S-MAX-INTRST-RT        PIC S9(3)V9999 COMP-3 VALUE 0.    
ACT181     05  S-CONTRACT-TAXABLE-FL  PIC X(01) VALUE 'N'.              
ACT181     05  S-TAX-RATE             PIC S9(3)V9999 COMP-3 VALUE 0.    
ACT181     05  S-INTRST-PRIOR-YR      PIC S9(7)V99   COMP-3 VALUE 0.    
                                                                        
       01  GTT-RETURN-FIELDS-2.                                         
           05  S-RETURN-CODE-2        PIC S9(9)        COMP VALUE 0.    
           05  S-CNT-ITEM-ID-2        PIC S9(9)        COMP VALUE 0.    
           05  S-MONTH                PIC S9(4)        COMP VALUE 0.    
           05  S-OPENING-BALANCE      PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-INTEREST             PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-PRINCIPAL            PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-CLOSING-BALANCE      PIC S9(9)V99     COMP-3 VALUE 0.  
           05  S-TOTAL-INTEREST       PIC S9(9)V99     COMP-3 VALUE 0.  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      *****************************************************************         
      *    CURSOR TO GET ALL EXISTING CONTRACT                                  
      *****************************************************************         
      *                                                                         
           EXEC SQL DECLARE CONTRACT_CURSOR CURSOR FOR                  
                 SELECT CT.CODE_CONTRACT_TYPE                           
                       ,CT.CNT_ITEM_ID                                  
                       ,CT.USER_ID                                      
                       ,CIS.CHAR2$DATE(CT.DATE_CONTRACT,'USA')                  
                       ,CT.CNT_NAME_CD                                  
                       ,CT.CNT_STATUS_CD                                
                       ,CIS.CHAR2$DATE(CT.STATUS_CHANGE_DT,'USA')               
                       ,CT.CODE_BILL_TYPE                               
                       ,CT.LIEN_CD                                      
                       ,CT.AMT_MO_PYMT                                  
                       ,CT.CONTRACT_COMMENTS                            
                       ,CT.AMT_DOWN_PYMT                                
                       ,CT.NO_SCHED_PYMTS                               
                       ,CT.REBATE_AMOUNT                                
                       ,CT.REBATE_CD                                    
                       ,CIS.CHAR2$DATE(CT.DATE_PYMT_START,'USA')                
                       ,CT.CODE_INTRST_METH                             
                       ,CT.INTRST_RATE                                  
                       ,CT.AMT_DEF_INTEREST                             
                       ,CT.INTRST_PRIOR_YR                              
                       ,CT.INTRST_YTD                                   
                       ,CT.REV_DISTRICT_CD                              
                       ,CT.GL_ACCT_NO_ERN_INT                           
                       ,CT.GL_ACCT_NO_DEF_INT                           
                       ,CT.SIMPLE_INT_FIN_CHG                           
                       ,CT.CNT_ADDL_DESC                                
                       ,CT.AMT_ORIG_ENTERED                             
                       ,CT.AMT_TAX_STATE                                
                       ,CT.AMT_TAX_CITY                                 
                       ,CT.AMT_TAX_OTHER                                
                   FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                   
                  WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO           
                    AND CT.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL    
                    AND CT.CNT_STATUS_CD                                
                     IN (:ACTIVE-CONTRACT,:REFINANCED-CONTRACT,         
                         :PENDING-CONTRACT,:TRANSFERED-CONTRACT,        
                         :PAID-CONTRACT,:CANCELLED-CONTRACT,            
                         :CLOSED-CONTRACT,:REPOD-CONTRACT)              
                     ORDER BY CNT_STATUS_CD                             
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE CONTRACT_CURSOR CURSOR FOR                          
MFA-TR*          SELECT CT.CODE_CONTRACT_TYPE                                   
MFA-TR*                ,CT.CNT_ITEM_ID                                          
MFA-TR*                ,CT.USER_ID                                              
MFA-TR*                ,CHAR(CT.DATE_CONTRACT,USA)                              
MFA-TR*                ,CT.CNT_NAME_CD                                          
MFA-TR*                ,CT.CNT_STATUS_CD                                        
MFA-TR*                ,CHAR(CT.STATUS_CHANGE_DT,USA)                           
MFA-TR*                ,CT.CODE_BILL_TYPE                                       
MFA-TR*                ,CT.LIEN_CD                                              
MFA-TR*                ,CT.AMT_MO_PYMT                                          
MFA-TR*                ,CT.CONTRACT_COMMENTS                                    
MFA-TR*                ,CT.AMT_DOWN_PYMT                                        
MFA-TR*                ,CT.NO_SCHED_PYMTS                                       
MFA-TR*                ,CT.REBATE_AMOUNT                                        
MFA-TR*                ,CT.REBATE_CD                                            
MFA-TR*                ,CHAR(CT.DATE_PYMT_START,USA)                            
MFA-TR*                ,CT.CODE_INTRST_METH                                     
MFA-TR*                ,CT.INTRST_RATE                                          
MFA-TR*                ,CT.AMT_DEF_INTEREST                                     
MFA-TR*                ,CT.INTRST_PRIOR_YR                                      
MFA-TR*                ,CT.INTRST_YTD                                           
MFA-TR*                ,CT.REV_DISTRICT_CD                                      
MFA-TR*                ,CT.GL_ACCT_NO_ERN_INT                                   
MFA-TR*                ,CT.GL_ACCT_NO_DEF_INT                                   
MFA-TR*                ,CT.SIMPLE_INT_FIN_CHG                                   
MFA-TR*                ,CT.CNT_ADDL_DESC                                        
MFA-TR*                ,CT.AMT_ORIG_ENTERED                                     
MFA-TR*                ,CT.AMT_TAX_STATE                                        
MFA-TR*                ,CT.AMT_TAX_CITY                                         
MFA-TR*                ,CT.AMT_TAX_OTHER                                        
MFA-TR*            FROM CSS_CONTRACT CT                                         
MFA-TR*           WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                   
MFA-TR*             AND CT.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
MFA-TR*             AND CT.CNT_STATUS_CD                                        
MFA-TR*              IN (:ACTIVE-CONTRACT,:REFINANCED-CONTRACT,                 
MFA-TR*                  :PENDING-CONTRACT,:TRANSFERED-CONTRACT,                
MFA-TR*                  :PAID-CONTRACT,:CANCELLED-CONTRACT,                    
MFA-TR*                  :CLOSED-CONTRACT,:REPOD-CONTRACT)                      
MFA-TR*              ORDER BY CNT_STATUS_CD                                     
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.          
       01   LINK-CNT-ITEM-ID         PIC S9(9)   USAGE COMP.            
       01   LINK-CNT-NAME-CD         PIC S9(4)   USAGE COMP.            
                                                                        
       PROCEDURE DIVISION USING LINK-ACCOUNT-NO                         
                                LINK-CNT-ITEM-ID                        
                                LINK-CNT-NAME-CD.                       
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-MAIN-CONTRACT-PROCESS                           
                                              THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                             *        
      *                                                                *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04821_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04821_R1
              (                                                          
               RETURN_CODE              INT                         
              ,CNT_ITEM_ID              INT                         
              ,CODE_BILL_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,CODE_CONTRACT_TYPE CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
              ,CNT_NAME_CD              SMALLINT                        
              ,CNT_STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,DATE_CONTRACT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,STATUS_CHANGE_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CHARGE_AMOUNT            DECIMAL(11,2)                   
              ,AMT_DOWN_PYMT            DECIMAL(11,2)                   
              ,AMT_ORIG_ENTERED         DECIMAL(11,2)                   
              ,NO_SCHED_PYMTS           SMALLINT                        
              ,AMT_MO_PYMT              DECIMAL(11,2)                   
              ,DATE_PYMT_START CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,DATE_PYMT_END CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,UNBILLED_AMT             DECIMAL(09,2)                   
              ,STATE_TAX                DECIMAL(09,2)                   
              ,CITY_TAX                 DECIMAL(09,2)                   
              ,OTHER_TAX                DECIMAL(09,2)                   
              ,CODE_INTRST_METH CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,INTRST_RATE              DECIMAL(07,4)                   
              ,SIMPLE_INT_FIN_CHG       DECIMAL(08,4)                   
              ,INTRST_YTD               DECIMAL(09,2)                   
              ,DISPOSAL_FEE_AM          DECIMAL(09,2)                   
              ,INSPECTION_FEE_AM        DECIMAL(09,2)                   
              ,FILING_FEE_AM            DECIMAL(09,2)                   
              ,GL_ACCT_NO               DECIMAL(07,4)                   
              ,USER_ID CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,LIEN_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,CONTRACT_COMMENTS CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,REV_DISTRICT_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,GL_ACCT_NO_ERN_INT       DECIMAL(07,4)                   
              ,GL_ACCT_NO_DEF_INT       DECIMAL(07,4)                   
              ,WRT_OFF_GL_ACCT_NO       DECIMAL(07,4)                   
              ,AMT_DEF_INTEREST         DECIMAL(09,2)                   
              ,CNT_XFER_ACCT_NO         DECIMAL(13,0)                   
              ,ADDL_DESC_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,ADVANCE_COLL_FLAG CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,REV_MTH_LST_NRML CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CNT_ADDL_DESC CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,TOT_AMT_TRANS_BAL        DECIMAL(11,2)                   
              ,CODE_BILL_FREQ CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,TRAN_BALANCE             DECIMAL(11,2)                   
              ,TOTAL_CHARGE             DECIMAL(11,2)                   
              ,TOTAL_CONTRACT           DECIMAL(11,2)                   
              ,CURRENT_BALANCE          DECIMAL(11,2)                   
              ,SETUP_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,COST_CENTER CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,MIN_TERM_MO_NM           DECIMAL(3,0)                        
              ,MAX_TERM_MO_NM           DECIMAL(3,0)                        
              ,MIN_INTRST_RT            DECIMAL(7,4)                        
              ,MAX_INTRST_RT            DECIMAL(7,4)                        
ACT181        ,CONTRACT_TAXABLE_FL CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
ACT181        ,TAX_RATE                 DECIMAL(5,4)                        
ACT181        ,INTRST_PRIOR_YR          DECIMAL(9,2)                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS   THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04821_R1'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                              THRU  9900-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,CNT_ITEM_ID                 AS CNT_ITEM_ID       
                      ,LTRIM(RTRIM(CODE_BILL_TYPE))       AS 
           CODE_BILL_TYPE    
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(CODE_CONTRACT_TYPE))   AS 
           CODE_CONTRACT_TYPE
                      ,CNT_NAME_CD                 AS CNT_NAME_CD       
                      ,LTRIM(RTRIM(CNT_STATUS_CD))        AS 
           CNT_STATUS_CD     
                      ,LTRIM(RTRIM(DATE_CONTRACT))        AS 
           DATE_CONTRACT     
                      ,LTRIM(RTRIM(STATUS_CHANGE_DT))     AS 
           STATUS_CHANGE_DT  
                      ,CHARGE_AMOUNT               AS CHARGE_AMOUNT     
                      ,AMT_DOWN_PYMT               AS AMT_DOWN_PYMT     
                      ,AMT_ORIG_ENTERED            AS AMT_ORIG_ENTERED  
                      ,NO_SCHED_PYMTS              AS NO_SCHED_PYMTS    
                      ,AMT_MO_PYMT                 AS AMT_MO_PYMT       
                      ,LTRIM(RTRIM(DATE_PYMT_START))      AS 
           DATE_PYMT_START   
                      ,LTRIM(RTRIM(DATE_PYMT_END))        AS 
           DATE_PYMT_END     
                      ,UNBILLED_AMT                AS UNBILLED_AMT      
                      ,STATE_TAX                   AS STATE_TAX         
                      ,CITY_TAX                    AS CITY_TAX          
                      ,OTHER_TAX                   AS OTHER_TAX         
                      ,LTRIM(RTRIM(CODE_INTRST_METH))     AS 
           CODE_INTRST_METH  
                      ,INTRST_RATE                 AS INTRST_RATE       
                      ,SIMPLE_INT_FIN_CHG          AS SIMPLE_INT_FIN_CHG
                      ,INTRST_YTD                  AS INTRST_YTD        
                      ,DISPOSAL_FEE_AM             AS DISPOSAL_FEE_AM   
                      ,INSPECTION_FEE_AM           AS INSPECTION_FEE_AM 
                      ,FILING_FEE_AM               AS FILING_FEE_AM     
                      ,GL_ACCT_NO                  AS GL_ACCT_NO        
                      ,LTRIM(RTRIM(USER_ID))              AS USER_ID           
                      ,LTRIM(RTRIM(LIEN_CD))              AS LIEN_CD           
                      ,LTRIM(RTRIM(CONTRACT_COMMENTS))    AS 
           CONTRACT_COMMENTS 
                      ,LTRIM(RTRIM(REV_DISTRICT_CD))      AS 
           REV_DISTRICT_CD   
                      ,GL_ACCT_NO_ERN_INT          AS GL_ACCT_NO_ERN_INT
                      ,GL_ACCT_NO_DEF_INT          AS GL_ACCT_NO_DEF_INT
                      ,WRT_OFF_GL_ACCT_NO          AS WRT_OFF_GL_ACCT_NO
                      ,AMT_DEF_INTEREST            AS AMT_DEF_INTEREST  
                      ,CNT_XFER_ACCT_NO            AS CNT_XFER_ACCT_NO  
                      ,LTRIM(RTRIM(ADDL_DESC_IND))        AS 
           ADDL_DESC_IND     
                      ,LTRIM(RTRIM(ADVANCE_COLL_FLAG))    AS 
           ADVANCE_COLL_FLAG 
                      ,LTRIM(RTRIM(REV_MTH_LST_NRML))     AS 
           LAST_BILL_DATE    
                      ,LTRIM(RTRIM(CNT_ADDL_DESC))        AS 
           CNT_ADDL_DESC     
                      ,TOT_AMT_TRANS_BAL           AS TOT_AMT_TRANS_BAL 
                      ,LTRIM(RTRIM(CODE_BILL_FREQ))       AS BILL_FREQ         
                      ,TRAN_BALANCE                AS TRAN_BALANCE      
                      ,TOTAL_CHARGE                AS TOTAL_CHARGE      
                      ,TOTAL_CONTRACT              AS                   
                                                TOTAL_CONTRACT_AMOUNT   
                      ,CURRENT_BALANCE             AS CURRENT_BALANCE   
                      ,LTRIM(RTRIM(SETUP_NAME))           AS SETUP_NAME        
                      ,LTRIM(RTRIM(COST_CENTER))          AS COST_CENTER       
                      ,MIN_TERM_MO_NM              AS                   
                                                MIN_NO_OF_PAYMENTS      
                      ,MAX_TERM_MO_NM              AS                   
                                                MAX_NO_OF_PAYMENT       
                      ,MIN_INTRST_RT               AS MIN_INTEREST_RATE 
                      ,MAX_INTRST_RT               AS MAX_INTEREST_RATE 
ACT181                ,CONTRACT_TAXABLE_FL         AS                   
ACT181                                          CONTRACT_TAXABLE_FL     
ACT181                ,TAX_RATE                    AS TAX_RATE          
ACT181                ,INTRST_PRIOR_YR             AS INTRST_PRIOR_YR   
               FROM #CSR04821_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,CNT_ITEM_ID                 AS CNT_ITEM_ID               
MFA-TR*               ,STRIP(CODE_BILL_TYPE)       AS CODE_BILL_TYPE            
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(CODE_CONTRACT_TYPE)   AS CODE_CONTRACT_TYPE        
MFA-TR*               ,CNT_NAME_CD                 AS CNT_NAME_CD               
MFA-TR*               ,STRIP(CNT_STATUS_CD)        AS CNT_STATUS_CD             
MFA-TR*               ,STRIP(DATE_CONTRACT)        AS DATE_CONTRACT             
MFA-TR*               ,STRIP(STATUS_CHANGE_DT)     AS STATUS_CHANGE_DT          
MFA-TR*               ,CHARGE_AMOUNT               AS CHARGE_AMOUNT             
MFA-TR*               ,AMT_DOWN_PYMT               AS AMT_DOWN_PYMT             
MFA-TR*               ,AMT_ORIG_ENTERED            AS AMT_ORIG_ENTERED          
MFA-TR*               ,NO_SCHED_PYMTS              AS NO_SCHED_PYMTS            
MFA-TR*               ,AMT_MO_PYMT                 AS AMT_MO_PYMT               
MFA-TR*               ,STRIP(DATE_PYMT_START)      AS DATE_PYMT_START           
MFA-TR*               ,STRIP(DATE_PYMT_END)        AS DATE_PYMT_END             
MFA-TR*               ,UNBILLED_AMT                AS UNBILLED_AMT              
MFA-TR*               ,STATE_TAX                   AS STATE_TAX                 
MFA-TR*               ,CITY_TAX                    AS CITY_TAX                  
MFA-TR*               ,OTHER_TAX                   AS OTHER_TAX                 
MFA-TR*               ,STRIP(CODE_INTRST_METH)     AS CODE_INTRST_METH          
MFA-TR*               ,INTRST_RATE                 AS INTRST_RATE               
MFA-TR*               ,SIMPLE_INT_FIN_CHG          AS SIMPLE_INT_FIN_CHG        
MFA-TR*               ,INTRST_YTD                  AS INTRST_YTD                
MFA-TR*               ,DISPOSAL_FEE_AM             AS DISPOSAL_FEE_AM           
MFA-TR*               ,INSPECTION_FEE_AM           AS INSPECTION_FEE_AM         
MFA-TR*               ,FILING_FEE_AM               AS FILING_FEE_AM             
MFA-TR*               ,GL_ACCT_NO                  AS GL_ACCT_NO                
MFA-TR*               ,STRIP(USER_ID)              AS USER_ID                   
MFA-TR*               ,STRIP(LIEN_CD)              AS LIEN_CD                   
MFA-TR*               ,STRIP(CONTRACT_COMMENTS)    AS CONTRACT_COMMENTS         
MFA-TR*               ,STRIP(REV_DISTRICT_CD)      AS REV_DISTRICT_CD           
MFA-TR*               ,GL_ACCT_NO_ERN_INT          AS GL_ACCT_NO_ERN_INT        
MFA-TR*               ,GL_ACCT_NO_DEF_INT          AS GL_ACCT_NO_DEF_INT        
MFA-TR*               ,WRT_OFF_GL_ACCT_NO          AS WRT_OFF_GL_ACCT_NO        
MFA-TR*               ,AMT_DEF_INTEREST            AS AMT_DEF_INTEREST          
MFA-TR*               ,CNT_XFER_ACCT_NO            AS CNT_XFER_ACCT_NO          
MFA-TR*               ,STRIP(ADDL_DESC_IND)        AS ADDL_DESC_IND             
MFA-TR*               ,STRIP(ADVANCE_COLL_FLAG)    AS ADVANCE_COLL_FLAG         
MFA-TR*               ,STRIP(REV_MTH_LST_NRML)     AS LAST_BILL_DATE            
MFA-TR*               ,STRIP(CNT_ADDL_DESC)        AS CNT_ADDL_DESC             
MFA-TR*               ,TOT_AMT_TRANS_BAL           AS TOT_AMT_TRANS_BAL         
MFA-TR*               ,STRIP(CODE_BILL_FREQ)       AS BILL_FREQ                 
MFA-TR*               ,TRAN_BALANCE                AS TRAN_BALANCE              
MFA-TR*               ,TOTAL_CHARGE                AS TOTAL_CHARGE              
MFA-TR*               ,TOTAL_CONTRACT              AS                           
MFA-TR*                                         TOTAL_CONTRACT_AMOUNT           
MFA-TR*               ,CURRENT_BALANCE             AS CURRENT_BALANCE           
MFA-TR*               ,STRIP(SETUP_NAME)           AS SETUP_NAME                
MFA-TR*               ,STRIP(COST_CENTER)          AS COST_CENTER               
MFA-TR*               ,MIN_TERM_MO_NM              AS                           
MFA-TR*                                         MIN_NO_OF_PAYMENTS              
MFA-TR*               ,MAX_TERM_MO_NM              AS                           
MFA-TR*                                         MAX_NO_OF_PAYMENT               
MFA-TR*               ,MIN_INTRST_RT               AS MIN_INTEREST_RATE         
MFA-TR*               ,MAX_INTRST_RT               AS MAX_INTEREST_RATE         
MFA-TR*               ,CONTRACT_TAXABLE_FL         AS                           
MFA-TR*                                         CONTRACT_TAXABLE_FL             
MFA-TR*               ,TAX_RATE                    AS TAX_RATE                  
MFA-TR*               ,INTRST_PRIOR_YR             AS INTRST_PRIOR_YR           
MFA-TR*        FROM SESSION.CSR04821_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT.                                             *        
      *                                                                *        
      ******************************************************************        
       0100B-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04821_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04821_R2
              (                                                          
               RETURN_CODE              INT                         
              ,CNT_ITEM_ID_2            INT                         
              ,MONTH                    SMALLINT                        
              ,OPENING_BALANCE          DECIMAL(11,2)                   
              ,INTEREST                 DECIMAL(11,2)                   
              ,PRINCIPAL                DECIMAL(11,2)                   
              ,CLOSING_BALANCE          DECIMAL(11,2)                   
              ,TOTAL_INTEREST           DECIMAL(11,2)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS   THRU 8000B-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04821_R2'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                              THRU  9900-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,CNT_ITEM_ID_2               AS CNT_ITEM_ID_2     
                      ,MONTH                       AS MONTH             
                      ,OPENING_BALANCE             AS OPENING_BALANCE   
                      ,INTEREST                    AS INTEREST          
                      ,PRINCIPAL                   AS PRINCIPAL         
                      ,CLOSING_BALANCE             AS CLOSING_BALANCE   
                      ,TOTAL_INTEREST              AS TOTAL_INTEREST    
               FROM #CSR04821_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,CNT_ITEM_ID_2               AS CNT_ITEM_ID_2             
MFA-TR*               ,MONTH                       AS MONTH                     
MFA-TR*               ,OPENING_BALANCE             AS OPENING_BALANCE           
MFA-TR*               ,INTEREST                    AS INTEREST                  
MFA-TR*               ,PRINCIPAL                   AS PRINCIPAL                 
MFA-TR*               ,CLOSING_BALANCE             AS CLOSING_BALANCE           
MFA-TR*               ,TOTAL_INTEREST              AS TOTAL_INTEREST            
MFA-TR*        FROM SESSION.CSR04821_R2                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
      *                                                                         
           MOVE LINK-ACCOUNT-NO              TO AT-ACCOUNT-NO           
                                                CT-ACCOUNT-NO           
                                                AC-ACCOUNT-NO.          
                                                                        
           MOVE LINK-CNT-ITEM-ID             TO WS-IN-CNT-ITEM-ID.      
           MOVE LINK-CNT-NAME-CD             TO WS-IN-CNT-NAME-CD.      
                                                                        
      *******CHECK FOR MAIN PROCESS                                             
           IF WS-IN-CNT-ITEM-ID > 0                                     
              SET GET-EXISTING-CONTARCT-DTLS TO TRUE                    
           ELSE                                                         
              SET GET-DEFAULT-CONTARCT-DTLS  TO TRUE                    
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-MAIN-CONTRACT-PROCESS.                                    *        
      * MAIN PROCESS STARTS HERE TO FETCH THE CONTRACT DETAILS.        *        
      ******************************************************************        
       2000-MAIN-CONTRACT-PROCESS.                                      
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           PERFORM 7200-GET-REV-DISTRICT-CD   THRU 7200-EXIT.           
           MOVE PR-REV-DISTRICT-CD           TO S-REV-DISTRICT-CD.      
                                                                        
           PERFORM 7400-SELECT-BILLING-DATA   THRU 7400-EXIT.           
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
           IF WS-NULL-BILL-FRQ-AT = -1                                  
              MOVE ZEROS                     TO S-CODE-BILL-FREQ        
           ELSE                                                         
              MOVE AT-CODE-BILL-FREQ         TO S-CODE-BILL-FREQ        
           END-IF.                                                      
                                                                        
           PERFORM 7410-SELECT-CURRENT-DATE   THRU 7410-EXIT.           
                                                                        
      *******GET THE TOTAL AMT TRANS BALNACE                                    
           PERFORM 7420-GET-SUM-AMT-TRANS     THRU 7420-EXIT.           
           IF WS-NULL-AMT-IND-AC  = -1                                  
              MOVE ZEROS                     TO S-TOT-AMT-TRANS-BAL     
           ELSE                                                         
              MOVE WS-TOT-AMT-TRANS-BAL      TO S-TOT-AMT-TRANS-BAL     
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN GET-EXISTING-CONTARCT-DTLS                          
                    PERFORM 2010-PROCESS-EXISTING-CONTRACT              
                                              THRU 2010-EXIT            
               WHEN GET-DEFAULT-CONTARCT-DTLS                           
                    PERFORM 2020-PROCESS-DEFAULT-CONTRACT               
                                              THRU 2020-EXIT            
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2010-PROCESS-EXISTING-CONTRACT.                               *         
      * RETRIEVE ALL THE CONTRACT EXISTING RECORDS                    *         
      * ORDER: ACTIVE,PENDING,XFER,PAID,CANCELLED,CLOSED              *         
      *****************************************************************         
       2010-PROCESS-EXISTING-CONTRACT.                                  
      *                                                                         
           MOVE SPACES                       TO                         
                                             CT-CONTRACT-COMMENTS-TEXT. 
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS.        
           PERFORM 7100-OPEN-CONTRACT         THRU 7100-EXIT.           
           PERFORM 7110-FETCH-CONTRACT        THRU 7110-EXIT.           
                                                                        
           PERFORM 2400-PROCESS-CONTRACT      THRU 2400-EXIT            
                                              UNTIL NO-MORE-ROWS.       
           PERFORM 7120-CLOSE-CONTRACT        THRU 7120-EXIT.           
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2020-PROCESS-DEFAULT-CONTRACT.                                 *        
      * NEW RECORD - GENERATE CONTRACT ID AND POPULATE                 *        
      *              FIELDS WITH DEFAULT VALUES                                 
      *                                                                         
      *****************************************************************         
       2020-PROCESS-DEFAULT-CONTRACT.                                   
      *                                                                         
           MOVE 'DATABASE'                   TO C8-DELINQ-CD            
           MOVE AT-COMPANY-NO                TO C8-COMPANY-NO           
                                                                        
           PERFORM 7250-GET-DATABASE          THRU 7250-EXIT            
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE             
                                                                        
           IF (CSR-DATABASE AND                                         
               WS-IN-CNT-NAME-CD = WS-PACE-CONTRBTN)                    
              PERFORM 7320-SELECT-NEW-PACE-ITM-ID                       
                                              THRU 7320-EXIT            
              IF WS-ITEM-ID-NULL-IND = -1                               
                 MOVE WS-MIN-PACE-CNT-ID     TO WS-NEW-CNT-ITEM-ID      
              END-IF                                                    
           ELSE                                                         
              IF (CSR-DATABASE AND                                      
                 (WS-IN-CNT-NAME-CD = WS-BILL-INS1  OR                  
                  WS-IN-CNT-NAME-CD = WS-BILL-INS2))OR                  
                 (SEB-DATABASE AND                                      
                  WS-IN-CNT-NAME-CD = WS-BILL-INS-SEB)                  
                                                                        
                  PERFORM 7310-SELECT-NEW-BPI-ITM-ID                    
                                              THRU 7310-EXIT            
                  IF WS-ITEM-ID-NULL-IND = -1                           
                     MOVE WS-MIN-BPI-CNT-ID                             
                                             TO WS-NEW-CNT-ITEM-ID      
                  END-IF                                                
              ELSE                                                      
                 PERFORM 7300-SELECT-NEW-ITEM-ID                        
                                              THRU 7300-EXIT            
                 IF WS-ITEM-ID-NULL-IND = -1                            
                    MOVE WS-MIN-CIS-CNT-ID                              
                                             TO WS-NEW-CNT-ITEM-ID      
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-NEW-CNT-ITEM-ID           TO S-CNT-ITEM-ID           
                                                WS-CNT-ITEM-ID.         
           MOVE WS-CURRENT-DATE              TO S-DATE-PYMT-END.        
                                                                        
           PERFORM 2210-SELECT-BILLING-DATES  THRU 2210-EXIT.           
                                                                        
           MOVE WS-IN-CNT-NAME-CD            TO K6-CNT-NAME-CD.         
           PERFORM 2220-POPULATE-DFLT-VALUES  THRU 2220-EXIT.           
                                                                        
           PERFORM 2250-GET-TOL-AMT-R1        THRU 2250-EXIT.           
           MOVE WS-TOTAL-CHARGE              TO S-TOTAL-CHARGE.         
           MOVE WS-TOTAL-CONTRACT            TO S-TOTAL-CONTRACT.       
ACT181     MOVE SPACES                       TO WS-REV-DISTRICT-CD.     
ACT181     MOVE ZEROS                        TO WS-CNT-NAME-CD.         
ACT181     MOVE K6-CNT-NAME-CD               TO WS-CNT-NAME-CD.         
ACT181     PERFORM 7700-GET-TAX-FLAG          THRU 7700-EXIT            
ACT181     MOVE WS-CNT-TAXABLE-FL            TO S-CONTRACT-TAXABLE-FL   
ACT181     IF S-CONTRACT-TAXABLE-FL   = 'Y'                             
ACT181        MOVE PR-REV-DISTRICT-CD        TO WS-REV-DISTRICT-CD      
ACT181        PERFORM 7800-GET-TAX-RATE       THRU 7800-EXIT            
ACT181        MOVE WS-TAX-RATE               TO S-TAX-RATE              
ACT181     END-IF                                                       
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
      ***PAYMENT SCHEDULE - RESULT SET 2                                        
           PERFORM 2050-PROCESS-PAYMNT-INFO   THRU 2050-EXIT.           
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2050-PROCESS-PAYMNT-INFO.                                      *        
      * PROCESS THE RESULT SET2.                                       *        
      *****************************************************************         
       2050-PROCESS-PAYMNT-INFO.                                        
      *                                                                         
           IF WS-CODE-BILL-TYPE = WS-INSTALLMENT AND                    
              WS-CD-INTRST-METH = WS-ADD-ON                             
                                                                        
              MOVE WS-YES                    TO WS-FIRST-BALANCE        
                                                WS-FIRST-INTRST         
      ********MONTHLY INTEREST RATE                                             
              COMPUTE WS-MONTHLY-RATE = (WS-INTRST-RATE/12)             
                                                                        
              PERFORM 2100-GET-PAYMNT-INFO    THRU 2100-EXIT            
                              UNTIL WS-SCHD-COUNT >= WS-NO-SCHED-PYMTS  
                                                                        
              INITIALIZE WS-RETURN-GRP2                                 
           END-IF.                                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2100-GET-PAYMNT-INFO.                                          *        
      *ALL INTEREST AND BALANCE CALCULATION ARE DONE FOR RESULT SET2   *        
      *****************************************************************         
       2100-GET-PAYMNT-INFO.                                            
      *                                                                         
      ***LAST MONTH BALANCES CALCULATION                                        
           IF WS-SCHD-COUNT = WS-NO-SCHED-PYMTS - 1                     
                                                                        
              MOVE WS-OPENING-BALANCE        TO WS-PRINCIPAL            
              MOVE ZEROS                     TO WS-CLOSING-BALANCE      
              MOVE WS-SIMPLE-INT-FIN-CHG     TO WS-TOTAL-INTEREST       
                                                                        
              COMPUTE WS-INTEREST-MON =                                 
                      WS-MNTHLY-PYMNT-AMT - WS-OPENING-BALANCE          
                                                                        
      ***BALANCES CALCULATION EXCEPT FOR LAST MONTH                             
           ELSE                                                         
      ***IT WILL CALCULATE OPENING BALANCE FOR FIRST MONTH                      
              IF WS-FIRST-BALANCE = WS-YES                              
                                                                        
                 COMPUTE WS-OPENING-BALANCE ROUNDED =                   
                         WS-AMT-ORIG-ENTERED - WS-SIMPLE-INT-FIN-CHG    
                 MOVE WS-NO                  TO WS-FIRST-BALANCE        
                                                                        
              END-IF                                                    
                                                                        
      ***IT WILL CALCULATE MONTHLY INTEREST AMOUNT                              
              COMPUTE WS-INTEREST-MON      ROUNDED =                    
                     (WS-OPENING-BALANCE *(WS-MONTHLY-RATE/100))        
                                                                        
      *****   COMPUTE WS-INTEREST-MON ROUNDED = WS-INTEREST-MON-TEMP            
                                                                        
      ***IT WILL CALCULATE TOTAL INTEREST AMOUNT OF THE MONTH                   
              IF WS-FIRST-INTRST = WS-YES                               
                 MOVE WS-INTEREST-MON        TO WS-TOTAL-INTEREST       
                 MOVE WS-NO                  TO WS-FIRST-INTRST         
              ELSE                                                      
                 COMPUTE WS-TOTAL-INTEREST ROUNDED =                    
                         WS-INTEREST-MON + WS-TOTAL-INTEREST            
              END-IF                                                    
                                                                        
      ***IT WILL CALCULATE PRINCIPLE AMOUNT OF THE MONTH                        
              COMPUTE WS-PRINCIPAL ROUNDED=                             
                      WS-MNTHLY-PYMNT-AMT - WS-INTEREST-MON             
                                                                        
      ***CLOSING BALANCE MONTHLY                                                
              COMPUTE WS-CLOSING-BALANCE ROUNDED =                      
                      WS-OPENING-BALANCE - WS-PRINCIPAL                 
           END-IF.                                                      
                                                                        
           ADD 1                             TO WS-SCHD-COUNT.          
           PERFORM 2100A-MOVE-RESULT2         THRU 2100A-EXIT.          
      ***PREVIOUS MONTH CLOSING BAL WILL BE EQUAL TO NEXT MONTH OPENING         
      ***BALANCE. TO CALCULATE CONSEQUENT MONTHS OPENING BAL.                   
           MOVE WS-CLOSING-BALANCE           TO WS-OPENING-BALANCE.     
                                                                        
           INITIALIZE WS-INTEREST-MON                                   
                      WS-CLOSING-BALANCE                                
                      WS-PRINCIPAL.                                     
                                                                        
           PERFORM 8200-SEND-RESULT           THRU 8200-EXIT.           
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100A-MOVE-RESULT2.                                            *        
      ******************************************************************        
       2100A-MOVE-RESULT2.                                              
                                                                        
           MOVE WS-CNT-ITEM-ID               TO S-CNT-ITEM-ID-2.        
           MOVE WS-SCHD-COUNT                TO S-MONTH.                
           MOVE WS-OPENING-BALANCE           TO S-OPENING-BALANCE.      
           MOVE WS-INTEREST-MON              TO S-INTEREST.             
           MOVE WS-PRINCIPAL                 TO S-PRINCIPAL.            
           MOVE WS-CLOSING-BALANCE           TO S-CLOSING-BALANCE.      
           MOVE WS-TOTAL-INTEREST            TO S-TOTAL-INTEREST.       
                                                                        
       2100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2210-SELECT-BILLING-DATES                                      *        
      ******************************************************************        
       2210-SELECT-BILLING-DATES.                                       
                                                                        
           MOVE AT-BILL-CYCLE                TO BN-BILL-CYCLE.          
                                                                        
           IF ((AT-BILL-CYCLE = '00' OR  AT-BILL-CYCLE <= SPACES)       
            AND AT-CODE-ACCT-STAT = WS-PENDING )                        
              MOVE WS-CURRENT-DATE           TO REFORMAT-DATE           
              MOVE WS-FORMAT-YEAR            TO USA-YEAR                
              MOVE WS-FORMAT-MONTH           TO USA-MONTH               
              MOVE WS-FORMAT-DAY             TO USA-DAY                 
              MOVE USA-DATE-FORMAT           TO S-DATE-PYMT-START-1     
           ELSE                                                         
              PERFORM 5900-NEXT-BILL-DATE     THRU                      
                                              5900-NEXT-BILL-DATE-EXIT  
              IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                      
                 MOVE BN-DATE-EXTRACT        TO REFORMAT-DATE           
                 MOVE WS-FORMAT-YEAR         TO USA-YEAR                
                 MOVE WS-FORMAT-MONTH        TO USA-MONTH               
                 MOVE WS-FORMAT-DAY          TO USA-DAY                 
                 MOVE USA-DATE-FORMAT        TO S-DATE-PYMT-START-1     
                 MOVE BN-DATE-EXTRACT        TO WS-CURRENT-DATE         
                 MOVE BN-REVENUE-MONTH       TO AT-REV-MTH-LST-NRML     
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-1         
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '5900'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2220-POPULATE-DFLT-VALUES - CREATED AS PART OF TPR9542         *        
      *                                                                         
      ******************************************************************        
       2220-POPULATE-DFLT-VALUES.                                       
                                                                        
           PERFORM 7000-SELECT-DFLT-CONTRACT  THRU 7000-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                        
              INITIALIZE DCLCSS-CONTRACT-INFO                           
           END-IF.                                                      
                                                                        
           IF WS-ADVANCE-COLL = WS-NO                                   
              MOVE SPACES                    TO S-USER-ID               
           END-IF.                                                      
                                                                        
           MOVE SPACE                        TO S-DATE-CONTRACT         
                                                S-CNT-STATUS-CD         
                                                S-STATUS-CHANGE-DT      
                                                S-CONTRACT-COMMENTS.    
           MOVE WS-NO                        TO S-LIEN-CD.              
           MOVE 0                            TO S-AMT-DOWN-PYMT         
                                                S-AMT-MO-PYMT           
                                                S-AMT-DEF-INT           
                                                S-INTRST-YTD            
                                                S-CHARGE-AMOUNT         
                                                S-STATE-TAX             
                                                S-CITY-TAX              
                                                S-OTHER-TAX             
                                                S-WHT-GDS-DISP-FEE      
                                                S-SIMPLE-INT-FIN-CHG    
                                                WS-TRAN-BALANCE         
                                                WS-CHARGE-AMOUNT        
                                                WS-MNTHLY-PYMNT-AMT.    
           MOVE K6-CNT-NAME-CD               TO S-CNT-NAME-CD.          
           MOVE K6-CODE-CONTRACT-TYPE        TO S-CODE-CONTRACT-TYPE.   
           MOVE K6-ADDL-DESC-IND             TO S-ADDL-DESC-IND.        
           MOVE K6-COST-CENTER               TO S-COST-CENTER.          
           MOVE K6-MIN-TERM-MO-NM            TO S-MIN-TERM-MO-NM.       
           MOVE K6-MAX-TERM-MO-NM            TO S-MAX-TERM-MO-NM.       
           MOVE K6-MIN-INTRST-RT             TO S-MIN-INTRST-RT.        
           MOVE K6-MAX-INTRST-RT             TO S-MAX-INTRST-RT.        
                                                                        
      *---- SEND BACK SPACES OR ZEROS FOR MARKETING CONTRACT ADVANCE            
      *---- COLLECTION. USER SHOULD NOT SEE THE DEFAULT VALUES ON THE           
      *---- PANEL BECAUSE MARKETING CONTRACT ADVANCE COLLECTIONS                
      *---- ARE NOT EDITABLE ON A CIS PANEL.                                    
           IF WS-ADVANCE-COLL = WS-YES AND                              
              CT-CNT-ITEM-ID  < WS-MIN-CIS-CNT-ID                       
              MOVE SPACES                    TO S-CODE-BILL-TYPE        
                                                S-CD-INTRST-METH        
                                                S-CHARGE-TYPE           
                                                S-COMPANY-NO            
                                                WS-CODE-BILL-TYPE       
                                                WS-CD-INTRST-METH       
                                                                        
              MOVE 0                         TO S-NO-SCHED-PYMTS        
                                                S-INTRST-RATE           
                                                S-GL-ACCT-NO            
                                                S-GL-ACCT-NO-ERN-INT    
                                                S-GL-ACCT-NO-DEF-INT    
                                                S-WRT-OFF-GL-ACCT-NO    
                                                S-CHARGE-AMOUNT         
                                                WS-INTRST-RATE          
                                                WS-CHARGE-AMOUNT        
                                                WS-NO-SCHED-PYMTS       
                                                                        
           ELSE                                                         
              MOVE K6-CODE-BILL-TYPE         TO S-CODE-BILL-TYPE        
                                                WS-CODE-BILL-TYPE       
              MOVE K6-DFLT-TERM-MO-NM        TO S-NO-SCHED-PYMTS        
                                                WS-NO-SCHED-PYMTS       
              MOVE K6-INTEREST-CD            TO S-CD-INTRST-METH        
                                                WS-CD-INTRST-METH       
              MOVE K6-DFLT-INTRST-RT         TO S-INTRST-RATE           
                                                WS-INTRST-RATE          
              MOVE K6-CHARGE-TYPE-CD         TO S-CHARGE-TYPE           
              MOVE K6-GL-ACCT-NO             TO S-GL-ACCT-NO            
              MOVE K6-COMPANY-NO             TO S-COMPANY-NO            
              MOVE K6-GL-ACCT-NO-ERN-INT     TO S-GL-ACCT-NO-ERN-INT    
              MOVE K6-GL-ACCT-NO-DEF-INT     TO S-GL-ACCT-NO-DEF-INT    
              MOVE K6-WRT-OFF-GL-ACCT-NO     TO S-WRT-OFF-GL-ACCT-NO    
              MOVE K6-DFLT-CHARGE-AM         TO S-CHARGE-AMOUNT         
                                                WS-CHARGE-AMOUNT        
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2250-GET-TOL-AMT-R1                                           *         
      *****************************************************************         
       2250-GET-TOL-AMT-R1.                                             
                                                                        
           INITIALIZE WS-TOTAL-CHARGE                                   
                      WS-TOTAL-CONTRACT                                 
                      S-TOTAL-CHARGE                                    
                      S-TOTAL-CONTRACT.                                 
                                                                        
           COMPUTE WS-TOTAL-CHARGE  =                                   
                             (S-CHARGE-AMOUNT + S-STATE-TAX +           
                              S-CITY-TAX + S-OTHER-TAX +                
                              S-WHT-GDS-DISP-FEE + S-INSPECTION-FEE +   
                              S-FILING-FEE-AM)                          
                                                                        
           COMPUTE WS-TOTAL-CONTRACT =                                  
                             ((WS-TOTAL-CHARGE - S-AMT-DOWN-PYMT) +     
                              S-SIMPLE-INT-FIN-CHG)                     
           .                                                            
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2300-SEND-DTLROWS                                             *         
      *****************************************************************         
       2300-SEND-DTLROWS.                                               
                                                                        
           MOVE EA-CHARGE-TYPE-CD            TO S-CHARGE-TYPE.          
           MOVE EA-GL-ACCT-NO                TO S-GL-ACCT-NO.           
           MOVE EA-CHARGE-AM                 TO S-CHARGE-AMOUNT         
                                                WS-CHARGE-AMOUNT.       
           MOVE CT-AMT-TAX-STATE             TO S-STATE-TAX.            
           MOVE CT-AMT-TAX-CITY              TO S-CITY-TAX.             
           MOVE CT-AMT-TAX-OTHER             TO S-OTHER-TAX.            
           MOVE EA-DISPOSAL-FEE-AM           TO S-WHT-GDS-DISP-FEE.     
           MOVE EA-INSPECTION-FEE-AM         TO S-INSPECTION-FEE.       
           MOVE EA-FILING-FEE-AM             TO S-FILING-FEE-AM.        
ACT278     MOVE SPACES                       TO S-COMPANY-NO.           
           MOVE EA-WRT-OFF-GL-ACCT-NO        TO S-WRT-OFF-GL-ACCT-NO.   
           MOVE EA-COST-CENTER               TO S-COST-CENTER.          
           MOVE WS-ADVANCE-COLL              TO S-ADVANCE-COLL.         
                                                                        
           PERFORM 2250-GET-TOL-AMT-R1        THRU 2250-EXIT.           
           MOVE WS-TOTAL-CHARGE              TO S-TOTAL-CHARGE.         
           MOVE WS-TOTAL-CONTRACT            TO S-TOTAL-CONTRACT.       
                                                                        
ACT177     PERFORM 2600-SET-PAID-N-CLSD-CUST-AMT THRU 2600-EXIT         
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-PROCESS-CONTRACT.                                         *        
      *                                                                *        
      ******************************************************************        
       2400-PROCESS-CONTRACT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF CT-CNT-STATUS-CD NOT = 'A' AND                         
                 (CT-CNT-NAME-CD = 1099 OR 1199)                        
                 CONTINUE                                               
              ELSE                                                      
ACT181           MOVE SPACES                 TO WS-REV-DISTRICT-CD      
ACT181           MOVE ZEROS                  TO WS-CNT-NAME-CD          
ACT181           MOVE CT-INTRST-PRIOR-YR     TO S-INTRST-PRIOR-YR       
ACT181           MOVE CT-CNT-NAME-CD         TO WS-CNT-NAME-CD          
ACT181           PERFORM 7700-GET-TAX-FLAG    THRU 7700-EXIT            
ACT181           MOVE WS-CNT-TAXABLE-FL      TO S-CONTRACT-TAXABLE-FL   
ACT181           IF S-CONTRACT-TAXABLE-FL   = 'Y'                       
ACT181              MOVE PR-REV-DISTRICT-CD  TO WS-REV-DISTRICT-CD      
ACT181              PERFORM 7800-GET-TAX-RATE THRU 7800-EXIT            
ACT181              MOVE WS-TAX-RATE         TO S-TAX-RATE              
ACT181           END-IF                                                 
                 PERFORM 2500-GET-CONTRACT-INFO     THRU 2500-EXIT      
                 PERFORM 2510-GET-CONTRACT-DTLS     THRU 2510-EXIT      
      ***PAYMENT SCHEDULE - RESULT SET 2                                        
                 PERFORM 2050-PROCESS-PAYMNT-INFO   THRU 2050-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7110-FETCH-CONTRACT        THRU 7110-EXIT.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-GET-CONTRACT-INFO.                                        *        
      *     THIS MODULE OBTAINS AND RETURNS ALL OF THE CONTRACTS.      *        
      ******************************************************************        
       2500-GET-CONTRACT-INFO.                                          
      *                                                                         
           MOVE CT-USER-ID                   TO S-USER-ID               
                                                PF-USER-ID.             
           MOVE SPACES                       TO S-SETUP-NAME.           
           PERFORM 7500-SELECT-USER-PROFILE   THRU 7500-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              CONTINUE                                                  
           ELSE                                                         
              IF PF-LAST-NAME  NOT = SPACES AND                         
                 PF-FIRST-NAME NOT = SPACES                             
                 STRING PF-LAST-NAME   DELIMITED  BY ' '                
                        WS-COMMA       DELIMITED  BY SIZE               
                        PF-FIRST-NAME  DELIMITED  BY ' '                
                        WS-SPACE       DELIMITED  BY SIZE               
                        PF-MIDDLE-NAME DELIMITED  BY ' '                
                   INTO S-SETUP-NAME                                    
              ELSE                                                      
                 IF PF-LAST-NAME NOT = SPACES AND                       
                    PF-FIRST-NAME    = SPACES                           
                    MOVE PF-LAST-NAME        TO S-SETUP-NAME            
                 ELSE                                                   
                    MOVE PF-FIRST-NAME       TO S-SETUP-NAME            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           MOVE CT-USER-ID                   TO S-USER-ID.              
           MOVE CT-CODE-CONTRACT-TYPE        TO S-CODE-CONTRACT-TYPE.   
           MOVE CT-CNT-NAME-CD               TO S-CNT-NAME-CD.          
           MOVE CT-CNT-ITEM-ID               TO S-CNT-ITEM-ID           
                                                WS-CNT-ITEM-ID.         
           MOVE CT-DATE-CONTRACT             TO S-DATE-CONTRACT.        
           MOVE CT-CNT-STATUS-CD             TO S-CNT-STATUS-CD.        
           MOVE CT-AMT-ORIG-ENTERED          TO S-AMT-ORIG-ENTERED      
                                                WS-AMT-ORIG-ENTERED.    
                                                                        
ACT238     IF CT-CNT-ADDL-DESC-LEN GREATER THAN ZERO                    
ACT238        MOVE CT-CNT-ADDL-DESC-TEXT(1:CT-CNT-ADDL-DESC-LEN)        
ACT238                                       TO S-CNT-ADDL-DESC         
ACT238     END-IF.                                                      
                                                                        
           INITIALIZE CT-CNT-ADDL-DESC.                                 
                                                                        
           IF WS-NULL-DATE-IND = -1                                     
              MOVE SPACE                     TO S-STATUS-CHANGE-DT      
           ELSE                                                         
              MOVE CT-STATUS-CHANGE-DT       TO S-STATUS-CHANGE-DT      
           END-IF.                                                      
                                                                        
           MOVE CT-CODE-BILL-TYPE            TO S-CODE-BILL-TYPE        
                                                WS-CODE-BILL-TYPE.      
           MOVE CT-LIEN-CD                   TO S-LIEN-CD.              
                                                                        
      *------  COLUMN MONTHLY_CREDIT STORES MONTHLY CREDIT AMOUNT               
      *------- IF BILLING OPTION = 'MONTHLY CREDIT' ('E'). OTHERWISE            
      *------- IT STORES MONTHLY PAYMENT AMOUNT                                 
                                                                        
           IF CT-CODE-BILL-TYPE = 'E'                                   
               MOVE 0                        TO S-AMT-MO-PYMT           
                                                WS-MNTHLY-PYMNT-AMT     
           ELSE                                                         
               MOVE CT-AMT-MO-PYMT           TO S-AMT-MO-PYMT           
                                                WS-MNTHLY-PYMNT-AMT     
           END-IF.                                                      
                                                                        
ACT238     MOVE CT-CONTRACT-COMMENTS-TEXT(1:CT-CONTRACT-COMMENTS-LEN)   
ACT238                                       TO S-CONTRACT-COMMENTS.    
           MOVE CT-AMT-DOWN-PYMT             TO S-AMT-DOWN-PYMT.        
           MOVE CT-NO-SCHED-PYMTS            TO S-NO-SCHED-PYMTS        
                                                WS-NO-SCHED-PYMTS.      
           MOVE CT-DATE-PYMT-START           TO S-DATE-PYMT-START-1.    
           MOVE WS-CURRENT-DATE              TO S-DATE-PYMT-END.        
           MOVE CT-CODE-INTRST-METH          TO S-CD-INTRST-METH        
                                                WS-CD-INTRST-METH.      
           MOVE CT-INTRST-RATE               TO S-INTRST-RATE           
                                                WS-INTRST-RATE          
           IF CT-SIMPLE-INT-FIN-CHG NOT NUMERIC                         
              MOVE 0                         TO CT-SIMPLE-INT-FIN-CHG   
           END-IF                                                       
           MOVE CT-SIMPLE-INT-FIN-CHG        TO S-SIMPLE-INT-FIN-CHG    
                                                WS-SIMPLE-INT-FIN-CHG.  
           MOVE CT-AMT-DEF-INTEREST          TO S-AMT-DEF-INT.          
           MOVE CT-INTRST-YTD                TO S-INTRST-YTD.           
                                                                        
      *------- POPULATE TRANSACTION BALANCE IF CONTRACT IS NOT                  
      *------- 'CANCELLED' OR  'REJECTED' AND IF BILLING OPTION IS              
      *------- 'INSTALLMENT' OR '90 DAY SAME AS CASH'                           
                                                                        
           MOVE CT-CNT-ITEM-ID               TO AC-ITEM-ID.             
           PERFORM 7600-SELECT-TRAN-BALANCE   THRU 7600-EXIT            
                                                                        
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
                                                                        
              MOVE AC-AMT-TRAN-BALANCE       TO WS-TRAN-BALANCE         
                                                S-AMT-TRAN-BALANCE      
              COMPUTE S-UNBILLED-AMT  = WS-TRAN-BALANCE                 
                                      - AC-AMT-AR-DAY-00                
                                      - AC-AMT-AR-DAY-30                
                                      - AC-AMT-AR-DAY-60                
                                      - AC-AMT-AR-DAY-90                
                                      - CT-AMT-DEF-INTEREST             
              COMPUTE S-CURRENT-BAL   = AC-AMT-AR-DAY-00                
                                      + AC-AMT-AR-DAY-30                
                                      + AC-AMT-AR-DAY-60                
                                      + AC-AMT-AR-DAY-90                
           ELSE                                                         
              MOVE 0                         TO AC-AMT-TRAN-BALANCE     
           END-IF                                                       
                                                                        
           MOVE PR-REV-DISTRICT-CD           TO S-REV-DISTRICT-CD.      
           MOVE CT-GL-ACCT-NO-ERN-INT        TO S-GL-ACCT-NO-ERN-INT.   
           MOVE CT-GL-ACCT-NO-DEF-INT        TO S-GL-ACCT-NO-DEF-INT.   
           MOVE CT-CNT-NAME-CD               TO K6-CNT-NAME-CD.         
                                                                        
           PERFORM 7000-SELECT-DFLT-CONTRACT  THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              INITIALIZE DCLCSS-CONTRACT-INFO                           
           END-IF                                                       
                                                                        
           MOVE K6-ADDL-DESC-IND             TO S-ADDL-DESC-IND.        
           MOVE WS-NO                        TO S-ADVANCE-COLL.         
                                                                        
           IF WS-NULL-DATE-IND-AT = -1                                  
              MOVE SPACES                    TO S-LAST-BILL-DATE        
           ELSE                                                         
              MOVE WS-LAST-BILL-DATE         TO S-LAST-BILL-DATE        
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2510-GET-CONTRACT-DTLS.                                        *        
      *     THIS MODULE GETS THE CONTRACT DETAILS.                     *        
      ******************************************************************        
       2510-GET-CONTRACT-DTLS.                                          
      *                                                                         
           MOVE CT-CNT-ITEM-ID               TO EA-CNT-ITEM-ID.         
           MOVE CT-ACCOUNT-NO                TO EA-ACCOUNT-NO.          
           PERFORM 7010-SELECT-CNT-DETAIL     THRU 7010-EXIT.           
                                                                        
     ******* SELECT DEFAULT VALUES AND SEND ROW BACK                            
     ******* IF ADVANCE COLLECTION CONTRACT. END PROGRAM OTHERWISE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2300-SEND-DTLROWS       THRU 2300-EXIT            
           ELSE                                                         
              IF AC-AMT-TRAN-BALANCE < 0 AND                            
                 CT-CNT-STATUS-CD    = PENDING-CONTRACT                 
                MOVE WS-YES                  TO WS-ADVANCE-COLL         
                MOVE CT-CNT-ITEM-ID          TO S-CNT-ITEM-ID           
                                                WS-CNT-ITEM-ID          
                MOVE CT-CNT-NAME-CD          TO K6-CNT-NAME-CD          
                                                                        
                PERFORM 2220-POPULATE-DFLT-VALUES                       
                                              THRU 2220-EXIT            
                MOVE CT-DATE-CONTRACT        TO S-DATE-CONTRACT         
                MOVE CT-CNT-STATUS-CD        TO S-CNT-STATUS-CD         
                MOVE AC-AMT-TRAN-BALANCE     TO WS-TRAN-BALANCE         
                                                                        
                COMPUTE WS-CHARGE-AMOUNT = WS-TRAN-BALANCE * (-1)       
                MOVE WS-CHARGE-AMOUNT        TO S-CHARGE-AMOUNT         
                                                                        
                MOVE CT-DATE-PYMT-START      TO S-DATE-PYMT-START-1     
                MOVE PR-REV-DISTRICT-CD      TO S-REV-DISTRICT-CD       
                MOVE WS-ADVANCE-COLL         TO S-ADVANCE-COLL          
                                                                        
                PERFORM 2250-GET-TOL-AMT-R1   THRU 2250-EXIT            
                MOVE WS-TOTAL-CHARGE         TO S-TOTAL-CHARGE          
                MOVE WS-TOTAL-CONTRACT       TO S-TOTAL-CONTRACT        
                                                                        
ACT177          PERFORM 2600-SET-PAID-N-CLSD-CUST-AMT THRU 2600-EXIT    
                PERFORM 8100-SEND-RESULT      THRU 8100-EXIT            
              ELSE                                                      
                PERFORM 2250-GET-TOL-AMT-R1   THRU 2250-EXIT            
                MOVE WS-TOTAL-CHARGE         TO S-TOTAL-CHARGE          
                MOVE WS-TOTAL-CONTRACT       TO S-TOTAL-CONTRACT        
                                                                        
ACT177          PERFORM 2600-SET-PAID-N-CLSD-CUST-AMT THRU 2600-EXIT    
                PERFORM 8100-SEND-RESULT      THRU 8100-EXIT            
                PERFORM 9999-END-PROGRAM      THRU 9999-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT177******************************************************************        
ACT177*                                                                *        
ACT177* 2600-SET-PAID-N-CLSD-CUST-AMT.                                 *        
ACT177******************************************************************        
ACT177 2600-SET-PAID-N-CLSD-CUST-AMT.                                   
ACT177                                                                  
ACT177     IF CT-CNT-STATUS-CD  EQUAL (WS-PAID OR WS-CLOSED)            
ACT177        IF CT-CODE-BILL-TYPE EQUAL WS-INSTALLMENT                 
ACT177           MOVE WS-ZERO                TO S-AMT-MO-PYMT           
ACT177        ELSE                                                      
ACT177           MOVE S-CHARGE-AMOUNT        TO S-AMT-MO-PYMT           
ACT177        END-IF                                                    
ACT177     END-IF.                                                      
ACT177                                                                  
ACT177 2600-EXIT.                                                       
ACT177     EXIT.                                                        
                                                                        
      ******************************************************************        
      * INCLUDE CPD00309 FOR NEXT BILL DATE CALCULATION                *        
      * 5900-NEXT-BILL-DATE.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00309                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-DFLT-CONTRACT                                      *        
      ******************************************************************        
       7000-SELECT-DFLT-CONTRACT.                                       
                                                                        
           EXEC SQL                                                     
                 SELECT K6.CODE_CONTRACT_TYPE                           
                       ,K6.CNT_NAME_CD                                  
                       ,K6.CODE_BILL_TYPE                               
                       ,K6.INTEREST_CD                                  
                       ,K6.DFLT_INTRST_RT                               
                       ,K6.DFLT_TERM_MO_NM                              
                       ,K6.CHARGE_TYPE_CD                               
                       ,K6.GL_ACCT_NO                                   
                       ,K6.COMPANY_NO                                   
                       ,K6.GL_ACCT_NO_ERN_INT                           
                       ,K6.GL_ACCT_NO_DEF_INT                           
                       ,K6.WRT_OFF_GL_ACCT_NO                           
                       ,K6.ADDL_DESC_IND                                
                       ,K6.DFLT_CHARGE_AM                               
                       ,K6.COST_CENTER                                  
                       ,K6.MIN_TERM_MO_NM                               
                       ,K6.MAX_TERM_MO_NM                               
                       ,K6.MIN_INTRST_RT                                
                       ,K6.MAX_INTRST_RT                                
                   INTO :K6-CODE-CONTRACT-TYPE                          
                       ,:K6-CNT-NAME-CD                                 
                       ,:K6-CODE-BILL-TYPE                              
                       ,:K6-INTEREST-CD                                 
                       ,:K6-DFLT-INTRST-RT                              
                       ,:K6-DFLT-TERM-MO-NM                             
                       ,:K6-CHARGE-TYPE-CD                              
                       ,:K6-GL-ACCT-NO                                  
                       ,:K6-COMPANY-NO                                  
                       ,:K6-GL-ACCT-NO-ERN-INT                          
                       ,:K6-GL-ACCT-NO-DEF-INT                          
                       ,:K6-WRT-OFF-GL-ACCT-NO                          
                       ,:K6-ADDL-DESC-IND                               
                       ,:K6-DFLT-CHARGE-AM                              
                       ,:K6-COST-CENTER                                 
                       ,:K6-MIN-TERM-MO-NM                              
                       ,:K6-MAX-TERM-MO-NM                              
                       ,:K6-MIN-INTRST-RT                               
                       ,:K6-MAX-INTRST-RT                               
                   FROM CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)              
                  WHERE K6.CNT_NAME_CD = :K6-CNT-NAME-CD                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT K6.CODE_CONTRACT_TYPE                                   
MFA-TR*                ,K6.CNT_NAME_CD                                          
MFA-TR*                ,K6.CODE_BILL_TYPE                                       
MFA-TR*                ,K6.INTEREST_CD                                          
MFA-TR*                ,K6.DFLT_INTRST_RT                                       
MFA-TR*                ,K6.DFLT_TERM_MO_NM                                      
MFA-TR*                ,K6.CHARGE_TYPE_CD                                       
MFA-TR*                ,K6.GL_ACCT_NO                                           
MFA-TR*                ,K6.COMPANY_NO                                           
MFA-TR*                ,K6.GL_ACCT_NO_ERN_INT                                   
MFA-TR*                ,K6.GL_ACCT_NO_DEF_INT                                   
MFA-TR*                ,K6.WRT_OFF_GL_ACCT_NO                                   
MFA-TR*                ,K6.ADDL_DESC_IND                                        
MFA-TR*                ,K6.DFLT_CHARGE_AM                                       
MFA-TR*                ,K6.COST_CENTER                                          
MFA-TR*                ,K6.MIN_TERM_MO_NM                                       
MFA-TR*                ,K6.MAX_TERM_MO_NM                                       
MFA-TR*                ,K6.MIN_INTRST_RT                                        
MFA-TR*                ,K6.MAX_INTRST_RT                                        
MFA-TR*            INTO :K6-CODE-CONTRACT-TYPE                                  
MFA-TR*                ,:K6-CNT-NAME-CD                                         
MFA-TR*                ,:K6-CODE-BILL-TYPE                                      
MFA-TR*                ,:K6-INTEREST-CD                                         
MFA-TR*                ,:K6-DFLT-INTRST-RT                                      
MFA-TR*                ,:K6-DFLT-TERM-MO-NM                                     
MFA-TR*                ,:K6-CHARGE-TYPE-CD                                      
MFA-TR*                ,:K6-GL-ACCT-NO                                          
MFA-TR*                ,:K6-COMPANY-NO                                          
MFA-TR*                ,:K6-GL-ACCT-NO-ERN-INT                                  
MFA-TR*                ,:K6-GL-ACCT-NO-DEF-INT                                  
MFA-TR*                ,:K6-WRT-OFF-GL-ACCT-NO                                  
MFA-TR*                ,:K6-ADDL-DESC-IND                                       
MFA-TR*                ,:K6-DFLT-CHARGE-AM                                      
MFA-TR*                ,:K6-COST-CENTER                                         
MFA-TR*                ,:K6-MIN-TERM-MO-NM                                      
MFA-TR*                ,:K6-MAX-TERM-MO-NM                                      
MFA-TR*                ,:K6-MIN-INTRST-RT                                       
MFA-TR*                ,:K6-MAX-INTRST-RT                                       
MFA-TR*            FROM CSS_CONTRACT_INFO K6                                    
MFA-TR*           WHERE K6.CNT_NAME_CD = :K6-CNT-NAME-CD                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT_INFO'       TO TABLE-1                 
              MOVE 'CNT_NAME_CD'             TO TABLE-ELEMENT-1         
              MOVE K6-CNT-NAME-CD            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-SELECT-CNT-DETAIL.                                        *        
      ******************************************************************        
       7010-SELECT-CNT-DETAIL.                                          
                                                                        
           EXEC SQL                                                     
                 SELECT EA.CHARGE_TYPE_CD                               
                       ,EA.GL_ACCT_NO                                   
                       ,EA.CHARGE_AM                                    
                       ,EA.WRT_OFF_GL_ACCT_NO                           
                       ,EA.DISPOSAL_FEE_AM                              
                       ,EA.INSPECTION_FEE_AM                            
                       ,EA.FILING_FEE_AM                                
                       ,EA.COST_CENTER                                  
                   INTO :EA-CHARGE-TYPE-CD                              
                       ,:EA-GL-ACCT-NO                                  
                       ,:EA-CHARGE-AM                                   
                       ,:EA-WRT-OFF-GL-ACCT-NO                          
                       ,:EA-DISPOSAL-FEE-AM                             
                       ,:EA-INSPECTION-FEE-AM                           
                       ,:EA-FILING-FEE-AM                               
                       ,:EA-COST-CENTER                                 
                   FROM CSS_CNT_DETAIL EA WITH(READUNCOMMITTED)                 
                  WHERE EA.ACCOUNT_NO        = :EA-ACCOUNT-NO           
                    AND EA.CNT_ITEM_ID       = :EA-CNT-ITEM-ID          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT EA.CHARGE_TYPE_CD                                       
MFA-TR*                ,EA.GL_ACCT_NO                                           
MFA-TR*                ,EA.CHARGE_AM                                            
MFA-TR*                ,EA.WRT_OFF_GL_ACCT_NO                                   
MFA-TR*                ,EA.DISPOSAL_FEE_AM                                      
MFA-TR*                ,EA.INSPECTION_FEE_AM                                    
MFA-TR*                ,EA.FILING_FEE_AM                                        
MFA-TR*                ,EA.COST_CENTER                                          
MFA-TR*            INTO :EA-CHARGE-TYPE-CD                                      
MFA-TR*                ,:EA-GL-ACCT-NO                                          
MFA-TR*                ,:EA-CHARGE-AM                                           
MFA-TR*                ,:EA-WRT-OFF-GL-ACCT-NO                                  
MFA-TR*                ,:EA-DISPOSAL-FEE-AM                                     
MFA-TR*                ,:EA-INSPECTION-FEE-AM                                   
MFA-TR*                ,:EA-FILING-FEE-AM                                       
MFA-TR*                ,:EA-COST-CENTER                                         
MFA-TR*            FROM CSS_CNT_DETAIL EA                                       
MFA-TR*           WHERE EA.ACCOUNT_NO        = :EA-ACCOUNT-NO                   
MFA-TR*             AND EA.CNT_ITEM_ID       = :EA-CNT-ITEM-ID                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNT_DETAIL'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CNT_ITEM_ID'             TO TABLE-ELEMENT-3         
              MOVE EA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE EA-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-CONTRACT.                                            *        
      ******************************************************************        
       7100-OPEN-CONTRACT.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN CONTRACT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT_STATUS_CD'           TO TABLE-ELEMENT-3         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE WS-CONTRACT-STATUS        TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7110-FETCH-CONTRACT.                                           *        
      *     THIS MODULE FETCHES THE CONTRACT AND CONTRACT DETAIL INFO. *        
      ******************************************************************        
       7110-FETCH-CONTRACT.                                             
      *                                                                         
           EXEC SQL                                                     
               FETCH CONTRACT_CURSOR                                    
                   INTO :CT-CODE-CONTRACT-TYPE                          
                       ,:CT-CNT-ITEM-ID                                 
T5824                  ,:CT-USER-ID                                     
                       ,:CT-DATE-CONTRACT                               
                       ,:CT-CNT-NAME-CD                                 
                       ,:CT-CNT-STATUS-CD                               
                       ,:CT-STATUS-CHANGE-DT :WS-NULL-DATE-IND           
                       ,:CT-CODE-BILL-TYPE                              
                       ,:CT-LIEN-CD                                     
                       ,:CT-AMT-MO-PYMT                                 
                       ,:CT-CONTRACT-COMMENTS                           
                       ,:CT-AMT-DOWN-PYMT                               
                       ,:CT-NO-SCHED-PYMTS                              
                       ,:CT-REBATE-AMOUNT                               
                       ,:CT-REBATE-CD                                   
                       ,:CT-DATE-PYMT-START                             
                       ,:CT-CODE-INTRST-METH                            
                       ,:CT-INTRST-RATE                                 
                       ,:CT-AMT-DEF-INTEREST                            
                       ,:CT-INTRST-PRIOR-YR                             
                       ,:CT-INTRST-YTD                                  
                       ,:CT-REV-DISTRICT-CD                             
                       ,:CT-GL-ACCT-NO-ERN-INT                          
                       ,:CT-GL-ACCT-NO-DEF-INT                          
T12515                 ,:CT-SIMPLE-INT-FIN-CHG                          
                       ,:CT-CNT-ADDL-DESC                               
                       ,:CT-AMT-ORIG-ENTERED                            
                       ,:CT-AMT-TAX-STATE                               
                       ,:CT-AMT-TAX-CITY                                
                       ,:CT-AMT-TAX-OTHER                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7110'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1         
                    MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2         
                    MOVE 'CNT_STATUS_CD'     TO TABLE-ELEMENT-3         
                    MOVE  CT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1       
                    MOVE  WS-PYMT-PRIORITY-LVL                          
                                             TO HOSTVAR-ELEMENT-2       
                    MOVE  WS-CONTRACT-STATUS TO HOSTVAR-ELEMENT-3       
                    PERFORM 9700-PROCESS-ABEND                          
                                              THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-CLOSE-CONTRACT.                                           *        
      *     THIS MODULE CLOSES THE CONTRACT CURSOR.                    *        
      ******************************************************************        
       7120-CLOSE-CONTRACT.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE CONTRACT_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT_STATUS_CD'           TO TABLE-ELEMENT-3         
              MOVE  CT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              MOVE  WS-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2       
              MOVE  WS-CONTRACT-STATUS       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-REV-DISTRICT-CD.                                      *        
      ******************************************************************        
       7200-GET-REV-DISTRICT-CD.                                        
                                                                        
           EXEC SQL                                                     
                SELECT PR.REV_DISTRICT_CD                               
                      ,AT.COMPANY_NO                                    
                  INTO :PR-REV-DISTRICT-CD                              
                      ,:AT-COMPANY-NO                                   
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                    
                       CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                 WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                   AND AT.PREMISE_NO = PR.PREMISE_NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PR.REV_DISTRICT_CD                                       
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*           INTO :PR-REV-DISTRICT-CD                                      
MFA-TR*               ,:AT-COMPANY-NO                                           
MFA-TR*           FROM CSS_ACCOUNT AT,                                          
MFA-TR*                CSS_PREMISE PR                                           
MFA-TR*          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*            AND AT.PREMISE_NO = PR.PREMISE_NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'CSS_ACCOUNT'             TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7250-GET-DATABASE                                             *         
      *     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
      *****************************************************************         
       7250-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
                 SELECT C8.DELINQ_VALUE                                 
                   INTO :C8-DELINQ-VALUE                                
                   FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
                  WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                   
                    AND C8.COMPANY_NO = :C8-COMPANY-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT C8.DELINQ_VALUE                                         
MFA-TR*            INTO :C8-DELINQ-VALUE                                        
MFA-TR*            FROM CSS_DELINQUENCY C8                                      
MFA-TR*           WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                           
MFA-TR*             AND C8.COMPANY_NO = :C8-COMPANY-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-SELECT-NEW-ITEM-ID                                        *        
      ******************************************************************        
       7300-SELECT-NEW-ITEM-ID.                                         
                                                                        
           EXEC SQL                                                     
                 SELECT MAX(CT.CNT_ITEM_ID) + 1                         
                   INTO :WS-NEW-CNT-ITEM-ID :WS-ITEM-ID-NULL-IND         
                   FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                   
                  WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO           
                    AND CT.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL    
                    AND CT.CNT_ITEM_ID      >= :WS-MIN-CIS-CNT-ID       
                    AND CT.CNT_ITEM_ID NOT BETWEEN                      
                        :WS-MIN-BPI-CNT-ID AND :WS-MIN-CNT-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT MAX(CT.CNT_ITEM_ID) + 1                                 
MFA-TR*            INTO :WS-NEW-CNT-ITEM-ID:WS-ITEM-ID-NULL-IND                 
MFA-TR*            FROM CSS_CONTRACT CT                                         
MFA-TR*           WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                   
MFA-TR*             AND CT.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
MFA-TR*             AND CT.CNT_ITEM_ID      >= :WS-MIN-CIS-CNT-ID               
MFA-TR*             AND CT.CNT_ITEM_ID NOT BETWEEN                              
MFA-TR*                 :WS-MIN-BPI-CNT-ID AND :WS-MIN-CNT-ID                   
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT_TIEM_ID'             TO TABLE-ELEMENT-3         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE WS-MIN-CIS-CNT-ID         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-SELECT-NEW-BPI-ITM-ID.                                    *        
      ******************************************************************        
       7310-SELECT-NEW-BPI-ITM-ID.                                      
                                                                        
           EXEC SQL                                                     
                 SELECT MAX(CNT_ITEM_ID) + 1                            
                   INTO :WS-NEW-CNT-ITEM-ID :WS-ITEM-ID-NULL-IND         
                   FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                   
                  WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO           
                    AND CT.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL    
                    AND CT.CNT_NAME_CD       = :WS-IN-CNT-NAME-CD       
                    AND CT.CNT_ITEM_ID      >= :WS-MIN-BPI-CNT-ID       
                    AND CT.CNT_ITEM_ID NOT BETWEEN                      
                        :WS-MIN-PACE-CNT-ID AND :WS-MIN-CNT-ID          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT MAX(CNT_ITEM_ID) + 1                                    
MFA-TR*            INTO :WS-NEW-CNT-ITEM-ID:WS-ITEM-ID-NULL-IND                 
MFA-TR*            FROM CSS_CONTRACT CT                                         
MFA-TR*           WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                   
MFA-TR*             AND CT.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
MFA-TR*             AND CT.CNT_NAME_CD       = :WS-IN-CNT-NAME-CD               
MFA-TR*             AND CT.CNT_ITEM_ID      >= :WS-MIN-BPI-CNT-ID               
MFA-TR*             AND CT.CNT_ITEM_ID NOT BETWEEN                              
MFA-TR*                 :WS-MIN-PACE-CNT-ID AND :WS-MIN-CNT-ID                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7310                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT_NAME_CD'             TO TABLE-ELEMENT-3         
              MOVE 'CNT_TIEM_ID'             TO TABLE-ELEMENT-4         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE WS-IN-CNT-NAME-CD         TO HOSTVAR-ELEMENT-3       
              MOVE WS-MIN-BPI-CNT-ID         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-SELECT-NEW-PACE-ITM-ID.                                   *        
      *                                                                         
      ******************************************************************        
       7320-SELECT-NEW-PACE-ITM-ID.                                     
                                                                        
           EXEC SQL                                                     
                 SELECT MAX(CT.CNT_ITEM_ID) + 1                         
                   INTO :WS-NEW-CNT-ITEM-ID :WS-ITEM-ID-NULL-IND         
                   FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                   
                  WHERE CT.ACCOUNT_NO        =  :CT-ACCOUNT-NO          
                    AND CT.PYMT_PRIORITY_LVL =  :WS-PYMT-PRIORITY-LVL   
                    AND CT.CNT_NAME_CD       =  :WS-IN-CNT-NAME-CD      
                    AND CT.CNT_ITEM_ID       >= :WS-MIN-PACE-CNT-ID     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT MAX(CT.CNT_ITEM_ID) + 1                                 
MFA-TR*            INTO :WS-NEW-CNT-ITEM-ID:WS-ITEM-ID-NULL-IND                 
MFA-TR*            FROM CSS_CONTRACT CT                                         
MFA-TR*           WHERE CT.ACCOUNT_NO        =  :CT-ACCOUNT-NO                  
MFA-TR*             AND CT.PYMT_PRIORITY_LVL =  :WS-PYMT-PRIORITY-LVL           
MFA-TR*             AND CT.CNT_NAME_CD       =  :WS-IN-CNT-NAME-CD              
MFA-TR*             AND CT.CNT_ITEM_ID       >= :WS-MIN-PACE-CNT-ID             
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7320                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT_NAME_CD'             TO TABLE-ELEMENT-3         
              MOVE 'CNT_TIEM_ID'             TO TABLE-ELEMENT-4         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE WS-IN-CNT-NAME-CD         TO HOSTVAR-ELEMENT-3       
              MOVE WS-MIN-PACE-CNT-ID        TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-BILLING-DATA                                       *        
      ******************************************************************        
       7400-SELECT-BILLING-DATA.                                        
                                                                        
           EXEC SQL                                                     
                 SELECT AT.BILL_CYCLE                                   
                       ,AT.DATE_BILL_DAY_00                             
                       ,AT.CODES_DATA_PRESENT                           
                       ,AT.REV_MTH_LST_NRML                             
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.CODE_BILL_FREQ                               
                   INTO :AT-BILL-CYCLE                                  
                       ,:WS-LAST-BILL-DATE :WS-NULL-DATE-IND-AT          
                       ,:AT-CODES-DATA-PRESENT                          
                       ,:AT-REV-MTH-LST-NRML                            
                       ,:AT-CODE-ACCT-STAT                              
                       ,:AT-CODE-BILL-FREQ :WS-NULL-BILL-FRQ-AT          
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT AT.BILL_CYCLE                                           
MFA-TR*                ,AT.DATE_BILL_DAY_00                                     
MFA-TR*                ,AT.CODES_DATA_PRESENT                                   
MFA-TR*                ,AT.REV_MTH_LST_NRML                                     
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.CODE_BILL_FREQ                                       
MFA-TR*            INTO :AT-BILL-CYCLE                                          
MFA-TR*                ,:WS-LAST-BILL-DATE:WS-NULL-DATE-IND-AT                  
MFA-TR*                ,:AT-CODES-DATA-PRESENT                                  
MFA-TR*                ,:AT-REV-MTH-LST-NRML                                    
MFA-TR*                ,:AT-CODE-ACCT-STAT                                      
MFA-TR*                ,:AT-CODE-BILL-FREQ:WS-NULL-BILL-FRQ-AT                  
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*           WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                          
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-SELECT-CURRENT-DATE                                       *        
      *                                                                         
      ******************************************************************        
       7410-SELECT-CURRENT-DATE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE-1         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7410'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-GET-SUM-AMT-TRANS                                         *        
      *                                                                         
      ******************************************************************        
       7420-GET-SUM-AMT-TRANS.                                          
                                                                        
           EXEC SQL                                                     
                 SELECT SUM(AC.AMT_TRAN_BALANCE)                        
                   INTO :WS-TOT-AMT-TRANS-BAL :WS-NULL-AMT-IND-AC        
                   FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                    
                  WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           
                    AND AC.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL    
                    AND AC.ITEM_ID           > 0                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT SUM(AC.AMT_TRAN_BALANCE)                                
MFA-TR*            INTO :WS-TOT-AMT-TRANS-BAL:WS-NULL-AMT-IND-AC                
MFA-TR*            FROM CSS_AR_CNTL AC                                          
MFA-TR*           WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                   
MFA-TR*             AND AC.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
MFA-TR*             AND AC.ITEM_ID           > 0                                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7420                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7420'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-SELECT-USER-PROFILE                                       *        
      ******************************************************************        
       7500-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
                 SELECT PF.FIRST_NAME                                   
                       ,PF.LAST_NAME                                    
                       ,PF.MIDDLE_NAME                                  
                   INTO :PF-FIRST-NAME                                  
                       ,:PF-LAST-NAME                                   
                       ,:PF-MIDDLE-NAME                                 
                   FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)               
                  WHERE PF.USER_ID = :PF-USER-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT PF.FIRST_NAME                                           
MFA-TR*                ,PF.LAST_NAME                                            
MFA-TR*                ,PF.MIDDLE_NAME                                          
MFA-TR*            INTO :PF-FIRST-NAME                                          
MFA-TR*                ,:PF-LAST-NAME                                           
MFA-TR*                ,:PF-MIDDLE-NAME                                         
MFA-TR*            FROM CSS_USER_PROFILE PF                                     
MFA-TR*           WHERE PF.USER_ID = :PF-USER-ID                                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-SELECT-TRAN-BALANCE                                       *        
      ******************************************************************        
       7600-SELECT-TRAN-BALANCE.                                        
                                                                        
           EXEC SQL                                                     
                 SELECT AC.AMT_TRAN_BALANCE                             
PCR530                 ,AC.AMT_AR_DAY_00                                
PCR530                 ,AC.AMT_AR_DAY_30                                
PCR530                 ,AC.AMT_AR_DAY_60                                
PCR530                 ,AC.AMT_AR_DAY_90                                
                   INTO :AC-AMT-TRAN-BALANCE                            
PCR530                 ,:AC-AMT-AR-DAY-00                               
PCR530                 ,:AC-AMT-AR-DAY-30                               
PCR530                 ,:AC-AMT-AR-DAY-60                               
PCR530                 ,:AC-AMT-AR-DAY-90                               
                   FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                    
                  WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           
                    AND AC.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL    
                    AND AC.ITEM_ID           = :AC-ITEM-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT AC.AMT_TRAN_BALANCE                                     
MFA-TR*                ,AC.AMT_AR_DAY_00                                        
MFA-TR*                ,AC.AMT_AR_DAY_30                                        
MFA-TR*                ,AC.AMT_AR_DAY_60                                        
MFA-TR*                ,AC.AMT_AR_DAY_90                                        
MFA-TR*            INTO :AC-AMT-TRAN-BALANCE                                    
MFA-TR*                ,:AC-AMT-AR-DAY-00                                       
MFA-TR*                ,:AC-AMT-AR-DAY-30                                       
MFA-TR*                ,:AC-AMT-AR-DAY-60                                       
MFA-TR*                ,:AC-AMT-AR-DAY-90                                       
MFA-TR*            FROM CSS_AR_CNTL AC                                          
MFA-TR*           WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                   
MFA-TR*             AND AC.PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
MFA-TR*             AND AC.ITEM_ID           = :AC-ITEM-ID                      
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7600                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-3         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT181******************************************************************        
ACT181* 7700-GET-TAX-FLAG                                              *        
ACT181******************************************************************        
ACT181*                                                                         
ACT181 7700-GET-TAX-FLAG.                                               
ACT181*                                                                         
ACT181     EXEC SQL                                                     
ACT181         SELECT K6.CNT_TAXABLE_FL                                 
ACT181           INTO :WS-CNT-TAXABLE-FL                                
ACT181           FROM CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)                
ACT181          WHERE K6.CNT_NAME_CD = :WS-CNT-NAME-CD                  
ACT181                                                           
ACT181                                                      
ACT181     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT K6.CNT_TAXABLE_FL                                         
MFA-TR*          INTO :WS-CNT-TAXABLE-FL                                        
MFA-TR*          FROM CSS_CONTRACT_INFO K6                                      
MFA-TR*         WHERE K6.CNT_NAME_CD = :WS-CNT-NAME-CD                          
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7700                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT181                                                                  
ACT181     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
ACT181                                                                  
ACT181     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT181        CONTINUE                                                  
ACT181     ELSE                                                         
ACT181        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT181        MOVE '7700'                    TO ACTIVE-PARAGRAPH        
ACT181        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT181        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT181                                          ABEND-TABLES            
ACT181        MOVE 'CSS_CONTRACT_INFO'       TO TABLE-1                 
ACT181        MOVE 'CNT-NAME-CD'             TO TABLE-ELEMENT-1         
ACT181        MOVE WS-CNT-NAME-CD            TO HOSTVAR-ELEMENT-1       
ACT181        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
ACT181     END-IF.                                                      
ACT181                                                                  
ACT181 7700-EXIT.                                                       
ACT181     EXIT.                                                        
ACT181*                                                                         
ACT181******************************************************************        
ACT181* 7800-GET-TAX-RATE                                              *        
ACT181******************************************************************        
ACT181*                                                                         
ACT181 7800-GET-TAX-RATE.                                               
ACT181*                                                                         
ACT181     EXEC SQL                                                     
ACT181       SELECT TOP(1) TR.TAX_RATE                                         
ACT181         INTO :WS-TAX-RATE                                        
ACT181         FROM CSS_TAX_RATE TR WITH(READUNCOMMITTED)                       
ACT181        WHERE TR.TAX_CNTRL_NO   = :WS-NC-STATE-SALES-TAX          
ACT181          AND TR.DETAIL_ID      = :WS-REV-DISTRICT-CD             
ACT181          AND TR.DATE_FROM     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
ACT181          AND TR.DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
ACT181                                              
ACT181                                                           
ACT181                                                      
ACT181     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT TR.TAX_RATE                                                 
MFA-TR*        INTO :WS-TAX-RATE                                                
MFA-TR*        FROM CSS_TAX_RATE TR                                             
MFA-TR*       WHERE TR.TAX_CNTRL_NO   = :WS-NC-STATE-SALES-TAX                  
MFA-TR*         AND TR.DETAIL_ID      = :WS-REV-DISTRICT-CD                     
MFA-TR*         AND TR.DATE_FROM     <= :WS-CURRENT-DATE                        
MFA-TR*         AND TR.DATE_TO       >= :WS-CURRENT-DATE                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7800                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT181*                                                                         
ACT181     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
ACT181                                                                  
ACT181     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT181        CONTINUE                                                  
ACT181     ELSE                                                         
ACT181        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT181        MOVE '7800'                    TO ACTIVE-PARAGRAPH        
ACT181        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT181        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT181                                          ABEND-TABLES            
ACT181        MOVE 'CSS_TAX_RATE'            TO TABLE-1                 
ACT181        MOVE 'REV_DISTRICT_CD'         TO TABLE-ELEMENT-1         
ACT181        MOVE WS-REV-DISTRICT-CD        TO HOSTVAR-ELEMENT-1       
ACT181        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
ACT181     END-IF.                                                      
ACT181*                                                                         
ACT181 7800-EXIT.                                                       
ACT181     EXIT.                                                        
ACT181*                                                                         
ACT181******************************************************************        
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'                TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04821_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04821_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE SQLCODE                  TO ABEND-SQLCODE           
               MOVE SQLSTATE                 TO ABEND-SQLSTATE          
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04821_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
     *                                                                  
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'                TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04821_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04821_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8000B'                   TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04821_R2'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04821_R1                            
             (                                                          
              RETURN_CODE                                               
             ,CNT_ITEM_ID                                               
             ,CODE_BILL_TYPE                                            
             ,COMPANY_NO                                                
             ,CODE_CONTRACT_TYPE                                        
             ,CNT_NAME_CD                                               
             ,CNT_STATUS_CD                                             
             ,DATE_CONTRACT                                             
             ,STATUS_CHANGE_DT                                          
             ,CHARGE_AMOUNT                                             
             ,AMT_DOWN_PYMT                                             
             ,AMT_ORIG_ENTERED                                          
             ,NO_SCHED_PYMTS                                            
             ,AMT_MO_PYMT                                               
             ,DATE_PYMT_START                                           
             ,DATE_PYMT_END                                             
             ,UNBILLED_AMT                                              
             ,STATE_TAX                                                 
             ,CITY_TAX                                                  
             ,OTHER_TAX                                                 
             ,CODE_INTRST_METH                                          
             ,INTRST_RATE                                               
             ,SIMPLE_INT_FIN_CHG                                        
             ,INTRST_YTD                                                
             ,DISPOSAL_FEE_AM                                           
             ,INSPECTION_FEE_AM                                         
             ,FILING_FEE_AM                                             
             ,GL_ACCT_NO                                                
             ,USER_ID                                                   
             ,LIEN_CD                                                   
             ,CONTRACT_COMMENTS                                         
             ,REV_DISTRICT_CD                                           
             ,GL_ACCT_NO_ERN_INT                                        
             ,GL_ACCT_NO_DEF_INT                                        
             ,WRT_OFF_GL_ACCT_NO                                        
             ,AMT_DEF_INTEREST                                          
             ,CNT_XFER_ACCT_NO                                          
             ,ADDL_DESC_IND                                             
             ,ADVANCE_COLL_FLAG                                         
             ,REV_MTH_LST_NRML                                          
             ,CNT_ADDL_DESC                                             
             ,TOT_AMT_TRANS_BAL                                         
             ,CODE_BILL_FREQ                                            
             ,TRAN_BALANCE                                              
             ,TOTAL_CHARGE                                              
             ,TOTAL_CONTRACT                                            
             ,CURRENT_BALANCE                                           
             ,SETUP_NAME                                                
             ,COST_CENTER                                               
             ,MIN_TERM_MO_NM                                            
             ,MAX_TERM_MO_NM                                            
             ,MIN_INTRST_RT                                             
             ,MAX_INTRST_RT                                             
ACT181       ,CONTRACT_TAXABLE_FL                                       
ACT181       ,TAX_RATE                                                  
ACT181       ,INTRST_PRIOR_YR                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-CNT-ITEM-ID                                            
             ,:S-CODE-BILL-TYPE                                         
             ,:S-COMPANY-NO                                             
             ,:S-CODE-CONTRACT-TYPE                                     
             ,:S-CNT-NAME-CD                                            
             ,:S-CNT-STATUS-CD                                          
             ,:S-DATE-CONTRACT                                          
             ,:S-STATUS-CHANGE-DT                                       
             ,:S-CHARGE-AMOUNT                                          
             ,:S-AMT-DOWN-PYMT                                          
             ,:S-AMT-ORIG-ENTERED                                       
             ,:S-NO-SCHED-PYMTS                                         
             ,:S-AMT-MO-PYMT                                            
             ,:S-DATE-PYMT-START-1                                      
             ,:S-DATE-PYMT-END                                          
             ,:S-UNBILLED-AMT                                           
             ,:S-STATE-TAX                                              
             ,:S-CITY-TAX                                               
             ,:S-OTHER-TAX                                              
             ,:S-CD-INTRST-METH                                         
             ,:S-INTRST-RATE                                            
             ,:S-SIMPLE-INT-FIN-CHG                                     
             ,:S-INTRST-YTD                                             
             ,:S-WHT-GDS-DISP-FEE                                       
             ,:S-INSPECTION-FEE                                         
             ,:S-FILING-FEE-AM                                          
             ,:S-GL-ACCT-NO                                             
             ,:S-USER-ID                                                
             ,:S-LIEN-CD                                                
             ,:S-CONTRACT-COMMENTS                                      
             ,:S-REV-DISTRICT-CD                                        
             ,:S-GL-ACCT-NO-ERN-INT                                     
             ,:S-GL-ACCT-NO-DEF-INT                                     
             ,:S-WRT-OFF-GL-ACCT-NO                                     
             ,:S-AMT-DEF-INT                                            
             ,:S-XFER-ACCT-NO                                           
             ,:S-ADDL-DESC-IND                                          
             ,:S-ADVANCE-COLL                                           
             ,:S-LAST-BILL-DATE                                         
             ,:S-CNT-ADDL-DESC                                          
             ,:S-TOT-AMT-TRANS-BAL                                      
             ,:S-CODE-BILL-FREQ                                         
             ,:S-AMT-TRAN-BALANCE                                       
             ,:S-TOTAL-CHARGE                                           
             ,:S-TOTAL-CONTRACT                                         
             ,:S-CURRENT-BAL                                            
             ,:S-SETUP-NAME                                             
             ,:S-COST-CENTER                                            
             ,:S-MIN-TERM-MO-NM                                         
             ,:S-MAX-TERM-MO-NM                                         
             ,:S-MIN-INTRST-RT                                          
             ,:S-MAX-INTRST-RT                                          
ACT181       ,:S-CONTRACT-TAXABLE-FL                                    
ACT181       ,:S-TAX-RATE                                               
ACT181       ,:S-INTRST-PRIOR-YR                                        
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04821_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CNT_ITEM_ID                                                       
MFA-TR*      ,CODE_BILL_TYPE                                                    
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CODE_CONTRACT_TYPE                                                
MFA-TR*      ,CNT_NAME_CD                                                       
MFA-TR*      ,CNT_STATUS_CD                                                     
MFA-TR*      ,DATE_CONTRACT                                                     
MFA-TR*      ,STATUS_CHANGE_DT                                                  
MFA-TR*      ,CHARGE_AMOUNT                                                     
MFA-TR*      ,AMT_DOWN_PYMT                                                     
MFA-TR*      ,AMT_ORIG_ENTERED                                                  
MFA-TR*      ,NO_SCHED_PYMTS                                                    
MFA-TR*      ,AMT_MO_PYMT                                                       
MFA-TR*      ,DATE_PYMT_START                                                   
MFA-TR*      ,DATE_PYMT_END                                                     
MFA-TR*      ,UNBILLED_AMT                                                      
MFA-TR*      ,STATE_TAX                                                         
MFA-TR*      ,CITY_TAX                                                          
MFA-TR*      ,OTHER_TAX                                                         
MFA-TR*      ,CODE_INTRST_METH                                                  
MFA-TR*      ,INTRST_RATE                                                       
MFA-TR*      ,SIMPLE_INT_FIN_CHG                                                
MFA-TR*      ,INTRST_YTD                                                        
MFA-TR*      ,DISPOSAL_FEE_AM                                                   
MFA-TR*      ,INSPECTION_FEE_AM                                                 
MFA-TR*      ,FILING_FEE_AM                                                     
MFA-TR*      ,GL_ACCT_NO                                                        
MFA-TR*      ,USER_ID                                                           
MFA-TR*      ,LIEN_CD                                                           
MFA-TR*      ,CONTRACT_COMMENTS                                                 
MFA-TR*      ,REV_DISTRICT_CD                                                   
MFA-TR*      ,GL_ACCT_NO_ERN_INT                                                
MFA-TR*      ,GL_ACCT_NO_DEF_INT                                                
MFA-TR*      ,WRT_OFF_GL_ACCT_NO                                                
MFA-TR*      ,AMT_DEF_INTEREST                                                  
MFA-TR*      ,CNT_XFER_ACCT_NO                                                  
MFA-TR*      ,ADDL_DESC_IND                                                     
MFA-TR*      ,ADVANCE_COLL_FLAG                                                 
MFA-TR*      ,REV_MTH_LST_NRML                                                  
MFA-TR*      ,CNT_ADDL_DESC                                                     
MFA-TR*      ,TOT_AMT_TRANS_BAL                                                 
MFA-TR*      ,CODE_BILL_FREQ                                                    
MFA-TR*      ,TRAN_BALANCE                                                      
MFA-TR*      ,TOTAL_CHARGE                                                      
MFA-TR*      ,TOTAL_CONTRACT                                                    
MFA-TR*      ,CURRENT_BALANCE                                                   
MFA-TR*      ,SETUP_NAME                                                        
MFA-TR*      ,COST_CENTER                                                       
MFA-TR*      ,MIN_TERM_MO_NM                                                    
MFA-TR*      ,MAX_TERM_MO_NM                                                    
MFA-TR*      ,MIN_INTRST_RT                                                     
MFA-TR*      ,MAX_INTRST_RT                                                     
MFA-TR*      ,CONTRACT_TAXABLE_FL                                               
MFA-TR*      ,TAX_RATE                                                          
MFA-TR*      ,INTRST_PRIOR_YR                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-1                                                  
MFA-TR*      ,:S-CNT-ITEM-ID                                                    
MFA-TR*      ,:S-CODE-BILL-TYPE                                                 
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      ,:S-CODE-CONTRACT-TYPE                                             
MFA-TR*      ,:S-CNT-NAME-CD                                                    
MFA-TR*      ,:S-CNT-STATUS-CD                                                  
MFA-TR*      ,:S-DATE-CONTRACT                                                  
MFA-TR*      ,:S-STATUS-CHANGE-DT                                               
MFA-TR*      ,:S-CHARGE-AMOUNT                                                  
MFA-TR*      ,:S-AMT-DOWN-PYMT                                                  
MFA-TR*      ,:S-AMT-ORIG-ENTERED                                               
MFA-TR*      ,:S-NO-SCHED-PYMTS                                                 
MFA-TR*      ,:S-AMT-MO-PYMT                                                    
MFA-TR*      ,:S-DATE-PYMT-START-1                                              
MFA-TR*      ,:S-DATE-PYMT-END                                                  
MFA-TR*      ,:S-UNBILLED-AMT                                                   
MFA-TR*      ,:S-STATE-TAX                                                      
MFA-TR*      ,:S-CITY-TAX                                                       
MFA-TR*      ,:S-OTHER-TAX                                                      
MFA-TR*      ,:S-CD-INTRST-METH                                                 
MFA-TR*      ,:S-INTRST-RATE                                                    
MFA-TR*      ,:S-SIMPLE-INT-FIN-CHG                                             
MFA-TR*      ,:S-INTRST-YTD                                                     
MFA-TR*      ,:S-WHT-GDS-DISP-FEE                                               
MFA-TR*      ,:S-INSPECTION-FEE                                                 
MFA-TR*      ,:S-FILING-FEE-AM                                                  
MFA-TR*      ,:S-GL-ACCT-NO                                                     
MFA-TR*      ,:S-USER-ID                                                        
MFA-TR*      ,:S-LIEN-CD                                                        
MFA-TR*      ,:S-CONTRACT-COMMENTS                                              
MFA-TR*      ,:S-REV-DISTRICT-CD                                                
MFA-TR*      ,:S-GL-ACCT-NO-ERN-INT                                             
MFA-TR*      ,:S-GL-ACCT-NO-DEF-INT                                             
MFA-TR*      ,:S-WRT-OFF-GL-ACCT-NO                                             
MFA-TR*      ,:S-AMT-DEF-INT                                                    
MFA-TR*      ,:S-XFER-ACCT-NO                                                   
MFA-TR*      ,:S-ADDL-DESC-IND                                                  
MFA-TR*      ,:S-ADVANCE-COLL                                                   
MFA-TR*      ,:S-LAST-BILL-DATE                                                 
MFA-TR*      ,:S-CNT-ADDL-DESC                                                  
MFA-TR*      ,:S-TOT-AMT-TRANS-BAL                                              
MFA-TR*      ,:S-CODE-BILL-FREQ                                                 
MFA-TR*      ,:S-AMT-TRAN-BALANCE                                               
MFA-TR*      ,:S-TOTAL-CHARGE                                                   
MFA-TR*      ,:S-TOTAL-CONTRACT                                                 
MFA-TR*      ,:S-CURRENT-BAL                                                    
MFA-TR*      ,:S-SETUP-NAME                                                     
MFA-TR*      ,:S-COST-CENTER                                                    
MFA-TR*      ,:S-MIN-TERM-MO-NM                                                 
MFA-TR*      ,:S-MAX-TERM-MO-NM                                                 
MFA-TR*      ,:S-MIN-INTRST-RT                                                  
MFA-TR*      ,:S-MAX-INTRST-RT                                                  
MFA-TR*      ,:S-CONTRACT-TAXABLE-FL                                            
MFA-TR*      ,:S-TAX-RATE                                                       
MFA-TR*      ,:S-INTRST-PRIOR-YR                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04821_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS-RS1.                                       
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-SEND-RESULT.                                              *        
      *                                                                         
      ******************************************************************        
      *                                                                         
       8200-SEND-RESULT.                                                
           EXEC SQL                                                     
             INSERT INTO #CSR04821_R2                            
             (                                                          
              RETURN_CODE                                               
             ,CNT_ITEM_ID_2                                             
             ,MONTH                                                     
             ,OPENING_BALANCE                                           
             ,INTEREST                                                  
             ,PRINCIPAL                                                 
             ,CLOSING_BALANCE                                           
             ,TOTAL_INTEREST                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-2                                          
             ,:S-CNT-ITEM-ID-2                                          
             ,:S-MONTH                                                  
             ,:S-OPENING-BALANCE                                        
             ,:S-INTEREST                                               
             ,:S-PRINCIPAL                                              
             ,:S-CLOSING-BALANCE                                        
             ,:S-TOTAL-INTEREST                                         
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04821_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CNT_ITEM_ID_2                                                     
MFA-TR*      ,MONTH                                                             
MFA-TR*      ,OPENING_BALANCE                                                   
MFA-TR*      ,INTEREST                                                          
MFA-TR*      ,PRINCIPAL                                                         
MFA-TR*      ,CLOSING_BALANCE                                                   
MFA-TR*      ,TOTAL_INTEREST                                                    
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-2                                                  
MFA-TR*      ,:S-CNT-ITEM-ID-2                                                  
MFA-TR*      ,:S-MONTH                                                          
MFA-TR*      ,:S-OPENING-BALANCE                                                
MFA-TR*      ,:S-INTEREST                                                       
MFA-TR*      ,:S-PRINCIPAL                                                      
MFA-TR*      ,:S-CLOSING-BALANCE                                                
MFA-TR*      ,:S-TOTAL-INTEREST                                                 
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04821_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS-RS2.                                       
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   100                     TO S-RETURN-CODE-1         
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   100                     TO S-RETURN-CODE-2         
              PERFORM 8200-SEND-RESULT        THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04821_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04821_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2.                              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2.        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT.          
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
           PERFORM 8200-SEND-RESULT           THRU 8200-EXIT.           
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS        THRU 8800-EXIT            
            PERFORM 8900-SEND-DONE            THRU 8900-EXIT            
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
