       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04818.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. OCT 16, 2014.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04818                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** LIGHTING MANAGEMENT SYSTEM: TRANSACTION HISTORY SCREEN      **         
      ** RETRIEVE PROGRAM                                            **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   CALL_TYPE             CHAR(01)                            **         
      **   FIXTURE_SEQ           CHAR(10)                            **         
      **   TRNS_HIST_FROM_TS     CHAR(26)                            **         
      **   TRNS_HIST_TO_TS       CHAR(26)                            **         
      **   COMPANY_NO            CHAR(02)                            **         
      **   USER_ID               CHAR(07)                            **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RES SET1:LMS TRANSACTION HISTORY - HEADER DATA            **         
      **   RES SET2:LMS TRANSACTION HISTORY - DETAILS DATA           **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
P00817** 10/16/13    GD43988      NEW PROGRAM.                       **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-TRANS-HDR-CUR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04818'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** LMS_TRANS_HIST, 4J                                                   
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_TRANS_HIST_DET, 4S                                               
           EXEC SQL                                                             
              INCLUDE TBLMSHST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_APPL_PGM_DESC, K9                                                
           EXEC SQL                                                             
              INCLUDE TBPGMDSC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_USER_PROFILE, PF                                                 
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME_ACCT_XREF, HT                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ADDR_FORMATTED, DY                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIP_CODE, A4                                                     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      **** LMS_CODE_DESC, 3U                                                    
           EXEC SQL                                                             
              INCLUDE TBLMCODE                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTR_STORGE_FAC, W9                                               
           EXEC SQL                                                             
              INCLUDE TBMTRFAC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_PLAN_DESC, RD                                               
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_REVENUE_CLASS , F3                                               
           EXEC SQL                                                             
              INCLUDE TBREVCLS                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04818'.    
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9) COMP.                
           05  PARM-CALL-TYPE            PIC X(01).                     
           05  PARM-FIXTURE-SEQ          PIC X(10).                     
           05  PARM-FIXTURE-SEQ-NUM REDEFINES                           
               PARM-FIXTURE-SEQ          PIC 9(10).                     
           05  PARM-TRNS-HIST-FROM-TS    PIC X(26).                     
           05  PARM-TRNS-HIST-TO-TS      PIC X(26).                     
           05  PARM-COMPANY-NO           PIC X(02).                     
           05  PARM-USER-ID              PIC X(07).                     
      *                                                                         
       01  WS-HDR-ARRAY.                                                
           05  H-TRANS-HIST-SEQ-NO       OCCURS 21 TIMES PIC X(26).     
           05  H-EQUIP-TAG-NO            OCCURS 21 TIMES PIC X(12).     
           05  H-APPL-PROGRAM-ID         OCCURS 21 TIMES PIC X(09).     
           05  H-TRANS-DATE              OCCURS 21 TIMES PIC X(10).     
           05  H-SOURCE-APPL-CD          OCCURS 21 TIMES PIC X(03).     
COB305     05 H-SOURCE-APPL-REQ-NO        PIC S9(13)V OCCURS 21 TIMES 
COB305       USAGE COMP-3 VALUE 0.  
COB305     05 H-WMS-POINT-NO        PIC S9(03)V9(2) OCCURS 21 TIMES 
COB305       USAGE COMP-3 VALUE 0.  
           05  H-INSTALL-LOC-NO          OCCURS 21 TIMES PIC X(10).     
COB305     05 H-INSTALL-POINT-NO        PIC S9(05)V OCCURS 21 TIMES 
COB305       USAGE COMP-3 VALUE 0.  
COB305     05 H-ACCOUNT-NO        PIC S9(13)V OCCURS 21 TIMES 
COB305       USAGE COMP-3 VALUE 0.      
           05  H-LAST-UPDATE-USERID      OCCURS 21 TIMES PIC X(07).     
           05  H-TRANS-COMMENTS          OCCURS 21 TIMES PIC X(250).    
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-HDR              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-DET              PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
           05  GTT-RETURN-FIELDS-HDR.                                   
               10 S-H-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
               10 S-H-TRANS-HIST-SEQ-NO  PIC X(26).                     
               10 S-H-TRANS-DATE         PIC X(10).                     
               10 S-H-EQUIP-TAG-NO       PIC X(12).                     
               10 S-H-APPL-PROGRAM-DESC  PIC X(20).                     
               10 S-H-EMPLOYEE-NAME      PIC X(40).                     
               10 S-H-SOURCE-APPL-CD     PIC X(03).                     
COB305         10 S-H-SOURCE-APPL-REQ-NO        PIC S9(13)V 
COB305           USAGE COMP-3 VALUE 0.  
COB305         10 S-H-WMS-POINT-NO        PIC S9(03)V9(2) USAGE COMP-3 
COB305           VALUE 0.  
               10 S-H-INSTALL-LOC-NO     PIC X(10).                     
COB305         10 S-H-INSTALL-POINT-NO        PIC S9(05)V USAGE COMP-3 
COB305           VALUE 0.  
COB305         10 S-H-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.  
               10 S-H-FULL-NAME          PIC X(70).                     
               10 S-H-ADDRESS-LINE-1     PIC X(75).                     
               10 S-H-ADDRESS-LINE-2     PIC X(35).                     
               10 S-H-TRANS-COMMENTS     PIC X(250).                    
               10 S-H-MORE-DATA-AVLB-FL  PIC X(01).                     
      *                                                                         
           05  GTT-RETURN-FIELDS-DET.                                   
               10 S-D-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
               10 S-D-TRANS-HIST-SEQ-NO  PIC X(26).                     
               10 S-D-COLUMN-DESC        PIC X(18).                     
               10 S-D-PRV-COLUMN-VALUE   PIC X(75).                     
               10 S-D-CHG-COLUMN-VALUE   PIC X(75).                     
               10 S-D-PRV-DECODE-BUS-CD  PIC X(02).                     
               10 S-D-CHG-DECODE-BUS-CD  PIC X(02).                     
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88  SEND-DONE-ERROR                 VALUE 'N'.           
               88  SEND-DONE-OK                    VALUE 'Y'.           
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-NULL-1            PIC S9(04) COMP VALUE +0.      
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-YES-NULL               PIC S9(04) VALUE -1.           
           05  WS-CURRENT-TS             PIC X(26)  VALUE SPACES.       
           05  WS-CURRENT-TS-MINUS-25    PIC X(26)  VALUE SPACES.       
           05  WS-EMPLOYEE-NAME          PIC X(40)  VALUE SPACES.       
           05  WS-HDR-FETCH-COUNT        PIC 9(04)  VALUE 0.            
           05  WS-MORE-DATA-AVLB-FL      PIC X(01)  VALUE SPACES.       
           05  WS-HI                     PIC 9(04)  VALUE 0.            
           05  WS-TRANS-COMMENTS.                                       
               49 WS-TRANS-COMMENTS-LEN  PIC S9(4) USAGE COMP.          
               49 WS-TRANS-COMMENTS-TEXT PIC X(250).                    
      *                                                                         
           05  WS-DECODE-VARIABLES.                                     
               10 WS-DECODE-COLUMN-VALUE PIC X(75) VALUE SPACES.        
               10 WS-DECODE-COLUMN-TEXT  PIC X(75) VALUE SPACES.        
               10 WS-DECODE-BUSOP-CD     PIC X(02) VALUE SPACES.        
      *                                                                         
           05  WS-ADDRESS.                                              
              10 WS-ADDRESS-LINE1        PIC X(85)  VALUE SPACES.       
              10 WS-ADDRESS-LINE2        PIC X(85)  VALUE SPACES.       
              10 WS-IN-STRING.                                          
                 15 WS-IN-CHAR           PIC X(01) OCCURS 85 TIMES      
                                         INDEXED BY WS-IN-INDX.         
              10 WS-OUT-STRING.                                         
                 15 WS-OUT-CHAR          PIC X(01) OCCURS 85 TIMES      
                                         INDEXED BY WS-OUT-INDX.        
              10 WS-LAST-CHAR            PIC X(01) VALUE SPACES.        
              10 WS-CHAR-LENGTH          PIC S9(3) VALUE ZERO.          
              10 WS-STREET-ADDRESS.                                     
                 15 WS-HOUSE-NO          PIC X(15) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-ADDR-PREFIX-1     PIC X(03) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-ADDR-PREFIX-2     PIC X(02) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-NAME-STREET       PIC X(30) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STREET-SUFFIX     PIC X(04) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-ADDRESS-SUFFIX    PIC X(02) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STREET-LOCATION-1 PIC X(04) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STREET-LOCATION-2 PIC X(11) VALUE SPACES.        
                 15 FILLER               PIC X(04) VALUE SPACES.        
              10 WS-CITY-STATE.                                         
                 15 WS-CITY              PIC X(26) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STATE             PIC X(02) VALUE SPACES.        
                 15 WS-ZIP-FILLER        PIC X(02) VALUE ' *'.          
                 15 WS-ZIP.                                             
                    20 WS-ZIP-CODE       PIC X(05) VALUE SPACES.        
                    20 WS-ZIP-DASH       PIC X(01) VALUE '-'.           
                    20 WS-ZIP-PLUS-4     PIC X(04) VALUE SPACES.        
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** LMS TRANSACTION HISTORY HEADER CURSOR                                
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRANS_HDR_CUR CURSOR WITH ROWSET POSITIONING FOR  
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           [4J].TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              [4J].EQUIP_TAG_NO,
              [4J].APPL_PROGRAM_ID,
              [4J].TRANS_DATE,
              [4J].SOURCE_APPL_CD,
              [4J].SOURCE_APPL_REQ_NO,
              [4J].WMS_POINT_NO,
              [4J].INSTALL_LOC_NO,
              [4J].INSTALL_POINT_NO,
              [4J].ACCOUNT_NO,
              [4J].LAST_UPDATE_USERID,
              [4J].TRANS_COMMENTS                                 
                FROM  LMS_TRANS_HIST   [4J] WITH(READUNCOMMITTED)               
               WHERE  [4J].EQUIP_SEQ          = :4J-EQUIP-SEQ             
                 AND  [4J].TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  [4J].TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRANS_HDR_CUR CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT  4J.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,4J.EQUIP_TAG_NO                                           
MFA-TR*              ,4J.APPL_PROGRAM_ID                                        
MFA-TR*              ,4J.TRANS_DATE                                             
MFA-TR*              ,4J.SOURCE_APPL_CD                                         
MFA-TR*              ,4J.SOURCE_APPL_REQ_NO                                     
MFA-TR*              ,4J.WMS_POINT_NO                                           
MFA-TR*              ,4J.INSTALL_LOC_NO                                         
MFA-TR*              ,4J.INSTALL_POINT_NO                                       
MFA-TR*              ,4J.ACCOUNT_NO                                             
MFA-TR*              ,4J.LAST_UPDATE_USERID                                     
MFA-TR*              ,4J.TRANS_COMMENTS                                         
MFA-TR*         FROM  LMS_TRANS_HIST   4J                                       
MFA-TR*        WHERE  4J.EQUIP_SEQ          = :4J-EQUIP-SEQ                     
MFA-TR*          AND  4J.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  4J.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **** LMS TRANSACTION HISTORY DETAILS CURSOR                               
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRANS_DET_CUR CURSOR FOR                          
              SELECT  [4S].COLUMN_DESC                                    
                     ,[4S].PRV_COLUMN_VALUE                               
                     ,[4S].CHG_COLUMN_VALUE                               
                FROM  LMS_TRANS_HIST_DET [4S] WITH(READUNCOMMITTED)             
               WHERE  [4S].EQUIP_SEQ          = :4S-EQUIP-SEQ             
                 AND  [4S].TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :4S-TRANS-HIST-SEQ-NO
              )     
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRANS_DET_CUR CURSOR FOR                                  
MFA-TR*       SELECT  4S.COLUMN_DESC                                            
MFA-TR*              ,4S.PRV_COLUMN_VALUE                                       
MFA-TR*              ,4S.CHG_COLUMN_VALUE                                       
MFA-TR*         FROM  LMS_TRANS_HIST_DET 4S                                     
MFA-TR*        WHERE  4S.EQUIP_SEQ          = :4S-EQUIP-SEQ                     
MFA-TR*          AND  4S.TRANS_HIST_SEQ_NO  = :4S-TRANS-HIST-SEQ-NO             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE           PIC X(01).                          
       01  LINK-FIXTURE-SEQ         PIC X(10).                          
       01  LINK-TRNS-HIST-FROM-TS   PIC X(26).                          
       01  LINK-TRNS-HIST-TO-TS     PIC X(26).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
       01  LINK-USER-ID             PIC X(07).                          
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-FIXTURE-SEQ                       
                                ,LINK-TRNS-HIST-FROM-TS                 
                                ,LINK-TRNS-HIST-TO-TS                   
                                ,LINK-COMPANY-NO                        
                                ,LINK-USER-ID.                          
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU  0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT        THRU  1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT       THRU  2000-EXIT.           
           PERFORM 2900-VLDT-NOTFOUND-RES    THRU  2900-EXIT.           
           PERFORM 9999-END-PROGRAM          THRU  9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS          
                                             WS-HDR-ARRAY.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-HDR     THRU  0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-DET     THRU  0100B-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - HEADER                      **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-HDR.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04818_HDR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04818_HDR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04818_HDR
              (                                                    
                       RETURN_CODE            INT                   
                      ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TRANS_DATE CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,EQUIP_TAG_NO CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,APPL_PROGRAM_DESC CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,EMPLOYEE_NAME CHAR(40)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,SOURCE_APPL_CD CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,SOURCE_APPL_REQ_NO     DECIMAL(13,0)            
                      ,WMS_POINT_NO           DECIMAL(05,2)            
                      ,INSTALL_LOC_NO CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,INSTALL_POINT_NO       DECIMAL(05,0)            
                      ,ACCOUNT_NO             DECIMAL(13,0)            
                      ,FULL_NAME CHAR(70)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ADDRESS_LINE_1 CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ADDRESS_LINE_2 CHAR(35)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TRANS_COMMENTS CHAR(250)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,MORE_DATA_AVLB_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS-HDR THRU 8000A-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04818_HDR'        TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,TRANS_HIST_SEQ_NO                                
                      ,TRANS_DATE                                       
                      ,EQUIP_TAG_NO                                     
                      ,APPL_PROGRAM_DESC                                
                      ,EMPLOYEE_NAME                                    
                      ,SOURCE_APPL_CD                                   
                      ,SOURCE_APPL_REQ_NO                               
                      ,WMS_POINT_NO                                     
                      ,INSTALL_LOC_NO                                   
                      ,INSTALL_POINT_NO                                 
                      ,ACCOUNT_NO                                       
                      ,FULL_NAME                                        
                      ,ADDRESS_LINE_1                                   
                      ,ADDRESS_LINE_2                                   
                      ,TRANS_COMMENTS                                   
                      ,MORE_DATA_AVLB_FL                                
               FROM #CSR04818_HDR                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,TRANS_DATE                                               
MFA-TR*               ,EQUIP_TAG_NO                                             
MFA-TR*               ,APPL_PROGRAM_DESC                                        
MFA-TR*               ,EMPLOYEE_NAME                                            
MFA-TR*               ,SOURCE_APPL_CD                                           
MFA-TR*               ,SOURCE_APPL_REQ_NO                                       
MFA-TR*               ,WMS_POINT_NO                                             
MFA-TR*               ,INSTALL_LOC_NO                                           
MFA-TR*               ,INSTALL_POINT_NO                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,FULL_NAME                                                
MFA-TR*               ,ADDRESS_LINE_1                                           
MFA-TR*               ,ADDRESS_LINE_2                                           
MFA-TR*               ,TRANS_COMMENTS                                           
MFA-TR*               ,MORE_DATA_AVLB_FL                                        
MFA-TR*        FROM SESSION.CSR04818_HDR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - DETAILS                     **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-DET.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04818_DET'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04818_DET')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04818_DET
              (                                                    
                       RETURN_CODE            INT                   
                      ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,COLUMN_DESC CHAR(18)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PRV_COLUMN_VALUE CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CHG_COLUMN_VALUE CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PRV_DECODE_BUS_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CHG_DECODE_BUS_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS-DET THRU 8000B-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100C'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04818_DET'        TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,TRANS_HIST_SEQ_NO                                
                      ,COLUMN_DESC                                      
                      ,PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                      ,PRV_DECODE_BUS_CD                                
                      ,CHG_DECODE_BUS_CD                                
               FROM #CSR04818_DET                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,COLUMN_DESC                                              
MFA-TR*               ,PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*               ,PRV_DECODE_BUS_CD                                        
MFA-TR*               ,CHG_DECODE_BUS_CD                                        
MFA-TR*        FROM SESSION.CSR04818_DET                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
           IF LINK-FIXTURE-SEQ GREATER THAN SPACES                      
              MOVE LINK-FIXTURE-SEQ       TO PARM-FIXTURE-SEQ           
           END-IF.                                                      
           MOVE LINK-TRNS-HIST-FROM-TS    TO PARM-TRNS-HIST-FROM-TS.    
           MOVE LINK-TRNS-HIST-TO-TS      TO PARM-TRNS-HIST-TO-TS.      
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO.           
           MOVE LINK-USER-ID              TO PARM-USER-ID.              
      *                                                                         
           IF PARM-FIXTURE-SEQ-NUM > 0                                  
              MOVE PARM-FIXTURE-SEQ-NUM   TO 4J-EQUIP-SEQ               
           END-IF.                                                      
      *                                                                         
           IF PARM-TRNS-HIST-FROM-TS > SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE '1900-01-01-00.00.00.000000'                         
                                          TO PARM-TRNS-HIST-FROM-TS     
           END-IF.                                                      
      *                                                                         
           IF PARM-TRNS-HIST-TO-TS > SPACES                             
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7000-GET-CURRENT-TIMESTAMP  THRU  7000-EXIT       
              MOVE WS-CURRENT-TS          TO PARM-TRNS-HIST-TO-TS       
           END-IF.                                                      
      *                                                                         
GOPI****** MOVE PARM-USER-ID              TO 4J-LAST-UPDATE-USERID.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL TYPE = 'F'(FIXTURE CALL)                                **        
      ** RESULT SETS: HEADER RESULT SET AND DETAILS RESULT SET        **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EVALUATE TRUE                                                
             WHEN (PARM-CALL-TYPE = 'F')                                
               PERFORM 7100-OPEN-TRNS-HDR-CUR   THRU  7100-EXIT         
               PERFORM 7110-FETCH-TRNS-HDR-CUR  THRU  7110-EXIT         
             WHEN OTHER                                                 
               PERFORM 2900-VLDT-NOTFOUND-RES   THRU  2900-EXIT         
               PERFORM 9999-END-PROGRAM         THRU  9999-EXIT         
           END-EVALUATE.                                                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              AND WS-HDR-FETCH-COUNT = 21                               
              MOVE 'Y'                    TO WS-MORE-DATA-AVLB-FL       
           ELSE                                                         
              MOVE 'N'                    TO WS-MORE-DATA-AVLB-FL       
           END-IF.                                                      
      *                                                                         
           PERFORM 2100-PROCESS-HDR-DATA  THRU  2100-EXIT               
           VARYING WS-HI FROM 1 BY 1 UNTIL WS-HI > 20                   
                OR WS-HI > WS-HDR-FETCH-COUNT.                          
      *                                                                         
           EVALUATE TRUE                                                
             WHEN (PARM-CALL-TYPE = 'F')                                
               PERFORM 7120-CLOSE-TRNS-HDR-CUR  THRU  7120-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS TRANSACTION HISTORY HEADER DATA                      **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-HDR-DATA.                                           
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        K9-APPL-PROGRAM-ID         
                                             K9-APPL-PROGRAM-DESC       
                                             WS-EMPLOYEE-NAME           
                                             PF-USER-ID                 
                                             PF-LAST-NAME               
                                             PF-FIRST-NAME              
                                             PF-MIDDLE-NAME.            
      *                                                                         
           MOVE H-APPL-PROGRAM-ID(WS-HI)  TO K9-APPL-PROGRAM-ID.        
           PERFORM 7200-GET-APPL-PGM-DESC   THRU  7200-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE K9-APPL-PROGRAM-ID     TO K9-APPL-PROGRAM-DESC       
           END-IF.                                                      
      *                                                                         
           EVALUATE H-LAST-UPDATE-USERID(WS-HI)                         
             WHEN 'LMSCONV'                                             
               MOVE 'LMS CONVERSION'      TO WS-EMPLOYEE-NAME           
             WHEN 'SYSTEM'                                              
               MOVE 'SYSTEM'              TO WS-EMPLOYEE-NAME           
             WHEN OTHER                                                 
               MOVE H-LAST-UPDATE-USERID(WS-HI)                         
                                          TO PF-USER-ID                 
               PERFORM 7225-GET-EMPLOYEE-NAME  THRU  7225-EXIT          
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE PF-USER-ID         TO WS-EMPLOYEE-NAME           
               END-IF                                                   
           END-EVALUATE.                                                
      *                                                                         
           IF H-ACCOUNT-NO(WS-HI) > 0                                   
              PERFORM 3000-GET-CUST-NAME-ADDRESS  THRU  3000-EXIT       
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-MOVE-RESULT-HDR  THRU  2500-EXIT.               
      *                                                                         
           INITIALIZE                        DCLLMS-TRANS-HIST-DET.     
      *                                                                         
           MOVE 4J-EQUIP-SEQ              TO 4S-EQUIP-SEQ.              
           MOVE H-TRANS-HIST-SEQ-NO(WS-HI)                              
                                          TO 4S-TRANS-HIST-SEQ-NO.      
      *                                                                         
           PERFORM 7900-OPEN-TRNS-DET-CUR    THRU  7900-EXIT.           
           PERFORM 7910-FETCH-TRNS-DET-CUR   THRU  7910-EXIT.           
           PERFORM 2600-MOVE-RESULT-DETAILS  THRU  2600-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7920-CLOSE-TRNS-DET-CUR   THRU  7920-EXIT.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - TRANSACTION HISTORY HEADER                 **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-HDR.                                            
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE H-TRANS-HIST-SEQ-NO(WS-HI)                              
                                          TO S-H-TRANS-HIST-SEQ-NO.     
           MOVE H-TRANS-DATE(WS-HI)       TO S-H-TRANS-DATE.            
           MOVE H-EQUIP-TAG-NO(WS-HI)     TO S-H-EQUIP-TAG-NO.          
           MOVE K9-APPL-PROGRAM-DESC      TO S-H-APPL-PROGRAM-DESC.     
           MOVE WS-EMPLOYEE-NAME          TO S-H-EMPLOYEE-NAME.         
           MOVE H-SOURCE-APPL-CD(WS-HI)   TO S-H-SOURCE-APPL-CD.        
           MOVE H-SOURCE-APPL-REQ-NO(WS-HI)                             
                                          TO S-H-SOURCE-APPL-REQ-NO.    
           MOVE H-WMS-POINT-NO(WS-HI)     TO S-H-WMS-POINT-NO.          
           MOVE H-INSTALL-LOC-NO(WS-HI)   TO S-H-INSTALL-LOC-NO.        
           MOVE H-INSTALL-POINT-NO(WS-HI) TO S-H-INSTALL-POINT-NO.      
           MOVE H-ACCOUNT-NO(WS-HI)       TO S-H-ACCOUNT-NO.            
           MOVE DQ-FULL-NAME              TO S-H-FULL-NAME.             
           MOVE WS-ADDRESS-LINE1          TO S-H-ADDRESS-LINE-1.        
           MOVE WS-ADDRESS-LINE2          TO S-H-ADDRESS-LINE-2.        
      *                                                                         
           INITIALIZE                        WS-TRANS-COMMENTS.         
           MOVE H-TRANS-COMMENTS(WS-HI)   TO WS-TRANS-COMMENTS.         
           IF WS-TRANS-COMMENTS-LEN > 0   AND                           
              WS-TRANS-COMMENTS-LEN < 250                               
              MOVE WS-TRANS-COMMENTS-TEXT TO S-H-TRANS-COMMENTS         
           ELSE                                                         
              MOVE H-TRANS-COMMENTS(WS-HI)                              
                                          TO S-H-TRANS-COMMENTS         
           END-IF                                                       
      *                                                                         
           MOVE WS-MORE-DATA-AVLB-FL      TO S-H-MORE-DATA-AVLB-FL.     
      *                                                                         
           PERFORM 8100A-SEND-RESULT-HDR  THRU  8100A-EXIT.             
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-HDR.     
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - LMS TRANSACTION HISTORY DETAILS            **        
      ******************************************************************        
      *                                                                         
       2600-MOVE-RESULT-DETAILS.                                        
      *                                                                         
           MOVE '2600'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4S-TRANS-HIST-SEQ-NO      TO S-D-TRANS-HIST-SEQ-NO.     
           MOVE 4S-COLUMN-DESC            TO S-D-COLUMN-DESC.           
      *                                                                         
           INITIALIZE                        WS-DECODE-VARIABLES.       
           MOVE 4S-PRV-COLUMN-VALUE-TEXT  TO WS-DECODE-COLUMN-VALUE.    
           PERFORM 2625-GET-COLUMN-VAL-TXT THRU 2625-EXIT.              
           MOVE WS-DECODE-COLUMN-TEXT     TO S-D-PRV-COLUMN-VALUE.      
           MOVE WS-DECODE-BUSOP-CD        TO S-D-PRV-DECODE-BUS-CD.     
      *                                                                         
           INITIALIZE                        WS-DECODE-VARIABLES.       
           MOVE 4S-CHG-COLUMN-VALUE-TEXT  TO WS-DECODE-COLUMN-VALUE.    
           PERFORM 2625-GET-COLUMN-VAL-TXT THRU 2625-EXIT.              
           MOVE WS-DECODE-COLUMN-TEXT     TO S-D-CHG-COLUMN-VALUE.      
           MOVE WS-DECODE-BUSOP-CD        TO S-D-CHG-DECODE-BUS-CD.     
      *                                                                         
           PERFORM 8100B-SEND-RESULT-DET  THRU  8100B-EXIT.             
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-DET      
                                             4S-COLUMN-DESC             
                                             4S-PRV-COLUMN-VALUE        
                                             4S-CHG-COLUMN-VALUE.       
      *                                                                         
           PERFORM 7910-FETCH-TRNS-DET-CUR  THRU  7910-EXIT.            
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET THE COLUMN VALUE TEXT.                                   **        
      ******************************************************************        
      *                                                                         
       2625-GET-COLUMN-VAL-TXT.                                         
      *                                                                         
           MOVE '2625'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF WS-DECODE-COLUMN-VALUE(1:1) = '*'                         
              MOVE WS-DECODE-COLUMN-VALUE    TO WS-DECODE-COLUMN-TEXT   
           ELSE                                                         
              PERFORM 2650-DECODE-VALUE-TO-TEXT  THRU  2650-EXIT        
              IF WS-DECODE-COLUMN-TEXT > SPACES                         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-DECODE-COLUMN-VALUE TO WS-DECODE-COLUMN-TEXT   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECODE VALUE TO TEXT OR IDENTIFY THE BUSOP                   **        
      ******************************************************************        
      *                                                                         
       2650-DECODE-VALUE-TO-TEXT.                                       
      *                                                                         
           MOVE '2650'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EVALUATE TRUE                                                
             WHEN (S-D-COLUMN-DESC = 'FXTR_STOCK_CD'              OR    
                      'STOCK_CD'          OR  'POLE_STOCK_CD')          
               MOVE 'MS'                  TO WS-DECODE-BUSOP-CD         
             WHEN (S-D-COLUMN-DESC =         'NO_CONTRACT_RSN_CD' OR    
                     'CNTRCT_STATUS_CD'   OR 'CNTRCT_DURATION_CD' OR    
                     'INVENTRY_STATUS_CD' OR 'NODE_INVNTRY_ST_CD' OR    
                     'FXTR_INVNTRY_ST_CD' OR 'POLE_INVNTRY_ST_CD' OR    
                     'FXTR_NOBILL_RSN_CD' OR 'POLE_NOBILL_RSN_CD' OR    
                     'FXTR_EQUIP_OWNR_CD' OR 'POLE_EQUIP_OWNR_CD' OR    
                     'FXTR_EQUIP_MFR_CD'  OR 'POLE_EQUIP_MFR_CD'  OR    
                     'NODE_EQUIP_MFR_CD'  OR 'INSTALL_LOC_CD'     OR    
                     'EQUIP_TYPE_CD'      OR 'WORK_FLOW_TYPE_CD')       
               MOVE 'CD'                  TO WS-DECODE-BUSOP-CD         
             WHEN (S-D-COLUMN-DESC = 'STORAGE_FAC_CD')                  
               PERFORM 7300-GET-MTR-STRG-TXT  THRU  7300-EXIT           
             WHEN (S-D-COLUMN-DESC = 'RATE_PLAN_NO'               OR    
                      'FXTR_RATE_PLAN_NO' OR 'POLE_RATE_PLAN_NO')       
               PERFORM 7325-GET-RATE-DESC     THRU  7325-EXIT           
             WHEN (S-D-COLUMN-DESC = 'CODE_REVENUE_CLASS'         OR    
                     'FXTR_REVENUE_CLASS' OR 'POLE_REVENUE_CLASS')      
               PERFORM 7350-GET-RVN-CLS-DESC  THRU  7350-EXIT           
             WHEN (S-D-COLUMN-DESC = 'FXTR_BILLING_FL'            OR    
                     'BILLING_FL'         OR 'POLE_BILLING_FL')         
               EVALUATE WS-DECODE-COLUMN-VALUE                          
                 WHEN 'Z'                                               
                 WHEN 'Y'                                               
                   MOVE 'YES'             TO WS-DECODE-COLUMN-TEXT      
                 WHEN 'N'                                               
                   MOVE 'NO'              TO WS-DECODE-COLUMN-TEXT      
               END-EVALUATE                                             
             WHEN (S-D-COLUMN-DESC = 'EQUIP_CONTRACT_FL')               
               EVALUATE WS-DECODE-COLUMN-VALUE                          
                 WHEN 'Y'                                               
                   MOVE 'YES'             TO WS-DECODE-COLUMN-TEXT      
                 WHEN 'N'                                               
                   MOVE 'NO'              TO WS-DECODE-COLUMN-TEXT      
               END-EVALUATE                                             
           END-EVALUATE.                                                
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-HDR = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-HDR      
              MOVE 100                    TO S-H-RETURN-CODE            
              PERFORM 8100A-SEND-RESULT-HDR  THRU  8100A-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-DET = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-DET      
              MOVE 100                    TO S-D-RETURN-CODE            
              PERFORM 8100B-SEND-RESULT-DET  THRU  8100B-EXIT           
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER'S NAME AND ADDRESS DETAILS                      **        
      ******************************************************************        
      *                                                                         
       3000-GET-CUST-NAME-ADDRESS.                                      
      *                                                                         
           MOVE '3000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        HT-ACCOUNT-NO              
                                             DQ-LAST-NAME               
                                             DQ-FIRST-NAME              
                                             DQ-MIDDLE-NAME             
                                             DQ-FULL-NAME               
                                             DCLCSS-ADDR-FORMATTED      
                                             A4-ZIP-CODE                
                                             A4-ZIP-CODE-TOKEN          
                                             A4-TOWN                    
                                             A4-STATE                   
                                             WS-ADDRESS.                
      *                                                                         
           MOVE H-ACCOUNT-NO(WS-HI)       TO HT-ACCOUNT-NO.             
      *                                                                         
           PERFORM 7250-GET-CUST-NAME-AND-ADDR  THRU  7250-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 3100-FORMAT-ADDRESS   THRU 3100-EXIT              
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FORMAT ADDRESS FIELDS                                        **        
      ******************************************************************        
      *                                                                         
       3100-FORMAT-ADDRESS.                                             
      *                                                                         
           MOVE '3100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE SPACES                    TO WS-IN-STRING               
                                             WS-OUT-STRING.             
           MOVE DY-HOUSE-NO               TO WS-HOUSE-NO.               
           MOVE DY-ADDR-PREFIX-1          TO WS-ADDR-PREFIX-1.          
           MOVE DY-ADDR-PREFIX-2          TO WS-ADDR-PREFIX-2.          
           MOVE DY-STREET-NAME            TO WS-NAME-STREET.            
           MOVE DY-STREET-SUFFIX          TO WS-STREET-SUFFIX.          
           MOVE DY-STREET-LOCATION-1      TO WS-STREET-LOCATION-1.      
           MOVE DY-STREET-LOCATION-2      TO WS-STREET-LOCATION-2.      
           MOVE DY-ADDR-SUFFIX            TO WS-ADDRESS-SUFFIX.         
           MOVE WS-STREET-ADDRESS         TO WS-IN-STRING.              
           MOVE 82                        TO WS-CHAR-LENGTH.            
           PERFORM 3200-REDUCE-EMBED-SPACES  THRU  3200-EXIT.           
           MOVE WS-OUT-STRING             TO WS-ADDRESS-LINE1.          
      *                                                                         
           MOVE SPACES                    TO WS-IN-STRING               
                                             WS-OUT-STRING.             
           MOVE DY-ZIP-CODE               TO WS-ZIP-CODE.               
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
              MOVE '-'                    TO WS-ZIP-DASH                
              MOVE DY-ZIP-CODE-PLUS-FOUR  TO WS-ZIP-PLUS-4              
           END-IF.                                                      
           MOVE ' *'                      TO WS-ZIP-FILLER.             
      *                                                                         
           IF A4-STATE > SPACES AND                                     
              A4-TOWN  > SPACES                                         
              MOVE A4-STATE              TO WS-STATE                    
              MOVE A4-TOWN               TO WS-CITY                     
           ELSE                                                         
              MOVE SPACES                TO WS-STATE                    
              MOVE 'UNKNOWN *'           TO WS-CITY                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-CITY-STATE            TO WS-IN-STRING.               
           MOVE 41                       TO WS-CHAR-LENGTH.             
           PERFORM 3200-REDUCE-EMBED-SPACES THRU 3200-EXIT.             
           MOVE WS-OUT-STRING            TO WS-ADDRESS-LINE2.           
      *                                                                         
           INSPECT WS-ADDRESS-LINE2    REPLACING ALL '*' BY SPACES.     
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REDUCE EMBEDED FIELDS                                        **        
      ******************************************************************        
      *                                                                         
       3200-REDUCE-EMBED-SPACES.                                        
      *                                                                         
           MOVE '3200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           SET WS-OUT-INDX                TO 1.                         
           MOVE SPACES                    TO WS-LAST-CHAR.              
      *                                                                         
           PERFORM VARYING WS-IN-INDX FROM 1 BY 1                       
             UNTIL WS-IN-INDX > WS-CHAR-LENGTH                          
             EVALUATE TRUE                                              
                WHEN WS-IN-CHAR (WS-IN-INDX) = LOW-VALUES               
                     CONTINUE                                           
                WHEN WS-IN-CHAR (WS-IN-INDX) = SPACES                   
                     AND WS-LAST-CHAR = SPACES                          
                     CONTINUE                                           
                WHEN OTHER                                              
                     MOVE WS-IN-CHAR (WS-IN-INDX) TO WS-LAST-CHAR       
                          WS-OUT-CHAR (WS-OUT-INDX)                     
                     SET WS-OUT-INDX UP BY 1                            
             END-EVALUATE                                               
           END-PERFORM.                                                 
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET CURRENT TIMESTAMP                                       **        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -25, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS,
              :WS-CURRENT-TS-MINUS-25                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TS           =  CURRENT TIMESTAMP                  
MFA-TR*         ,:WS-CURRENT-TS-MINUS-25  =  CURRENT TIMESTAMP                  
MFA-TR*                                   -  25 MONTHS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SPACES                     TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'FIXTURE_SEQ'              TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-FIXTURE-SEQ           TO HOSTVAR-ELEMENT-2      
              MOVE LINK-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE LINK-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN LMS TRANSACTION HISTORY HEADER CURSOR                   **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-TRNS-HDR-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN TRANS_HDR_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST'           TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH LMS TRANSACTION HISTORY HEADER CURSOR                  **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-TRNS-HDR-CUR.                                         

MSQ008     MOVE 21 TO MSQ008-TRANS-HDR-CUR
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRANS-HDR-CUR
              FETCH 
              FROM TRANS_HDR_CUR           
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-EQUIP-TAG-NO                                     
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-TRANS-DATE                                       
                   ,:H-SOURCE-APPL-CD                                   
                   ,:H-SOURCE-APPL-REQ-NO                               
                   ,:H-WMS-POINT-NO                                     
                   ,:H-INSTALL-LOC-NO                                   
                   ,:H-INSTALL-POINT-NO                                 
                   ,:H-ACCOUNT-NO                                       
                   ,:H-LAST-UPDATE-USERID                               
                   ,:H-TRANS-COMMENTS                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRANS_HDR_CUR FOR 21 ROWS                  
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-EQUIP-TAG-NO                                             
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-TRANS-DATE                                               
MFA-TR*            ,:H-SOURCE-APPL-CD                                           
MFA-TR*            ,:H-SOURCE-APPL-REQ-NO                                       
MFA-TR*            ,:H-WMS-POINT-NO                                             
MFA-TR*            ,:H-INSTALL-LOC-NO                                           
MFA-TR*            ,:H-INSTALL-POINT-NO                                         
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-LAST-UPDATE-USERID                                       
MFA-TR*            ,:H-TRANS-COMMENTS                                           
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRANS-HDR-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST'           TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE LMS TRANSACTION HISTORY HEADER CURSOR                  **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-TRNS-HDR-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRANS_HDR_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST'           TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET THE PROGRAM DESCRIPTION                                  **        
      ******************************************************************        
      *                                                                         
       7200-GET-APPL-PGM-DESC.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  K9.APPL_PROGRAM_DESC                              
                INTO :K9-APPL-PROGRAM-DESC                              
                FROM  CSS_APPL_PGM_DESC   K9 WITH(READUNCOMMITTED)              
               WHERE  K9.APPL_PROGRAM_ID  =  :K9-APPL-PROGRAM-ID        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  K9.APPL_PROGRAM_DESC                                      
MFA-TR*         INTO :K9-APPL-PROGRAM-DESC                                      
MFA-TR*         FROM  CSS_APPL_PGM_DESC   K9                                    
MFA-TR*        WHERE  K9.APPL_PROGRAM_ID  =  :K9-APPL-PROGRAM-ID                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_APPL_PGM_DESC'        TO TABLE-1                
              MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE K9-APPL-PROGRAM-ID         TO HOSTVAR-ELEMENT-1      
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET EMPLOYEE NAME                                            **        
      ******************************************************************        
      *                                                                         
       7225-GET-EMPLOYEE-NAME.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  CIS.CHAR2$CHAR(LTRIM(RTRIM(PF.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(PF.FIRST_NAME,1,1)  = ' '        
                           THEN '' ELSE ', ' END + LTRIM(RTRIM(
           PF.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           PF.MIDDLE_NAME,1,1) = ' '        
                           THEN '' ELSE ' '  END + LTRIM(RTRIM(
           PF.MIDDLE_NAME)),40)                         
                INTO  :WS-EMPLOYEE-NAME                                 
                FROM  CSS_USER_PROFILE  PF WITH(READUNCOMMITTED)                
               WHERE  PF.USER_ID  =  :PF-USER-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CHAR(STRIP(PF.LAST_NAME)    CONCAT                        
MFA-TR*               CASE WHEN SUBSTR(PF.FIRST_NAME,1,1)  = ' '                
MFA-TR*                    THEN '' ELSE ', ' END  CONCAT                        
MFA-TR*               STRIP(PF.FIRST_NAME)        CONCAT                        
MFA-TR*               CASE WHEN SUBSTR(PF.MIDDLE_NAME,1,1) = ' '                
MFA-TR*                    THEN '' ELSE ' '  END  CONCAT                        
MFA-TR*               STRIP(PF.MIDDLE_NAME),40)                                 
MFA-TR*         INTO  :WS-EMPLOYEE-NAME                                         
MFA-TR*         FROM  CSS_USER_PROFILE  PF                                      
MFA-TR*        WHERE  PF.USER_ID  =  :PF-USER-ID                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7225                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7225'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER NAME AND ADDRESS                                **        
      ******************************************************************        
      *                                                                         
       7250-GET-CUST-NAME-AND-ADDR.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME  
                      ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '   
                                THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '   
                                THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                
                     ,DY.HOUSE_NO                                       
                     ,DY.ADDR_PREFIX_1                                  
                     ,DY.ADDR_PREFIX_2                                  
                     ,DY.STREET_NAME                                    
                     ,DY.STREET_LOCATION_1                              
                     ,DY.STREET_LOCATION_2                              
                     ,DY.STREET_SUFFIX                                  
                     ,DY.ADDRESS_OVERFLOW                               
                     ,DY.CARRIER_ROUTE                                  
                     ,DY.ZIP_CODE                                       
                     ,DY.ZIP_CODE_PLUS_FOUR                             
                     ,DY.ZIP_CODE_TOKEN                                 
                     ,DY.ADDR_SUFFIX                                    
                     ,A4.TOWN                                           
                     ,A4.STATE                                          
                INTO  :DQ-FULL-NAME                                     
                     ,:DY-HOUSE-NO                                      
                     ,:DY-ADDR-PREFIX-1                                 
                     ,:DY-ADDR-PREFIX-2                                 
                     ,:DY-STREET-NAME                                   
                     ,:DY-STREET-LOCATION-1                             
                     ,:DY-STREET-LOCATION-2                             
                     ,:DY-STREET-SUFFIX                                 
                     ,:DY-ADDRESS-OVERFLOW                              
                     ,:DY-CARRIER-ROUTE                                 
                     ,:DY-ZIP-CODE                                      
                     ,:DY-ZIP-CODE-PLUS-FOUR                            
                     ,:DY-ZIP-CODE-TOKEN                                
                     ,:DY-ADDR-SUFFIX                                   
                     ,:A4-TOWN                                          
                     ,:A4-STATE                                         
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
                     ,CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED)              
                     ,CSS_ZIP_CODE        A4 WITH(READUNCOMMITTED)              
               WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO              
                 AND  HT.NAME_ID          =  DQ.NAME_ID                 
                 AND  DQ.NAME_TYPE        =  'CN'                       
                 AND  HT.ADDRESS_ID       =  DY.ADDRESS_ID              
                 AND  HT.CUSTOMER_ROLE_CD =  ' '                        
                 AND  A4.ZIP_CODE         =  DY.ZIP_CODE                
                 AND  A4.ZIP_CODE_TOKEN   =  DY.ZIP_CODE_TOKEN          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME          
MFA-TR*               ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '           
MFA-TR*                         THEN '' ELSE ', '    END  ||                    
MFA-TR*                    STRIP(DQ.FIRST_NAME)           ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '           
MFA-TR*                         THEN '' ELSE ' '     END  ||                    
MFA-TR*                    STRIP(DQ.MIDDLE_NAME),70) END                        
MFA-TR*              ,DY.HOUSE_NO                                               
MFA-TR*              ,DY.ADDR_PREFIX_1                                          
MFA-TR*              ,DY.ADDR_PREFIX_2                                          
MFA-TR*              ,DY.STREET_NAME                                            
MFA-TR*              ,DY.STREET_LOCATION_1                                      
MFA-TR*              ,DY.STREET_LOCATION_2                                      
MFA-TR*              ,DY.STREET_SUFFIX                                          
MFA-TR*              ,DY.ADDRESS_OVERFLOW                                       
MFA-TR*              ,DY.CARRIER_ROUTE                                          
MFA-TR*              ,DY.ZIP_CODE                                               
MFA-TR*              ,DY.ZIP_CODE_PLUS_FOUR                                     
MFA-TR*              ,DY.ZIP_CODE_TOKEN                                         
MFA-TR*              ,DY.ADDR_SUFFIX                                            
MFA-TR*              ,A4.TOWN                                                   
MFA-TR*              ,A4.STATE                                                  
MFA-TR*         INTO  :DQ-FULL-NAME                                             
MFA-TR*              ,:DY-HOUSE-NO                                              
MFA-TR*              ,:DY-ADDR-PREFIX-1                                         
MFA-TR*              ,:DY-ADDR-PREFIX-2                                         
MFA-TR*              ,:DY-STREET-NAME                                           
MFA-TR*              ,:DY-STREET-LOCATION-1                                     
MFA-TR*              ,:DY-STREET-LOCATION-2                                     
MFA-TR*              ,:DY-STREET-SUFFIX                                         
MFA-TR*              ,:DY-ADDRESS-OVERFLOW                                      
MFA-TR*              ,:DY-CARRIER-ROUTE                                         
MFA-TR*              ,:DY-ZIP-CODE                                              
MFA-TR*              ,:DY-ZIP-CODE-PLUS-FOUR                                    
MFA-TR*              ,:DY-ZIP-CODE-TOKEN                                        
MFA-TR*              ,:DY-ADDR-SUFFIX                                           
MFA-TR*              ,:A4-TOWN                                                  
MFA-TR*              ,:A4-STATE                                                 
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*              ,CSS_ADDR_FORMATTED  DY                                    
MFA-TR*              ,CSS_ZIP_CODE        A4                                    
MFA-TR*        WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                      
MFA-TR*          AND  HT.NAME_ID          =  DQ.NAME_ID                         
MFA-TR*          AND  DQ.NAME_TYPE        =  'CN'                               
MFA-TR*          AND  HT.ADDRESS_ID       =  DY.ADDRESS_ID                      
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD =  ' '                                
MFA-TR*          AND  A4.ZIP_CODE         =  DY.ZIP_CODE                        
MFA-TR*          AND  A4.ZIP_CODE_TOKEN   =  DY.ZIP_CODE_TOKEN                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE HT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET THE METER STORAGE TEXT                                   **        
      ******************************************************************        
      *                                                                         
       7300-GET-MTR-STRG-TXT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) W9.MTR_STORAGE_FAC_TX                             
                INTO :WS-DECODE-COLUMN-TEXT                             
                FROM  CSS_MTR_STORGE_FAC  W9 WITH(READUNCOMMITTED)              
               WHERE  W9.MTR_STORAGE_FAC_CD = :WS-DECODE-COLUMN-VALUE   
                 AND  W9.CODE_UTIL_TYPE     = 'E'                       
                 AND  W9.COMPANY_NO         = '01'                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  W9.MTR_STORAGE_FAC_TX                                     
MFA-TR*         INTO :WS-DECODE-COLUMN-TEXT                                     
MFA-TR*         FROM  CSS_MTR_STORGE_FAC  W9                                    
MFA-TR*        WHERE  W9.MTR_STORAGE_FAC_CD = :WS-DECODE-COLUMN-VALUE           
MFA-TR*          AND  W9.CODE_UTIL_TYPE     = 'E'                               
MFA-TR*          AND  W9.COMPANY_NO         = '01'                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_STORGE_FAC'       TO TABLE-1                
              MOVE 'MTR_STORAGE_FAC_CD'       TO TABLE-ELEMENT-1        
              MOVE WS-DECODE-COLUMN-VALUE     TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET THE RATE PLAN DESCRIPTION                                **        
      ******************************************************************        
      *                                                                         
       7325-GET-RATE-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) RD.RATE_DESC                                      
                INTO :WS-DECODE-COLUMN-TEXT                             
                FROM  CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
               WHERE  RD.RATE_PLAN_NO       = :WS-DECODE-COLUMN-VALUE   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RD.RATE_DESC                                              
MFA-TR*         INTO :WS-DECODE-COLUMN-TEXT                                     
MFA-TR*         FROM  CSS_RATE_PLAN_DESC RD                                     
MFA-TR*        WHERE  RD.RATE_PLAN_NO       = :WS-DECODE-COLUMN-VALUE           
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7325                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7325'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-DECODE-COLUMN-VALUE     TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET THE REVENUE CLASS DESCRIPTION                            **        
      ******************************************************************        
      *                                                                         
       7350-GET-RVN-CLS-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) F3.REVENUE_CLS_DESC                               
                INTO :WS-DECODE-COLUMN-TEXT                             
                FROM  CSS_REVENUE_CLASS   F3 WITH(READUNCOMMITTED)              
               WHERE  F3.CODE_REVENUE_CLASS = :WS-DECODE-COLUMN-VALUE   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  F3.REVENUE_CLS_DESC                                       
MFA-TR*         INTO :WS-DECODE-COLUMN-TEXT                                     
MFA-TR*         FROM  CSS_REVENUE_CLASS   F3                                    
MFA-TR*        WHERE  F3.CODE_REVENUE_CLASS = :WS-DECODE-COLUMN-VALUE           
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_REVENUE_CLASS'        TO TABLE-1                
              MOVE 'CODE_REVENUE_CLASS'       TO TABLE-ELEMENT-1        
              MOVE WS-DECODE-COLUMN-VALUE     TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN LMS TRANSACTION HISTORY DETAILS CURSOR                 **        
      ******************************************************************        
      *                                                                         
       7900-OPEN-TRNS-DET-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN TRANS_DET_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST_DET'       TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE 4S-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE 4S-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH LMS TRANSACTION HISTORY DETAILS                        **        
      ******************************************************************        
      *                                                                         
       7910-FETCH-TRNS-DET-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              FETCH TRANS_DET_CUR                                       
               INTO :4S-COLUMN-DESC                                     
                   ,:4S-PRV-COLUMN-VALUE                                
                   ,:4S-CHG-COLUMN-VALUE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7910'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST_DET'       TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE 4S-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE 4S-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE LMS TRANSACTION HISTORY DETAILS                        **        
      ******************************************************************        
      *                                                                         
       7920-CLOSE-TRNS-DET-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRANS_DET_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7920'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST_DET'       TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE 4S-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE 4S-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - HEADER                                **        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS-HDR.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04818_HDR'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04818_HDR                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04818_HDR                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04818_HDR'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - TRANSACTION HISTORY DETAILS           **        
      ******************************************************************        
      *                                                                         
       8000B-DELETE-GTT-ROWS-DET.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04818_DET'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04818_DET                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04818_DET                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04818_DET'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - HEADER                                     **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-HDR.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04818_HDR                           
             (                                                          
              RETURN_CODE                                               
             ,TRANS_HIST_SEQ_NO                                         
             ,TRANS_DATE                                                
             ,EQUIP_TAG_NO                                              
             ,APPL_PROGRAM_DESC                                         
             ,EMPLOYEE_NAME                                             
             ,SOURCE_APPL_CD                                            
             ,SOURCE_APPL_REQ_NO                                        
             ,WMS_POINT_NO                                              
             ,INSTALL_LOC_NO                                            
             ,INSTALL_POINT_NO                                          
             ,ACCOUNT_NO                                                
             ,FULL_NAME                                                 
             ,ADDRESS_LINE_1                                            
             ,ADDRESS_LINE_2                                            
             ,TRANS_COMMENTS                                            
             ,MORE_DATA_AVLB_FL                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-H-RETURN-CODE                                          
             ,:S-H-TRANS-HIST-SEQ-NO                                    
             ,:S-H-TRANS-DATE                                           
             ,:S-H-EQUIP-TAG-NO                                         
             ,:S-H-APPL-PROGRAM-DESC                                    
             ,:S-H-EMPLOYEE-NAME                                        
             ,:S-H-SOURCE-APPL-CD                                       
             ,:S-H-SOURCE-APPL-REQ-NO                                   
             ,:S-H-WMS-POINT-NO                                         
             ,:S-H-INSTALL-LOC-NO                                       
             ,:S-H-INSTALL-POINT-NO                                     
             ,:S-H-ACCOUNT-NO                                           
             ,:S-H-FULL-NAME                                            
             ,:S-H-ADDRESS-LINE-1                                       
             ,:S-H-ADDRESS-LINE-2                                       
             ,:S-H-TRANS-COMMENTS                                       
             ,:S-H-MORE-DATA-AVLB-FL                                    
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04818_HDR                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TRANS_HIST_SEQ_NO                                                 
MFA-TR*      ,TRANS_DATE                                                        
MFA-TR*      ,EQUIP_TAG_NO                                                      
MFA-TR*      ,APPL_PROGRAM_DESC                                                 
MFA-TR*      ,EMPLOYEE_NAME                                                     
MFA-TR*      ,SOURCE_APPL_CD                                                    
MFA-TR*      ,SOURCE_APPL_REQ_NO                                                
MFA-TR*      ,WMS_POINT_NO                                                      
MFA-TR*      ,INSTALL_LOC_NO                                                    
MFA-TR*      ,INSTALL_POINT_NO                                                  
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,FULL_NAME                                                         
MFA-TR*      ,ADDRESS_LINE_1                                                    
MFA-TR*      ,ADDRESS_LINE_2                                                    
MFA-TR*      ,TRANS_COMMENTS                                                    
MFA-TR*      ,MORE_DATA_AVLB_FL                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-H-RETURN-CODE                                                  
MFA-TR*      ,:S-H-TRANS-HIST-SEQ-NO                                            
MFA-TR*      ,:S-H-TRANS-DATE                                                   
MFA-TR*      ,:S-H-EQUIP-TAG-NO                                                 
MFA-TR*      ,:S-H-APPL-PROGRAM-DESC                                            
MFA-TR*      ,:S-H-EMPLOYEE-NAME                                                
MFA-TR*      ,:S-H-SOURCE-APPL-CD                                               
MFA-TR*      ,:S-H-SOURCE-APPL-REQ-NO                                           
MFA-TR*      ,:S-H-WMS-POINT-NO                                                 
MFA-TR*      ,:S-H-INSTALL-LOC-NO                                               
MFA-TR*      ,:S-H-INSTALL-POINT-NO                                             
MFA-TR*      ,:S-H-ACCOUNT-NO                                                   
MFA-TR*      ,:S-H-FULL-NAME                                                    
MFA-TR*      ,:S-H-ADDRESS-LINE-1                                               
MFA-TR*      ,:S-H-ADDRESS-LINE-2                                               
MFA-TR*      ,:S-H-TRANS-COMMENTS                                               
MFA-TR*      ,:S-H-MORE-DATA-AVLB-FL                                            
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100A'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04818_HDR'             TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-HDR.          
      *                                                                         
       8100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - MAINTAIN TRNS HIST DETAILS                 **        
      ******************************************************************        
      *                                                                         
       8100B-SEND-RESULT-DET.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04818_DET                           
             (                                                          
              RETURN_CODE                                               
             ,TRANS_HIST_SEQ_NO                                         
             ,COLUMN_DESC                                               
             ,PRV_COLUMN_VALUE                                          
             ,CHG_COLUMN_VALUE                                          
             ,PRV_DECODE_BUS_CD                                         
             ,CHG_DECODE_BUS_CD                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-D-RETURN-CODE                                          
             ,:S-D-TRANS-HIST-SEQ-NO                                    
             ,:S-D-COLUMN-DESC                                          
             ,:S-D-PRV-COLUMN-VALUE                                     
             ,:S-D-CHG-COLUMN-VALUE                                     
             ,:S-D-PRV-DECODE-BUS-CD                                    
             ,:S-D-CHG-DECODE-BUS-CD                                    
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04818_DET                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TRANS_HIST_SEQ_NO                                                 
MFA-TR*      ,COLUMN_DESC                                                       
MFA-TR*      ,PRV_COLUMN_VALUE                                                  
MFA-TR*      ,CHG_COLUMN_VALUE                                                  
MFA-TR*      ,PRV_DECODE_BUS_CD                                                 
MFA-TR*      ,CHG_DECODE_BUS_CD                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-D-RETURN-CODE                                                  
MFA-TR*      ,:S-D-TRANS-HIST-SEQ-NO                                            
MFA-TR*      ,:S-D-COLUMN-DESC                                                  
MFA-TR*      ,:S-D-PRV-COLUMN-VALUE                                             
MFA-TR*      ,:S-D-CHG-COLUMN-VALUE                                             
MFA-TR*      ,:S-D-PRV-DECODE-BUS-CD                                            
MFA-TR*      ,:S-D-CHG-DECODE-BUS-CD                                            
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100B'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04818_DET'             TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-DET.          
      *                                                                         
       8100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-H-RETURN-CODE               
                                          S-D-RETURN-CODE.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-HDR   THRU  0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-DET   THRU  0100B-EXIT.            
      *                                                                         
           PERFORM 8100A-SEND-RESULT-HDR   THRU  8100A-EXIT.            
           PERFORM 8100B-SEND-RESULT-DET   THRU  8100B-EXIT.            
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE      THRU  8900-EXIT.                 
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
