       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04817.                                      
       AUTHOR.           HA7A338.                                       
COB303 DATE-WRITTEN.     NOVEMBER 27,2014.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                    SOUTH CAROLINA ELECTRIC & GAS               *        
      ******************************************************************        
      *                     STORED PROCEDURE:  CSR04817                *        
      ******************************************************************        
      *                           S U M M A R Y                        *        
      *    CSR04817 :                                                  *        
      *                                                                *        
      *    # UPDATE CONTRACT TERMINATION CHARGES FOR LMS               *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *    PARAMETERS DETAILS                                          *        
      *                                                                *        
      *        INPUT                                                   *        
      *              I_ACCOUNT_NO                DECIMAL(13,0)         *        
      *              I_INSTALL_LOC_NO            CHAR(10)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_01 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_02 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_03 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_04 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_05 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_06 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_07 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_08 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_09 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_10 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_11 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_12 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_13 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_14 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_15 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_16 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_17 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_18 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_19 CHAR(40)              *        
      *              I_LIGHT_CNTRCT_CHRG_DTLS_20 CHAR(40)              *        
      *              I_USER_ID                   CHAR(07)              *        
      *              I_TRANS_COMMENTS            VC(250)               *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *               RETURN_CODE          INTEGER                     *        
      *               APPL_RETURN_CODE     INTEGER                     *        
      *               BUS_RULE_ID          CHAR(10)                    *        
      *               BUS_RULE_RESULT_CD   CHAR(10)                    *        
      *               BUS_RULE_XREF_ID     CHAR(26)                    *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                          MODIFICATION LOG                      *        
      *                                                                *        
      *    DATE          INITIALS    COMMENTS                          *        
      *    -----------   --------    ----------------------------------*        
P00817*    11-27-2014    HA7A338     UPDATE CONTRACT TERMINATION       *        
      *                              CHARGES FOR LMS                   *        
A05084*    04-27-2014    DS16382     ADD BUSINESS RULES                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04817'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR CSR04817 STARTS HERE'.                  
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                PIC X(05) VALUE SPACES.        
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW                PIC X(01) VALUE 'N'.           
              88 NOT-ALL-DONE                VALUE 'N'.                 
              88 ALL-DONE                    VALUE 'Y'.                 
           05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR             VALUE 'N'.                 
              88 SEND-DONE-OK                VALUE 'Y'.                 
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                PIC X(18) VALUE SPACES.        
            10  S-SQLCODE                PIC S9(9) COMP VALUE 0.        
            10  S-SQLSTATE               PIC X(05) VALUE ' '.           
            10  S-TABLE-NAME             PIC X(18) VALUE SPACES.        
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L   PIC S9(4) USAGE COMP.          
                49  S-HOST-VARIABLES-V   PIC X(255).                    
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L    PIC S9(4) USAGE COMP.          
                49  S-SQL-STATEMENT-V    PIC X(255).                    
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L  PIC S9(4) USAGE COMP.          
                49  S-SQL-DESCRIPTION-V  PIC X(255).                    
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN           PIC S9(04) COMP.               
                49 GTT-ROW-CHAR          PIC X(1024).                   
            05  GTT-SQLCODE              PIC S9(9) COMP.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9) COMP VALUE 1.        
           05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9) COMP.                
           05  WRKLEN1                   PIC S9(9) COMP.                
           05  WRKLEN2                   PIC S9(9) COMP.                
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04817'.    
           05 MCSCB822                   PIC X(08) VALUE 'MCSCB822'.    
           05 GTT-NAME                   PIC X(26) VALUE                
                                     'SESSION.CSR04817_R1'.             
           05 WS-LGHT-CNCL-CHRG          PIC 9(03) VALUE 407.           
           05 WS-MISC-CHRG-CD            PIC X(01) VALUE 'E'.           
           05 WS-ONLINE-PGM              PIC X(01) VALUE 'O'.           
           05 WS-INSERT                  PIC X(01) VALUE 'I'.           
           05 WS-FINAL-BIL               PIC X(01) VALUE 'B'.           
           05 WS-HOLD                    PIC X(01) VALUE 'H'.           
           05 WS-LMS                     PIC X(03) VALUE 'LMS'.         
           05 WS-NEW                     PIC X(07) VALUE '**NEW**'.     
           05 WS-TRNS-HIST-TXT           PIC X(37) VALUE                
                           'TERMINATION CHARGES HAVE BEEN APPLIED'.     
A05084     05 WS-FAILED                  PIC X(01) VALUE 'F'.           
                                                                        
       01  WS-MISC.                                                     
           05  S-APPL-RETURN-CODE        PIC S9(09) COMP VALUE 0.       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0. 
           05 WS-INSTALL-LOC-NO          PIC  X(10).                    
           05 WS-LGHT-CNTRT-INFO.                                       
              10 WS-LGHT-CNTRT-DATA OCCURS 20 TIMES                     
                                    INDEXED BY WS-LGHT-CNTRT-INDX.      
                 15 WS-FXTR-EQUIP-SEQ-C  PIC  X(10).                    
                 15 WS-FXTR-EQUIP-SEQ    REDEFINES                      
                    WS-FXTR-EQUIP-SEQ-C  PIC  9(10)V.                   
                 15 WS-FXTR-EQUIP-TAG    PIC  X(12).                    
                 15 WS-CNTRCT-START-DT   PIC  X(10).                    
                 15 WS-ACTL-TERM-CHRG-C  PIC  X(08).                    
                 15 WS-ACTL-TERM-CHRG    REDEFINES                      
                    WS-ACTL-TERM-CHRG-C.                                
                    20 WS-ACTL-TERM-CHRG-SIGN PIC X(01).                
                    20 WS-ACTL-TERM-CHRG-AM   PIC S9(05)V9(02).         
           05 WS-USER-ID                 PIC  X(07).                    
           05 WS-CURRENT-DATE            PIC  X(10).                    
           05 WS-CURRENT-TIMESTAMP       PIC  X(26).                    
           05 WS-TOT-TERM-CHRG-AMT       PIC  S9(05)V9(02) VALUE 0.     
           05 WS-TERM-CHRG-AMT           PIC -ZZZZ9.99.                 
                                                                        
       01  WS-ACCOUNT-HOLD               PIC X(01) VALUE 'N'.           
           88 ACCOUNT-HOLD                         VALUE 'Y'.           
                                                                        
       01 WS-TRANS-COMMENTS.                                            
           05 WS-TRANS-COMMENTS-LEN      PIC S9(04) COMP.               
           05 WS-TRANS-COMMENTS-TXT      PIC X(250).                    
                                                                        
       01 WS-XPLNTN-OF-CHRG-COMMENT.                                    
           05 WS-XPLNTN-OF-CHRG-LEN      PIC S9(04) COMP.               
           05 WS-XPLNTN-OF-CHRG-TXT      PIC X(250).                    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
A05084     05  S-RS1-BUS-RULE-ID         PIC X(10)  VALUE SPACES.       
A05084     05  S-RS1-BUS-RULE-RESULT-CD  PIC X(10)  VALUE SPACES.       
A05084     05  S-RS1-BUS-RULE-XREF-ID    PIC X(26)  VALUE SPACES.       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR UPDATE                          *        
      ******************************************************************        
           COPY CWS04822.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
A05084*****************************************************************         
A05084* CSS_BUS_RULE , 1R                                             *         
A05084*****************************************************************         
A05084      EXEC SQL                                                            
A05084           INCLUDE TBBUSRUL                                               
A05084      END-EXEC.                                                           
A05084                                                                  
A05084*****************************************************************         
A05084* CSS_BUS_RULE_XREF , 1T                                        *         
A05084*****************************************************************         
A05084      EXEC SQL                                                            
A05084           INCLUDE TBRULXRF                                               
A05084      END-EXEC.                                                           
                                                                        
      *** LMS_EQUIP_CONTRACT,4L                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST,4J                                                     
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST_DET,4S                                                 
           EXEC SQL                                                             
              INCLUDE TBLMSHST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_ACCOUNT,AT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_OFF_CYCL_ACCT,OC                                                  
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01  PARM-INSTALL-LOC-NO           PIC X(10).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS01   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS02   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS03   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS04   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS05   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS06   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS07   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS08   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS09   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS10   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS11   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS12   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS13   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS14   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS15   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS16   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS17   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS18   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS19   PIC X(40).                     
       01  PARM-LGHT-CNTRT-CHRG-DTLS20   PIC X(40).                     
       01  PARM-USER-ID                  PIC X(07).                     
       01  PARM-TRANS-COMMENTS           PIC X(250).                    
       01  PARM-EXPLANATION-OF-CHRG      PIC X(250).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-INSTALL-LOC-NO                    
                                 PARM-LGHT-CNTRT-CHRG-DTLS01            
                                 PARM-LGHT-CNTRT-CHRG-DTLS02            
                                 PARM-LGHT-CNTRT-CHRG-DTLS03            
                                 PARM-LGHT-CNTRT-CHRG-DTLS04            
                                 PARM-LGHT-CNTRT-CHRG-DTLS05            
                                 PARM-LGHT-CNTRT-CHRG-DTLS06            
                                 PARM-LGHT-CNTRT-CHRG-DTLS07            
                                 PARM-LGHT-CNTRT-CHRG-DTLS08            
                                 PARM-LGHT-CNTRT-CHRG-DTLS09            
                                 PARM-LGHT-CNTRT-CHRG-DTLS10            
                                 PARM-LGHT-CNTRT-CHRG-DTLS11            
                                 PARM-LGHT-CNTRT-CHRG-DTLS12            
                                 PARM-LGHT-CNTRT-CHRG-DTLS13            
                                 PARM-LGHT-CNTRT-CHRG-DTLS14            
                                 PARM-LGHT-CNTRT-CHRG-DTLS15            
                                 PARM-LGHT-CNTRT-CHRG-DTLS16            
                                 PARM-LGHT-CNTRT-CHRG-DTLS17            
                                 PARM-LGHT-CNTRT-CHRG-DTLS18            
                                 PARM-LGHT-CNTRT-CHRG-DTLS19            
                                 PARM-LGHT-CNTRT-CHRG-DTLS20            
                                 PARM-USER-ID                           
                                 PARM-TRANS-COMMENTS                    
                                 PARM-EXPLANATION-OF-CHRG.              
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE    THRU 0100-EXIT.                   
           PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT.                   
           PERFORM 2000-PROCESS-OUTPUT                                  
                                      THRU 2000-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE.                                               *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLLMS-EQUIP-CONTRACT                             
                      DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           PERFORM 7000-GET-CURRENT-DATE                                
                                      THRU 7000-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04817_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04817_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
A05084             ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
A05084             ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
A05084             ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE             TO WS-SQLSTATE.                    
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS                                
                                      THRU 8000A-EXIT                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME   TO ABEND-PROGRAM                   
                 MOVE '0100'         TO ACTIVE-PARAGRAPH                
                 MOVE SQLCODE        TO ABEND-SQLCODE                   
                 MOVE SQLSTATE       TO ABEND-SQLSTATE                  
                 MOVE 'DECLARE GTT'  TO ABEND-FUNCTION                  
                 MOVE SPACES         TO ABEND-SQL-PREDICATES            
                                        ABEND-TABLES                    
                 MOVE GTT-NAME       TO TABLE-1                         
                 MOVE SPACES         TO TABLE-ELEMENT-1                 
                 MOVE SPACES         TO HOSTVAR-ELEMENT-1               
                 PERFORM 9700-PROCESS-ABEND                             
                                      THRU 9700-EXIT                    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
A05084                ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
A05084                ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
A05084                ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04817_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04817_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO      TO WS-ACCOUNT-NO                   
                                        4L-ACCOUNT-NO                   
                                        4J-ACCOUNT-NO                   
                                        AT-ACCOUNT-NO                   
                                        OC-ACCOUNT-NO.                  
           MOVE PARM-INSTALL-LOC-NO  TO WS-INSTALL-LOC-NO               
                                        4L-INSTALL-LOC-NO               
                                        4J-INSTALL-LOC-NO.              
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS01                             
                                     TO WS-LGHT-CNTRT-DATA(01).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS02                             
                                     TO WS-LGHT-CNTRT-DATA(02).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS03                             
                                     TO WS-LGHT-CNTRT-DATA(03).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS04                             
                                     TO WS-LGHT-CNTRT-DATA(04).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS05                             
                                     TO WS-LGHT-CNTRT-DATA(05).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS06                             
                                     TO WS-LGHT-CNTRT-DATA(06).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS07                             
                                     TO WS-LGHT-CNTRT-DATA(07).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS08                             
                                     TO WS-LGHT-CNTRT-DATA(08).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS09                             
                                     TO WS-LGHT-CNTRT-DATA(09).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS10                             
                                     TO WS-LGHT-CNTRT-DATA(10).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS11                             
                                     TO WS-LGHT-CNTRT-DATA(11).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS12                             
                                     TO WS-LGHT-CNTRT-DATA(12).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS13                             
                                     TO WS-LGHT-CNTRT-DATA(13).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS14                             
                                     TO WS-LGHT-CNTRT-DATA(14).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS15                             
                                     TO WS-LGHT-CNTRT-DATA(15).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS16                             
                                     TO WS-LGHT-CNTRT-DATA(16).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS17                             
                                     TO WS-LGHT-CNTRT-DATA(17).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS18                             
                                     TO WS-LGHT-CNTRT-DATA(18).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS19                             
                                     TO WS-LGHT-CNTRT-DATA(19).         
           MOVE PARM-LGHT-CNTRT-CHRG-DTLS20                             
                                     TO WS-LGHT-CNTRT-DATA(20).         
           MOVE PARM-USER-ID         TO WS-USER-ID                      
                                        4L-LAST-UPDATE-USERID           
                                        4J-LAST-UPDATE-USERID           
                                        4S-LAST-UPDATE-USERID.          
           MOVE WS-CURRENT-DATE      TO 4L-ACTL-CHRG-DT.                
           MOVE PARM-EXPLANATION-OF-CHRG                                
                                     TO WS-XPLNTN-OF-CHRG-COMMENT.      
           MOVE PARM-TRANS-COMMENTS  TO WS-TRANS-COMMENTS.              
           IF WS-TRANS-COMMENTS-TXT <= SPACES                           
              MOVE WS-TRNS-HIST-TXT  TO WS-TRANS-COMMENTS-TXT           
              MOVE LENGTH OF WS-TRNS-HIST-TXT                           
                                     TO WS-TRANS-COMMENTS-LEN           
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-UPDT-EQUP-CNTRT                                 
                                      THRU 2100-EXIT.                   
           PERFORM 2200-INSRT-CNTRT   THRU 2200-EXIT.                   
           PERFORM 2300-INSERT-TRANS-HIST                               
                                      THRU 2300-EXIT.                   
           PERFORM 2400-RLSE-ACCOUNT  THRU 2400-EXIT.                   
           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE                                   
                                     TO S-RETURN-CODE.                  
           MOVE 0                    TO S-APPL-RETURN-CODE.             
A05084     MOVE SPACES               TO S-RS1-BUS-RULE-XREF-ID.         
A05084     IF S-RS1-BUS-RULE-ID > SPACES                                
A05084        MOVE +0                      TO S-RETURN-CODE             
A05084*       PERFORM 7550-GET-RULE-XREF-ID   THRU 7550-EXIT                    
A05084     END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-UPDT-EQUP-CNTRT.                                          *        
      ******************************************************************        
       2100-UPDT-EQUP-CNTRT.                                            
                                                                        
           PERFORM VARYING WS-LGHT-CNTRT-INDX FROM 1 BY 1               
                    UNTIL WS-LGHT-CNTRT-INDX > 20                       
           OR WS-FXTR-EQUIP-SEQ-C(WS-LGHT-CNTRT-INDX) <= SPACES         
           OR WS-FXTR-EQUIP-SEQ-C(WS-LGHT-CNTRT-INDX) <= LOW-VALUES     
                                                                        
              MOVE WS-FXTR-EQUIP-SEQ(WS-LGHT-CNTRT-INDX)                
                                     TO 4L-EQUIP-SEQ                    
              MOVE WS-CNTRCT-START-DT(WS-LGHT-CNTRT-INDX)               
                                     TO 4L-CNTRCT-START-DT              
              IF WS-ACTL-TERM-CHRG-SIGN(WS-LGHT-CNTRT-INDX) = '-'       
                 MULTIPLY WS-ACTL-TERM-CHRG-AM(WS-LGHT-CNTRT-INDX) BY -1
                   GIVING 4L-ACTL-TERM-CHRG-AM                          
              ELSE                                                      
                 MOVE WS-ACTL-TERM-CHRG-AM(WS-LGHT-CNTRT-INDX)          
                                     TO 4L-ACTL-TERM-CHRG-AM            
              END-IF                                                    
              ADD 4L-ACTL-TERM-CHRG-AM                                  
                                     TO WS-TOT-TERM-CHRG-AMT            
                                                                        
              PERFORM 8000-UPDT-LMS-EQUP-CNTRT                          
                                      THRU 8000-EXIT                    
                                                                        
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-INSRT-CNTRT.                                              *        
      ******************************************************************        
       2200-INSRT-CNTRT.                                                
                                                                        
           INITIALIZE  WS-CONTRACT-HEADER-PARMS                         
                       WS-CONTRACT-DETAIL-PARMS                         
                       WS-CONTRACT-OPERATION-TYPE                       
                       WS-CONTRACT-RETURN-INFO.                         
                                                                        
           MOVE WS-INSERT            TO WS-4822-UPDATE-TYPE.            
           MOVE WS-ONLINE-PGM        TO WS-4822-PGM-CALLED-FROM.        
           MOVE PROGRAM-NAME         TO WS-4822-CNT-APPL-PGM-ID.        
           MOVE WS-LMS               TO WS-4822-CNT-APPL-CODE.          
           MOVE WS-ACCOUNT-NO        TO WS-4822-ACCOUNT-NO.             
           MOVE WS-MISC-CHRG-CD      TO WS-4822-CODE-CONTRACT-TYPE.     
           MOVE WS-LGHT-CNCL-CHRG    TO WS-4822-CNT-NAME-CD.            
           MOVE WS-TOT-TERM-CHRG-AMT TO WS-4822-AMT-ORIG-ENTERED.       
                                                                        
           PERFORM 6000-INSRT-CONTRACT-ENTRIES                          
                                      THRU 6000-EXIT.                   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-INSERT-TRANS-HIST.                                        *        
      ******************************************************************        
       2300-INSERT-TRANS-HIST.                                          
                                                                        
           MOVE ZERO                 TO 4L-ACTL-TERM-CHRG-AM            
                                                                        
           PERFORM VARYING WS-LGHT-CNTRT-INDX FROM 1 BY 1               
                    UNTIL WS-LGHT-CNTRT-INDX > 20                       
           OR WS-FXTR-EQUIP-SEQ-C(WS-LGHT-CNTRT-INDX) <= SPACES         
           OR WS-FXTR-EQUIP-SEQ-C(WS-LGHT-CNTRT-INDX) <= LOW-VALUES     
                                                                        
              MOVE WS-FXTR-EQUIP-SEQ(WS-LGHT-CNTRT-INDX)                
                                     TO 4J-EQUIP-SEQ                    
                                        4S-EQUIP-SEQ                    
              MOVE WS-FXTR-EQUIP-TAG(WS-LGHT-CNTRT-INDX)                
                                     TO 4J-EQUIP-TAG-NO                 
              MOVE WS-CNTRCT-START-DT(WS-LGHT-CNTRT-INDX)               
                                     TO 4L-CNTRCT-START-DT              
              IF WS-ACTL-TERM-CHRG-SIGN(WS-LGHT-CNTRT-INDX) = '-'       
                 MULTIPLY WS-ACTL-TERM-CHRG-AM(WS-LGHT-CNTRT-INDX) BY -1
                   GIVING 4L-ACTL-TERM-CHRG-AM                          
              ELSE                                                      
                 MOVE WS-ACTL-TERM-CHRG-AM(WS-LGHT-CNTRT-INDX)          
                                     TO 4L-ACTL-TERM-CHRG-AM            
              END-IF                                                    
                                                                        
              PERFORM 5000-CREATE-TRNS-HIST                             
                                      THRU 5000-EXIT                    
                                                                        
           END-PERFORM.                                                 
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-RLSE-ACCOUNT.                                             *        
      ******************************************************************        
       2400-RLSE-ACCOUNT.                                               
                                                                        
           PERFORM 7025-GET-ACCT-DETAILS                                
                                      THRU 7025-EXIT                    
           IF ACCOUNT-HOLD                                              
              PERFORM 8050-UPDT-ACCT-STATUS                             
                                      THRU 8050-EXIT                    
              PERFORM 8200-INSRT-OFF-CYCL-ACCT                          
                                      THRU 8200-EXIT                    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-CREATE-TRNS-HIST.                                         *        
      ******************************************************************        
       5000-CREATE-TRNS-HIST.                                           
                                                                        
           MOVE WS-LMS               TO 4J-SOURCE-APPL-CD.              
           MOVE PROGRAM-NAME         TO 4J-APPL-PROGRAM-ID.             
                                                                        
           IF WS-XPLNTN-OF-CHRG-TXT > SPACES                            
              MOVE WS-CURRENT-DATE   TO 4J-TRANS-DATE                   
              MOVE WS-CURRENT-TIMESTAMP                                 
                                     TO 4J-TRANS-HIST-SEQ-NO            
              MOVE WS-XPLNTN-OF-CHRG-LEN                                
                                     TO 4J-TRANS-COMMENTS-LEN           
              MOVE WS-XPLNTN-OF-CHRG-TXT                                
                                     TO 4J-TRANS-COMMENTS-TEXT          
              PERFORM 6025-INS-LMS-TRN-HST-CPDLM2                       
                                      THRU 6025-CPDLM2-EXIT             
              MOVE SPACES            TO 4J-TRANS-DATE                   
                                        4J-TRANS-HIST-SEQ-NO            
           END-IF.                                                      
                                                                        
           MOVE WS-TRANS-COMMENTS-LEN                                   
                                     TO 4J-TRANS-COMMENTS-LEN.          
           MOVE WS-TRANS-COMMENTS-TXT                                   
                                     TO 4J-TRANS-COMMENTS-TEXT.         
           MOVE 1                    TO 4S-DETAIL-SEQ-NO.               
                                                                        
           PERFORM 5010-CREATE-TRNS-HIST-DTL                            
                                      THRU 5010-EXIT.                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5010-CREATE-TRNS-HIST-DTL.                                     *        
      ******************************************************************        
       5010-CREATE-TRNS-HIST-DTL.                                       
                                                                        
           MOVE 'ACTL_TERM_CHRG_AM'  TO 4S-COLUMN-DESC.                 
           MOVE WS-NEW               TO 4S-PRV-COLUMN-VALUE-TEXT.       
           MOVE LENGTH OF WS-NEW     TO 4S-PRV-COLUMN-VALUE-LEN.        
           MOVE 4L-ACTL-TERM-CHRG-AM TO WS-TERM-CHRG-AMT.               
           MOVE WS-TERM-CHRG-AMT     TO 4S-CHG-COLUMN-VALUE-TEXT.       
           MOVE LENGTH OF WS-TERM-CHRG-AMT                              
                                     TO 4S-CHG-COLUMN-VALUE-LEN.        
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
                                      THRU 6000-CPDLM2-EXIT.            
                                                                        
           MOVE 'ACTL_CHRG_DT'       TO 4S-COLUMN-DESC.                 
           MOVE WS-NEW               TO 4S-PRV-COLUMN-VALUE-TEXT.       
           MOVE LENGTH OF WS-NEW     TO 4S-PRV-COLUMN-VALUE-LEN.        
           MOVE 4L-ACTL-CHRG-DT      TO 4S-CHG-COLUMN-VALUE-TEXT.       
           MOVE LENGTH OF 4L-ACTL-CHRG-DT                               
                                     TO 4S-CHG-COLUMN-VALUE-LEN.        
                                                                        
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
                                      THRU 6000-CPDLM2-EXIT.            
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *6000-LOAD-LMS-TRN-HST-CPDLM2                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM002                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-INSRT-CONTRACT-ENTRIES.                                  *         
      *****************************************************************         
       6000-INSRT-CONTRACT-ENTRIES.                                     
                                                                        
           CALL MCSCB822 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CONTRACT-HEADER-PARMS                 
                               WS-CONTRACT-DETAIL-PARMS                 
                               WS-CONTRACT-OPERATION-TYPE               
                               WS-CONTRACT-RETURN-INFO.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
           OR WS-4822-APPL-CNT-RETURN-CD NOT EQUAL ZEROES               
              MOVE WS-4822-APPL-CNT-RETURN-CD                           
                                     TO  S-APPL-RETURN-CODE             
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-GET-CURRENT-DATE.                                        *         
      *****************************************************************         
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE SQLCODE           TO ABEND-SQLCODE                   
              MOVE '7000'            TO ACTIVE-PARAGRAPH                
              MOVE 'SET'             TO ABEND-FUNCTION                  
              MOVE SPACES            TO ABEND-SQL-PREDICATES            
                                        ABEND-TABLES                    
                                        TABLE-1                         
              MOVE 'CURRENT DATE'    TO TABLE-ELEMENT-1                 
              MOVE WS-CURRENT-DATE   TO HOSTVAR-ELEMENT-1               
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7025-GET-ACCT-DETAILS.                                        *         
      *****************************************************************         
       7025-GET-ACCT-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT  AT.CUSTOMER_NO                                    
                INTO  :AT-CUSTOMER-NO                                   
                FROM  CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
               WHERE  AT.ACCOUNT_NO       = :AT-ACCOUNT-NO              
                 AND  AT.CODE_ACCT_STAT   = :WS-FINAL-BIL               
                 AND  AT.CODE_ACCT_BILLED = :WS-HOLD                    
                 AND  AT.ACCT_FINALED_DT  IS NULL                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.CUSTOMER_NO                                            
MFA-TR*         INTO  :AT-CUSTOMER-NO                                           
MFA-TR*         FROM  CSS_ACCOUNT  AT                                           
MFA-TR*        WHERE  AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*          AND  AT.CODE_ACCT_STAT   = :WS-FINAL-BIL                       
MFA-TR*          AND  AT.CODE_ACCT_BILLED = :WS-HOLD                            
MFA-TR*          AND  AT.ACCT_FINALED_DT  IS NULL                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 SET ACCOUNT-HOLD    TO TRUE                            
              ELSE                                                      
                 MOVE ZERO           TO WS-ACTIVE-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE SQLCODE           TO ABEND-SQLCODE                   
              MOVE '7025'            TO ACTIVE-PARAGRAPH                
              MOVE 'SELECT'          TO ABEND-FUNCTION                  
              MOVE SPACES            TO ABEND-SQL-PREDICATES            
                                        ABEND-TABLES                    
                                        TABLE-1                         
              MOVE 'CSS_ACCOUNT'     TO TABLE-ELEMENT-1                 
              MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1               
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05084******************************************************************        
A05084*                                                                *        
A05084* 7550-GET-RULE-XREF-ID                                          *        
A05084*                                                                *        
A05084******************************************************************        
A05084 7550-GET-RULE-XREF-ID.                                           
A05084                                                                  
A05084     EXEC SQL                                                     
A05084        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
A05084          INTO :S-RS1-BUS-RULE-XREF-ID                            
A05084          FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)               
A05084              ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
A05084         WHERE [1R].BUS_RULE_ID = :S-RS1-BUS-RULE-ID                
A05084           AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
A05084                                       
A05084                                                      
A05084     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE      1R                                       
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05084                                                                  
A05084     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A05084                                                                  
A05084     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A05084        CONTINUE                                                  
A05084     ELSE                                                         
A05084         MOVE SPACES                  TO ABEND-TABLES             
A05084         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
A05084         MOVE '7550'                  TO ACTIVE-PARAGRAPH         
A05084         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A05084         MOVE 'SELECT'                TO ABEND-FUNCTION           
A05084         MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
A05084         MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
A05084         MOVE S-RS1-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
A05084         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
A05084     END-IF.                                                      
A05084                                                                  
A05084 7550-EXIT.                                                       
A05084     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000-UPDT-LMS-EQUP-CNTRT.                                     *         
      *****************************************************************         
       8000-UPDT-LMS-EQUP-CNTRT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE [4L]                               
                 SET [4L].ACTL_TERM_CHRG_AM   = :4L-ACTL-TERM-CHRG-AM     
                    ,[4L].ACTL_CHRG_DT        = IIF(TRY_CONVERT(DATE, 
                                                       :4L-ACTL-CHRG-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-ACTL-CHRG-DT
              ) <> 0) OR (LEN(:4L-ACTL-CHRG-DT) <> 10), CIS.CHAR2DATE(
                                                       :4L-ACTL-CHRG-DT
              ), CONVERT(DATE, :4L-ACTL-CHRG-DT) )          
                    ,[4L].LAST_UPDATE_USERID  = :4L-LAST-UPDATE-USERID    
              FROM LMS_EQUIP_CONTRACT [4L]
              WHERE [4L].EQUIP_SEQ            = :4L-EQUIP-SEQ             
                AND [4L].INSTALL_LOC_NO       = :4L-INSTALL-LOC-NO        
                AND [4L].CNTRCT_START_DT      = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_CONTRACT  4L                                     
MFA-TR*          SET 4L.ACTL_TERM_CHRG_AM   = :4L-ACTL-TERM-CHRG-AM             
MFA-TR*             ,4L.ACTL_CHRG_DT        = :4L-ACTL-CHRG-DT                  
MFA-TR*             ,4L.LAST_UPDATE_USERID  = :4L-LAST-UPDATE-USERID            
MFA-TR*       WHERE 4L.EQUIP_SEQ            = :4L-EQUIP-SEQ                     
MFA-TR*         AND 4L.INSTALL_LOC_NO       = :4L-INSTALL-LOC-NO                
MFA-TR*         AND 4L.CNTRCT_START_DT      = :4L-CNTRCT-START-DT               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE SQLCODE           TO ABEND-SQLCODE                   
              MOVE '8000'            TO ACTIVE-PARAGRAPH                
              MOVE 'UPDATE'          TO ABEND-FUNCTION                  
              MOVE 'LMS_EQUIP_CONTRACT'                                 
                                     TO ABEND-SQL-PREDICATES            
                                        ABEND-TABLES                    
                                        TABLE-1                         
              MOVE 'ACTL_CHRG_DT'    TO TABLE-ELEMENT-1                 
              MOVE 4L-ACTL-CHRG-DT   TO HOSTVAR-ELEMENT-1               
A05084        MOVE 'LMS0000049'      TO S-RS1-BUS-RULE-ID               
A05084        MOVE WS-FAILED         TO S-RS1-BUS-RULE-RESULT-CD        
A05084        MOVE 0                 TO S-APPL-RETURN-CODE              
A05084        MOVE SPACES            TO S-RS1-BUS-RULE-XREF-ID          
A05084*       PERFORM 7550-GET-RULE-XREF-ID   THRU 7550-EXIT                    
                                                                        
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8050-UPDT-ACCT-STATUS.                                        *         
      *****************************************************************         
       8050-UPDT-ACCT-STATUS.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.CODE_ACCT_BILLED    = ' '                       
                    ,AT.LAST_UPDATE_TS      = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )     
              FROM CSS_ACCOUNT AT
              WHERE  AT.ACCOUNT_NO          = :AT-ACCOUNT-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT     AT                                         
MFA-TR*          SET AT.CODE_ACCT_BILLED    = ' '                               
MFA-TR*             ,AT.LAST_UPDATE_TS      = :WS-CURRENT-TIMESTAMP             
MFA-TR*       WHERE  AT.ACCOUNT_NO          = :AT-ACCOUNT-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE SQLCODE           TO ABEND-SQLCODE                   
              MOVE '8050'            TO ACTIVE-PARAGRAPH                
              MOVE 'UPDATE'          TO ABEND-FUNCTION                  
              MOVE 'CSS_ACCOUNT'     TO ABEND-SQL-PREDICATES            
                                        ABEND-TABLES                    
                                        TABLE-1                         
              MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                 
              MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1               
A05084        MOVE 'LMS0000048'      TO S-RS1-BUS-RULE-ID               
A05084        MOVE WS-FAILED         TO S-RS1-BUS-RULE-RESULT-CD        
A05084        MOVE 0                 TO S-APPL-RETURN-CODE              
A05084        MOVE SPACES            TO S-RS1-BUS-RULE-XREF-ID          
A05084*       PERFORM 7550-GET-RULE-XREF-ID   THRU 7550-EXIT                    
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04817_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04817_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES      TO WS-ACTIVE-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME                                   
                                     TO ABEND-PROGRAM                   
                    MOVE SQLCODE     TO ABEND-SQLCODE                   
                    MOVE SQLSTATE    TO ABEND-SQLSTATE                  
                    MOVE '8000A'     TO ACTIVE-PARAGRAPH                
                    MOVE 'DELETE'    TO ABEND-FUNCTION                  
                    MOVE SPACES      TO ABEND-SQL-PREDICATES            
                                        ABEND-TABLES                    
                    MOVE 'CSR04817_R1'                                  
                                     TO TABLE-1                         
                    MOVE SPACES      TO TABLE-ELEMENT-1                 
                    MOVE SPACES      TO HOSTVAR-ELEMENT-1               
                    PERFORM 9700-PROCESS-ABEND                          
                                      THRU 9700-EXIT                    
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04817_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
A05084            ,BUS_RULE_ID                                          
A05084            ,BUS_RULE_RESULT_CD                                   
A05084            ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
A05084            ,:S-RS1-BUS-RULE-ID                                   
A05084            ,:S-RS1-BUS-RULE-RESULT-CD                            
A05084            ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04817_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                 TO CTR-ROWS                        
           ELSE                                                         
              MOVE PROGRAM-NAME      TO  ABEND-PROGRAM                  
              MOVE '8100'            TO  ACTIVE-PARAGRAPH               
              MOVE SQLCODE           TO  ABEND-SQLCODE                  
              MOVE 'INSERT'          TO  ABEND-FUNCTION                 
              MOVE SPACES            TO  ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04817_R1'     TO  TABLE-1                        
              MOVE SPACES            TO  TABLE-ELEMENT-1                
              MOVE SPACES            TO  HOSTVAR-ELEMENT-1              
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-INSRT-OFF-CYCL-ACCT.                                      *        
      ******************************************************************        
       8200-INSRT-OFF-CYCL-ACCT.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_OFF_CYCL_ACCT                             
                 (                                                      
                   ACCOUNT_NO                                           
                  ,CODE_BILL_OFF_CYCL                                   
                  ,CUSTOMER_NO                                          
                  ,LAST_UPDATE_TS                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :OC-ACCOUNT-NO                                       
                  ,:WS-FINAL-BIL                                        
                  ,:AT-CUSTOMER-NO                                      
                  ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_OFF_CYCL_ACCT                                     
MFA-TR*          (                                                              
MFA-TR*            ACCOUNT_NO                                                   
MFA-TR*           ,CODE_BILL_OFF_CYCL                                           
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :OC-ACCOUNT-NO                                               
MFA-TR*           ,:WS-FINAL-BIL                                                
MFA-TR*           ,:AT-CUSTOMER-NO                                              
MFA-TR*           ,:WS-CURRENT-TIMESTAMP                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME      TO  ABEND-PROGRAM                  
              MOVE '8200'            TO  ACTIVE-PARAGRAPH               
              MOVE SQLCODE           TO  ABEND-SQLCODE                  
              MOVE 'INSERT'          TO  ABEND-FUNCTION                 
              MOVE SPACES            TO  ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSS_OFF_CYCL_ACCT'                                  
                                     TO  TABLE-1                        
              MOVE 'ACCOUNT_NO'      TO  TABLE-ELEMENT-1                
              MOVE OC-ACCOUNT-NO     TO  HOSTVAR-ELEMENT-1              
              PERFORM 9700-PROCESS-ABEND                                
                                      THRU 9700-EXIT                    
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05084******************************************************************        
A05084*   8900-SEND-DONE                                               *        
A05084******************************************************************        
A05084 8900-SEND-DONE.                                                  
A05084*                                                                         
A05084     EXEC SQL                                                     
A05084         OPEN C1                                                  
A05084     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
A05084*                                                                         
A05084 8900-EXIT.                                                       
A05084     EXIT.                                                        
                                                                        
A05084******************************************************************        
A05084* 9000-SEND-ERROR-RESULT                                         *        
A05084******************************************************************        
A05084 9000-SEND-ERROR-RESULT.                                          
A05084*                                                                         
A05084     MOVE 'N'                   TO SEND-DONE-SW.                  
A05084     MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE                  
A05084                                   S-RETURN-CODE.                 
A05084     MOVE SQLERRMC              TO ABEND-SQLERRMC.                
A05084     IF S-RS1-BUS-RULE-ID > SPACES                                
A05084        MOVE +0                      TO S-RETURN-CODE             
A05084     END-IF.                                                      
A05084*                                                                         
A05084     EXEC SQL                                                     
A05084         ROLLBACK                                                 
A05084     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05084*                                                                         
A05084     IF SQLCODE = 0                                               
A05084        CONTINUE                                                  
A05084     ELSE                                                         
A05084        MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
A05084     END-IF.                                                      
A05084*                                                                         
A05084     PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
A05084     PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
A05084*                                                                         
A05084 9000-EXIT.                                                       
A05084     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05084******************************************************************        
A05084*   9999-END-PROGRAM                                             *        
A05084******************************************************************        
A05084 9999-END-PROGRAM.                                                
A05084                                                                  
A05084     IF CTR-ROWS < 1                                              
A05084******************************************************************        
A05084*         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
A05084******************************************************************        
A05084        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
A05084        MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
A05084        MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
A05084        MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
A05084        MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
A05084        MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
A05084        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A05084        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A05084     ELSE                                                         
A05084        PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
A05084     END-IF.                                                      
A05084                                                                  
A05084     
MSQ016        GOBACK.                                                    
A05084                                                                  
A05084 9999-EXIT.                                                       
A05084     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
