       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04816.                                      
COB303 DATE-WRITTEN.     NOV 11, 2014.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04816              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04816 :                                                --         
      *--                                                            --         
      *--  GET CONTRACT TERMINATION CHARGE.                          --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *-- PARAMETERS                                                 --         
      *--                                                            --         
      *--  INPUT                                                     --         
      *--    INSTALL_LOC_NO          CHAR(10)                        --         
      *--    ACCOUNT_NO              CHAR(10)                        --         
      *--    EQUIP_SEQ_NO            CHAR(10)                        --         
      *--                                                            --         
      *--  OUTPUT                                                    --         
      *--    RESULT SET                                              --         
      *--    RETURN_CODE             INTEGER                         --         
      *--    EQUIP_SEQ               DECIMAL(10, 0)                  --         
      *--    EQUIP_TAG_NO            CHAR(12)                        --         
      *--    ORIG_TERM_CHRG_AM       DECIMAL(7, 2)                   --         
      *--    CNTRCT_START_DT         CHAR(10)                        --         
      *--    FIXTURE_DESC            CHAR(50)                        --         
      *--    ACTL_TERM_CHRG_AM       DECIMAL(7, 2)                   --         
      *--    ACTL_CHRG_DT            CHAR(10)                        --         
      *--    CNTRCT_DURATION_CD      CHAR(02)                        --         
      *--    CNTRCT_END_DT           CHAR(10)                        --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00817*--  11/11/2014    SV95326     GET CONTRACT TERMINATION CHARGE.--         
A05136*--  11/05/2015    db41297     add equip_seq_no if passed.    .--         
      *--                                                            --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04816'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_INVENTRY, 4D                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_ENVRNMT, 4F                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_CONTRACT, 4L                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **** LMS_MSTR_STCK_INFO, 4A                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMSTINF                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04816'. 
           05  WS-811                       PIC S9(9) VALUE -811 COMP.  
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-INSTALL-LOC-NO       PIC X(10).                     
           05  PARM-ACCOUNT-NO           PIC X(13).                     
           05  PARM-EQUIP-SEQ-NO         PIC X(10).                     
           05  PARM-EQUIP-SEQ-NUM        REDEFINES                      
               PARM-EQUIP-SEQ-NO         PIC 9(10).                     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-FXTR             PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
      **** GTT TABLE LAYOUT FOR Fixture Details                                 
      *                                                                         
           05 GTT-RETURN-FIELDS-FXTR.                                   
              10 S-RETURN-CODE         PIC S9(9) COMP VALUE 0.          
COB305        10 S-EQUIP-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.        
              10 S-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.          
              10 S-RATE-PLAN-NO        PIC X(03) VALUE SPACES.          
COB305        10 S-ORIG-TERM-CHRG-AM        PIC S9(5)V9(2) USAGE COMP-3 
COB305           VALUE 0.     
              10 S-CNTRCT-START-DT     PIC X(10) VALUE SPACES.          
              10 S-FIXTURE-DESC        PIC X(50) VALUE SPACES.          
COB305        10 S-ACTL-TERM-CHRG-AM        PIC S9(5)V9(2) USAGE COMP-3 
COB305           VALUE 0.     
              10 S-ACTL-CHRG-DT        PIC X(10) VALUE SPACES.          
              10 S-CNTRCT-DURATION-CD  PIC X(02) VALUE SPACES.          
              10 S-CNTRCT-END-DT       PIC X(10) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      **   ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           10  WS-POLE-COUNT                PIC S9(4) COMP.             
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** WOKING STORAGE FOR CPDCA099                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** FIXTURE SPECIAL AGREEMENTS CURSOR                            **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE CNTRCT_DET_CUR CURSOR FOR                        
                SELECT  [4D].EQUIP_SEQ                                    
                       ,[4D].EQUIP_TAG_NO                                 
                       ,[4D].COMPANY_NO                                   
                       ,[4D].CODE_SERVICE_TYPE                            
                       ,[4D].STOCK_CD                                     
                       ,[4L].CNTRCT_START_DT                              
                       ,[4L].ORIG_TERM_CHRG_AM                            
                       ,[4L].ACTL_TERM_CHRG_AM                            
                       ,COALESCE([4L].ACTL_CHRG_DT,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))            
                       ,[4L].CNTRCT_DURATION_CD                           
                 FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)            
                      ,LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)            
                WHERE  [4L].INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO        
                  AND  [4L].ACCOUNT_NO       =  :4L-ACCOUNT-NO            
                  AND  [4L].CNTRCT_END_DT    =  IIF(TRY_CONVERT(DATE, 
                                                      :4L-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-END-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :4L-CNTRCT-END-DT
              ), CONVERT(DATE, :4L-CNTRCT-END-DT) )         
                  AND  [4L].CNTRCT_STATUS_CD =  'T'                       
                  AND  [4L].EQUIP_SEQ        =   [4D].EQUIP_SEQ             
                  AND  [4D].EQUIP_TYPE_CD    =  'F'                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CNTRCT_DET_CUR CURSOR FOR                                
MFA-TR*         SELECT  4D.EQUIP_SEQ                                            
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*                ,4D.COMPANY_NO                                           
MFA-TR*                ,4D.CODE_SERVICE_TYPE                                    
MFA-TR*                ,4D.STOCK_CD                                             
MFA-TR*                ,4L.CNTRCT_START_DT                                      
MFA-TR*                ,4L.ORIG_TERM_CHRG_AM                                    
MFA-TR*                ,4L.ACTL_TERM_CHRG_AM                                    
MFA-TR*                ,IFNULL(4L.ACTL_CHRG_DT,'1900-01-01')                    
MFA-TR*                ,4L.CNTRCT_DURATION_CD                                   
MFA-TR*          FROM  LMS_EQUIP_INVENTRY 4D                                    
MFA-TR*               ,LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*         WHERE  4L.INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO                
MFA-TR*           AND  4L.ACCOUNT_NO       =  :4L-ACCOUNT-NO                    
MFA-TR*           AND  4L.CNTRCT_END_DT    =  :4L-CNTRCT-END-DT                 
MFA-TR*           AND  4L.CNTRCT_STATUS_CD =  'T'                               
MFA-TR*           AND  4L.EQUIP_SEQ        =   4D.EQUIP_SEQ                     
MFA-TR*           AND  4D.EQUIP_TYPE_CD    =  'F'                               
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 LINK-INSTALL-LOC-NO       PIC X(10).                          
       01 LINK-ACCOUNT-NO           PIC X(13).                          
       01 LINK-EQUIP-SEQ-NO         PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING LINK-INSTALL-LOC-NO                     
                               ,LINK-ACCOUNT-NO                         
                               ,LINK-EQUIP-SEQ-NO.                      
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT      THRU  1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT     THRU  2000-EXIT.             
           PERFORM 2900-VLDT-NOTFOUND-RES  THRU  2900-EXIT.             
           PERFORM 9999-END-PROGRAM        THRU  9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-FXTR    THRU  0100A-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - FIXTURE DETAILS             **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-FXTR.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04816_FXTR'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04816_FXTR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04816_FXTR
              (                                                       
                    RETURN_CODE             INT                     
                   ,EQUIP_SEQ               DECIMAL(10,0)              
                   ,EQUIP_TAG_NO CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ORIG_TERM_CHRG_AM       DECIMAL(7,2)               
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXTURE_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTL_TERM_CHRG_AM       DECIMAL(7,2)               
                   ,ACTL_CHRG_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_DURATION_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS-FXTR  THRU  8000A-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04816_FXTR'       TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,EQUIP_SEQ                                        
                      ,EQUIP_TAG_NO                                     
                      ,RATE_PLAN_NO                                     
                      ,ORIG_TERM_CHRG_AM                                
                      ,CNTRCT_START_DT                                  
                      ,FIXTURE_DESC                                     
                      ,ACTL_TERM_CHRG_AM                                
                      ,ACTL_CHRG_DT                                     
                      ,CNTRCT_DURATION_CD                               
                      ,CNTRCT_END_DT                                    
                  FROM #CSR04816_FXTR                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,EQUIP_SEQ                                                
MFA-TR*               ,EQUIP_TAG_NO                                             
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,ORIG_TERM_CHRG_AM                                        
MFA-TR*               ,CNTRCT_START_DT                                          
MFA-TR*               ,FIXTURE_DESC                                             
MFA-TR*               ,ACTL_TERM_CHRG_AM                                        
MFA-TR*               ,ACTL_CHRG_DT                                             
MFA-TR*               ,CNTRCT_DURATION_CD                                       
MFA-TR*               ,CNTRCT_END_DT                                            
MFA-TR*           FROM SESSION.CSR04816_FXTR                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-INSTALL-LOC-NO       TO PARM-INSTALL-LOC-NO        
                                             4L-INSTALL-LOC-NO.         
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO            
                                             4L-ACCOUNT-NO.             
           IF LINK-EQUIP-SEQ-NO > SPACES                                
              MOVE LINK-EQUIP-SEQ-NO      TO PARM-EQUIP-SEQ-NO          
                                             4L-EQUIP-SEQ               
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE INVENTORY INFO,CUSTOMER INFO,CONTRACT INFO,  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 7000-GET-CONTRACT-END-DATE     THRU 7000-EXIT.       
      *                                                                         
           IF PARM-EQUIP-SEQ-NO  > SPACES AND                           
              PARM-EQUIP-SEQ-NO  NOT = '0000000000'                     
              PERFORM 7050-SINGLE-TERM-CHARGE-DET THRU 7050-EXIT        
              PERFORM 7200-GET-FIXTURE-DESC       THRU 7200-EXIT        
              MOVE 4D-EQUIP-SEQ           TO 4F-EQUIP-SEQ               
              PERFORM 7250-GET-EQUIP-ENV-DET      THRU 7250-EXIT        
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
           ELSE                                                         
              PERFORM 7100-OPEN-MULT-TERM-CHRG  THRU 7100-EXIT          
              PERFORM 2200-PROCESS-MULT-TERM-CHRG THRU 2200-EXIT        
                        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
              PERFORM 7120-CLOSE-MULT-TERM-CHRG  THRU 7120-EXIT         
           END-IF.                                                      
      *                                                                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND RESULT SET                                       **        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE '2000A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE 4D-EQUIP-SEQ              TO S-EQUIP-SEQ.               
           MOVE 4D-EQUIP-TAG-NO           TO S-EQUIP-TAG-NO.            
           MOVE 4F-RATE-PLAN-NO           TO S-RATE-PLAN-NO.            
           MOVE 4L-CNTRCT-START-DT        TO S-CNTRCT-START-DT.         
           MOVE 4L-ORIG-TERM-CHRG-AM      TO S-ORIG-TERM-CHRG-AM.       
           MOVE 4A-STOCK-DESC             TO S-FIXTURE-DESC.            
           MOVE 4L-ACTL-TERM-CHRG-AM      TO S-ACTL-TERM-CHRG-AM.       
           IF 4L-ACTL-CHRG-DT  = '1900-01-01'                           
              MOVE SPACES                 TO S-ACTL-CHRG-DT             
           ELSE                                                         
              MOVE 4L-ACTL-CHRG-DT        TO S-ACTL-CHRG-DT             
           END-IF.                                                      
           MOVE 4L-CNTRCT-DURATION-CD     TO S-CNTRCT-DURATION-CD.      
           MOVE 4L-CNTRCT-END-DT          TO S-CNTRCT-END-DT.           
      *                                                                         
           PERFORM 8100A-SEND-RESULT      THRU  8100A-EXIT.             
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-MULT-TERM-CHRG.                                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-MULT-TERM-CHRG.                                     
                                                                        
           PERFORM 7110-FETCH-MULT-TERM-CHRG  THRU 7110-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES                        TO 4A-STOCK-DESC       
              PERFORM 7200-GET-FIXTURE-DESC      THRU 7200-EXIT         
              MOVE 4D-EQUIP-SEQ                  TO 4F-EQUIP-SEQ        
              PERFORM 7250-GET-EQUIP-ENV-DET     THRU 7250-EXIT         
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-FXTR = 0                                         
              INITIALIZE                     GTT-RETURN-FIELDS-FXTR     
              MOVE 100                        TO S-RETURN-CODE          
              PERFORM 8100A-SEND-RESULT       THRU  8100A-EXIT          
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET CONTRACT END DATE.                                      **        
      ******************************************************************        
      *                                                                         
       7000-GET-CONTRACT-END-DATE.                                      
      *                                                                         
A05136     IF 4L-EQUIP-SEQ NUMERIC AND 4L-EQUIP-SEQ > 0                 
A05136       EXEC SQL                                                   
A05136          SELECT  COALESCE(MAX([4L].CNTRCT_END_DT),
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))      
A05136            INTO :4L-CNTRCT-END-DT                                
A05136           FROM  LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)            
A05136          WHERE  [4L].INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO        
A05136            AND  [4L].ACCOUNT_NO       =  :4L-ACCOUNT-NO            
A05136            AND  [4L].EQUIP_SEQ        =  :4L-EQUIP-SEQ             
A05136            AND  [4L].CNTRCT_STATUS_CD =  'T'                       
A05136                                                           
A05136                                                      
A05136       END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT  IFNULL(MAX(4L.CNTRCT_END_DT),'1900-01-01')              
MFA-TR*           INTO :4L-CNTRCT-END-DT                                        
MFA-TR*          FROM  LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*         WHERE  4L.INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO                
MFA-TR*           AND  4L.ACCOUNT_NO       =  :4L-ACCOUNT-NO                    
MFA-TR*           AND  4L.EQUIP_SEQ        =  :4L-EQUIP-SEQ                     
MFA-TR*           AND  4L.CNTRCT_STATUS_CD =  'T'                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
A05136     ELSE                                                         
A05136       EXEC SQL                                                   
A05136          SELECT  COALESCE(MAX([4L].CNTRCT_END_DT),
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))      
A05136            INTO :4L-CNTRCT-END-DT                                
A05136           FROM  LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)            
A05136          WHERE  [4L].INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO        
A05136            AND  [4L].ACCOUNT_NO       =  :4L-ACCOUNT-NO            
A05136            AND  [4L].CNTRCT_STATUS_CD =  'T'                       
A05136                                                           
A05136                                                      
A05136       END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT  IFNULL(MAX(4L.CNTRCT_END_DT),'1900-01-01')              
MFA-TR*           INTO :4L-CNTRCT-END-DT                                        
MFA-TR*          FROM  LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*         WHERE  4L.INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO                
MFA-TR*           AND  4L.ACCOUNT_NO       =  :4L-ACCOUNT-NO                    
MFA-TR*           AND  4L.CNTRCT_STATUS_CD =  'T'                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
A05136     END-IF.                                                      
      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1                
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'EQUIP_SEQ_NO'             TO TABLE-ELEMENT-3        
              MOVE 4L-INSTALL-LOC-NO          TO HOSTVAR-ELEMENT-1      
              MOVE 4L-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 4L-EQUIP-SEQ               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT INVENTORY DATA                                    **        
      ******************************************************************        
      *                                                                         
       7050-SINGLE-TERM-CHARGE-DET.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4D].EQUIP_SEQ                                      
                     ,[4D].EQUIP_TAG_NO                                   
                     ,[4D].COMPANY_NO                                     
                     ,[4D].CODE_SERVICE_TYPE                              
                     ,[4D].STOCK_CD                                       
                     ,[4L].CNTRCT_START_DT                                
                     ,[4L].ORIG_TERM_CHRG_AM                              
                     ,[4L].ACTL_TERM_CHRG_AM                              
                     ,COALESCE([4L].ACTL_CHRG_DT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))              
                     ,[4L].CNTRCT_DURATION_CD                             
                INTO :4D-EQUIP-SEQ                                      
                    ,:4D-EQUIP-TAG-NO                                   
                    ,:4D-COMPANY-NO                                     
                    ,:4D-CODE-SERVICE-TYPE                              
                    ,:4D-STOCK-CD                                       
                    ,:4L-CNTRCT-START-DT                                
                    ,:4L-ORIG-TERM-CHRG-AM                              
                    ,:4L-ACTL-TERM-CHRG-AM                              
                    ,:4L-ACTL-CHRG-DT                                   
                    ,:4L-CNTRCT-DURATION-CD                             
               FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)              
              WHERE  [4L].EQUIP_SEQ        =  :4L-EQUIP-SEQ               
                AND  [4L].INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO          
                AND  [4L].ACCOUNT_NO       =  :4L-ACCOUNT-NO              
                AND  [4L].CNTRCT_END_DT    =  IIF(TRY_CONVERT(DATE, 
                                                      :4L-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-END-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :4L-CNTRCT-END-DT
              ), CONVERT(DATE, :4L-CNTRCT-END-DT) )           
                AND  [4L].CNTRCT_STATUS_CD =  'T'                         
                AND  [4L].EQUIP_SEQ        =  [4D].EQUIP_SEQ                
                AND  [4D].EQUIP_TYPE_CD    =  'F'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4D.EQUIP_SEQ                                              
MFA-TR*              ,4D.EQUIP_TAG_NO                                           
MFA-TR*              ,4D.COMPANY_NO                                             
MFA-TR*              ,4D.CODE_SERVICE_TYPE                                      
MFA-TR*              ,4D.STOCK_CD                                               
MFA-TR*              ,4L.CNTRCT_START_DT                                        
MFA-TR*              ,4L.ORIG_TERM_CHRG_AM                                      
MFA-TR*              ,4L.ACTL_TERM_CHRG_AM                                      
MFA-TR*              ,IFNULL(4L.ACTL_CHRG_DT,'1900-01-01')                      
MFA-TR*              ,4L.CNTRCT_DURATION_CD                                     
MFA-TR*         INTO :4D-EQUIP-SEQ                                              
MFA-TR*             ,:4D-EQUIP-TAG-NO                                           
MFA-TR*             ,:4D-COMPANY-NO                                             
MFA-TR*             ,:4D-CODE-SERVICE-TYPE                                      
MFA-TR*             ,:4D-STOCK-CD                                               
MFA-TR*             ,:4L-CNTRCT-START-DT                                        
MFA-TR*             ,:4L-ORIG-TERM-CHRG-AM                                      
MFA-TR*             ,:4L-ACTL-TERM-CHRG-AM                                      
MFA-TR*             ,:4L-ACTL-CHRG-DT                                           
MFA-TR*             ,:4L-CNTRCT-DURATION-CD                                     
MFA-TR*        FROM  LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*             ,LMS_EQUIP_CONTRACT 4L                                      
MFA-TR*       WHERE  4L.EQUIP_SEQ        =  :4L-EQUIP-SEQ                       
MFA-TR*         AND  4L.INSTALL_LOC_NO   =  :4L-INSTALL-LOC-NO                  
MFA-TR*         AND  4L.ACCOUNT_NO       =  :4L-ACCOUNT-NO                      
MFA-TR*         AND  4L.CNTRCT_END_DT    =  :4L-CNTRCT-END-DT                   
MFA-TR*         AND  4L.CNTRCT_STATUS_CD =  'T'                                 
MFA-TR*         AND  4L.EQUIP_SEQ        =  4D.EQUIP_SEQ                        
MFA-TR*         AND  4D.EQUIP_TYPE_CD    =  'F'                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CNTRCT_END_DT'            TO TABLE-ELEMENT-2        
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-3        
              MOVE 4L-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 4L-CNTRCT-END-DT           TO HOSTVAR-ELEMENT-2      
              MOVE 4L-EQUIP-SEQ               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-MULT-TERM-CHRG.                                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-OPEN-MULT-TERM-CHRG.                                        
                                                                        
           EXEC SQL                                                     
                OPEN CNTRCT_DET_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'CNTRCT_END_DT'            TO TABLE-ELEMENT-2       
               MOVE 4L-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 4L-CNTRCT-END-DT           TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-MULT-TERM-CHRG.                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7110-FETCH-MULT-TERM-CHRG.                                       
                                                                        
           EXEC SQL                                                     
                FETCH CNTRCT_DET_CUR                                    
                INTO :4D-EQUIP-SEQ                                      
                    ,:4D-EQUIP-TAG-NO                                   
                    ,:4D-COMPANY-NO                                     
                    ,:4D-CODE-SERVICE-TYPE                              
                    ,:4D-STOCK-CD                                       
                    ,:4L-CNTRCT-START-DT                                
                    ,:4L-ORIG-TERM-CHRG-AM                              
                    ,:4L-ACTL-TERM-CHRG-AM                              
                    ,:4L-ACTL-CHRG-DT                                   
                    ,:4L-CNTRCT-DURATION-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7110'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'CNTRCT_END_DT'            TO TABLE-ELEMENT-2       
               MOVE 4L-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 4L-CNTRCT-END-DT           TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-MULT-TERM-CHRG.                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7120-CLOSE-MULT-TERM-CHRG.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE CNTRCT_DET_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7120'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'CNTRCT_END_DT'            TO TABLE-ELEMENT-2       
               MOVE 4L-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 4L-CNTRCT-END-DT           TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GET FIXTURE DESCRIPTION.                                    **        
      ******************************************************************        
      *                                                                         
       7200-GET-FIXTURE-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4A].STOCK_DESC                                     
                INTO :4A-STOCK-DESC                                     
               FROM  LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)              
              WHERE  [4A].STOCK_CD       =  :4D-STOCK-CD                  
                AND  [4A].COMPANY_NO     =  :4D-COMPANY-NO                
                AND  [4A].CODE_SERVICE_TYPE =:4D-CODE-SERVICE-TYPE        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4A.STOCK_DESC                                             
MFA-TR*         INTO :4A-STOCK-DESC                                             
MFA-TR*        FROM  LMS_MSTR_STCK_INFO 4A                                      
MFA-TR*       WHERE  4A.STOCK_CD       =  :4D-STOCK-CD                          
MFA-TR*         AND  4A.COMPANY_NO     =  :4D-COMPANY-NO                        
MFA-TR*         AND  4A.CODE_SERVICE_TYPE =:4D-CODE-SERVICE-TYPE                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_MSTR_STCK_INFO'       TO TABLE-1                
              MOVE 'STOCK_CD'                 TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CODE_SERVICE_TYPE'        TO TABLE-ELEMENT-3        
              MOVE 4D-STOCK-CD                TO HOSTVAR-ELEMENT-1      
              MOVE 4D-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 4D-CODE-SERVICE-TYPE       TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT ENVIRONMENT DATA                                  **        
      ******************************************************************        
      *                                                                         
       7250-GET-EQUIP-ENV-DET.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4F].RATE_PLAN_NO                                   
                INTO :4F-RATE-PLAN-NO                                   
               FROM  LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
              WHERE  [4F].EQUIP_SEQ  =  :4F-EQUIP-SEQ                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4F.RATE_PLAN_NO                                           
MFA-TR*         INTO :4F-RATE-PLAN-NO                                           
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*       WHERE  4F.EQUIP_SEQ  =  :4F-EQUIP-SEQ                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_ENVRNMT'        TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 4F-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - FIXTURE DETAILS                      **         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS-FXTR.                                         
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04816_FXTR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04816_FXTR                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04816_FXTR                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04816_FXTR'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - FIXTURE DETAILS                          **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT.                                               
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04816_FXTR                         
                 (                                                      
                   RETURN_CODE                                          
                  ,EQUIP_SEQ                                            
                  ,EQUIP_TAG_NO                                         
                  ,RATE_PLAN_NO                                         
                  ,CNTRCT_START_DT                                      
                  ,ORIG_TERM_CHRG_AM                                    
                  ,FIXTURE_DESC                                         
                  ,ACTL_TERM_CHRG_AM                                    
                  ,ACTL_CHRG_DT                                         
                  ,CNTRCT_DURATION_CD                                   
                  ,CNTRCT_END_DT                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-EQUIP-SEQ                                         
                  ,:S-EQUIP-TAG-NO                                      
                  ,:S-RATE-PLAN-NO                                      
                  ,:S-CNTRCT-START-DT                                   
                  ,:S-ORIG-TERM-CHRG-AM                                 
                  ,:S-FIXTURE-DESC                                      
                  ,:S-ACTL-TERM-CHRG-AM                                 
                  ,:S-ACTL-CHRG-DT                                      
                  ,:S-CNTRCT-DURATION-CD                                
                  ,:S-CNTRCT-END-DT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04816_FXTR                                 
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,ORIG_TERM_CHRG_AM                                            
MFA-TR*           ,FIXTURE_DESC                                                 
MFA-TR*           ,ACTL_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_CHRG_DT                                                 
MFA-TR*           ,CNTRCT_DURATION_CD                                           
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-EQUIP-SEQ                                                 
MFA-TR*           ,:S-EQUIP-TAG-NO                                              
MFA-TR*           ,:S-RATE-PLAN-NO                                              
MFA-TR*           ,:S-CNTRCT-START-DT                                           
MFA-TR*           ,:S-ORIG-TERM-CHRG-AM                                         
MFA-TR*           ,:S-FIXTURE-DESC                                              
MFA-TR*           ,:S-ACTL-TERM-CHRG-AM                                         
MFA-TR*           ,:S-ACTL-CHRG-DT                                              
MFA-TR*           ,:S-CNTRCT-DURATION-CD                                        
MFA-TR*           ,:S-CNTRCT-END-DT                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-FXTR           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04816_FXTR'           TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100A-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-FXTR    THRU  0100A-EXIT.          
      *                                                                         
           PERFORM 8100A-SEND-RESULT         THRU  8100A-EXIT.          
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE    THRU  9900-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE  THRU  8900-EXIT.                     
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
