       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04814.                                         
COB303 DATE-WRITTEN.  FEBRUARY 8, 2016.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM COPIES ATTRIBUTES BETWEEN ACCOUNTS.              *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  02/08/16   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04814'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     01050000
              INCLUDE TBACCT                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBCSTSTS                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBACTATT                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-OLD-ACCOUNT-NO-CHAR   PIC X(13).                      
           05  WS-OLD-ACCOUNT-NO-NUM    REDEFINES WS-OLD-ACCOUNT-NO-CHAR
                                        PIC 9(13).                      
           05  WS-NEW-ACCOUNT-NO-CHAR   PIC X(13).                      
           05  WS-NEW-ACCOUNT-NO-NUM    REDEFINES WS-NEW-ACCOUNT-NO-CHAR
                                        PIC 9(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04814'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-BILL-NOTIFICATION     PIC X(01) VALUE SPACES.         
           05  WS-PAYMENT-REMINDER      PIC X(01) VALUE SPACES.         
           05  WS-ADDRESS-ID            PIC S9(13)V COMP-3 VALUE ZEROES.
           05  WS-ADDRESS-FORMAT        PIC X(01) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-OLD-ACCOUNT-NO      PIC X(13).                          
       01  LINK-NEW-ACCOUNT-NO      PIC X(13).                          
       01  LINK-MAIL-ADDRESS-CD     PIC X(01).                          
       01  LINK-USERID              PIC X(07).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-OLD-ACCOUNT-NO,                                    
                LINK-NEW-ACCOUNT-NO,                                    
                LINK-MAIL-ADDRESS-CD,                                   
                LINK-USERID.                                            
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-OLD-ACCOUNT-NO <= SPACES                             
               MOVE ZEROES TO LINK-OLD-ACCOUNT-NO
           END-IF.                      
           MOVE LINK-OLD-ACCOUNT-NO TO WS-OLD-ACCOUNT-NO-NUM.           
           IF LINK-NEW-ACCOUNT-NO <= SPACES                             
               MOVE ZEROES TO LINK-NEW-ACCOUNT-NO
           END-IF.                      
           MOVE LINK-NEW-ACCOUNT-NO TO WS-NEW-ACCOUNT-NO-NUM.           
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET.                            
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO        
                                            MI-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE WS-NEW-ACCOUNT-NO-NUM    TO MH-ACCOUNT-NO.              
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'CSR04814'               TO MH-APPL-PROGRAM-ID.         
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-OLD-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                 
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 2100-GET-OLD-ACCT-DATA THRU 2100-EXIT
           END-IF.           
                                                                        
           MOVE WS-NEW-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                 
           IF AT-ACCOUNT-NO > 0                                         
               IF WS-PAYMENT-REMINDER = 'Y'                             
                   PERFORM 2200-PAYMENT-REMINDER THRU 2200-EXIT         
               END-IF                                                   
               IF WS-BILL-NOTIFICATION = '1' OR '2' OR '3' OR '4'       
                   PERFORM 2300-BILL-NOTIFICATION THRU 2300-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-GET-OLD-ACCT-DATA.                                          
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7010-SELECT-STATS THRU 7010-EXIT.                    
                                                                        
           MOVE 'EMAIL PMT REMINDER' TO YP-ATTRIBUTE-DESC.              
           MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX.                        
           PERFORM 7200-SELECT-ATTRIB THRU 7200-EXIT.                   
           IF YP-ATTRIBUTE-VALUE-CD = 'YES'                             
               MOVE 'Y' TO WS-PAYMENT-REMINDER                          
           ELSE                                                         
               MOVE 'N' TO WS-PAYMENT-REMINDER
           END-IF.                         
                                                                        
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX.                        
           PERFORM 7200-SELECT-ATTRIB THRU 7200-EXIT.                   
           IF YP-ATTRIBUTE-VALUE-CD = 'NO'                              
               MOVE '4' TO WS-BILL-NOTIFICATION                         
           ELSE                                                         
               IF AT-NO-BILL-COPIES = 0                                 
                   MOVE '1' TO WS-BILL-NOTIFICATION                     
               ELSE                                                     
                   IF AT-NO-BILL-COPIES > 0                             
                       MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC      
                       MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX             
                       PERFORM 7200-SELECT-ATTRIB THRU 7200-EXIT        
                       IF YP-ATTRIBUTE-VALUE-CD = 'YES'                 
                           MOVE '3' TO WS-BILL-NOTIFICATION             
                       ELSE                                             
                           MOVE '5' TO WS-BILL-NOTIFICATION
                       END-IF
                   END-IF
               END-IF
           END-IF.            
                                                                        
           IF (AT-NO-BILL-COPIES = 0 OR                                 
               CE-EBILL-REGISTER-IND = 'Y') AND                         
               WS-BILL-NOTIFICATION = '5'                               
                   MOVE '2' TO WS-BILL-NOTIFICATION
           END-IF.                    
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-PAYMENT-REMINDER.                                           
                                                                        
           MOVE 'EMAIL PMT REMINDER' TO WZ-ATTRIBUTE-DESC               
                                        YP-ATTRIBUTE-DESC.              
           PERFORM 7020-ACCOUNT-ATTRIB THRU 7020-EXIT.                  
           EVALUATE WZ-ATTRIB-DFLT-VAL-CD                               
               WHEN 'NO'                                                
                   MOVE 'YES' TO YP-ATTRIBUTE-VALUE-CD                  
               WHEN 'YES'                                               
                   MOVE 'NO' TO YP-ATTRIBUTE-VALUE-CD.                  
           MOVE WZ-ATTRIB-DFLT-VAL-TX TO YP-ATTRIBUTE-VALUE-TX.         
           MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT.               
           MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO.                         
           PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT.                
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE 'EMAIL PMT REMINDER' TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE +18                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE 'ATTRIBUTE DESC '    TO MI-COLUMN-DESC.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                     TO WS-TRAN-APPL-NO.                
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE 'OPT OUT'            TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE +7                   TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE 'OPT IN'             TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE +6                   TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE 'PYMT REMINDER'      TO MI-COLUMN-DESC.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                     TO WS-TRAN-APPL-NO.                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-BILL-NOTIFICATION.                                          
                                                                        
           EVALUATE WS-BILL-NOTIFICATION                                
              WHEN '1'                                                  
                   PERFORM 2310-EMAIL-ONLY THRU 2310-EXIT               
              WHEN '2'                                                  
                   PERFORM 2320-EMAIL-PAPER THRU 2320-EXIT              
              WHEN '3'                                                  
                   PERFORM 2330-PAPER-ONLY THRU 2330-EXIT               
              WHEN '4'                                                  
                   PERFORM 2340-NO-BILL-NOTIFY THRU 2340-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE 'BILL NOTIFY OPT' TO MI-COLUMN-DESC.                    
           MOVE +25 TO MI-PRV-COLUMN-VALUE-LEN.                         
           MOVE 'SYSTEM DEFAULT PAPER ONLY' TO MI-PRV-COLUMN-VALUE-TEXT.
           EVALUATE WS-BILL-NOTIFICATION                                
              WHEN 1                                                    
                  MOVE +15               TO MI-CHG-COLUMN-VALUE-LEN     
                  MOVE 'PAPERLESS/EMAIL' TO MI-CHG-COLUMN-VALUE-TEXT    
              WHEN 2                                                    
                  MOVE +15               TO MI-CHG-COLUMN-VALUE-LEN     
                  MOVE 'EMAIL AND PAPER' TO MI-CHG-COLUMN-VALUE-TEXT    
              WHEN 3                                                    
                  MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN     
                  MOVE 'PAPER ONLY'      TO MI-CHG-COLUMN-VALUE-TEXT    
              WHEN 4                                                    
                  MOVE +17               TO MI-CHG-COLUMN-VALUE-LEN     
                  MOVE 'NO PAPER/NO EMAIL' TO MI-CHG-COLUMN-VALUE-TEXT  
           END-EVALUATE                                                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-EMAIL-ONLY.                                                 
                                                                        
           MOVE 0 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-EMAIL-PAPER.                                                
                                                                        
           MOVE 1 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2330-PAPER-ONLY.                                                 
                                                                        
           MOVE 1 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
                                                                        
           MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO.                         
           MOVE 'YES' TO YP-ATTRIBUTE-VALUE-CD.                         
           MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT.               
           MOVE +15 TO YP-ATTRIBUTE-VALUE-TX-LEN.                       
           MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-VALUE-TX-TEXT         
                                     YP-ATTRIBUTE-DESC.                 
           PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT.                
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2340-NO-BILL-NOTIFY.                                             
                                                                        
           MOVE 0 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
                                                                        
           MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO.                         
           MOVE 'NO' TO YP-ATTRIBUTE-VALUE-CD.                          
           MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT.               
           MOVE +16 TO YP-ATTRIBUTE-VALUE-TX-LEN.                       
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-VALUE-TX-TEXT        
                                      YP-ATTRIBUTE-DESC.                
           PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT.                
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              COMPANY_NO,
              NO_BILL_COPIES,
              ADDRESS_ID,
              ADDRESS_FORMAT                                     
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-COMPANY-NO,                                    
                     :AT-NO-BILL-COPIES,                                
                     :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT                                             
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-NO-BILL-COPIES,                                        
MFA-TR*              :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ADDRESS-ID TO WS-ADDRESS-ID                  
                   MOVE AT-ADDRESS-FORMAT TO WS-ADDRESS-FORMAT          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) EBILL_REGISTER_IND                                 
                INTO :CE-EBILL-REGISTER-IND                             
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS CE                                          
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO CE-EBILL-REGISTER-IND                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7010'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_CUST_STATS'  TO TABLE-1                    
                   MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1            
                   MOVE AT-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-ACCOUNT-ATTRIB.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ATTRIB_DFLT_VAL_CD,
              ATTRIB_DFLT_VAL_TX                                 
                INTO :WZ-ATTRIB-DFLT-VAL-CD,                            
                     :WZ-ATTRIB-DFLT-VAL-TX                             
                FROM CSS_ATTRIBUTE WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO = :AT-COMPANY-NO                        
                 AND ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTRIB_DFLT_VAL_CD,                                        
MFA-TR*              ATTRIB_DFLT_VAL_TX                                         
MFA-TR*         INTO :WZ-ATTRIB-DFLT-VAL-CD,                                    
MFA-TR*              :WZ-ATTRIB-DFLT-VAL-TX                                     
MFA-TR*         FROM CSS_ATTRIBUTE                                              
MFA-TR*        WHERE COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          AND ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7020'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ATTRIBUTE'   TO TABLE-1                    
                   MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-COMPANY-NO     TO HOSTVAR-ELEMENT-1          
                   MOVE 'ATTRIBUTE_DESC'  TO TABLE-ELEMENT-2            
                   MOVE WZ-ATTRIBUTE-DESC TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'OLD_ACCT_NO'         TO TABLE-ELEMENT-2             
              MOVE 'NEW_ACCT_NO'         TO TABLE-ELEMENT-3             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-OLD-ACCOUNT-NO   TO HOSTVAR-ELEMENT-2           
              MOVE LINK-NEW-ACCOUNT-NO   TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-ATTRIB.                                              
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ATTRIBUTE_VALUE_CD                                  
               INTO :YP-ATTRIBUTE-VALUE-CD                              
               FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),                
                    CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND COMPANY_NO = :AT-COMPANY-NO                         
                AND YP.ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC              
                AND ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX           
                AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC               
                AND ATTRIBUTE_STAT_CD = 'A'                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT ATTRIBUTE_VALUE_CD                                  14210000
MFA-TR*        INTO :YP-ATTRIBUTE-VALUE-CD                              14380000
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE YP,                              14550000
MFA-TR*             CSS_ATTRIBUTE WZ                                            
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         14560000
MFA-TR*         AND COMPANY_NO = :AT-COMPANY-NO                                 
MFA-TR*         AND YP.ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                      
MFA-TR*         AND ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX                   
MFA-TR*         AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC                       
MFA-TR*         AND ATTRIBUTE_STAT_CD = 'A'                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ACCT-ATTRIBUTE                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7200'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   MOVE 'ATTRIBUTE_DESC'  TO TABLE-ELEMENT-2            
                   MOVE 'EMAIL PMT REMINDER' TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-ATTRIBUTE.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                   ( ACCOUNT_NO,                                        
                     ATTRIBUTE_DESC,                                    
                     ATTRIBUTE_VALUE_CD,                                
                     ATTRIBUTE_VALUE_DT,                                
                     ATTRIBUTE_VALUE_TX)                                
              VALUES                                                    
                   (:YP-ACCOUNT-NO,                                     
                    :YP-ATTRIBUTE-DESC,                                 
                    :YP-ATTRIBUTE-VALUE-CD,                             
                    IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) ),                      
                    :YP-ATTRIBUTE-VALUE-TX)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*            ( ACCOUNT_NO,                                                
MFA-TR*              ATTRIBUTE_DESC,                                            
MFA-TR*              ATTRIBUTE_VALUE_CD,                                        
MFA-TR*              ATTRIBUTE_VALUE_DT,                                        
MFA-TR*              ATTRIBUTE_VALUE_TX)                                        
MFA-TR*       VALUES                                                            
MFA-TR*            (:YP-ACCOUNT-NO,                                             
MFA-TR*             :YP-ATTRIBUTE-DESC,                                         
MFA-TR*             :YP-ATTRIBUTE-VALUE-CD,                                     
MFA-TR*             :YP-ATTRIBUTE-VALUE-DT,                                     
MFA-TR*             :YP-ATTRIBUTE-VALUE-TX)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-BILL-COPIES.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8360'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
