       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04813.                                         
COB303 DATE-WRITTEN.  MARCH 4, 2015.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES SPOUSE INFO FROM THE WEB.                *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  03/04/14   FMB       NEW PROGRAM.                             *00290000
A05317*  12/28/16   FMB       REPLACE ZEROES WITH SPACES IN SSN.       *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04813'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     01010000
              INCLUDE TBCSTSTS                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01010000
              INCLUDE TBNAME                                            01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04813'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-SPOUSE-EXISTS-FLAG    PIC X(03) VALUE 'NO '.          
               88 SPOUSE-EXISTS                   VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-STATS-CHANGED-FLAG    PIC X(03) VALUE 'NO '.          
               88 STATS-CHANGED                   VALUE 'YES'.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-SPOUSE-FIRST-NAME   PIC X(15).                          
       01  LINK-SPOUSE-LAST-NAME    PIC X(40).                          
       01  LINK-SPOUSE-SSN          PIC X(09).                          
       01  LINK-SPOUSE-DOB          PIC X(10).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO,                                       
                LINK-SPOUSE-FIRST-NAME,                                 
                LINK-SPOUSE-LAST-NAME,                                  
                LINK-SPOUSE-SSN,                                        
                LINK-SPOUSE-DOB,                                        
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CE-CUSTOMER-NO.                   
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
A05317     IF LINK-SPOUSE-SSN = ALL '0'                                 
A05317         MOVE SPACES TO LINK-SPOUSE-SSN
           END-IF.                          
           PERFORM 7005-DETERMINE-DATABASE THRU 7005-EXIT.              
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-PREMISE-NO.              
           MOVE CE-CUSTOMER-NO           TO MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL032'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7020-SELECT-SPOUSE THRU 7020-EXIT.                   
                                                                        
           PERFORM 2100-TRANSACTION-HISTORY THRU 2100-EXIT.             
                                                                        
           IF NAME-CHANGED                                              
               IF SPOUSE-EXISTS                                         
                   MOVE LINK-SPOUSE-FIRST-NAME TO DQ-FIRST-NAME         
                   MOVE LINK-SPOUSE-LAST-NAME TO DQ-LAST-NAME           
                   PERFORM 8380-UPDATE-NAME THRU 8380-EXIT              
               ELSE                                                     
                   INITIALIZE DCLCSS-NAME                               
                              DCLCSS-CUST-STATS                         
                   PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT          
                   MOVE WS-91-NEW-NAME-ID TO DQ-NAME-ID                 
                                             CE-NAME-ID                 
                   MOVE WS-CUSTOMER-NO-NUM TO CE-CUSTOMER-NO            
                   MOVE 'S' TO CE-CUSTOMER-TYPE                         
                   MOVE LINK-SPOUSE-SSN TO CE-SSN                       
                   MOVE LINK-SPOUSE-DOB TO CE-DATE-OF-BIRTH             
                   MOVE LINK-SPOUSE-FIRST-NAME TO DQ-FIRST-NAME         
                   MOVE LINK-SPOUSE-LAST-NAME TO DQ-LAST-NAME           
                   MOVE 'SN' TO DQ-NAME-TYPE                            
                   MOVE 'I' TO DQ-NAME-FORMAT                           
                   MOVE WS-CURRENT-TIMESTAMP TO DQ-CREATED-DATE         
                   IF SEB-DATABASE                                      
                       MOVE '01' TO CE-ACCESS-LEVEL-CD                  
                   ELSE                                                 
                       MOVE '02' TO CE-ACCESS-LEVEL-CD                  
                   END-IF                                               
                   MOVE WS-CURRENT-TIMESTAMP TO CE-INFO-VERIFIED-TS     
                   PERFORM 8050-INSERT-NAME THRU 8050-EXIT              
                   PERFORM 8060-INSERT-STATS THRU 8060-EXIT             
                   MOVE 'NO ' TO WS-STATS-CHANGED-FLAG
               END-IF
           END-IF.                 
                                                                        
           IF STATS-CHANGED                                             
               MOVE LINK-SPOUSE-SSN TO CE-SSN                           
               MOVE LINK-SPOUSE-DOB TO CE-DATE-OF-BIRTH                 
               PERFORM 8390-UPDATE-STATS THRU 8390-EXIT
           END-IF.                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-TRANSACTION-HISTORY.                                        
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-SPOUSE-FIRST-NAME                
              MOVE 'YES'                  TO WS-NAME-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-SPOUSE-FIRST-NAME > SPACES                        
                 MOVE +15                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-SPOUSE-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DQ-FIRST-NAME       TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'SPOUSE FIRST NAME'    TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME NOT = LINK-SPOUSE-LAST-NAME                  
              MOVE 'YES'                  TO WS-NAME-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-SPOUSE-LAST-NAME > SPACES                         
                 MOVE +40                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-SPOUSE-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF DQ-LAST-NAME > SPACES                                  
                 MOVE +40                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DQ-LAST-NAME        TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'SPOUSE LAST NAME'     TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-SSN NOT = LINK-SPOUSE-SSN                              
              MOVE 'YES'                  TO WS-STATS-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-SPOUSE-SSN > SPACES                               
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-SPOUSE-SSN     TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF CE-SSN > SPACES                                        
                 MOVE +9                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE CE-SSN              TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'SSN'                  TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DATE-OF-BIRTH NOT = LINK-SPOUSE-DOB                    
              MOVE 'YES'                  TO WS-STATS-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-SPOUSE-DOB > SPACES                               
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-SPOUSE-DOB     TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF CE-DATE-OF-BIRTH > SPACES                              
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE CE-DATE-OF-BIRTH    TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'SPOUSE DOB'           TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DETERMINE-DATABASE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'DATABASE'                             
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                                     
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DATABASE                  
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO WS-DATABASE                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DATABASE'       TO TABLE-ELEMENT-1             
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-SPOUSE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FIRST_NAME,
              LAST_NAME,
              SSN,
              DATE_OF_BIRTH,
              DQ.NAME_ID,
              CE.NAME_ID                                         
                INTO :DQ-FIRST-NAME,                                    
                     :DQ-LAST-NAME,                                     
                     :CE-SSN,                                           
                     :CE-DATE-OF-BIRTH :WS-NULL-1,                       
                     :DQ-NAME-ID,                                       
                     :CE-NAME-ID                                        
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE = 'S'                                
                 AND CE.NAME_ID = DQ.NAME_ID                            
                                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              SSN,                                                       
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              DQ.NAME_ID,                                                
MFA-TR*              CE.NAME_ID                                                 
MFA-TR*         INTO :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :CE-SSN,                                                   
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-1,                               
MFA-TR*              :DQ-NAME-ID,                                               
MFA-TR*              :CE-NAME-ID                                                
MFA-TR*         FROM CSS_CUST_STATS CE,                                         
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*          AND CE.NAME_ID = DQ.NAME_ID                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'YES' TO WS-SPOUSE-EXISTS-FLAG                  
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-STATS                         
                              DCLCSS-NAME                               
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'S'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     LAST_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-LAST-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              LAST_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-LAST-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-2              
              MOVE 'LAST_NAME'          TO TABLE-ELEMENT-3              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-2            
              MOVE DQ-LAST-NAME         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-STATS.                                               
                                                                        
           IF CE-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-1
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     SSN,                                               
                     DATE_OF_BIRTH,                                     
                     NAME_ID,                                           
                     ACCESS_LEVEL_CD,                                   
                     INFO_VERIFIED_TS)                                  
              VALUES                                                    
                   (:CE-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-SSN,                                            
                    IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-1
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-1) ),                
                    :CE-NAME-ID,                                        
                    :CE-ACCESS-LEVEL-CD,                                
                    CIS.CHAR2TIMESTAMP(:CE-INFO-VERIFIED-TS))                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_STATS                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              NAME_ID,                                                   
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              INFO_VERIFIED_TS)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:CE-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-SSN,                                                    
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-1,                                
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-ACCESS-LEVEL-CD,                                        
MFA-TR*             :CE-INFO-VERIFIED-TS)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-2              
              MOVE 'SSN'                TO TABLE-ELEMENT-3              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-2            
              MOVE CE-SSN               TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET FIRST_NAME = :DQ-FIRST-NAME,                       
                     LAST_NAME = :DQ-LAST-NAME                          
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET FIRST_NAME = :DQ-FIRST-NAME,                               
MFA-TR*              LAST_NAME = :DQ-LAST-NAME                                  
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-2              
              MOVE 'LAST_NAME'          TO TABLE-ELEMENT-3              
              MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-2            
              MOVE DQ-LAST-NAME         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8390-UPDATE-STATS.                                               
                                                                        
           IF CE-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-1
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
                 SET SSN = :CE-SSN,                                     
                     DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :CE-DATE-OF-BIRTH 
                                                           :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-1
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-1) )        
               WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE = 'S'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*          SET SSN = :CE-SSN,                                             
MFA-TR*              DATE_OF_BIRTH = :CE-DATE-OF-BIRTH:WS-NULL-1                
MFA-TR*        WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*       QUERYNO 8390                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8390'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'DOB'                TO TABLE-ELEMENT-2              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8390-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     29920000
              INCLUDE CPD00071                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
