       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04811.                                         
COB303 DATE-WRITTEN.  AUG 11,2015.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *                                                                *00130000
      *  THIS PROGRAM RETURNS ATTRIBUTES FOR PROFILE SCREEN.           *00140000
      *  RESULT SET 1.                                                 *00150000
      *         1. AUTOMATIC PAYMENTS                                  *00160000
      *         2. BUDGET BILLLING(BBP)                                *00170000
      *         3. EMAIL ALERT                                         *00180000
      *         4. PAPERLESS BILLING                                   *00190000
      *         5. MAILING ADDRESS1                                    *00200000
      *         6. MAILING ADDRESS2                                    *00210000
      *         7. PROJECT SHARE                                       *00220000
      *                                                                *00260000
      *  NOTE : IF A CUSTOMER HAS MULTIPLE BANK DETAILS,SP WILL SEND   *00270000
      *         MULTIPLE ROWS FOR SAME BANK DETAILS.                   *00280000
      *                                                                *00281000
      *         CPD00377 used to get draft/autocard eligibility and    *00282000
      *         current status.                                        *00283000
      *---------------------------------------------------------------- 00290000
      *--                                                            -- 00300000
      *--  PARAMETERS:                                               -- 00310000
      *--                                                            -- 00320000
      *--  INPUT PARAMETERS.                                         -- 00330000
      *--                                                            -- 00340000
      *--           I_ACCOUNT_NO               CHAR(13)              -- 00350000
      *--                                                            -- 00360000
      *--  RESULT SET 1.                                             -- 00370000
      *--                                                            -- 00380000
      *--           RETURN_CODE                INTEGER               -- 00390000
      *--           ATTRIBUTE_NAME             CHAR(20)              -- 00400000
      *--           ATTRIBUTE_CURRENT_STATUS   CHAR(01)              -- 00410000
      *--           ATTRIBUTE_ELIGIBLE         CHAR(01)              -- 00420000
      *--           ATTRIBUTE_DETAILS          VARCHAR(500)          -- 00430000
      *--                                                            -- 00440000
      ******************************************************************00520000
      *                                                                *00530000
      *                     PROGRAM MODIFICATION LOG                   *00540000
      *                                                                *00550000
      *    DATE    INITIALS   COMMENTS                                 *00560000
      *  --------  --------   ---------------------------------------  *00570000
      *  08/11/15  SS7F226    PROCEDURE ORIGINALLY CODED.              *00580000
P00892*  04/15/16  SS45239    DO NOT SHOW AUTORENEW SECTION IN RATE    *00580100
P00892*                       PLAN PREFERENCES FOR SEASONAL ACCOUNTS   *00580200
P00892*                       UNLESS OPTED-IN.                         *00580300
PRDFIX*  06/17/16  LG41184    ADD BILL CYCLE VALIDITY CHECK FOR DRAFT  *00580300
PRDFIX*                       AND AUTOCARD PAYMENTS.                   *00580300
OTPOOL*  07/19/16  SS45239    OUTER POOL CHANGES                       *        
I02262*  08/23/16  SS45239    SMALL COMMERCIAL OUTER POOL CHANGES      *        
      ******************************************************************00590000
      ******************************************************************00600000
      *                                                                *00610000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00620000
      *                                                                *00630000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00640000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00650000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00660000
      *  3000 - 4999  NOT USED                                         *00670000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00680000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00690000
      *  7000 - 7999  INPUT MODULES                                    *00700000
      *  8000 - 8999  OUTPUT MODULES                                   *00710000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00720000
      *                                                                *00730000
      ******************************************************************00740000
      *                                                                 00750000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00770000
       DATA DIVISION.                                                   
      *                                                                 00790000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04811'.
MSQ017     COPY MFASQLM.
      *                                                                 00810000
      ******************************************************************00820000
      * WORKING STORAGE COPYBOOKS FOR CPD04353                         *00830000
      ******************************************************************00840000
      *                                                                 00850000
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04811 STARTS HERE'.                 
      *                                                                 00880000
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04811'.        
          05 WS-YES-NULL             PIC S9(4) VALUE -1.                
          05 WS-129                  PIC S9(4) USAGE COMP VALUE 129.    
          05 WS-500                  PIC X(03) VALUE '500'.             
          05 WS-ONE                  PIC S9(9) USAGE COMP VALUE 1.      
      *                                                                 00940000
       01 WS-MISC.                                                      
          05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-DATABASE             PIC 9(01) VALUE ZERO.              
              88  CSR-DATABASE                 VALUE 1.                 
              88  SEB-DATABASE                 VALUE 2.                 
          05  WS-REGULARED-CUST      PIC X(01) VALUE 'N'.               
              88  REGULATED-CUST               VALUE 'Y'.               
              88  DEREGULATED-CUST             VALUE 'N'.               
                                                                        
          05 WS-RETURN-CODE-1        PIC S9(4) COMP VALUE 0.            
          05 RS-RETURN-CODE          PIC S9(4) COMP VALUE 0.            
          05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                     PIC S9(13).                        
          05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.            
          05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.            
          05 WS-NICKNAME             PIC X(50) VALUE SPACES.            
          05 WS-BILL-NOTIFICATION    PIC X(01) VALUE SPACES.            
          05 WS-BANK-ACCT-NO         PIC X(19) VALUE SPACES.            
          05 WS-ADDR-LINE            PIC X(200) VALUE SPACES.           
          05 WS-MONTHLY-BILL-NUM     PIC 9(13) VALUE 0.                 
          05 WS-MONTHLY-BILL         REDEFINES                          
             WS-MONTHLY-BILL-NUM     PIC X(13).                         
          05 WS-NULL-IND1            PIC S9(4) COMP.                    
          05 WS-NULL-IND2            PIC S9(4) COMP.                    
          05 WS-COUNT                PIC S9(4) COMP.                    
          05 WS-NULL-ATTR-VALUE-DT   PIC S9(04) COMP.                   
          05 WS-DRAFT-DAY-4242       PIC X(02) VALUE SPACES.            
          05 WS-ACCT-NICK-NAME       PIC X(60) VALUE SPACES.            
          05 WS-701                  PIC S9(04) COMP VALUE +701.        
          05 WS-CPD377-DRAFT-STATUS       PIC X(01) VALUE SPACES.       
          05 WS-CPD377-AUTOCARD-STATUS    PIC X(01) VALUE SPACES.       
          05 WS-CPD377-EPAY-STATUS        PIC X(01) VALUE SPACES.       
          05 WS-CPD377-DRAFT-ELIGIBLE     PIC X(01) VALUE SPACES.       
          05 WS-CPD377-AUTOCARD-ELIGIBLE  PIC X(01) VALUE SPACES.       
          05 WS-CPD377-EPAY-ELIGIBLE      PIC X(01) VALUE SPACES.       
          05 WS-APPL-PROG-ID         PIC X(03) VALUE SPACES.            
          05 WS-ADDTNL-BILLS-EXIST   PIC X(01) VALUE SPACES.            
          05 WS-CUTOFF-CNT           PIC 9(03) VALUE 0.                 
          05 WS-CUTOF-REV-MNTH       PIC S9(6).                         
          05 WS-CUTOF-REV-MNTH-RED   REDEFINES WS-CUTOF-REV-MNTH.       
             10 WS-CUTOF-REV-MNTH-YY PIC 9(04).                         
             10 WS-CUTOF-REV-MNTH-MM PIC 9(02).                         
          05 WS-REVENUE-MONTH        PIC S9(6) VALUE 0.                 
          05 WS-ADDRESS-LINE-1       PIC X(80) VALUE SPACES.            
          05 WS-ADDRESS-LINE-2       PIC X(80) VALUE SPACES.            
          05  WS-SUB1                PIC S9(4) COMP VALUE 0.            
          05  WS-SUB2                PIC S9(4) COMP VALUE 0.            
      *                                                                 01180000
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-1              PIC S9(9) COMP VALUE 0.            
          05 WS-T1-ROWCOUNT          PIC S9(4) COMP VALUE 0.            
      *                                                                 01230000
       01 WS-ACCT-NO-FORMAT.                                            
          05 FILLER                  PIC X(01) VALUE SPACES.            
          05 FILLER                  PIC X(01) VALUE '('.               
          05 WS-BANK-ACCOUNT-NO      PIC X(04) VALUE SPACES.            
          05 FILLER                  PIC X(01) VALUE ')'.               
                                                                        
       01 WS-MAILING-ADDR-LINE1      PIC X(30) VALUE SPACES.            
       01 WS-MAILING-ADDR-CITY-STATE.                                   
          05  WS-MAILING-ADDR-CITY   PIC X(26).                         
          05  FILLER                 PIC X(01).                         
          05  WS-MAILING-ADDR-STATE  PIC X(02).                         
          05  WS-ZIP-FILER           PIC X(02) VALUE ' *'.              
          05  WS-MAILING-ADDR-ZIP.                                      
              10  WS-ZIP-CODE-MAIL   PIC X(05).                         
              10  WS-ZIP-DASH-MAIL   PIC X(01) VALUE '-'.               
              10  WS-ZIP-PLUS-4-MAIL PIC X(04).                         
                                                                        
       01 WS-FLAG.                                                      
          05 WS-ZERO                 PIC S9(4)  VALUE 0.                
          05 WS-YES                  PIC X(01)  VALUE 'Y'.              
          05 WS-NO                   PIC X(01)  VALUE 'N'.              
          05 WS-A                    PIC X(01)  VALUE 'A'.              
          05 WS-INDUSTRIAL           PIC X(01)  VALUE 'I'.              
          05 WS-ALERT-OUT            PIC X(01)  VALUE SPACES.           
          05 WS-PRESENT              PIC X(01)  VALUE SPACES.           
          05 WS-ACTIVE               PIC X(01)  VALUE 'A'.              
          05 WS-APPLIED              PIC X(01)  VALUE 'A'.              
          05 WS-PENDING              PIC X(01)  VALUE 'P'.              
          05 WS-CUSTOMER             PIC X(01)  VALUE 'C'.              
          05 WS-ENGLISH              PIC X(07)  VALUE 'ENGLISH'.        
          05 WS-SPANISH              PIC X(07)  VALUE 'SPANISH'.        
          05 WS-E                    PIC X(02)  VALUE 'EN'.             
          05 WS-S                    PIC X(02)  VALUE 'SP'.             
          05 WS-SUB-ACCT             PIC X(01)  VALUE 'S'.              
          05 WS-NOT-ELIGIBLE         PIC X(01)  VALUE 'N'.              
          05 WS-ELIGIBLE             PIC X(01)  VALUE 'E'.              
          05 WS-OPTED-IN             PIC X(01)  VALUE 'I'.              
          05 WS-OPTED-OUT            PIC X(01)  VALUE 'O'.              
          05 WS-AUTO-RENEWED         PIC X(01)  VALUE 'A'.              
          05 WS-OPEN-FOR-RENEWL      PIC X(01)  VALUE 'O'.              
          05 WS-RENEWED              PIC X(01)  VALUE 'R'.              
          05 WS-DFLT-NO-OF-BILLS     PIC 9(02)  VALUE 12.               
          05 WS-12                   PIC 9(02)  VALUE 12.               
      *                                                                 01380000
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
          05 SW-FETCH                PIC X(01) VALUE 'Y'.               
             88 NO-MORE-ROWS                   VALUE 'N'.               
             88 MORE-ROWS                      VALUE 'Y'.               
      *                                                                 01460000
      ******************************************************************01470000
      * CALLED MODULE RETURN VALUES                                    *01480000
      ******************************************************************01490000
       01 BBP-CALL-DATA.                                                
          05 IN-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 IN-ELIGIBLE             PIC X(01) VALUE SPACES.            
                                                                        
       01 BBP-RETURN-DATA.                                              
          05 BBP-RETURN-CODE         PIC S9(9) COMP VALUE 0.            
          05 BBP-ELIGIBLE            PIC X(01) VALUE SPACES.            
                                                                        
       01 RETURN-DATA-4242.                                             
          05 RETURN-CODE-4242        PIC S9(9) COMP VALUE 0.            
          05 DRAFT-CYCLE-4242        PIC X(02) VALUE SPACES.            
          05 DRAFT-DAY-4242          PIC X(02) VALUE SPACES.            
                                                                        
       01 BANK-CALL-DATA.                                               
          05 IN-ACCOUNT-NO-BK        PIC X(13) VALUE SPACES.            
          05 IN-CUSTOMER-NO-BK       PIC X(10) VALUE SPACES.            
                                                                        
       01 BANK-RETURN-DATA.                                             
          05 RETURN-CODE-3423        PIC S9(9) COMP VALUE 0.            
          05 BANK-ACCOUNT-NAME       PIC X(50) VALUE SPACES.            
          05 BANK-ACCT-NO            PIC X(19) VALUE SPACES.            
          05 BANK-ACCT-STAT-CD       PIC X(01) VALUE SPACES.            
          05 BANK-ACCT-TYPE-CD       PIC X(01) VALUE SPACES.            
          05 BANK-ID                 PIC X(06) VALUE SPACES.            
          05 CUST-BANK-SEQ-NO        PIC X(09) VALUE SPACES.            
          05 WS-BANK-ACCT-NICKNAME.                                     
             49 WS-BANK-ACCT-NICKNAME-LEN  PIC S9(4) USAGE COMP.        
             49 WS-BANK-ACCT-NICKNAME-TEXT PIC X(50).                   
          05 CUSTOMER-NO             PIC X(10) VALUE SPACES.            
          05 PRIMARY-IND             PIC X(01) VALUE SPACES.            
                                                                        
      *                                                                 01800000
       01 GTT-RETURN-FIELDS-1.                                          
             10 S-RETURN-CODE-1      PIC S9(4)    COMP VALUE 0.         
             10 S-ATTRIBUTE-1        PIC X(20)    VALUE SPACES.         
             10 S-CURR-STATUS        PIC X(01)    VALUE SPACES.         
             10 S-ELIGIBLE           PIC X(01)    VALUE SPACES.         
             10 S-ATTRIBUTE-DETAILS  PIC X(500)   VALUE SPACES.         
                                                                        
                                                                        
      *01 LOC4620 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4344 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC3423 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4242 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *                                                                 01980000
       01  WS-END                    PIC X(40)                          
           VALUE 'WORKING STORAGE FOR CSR04811 ENDS HERE  '.            
      *                                                                 02010000
      ******************************************************************02020000
      *               COBOL WORKING STORAGE COPY BOOKS                 *02030000
      ******************************************************************02040000
      *                                                                 02050000
          COPY CWS00056.                                                02060000
      *                                                                 02070000
      ******************************************************************02080000
      *               COPY BOOKS USED FOR CPD00074.                    *02090000
      ******************************************************************02100000
      *                                                                 02110000
          COPY CWS00074.                                                02120000
          COPY CWS00011.                                                02130000
      *                                                                 02140000
      ******************************************************************02150000
      *    ERROR HANDLING                                               02160000
      ******************************************************************02170000
      *                                                                 02180000
           EXEC SQL                                                     02190000
              INCLUDE CWSX0010                                          02200000
           END-EXEC.                                                    02210000
      *                                                                 02220000
      ******************************************************************02230000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *02240000
      ******************************************************************02250000
      *                                                                 02260000
           COPY CWS00303.                                               02270000
      *                                                                 02280000
      ******************************************************************02290000
      *    COPYBOOK FOR CWS00309                                       *02300000
      ******************************************************************02310000
      *                                                                 02320000
           EXEC SQL                                                     02330000
              INCLUDE CWS00309                                          02340000
           END-EXEC.                                                    02350000
      *                                                                 02360000
      *                                                                 02370000
      ******************************************************************02380000
      *    COPYBOOK FOR CPD04353                                       *02390000
      ******************************************************************02400000
      *                                                                 02410000
           EXEC SQL                                                     02420000
              INCLUDE CWS04353                                          02430000
           END-EXEC.                                                    02440000
      *                                                                 02450000
      ******************************************************************02460000
      *   SQL COMMUNICATION AREA                                       *02470000
      ******************************************************************02480000
      *                                                                 02490000
           EXEC SQL                                                     02500000
               INCLUDE SQLCA                                            02510000
           END-EXEC.                                                    02520000
      *                                                                 02530000
      ******************************************************************02540000
      *    CSS_AR_CNTL  - AC                                           *02550000
      ******************************************************************02560000
      *                                                                 02570000
           EXEC SQL                                                     02580000
               INCLUDE TBARCNTL                                         02590000
           END-EXEC.                                                    02600000
      *                                                                 02610000
      ******************************************************************02620000
      *    CSS_ACCOUNT  - AT                                           *02630000
      ******************************************************************02640000
      *                                                                 02650000
           EXEC SQL                                                     02660000
                INCLUDE TBACCT                                          02670000
           END-EXEC.                                                    02680000
      *                                                                 02690000
OTPOOL******************************************************************02620000
OTPOOL*    CSS_LOCAL_OFFICE - B1                                       *02630000
OTPOOL******************************************************************02640000
OTPOOL*                                                                 02650000
OTPOOL     EXEC SQL                                                     02660000
OTPOOL          INCLUDE TBLOCOFC                                        02670000
OTPOOL     END-EXEC.                                                    02680000
OTPOOL*                                                                 02690000
OTPOOL******************************************************************        
OTPOOL*    CSS_ACCT_MKT_TIER    DD                                     *        
OTPOOL******************************************************************        
OTPOOL*                                                                 02690000
OTPOOL     EXEC SQL                                                             
OTPOOL        INCLUDE TBMKTIER                                                  
OTPOOL     END-EXEC.                                                            
OTPOOL*                                                                         
      ******************************************************************02700000
      *    CSS_ZIP_CODE - A4                                           *02710000
      ******************************************************************02720000
      *                                                                 02730000
           EXEC SQL                                                     02740000
                INCLUDE TBZIPCD                                         02750000
           END-EXEC.                                                    02760000
      *                                                                 02770000
      ******************************************************************02780000
      *    CSS_BANK_EFT  - BE                                        *  02790000
      ******************************************************************02800000
      *                                                                 02810000
           EXEC SQL                                                     02820000
               INCLUDE TBBNKEFT                                         02830000
           END-EXEC.                                                    02840000
      *                                                                 02850000
      ******************************************************************02851000
      *    CSS_CUSTOMER_BANK JF                                      *  02852000
      ******************************************************************02853000
      *                                                                 02854000
           EXEC SQL                                                     02855000
               INCLUDE TBCSTBNK                                         02856000
           END-EXEC.                                                    02857000
      *                                                                 02858000
      ******************************************************************02860000
      *    CSS_CUST_STATS  - CE                                        *02870000
      ******************************************************************02880000
      *                                                                 02890000
           EXEC SQL                                                     02900000
               INCLUDE TBCSTSTS                                         02910000
           END-EXEC.                                                    02920000
      *                                                                 02930000
      ******************************************************************02940000
      *    CSS_CHRG_OFF - CO                                           *02950000
      ******************************************************************02960000
      *                                                                 02970000
           EXEC SQL                                                     02980000
                INCLUDE TBCHGOFF                                        02990000
           END-EXEC.                                                    03000000
      *                                                                 03010000
      ******************************************************************03020000
      *   CSS_CREDIT_PROFILE - CZ                                      *03030000
      ******************************************************************03040000
           EXEC SQL                                                     03050000
               INCLUDE TBCRPROF                                         03060000
           END-EXEC.                                                    03070000
      *                                                                 03080000
      ******************************************************************03090000
      *    CSS_DELINQUENCY - C8                                        *03100000
      ******************************************************************03110000
      *                                                                 03120000
           EXEC SQL                                                     03130000
               INCLUDE TBDELQ                                           03140000
           END-EXEC.                                                    03150000
      *                                                                 03160000
      ******************************************************************03170000
      *    CSS_ACCT_RTPK_AGR - DF                                      *03180000
      ******************************************************************03190000
      *                                                                 03200000
           EXEC SQL                                                     03210000
               INCLUDE TBACCTRG                                         03220000
           END-EXEC.                                                    03230000
      *                                                                 03240000
I02262******************************************************************00510000
I02262*    CRM_RT_PKG_OFFER - FG                                       *00520000
I02262******************************************************************00530000
I02262     EXEC SQL                                                     00540000
I02262        INCLUDE TBRTPOFF                                          00550000
I02262     END-EXEC.                                                    00560000
I02262*                                                                 00570000
      ******************************************************************03250000
      *    CSS_CUST_ADDR_XREF - DM                                     *03260000
      ******************************************************************03270000
      *                                                                 03280000
           EXEC SQL                                                     03290000
               INCLUDE TBCSADRX                                         03300000
           END-EXEC.                                                    03310000
      *                                                                 03320000
      ******************************************************************03330000
      *    CSS_NAME           - DQ                                     *03340000
      ******************************************************************03350000
      *                                                                 03360000
           EXEC SQL                                                     03370000
               INCLUDE TBNAME                                           03380000
           END-EXEC.                                                    03390000
      *                                                                 03400000
      ******************************************************************03410000
      *    CSS_ADDR_FORMATTED - DY                                     *03420000
      ******************************************************************03430000
      *                                                                 03440000
           EXEC SQL                                                     03450000
               INCLUDE TBADRFMT                                         03460000
           END-EXEC.                                                    03470000
      *                                                                 03480000
      ******************************************************************03490000
      *    CSS_ADDR_FREEFORM  - DZ                                     *03500000
      ******************************************************************03510000
      *                                                                 03520000
           EXEC SQL                                                     03530000
               INCLUDE TBADRFRE                                         03540000
           END-EXEC.                                                    03550000
      *                                                                 03560000
      ******************************************************************03570000
      *    CSS_FINAL_WO      - FW                                      *03580000
      ******************************************************************03590000
      *                                                                 03600000
           EXEC SQL                                                     03610000
               INCLUDE TBFINLWO                                         03620000
           END-EXEC.                                                    03630000
      *                                                                 03640000
      ******************************************************************03650000
      *    CSS_NAME_ACCT_XREF  - HT                                    *03660000
      ******************************************************************03670000
      *                                                                 03680000
           EXEC SQL                                                     03690000
               INCLUDE TBNMACTX                                         03700000
           END-EXEC.                                                    03710000
      *                                                                 03720000
      ******************************************************************03730000
      * CSS_REG_PFOFILE    - LR                                         03740000
      ******************************************************************03750000
      *                                                                 03760000
           EXEC SQL                                                     03770000
              INCLUDE TBREGPRF                                          03780000
           END-EXEC.                                                    03790000
      *                                                                 03800000
      ******************************************************************03810000
      *    CSS_AR_TYPE  - L5                                           *03820000
      ******************************************************************03830000
      *                                                                 03840000
           EXEC SQL                                                     03850000
               INCLUDE TBARTYPE                                         03860000
           END-EXEC.                                                    03870000
      *                                                                 03880000
      ******************************************************************03890000
      *    CSS_CUST_EMAIL    - NE                                      *03900000
      ******************************************************************03910000
      *                                                                 03920000
           EXEC SQL                                                     03930000
               INCLUDE TBCSTEML                                         03940000
           END-EXEC.                                                    03950000
      *                                                                 03960000
      ******************************************************************03970000
      *    CSS_EDI_ACCT_DEST - NF                                      *03980000
      ******************************************************************03990000
      *                                                                 04000000
           EXEC SQL                                                     04010000
               INCLUDE TBACDEST                                         04020000
           END-EXEC.                                                    04030000
      *                                                                 04040000
      ******************************************************************04050000
      *    CSS_PNDNG_BNK_DRFT - PB                                     *04060000
      ******************************************************************04070000
      *                                                                 04080000
           EXEC SQL                                                     04090000
               INCLUDE TBPDBKDF                                         04100000
           END-EXEC.                                                    04110000
      *                                                                 04120000
      ******************************************************************04130000
      *    CSS_PROJ_SHARE     - PJ                                     *04140000
      ******************************************************************04150000
      *                                                                 04160000
           EXEC SQL                                                     04170000
               INCLUDE TBPRJSHR                                         04180000
           END-EXEC.                                                    04190000
      *                                                                 04200000
      ******************************************************************04210000
      *    CSS_PREMISE        - PR                                     *04220000
      ******************************************************************04230000
      *                                                                 04240000
           EXEC SQL                                                     04250000
               INCLUDE TBPREM                                           04260000
           END-EXEC.                                                    04270000
      *                                                                 04280000
      ******************************************************************04290000
      *    CSS_ACCT_MISC_INFO - TA                                     *04300000
      ******************************************************************04310000
      *                                                                 04320000
           EXEC SQL                                                     04330000
               INCLUDE TBATMISC                                         04340000
           END-EXEC.                                                    04350000
      *                                                                 04360000
      ******************************************************************04370000
      *    CSS_UTL_ENVRMNT - UT                                        *04380000
      ******************************************************************04390000
      *                                                                 04400000
           EXEC SQL                                                     04410000
               INCLUDE TBUTLENV                                         04420000
           END-EXEC.                                                    04430000
      *                                                                 04440000
      ******************************************************************04450000
      * CSS_ACCT_ATTRIBUTE - YP                                         04460000
      ******************************************************************04470000
           EXEC SQL                                                     04490000
              INCLUDE TBACTATT                                          04500000
           END-EXEC.                                                    04510000
      *                                                                 04520000
      ******************************************************************04530000
      * CSS_ATTRIBUTE - WZ                                              04540000
      ******************************************************************04550000
      *                                                                 04560000
           EXEC SQL                                                     04570000
              INCLUDE TBATTRIB                                          04580000
           END-EXEC.                                                    04590000
      *                                                                 04600000
      ******************************************************************04610000
      * CSS_SERVICE_PROMO -  3A                                         04620000
      ******************************************************************04630000
           EXEC SQL                                                     04650000
              INCLUDE TBSERPRM                                          04660000
           END-EXEC.                                                    04670000
      *                                                                 04680000
      ******************************************************************04681000
      * CSS_CONTRACT  - CT                                              04682000
      ******************************************************************04683000
           EXEC SQL                                                     04685000
              INCLUDE TBCNTRCT                                          04686000
           END-EXEC.                                                    04687000
                                                                        
      ******************************************************************04688100
      * CSS_BILLING_DET,     BG                                         04688200
      ******************************************************************04688300
           EXEC SQL                                                     04688500
              INCLUDE TBBLLDET                                          04688600
           END-EXEC.                                                    04688700
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4620 CURSOR
MSQ001          FOR CALL CSR04620                                          
                  ( :IN-ACCOUNT-NO
                  , :IN-ELIGIBLE
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4344 CURSOR
MSQ001          FOR CALL CSR04344                                          
                  ( :IN-ACCOUNT-NO
                  , :IN-ELIGIBLE
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4242 CURSOR
MSQ001          FOR CALL CSR04242                                          
                   ( :IN-ACCOUNT-NO
                  )
MSQ001        END-EXEC.
                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO           PIC  X(13).                        
       01  PARM-CALL-TYPE            PIC  X(01).                        
      *                                                                 04710000
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-CALL-TYPE.                         
      *                                                                 04730000
      ******************************************************************04740000
      * 0000-MAINLINE                                                  *04750000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04760000
      ******************************************************************04770000
      *                                                                 04780000
       0000-MAINLINE.                                                   
      *                                                                 04800000
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
           
MSQ016        GOBACK.                                                    
      *                                                                 04860000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04890000
      ******************************************************************04900000
      * 0100-INITIALIZE                                                *04910000
      ******************************************************************04920000
      *                                                                 04930000
       0100-INITIALIZE.                                                 
      *                                                                 04950000
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
      *                                                                 04990000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05020000
      ******************************************************************05030000
      * 0100A-DECLARE-GTT                                              *05040000
      ******************************************************************05050000
      *                                                                 05060000
       0100A-DECLARE-GTT.                                               
      *                                                                 05080000
           MOVE 'SESSION.CSR04811_R1'        TO WS-GTT-NAME.            
      *                                                                 05100000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04811_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04811_R1
              (                                                       
                    RETURN_CODE                 INT                 
                   ,ATTRIBUTE_NAME CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,ATTRIBUTE_CURRENT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,ATTRIBUTE_ELIGIBLE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,ATTRIBUTE_DETAILS VARCHAR(500)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2            
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05220000
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 05260000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 05460000
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT DISTINCT RETURN_CODE                              
                     ,ATTRIBUTE_NAME     AS ATTRIBUTE_NAME              
                     ,ATTRIBUTE_CURRENT_STATUS                          
                                         AS ATTRIBUTE_CURRENT_STATUS    
                     ,ATTRIBUTE_ELIGIBLE AS ATTRIBUTE_ELIGIBLE          
                     ,ATTRIBUTE_DETAILS  AS ATTRIBUTE_DETAILS           
                FROM #CSR04811_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     05470000
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                             05480000
MFA-TR*                         WITH ROWSET POSITIONING FOR             05490000
MFA-TR*        SELECT DISTINCT RETURN_CODE                              05500000
MFA-TR*              ,ATTRIBUTE_NAME     AS ATTRIBUTE_NAME              05510000
MFA-TR*              ,ATTRIBUTE_CURRENT_STATUS                          05520000
MFA-TR*                                  AS ATTRIBUTE_CURRENT_STATUS    05530000
MFA-TR*              ,ATTRIBUTE_ELIGIBLE AS ATTRIBUTE_ELIGIBLE          05540000
MFA-TR*              ,ATTRIBUTE_DETAILS  AS ATTRIBUTE_DETAILS           05550000
MFA-TR*         FROM SESSION.CSR04811_R1                                05560000
MFA-TR*    END-EXEC.                                                    05570000
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 05610000
      ******************************************************************06180000
      * 1000-PROCESS-INPUT.                                            *06190000
      ******************************************************************06200000
      *                                                                 06210000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NUM               TO AT-ACCOUNT-NO           
                                                YP-ACCOUNT-NO           
                                                BE-ACCOUNT-NO           
                                                NF-ACCOUNT-NO           
                                                PB-ACCOUNT-NO           
                                                LR-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                DF-ACCOUNT-NO           
P00892                                          TA-ACCOUNT-NO           
OTPOOL                                          DD-ACCOUNT-NO.          
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     06320000
MFA-TR*       VALUES CURRENT DATE                                       06330000
MFA-TR*         INTO :WS-CURRENT-DATE                                   06340000
MFA-TR*    END-EXEC.                                                    06350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06360000
MFA-TR*       VALUES CURRENT TIMESTAMP                                  06370000
MFA-TR*         INTO :WS-CURRENT-TS                                     06380000
MFA-TR*    END-EXEC.                                                    06390000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 06400000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06430000
      ******************************************************************06440000
      * 2000-PROCESS-OUTPUT                                            *06450000
      ******************************************************************06460000
      *                                                                 06470000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT          THRU 7000-EXIT.         
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
                                                                        
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           PERFORM 7100-GET-DELINQUENCY         THRU 7100-EXIT.         
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
                                                                        
           IF SEB-DATABASE AND AT-LOCAL-OFFICE >= WS-500                
              MOVE WS-YES                    TO WS-REGULARED-CUST       
           END-IF.                                                      
                                                                        
           IF PARM-CALL-TYPE EQUAL SPACES                               
              PERFORM 2200-AUTOMATIC-CREDIT-CARD   THRU 2200-EXIT       
              PERFORM 2250-GET-DRAFT-DETAILS       THRU 2250-EXIT       
              PERFORM 2270-GET-EPAY-ATTRIB         THRU 2270-EXIT       
              PERFORM 2280-GET-AUTOPYMT-ATTRIB     THRU 2280-EXIT       
              PERFORM 2300-BBP-ATTRIB              THRU 2300-EXIT       
              PERFORM 2750-CUST-PREF-LANGUAGE      THRU 2750-EXIT       
              PERFORM 2400-MAIL-ALERTS             THRU 2400-EXIT       
              PERFORM 2500-PAPERLESS-ATTRIB        THRU 2500-EXIT       
              PERFORM 2700-PROJECT-SHARE           THRU 2700-EXIT       
              IF SEB-DATABASE                                           
                 PERFORM 2800-AUTO-RENEW-STATUS    THRU 2800-EXIT       
              END-IF                                                    
              PERFORM 2900-BBP-CALC-ATTRIB         THRU 2900-EXIT       
           END-IF.                                                      
                                                                        
           IF PARM-CALL-TYPE EQUAL SPACES OR 'A'                        
              PERFORM 2610-MAILINT-ADDR-FORMAT     THRU 2610-EXIT       
              PERFORM 2600-MAIL-ADDRESS1           THRU 2600-EXIT       
              PERFORM 2650-MAIL-ADDRESS2           THRU 2650-EXIT       
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06700000
      ******************************************************************06710000
      * 2200-AUTOMATIC-CREDIT-CARD.                                    *06720000
      ******************************************************************06730000
      *                                                                 06740000
       2200-AUTOMATIC-CREDIT-CARD.                                      
      *                                                                 06760000
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'AUTO CARD'                     TO S-ATTRIBUTE-1.       
           PERFORM 6200-GET-AUTOCARD-STAT-ELIG  THRU 6200-EXIT          
           MOVE WS-CPD377-AUTOCARD-STATUS       TO S-CURR-STATUS        
           MOVE WS-CPD377-AUTOCARD-ELIGIBLE     TO S-ELIGIBLE           
                                                                        
           MOVE SPACES                          TO S-ATTRIBUTE-DETAILS  
           MOVE WS-ZERO                         TO S-RETURN-CODE-1      
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
                                                                        
        2200-EXIT.                                                      
             EXIT.                                                      
      *                                                                 07000000
      ******************************************************************07001000
      * 2250-GET-DRAFT-DETAILS.                                        *07002000
      ******************************************************************07003000
      *                                                                 07004000
       2250-GET-DRAFT-DETAILS.                                          
      *                                                                 07006000
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'AUTO DRAFT'                 TO S-ATTRIBUTE-1.          
                                                                        
           PERFORM 7550-SELECT-BANK-EFT      THRU 7550-EXIT             
           PERFORM 7560-SELECT-CREDIT-PROF   THRU 7560-EXIT             
                                                                        
           PERFORM 6100-GET-DRAFT-STAT-ELIG  THRU 6100-EXIT             
           MOVE WS-CPD377-DRAFT-ELIGIBLE     TO S-ELIGIBLE              
           MOVE WS-CPD377-DRAFT-STATUS       TO S-CURR-STATUS           
                                                                        
           IF WS-CODE-BANK-EFT = 'A'                                    
              PERFORM 7570-GET-BANK-NICKNAME    THRU 7570-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                                                                        
                 MOVE JF-BANK-ACCT-NICKNAME-TEXT                        
                   (1:JF-BANK-ACCT-NICKNAME-LEN) TO WS-ACCT-NICK-NAME   
                                                                        
                 INSPECT JF-BANK-ACCT-NO  TALLYING WS-COUNT             
                                     FOR CHARACTERS BEFORE INITIAL ' '  
                                                                        
                 MOVE JF-BANK-ACCT-NO(WS-COUNT - 3:4)                   
                                    TO WS-BANK-ACCOUNT-NO               
                                                                        
                 STRING WS-ACCT-NICK-NAME    DELIMITED BY '  '          
                        WS-ACCT-NO-FORMAT    DELIMITED BY SIZE          
                                             INTO WS-ACCT-NICK-NAME     
              END-IF                                                    
                                                                        
              IF BE-REQSTED-DRAFT-DAY > SPACES                          
                 STRING BE-REQSTED-DRAFT-DAY DELIMITED BY '  '          
                        ' | '                DELIMITED BY SIZE          
                        WS-ACCT-NICK-NAME    DELIMITED BY SIZE          
                                           INTO S-ATTRIBUTE-DETAILS     
              ELSE                                                      
                 IF BE-DRAFT-CYCLE > SPACES                             
                    MOVE WS-ACCOUNT-NUM      TO IN-ACCOUNT-NO           
                    PERFORM 2360-CALL-CSR04242     THRU 2360-EXIT       
                    STRING WS-DRAFT-DAY-4242 DELIMITED BY '  '          
                           ' | '             DELIMITED BY SIZE          
                           WS-ACCT-NICK-NAME DELIMITED BY SIZE          
                                           INTO S-ATTRIBUTE-DETAILS     
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                    TO S-ATTRIBUTE-DETAILS     
           END-IF.                                                      
                                                                        
           MOVE WS-ZERO                      TO S-RETURN-CODE-1         
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
        2250-EXIT.                                                      
             EXIT.                                                      
      *                                                                 07016500
      ******************************************************************07016600
      * 2270-GET-EPAY-ATTRIB.                                           07016700
      ******************************************************************07016800
        2270-GET-EPAY-ATTRIB.                                           
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'EPAY'                       TO S-ATTRIBUTE-1.          
           MOVE SPACES                       TO S-ATTRIBUTE-DETAILS.    
           PERFORM 6150-GET-EPAY-STAT-ELIG   THRU 6150-EXIT.            
                                                                        
           MOVE WS-CPD377-EPAY-STATUS        TO S-CURR-STATUS.          
           MOVE WS-CPD377-EPAY-ELIGIBLE      TO S-ELIGIBLE.             
           MOVE WS-ZERO                      TO S-RETURN-CODE-1         
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
        2270-EXIT.                                                      
                                                                        
      ******************************************************************07018100
      * 2280-GET-AUTOPYMT-ATTRIB.                                       07018200
      * GET AUTOMATIC PAYMENT ATTRIBUTE                                *07018300
      ******************************************************************07018400
        2280-GET-AUTOPYMT-ATTRIB.                                       
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'AUTOMATICPAYMENT'           TO S-ATTRIBUTE-1.          
           MOVE SPACES                       TO S-ATTRIBUTE-DETAILS.    
           IF WS-CPD377-DRAFT-STATUS = WS-YES OR                        
                      WS-CPD377-AUTOCARD-STATUS = WS-YES                
              MOVE WS-YES                    TO S-CURR-STATUS           
           ELSE                                                         
              MOVE WS-NO                     TO S-CURR-STATUS           
           END-IF.                                                      
           IF WS-CPD377-DRAFT-ELIGIBLE = WS-YES OR                      
                      WS-CPD377-AUTOCARD-ELIGIBLE = WS-YES              
              MOVE WS-YES                    TO S-ELIGIBLE              
           ELSE                                                         
              MOVE WS-NO                     TO S-ELIGIBLE              
           END-IF.                                                      
           MOVE WS-ZERO                      TO S-RETURN-CODE-1         
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
        2280-EXIT.                                                      
            EXIT.                                                       
      *                                                                 07020800
      ******************************************************************07020900
      * 2300-BBP-ATTRIB.                                               *07021000
      ******************************************************************07030000
                                                                        
       2300-BBP-ATTRIB.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'BUDGENTBILLING'             TO S-ATTRIBUTE-1.          
           IF   WS-CODE-BUDGET = 'A'                                    
                MOVE WS-ZERO                 TO S-RETURN-CODE-1         
                MOVE WS-YES                  TO S-CURR-STATUS           
                MOVE WS-YES                  TO S-ELIGIBLE              
           ELSE                                                         
              IF AT-CODE-ACCT-STAT EQUAL WS-ACTIVE                      
                 MOVE WS-NO                  TO S-CURR-STATUS           
                 MOVE WS-ACCOUNT-NUM         TO IN-ACCOUNT-NO           
                 MOVE 'W'                    TO IN-ELIGIBLE             
                 IF CSR-DATABASE                                        
                    PERFORM 2350-CALL-CSR04620  THRU 2350-EXIT          
                 ELSE                                                   
                    PERFORM 2355-CALL-CSR04344  THRU 2355-EXIT          
                 END-IF                                                 
                 MOVE BBP-ELIGIBLE           TO S-ELIGIBLE              
              ELSE                                                      
                 MOVE WS-ZERO                TO S-RETURN-CODE-1         
                 MOVE WS-NO                  TO S-CURR-STATUS           
                 MOVE WS-NO                  TO S-ELIGIBLE              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO S-ATTRIBUTE-DETAILS.    
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07310000
      ******************************************************************07320000
      * 2350-CALL-CSR04620                                             *07330000
      ******************************************************************07340000
      *                                                                 07350000
       2350-CALL-CSR04620.                                              
      *                                                                 07370000
      *     EXEC SQL                                                    
      *          CALL CSR04620                                          
      *           (:IN-ACCOUNT-NO,                                      
      *            :IN-ELIGIBLE)                                        
      *     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4620
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4620
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4620 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2350'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CALL'                    TO ABEND-FUNCTION          
              MOVE 'CSR04620'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE IN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4620)                                                
      *       WITH PROCEDURE CSR04620                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4620 CURSOR FOR RESULT SET        
      *       :LOC4620                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4620 INTO                            
                 :BBP-RETURN-CODE,                                      
                 :BBP-ELIGIBLE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '2350'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSR04620'           TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE IN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                 07880000
       2350-EXIT.                                                       
            EXIT.                                                       
      *                                                                 07910000
      ******************************************************************07920000
      * 2355-CALL-CSR04344                                             *07930000
      ******************************************************************07940000
      *                                                                 07950000
       2355-CALL-CSR04344.                                              
      *                                                                 07970000
      *       EXEC SQL                                                  
      *          CALL CSR04344                                          
      *           (:IN-ACCOUNT-NO,                                      
      *            :IN-ELIGIBLE)                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4344
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4344
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4344 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2355'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CALL'                    TO ABEND-FUNCTION          
              MOVE 'CSR04344'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE IN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4344)                                                
      *       WITH PROCEDURE CSR04344                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4344 CURSOR FOR RESULT SET        
      *       :LOC4344                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4344 INTO                            
                 :BBP-RETURN-CODE,                                      
                 :BBP-ELIGIBLE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '2355'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSR04344'           TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE IN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
           END-EVALUATE.                                                
      *                                                                 08470000
       2355-EXIT.                                                       
            EXIT.                                                       
      *                                                                 08500000
      ******************************************************************08501000
      * 2360-CALL-CSR04242                                             *08502000
      ******************************************************************08503000
       2360-CALL-CSR04242.                                              
                                                                        
      *    EXEC SQL                                                     
      *          CALL CSR04242                                          
      *            (:IN-ACCOUNT-NO                                      
      *            )                                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4242
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4242
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4242 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2360'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CALL'                    TO ABEND-FUNCTION          
              MOVE 'CSR04242'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE IN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4242)                                                
      *       WITH PROCEDURE CSR04242                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4242 CURSOR FOR RESULT SET        
      *       :LOC4242                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
              EXEC SQL                                                  
                 FETCH RESULT_SET_CSR_4242 INTO                         
                    :RETURN-CODE-4242                                   
                   ,:DRAFT-CYCLE-4242                                   
                   ,:DRAFT-DAY-4242                                     
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE-1      
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                WHEN SUCCESSFUL-CALL                                    
                     IF RETURN-CODE-4242 EQUAL WS-ZERO                  
                        IF BE-DRAFT-CYCLE EQUAL DRAFT-CYCLE-4242        
                           MOVE DRAFT-DAY-4242 TO WS-DRAFT-DAY-4242     
                           SET NO-MORE-ROWS    TO TRUE                  
                        END-IF                                          
                     ELSE                                               
                        MOVE RETURN-CODE-4242  TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1       
                        MOVE PROGRAM-NAME      TO ABEND-PROGRAM         
                        MOVE '2360'            TO ACTIVE-PARAGRAPH      
                        MOVE 'FETCH'           TO ABEND-FUNCTION        
                        MOVE 'CSR04242'        TO TABLE-1               
                        MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1       
                        MOVE IN-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1     
                        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT       
                     END-IF                                             
                WHEN NOT-FOUND                                          
                     SET NO-MORE-ROWS          TO TRUE                  
                     MOVE SPACES               TO WS-DRAFT-DAY-4242     
                WHEN OTHER                                              
                     MOVE RETURN-CODE-4242     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1       
                     MOVE PROGRAM-NAME         TO ABEND-PROGRAM         
                     MOVE '2360'               TO ACTIVE-PARAGRAPH      
                     MOVE 'FETCH'              TO ABEND-FUNCTION        
                     MOVE 'CSR04242'           TO TABLE-1               
                     MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1       
                     MOVE IN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1     
                     PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT        
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           MOVE 'Y'                          TO SW-FETCH.               
      *                                                                 08516700
       2360-EXIT.                                                       
            EXIT.                                                       
      *                                                                 08517000
      ******************************************************************08518000
      * 2400-MAIL-ALERTS.                                              *08520000
      ******************************************************************08530000
      *                                                                 08540000
       2400-MAIL-ALERTS.                                                
      *                                                                 08560000
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'EMAILALERTS'                TO S-ATTRIBUTE-1.          
                                                                        
           MOVE 'EMAIL_BILLNOTIFY'           TO YP-ATTRIBUTE-DESC.      
           MOVE 'EMAIL'                      TO WZ-ATTRIBUTE-TYPE-TX.   
           MOVE SPACES                       TO YP-ATTRIBUTE-VALUE-CD.  
           PERFORM 7200-GET-EMAIL-ADDRESS     THRU 7200-EXIT            
           IF YP-ATTRIBUTE-VALUE-CD NOT = 'NO'                          
              IF AT-NO-BILL-COPIES = 0                                  
                 MOVE '1'                    TO WS-BILL-NOTIFICATION    
              ELSE                                                      
                 IF AT-NO-BILL-COPIES > 0                               
                    MOVE 'EMAIL_PAPERONLY'   TO YP-ATTRIBUTE-DESC       
                    MOVE 'EMAIL'             TO WZ-ATTRIBUTE-TYPE-TX    
                    MOVE SPACES              TO YP-ATTRIBUTE-VALUE-CD   
                    PERFORM 7200-GET-EMAIL-ADDRESS                      
                                              THRU 7200-EXIT            
                    IF YP-ATTRIBUTE-VALUE-CD = 'YES'                    
                        MOVE '3'             TO WS-BILL-NOTIFICATION    
                    ELSE                                                
                        MOVE '5'             TO WS-BILL-NOTIFICATION    
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF (AT-NO-BILL-COPIES = 0 OR                                 
               CE-EBILL-REGISTER-IND = 'Y') AND                         
               WS-BILL-NOTIFICATION = '5'                               
               MOVE '2'                      TO WS-BILL-NOTIFICATION    
           END-IF.                                                      
                                                                        
           IF (WS-BILL-NOTIFICATION = '1' OR '2')                       
               MOVE 'NEW BILL READY'         TO S-ATTRIBUTE-DETAILS     
               MOVE WS-YES                   TO S-CURR-STATUS           
               MOVE WS-NO                    TO S-ELIGIBLE              
               MOVE 0                        TO S-RETURN-CODE-1         
               PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT            
               MOVE WS-YES                   TO WS-ALERT-OUT            
           END-IF.                                                      
      *                                                                 08574100
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'EMAILALERTS'                TO S-ATTRIBUTE-1.          
                                                                        
           MOVE 'EMAIL PMT REMINDER'         TO YP-ATTRIBUTE-DESC.      
           MOVE 'EMAIL'                      TO WZ-ATTRIBUTE-TYPE-TX.   
           MOVE SPACES                       TO YP-ATTRIBUTE-VALUE-CD.  
           PERFORM 7200-GET-EMAIL-ADDRESS     THRU 7200-EXIT            
           IF YP-ATTRIBUTE-VALUE-CD = 'YES'                             
              MOVE 'PAYMENT REMINDER'        TO S-ATTRIBUTE-DETAILS     
              MOVE WS-YES                    TO S-CURR-STATUS           
              MOVE WS-NO                     TO S-ELIGIBLE              
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
           ELSE                                                         
              IF WS-ALERT-OUT NOT = WS-YES                              
                 MOVE WS-NO                  TO S-CURR-STATUS           
                                                S-ELIGIBLE              
                 MOVE SPACES                 TO S-ATTRIBUTE-DETAILS     
                 PERFORM 8010-INSERT-GTT-R1   THRU 8010-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08750000
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                 08950000
      ******************************************************************08960000
      * 2500-PAPERLESS-ATTRIB.                                         *08970000
      ******************************************************************08980000
      *                                                                 08990000
       2500-PAPERLESS-ATTRIB.                                           
      *                                                                 09010000
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'PAPERLESS BILLING'          TO S-ATTRIBUTE-1.          
           IF AT-NO-BILL-COPIES EQUAL 0                                 
              MOVE WS-YES                    TO  S-CURR-STATUS          
              MOVE WS-NO                     TO  S-ELIGIBLE             
           ELSE                                                         
              MOVE WS-NO                     TO  S-CURR-STATUS          
              IF AT-NO-BILL-COPIES NOT EQUAL WS-ZERO AND                
                 (AT-CODE-ACCT-STAT EQUAL  WS-ACTIVE  OR                
                  AT-CODE-ACCT-STAT EQUAL  WS-PENDING )                 
                 MOVE WS-YES                 TO  S-ELIGIBLE             
                 MOVE WS-NO                  TO  S-CURR-STATUS          
              ELSE                                                      
                 MOVE WS-NO                  TO  S-ELIGIBLE             
                 MOVE WS-NO                  TO  S-CURR-STATUS          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO S-ATTRIBUTE-DETAILS.    
           MOVE 0                            TO S-RETURN-CODE-1.        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************09270000
      * 2600-MAIL-ADDRESS1.                                            *09280000
      ******************************************************************09290000
       2600-MAIL-ADDRESS1.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
           MOVE 'MAILING ADDRESS1'              TO S-ATTRIBUTE-1        
                                                                        
           PERFORM 7250-GET-ACCT-XREF-ID           THRU 7250-EXIT       
           PERFORM 4025-DETERMINE-ADDRESS          THRU 4025-EXIT       
                                                                        
           IF AT-ADDRESS-ID > 0                                         
              IF WS-FMT-ADDR-STREET    >  SPACES                        
                 INSPECT WS-FMT-ADDR-STREET REPLACING ALL ',' BY SPACES 
                                                                        
                 MOVE WS-FMT-ADDR-STREET        TO S-ATTRIBUTE-DETAILS  
                 MOVE WS-YES                    TO S-CURR-STATUS        
                 MOVE WS-NO                     TO S-ELIGIBLE           
              ELSE                                                      
                 IF WS-FRE-ADDR-STREET  > SPACES                        
                    INSPECT WS-FRE-ADDR-STREET                          
                                     REPLACING ALL ',' BY SPACES        
                                                                        
                    MOVE WS-FRE-ADDR-STREET     TO S-ATTRIBUTE-DETAILS  
                    MOVE WS-YES                 TO S-CURR-STATUS        
                    MOVE WS-NO                  TO S-ELIGIBLE           
                 ELSE                                                   
                    MOVE WS-NO                  TO S-CURR-STATUS        
                                                   S-ELIGIBLE           
                    MOVE SPACES                 TO S-ATTRIBUTE-DETAILS  
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT        
           END-IF.                                                      
                                                                        
      *    GETTING THE FORMTED SERVICE ADDRESS BASED ON HT-ADDRESS-ID   09591905
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'SERVICE ADDRESS1'           TO S-ATTRIBUTE-1.          
                                                                        
           IF WS-PR-STREET GREATER THAN SPACES                          
              INSPECT WS-PR-STREET REPLACING ALL ',' BY SPACES          
                                                                        
              MOVE WS-PR-STREET              TO S-ATTRIBUTE-DETAILS     
              MOVE WS-YES                    TO S-CURR-STATUS           
              MOVE WS-NO                     TO S-ELIGIBLE              
           ELSE                                                         
              MOVE WS-NO                     TO S-CURR-STATUS           
                                                S-ELIGIBLE              
              MOVE SPACES                    TO S-ATTRIBUTE-DETAILS     
           END-IF                                                       
                                                                        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************09630119
      * 2610-MAILINT-ADDR-FORMAT.                                      *09630219
      ******************************************************************09630319
       2610-MAILINT-ADDR-FORMAT.                                        
                                                                        
           IF AT-ADDRESS-ID > 0                                         
              EVALUATE AT-ADDRESS-FORMAT                                
                   WHEN 'A'                                             
                       MOVE AT-ADDRESS-ID         TO DY-ADDRESS-ID      
                       PERFORM 7300-SELECT-FMT-ADDR THRU 7300-EXIT      
                   WHEN 'B'                                             
                       MOVE AT-ADDRESS-ID         TO DZ-ADDRESS-ID      
                       PERFORM 7310-SELECT-FF-ADDR   THRU 7310-EXIT     
                       MOVE DZ-ADDR-ZIP-CODE(1:5) TO DY-ZIP-CODE        
                                                                        
                       IF DZ-ADDR-CITY-STATE > ' ' AND                  
                          (DZ-ADDR-COUNTRY = ' ' OR 'UNITED STATES'     
                                                 OR 'USA')              
                          PERFORM 2620-EXTRACT-CITY-STATE THRU 2620-EXIT
                       END-IF                                           
              END-EVALUATE                                              
                                                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE WS-YES                    TO S-CURR-STATUS           
              MOVE WS-NO                     TO S-ELIGIBLE              
                                                                        
              MOVE 'MAILING ADDR LINE1'      TO S-ATTRIBUTE-1           
              MOVE WS-ADDRESS-LINE-1         TO S-ATTRIBUTE-DETAILS     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
                                                                        
              MOVE 'MAILING ADDR LINE2'      TO S-ATTRIBUTE-1           
              MOVE WS-ADDRESS-LINE-2         TO S-ATTRIBUTE-DETAILS     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
                                                                        
              MOVE 'MAILING ADDR CITY'       TO S-ATTRIBUTE-1           
              MOVE A4-TOWN                   TO S-ATTRIBUTE-DETAILS     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
                                                                        
              MOVE 'MAILING ADDR STATE'      TO S-ATTRIBUTE-1           
              MOVE A4-STATE                  TO S-ATTRIBUTE-DETAILS     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
                                                                        
              MOVE 'MAILING ADDR ZIP'        TO S-ATTRIBUTE-1           
              MOVE DY-ZIP-CODE               TO S-ATTRIBUTE-DETAILS     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
           END-IF.                                                      
                                                                        
       2610-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************09640119
      * 2620-EXTRACT-CITY-STATE..                                      *09640219
      ******************************************************************09640319
       2620-EXTRACT-CITY-STATE.                                         
                                                                        
           INSPECT DZ-ADDR-CITY-STATE REPLACING ALL ',' BY ' '.         
           MOVE +30 TO WS-SUB1.                                         
           MOVE 0 TO WS-SUB2.                                           
           PERFORM UNTIL DZ-ADDR-CITY-STATE(WS-SUB1:1) > ' '            
               SUBTRACT +1 FROM WS-SUB1                                 
           END-PERFORM.                                                 
                                                                        
           IF DZ-ADDR-CITY-STATE(WS-SUB1 - 2:1) = ' '                   
               MOVE DZ-ADDR-CITY-STATE(WS-SUB1 - 1:2) TO A4-STATE       
               MOVE DZ-ADDR-CITY-STATE(1:WS-SUB1 - 3) TO A4-TOWN        
           END-IF.                                                      
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09650000
      * 2650-MAIL-ADDRESS2.                                            *09660000
      ******************************************************************09670000
       2650-MAIL-ADDRESS2.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'MAILING ADDRESS2'           TO S-ATTRIBUTE-1.          
                                                                        
           IF AT-ADDRESS-ID > 0                                         
              IF WS-FMT-CITY-STATE-ZIP >  SPACES                        
                 INSPECT WS-FMT-CITY-STATE-ZIP REPLACING ALL ','        
                                                     BY SPACES          
                 MOVE WS-FMT-CITY-STATE-ZIP     TO S-ATTRIBUTE-DETAILS  
                 MOVE WS-YES                    TO S-CURR-STATUS        
                 MOVE WS-NO                     TO S-ELIGIBLE           
              ELSE                                                      
                 IF WS-FRE-ADDR-CITY-STATE > SPACES                     
                    INSPECT WS-FRE-ADDR-CITY-STATE                      
                                     REPLACING ALL ',' BY SPACES        
                                                                        
                    MOVE WS-FRE-ADDR-CITY-STATE TO S-ATTRIBUTE-DETAILS  
                    MOVE WS-YES                 TO S-CURR-STATUS        
                    MOVE WS-NO                  TO S-ELIGIBLE           
                 ELSE                                                   
                    MOVE WS-NO                  TO S-CURR-STATUS        
                                                   S-ELIGIBLE           
                   MOVE SPACES                  TO S-ATTRIBUTE-DETAILS  
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT       
           END-IF.                                                      
                                                                        
      *    GETTING THE FORMTED SERVICE ADDRESS BASED ON HT-ADDRESS-ID   09942205
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'SERVICE ADDRESS2'              TO S-ATTRIBUTE-1.       
                                                                        
           IF WS-PR-ADDR-CITY-STATE-ZIP GREATER THAN SPACES             
              INSPECT WS-PR-ADDR-CITY-STATE-ZIP                         
                                            REPLACING ALL ',' BY SPACES 
                                                                        
              MOVE WS-PR-ADDR-CITY-STATE-ZIP TO S-ATTRIBUTE-DETAILS     
              MOVE WS-YES                    TO S-CURR-STATUS           
              MOVE WS-NO                     TO S-ELIGIBLE              
           ELSE                                                         
              MOVE WS-NO                     TO S-CURR-STATUS           
                                                S-ELIGIBLE              
              MOVE SPACES                    TO S-ATTRIBUTE-DETAILS     
           END-IF                                                       
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
                                                                        
      *    Address Id (Billing Address) - identifies the Account        09944105
      *    Billing Address of a Premise; the Address is stored as either09944205
      *    Formatted (Address Format is "A") or Freeform (Address Forma 09944305
      *    mat is "B") if there is no billing address,address id will   09944405
      *    passed as zeroes.                                            09944505
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'MAILING ADDRESS ID'         TO S-ATTRIBUTE-1.          
           MOVE SPACES                       TO S-CURR-STATUS           
                                                S-ELIGIBLE.             
           MOVE AT-ADDRESS-ID                TO S-ATTRIBUTE-DETAILS.    
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
      *    Address Id (SERVICE Address) - identifies the Account        09950102
      *    SERVICE Address of a Premise; the Address is stored as       09950202
      *    Formatted.No free form for service address.                  09950302
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'SERVICE ADDRESS ID'         TO S-ATTRIBUTE-1.          
           MOVE SPACES                       TO S-CURR-STATUS           
                                                S-ELIGIBLE.             
           MOVE HT-ADDRESS-ID                TO S-ATTRIBUTE-DETAILS.    
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'MAILING ADDR FORMAT'        TO S-ATTRIBUTE-1.          
           MOVE SPACES                       TO S-CURR-STATUS           
                                                S-ELIGIBLE.             
           MOVE AT-ADDRESS-FORMAT            TO S-ATTRIBUTE-DETAILS.    
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
                                                                        
       2650-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************09990000
      * 2700-PROJECT-SHARE.                                            *10000000
      ******************************************************************10010000
       2700-PROJECT-SHARE.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'PROJECT SHARE'               TO S-ATTRIBUTE-1.         
                                                                        
           IF AT-CODE-ACCT-STAT EQUAL WS-ACTIVE                         
              PERFORM 7350-GET-SHARE-AMT      THRU 7350-EXIT            
              IF PJ-SHARE-STATUS-CD EQUAL WS-ACTIVE                     
                 MOVE WS-ZERO                 TO S-RETURN-CODE-1        
                 MOVE WS-YES                  TO S-CURR-STATUS          
                 MOVE WS-YES                  TO S-ELIGIBLE             
              ELSE                                                      
                IF REGULATED-CUST                                       
                   MOVE WS-ZERO               TO S-RETURN-CODE-1        
                   MOVE WS-NO                 TO S-CURR-STATUS          
                   MOVE WS-NO                 TO S-ELIGIBLE             
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF AT-CODE-ACCT-STAT NOT EQUAL WS-ACTIVE    OR               
              (PJ-SHARE-STATUS-CD NOT EQUAL WS-ACTIVE AND               
                                         DEREGULATED-CUST)              
              MOVE WS-ZERO                    TO S-RETURN-CODE-1        
              MOVE WS-NO                      TO S-CURR-STATUS          
              MOVE WS-YES                     TO S-ELIGIBLE             
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10250000
      ******************************************************************10250100
      * 2750-CUST-PREF-LANGUAGE.                                       *10250200
      ******************************************************************10250300
      *                                                                 10250400
       2750-CUST-PREF-LANGUAGE.                                         
      *                                                                 10250600
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'CUST LANGUAGE PREFRN'                                  
                                             TO S-ATTRIBUTE-1.          
                                                                        
           PERFORM 7400-GET-CUST-LANG           THRU 7400-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CE-LANGUAGE-PREF-CD       TO S-ATTRIBUTE-DETAILS     
           ELSE                                                         
              MOVE SPACES                    TO S-ATTRIBUTE-DETAILS     
           END-IF.                                                      
      *                                                                 10251700
           MOVE WS-NO                        TO S-CURR-STATUS           
                                                S-ELIGIBLE.             
      *                                                                 10252000
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
      *                                                                 10252200
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10252500
      ******************************************************************10252600
      * 2800-AUTO-RENEW-STATUS.                                        *10252700
      ******************************************************************10253000
       2800-AUTO-RENEW-STATUS.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'AUTO RENEW'                  TO S-ATTRIBUTE-1.         
           MOVE SPACES                        TO S-ATTRIBUTE-DETAILS.   
                                                                        
           PERFORM 7600-GET-AUTORENEW-IND        THRU 7600-EXIT.        
P00892     PERFORM 7650-GET-SEASONAL-FLAG        THRU 7650-EXIT.        
OTPOOL     PERFORM 7675-GET-ACCT-MKT-TIER        THRU 7675-EXIT.        
                                                                        
P00892     IF TA-SEASONAL-FL > SPACES OR                                
P00892**** SEASONAL ACCOUNT                                             10258310
OTPOOL      ( B1-DIVISION-NO = 'OUT'  AND                               
OTPOOL         ( DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B' ) )           
OTPOOL**** OUTER POOL ACCOUNT                                                   
P00892        IF DF-AUTO-REN-OPT-IN-FL EQUAL WS-OPTED-IN                
P00892           MOVE WS-YES                  TO S-CURR-STATUS          
P00892           MOVE WS-YES                  TO S-ELIGIBLE             
P00892        ELSE                                                      
P00892           MOVE WS-NO                   TO S-CURR-STATUS          
P00892           MOVE WS-NO                   TO S-ELIGIBLE             
P00892        END-IF                                                    
P00892     ELSE                                                         
I02262        IF B1-DIVISION-NO       = 'OUT' AND                       
I02262           DD-TIER-ACCT-TYPE-CD = 'S'                             
I02262           PERFORM 7625-GET-OFFER-TYPE     THRU 7625-EXIT         
I02262           IF FG-SPCL-OFFER-TYPE-CD = 'OP'                        
I02262              EVALUATE DF-AUTO-REN-OPT-IN-FL                      
I02262                  WHEN WS-NOT-ELIGIBLE                            
I02262                       MOVE WS-NO       TO S-CURR-STATUS          
I02262                       MOVE WS-NO       TO S-ELIGIBLE             
I02262                  WHEN WS-ELIGIBLE                                
I02262                       MOVE WS-NO       TO S-CURR-STATUS          
I02262                       MOVE WS-YES      TO S-ELIGIBLE             
I02262                  WHEN WS-OPTED-IN                                
I02262                       MOVE WS-YES      TO S-CURR-STATUS          
I02262                       MOVE WS-YES      TO S-ELIGIBLE             
I02262                  WHEN WS-OPTED-OUT                               
I02262                       MOVE WS-NO       TO S-CURR-STATUS          
I02262                       MOVE WS-YES      TO S-ELIGIBLE             
I02262                  WHEN OTHER                                      
I02262                       MOVE WS-NO       TO S-CURR-STATUS          
I02262                       MOVE WS-NO       TO S-ELIGIBLE             
I02262              END-EVALUATE                                        
I02262           ELSE                                                   
I02262              IF DF-AUTO-REN-OPT-IN-FL EQUAL WS-OPTED-IN          
I02262                 MOVE WS-YES            TO S-CURR-STATUS          
I02262                 MOVE WS-YES            TO S-ELIGIBLE             
I02262              ELSE                                                
I02262                 MOVE WS-NO             TO S-CURR-STATUS          
I02262                 MOVE WS-NO             TO S-ELIGIBLE             
I02262              END-IF                                              
I02262           END-IF                                                 
I02262        ELSE                                                      
                 EVALUATE DF-AUTO-REN-OPT-IN-FL                         
                     WHEN WS-NOT-ELIGIBLE                               
                          MOVE WS-NO          TO S-CURR-STATUS          
                          MOVE WS-NO          TO S-ELIGIBLE             
                     WHEN WS-ELIGIBLE                                   
                          MOVE WS-NO          TO S-CURR-STATUS          
                          MOVE WS-YES         TO S-ELIGIBLE             
                     WHEN WS-OPTED-IN                                   
                          MOVE WS-YES         TO S-CURR-STATUS          
                          MOVE WS-YES         TO S-ELIGIBLE             
                     WHEN WS-OPTED-OUT                                  
                          MOVE WS-NO          TO S-CURR-STATUS          
                          MOVE WS-YES         TO S-ELIGIBLE             
                     WHEN OTHER                                         
                          MOVE WS-NO          TO S-CURR-STATUS          
                          MOVE WS-NO          TO S-ELIGIBLE             
                 END-EVALUATE                                           
I02262        END-IF                                                    
P00892     END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10264700
      ******************************************************************10265000
      * 2900-BBP-CALC-ATTRIB.                                          *10270000
      ******************************************************************10280000
       2900-BBP-CALC-ATTRIB.                                            
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE '12 Months Usage'             TO S-ATTRIBUTE-1.         
           MOVE 'N'                           TO S-ELIGIBLE.            
           MOVE SPACES                        TO S-ATTRIBUTE-DETAILS.   
                                                                        
      *    GET CUT-OFF-MONTH                                            10301600
           IF AT-REV-MTH-LST-NRML GREATER THAN WS-ZERO                  
              MOVE WS-DFLT-NO-OF-BILLS        TO WS-CUTOFF-CNT          
              MOVE AT-REV-MTH-LST-NRML        TO WS-CUTOF-REV-MNTH      
                                                                        
              PERFORM 2910-GET-CUTOFF-REV-MNTH   THRU 2910-EXIT         
                UNTIL WS-CUTOFF-CNT EQUAL WS-ZERO                       
                                                                        
              MOVE WS-CUTOF-REV-MNTH          TO WS-REVENUE-MONTH       
              MOVE WS-REVENUE-MONTH           TO BG-REVENUE-MONTH       
                                                                        
      *       CHECK FOR 13 MONTHS BILLS EXISTS USING CUT-OFF-MONTH      10302700
              PERFORM 7700-CHK-13-MNTHS-BILL-EXIST THRU 7700-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-ADDTNL-BILLS-EXIST EQUAL WS-YES                        
              MOVE WS-YES                 TO S-CURR-STATUS              
           ELSE                                                         
              MOVE WS-NO                  TO S-CURR-STATUS              
           END-IF.                                                      
                                                                        
           MOVE  WS-ZERO                  TO S-RETURN-CODE-1.           
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
        2900-EXIT.                                                      
             EXIT.                                                      
      *                                                                 10304300
      ******************************************************************10304400
      *                                                                *10304500
      * 2910-GET-CUTOFF-REV-MNTH.                                      *10304600
      *   THIS ROUTINE WILL GET THE CUTOFF REVENUE MONTH               *10304700
      ******************************************************************10304800
       2910-GET-CUTOFF-REV-MNTH.                                        
                                                                        
           SUBTRACT +1     FROM WS-CUTOF-REV-MNTH-MM                    
                                WS-CUTOFF-CNT.                          
                                                                        
           IF WS-CUTOF-REV-MNTH-MM EQUAL WS-ZERO                        
              MOVE WS-12                     TO WS-CUTOF-REV-MNTH-MM    
              SUBTRACT +1  FROM WS-CUTOF-REV-MNTH-YY                    
           END-IF.                                                      
                                                                        
       2910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11950000
      * 4025-DETERMINE-ADDRESS.                                        *11960000
      ******************************************************************11970000
      *                                                                 11980000
           EXEC SQL                                                     11990000
              INCLUDE CPD00074                                          12000000
           END-EXEC.                                                    12010000
      *                                                                 12020000
           EXEC SQL                                                     12030000
              INCLUDE CPD00004                                          12040000
           END-EXEC.                                                    12050000
      *                                                                 12060000
      ******************************************************************12060100
      * 6100-GET-DRAFT-ELIGIBILITY.                                    *12060200
      * 6200-GET-AUTOCARD-ELIGIBILITY.                                 *12060300
      ******************************************************************12060400
           EXEC SQL                                                     12061000
              INCLUDE CPD00377                                          12062000
           END-EXEC.                                                    12063000
      *                                                                 12064000
      ******************************************************************12070000
      * 7000-SELECT-ACCOUNT.                                           *12080000
      ******************************************************************12090000
      *                                                                 12100000
       7000-SELECT-ACCOUNT.                                             
      *                                                                 12120000
           EXEC SQL                                                     
              SELECT                                                    
                     AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.TOTAL_AR_BALANCE                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                    ,AT.NO_BILL_COPIES                                  
                    ,AT.PREMISE_NO                                      
                    ,AT.MST_SUB_ACCT_IND                                
                    ,AT.ADDRESS_ID                                      
                    ,AT.ADDRESS_FORMAT                                  
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.REV_MTH_LST_NRML                                
PRDFIX              ,AT.BILL_CYCLE                                      
OTPOOL              ,COALESCE(B1.DIVISION_NO,'   ')                       
                INTO                                                    
                     :AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-ACCT-CREATE-DT :WS-NULL-IND1                    
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-ACCT-FINALED-DT :WS-NULL-IND2                   
                    ,:AT-NO-BILL-COPIES                                 
                    ,:AT-PREMISE-NO                                     
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-REV-MTH-LST-NRML                               
PRDFIX              ,:AT-BILL-CYCLE                                     
OTPOOL              ,:B1-DIVISION-NO                                    
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
OTPOOL              ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   
OTPOOL           AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                 
OTPOOL           AND B1.COMPANY_NO   =  AT.COMPANY_NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12130000
MFA-TR*       SELECT                                                    12140000
MFA-TR*              AT.COMPANY_NO                                      12150000
MFA-TR*             ,AT.CUSTOMER_NO                                     12160000
MFA-TR*             ,AT.CODES_DATA_PRESENT                              12170000
MFA-TR*             ,AT.CODE_ACCT_STAT                                  12180000
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                               12190000
MFA-TR*             ,AT.ACCT_CREATE_DT                                  12200000
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                12210000
MFA-TR*             ,AT.ACCT_FINALED_DT                                 12220000
MFA-TR*             ,AT.NO_BILL_COPIES                                  12230000
MFA-TR*             ,AT.PREMISE_NO                                      12240000
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                12250000
MFA-TR*             ,AT.ADDRESS_ID                                      12260000
MFA-TR*             ,AT.ADDRESS_FORMAT                                  12270000
MFA-TR*             ,AT.LOCAL_OFFICE                                    12271000
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                               12272000
MFA-TR*             ,AT.REV_MTH_LST_NRML                                12273000
MFA-TR*             ,AT.BILL_CYCLE                                      12273000
MFA-TR*             ,IFNULL(B1.DIVISION_NO,'   ')                               
MFA-TR*         INTO                                                    12280000
MFA-TR*              :AT-COMPANY-NO                                     12290000
MFA-TR*             ,:AT-CUSTOMER-NO                                    12300000
MFA-TR*             ,:AT-CODES-DATA-PRESENT                             12310000
MFA-TR*             ,:AT-CODE-ACCT-STAT                                 12320000
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                              12330000
MFA-TR*             ,:AT-ACCT-CREATE-DT:WS-NULL-IND1                    12340000
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                               12350000
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-NULL-IND2                   12360000
MFA-TR*             ,:AT-NO-BILL-COPIES                                 12370000
MFA-TR*             ,:AT-PREMISE-NO                                     12380000
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                               12390000
MFA-TR*             ,:AT-ADDRESS-ID                                     12400000
MFA-TR*             ,:AT-ADDRESS-FORMAT                                 12410000
MFA-TR*             ,:AT-LOCAL-OFFICE                                   12411000
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                              12412000
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               12413000
MFA-TR*             ,:AT-BILL-CYCLE                                     12413000
MFA-TR*             ,:B1-DIVISION-NO                                            
MFA-TR*         FROM CSS_ACCOUNT      AT                                12420000
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   12430000
MFA-TR*          AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                         
MFA-TR*          AND B1.COMPANY_NO   =  AT.COMPANY_NO                           
MFA-TR*         WITH UR                                                 12440000
MFA-TR*      QUERYNO 7000                                               12450000
MFA-TR*    END-EXEC.                                                    12460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12470000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
      *                                                                 12510000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NUM            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 12650000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12680000
      ******************************************************************12690000
      * 7100-GET-DELINQUENCY.                                          *12700000
      ******************************************************************12710000
      *                                                                 12720000
       7100-GET-DELINQUENCY.                                            
      *                                                                 12740000
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12750000
MFA-TR*       SELECT DELINQ_VALUE                                       12760000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   12770000
MFA-TR*         FROM CSS_DELINQUENCY                                    12780000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         12790000
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                        12800000
MFA-TR*         WITH UR                                                 12810000
MFA-TR*      QUERYNO 7100                                               12820000
MFA-TR*    END-EXEC.                                                    12830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'DELINQ CE'               TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13050000
      ******************************************************************13060000
      * 7200-GET-EMAIL-ADDRESS.                                        *13070000
      ******************************************************************13080000
      *                                                                 13090000
       7200-GET-EMAIL-ADDRESS.                                          
      *                                                                 13110000
           EXEC SQL                                                     
             SELECT TOP(1) YP.ATTRIBUTE_VALUE_CD                               
               INTO :YP-ATTRIBUTE-VALUE-CD                              
               FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),                
                    CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                      
              WHERE YP.ACCOUNT_NO        = :AT-ACCOUNT-NO               
                AND WZ.COMPANY_NO        = :AT-COMPANY-NO               
                AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC           
                AND WZ.ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX        
                AND YP.ATTRIBUTE_DESC    = WZ.ATTRIBUTE_DESC            
                AND WZ.ATTRIBUTE_STAT_CD = :WS-A                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13120000
MFA-TR*      SELECT YP.ATTRIBUTE_VALUE_CD                               13130000
MFA-TR*        INTO :YP-ATTRIBUTE-VALUE-CD                              13140000
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE YP,                              13150000
MFA-TR*             CSS_ATTRIBUTE WZ                                    13160000
MFA-TR*       WHERE YP.ACCOUNT_NO        = :AT-ACCOUNT-NO               13170000
MFA-TR*         AND WZ.COMPANY_NO        = :AT-COMPANY-NO               13180000
MFA-TR*         AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC           13190000
MFA-TR*         AND WZ.ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX        13200000
MFA-TR*         AND YP.ATTRIBUTE_DESC    = WZ.ATTRIBUTE_DESC            13210000
MFA-TR*         AND WZ.ATTRIBUTE_STAT_CD = :WS-A                        13220000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              13230000
MFA-TR*       QUERYNO 7200                                              13240000
MFA-TR*    END-EXEC.                                                    13250000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_EMAIL'          TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13450000
      ***************************************************************** 13460000
      * 7250-GET-ACCT-XREF-ID.                                        * 13470000
      * GET ADDRESS ID.                                               * 13480000
      ***************************************************************** 13490000
       7250-GET-ACCT-XREF-ID.                                           
      *                                                                 13510000
           EXEC SQL                                                     
               SELECT TOP(1) HT.ADDRESS_ID                                     
                 INTO :HT-ADDRESS-ID                                    
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                     ,CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.ACCOUNT_NO         = :AT-ACCOUNT-NO            
                  AND HT.NAME_ID            = DQ.NAME_ID                
                  AND DQ.NAME_TYPE          = 'CN'                      
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13520000
MFA-TR*        SELECT HT.ADDRESS_ID                                     13530000
MFA-TR*          INTO :HT-ADDRESS-ID                                    13540000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT                             13550000
MFA-TR*              ,CSS_NAME DQ                                       13560000
MFA-TR*         WHERE HT.ACCOUNT_NO         = :AT-ACCOUNT-NO            13570000
MFA-TR*           AND HT.NAME_ID            = DQ.NAME_ID                13580000
MFA-TR*           AND DQ.NAME_TYPE          = 'CN'                      13590000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            13600000
MFA-TR*    END-EXEC.                                                    13610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 13810119
      *                                                               * 13810219
      * 7300-SELECT-FMT-ADDR.                                         * 13810319
      ***************************************************************** 13810419
       7300-SELECT-FMT-ADDR.                                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX)))))))),
              RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2)))),
              DY.ZIP_CODE,
              TOWN,
              STATE                                               
               INTO :WS-ADDRESS-LINE-1,                                 
                    :WS-ADDRESS-LINE-2,                                 
                    :DY-ZIP-CODE,                                       
                    :A4-TOWN,                                           
                    :A4-STATE                                           
               FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),                
                    CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                       
              WHERE ADDRESS_ID = :DY-ADDRESS-ID                         
                AND DY.ZIP_CODE = A4.ZIP_CODE                           
                AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     13813009
MFA-TR*      SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||               13814009
MFA-TR*             LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                13815009
MFA-TR*             LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                13816009
MFA-TR*             LTRIM(RTRIM(STREET_NAME) || ' ' ||                  13817009
MFA-TR*             LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                13818009
MFA-TR*             LTRIM(RTRIM(ADDR_SUFFIX)))))))),                    13819009
MFA-TR*             RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||      13819109
MFA-TR*             LTRIM(RTRIM(STREET_LOCATION_2)))),                  13819209
MFA-TR*             DY.ZIP_CODE,                                        13819409
MFA-TR*             TOWN,                                               13819509
MFA-TR*             STATE                                               13819609
MFA-TR*        INTO :WS-ADDRESS-LINE-1,                                 13819709
MFA-TR*             :WS-ADDRESS-LINE-2,                                 13819809
MFA-TR*             :DY-ZIP-CODE,                                       13819909
MFA-TR*             :A4-TOWN,                                           13820009
MFA-TR*             :A4-STATE                                           13820111
MFA-TR*        FROM CSS_ADDR_FORMATTED DY,                              13820209
MFA-TR*             CSS_ZIP_CODE A4                                     13820309
MFA-TR*       WHERE ADDRESS_ID = :DY-ADDRESS-ID                         13820409
MFA-TR*         AND DY.ZIP_CODE = A4.ZIP_CODE                           13820509
MFA-TR*         AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN               13820609
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13820709
MFA-TR*       WITH UR                                                   13820809
MFA-TR*       QUERYNO 7300                                              13820909
MFA-TR*    END-EXEC.                                                    13821009

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                              DCLCSS-ZIP-CODE                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME   TO ABEND-PROGRAM                 
                   MOVE '7300'         TO ACTIVE-PARAGRAPH              
                   MOVE 'SELECT'       TO ABEND-FUNCTION                
                   MOVE SPACES         TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'   TO TABLE-ELEMENT-1               
                   MOVE DY-ADDRESS-ID  TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 13823619
      *                                                               * 13823719
      * 7310-SELECT-FF-ADDR..                                         * 13823819
      ***************************************************************** 13823919
       7310-SELECT-FF-ADDR.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                       
               INTO :WS-ADDRESS-LINE-1                                  
                   ,:DZ-ADDR-CITY-STATE                                 
                   ,:DZ-ADDR-ZIP-CODE                                   
                   ,:DZ-ADDR-COUNTRY                                    
               FROM  CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
              WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13824215
MFA-TR*       SELECT ADDR_STREET                                        13824315
MFA-TR*             ,ADDR_CITY_STATE                                    13824415
MFA-TR*             ,ADDR_ZIP_CODE                                      13824515
MFA-TR*             ,ADDR_COUNTRY                                       13824615
MFA-TR*        INTO :WS-ADDRESS-LINE-1                                  13824715
MFA-TR*            ,:DZ-ADDR-CITY-STATE                                 13824815
MFA-TR*            ,:DZ-ADDR-ZIP-CODE                                   13824915
MFA-TR*            ,:DZ-ADDR-COUNTRY                                    13825015
MFA-TR*        FROM  CSS_ADDR_FREEFORM                                  13825115
MFA-TR*       WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         13825215
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13825315
MFA-TR*       WITH UR                                                   13825415
MFA-TR*       QUERYNO 7310                                              13825516
MFA-TR*    END-EXEC.                                                    13825615

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7310'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ADDRESS_ID'   TO TABLE-ELEMENT-1               
                   MOVE DZ-ADDRESS-ID  TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 13829000
      * 7260-GET-ADDR-FORMAT.                                         * 13830000
      * GET ADDRESS FORMATTED DETAILS.                                * 13840000
      ***************************************************************** 13850000
       7260-GET-ADDR-FORMAT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DY.HOUSE_NO,
              DY.ADDR_PREFIX_1,
              DY.ADDR_PREFIX_2,
              DY.STREET_NAME,
              DY.STREET_SUFFIX,
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              DY.ADDR_SUFFIX,
              DY.STREET_LOCATION_1,
              DY.STREET_LOCATION_2,
              DY.ADDRESS_OVERFLOW,
              A4.TOWN,
              A4.STATE                                          
                 INTO :DY-HOUSE-NO                                      
                     ,:DY-ADDR-PREFIX-1                                 
                     ,:DY-ADDR-PREFIX-2                                 
                     ,:DY-STREET-NAME                                   
                     ,:DY-STREET-SUFFIX                                 
                     ,:DY-ZIP-CODE                                      
                     ,:DY-ZIP-CODE-PLUS-FOUR                            
                     ,:DY-ZIP-CODE-TOKEN                                
                     ,:DY-ADDR-SUFFIX                                   
                     ,:DY-STREET-LOCATION-1                             
                     ,:DY-STREET-LOCATION-2                             
                     ,:DY-ADDRESS-OVERFLOW                              
                     ,:A4-TOWN                                          
                     ,:A4-STATE                                         
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                     ,CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE DY.ADDRESS_ID         = :DY-ADDRESS-ID            
                  AND DY.ZIP_CODE           = A4.ZIP_CODE               
                  AND DY.ZIP_CODE_TOKEN     = A4.ZIP_CODE_TOKEN         
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13880000
MFA-TR*        SELECT DY.HOUSE_NO                                       13890000
MFA-TR*              ,DY.ADDR_PREFIX_1                                  13900000
MFA-TR*              ,DY.ADDR_PREFIX_2                                  13910000
MFA-TR*              ,DY.STREET_NAME                                    13920000
MFA-TR*              ,DY.STREET_SUFFIX                                  13930000
MFA-TR*              ,DY.ZIP_CODE                                       13940000
MFA-TR*              ,DY.ZIP_CODE_PLUS_FOUR                             13950000
MFA-TR*              ,DY.ZIP_CODE_TOKEN                                 13960000
MFA-TR*              ,DY.ADDR_SUFFIX                                    13970000
MFA-TR*              ,DY.STREET_LOCATION_1                              13980000
MFA-TR*              ,DY.STREET_LOCATION_2                              13990000
MFA-TR*              ,DY.ADDRESS_OVERFLOW                               14000000
MFA-TR*              ,A4.TOWN                                           14010000
MFA-TR*              ,A4.STATE                                          14020000
MFA-TR*          INTO :DY-HOUSE-NO                                      14030000
MFA-TR*              ,:DY-ADDR-PREFIX-1                                 14040000
MFA-TR*              ,:DY-ADDR-PREFIX-2                                 14050000
MFA-TR*              ,:DY-STREET-NAME                                   14060000
MFA-TR*              ,:DY-STREET-SUFFIX                                 14070000
MFA-TR*              ,:DY-ZIP-CODE                                      14080000
MFA-TR*              ,:DY-ZIP-CODE-PLUS-FOUR                            14090000
MFA-TR*              ,:DY-ZIP-CODE-TOKEN                                14100000
MFA-TR*              ,:DY-ADDR-SUFFIX                                   14110000
MFA-TR*              ,:DY-STREET-LOCATION-1                             14120000
MFA-TR*              ,:DY-STREET-LOCATION-2                             14130000
MFA-TR*              ,:DY-ADDRESS-OVERFLOW                              14140000
MFA-TR*              ,:A4-TOWN                                          14150000
MFA-TR*              ,:A4-STATE                                         14160000
MFA-TR*          FROM CSS_ADDR_FORMATTED DY                             14170000
MFA-TR*              ,CSS_ZIP_CODE A4                                   14180000
MFA-TR*         WHERE DY.ADDRESS_ID         = :DY-ADDRESS-ID            14190000
MFA-TR*           AND DY.ZIP_CODE           = A4.ZIP_CODE               14200000
MFA-TR*           AND DY.ZIP_CODE_TOKEN     = A4.ZIP_CODE_TOKEN         14210000
MFA-TR*          FETCH FIRST 1 ROWS ONLY WITH UR                        14220000
MFA-TR*       QUERYNO 7260                                              14230000
MFA-TR*    END-EXEC.                                                    14240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                 
              MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1         
              MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14440000
      ***************************************************************** 14450000
      * 7270-GET-ADDR-FREEFORM.                                       * 14460000
      * GET TOWN & STATE OF THE ZIP.                                  * 14470000
      ***************************************************************** 14480000
       7270-GET-ADDR-FREEFORM.                                          
      *                                                                 14500000
           EXEC SQL                                                     
               SELECT TOP(1) DZ.ADDR_STREET,
              DZ.ADDR_CITY_STATE,
              DZ.ADDR_ZIP_CODE                                  
                 INTO :DZ-ADDR-STREET                                   
                     ,:DZ-ADDR-CITY-STATE                               
                     ,:DZ-ADDR-ZIP-CODE                                 
                 FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED)                
                WHERE DZ.ADDRESS_ID = :DZ-ADDRESS-ID                    
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14510000
MFA-TR*        SELECT DZ.ADDR_STREET                                    14520000
MFA-TR*              ,DZ.ADDR_CITY_STATE                                14530000
MFA-TR*              ,DZ.ADDR_ZIP_CODE                                  14540000
MFA-TR*          INTO :DZ-ADDR-STREET                                   14550000
MFA-TR*              ,:DZ-ADDR-CITY-STATE                               14560000
MFA-TR*              ,:DZ-ADDR-ZIP-CODE                                 14570000
MFA-TR*          FROM CSS_ADDR_FREEFORM DZ                              14580000
MFA-TR*         WHERE DZ.ADDRESS_ID = :DZ-ADDRESS-ID                    14590000
MFA-TR*          FETCH FIRST 1 ROWS ONLY WITH UR                        14600000
MFA-TR*       QUERYNO 7270                                              14610000
MFA-TR*    END-EXEC.                                                    14620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7270'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ZIP_CODE'            TO TABLE-1                 
              MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-1         
              MOVE 'ZIP_CODE_TOKEN'          TO TABLE-ELEMENT-2         
              MOVE A4-ZIP-CODE               TO HOSTVAR-ELEMENT-1       
              MOVE A4-ZIP-CODE-TOKEN         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14840000
      ******************************************************************15230000
      * 7350-GET-SHARE-AMT.                                            *15240000
      ******************************************************************15250000
       7350-GET-SHARE-AMT.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COALESCE(MONTHLY_BILL_AM,0),
              PJ.SHARE_STATUS_CD                                
                 INTO :PJ-MONTHLY-BILL-AM                               
                     ,:PJ-SHARE-STATUS-CD                               
                 FROM CSS_PROJ_SHARE  PJ WITH(READUNCOMMITTED)                  
                WHERE PJ.ACCOUNT_NO         = :AT-ACCOUNT-NO            
                  AND PJ.PYMT_PRIORITY_LVL  = :WS-129                   
                  AND PJ.ITEM_ID            = :WS-ONE                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15290000
MFA-TR*        SELECT COALESCE(MONTHLY_BILL_AM,0)                       15300000
MFA-TR*              ,PJ.SHARE_STATUS_CD                                15301000
MFA-TR*          INTO :PJ-MONTHLY-BILL-AM                               15310000
MFA-TR*              ,:PJ-SHARE-STATUS-CD                               15311000
MFA-TR*          FROM CSS_PROJ_SHARE  PJ                                15320000
MFA-TR*         WHERE PJ.ACCOUNT_NO         = :AT-ACCOUNT-NO            15330000
MFA-TR*           AND PJ.PYMT_PRIORITY_LVL  = :WS-129                   15340000
MFA-TR*           AND PJ.ITEM_ID            = :WS-ONE                   15350000
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                           15370000
MFA-TR*       QUERYNO 7350                                              15380000
MFA-TR*    END-EXEC.                                                    15390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
      *                                                                 15440000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE PJ-MONTHLY-BILL-AM     TO WS-MONTHLY-BILL-NUM     
                 MOVE WS-MONTHLY-BILL        TO S-ATTRIBUTE-DETAILS     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7350'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PROJ_SHARE'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15590000
      ******************************************************************15600000
      * 7400-GET-CUST-LANG.                                            *15610000
      ******************************************************************15620000
      *                                                                 15630000
       7400-GET-CUST-LANG.                                              
      *                                                                 15650000
           EXEC SQL                                                     
               SELECT CE.LANGUAGE_PREF_CD                               
                     ,CE.EBILL_REGISTER_IND                             
                 INTO :CE-LANGUAGE-PREF-CD                              
                     ,:CE-EBILL-REGISTER-IND                            
                 FROM CSS_CUST_STATS  CE WITH(READUNCOMMITTED)                  
                WHERE CE.CUSTOMER_NO        = :AT-CUSTOMER-NO           
                  AND CE.CUSTOMER_TYPE      = :WS-CUSTOMER              
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15660000
MFA-TR*        SELECT CE.LANGUAGE_PREF_CD                               15670000
MFA-TR*              ,CE.EBILL_REGISTER_IND                             15671000
MFA-TR*          INTO :CE-LANGUAGE-PREF-CD                              15680000
MFA-TR*              ,:CE-EBILL-REGISTER-IND                            15681000
MFA-TR*          FROM CSS_CUST_STATS  CE                                15690000
MFA-TR*         WHERE CE.CUSTOMER_NO        = :AT-CUSTOMER-NO           15700000
MFA-TR*           AND CE.CUSTOMER_TYPE      = :WS-CUSTOMER              15710000
MFA-TR*       QUERYNO 7400                                              15720000
MFA-TR*       WITH UR                                                   15730000
MFA-TR*    END-EXEC.                                                    15740000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
      *                                                                 15790000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15940000
      ******************************************************************16351000
      * 7550-SELECT-BANK-EFT.                                          *16352000
      ******************************************************************16353000
      *                                                                 16354000
       7550-SELECT-BANK-EFT.                                            
      *                                                                 16356000
           EXEC SQL                                                     
               SELECT BE.STATUS_CODE                                    
                     ,BE.REQSTED_DRAFT_DAY                              
                     ,BE.DRAFT_CYCLE                                    
                     ,BE.CUST_BANK_SEQ_NO                               
                 INTO :BE-STATUS-CODE                                   
                     ,:BE-REQSTED-DRAFT-DAY                             
                     ,:BE-DRAFT-CYCLE                                   
                     ,:BE-CUST-BANK-SEQ-NO                              
                 FROM CSS_BANK_EFT BE                                   
                WHERE BE.ACCOUNT_NO  = :BE-ACCOUNT-NO                   
      *           AND BE.STATUS_CODE = :WS-ACTIVE                       16359800
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     16357000
MFA-TR*        SELECT BE.STATUS_CODE                                    16358000
MFA-TR*              ,BE.REQSTED_DRAFT_DAY                              16358100
MFA-TR*              ,BE.DRAFT_CYCLE                                    16359000
MFA-TR*              ,BE.CUST_BANK_SEQ_NO                               16359100
MFA-TR*          INTO :BE-STATUS-CODE                                   16359200
MFA-TR*              ,:BE-REQSTED-DRAFT-DAY                             16359300
MFA-TR*              ,:BE-DRAFT-CYCLE                                   16359400
MFA-TR*              ,:BE-CUST-BANK-SEQ-NO                              16359500
MFA-TR*          FROM CSS_BANK_EFT BE                                   16359600
MFA-TR*         WHERE BE.ACCOUNT_NO  = :BE-ACCOUNT-NO                   16359700
MFA-TR*           AND BE.STATUS_CODE = :WS-ACTIVE                       16359800
MFA-TR*       QUERYNO 7550                                              16359900
MFA-TR*    END-EXEC.                                                    16360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES               TO BE-REQSTED-DRAFT-DAY   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7550'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_BANK_EFT'        TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE BE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 16361900
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16362300
      *  7560-SELECT-CREDIT-PROF                                       *16362400
      ******************************************************************16362500
       7560-SELECT-CREDIT-PROF.                                         
      *                                                                 16362700
           EXEC SQL                                                     
              SELECT CASH_ONLY_FL                                       
                INTO :CZ-CASH-ONLY-FL                                   
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16362800
MFA-TR*       SELECT CASH_ONLY_FL                                       16362900
MFA-TR*         INTO :CZ-CASH-ONLY-FL                                   16363100
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 16365000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        16366000
MFA-TR*         WITH UR                                                 16367000
MFA-TR*        QUERYNO 7560                                             16368000
MFA-TR*    END-EXEC.                                                    16369000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7560'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16370800
                                                                        
      ******************************************************************16371000
      * 7570-GET-BANK-NICKNAME.                                        *16371100
      ******************************************************************16371200
      *                                                                 16371300
       7570-GET-BANK-NICKNAME.                                          
           EXEC SQL                                                     
               SELECT JF.BANK_ACCT_NICKNAME,                            
                      JF.BANK_ACCT_NO                                   
                 INTO :JF-BANK-ACCT-NICKNAME,                           
                      :JF-BANK-ACCT-NO                                  
                 FROM CSS_CUSTOMER_BANK JF                              
                WHERE JF.CUSTOMER_NO = :AT-CUSTOMER-NO                  
                  AND JF.CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO        
                  AND JF.BANK_ACCT_STAT_CD = 'A'                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     16371500
MFA-TR*        SELECT JF.BANK_ACCT_NICKNAME,                            16371600
MFA-TR*               JF.BANK_ACCT_NO                                   16371700
MFA-TR*          INTO :JF-BANK-ACCT-NICKNAME,                           16371800
MFA-TR*               :JF-BANK-ACCT-NO                                  16371900
MFA-TR*          FROM CSS_CUSTOMER_BANK JF                              16372000
MFA-TR*         WHERE JF.CUSTOMER_NO = :AT-CUSTOMER-NO                  16372100
MFA-TR*           AND JF.CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO        16372200
MFA-TR*           AND JF.BANK_ACCT_STAT_CD = 'A'                        16372300
MFA-TR*       QUERYNO 7570                                              16372400
MFA-TR*    END-EXEC.                                                    16372500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES               TO BE-REQSTED-DRAFT-DAY   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7570'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CUSTOMER_BANK'   TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE BE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 16374400
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16374800
      *                                                               * 16374900
      * 7600-GET-AUTORENEW-IND.                                       * 16375000
      ***************************************************************** 16375100
       7600-GET-AUTORENEW-IND.                                          
      *                                                                 16375300
           EXEC SQL                                                     
                SELECT TOP(1) DF.AUTO_REN_OPT_IN_FL,
              DF.OFFER_CD,
              DF.OPT_AGRMT_EFF_DT                              
                  INTO :DF-AUTO-REN-OPT-IN-FL                           
I02262                ,:DF-OFFER-CD                                     
I02262                ,:DF-OPT-AGRMT-EFF-DT                             
                  FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
                 WHERE DF.ACCOUNT_NO = :DF-ACCOUNT-NO                   
                 ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16375400
MFA-TR*         SELECT DF.AUTO_REN_OPT_IN_FL                            16375500
MFA-TR*               ,DF.OFFER_CD                                              
MFA-TR*               ,DF.OPT_AGRMT_EFF_DT                                      
MFA-TR*           INTO :DF-AUTO-REN-OPT-IN-FL                           16375700
MFA-TR*               ,:DF-OFFER-CD                                             
MFA-TR*               ,:DF-OPT-AGRMT-EFF-DT                                     
MFA-TR*           FROM CSS_ACCT_RTPK_AGR DF                             16375900
MFA-TR*          WHERE DF.ACCOUNT_NO = :DF-ACCOUNT-NO                   16376100
MFA-TR*          ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                     16376500
MFA-TR*          FETCH FIRST ROW ONLY                                   16376600
MFA-TR*           WITH UR                                               16376700
MFA-TR*        QUERYNO 7600                                             16376800
MFA-TR*    END-EXEC.                                                    16376900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_RTPK_AGR'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE DF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                 16378800
I02262*****************************************************************         
I02262*                                                               *         
I02262* 7625-GET-OFFER-TYPE.                                          *         
I02262*****************************************************************         
I02262 7625-GET-OFFER-TYPE.                                             
I02262*                                                                         
I02262     EXEC SQL                                                     
I02262         SELECT TOP(1) FG.SPCL_OFFER_TYPE_CD                            
I02262           INTO :FG-SPCL-OFFER-TYPE-CD                            
I02262           FROM  CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                
I02262          WHERE  FG.OFFER_CD             = :DF-OFFER-CD           
I02262            AND  CAST(FG.OFF_VSTART_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )   
I02262            AND  CAST(FG.OFF_VEND_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )   
I02262            AND  FG.PROC_STATUS_CD       = 'AC'                   
I02262          ORDER BY FG.OFF_VSTART_TS DESC                          
I02262                                     
I02262                                                      
I02262     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FG.SPCL_OFFER_TYPE_CD                                    
MFA-TR*          INTO :FG-SPCL-OFFER-TYPE-CD                                    
MFA-TR*          FROM  CRM_RT_PKG_OFFER FG                                      
MFA-TR*         WHERE  FG.OFFER_CD             = :DF-OFFER-CD                   
MFA-TR*           AND  DATE(FG.OFF_VSTART_TS) <= :DF-OPT-AGRMT-EFF-DT           
MFA-TR*           AND  DATE(FG.OFF_VEND_TS)   >= :DF-OPT-AGRMT-EFF-DT           
MFA-TR*           AND  FG.PROC_STATUS_CD       = 'AC'                           
MFA-TR*         ORDER BY FG.OFF_VSTART_TS DESC                                  
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7625                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02262                                                                  
I02262     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
I02262                                                                  
I02262     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I02262        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
I02262           MOVE SPACES                TO FG-SPCL-OFFER-TYPE-CD    
I02262        END-IF                                                    
I02262     ELSE                                                         
I02262        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
I02262        MOVE '7625'                   TO ACTIVE-PARAGRAPH         
I02262        MOVE 'SELECT'                 TO ABEND-FUNCTION           
I02262        MOVE 'CRM_RT_PKG_OFFER'       TO TABLE-1                  
I02262        MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
I02262        MOVE 'OPT_AGRMT_EFF_DT'       TO TABLE-ELEMENT-2          
I02262        MOVE DF-OFFER-CD              TO HOSTVAR-ELEMENT-1        
I02262        MOVE DF-OPT-AGRMT-EFF-DT      TO HOSTVAR-ELEMENT-2        
I02262        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
I02262     END-IF.                                                      
I02262                                                                  
I02262 7625-EXIT.                                                       
I02262     EXIT.                                                        
I02262*                                                                         
P00892***************************************************************** 16378810
P00892*                                                               * 16378820
P00892* 7650-GET-SEASONAL-FLAG.                                       * 16378830
P00892***************************************************************** 16378840
P00892 7650-GET-SEASONAL-FLAG.                                          
P00892*                                                                 16378860
P00892     EXEC SQL                                                     
P00892        SELECT  TA.SEASONAL_FL                                    
P00892          INTO :TA-SEASONAL-FL                                    
P00892          FROM  CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
P00892         WHERE  TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    
P00892                                                           
P00892                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16378870
MFA-TR*       SELECT  TA.SEASONAL_FL                                    16378871
MFA-TR*         INTO :TA-SEASONAL-FL                                    16378872
MFA-TR*         FROM  CSS_ACCT_MISC_INFO TA                             16378873
MFA-TR*        WHERE  TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    16378874
MFA-TR*         WITH UR                                                 16378875
MFA-TR*      QUERYNO 7650                                               16378876
MFA-TR*    END-EXEC.                                                    16378897

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00892                                           S-RETURN-CODE-1.       
P00892                                                                  
P00892     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00892         WHEN SUCCESSFUL-CALL                                     
P00892             CONTINUE                                             
P00892         WHEN NOT-FOUND                                           
P00892             MOVE SPACES                 TO TA-SEASONAL-FL        
P00892         WHEN OTHER                                               
P00892             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00892             MOVE '7650'                 TO ACTIVE-PARAGRAPH      
P00892             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00892             MOVE 'CSS_ACCT_MISC_INFO'   TO TABLE-1               
P00892             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00892             MOVE TA-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00892             PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
P00892     END-EVALUATE.                                                
P00892                                                                  
P00892 7650-EXIT.                                                       
P00892      EXIT.                                                       
P00892*                                                                 16378922
OTPOOL*****************************************************************         
OTPOOL*                                                               *         
OTPOOL* 7675-GET-ACCT-MKT-TIER.                                       *         
OTPOOL*****************************************************************         
OTPOOL 7675-GET-ACCT-MKT-TIER.                                          
OTPOOL*                                                                         
OTPOOL     EXEC SQL                                                     
OTPOOL         SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                             
OTPOOL           INTO :DD-TIER-ACCT-TYPE-CD                             
OTPOOL           FROM  CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)               
OTPOOL          WHERE  DD.ACCOUNT_NO  = :DD-ACCOUNT-NO                  
OTPOOL          ORDER  BY DD.EFF_START_DT DESC                          
OTPOOL                                              
OTPOOL                                                           
OTPOOL                                                      
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DD.TIER_ACCT_TYPE_CD                                     
MFA-TR*          INTO :DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*          FROM  CSS_ACCT_MKT_TIER DD                                     
MFA-TR*         WHERE  DD.ACCOUNT_NO  = :DD-ACCOUNT-NO                          
MFA-TR*         ORDER  BY DD.EFF_START_DT DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7675                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
OTPOOL                                                                  
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
OTPOOL        CONTINUE                                                  
OTPOOL     ELSE                                                         
OTPOOL        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
OTPOOL        MOVE '7675'                   TO ACTIVE-PARAGRAPH         
OTPOOL        MOVE 'SELECT'                 TO ABEND-FUNCTION           
OTPOOL        MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
OTPOOL        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
OTPOOL        MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
OTPOOL        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL                                                                  
OTPOOL 7675-EXIT.                                                       
OTPOOL     EXIT.                                                        
OTPOOL*                                                                         
      ******************************************************************16378930
      * 7700-CHK-13-MNTHS-BILL-EXIST                                   *16379000
      ******************************************************************16379100
      *                                                                 16379200
       7700-CHK-13-MNTHS-BILL-EXIST.                                    
      *                                                                 16379400
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO  :WS-ADDTNL-BILLS-EXIST                           
                 FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO               
                  AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH            
                  AND  BG.REVENUE_MONTH  > 0                            
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16379500
MFA-TR*        SELECT  'Y'                                              16379600
MFA-TR*          INTO  :WS-ADDTNL-BILLS-EXIST                           16379700
MFA-TR*          FROM  CSS_BILLING_DET BG                               16379800
MFA-TR*         WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO               16379900
MFA-TR*           AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH            16380000
MFA-TR*           AND  BG.REVENUE_MONTH  > 0                            16380100
MFA-TR*         FETCH FIRST ROW ONLY                                    16380200
MFA-TR*           WITH UR                                               16380300
MFA-TR*    END-EXEC.                                                    16380400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                   TO WS-ADDTNL-BILLS-EXIST  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-REVENUE-MONTH           TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 16382500
       7700-EXIT.                                                       
            EXIT.                                                       
      *                                                                 16382800
      ******************************************************************16382900
      * 8000A-DEL-GTT-ROWS.                                            *16383000
      ******************************************************************16384000
      *                                                                 16390000
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 16410000
           EXEC SQL                                                     
               DELETE FROM #CSR04811_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     16420000
MFA-TR*        DELETE FROM SESSION.CSR04811_R1                          16430000
MFA-TR*    END-EXEC.                                                    16440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16450000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 16480000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04811_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 16680000
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 16710000
      ******************************************************************17080000
      * 8010-INSERT-GTT-R1.                                            *17090000
      ******************************************************************17100000
      *                                                                 17110000
       8010-INSERT-GTT-R1.                                              
      *                                                                 17130000
            EXEC SQL                                                    
               INSERT INTO #CSR04811_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,ATTRIBUTE_NAME                                      
                   ,ATTRIBUTE_CURRENT_STATUS                            
                   ,ATTRIBUTE_ELIGIBLE                                  
                   ,ATTRIBUTE_DETAILS                                   
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-ATTRIBUTE-1                                      
                   ,:S-CURR-STATUS                                      
                   ,:S-ELIGIBLE                                         
                   ,:S-ATTRIBUTE-DETAILS                                
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    17140000
MFA-TR*        INSERT INTO SESSION.CSR04811_R1                          17150000
MFA-TR*           (                                                     17160000
MFA-TR*             RETURN_CODE                                         17170000
MFA-TR*            ,ATTRIBUTE_NAME                                      17180000
MFA-TR*            ,ATTRIBUTE_CURRENT_STATUS                            17190000
MFA-TR*            ,ATTRIBUTE_ELIGIBLE                                  17200000
MFA-TR*            ,ATTRIBUTE_DETAILS                                   17210000
MFA-TR*           )                                                     17220000
MFA-TR*        VALUES                                                   17230000
MFA-TR*           (                                                     17240000
MFA-TR*             :S-RETURN-CODE-1                                    17250000
MFA-TR*            ,:S-ATTRIBUTE-1                                      17260000
MFA-TR*            ,:S-CURR-STATUS                                      17270000
MFA-TR*            ,:S-ELIGIBLE                                         17280000
MFA-TR*            ,:S-ATTRIBUTE-DETAILS                                17290000
MFA-TR*           )                                                     17300000
MFA-TR*     END-EXEC                                                    17310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17320000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 17350000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS-1             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8010'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04811_R1'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 17500000
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 17530000
      ******************************************************************17980000
      * 8800-CHECK-RESULTS.                                            *17990000
      ******************************************************************18000000
      *                                                                 18010000
       8800-CHECK-RESULTS.                                              
      *                                                                 18030000
           IF CTR-ROWS-1    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
           END-IF.                                                      
      *                                                                 18150000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18180000
      ******************************************************************18190000
      * 8900-SEND-DONE.                                                *18200000
      ******************************************************************18210000
      *                                                                 18220000
       8900-SEND-DONE.                                                  
      *                                                                 18240000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 18280000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 18310000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04811_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 18430000
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************18660000
      * 9000-SEND-ERROR-RESULT.                                        *18670000
      ******************************************************************18680000
      *                                                                 18690000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 18710000
           IF S-RETURN-CODE-1 NOT EQUAL ZERO                            
               MOVE S-RETURN-CODE-1          TO WS-RETURN-CODE-1        
           END-IF.                                                      
      *                                                                 18750000
           MOVE WS-NO                        TO SEND-DONE-SW.           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE.          
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
      *                                                                 18870000
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18910000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
      *                                                                 18970000
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
      *                                                                 19000000
           MOVE WS-RETURN-CODE-1             TO S-RETURN-CODE-1.        
      *                                                                 19030000
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
      *                                                                 19060000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19090000
      ******************************************************************19100000
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *19110000
      ******************************************************************19120000
      *                                                                 19130000
           EXEC SQL                                                     19140000
              INCLUDE CPD0023C                                          19150000
           END-EXEC.                                                    19160000
      *                                                                 19170000
      ******************************************************************19180000
      * 9900-SQL-ERROR-ROUTINE.                                        *19190000
      ******************************************************************19200000
      *                                                                 19210000
           EXEC SQL                                                     19220000
              INCLUDE CPDSP300                                          19230000
           END-EXEC.                                                    19240000
      *                                                                 19250000
      ******************************************************************19260000
      * 9999-END-PROGRAM.                                      *        19270000
      ******************************************************************19280000
      *                                                                 19290000
       9999-END-PROGRAM.                                                
      *                                                                 19310000
           PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT            
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT            
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                 19360000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *19390000
      **********************End Of Program *****************************19400000
      *                                                                *19410000
