       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04808.                                          
COB303 DATE-WRITTEN. MARCH 11, 2015.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS CUSTOMER DATA FOR THE WEB.               *        
      *  RESULTS SETS:                                                 *        
      *     1.  CUSTOMER / SPOUSE INFO                                 *        
      *     2.  PHONE NUMBERS                                          *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/11/15    FMB      NEW PROGRAM.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04808'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04808 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04808_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04808_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1      PIC S9(9) COMP VALUE 0.          
               10 S-STATUS-CODE        PIC S9(9) COMP VALUE 0.          
               10 S-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.      
               10 S-CUSTOMER-TYPE      PIC X(01) VALUE SPACES.          
               10 S-CUSTOMER-NAME      PIC X(80) VALUE SPACES.          
               10 S-NAME-FORMAT        PIC X(01) VALUE SPACES.          
               10 S-SSN                PIC X(09) VALUE SPACES.          
               10 S-ITIN               PIC X(09) VALUE SPACES.          
               10 S-OTHER-ID           PIC X(16) VALUE SPACES.          
               10 S-OTHER-ID-TYPE      PIC X(12) VALUE SPACES.          
               10 S-DLN                PIC X(19) VALUE SPACES.          
               10 S-DLN-STATE          PIC X(02) VALUE SPACES.          
               10 S-DOB                PIC X(10) VALUE SPACES.          
               10 S-EMPLOYER           PIC X(23) VALUE SPACES.          
               10 S-EMAIL-ADDRESS      PIC X(100) VALUE SPACES.         
               10 S-TAX-ID             PIC X(09) VALUE SPACES.          
               10 S-SBU-CD             PIC X(01) VALUE SPACES.          
               10 S-FIRST-NAME         PIC X(15) VALUE SPACES.          
               10 S-MIDDLE-NAME        PIC X(15) VALUE SPACES.          
               10 S-LAST-NAME          PIC X(40) VALUE SPACES.          
               10 S-EMAIL-MKT-FL       PIC X(01) VALUE SPACES.          
               10 S-EMAIL-MKT-DT       PIC X(10) VALUE SPACES.          
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2      PIC S9(9) COMP VALUE 0.          
               10 S-PHONE-NAME-TYPE    PIC X(01) VALUE SPACES.          
               10 S-PHONE-TYPE         PIC X(02) VALUE SPACES.          
               10 S-PHONE-NO           PIC X(10) VALUE SPACES.          
               10 S-PHONE-EXT          PIC X(06) VALUE SPACES.          
               10 S-PHONE-MOBILE-FL    PIC X(01) VALUE SPACES.          
               10 S-PHONE-MKT-FL       PIC X(01) VALUE SPACES.          
               10 S-PHONE-MKT-DT       PIC X(10) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04808'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-CUST-NAME             PIC X(76) VALUE SPACES.         
           05  WS-SPOUSE-NAME           PIC X(76) VALUE SPACES.         
           05  WS-SCEG-FL               PIC X(01) VALUE 'N'.            
           05  WS-PSNC-FL               PIC X(01) VALUE 'N'.            
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE PHONE-CURSOR CURSOR FOR                           
               SELECT PHONE_NO,                                         
                      PHONE_TYPE,                                       
                      EXTENSION_NO,                                     
                      MOBILE_PHONE_FL,                                  
                      PERMISN_TO_MKT_DT,                                
                      PERMISN_TO_MKT_FL                                 
                 FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                 
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PHONE-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT PHONE_NO,                                                 
MFA-TR*               PHONE_TYPE,                                               
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               MOBILE_PHONE_FL,                                          
MFA-TR*               PERMISN_TO_MKT_DT,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_CUST_PHONE                                            
MFA-TR*         WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                         
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE      AS RETURN_CODE,                  
                      STATUS_CODE      AS STATUS_CODE,                  
                      CUSTOMER_NO      AS CUSTOMER_NO,                  
                      CUSTOMER_TYPE    AS CUSTOMER_TYPE,                
                      CUSTOMER_NAME    AS CUSTOMER_NAME,                
                      NAME_FORMAT      AS NAME_FORMAT,                  
                      SSN              AS SSN,                          
                      ITIN             AS ITIN,                         
                      OTHER_ID         AS OTHER_ID,                     
                      OTHER_ID_TYPE    AS OTHER_ID_TYPE,                
                      DLN              AS DRIVERS_LICENSE_NO,           
                      DLN_STATE        AS DLN_STATE,                    
                      DOB              AS DATE_OF_BIRTH,                
                      EMPLOYER         AS EMPLOYER,                     
                      EMAIL_ADDRESS    AS EMAIL_ADDRESS,                
                      TAX_ID           AS TAX_ID,                       
                      SBU_CD           AS SBU_CD,                       
                      FIRST_NAME       AS FIRST_NAME,                   
                      MIDDLE_NAME      AS MIDDLE_NAME,                  
                      LAST_NAME        AS LAST_NAME,                    
                      EMAIL_MKT_FL     AS EMAIL_MKT_FL,                 
                      EMAIL_MKT_DT     AS EMAIL_MKT_DT                  
                FROM #CSR04808_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE      AS RETURN_CODE,                          
MFA-TR*               STATUS_CODE      AS STATUS_CODE,                          
MFA-TR*               CUSTOMER_NO      AS CUSTOMER_NO,                          
MFA-TR*               CUSTOMER_TYPE    AS CUSTOMER_TYPE,                        
MFA-TR*               CUSTOMER_NAME    AS CUSTOMER_NAME,                        
MFA-TR*               NAME_FORMAT      AS NAME_FORMAT,                          
MFA-TR*               SSN              AS SSN,                                  
MFA-TR*               ITIN             AS ITIN,                                 
MFA-TR*               OTHER_ID         AS OTHER_ID,                             
MFA-TR*               OTHER_ID_TYPE    AS OTHER_ID_TYPE,                        
MFA-TR*               DLN              AS DRIVERS_LICENSE_NO,                   
MFA-TR*               DLN_STATE        AS DLN_STATE,                            
MFA-TR*               DOB              AS DATE_OF_BIRTH,                        
MFA-TR*               EMPLOYER         AS EMPLOYER,                             
MFA-TR*               EMAIL_ADDRESS    AS EMAIL_ADDRESS,                        
MFA-TR*               TAX_ID           AS TAX_ID,                               
MFA-TR*               SBU_CD           AS SBU_CD,                               
MFA-TR*               FIRST_NAME       AS FIRST_NAME,                           
MFA-TR*               MIDDLE_NAME      AS MIDDLE_NAME,                          
MFA-TR*               LAST_NAME        AS LAST_NAME,                            
MFA-TR*               EMAIL_MKT_FL     AS EMAIL_MKT_FL,                         
MFA-TR*               EMAIL_MKT_DT     AS EMAIL_MKT_DT                          
MFA-TR*         FROM SESSION.CSR04808_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CODE,               
                      :S-CUSTOMER-NO      AS CUSTOMER_NO,               
                      :S-CUSTOMER-TYPE    AS CUSTOMER_TYPE,             
                      :S-CUSTOMER-NAME    AS CUSTOMER_NAME,             
                      :S-NAME-FORMAT      AS NAME_FORMAT,               
                      :S-SSN              AS SSN,                       
                      :S-ITIN             AS ITIN,                      
                      :S-OTHER-ID         AS OTHER_ID,                  
                      :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,             
                      :S-DLN              AS DRIVERS_LICENSE_NO,        
                      :S-DLN-STATE        AS DLN_STATE,                 
                      :S-DOB              AS DATE_OF_BIRTH,             
                      :S-EMPLOYER         AS EMPLOYER,                  
                      :S-EMAIL-ADDRESS    AS EMAIL_ADDRESS,             
                      :S-TAX-ID           AS TAX_ID,                    
                      :S-SBU-CD           AS SBU_CD,                    
                      :S-FIRST-NAME       AS FIRST_NAME,                
                      :S-MIDDLE-NAME      AS MIDDLE_NAME,               
                      :S-LAST-NAME        AS LAST_NAME,                 
                      :S-EMAIL-MKT-FL     AS EMAIL_MKT_FL,              
                      :S-EMAIL-MKT-DT     AS EMAIL_MKT_DT               
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CODE,                       
MFA-TR*               :S-CUSTOMER-NO      AS CUSTOMER_NO,                       
MFA-TR*               :S-CUSTOMER-TYPE    AS CUSTOMER_TYPE,                     
MFA-TR*               :S-CUSTOMER-NAME    AS CUSTOMER_NAME,                     
MFA-TR*               :S-NAME-FORMAT      AS NAME_FORMAT,                       
MFA-TR*               :S-SSN              AS SSN,                               
MFA-TR*               :S-ITIN             AS ITIN,                              
MFA-TR*               :S-OTHER-ID         AS OTHER_ID,                          
MFA-TR*               :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,                     
MFA-TR*               :S-DLN              AS DRIVERS_LICENSE_NO,                
MFA-TR*               :S-DLN-STATE        AS DLN_STATE,                         
MFA-TR*               :S-DOB              AS DATE_OF_BIRTH,                     
MFA-TR*               :S-EMPLOYER         AS EMPLOYER,                          
MFA-TR*               :S-EMAIL-ADDRESS    AS EMAIL_ADDRESS,                     
MFA-TR*               :S-TAX-ID           AS TAX_ID,                            
MFA-TR*               :S-SBU-CD           AS SBU_CD,                            
MFA-TR*               :S-FIRST-NAME       AS FIRST_NAME,                        
MFA-TR*               :S-MIDDLE-NAME      AS MIDDLE_NAME,                       
MFA-TR*               :S-LAST-NAME        AS LAST_NAME,                         
MFA-TR*               :S-EMAIL-MKT-FL     AS EMAIL_MKT_FL,                      
MFA-TR*               :S-EMAIL-MKT-DT     AS EMAIL_MKT_DT                       
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING  FOR
               SELECT RETURN_CODE        AS RETURN_CODE,                
                      PHONE_NAME_TYPE    AS PHONE_NAME_TYPE,            
                      PHONE_TYPE         AS PHONE_TYPE,                 
                      PHONE_NO           AS PHONE_NO,                   
                      PHONE_EXT          AS PHONE_EXT,                  
                      PHONE_MOBILE_FL    AS PHONE_MOBILE_FL,            
                      PHONE_MKT_FL       AS PHONE_MKT_FL,               
                      PHONE_MKT_DT       AS PHONE_MKT_DT                
                FROM #CSR04808_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING  FOR        
MFA-TR*        SELECT RETURN_CODE        AS RETURN_CODE,                        
MFA-TR*               PHONE_NAME_TYPE    AS PHONE_NAME_TYPE,                    
MFA-TR*               PHONE_TYPE         AS PHONE_TYPE,                         
MFA-TR*               PHONE_NO           AS PHONE_NO,                           
MFA-TR*               PHONE_EXT          AS PHONE_EXT,                          
MFA-TR*               PHONE_MOBILE_FL    AS PHONE_MOBILE_FL,                    
MFA-TR*               PHONE_MKT_FL       AS PHONE_MKT_FL,                       
MFA-TR*               PHONE_MKT_DT       AS PHONE_MKT_DT                        
MFA-TR*         FROM SESSION.CSR04808_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2      AS RETURN_CODE,             
                      :S-PHONE-NAME-TYPE    AS PHONE_NAME_TYPE,         
                      :S-PHONE-TYPE         AS PHONE_TYPE,              
                      :S-PHONE-NO           AS PHONE_NO,                
                      :S-PHONE-EXT          AS PHONE_EXT,               
                      :S-PHONE-MOBILE-FL    AS PHONE_MOBILE_FL,         
                      :S-PHONE-MKT-FL       AS PHONE_MKT_FL,            
                      :S-PHONE-MKT-DT       AS PHONE_MKT_DT             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2      AS RETURN_CODE,                     
MFA-TR*               :S-PHONE-NAME-TYPE    AS PHONE_NAME_TYPE,                 
MFA-TR*               :S-PHONE-TYPE         AS PHONE_TYPE,                      
MFA-TR*               :S-PHONE-NO           AS PHONE_NO,                        
MFA-TR*               :S-PHONE-EXT          AS PHONE_EXT,                       
MFA-TR*               :S-PHONE-MOBILE-FL    AS PHONE_MOBILE_FL,                 
MFA-TR*               :S-PHONE-MKT-FL       AS PHONE_MKT_FL,                    
MFA-TR*               :S-PHONE-MKT-DT       AS PHONE_MKT_DT                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04808_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04808_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               CUSTOMER_NO          DECIMAL(10,0),                      
               CUSTOMER_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               CUSTOMER_NAME CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,         
               NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               ITIN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               OTHER_ID CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2,              
               OTHER_ID_TYPE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,         
               DLN CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               DLN_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DOB CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               EMPLOYER CHAR(23)  COLLATE LATIN1_GENERAL_100_BIN2,              
               EMAIL_ADDRESS CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2,        
               TAX_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                
               SBU_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                
               FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,            
               MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,           
               LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,             
               EMAIL_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               EMAIL_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04808_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04808_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04808_R2
              (                                                          
               RETURN_CODE          INT,                            
               PHONE_NAME_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PHONE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
               PHONE_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2,             
               PHONE_MOBILE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PHONE_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               PHONE_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT02-ROWS THRU 8002-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04808_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-CUSTOMER-NO = ZEROES                                 
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-CUSTOMER-NAME                 
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-CUST-SPOUSE-INFO THRU 2100-EXIT.                
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'NO DATA' TO S-CUSTOMER-NAME                        
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-CUST-SPOUSE-INFO.                                           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE CU-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           PERFORM 7025-SELECT-CUST-NAME THRU 7025-EXIT.                
           MOVE WS-CUST-NAME TO S-CUSTOMER-NAME.                        
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
                                                                        
           MOVE 'C' TO CE-CUSTOMER-TYPE                                 
                       S-CUSTOMER-TYPE.                                 
           PERFORM 7030-SELECT-STATS THRU 7030-EXIT.                    
           MOVE CE-SSN TO S-SSN.                                        
           MOVE CE-ITIN-ID TO S-ITIN.                                   
           MOVE CE-OTHER-ID TO S-OTHER-ID.                              
           MOVE CE-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE CE-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE CE-CODE-STATE-ID TO S-DLN-STATE.                        
           MOVE CE-DATE-OF-BIRTH TO S-DOB.                              
           MOVE CE-EMPLOYER TO S-EMPLOYER.                              
                                                                        
           MOVE CU-CUSTOMER-NO TO BS-CUSTOMER-NO.                       
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           MOVE BS-TAX-ID TO S-TAX-ID.                                  
                                                                        
           MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
                                                                        
           MOVE CU-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
           MOVE 'P1' TO NE-EMAIL-TYPE-CD.                               
           PERFORM 7070-SELECT-EMAIL THRU 7070-EXIT.                    
           MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS.            
           MOVE NE-PERMISN-TO-MKT-TS(1:10) TO S-EMAIL-MKT-DT.           
           MOVE NE-PERMISN-TO-MKT-FL TO S-EMAIL-MKT-FL.                 
                                                                        
           IF CSR-DATABASE                                              
               MOVE '01' TO AT-COMPANY-NO                               
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT               
               MOVE '26' TO AT-COMPANY-NO                               
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT
           END-IF.              
                                                                        
           EVALUATE TRUE ALSO TRUE                                      
               WHEN WS-SCEG-FL = 'Y'ALSO WS-PSNC-FL = 'Y'               
                   MOVE 'B' TO S-SBU-CD                                 
               WHEN WS-SCEG-FL = 'Y'ALSO WS-PSNC-FL = 'N'               
                   MOVE 'S' TO S-SBU-CD                                 
               WHEN WS-SCEG-FL = 'N'ALSO WS-PSNC-FL = 'Y'               
                   MOVE 'P' TO S-SBU-CD                                 
           END-EVALUATE.                                                
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           MOVE 'S' TO CE-CUSTOMER-TYPE.                                
           PERFORM 7030-SELECT-STATS THRU 7030-EXIT.                    
           IF CE-CUSTOMER-NO > 0                                        
               PERFORM 2110-SPOUSE-INFO THRU 2110-EXIT
           END-IF.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-SPOUSE-INFO.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE CU-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE CE-SSN TO S-SSN.                                        
           MOVE CE-ITIN-ID TO S-ITIN.                                   
           MOVE CE-OTHER-ID TO S-OTHER-ID.                              
           MOVE CE-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE CE-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE CE-CODE-STATE-ID TO S-DLN-STATE.                        
           MOVE CE-DATE-OF-BIRTH TO S-DOB.                              
           MOVE CE-EMPLOYER TO S-EMPLOYER.                              
                                                                        
           MOVE CE-NAME-ID TO DQ-NAME-ID.                               
           PERFORM 7080-SELECT-SPOUSE-NAME THRU 7080-EXIT.              
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE WS-SPOUSE-NAME TO S-CUSTOMER-NAME.                      
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
                                                                        
           MOVE 'S' TO CB-CUSTOMER-TYPE                                 
                       S-CUSTOMER-TYPE.                                 
           MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
                                                                        
           MOVE 'S1' TO NE-EMAIL-TYPE-CD.                               
           PERFORM 7070-SELECT-EMAIL THRU 7070-EXIT.                    
           MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS.            
           MOVE NE-PERMISN-TO-MKT-TS(1:10) TO S-EMAIL-MKT-DT.           
           MOVE NE-PERMISN-TO-MKT-FL TO S-EMAIL-MKT-FL.                 
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
           END-IF                                                       
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :AT-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
                AND COMPANY_NO = :AT-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                               
MFA-TR*         AND COMPANY_NO = :AT-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   EVALUATE AT-COMPANY-NO                               
                       WHEN '01'                                        
                          MOVE 'Y' TO WS-SCEG-FL                        
                       WHEN '26'                                        
                          MOVE 'Y' TO WS-PSNC-FL                        
                   END-EVALUATE                                         
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-2             
                   MOVE AT-COMPANY-NO    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'      TO TABLE-ELEMENT-1             
                   MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-SELECT-CUST-NAME.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + 
           LTRIM(RTRIM(MIDDLE_NAME) + ' ' + LTRIM(RTRIM(LAST_NAME))))),
              FULL_NAME,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_SUFFIX_1,
              DHR_FL,
              COMPANY_NO_ORIG                                   
                 INTO :WS-CUST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-TITLE-SUFFIX-1,                               
                      :CU-DHR-FL,                                       
                      :CU-COMPANY-NO-ORIG                               
                 FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(LAST_NAME))))),                               
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               DHR_FL,                                                   
MFA-TR*               COMPANY_NO_ORIG                                           
MFA-TR*          INTO :WS-CUST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-TITLE-SUFFIX-1,                                       
MFA-TR*               :CU-DHR-FL,                                               
MFA-TR*               :CU-COMPANY-NO-ORIG                                       
MFA-TR*          FROM CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-CUST-NAME                
                       MOVE SPACES TO DQ-LAST-NAME                      
                                      DQ-FIRST-NAME                     
                                      DQ-MIDDLE-NAME                    
                                      DQ-TITLE-SUFFIX-1                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-CUST-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7025'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO,
              SSN,
              REFUSED_SSN_FL,
              DRIVERS_LICENSE_NO,
              OTHER_ID,
              PASSWORD_TX,
              DATE_OF_BIRTH,
              OTHER_ID_TYPE,
              CODE_STATE_ID,
              DOB_VERIFIED_CD,
              ACCESS_LEVEL_CD,
              ALLOW_CALL_FL,
              ITIN_ID,
              VERIFY_SSN_FL,
              PASSWORD_HINT,
              ALLOW_EMAIL_FL,
              EMPLOYER,
              NAME_ID                                           
                 INTO :CE-CUSTOMER-NO,                                  
                      :CE-SSN,                                          
                      :CE-REFUSED-SSN-FL,                               
                      :CE-DRIVERS-LICENSE-NO,                           
                      :CE-OTHER-ID,                                     
                      :CE-PASSWORD-TX,                                  
                      :CE-DATE-OF-BIRTH :WS-NULL-2,                      
                      :CE-OTHER-ID-TYPE,                                
                      :CE-CODE-STATE-ID,                                
                      :CE-DOB-VERIFIED-CD,                              
                      :CE-ACCESS-LEVEL-CD,                              
                      :CE-ALLOW-CALL-FL,                                
                      :CE-ITIN-ID,                                      
                      :CE-VERIFY-SSN-FL,                                
                      :CE-PASSWORD-HINT,                                
                      :CE-ALLOW-EMAIL-FL,                               
                      :CE-EMPLOYER,                                     
                      :CE-NAME-ID                                       
                 FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               SSN,                                                      
MFA-TR*               REFUSED_SSN_FL,                                           
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               PASSWORD_TX,                                              
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               CODE_STATE_ID,                                            
MFA-TR*               DOB_VERIFIED_CD,                                          
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               ALLOW_CALL_FL,                                            
MFA-TR*               ITIN_ID,                                                  
MFA-TR*               VERIFY_SSN_FL,                                            
MFA-TR*               PASSWORD_HINT,                                            
MFA-TR*               ALLOW_EMAIL_FL,                                           
MFA-TR*               EMPLOYER,                                                 
MFA-TR*               NAME_ID                                                   
MFA-TR*          INTO :CE-CUSTOMER-NO,                                          
MFA-TR*               :CE-SSN,                                                  
MFA-TR*               :CE-REFUSED-SSN-FL,                                       
MFA-TR*               :CE-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :CE-OTHER-ID,                                             
MFA-TR*               :CE-PASSWORD-TX,                                          
MFA-TR*               :CE-DATE-OF-BIRTH:WS-NULL-2,                              
MFA-TR*               :CE-OTHER-ID-TYPE,                                        
MFA-TR*               :CE-CODE-STATE-ID,                                        
MFA-TR*               :CE-DOB-VERIFIED-CD,                                      
MFA-TR*               :CE-ACCESS-LEVEL-CD,                                      
MFA-TR*               :CE-ALLOW-CALL-FL,                                        
MFA-TR*               :CE-ITIN-ID,                                              
MFA-TR*               :CE-VERIFY-SSN-FL,                                        
MFA-TR*               :CE-PASSWORD-HINT,                                        
MFA-TR*               :CE-ALLOW-EMAIL-FL,                                       
MFA-TR*               :CE-EMPLOYER,                                             
MFA-TR*               :CE-NAME-ID                                               
MFA-TR*          FROM CSS_CUST_STATS                                            
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-CUST-STATS                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TAX_ID                                            
                 INTO :BS-TAX-ID                                        
                 FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TAX_ID                                                    
MFA-TR*          INTO :BS-TAX-ID                                                
MFA-TR*          FROM CSS_BUS_CUST_STATS                                        
MFA-TR*         WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO BS-TAX-ID                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-PHONE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN PHONE-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7051-FETCH-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH PHONE-CURSOR                                       
                INTO :CB-PHONE-NO,                                      
                     :CB-PHONE-TYPE,                                    
                     :CB-EXTENSION-NO,                                  
                     :CB-MOBILE-PHONE-FL,                               
                     :CB-PERMISN-TO-MKT-DT :WS-NULL-5,                   
                     :CB-PERMISN-TO-MKT-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
                   INITIALIZE GTT-RETURN-FIELDS-2                       
                   MOVE CB-CUSTOMER-TYPE TO S-PHONE-NAME-TYPE           
                   MOVE CB-PHONE-TYPE TO S-PHONE-TYPE                   
                   MOVE CB-PHONE-NO TO S-PHONE-NO                       
                   MOVE CB-EXTENSION-NO TO S-PHONE-EXT                  
                   MOVE CB-MOBILE-PHONE-FL TO S-PHONE-MOBILE-FL         
                   MOVE CB-PERMISN-TO-MKT-DT TO S-PHONE-MKT-DT          
                   MOVE CB-PERMISN-TO-MKT-FL TO S-PHONE-MKT-FL          
                   IF WS-GTT02-DECLARED = 'N'                           
                       PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT        
                   END-IF                                               
                   PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT            
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 7051-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7051'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 7051-FETCH-PHONE-CURSOR.                               
                                                                        
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7052-CLOSE-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE PHONE-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7052'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7052-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-EMAIL.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) EMAIL_ADDRESS_TX,
              REPLACE(REPLACE(CONVERT(CHAR(26), PERMISN_TO_MKT_TS
           , 121), ' ', '-'), ':', '.') PERMISN_TO_MKT_TS,
              PERMISN_TO_MKT_FL                                 
                 INTO :NE-EMAIL-ADDRESS-TX,                             
                      :NE-PERMISN-TO-MKT-TS :WS-NULL-1,                  
                      :NE-PERMISN-TO-MKT-FL                             
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
                  AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_TS,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          INTO :NE-EMAIL-ADDRESS-TX,                                     
MFA-TR*               :NE-PERMISN-TO-MKT-TS:WS-NULL-1,                          
MFA-TR*               :NE-PERMISN-TO-MKT-FL                                     
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO NE-PERMISN-TO-MKT-TS              
                   END-IF                                               
                   IF NE-EMAIL-ADDRESS-TX-TEXT <= SPACES                
                       MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT              
                                  NE-PERMISN-TO-MKT-TS                  
                                  NE-PERMISN-TO-MKT-FL                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE 'EMAIL_TYPE_CD'  TO TABLE-ELEMENT-2             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE NE-EMAIL-TYPE-CD TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-SPOUSE-NAME.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + 
           LTRIM(RTRIM(MIDDLE_NAME) + ' ' + LTRIM(RTRIM(LAST_NAME))))),
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_SUFFIX_1                                    
                 INTO :WS-SPOUSE-NAME,                                  
                      :DQ-NAME-FORMAT,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-TITLE-SUFFIX-1                                
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE NAME_ID = :DQ-NAME-ID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(LAST_NAME))))),                               
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_SUFFIX_1                                            
MFA-TR*          INTO :WS-SPOUSE-NAME,                                          
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-TITLE-SUFFIX-1                                        
MFA-TR*          FROM CSS_NAME DQ                                               
MFA-TR*         WHERE NAME_ID = :DQ-NAME-ID                                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-SPOUSE-NAME                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7080'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME'       TO TABLE-1                     
                   MOVE 'NAME_ID'        TO TABLE-ELEMENT-1             
                   MOVE DQ-NAME-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04808_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04808_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04808_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT02-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04808_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04808_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04808_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04808_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              CUSTOMER_NO,                                              
              CUSTOMER_TYPE,                                            
              CUSTOMER_NAME,                                            
              NAME_FORMAT,                                              
              SSN,                                                      
              ITIN,                                                     
              OTHER_ID,                                                 
              OTHER_ID_TYPE,                                            
              DLN,                                                      
              DLN_STATE,                                                
              DOB,                                                      
              EMPLOYER,                                                 
              EMAIL_ADDRESS,                                            
              TAX_ID,                                                   
              SBU_CD,                                                   
              FIRST_NAME,                                               
              MIDDLE_NAME,                                              
              LAST_NAME,                                                
              EMAIL_MKT_FL,                                             
              EMAIL_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-CUSTOMER-NO,                                          
               :S-CUSTOMER-TYPE,                                        
               :S-CUSTOMER-NAME,                                        
               :S-NAME-FORMAT,                                          
               :S-SSN,                                                  
               :S-ITIN,                                                 
               :S-OTHER-ID,                                             
               :S-OTHER-ID-TYPE,                                        
               :S-DLN,                                                  
               :S-DLN-STATE,                                            
               :S-DOB,                                                  
               :S-EMPLOYER,                                             
               :S-EMAIL-ADDRESS,                                        
               :S-TAX-ID,                                               
               :S-SBU-CD,                                               
               :S-FIRST-NAME,                                           
               :S-MIDDLE-NAME,                                          
               :S-LAST-NAME,                                            
               :S-EMAIL-MKT-FL,                                         
               :S-EMAIL-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04808_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       CUSTOMER_NO,                                                      
MFA-TR*       CUSTOMER_TYPE,                                                    
MFA-TR*       CUSTOMER_NAME,                                                    
MFA-TR*       NAME_FORMAT,                                                      
MFA-TR*       SSN,                                                              
MFA-TR*       ITIN,                                                             
MFA-TR*       OTHER_ID,                                                         
MFA-TR*       OTHER_ID_TYPE,                                                    
MFA-TR*       DLN,                                                              
MFA-TR*       DLN_STATE,                                                        
MFA-TR*       DOB,                                                              
MFA-TR*       EMPLOYER,                                                         
MFA-TR*       EMAIL_ADDRESS,                                                    
MFA-TR*       TAX_ID,                                                           
MFA-TR*       SBU_CD,                                                           
MFA-TR*       FIRST_NAME,                                                       
MFA-TR*       MIDDLE_NAME,                                                      
MFA-TR*       LAST_NAME,                                                        
MFA-TR*       EMAIL_MKT_FL,                                                     
MFA-TR*       EMAIL_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-CUSTOMER-NO,                                                  
MFA-TR*        :S-CUSTOMER-TYPE,                                                
MFA-TR*        :S-CUSTOMER-NAME,                                                
MFA-TR*        :S-NAME-FORMAT,                                                  
MFA-TR*        :S-SSN,                                                          
MFA-TR*        :S-ITIN,                                                         
MFA-TR*        :S-OTHER-ID,                                                     
MFA-TR*        :S-OTHER-ID-TYPE,                                                
MFA-TR*        :S-DLN,                                                          
MFA-TR*        :S-DLN-STATE,                                                    
MFA-TR*        :S-DOB,                                                          
MFA-TR*        :S-EMPLOYER,                                                     
MFA-TR*        :S-EMAIL-ADDRESS,                                                
MFA-TR*        :S-TAX-ID,                                                       
MFA-TR*        :S-SBU-CD,                                                       
MFA-TR*        :S-FIRST-NAME,                                                   
MFA-TR*        :S-MIDDLE-NAME,                                                  
MFA-TR*        :S-LAST-NAME,                                                    
MFA-TR*        :S-EMAIL-MKT-FL,                                                 
MFA-TR*        :S-EMAIL-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04808_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04808_R2                            
             (                                                          
              RETURN_CODE,                                              
              PHONE_NAME_TYPE,                                          
              PHONE_TYPE,                                               
              PHONE_NO,                                                 
              PHONE_EXT,                                                
              PHONE_MOBILE_FL,                                          
              PHONE_MKT_FL,                                             
              PHONE_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-PHONE-NAME-TYPE,                                      
               :S-PHONE-TYPE,                                           
               :S-PHONE-NO,                                             
               :S-PHONE-EXT,                                            
               :S-PHONE-MOBILE-FL,                                      
               :S-PHONE-MKT-FL,                                         
               :S-PHONE-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04808_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PHONE_NAME_TYPE,                                                  
MFA-TR*       PHONE_TYPE,                                                       
MFA-TR*       PHONE_NO,                                                         
MFA-TR*       PHONE_EXT,                                                        
MFA-TR*       PHONE_MOBILE_FL,                                                  
MFA-TR*       PHONE_MKT_FL,                                                     
MFA-TR*       PHONE_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-PHONE-NAME-TYPE,                                              
MFA-TR*        :S-PHONE-TYPE,                                                   
MFA-TR*        :S-PHONE-NO,                                                     
MFA-TR*        :S-PHONE-EXT,                                                    
MFA-TR*        :S-PHONE-MOBILE-FL,                                              
MFA-TR*        :S-PHONE-MKT-FL,                                                 
MFA-TR*        :S-PHONE-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04808_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           EXEC SQL                                                     
               UPDATE #CSR04808_R1                               
                  SET RETURN_CODE = :S-RETURN-CODE-1                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE SESSION.CSR04808_R1                                       
MFA-TR*           SET RETURN_CODE = :S-RETURN-CODE-1                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
