       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04807.                                          
COB303 DATE-WRITTEN. DECEMBER 30, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS ACCOUNT SUMMARY DATA FOR THE WEB.       *        
      *  IF ANY ACCOUNT LOGIC IS CHANGED, CHECK CSR04806 (ACCOUNT      *        
      *  LISTING) TO SEE IF IT SHOULD CHANGE.                          *        
      *  RESULTS SETS:                                                 *        
      *     1.  ACCOUNT INFO                                           *        
      *     2.  MESSAGES                                               *        
      *     3.  BILL INSERTS                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/30/14    FMB      NEW PROGRAM.                                      
A05317*  08/30/16    FMB      REMOVE UNUSED CODE.                               
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04807'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04807 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBEBLINS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPDBKDF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWQCAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRBLDL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRARNG                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRARSC                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRARHS                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSTASUM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCORHDR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCORCOM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBUSDAY                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
           COPY CWS0068L.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00068                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00375                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00309                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00322                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04807_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1      PIC S9(09) COMP VALUE 0.         
               10 S-STATUS-CODE        PIC S9(09) COMP VALUE 0.         
               10 S-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.      
               10 S-LAST-PYMT-DT       PIC X(10) VALUE SPACES.          
               10 S-LAST-PYMT-AMT      PIC S9(09)V99 COMP-3 VALUE 0.    
               10 S-TOWN               PIC X(30) VALUE SPACES.          
               10 S-SERVICE-ADDRESS    PIC X(80) VALUE SPACES.          
               10 S-ACCOUNT-ID         PIC X(35) VALUE SPACES.          
               10 S-TOTAL-AR-BALANCE   PIC S9(11)V9(02) COMP-3 VALUE 0. 
               10 S-MST-SUB-ACCT-IND   PIC X(01) VALUE SPACES.          
               10 S-DUE-DT             PIC X(10) VALUE SPACES.          
               10 S-ACCOUNT-TYPE-CODE  PIC X(01) VALUE SPACES.          
               10 S-CODE-ACCT-STAT     PIC X(01) VALUE SPACES.          
               10 S-DBA-NAME           PIC X(70) VALUE SPACES.          
               10 S-COMPANY-NO         PIC X(02) VALUE SPACES.          
               10 S-REG-GROUP-CD       PIC X(03) VALUE SPACES.          
               10 S-STREET-NAME        PIC X(30) VALUE SPACES.          
               10 S-HOUSE-NO           PIC X(15) VALUE SPACES.          
               10 S-PYMT-SCHED-DT      PIC X(10) VALUE SPACES.          
               10 S-PYMT-METHOD        PIC X(10) VALUE SPACES.          
               10 S-OUTAGE-FL          PIC X(01) VALUE SPACES.          
               10 S-ARREARS-AMT        PIC S9(11)V9(02) COMP-3 VALUE 0. 
               10 S-PYMT-SCHED-AMT     PIC S9(11)V9(02) COMP-3 VALUE 0. 
               10 S-STA-REM-AMT        PIC S9(11)V9(02) COMP-3 VALUE 0. 
               10 S-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.      
               10 S-WQ-FOUND-FL        PIC X(01) VALUE SPACES.          
               10 S-CUSTOMER-NAME      PIC X(80) VALUE SPACES.          
               10 S-STA-ELIGIBLE-FL    PIC X(01) VALUE SPACES.          
               10 S-CREDIT-GROUP       PIC X(01) VALUE SPACES.          
               10 S-ELEC-UTIL-FL       PIC X(01) VALUE SPACES.          
               10 S-GAS-UTIL-FL        PIC X(01) VALUE SPACES.          
               10 S-SOLAR-UTIL-FL      PIC X(01) VALUE SPACES.          
               10 S-LIGHTING-FL        PIC X(01) VALUE SPACES.          
               10 S-ZIP-CODE           PIC X(05) VALUE SPACES.          
               10 S-NO-BILL-COPIES     PIC S9(04) COMP VALUE 0.         
               10 S-ACCT-CREATE-DT     PIC X(10) VALUE SPACES.          
               10 S-DURATION-REM-MO    PIC S9(04) COMP VALUE 0.         
               10 S-BILL-NOTIFICATION  PIC X(01) VALUE SPACES.          
               10 S-ROR-DT             PIC X(10) VALUE SPACES.          
               10 S-SEB-UTIL-TYPE      PIC X(01) VALUE SPACES.          
               10 S-SEB-IC-NO          PIC S9(04) COMP VALUE 0.         
               10 S-SEB-OPTION-CD      PIC X(12) VALUE SPACES.          
               10 S-SEB-RENEWAL-FL     PIC X(01) VALUE SPACES.          
               10 S-STATEMENT-DT       PIC X(10) VALUE SPACES.          
               10 S-PREMISE-NO         PIC S9(10)V COMP-3 VALUE 0.      
               10 S-CITY               PIC X(26) VALUE SPACES.          
               10 S-STATE              PIC X(02) VALUE SPACES.          
               10 S-SENIOR-RATE-FL     PIC X(01) VALUE SPACES.          
               10 S-TIER-ACCT-TYPE     PIC X(01) VALUE SPACES.          
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2      PIC S9(09) COMP VALUE 0.         
               10 S-BUS-RULE-MSG-ID    PIC X(10) VALUE SPACES.          
               10 S-RULE-RESULT-CD     PIC X(10) VALUE SPACES.          
               10 S-BUS-RULE-XREF-ID   PIC X(26) VALUE SPACES.          
               10 S-MESSAGE-PARMS      PIC X(200) VALUE SPACES.         
               10 S-LINK-PARMS         PIC X(200) VALUE SPACES.         
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3      PIC S9(09) COMP VALUE 0.         
               10 S-BILL-CYCLE         PIC X(02) VALUE SPACES.          
               10 S-DATE-BILLED        PIC X(10) VALUE SPACES.          
               10 S-INSERT-FLAGS       PIC X(10) VALUE SPACES.          
               10 S-REVENUE-MONTH      PIC X(06) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04807'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(04) COMP VALUE +0.       
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.        
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-CPD310-NULL-IND       PIC S9(04) COMP.                
           05  WS-NULL-IND-CPD          PIC S9(04) COMP.                
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.         
           05  WS-CUST-NAME             PIC X(76) VALUE SPACES.         
           05  WS-TOWN                  PIC X(30) VALUE SPACES.         
           05  WS-WOFF-DT-01            PIC X(10) VALUE SPACES.         
           05  WS-WOFF-DT-26            PIC X(10) VALUE SPACES.         
           05  WS-WOFF-DT               PIC X(10) VALUE SPACES.         
           05  WS-WOFF-YEARS            PIC S9(09)V COMP-3 VALUE 0.     
           05  WS-COMP-NO               PIC X(10) VALUE SPACES.         
           05  WS-NEXT-READ-DT          PIC X(10) VALUE SPACES.         
           05  WS-NOTICE-DT             PIC X(10) VALUE SPACES.         
           05  WS-FMT-DT.                                               
               10  WS-FMT-MM            PIC X(03) VALUE SPACES.         
               10  F                    PIC X(01) VALUE SPACES.         
               10  WS-FMT-DD            PIC Z9    VALUE ZEROES.         
               10  F                    PIC X(02) VALUE ', '.           
               10  WS-FMT-YY            PIC X(04) VALUE SPACES.         
           05  WS-STATEMENT-DT          PIC X(10) VALUE SPACES.         
           05  WS-SCEG-FL               PIC X(01) VALUE 'N'.            
           05  WS-PSNC-FL               PIC X(01) VALUE 'N'.            
           05  WS-UT-FL                 PIC X(01) VALUE 'N'.            
           05  WS-RULE-XREF-ID          PIC X(26) VALUE SPACES.         
           05  WS-RULE-MSG-ID           PIC X(10) VALUE SPACES.         
           05  WS-RULE-ID               PIC X(10) VALUE SPACES.         
           05  WS-RULE-RESULT           PIC X(10) VALUE SPACES.         
           05  WS-FORMAT-AMT            PIC $$$,$$$,$$$.99.             
           05  WS-DATE-MINUS-30-DAYS    PIC X(10) VALUE SPACES.         
           05  WS-DATE-MINUS-45-DAYS    PIC X(10) VALUE SPACES.         
           05  SW-FETCH                 PIC X(01) VALUE 'Y'.            
               88 NO-MORE-ROWS                    VALUE 'N'.            
               88 MORE-ROWS                       VALUE 'Y'.            
           05  WS-MESSAGE-PARMS.                                        
               10 WS-MESSAGE-PARMS-LEN  PIC S9(04) COMP.                
               10 WS-MESSAGE-PARMS-TEXT PIC X(300).                     
           05  WS-IC-NO-NUM             PIC 9(04) VALUE ZEROES.         
           05  WS-IC-NO-CHAR            REDEFINES WS-IC-NO-NUM          
                                        PIC X(04).                      
                                                                        
       01  WS-TABLES.                                                   
           05  T2-RULES               OCCURS 300                        
                                      INDEXED BY T2-INDEX.              
               10  T2-RULE-ID         PIC X(10).                        
               10  T2-RULE-MSG-ID     PIC X(10).                        
               10  T2-RULE-XREF-ID    PIC X(26).                        
               10  T2-COMPANY-NO      PIC X(02).                        
               10  T2-RULE-RESULT-CD  PIC X(10).                        
                                                                        
       01  CSR04099-CALL-DATA.                                          
           03  OPTION-CD-4099           PIC X(12) VALUE SPACES.         
           03  ACCOUNT-NO-4099          PIC X(13) VALUE SPACES.         
           03  CODE-UTIL-TYPE-4099      PIC X(01) VALUE SPACES.         
           03  IC-NO-4099               PIC X(04) VALUE SPACES.         
           03  THERM-CSC-ACCT-FL-4099   PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04099-RETURN-DATA-A.                                      
           03  RETURN-CODE-4099-A       PIC S9(09) COMP VALUE 0.        
           03  THERM-PRICE-4099         PIC S9(05)V9(06) COMP-3 VALUE 0.
           03  OPTN-VALID-MNTHS-4099    PIC S9(04) COMP VALUE 0.        
           03  PRIM-FACTOR-ID-4099      PIC X(09) VALUE SPACES.         
           03  CORE-RATE-PLAN-NO-4099   PIC X(03) VALUE SPACES.         
           03  RATE-CALC-TYPE-CD-4099   PIC X(02) VALUE SPACES.         
           03  CSC-AMT-4099             PIC S9(05)V9(06) COMP-3 VALUE 0.
           03  CSC-REFND-FL-4099        PIC X(01) VALUE SPACES.         
           03  CSC-MNTHS-4099           PIC S9(04) COMP VALUE 0.        
           03  DURATION-REM-MO-4099     PIC S9(04) COMP VALUE 0.        
           03  TIER-ACCT-TYPE-CD-4099   PIC X(01) VALUE SPACES.         
           03  WEB-RENEWAL-FL-4099      PIC X(01) VALUE SPACES.         
           03  RATE-DEFINITION-CD-4099  PIC X(01) VALUE SPACES.         
           03  CURR-EXT-DESC-LONG-4099  PIC X(255) VALUE SPACES.        
           03  PEND-OPT-EXISTS-FL-4099  PIC X(01) VALUE SPACES.         
           03  SHOW-RENEWAL-OPT-4099    PIC X(01) VALUE SPACES.         
           03  PEND-EXT-DESC-LONG-4099  PIC X(255) VALUE SPACES.        
           03  ADJUSTABLE-FL-4099       PIC X(01) VALUE SPACES.         
           03  CURRENT-THERM-PRICE-4099 PIC S9(05)V9(06) COMP-3 VALUE 0.
           03  CURR-OPT-EFF-DATE-4099   PIC X(10) VALUE SPACES.         
           03  PEND-OPT-EFF-DATE-4099   PIC X(10) VALUE SPACES.         
           03  SENIOR-RATE-FL-4099      PIC X(01) VALUE SPACES.         
           03  IS-CURR-OPTN-FLEX-4099   PIC X(01) VALUE SPACES.         
           03  CORE-RATE-PLAN-DDDC-4099 PIC S9(03)V99 COMP-3 VALUE 0.   
           03  PRINT-SR-DSC-MSG-CD-4099 PIC X(02) VALUE SPACES.         
           03  CURR-OPT-ROR-END-DT-4099 PIC X(10) VALUE SPACES.         
           03  CUSTOMER-DOB-4099        PIC X(10) VALUE SPACES.         
           03  SENIOR-BY-DOB-FL-4099    PIC X(01) VALUE SPACES.         
           03  TIER-CUST-STAT-CD-4099   PIC X(01) VALUE SPACES.         
           03  CODE-REVENUE-CLASS-4099  PIC X(01) VALUE SPACES.         
           03  SPCL-OFFER-TYPE-CD-4099  PIC X(02) VALUE SPACES.         
                                                                        
       01  CSR04099-RETURN-DATA-B.                                      
           03  RETURN-CODE-4099-B       PIC S9(09) COMP VALUE 0.        
           03  BUS-RULE-MSG-ID-4099     PIC X(10) VALUE SPACES.         
           03  RULE-RESULT-CD-4099      PIC X(10) VALUE SPACES.         
           03  BUS-RULE-XREF-ID-4099    PIC X(26) VALUE SPACES.         
           03  MESSAGE-PARMS-4099       PIC X(300) VALUE SPACES.        
           03  LINK-PARMS-4099          PIC X(200) VALUE SPACES.        
                                                                        
       01  DYNAMIC-CALLS.                                               
           05  WS-MCSCB068             PIC X(08) VALUE 'MCSCB068'.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(09) COMP VALUE 0.        
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC4099A USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4099B USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
                                                                        
           EXEC SQL                                                     
              DECLARE RULE-CURSOR CURSOR FOR                            
               SELECT BUS_RULE_ID,                                      
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1T].BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID,                              
                      COMPANY_NO,                                       
                      RULE_MESSAGE_ID,                                  
                      RULE_RESULT_CD                                    
                 FROM CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED),             
                      CSS_BUS_RULE_ACTN [1S] WITH(READUNCOMMITTED)              
                WHERE [1S].BUS_RULE_XREF_ID = [1T].BUS_RULE_XREF_ID         
                  AND APPLICATION_ID = 'WEB'                            
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RULE-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT BUS_RULE_ID,                                              
MFA-TR*               1T.BUS_RULE_XREF_ID,                                      
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               RULE_MESSAGE_ID,                                          
MFA-TR*               RULE_RESULT_CD                                            
MFA-TR*          FROM CSS_BUS_RULE_XREF 1T,                                     
MFA-TR*               CSS_BUS_RULE_ACTN 1S                                      
MFA-TR*         WHERE 1S.BUS_RULE_XREF_ID = 1T.BUS_RULE_XREF_ID                 
MFA-TR*           AND APPLICATION_ID = 'WEB'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-ACCOUNT-NO        AS ACCOUNT_NO,               
                      :S-LAST-PYMT-DT      AS LAST_PYMT_DT,             
                      :S-LAST-PYMT-AMT     AS LAST_PYMT_AMT,            
                      :S-TOWN              AS TOWN,                     
                      :S-SERVICE-ADDRESS   AS SERVICE_ADDRESS,          
                      :S-ACCOUNT-ID        AS ACCOUNT_ID,               
                      :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,         
                      :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,         
                      :S-DUE-DT            AS DUE_DT,                   
                      :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,        
                      :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,           
                      :S-DBA-NAME          AS DBA_NAME,                 
                      :S-COMPANY-NO        AS COMPANY_NO,               
                      :S-REG-GROUP-CD      AS REG_GROUP_CD,             
                      :S-STREET-NAME       AS STREET_NAME,              
                      :S-HOUSE-NO          AS HOUSE_NO,                 
                      :S-PYMT-SCHED-DT     AS PYMT_SCHED_DT,            
                      :S-PYMT-METHOD       AS PYMT_METHOD,              
                      :S-OUTAGE-FL         AS OUTAGE_FL,                
                      :S-ARREARS-AMT       AS ARREARS_AMT,              
                      :S-PYMT-SCHED-AMT    AS PYMT_SCHED_AMT,           
                      :S-STA-REM-AMT       AS STA_REM_AMT,              
                      :S-MST-ACCT-NO       AS MST_ACCT_NO,              
                      :S-WQ-FOUND-FL       AS WQ_FOUND_FL,              
                      :S-CUSTOMER-NAME     AS CUSTOMER_NAME,            
                      :S-STA-ELIGIBLE-FL   AS STA_ELIGIBLE_FL,          
                      :S-CREDIT-GROUP      AS CREDIT_GROUP,             
                      :S-ELEC-UTIL-FL      AS ELEC_UTIL_FL,             
                      :S-GAS-UTIL-FL       AS GAS_UTIL_FL,              
                      :S-SOLAR-UTIL-FL     AS SOLAR_UTIL_FL,            
                      :S-LIGHTING-FL       AS LIGHTING_FL,              
                      :S-ZIP-CODE          AS ZIP_CODE,                 
                      :S-NO-BILL-COPIES    AS NO_BILL_COPIES,           
                      :S-ACCT-CREATE-DT    AS ACCT_CREATE_DT,           
                      :S-DURATION-REM-MO   AS DURATION_REM_MO,          
                      :S-BILL-NOTIFICATION AS BILL_NOTIFICATION,        
                      :S-ROR-DT            AS RIGHT_OF_RESCISSION_DT,   
                      :S-SEB-UTIL-TYPE     AS SEB_UTIL_TYPE,            
                      :S-SEB-IC-NO         AS SEB_IC_NO,                
                      :S-SEB-OPTION-CD     AS SEB_OPTION_CD,            
                      :S-SEB-RENEWAL-FL    AS SEB_RENEWAL_FL,           
                      :S-STATEMENT-DT      AS STATEMENT_DT,             
                      :S-PREMISE-NO        AS PREMISE_NO,               
                      :S-CITY              AS CITY,                     
                      :S-STATE             AS STATE,                    
                      :S-SENIOR-RATE-FL    AS SENIOR_RATE_FL,           
                      :S-TIER-ACCT-TYPE    AS TIER_ACCT_TYPE            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-ACCOUNT-NO        AS ACCOUNT_NO,                       
MFA-TR*               :S-LAST-PYMT-DT      AS LAST_PYMT_DT,                     
MFA-TR*               :S-LAST-PYMT-AMT     AS LAST_PYMT_AMT,                    
MFA-TR*               :S-TOWN              AS TOWN,                             
MFA-TR*               :S-SERVICE-ADDRESS   AS SERVICE_ADDRESS,                  
MFA-TR*               :S-ACCOUNT-ID        AS ACCOUNT_ID,                       
MFA-TR*               :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,                 
MFA-TR*               :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,                 
MFA-TR*               :S-DUE-DT            AS DUE_DT,                           
MFA-TR*               :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,                
MFA-TR*               :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,                   
MFA-TR*               :S-DBA-NAME          AS DBA_NAME,                         
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO,                       
MFA-TR*               :S-REG-GROUP-CD      AS REG_GROUP_CD,                     
MFA-TR*               :S-STREET-NAME       AS STREET_NAME,                      
MFA-TR*               :S-HOUSE-NO          AS HOUSE_NO,                         
MFA-TR*               :S-PYMT-SCHED-DT     AS PYMT_SCHED_DT,                    
MFA-TR*               :S-PYMT-METHOD       AS PYMT_METHOD,                      
MFA-TR*               :S-OUTAGE-FL         AS OUTAGE_FL,                        
MFA-TR*               :S-ARREARS-AMT       AS ARREARS_AMT,                      
MFA-TR*               :S-PYMT-SCHED-AMT    AS PYMT_SCHED_AMT,                   
MFA-TR*               :S-STA-REM-AMT       AS STA_REM_AMT,                      
MFA-TR*               :S-MST-ACCT-NO       AS MST_ACCT_NO,                      
MFA-TR*               :S-WQ-FOUND-FL       AS WQ_FOUND_FL,                      
MFA-TR*               :S-CUSTOMER-NAME     AS CUSTOMER_NAME,                    
MFA-TR*               :S-STA-ELIGIBLE-FL   AS STA_ELIGIBLE_FL,                  
MFA-TR*               :S-CREDIT-GROUP      AS CREDIT_GROUP,                     
MFA-TR*               :S-ELEC-UTIL-FL      AS ELEC_UTIL_FL,                     
MFA-TR*               :S-GAS-UTIL-FL       AS GAS_UTIL_FL,                      
MFA-TR*               :S-SOLAR-UTIL-FL     AS SOLAR_UTIL_FL,                    
MFA-TR*               :S-LIGHTING-FL       AS LIGHTING_FL,                      
MFA-TR*               :S-ZIP-CODE          AS ZIP_CODE,                         
MFA-TR*               :S-NO-BILL-COPIES    AS NO_BILL_COPIES,                   
MFA-TR*               :S-ACCT-CREATE-DT    AS ACCT_CREATE_DT,                   
MFA-TR*               :S-DURATION-REM-MO   AS DURATION_REM_MO,                  
MFA-TR*               :S-BILL-NOTIFICATION AS BILL_NOTIFICATION,                
MFA-TR*               :S-ROR-DT            AS RIGHT_OF_RESCISSION_DT,           
MFA-TR*               :S-SEB-UTIL-TYPE     AS SEB_UTIL_TYPE,                    
MFA-TR*               :S-SEB-IC-NO         AS SEB_IC_NO,                        
MFA-TR*               :S-SEB-OPTION-CD     AS SEB_OPTION_CD,                    
MFA-TR*               :S-SEB-RENEWAL-FL    AS SEB_RENEWAL_FL,                   
MFA-TR*               :S-STATEMENT-DT      AS STATEMENT_DT,                     
MFA-TR*               :S-PREMISE-NO        AS PREMISE_NO,                       
MFA-TR*               :S-CITY              AS CITY,                             
MFA-TR*               :S-STATE             AS STATE,                            
MFA-TR*               :S-SENIOR-RATE-FL    AS SENIOR_RATE_FL,                   
MFA-TR*               :S-TIER-ACCT-TYPE    AS TIER_ACCT_TYPE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING  FOR
               SELECT RETURN_CODE        AS RETURN_CODE,                
                      BUS_RULE_MSG_ID    AS BUS_RULE_MSG_ID,            
                      RULE_RESULT_CD     AS RULE_RESULT_CD,             
                      BUS_RULE_XREF_ID   AS BUS_RULE_XREF_ID,           
                      MESSAGE_PARMS      AS MESSAGE_PARM,               
                      LINK_PARMS         AS LINK_PARMS                  
                 FROM #CSR04807_R2                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING  FOR        
MFA-TR*        SELECT RETURN_CODE        AS RETURN_CODE,                        
MFA-TR*               BUS_RULE_MSG_ID    AS BUS_RULE_MSG_ID,                    
MFA-TR*               RULE_RESULT_CD     AS RULE_RESULT_CD,                     
MFA-TR*               BUS_RULE_XREF_ID   AS BUS_RULE_XREF_ID,                   
MFA-TR*               MESSAGE_PARMS      AS MESSAGE_PARM,                       
MFA-TR*               LINK_PARMS         AS LINK_PARMS                          
MFA-TR*          FROM SESSION.CSR04807_R2                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2      AS RETURN_CODE,             
                      :S-BUS-RULE-MSG-ID    AS BUS_RULE_MSG_ID,         
                      :S-RULE-RESULT-CD     AS RULE_RESULT_CD,          
                      :S-BUS-RULE-XREF-ID   AS BUS_RULE_XREF_ID,        
                      :S-MESSAGE-PARMS      AS MESSAGE_PARMS,           
                      :S-LINK-PARMS         AS LINK_PARMS               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2      AS RETURN_CODE,                     
MFA-TR*               :S-BUS-RULE-MSG-ID    AS BUS_RULE_MSG_ID,                 
MFA-TR*               :S-RULE-RESULT-CD     AS RULE_RESULT_CD,                  
MFA-TR*               :S-BUS-RULE-XREF-ID   AS BUS_RULE_XREF_ID,                
MFA-TR*               :S-MESSAGE-PARMS      AS MESSAGE_PARMS,                   
MFA-TR*               :S-LINK-PARMS         AS LINK_PARMS                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3      AS RETURN_CODE,             
                      :S-BILL-CYCLE         AS BILL_CYCLE,              
                      :S-DATE-BILLED        AS DATE_BILLED,             
                      :S-INSERT-FLAGS       AS INSERT_FLAGS,            
                      :S-REVENUE-MONTH      AS REVENUE_MONTH            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3      AS RETURN_CODE,                     
MFA-TR*               :S-BILL-CYCLE         AS BILL_CYCLE,                      
MFA-TR*               :S-DATE-BILLED        AS DATE_BILLED,                     
MFA-TR*               :S-INSERT-FLAGS       AS INSERT_FLAGS,                    
MFA-TR*               :S-REVENUE-MONTH      AS REVENUE_MONTH                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_1 CURSOR
MSQ001          FOR CALL CSR04099                                             
                  ( :OPTION-CD-4099
                  , :ACCOUNT-NO-4099
                  , :CODE-UTIL-TYPE-4099
                  , :IC-NO-4099
                  , :THERM-CSC-ACCT-FL-4099
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-CONTACT-ID         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO                               
                          LINK-CONTACT-ID.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -30, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-30-DAYS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 30 DAYS)                       
MFA-TR*          INTO :WS-DATE-MINUS-30-DAYS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -45, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-45-DAYS                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 45 DAYS)                       
MFA-TR*          INTO :WS-DATE-MINUS-45-DAYS                                    
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04807_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04807_R2
              (                                                          
               RETURN_CODE          INT,                            
               BUS_RULE_MSG_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               RULE_RESULT_CD CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MESSAGE_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2,        
               LINK_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT02-ROWS THRU 8002-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04807_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-CONTACT-ID NOT NUMERIC                               
               MOVE ZEROES TO LINK-CONTACT-ID
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7020-GET-DELINQUENCY-VALUES THRU 7020-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           PERFORM 7050-OPEN-RULE-CURSOR THRU 7050-EXIT.                
           SET T2-INDEX TO 1.                                           
           PERFORM 1010-FETCH-ROWS THRU 1010-EXIT.                      
           PERFORM 7051-CLOSE-RULE-CURSOR THRU 7051-EXIT.               
                                                                        
           IF CSR-DATABASE                                              
               MOVE '01' TO C8-COMPANY-NO                               
               PERFORM 7110-WRITE-OFF-CUTOFF THRU 7110-EXIT             
               MOVE WS-WOFF-DT TO WS-WOFF-DT-01                         
               MOVE '26' TO C8-COMPANY-NO                               
               PERFORM 7110-WRITE-OFF-CUTOFF THRU 7110-EXIT             
               MOVE WS-WOFF-DT TO WS-WOFF-DT-26
           END-IF.                        
                                                                        
           IF LINK-ACCOUNT-NO = ZEROES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ZERO PARM' TO S-LAST-PYMT-DT                       
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1010-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH RULE-CURSOR                                        
                INTO :1T-BUS-RULE-ID,                                   
                     :1T-BUS-RULE-XREF-ID,                              
                     :1T-COMPANY-NO,                                    
                     :1S-RULE-MESSAGE-ID,                               
                     :1S-RULE-RESULT-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 1010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '1010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_RULE_XREF'  TO TABLE-1                 
                   MOVE 'CSS_BUS_RULE_ACTN'  TO TABLE-2                 
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE 1T-BUS-RULE-ID TO T2-RULE-ID (T2-INDEX).                
           MOVE 1T-BUS-RULE-XREF-ID TO T2-RULE-XREF-ID (T2-INDEX).      
           MOVE 1T-COMPANY-NO TO T2-COMPANY-NO (T2-INDEX).              
           MOVE 1S-RULE-MESSAGE-ID TO T2-RULE-MSG-ID (T2-INDEX).        
           MOVE 1S-RULE-RESULT-CD TO T2-RULE-RESULT-CD (T2-INDEX).      
           SET T2-INDEX UP BY 1.                                        
                                                                        
           GO TO 1010-FETCH-ROWS.                                       
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7100-SELECT-STATS THRU 7100-EXIT.                    
           MOVE AT-ACCOUNT-NO TO TA-ACCOUNT-NO.                         
           PERFORM 7090-ACCT-MISC-INFO THRU 7090-EXIT.                  
           PERFORM 7130-SELECT-DBA THRU 7130-EXIT.                      
           IF AT-MST-SUB-ACCT-IND = 'M' AND                             
              AT-ADDRESS-ID > 0                                         
                  EVALUATE AT-ADDRESS-FORMAT                            
                      WHEN 'A'                                          
                          PERFORM 7190-FMT-BILL-ADDR THRU 7190-EXIT     
                      WHEN 'B'                                          
                          PERFORM 7200-FRE-BILL-ADDR THRU 7200-EXIT     
                  END-EVALUATE
           END-IF.                                         
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               PERFORM 7250-MST-SUB THRU 7250-EXIT
           END-IF.                     
           PERFORM 7030-BILL-STATEMENT THRU 7030-EXIT.                  
           IF AT-CODE-ACCT-STAT = 'A'                                   
               PERFORM 7070-CORRESP-HDR THRU 7070-EXIT
           END-IF.                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           ADD 1 TO CTR-ROWS.                                           
           MOVE AT-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE AT-LAST-PYMT-DATE TO S-LAST-PYMT-DT.                    
           MOVE AT-LAST-PYMT-AMOUNT TO S-LAST-PYMT-AMT.                 
           MOVE AT-PREMISE-NO TO S-PREMISE-NO.                          
           MOVE A4-TOWN TO S-CITY.                                      
           MOVE A4-STATE TO S-STATE.                                    
           IF AT-CODE-ACCT-STAT = 'A'                                   
               PERFORM 5901-NEXT-READ-DATE                              
                  THRU 5901-NEXT-READ-DATE-EXIT                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   IF RW-THIRD-PTY-READ-DT > SPACES                     
                      MOVE RW-THIRD-PTY-READ-DT TO WS-NEXT-READ-DT      
                   ELSE                                                 
                      MOVE RW-OPTIMUM-READ-DATE TO WS-NEXT-READ-DT
                   END-IF
               END-IF
           END-IF.     
                                                                        
           MOVE WS-TOWN TO S-TOWN.                                      
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE WS-ADDRESS-LINE-I TO S-SERVICE-ADDRESS              
           ELSE                                                         
               MOVE WS-ADDRESS-LINE TO S-SERVICE-ADDRESS
           END-IF.               
           MOVE TA-SPCL-BILL-STMNT-TX TO S-ACCOUNT-ID.                  
           IF AT-CODE-ACCT-STAT = 'S'                                   
               IF CSR-DATABASE                                          
                   EVALUATE AT-COMPANY-NO                               
                       WHEN '01'                                        
                           MOVE WS-WOFF-DT-01 TO WS-WOFF-DT             
                       WHEN '26'                                        
                           MOVE WS-WOFF-DT-26 TO WS-WOFF-DT             
                   END-EVALUATE                                         
               ELSE                                                     
                   MOVE '1900-01-01' TO WS-WOFF-DT
               END-IF
           END-IF.                     
           MOVE AT-MST-SUB-ACCT-IND TO S-MST-SUB-ACCT-IND.              
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               MOVE MU-MST-ACCT-NO TO S-MST-ACCT-NO
           END-IF.                    
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE AT-CODE-ACCT-STAT TO S-CODE-ACCT-STAT.                  
           MOVE DQ-FULL-NAME TO S-DBA-NAME.                             
           MOVE AT-COMPANY-NO TO S-COMPANY-NO.                          
           IF CSR-DATABASE                                              
               EVALUATE AT-COMPANY-NO                                   
                   WHEN '01'                                            
                       MOVE 'Y' TO WS-SCEG-FL                           
                   WHEN '26'                                            
                       MOVE 'Y' TO WS-PSNC-FL                           
               END-EVALUATE
           END-IF.                                            
           MOVE DY-STREET-NAME TO S-STREET-NAME.                        
           MOVE DY-HOUSE-NO TO S-HOUSE-NO.                              
                                                                        
           PERFORM 6000-GET-ACCT-DATA THRU 6000-GET-ACCT-DATA-EXIT.     
                                                                        
           MOVE WS-DISPLAY-DUE-DATE TO S-DUE-DT.                        
           MOVE WS-BILLED-BALANCE TO S-TOTAL-AR-BALANCE.                
           MOVE WS-ARREARS-AMOUNT TO S-ARREARS-AMT.                     
           MOVE WS-BILL-EXCPN-WQ-FL TO S-WQ-FOUND-FL.                   
                                                                        
           MOVE WS-CUST-NAME TO S-CUSTOMER-NAME.                        
           MOVE AT-CREDIT-GROUP TO S-CREDIT-GROUP.                      
           MOVE DY-ZIP-CODE TO S-ZIP-CODE.                              
           MOVE AT-NO-BILL-COPIES TO S-NO-BILL-COPIES.                  
           MOVE AT-ACCT-CREATE-DT(1:10) TO S-ACCT-CREATE-DT.            
                                                                        
           IF SEB-DATABASE                                              
               PERFORM 7040-UTIL-ENVRNMT THRU 7040-EXIT                 
               MOVE UT-CODE-UTIL-TYPE TO S-SEB-UTIL-TYPE                
               MOVE UT-IC-NO TO WS-IC-NO-NUM                            
                                S-SEB-IC-NO                             
               PERFORM 7300-SELECT-PKG-OPTION THRU 7300-EXIT            
               MOVE DF-OPTION-CD TO S-SEB-OPTION-CD                     
               PERFORM 7140-REG-PROFILE THRU 7140-EXIT                  
               MOVE LR-REG-GROUP-CD TO S-REG-GROUP-CD
           END-IF.                  
                                                                        
           MOVE 'N' TO S-ELEC-UTIL-FL                                   
                       S-GAS-UTIL-FL                                    
                       S-SOLAR-UTIL-FL                                  
                       S-LIGHTING-FL.                                   
           MOVE 'G' TO UT-CODE-UTIL-TYPE.                               
           PERFORM 7280-UTILITIES THRU 7280-EXIT.                       
           IF CSR-DATABASE                                              
               MOVE 'E' TO UT-CODE-UTIL-TYPE                            
               PERFORM 7280-UTILITIES THRU 7280-EXIT                    
               MOVE 'U' TO UT-CODE-UTIL-TYPE                            
               PERFORM 7280-UTILITIES THRU 7280-EXIT
           END-IF.                   
                                                                        
           IF CSR-DATABASE AND                                          
              AT-COMPANY-NO = '01' AND                                  
              AT-CODE-ACCT-STAT = 'A' AND                               
              S-ELEC-UTIL-FL = 'Y'                                      
                  MOVE 'Y' TO S-OUTAGE-FL                               
           ELSE                                                         
               MOVE 'N' TO S-OUTAGE-FL
           END-IF.                                 
           PERFORM 2010-BILL-NOTIFICATION THRU 2010-EXIT.               
           IF (AT-NO-BILL-COPIES = 0 OR                                 
               CE-EBILL-REGISTER-IND = 'Y') AND                         
               S-BILL-NOTIFICATION = '5'                                
                   MOVE '2' TO S-BILL-NOTIFICATION
           END-IF.                     
           MOVE WS-STATEMENT-DT TO S-STATEMENT-DT.                      
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           PERFORM 7060-EBILL-INSERTS THRU 7060-EXIT.                   
           MOVE IE-BILL-CYCLE TO S-BILL-CYCLE.                          
           MOVE IE-DATE-BILLED TO S-DATE-BILLED.                        
           MOVE IE-INSERT-FLAGS TO S-INSERT-FLAGS.                      
           MOVE IE-REVENUE-MONTH TO S-REVENUE-MONTH.                    
                                                                        
           PERFORM 4000-MESSAGES THRU 4000-EXIT.                        
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'NO DATA' TO S-LAST-PYMT-DT                         
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-BILL-NOTIFICATION.                                          
                                                                        
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX.                        
           PERFORM 7120-SELECT-ATTRIB THRU 7120-EXIT.                   
           IF YP-ATTRIBUTE-VALUE-CD = 'NO'                              
               MOVE '4' TO S-BILL-NOTIFICATION                          
           ELSE                                                         
               IF AT-NO-BILL-COPIES = 0                                 
                   MOVE '1' TO S-BILL-NOTIFICATION                      
               ELSE                                                     
                   IF AT-NO-BILL-COPIES > 0                             
                       MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC      
                       MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX             
                       PERFORM 7120-SELECT-ATTRIB THRU 7120-EXIT        
                       IF YP-ATTRIBUTE-VALUE-CD = 'YES'                 
                           MOVE '3' TO S-BILL-NOTIFICATION              
                       ELSE                                             
                           MOVE '5' TO S-BILL-NOTIFICATION
                       END-IF
                   END-IF
               END-IF
           END-IF.             
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4000-MESSAGES.                                                   
                                                                        
      * BILL STATEMENT                                                          
                                                                        
           IF WS-STATEMENT-DT > SPACES                                  
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE 0 TO S-RETURN-CODE-2                                
               MOVE 'WCM0000023' TO WS-RULE-ID                          
               MOVE '00' TO WS-COMP-NO                                  
               PERFORM 7345-RULE-XREF THRU 7345-EXIT                    
               MOVE WS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID               
               MOVE WS-RULE-MSG-ID TO S-BUS-RULE-MSG-ID                 
               MOVE WS-RULE-RESULT TO S-RULE-RESULT-CD                  
               MOVE WS-STATEMENT-DT(1:4) TO WS-FMT-YY                   
               MOVE WS-STATEMENT-DT(9:2) TO WS-FMT-DD                   
               EVALUATE WS-STATEMENT-DT(6:2)                            
                   WHEN '01'                                            
                       MOVE 'JAN' TO WS-FMT-MM                          
                   WHEN '02'                                            
                       MOVE 'FEB' TO WS-FMT-MM                          
                   WHEN '03'                                            
                       MOVE 'MAR' TO WS-FMT-MM                          
                   WHEN '04'                                            
                       MOVE 'APR' TO WS-FMT-MM                          
                   WHEN '05'                                            
                       MOVE 'MAY' TO WS-FMT-MM                          
                   WHEN '06'                                            
                       MOVE 'JUN' TO WS-FMT-MM                          
                   WHEN '07'                                            
                       MOVE 'JUL' TO WS-FMT-MM                          
                   WHEN '08'                                            
                       MOVE 'AUG' TO WS-FMT-MM                          
                   WHEN '09'                                            
                       MOVE 'SEP' TO WS-FMT-MM                          
                   WHEN '10'                                            
                       MOVE 'OCT' TO WS-FMT-MM                          
                   WHEN '11'                                            
                       MOVE 'NOV' TO WS-FMT-MM                          
                   WHEN '12'                                            
                       MOVE 'DEC' TO WS-FMT-MM                          
               END-EVALUATE                                             
               MOVE WS-FMT-DT TO S-MESSAGE-PARMS                        
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
      * DEPOSIT ON PENDING ACCOUNT                                              
                                                                        
           IF WS-DEPOSIT-AMT > ZEROES                                   
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE 0 TO S-RETURN-CODE-2                                
               MOVE 'WCM0000014' TO WS-RULE-ID                          
               MOVE '00' TO WS-COMP-NO                                  
               PERFORM 7345-RULE-XREF THRU 7345-EXIT                    
               MOVE WS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID               
               MOVE WS-RULE-MSG-ID TO S-BUS-RULE-MSG-ID                 
               MOVE WS-RULE-RESULT TO S-RULE-RESULT-CD                  
               MOVE WS-DEPOSIT-AMT TO WS-FORMAT-AMT                     
               MOVE WS-FORMAT-AMT  TO S-MESSAGE-PARMS                   
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
      * DNP SCHEDULED                                                           
                                                                        
           IF WS-375-DNP-FL = 'Y'                                       
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE 0 TO S-RETURN-CODE-2                                
               MOVE 'WCM0000013' TO WS-RULE-ID                          
               MOVE '00' TO WS-COMP-NO                                  
               PERFORM 7345-RULE-XREF THRU 7345-EXIT                    
               MOVE WS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID               
               MOVE WS-RULE-MSG-ID TO S-BUS-RULE-MSG-ID                 
               MOVE WS-RULE-RESULT TO S-RULE-RESULT-CD                  
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
      * NEXT METER READ DATE                                                    
                                                                        
           IF WS-NEXT-READ-DT > SPACES                                  
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE 0 TO S-RETURN-CODE-2                                
               IF CSR-DATABASE                                          
                   EVALUATE AT-COMPANY-NO                               
                       WHEN '01'                                        
                           MOVE 'WCM0000015' TO WS-RULE-ID              
                       WHEN '26'                                        
                           MOVE 'WCM0000025' TO WS-RULE-ID              
                   END-EVALUATE                                         
               ELSE                                                     
                   IF S-REG-GROUP-CD > SPACES                           
                       MOVE 'WCM0000027' TO WS-RULE-ID                  
                   ELSE                                                 
                       MOVE 'WCM0000026' TO WS-RULE-ID                  
                   END-IF                                               
               END-IF                                                   
               MOVE '00' TO WS-COMP-NO                                  
               PERFORM 7345-RULE-XREF THRU 7345-EXIT                    
               MOVE WS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID               
               MOVE WS-RULE-MSG-ID TO S-BUS-RULE-MSG-ID                 
               MOVE WS-RULE-RESULT TO S-RULE-RESULT-CD                  
               MOVE WS-NEXT-READ-DT(1:4) TO WS-FMT-YY                   
               MOVE WS-NEXT-READ-DT(9:2) TO WS-FMT-DD                   
               EVALUATE WS-NEXT-READ-DT(6:2)                            
                   WHEN '01'                                            
                       MOVE 'JAN' TO WS-FMT-MM                          
                   WHEN '02'                                            
                       MOVE 'FEB' TO WS-FMT-MM                          
                   WHEN '03'                                            
                       MOVE 'MAR' TO WS-FMT-MM                          
                   WHEN '04'                                            
                       MOVE 'APR' TO WS-FMT-MM                          
                   WHEN '05'                                            
                       MOVE 'MAY' TO WS-FMT-MM                          
                   WHEN '06'                                            
                       MOVE 'JUN' TO WS-FMT-MM                          
                   WHEN '07'                                            
                       MOVE 'JUL' TO WS-FMT-MM                          
                   WHEN '08'                                            
                       MOVE 'AUG' TO WS-FMT-MM                          
                   WHEN '09'                                            
                       MOVE 'SEP' TO WS-FMT-MM                          
                   WHEN '10'                                            
                       MOVE 'OCT' TO WS-FMT-MM                          
                   WHEN '11'                                            
                       MOVE 'NOV' TO WS-FMT-MM                          
                   WHEN '12'                                            
                       MOVE 'DEC' TO WS-FMT-MM                          
               END-EVALUATE                                             
               MOVE WS-FMT-DT TO S-MESSAGE-PARMS                        
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
      * NOTICE                                                                  
                                                                        
           IF WS-NOTICE-DT > SPACES                                     
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE 0 TO S-RETURN-CODE-2                                
               MOVE 'WCM0000024' TO WS-RULE-ID                          
               MOVE '00' TO WS-COMP-NO                                  
               PERFORM 7345-RULE-XREF THRU 7345-EXIT                    
               MOVE WS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID               
               MOVE WS-RULE-MSG-ID TO S-BUS-RULE-MSG-ID                 
               MOVE WS-RULE-RESULT TO S-RULE-RESULT-CD                  
               MOVE WS-NOTICE-DT(1:4) TO WS-FMT-YY                      
               MOVE WS-NOTICE-DT(9:2) TO WS-FMT-DD                      
               EVALUATE WS-NOTICE-DT(6:2)                               
                   WHEN '01'                                            
                       MOVE 'JAN' TO WS-FMT-MM                          
                   WHEN '02'                                            
                       MOVE 'FEB' TO WS-FMT-MM                          
                   WHEN '03'                                            
                       MOVE 'MAR' TO WS-FMT-MM                          
                   WHEN '04'                                            
                       MOVE 'APR' TO WS-FMT-MM                          
                   WHEN '05'                                            
                       MOVE 'MAY' TO WS-FMT-MM                          
                   WHEN '06'                                            
                       MOVE 'JUN' TO WS-FMT-MM                          
                   WHEN '07'                                            
                       MOVE 'JUL' TO WS-FMT-MM                          
                   WHEN '08'                                            
                       MOVE 'AUG' TO WS-FMT-MM                          
                   WHEN '09'                                            
                       MOVE 'SEP' TO WS-FMT-MM                          
                   WHEN '10'                                            
                       MOVE 'OCT' TO WS-FMT-MM                          
                   WHEN '11'                                            
                       MOVE 'NOV' TO WS-FMT-MM                          
                   WHEN '12'                                            
                       MOVE 'DEC' TO WS-FMT-MM                          
               END-EVALUATE                                             
               STRING WS-FMT-DT                                         
                      ';'                                               
                      1J-CORRESP-STMT-DT                                
                      ';'                                               
                      1L-COMM-TYPE-CODE                                 
                      ';'                                               
                      1L-COMM-SUBTYPE-CODE                              
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
      * OUTAGE PLACEHOLDER                                                      
                                                                        
           IF S-OUTAGE-FL = 'Y'                                         
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE 0 TO S-RETURN-CODE-2                                
               MOVE 'WCM0000012' TO WS-RULE-ID                          
               MOVE '00' TO WS-COMP-NO                                  
               PERFORM 7345-RULE-XREF THRU 7345-EXIT                    
               MOVE WS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID               
               MOVE WS-RULE-MSG-ID TO S-BUS-RULE-MSG-ID                 
               MOVE WS-RULE-RESULT TO S-RULE-RESULT-CD                  
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
      * SEB RATE RENEWAL                                                        
                                                                        
           IF SEB-DATABASE AND                                          
              AT-MST-SUB-ACCT-IND NOT = 'M' AND                         
              WS-UT-FL = 'Y'                                            
                  PERFORM 4100-CALL-CSR04099 THRU 4100-EXIT
           END-IF.            
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4100-CALL-CSR04099.                                              
                                                                        
           MOVE DF-OPTION-CD TO OPTION-CD-4099.                         
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-4099.                     
           MOVE UT-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-4099.               
           MOVE WS-IC-NO-CHAR TO IC-NO-4099.                            
           MOVE 'Y' TO THERM-CSC-ACCT-FL-4099.                          
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04099                                             
      *           (:OPTION-CD-4099,                                     
      *            :ACCOUNT-NO-4099,                                    
      *            :CODE-UTIL-TYPE-4099,                                
      *            :IC-NO-4099,                                         
      *            :THERM-CSC-ACCT-FL-4099)                             
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04099'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4099       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4099A, :LOC4099B)                                    
      *       WITH PROCEDURE CSR04099                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4099A CURSOR FOR RESULT SET       
      *       :LOC4099A                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4099B CURSOR FOR RESULT SET       
      *       :LOC4099B                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH MSQ001_CUR_1 INTO                           
                 :RETURN-CODE-4099-A,                                   
                 :THERM-PRICE-4099,                                     
                 :OPTN-VALID-MNTHS-4099,                                
                 :PRIM-FACTOR-ID-4099,                                  
                 :CORE-RATE-PLAN-NO-4099,                               
                 :RATE-CALC-TYPE-CD-4099,                               
                 :CSC-AMT-4099,                                         
                 :CSC-REFND-FL-4099,                                    
                 :CSC-MNTHS-4099,                                       
                 :DURATION-REM-MO-4099,                                 
                 :TIER-ACCT-TYPE-CD-4099,                               
                 :WEB-RENEWAL-FL-4099,                                  
                 :RATE-DEFINITION-CD-4099,                              
                 :CURR-EXT-DESC-LONG-4099,                              
                 :PEND-OPT-EXISTS-FL-4099,                              
                 :SHOW-RENEWAL-OPT-4099,                                
                 :PEND-EXT-DESC-LONG-4099,                              
                 :ADJUSTABLE-FL-4099,                                   
                 :CURRENT-THERM-PRICE-4099,                             
                 :CURR-OPT-EFF-DATE-4099,                               
                 :PEND-OPT-EFF-DATE-4099,                               
                 :SENIOR-RATE-FL-4099,                                  
                 :IS-CURR-OPTN-FLEX-4099,                               
                 :CORE-RATE-PLAN-DDDC-4099,                             
                 :PRINT-SR-DSC-MSG-CD-4099,                             
                 :CURR-OPT-ROR-END-DT-4099,                             
                 :CUSTOMER-DOB-4099,                                    
                 :SENIOR-BY-DOB-FL-4099,                                
                 :TIER-CUST-STAT-CD-4099,                               
                 :CODE-REVENUE-CLASS-4099,                              
                 :SPCL-OFFER-TYPE-CD-4099                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4099A INTO                                   
MFA-TR*          :RETURN-CODE-4099-A,                                           
MFA-TR*          :THERM-PRICE-4099,                                             
MFA-TR*          :OPTN-VALID-MNTHS-4099,                                        
MFA-TR*          :PRIM-FACTOR-ID-4099,                                          
MFA-TR*          :CORE-RATE-PLAN-NO-4099,                                       
MFA-TR*          :RATE-CALC-TYPE-CD-4099,                                       
MFA-TR*          :CSC-AMT-4099,                                                 
MFA-TR*          :CSC-REFND-FL-4099,                                            
MFA-TR*          :CSC-MNTHS-4099,                                               
MFA-TR*          :DURATION-REM-MO-4099,                                         
MFA-TR*          :TIER-ACCT-TYPE-CD-4099,                                       
MFA-TR*          :WEB-RENEWAL-FL-4099,                                          
MFA-TR*          :RATE-DEFINITION-CD-4099,                                      
MFA-TR*          :CURR-EXT-DESC-LONG-4099,                                      
MFA-TR*          :PEND-OPT-EXISTS-FL-4099,                                      
MFA-TR*          :SHOW-RENEWAL-OPT-4099,                                        
MFA-TR*          :PEND-EXT-DESC-LONG-4099,                                      
MFA-TR*          :ADJUSTABLE-FL-4099,                                           
MFA-TR*          :CURRENT-THERM-PRICE-4099,                                     
MFA-TR*          :CURR-OPT-EFF-DATE-4099,                                       
MFA-TR*          :PEND-OPT-EFF-DATE-4099,                                       
MFA-TR*          :SENIOR-RATE-FL-4099,                                          
MFA-TR*          :IS-CURR-OPTN-FLEX-4099,                                       
MFA-TR*          :CORE-RATE-PLAN-DDDC-4099,                                     
MFA-TR*          :PRINT-SR-DSC-MSG-CD-4099,                                     
MFA-TR*          :CURR-OPT-ROR-END-DT-4099,                                     
MFA-TR*          :CUSTOMER-DOB-4099,                                            
MFA-TR*          :SENIOR-BY-DOB-FL-4099,                                        
MFA-TR*          :TIER-CUST-STAT-CD-4099,                                       
MFA-TR*          :CODE-REVENUE-CLASS-4099,                                      
MFA-TR*          :SPCL-OFFER-TYPE-CD-4099                                       
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4099-A NOT = 0                        
                       MOVE RETURN-CODE-4099-A TO WS-ACTIVE-RETURN-CODE 
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04099A'       TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-4099   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
                   END-IF                                               
                   MOVE DURATION-REM-MO-4099 TO S-DURATION-REM-MO       
                   MOVE SENIOR-RATE-FL-4099 TO S-SENIOR-RATE-FL         
                   MOVE TIER-ACCT-TYPE-CD-4099 TO S-TIER-ACCT-TYPE      
                   MOVE CURR-OPT-ROR-END-DT-4099 TO S-ROR-DT            
                   IF RATE-CALC-TYPE-CD-4099 = '02' AND                 
                      SHOW-RENEWAL-OPT-4099 = 'Y' AND                   
                      WEB-RENEWAL-FL-4099 = 'Y'                         
                          MOVE 'Y' TO S-SEB-RENEWAL-FL                  
                   END-IF                                               
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04099A'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4099       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE.                                              
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4099-B,                                 
                   :BUS-RULE-MSG-ID-4099,                               
                   :RULE-RESULT-CD-4099,                                
                   :BUS-RULE-XREF-ID-4099,                              
                   :MESSAGE-PARMS-4099,                                 
                   :LINK-PARMS-4099                                     
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4099B INTO                                 
MFA-TR*            :RETURN-CODE-4099-B,                                         
MFA-TR*            :BUS-RULE-MSG-ID-4099,                                       
MFA-TR*            :RULE-RESULT-CD-4099,                                        
MFA-TR*            :BUS-RULE-XREF-ID-4099,                                      
MFA-TR*            :MESSAGE-PARMS-4099,                                         
MFA-TR*            :LINK-PARMS-4099                                             
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4099-B NOT = 0 AND                   
                       RETURN-CODE-4099-B NOT = +100                    
                         MOVE RETURN-CODE-4099-B TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '4100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04099B'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4099   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4099-B = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        MOVE SPACES TO WS-MESSAGE-PARMS                 
                        PERFORM 4110-PROCESS-4099B THRU 4110-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '4100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04099B'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4099       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4110-PROCESS-4099B.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE 0 TO S-RETURN-CODE-2.                                   
           MOVE BUS-RULE-MSG-ID-4099 TO S-BUS-RULE-MSG-ID.              
           MOVE RULE-RESULT-CD-4099 TO S-RULE-RESULT-CD.                
           MOVE BUS-RULE-XREF-ID-4099 TO S-BUS-RULE-XREF-ID.            
           MOVE MESSAGE-PARMS-4099 TO S-MESSAGE-PARMS.                  
           MOVE LINK-PARMS-4099 TO S-LINK-PARMS.                        
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
       4110-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT RTRIM(LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE
           )))),                            
                      ADDR_USAGE_CD,                                    
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE,                                 
                      MST_SUB_ACCT_IND,                                 
                      ACCOUNT_TYPE_CODE,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                      CREDIT_GROUP,                                     
                      BANKRUPTCY_IND,                                   
                      JUDGEMENT_IND,                                    
                      DATE_BILL_DAY_00,                                 
                      AT.PREMISE_NO,                                    
                      AT.COMPANY_NO,                                    
                      AT.ADDRESS_ID,                                    
                      AT.ADDRESS_FORMAT,                                
                      STREET_NAME,                                      
                      HOUSE_NO,                                         
                      CODES_DATA_PRESENT,                               
                      LAST_PYMT_DATE,                                   
                      LAST_PYMT_AMOUNT,                                 
                      NO_BILL_COPIES,                                   
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),          
                      RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW)))),                 
                      RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + LTRIM(RTRIM(
           MIDDLE_NAME) + ' ' + LTRIM(RTRIM(LAST_NAME))))),                    
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      DY.ZIP_CODE,                                      
                      AT.CUSTOMER_NO,                                   
                      AT.LOCAL_OFFICE,                                  
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      NOTICE_EXEMPT_CD,                                 
                      IVR_EXEMPT_CD,                                    
                      CODE_DISC_OK,                                     
                      TOWN,                                             
                      STATE,                                            
                      REV_MTH_LST_NRML                                  
                 INTO :WS-TOWN,                                         
                      :DY-ADDR-USAGE-CD,                                
                      :AT-CODE-ACCT-STAT,                               
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-MST-SUB-ACCT-IND,                             
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-ACCT-CREATE-DT :WS-NULL-3,                     
                      :AT-ACCT-FINALED-DT :WS-NULL-4,                    
                      :AT-CREDIT-GROUP,                                 
                      :AT-BANKRUPTCY-IND,                               
                      :AT-JUDGEMENT-IND,                                
                      :AT-DATE-BILL-DAY-00,                             
                      :AT-PREMISE-NO,                                   
                      :AT-COMPANY-NO,                                   
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
                      :DY-STREET-NAME,                                  
                      :DY-HOUSE-NO,                                     
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-LAST-PYMT-DATE :WS-NULL-1,                     
                      :AT-LAST-PYMT-AMOUNT,                             
                      :AT-NO-BILL-COPIES,                               
                      :WS-ADDRESS-LINE,                                 
                      :WS-ADDRESS-LINE-I,                               
                      :WS-CUST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT,                                  
                      :DY-ZIP-CODE,                                     
                      :AT-CUSTOMER-NO,                                  
                      :AT-LOCAL-OFFICE,                                 
                      :AT-DATE-BILL-DAY-30,                             
                      :AT-DATE-BILL-DAY-60,                             
                      :AT-DATE-BILL-DAY-90,                             
                      :AT-NOTICE-EXEMPT-CD,                             
                      :AT-IVR-EXEMPT-CD,                                
                      :AT-CODE-DISC-OK,                                 
                      :A4-TOWN,                                         
                      :A4-STATE,                                        
                      :AT-REV-MTH-LST-NRML                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                    
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND AT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                  AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(TOWN) || ', ' ||                        
MFA-TR*               LTRIM(RTRIM(STATE)))),                                    
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               TOTAL_AR_BALANCE,                                         
MFA-TR*               MST_SUB_ACCT_IND,                                         
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               ACCT_CREATE_DT,                                           
MFA-TR*               ACCT_FINALED_DT,                                          
MFA-TR*               CREDIT_GROUP,                                             
MFA-TR*               BANKRUPTCY_IND,                                           
MFA-TR*               JUDGEMENT_IND,                                            
MFA-TR*               DATE_BILL_DAY_00,                                         
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.ADDRESS_FORMAT,                                        
MFA-TR*               STREET_NAME,                                              
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               LAST_PYMT_DATE,                                           
MFA-TR*               LAST_PYMT_AMOUNT,                                         
MFA-TR*               NO_BILL_COPIES,                                           
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)))))))))),                  
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||               
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                         
MFA-TR*               RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(LAST_NAME))))),                               
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               AT.CUSTOMER_NO,                                           
MFA-TR*               AT.LOCAL_OFFICE,                                          
MFA-TR*               DATE_BILL_DAY_30,                                         
MFA-TR*               DATE_BILL_DAY_60,                                         
MFA-TR*               DATE_BILL_DAY_90,                                         
MFA-TR*               NOTICE_EXEMPT_CD,                                         
MFA-TR*               IVR_EXEMPT_CD,                                            
MFA-TR*               CODE_DISC_OK,                                             
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE,                                                    
MFA-TR*               REV_MTH_LST_NRML                                          
MFA-TR*          INTO :WS-TOWN,                                                 
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-TOTAL-AR-BALANCE,                                     
MFA-TR*               :AT-MST-SUB-ACCT-IND,                                     
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-ACCT-CREATE-DT:WS-NULL-3,                             
MFA-TR*               :AT-ACCT-FINALED-DT:WS-NULL-4,                            
MFA-TR*               :AT-CREDIT-GROUP,                                         
MFA-TR*               :AT-BANKRUPTCY-IND,                                       
MFA-TR*               :AT-JUDGEMENT-IND,                                        
MFA-TR*               :AT-DATE-BILL-DAY-00,                                     
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-LAST-PYMT-DATE:WS-NULL-1,                             
MFA-TR*               :AT-LAST-PYMT-AMOUNT,                                     
MFA-TR*               :AT-NO-BILL-COPIES,                                       
MFA-TR*               :WS-ADDRESS-LINE,                                         
MFA-TR*               :WS-ADDRESS-LINE-I,                                       
MFA-TR*               :WS-CUST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-DATE-BILL-DAY-30,                                     
MFA-TR*               :AT-DATE-BILL-DAY-60,                                     
MFA-TR*               :AT-DATE-BILL-DAY-90,                                     
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                                     
MFA-TR*               :AT-IVR-EXEMPT-CD,                                        
MFA-TR*               :AT-CODE-DISC-OK,                                         
MFA-TR*               :A4-TOWN,                                                 
MFA-TR*               :A4-STATE,                                                
MFA-TR*               :AT-REV-MTH-LST-NRML                                      
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4,                                          
MFA-TR*               CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND AT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*           AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO AT-LAST-PYMT-DATE                 
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-CUST-NAME                
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CSS_PREMISE'    TO TABLE-2                     
                   MOVE 'CSS_ADDR_FORMATTED' TO  TABLE-3                
                   MOVE 'CSS_ZIP-CODE'   TO TABLE-4                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'      TO TABLE-ELEMENT-1             
                   MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-BILL-STATEMENT.                                             
                                                                        
           MOVE WS-DATE-MINUS-30-DAYS TO KO-COMMUNICATION-ID(1:10).     
           MOVE '-00.00.00.000000' TO KO-COMMUNICATION-ID(11:16).       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID                                   
                INTO :KO-COMMUNICATION-ID                               
                FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND COMMUNICATION_ID > CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )            
                 AND COMM_TYPE_CD = '46'                                
                 AND COMM_SUBTYPE_CODE = '27'                           
              ORDER BY COMMUNICATION_ID DESC                            
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMMUNICATION_ID                                           
MFA-TR*         INTO :KO-COMMUNICATION-ID                                       
MFA-TR*         FROM CSS_COMM_DATA                                              
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND COMMUNICATION_ID > :KO-COMMUNICATION-ID                    
MFA-TR*          AND COMM_TYPE_CD = '46'                                        
MFA-TR*          AND COMM_SUBTYPE_CODE = '27'                                   
MFA-TR*       ORDER BY COMMUNICATION_ID DESC                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE KO-COMMUNICATION-ID(1:10) TO WS-STATEMENT-DT    
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-STATEMENT-DT                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-UTIL-ENVRNMT.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) IC_NO,
              CODE_UTIL_TYPE,
              RATE_PLAN_NO                                      
                 INTO :UT-IC-NO,                                        
                      :UT-CODE-UTIL-TYPE,                               
                      :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                ORDER BY IC_NO                                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IC_NO,                                                    
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               RATE_PLAN_NO                                              
MFA-TR*          INTO :UT-IC-NO,                                                
MFA-TR*               :UT-CODE-UTIL-TYPE,                                       
MFA-TR*               :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         ORDER BY IC_NO                                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-UT-FL                                 
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-UT-FL                                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO  TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE UT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-RULE-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN RULE-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_RULE_XREF'  TO TABLE-1                 
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7051-CLOSE-RULE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE RULE-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7051'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_RULE_XREF'  TO TABLE-1                 
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-EBILL-INSERTS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) BILL_CYCLE,
              COMPANY_NO,
              DATE_BILLED,
              INSERT_FLAGS,
              REVENUE_MONTH                                     
                 INTO :IE-BILL-CYCLE,                                   
                      :IE-COMPANY-NO,                                   
                      :IE-DATE-BILLED,                                  
                      :IE-INSERT-FLAGS,                                 
                      :IE-REVENUE-MONTH                                 
                 FROM CSS_EBILL_INSERTS WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BILL_CYCLE,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               DATE_BILLED,                                              
MFA-TR*               INSERT_FLAGS,                                             
MFA-TR*               REVENUE_MONTH                                             
MFA-TR*          INTO :IE-BILL-CYCLE,                                           
MFA-TR*               :IE-COMPANY-NO,                                           
MFA-TR*               :IE-DATE-BILLED,                                          
MFA-TR*               :IE-INSERT-FLAGS,                                         
MFA-TR*               :IE-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_EBILL_INSERTS                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND DATE_BILLED = :AT-DATE-BILL-DAY-00                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-EBILL-INSERTS                      
                   MOVE +100 TO S-RETURN-CODE-3                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_EBILL_INSERTS' TO  TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-CORRESP-HDR.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COMM_TYPE_CODE,
              COMM_SUBTYPE_CODE,
              CORRESP_STMT_DT                                   
                 INTO :1L-COMM-TYPE-CODE,                               
                      :1L-COMM-SUBTYPE-CODE,                            
                      :1J-CORRESP-STMT-DT                               
                 FROM CSS_CORRESP_COMM [1L] WITH(READUNCOMMITTED),              
                      CSS_CORRESP_HDR [1J] WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND CORRESP_STMT_DT >= IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )            
                 AND [1J].CORRESP_TYPE_CD = '2N'                          
                 AND [1L].CORRESP_MSG_ID = [1J].CORRESP_MSG_ID              
               ORDER BY CORRESP_STMT_DT DESC                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMM_TYPE_CODE,                                           
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               CORRESP_STMT_DT                                           
MFA-TR*          INTO :1L-COMM-TYPE-CODE,                                       
MFA-TR*               :1L-COMM-SUBTYPE-CODE,                                    
MFA-TR*               :1J-CORRESP-STMT-DT                                       
MFA-TR*          FROM CSS_CORRESP_COMM 1L,                                      
MFA-TR*               CSS_CORRESP_HDR 1J                                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND CORRESP_STMT_DT >= :AT-DATE-BILL-DAY-00                    
MFA-TR*          AND 1J.CORRESP_TYPE_CD = '2N'                                  
MFA-TR*          AND 1L.CORRESP_MSG_ID = 1J.CORRESP_MSG_ID                      
MFA-TR*        ORDER BY CORRESP_STMT_DT DESC                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1J-CORRESP-STMT-DT TO WS-NOTICE-DT              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-NOTICE-DT                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CORRESP_HDR' TO TABLE-1                    
                   MOVE 'CSS_CORRESP_COMM' TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-ACCT-MISC-INFO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SPCL_BILL_STMNT_TX                                
                 INTO :TA-SPCL-BILL-STMNT-TX                            
                 FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SPCL_BILL_STMNT_TX                                        
MFA-TR*          INTO :TA-SPCL-BILL-STMNT-TX                                    
MFA-TR*          FROM CSS_ACCT_MISC_INFO                                        
MFA-TR*         WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCT-MISC-INFO                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) LANGUAGE_PREF_CD,
              PASSWORD_HINT,
              PASSWORD_TX,
              EBILL_REGISTER_IND,
              ALLOW_CALL_FL,
              ALLOW_EMAIL_FL,
              EMPLOYER                                           
               INTO :CE-LANGUAGE-PREF-CD,                               
                    :CE-PASSWORD-HINT,                                  
                    :CE-PASSWORD-TX,                                    
                    :CE-EBILL-REGISTER-IND,                             
                    :CE-ALLOW-CALL-FL,                                  
                    :CE-ALLOW-EMAIL-FL,                                 
                    :CE-EMPLOYER                                        
               FROM  CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                       
                AND CUSTOMER_TYPE = 'C'                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT  LANGUAGE_PREF_CD,                                  14210000
MFA-TR*              PASSWORD_HINT,                                     14240000
MFA-TR*              PASSWORD_TX,                                       14250000
MFA-TR*              EBILL_REGISTER_IND,                                        
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              EMPLOYER                                                   
MFA-TR*        INTO :CE-LANGUAGE-PREF-CD,                               14380000
MFA-TR*             :CE-PASSWORD-HINT,                                  14410000
MFA-TR*             :CE-PASSWORD-TX,                                    14410000
MFA-TR*             :CE-EBILL-REGISTER-IND,                             14420000
MFA-TR*             :CE-ALLOW-CALL-FL,                                  14420000
MFA-TR*             :CE-ALLOW-EMAIL-FL,                                 14420000
MFA-TR*             :CE-EMPLOYER                                        14420000
MFA-TR*        FROM  CSS_CUST_STATS                                     14550000
MFA-TR*       WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                       14560000
MFA-TR*         AND CUSTOMER_TYPE = 'C'                                 14561000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-STATS                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7100'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-WRITE-OFF-CUTOFF.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'WO-CUTOFF-DT'                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'WO-CUTOFF-DT'                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-WOFF-YEARS                
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 0 TO WS-WOFF-YEARS                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'WO-CUTOFF-DT'   TO TABLE-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF C8-COMPANY-NO = '26'                                      
               MOVE +6 TO WS-WOFF-YEARS
           END-IF.                                
                                                                        
           IF WS-WOFF-YEARS > 0                                         
               EXEC SQL                                                 
                   SELECT
              DATEADD( YEAR, -(:WS-WOFF-YEARS), IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-WOFF-DT            
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SET :WS-WOFF-DT = (DATE(:WS-CURRENT-DATE) -                  
MFA-TR*                              (:WS-WOFF-YEARS) YEARS)                    
MFA-TR*        END-EXEC.                                                        
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL


           END-IF.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-ATTRIB.                                              
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ATTRIBUTE_VALUE_CD                                  
               INTO :YP-ATTRIBUTE-VALUE-CD                              
               FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),                
                    CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND COMPANY_NO = :AT-COMPANY-NO                         
                AND YP.ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC              
                AND ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX           
                AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC               
                AND ATTRIBUTE_STAT_CD = 'A'                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT ATTRIBUTE_VALUE_CD                                  14210000
MFA-TR*        INTO :YP-ATTRIBUTE-VALUE-CD                              14380000
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE YP,                              14550000
MFA-TR*             CSS_ATTRIBUTE WZ                                            
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         14560000
MFA-TR*         AND COMPANY_NO = :AT-COMPANY-NO                                 
MFA-TR*         AND YP.ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                      
MFA-TR*         AND ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX                   
MFA-TR*         AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC                       
MFA-TR*         AND ATTRIBUTE_STAT_CD = 'A'                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ACCT-ATTRIBUTE                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7120'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   MOVE 'ATTRIBUTE_DESC'  TO TABLE-ELEMENT-2            
                   MOVE 'EMAIL PMT REMINDER' TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SELECT-DBA.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FULL_NAME                                         
                 INTO :DQ-FULL-NAME                                     
                 FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND AB.NAME_TYPE = 'DB'                               
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FULL_NAME                                                 
MFA-TR*          INTO :DQ-FULL-NAME                                             
MFA-TR*          FROM CSS_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_TYPE = 'DB'                                       
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO DQ-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-REG-PROFILE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7140                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                WHEN SUCCESSFUL-CALL                                    
                    CONTINUE                                            
                WHEN NOT-FOUND                                          
                    MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                
                    MOVE SPACES TO LR-REG-GROUP-CD                      
                WHEN OTHER                                              
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_REG_PROFILE' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7190-FMT-BILL-ADDR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE))))                              
                INTO :WS-TOWN                                           
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(TOWN) || ', ' ||                         
MFA-TR*              LTRIM(RTRIM(STATE))))                                      
MFA-TR*         INTO :WS-TOWN                                                   
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7190'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'      TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-2          
                   MOVE AT-ADDRESS-ID       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-FRE-BILL-ADDR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_CITY_STATE                                    
                INTO :DZ-ADDR-CITY-STATE                                
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_CITY_STATE                                            
MFA-TR*         INTO :DZ-ADDR-CITY-STATE                                        
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE DZ-ADDR-CITY-STATE TO WS-TOWN                   
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-2          
                   MOVE AT-ADDRESS-ID       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-MST-SUB.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MST_ACCT_NO                                       
                 INTO :MU-MST-ACCT-NO                                   
                 FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
                WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MST_ACCT_NO                                               
MFA-TR*          INTO :MU-MST-ACCT-NO                                           
MFA-TR*          FROM CSS_MSTSUB_ACCT                                           
MFA-TR*         WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  MU-MST-ACCT-NO                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7250'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_MSTSUB_ACCT'    TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-UTILITIES.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :UT-ACCOUNT-NO                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :UT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7280                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   EVALUATE UT-CODE-UTIL-TYPE                           
                       WHEN 'E'                                         
                           MOVE 'Y' TO S-ELEC-UTIL-FL                   
                       WHEN 'G'                                         
                           MOVE 'Y' TO S-GAS-UTIL-FL                    
                       WHEN 'U'                                         
                           MOVE 'Y' TO S-LIGHTING-FL                    
                   END-EVALUATE                                         
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7280'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-PKG-OPTION.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FI.OPT_DESC_INT_LONG,
              DF.OPTION_CD,
              DF.STATUS_CD,
              DF.RT_PKG_OPT_SEQ_NO,
              FI.OPT_CALC_TYPE_CD,
              FI.CURR_EXT_DESC_LONG,
              DF.AUTO_REN_OPT_IN_FL                             
                 INTO :FI-OPT-DESC-INT-LONG,                            
                      :DF-OPTION-CD,                                    
                      :DF-STATUS-CD,                                    
                      :DF-RT-PKG-OPT-SEQ-NO,                            
                      :FI-OPT-CALC-TYPE-CD,                             
                      :FI-CURR-EXT-DESC-LONG,                           
                      :DF-AUTO-REN-OPT-IN-FL                            
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED),               
                      CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED),               
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                  AND UT.IC_NO             = :UT-IC-NO                  
                  AND UT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                  AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
                  AND DF.IC_NO             = UT.IC_NO                   
                  AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
                  AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
                  AND FI.OPTION_CD         = DF.OPTION_CD               
                  AND FI.COMPANY_NO        = :AT-COMPANY-NO             
                  AND FI.OPT_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )             
                  AND FI.OPT_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )             
                  AND FI.PROC_STATUS_CD    = 'AC'                       
                ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*        SELECT FI.OPT_DESC_INT_LONG,                             41146600
MFA-TR*               DF.OPTION_CD,                                     41146600
MFA-TR*               DF.STATUS_CD,                                     41146600
MFA-TR*               DF.RT_PKG_OPT_SEQ_NO,                             41146600
MFA-TR*               FI.OPT_CALC_TYPE_CD,                                      
MFA-TR*               FI.CURR_EXT_DESC_LONG,                                    
MFA-TR*               DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*          INTO :FI-OPT-DESC-INT-LONG,                            41146600
MFA-TR*               :DF-OPTION-CD,                                    41146600
MFA-TR*               :DF-STATUS-CD,                                    41146600
MFA-TR*               :DF-RT-PKG-OPT-SEQ-NO,                            41146600
MFA-TR*               :FI-OPT-CALC-TYPE-CD,                             41146600
MFA-TR*               :FI-CURR-EXT-DESC-LONG,                           41146600
MFA-TR*               :DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*          FROM CRM_RT_PKG_OPTION FI,                             41146600
MFA-TR*               CSS_ACCT_RTPK_AGR DF,                             41146600
MFA-TR*               CSS_UTIL_ENVRNMT UT                               41146600
MFA-TR*         WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         41146600
MFA-TR*           AND UT.IC_NO             = :UT-IC-NO                  41146600
MFA-TR*           AND UT.ACCOUNT_NO        = :AT-ACCOUNT-NO             41146600
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          41146600
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                   41146600
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              41146600
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       41146600
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD               41146600
MFA-TR*           AND FI.COMPANY_NO        = :AT-COMPANY-NO             41146600
MFA-TR*           AND FI.OPT_VSTART_TS    <= :WS-CURRENT-TS                     
MFA-TR*           AND FI.OPT_VEND_TS      >= :WS-CURRENT-TS                     
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*         ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      41146600
MFA-TR*         FETCH FIRST ROW ONLY                                    41146600
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*     END-EXEC.                                                   41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO FI-OPT-DESC-INT                       
                                  DF-OPTION-CD                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CRM_RT_PKG_OPTION' TO TABLE-1                  
                   MOVE 'CSS_ACCT_RTPK_AGR' TO TABLE-2                  
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-3                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7345-RULE-XREF.                                                  
                                                                        
           MOVE SPACES TO WS-RULE-XREF-ID                               
                          WS-RULE-MSG-ID                                
                          WS-RULE-RESULT.                               
                                                                        
           SET T2-INDEX TO +1.                                          
           SEARCH T2-RULES                                              
              AT END                                                    
                 MOVE SPACES TO WS-RULE-XREF-ID                         
               WHEN T2-RULE-ID (T2-INDEX) = WS-RULE-ID                  
                AND T2-COMPANY-NO (T2-INDEX) = WS-COMP-NO               
                    MOVE T2-RULE-XREF-ID (T2-INDEX) TO WS-RULE-XREF-ID  
                    MOVE T2-RULE-MSG-ID (T2-INDEX) TO WS-RULE-MSG-ID    
                    MOVE T2-RULE-RESULT-CD (T2-INDEX) TO WS-RULE-RESULT 
           END-SEARCH.                                                  
                                                                        
       7345-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT02-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04807_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04807_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04807_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04807_R2                            
             (                                                          
              RETURN_CODE,                                              
              BUS_RULE_MSG_ID,                                          
              RULE_RESULT_CD,                                           
              BUS_RULE_XREF_ID,                                         
              MESSAGE_PARMS,                                            
              LINK_PARMS                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-BUS-RULE-MSG-ID,                                      
               :S-RULE-RESULT-CD,                                       
               :S-BUS-RULE-XREF-ID,                                     
               :S-MESSAGE-PARMS,                                        
               :S-LINK-PARMS                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04807_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_RULE_MSG_ID,                                                  
MFA-TR*       RULE_RESULT_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID,                                                 
MFA-TR*       MESSAGE_PARMS,                                                    
MFA-TR*       LINK_PARMS                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-BUS-RULE-MSG-ID,                                              
MFA-TR*        :S-RULE-RESULT-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID,                                             
MFA-TR*        :S-MESSAGE-PARMS,                                                
MFA-TR*        :S-LINK-PARMS                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04807_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00310                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00375                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD0309A                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
                                                                        
