       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04806.                                          
COB303 DATE-WRITTEN. OCTOBER 1, 2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS CUSTOMER AND ACCOUNT DATA FOR THE WEB.  *        
      *  RESULTS SETS:                                                 *        
      *     1.  CUSTOMER / SPOUSE INFO                                 *        
      *     2.  PHONE NUMBERS                                          *        
      *     3.  ACCOUNT DATA                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/01/14    FMB      NEW PROGRAM.                                      
A05317*  07/25/16    FMB      ADD PROPERTY MANAGER FLAG.                        
A05317*  10/27/16    FMB      TWEAK SORT ORDER ABOVE THRESHOLD (C4).            
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04806'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04806 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWQCAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRBLDL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRARNG                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRARSC                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRARHS                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSTASUM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBUSDAY                                                  
           END-EXEC.                                                            
A05317     EXEC SQL                                                             
A05317        INCLUDE TBLNDLRD                                                  
A05317     END-EXEC.                                                            
                                                                        
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
           COPY CWS0068L.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00068                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00375                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00309                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00322                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04806_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04806_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04806_R3'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1      PIC S9(9) COMP VALUE 0.          
               10 S-STATUS-CODE        PIC S9(9) COMP VALUE 0.          
               10 S-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.      
               10 S-CUSTOMER-TYPE      PIC X(01) VALUE SPACES.          
               10 S-CUSTOMER-NAME      PIC X(80) VALUE SPACES.          
               10 S-NAME-FORMAT        PIC X(01) VALUE SPACES.          
               10 S-SSN                PIC X(09) VALUE SPACES.          
               10 S-ITIN               PIC X(09) VALUE SPACES.          
               10 S-OTHER-ID           PIC X(16) VALUE SPACES.          
               10 S-OTHER-ID-TYPE      PIC X(12) VALUE SPACES.          
               10 S-DLN                PIC X(19) VALUE SPACES.          
               10 S-DLN-STATE          PIC X(02) VALUE SPACES.          
               10 S-DOB                PIC X(10) VALUE SPACES.          
               10 S-EMPLOYER           PIC X(23) VALUE SPACES.          
               10 S-EMAIL-ADDRESS      PIC X(100) VALUE SPACES.         
               10 S-TAX-ID             PIC X(09) VALUE SPACES.          
               10 S-SBU-CD             PIC X(01) VALUE SPACES.          
               10 S-FIRST-NAME         PIC X(15) VALUE SPACES.          
               10 S-MIDDLE-NAME        PIC X(15) VALUE SPACES.          
               10 S-LAST-NAME          PIC X(40) VALUE SPACES.          
               10 S-PROP-MGR-FL        PIC X(01) VALUE SPACES.          
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2      PIC S9(9) COMP VALUE 0.          
               10 S-PHONE-NAME-TYPE    PIC X(01) VALUE SPACES.          
               10 S-PHONE-TYPE         PIC X(02) VALUE SPACES.          
               10 S-PHONE-NO           PIC X(10) VALUE SPACES.          
               10 S-PHONE-EXT          PIC X(06) VALUE SPACES.          
               10 S-PHONE-MOBILE-FL    PIC X(01) VALUE SPACES.          
               10 S-PHONE-MKT-FL       PIC X(01) VALUE SPACES.          
               10 S-PHONE-MKT-DT       PIC X(10) VALUE SPACES.          
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3      PIC S9(9) COMP VALUE 0.          
               10 S-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.      
               10 S-TOWN               PIC X(30) VALUE SPACES.          
               10 S-SERVICE-ADDRESS    PIC X(80) VALUE SPACES.          
               10 S-ACCOUNT-ID         PIC X(35) VALUE SPACES.          
               10 S-TOTAL-AR-BALANCE   PIC S9(11)V9(2) COMP-3 VALUE 0.  
               10 S-MST-SUB-ACCT-IND   PIC X(01) VALUE SPACES.          
               10 S-DUE-DT             PIC X(10) VALUE SPACES.          
               10 S-SORT-ORDER         PIC S9(04) COMP VALUE 0.         
               10 S-ACCOUNT-TYPE-CODE  PIC X(01) VALUE SPACES.          
               10 S-CODE-ACCT-STAT     PIC X(01) VALUE SPACES.          
               10 S-DBA-NAME           PIC X(70) VALUE SPACES.          
               10 S-COMPANY-NO         PIC X(02) VALUE SPACES.          
               10 S-REG-GROUP-CD       PIC X(03) VALUE SPACES.          
               10 S-STREET-NAME        PIC X(30) VALUE SPACES.          
               10 S-HOUSE-NO           PIC X(15) VALUE SPACES.          
               10 S-STREET-LOC-1       PIC X(04) VALUE SPACES.          
               10 S-STREET-LOC-2       PIC X(11) VALUE SPACES.          
               10 S-PYMT-SCHED-DT      PIC X(10) VALUE SPACES.          
               10 S-PYMT-METHOD        PIC X(10) VALUE SPACES.          
               10 S-SORT-DT            PIC X(10) VALUE SPACES.          
               10 S-OUTAGE-FL          PIC X(01) VALUE SPACES.          
               10 S-ARREARS-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.  
               10 S-PYMT-SCHED-AMT     PIC S9(11)V9(2) COMP-3 VALUE 0.  
               10 S-DNP-FL             PIC X(01) VALUE SPACES.          
               10 S-DNP-DT             PIC X(10) VALUE SPACES.          
               10 S-STA-REM-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.  
               10 S-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.      
               10 S-WQ-FOUND-FL        PIC X(01) VALUE SPACES.          
               10 S-SORT-DUE-DT        PIC X(10) VALUE SPACES.          
               10 S-CODES-DATA-PRESENT PIC X(32) VALUE SPACES.          
               10 S-RENEWAL-FL         PIC X(01) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CONTACT-ID-CHAR       PIC X(10).                      
           05  WS-CONTACT-ID-NUM        REDEFINES WS-CONTACT-ID-CHAR    
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04806'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-CUST-NAME             PIC X(76) VALUE SPACES.         
           05  WS-SPOUSE-NAME           PIC X(76) VALUE SPACES.         
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.         
           05  WS-TOWN                  PIC X(30) VALUE SPACES.         
           05  WS-RETURN-ACCT-FL        PIC X(01) VALUE SPACES.         
           05  WS-ATTORNEY-FL           PIC X(01) VALUE SPACES.         
           05  WS-ORDER-EXISTS-FL       PIC X(01) VALUE SPACES.         
           05  WS-SCEG-FL               PIC X(01) VALUE 'N'.            
           05  WS-PSNC-FL               PIC X(01) VALUE 'N'.            
           05  WS-SEB-FL                PIC X(01) VALUE 'N'.            
           05  WS-SEBR-FL               PIC X(01) VALUE 'N'.            
           05  WS-WOFF-DT-01            PIC X(10) VALUE SPACES.         
           05  WS-WOFF-DT-26            PIC X(10) VALUE SPACES.         
           05  WS-WOFF-DT               PIC X(10) VALUE SPACES.         
           05  WS-WOFF-YEARS            PIC S9(9)V COMP-3 VALUE 0.      
           05  WS-DATE-MINUS-16-MONTHS  PIC X(10) VALUE SPACES.         
           05  WS-DATE-MINUS-90-DAYS    PIC X(10) VALUE SPACES.         
           05  WS-ACCOUNT-NO            PIC S9(13)V COMP-3 VALUE 0.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ACCOUNT-THRESHOLD     PIC S9(4) COMP VALUE 0.         
           05  WS-ACCOUNT-CT            PIC S9(4) COMP VALUE 0.         
           05  WS-CONTACT-CUST-FL       PIC X(01) VALUE SPACES.         
                                                                        
       01  DYNAMIC-CALLS.                                               
           05  WS-MCSCB068             PIC X(08) VALUE 'MCSCB068'.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE ACCOUNT-CURSOR CURSOR FOR                         
               SELECT DISTINCT                                          
                      ACCOUNT_NO,                                       
                      RTRIM(LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE
           )))),                            
                      ADDR_USAGE_CD,                                    
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE,                                 
                      MST_SUB_ACCT_IND,                                 
                      ACCOUNT_TYPE_CODE,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                      CREDIT_GROUP,                                     
                      BANKRUPTCY_IND,                                   
                      JUDGEMENT_IND,                                    
                      DATE_BILL_DAY_00,                                 
                      AT.PREMISE_NO,                                    
                      AT.COMPANY_NO,                                    
                      AT.ADDRESS_ID,                                    
                      AT.ADDRESS_FORMAT,                                
                      STREET_NAME,                                      
                      HOUSE_NO,                                         
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      CODES_DATA_PRESENT,                               
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),          
                      RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW)))),                 
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      NOTICE_EXEMPT_CD,                                 
                      IVR_EXEMPT_CD,                                    
                      CODE_DISC_OK,                                     
                      AT.LOCAL_OFFICE,                                  
                      REV_MTH_LST_NRML                                  
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                  AND ACCOUNT_TYPE_CODE NOT IN ('D', 'S')               
                  AND CODE_ACCT_STAT <> 'J'                             
      *           AND MST_SUB_ACCT_IND ^= 'S'                                   
                  AND AT.LOCAL_OFFICE NOT IN ('301', '303')             
                  AND AT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN
            OPTION(FAST 1)
            FOR READ ONLY
            
                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ053
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT DISTINCT                                                  
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               RTRIM(LTRIM(RTRIM(TOWN) || ', ' ||                        
MFA-TR*               LTRIM(RTRIM(STATE)))),                                    
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               TOTAL_AR_BALANCE,                                         
MFA-TR*               MST_SUB_ACCT_IND,                                         
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               ACCT_CREATE_DT,                                           
MFA-TR*               ACCT_FINALED_DT,                                          
MFA-TR*               CREDIT_GROUP,                                             
MFA-TR*               BANKRUPTCY_IND,                                           
MFA-TR*               JUDGEMENT_IND,                                            
MFA-TR*               DATE_BILL_DAY_00,                                         
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.ADDRESS_FORMAT,                                        
MFA-TR*               STREET_NAME,                                              
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)))))))))),                  
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||               
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                         
MFA-TR*               DATE_BILL_DAY_30,                                         
MFA-TR*               DATE_BILL_DAY_60,                                         
MFA-TR*               DATE_BILL_DAY_90,                                         
MFA-TR*               NOTICE_EXEMPT_CD,                                         
MFA-TR*               IVR_EXEMPT_CD,                                            
MFA-TR*               CODE_DISC_OK,                                             
MFA-TR*               AT.LOCAL_OFFICE,                                          
MFA-TR*               REV_MTH_LST_NRML                                          
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4                                           
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*           AND ACCOUNT_TYPE_CODE NOT IN ('D', 'S')                       
MFA-TR*           AND CODE_ACCT_STAT ^= 'J'                                     
MFA-TR*           AND MST_SUB_ACCT_IND ^= 'S'                                   
MFA-TR*           AND AT.LOCAL_OFFICE NOT IN ('301', '303')                     
MFA-TR*           AND AT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*         OPTIMIZE FOR 1 ROW                                              
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE PHONE-CURSOR CURSOR FOR                           
               SELECT PHONE_NO,                                         
                      PHONE_TYPE,                                       
                      EXTENSION_NO,                                     
                      MOBILE_PHONE_FL,                                  
                      PERMISN_TO_MKT_DT,                                
                      PERMISN_TO_MKT_FL                                 
                 FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                 
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PHONE-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT PHONE_NO,                                                 
MFA-TR*               PHONE_TYPE,                                               
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               MOBILE_PHONE_FL,                                          
MFA-TR*               PERMISN_TO_MKT_DT,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_CUST_PHONE                                            
MFA-TR*         WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                         
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE TEMP-CURSOR CURSOR FOR                            
               SELECT ACCOUNT_NO,                                       
                      CODES_DATA_PRESENT,                               
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE                                  
                 FROM #CSR04806_R3                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TEMP-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               TOTAL_AR_BALANCE                                          
MFA-TR*          FROM SESSION.CSR04806_R3                                       
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE      AS RETURN_CODE,                  
                      STATUS_CODE      AS STATUS_CODE,                  
                      CUSTOMER_NO      AS CUSTOMER_NO,                  
                      CUSTOMER_TYPE    AS CUSTOMER_TYPE,                
                      CUSTOMER_NAME    AS CUSTOMER_NAME,                
                      NAME_FORMAT      AS NAME_FORMAT,                  
                      SSN              AS SSN,                          
                      ITIN             AS ITIN,                         
                      OTHER_ID         AS OTHER_ID,                     
                      OTHER_ID_TYPE    AS OTHER_ID_TYPE,                
                      DLN              AS DRIVERS_LICENSE_NO,           
                      DLN_STATE        AS DLN_STATE,                    
                      DOB              AS DATE_OF_BIRTH,                
                      EMPLOYER         AS EMPLOYER,                     
                      EMAIL_ADDRESS    AS EMAIL_ADDRESS,                
                      TAX_ID           AS TAX_ID,                       
                      SBU_CD           AS SBU_CD,                       
                      FIRST_NAME       AS FIRST_NAME,                   
                      MIDDLE_NAME      AS MIDDLE_NAME,                  
                      LAST_NAME        AS LAST_NAME,                    
A05317                PROP_MGR_FL      AS PROP_MGR_FL                   
                FROM #CSR04806_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE      AS RETURN_CODE,                          
MFA-TR*               STATUS_CODE      AS STATUS_CODE,                          
MFA-TR*               CUSTOMER_NO      AS CUSTOMER_NO,                          
MFA-TR*               CUSTOMER_TYPE    AS CUSTOMER_TYPE,                        
MFA-TR*               CUSTOMER_NAME    AS CUSTOMER_NAME,                        
MFA-TR*               NAME_FORMAT      AS NAME_FORMAT,                          
MFA-TR*               SSN              AS SSN,                                  
MFA-TR*               ITIN             AS ITIN,                                 
MFA-TR*               OTHER_ID         AS OTHER_ID,                             
MFA-TR*               OTHER_ID_TYPE    AS OTHER_ID_TYPE,                        
MFA-TR*               DLN              AS DRIVERS_LICENSE_NO,                   
MFA-TR*               DLN_STATE        AS DLN_STATE,                            
MFA-TR*               DOB              AS DATE_OF_BIRTH,                        
MFA-TR*               EMPLOYER         AS EMPLOYER,                             
MFA-TR*               EMAIL_ADDRESS    AS EMAIL_ADDRESS,                        
MFA-TR*               TAX_ID           AS TAX_ID,                               
MFA-TR*               SBU_CD           AS SBU_CD,                               
MFA-TR*               FIRST_NAME       AS FIRST_NAME,                           
MFA-TR*               MIDDLE_NAME      AS MIDDLE_NAME,                          
MFA-TR*               LAST_NAME        AS LAST_NAME,                            
MFA-TR*               PROP_MGR_FL      AS PROP_MGR_FL                           
MFA-TR*         FROM SESSION.CSR04806_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CODE,               
                      :S-CUSTOMER-NO      AS CUSTOMER_NO,               
                      :S-CUSTOMER-TYPE    AS CUSTOMER_TYPE,             
                      :S-CUSTOMER-NAME    AS CUSTOMER_NAME,             
                      :S-NAME-FORMAT      AS NAME_FORMAT,               
                      :S-SSN              AS SSN,                       
                      :S-ITIN             AS ITIN,                      
                      :S-OTHER-ID         AS OTHER_ID,                  
                      :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,             
                      :S-DLN              AS DRIVERS_LICENSE_NO,        
                      :S-DLN-STATE        AS DLN_STATE,                 
                      :S-DOB              AS DATE_OF_BIRTH,             
                      :S-EMPLOYER         AS EMPLOYER,                  
                      :S-EMAIL-ADDRESS    AS EMAIL_ADDRESS,             
                      :S-TAX-ID           AS TAX_ID,                    
                      :S-SBU-CD           AS SBU_CD,                    
                      :S-FIRST-NAME       AS FIRST_NAME,                
                      :S-MIDDLE-NAME      AS MIDDLE_NAME,               
                      :S-LAST-NAME        AS LAST_NAME,                 
A05317                :S-PROP-MGR-FL      AS PROP_MGR_FL                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CODE,                       
MFA-TR*               :S-CUSTOMER-NO      AS CUSTOMER_NO,                       
MFA-TR*               :S-CUSTOMER-TYPE    AS CUSTOMER_TYPE,                     
MFA-TR*               :S-CUSTOMER-NAME    AS CUSTOMER_NAME,                     
MFA-TR*               :S-NAME-FORMAT      AS NAME_FORMAT,                       
MFA-TR*               :S-SSN              AS SSN,                               
MFA-TR*               :S-ITIN             AS ITIN,                              
MFA-TR*               :S-OTHER-ID         AS OTHER_ID,                          
MFA-TR*               :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,                     
MFA-TR*               :S-DLN              AS DRIVERS_LICENSE_NO,                
MFA-TR*               :S-DLN-STATE        AS DLN_STATE,                         
MFA-TR*               :S-DOB              AS DATE_OF_BIRTH,                     
MFA-TR*               :S-EMPLOYER         AS EMPLOYER,                          
MFA-TR*               :S-EMAIL-ADDRESS    AS EMAIL_ADDRESS,                     
MFA-TR*               :S-TAX-ID           AS TAX_ID,                            
MFA-TR*               :S-SBU-CD           AS SBU_CD,                            
MFA-TR*               :S-FIRST-NAME       AS FIRST_NAME,                        
MFA-TR*               :S-MIDDLE-NAME      AS MIDDLE_NAME,                       
MFA-TR*               :S-LAST-NAME        AS LAST_NAME,                         
MFA-TR*               :S-PROP-MGR-FL      AS PROP_MGR_FL                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING  FOR
               SELECT RETURN_CODE        AS RETURN_CODE,                
                      PHONE_NAME_TYPE    AS PHONE_NAME_TYPE,            
                      PHONE_TYPE         AS PHONE_TYPE,                 
                      PHONE_NO           AS PHONE_NO,                   
                      PHONE_EXT          AS PHONE_EXT,                  
                      PHONE_MOBILE_FL    AS PHONE_MOBILE_FL,            
                      PHONE_MKT_FL       AS PHONE_MKT_FL,               
                      PHONE_MKT_DT       AS PHONE_MKT_DT                
                FROM #CSR04806_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING  FOR        
MFA-TR*        SELECT RETURN_CODE        AS RETURN_CODE,                        
MFA-TR*               PHONE_NAME_TYPE    AS PHONE_NAME_TYPE,                    
MFA-TR*               PHONE_TYPE         AS PHONE_TYPE,                         
MFA-TR*               PHONE_NO           AS PHONE_NO,                           
MFA-TR*               PHONE_EXT          AS PHONE_EXT,                          
MFA-TR*               PHONE_MOBILE_FL    AS PHONE_MOBILE_FL,                    
MFA-TR*               PHONE_MKT_FL       AS PHONE_MKT_FL,                       
MFA-TR*               PHONE_MKT_DT       AS PHONE_MKT_DT                        
MFA-TR*         FROM SESSION.CSR04806_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2      AS RETURN_CODE,             
                      :S-PHONE-NAME-TYPE    AS PHONE_NAME_TYPE,         
                      :S-PHONE-TYPE         AS PHONE_TYPE,              
                      :S-PHONE-NO           AS PHONE_NO,                
                      :S-PHONE-EXT          AS PHONE_EXT,               
                      :S-PHONE-MOBILE-FL    AS PHONE_MOBILE_FL,         
                      :S-PHONE-MKT-FL       AS PHONE_MKT_FL,            
                      :S-PHONE-MKT-DT       AS PHONE_MKT_DT             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2      AS RETURN_CODE,                     
MFA-TR*               :S-PHONE-NAME-TYPE    AS PHONE_NAME_TYPE,                 
MFA-TR*               :S-PHONE-TYPE         AS PHONE_TYPE,                      
MFA-TR*               :S-PHONE-NO           AS PHONE_NO,                        
MFA-TR*               :S-PHONE-EXT          AS PHONE_EXT,                       
MFA-TR*               :S-PHONE-MOBILE-FL    AS PHONE_MOBILE_FL,                 
MFA-TR*               :S-PHONE-MKT-FL       AS PHONE_MKT_FL,                    
MFA-TR*               :S-PHONE-MKT-DT       AS PHONE_MKT_DT                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      ACCOUNT_NO        AS ACCOUNT_NO,                  
                      TOWN              AS TOWN,                        
                      SERVICE_ADDRESS   AS SERVICE_ADDRESS,             
                      ACCOUNT_ID        AS ACCOUNT_ID,                  
                      TOTAL_AR_BALANCE  AS TOTAL_AR_BALANCE,            
                      MST_SUB_ACCT_IND  AS MST_SUB_ACCT_IND,            
                      DUE_DT            AS DUE_DT,                      
                      SORT_ORDER        AS SORT_ORDER,                  
                      ACCOUNT_TYPE_CODE AS ACCOUNT_TYPE_CODE,           
                      CODE_ACCT_STAT    AS CODE_ACCT_STAT,              
                      DBA_NAME          AS DBA_NAME,                    
                      COMPANY_NO        AS COMPANY_NO,                  
                      REG_GROUP_CD      AS REG_GROUP_CD,                
                      STREET_NAME       AS STREET_NAME,                 
                      HOUSE_NO          AS HOUSE_NO,                    
                      PYMT_SCHED_DT     AS PYMT_SCHED_DT,               
                      PYMT_METHOD       AS PYMT_METHOD,                 
                      OUTAGE_FL         AS OUTAGE_FL,                   
                      ARREARS_AMT       AS ARREARS_AMT,                 
                      PYMT_SCHED_AMT    AS PYMT_SCHED_AMT,              
                      DNP_FL            AS DNP_FL,                      
                      DNP_DT            AS DNP_DT,                      
                      STA_REM_AMT       AS STA_REM_AMT,                 
                      MST_ACCT_NO       AS MST_ACCT_NO,                 
                      WQ_FOUND_FL       AS WQ_FOUND_FL,                 
                      SORT_DT           AS SORT_DT,                     
                      SORT_DUE_DT       AS SORT_DUE_DT,                 
                      RENEWAL_FL        AS RENEWAL_FL                   
                FROM #CSR04806_R3                                
                ORDER BY DNP_FL DESC,                                   
                         RENEWAL_FL DESC,                               
                         SORT_DT,                                       
                         SORT_DUE_DT,                                   
                         SORT_ORDER,                                    
                         TOWN,                                          
                         STREET_NAME,                                   
                         HOUSE_NO                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               ACCOUNT_NO        AS ACCOUNT_NO,                          
MFA-TR*               TOWN              AS TOWN,                                
MFA-TR*               SERVICE_ADDRESS   AS SERVICE_ADDRESS,                     
MFA-TR*               ACCOUNT_ID        AS ACCOUNT_ID,                          
MFA-TR*               TOTAL_AR_BALANCE  AS TOTAL_AR_BALANCE,                    
MFA-TR*               MST_SUB_ACCT_IND  AS MST_SUB_ACCT_IND,                    
MFA-TR*               DUE_DT            AS DUE_DT,                              
MFA-TR*               SORT_ORDER        AS SORT_ORDER,                          
MFA-TR*               ACCOUNT_TYPE_CODE AS ACCOUNT_TYPE_CODE,                   
MFA-TR*               CODE_ACCT_STAT    AS CODE_ACCT_STAT,                      
MFA-TR*               DBA_NAME          AS DBA_NAME,                            
MFA-TR*               COMPANY_NO        AS COMPANY_NO,                          
MFA-TR*               REG_GROUP_CD      AS REG_GROUP_CD,                        
MFA-TR*               STREET_NAME       AS STREET_NAME,                         
MFA-TR*               HOUSE_NO          AS HOUSE_NO,                            
MFA-TR*               PYMT_SCHED_DT     AS PYMT_SCHED_DT,                       
MFA-TR*               PYMT_METHOD       AS PYMT_METHOD,                         
MFA-TR*               OUTAGE_FL         AS OUTAGE_FL,                           
MFA-TR*               ARREARS_AMT       AS ARREARS_AMT,                         
MFA-TR*               PYMT_SCHED_AMT    AS PYMT_SCHED_AMT,                      
MFA-TR*               DNP_FL            AS DNP_FL,                              
MFA-TR*               DNP_DT            AS DNP_DT,                              
MFA-TR*               STA_REM_AMT       AS STA_REM_AMT,                         
MFA-TR*               MST_ACCT_NO       AS MST_ACCT_NO,                         
MFA-TR*               WQ_FOUND_FL       AS WQ_FOUND_FL,                         
MFA-TR*               SORT_DT           AS SORT_DT,                             
MFA-TR*               SORT_DUE_DT       AS SORT_DUE_DT,                         
MFA-TR*               RENEWAL_FL        AS RENEWAL_FL                           
MFA-TR*         FROM SESSION.CSR04806_R3                                        
MFA-TR*         ORDER BY DNP_FL DESC,                                           
MFA-TR*                  RENEWAL_FL DESC,                                       
MFA-TR*                  SORT_DT,                                               
MFA-TR*                  SORT_DUE_DT,                                           
MFA-TR*                  SORT_ORDER,                                            
MFA-TR*                  TOWN,                                                  
MFA-TR*                  STREET_NAME,                                           
MFA-TR*                  HOUSE_NO                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-ACCOUNT-NO        AS ACCOUNT_NO,               
                      :S-TOWN              AS TOWN,                     
                      :S-SERVICE-ADDRESS   AS SERVICE_ADDRESS,          
                      :S-ACCOUNT-ID        AS ACCOUNT_ID,               
                      :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,         
                      :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,         
                      :S-DUE-DT            AS DUE_DT,                   
                      :S-SORT-ORDER        AS SORT_ORDER,               
                      :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,        
                      :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,           
                      :S-DBA-NAME          AS DBA_NAME,                 
                      :S-COMPANY-NO        AS COMPANY_NO,               
                      :S-REG-GROUP-CD      AS REG_GROUP_CD,             
                      :S-STREET-NAME       AS STREET_NAME,              
                      :S-HOUSE-NO          AS HOUSE_NO,                 
                      :S-PYMT-SCHED-DT     AS PYMT_SCHED_DT,            
                      :S-PYMT-METHOD       AS PYMT_METHOD,              
                      :S-OUTAGE-FL         AS OUTAGE_FL,                
                      :S-ARREARS-AMT       AS ARREARS_AMT,              
                      :S-PYMT-SCHED-AMT    AS PYMT_SCHED_AMT,           
                      :S-DNP-FL            AS DNP_FL,                   
                      :S-DNP-DT            AS DNP_DT,                   
                      :S-STA-REM-AMT       AS STA_REM_AMT,              
                      :S-MST-ACCT-NO       AS MST_ACCT_NO,              
                      :S-WQ-FOUND-FL       AS WQ_FOUND_FL,              
                      :S-SORT-DT           AS SORT_DT,                  
                      :S-SORT-DUE-DT       AS SORT_DUE_DT,              
                      :S-RENEWAL-FL        AS RENEWAL_FL                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-ACCOUNT-NO        AS ACCOUNT_NO,                       
MFA-TR*               :S-TOWN              AS TOWN,                             
MFA-TR*               :S-SERVICE-ADDRESS   AS SERVICE_ADDRESS,                  
MFA-TR*               :S-ACCOUNT-ID        AS ACCOUNT_ID,                       
MFA-TR*               :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,                 
MFA-TR*               :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,                 
MFA-TR*               :S-DUE-DT            AS DUE_DT,                           
MFA-TR*               :S-SORT-ORDER        AS SORT_ORDER,                       
MFA-TR*               :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,                
MFA-TR*               :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,                   
MFA-TR*               :S-DBA-NAME          AS DBA_NAME,                         
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO,                       
MFA-TR*               :S-REG-GROUP-CD      AS REG_GROUP_CD,                     
MFA-TR*               :S-STREET-NAME       AS STREET_NAME,                      
MFA-TR*               :S-HOUSE-NO          AS HOUSE_NO,                         
MFA-TR*               :S-PYMT-SCHED-DT     AS PYMT_SCHED_DT,                    
MFA-TR*               :S-PYMT-METHOD       AS PYMT_METHOD,                      
MFA-TR*               :S-OUTAGE-FL         AS OUTAGE_FL,                        
MFA-TR*               :S-ARREARS-AMT       AS ARREARS_AMT,                      
MFA-TR*               :S-PYMT-SCHED-AMT    AS PYMT_SCHED_AMT,                   
MFA-TR*               :S-DNP-FL            AS DNP_FL,                           
MFA-TR*               :S-DNP-DT            AS DNP_DT,                           
MFA-TR*               :S-STA-REM-AMT       AS STA_REM_AMT,                      
MFA-TR*               :S-MST-ACCT-NO       AS MST_ACCT_NO,                      
MFA-TR*               :S-WQ-FOUND-FL       AS WQ_FOUND_FL,                      
MFA-TR*               :S-SORT-DT           AS SORT_DT,                          
MFA-TR*               :S-SORT-DUE-DT       AS SORT_DUE_DT,                      
MFA-TR*               :S-RENEWAL-FL        AS RENEWAL_FL                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      ACCOUNT_NO        AS ACCOUNT_NO,                  
                      TOWN              AS TOWN,                        
                      SERVICE_ADDRESS   AS SERVICE_ADDRESS,             
                      ACCOUNT_ID        AS ACCOUNT_ID,                  
                      TOTAL_AR_BALANCE  AS TOTAL_AR_BALANCE,            
                      MST_SUB_ACCT_IND  AS MST_SUB_ACCT_IND,            
                      DUE_DT            AS DUE_DT,                      
                      SORT_ORDER        AS SORT_ORDER,                  
                      ACCOUNT_TYPE_CODE AS ACCOUNT_TYPE_CODE,           
                      CODE_ACCT_STAT    AS CODE_ACCT_STAT,              
                      DBA_NAME          AS DBA_NAME,                    
                      COMPANY_NO        AS COMPANY_NO,                  
                      REG_GROUP_CD      AS REG_GROUP_CD,                
                      STREET_NAME       AS STREET_NAME,                 
                      HOUSE_NO          AS HOUSE_NO,                    
                      PYMT_SCHED_DT     AS PYMT_SCHED_DT,               
                      PYMT_METHOD       AS PYMT_METHOD,                 
                      OUTAGE_FL         AS OUTAGE_FL,                   
                      ARREARS_AMT       AS ARREARS_AMT,                 
                      PYMT_SCHED_AMT    AS PYMT_SCHED_AMT,              
                      DNP_FL            AS DNP_FL,                      
                      DNP_DT            AS DNP_DT,                      
                      STA_REM_AMT       AS STA_REM_AMT,                 
                      MST_ACCT_NO       AS MST_ACCT_NO,                 
                      WQ_FOUND_FL       AS WQ_FOUND_FL,                 
                      SORT_DT           AS SORT_DT,                     
                      SORT_DUE_DT       AS SORT_DUE_DT,                 
                      RENEWAL_FL        AS RENEWAL_FL                   
                FROM #CSR04806_R3                                
                ORDER BY SORT_DT,                                       
                         SORT_ORDER,                                    
                         TOWN,                                          
                         STREET_NAME,                                   
                         HOUSE_NO,                                      
                         STREET_LOCATION_1,                             
                         STREET_LOCATION_2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               ACCOUNT_NO        AS ACCOUNT_NO,                          
MFA-TR*               TOWN              AS TOWN,                                
MFA-TR*               SERVICE_ADDRESS   AS SERVICE_ADDRESS,                     
MFA-TR*               ACCOUNT_ID        AS ACCOUNT_ID,                          
MFA-TR*               TOTAL_AR_BALANCE  AS TOTAL_AR_BALANCE,                    
MFA-TR*               MST_SUB_ACCT_IND  AS MST_SUB_ACCT_IND,                    
MFA-TR*               DUE_DT            AS DUE_DT,                              
MFA-TR*               SORT_ORDER        AS SORT_ORDER,                          
MFA-TR*               ACCOUNT_TYPE_CODE AS ACCOUNT_TYPE_CODE,                   
MFA-TR*               CODE_ACCT_STAT    AS CODE_ACCT_STAT,                      
MFA-TR*               DBA_NAME          AS DBA_NAME,                            
MFA-TR*               COMPANY_NO        AS COMPANY_NO,                          
MFA-TR*               REG_GROUP_CD      AS REG_GROUP_CD,                        
MFA-TR*               STREET_NAME       AS STREET_NAME,                         
MFA-TR*               HOUSE_NO          AS HOUSE_NO,                            
MFA-TR*               PYMT_SCHED_DT     AS PYMT_SCHED_DT,                       
MFA-TR*               PYMT_METHOD       AS PYMT_METHOD,                         
MFA-TR*               OUTAGE_FL         AS OUTAGE_FL,                           
MFA-TR*               ARREARS_AMT       AS ARREARS_AMT,                         
MFA-TR*               PYMT_SCHED_AMT    AS PYMT_SCHED_AMT,                      
MFA-TR*               DNP_FL            AS DNP_FL,                              
MFA-TR*               DNP_DT            AS DNP_DT,                              
MFA-TR*               STA_REM_AMT       AS STA_REM_AMT,                         
MFA-TR*               MST_ACCT_NO       AS MST_ACCT_NO,                         
MFA-TR*               WQ_FOUND_FL       AS WQ_FOUND_FL,                         
MFA-TR*               SORT_DT           AS SORT_DT,                             
MFA-TR*               SORT_DUE_DT       AS SORT_DUE_DT,                         
MFA-TR*               RENEWAL_FL        AS RENEWAL_FL                           
MFA-TR*         FROM SESSION.CSR04806_R3                                        
MFA-TR*         ORDER BY SORT_DT,                                               
MFA-TR*                  SORT_ORDER,                                            
MFA-TR*                  TOWN,                                                  
MFA-TR*                  STREET_NAME,                                           
MFA-TR*                  HOUSE_NO,                                              
MFA-TR*                  STREET_LOCATION_1,                                     
MFA-TR*                  STREET_LOCATION_2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-CONTACT-ID         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO                              
                          LINK-CONTACT-ID.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -16, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-16-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES (DATE(:WS-CURRENT-DATE) - 16 MONTHS)                       
MFA-TR*         INTO :WS-DATE-MINUS-16-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -90, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-90-DAYS                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 90 DAYS)                       
MFA-TR*          INTO :WS-DATE-MINUS-90-DAYS                                    
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04806_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04806_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               CUSTOMER_NO          DECIMAL(10,0),                      
               CUSTOMER_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               CUSTOMER_NAME CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,         
               NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               ITIN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               OTHER_ID CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2,              
               OTHER_ID_TYPE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,         
               DLN CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               DLN_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DOB CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               EMPLOYER CHAR(23)  COLLATE LATIN1_GENERAL_100_BIN2,              
               EMAIL_ADDRESS CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2,        
               TAX_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                
               SBU_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                
               FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,            
               MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,           
               LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,             
A05317         PROP_MGR_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04806_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04806_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04806_R2
              (                                                          
               RETURN_CODE          INT,                            
               PHONE_NAME_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PHONE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
               PHONE_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2,             
               PHONE_MOBILE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PHONE_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               PHONE_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT02-ROWS THRU 8002-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04806_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04806_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04806_R3
              (                                                          
               RETURN_CODE          INT,                            
               ACCOUNT_NO           DECIMAL(13,0),                      
               TOWN CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               SERVICE_ADDRESS CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ACCOUNT_ID CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2,            
               TOTAL_AR_BALANCE     DECIMAL(13,2),                      
               MST_SUB_ACCT_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DUE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                
               SORT_ORDER           SMALLINT,                           
               ACCOUNT_TYPE_CODE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               DBA_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2,              
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               REG_GROUP_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,           
               HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               PYMT_SCHED_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               PYMT_METHOD CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SORT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               OUTAGE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               ARREARS_AMT          DECIMAL(13,2),                      
               PYMT_SCHED_AMT       DECIMAL(13,2),                      
               DNP_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                
               DNP_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                
               STA_REM_AMT          DECIMAL(13,2),                      
               MST_ACCT_NO          DECIMAL(13,0),                      
               WQ_FOUND_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SORT_DUE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_LOCATION_1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               STREET_LOCATION_2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODES_DATA_PRESENT CHAR(32)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               RENEWAL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT03-ROWS THRU 8003-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04806_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           IF LINK-CONTACT-ID NOT NUMERIC                               
               MOVE ZEROES TO LINK-CONTACT-ID
           END-IF.                          
           MOVE LINK-CONTACT-ID TO WS-CONTACT-ID-CHAR.                  
           MOVE WS-CONTACT-ID-NUM TO DW-CONTACT-ID                      
                                     DT-CONTACT-ID.                     
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           MOVE 'WEB-LIST-ACCT-CT' TO C8-DELINQ-CD.                     
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-ACCOUNT-THRESHOLD.                
                                                                        
           IF CSR-DATABASE                                              
               MOVE '01' TO C8-COMPANY-NO                               
               PERFORM 7110-WRITE-OFF-CUTOFF THRU 7110-EXIT             
               MOVE WS-WOFF-DT TO WS-WOFF-DT-01                         
               MOVE '26' TO C8-COMPANY-NO                               
               PERFORM 7110-WRITE-OFF-CUTOFF THRU 7110-EXIT             
               MOVE WS-WOFF-DT TO WS-WOFF-DT-26
           END-IF.                        
                                                                        
           IF LINK-CUSTOMER-NO = ZEROES                                 
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-CUSTOMER-NAME                 
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULTS-3 THRU 2200-EXIT.                 
           PERFORM 2100-CUST-SPOUSE-INFO THRU 2100-EXIT.                
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'NO DATA' TO S-CUSTOMER-NAME                        
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-CUST-SPOUSE-INFO.                                           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE CU-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           PERFORM 7025-SELECT-CUST-NAME THRU 7025-EXIT.                
           MOVE WS-CUST-NAME TO S-CUSTOMER-NAME.                        
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
                                                                        
           MOVE 'C' TO CE-CUSTOMER-TYPE                                 
                       S-CUSTOMER-TYPE.                                 
           PERFORM 7030-SELECT-STATS THRU 7030-EXIT.                    
           MOVE CE-SSN TO S-SSN.                                        
           MOVE CE-ITIN-ID TO S-ITIN.                                   
           MOVE CE-OTHER-ID TO S-OTHER-ID.                              
           MOVE CE-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE CE-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE CE-CODE-STATE-ID TO S-DLN-STATE.                        
           MOVE CE-DATE-OF-BIRTH TO S-DOB.                              
           MOVE CE-EMPLOYER TO S-EMPLOYER.                              
                                                                        
           MOVE CU-CUSTOMER-NO TO BS-CUSTOMER-NO.                       
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           MOVE BS-TAX-ID TO S-TAX-ID.                                  
                                                                        
A05317     PERFORM 7160-GET-LANDLORD THRU 7160-EXIT.                    
                                                                        
           MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
                                                                        
           MOVE CU-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
           MOVE 'P1' TO NE-EMAIL-TYPE-CD.                               
           PERFORM 7070-SELECT-EMAIL THRU 7070-EXIT.                    
           MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS.            
                                                                        
           EVALUATE TRUE ALSO TRUE                                      
               WHEN WS-SCEG-FL = 'Y' ALSO WS-PSNC-FL = 'Y'              
                   MOVE 'B' TO S-SBU-CD                                 
               WHEN WS-SCEG-FL = 'Y' ALSO WS-PSNC-FL = 'N'              
                   MOVE 'S' TO S-SBU-CD                                 
               WHEN WS-SCEG-FL = 'N' ALSO WS-PSNC-FL = 'Y'              
                   MOVE 'P' TO S-SBU-CD                                 
               WHEN WS-SEB-FL = 'Y' ALSO WS-SEBR-FL = 'Y'               
                   MOVE 'B' TO S-SBU-CD                                 
               WHEN WS-SEB-FL = 'Y' ALSO WS-SEBR-FL = 'N'               
                   MOVE 'D' TO S-SBU-CD                                 
               WHEN WS-SEB-FL = 'N' ALSO WS-SEBR-FL = 'Y'               
                   MOVE 'R' TO S-SBU-CD                                 
           END-EVALUATE.                                                
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           MOVE 'S' TO CE-CUSTOMER-TYPE.                                
           PERFORM 7030-SELECT-STATS THRU 7030-EXIT.                    
           IF CE-CUSTOMER-NO > 0                                        
               PERFORM 2110-SPOUSE-INFO THRU 2110-EXIT
           END-IF.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-SPOUSE-INFO.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE CU-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE CE-SSN TO S-SSN.                                        
           MOVE CE-ITIN-ID TO S-ITIN.                                   
           MOVE CE-OTHER-ID TO S-OTHER-ID.                              
           MOVE CE-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE CE-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE CE-CODE-STATE-ID TO S-DLN-STATE.                        
           MOVE CE-DATE-OF-BIRTH TO S-DOB.                              
           MOVE CE-EMPLOYER TO S-EMPLOYER.                              
                                                                        
           MOVE CE-NAME-ID TO DQ-NAME-ID.                               
           PERFORM 7080-SELECT-SPOUSE-NAME THRU 7080-EXIT.              
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE WS-SPOUSE-NAME TO S-CUSTOMER-NAME.                      
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
A05317     MOVE 'N' TO S-PROP-MGR-FL.                                   
                                                                        
           MOVE 'S' TO CB-CUSTOMER-TYPE                                 
                       S-CUSTOMER-TYPE.                                 
           MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
                                                                        
           MOVE 'S1' TO NE-EMAIL-TYPE-CD.                               
           PERFORM 7070-SELECT-EMAIL THRU 7070-EXIT.                    
           MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS.            
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
           END-IF                                                       
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-BUILD-RESULTS-3.                                            
                                                                        
           MOVE CU-CUSTOMER-NO TO AT-CUSTOMER-NO.                       
           IF DT-CONTACT-ID > ZEROES                                    
               MOVE 'N' TO WS-CONTACT-CUST-FL                           
               PERFORM 7310-CONTACT-CUSTOMER THRU 7310-EXIT
           END-IF.            
                                                                        
           PERFORM 7060-OPEN-ACCOUNT-CURSOR THRU 7060-EXIT.             
           PERFORM 2210-FETCH-ROWS THRU 2210-EXIT.                      
           PERFORM 7061-CLOSE-ACCOUNT-CURSOR THRU 7061-EXIT.            
                                                                        
           IF WS-ACCOUNT-CT <= WS-ACCOUNT-THRESHOLD                     
               PERFORM 7290-OPEN-TEMP-CURSOR THRU 7290-EXIT             
               PERFORM 2280-FETCH-ROWS THRU 2280-EXIT                   
               PERFORM 7291-CLOSE-TEMP-CURSOR THRU 7291-EXIT
           END-IF.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * SORT ORDER: PAY BOX COLUMN                                              
      *                 NON-ZERO BALANCE                                        
      *             DUE DATE ASCENDING                                          
      *                 DATE ARTIFICIALLY SET FOR ACCOUNTS WITH                 
      *                 ZERO BALANCE TO OMIT THIS SORT CRITERIA                 
      *             ACCOUNT STATUS                                              
      *                 ACTIVE                                                  
      *                 PENDING                                                 
      *                 FINAL BILL                                              
      *                 WRITE OFF                                               
      *                 INACTIVE                                                
      *             TOWN                                                        
      *             STREET NAME                                                 
      *             HOUSE NUMBER                                                
                                                                        
       2210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCOUNT-CURSOR                                     
                INTO :AT-ACCOUNT-NO,                                    
                     :WS-TOWN,                                          
                     :DY-ADDR-USAGE-CD,                                 
                     :AT-CODE-ACCT-STAT,                                
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-ACCT-CREATE-DT :WS-NULL-3,                      
                     :AT-ACCT-FINALED-DT :WS-NULL-4,                     
                     :AT-CREDIT-GROUP,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-JUDGEMENT-IND,                                 
                     :AT-DATE-BILL-DAY-00,                              
                     :AT-PREMISE-NO,                                    
                     :AT-COMPANY-NO,                                    
                     :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT,                                
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :AT-CODES-DATA-PRESENT,                            
                     :WS-ADDRESS-LINE,                                  
                     :WS-ADDRESS-LINE-I,                                
                     :AT-DATE-BILL-DAY-30,                              
                     :AT-DATE-BILL-DAY-60,                              
                     :AT-DATE-BILL-DAY-90,                              
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-IVR-EXEMPT-CD,                                 
                     :AT-CODE-DISC-OK,                                  
                     :AT-LOCAL-OFFICE,                                  
                     :AT-REV-MTH-LST-NRML                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2210-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE SPACES TO WS-RETURN-ACCT-FL                             
                          WS-ATTORNEY-FL.                               
           PERFORM 2220-ACCT-DETERMINATION THRU 2220-EXIT.              
                                                                        
           IF WS-RETURN-ACCT-FL = 'Y'                                   
               PERFORM 2240-RETURN-ACCOUNT THRU 2240-EXIT
           END-IF.              
                                                                        
           GO TO 2210-FETCH-ROWS.                                       
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2220-ACCT-DETERMINATION.                                         
                                                                        
           MOVE 'N' TO WS-RETURN-ACCT-FL.                               
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'A'                                                 
                   MOVE 'Y' TO WS-RETURN-ACCT-FL                        
               WHEN 'B'                                                 
                   IF (AT-TOTAL-AR-BALANCE NOT = 0) OR                  
                      (AT-TOTAL-AR-BALANCE = 0 AND                      
                       AT-ACCT-FINALED-DT(1:10) >=                      
                       WS-DATE-MINUS-16-MONTHS)                         
                           MOVE 'Y' TO WS-RETURN-ACCT-FL                
                   END-IF                                               
               WHEN 'P'                                                 
                   IF SEB-DATABASE                                      
                       IF (AT-ACCT-CREATE-DT(1:10) >=                   
                           WS-DATE-MINUS-90-DAYS) OR                    
                           AT-ACCOUNT-NO = 9310129132623                
                               MOVE 'Y' TO WS-RETURN-ACCT-FL            
                       END-IF                                           
                   ELSE                                                 
                       PERFORM 7100-CC-NC-ORDER THRU 7100-EXIT          
                       IF WS-ORDER-EXISTS-FL = 'Y'                      
                           MOVE 'Y' TO WS-RETURN-ACCT-FL                
                       END-IF                                           
                   END-IF                                               
                   IF WS-RETURN-ACCT-FL = 'Y' AND                       
                      CSR-DATABASE                                      
                          MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO     
                          PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT 
                          MOVE WS-CPD99-ACCOUNT-NO TO WS-ACCOUNT-NO     
                          IF WS-ACCOUNT-NO > 0                          
                              PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT
                          ELSE                                          
                              MOVE SPACES TO AT-ACCOUNT-TYPE-CODE       
                          END-IF                                        
                   END-IF                                               
               WHEN 'S'                                                 
                   PERFORM 7120-SELECT-FINAL-WO THRU 7120-EXIT          
                   IF (FW-COLLECT-STATUS-CD = 'D' OR 'E') OR            
                       AT-BANKRUPTCY-IND = 'B' OR                       
                       AT-JUDGEMENT-IND = 'J'                           
                           MOVE 'Y' TO WS-ATTORNEY-FL                   
                   END-IF                                               
                   IF CSR-DATABASE                                      
                       EVALUATE AT-COMPANY-NO                           
                           WHEN '01'                                    
                               MOVE WS-WOFF-DT-01 TO WS-WOFF-DT         
                           WHEN '26'                                    
                               MOVE WS-WOFF-DT-26 TO WS-WOFF-DT         
                       END-EVALUATE                                     
                   ELSE                                                 
                       MOVE '1900-01-01' TO WS-WOFF-DT                  
                   END-IF                                               
                   PERFORM 7150-CHARGE-OFF THRU 7150-EXIT               
                   IF CO-AMT-TRANS > 0                                  
                       IF WS-ATTORNEY-FL = 'Y'                          
                           MOVE 'N' TO WS-RETURN-ACCT-FL                
                       ELSE                                             
                           MOVE 'Y' TO WS-RETURN-ACCT-FL                
                       END-IF                                           
                   ELSE                                                 
                       IF AT-ACCT-FINALED-DT(1:10) >=                   
                          WS-DATE-MINUS-16-MONTHS                       
                              IF WS-ATTORNEY-FL = 'Y'                   
                                  MOVE 'N' TO WS-RETURN-ACCT-FL         
                              ELSE                                      
                                  MOVE 'Y' TO WS-RETURN-ACCT-FL         
                              END-IF                                    
                       END-IF                                           
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           IF DW-CONTACT-ID > ZEROES AND                                
              WS-CONTACT-CUST-FL = 'N' AND                              
              WS-RETURN-ACCT-FL = 'Y'                                   
                  PERFORM 7300-CONTACT-ACCOUNT THRU 7300-EXIT           
                  IF DW-ACCOUNT-NO = ZEROES                             
                      MOVE 'N' TO WS-RETURN-ACCT-FL
                  END-IF
           END-IF.                    
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2240-RETURN-ACCOUNT.                                             
                                                                        
           MOVE AT-ACCOUNT-NO TO TA-ACCOUNT-NO.                         
           PERFORM 7090-ACCT-MISC-INFO THRU 7090-EXIT.                  
           PERFORM 7130-SELECT-DBA THRU 7130-EXIT.                      
           IF AT-MST-SUB-ACCT-IND = 'M' AND                             
              AT-ADDRESS-ID > 0                                         
                  EVALUATE AT-ADDRESS-FORMAT                            
                      WHEN 'A'                                          
                          PERFORM 7190-FMT-BILL-ADDR THRU 7190-EXIT     
                      WHEN 'B'                                          
                          PERFORM 7200-FRE-BILL-ADDR THRU 7200-EXIT     
                  END-EVALUATE
           END-IF.                                         
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               PERFORM 7250-MST-SUB THRU 7250-EXIT
           END-IF.                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE AT-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE AT-CODES-DATA-PRESENT TO S-CODES-DATA-PRESENT.          
           MOVE WS-TOWN TO S-TOWN.                                      
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE WS-ADDRESS-LINE-I TO S-SERVICE-ADDRESS              
           ELSE                                                         
               MOVE WS-ADDRESS-LINE TO S-SERVICE-ADDRESS
           END-IF.               
           MOVE TA-SPCL-BILL-STMNT-TX TO S-ACCOUNT-ID.                  
           IF AT-CODE-ACCT-STAT = 'S'                                   
               COMPUTE S-TOTAL-AR-BALANCE =                             
                       CO-AMT-TRANS +                                   
                       AT-TOTAL-AR-BALANCE                              
           ELSE                                                         
               MOVE AT-TOTAL-AR-BALANCE TO S-TOTAL-AR-BALANCE
           END-IF.          
           MOVE AT-MST-SUB-ACCT-IND TO S-MST-SUB-ACCT-IND.              
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               MOVE MU-MST-ACCT-NO TO S-MST-ACCT-NO
           END-IF.                    
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE AT-CODE-ACCT-STAT TO S-CODE-ACCT-STAT.                  
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'A'                                                 
                   MOVE +100 TO S-SORT-ORDER                            
               WHEN 'P'                                                 
                   MOVE +200 TO S-SORT-ORDER                            
               WHEN 'B'                                                 
                   MOVE +300 TO S-SORT-ORDER                            
               WHEN 'S'                                                 
                   MOVE +400 TO S-SORT-ORDER                            
           END-EVALUATE.                                                
           MOVE DQ-FULL-NAME TO S-DBA-NAME.                             
           MOVE AT-COMPANY-NO TO S-COMPANY-NO.                          
           IF CSR-DATABASE                                              
               EVALUATE AT-COMPANY-NO                                   
                   WHEN '01'                                            
                       MOVE 'Y' TO WS-SCEG-FL                           
                   WHEN '26'                                            
                       MOVE 'Y' TO WS-PSNC-FL                           
               END-EVALUATE
           END-IF.                                            
           MOVE DY-STREET-NAME TO S-STREET-NAME.                        
           MOVE DY-HOUSE-NO TO S-HOUSE-NO.                              
           MOVE DY-STREET-LOCATION-1 TO S-STREET-LOC-1.                 
           MOVE DY-STREET-LOCATION-2 TO S-STREET-LOC-2.                 
           IF SEB-DATABASE                                              
               PERFORM 7140-REG-PROFILE THRU 7140-EXIT                  
               MOVE LR-REG-GROUP-CD TO S-REG-GROUP-CD                   
               EVALUATE LR-REG-GROUP-CD                                 
                   WHEN SPACES                                          
                       MOVE 'Y' TO WS-SEB-FL                            
                   WHEN OTHER                                           
                       MOVE 'Y' TO WS-SEBR-FL                           
               END-EVALUATE                                             
               MOVE 'G' TO UT-CODE-UTIL-TYPE                            
               PERFORM 7280-UTILITY THRU 7280-EXIT                      
               IF UT-ACCOUNT-NO > ZEROES                                
                   PERFORM 7210-RENEWAL-FL THRU 7210-EXIT               
                   IF DF-STATUS-CD = 'O'                                
                       MOVE 'Y' TO S-RENEWAL-FL
                   END-IF
               END-IF
           END-IF.                        
                                                                        
           EVALUATE TRUE                                                
               WHEN S-TOTAL-AR-BALANCE > 0                              
                   MOVE '1900-01-01' TO S-SORT-DT                       
               WHEN S-TOTAL-AR-BALANCE = 0                              
                   MOVE '2999-12-31' TO S-SORT-DT                       
               WHEN S-TOTAL-AR-BALANCE < 0                              
                   MOVE '1959-06-28' TO S-SORT-DT                       
           END-EVALUATE.                                                
           MOVE 'N' TO S-OUTAGE-FL.                                     
           IF CSR-DATABASE AND                                          
              AT-COMPANY-NO = '01' AND                                  
              AT-CODE-ACCT-STAT = 'A'                                   
                  MOVE 'E' TO UT-CODE-UTIL-TYPE                         
                  PERFORM 7280-UTILITY THRU 7280-EXIT                   
                  IF UT-ACCOUNT-NO > ZEROES                             
                      MOVE 'Y' TO S-OUTAGE-FL
                  END-IF
           END-IF.                          
                                                                        
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
           IF AT-MST-SUB-ACCT-IND NOT = 'S'                             
               ADD +1 TO WS-ACCOUNT-CT
           END-IF.                                 
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2280-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH TEMP-CURSOR                                        
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CODE-ACCT-STAT,                                
                     :AT-TOTAL-AR-BALANCE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2280-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2280'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR04806_R3'    TO TABLE-1                     
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 6000-GET-ACCT-DATA THRU 6000-GET-ACCT-DATA-EXIT.     
                                                                        
           MOVE WS-375-DNP-DT TO S-DNP-DT.                              
           MOVE WS-375-DNP-FL TO S-DNP-FL.                              
           MOVE WS-DISPLAY-DUE-DATE TO S-DUE-DT.                        
           MOVE WS-BILLED-BALANCE TO S-TOTAL-AR-BALANCE.                
           MOVE WS-ARREARS-AMOUNT TO S-ARREARS-AMT.                     
           MOVE WS-BILL-EXCPN-WQ-FL TO S-WQ-FOUND-FL.                   
           IF WS-STA-EXISTS-FL = 'Y'                                    
               MOVE 99.99 TO S-STA-REM-AMT                              
           ELSE                                                         
               MOVE 0.00 TO S-STA-REM-AMT
           END-IF.                              
           IF AT-TOTAL-AR-BALANCE <= 0                                  
               MOVE '2999-12-31' TO S-SORT-DUE-DT                       
           ELSE                                                         
               MOVE S-DUE-DT TO S-SORT-DUE-DT
           END-IF.                          
           IF S-SORT-DUE-DT <= SPACES AND                               
              S-TOTAL-AR-BALANCE NOT = ZEROES                           
                  MOVE '2999-01-01' TO S-SORT-DUE-DT
           END-IF.                   
                                                                        
           PERFORM 8310-UPDATE-TEMP-3 THRU 8310-EXIT.                   
                                                                        
           GO TO 2280-FETCH-ROWS.                                       
                                                                        
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_TYPE_CODE,                                 
                     NOTICE_EXEMPT_CD,                                  
                     CODE_DISC_OK,                                      
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     BANKRUPTCY_IND,                                    
                     CREDIT_GROUP,                                      
                     IVR_EXEMPT_CD                                      
               INTO :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-NOTICE-EXEMPT-CD,                               
                    :AT-CODE-DISC-OK,                                   
                    :AT-DATE-BILL-DAY-00,                               
                    :AT-DATE-BILL-DAY-30,                               
                    :AT-DATE-BILL-DAY-60,                               
                    :AT-DATE-BILL-DAY-90,                               
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-BANKRUPTCY-IND,                                 
                    :AT-CREDIT-GROUP,                                   
                    :AT-IVR-EXEMPT-CD                                   
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE,                                         
MFA-TR*              NOTICE_EXEMPT_CD,                                          
MFA-TR*              CODE_DISC_OK,                                              
MFA-TR*              DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90,                                          
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              BANKRUPTCY_IND,                                            
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              IVR_EXEMPT_CD                                              
MFA-TR*        INTO :AT-ACCOUNT-TYPE-CODE,                                      
MFA-TR*             :AT-NOTICE-EXEMPT-CD,                                       
MFA-TR*             :AT-CODE-DISC-OK,                                           
MFA-TR*             :AT-DATE-BILL-DAY-00,                                       
MFA-TR*             :AT-DATE-BILL-DAY-30,                                       
MFA-TR*             :AT-DATE-BILL-DAY-60,                                       
MFA-TR*             :AT-DATE-BILL-DAY-90,                                       
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-LOCAL-OFFICE,                                           
MFA-TR*             :AT-BANKRUPTCY-IND,                                         
MFA-TR*             :AT-CREDIT-GROUP,                                           
MFA-TR*             :AT-IVR-EXEMPT-CD                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO AT-ACCOUNT-TYPE-CODE                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE WS-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   EVALUATE C8-DELINQ-CD                                
                       WHEN 'DATABASE'                                  
                           MOVE 1 TO C8-DELINQ-VALUE                    
                       WHEN 'WEB-LIST-ACCT-CT'                          
                           MOVE 25 TO C8-DELINQ-VALUE                   
                   END-EVALUATE                                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'      TO TABLE-ELEMENT-1             
                   MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-SELECT-CUST-NAME.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + 
           LTRIM(RTRIM(MIDDLE_NAME) + ' ' + LTRIM(RTRIM(LAST_NAME))))),
              FULL_NAME,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_SUFFIX_1,
              DHR_FL,
              COMPANY_NO_ORIG                                   
                 INTO :WS-CUST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-TITLE-SUFFIX-1,                               
                      :CU-DHR-FL,                                       
                      :CU-COMPANY-NO-ORIG                               
                 FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(LAST_NAME))))),                               
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               DHR_FL,                                                   
MFA-TR*               COMPANY_NO_ORIG                                           
MFA-TR*          INTO :WS-CUST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-TITLE-SUFFIX-1,                                       
MFA-TR*               :CU-DHR-FL,                                               
MFA-TR*               :CU-COMPANY-NO-ORIG                                       
MFA-TR*          FROM CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-CUST-NAME                
                       MOVE SPACES TO DQ-LAST-NAME                      
                                      DQ-FIRST-NAME                     
                                      DQ-MIDDLE-NAME                    
                                      DQ-TITLE-SUFFIX-1                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-CUST-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7025'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO,
              SSN,
              REFUSED_SSN_FL,
              DRIVERS_LICENSE_NO,
              OTHER_ID,
              PASSWORD_TX,
              DATE_OF_BIRTH,
              OTHER_ID_TYPE,
              CODE_STATE_ID,
              DOB_VERIFIED_CD,
              ACCESS_LEVEL_CD,
              ALLOW_CALL_FL,
              ITIN_ID,
              VERIFY_SSN_FL,
              PASSWORD_HINT,
              ALLOW_EMAIL_FL,
              EMPLOYER,
              NAME_ID                                           
                 INTO :CE-CUSTOMER-NO,                                  
                      :CE-SSN,                                          
                      :CE-REFUSED-SSN-FL,                               
                      :CE-DRIVERS-LICENSE-NO,                           
                      :CE-OTHER-ID,                                     
                      :CE-PASSWORD-TX,                                  
                      :CE-DATE-OF-BIRTH :WS-NULL-2,                      
                      :CE-OTHER-ID-TYPE,                                
                      :CE-CODE-STATE-ID,                                
                      :CE-DOB-VERIFIED-CD,                              
                      :CE-ACCESS-LEVEL-CD,                              
                      :CE-ALLOW-CALL-FL,                                
                      :CE-ITIN-ID,                                      
                      :CE-VERIFY-SSN-FL,                                
                      :CE-PASSWORD-HINT,                                
                      :CE-ALLOW-EMAIL-FL,                               
                      :CE-EMPLOYER,                                     
                      :CE-NAME-ID                                       
                 FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               SSN,                                                      
MFA-TR*               REFUSED_SSN_FL,                                           
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               PASSWORD_TX,                                              
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               CODE_STATE_ID,                                            
MFA-TR*               DOB_VERIFIED_CD,                                          
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               ALLOW_CALL_FL,                                            
MFA-TR*               ITIN_ID,                                                  
MFA-TR*               VERIFY_SSN_FL,                                            
MFA-TR*               PASSWORD_HINT,                                            
MFA-TR*               ALLOW_EMAIL_FL,                                           
MFA-TR*               EMPLOYER,                                                 
MFA-TR*               NAME_ID                                                   
MFA-TR*          INTO :CE-CUSTOMER-NO,                                          
MFA-TR*               :CE-SSN,                                                  
MFA-TR*               :CE-REFUSED-SSN-FL,                                       
MFA-TR*               :CE-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :CE-OTHER-ID,                                             
MFA-TR*               :CE-PASSWORD-TX,                                          
MFA-TR*               :CE-DATE-OF-BIRTH:WS-NULL-2,                              
MFA-TR*               :CE-OTHER-ID-TYPE,                                        
MFA-TR*               :CE-CODE-STATE-ID,                                        
MFA-TR*               :CE-DOB-VERIFIED-CD,                                      
MFA-TR*               :CE-ACCESS-LEVEL-CD,                                      
MFA-TR*               :CE-ALLOW-CALL-FL,                                        
MFA-TR*               :CE-ITIN-ID,                                              
MFA-TR*               :CE-VERIFY-SSN-FL,                                        
MFA-TR*               :CE-PASSWORD-HINT,                                        
MFA-TR*               :CE-ALLOW-EMAIL-FL,                                       
MFA-TR*               :CE-EMPLOYER,                                             
MFA-TR*               :CE-NAME-ID                                               
MFA-TR*          FROM CSS_CUST_STATS                                            
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-CUST-STATS                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TAX_ID                                            
                 INTO :BS-TAX-ID                                        
                 FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TAX_ID                                                    
MFA-TR*          INTO :BS-TAX-ID                                                
MFA-TR*          FROM CSS_BUS_CUST_STATS                                        
MFA-TR*         WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO BS-TAX-ID                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-PHONE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN PHONE-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7051-FETCH-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH PHONE-CURSOR                                       
                INTO :CB-PHONE-NO,                                      
                     :CB-PHONE-TYPE,                                    
                     :CB-EXTENSION-NO,                                  
                     :CB-MOBILE-PHONE-FL,                               
                     :CB-PERMISN-TO-MKT-DT :WS-NULL-5,                   
                     :CB-PERMISN-TO-MKT-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
                   INITIALIZE GTT-RETURN-FIELDS-2                       
                   MOVE CB-CUSTOMER-TYPE TO S-PHONE-NAME-TYPE           
                   MOVE CB-PHONE-TYPE TO S-PHONE-TYPE                   
                   MOVE CB-PHONE-NO TO S-PHONE-NO                       
                   MOVE CB-EXTENSION-NO TO S-PHONE-EXT                  
                   MOVE CB-MOBILE-PHONE-FL TO S-PHONE-MOBILE-FL         
                   MOVE CB-PERMISN-TO-MKT-DT TO S-PHONE-MKT-DT          
                   MOVE CB-PERMISN-TO-MKT-FL TO S-PHONE-MKT-FL          
                   IF WS-GTT02-DECLARED = 'N'                           
                       PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT        
                   END-IF                                               
                   PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT            
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 7051-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7051'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 7051-FETCH-PHONE-CURSOR.                               
                                                                        
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7052-CLOSE-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE PHONE-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7052'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7052-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-OPEN-ACCOUNT-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN ACCOUNT-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7061-CLOSE-ACCOUNT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE ACCOUNT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7061'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7061-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-EMAIL.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) EMAIL_ADDRESS_TX                                  
                 INTO :NE-EMAIL-ADDRESS-TX                              
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
                  AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EMAIL_ADDRESS_TX                                          
MFA-TR*          INTO :NE-EMAIL-ADDRESS-TX                                      
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF NE-EMAIL-ADDRESS-TX-TEXT <= SPACES                
                       MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE 'EMAIL_TYPE_CD'  TO TABLE-ELEMENT-2             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE NE-EMAIL-TYPE-CD TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-SPOUSE-NAME.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + 
           LTRIM(RTRIM(MIDDLE_NAME) + ' ' + LTRIM(RTRIM(LAST_NAME))))),
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_SUFFIX_1                                    
                 INTO :WS-SPOUSE-NAME,                                  
                      :DQ-NAME-FORMAT,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-TITLE-SUFFIX-1                                
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE NAME_ID = :DQ-NAME-ID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(LAST_NAME))))),                               
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_SUFFIX_1                                            
MFA-TR*          INTO :WS-SPOUSE-NAME,                                          
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-TITLE-SUFFIX-1                                        
MFA-TR*          FROM CSS_NAME DQ                                               
MFA-TR*         WHERE NAME_ID = :DQ-NAME-ID                                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-SPOUSE-NAME                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7080'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME'       TO TABLE-1                     
                   MOVE 'NAME_ID'        TO TABLE-ELEMENT-1             
                   MOVE DQ-NAME-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-ACCT-MISC-INFO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SPCL_BILL_STMNT_TX                                
                 INTO :TA-SPCL-BILL-STMNT-TX                            
                 FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SPCL_BILL_STMNT_TX                                        
MFA-TR*          INTO :TA-SPCL-BILL-STMNT-TX                                    
MFA-TR*          FROM CSS_ACCT_MISC_INFO                                        
MFA-TR*         WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCT-MISC-INFO                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CC-NC-ORDER.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND (ORDER_TYPE_CD LIKE 'CC%'                         
                   OR  ORDER_TYPE_CD = 'NC001')                         
                  AND ORDER_STATE_CD <> 'C'                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND (ORDER_TYPE_CD LIKE 'CC%'                                 
MFA-TR*            OR  ORDER_TYPE_CD = 'NC001')                                 
MFA-TR*           AND ORDER_STATE_CD ^= 'C'                                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ORDER-EXISTS-FL                       
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-ORDER-EXISTS-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-2             
                   MOVE AT-PREMISE-NO    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-WRITE-OFF-CUTOFF.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'WO-CUTOFF-DT'                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'WO-CUTOFF-DT'                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-WOFF-YEARS                
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 0 TO WS-WOFF-YEARS                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'WO-CUTOFF-DT'   TO TABLE-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF C8-COMPANY-NO = '26'                                      
               MOVE +6 TO WS-WOFF-YEARS
           END-IF.                                
                                                                        
           IF WS-WOFF-YEARS > 0                                         
               EXEC SQL                                                 
                   SELECT
              DATEADD( YEAR, -(:WS-WOFF-YEARS), IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-WOFF-DT            
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SET :WS-WOFF-DT = (DATE(:WS-CURRENT-DATE) -                  
MFA-TR*                              (:WS-WOFF-YEARS) YEARS)                    
MFA-TR*        END-EXEC.                                                        
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL


           END-IF.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-FINAL-WO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COLLECT_STATUS_CD                                 
                INTO :FW-COLLECT-STATUS-CD                              
                FROM  CSS_FINAL_WO WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  COLLECT_STATUS_CD                                         
MFA-TR*         INTO :FW-COLLECT-STATUS-CD                                      
MFA-TR*         FROM  CSS_FINAL_WO                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  FW-FINAL-BILL-AM                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_FINAL_WO'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SELECT-DBA.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FULL_NAME                                         
                 INTO :DQ-FULL-NAME                                     
                 FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND AB.NAME_TYPE = 'DB'                               
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FULL_NAME                                                 
MFA-TR*          INTO :DQ-FULL-NAME                                             
MFA-TR*          FROM CSS_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_TYPE = 'DB'                                       
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO DQ-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-REG-PROFILE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7140                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                WHEN SUCCESSFUL-CALL                                    
                    CONTINUE                                            
                WHEN NOT-FOUND                                          
                    MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                
                    MOVE SPACES TO LR-REG-GROUP-CD                      
                WHEN OTHER                                              
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_REG_PROFILE' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-CHARGE-OFF.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :CO-AMT-TRANS :WS-NULL-1                           
                 FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND DATE_OF_CHG_OFF > IIF(TRY_CONVERT(DATE, 
                                                            :WS-WOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WOFF-DT) <> 0) OR (LEN(
                                                            :WS-WOFF-DT
              ) <> 10), CIS.CHAR2DATE(:WS-WOFF-DT), CONVERT(DATE, 
                                                            :WS-WOFF-DT
              ) )                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-1                                   
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND DATE_OF_CHG_OFF > :WS-WOFF-DT                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE 0.00 TO CO-AMT-TRANS                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  CO-AMT-TRANS                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7150'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CHRG_OFF'      TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7160-GET-LANDLORD.                                               
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         SELECT TOP(1) CUSTOMER_NO                                       
A05317           INTO :SI-CUSTOMER-NO                                   
A05317           FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
A05317          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7160                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             MOVE 'Y' TO S-PROP-MGR-FL                            
A05317         WHEN NOT-FOUND                                           
A05317             MOVE 'N' TO S-PROP-MGR-FL                            
A05317             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
A05317             MOVE '7160 '            TO ACTIVE-PARAGRAPH          
A05317             MOVE 'SELECT'           TO ABEND-FUNCTION            
A05317             MOVE SPACES             TO ABEND-SQL-PREDICATES      
A05317                                        ABEND-TABLES              
A05317             MOVE 'CSS_LANDLORD'     TO TABLE-1                   
A05317             MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
A05317             MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
A05317             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7160-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       7190-FMT-BILL-ADDR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE))))                              
                INTO :WS-TOWN                                           
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(TOWN) || ', ' ||                         
MFA-TR*              LTRIM(RTRIM(STATE))))                                      
MFA-TR*         INTO :WS-TOWN                                                   
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7190'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'      TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-2          
                   MOVE AT-ADDRESS-ID       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-FRE-BILL-ADDR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_CITY_STATE                                    
                INTO :DZ-ADDR-CITY-STATE                                
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_CITY_STATE                                            
MFA-TR*         INTO :DZ-ADDR-CITY-STATE                                        
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE DZ-ADDR-CITY-STATE TO WS-TOWN                   
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-2          
                   MOVE AT-ADDRESS-ID       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-RENEWAL-FL.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DF.STATUS_CD                                      
                 INTO :DF-STATUS-CD                                     
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED),               
                      CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED),               
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                  AND UT.IC_NO             = :UT-IC-NO                  
                  AND UT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                  AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
                  AND DF.IC_NO             = UT.IC_NO                   
                  AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
                  AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
                  AND FI.OPTION_CD         = DF.OPTION_CD               
                  AND FI.COMPANY_NO        = :AT-COMPANY-NO             
                  AND FI.OPT_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )             
                  AND FI.OPT_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )             
                  AND FI.PROC_STATUS_CD    = 'AC'                       
                ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*        SELECT DF.STATUS_CD                                      41146600
MFA-TR*          INTO :DF-STATUS-CD                                     41146600
MFA-TR*          FROM CRM_RT_PKG_OPTION FI,                             41146600
MFA-TR*               CSS_ACCT_RTPK_AGR DF,                             41146600
MFA-TR*               CSS_UTIL_ENVRNMT UT                               41146600
MFA-TR*         WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         41146600
MFA-TR*           AND UT.IC_NO             = :UT-IC-NO                  41146600
MFA-TR*           AND UT.ACCOUNT_NO        = :AT-ACCOUNT-NO             41146600
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          41146600
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                   41146600
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              41146600
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       41146600
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD               41146600
MFA-TR*           AND FI.COMPANY_NO        = :AT-COMPANY-NO             41146600
MFA-TR*           AND FI.OPT_VSTART_TS    <= :WS-CURRENT-TS                     
MFA-TR*           AND FI.OPT_VEND_TS      >= :WS-CURRENT-TS                     
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*         ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      41146600
MFA-TR*         FETCH FIRST ROW ONLY                                    41146600
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*     END-EXEC.                                                   41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO DF-STATUS-CD                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CRM_RT_PKG_OPTION' TO TABLE-1                  
                   MOVE 'CSS_ACCT_RTPK_AGR' TO TABLE-2                  
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-3                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-MST-SUB.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MST_ACCT_NO                                       
                 INTO :MU-MST-ACCT-NO                                   
                 FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
                WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MST_ACCT_NO                                               
MFA-TR*          INTO :MU-MST-ACCT-NO                                           
MFA-TR*          FROM CSS_MSTSUB_ACCT                                           
MFA-TR*         WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  MU-MST-ACCT-NO                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7250'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_MSTSUB_ACCT'    TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-UTILITY.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO,
              IC_NO                                             
                 INTO :UT-ACCOUNT-NO,                                   
                      :UT-IC-NO                                         
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               IC_NO                                                     
MFA-TR*          INTO :UT-ACCOUNT-NO,                                           
MFA-TR*               :UT-IC-NO                                                 
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7280                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  UT-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7280'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2         
                   MOVE UT-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7290-OPEN-TEMP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN TEMP-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7290'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR04806_R3'    TO TABLE-1                     
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7291-CLOSE-TEMP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE TEMP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7291'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR04806_R3'    TO TABLE-1                     
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7291-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-CONTACT-ACCOUNT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :DW-ACCOUNT-NO                                    
                 FROM CSS_CONTACT_ACCT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CONTACT_ID = :DW-CONTACT-ID                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :DW-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_CONTACT_ACCT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CONTACT_ID = :DW-CONTACT-ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DW-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7300'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-CONTACT-CUSTOMER.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO                                       
                 INTO :DT-CUSTOMER-NO                                   
                 FROM CSS_CONTACT_CUST WITH(READUNCOMMITTED)                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                  AND CONTACT_ID = :DT-CONTACT-ID                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :DT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_CONTACT_CUST                                          
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*           AND CONTACT_ID = :DT-CONTACT-ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7310                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-CONTACT-CUST-FL                       
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DT-CUSTOMER-NO                        
                   MOVE 'N' TO WS-CONTACT-CUST-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7310'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04806_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04806_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04806_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT02-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04806_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04806_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04806_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT03-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04806_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04806_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8003'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04806_R3'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04806_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              CUSTOMER_NO,                                              
              CUSTOMER_TYPE,                                            
              CUSTOMER_NAME,                                            
              NAME_FORMAT,                                              
              SSN,                                                      
              ITIN,                                                     
              OTHER_ID,                                                 
              OTHER_ID_TYPE,                                            
              DLN,                                                      
              DLN_STATE,                                                
              DOB,                                                      
              EMPLOYER,                                                 
              EMAIL_ADDRESS,                                            
              TAX_ID,                                                   
              SBU_CD,                                                   
              FIRST_NAME,                                               
              MIDDLE_NAME,                                              
              LAST_NAME,                                                
A05317        PROP_MGR_FL                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-CUSTOMER-NO,                                          
               :S-CUSTOMER-TYPE,                                        
               :S-CUSTOMER-NAME,                                        
               :S-NAME-FORMAT,                                          
               :S-SSN,                                                  
               :S-ITIN,                                                 
               :S-OTHER-ID,                                             
               :S-OTHER-ID-TYPE,                                        
               :S-DLN,                                                  
               :S-DLN-STATE,                                            
               :S-DOB,                                                  
               :S-EMPLOYER,                                             
               :S-EMAIL-ADDRESS,                                        
               :S-TAX-ID,                                               
               :S-SBU-CD,                                               
               :S-FIRST-NAME,                                           
               :S-MIDDLE-NAME,                                          
               :S-LAST-NAME,                                            
A05317         :S-PROP-MGR-FL                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04806_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       CUSTOMER_NO,                                                      
MFA-TR*       CUSTOMER_TYPE,                                                    
MFA-TR*       CUSTOMER_NAME,                                                    
MFA-TR*       NAME_FORMAT,                                                      
MFA-TR*       SSN,                                                              
MFA-TR*       ITIN,                                                             
MFA-TR*       OTHER_ID,                                                         
MFA-TR*       OTHER_ID_TYPE,                                                    
MFA-TR*       DLN,                                                              
MFA-TR*       DLN_STATE,                                                        
MFA-TR*       DOB,                                                              
MFA-TR*       EMPLOYER,                                                         
MFA-TR*       EMAIL_ADDRESS,                                                    
MFA-TR*       TAX_ID,                                                           
MFA-TR*       SBU_CD,                                                           
MFA-TR*       FIRST_NAME,                                                       
MFA-TR*       MIDDLE_NAME,                                                      
MFA-TR*       LAST_NAME,                                                        
MFA-TR*       PROP_MGR_FL                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-CUSTOMER-NO,                                                  
MFA-TR*        :S-CUSTOMER-TYPE,                                                
MFA-TR*        :S-CUSTOMER-NAME,                                                
MFA-TR*        :S-NAME-FORMAT,                                                  
MFA-TR*        :S-SSN,                                                          
MFA-TR*        :S-ITIN,                                                         
MFA-TR*        :S-OTHER-ID,                                                     
MFA-TR*        :S-OTHER-ID-TYPE,                                                
MFA-TR*        :S-DLN,                                                          
MFA-TR*        :S-DLN-STATE,                                                    
MFA-TR*        :S-DOB,                                                          
MFA-TR*        :S-EMPLOYER,                                                     
MFA-TR*        :S-EMAIL-ADDRESS,                                                
MFA-TR*        :S-TAX-ID,                                                       
MFA-TR*        :S-SBU-CD,                                                       
MFA-TR*        :S-FIRST-NAME,                                                   
MFA-TR*        :S-MIDDLE-NAME,                                                  
MFA-TR*        :S-LAST-NAME,                                                    
MFA-TR*        :S-PROP-MGR-FL                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04806_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04806_R2                            
             (                                                          
              RETURN_CODE,                                              
              PHONE_NAME_TYPE,                                          
              PHONE_TYPE,                                               
              PHONE_NO,                                                 
              PHONE_EXT,                                                
              PHONE_MOBILE_FL,                                          
              PHONE_MKT_FL,                                             
              PHONE_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-PHONE-NAME-TYPE,                                      
               :S-PHONE-TYPE,                                           
               :S-PHONE-NO,                                             
               :S-PHONE-EXT,                                            
               :S-PHONE-MOBILE-FL,                                      
               :S-PHONE-MKT-FL,                                         
               :S-PHONE-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04806_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PHONE_NAME_TYPE,                                                  
MFA-TR*       PHONE_TYPE,                                                       
MFA-TR*       PHONE_NO,                                                         
MFA-TR*       PHONE_EXT,                                                        
MFA-TR*       PHONE_MOBILE_FL,                                                  
MFA-TR*       PHONE_MKT_FL,                                                     
MFA-TR*       PHONE_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-PHONE-NAME-TYPE,                                              
MFA-TR*        :S-PHONE-TYPE,                                                   
MFA-TR*        :S-PHONE-NO,                                                     
MFA-TR*        :S-PHONE-EXT,                                                    
MFA-TR*        :S-PHONE-MOBILE-FL,                                              
MFA-TR*        :S-PHONE-MKT-FL,                                                 
MFA-TR*        :S-PHONE-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04806_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04806_R3                            
             (                                                          
              RETURN_CODE,                                              
              ACCOUNT_NO,                                               
              TOWN,                                                     
              SERVICE_ADDRESS,                                          
              ACCOUNT_ID,                                               
              TOTAL_AR_BALANCE,                                         
              MST_SUB_ACCT_IND,                                         
              DUE_DT,                                                   
              SORT_ORDER,                                               
              ACCOUNT_TYPE_CODE,                                        
              CODE_ACCT_STAT,                                           
              DBA_NAME,                                                 
              COMPANY_NO,                                               
              REG_GROUP_CD,                                             
              STREET_NAME,                                              
              HOUSE_NO,                                                 
              PYMT_SCHED_DT,                                            
              PYMT_METHOD,                                              
              SORT_DT,                                                  
              OUTAGE_FL,                                                
              ARREARS_AMT,                                              
              PYMT_SCHED_AMT,                                           
              DNP_FL,                                                   
              DNP_DT,                                                   
              STA_REM_AMT,                                              
              MST_ACCT_NO,                                              
              WQ_FOUND_FL,                                              
              SORT_DUE_DT,                                              
              STREET_LOCATION_1,                                        
              STREET_LOCATION_2,                                        
              CODES_DATA_PRESENT,                                       
              RENEWAL_FL                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-ACCOUNT-NO,                                           
               :S-TOWN,                                                 
               :S-SERVICE-ADDRESS,                                      
               :S-ACCOUNT-ID,                                           
               :S-TOTAL-AR-BALANCE,                                     
               :S-MST-SUB-ACCT-IND,                                     
               :S-DUE-DT,                                               
               :S-SORT-ORDER,                                           
               :S-ACCOUNT-TYPE-CODE,                                    
               :S-CODE-ACCT-STAT,                                       
               :S-DBA-NAME,                                             
               :S-COMPANY-NO,                                           
               :S-REG-GROUP-CD,                                         
               :S-STREET-NAME,                                          
               :S-HOUSE-NO,                                             
               :S-PYMT-SCHED-DT,                                        
               :S-PYMT-METHOD,                                          
               :S-SORT-DT,                                              
               :S-OUTAGE-FL,                                            
               :S-ARREARS-AMT,                                          
               :S-PYMT-SCHED-AMT,                                       
               :S-DNP-FL,                                               
               :S-DNP-DT,                                               
               :S-STA-REM-AMT,                                          
               :S-MST-ACCT-NO,                                          
               :S-WQ-FOUND-FL,                                          
               :S-SORT-DUE-DT,                                          
               :S-STREET-LOC-1,                                         
               :S-STREET-LOC-2,                                         
               :S-CODES-DATA-PRESENT,                                   
               :S-RENEWAL-FL                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04806_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       TOWN,                                                             
MFA-TR*       SERVICE_ADDRESS,                                                  
MFA-TR*       ACCOUNT_ID,                                                       
MFA-TR*       TOTAL_AR_BALANCE,                                                 
MFA-TR*       MST_SUB_ACCT_IND,                                                 
MFA-TR*       DUE_DT,                                                           
MFA-TR*       SORT_ORDER,                                                       
MFA-TR*       ACCOUNT_TYPE_CODE,                                                
MFA-TR*       CODE_ACCT_STAT,                                                   
MFA-TR*       DBA_NAME,                                                         
MFA-TR*       COMPANY_NO,                                                       
MFA-TR*       REG_GROUP_CD,                                                     
MFA-TR*       STREET_NAME,                                                      
MFA-TR*       HOUSE_NO,                                                         
MFA-TR*       PYMT_SCHED_DT,                                                    
MFA-TR*       PYMT_METHOD,                                                      
MFA-TR*       SORT_DT,                                                          
MFA-TR*       OUTAGE_FL,                                                        
MFA-TR*       ARREARS_AMT,                                                      
MFA-TR*       PYMT_SCHED_AMT,                                                   
MFA-TR*       DNP_FL,                                                           
MFA-TR*       DNP_DT,                                                           
MFA-TR*       STA_REM_AMT,                                                      
MFA-TR*       MST_ACCT_NO,                                                      
MFA-TR*       WQ_FOUND_FL,                                                      
MFA-TR*       SORT_DUE_DT,                                                      
MFA-TR*       STREET_LOCATION_1,                                                
MFA-TR*       STREET_LOCATION_2,                                                
MFA-TR*       CODES_DATA_PRESENT,                                               
MFA-TR*       RENEWAL_FL                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-TOWN,                                                         
MFA-TR*        :S-SERVICE-ADDRESS,                                              
MFA-TR*        :S-ACCOUNT-ID,                                                   
MFA-TR*        :S-TOTAL-AR-BALANCE,                                             
MFA-TR*        :S-MST-SUB-ACCT-IND,                                             
MFA-TR*        :S-DUE-DT,                                                       
MFA-TR*        :S-SORT-ORDER,                                                   
MFA-TR*        :S-ACCOUNT-TYPE-CODE,                                            
MFA-TR*        :S-CODE-ACCT-STAT,                                               
MFA-TR*        :S-DBA-NAME,                                                     
MFA-TR*        :S-COMPANY-NO,                                                   
MFA-TR*        :S-REG-GROUP-CD,                                                 
MFA-TR*        :S-STREET-NAME,                                                  
MFA-TR*        :S-HOUSE-NO,                                                     
MFA-TR*        :S-PYMT-SCHED-DT,                                                
MFA-TR*        :S-PYMT-METHOD,                                                  
MFA-TR*        :S-SORT-DT,                                                      
MFA-TR*        :S-OUTAGE-FL,                                                    
MFA-TR*        :S-ARREARS-AMT,                                                  
MFA-TR*        :S-PYMT-SCHED-AMT,                                               
MFA-TR*        :S-DNP-FL,                                                       
MFA-TR*        :S-DNP-DT,                                                       
MFA-TR*        :S-STA-REM-AMT,                                                  
MFA-TR*        :S-MST-ACCT-NO,                                                  
MFA-TR*        :S-WQ-FOUND-FL,                                                  
MFA-TR*        :S-SORT-DUE-DT,                                                  
MFA-TR*        :S-STREET-LOC-1,                                                 
MFA-TR*        :S-STREET-LOC-2,                                                 
MFA-TR*        :S-CODES-DATA-PRESENT,                                           
MFA-TR*        :S-RENEWAL-FL                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04806_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8310-UPDATE-TEMP-3.                                              
                                                                        
           EXEC SQL                                                     
             UPDATE #CSR04806_R3                                 
                SET DUE_DT = :S-DUE-DT,                                 
                    ARREARS_AMT = :S-ARREARS-AMT,                       
                    DNP_DT = :S-DNP-DT,                                 
                    DNP_FL = :S-DNP-FL,                                 
                    WQ_FOUND_FL = :S-WQ-FOUND-FL,                       
                    TOTAL_AR_BALANCE = :S-TOTAL-AR-BALANCE,             
                    STA_REM_AMT = :S-STA-REM-AMT,                       
                    SORT_DUE_DT = :S-SORT-DUE-DT                        
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE SESSION.CSR04806_R3                                         
MFA-TR*         SET DUE_DT = :S-DUE-DT,                                         
MFA-TR*             ARREARS_AMT = :S-ARREARS-AMT,                               
MFA-TR*             DNP_DT = :S-DNP-DT,                                         
MFA-TR*             DNP_FL = :S-DNP-FL,                                         
MFA-TR*             WQ_FOUND_FL = :S-WQ-FOUND-FL,                               
MFA-TR*             TOTAL_AR_BALANCE = :S-TOTAL-AR-BALANCE,                     
MFA-TR*             STA_REM_AMT = :S-STA-REM-AMT,                               
MFA-TR*             SORT_DUE_DT = :S-SORT-DUE-DT                                
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8310'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSR04806_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               IF WS-ACCOUNT-CT > WS-ACCOUNT-THRESHOLD                  
                   EXEC SQL                                             
                       OPEN C4                                          
                   END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                             
               ELSE                                                     
                   EXEC SQL                                             
                       OPEN C3                                          
                   END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                             
               END-IF                                                   
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           EXEC SQL                                                     
               UPDATE #CSR04806_R1                               
                  SET RETURN_CODE = :S-RETURN-CODE-1                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE SESSION.CSR04806_R1                                       
MFA-TR*           SET RETURN_CODE = :S-RETURN-CODE-1                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00375                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD0309A                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
                                                                        
