       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04804.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *        
      *  THIS PROGRAM PERFORMS PAYMENT REVERSALS.                      *00100000
      *                                                                *00110000
      *  BUSOP NAME: UPDACCTPAYMENTREVERSAL                            *00120000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM DOES THE FOLLOWING:                              *00190000
      *  1. PERFORMS PAYMENT REVERSAL.                                 *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    USERID     COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
PRJ586*  09/12/14  CB18344    THIS PROGRAM WAS WRITTEN TO USE IN CIS   *00280000
      *                         MODERNIZATION TO PERFORM PAYMENT       *00290000
      *                         REVERSALS.                             *00300000
A04860*  05/04/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT107    CSS_WQ_ITEMS TABLE                        *01790200
      ******************************************************************00460000
      ******************************************************************00470000
      *                                                                *00480000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00490000
      *                                                                *00500000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00510000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00520000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00530000
      *  3000 - 4999  NOT USED                                         *00540000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00550000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00560000
      *  7000 - 7999  INPUT MODULES                                    *00570000
      *  8000 - 8999  OUTPUT MODULES                                   *00580000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00590000
      *                                                                *00600000
      ******************************************************************00610000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04804'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04804 STARTS HERE'.                  
                                                                        
      ******************************************************************00700000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00710000
      ******************************************************************00720000
                                                                        
           COPY CWS00056.                                               00810000
           COPY CWS00303.                                               00820000
           COPY CJF00101.                                               00840000
           COPY CWSCA225.                                                       
           COPY CWSCA224.                                                       
ACT107     COPY CWS00077.                                                       
      *                                                                 05360000
       COPY CWS00182.                                                           
      *                                                                 05360000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
      *                                                                 00900000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08)  VALUE 'CSR04804'.   
           05  EIBTRNID                  PIC X(04)     VALUE 'S183'.    
ACT107     05  MCSCB077                  PIC X(08)  VALUE 'MCSCB077'.   
           05  WS-SQLSTATE               PIC X(05).                     
           05  WS-RETURN-CODE            PIC S9(4)     COMP VALUE 0.    
           05  ALL-DONE-SW               PIC X(01)     VALUE 'N'.       
               88 NOT-ALL-DONE                         VALUE 'N'.       
               88 ALL-DONE                             VALUE 'Y'.       
           05  SEND-DONE-SW              PIC X(01)     VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
           05  WS-ACCOUNT-NO             PIC 9(13).                     
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.          
           05  WS-CURRENT-DATE           PIC X(10).                     
           05  WS-PAYMENT-REVERSED       PIC X(09)     VALUE            
                                                       'PANEL118A'.     
           05  WS-VOUCHER-REVERSAL       PIC X(09)     VALUE            
                                                       'PANEL378D'.     
           05  WS-VOUCHER-REVERSED       PIC X(09)     VALUE            
                                                       'PANEL378A'.     
           05  WS-CURRENT-TIMESTAMP      PIC X(26).                     
           05  WS-AMOUNT-REFUNDED-NUM    PIC 9(09)V99.                  
           05  WS-USER-ID                PIC X(07).                     
           05  WS-PREV-TRANS-HIST-SEQ-NO PIC X(26).                     
           05  WS-TRANS-HIST-SEQ-NO      PIC X(26).                     
           05  WS-ADJ-TRANS-HIST-SEQ-NO  PIC X(26).                     
           05  WS-DATE                   PIC X(10).                     
           05  WS-TIME                   PIC X(08).                     
           05  WS-NULL-IND1              PIC S9(04)    COMP VALUE 0.    
           05  WS-NULL-IND2              PIC S9(04)    COMP VALUE 0.    
           05  WS-NULL-IND3              PIC S9(04)    COMP VALUE 0.    
           05  WS-DATE-ORIG-PYMT-IND     PIC S9(04)    COMP VALUE +0.   
           05  WS-TRAN-COMMENT-LEN       PIC S9(09)    COMP.            
           05  WS-TRAN-COMMENT-TEXT      PIC X(210).                    
           05  WS-DNP-COMMENT-TEXT       PIC X(210)    VALUE SPACES.    
           05  WS-DNP-HOLD-LEN           PIC S9(09)    COMP  VALUE +0.  
           05  WS-REC-COMMENT-TEXT       PIC X(210)    VALUE SPACES.    
           05  WS-REC-HOLD-LEN           PIC S9(09)    COMP  VALUE +0.  
           05  WS-TOTAL-ORIG-AMT         PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RECORD-ONLY            PIC X(01)     VALUE SPACES.    
           05  WS-LAST-UPDATE-TS         PIC X(26).                     
           05  WS-TRAN-TS-TIME           PIC X(08).                     
           05  MCSCA182                  PIC X(08)     VALUE 'MCSCA182'.
           05  MCSCB225                  PIC X(8)      VALUE 'MCSCB225'.
           05  MCSCB224                  PIC X(8)      VALUE 'MCSCB224'.
           05  WS-UTIL-ACCOUNT           PIC X.                         
               88  UTIL-EXISTS                         VALUE 'Y'.       
               88  NO-UTIL-EXISTS                      VALUE 'N'.       
           05  WS-VALID-RATE-FL          PIC X.                         
               88  VALID-RATE                          VALUE 'Y'.       
               88  NOT-VALID-RATE                      VALUE 'N'.       
           05  WS-AMOUNT-PYMT            PIC X(11).                     
           05  WS-AMOUNT-PYMT-NUM REDEFINES WS-AMOUNT-PYMT              
                                         PIC 9(09)V99.                  
           05  WS-AMOUNT-PYMT-COMP3      PIC S9(09)V99 COMP-3 VALUE +0. 
      *                                                                         
       01  WS-LITERAL.                                                  
           05  WS-D                      PIC X(01)     VALUE 'D'.       
           05  WS-G                      PIC X(01)     VALUE 'G'.       
           05  WS-I                      PIC X(01)     VALUE 'I'.       
           05  WS-M                      PIC X(01)     VALUE 'M'.       
           05  WS-O                      PIC X(01)     VALUE 'O'.       
           05  WS-FOUND-MULT-BILLS       PIC S9(04)    COMP VALUE -811. 
                                                                        
       01  FILLER                        PIC X(11)     VALUE            
                                                       'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)     COMP.            
           05  SNA-CONNECTION-NAME       PIC X(8)      VALUE SPACES.    
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)     COMP VALUE 1.    
           05  CTR-ROWS                  PIC S9(9)     COMP VALUE 0.    
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9)     COMP.            
           05  WRKLEN1                   PIC S9(9)     COMP.            
           05  WRKLEN2                   PIC S9(9)     COMP.            
           05  WRK-DONE-STATUS           PIC S9(9)     COMP.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)    COMP VALUE +0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09)    COMP VALUE +0.   
           05  S-APPL-RETURN-CODE        PIC S9(09)    COMP VALUE +0.   
           05  S-DNP-FLAG                PIC X(01)     VALUE 'N'.       
           05  S-AR-LOCKOUT-IND          PIC X(01)     VALUE SPACE.     
           05  S-ACCT-XFER-TO            PIC X(13)     VALUE SPACE.     
           05  S-REC-FLAG                PIC X(01)     VALUE 'N'.       
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18)     VALUE SPACES.    
           10  S-SQLCODE                 PIC S9(9)     COMP VALUE 0.    
           10  S-SQLSTATE                PIC X(5)      VALUE ' '.       
           10  S-TABLE-NAME              PIC X(18)     VALUE SPACES.    
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4)     USAGE COMP.      
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4)     USAGE COMP.      
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4)     USAGE COMP.      
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
      *                                                                         
           EXEC SQL                                                     01990000
              INCLUDE SQLCA                                             02000000
           END-EXEC.                                                    02010000
                                                                        
      *************************************************************             
      *    CSS_AR_CNTL - AC                                       *             
      *************************************************************             
           EXEC SQL                                                     02071000
              INCLUDE TBARCNTL                                          02080000
           END-EXEC.                                                    02090000
                                                                        
      *************************************************************             
      *    CSS_AR_LOCKOUT - AL                                    *             
      *************************************************************             
           EXEC SQL                                                     02310000
              INCLUDE TBARLOCK                                          02320000
           END-EXEC.                                                    02330000
                                                                        
      *************************************************************             
      *    CSS_AR_TRANS_HIST - AR                                 *             
      *************************************************************             
           EXEC SQL                                                     02230000
              INCLUDE TBARHIST                                          02240000
           END-EXEC.                                                    02250000
                                                                        
      *************************************************************             
      *    CSS_ACCOUNT - AT                                       *             
      *************************************************************             
           EXEC SQL                                                     02270000
              INCLUDE TBACCT                                            02280000
           END-EXEC.                                                    02290000
                                                                        
      *************************************************************             
      *    CSS_AR_TRN_HST_DET - AU                                *             
      *************************************************************             
           EXEC SQL                                                     02510000
              INCLUDE TBARHDT                                           02520000
           END-EXEC.                                                    02530000
                                                                        
      *************************************************************             
      *    CSS_BCH_JRNL_CNTL - BC                                 *             
      *************************************************************             
           EXEC SQL                                                     02630000
              INCLUDE TBBJCNTL                                          02640000
           END-EXEC.                                                    02650000
                                                                        
      *************************************************************             
      *    CSS_BUDGET_HIST - BH                                   *             
      *************************************************************             
           EXEC SQL                                                     02150000
              INCLUDE TBBGTHST                                          02160000
           END-EXEC.                                                    02170000
                                                                        
      *************************************************************             
      *    CSS_BATCH_JRNL - BJ                                    *             
      *************************************************************             
           EXEC SQL                                                     02670000
              INCLUDE TBBTJRNL                                          02680000
           END-EXEC.                                                    02690000
                                                                        
      *************************************************************             
      *    CSS_BUDGET_PLAN - BU                                   *             
      *************************************************************             
           EXEC SQL                                                     02190000
              INCLUDE TBBGTPLN                                          02200000
           END-EXEC.                                                    02210000
                                                                        
      *************************************************************             
      *    CSS_LOCAL_OFFICE - B1                                  *             
      *************************************************************             
           EXEC SQL                                                     01532000
              INCLUDE TBLOCOFC                                          01533000
           END-EXEC.                                                    01534000
                                                                        
      *************************************************************             
      *    CSS_CONNECT_CHRG - CC                                  *             
      *************************************************************             
           EXEC SQL                                                     03880001
              INCLUDE TBCCCHRG                                          03890000
           END-EXEC.                                                    03900001
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_JRNL - CJ                                 *             
      *************************************************************             
           EXEC SQL                                                     02590000
              INCLUDE TBCDJRNL                                          02600000
           END-EXEC.                                                    02610000
                                                                        
      *************************************************************             
      *    CSS_CRED_COLL - CL                                     *             
      *************************************************************             
           EXEC SQL                                                     02069800
              INCLUDE TBCRCOLL                                          02069900
           END-EXEC.                                                    02070000
                                                                        
      *************************************************************             
      *    CSS_CHRG_OFF - CO                                      *             
      *************************************************************             
           EXEC SQL                                                     03230000
              INCLUDE TBCHGOFF                                          03240000
           END-EXEC.                                                    03250000
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_CNTL - CS                                 *             
      *************************************************************             
           EXEC SQL                                                     02550000
              INCLUDE TBCDCNTL                                          02560000
           END-EXEC.                                                    02570000
                                                                        
      *************************************************************             
      *    CSS_CONTRACT - CT                                      *             
      *************************************************************             
           EXEC SQL                                                     02470000
              INCLUDE TBCNTRCT                                          02480000
           END-EXEC.                                                    02490000
                                                                        
      *************************************************************             
      *    CSS_CUSTOMER - CU                                      *             
      *************************************************************             
           EXEC SQL                                                     02350000
              INCLUDE TBCUST                                            02360000
           END-EXEC.                                                    02370000
                                                                        
      *************************************************************             
      *    CSS_CREDIT_PROFILE - CZ                                *             
      *************************************************************             
           EXEC SQL                                                     03270000
              INCLUDE TBCRPROF                                          03280000
           END-EXEC.                                                    03290000
                                                                        
      *************************************************************             
      *    CSS_DELINQUENCY - C8                                   *             
      *************************************************************             
           EXEC SQL                                                     01532000
              INCLUDE TBDELQ                                            01533000
           END-EXEC.                                                    01534000
                                                                        
      *************************************************************             
      *    CSS_DFA_ACCT - DA                                      *             
      *************************************************************             
           EXEC SQL                                                     02110000
              INCLUDE TBDFAACT                                          02120000
           END-EXEC.                                                    02130000
                                                                        
      *************************************************************             
      *    CSS_DEP_ON_HAND - DO                                   *             
      *************************************************************             
           EXEC SQL                                                     03150000
              INCLUDE TBDEPHND                                          03160000
           END-EXEC.                                                    03170000
                                                                        
      *************************************************************             
      *    CSS_DEP_PAY_HST - DP                                   *             
      *************************************************************             
           EXEC SQL                                                     03110000
              INCLUDE TBDEPHST                                          03120000
           END-EXEC.                                                    03130000
                                                                        
      *************************************************************             
      *    CSS_DEP_REQ - DR                                       *             
      *************************************************************             
           EXEC SQL                                                     02710000
              INCLUDE TBDEPREQ                                          02720000
           END-EXEC.                                                    02730000
                                                                        
      *************************************************************             
      *    CSS_DFA_RECVBLE - DV                                   *             
      *************************************************************             
           EXEC SQL                                                     02870000
              INCLUDE TBDFARCV                                          02880000
           END-EXEC.                                                    02890000
                                                                        
      *************************************************************             
      *    CSS_CNT_DETAIL - EA                                    *             
      *************************************************************             
           EXEC SQL                                                     02061000
              INCLUDE TBCNTDET                                          02062000
           END-EXEC.                                                    02063000
                                                                        
      *************************************************************             
      *    CSS_FINAL_WO - FW                                      *             
      *************************************************************             
           EXEC SQL                                                     02069400
              INCLUDE TBFINLWO                                          02069500
           END-EXEC.                                                    02069600
                                                                        
      *************************************************************             
      *    CSS_GL_ACCT_NO - GO                                    *             
      *************************************************************             
           EXEC SQL                                                     02990000
              INCLUDE TBGLATNO                                          03000000
           END-EXEC.                                                    03010000
                                                                        
      *************************************************************             
      *    CSS_JOB_PARM - G6                                      *             
      *************************************************************             
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_LIEAP_AGENCY - I5                                  *             
      *************************************************************             
           EXEC SQL                                                     02051000
              INCLUDE TBLIEAP                                           02052000
           END-EXEC.                                                    02053000
                                                                        
      *************************************************************             
      *    CSS_MISC_JRNL - MJ                                     *             
      *************************************************************             
           EXEC SQL                                                     02750000
              INCLUDE TBMSJRNL                                          02760000
           END-EXEC.                                                    02770000
                                                                        
      *************************************************************             
      *    CSS_USER_PROFILE - PF                                  *             
      *************************************************************             
           EXEC SQL                                                     02790000
              INCLUDE TBUSRPRF                                          02800000
           END-EXEC.                                                    02810000
                                                                        
      *************************************************************             
      *    CSS_PROJ_SHARE - PJ                                    *             
      *************************************************************             
           EXEC SQL                                                     02830000
              INCLUDE TBPRJSHR                                          02840000
           END-EXEC.                                                    02850000
                                                                        
      *************************************************************             
      *    CSS_PREMISE - PR                                       *             
      *************************************************************             
           EXEC SQL                                                     02390000
              INCLUDE TBPREM                                            02400000
           END-EXEC.                                                    02410000
                                                                        
      *************************************************************             
      *    CSS_RECONNECT - DL                                     *             
      *************************************************************             
           EXEC SQL                                                             
             INCLUDE TBRECNCT                                                   
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_RATE_PLAN_DESC - RD                                *             
      *************************************************************             
           EXEC SQL                                                             
             INCLUDE TBRTDESC                                                   
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_UTIL_ENVRNMT - UT                                  *             
      *************************************************************             
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_WQ_ITEMS_MF - WF                                   *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     03310000
              INCLUDE CWS0013B                                          03320000
           END-EXEC.                                                    03330000
                                                                        
           EXEC SQL                                                     03350000
              INCLUDE CWS00017                                          03360000
           END-EXEC.                                                    03370000
                                                                        
           EXEC SQL                                                     03390000
              INCLUDE CWS00061                                          03400000
           END-EXEC.                                                    03410000
                                                                        
           EXEC SQL                                                     03430000
              INCLUDE CWS00073                                          03440000
           END-EXEC.                                                    03450000
                                                                        
           EXEC SQL                                                     03470000
              INCLUDE CWS0116A                                          03480000
           END-EXEC.                                                    03490000
                                                                        
HPCCDM*EJECT                                                            03510000
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO          PIC X(13).                          
       01  PARM-USER-ID             PIC X(07).                          
       01  PARM-DATE-TRANS          PIC X(10).                          
       01  PARM-AMT-ORIG-ENTERED    PIC X(11).                          
       01  PARM-TRAN-COMMENT-LEN    PIC S9(09) COMP.                    
       01  PARM-TRAN-COMMENT-TEXT   PIC X(210).                         
       01  PARM-CASH-COMPANY-NO     PIC X(02).                          
       01  PARM-CASH-LOCAL-OFFICE   PIC X(03).                          
       01  PARM-CASH-REPORT-NO      PIC X(03).                          
       01  PARM-DATE-CASH-REPORT    PIC X(10).                          
       01  PARM-CASH-DRAWER-ID      PIC S9(04) COMP.                    
       01  PARM-LAST-UPDATE-TS      PIC X(26).                          
       01  PARM-TRAN-TS             PIC X(26).                          
      *                                                                         
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                 PARM-USER-ID                           
                                 PARM-DATE-TRANS                        
                                 PARM-AMT-ORIG-ENTERED                  
                                 PARM-TRAN-COMMENT-LEN                  
                                 PARM-TRAN-COMMENT-TEXT                 
                                 PARM-CASH-COMPANY-NO                   
                                 PARM-CASH-LOCAL-OFFICE                 
                                 PARM-CASH-REPORT-NO                    
                                 PARM-DATE-CASH-REPORT                  
                                 PARM-CASH-DRAWER-ID                    
                                 PARM-LAST-UPDATE-TS                    
                                 PARM-TRAN-TS.                          

SCA006        SET WS-GL-SUB TO 1.
                                                                        
      *                                                                 03580000
      ******************************************************************03540000
      * 0000-MAINLINE                                                  *03550000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03560000
      ******************************************************************03570000
      *                                                                 03580000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03670000
      ******************************************************************03680000
      * 0100-INITIALIZE                                                *03690000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03720000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03730000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03740000
      *                                                                *03750000
      ******************************************************************03760000
      *                                                                 03670000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE '0100A' TO ACTIVE-PARAGRAPH.                            
      *                                                                 03770000
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04804_R1'            
                                       TO S-SQL-STATEMENT-V.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04804_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04804_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,DNP_FLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,AR_LOCKOUT_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ACCT_XFER_TO CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,REC_FLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE         
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE SQLCODE                   TO ABEND-SQLCODE         
                MOVE SQLSTATE                  TO ABEND-SQLSTATE        
                MOVE 'DECLARE GTT'             TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSR04804_R1'             TO TABLE-1               
                MOVE SPACES                    TO TABLE-ELEMENT-1       
                MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,DNP_FLAG                                          
                     ,AR_LOCKOUT_IND                                    
                     ,ACCT_XFER_TO                                      
                     ,REC_FLAG                                          
               FROM                                                     
                   #CSR04804_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,DNP_FLAG                                                  
MFA-TR*              ,AR_LOCKOUT_IND                                            
MFA-TR*              ,ACCT_XFER_TO                                              
MFA-TR*              ,REC_FLAG                                                  
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04804_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************04010000
      * 1000-PROCESS-INPUT                                             *04020000
      *     1. RECEIVE PARMS.                                          *04040000
      ******************************************************************04060000
      *                                                                         
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE SCSCA182-LINK-RECORD.                             
           MOVE PARM-ACCOUNT-NO TO SCSCA182-ACCOUNT-NO.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT                                            *05520000
      *     1. DESCRIBE RESULT SET                                     *05540000
      *     2. UPDATE DB2 DATA                                         *05550000
      *     3. BUILD RESULT SET                                        *05560000
      *     4. SEND RESULT SET                                         *05570000
      ******************************************************************05590000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           PERFORM 2200-PROCESS THRU 2200-EXIT.                         
                                                                        
           IF CTR-ROWS = 0                                              
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08130000
      ***************************************************************** 08160000
      * 2100-CHECK-OPEN-DRAWER                                        * 08170000
      ***************************************************************** 08180000
      *                                                                 08130000
       2100-CHECK-OPEN-DRAWER.                                          
                                                                        
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
               SELECT 'O'                                               
                 INTO :WS-O                                             
                 FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                   
                WHERE USER_ID            = :PARM-USER-ID                
                  AND CASH_COMPANY_NO    = :PARM-CASH-COMPANY-NO        
                  AND CASH_LOCAL_OFFICE  = :PARM-CASH-LOCAL-OFFICE      
                  AND CASH_REPORT_NO     = :PARM-CASH-REPORT-NO         
                  AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                 :PARM-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :PARM-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:PARM-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:PARM-DATE-CASH-REPORT
              ), CONVERT(DATE, :PARM-DATE-CASH-REPORT) )       
                  AND CASH_DRAWER_ID     = :PARM-CASH-DRAWER-ID         
                  AND CODE_CSH_DRWR_STAT = 'A'                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*        SELECT 'O'                                               08220000
MFA-TR*          INTO :WS-O                                             08390000
MFA-TR*          FROM CSS_CSH_DRWR_CNTL                                 08560000
MFA-TR*         WHERE USER_ID            = :PARM-USER-ID                08570000
MFA-TR*           AND CASH_COMPANY_NO    = :PARM-CASH-COMPANY-NO        08570000
MFA-TR*           AND CASH_LOCAL_OFFICE  = :PARM-CASH-LOCAL-OFFICE              
MFA-TR*           AND CASH_REPORT_NO     = :PARM-CASH-REPORT-NO                 
MFA-TR*           AND DATE_CASH_REPORT   = :PARM-DATE-CASH-REPORT               
MFA-TR*           AND CASH_DRAWER_ID     = :PARM-CASH-DRAWER-ID                 
MFA-TR*           AND CODE_CSH_DRWR_STAT = 'A'                                  
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2100                                                         
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 0                         TO S-RETURN-CODE           
              MOVE +1000                     TO S-APPL-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_STAT'       TO TABLE-1                 
              MOVE 'USER_ID   '              TO TABLE-ELEMENT-1         
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-3         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-4         
              MOVE PARM-USER-ID              TO HOSTVAR-ELEMENT-1       
              MOVE PARM-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-2       
              MOVE PARM-DATE-CASH-REPORT     TO HOSTVAR-ELEMENT-3       
              MOVE PARM-CASH-DRAWER-ID       TO HOSTVAR-ELEMENT-4       
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06650000
      * 2200-PROCESS                                                   *06660000
      ******************************************************************06670000
      *                                                                         
       2200-PROCESS.                                                    
                                                                        
           MOVE '2200'                  TO ACTIVE-PARAGRAPH.            
      *                                                                         
           PERFORM 7999-SELECT-AL       THRU 7999-SELECT-AL-EXIT.       
           IF AL-AR-LOCKOUT-IND         = 'Y'                           
              MOVE +0                   TO S-RETURN-CODE                
              MOVE +5000                TO S-APPL-RETURN-CODE           
              MOVE AL-AR-LOCKOUT-IND    TO S-AR-LOCKOUT-IND             
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF.                                                      
      *                                                                         
           PERFORM 2100-CHECK-OPEN-DRAWER THRU 2100-EXIT.               
           PERFORM 9200-LINK-SCSCA182         THRU 9200-EXIT            
           IF  SCSCA182-RETURN-CODE NOT EQUAL ZERO                      
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE +0                        TO S-RETURN-CODE          
               MOVE SCSCA182-RETURN-CODE      TO WS-ACTIVE-RETURN-CODE  
                                                 S-APPL-RETURN-CODE     
                                                 SQLCODE                
               PERFORM 8100-SEND-RESULT       THRU 8100-EXIT            
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           ELSE                                                         
               MOVE SCSCA182-LAST-UPDATE-TS TO WS-LAST-UPDATE-TS        
               IF  PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS              
                   CONTINUE                                             
               ELSE                                                     
                   MOVE +0                   TO S-RETURN-CODE           
                   MOVE +5272                TO S-APPL-RETURN-CODE      
                   PERFORM 8100-SEND-RESULT   THRU 8100-EXIT            
                   GO TO 2000-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO                 TO WS-ACCOUNT-NO-COMP3.   
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO                    
                                       LI-ACCOUNT-NO.                   
      *                                                                         
           PERFORM 8000-UPDATE-AT-ACCT THRU 8000-EXIT.                  
      *                                                                         
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
           MOVE AT-ACCT-XFER-TO TO S-ACCT-XFER-TO.                      
      *                                                                         
           PERFORM 2300-CREATE-AR-FOR-REV THRU 2300-EXIT.               
           MOVE PARM-USER-ID              TO AR-USER-ID.                
           MOVE 'PANEL118'                TO AR-APPL-PROGRAM-ID.        
           MOVE ZEROS                     TO WS-NULL-IND1               
                                             WS-NULL-IND2               
                                             WS-NULL-IND3.              
           MOVE 'C'                       TO AR-CODE-TRAN-TYPE.         
           MOVE AR-DATE-TRANS             TO AR-DATE-ORIG-PYMT.         
           MOVE WS-CURRENT-DATE           TO AR-DATE-TRANS.             
           MOVE 'Y'                       TO WS-REVERSAL-FLAG.          
           PERFORM 8010-UPDATE-CSH-DRWR-JRNL THRU 8010-EXIT.            
      *                                                                         
           PERFORM 8040-INSERT-AR-TRANS-HIST THRU 8040-EXIT.            
           MOVE AR-AMT-ORIG-ENTERED       TO WS-AMOUNT-REFUNDED.        
           MOVE 'F'                       TO WS-PART-CASH-PROCESS-FLG.  
           MOVE 'RVR'                     TO WS-CHECK-CASH-IND.         
           MOVE '183B'                    TO WS-116-NON-CASH-TRAN-NO.   
           MOVE PARM-USER-ID              TO WS-USER-ID.                
           MOVE AR-ACCOUNT-NO             TO AU-ACCOUNT-NO              
                                             AT-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO-COMP3       TO CZ-ACCOUNT-NO.             
      *                                                                         
      * CHECK IF PAYMENT CANCELLED A DNP IF SO SET DNP-FLAG             07220000
      *                                                                         
           PERFORM 7300-PROCESS-DNP       THRU 7300-EXIT.               
           INITIALIZE AR-TRAN-COMMENT                                   
                      WS-JRNL-TRAN-COMMENT                              
           IF S-DNP-FLAG = 'Y'                                          
              MOVE PARM-TRAN-COMMENT-LEN  TO WS-DNP-HOLD-LEN            
              MOVE PARM-TRAN-COMMENT-TEXT(1:WS-DNP-HOLD-LEN)            
                   TO WS-DNP-COMMENT-TEXT(1:WS-DNP-HOLD-LEN)            
              ADD 1 TO WS-DNP-HOLD-LEN                                  
              MOVE '; ORIGINAL PAYMENT CANCELLED DNP' TO                
                           WS-DNP-COMMENT-TEXT(WS-DNP-HOLD-LEN:32)      
              ADD +32                      TO PARM-TRAN-COMMENT-LEN     
              MOVE WS-DNP-COMMENT-TEXT(1:PARM-TRAN-COMMENT-LEN) TO      
                         AR-TRAN-COMMENT-TEXT(1:PARM-TRAN-COMMENT-LEN)  
              MOVE AR-TRAN-COMMENT-TEXT    TO WS-JRNL-TRAN-COMMENT-TEXT 
              IF PARM-TRAN-COMMENT-LEN > 210                            
                 MOVE 210                  TO PARM-TRAN-COMMENT-LEN     
              END-IF                                                    
              MOVE PARM-TRAN-COMMENT-LEN   TO AR-TRAN-COMMENT-LEN       
                                              WS-JRNL-TRAN-COMMENT-LEN  
           END-IF.                                                      
      *                                                                         
      * CHECK IF THE ACCOUNT HAS AN ACTIVE RECONNECT AGREEMENT          07220000
      *                                                                         
           IF S-DNP-FLAG = 'N'                                          
              PERFORM 7400-SELECT-RECONNECT  THRU 7400-EXIT             
              IF S-REC-FLAG = 'N'                                       
                 IF PARM-TRAN-COMMENT-LEN > 210                         
                    MOVE 210 TO PARM-TRAN-COMMENT-LEN                   
                 END-IF                                                 
                 MOVE PARM-TRAN-COMMENT-LEN TO AR-TRAN-COMMENT-LEN      
                                               WS-JRNL-TRAN-COMMENT-LEN 
                 MOVE PARM-TRAN-COMMENT-TEXT TO AR-TRAN-COMMENT-TEXT    
                                               WS-JRNL-TRAN-COMMENT-TEXT
              ELSE                                                      
                 MOVE PARM-TRAN-COMMENT-LEN  TO WS-REC-HOLD-LEN         
                 MOVE PARM-TRAN-COMMENT-TEXT(1:WS-REC-HOLD-LEN)         
                      TO WS-REC-COMMENT-TEXT(1:WS-REC-HOLD-LEN)         
                 ADD 1 TO WS-REC-HOLD-LEN                               
                 MOVE '; ACCOUNT HAS RECONNECT AGREEMENT' TO            
                           WS-REC-COMMENT-TEXT(WS-REC-HOLD-LEN:33)      
                 ADD +33                    TO PARM-TRAN-COMMENT-LEN    
                 MOVE WS-REC-COMMENT-TEXT(1:PARM-TRAN-COMMENT-LEN) TO   
                         AR-TRAN-COMMENT-TEXT(1:PARM-TRAN-COMMENT-LEN)  
                 MOVE AR-TRAN-COMMENT-TEXT TO WS-JRNL-TRAN-COMMENT-TEXT 
                 IF PARM-TRAN-COMMENT-LEN > 210                         
                    MOVE 210                TO PARM-TRAN-COMMENT-LEN    
                 END-IF                                                 
                 MOVE PARM-TRAN-COMMENT-LEN TO AR-TRAN-COMMENT-LEN      
                                               WS-JRNL-TRAN-COMMENT-LEN 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 8030-UPDATE-COMMENT    THRU 8030-EXIT.               
           MOVE PARM-CASH-COMPANY-NO      TO WS-CD-COMPANY-NO.          
           MOVE PARM-CASH-LOCAL-OFFICE    TO WS-CD-LOCAL-OFFICE.        
           MOVE PARM-CASH-REPORT-NO       TO WS-CD-REPORT-NO.           
           MOVE PARM-DATE-CASH-REPORT     TO WS-CD-REPORT-DATE.         
           MOVE PARM-CASH-DRAWER-ID       TO WS-CASH-DRAWER-ID.         
           MOVE EIBTRNID                  TO WS-CSH-DRWR-TRAN-ID.       
      *                                                                         
           PERFORM 6904-INSERT-AR-DETAILS THRU 6904-EXIT.               
      *                                                                         
           PERFORM 8110-DELETE-LI-ROW THRU 8110-EXIT.                   
      *                                                                 07380000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07380000
      ******************************************************************07420000
      * 2300-CREATE-AR-FOR-REV                                         *07430000
      ******************************************************************07440000
      *                                                                 07380000
       2300-CREATE-AR-FOR-REV.                                          
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3    TO AR-ACCOUNT-NO.                
           MOVE PARM-CASH-COMPANY-NO   TO AR-CASH-COMPANY-NO.           
           MOVE PARM-CASH-LOCAL-OFFICE TO AR-CASH-LOCAL-OFFICE.         
           MOVE PARM-CASH-REPORT-NO    TO AR-CASH-REPORT-NO.            
           MOVE PARM-DATE-CASH-REPORT  TO AR-DATE-CASH-REPORT.          
           MOVE PARM-DATE-TRANS        TO AR-DATE-TRANS.                
           MOVE PARM-CASH-DRAWER-ID    TO AR-CASH-DRAWER-ID.            
           MOVE PARM-AMT-ORIG-ENTERED  TO WS-AMOUNT-PYMT.               
           MOVE WS-AMOUNT-PYMT-NUM     TO WS-AMOUNT-PYMT-COMP3.         
           MOVE WS-AMOUNT-PYMT-COMP3   TO AR-AMT-ORIG-ENTERED.          
      *                                                                         
           PERFORM 7100-SELECT-AR-TRANS-HIST THRU 7100-EXIT.            
                                                                        
           IF AR-DATE-ORIG-PYMT EQUAL SPACES                            
              MOVE -1 TO WS-NULL-IND1                                   
                         WS-DATE-ORIG-PYMT-IND                          
           END-IF.                                                      
           IF AR-DATE-TRANS     EQUAL SPACES                            
              MOVE -1 TO WS-NULL-IND2                                   
           END-IF.                                                      
           IF AR-TRANS-HIST-SEQ-NO EQUAL SPACES                         
              MOVE -1 TO WS-NULL-IND3                                   
           END-IF.                                                      
           MOVE 'Y'                 TO AR-PYMT-REFUNDED-IND.            
           MOVE WS-PAYMENT-REVERSED TO AR-APPL-PROGRAM-ID.              
           MOVE AR-DATE-TRANS       TO WS-PREV-DATE-TRANS.              
                                                                        
      * CHECK IF BILLINGS OCCURED ATER PAYMENT IF NOT MARK JOURNAL      07690000
      * ENTRIES FOR RECORD ONLY.                                        07700000
      *                                                                         
           PERFORM 7250-PROCESS-RECORD-ONLY THRU 7250-EXIT.             
                                                                        
      * NOT-FOUND MEANS THERE WAS NO BILLING FOUND SO RECORD ONLY       07720000
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'Y' TO WS-RECORD-ONLY                                
           END-IF.                                                      
           MOVE WS-RECORD-ONLY TO AR-RECORD-ONLY-FL.                    
      *                                                                         
           PERFORM 8020-UPDATE-AR-TRANS-HIST THRU 8020-EXIT.            
                                                                        
      *** CPD00010 CHANGES                                                      
           MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO WS-DATE                   
           MOVE AR-TRANS-HIST-SEQ-NO(12:8) TO WS-TIME                   
      *                                                                         
           PERFORM 7251-GET-ADJ-RECORD     THRU 7251-EXIT.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-FOUND-MULT-BILLS                                       
              MOVE WS-ADJ-TRANS-HIST-SEQ-NO     TO AR-TRANS-HIST-SEQ-NO 
              MOVE 'PANEL113H'                  TO AR-APPL-PROGRAM-ID   
              PERFORM 8020-UPDATE-AR-TRANS-HIST THRU 8020-EXIT          
           END-IF.                                                      
      *** CPD00010 CHANGES                                                      
                                                                        
      *                                                                         
           PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07820000
      * 6400-FINANCIAL JOURNALING ROUTINE                              *07830000
      ******************************************************************07840000
      *                                                                         
           EXEC SQL                                                     07850000
             INCLUDE CPD0006A                                           07860000
           END-EXEC.                                                    07870000
                                                                        
           EXEC SQL                                                     07890000
              INCLUDE CPD00116                                          07940000
           END-EXEC.                                                    07950000
      *                                                                 07980000
      ***************************************************************** 07990000
      * 7000-GET-CURRENT-TIMESTAMP                                    * 08000000
      ***************************************************************** 08010000
      *                                                                 07980000
       7000-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08040000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           08050000
MFA-TR*    END-EXEC.                                                    08060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080000
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                     08090000
MFA-TR*    END-EXEC.                                                    08100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO.          
      *                                                                 08130000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08130000
      ***************************************************************** 08160000
      * 7100-SELECT-AR-TRANS-HIST                                     * 08170000
      ***************************************************************** 08180000
      *                                                                 08130000
       7100-SELECT-AR-TRANS-HIST.                                       
                                                                        
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
           MOVE PARM-TRAN-TS(12:8) TO WS-TRAN-TS-TIME.                  
      *                                                                 03770000
           EXEC SQL                                                     
               SELECT DATE_TRANS,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
                      CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      CASH_REPORT_NO,                                   
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRAN_COMMENT                                      
                 INTO :AR-DATE-TRANS :WS-NULL-IND1,                      
                      :AR-TRANS-HIST-SEQ-NO,                            
                      :AR-CODE-TRAN-TYPE,                               
                      :AR-AMT-ORIG-ENTERED,                             
                      :AR-AMT-BILLED-UNPAID,                            
                      :AR-RESP-AREA-ID,                                 
                      :AR-APPL-PROGRAM-ID,                              
                      :AR-PYMT-FACILITY-CD,                             
                      :AR-USER-ID,                                      
                      :AR-COMPANY-NO,                                   
                      :AR-RECORD-ONLY-FL,                               
                      :AR-DATE-ORIG-PYMT :WS-NULL-IND2,                  
                      :AR-CASH-COMPANY-NO,                              
                      :AR-CASH-LOCAL-OFFICE,                            
                      :AR-CASH-REPORT-NO,                               
                      :AR-DATE-CASH-REPORT,                             
                      :AR-CASH-DRAWER-ID,                               
                      :AR-TRAN-COMMENT                                  
                 FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                
                  AND CODE_TRAN_TYPE    = 'P'                           
                  AND AMT_ORIG_ENTERED  = :AR-AMT-ORIG-ENTERED          
                  AND RECORD_ONLY_FL    IN ('N', ' ')                   
                  AND PYMT_REFUNDED_IND IN ('N', ' ')                   
                  AND CASH_COMPANY_NO   = :AR-CASH-COMPANY-NO           
                  AND CASH_LOCAL_OFFICE = :AR-CASH-LOCAL-OFFICE         
                  AND CASH_REPORT_NO    = :AR-CASH-REPORT-NO            
                  AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) )          
                  AND CASH_DRAWER_ID    = :AR-CASH-DRAWER-ID            
                  AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME)) = CIS.CHAR2TIME(:WS-TRAN-TS-TIME)        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*        SELECT DATE_TRANS,                                       08220000
MFA-TR*               TRANS_HIST_SEQ_NO,                                08220000
MFA-TR*               CODE_TRAN_TYPE,                                   08230000
MFA-TR*               AMT_ORIG_ENTERED,                                 08240000
MFA-TR*               AMT_BILLED_UNPAID,                                08250000
MFA-TR*               RESP_AREA_ID,                                     08260000
MFA-TR*               APPL_PROGRAM_ID,                                  08270000
MFA-TR*               PYMT_FACILITY_CD,                                 08280000
MFA-TR*               USER_ID,                                          08290000
MFA-TR*               COMPANY_NO,                                       08300000
MFA-TR*               RECORD_ONLY_FL,                                   08310000
MFA-TR*               DATE_ORIG_PYMT,                                   08320000
MFA-TR*               CASH_COMPANY_NO,                                  08330000
MFA-TR*               CASH_LOCAL_OFFICE,                                08340000
MFA-TR*               CASH_REPORT_NO,                                   08350000
MFA-TR*               DATE_CASH_REPORT,                                 08360000
MFA-TR*               CASH_DRAWER_ID,                                   08370000
MFA-TR*               TRAN_COMMENT                                      08380000
MFA-TR*          INTO :AR-DATE-TRANS:WS-NULL-IND1,                      08390000
MFA-TR*               :AR-TRANS-HIST-SEQ-NO,                            08390000
MFA-TR*               :AR-CODE-TRAN-TYPE,                               08400000
MFA-TR*               :AR-AMT-ORIG-ENTERED,                             08410000
MFA-TR*               :AR-AMT-BILLED-UNPAID,                            08420000
MFA-TR*               :AR-RESP-AREA-ID,                                 08430000
MFA-TR*               :AR-APPL-PROGRAM-ID,                              08440000
MFA-TR*               :AR-PYMT-FACILITY-CD,                             08450000
MFA-TR*               :AR-USER-ID,                                      08460000
MFA-TR*               :AR-COMPANY-NO,                                   08470000
MFA-TR*               :AR-RECORD-ONLY-FL,                               08480000
MFA-TR*               :AR-DATE-ORIG-PYMT:WS-NULL-IND2,                  08490000
MFA-TR*               :AR-CASH-COMPANY-NO,                              08500000
MFA-TR*               :AR-CASH-LOCAL-OFFICE,                            08510000
MFA-TR*               :AR-CASH-REPORT-NO,                               08520000
MFA-TR*               :AR-DATE-CASH-REPORT,                             08530000
MFA-TR*               :AR-CASH-DRAWER-ID,                               08540000
MFA-TR*               :AR-TRAN-COMMENT                                  08550000
MFA-TR*          FROM CSS_AR_TRANS_HIST                                 08560000
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                08570000
MFA-TR*           AND DATE_TRANS        = :AR-DATE-TRANS                08570000
MFA-TR*           AND CODE_TRAN_TYPE    = 'P'                                   
MFA-TR*           AND AMT_ORIG_ENTERED  = :AR-AMT-ORIG-ENTERED                  
MFA-TR*           AND RECORD_ONLY_FL    IN ('N', ' ')                           
MFA-TR*           AND PYMT_REFUNDED_IND IN ('N', ' ')                           
MFA-TR*           AND CASH_COMPANY_NO   = :AR-CASH-COMPANY-NO           07040000
MFA-TR*           AND CASH_LOCAL_OFFICE = :AR-CASH-LOCAL-OFFICE                 
MFA-TR*           AND CASH_REPORT_NO    = :AR-CASH-REPORT-NO            07060000
MFA-TR*           AND DATE_CASH_REPORT  = :AR-DATE-CASH-REPORT          07070000
MFA-TR*           AND CASH_DRAWER_ID    = :AR-CASH-DRAWER-ID            07120000
MFA-TR*           AND TIME(TRANS_HIST_SEQ_NO) = :WS-TRAN-TS-TIME        07120000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7100                                                         
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES TO AR-DATE-TRANS                              
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND2 < 0                                          
              MOVE SPACES TO AR-DATE-ORIG-PYMT                          
           END-IF.                                                      
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AR-TRANS-HIST-SEQ-NO TO WS-INPUT-TRANS-HIST-SEQ-NO   
                                           WS-PREV-TRANS-HIST-SEQ-NO    
                                           LI-VOUCHER-PAY-DT            
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE +300 TO WS-ACTIVE-RETURN-CODE                      
                             S-RETURN-CODE                              
             ELSE                                                       
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
             END-IF                                                     
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                  
             MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1          
             MOVE 'TRAN_HIST_SEQ_NO'        TO TABLE-ELEMENT-2          
             MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
             MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2        
             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 09780000
      * 7250-PROCESS-RECORD-ONLY                                      * 09790000
      ***************************************************************** 09840000
      *                                                                         
       7250-PROCESS-RECORD-ONLY.                                        
                                                                        
           MOVE '7250' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                INTO :WS-TRANS-HIST-SEQ-NO                              
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        
                 AND TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )          
                 AND CODE_TRAN_TYPE = 'B'                               
                 AND CIS.SUBSTR3(
           APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*         INTO :WS-TRANS-HIST-SEQ-NO                              09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        09900000
MFA-TR*          AND TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO          09910000
MFA-TR*          AND CODE_TRAN_TYPE = 'B'                               09920000
MFA-TR*          AND SUBSTR(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')   09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7250                                                 09940000
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
           OR WS-ACTIVE-RETURN-CODE EQUAL WS-FOUND-MULT-BILLS           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRAN_HIST_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 09780000
      * 7251-GET-ADJ-RECORD.                                          * 09790000
      ***************************************************************** 09840000
      *                                                                         
       7251-GET-ADJ-RECORD.                                             
                                                                        
           MOVE '7251' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                INTO :WS-ADJ-TRANS-HIST-SEQ-NO                          
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        
                 AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                 AND DATE_TRANS = IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                        
                 AND CODE_TRAN_TYPE = 'A'                               
                 AND APPL_PROGRAM_ID = 'PANEL113H'                      
                 AND CAST(TRANS_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) )                 
                 AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME)) = CIS.CHAR2TIME(:WS-TIME)                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*         INTO :WS-ADJ-TRANS-HIST-SEQ-NO                          09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        09900000
MFA-TR*          AND TRANS_HIST_SEQ_NO <= :AR-TRANS-HIST-SEQ-NO         09910000
MFA-TR*          AND DATE_TRANS = :AR-DATE-TRANS                                
MFA-TR*          AND CODE_TRAN_TYPE = 'A'                               09920000
MFA-TR*          AND APPL_PROGRAM_ID = 'PANEL113H'                              
MFA-TR*          AND DATE(TRANS_HIST_SEQ_NO) = :WS-DATE                 09930000
MFA-TR*          AND TIME(TRANS_HIST_SEQ_NO) = :WS-TIME                 09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7251                                                 09940000
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
           OR WS-ACTIVE-RETURN-CODE EQUAL WS-FOUND-MULT-BILLS           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRAN_HIST_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7251-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 10130000
      * 7300-PROCESS-DNP                                              * 10140000
      ***************************************************************** 10180000
      *                                                                         
       7300-PROCESS-DNP.                                                
                                                                        
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           MOVE 'N' TO S-DNP-FLAG.                                      
      *                                                                 03770000
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :S-DNP-FLAG                                        
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
                 AND ( CIS.SUBSTR3(DISCONNECT_HIST,1,1) IN ('R')             
                  OR CIS.SUBSTR3(DISC_EXCEPTN_HIST,1,1) IN ('R'))            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     10200000
MFA-TR*       SELECT 'Y'                                                10210000
MFA-TR*         INTO :S-DNP-FLAG                                        10220000
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 10230000
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        10240000
MFA-TR*          AND ( SUBSTR(DISCONNECT_HIST,1,1) IN ('R')             10250000
MFA-TR*           OR SUBSTR(DISC_EXCEPTN_HIST,1,1) IN ('R'))            10260000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7300                                                 10270000
MFA-TR*    END-EXEC.                                                    10270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CREDIT_PROFILE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10540000
      ***************************************************************** 10130000
      * 7400-SELECT-RECONNECT                                         * 10140000
      ***************************************************************** 10180000
      *                                                                         
       7400-SELECT-RECONNECT.                                           
                                                                        
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'N' TO S-REC-FLAG.                                      
      *                                                                 03770000
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :S-REC-FLAG                                        
                FROM CSS_RECONNECT WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :PARM-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10200000
MFA-TR*       SELECT 'Y'                                                10210000
MFA-TR*         INTO :S-REC-FLAG                                        10220000
MFA-TR*         FROM CSS_RECONNECT                                      10230000
MFA-TR*        WHERE ACCOUNT_NO = :PARM-ACCOUNT-NO                      10240000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7400                                                 10270000
MFA-TR*    END-EXEC.                                                    10270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RECONNECT'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10540000
      ***************************************************************** 10470000
      * 7999-SELECT-AL                                                *         
      ***************************************************************** 10490000
      *                                                                 10500000
           EXEC SQL                                                     10510000
              INCLUDE CPD00075                                          10520000
           END-EXEC.                                                    10530000
      *                                                                 10540000
      ***************************************************************** 10470000
      * 7999-SELECT-TRANSFER-IND                                      *         
      ***************************************************************** 10490000
      *                                                                 10500000
           EXEC SQL                                                     10550000
              INCLUDE CPD00307                                          10560000
           END-EXEC.                                                    10570000
      *                                                                         
      ******************************************************************07420000
      * 8000-UPDATE-AT-ACCT                                            *07430000
      ******************************************************************07440000
      *                                                                         
       8000-UPDATE-AT-ACCT.                                             
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET LAST_UPDATE_TS  = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )           
                WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET LAST_UPDATE_TS  = :WS-CURRENT-TIMESTAMP                   
MFA-TR*         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                          
MFA-TR*    QUERYNO 8000                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS                                         *         
      *****************************************************************         
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE '8000A'                  TO ACTIVE-PARAGRAPH.           
      *                                                                 03770000
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04804_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04804_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04804_R1'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
                                                HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08850000
      * 8010-UPDATE-CSH-DRWR-JRNL                                    *  08860000
      ****************************************************************  08870000
      *                                                                         
       8010-UPDATE-CSH-DRWR-JRNL.                                       
                                                                        
           MOVE '8010' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_CSH_DRWR_JRNL                                 
                  SET REVERSED_FL       = 'Y'                           
                WHERE CASH_COMPANY_NO   = :PARM-CASH-COMPANY-NO         
                  AND CASH_LOCAL_OFFICE = :PARM-CASH-LOCAL-OFFICE       
                  AND CASH_REPORT_NO    = :PARM-CASH-REPORT-NO          
                  AND USER_ID           = :PARM-USER-ID                 
                  AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                 :PARM-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :PARM-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:PARM-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:PARM-DATE-CASH-REPORT
              ), CONVERT(DATE, :PARM-DATE-CASH-REPORT) )        
                  AND CASH_DRAWER_ID    = :PARM-CASH-DRAWER-ID          
                  AND ACCOUNT_NO        = :PARM-ACCOUNT-NO              
                  AND                                                   
            (CIS.DECIMAL2DECIMAL3((CIS.CHAR2DECIMAL3((CIS.SUBSTR3$(
           CIS.HEX(CIS.SUBSTR3(TRAN_DATA,5,6)), 1, 11)) 
                    ,11,0)/100),11,2)) = :AR-AMT-ORIG-ENTERED           
                  AND TRAN_TS           = CIS.CHAR2TIMESTAMP(
                                                          :PARM-TRAN-TS
              )                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08890000
MFA-TR*        UPDATE CSS_CSH_DRWR_JRNL                                 08900000
MFA-TR*           SET REVERSED_FL       = 'Y'                           08910000
MFA-TR*         WHERE CASH_COMPANY_NO   = :PARM-CASH-COMPANY-NO         08920000
MFA-TR*           AND CASH_LOCAL_OFFICE = :PARM-CASH-LOCAL-OFFICE       08930000
MFA-TR*           AND CASH_REPORT_NO    = :PARM-CASH-REPORT-NO          08940000
MFA-TR*           AND USER_ID           = :PARM-USER-ID                 08950000
MFA-TR*           AND DATE_CASH_REPORT  = :PARM-DATE-CASH-REPORT        08960000
MFA-TR*           AND CASH_DRAWER_ID    = :PARM-CASH-DRAWER-ID          08970000
MFA-TR*           AND ACCOUNT_NO        = :PARM-ACCOUNT-NO              08980000
MFA-TR*           AND                                                   08990000
MFA-TR*     (DECIMAL((DECIMAL((SUBSTR(HEX(SUBSTR(TRAN_DATA,5,6)),1,11)) 09080000
MFA-TR*             ,11,0)/100),11,2)) = :AR-AMT-ORIG-ENTERED           09090000
MFA-TR*           AND TRAN_TS           = :PARM-TRAN-TS                 08990000
MFA-TR*    QUERYNO 8010                                                         
MFA-TR*    END-EXEC.                                                    09320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CSH_DRWR_JRNL'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'AMT_ORIG_ENTERED'        TO TABLE-ELEMENT-2         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-3         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-AMT-ORIG-ENTERED       TO HOSTVAR-ELEMENT-2-N     
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              MOVE AR-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 09490000
      * 8020-UPDATE-AR-TRANS-HIST                                     * 09500000
      ***************************************************************** 09510000
      *                                                                         
       8020-UPDATE-AR-TRANS-HIST.                                       
                                                                        
           MOVE '8020' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET USER_ID           = :AR-USER-ID,                  
                      APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID,          
                      PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND,        
                      RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09530000
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 09540000
MFA-TR*           SET USER_ID           = :AR-USER-ID,                  09550000
MFA-TR*               APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID,          09560000
MFA-TR*               PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND,        09570000
MFA-TR*               RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            09580000
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                09590000
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO         09600000
MFA-TR*    QUERYNO 8020                                                 09610000
MFA-TR*    END-EXEC.                                                    09610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_REFUNDED_IND'       TO TABLE-ELEMENT-2         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-3         
              MOVE 'APPL_PROGRAM_ID'         TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-PYMT-REFUNDED-IND      TO HOSTVAR-ELEMENT-2       
              MOVE AR-USER-ID                TO HOSTVAR-ELEMENT-3       
              MOVE AR-APPL-PROGRAM-ID        TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 09490000
      * 8030-UPDATE-COMMENT                                           * 09500000
      ***************************************************************** 09510000
      *                                                                         
       8030-UPDATE-COMMENT.                                             
                                                                        
           MOVE '8030' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET TRAN_COMMENT      = :AR-TRAN-COMMENT              
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09530000
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 09540000
MFA-TR*           SET TRAN_COMMENT      = :AR-TRAN-COMMENT              09550000
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                09590000
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO         09600000
MFA-TR*    QUERYNO 8030                                                 09610000
MFA-TR*    END-EXEC.                                                    09610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRAN_HIST_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08850000
      * 8040-INSERT-AR-TRANS-HIST                                     * 08860000
      ***************************************************************** 08870000
      *                                                                         
       8040-INSERT-AR-TRANS-HIST.                                       
                                                                        
           MOVE '8040' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRANS_HIST                            
                   ( ACCOUNT_NO,                                        
                     TRANS_HIST_SEQ_NO,                                 
                     DATE_TRANS,                                        
                     CODE_TRAN_TYPE,                                    
                     AMT_ORIG_ENTERED,                                  
                     AMT_BILLED_UNPAID,                                 
                     RESP_AREA_ID,                                      
                     APPL_PROGRAM_ID,                                   
                     PYMT_FACILITY_CD,                                  
                     USER_ID,                                           
                     COMPANY_NO,                                        
                     RECORD_ONLY_FL,                                    
                     DATE_ORIG_PYMT,                                    
                     PYMT_REFUNDED_IND,                                 
                     CASH_COMPANY_NO,                                   
                     CASH_LOCAL_OFFICE,                                 
                     CASH_REPORT_NO,                                    
                     DATE_CASH_REPORT,                                  
                     CASH_DRAWER_ID,                                    
                     TRAN_COMMENT)                                      
              VALUES                                                    
                  ( :AR-ACCOUNT-NO,                                     
                    CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO 
                                       :WS-NULL-IND3),                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-NULL-IND2
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2) ),                
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-RECORD-ONLY-FL,                                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                          :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-NULL-IND1) ),            
                    :AR-PYMT-REFUNDED-IND,                              
                    :AR-CASH-COMPANY-NO,                                
                    :AR-CASH-LOCAL-OFFICE,                              
                    :AR-CASH-REPORT-NO,                                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) ),                        
                    :AR-CASH-DRAWER-ID,                                 
                    :AR-TRAN-COMMENT)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08890000
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                            08900000
MFA-TR*            ( ACCOUNT_NO,                                        08910000
MFA-TR*              TRANS_HIST_SEQ_NO,                                 08920000
MFA-TR*              DATE_TRANS,                                        08930000
MFA-TR*              CODE_TRAN_TYPE,                                    08940000
MFA-TR*              AMT_ORIG_ENTERED,                                  08950000
MFA-TR*              AMT_BILLED_UNPAID,                                 08960000
MFA-TR*              RESP_AREA_ID,                                      08970000
MFA-TR*              APPL_PROGRAM_ID,                                   08980000
MFA-TR*              PYMT_FACILITY_CD,                                  08990000
MFA-TR*              USER_ID,                                           09000000
MFA-TR*              COMPANY_NO,                                        09010000
MFA-TR*              RECORD_ONLY_FL,                                    09020000
MFA-TR*              DATE_ORIG_PYMT,                                    09030000
MFA-TR*              PYMT_REFUNDED_IND,                                 09040000
MFA-TR*              CASH_COMPANY_NO,                                   09050000
MFA-TR*              CASH_LOCAL_OFFICE,                                 09060000
MFA-TR*              CASH_REPORT_NO,                                    09070000
MFA-TR*              DATE_CASH_REPORT,                                  09080000
MFA-TR*              CASH_DRAWER_ID,                                    09090000
MFA-TR*              TRAN_COMMENT)                                      09100000
MFA-TR*       VALUES                                                    09110000
MFA-TR*           ( :AR-ACCOUNT-NO,                                     09120000
MFA-TR*             :AR-TRANS-HIST-SEQ-NO:WS-NULL-IND3,                 09130000
MFA-TR*             :AR-DATE-TRANS:WS-NULL-IND2,                        09140000
MFA-TR*             :AR-CODE-TRAN-TYPE,                                 09150000
MFA-TR*             :AR-AMT-ORIG-ENTERED,                               09160000
MFA-TR*             :AR-AMT-BILLED-UNPAID,                              09170000
MFA-TR*             :AR-RESP-AREA-ID,                                   09180000
MFA-TR*             :AR-APPL-PROGRAM-ID,                                09190000
MFA-TR*             :AR-PYMT-FACILITY-CD,                               09200000
MFA-TR*             :AR-USER-ID,                                        09210000
MFA-TR*             :AR-COMPANY-NO,                                     09220000
MFA-TR*             :AR-RECORD-ONLY-FL,                                 09230000
MFA-TR*             :AR-DATE-ORIG-PYMT:WS-NULL-IND1,                    09240000
MFA-TR*             :AR-PYMT-REFUNDED-IND,                              09250000
MFA-TR*             :AR-CASH-COMPANY-NO,                                09260000
MFA-TR*             :AR-CASH-LOCAL-OFFICE,                              09270000
MFA-TR*             :AR-CASH-REPORT-NO,                                 09280000
MFA-TR*             :AR-DATE-CASH-REPORT,                               09290000
MFA-TR*             :AR-CASH-DRAWER-ID,                                 09300000
MFA-TR*             :AR-TRAN-COMMENT)                                   09310000
MFA-TR*    END-EXEC.                                                    09320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'AMT_ORIG_ENTERED'        TO TABLE-ELEMENT-2         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-3         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-AMT-ORIG-ENTERED       TO HOSTVAR-ELEMENT-2-N     
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              MOVE AR-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42860000
      *****************************************************************         
      * 8100-SEND-RESULT                                              *         
      *****************************************************************         
      *                                                                 42860000
       8100-SEND-RESULT.                                                
                                                                        
           MOVE '8100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
                INSERT INTO #CSR04804_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,DNP_FLAG                                            
                   ,AR_LOCKOUT_IND                                      
                   ,ACCT_XFER_TO                                        
                   ,REC_FLAG                                            
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-DNP-FLAG                                         
                   ,:S-AR-LOCKOUT-IND                                   
                   ,:S-ACCT-XFER-TO                                     
                   ,:S-REC-FLAG                                         
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04804_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,DNP_FLAG                                                    
MFA-TR*            ,AR_LOCKOUT_IND                                              
MFA-TR*            ,ACCT_XFER_TO                                                
MFA-TR*            ,REC_FLAG                                                    
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-DNP-FLAG                                                 
MFA-TR*            ,:S-AR-LOCKOUT-IND                                           
MFA-TR*            ,:S-ACCT-XFER-TO                                             
MFA-TR*            ,:S-REC-FLAG                                                 
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1 TO CTR-ROWS                                        
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04804_R1'              TO TABLE-1                
              MOVE SPACES                     TO TABLE-ELEMENT-1        
                                                 HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 10420200
      * 8110-DELETE-LI-ROW                                            *         
      ***************************************************************** 10420500
      *                                                                         
       8110-DELETE-LI-ROW.                                              
                                                                        
           MOVE '8110' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           EXEC SQL                                                     
             DELETE FROM  CSS_LIEAP                                     
                   WHERE  ACCOUNT_NO    = :LI-ACCOUNT-NO                
                     AND VOUCHER_PAY_DT = CIS.CHAR2TIMESTAMP(
                                                     :LI-VOUCHER-PAY-DT
              )           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10420800
MFA-TR*      DELETE FROM  CSS_LIEAP                                     10420900
MFA-TR*            WHERE  ACCOUNT_NO    = :LI-ACCOUNT-NO                10421000
MFA-TR*              AND VOUCHER_PAY_DT = : LI-VOUCHER-PAY-DT           10421200
MFA-TR*    QUERYNO 8110                                                 10421400
MFA-TR*    END-EXEC.                                                    10421400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 10421800
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE ZERO  TO WS-ACTIVE-RETURN-CODE                       
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_LIEAP'                TO TABLE-1                
              MOVE 'ACCOUNT-NO    '           TO TABLE-ELEMENT-1        
              MOVE 'VOUCHER_PAY_DT'           TO TABLE-ELEMENT-2        
              MOVE LI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE LI-VOUCHER-PAY-DT          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 10422900
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10422900
      *****************************************************************         
      * 9200-LINK-SCSCA182                                            *         
      *****************************************************************         
      *                                                                         
       9200-LINK-SCSCA182.                                              
                                                                        
           MOVE '9200' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03770000
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                               , SCSCA182-RETURN-CODE                   
                               , SCSCA182-LAST-UPDATE-TS                
                               , ABEND-FILE.                            
      *                                                                         
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10540000
      ***************************************************************** 10470000
      * 9700-PROCESS-ABEND                                            *         
      ***************************************************************** 10490000
      *                                                                 10500000
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                 10580000
      ***************************************************************** 10590000
      * 9900-SQL-ERROR-ROUTINE                                        * 10600000
      * 9975-ABEND-CONTROL-TRANSFER                                   * 10600000
      ***************************************************************** 10610000
      *                                                                 10650000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      * 9000-SEND-ERROR-RESULT                                         *        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
