       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04800.                                      
COB303 DATE-WRITTEN.     JULY 17, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04800              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04800 : NEW LOGIN/REGISTRATION.                        --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             PARM-CUSTOMER-NO     CHAR(10)                  --         
      *--             PARM-EMAIL-ADDRESS   CHAR(100)                 --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--  CSR04800_R1 - MATCHED CUSTOMER                            --         
      *--                                                            --         
      *--           RETURN_CODE        INTEGER                       --         
      *--           CUSTOMER_NO        DECIMAL(10,0)                 --         
      *--           ACCOUNT_NO         DECIMAL(13,0)                 --         
      *--           ACCOUNT_TYPE_CODE  CHAR(1)                       --         
      *--           SSN                CHAR(4)                       --         
      *--           ITIN_ID            CHAR(9)                       --         
      *--           TAX_ID             CHAR(9)                       --         
      *--           ZIP_CODE           CHAR(5)                       --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  07/17/2014    SV95326     INITIAL CODE                    --         
A05136*--  03/23/2014    DB41297     CHANGE UPPER TO LOWER STATEMENT --         
ACT071*--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04800'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                         PIC X(40) VALUE              
            'WORKING STORAGE FOR CSR04800 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                PIC X(8) VALUE 'CSR04800'.   
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.    
           05  WS-NULL-IND                 PIC S9(4) COMP.              
           05  WS-FETCH-NO-DATA-SW         PIC X(01) VALUE 'N'.         
               88 FETCH-NO-DATA                VALUE 'Y'.               
                                                                        
       01  WS-PARM-FIELDS.                                              
           05 PARM-CUSTOMER-NO             PIC X(10).                   
           05 PARM-EMAIL-ADDRESS           PIC X(100).                  
                                                                        
       01 NULL-INDICATORS.                                              
           05 WS-NULL-SSN-4-DIGITS         PIC S9(4) COMP VALUE -1.     
           05 WS-NULL-ITIN-ID              PIC S9(4) COMP VALUE -1.     
           05 WS-NULL-OTHER-ID-TYPE        PIC S9(4) COMP VALUE -1.     
           05 WS-NULL-OTHER-ID             PIC S9(4) COMP VALUE -1.     
           05 WS-NULL-CUSTOMER-TYPE        PIC S9(4) COMP VALUE -1.     
      *                                                                 01482100
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
           05 WS-NO-MORE-ROWS          PIC X(01) VALUE 'N'.             
              88 NO-MORE-ROWS                    VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(9) COMP VALUE 0.      
COB305     05 S-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.    
COB305     05 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
           05  S-ACCOUNT-TYPE-CODE         PIC X(01) VALUE SPACES.      
           05  S-SSN-FOUR-DIGIT            PIC X(04) VALUE SPACES.      
           05  S-ITIN-ID                   PIC X(09) VALUE SPACES.      
           05  S-TAX-ID                    PIC X(09) VALUE SPACES.      
           05  S-ZIP-CODE                  PIC X(05) VALUE SPACES.      
           05  S-COMPANY-NO                PIC X(02) VALUE SPACES.      
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    BS - CSS_BUS_CUST_STATS                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    NE - CSS_CUST_EMAIL                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH DATA BY USING EMAIL ADDRESS.     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE EMAIL_ADDR_CUR CURSOR FOR                        
                 SELECT NE.CUSTOMER_NO                                  
                       ,AT.ACCOUNT_NO                                   
                       ,AT.ACCOUNT_TYPE_CODE                            
                       ,RIGHT(CE.SSN, 4)                                 
                       ,CE.ITIN_ID                                      
                       ,DY.ZIP_CODE                                     
                       ,CE.OTHER_ID_TYPE                                
                       ,CE.OTHER_ID                                     
                       ,AT.COMPANY_NO                                   
                       ,CE.CUSTOMER_TYPE                                
                  FROM CSS_CUST_EMAIL NE WITH(READUNCOMMITTED)                  
                      ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                      ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                      LEFT JOIN CSS_CUST_STATS CE WITH(READUNCOMMITTED)         
                      ON (  HT.CUSTOMER_NO = CE.CUSTOMER_NO             
                      AND CE.CUSTOMER_TYPE = 'C'                        
                      AND CE.NAME_ID       = HT.NAME_ID )               
ACT071           WHERE NE.EMAIL_ADDRESS_TX =                            
ACT071                         LOWER(:PARM-EMAIL-ADDRESS)               
                   AND NE.EMAIL_TYPE_CD = 'P1'                          
                   AND NE.CUSTOMER_NO = AT.CUSTOMER_NO                  
                   AND NE.CUSTOMER_NO = HT.CUSTOMER_NO                  
                   AND AT.ACCOUNT_NO = HT.ACCOUNT_NO                    
                   AND NE.CUSTOMER_NO = HT.CUSTOMER_NO                  
                   AND HT.ADDRESS_ID    = DY.ADDRESS_ID                 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EMAIL_ADDR_CUR CURSOR FOR                                
MFA-TR*          SELECT NE.CUSTOMER_NO                                          
MFA-TR*                ,AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.ACCOUNT_TYPE_CODE                                    
MFA-TR*                ,RIGHT(CE.SSN,4)                                         
MFA-TR*                ,CE.ITIN_ID                                              
MFA-TR*                ,DY.ZIP_CODE                                             
MFA-TR*                ,CE.OTHER_ID_TYPE                                        
MFA-TR*                ,CE.OTHER_ID                                             
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,CE.CUSTOMER_TYPE                                        
MFA-TR*           FROM CSS_CUST_EMAIL NE                                        
MFA-TR*               ,CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_NAME_ACCT_XREF HT                                    
MFA-TR*               LEFT JOIN CSS_CUST_STATS CE                               
MFA-TR*               ON (  HT.CUSTOMER_NO = CE.CUSTOMER_NO                     
MFA-TR*               AND CE.CUSTOMER_TYPE = 'C'                                
MFA-TR*               AND CE.NAME_ID       = HT.NAME_ID )                       
MFA-TR*          WHERE NE.EMAIL_ADDRESS_TX =                                    
MFA-TR*                        LOWER(:PARM-EMAIL-ADDRESS)                       
MFA-TR*            AND NE.EMAIL_TYPE_CD = 'P1'                                  
MFA-TR*            AND NE.CUSTOMER_NO = AT.CUSTOMER_NO                          
MFA-TR*            AND NE.CUSTOMER_NO = HT.CUSTOMER_NO                          
MFA-TR*            AND AT.ACCOUNT_NO = HT.ACCOUNT_NO                            
MFA-TR*            AND NE.CUSTOMER_NO = HT.CUSTOMER_NO                          
MFA-TR*            AND HT.ADDRESS_ID    = DY.ADDRESS_ID                         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH DATA BY USING CUSTOMER NO.       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE CUST_NO_CUR CURSOR FOR                           
                 SELECT HT.CUSTOMER_NO                                  
                       ,AT.ACCOUNT_NO                                   
                       ,AT.ACCOUNT_TYPE_CODE                            
                       ,RIGHT(CE.SSN, 4)                                 
                       ,CE.ITIN_ID                                      
                       ,DY.ZIP_CODE                                     
                       ,CE.OTHER_ID_TYPE                                
                       ,CE.OTHER_ID                                     
                       ,AT.COMPANY_NO                                   
                       ,CE.CUSTOMER_TYPE                                
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                      ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                      LEFT JOIN CSS_CUST_STATS CE WITH(READUNCOMMITTED)         
                      ON (  HT.CUSTOMER_NO = CE.CUSTOMER_NO             
                      AND CE.CUSTOMER_TYPE = 'C'                        
                      AND CE.NAME_ID       = HT.NAME_ID )               
                 WHERE HT.CUSTOMER_NO      = :HT-CUSTOMER-NO            
                   AND HT.CUSTOMER_NO      = AT.CUSTOMER_NO             
                   AND AT.ACCOUNT_NO       = HT.ACCOUNT_NO              
                   AND HT.ADDRESS_ID       = DY.ADDRESS_ID              
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CUST_NO_CUR CURSOR FOR                                   
MFA-TR*          SELECT HT.CUSTOMER_NO                                          
MFA-TR*                ,AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.ACCOUNT_TYPE_CODE                                    
MFA-TR*                ,RIGHT(CE.SSN,4)                                         
MFA-TR*                ,CE.ITIN_ID                                              
MFA-TR*                ,DY.ZIP_CODE                                             
MFA-TR*                ,CE.OTHER_ID_TYPE                                        
MFA-TR*                ,CE.OTHER_ID                                             
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,CE.CUSTOMER_TYPE                                        
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_NAME_ACCT_XREF HT                                    
MFA-TR*               LEFT JOIN CSS_CUST_STATS CE                               
MFA-TR*               ON (  HT.CUSTOMER_NO = CE.CUSTOMER_NO                     
MFA-TR*               AND CE.CUSTOMER_TYPE = 'C'                                
MFA-TR*               AND CE.NAME_ID       = HT.NAME_ID )                       
MFA-TR*          WHERE HT.CUSTOMER_NO      = :HT-CUSTOMER-NO                    
MFA-TR*            AND HT.CUSTOMER_NO      = AT.CUSTOMER_NO                     
MFA-TR*            AND AT.ACCOUNT_NO       = HT.ACCOUNT_NO                      
MFA-TR*            AND HT.ADDRESS_ID       = DY.ADDRESS_ID                      
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                  RETURN_CODE                                           
                 ,CUSTOMER_NO                                           
                 ,ACCOUNT_NO                                            
                 ,ACCOUNT_TYPE_CODE                                     
                 ,SSN_FOUR_DIGIT                                        
                 ,ITIN_ID                                               
                 ,TAX_ID                                                
                 ,ZIP_CODE                                              
                 ,COMPANY_NO                                            
               FROM #CSR04800_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,CUSTOMER_NO                                                   
MFA-TR*          ,ACCOUNT_NO                                                    
MFA-TR*          ,ACCOUNT_TYPE_CODE                                             
MFA-TR*          ,SSN_FOUR_DIGIT                                                
MFA-TR*          ,ITIN_ID                                                       
MFA-TR*          ,TAX_ID                                                        
MFA-TR*          ,ZIP_CODE                                                      
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*        FROM SESSION.CSR04800_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
      ******************************************************************        
       LINKAGE SECTION.                                                 
       01 LINK-CUSTOMER-NO                 PIC X(10).                   
       01 LINK-EMAIL-ADDRESS               PIC X(100).                  
                                                                        
       PROCEDURE DIVISION USING LINK-CUSTOMER-NO,                       
                                LINK-EMAIL-ADDRESS.                     
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02920000
      * 0100-INITIALIZE                                                *02930000
      *                                                                *02940000
      *     1. RESET DB2 ERROR HANDLERS                                *02950000
      *     2. DECLARE CURSORS FOR RETURN VALUES.                      *02960000
      *                                                                *02990000
      ******************************************************************03000000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO        .  
           MOVE LINK-EMAIL-ADDRESS        TO PARM-EMAIL-ADDRESS      .  
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04800_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04800_R1
              (                                                          
               RETURN_CODE              INT                         
              ,CUSTOMER_NO              DECIMAL(10,0)                   
              ,ACCOUNT_NO               DECIMAL(13,0)                   
              ,ACCOUNT_TYPE_CODE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,SSN_FOUR_DIGIT CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,ITIN_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,TAX_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2                 
              ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04800_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                     TO ACTIVE-PARAGRAPH.         
           MOVE PARM-CUSTOMER-NO           TO HT-CUSTOMER-NO.           
           MOVE PARM-EMAIL-ADDRESS         TO NE-EMAIL-ADDRESS-TX.      
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
                                                                        
            MOVE '2000'                     TO ACTIVE-PARAGRAPH.        
                                                                        
            IF NE-EMAIL-ADDRESS-TX > SPACES                             
                PERFORM 7000-OPEN-EMAIL-ADDR-CUR  THRU 7000-EXIT        
                PERFORM 2200-PROCESS-EMAIL-ADDR-ROW THRU 2200-EXIT      
                        UNTIL FETCH-NO-DATA                             
                PERFORM 7020-CLOSE-EMAIL-ADDR-CUR  THRU 7020-EXIT       
            ELSE                                                        
                PERFORM 7100-OPEN-CUST-NO-CUR  THRU 7100-EXIT           
                PERFORM 2300-PROCESS-CUST-NO-ROW THRU 2300-EXIT         
                        UNTIL FETCH-NO-DATA                             
                PERFORM 7120-CLOSE-CUST-NO-CUR  THRU 7120-EXIT          
            END-IF.                                                     
                                                                        
            IF CTR-ROWS < 1                                             
                INITIALIZE GTT-RETURN-FIELDS                            
                MOVE 100                   TO S-RETURN-CODE             
                PERFORM 8100-SEND-RESULT   THRU 8100-EXIT               
            END-IF.                                                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-CUSTOMER-NO          TO S-CUSTOMER-NO.               
           MOVE AT-ACCOUNT-NO           TO S-ACCOUNT-NO.                
           MOVE AT-ACCOUNT-TYPE-CODE    TO S-ACCOUNT-TYPE-CODE.         
           MOVE CE-SSN                  TO S-SSN-FOUR-DIGIT.            
           IF CE-ITIN-ID < SPACES                                       
              MOVE SPACES               TO CE-ITIN-ID                   
           END-IF.                                                      
           IF CE-ITIN-ID = SPACES AND CE-OTHER-ID-TYPE = 'ITIN'         
              MOVE CE-OTHER-ID          TO S-ITIN-ID                    
           ELSE                                                         
              MOVE CE-ITIN-ID           TO S-ITIN-ID                    
           END-IF.                                                      
           MOVE BS-TAX-ID               TO S-TAX-ID.                    
           MOVE DY-ZIP-CODE             TO S-ZIP-CODE.                  
           MOVE AT-COMPANY-NO           TO S-COMPANY-NO.                
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-EMAIL-ADDR-ROW.                                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-EMAIL-ADDR-ROW.                                     
                                                                        
           PERFORM 7010-FETCH-EMAIL-ADDR-CUR  THRU 7010-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES                        TO BS-TAX-ID           
              PERFORM 7200-SELECT-CUST-COM       THRU 7200-EXIT         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                  
                 CE-CUSTOMER-TYPE = 'C'                                 
                 PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT     
                 PERFORM 8100-SEND-RESULT           THRU 8100-EXIT      
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT  
                    PERFORM 8100-SEND-RESULT           THRU 8100-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-CUST-NO-ROW.                                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2300-PROCESS-CUST-NO-ROW.                                        
                                                                        
           PERFORM 7110-FETCH-CUST-NO-CUR     THRU 7110-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES                        TO BS-TAX-ID           
              PERFORM 7200-SELECT-CUST-COM       THRU 7200-EXIT         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                  
                 CE-CUSTOMER-TYPE = 'C'                                 
                 PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT     
                 PERFORM 8100-SEND-RESULT           THRU 8100-EXIT      
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT  
                    PERFORM 8100-SEND-RESULT           THRU 8100-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
      * 7000-OPEN-EMAIL-ADDR-CUR.                                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-OPEN-EMAIL-ADDR-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN EMAIL_ADDR_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_CUST_EMAIL'       TO TABLE-1                   
               MOVE 'EMAIL_ADDRESS_TX'     TO TABLE-ELEMENT-1           
               MOVE PARM-EMAIL-ADDRESS     TO HOSTVAR-ELEMENT-1         
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-EMAIL-ADDR-CUR.                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7010-FETCH-EMAIL-ADDR-CUR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH EMAIL_ADDR_CUR                                    
                INTO :WS-CUSTOMER-NO                                    
                    ,:AT-ACCOUNT-NO                                     
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:CE-SSN :WS-NULL-SSN-4-DIGITS                       
                    ,:CE-ITIN-ID :WS-NULL-ITIN-ID                        
                    ,:DY-ZIP-CODE                                       
                    ,:CE-OTHER-ID-TYPE :WS-NULL-OTHER-ID-TYPE            
                    ,:CE-OTHER-ID :WS-NULL-OTHER-ID                      
                    ,:AT-COMPANY-NO                                     
                    ,:CE-CUSTOMER-TYPE :WS-NULL-CUSTOMER-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
                    IF WS-NULL-SSN-4-DIGITS = -1                        
                       MOVE SPACES          TO CE-SSN                   
                    END-IF                                              
                    IF WS-NULL-ITIN-ID    = -1                          
                       MOVE SPACES          TO CE-ITIN-ID               
                    END-IF                                              
                    IF WS-NULL-OTHER-ID-TYPE = -1                       
                       MOVE SPACES          TO CE-OTHER-ID-TYPE         
                    END-IF                                              
                    IF WS-NULL-OTHER-ID   = -1                          
                       MOVE SPACES          TO CE-OTHER-ID              
                    END-IF                                              
                    IF WS-NULL-CUSTOMER-TYPE = -1                       
                       MOVE SPACES          TO CE-CUSTOMER-TYPE         
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 100                TO WS-ACTIVE-RETURN-CODE    
                    MOVE 'Y'                TO WS-FETCH-NO-DATA-SW      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7010'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CSS_CUST_EMAIL'       TO TABLE-1              
                    MOVE 'EMAIL_ADDRESS_TX'     TO TABLE-ELEMENT-1      
                    MOVE PARM-EMAIL-ADDRESS     TO HOSTVAR-ELEMENT-1    
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT     
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-EMAIL-ADDR-CUR.                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7020-CLOSE-EMAIL-ADDR-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE EMAIL_ADDR_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7020'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_CUST_EMAIL'       TO TABLE-1                   
               MOVE 'EMAIL_ADDRESS_TX'     TO TABLE-ELEMENT-1           
               MOVE PARM-EMAIL-ADDRESS     TO HOSTVAR-ELEMENT-1         
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-CUST-NO-CUR.                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-OPEN-CUST-NO-CUR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN CUST_NO_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_CUST_EMAIL'       TO TABLE-1                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE PARM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-CUST-NO-CUR.                                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7110-FETCH-CUST-NO-CUR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH CUST_NO_CUR                                       
                INTO :WS-CUSTOMER-NO                                    
                    ,:AT-ACCOUNT-NO                                     
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:CE-SSN :WS-NULL-SSN-4-DIGITS                       
                    ,:CE-ITIN-ID :WS-NULL-ITIN-ID                        
                    ,:DY-ZIP-CODE                                       
                    ,:CE-OTHER-ID-TYPE :WS-NULL-OTHER-ID-TYPE            
                    ,:CE-OTHER-ID :WS-NULL-OTHER-ID                      
                    ,:AT-COMPANY-NO                                     
                    ,:CE-CUSTOMER-TYPE :WS-NULL-CUSTOMER-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
                    IF WS-NULL-SSN-4-DIGITS = -1                        
                       MOVE SPACES          TO CE-SSN                   
                    END-IF                                              
                    IF WS-NULL-ITIN-ID    = -1                          
                       MOVE SPACES          TO CE-ITIN-ID               
                    END-IF                                              
                    IF WS-NULL-OTHER-ID-TYPE = -1                       
                       MOVE SPACES          TO CE-OTHER-ID-TYPE         
                    END-IF                                              
                    IF WS-NULL-OTHER-ID   = -1                          
                       MOVE SPACES          TO CE-OTHER-ID              
                    END-IF                                              
                    IF WS-NULL-CUSTOMER-TYPE = -1                       
                       MOVE SPACES          TO CE-CUSTOMER-TYPE         
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 100                TO WS-ACTIVE-RETURN-CODE    
                    MOVE 'Y'                TO WS-FETCH-NO-DATA-SW      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7110'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1      
                    MOVE PARM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1    
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT     
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-CUST-NO-CUR.                                        *        
      ******************************************************************        
                                                                        
       7120-CLOSE-CUST-NO-CUR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE CUST_NO_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7120'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE PARM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-CUST-COM.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-SELECT-CUST-COM.                                            
                                                                        
           MOVE '7200'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              SELECT TAX_ID                                             
              INTO :BS-TAX-ID                                           
              FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                     
              WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TAX_ID                                                     
MFA-TR*       INTO :BS-TAX-ID                                                   
MFA-TR*       FROM CSS_BUS_CUST_STATS                                           
MFA-TR*       WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_BUS_CUST_STATS'   TO TABLE-1                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*00000100
       8000A-DELETE-GTT-ROWS.                                           
      *================================================================*00000300
      *                                                                 00000500
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04800_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04800_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04800_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *================================================================*06310000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     06320000
      *================================================================*06330000
           EXEC SQL                                                     06340000
              INCLUDE CPDSP300                                          06350000
           END-EXEC.                                                    06360000
                                                                        
      *================================================================*06420000
       8100-SEND-RESULT.                                                
      *================================================================*06420000
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04800_R1                            
             (                                                          
               RETURN_CODE                                              
              ,CUSTOMER_NO                                              
              ,ACCOUNT_NO                                               
              ,ACCOUNT_TYPE_CODE                                        
              ,SSN_FOUR_DIGIT                                           
              ,ITIN_ID                                                  
              ,TAX_ID                                                   
              ,ZIP_CODE                                                 
              ,COMPANY_NO                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-CUSTOMER-NO                                            
             ,:S-ACCOUNT-NO                                             
             ,:S-ACCOUNT-TYPE-CODE                                      
             ,:S-SSN-FOUR-DIGIT                                         
             ,:S-ITIN-ID                                                
             ,:S-TAX-ID                                                 
             ,:S-ZIP-CODE                                               
             ,:S-COMPANY-NO                                             
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04800_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,CUSTOMER_NO                                                      
MFA-TR*       ,ACCOUNT_NO                                                       
MFA-TR*       ,ACCOUNT_TYPE_CODE                                                
MFA-TR*       ,SSN_FOUR_DIGIT                                                   
MFA-TR*       ,ITIN_ID                                                          
MFA-TR*       ,TAX_ID                                                           
MFA-TR*       ,ZIP_CODE                                                         
MFA-TR*       ,COMPANY_NO                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-CUSTOMER-NO                                                    
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-ACCOUNT-TYPE-CODE                                              
MFA-TR*      ,:S-SSN-FOUR-DIGIT                                                 
MFA-TR*      ,:S-ITIN-ID                                                        
MFA-TR*      ,:S-TAX-ID                                                         
MFA-TR*      ,:S-ZIP-CODE                                                       
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04800_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
