       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04795.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. JUNE 2, 2014.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM VALIDATES BILL CYCLE AND CHANGE REASON.          *        
      *                                                                *        
      *  IF THE USER CHANGES THE REASON AND SELECTS SPACES FROM THE    *        
      *  DROPDOWN, THE UI MUST PASS A C IN THE CHANGE REASON. IF THE   *        
      *  USER DOES NOT CHANGE THE REASON, THE UI MUST PASS WHAT CAME   *        
      *  FROM THE DATABASE - INCLUDING SPACES WHICH IS THE DEFAULT.    *        
      *  THIS PROGRAM SHOULD NEVER GET A SPACE IF THE REASON IS        *        
      *  CHANGED.                                                      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  06/02/2014 FMB       INITIAL VERSION                          *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04795'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04795 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04795_R1'.          
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(9) COMP VALUE ZERO.       
          05 S-BUS-RULE-ID             PIC X(10) VALUE SPACES.          
          05 S-RULE-RESULT-CD          PIC X(08) VALUE SPACES.          
          05 S-BUS-RULE-XREF-ID        PIC X(26) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04795'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-DATABASE              PIC 9(01) VALUE 0.               
              88  CSR-DATABASE                   VALUE 1.               
              88  SEB-DATABASE                   VALUE 2.               
COB305    05 WS-REV-MONTH-FROM        PIC S9(6)V USAGE COMP-3 VALUE 0.         
          05  WS-LAST-REV-MONTH        PIC 9(6) VALUE 0.                
          05  WS-YEAR                  PIC 9(04) VALUE 0.               
          05  WS-MONTH                 PIC 9(02) VALUE 0.               
          05  WS-BILL-CYCLE-NUM        PIC 9(02)   VALUE 0.             
          05  WS-NEW-DRAFT-CYCLE       PIC 9(02)   VALUE 0.             
          05  WS-NEW-DRAFT-CYCLE-C     PIC X(02)   VALUE SPACES.        
          05  WS-BILL-CYCLE-PLUS-5     PIC 9(02)   VALUE 0.             
          05  WS-BILL-CYCLE-MINUS-2    PIC 9(02)   VALUE 0.             
          05  WS-PENDING-DRAFT-FL      PIC X(01) VALUE SPACES.          
          05  WS-NULL-1                PIC S9(04) COMP.                 
          05  WS-NULL-2                PIC S9(04) COMP.                 
          05  WS-NULL-3                PIC S9(04) COMP.                 
          05  WS-NULL-4                PIC S9(04) COMP.                 
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  CSR01150-CALL-DATA.                                          
           05  BILL-CYCLE-1150           PIC X(02) VALUE SPACES.        
           05  TIMESTAMP-1150            PIC X(26) VALUE SPACES.        
                                                                        
       01  CSR01150-RETURN-DATA.                                        
           05  RETURN-CODE-1150          PIC S9(9) COMP VALUE 0.        
           05  BILL-DAY-1150             PIC S9(9) COMP VALUE 0.        
COB305     05 REVENUE-MONTH-1150        PIC S9(6)V USAGE COMP-3 VALUE 0.       
                                                                        
      *01 LOC1150 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPDBKDF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 RULE_RESULT_CD       AS RULE_RESULT_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID               
              FROM #CSR04795_R1                                  
      *       FETCH FIRST 1 ROWS ONLY                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          RULE_RESULT_CD       AS RULE_RESULT_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID                       
MFA-TR*       FROM SESSION.CSR04795_R1                                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE       AS RETURN_CODE,              
                      :S-BUS-RULE-ID       AS BUS_RULE_ID,              
                      :S-RULE-RESULT-CD    AS RULE_RESULT_CD,           
                      :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID          
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE       AS RETURN_CODE,                      
MFA-TR*               :S-BUS-RULE-ID       AS BUS_RULE_ID,                      
MFA-TR*               :S-RULE-RESULT-CD    AS RULE_RESULT_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1150 CURSOR
MSQ001          FOR CALL CSR01150                                             
                  ( :BILL-CYCLE-1150
                  , :TIMESTAMP-1150
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-BILL-CYCLE          PIC X(02).                          
       01  LINK-CYCLE-CHG-CD        PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO,                       
                                 LINK-BILL-CYCLE,                       
                                 LINK-CYCLE-CHG-CD.                     
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N' TO WS-GTT01-DECLARED.                               
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04795_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04795_R1
              (                                                          
               RETURN_CODE          INT,                            
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               RULE_RESULT_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04795_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO.               
           MOVE 'CASA' TO 1T-BUS-PROCESS-ID.                            
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-ACCOUNT-NO = ZEROES                                  
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE +100 TO S-RETURN-CODE                               
               MOVE 'PARMS ZERO' TO S-BUS-RULE-ID                       
               ADD +1 TO CTR-ROWS                                       
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7015-READ-CYCLE THRU 7015-EXIT.                      
           PERFORM 7020-BANK-EFT THRU 7020-EXIT.                        
           PERFORM 7025-PENDING-DRAFT THRU 7025-EXIT.                   
           PERFORM 7030-CURRENT-REV-MONTH THRU 7030-EXIT.               
           PERFORM 7035-CURRENT-BILL-CYCLE THRU 7035-EXIT.              
           PERFORM 7040-SELECT-CRED-COLL THRU 7040-EXIT.                
                                                                        
      *  NEED TO SPLIT VALIDATIONS UP LIKE THE PB LOGIC BECAUSE THE             
      *  LINK-BILL-CYCLE CAN CHANGE WHEN THE REASON CHANGES. SUBSEQUENT         
      *  EDITS SHOULD BE DONE ON THE CHANGED CYCLE.                             
                                                                        
      *  FROM POWERBUILDER EVENTS:                                              
      *      ITEMCHANGED                                                        
      *      FW_I_VALIDATE_BILL_CYCLE                                           
      *      FW_I_GET_BILL_DAY                                                  
                                                                        
           IF LINK-BILL-CYCLE NOT = AT-BILL-CYCLE                       
               PERFORM 2100-VALIDATE-CYCLE-CHANGE THRU 2100-EXIT
           END-IF.       
           IF LINK-CYCLE-CHG-CD NOT = AT-BILL-CYCLE-CHG-CD              
               PERFORM 2200-VALIDATE-REASON-CHANGE THRU 2200-EXIT
           END-IF.      
                                                                        
      *  FROM POWERBUILDER EVENTS:                                              
      *      FW_I_EDITFIELDS                                                    
      *      FW_S_CALCDRAFTCYCLE                                                
                                                                        
           IF LINK-BILL-CYCLE NOT = AT-BILL-CYCLE                       
               PERFORM 2300-VALIDATE-CYCLE-CHANGE THRU 2300-EXIT
           END-IF.       
           IF LINK-CYCLE-CHG-CD NOT = AT-BILL-CYCLE-CHG-CD              
               PERFORM 2400-VALIDATE-REASON-CHANGE THRU 2400-EXIT
           END-IF.      
                                                                        
           IF (AT-CREDIT-GROUP = 'M' OR 'D') AND                        
               LINK-CYCLE-CHG-CD = 'F'                                  
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'CASA000029' TO S-BUS-RULE-ID                   
                   MOVE 'F' TO S-RULE-RESULT-CD                         
                   PERFORM 7010-RULE-XREF THRU 7010-EXIT                
                   IF WS-GTT01-DECLARED = 'N'                           
                       PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT        
                   END-IF                                               
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.             
           IF AT-CODE-ACCT-STAT NOT = 'A' AND                           
              AT-CODE-ACCT-STAT NOT = 'P' AND                           
              LINK-CYCLE-CHG-CD = 'F'                                   
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'CASA000030' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7010-RULE-XREF THRU 7010-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF LINK-CYCLE-CHG-CD = 'F'                                   
               PERFORM 7070-DNP THRU 7070-EXIT                          
               IF VO-PREMISE-NO > 0                                     
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'CASA000031' TO S-BUS-RULE-ID                   
                   MOVE 'F' TO S-RULE-RESULT-CD                         
                   PERFORM 7010-RULE-XREF THRU 7010-EXIT                
                   IF WS-GTT01-DECLARED = 'N'                           
                       PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT        
                   END-IF                                               
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
           IF LINK-CYCLE-CHG-CD = 'F' AND                               
              AT-BILL-CYCLE-CHG-CD NOT = 'F'                            
                  IF CL-ACCOUNT-NO > 0                                  
                      MOVE 0 TO S-RETURN-CODE                           
                      MOVE 'CASA000035' TO S-BUS-RULE-ID                
                      MOVE 'F' TO S-RULE-RESULT-CD                      
                      PERFORM 7010-RULE-XREF THRU 7010-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT THRU 8100-EXIT           
                  END-IF                                                
                  IF WS-CODE-DPP-ACCT = 'A'                             
                      MOVE 0 TO S-RETURN-CODE                           
                      MOVE 'CASA000036' TO S-BUS-RULE-ID                
                      MOVE 'F' TO S-RULE-RESULT-CD                      
                      PERFORM 7010-RULE-XREF THRU 7010-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT THRU 8100-EXIT
                  END-IF
           END-IF.          
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              MOVE 'NO DATA' TO S-BUS-RULE-ID                           
              ADD +1 TO CTR-ROWS                                        
              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-VALIDATE-CYCLE-CHANGE.                                      
                                                                        
           IF LINK-BILL-CYCLE > AT-BILL-CYCLE                           
               NEXT SENTENCE                                            
           ELSE                                                         
               IF AT-BILL-CYCLE > LINK-BILL-CYCLE                       
                   PERFORM 2110-VALIDATE-BILL-CYCLE THRU 2110-EXIT
               END-IF
           END-IF.     
                                                                        
      * IF USER CHOOSES TO CONTINUE, UI SHOULD MOVE 'C' TO CHANGE               
      * REASON                                                                  
                                                                        
           IF LINK-BILL-CYCLE = UT-READ-CYCLE AND                       
              AT-BILL-CYCLE-CHG-CD = 'F'                                
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'CASA000022' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7010-RULE-XREF THRU 7010-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-VALIDATE-BILL-CYCLE.                                        
                                                                        
           MOVE LINK-BILL-CYCLE TO BILL-CYCLE-1150.                     
           PERFORM 4000-CALL-CSR01150 THRU 4000-EXIT.                   
           IF AT-CODE-BILL-FREQ(3:1) NUMERIC                            
               MOVE AT-CODE-BILL-FREQ(3:1) TO WS-REV-MONTH-FROM         
           ELSE                                                         
               MOVE 1 TO WS-REV-MONTH-FROM
           END-IF.                             
           IF AT-CODE-BILL-FREQ(1:1) = 'M'                              
               IF AT-REV-MTH-LST-NRML = 0                               
                   MOVE REVENUE-MONTH-1150 TO WS-REV-MONTH-FROM         
               ELSE                                                     
                   MOVE AT-REV-MTH-LST-NRML TO WS-LAST-REV-MONTH        
                   MOVE WS-LAST-REV-MONTH(1:4) TO WS-YEAR               
                   MOVE WS-LAST-REV-MONTH(5:2) TO WS-MONTH              
                   IF WS-MONTH = '12'                                   
                       COMPUTE WS-YEAR = WS-YEAR + 1                    
                       MOVE WS-YEAR TO WS-LAST-REV-MONTH(1:4)           
                       MOVE 01 TO WS-LAST-REV-MONTH(5:2)                
                       MOVE WS-LAST-REV-MONTH TO WS-REV-MONTH-FROM      
                   ELSE                                                 
                       COMPUTE WS-MONTH = WS-MONTH + 1                  
                       MOVE WS-MONTH TO WS-LAST-REV-MONTH(5:2)          
                       MOVE WS-LAST-REV-MONTH TO WS-REV-MONTH-FROM      
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
               MOVE WS-CURRENT-TS(1:4) TO WS-YEAR                       
               MOVE WS-CURRENT-TS(6:2) TO WS-MONTH                      
               IF WS-REV-MONTH-FROM < WS-MONTH                          
                   COMPUTE WS-YEAR = WS-YEAR + 1                        
                   MOVE WS-YEAR TO WS-LAST-REV-MONTH(1:4)               
                   MOVE WS-REV-MONTH-FROM TO WS-MONTH                   
                   MOVE WS-MONTH TO WS-LAST-REV-MONTH(5:2)              
                   MOVE WS-LAST-REV-MONTH TO WS-REV-MONTH-FROM          
               ELSE                                                     
                   MOVE WS-YEAR TO WS-LAST-REV-MONTH(1:4)               
                   MOVE WS-REV-MONTH-FROM TO WS-MONTH                   
                   MOVE WS-MONTH TO WS-LAST-REV-MONTH(5:2)              
                   MOVE WS-LAST-REV-MONTH TO WS-REV-MONTH-FROM
               END-IF
           END-IF.         
                                                                        
           IF REVENUE-MONTH-1150 > WS-REV-MONTH-FROM                    
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'CASA000020' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               PERFORM 7010-RULE-XREF THRU 7010-EXIT                    
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
           IF UT-READ-CYCLE > ' ' AND                                   
              LINK-BILL-CYCLE < UT-READ-CYCLE                           
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'CASA000021' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7010-RULE-XREF THRU 7010-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * NOTE THAT LINK-BILL-CYCLE CAN CHANGE HERE                               
                                                                        
       2200-VALIDATE-REASON-CHANGE.                                     
                                                                        
           IF LINK-CYCLE-CHG-CD = 'C' AND                               
              AT-BILL-CYCLE-CHG-CD = 'F'                                
                  MOVE UT-READ-CYCLE TO LINK-BILL-CYCLE                 
                  PERFORM 2110-VALIDATE-BILL-CYCLE THRU 2110-EXIT
           END-IF.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-VALIDATE-CYCLE-CHANGE.                                      
                                                                        
           IF LINK-CYCLE-CHG-CD = 'C' AND                               
              AT-BILL-CYCLE-CHG-CD NOT = 'F'                            
                  IF LINK-BILL-CYCLE NOT = UT-READ-CYCLE                
                      MOVE 0 TO S-RETURN-CODE                           
                      MOVE 'CASA000023' TO S-BUS-RULE-ID                
                      MOVE 'F' TO S-RULE-RESULT-CD                      
                      PERFORM 7010-RULE-XREF THRU 7010-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT THRU 8100-EXIT           
                  END-IF                                                
           ELSE                                                         
               IF LINK-CYCLE-CHG-CD = AT-BILL-CYCLE-CHG-CD AND          
                  AT-BILL-CYCLE-CHG-CD NOT = 'F'                        
                      MOVE 0 TO S-RETURN-CODE                           
                      MOVE 'CASA000024' TO S-BUS-RULE-ID                
                      MOVE 'F' TO S-RULE-RESULT-CD                      
                      PERFORM 7010-RULE-XREF THRU 7010-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.          
                                                                        
           IF LINK-CYCLE-CHG-CD = 'F' AND                               
              WS-CODE-NSF-CHK-AMT = 'A'                                 
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'CASA000025' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7010-RULE-XREF THRU 7010-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
           IF BE-DRAFT-CYCLE > ' '                                      
              PERFORM 2310-CALCULATE-DRAFT-CYCLE THRU 2310-EXIT         
              IF WS-PENDING-DRAFT-FL = 'Y' AND                          
                (WS-NEW-DRAFT-CYCLE NOT = BE-DRAFT-CYCLE)               
                     MOVE 0 TO S-RETURN-CODE                            
                     MOVE 'CASA000026' TO S-BUS-RULE-ID                 
                     MOVE 'F' TO S-RULE-RESULT-CD                       
                     PERFORM 7010-RULE-XREF THRU 7010-EXIT              
                     IF WS-GTT01-DECLARED = 'N'                         
                         PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT      
                     END-IF                                             
                     PERFORM 8100-SEND-RESULT THRU 8100-EXIT            
             ELSE                                                       
                 IF WS-NEW-DRAFT-CYCLE NOT = BE-DRAFT-CYCLE             
                     MOVE 0 TO S-RETURN-CODE                            
                     MOVE 'CASA00027' TO S-BUS-RULE-ID                  
                     MOVE 'F' TO S-RULE-RESULT-CD                       
                     PERFORM 7010-RULE-XREF THRU 7010-EXIT              
                     IF WS-GTT01-DECLARED = 'N'                         
                         PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT      
                     END-IF                                             
                     PERFORM 8100-SEND-RESULT THRU 8100-EXIT
                 END-IF
              END-IF
           END-IF.           
                                                                        
           IF LINK-CYCLE-CHG-CD = 'F' AND                               
              AT-CODE-ACCT-BILLED = 'R'                                 
                 PERFORM 2340-CHECK-CYCLES THRU 2340-EXIT
           END-IF.              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-CALCULATE-DRAFT-CYCLE.                                      
                                                                        
           MOVE LINK-BILL-CYCLE TO WS-BILL-CYCLE-NUM.                   
           IF BE-REQSTED-DRAFT-DAY <= SPACES                            
               PERFORM 2320-CYCLE-PLUS-5 THRU 2320-EXIT                 
               MOVE WS-BILL-CYCLE-PLUS-5 TO WS-NEW-DRAFT-CYCLE          
           ELSE                                                         
               PERFORM 2320-CYCLE-PLUS-5 THRU 2320-EXIT                 
               PERFORM 2330-CYCLE-MINUS-2 THRU 2330-EXIT                
               IF ((BE-DRAFT-CYCLE >= WS-BILL-CYCLE-PLUS-5 AND          
                    BE-DRAFT-CYCLE <= WS-BILL-CYCLE-MINUS-2) AND        
                    WS-BILL-CYCLE-PLUS-5 < WS-BILL-CYCLE-MINUS-2) OR    
                  ((BE-DRAFT-CYCLE >= WS-BILL-CYCLE-PLUS-5 OR           
                    BE-DRAFT-CYCLE <= WS-BILL-CYCLE-MINUS-2) AND        
                    WS-BILL-CYCLE-PLUS-5 > WS-BILL-CYCLE-MINUS-2)       
                        MOVE BE-DRAFT-CYCLE TO WS-NEW-DRAFT-CYCLE       
               ELSE                                                     
                   IF WS-BILL-CYCLE-PLUS-5 > BE-DRAFT-CYCLE             
                       MOVE WS-BILL-CYCLE-PLUS-5 TO WS-NEW-DRAFT-CYCLE
                   END-IF
               END-IF
           END-IF. 
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-CYCLE-PLUS-5.                                               
                                                                        
           COMPUTE WS-BILL-CYCLE-PLUS-5 = WS-BILL-CYCLE-NUM + 5.        
           IF WS-BILL-CYCLE-PLUS-5 > 20                                 
               COMPUTE WS-BILL-CYCLE-PLUS-5 =                           
                       WS-BILL-CYCLE-PLUS-5 - 20
           END-IF.                       
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2330-CYCLE-MINUS-2.                                              
                                                                        
           IF WS-BILL-CYCLE-NUM > 2                                     
               COMPUTE WS-BILL-CYCLE-MINUS-2 = WS-BILL-CYCLE-NUM - 2    
           ELSE                                                         
               COMPUTE WS-BILL-CYCLE-MINUS-2 = WS-BILL-CYCLE-NUM + 18
           END-IF.  
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2340-CHECK-CYCLES.                                               
                                                                        
           IF LINK-BILL-CYCLE < BN-BILL-CYCLE AND                       
              UT-READ-CYCLE < AT-BILL-CYCLE                             
                  EVALUATE LINK-CYCLE-CHG-CD                            
                      WHEN 'F'                                          
                          MOVE 0 TO S-RETURN-CODE                       
                          MOVE 'CASA00020' TO S-BUS-RULE-ID             
                          MOVE 'F' TO S-RULE-RESULT-CD                  
                          PERFORM 7010-RULE-XREF THRU 7010-EXIT         
                          IF WS-GTT01-DECLARED = 'N'                    
                              PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT 
                          END-IF                                        
                          PERFORM 8100-SEND-RESULT THRU 8100-EXIT       
                      WHEN 'C'                                          
                          MOVE 0 TO S-RETURN-CODE                       
                          MOVE 'CASA00034' TO S-BUS-RULE-ID             
                          MOVE 'F' TO S-RULE-RESULT-CD                  
                          PERFORM 7010-RULE-XREF THRU 7010-EXIT         
                          IF WS-GTT01-DECLARED = 'N'                    
                              PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT 
                          END-IF                                        
                          PERFORM 8100-SEND-RESULT THRU 8100-EXIT       
                  END-EVALUATE
           END-IF.                                         
                                                                        
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-VALIDATE-REASON-CHANGE.                                     
                                                                        
           IF LINK-BILL-CYCLE = AT-BILL-CYCLE                           
               EVALUATE LINK-CYCLE-CHG-CD                               
                   WHEN 'C'                                             
                       MOVE 0 TO S-RETURN-CODE                          
                       MOVE 'CASA000023' TO S-BUS-RULE-ID               
                       MOVE 'F' TO S-RULE-RESULT-CD                     
                       PERFORM 7010-RULE-XREF THRU 7010-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
                   WHEN OTHER                                           
                       MOVE 0 TO S-RETURN-CODE                          
                       MOVE 'CASA000028' TO S-BUS-RULE-ID               
                       MOVE 'F' TO S-RULE-RESULT-CD                     
                       PERFORM 7010-RULE-XREF THRU 7010-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF LINK-CYCLE-CHG-CD = 'F' AND                               
             (AT-CODE-DISC-OK = ' ' OR                                  
              AT-CODE-LPC-XMT = ' ')                                    
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'CASA000037' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7010-RULE-XREF THRU 7010-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  RETURNS 1 IF READ WINDOW IS NOT OPEN                                   
      *         -1 IF READ WINDOW IS OPEN                                       
      *         -2 IF AN ERROR OCCURRED                                         
                                                                        
       4000-CALL-CSR01150.                                              
                                                                        
           MOVE WS-CURRENT-TS TO TIMESTAMP-1150.                        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01150                                             
      *           (:BILL-CYCLE-1150,                                    
      *            :TIMESTAMP-1150)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1150
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1150
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1150 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01150'            TO TABLE-1                     
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-1             
              MOVE BILL-CYCLE-1150       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1150)                                                
      *       WITH PROCEDURE CSR01150                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1150 CURSOR FOR RESULT SET        
      *       :LOC1150                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1150 INTO                            
                 :RETURN-CODE-1150,                                     
                 :BILL-DAY-1150,                                        
                 :REVENUE-MONTH-1150                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1150 NOT = 0 AND                      
                      RETURN-CODE-1150 NOT = 1 AND                      
                      RETURN-CODE-1150 NOT = -1                         
                          MOVE RETURN-CODE-1150 TO WS-ACTIVE-RETURN-CODE
                          MOVE PROGRAM-NAME   TO ABEND-PROGRAM          
                          MOVE '4000'         TO ACTIVE-PARAGRAPH       
                          MOVE 'FETCH'        TO ABEND-FUNCTION         
                          MOVE 'CSR01150'     TO TABLE-1                
                          MOVE 'BILL_CYCLE'   TO TABLE-ELEMENT-1        
                          MOVE BILL-CYCLE-1150 TO HOSTVAR-ELEMENT-1     
                          PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT     
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01150'            TO TABLE-1                
                   MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-1        
                   MOVE BILL-CYCLE-1150       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT BILL_CYCLE,                                        
                     BILL_CYCLE_CHG_CD,                                 
                     CODE_BILL_FREQ,                                    
                     REV_MTH_LST_NRML,                                  
                     CODES_DATA_PRESENT,                                
                     CODE_ACCT_STAT,                                    
                     CREDIT_GROUP,                                      
                     CODE_ACCT_BILLED,                                  
                     PREMISE_NO,                                        
                     CODE_LPC_XMT,                                      
                     CODE_DISC_OK                                       
                INTO :AT-BILL-CYCLE,                                    
                     :AT-BILL-CYCLE-CHG-CD,                             
                     :AT-CODE-BILL-FREQ,                                
                     :AT-REV-MTH-LST-NRML,                              
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CODE-ACCT-STAT,                                
                     :AT-CREDIT-GROUP,                                  
                     :AT-CODE-ACCT-BILLED,                              
                     :AT-PREMISE-NO,                                    
                     :AT-CODE-LPC-XMT,                                  
                     :AT-CODE-DISC-OK                                   
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_CYCLE,                                                
MFA-TR*              BILL_CYCLE_CHG_CD,                                         
MFA-TR*              CODE_BILL_FREQ,                                            
MFA-TR*              REV_MTH_LST_NRML,                                          
MFA-TR*              CODES_DATA_PRESENT,                                        
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              CODE_ACCT_BILLED,                                          
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CODE_LPC_XMT,                                              
MFA-TR*              CODE_DISC_OK                                               
MFA-TR*         INTO :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-BILL-CYCLE-CHG-CD,                                     
MFA-TR*              :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-CODE-ACCT-BILLED,                                      
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CODE-LPC-XMT,                                          
MFA-TR*              :AT-CODE-DISC-OK                                           
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7005'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_DELINQUENCY'   TO TABLE-1                  
                   MOVE 'DELINQ_CD'         TO TABLE-ELEMENT-1          
                   MOVE C8-DELINQ-CD        TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-READ-CYCLE.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) READ_CYCLE                                        
                 INTO :UT-READ-CYCLE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE IN ('E', 'G')                      
                  AND READ_CYCLE > ' '                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_CYCLE                                                
MFA-TR*          INTO :UT-READ-CYCLE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE IN ('E', 'G')                              
MFA-TR*           AND READ_CYCLE > ' '                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO UT-READ-CYCLE                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7015'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-BANK-EFT.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REQSTED_DRAFT_DAY,
              DRAFT_CYCLE,
              LAST_DRAFT_DATE                                    
                INTO :BE-REQSTED-DRAFT-DAY,                             
                     :BE-DRAFT-CYCLE,                                   
                     :BE-LAST-DRAFT-DATE :WS-NULL-1                      
                FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND STATUS_CODE NOT IN ('D', 'M', 'N', 'O')            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REQSTED_DRAFT_DAY,                                         
MFA-TR*              DRAFT_CYCLE,                                               
MFA-TR*              LAST_DRAFT_DATE                                            
MFA-TR*         INTO :BE-REQSTED-DRAFT-DAY,                                     
MFA-TR*              :BE-DRAFT-CYCLE,                                           
MFA-TR*              :BE-LAST-DRAFT-DATE:WS-NULL-1                              
MFA-TR*         FROM CSS_BANK_EFT                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND STATUS_CODE NOT IN ('D', 'M', 'N', 'O')                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO BE-LAST-DRAFT-DATE                
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-BANK-EFT                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BANK_EFT'      TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-PENDING-DRAFT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DRAFT_DATE                                         
                INTO :PB-DRAFT-DATE :WS-NULL-2                           
              FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
              ORDER BY DRAFT_DATE DESC                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DRAFT_DATE                                                 
MFA-TR*         INTO :PB-DRAFT-DATE:WS-NULL-2                                   
MFA-TR*       FROM CSS_PNDNG_BNK_DRFT                                           
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       ORDER BY DRAFT_DATE DESC                                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7025                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-PENDING-DRAFT-FL                      
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO PB-DRAFT-DATE                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-PENDING-DRAFT-FL                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7025'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CURRENT-REV-MONTH.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MIN(REVENUE_MONTH)                                 
                INTO :BN-REVENUE-MONTH :WS-NULL-3                        
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT   >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                 
                 AND BILL_CYCLE     = :AT-BILL-CYCLE                    
                 AND CODE_BILL_COND = 'C'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH:WS-NULL-3                                
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT   >= :WS-CURRENT-DATE                         
MFA-TR*          AND BILL_CYCLE     = :AT-BILL-CYCLE                            
MFA-TR*          AND CODE_BILL_COND = 'C'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE ZEROES TO BN-REVENUE-MONTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7030'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_BILL_WINDOW' TO TABLE-1                    
                   MOVE 'BILL_CYCLE'      TO TABLE-ELEMENT-1            
                   MOVE AT-BILL-CYCLE     TO HOSTVAR-ELEMENT-1          
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7035-CURRENT-BILL-CYCLE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MIN(BILL_CYCLE)                                    
                INTO :BN-BILL-CYCLE :WS-NULL-4                           
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT   >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                 
                 AND REVENUE_MONTH  = :BN-REVENUE-MONTH                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(BILL_CYCLE)                                            
MFA-TR*         INTO :BN-BILL-CYCLE:WS-NULL-4                                   
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT   >= :WS-CURRENT-DATE                         
MFA-TR*          AND REVENUE_MONTH  = :BN-REVENUE-MONTH                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7035                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO BN-BILL-CYCLE                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7035'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_BILL_WINDOW' TO TABLE-1                    
                   MOVE 'REVENUE_MONTH'   TO TABLE-ELEMENT-1            
                   MOVE BN-REVENUE-MONTH  TO HOSTVAR-ELEMENT-1          
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-CRED-COLL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :CL-ACCOUNT-NO                                     
                FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND CODE_NOTICE_TYPE = 'D'                             
                 AND DATE_CREDIT_ACTION >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :CL-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND CODE_NOTICE_TYPE = 'D'                                     
MFA-TR*          AND DATE_CREDIT_ACTION >= :WS-CURRENT-DATE                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  CL-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CRED_COLL'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-DNP.                                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                         
                INTO :VO-PREMISE-NO                                     
              FROM CSS_SO_DATA WITH(READUNCOMMITTED)                            
              WHERE PREMISE_NO = :AT-PREMISE-NO                         
                AND ORDER_TYPE_CD = 'DNP01'                             
                AND ORDER_STATE_CD = 'A'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*         INTO :VO-PREMISE-NO                                             
MFA-TR*       FROM CSS_SO_DATA                                                  
MFA-TR*       WHERE PREMISE_NO = :AT-PREMISE-NO                                 
MFA-TR*         AND ORDER_TYPE_CD = 'DNP01'                                     
MFA-TR*         AND ORDER_STATE_CD = 'A'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  VO-PREMISE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7070'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_DATA'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04795_R1                            
             (                                                          
              RETURN_CODE,                                              
              BUS_RULE_ID,                                              
              RULE_RESULT_CD,                                           
              BUS_RULE_XREF_ID                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-RULE-RESULT-CD,                                       
               :S-BUS-RULE-XREF-ID                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04795_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       RULE_RESULT_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-RULE-RESULT-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04795_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04795_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04795_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04795_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE                               
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
