       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04794.                                         
COB303 DATE-WRITTEN.  MAY 2014.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM RETRIEVES CASHIER DRAWER DETAILS AND CASH PC-ID  *00190000
      *  ENTRIES.                                                      *00200000
      *  BUSOP NAME: GETOPENCASHDRAWERDTLSBUSOPP                       *        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      ******************************************************************00300000
PRJ586* 05/21/2014  AP40911   NEW PROCEDURE FOR CIS MODERNIZATION.     *        
PRJ586* 07/09/2015  CB18344   ADDED SELECT FOR CATEGORY 8025.          *        
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04794'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE STARTS HERE'.                               
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CWS00027.                                               00620000
           COPY CWS00303.                                               00632000
           COPY CWS00133.                                               01850200
      *                                                                         
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************00650000
      *    WORK AREAS                                                  *00660000
      ******************************************************************00670000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04794'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-DATE-CASH-REPORT      PIC X(10).                      
           05  WS-DATE-LAST-ACTIVITY    PIC X(10).                      
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-COUNT-1               PIC S9(9) COMP VALUE 0.         
           05  WS-COUNT-2               PIC S9(9) COMP VALUE 0.         
           05  WS-PARM-USER-ID          PIC X(07).                      
           05  WS-PARM-CSR-PC-ID        PIC X(15).                      
           05  WS-RETURN-CODE-1         PIC S9(4)    COMP VALUE 0.      
           05  WS-RETURN-CODE-2         PIC S9(4)    COMP VALUE 0.      
           05  WS-APPL-RETURN-CODE      PIC S9(009)  COMP VALUE 0.      
           05  WS-CATEGORY-CD           PIC X(01) VALUE SPACES.         
                                                                        
           05 WS-RESULT-TYPE          PIC 9(01) VALUE ZERO.             
              88 WS-RESULT-1                    VALUE 1.                
              88 WS-RESULT-2                    VALUE 2.                
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-1              PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-2              PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS-1.                                         
           05  S-RETURN-CODE-1         PIC S9(09) COMP VALUE +0.        
           05  S-APPL-RETURN-CODE      PIC S9(009) COMP VALUE +0.       
           05  S-CASH-COMPANY-NO       PIC X(2) VALUE SPACES.           
           05  S-CASH-LOCAL-OFFICE-1   PIC X(3) VALUE SPACES.           
           05  S-CASH-REPORT-NO        PIC X(3) VALUE SPACES.           
           05  S-DATE-CASH-REPORT      PIC X(10) VALUE SPACES.          
           05  S-CASH-DRAWER-ID        PIC S9(4) USAGE COMP.            
           05  S-AMT-CASH-BEGIN-BAL    PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  S-DATE-LAST-ACTIVITY    PIC X(10) VALUE SPACES.          
           05  S-NO-ITEMS-ENTERED      PIC S9(9)   COMP VALUE +0.       
           05  S-CASHIER-FULL-NAME     PIC X(40) VALUE SPACES.          
           05  S-DRAWER-CREATED-TS     PIC X(026).                      
           05  S-BUSINESS-OFF-CASHIER  PIC X(01) VALUE SPACES.          
PRJ586     05  S-PAYMENTS-CATEGORY     PIC X(01) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS-2.                                         
           05  S-RETURN-CODE-2          PIC S9(9) COMP VALUE 0.         
           05  S-CASH-PC-ID             PIC X(15) VALUE SPACES.         
           05  S-CODE-PYMT-FACILITY     PIC X(01) VALUE SPACES.         
           05  S-CASH-LOCAL-OFFICE-2    PIC X(03) VALUE SPACES.         
           05  S-AMT-BASIC-WORK         PIC S9(13)V9(2) USAGE COMP-3    
                                                       VALUE +0.        
           05  S-CREDIT-CARD-FL         PIC X(01) VALUE 'N'.            
           05  S-CHECK21-FL             PIC X(01) VALUE 'N'.            
           05  S-PYMT-FACLTY-RBN-CD     PIC X(15) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           EXEC SQL                                                     01550000
              INCLUDE SQLCA                                             01560000
           END-EXEC.                                                    01570000
                                                                        
      *** DCLGEN FOR CSS_CASHIER - Y1                                           
           EXEC SQL                                                     01590000
              INCLUDE TBCSHIER                                          01600000
           END-EXEC.                                                    01610000
                                                                        
      *** DCLGEN FOR CSS_CASH_PC_ID - Y3                                        
           EXEC SQL                                                     01590000
              INCLUDE TBCSPCID                                          01600000
           END-EXEC.                                                    01610000
                                                                        
      *** DCLGEN FOR CSS_CSH_DRWR_CNTL - CS                                     
           EXEC SQL                                                     01630000
             INCLUDE TBCDCNTL                                           01640000
           END-EXEC.                                                    01650000
                                                                        
      *** DCLGEN FOR CSS_USER_PROFILE - PF                                      
           EXEC SQL                                                     01630000
             INCLUDE TBUSRPRF                                           01640000
           END-EXEC.                                                    01650000
                                                                        
      *** DCLGEN FOR CSS_CASHIER_OFFICE - Y2                                    
           EXEC SQL                                                             
             INCLUDE TBCSHOFF                                                   
           END-EXEC.                                                            
                                                                        
      *** DCLGEN FOR CSS_CATEGORY - F5                                          
           EXEC SQL                                                             
             INCLUDE TBCAT                                                      
           END-EXEC.                                                            
                                                                        
      ***********************************************************       01670000
      *** CSHDWRCNTL-CURSOR :FETCH ALL ROWS IN CSS_CSH_DRWR_CNTL*       01680000
      *** TABLE WITH THE PASSED USER_ID AND DRAWER STATUS       *       01690000
      ***********************************************************       01700000
           EXEC SQL                                                     
             DECLARE CSHDWRCNTL-CURSOR  CURSOR FOR                      
             SELECT CASH_COMPANY_NO,                                    
                    CASH_LOCAL_OFFICE,                                  
                    CASH_REPORT_NO,                                     
                    DATE_CASH_REPORT,                                   
                    CASH_DRAWER_ID,                                     
                    AMT_CASH_BEGIN_BAL,                                 
                    DATE_LAST_ACTIVITY,                                 
                    NO_ITEMS_ENTERED,                                   
                    CIS.CHAR2$DATE(DATE_CASH_REPORT,'USA'),                     
                    CIS.CHAR2$DATE(DATE_LAST_ACTIVITY,'USA'),                   
                    REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS                                     
             FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                       
             WHERE USER_ID       = :CS-USER-ID                          
             AND CODE_CSH_DRWR_STAT = 'A'                               
             ORDER BY DATE_CASH_REPORT DESC                             
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01710000
MFA-TR*      DECLARE CSHDWRCNTL-CURSOR  CURSOR FOR                      01720000
MFA-TR*      SELECT CASH_COMPANY_NO,                                    01740000
MFA-TR*             CASH_LOCAL_OFFICE,                                  01770000
MFA-TR*             CASH_REPORT_NO,                                     01740000
MFA-TR*             DATE_CASH_REPORT,                                   01740000
MFA-TR*             CASH_DRAWER_ID,                                     01780000
MFA-TR*             AMT_CASH_BEGIN_BAL,                                 01780000
MFA-TR*             DATE_LAST_ACTIVITY,                                 01780000
MFA-TR*             NO_ITEMS_ENTERED,                                   01780000
MFA-TR*             CHAR(DATE_CASH_REPORT,USA),                         01740000
MFA-TR*             CHAR(DATE_LAST_ACTIVITY,USA),                       01780000
MFA-TR*             CREATED_TS                                                  
MFA-TR*      FROM CSS_CSH_DRWR_CNTL                                     01800000
MFA-TR*      WHERE USER_ID       = :CS-USER-ID                          01810000
MFA-TR*      AND CODE_CSH_DRWR_STAT = 'A'                               01820000
MFA-TR*      ORDER BY DATE_CASH_REPORT DESC                             01830000
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    01840000
                                                                        
      *                                                                         
      ******************************************************************01670000
      *** CASHPCID-CURSOR :FETCH ALL ROWS IN CSS_CASH_PC_ID            *01680000
      *** TABLE WITH PARM-CSR-PC-ID                                    *01690000
      ******************************************************************01700000
           EXEC SQL                                                     
             DECLARE CASHPCID CURSOR FOR                                
              SELECT Y3.CASH_PC_ID,                                     
                     Y3.CODE_PYMT_FACILITY,                             
                     Y3.CASH_LOCAL_OFFICE,                              
                     Y2.CREDIT_CARD_FL,                                 
                     Y2.CHECK21_FL,                                     
                     Y2.PYMT_FACLTY_RBN_CD,                             
                     Y2.AMT_BASIC_WORK                                  
              FROM CSS_CASH_PC_ID Y3 WITH(READUNCOMMITTED)                      
                  ,CSS_CASHIER_OFFICE Y2 WITH(READUNCOMMITTED)                  
              WHERE Y3.CASH_PC_ID        = :WS-PARM-CSR-PC-ID           
                AND Y2.CASH_LOCAL_OFFICE = Y3.CASH_LOCAL_OFFICE         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*      DECLARE CASHPCID CURSOR FOR                                01720000
MFA-TR*       SELECT Y3.CASH_PC_ID,                                     04950000
MFA-TR*              Y3.CODE_PYMT_FACILITY,                                     
MFA-TR*              Y3.CASH_LOCAL_OFFICE,                                      
MFA-TR*              Y2.CREDIT_CARD_FL,                                         
MFA-TR*              Y2.CHECK21_FL,                                             
MFA-TR*              Y2.PYMT_FACLTY_RBN_CD,                                     
MFA-TR*              Y2.AMT_BASIC_WORK                                          
MFA-TR*       FROM CSS_CASH_PC_ID Y3                                    04950000
MFA-TR*           ,CSS_CASHIER_OFFICE Y2                                        
MFA-TR*       WHERE Y3.CASH_PC_ID        = :WS-PARM-CSR-PC-ID           04950000
MFA-TR*         AND Y2.CASH_LOCAL_OFFICE = Y3.CASH_LOCAL_OFFICE                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    04950000
HPCCDM*EJECT                                                            01860000
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-USER-ID             PIC  X(07).                         
       01  PARM-CSR-PC-ID           PIC  X(15).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                 PARM-USER-ID                                           
                 PARM-CSR-PC-ID.                                        
                                                                        
      ******************************************************************01890000
      * 0000-MAINLINE                                                  *01900000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01910000
      ******************************************************************01920000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02030000
      * 0100-INITIALIZE                                                *02040000
      *                                                                *02050000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02060000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02070000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02080000
      *                                                                *02090000
      ******************************************************************02100000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
               RETURN_CODE                                              
              ,APPL_RETURN_CODE                                         
              ,CASH_COMPANY_NO                                          
              ,CASH_LOCAL_OFFICE                                        
              ,CASH_REPORT_NO                                           
              ,LTRIM(RTRIM(DATE_CASH_REPORT)) AS DATE_CASH_REPORT              
              ,CASH_DRAWER_ID                                           
              ,AMT_CASH_BEGIN_BAL                                       
              ,DATE_LAST_ACTIVITY                                       
              ,NO_ITEMS_ENTERED                                         
              ,CASHIER_FULL_NAME                                        
              ,DRAWER_CREATED_TS                                        
              ,BUSINESS_OFF_CASHIER                                     
PRJ586        ,PAYMENTS_CATEGORY                                        
               FROM #CSR04794_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,APPL_RETURN_CODE                                                 
MFA-TR*       ,CASH_COMPANY_NO                                                  
MFA-TR*       ,CASH_LOCAL_OFFICE                                                
MFA-TR*       ,CASH_REPORT_NO                                                   
MFA-TR*       ,STRIP(DATE_CASH_REPORT) AS DATE_CASH_REPORT                      
MFA-TR*       ,CASH_DRAWER_ID                                                   
MFA-TR*       ,AMT_CASH_BEGIN_BAL                                               
MFA-TR*       ,DATE_LAST_ACTIVITY                                               
MFA-TR*       ,NO_ITEMS_ENTERED                                                 
MFA-TR*       ,CASHIER_FULL_NAME                                                
MFA-TR*       ,DRAWER_CREATED_TS                                                
MFA-TR*       ,BUSINESS_OFF_CASHIER                                             
MFA-TR*       ,PAYMENTS_CATEGORY                                                
MFA-TR*        FROM SESSION.CSR04794_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
      *                                                                         
           EXEC SQL                                                     
                DECLARE C2 CURSOR  FOR                       
                SELECT                                                  
                     RETURN_CODE                                        
                    ,CASH_PC_ID                                         
                    ,CODE_PYMT_FACILITY                                 
                    ,CASH_LOCAL_OFFICE                                  
                    ,CREDIT_CARD_FL                                     
                    ,CHECK21_FL                                         
                    ,PYMT_FACLTY_RBN_CD                                 
                    ,AMT_BASIC_WORK                                     
                FROM                                                    
                    #CSR04794_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C2 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CASH_PC_ID                                                 
MFA-TR*             ,CODE_PYMT_FACILITY                                         
MFA-TR*             ,CASH_LOCAL_OFFICE                                          
MFA-TR*             ,CREDIT_CARD_FL                                             
MFA-TR*             ,CHECK21_FL                                                 
MFA-TR*             ,PYMT_FACLTY_RBN_CD                                         
MFA-TR*             ,AMT_BASIC_WORK                                             
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04794_R2                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04794_R1'            
                                          TO S-SQL-STATEMENT-V.         
           SET WS-RESULT-1                TO TRUE                       
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04794_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04794_R1
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,CASH_COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CASH_LOCAL_OFFICE CHAR(3)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
              ,CASH_REPORT_NO CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,DATE_CASH_REPORT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CASH_DRAWER_ID           SMALLINT                        
              ,AMT_CASH_BEGIN_BAL       DECIMAL(13,2)                   
              ,DATE_LAST_ACTIVITY CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,NO_ITEMS_ENTERED         INT                         
              ,CASHIER_FULL_NAME CHAR(40)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,DRAWER_CREATED_TS CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,BUSINESS_OFF_CASHIER CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
PRJ586        ,PAYMENTS_CATEGORY CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04794_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04794_R2'            
                                          TO S-SQL-STATEMENT-V.         
           SET WS-RESULT-2                TO TRUE                       
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04794_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04794_R2
              (                                                       
                     RETURN_CODE            INT                     
                    ,CASH_PC_ID CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CODE_PYMT_FACILITY CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CASH_LOCAL_OFFICE CHAR(3)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CREDIT_CARD_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CHECK21_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,PYMT_FACLTY_RBN_CD CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,AMT_BASIC_WORK         DECIMAL(13,2)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE            TO WS-SQLSTATE.                     
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                     NEXT SENTENCE                                      
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04794_R2'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
      ******************************************************************02710000
      * 2000-PROCESS-OUTPUT.                                           *02720000
      *                                                                *02730000
      *     1. DESCRIBE RESULT SET                                     *02740000
      *     2. UPDATE DB2 DATA                                         *02750000
      *     3. BUILD RESULT SET                                        *02760000
      *     4. SEND RESULT SET                                         *02770000
      *                                                                *02780000
      ******************************************************************02790000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           SET WS-RESULT-1                      TO TRUE                 
           PERFORM 2200-PROCESS          THRU 2200-EXIT.                
           SET WS-RESULT-2                      TO TRUE                 
           PERFORM 2400-PROCESS           THRU 2400-EXIT.               
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 04600000
      *  2200-PROCESS-CSH_DRWR_CNTL                                     04610000
      *                                                               * 04620000
      *    RETRIEVE THE CSH_DRWR_CNTL ROW USING PARMS PASSED          * 04630000
      *                                                               * 04640000
      ***************************************************************** 04650000
       2200-PROCESS.                                                    
                                                                        
           MOVE PARM-USER-ID             TO CS-USER-ID                  
                                            Y1-USER-ID                  
                                            PF-USER-ID                  
                                            F5-USER-ID.                 
                                                                        
           PERFORM 7000-SELECT-CASHIER     THRU 7000-EXIT.              
           PERFORM 7100-SELECT-CATEGORY-ID THRU 7100-EXIT.              
           MOVE WS-CATEGORY-CD             TO S-BUSINESS-OFF-CASHIER.   
PRJ586     PERFORM 7150-SELECT-CATEGORY-8025 THRU 7150-EXIT.            
PRJ586     MOVE WS-CATEGORY-CD             TO S-PAYMENTS-CATEGORY.      
           PERFORM 7200-OPEN-CSHDWRCNTL-CURSOR  THRU 7200-EXIT.         
           PERFORM 2300-FETCH                   THRU 2300-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
                                                                        
           IF CTR-ROWS-1 = 0                                            
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1             
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT
           END-IF.                
                                                                        
           PERFORM 7220-CLOSE-CSHDWRCNTL-CURSOR THRU 7220-EXIT.         
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-FETCH.                                                      
      * FETCH CASHDRAWER IF AVAILABLE                                   04820000
           PERFORM 7210-FETCH-CSHDWRCNTL-CURSOR THRU 7210-EXIT.         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-1.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CS-CASH-COMPANY-NO     TO S-CASH-COMPANY-NO          
              MOVE CS-CASH-LOCAL-OFFICE   TO S-CASH-LOCAL-OFFICE-1      
              MOVE CS-CASH-REPORT-NO      TO S-CASH-REPORT-NO           
              MOVE WS-DATE-CASH-REPORT    TO S-DATE-CASH-REPORT         
              MOVE CS-CASH-DRAWER-ID      TO S-CASH-DRAWER-ID           
              MOVE CS-AMT-CASH-BEGIN-BAL  TO S-AMT-CASH-BEGIN-BAL       
              MOVE WS-DATE-LAST-ACTIVITY  TO S-DATE-LAST-ACTIVITY       
              MOVE CS-NO-ITEMS-ENTERED    TO S-NO-ITEMS-ENTERED         
              MOVE CS-CREATED-TS          TO S-DRAWER-CREATED-TS        
              PERFORM 8010-INSERT-GTT-R1  THRU 8010-EXIT                
           END-IF.                                                      
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04600000
      *  2400-PROCESS-CSS-CASH-PC-ID                                   *04610000
      *                                                                *04620000
      *    RETRIEVE  CSS_CASH_PC_ID ROWS USING PARMS PASSED            *04630000
      *                                                                *04640000
      ***************************************************************** 04650000
       2400-PROCESS.                                                    
           MOVE PARM-CSR-PC-ID    TO  WS-PARM-CSR-PC-ID.                
           PERFORM 7300-OPEN-CASH-PC-ID-CURSOR THRU 7300-EXIT.          
           PERFORM 2500-FETCH                   THRU 2500-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
                                                                        
           IF CTR-ROWS-2 = 0                                            
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-2             
              PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT
           END-IF.                
                                                                        
           PERFORM 7320-CLOSE-CASH-PC-ID-CURSOR THRU 7320-EXIT.         
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-FETCH.                                                      
      * FETCH CASH-PC-ID                                                04820000
           PERFORM 7310-FETCH-CASH-PC-ID-CURSOR THRU 7310-EXIT.         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-2.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE Y3-CASH-PC-ID          TO S-CASH-PC-ID               
              MOVE Y3-CODE-PYMT-FACILITY  TO S-CODE-PYMT-FACILITY       
              MOVE Y3-CASH-LOCAL-OFFICE   TO S-CASH-LOCAL-OFFICE-2      
              MOVE Y2-CREDIT-CARD-FL      TO S-CREDIT-CARD-FL           
              MOVE Y2-CHECK21-FL          TO S-CHECK21-FL               
              MOVE Y2-PYMT-FACLTY-RBN-CD  TO S-PYMT-FACLTY-RBN-CD       
              Move Y2-AMT-BASIC-WORK      TO S-AMT-BASIC-WORK           
              PERFORM 8020-INSERT-GTT-R2  THRU 8020-EXIT                
           END-IF.                                                      
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-CASHIER.                                           *        
      ******************************************************************        
       7000-SELECT-CASHIER.                                             
           EXEC SQL                                                     
              SELECT Y1.CASH_COMPANY_NO,                                
                     Y1.CASH_LOCAL_OFFICE,                              
                     RTRIM(PF.LAST_NAME) + ', ' + RTRIM(PF.FIRST_NAME
           ) + ' ' + RTRIM(PF.MIDDLE_NAME)                              
              INTO   :Y1-CASH-COMPANY-NO,                               
                     :Y1-CASH-LOCAL-OFFICE,                             
                     :S-CASHIER-FULL-NAME                               
              FROM CSS_CASHIER Y1 WITH(READUNCOMMITTED),                        
                   CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                    
              WHERE Y1.USER_ID = :Y1-USER-ID                            
                AND Y1.USER_ID = PF.USER_ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT Y1.CASH_COMPANY_NO,                                04950000
MFA-TR*              Y1.CASH_LOCAL_OFFICE,                              04950000
MFA-TR*              RTRIM(PF.LAST_NAME) || ', ' ||                             
MFA-TR*              RTRIM(PF.FIRST_NAME) || ' ' ||                             
MFA-TR*              RTRIM(PF.MIDDLE_NAME)                                      
MFA-TR*       INTO   :Y1-CASH-COMPANY-NO,                               04950000
MFA-TR*              :Y1-CASH-LOCAL-OFFICE,                             04950000
MFA-TR*              :S-CASHIER-FULL-NAME                                       
MFA-TR*       FROM CSS_CASHIER Y1,                                      04950000
MFA-TR*            CSS_USER_PROFILE PF                                          
MFA-TR*       WHERE Y1.USER_ID = :Y1-USER-ID                            04950000
MFA-TR*         AND Y1.USER_ID = PF.USER_ID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    04950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE Y1-CASH-COMPANY-NO   TO S-CASH-COMPANY-NO            
              MOVE Y1-CASH-LOCAL-OFFICE TO S-CASH-LOCAL-OFFICE-1        
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              MOVE '01'               TO S-CASH-COMPANY-NO              
              MOVE SPACES             TO S-CASH-LOCAL-OFFICE-1          
              Move +1000              TO WS-APPL-RETURN-CODE            
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CASHIER'       TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE Y1-USER-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT
                END-IF
           END-IF.          
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-CATEGORY-ID.                                       *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-CATEGORY-ID.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CATEGORY-CD                                    
                FROM CSS_CATEGORY F5 WITH(READUNCOMMITTED)                      
               WHERE F5.USER_ID      = :F5-USER-ID                      
                 AND F5.CATEGORY_ID  = 247                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CATEGORY-CD                                            
MFA-TR*         FROM CSS_CATEGORY F5                                            
MFA-TR*        WHERE F5.USER_ID      = :F5-USER-ID                              
MFA-TR*          AND F5.CATEGORY_ID  = 247                                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
                CONTINUE                                                
           WHEN NOT-FOUND                                               
                MOVE 'N'                TO WS-CATEGORY-CD               
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CATEGORY'       TO TABLE-1                      
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE  F5-USER-ID          TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-EVALUATE.                                                
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PRJ586******************************************************************        
PRJ586* 7150-SELECT-CATEGORY-8025                                      *        
PRJ586******************************************************************        
PRJ586*                                                                         
PRJ586 7150-SELECT-CATEGORY-8025.                                       
PRJ586*                                                                         
PRJ586     EXEC SQL                                                     
PRJ586        SELECT 'Y'                                                
PRJ586          INTO :WS-CATEGORY-CD                                    
PRJ586          FROM CSS_CATEGORY F5 WITH(READUNCOMMITTED)                      
PRJ586         WHERE F5.USER_ID      = :F5-USER-ID                      
PRJ586           AND F5.CATEGORY_ID  = 8025                             
PRJ586                                                           
PRJ586                                                      
PRJ586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CATEGORY-CD                                            
MFA-TR*         FROM CSS_CATEGORY F5                                            
MFA-TR*        WHERE F5.USER_ID      = :F5-USER-ID                              
MFA-TR*          AND F5.CATEGORY_ID  = 8025                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ586*                                                                         
PRJ586     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
PRJ586     EVALUATE WS-ACTIVE-RETURN-CODE                               
PRJ586     WHEN SUCCESSFUL-CALL                                         
PRJ586          CONTINUE                                                
PRJ586     WHEN NOT-FOUND                                               
PRJ586          MOVE 'N'                TO WS-CATEGORY-CD               
PRJ586     WHEN OTHER                                                   
PRJ586        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PRJ586        MOVE '7150'               TO ACTIVE-PARAGRAPH             
PRJ586        MOVE 'SELECT'             TO ABEND-FUNCTION               
PRJ586        MOVE 'CSS_CATEGORY'       TO TABLE-1                      
PRJ586        MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
PRJ586        MOVE  F5-USER-ID          TO HOSTVAR-ELEMENT-1            
PRJ586        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
PRJ586     END-EVALUATE.                                                
PRJ586 7150-EXIT.                                                       
PRJ586     EXIT.                                                        
PRJ586*                                                                         
       7200-OPEN-CSHDWRCNTL-CURSOR.                                     
           EXEC SQL                                                     
                OPEN CSHDWRCNTL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_CSH_DRWR_CNTL'     TO TABLE-1                   
              MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE CS-USER-ID              TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
       7210-FETCH-CSHDWRCNTL-CURSOR.                                    
           EXEC SQL                                                     
                FETCH CSHDWRCNTL-CURSOR                                 
           INTO :CS-CASH-COMPANY-NO,                                    
                :CS-CASH-LOCAL-OFFICE,                                  
                :CS-CASH-REPORT-NO,                                     
                :CS-DATE-CASH-REPORT,                                   
                :CS-CASH-DRAWER-ID,                                     
                :CS-AMT-CASH-BEGIN-BAL,                                 
                :CS-DATE-LAST-ACTIVITY,                                 
                :CS-NO-ITEMS-ENTERED,                                   
                :WS-DATE-CASH-REPORT,                                   
                :WS-DATE-LAST-ACTIVITY,                                 
                :CS-CREATED-TS :WS-NULL-IND1                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF WS-NULL-IND1 < ZERO                                   
                   MOVE LOW-VALUES TO CS-CREATED-TS                     
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CSH_DRWR_CNTL'     TO TABLE-1                   
              MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE CS-USER-ID              TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-CSHDWRCNTL-CURSOR.                                    
           EXEC SQL                                                     
                CLOSE CSHDWRCNTL-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7220'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CSH_DRWR_CNTL'     TO TABLE-1                   
              MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE CS-USER-ID              TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-OPEN-CASH-PC-ID-CURSOR.                                     
           EXEC SQL                                                     
                OPEN CASHPCID                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7300'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_CASH_PC_ID'        TO TABLE-1                   
              MOVE 'PC_ID'                 TO TABLE-ELEMENT-1           
              MOVE WS-PARM-CSR-PC-ID       TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
       7310-FETCH-CASH-PC-ID-CURSOR.                                    
           EXEC SQL                                                     
                FETCH CASHPCID                                          
           INTO :Y3-CASH-PC-ID,                                         
                :Y3-CODE-PYMT-FACILITY,                                 
                :Y3-CASH-LOCAL-OFFICE,                                  
                :Y2-CREDIT-CARD-FL,                                     
                :Y2-CHECK21-FL,                                         
                :Y2-PYMT-FACLTY-RBN-CD,                                 
                :Y2-AMT-BASIC-WORK                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7310'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CASH_PC_ID'    TO TABLE-1                       
              MOVE 'PC_ID'             TO TABLE-ELEMENT-1               
              MOVE WS-PARM-CSR-PC-ID   TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-CLOSE-CASH-PC-ID-CURSOR.                                    
           EXEC SQL                                                     
                CLOSE CASHPCID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7320'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CASH_PC_ID'    TO TABLE-1                       
              MOVE 'PC_ID'             TO TABLE-ELEMENT-1               
              MOVE WS-PARM-CSR-PC-ID   TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00000500
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04794_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04794_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04794_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00003400
      ******************************************************************02530000
      *8000B-DELETE-GTT-ROWS                                           *02540000
      ******************************************************************02610000
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04794_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04794_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000B'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04794_R2'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      * 8010-INSERT-GTT-R1                                             *02540000
      ******************************************************************02610000
       8010-INSERT-GTT-R1.                                              
                                                                        
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04794_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,CASH_COMPANY_NO                                           
             ,CASH_LOCAL_OFFICE                                         
             ,CASH_REPORT_NO                                            
             ,DATE_CASH_REPORT                                          
             ,CASH_DRAWER_ID                                            
             ,AMT_CASH_BEGIN_BAL                                        
             ,DATE_LAST_ACTIVITY                                        
             ,NO_ITEMS_ENTERED                                          
             ,CASHIER_FULL_NAME                                         
             ,DRAWER_CREATED_TS                                         
             ,BUSINESS_OFF_CASHIER                                      
PRJ586       ,PAYMENTS_CATEGORY                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-APPL-RETURN-CODE                                       
             ,:S-CASH-COMPANY-NO                                        
             ,:S-CASH-LOCAL-OFFICE-1                                    
             ,:S-CASH-REPORT-NO                                         
             ,LTRIM(RTRIM(:S-DATE-CASH-REPORT))                                
             ,:S-CASH-DRAWER-ID                                         
             ,:S-AMT-CASH-BEGIN-BAL                                     
             ,:S-DATE-LAST-ACTIVITY                                     
             ,:S-NO-ITEMS-ENTERED                                       
             ,:S-CASHIER-FULL-NAME                                      
             ,:S-DRAWER-CREATED-TS                                      
             ,:S-BUSINESS-OFF-CASHIER                                   
PRJ586       ,:S-PAYMENTS-CATEGORY                                      
                                                                        
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04794_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,CASH_COMPANY_NO                                                   
MFA-TR*      ,CASH_LOCAL_OFFICE                                                 
MFA-TR*      ,CASH_REPORT_NO                                                    
MFA-TR*      ,DATE_CASH_REPORT                                                  
MFA-TR*      ,CASH_DRAWER_ID                                                    
MFA-TR*      ,AMT_CASH_BEGIN_BAL                                                
MFA-TR*      ,DATE_LAST_ACTIVITY                                                
MFA-TR*      ,NO_ITEMS_ENTERED                                                  
MFA-TR*      ,CASHIER_FULL_NAME                                                 
MFA-TR*      ,DRAWER_CREATED_TS                                                 
MFA-TR*      ,BUSINESS_OFF_CASHIER                                              
MFA-TR*      ,PAYMENTS_CATEGORY                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-1                                                  
MFA-TR*      ,:S-APPL-RETURN-CODE                                               
MFA-TR*      ,:S-CASH-COMPANY-NO                                                
MFA-TR*      ,:S-CASH-LOCAL-OFFICE-1                                            
MFA-TR*      ,:S-CASH-REPORT-NO                                                 
MFA-TR*      ,STRIP(:S-DATE-CASH-REPORT)                                        
MFA-TR*      ,:S-CASH-DRAWER-ID                                                 
MFA-TR*      ,:S-AMT-CASH-BEGIN-BAL                                             
MFA-TR*      ,:S-DATE-LAST-ACTIVITY                                             
MFA-TR*      ,:S-NO-ITEMS-ENTERED                                               
MFA-TR*      ,:S-CASHIER-FULL-NAME                                              
MFA-TR*      ,:S-DRAWER-CREATED-TS                                              
MFA-TR*      ,:S-BUSINESS-OFF-CASHIER                                           
MFA-TR*      ,:S-PAYMENTS-CATEGORY                                              
MFA-TR*                                                                         
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO CTR-ROWS-1                   
                                           WS-COUNT-1                   
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04794_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************02530000
      * 8020-INSERT-GTT-R2                                             *02540000
      ******************************************************************02610000
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04794_R2                         
                (                                                       
                     RETURN_CODE                                        
                    ,CASH_PC_ID                                         
                    ,CODE_PYMT_FACILITY                                 
                    ,CASH_LOCAL_OFFICE                                  
                    ,CREDIT_CARD_FL                                     
                    ,CHECK21_FL                                         
                    ,PYMT_FACLTY_RBN_CD                                 
                    ,AMT_BASIC_WORK                                     
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE-2                                   
                    ,:S-CASH-PC-ID                                      
                    ,:S-CODE-PYMT-FACILITY                              
                    ,:S-CASH-LOCAL-OFFICE-2                             
                    ,:S-CREDIT-CARD-FL                                  
                    ,:S-CHECK21-FL                                      
                    ,:S-PYMT-FACLTY-RBN-CD                              
                    ,:S-AMT-BASIC-WORK                                  
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04794_R2                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CASH_PC_ID                                                 
MFA-TR*             ,CODE_PYMT_FACILITY                                         
MFA-TR*             ,CASH_LOCAL_OFFICE                                          
MFA-TR*             ,CREDIT_CARD_FL                                             
MFA-TR*             ,CHECK21_FL                                                 
MFA-TR*             ,PYMT_FACLTY_RBN_CD                                         
MFA-TR*             ,AMT_BASIC_WORK                                             
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE-2                                           
MFA-TR*             ,:S-CASH-PC-ID                                              
MFA-TR*             ,:S-CODE-PYMT-FACILITY                                      
MFA-TR*             ,:S-CASH-LOCAL-OFFICE-2                                     
MFA-TR*             ,:S-CREDIT-CARD-FL                                          
MFA-TR*             ,:S-CHECK21-FL                                              
MFA-TR*             ,:S-PYMT-FACLTY-RBN-CD                                      
MFA-TR*             ,:S-AMT-BASIC-WORK                                          
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO CTR-ROWS-2                   
                                           WS-COUNT-2                   
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04794_R2'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF WS-COUNT-1     = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-COUNT-2  = 0                                           
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                      TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04755_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 00300000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 00300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04755_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-RESULT-1                                         
                    MOVE S-RETURN-CODE-1 TO WS-RETURN-CODE-1            
               WHEN  WS-RESULT-2                                        
                    MOVE S-RETURN-CODE-2 TO WS-RETURN-CODE-2            
           END-EVALUATE.                                                
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2.                              
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           MOVE WS-RETURN-CODE-1         TO S-RETURN-CODE-1.            
           MOVE WS-RETURN-CODE-2         TO S-RETURN-CODE-2.            
           Move WS-APPL-RETURN-CODE      TO S-APPL-RETURN-CODE.         
      *                                                                 00339704
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                 00380000
           IF CTR-ROWS-1 < 1                                            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT
           END-IF.                
      *                                                                 00391000
           
MSQ016        GOBACK.                                                    
      *                                                                 00391000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
